// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MAP_MS_DataTypes.hh"

namespace MAP__MS__DataTypes {

/* Member functions of C++ classes */

ODB__Info::ODB__Info()
{
}

ODB__Info::ODB__Info(const ODB__Data& par_odb__Data,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_odb__Data(par_odb__Data),
  field_notificationToCSE(par_notificationToCSE),
  field_extensionContainer(par_extensionContainer)
{
}

ODB__Info::ODB__Info(const ODB__Info& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ODB-Info.");
if (other_value.odb__Data().is_bound()) field_odb__Data = other_value.odb__Data();
else field_odb__Data.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void ODB__Info::clean_up()
{
field_odb__Data.clean_up();
field_notificationToCSE.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* ODB__Info::get_descriptor() const { return &ODB__Info_descr_; }
ODB__Info& ODB__Info::operator=(const ODB__Info& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ODB-Info.");
  if (other_value.odb__Data().is_bound()) field_odb__Data = other_value.odb__Data();
  else field_odb__Data.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean ODB__Info::operator==(const ODB__Info& other_value) const
{
return field_odb__Data==other_value.field_odb__Data
  && field_notificationToCSE==other_value.field_notificationToCSE
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean ODB__Info::is_bound() const
{
return (field_odb__Data.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean ODB__Info::is_value() const
{
return field_odb__Data.is_value()
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int ODB__Info::size_of() const
{
  int ret_val = 1;
  if (field_notificationToCSE.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void ODB__Info::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ odb_Data := ");
field_odb__Data.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void ODB__Info::set_implicit_omit()
{
if (odb__Data().is_bound()) odb__Data().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void ODB__Info::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ODB-Info has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) odb__Data().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "odb_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          odb__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ODB-Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ODB-Info");
  }
}

void ODB__Info::encode_text(Text_Buf& text_buf) const
{
field_odb__Data.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void ODB__Info::decode_text(Text_Buf& text_buf)
{
field_odb__Data.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void ODB__Info::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ODB__Info::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ODB__Info::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("odb_Data': ");
  new_tlv->add_TLV(field_odb__Data.BER_encode_TLV(ODB__Info_odb__Data_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(ASN_NULL_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(ODB__Info_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ODB__Info::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ODB-Info' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("odb_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_odb__Data.BER_decode_TLV(ODB__Info_odb__Data_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(ASN_NULL_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(ODB__Info_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ODB__Info::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ODB-Info.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "odb_Data");
    enc_len += field_odb__Data.JSON_encode(ODB__Info_odb__Data_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(ASN_NULL_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(ODB__Info_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ODB__Info::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ODB__Info*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean odb__Data_found = FALSE;
  boolean notificationToCSE_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (8 == name_len && 0 == strncmp(fld_name, "odb_Data", name_len)) {
        odb__Data_found = TRUE;
         int ret_val = field_odb__Data.JSON_decode(ODB__Info_odb__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "odb_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(ASN_NULL_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(ODB__Info_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!odb__Data_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "odb_Data");
    return JSON_ERROR_FATAL;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ODB__Info::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_notificationToCSE.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_odb__Data.OER_encode(ODB__Info_odb__Data_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(ASN_NULL_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(ODB__Info_extensionContainer_descr_, p_buf);
  return 0;
}

int ODB__Info::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_odb__Data.OER_decode(ODB__Info_odb__Data_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_notificationToCSE.OER_decode(ASN_NULL_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(ODB__Info_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void ODB__Info::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_odb__Data.PER_encode(ODB__Info_odb__Data_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(ASN_NULL_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(ODB__Info_extensionContainer_descr_, p_buf, p_options);
}

void ODB__Info::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_odb__Data.PER_decode(ODB__Info_odb__Data_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(ASN_NULL_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(ODB__Info_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ODB__Info_template::single_value_struct {
ODB__Data_template field_odb__Data;
ASN_NULL_template field_notificationToCSE;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void ODB__Info_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_odb__Data = ANY_VALUE;
single_value->field_notificationToCSE = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void ODB__Info_template::copy_value(const ODB__Info& other_value)
{
single_value = new single_value_struct;
if (other_value.odb__Data().is_bound()) {
  single_value->field_odb__Data = other_value.odb__Data();
} else {
  single_value->field_odb__Data.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ODB__Info_template::copy_template(const ODB__Info_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.odb__Data().get_selection()) {
single_value->field_odb__Data = other_value.odb__Data();
} else {
single_value->field_odb__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ODB__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ODB__Info_template(*other_value.implication_.precondition);
implication_.implied_template = new ODB__Info_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ODB-Info.");
break;
}
set_selection(other_value);
}

ODB__Info_template::ODB__Info_template()
{
}

ODB__Info_template::ODB__Info_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ODB__Info_template::ODB__Info_template(const ODB__Info& other_value)
{
copy_value(other_value);
}

ODB__Info_template::ODB__Info_template(const OPTIONAL<ODB__Info>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ODB__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ODB-Info from an unbound optional field.");
}
}

ODB__Info_template::ODB__Info_template(ODB__Info_template* p_precondition, ODB__Info_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ODB__Info_template::ODB__Info_template(Dynamic_Match_Interface<ODB__Info>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ODB__Info>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ODB__Info_template::ODB__Info_template(const ODB__Info_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ODB__Info_template::~ODB__Info_template()
{
clean_up();
}

ODB__Info_template& ODB__Info_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ODB__Info_template& ODB__Info_template::operator=(const ODB__Info& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ODB__Info_template& ODB__Info_template::operator=(const OPTIONAL<ODB__Info>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ODB__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ODB-Info.");
}
return *this;
}

ODB__Info_template& ODB__Info_template::operator=(const ODB__Info_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ODB__Info_template::match(const ODB__Info& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.odb__Data().is_bound()) return FALSE;
if(!single_value->field_odb__Data.match(other_value.odb__Data(), legacy))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ODB-Info.");
}
return FALSE;
}

boolean ODB__Info_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_odb__Data.is_bound()
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean ODB__Info_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_odb__Data.is_value()
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void ODB__Info_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ODB__Info ODB__Info_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ODB-Info.");
ODB__Info ret_val;
if (single_value->field_odb__Data.is_bound()) {
ret_val.odb__Data() = single_value->field_odb__Data.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void ODB__Info_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ODB-Info.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ODB__Info_template[list_length];
}

ODB__Info_template& ODB__Info_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ODB-Info.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ODB-Info.");
return value_list.list_value[list_index];
}

ODB__Data_template& ODB__Info_template::odb__Data()
{
set_specific();
return single_value->field_odb__Data;
}

const ODB__Data_template& ODB__Info_template::odb__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field odb_Data of a non-specific template of type @MAP-MS-DataTypes.ODB-Info.");
return single_value->field_odb__Data;
}

ASN_NULL_template& ODB__Info_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& ODB__Info_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.ODB-Info.");
return single_value->field_notificationToCSE;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& ODB__Info_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& ODB__Info_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.ODB-Info.");
return single_value->field_extensionContainer;
}

int ODB__Info_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ODB-Info containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ODB-Info.");
  }
  return 0;
}

void ODB__Info_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ odb_Data := ");
single_value->field_odb__Data.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ODB__Info_template::log_match(const ODB__Info& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_odb__Data.match(match_value.odb__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".odb_Data");
single_value->field_odb__Data.log_match(match_value.odb__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ odb_Data := ");
single_value->field_odb__Data.log_match(match_value.odb__Data(), legacy);
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ODB__Info_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (odb__Data().is_bound()) odb__Data().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void ODB__Info_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_odb__Data.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ODB-Info.");
}
}

void ODB__Info_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_odb__Data.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ODB__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ODB-Info.");
}
}

void ODB__Info_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ODB__Info_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ODB-Info has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) odb__Data().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "odb_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          odb__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ODB-Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ODB__Info_template* precondition = new ODB__Info_template;
    precondition->set_param(*param.get_elem(0));
    ODB__Info_template* implied_template = new ODB__Info_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ODB__Info_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ODB-Info");
  }
  is_ifpresent = param.get_ifpresent();
}

void ODB__Info_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_odb__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ODB-Info");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ODB-Info");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ODB-Info");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ODB-Info");
}

boolean ODB__Info_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ODB__Info_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CAMEL__SubscriptionInfo::CAMEL__SubscriptionInfo()
{
}

CAMEL__SubscriptionInfo::CAMEL__SubscriptionInfo(const OPTIONAL< O__CSI >& par_o__CSI,
    const OPTIONAL< O__BcsmCamelTDPCriteriaList >& par_o__BcsmCamelTDP__CriteriaList,
    const OPTIONAL< D__CSI >& par_d__CSI,
    const OPTIONAL< T__CSI >& par_t__CSI,
    const OPTIONAL< T__BCSM__CAMEL__TDP__CriteriaList >& par_t__BCSM__CAMEL__TDP__CriteriaList,
    const OPTIONAL< T__CSI >& par_vt__CSI,
    const OPTIONAL< T__BCSM__CAMEL__TDP__CriteriaList >& par_vt__BCSM__CAMEL__TDP__CriteriaList,
    const OPTIONAL< ASN_NULL >& par_tif__CSI,
    const OPTIONAL< ASN_NULL >& par_tif__CSI__NotificationToCSE,
    const OPTIONAL< GPRS__CSI >& par_gprs__CSI,
    const OPTIONAL< SMS__CSI >& par_mo__sms__CSI,
    const OPTIONAL< SS__CSI >& par_ss__CSI,
    const OPTIONAL< M__CSI >& par_m__CSI,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< BITSTRING >& par_specificCSIDeletedList,
    const OPTIONAL< SMS__CSI >& par_mt__sms__CSI,
    const OPTIONAL< MT__smsCAMELTDP__CriteriaList >& par_mt__smsCAMELTDP__CriteriaList,
    const OPTIONAL< MG__CSI >& par_mg__csi,
    const OPTIONAL< O__CSI >& par_o__IM__CSI,
    const OPTIONAL< O__BcsmCamelTDPCriteriaList >& par_o__IM__BcsmCamelTDP__CriteriaList,
    const OPTIONAL< D__CSI >& par_d__IM__CSI,
    const OPTIONAL< T__CSI >& par_vt__IM__CSI,
    const OPTIONAL< T__BCSM__CAMEL__TDP__CriteriaList >& par_vt__IM__BCSM__CAMEL__TDP__CriteriaList)
  :   field_o__CSI(par_o__CSI),
  field_o__BcsmCamelTDP__CriteriaList(par_o__BcsmCamelTDP__CriteriaList),
  field_d__CSI(par_d__CSI),
  field_t__CSI(par_t__CSI),
  field_t__BCSM__CAMEL__TDP__CriteriaList(par_t__BCSM__CAMEL__TDP__CriteriaList),
  field_vt__CSI(par_vt__CSI),
  field_vt__BCSM__CAMEL__TDP__CriteriaList(par_vt__BCSM__CAMEL__TDP__CriteriaList),
  field_tif__CSI(par_tif__CSI),
  field_tif__CSI__NotificationToCSE(par_tif__CSI__NotificationToCSE),
  field_gprs__CSI(par_gprs__CSI),
  field_mo__sms__CSI(par_mo__sms__CSI),
  field_ss__CSI(par_ss__CSI),
  field_m__CSI(par_m__CSI),
  field_extensionContainer(par_extensionContainer),
  field_specificCSIDeletedList(par_specificCSIDeletedList),
  field_mt__sms__CSI(par_mt__sms__CSI),
  field_mt__smsCAMELTDP__CriteriaList(par_mt__smsCAMELTDP__CriteriaList),
  field_mg__csi(par_mg__csi),
  field_o__IM__CSI(par_o__IM__CSI),
  field_o__IM__BcsmCamelTDP__CriteriaList(par_o__IM__BcsmCamelTDP__CriteriaList),
  field_d__IM__CSI(par_d__IM__CSI),
  field_vt__IM__CSI(par_vt__IM__CSI),
  field_vt__IM__BCSM__CAMEL__TDP__CriteriaList(par_vt__IM__BCSM__CAMEL__TDP__CriteriaList)
{
}

CAMEL__SubscriptionInfo::CAMEL__SubscriptionInfo(const CAMEL__SubscriptionInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
if (other_value.o__CSI().is_bound()) field_o__CSI = other_value.o__CSI();
else field_o__CSI.clean_up();
if (other_value.o__BcsmCamelTDP__CriteriaList().is_bound()) field_o__BcsmCamelTDP__CriteriaList = other_value.o__BcsmCamelTDP__CriteriaList();
else field_o__BcsmCamelTDP__CriteriaList.clean_up();
if (other_value.d__CSI().is_bound()) field_d__CSI = other_value.d__CSI();
else field_d__CSI.clean_up();
if (other_value.t__CSI().is_bound()) field_t__CSI = other_value.t__CSI();
else field_t__CSI.clean_up();
if (other_value.t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_t__BCSM__CAMEL__TDP__CriteriaList = other_value.t__BCSM__CAMEL__TDP__CriteriaList();
else field_t__BCSM__CAMEL__TDP__CriteriaList.clean_up();
if (other_value.vt__CSI().is_bound()) field_vt__CSI = other_value.vt__CSI();
else field_vt__CSI.clean_up();
if (other_value.vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_vt__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__BCSM__CAMEL__TDP__CriteriaList();
else field_vt__BCSM__CAMEL__TDP__CriteriaList.clean_up();
if (other_value.tif__CSI().is_bound()) field_tif__CSI = other_value.tif__CSI();
else field_tif__CSI.clean_up();
if (other_value.tif__CSI__NotificationToCSE().is_bound()) field_tif__CSI__NotificationToCSE = other_value.tif__CSI__NotificationToCSE();
else field_tif__CSI__NotificationToCSE.clean_up();
if (other_value.gprs__CSI().is_bound()) field_gprs__CSI = other_value.gprs__CSI();
else field_gprs__CSI.clean_up();
if (other_value.mo__sms__CSI().is_bound()) field_mo__sms__CSI = other_value.mo__sms__CSI();
else field_mo__sms__CSI.clean_up();
if (other_value.ss__CSI().is_bound()) field_ss__CSI = other_value.ss__CSI();
else field_ss__CSI.clean_up();
if (other_value.m__CSI().is_bound()) field_m__CSI = other_value.m__CSI();
else field_m__CSI.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.specificCSIDeletedList().is_bound()) field_specificCSIDeletedList = other_value.specificCSIDeletedList();
else field_specificCSIDeletedList.clean_up();
if (other_value.mt__sms__CSI().is_bound()) field_mt__sms__CSI = other_value.mt__sms__CSI();
else field_mt__sms__CSI.clean_up();
if (other_value.mt__smsCAMELTDP__CriteriaList().is_bound()) field_mt__smsCAMELTDP__CriteriaList = other_value.mt__smsCAMELTDP__CriteriaList();
else field_mt__smsCAMELTDP__CriteriaList.clean_up();
if (other_value.mg__csi().is_bound()) field_mg__csi = other_value.mg__csi();
else field_mg__csi.clean_up();
if (other_value.o__IM__CSI().is_bound()) field_o__IM__CSI = other_value.o__IM__CSI();
else field_o__IM__CSI.clean_up();
if (other_value.o__IM__BcsmCamelTDP__CriteriaList().is_bound()) field_o__IM__BcsmCamelTDP__CriteriaList = other_value.o__IM__BcsmCamelTDP__CriteriaList();
else field_o__IM__BcsmCamelTDP__CriteriaList.clean_up();
if (other_value.d__IM__CSI().is_bound()) field_d__IM__CSI = other_value.d__IM__CSI();
else field_d__IM__CSI.clean_up();
if (other_value.vt__IM__CSI().is_bound()) field_vt__IM__CSI = other_value.vt__IM__CSI();
else field_vt__IM__CSI.clean_up();
if (other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList();
else field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}

void CAMEL__SubscriptionInfo::clean_up()
{
field_o__CSI.clean_up();
field_o__BcsmCamelTDP__CriteriaList.clean_up();
field_d__CSI.clean_up();
field_t__CSI.clean_up();
field_t__BCSM__CAMEL__TDP__CriteriaList.clean_up();
field_vt__CSI.clean_up();
field_vt__BCSM__CAMEL__TDP__CriteriaList.clean_up();
field_tif__CSI.clean_up();
field_tif__CSI__NotificationToCSE.clean_up();
field_gprs__CSI.clean_up();
field_mo__sms__CSI.clean_up();
field_ss__CSI.clean_up();
field_m__CSI.clean_up();
field_extensionContainer.clean_up();
field_specificCSIDeletedList.clean_up();
field_mt__sms__CSI.clean_up();
field_mt__smsCAMELTDP__CriteriaList.clean_up();
field_mg__csi.clean_up();
field_o__IM__CSI.clean_up();
field_o__IM__BcsmCamelTDP__CriteriaList.clean_up();
field_d__IM__CSI.clean_up();
field_vt__IM__CSI.clean_up();
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}

const TTCN_Typedescriptor_t* CAMEL__SubscriptionInfo::get_descriptor() const { return &CAMEL__SubscriptionInfo_descr_; }
CAMEL__SubscriptionInfo& CAMEL__SubscriptionInfo::operator=(const CAMEL__SubscriptionInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
  if (other_value.o__CSI().is_bound()) field_o__CSI = other_value.o__CSI();
  else field_o__CSI.clean_up();
  if (other_value.o__BcsmCamelTDP__CriteriaList().is_bound()) field_o__BcsmCamelTDP__CriteriaList = other_value.o__BcsmCamelTDP__CriteriaList();
  else field_o__BcsmCamelTDP__CriteriaList.clean_up();
  if (other_value.d__CSI().is_bound()) field_d__CSI = other_value.d__CSI();
  else field_d__CSI.clean_up();
  if (other_value.t__CSI().is_bound()) field_t__CSI = other_value.t__CSI();
  else field_t__CSI.clean_up();
  if (other_value.t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_t__BCSM__CAMEL__TDP__CriteriaList = other_value.t__BCSM__CAMEL__TDP__CriteriaList();
  else field_t__BCSM__CAMEL__TDP__CriteriaList.clean_up();
  if (other_value.vt__CSI().is_bound()) field_vt__CSI = other_value.vt__CSI();
  else field_vt__CSI.clean_up();
  if (other_value.vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_vt__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__BCSM__CAMEL__TDP__CriteriaList();
  else field_vt__BCSM__CAMEL__TDP__CriteriaList.clean_up();
  if (other_value.tif__CSI().is_bound()) field_tif__CSI = other_value.tif__CSI();
  else field_tif__CSI.clean_up();
  if (other_value.tif__CSI__NotificationToCSE().is_bound()) field_tif__CSI__NotificationToCSE = other_value.tif__CSI__NotificationToCSE();
  else field_tif__CSI__NotificationToCSE.clean_up();
  if (other_value.gprs__CSI().is_bound()) field_gprs__CSI = other_value.gprs__CSI();
  else field_gprs__CSI.clean_up();
  if (other_value.mo__sms__CSI().is_bound()) field_mo__sms__CSI = other_value.mo__sms__CSI();
  else field_mo__sms__CSI.clean_up();
  if (other_value.ss__CSI().is_bound()) field_ss__CSI = other_value.ss__CSI();
  else field_ss__CSI.clean_up();
  if (other_value.m__CSI().is_bound()) field_m__CSI = other_value.m__CSI();
  else field_m__CSI.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.specificCSIDeletedList().is_bound()) field_specificCSIDeletedList = other_value.specificCSIDeletedList();
  else field_specificCSIDeletedList.clean_up();
  if (other_value.mt__sms__CSI().is_bound()) field_mt__sms__CSI = other_value.mt__sms__CSI();
  else field_mt__sms__CSI.clean_up();
  if (other_value.mt__smsCAMELTDP__CriteriaList().is_bound()) field_mt__smsCAMELTDP__CriteriaList = other_value.mt__smsCAMELTDP__CriteriaList();
  else field_mt__smsCAMELTDP__CriteriaList.clean_up();
  if (other_value.mg__csi().is_bound()) field_mg__csi = other_value.mg__csi();
  else field_mg__csi.clean_up();
  if (other_value.o__IM__CSI().is_bound()) field_o__IM__CSI = other_value.o__IM__CSI();
  else field_o__IM__CSI.clean_up();
  if (other_value.o__IM__BcsmCamelTDP__CriteriaList().is_bound()) field_o__IM__BcsmCamelTDP__CriteriaList = other_value.o__IM__BcsmCamelTDP__CriteriaList();
  else field_o__IM__BcsmCamelTDP__CriteriaList.clean_up();
  if (other_value.d__IM__CSI().is_bound()) field_d__IM__CSI = other_value.d__IM__CSI();
  else field_d__IM__CSI.clean_up();
  if (other_value.vt__IM__CSI().is_bound()) field_vt__IM__CSI = other_value.vt__IM__CSI();
  else field_vt__IM__CSI.clean_up();
  if (other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList();
  else field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
return *this;
}

boolean CAMEL__SubscriptionInfo::operator==(const CAMEL__SubscriptionInfo& other_value) const
{
return field_o__CSI==other_value.field_o__CSI
  && field_o__BcsmCamelTDP__CriteriaList==other_value.field_o__BcsmCamelTDP__CriteriaList
  && field_d__CSI==other_value.field_d__CSI
  && field_t__CSI==other_value.field_t__CSI
  && field_t__BCSM__CAMEL__TDP__CriteriaList==other_value.field_t__BCSM__CAMEL__TDP__CriteriaList
  && field_vt__CSI==other_value.field_vt__CSI
  && field_vt__BCSM__CAMEL__TDP__CriteriaList==other_value.field_vt__BCSM__CAMEL__TDP__CriteriaList
  && field_tif__CSI==other_value.field_tif__CSI
  && field_tif__CSI__NotificationToCSE==other_value.field_tif__CSI__NotificationToCSE
  && field_gprs__CSI==other_value.field_gprs__CSI
  && field_mo__sms__CSI==other_value.field_mo__sms__CSI
  && field_ss__CSI==other_value.field_ss__CSI
  && field_m__CSI==other_value.field_m__CSI
  && field_extensionContainer==other_value.field_extensionContainer
  && field_specificCSIDeletedList==other_value.field_specificCSIDeletedList
  && field_mt__sms__CSI==other_value.field_mt__sms__CSI
  && field_mt__smsCAMELTDP__CriteriaList==other_value.field_mt__smsCAMELTDP__CriteriaList
  && field_mg__csi==other_value.field_mg__csi
  && field_o__IM__CSI==other_value.field_o__IM__CSI
  && field_o__IM__BcsmCamelTDP__CriteriaList==other_value.field_o__IM__BcsmCamelTDP__CriteriaList
  && field_d__IM__CSI==other_value.field_d__IM__CSI
  && field_vt__IM__CSI==other_value.field_vt__IM__CSI
  && field_vt__IM__BCSM__CAMEL__TDP__CriteriaList==other_value.field_vt__IM__BCSM__CAMEL__TDP__CriteriaList;
}

boolean CAMEL__SubscriptionInfo::is_bound() const
{
return (OPTIONAL_OMIT == field_o__CSI.get_selection() || field_o__CSI.is_bound())
  || (OPTIONAL_OMIT == field_o__BcsmCamelTDP__CriteriaList.get_selection() || field_o__BcsmCamelTDP__CriteriaList.is_bound())
  || (OPTIONAL_OMIT == field_d__CSI.get_selection() || field_d__CSI.is_bound())
  || (OPTIONAL_OMIT == field_t__CSI.get_selection() || field_t__CSI.is_bound())
  || (OPTIONAL_OMIT == field_t__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_t__BCSM__CAMEL__TDP__CriteriaList.is_bound())
  || (OPTIONAL_OMIT == field_vt__CSI.get_selection() || field_vt__CSI.is_bound())
  || (OPTIONAL_OMIT == field_vt__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_vt__BCSM__CAMEL__TDP__CriteriaList.is_bound())
  || (OPTIONAL_OMIT == field_tif__CSI.get_selection() || field_tif__CSI.is_bound())
  || (OPTIONAL_OMIT == field_tif__CSI__NotificationToCSE.get_selection() || field_tif__CSI__NotificationToCSE.is_bound())
  || (OPTIONAL_OMIT == field_gprs__CSI.get_selection() || field_gprs__CSI.is_bound())
  || (OPTIONAL_OMIT == field_mo__sms__CSI.get_selection() || field_mo__sms__CSI.is_bound())
  || (OPTIONAL_OMIT == field_ss__CSI.get_selection() || field_ss__CSI.is_bound())
  || (OPTIONAL_OMIT == field_m__CSI.get_selection() || field_m__CSI.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_specificCSIDeletedList.get_selection() || field_specificCSIDeletedList.is_bound())
  || (OPTIONAL_OMIT == field_mt__sms__CSI.get_selection() || field_mt__sms__CSI.is_bound())
  || (OPTIONAL_OMIT == field_mt__smsCAMELTDP__CriteriaList.get_selection() || field_mt__smsCAMELTDP__CriteriaList.is_bound())
  || (OPTIONAL_OMIT == field_mg__csi.get_selection() || field_mg__csi.is_bound())
  || (OPTIONAL_OMIT == field_o__IM__CSI.get_selection() || field_o__IM__CSI.is_bound())
  || (OPTIONAL_OMIT == field_o__IM__BcsmCamelTDP__CriteriaList.get_selection() || field_o__IM__BcsmCamelTDP__CriteriaList.is_bound())
  || (OPTIONAL_OMIT == field_d__IM__CSI.get_selection() || field_d__IM__CSI.is_bound())
  || (OPTIONAL_OMIT == field_vt__IM__CSI.get_selection() || field_vt__IM__CSI.is_bound())
  || (OPTIONAL_OMIT == field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_bound());
}
boolean CAMEL__SubscriptionInfo::is_value() const
{
return (OPTIONAL_OMIT == field_o__CSI.get_selection() || field_o__CSI.is_value())
  && (OPTIONAL_OMIT == field_o__BcsmCamelTDP__CriteriaList.get_selection() || field_o__BcsmCamelTDP__CriteriaList.is_value())
  && (OPTIONAL_OMIT == field_d__CSI.get_selection() || field_d__CSI.is_value())
  && (OPTIONAL_OMIT == field_t__CSI.get_selection() || field_t__CSI.is_value())
  && (OPTIONAL_OMIT == field_t__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_t__BCSM__CAMEL__TDP__CriteriaList.is_value())
  && (OPTIONAL_OMIT == field_vt__CSI.get_selection() || field_vt__CSI.is_value())
  && (OPTIONAL_OMIT == field_vt__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_vt__BCSM__CAMEL__TDP__CriteriaList.is_value())
  && (OPTIONAL_OMIT == field_tif__CSI.get_selection() || field_tif__CSI.is_value())
  && (OPTIONAL_OMIT == field_tif__CSI__NotificationToCSE.get_selection() || field_tif__CSI__NotificationToCSE.is_value())
  && (OPTIONAL_OMIT == field_gprs__CSI.get_selection() || field_gprs__CSI.is_value())
  && (OPTIONAL_OMIT == field_mo__sms__CSI.get_selection() || field_mo__sms__CSI.is_value())
  && (OPTIONAL_OMIT == field_ss__CSI.get_selection() || field_ss__CSI.is_value())
  && (OPTIONAL_OMIT == field_m__CSI.get_selection() || field_m__CSI.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_specificCSIDeletedList.get_selection() || field_specificCSIDeletedList.is_value())
  && (OPTIONAL_OMIT == field_mt__sms__CSI.get_selection() || field_mt__sms__CSI.is_value())
  && (OPTIONAL_OMIT == field_mt__smsCAMELTDP__CriteriaList.get_selection() || field_mt__smsCAMELTDP__CriteriaList.is_value())
  && (OPTIONAL_OMIT == field_mg__csi.get_selection() || field_mg__csi.is_value())
  && (OPTIONAL_OMIT == field_o__IM__CSI.get_selection() || field_o__IM__CSI.is_value())
  && (OPTIONAL_OMIT == field_o__IM__BcsmCamelTDP__CriteriaList.get_selection() || field_o__IM__BcsmCamelTDP__CriteriaList.is_value())
  && (OPTIONAL_OMIT == field_d__IM__CSI.get_selection() || field_d__IM__CSI.is_value())
  && (OPTIONAL_OMIT == field_vt__IM__CSI.get_selection() || field_vt__IM__CSI.is_value())
  && (OPTIONAL_OMIT == field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.get_selection() || field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_value());
}
int CAMEL__SubscriptionInfo::size_of() const
{
  int ret_val = 0;
  if (field_o__CSI.ispresent()) ret_val++;
  if (field_o__BcsmCamelTDP__CriteriaList.ispresent()) ret_val++;
  if (field_d__CSI.ispresent()) ret_val++;
  if (field_t__CSI.ispresent()) ret_val++;
  if (field_t__BCSM__CAMEL__TDP__CriteriaList.ispresent()) ret_val++;
  if (field_vt__CSI.ispresent()) ret_val++;
  if (field_vt__BCSM__CAMEL__TDP__CriteriaList.ispresent()) ret_val++;
  if (field_tif__CSI.ispresent()) ret_val++;
  if (field_tif__CSI__NotificationToCSE.ispresent()) ret_val++;
  if (field_gprs__CSI.ispresent()) ret_val++;
  if (field_mo__sms__CSI.ispresent()) ret_val++;
  if (field_ss__CSI.ispresent()) ret_val++;
  if (field_m__CSI.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_specificCSIDeletedList.ispresent()) ret_val++;
  if (field_mt__sms__CSI.ispresent()) ret_val++;
  if (field_mt__smsCAMELTDP__CriteriaList.ispresent()) ret_val++;
  if (field_mg__csi.ispresent()) ret_val++;
  if (field_o__IM__CSI.ispresent()) ret_val++;
  if (field_o__IM__BcsmCamelTDP__CriteriaList.ispresent()) ret_val++;
  if (field_d__IM__CSI.ispresent()) ret_val++;
  if (field_vt__IM__CSI.ispresent()) ret_val++;
  if (field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.ispresent()) ret_val++;
  return ret_val;
}

void CAMEL__SubscriptionInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ o_CSI := ");
field_o__CSI.log();
TTCN_Logger::log_event_str(", o_BcsmCamelTDP_CriteriaList := ");
field_o__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", d_CSI := ");
field_d__CSI.log();
TTCN_Logger::log_event_str(", t_CSI := ");
field_t__CSI.log();
TTCN_Logger::log_event_str(", t_BCSM_CAMEL_TDP_CriteriaList := ");
field_t__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(", vt_CSI := ");
field_vt__CSI.log();
TTCN_Logger::log_event_str(", vt_BCSM_CAMEL_TDP_CriteriaList := ");
field_vt__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(", tif_CSI := ");
field_tif__CSI.log();
TTCN_Logger::log_event_str(", tif_CSI_NotificationToCSE := ");
field_tif__CSI__NotificationToCSE.log();
TTCN_Logger::log_event_str(", gprs_CSI := ");
field_gprs__CSI.log();
TTCN_Logger::log_event_str(", mo_sms_CSI := ");
field_mo__sms__CSI.log();
TTCN_Logger::log_event_str(", ss_CSI := ");
field_ss__CSI.log();
TTCN_Logger::log_event_str(", m_CSI := ");
field_m__CSI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", specificCSIDeletedList := ");
field_specificCSIDeletedList.log();
TTCN_Logger::log_event_str(", mt_sms_CSI := ");
field_mt__sms__CSI.log();
TTCN_Logger::log_event_str(", mt_smsCAMELTDP_CriteriaList := ");
field_mt__smsCAMELTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", mg_csi := ");
field_mg__csi.log();
TTCN_Logger::log_event_str(", o_IM_CSI := ");
field_o__IM__CSI.log();
TTCN_Logger::log_event_str(", o_IM_BcsmCamelTDP_CriteriaList := ");
field_o__IM__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", d_IM_CSI := ");
field_d__IM__CSI.log();
TTCN_Logger::log_event_str(", vt_IM_CSI := ");
field_vt__IM__CSI.log();
TTCN_Logger::log_event_str(", vt_IM_BCSM_CAMEL_TDP_CriteriaList := ");
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(" }");
}

void CAMEL__SubscriptionInfo::set_implicit_omit()
{
if (!o__CSI().is_bound()) o__CSI() = OMIT_VALUE;
else o__CSI().set_implicit_omit();
if (!o__BcsmCamelTDP__CriteriaList().is_bound()) o__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else o__BcsmCamelTDP__CriteriaList().set_implicit_omit();
if (!d__CSI().is_bound()) d__CSI() = OMIT_VALUE;
else d__CSI().set_implicit_omit();
if (!t__CSI().is_bound()) t__CSI() = OMIT_VALUE;
else t__CSI().set_implicit_omit();
if (!t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) t__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else t__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
if (!vt__CSI().is_bound()) vt__CSI() = OMIT_VALUE;
else vt__CSI().set_implicit_omit();
if (!vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) vt__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else vt__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
if (!tif__CSI().is_bound()) tif__CSI() = OMIT_VALUE;
else tif__CSI().set_implicit_omit();
if (!tif__CSI__NotificationToCSE().is_bound()) tif__CSI__NotificationToCSE() = OMIT_VALUE;
else tif__CSI__NotificationToCSE().set_implicit_omit();
if (!gprs__CSI().is_bound()) gprs__CSI() = OMIT_VALUE;
else gprs__CSI().set_implicit_omit();
if (!mo__sms__CSI().is_bound()) mo__sms__CSI() = OMIT_VALUE;
else mo__sms__CSI().set_implicit_omit();
if (!ss__CSI().is_bound()) ss__CSI() = OMIT_VALUE;
else ss__CSI().set_implicit_omit();
if (!m__CSI().is_bound()) m__CSI() = OMIT_VALUE;
else m__CSI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!specificCSIDeletedList().is_bound()) specificCSIDeletedList() = OMIT_VALUE;
else specificCSIDeletedList().set_implicit_omit();
if (!mt__sms__CSI().is_bound()) mt__sms__CSI() = OMIT_VALUE;
else mt__sms__CSI().set_implicit_omit();
if (!mt__smsCAMELTDP__CriteriaList().is_bound()) mt__smsCAMELTDP__CriteriaList() = OMIT_VALUE;
else mt__smsCAMELTDP__CriteriaList().set_implicit_omit();
if (!mg__csi().is_bound()) mg__csi() = OMIT_VALUE;
else mg__csi().set_implicit_omit();
if (!o__IM__CSI().is_bound()) o__IM__CSI() = OMIT_VALUE;
else o__IM__CSI().set_implicit_omit();
if (!o__IM__BcsmCamelTDP__CriteriaList().is_bound()) o__IM__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else o__IM__BcsmCamelTDP__CriteriaList().set_implicit_omit();
if (!d__IM__CSI().is_bound()) d__IM__CSI() = OMIT_VALUE;
else d__IM__CSI().set_implicit_omit();
if (!vt__IM__CSI().is_bound()) vt__IM__CSI() = OMIT_VALUE;
else vt__IM__CSI().set_implicit_omit();
if (!vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) vt__IM__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
}

void CAMEL__SubscriptionInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (23<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo has 23 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) o__CSI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) o__BcsmCamelTDP__CriteriaList().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) d__CSI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) t__CSI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) t__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) vt__CSI().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) vt__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) tif__CSI().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) tif__CSI__NotificationToCSE().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) gprs__CSI().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) mo__sms__CSI().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) ss__CSI().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) m__CSI().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) specificCSIDeletedList().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) mt__sms__CSI().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) mt__smsCAMELTDP__CriteriaList().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) mg__csi().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) o__IM__CSI().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) o__IM__BcsmCamelTDP__CriteriaList().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) d__IM__CSI().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) vt__IM__CSI().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(22));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_BcsmCamelTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__BcsmCamelTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tif_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tif__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tif_CSI_NotificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tif__CSI__NotificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprs_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprs__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mo_sms_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mo__sms__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "m_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          m__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "specificCSIDeletedList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          specificCSIDeletedList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mt_sms_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mt__sms__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mt_smsCAMELTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mt__smsCAMELTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mg_csi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mg__csi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_IM_BcsmCamelTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__IM__BcsmCamelTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_IM_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
  }
}

void CAMEL__SubscriptionInfo::encode_text(Text_Buf& text_buf) const
{
field_o__CSI.encode_text(text_buf);
field_o__BcsmCamelTDP__CriteriaList.encode_text(text_buf);
field_d__CSI.encode_text(text_buf);
field_t__CSI.encode_text(text_buf);
field_t__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
field_vt__CSI.encode_text(text_buf);
field_vt__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
field_tif__CSI.encode_text(text_buf);
field_tif__CSI__NotificationToCSE.encode_text(text_buf);
field_gprs__CSI.encode_text(text_buf);
field_mo__sms__CSI.encode_text(text_buf);
field_ss__CSI.encode_text(text_buf);
field_m__CSI.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_specificCSIDeletedList.encode_text(text_buf);
field_mt__sms__CSI.encode_text(text_buf);
field_mt__smsCAMELTDP__CriteriaList.encode_text(text_buf);
field_mg__csi.encode_text(text_buf);
field_o__IM__CSI.encode_text(text_buf);
field_o__IM__BcsmCamelTDP__CriteriaList.encode_text(text_buf);
field_d__IM__CSI.encode_text(text_buf);
field_vt__IM__CSI.encode_text(text_buf);
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
}

void CAMEL__SubscriptionInfo::decode_text(Text_Buf& text_buf)
{
field_o__CSI.decode_text(text_buf);
field_o__BcsmCamelTDP__CriteriaList.decode_text(text_buf);
field_d__CSI.decode_text(text_buf);
field_t__CSI.decode_text(text_buf);
field_t__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
field_vt__CSI.decode_text(text_buf);
field_vt__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
field_tif__CSI.decode_text(text_buf);
field_tif__CSI__NotificationToCSE.decode_text(text_buf);
field_gprs__CSI.decode_text(text_buf);
field_mo__sms__CSI.decode_text(text_buf);
field_ss__CSI.decode_text(text_buf);
field_m__CSI.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_specificCSIDeletedList.decode_text(text_buf);
field_mt__sms__CSI.decode_text(text_buf);
field_mt__smsCAMELTDP__CriteriaList.decode_text(text_buf);
field_mg__csi.decode_text(text_buf);
field_o__IM__CSI.decode_text(text_buf);
field_o__IM__BcsmCamelTDP__CriteriaList.decode_text(text_buf);
field_d__IM__CSI.decode_text(text_buf);
field_vt__IM__CSI.decode_text(text_buf);
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
}

void CAMEL__SubscriptionInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CAMEL__SubscriptionInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* CAMEL__SubscriptionInfo::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("o_CSI': ");
  new_tlv->add_TLV(field_o__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_o__CSI_descr_, p_coding));
  ec_1.set_msg("o_BcsmCamelTDP_CriteriaList': ");
  new_tlv->add_TLV(field_o__BcsmCamelTDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_coding));
  ec_1.set_msg("d_CSI': ");
  new_tlv->add_TLV(field_d__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_d__CSI_descr_, p_coding));
  ec_1.set_msg("t_CSI': ");
  new_tlv->add_TLV(field_t__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_t__CSI_descr_, p_coding));
  ec_1.set_msg("t_BCSM_CAMEL_TDP_CriteriaList': ");
  new_tlv->add_TLV(field_t__BCSM__CAMEL__TDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_coding));
  ec_1.set_msg("vt_CSI': ");
  new_tlv->add_TLV(field_vt__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_coding));
  ec_1.set_msg("vt_BCSM_CAMEL_TDP_CriteriaList': ");
  new_tlv->add_TLV(field_vt__BCSM__CAMEL__TDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_coding));
  ec_1.set_msg("tif_CSI': ");
  new_tlv->add_TLV(field_tif__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_coding));
  ec_1.set_msg("tif_CSI_NotificationToCSE': ");
  new_tlv->add_TLV(field_tif__CSI__NotificationToCSE.BER_encode_TLV(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_coding));
  ec_1.set_msg("gprs_CSI': ");
  new_tlv->add_TLV(field_gprs__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_coding));
  ec_1.set_msg("mo_sms_CSI': ");
  new_tlv->add_TLV(field_mo__sms__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_coding));
  ec_1.set_msg("ss_CSI': ");
  new_tlv->add_TLV(field_ss__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_coding));
  ec_1.set_msg("m_CSI': ");
  new_tlv->add_TLV(field_m__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_m__CSI_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_coding));
  ec_1.set_msg("specificCSIDeletedList': ");
  new_tlv->add_TLV(field_specificCSIDeletedList.BER_encode_TLV(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, p_coding));
  ec_1.set_msg("mt_sms_CSI': ");
  new_tlv->add_TLV(field_mt__sms__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, p_coding));
  ec_1.set_msg("mt_smsCAMELTDP_CriteriaList': ");
  new_tlv->add_TLV(field_mt__smsCAMELTDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, p_coding));
  ec_1.set_msg("mg_csi': ");
  new_tlv->add_TLV(field_mg__csi.BER_encode_TLV(CAMEL__SubscriptionInfo_mg__csi_descr_, p_coding));
  ec_1.set_msg("o_IM_CSI': ");
  new_tlv->add_TLV(field_o__IM__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, p_coding));
  ec_1.set_msg("o_IM_BcsmCamelTDP_CriteriaList': ");
  new_tlv->add_TLV(field_o__IM__BcsmCamelTDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, p_coding));
  ec_1.set_msg("d_IM_CSI': ");
  new_tlv->add_TLV(field_d__IM__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, p_coding));
  ec_1.set_msg("vt_IM_CSI': ");
  new_tlv->add_TLV(field_vt__IM__CSI.BER_encode_TLV(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, p_coding));
  ec_1.set_msg("vt_IM_BCSM_CAMEL_TDP_CriteriaList': ");
  new_tlv->add_TLV(field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.BER_encode_TLV(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean CAMEL__SubscriptionInfo::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.CAMEL-SubscriptionInfo' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("o_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_o__CSI=OMIT_VALUE;
    else {
      field_o__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_o__CSI_descr_, tmp_tlv, L_form);
      if(field_o__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("o_BcsmCamelTDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_o__BcsmCamelTDP__CriteriaList=OMIT_VALUE;
    else {
      field_o__BcsmCamelTDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_o__BcsmCamelTDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("d_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_d__CSI=OMIT_VALUE;
    else {
      field_d__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_d__CSI_descr_, tmp_tlv, L_form);
      if(field_d__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("t_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_t__CSI=OMIT_VALUE;
    else {
      field_t__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_t__CSI_descr_, tmp_tlv, L_form);
      if(field_t__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("t_BCSM_CAMEL_TDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_t__BCSM__CAMEL__TDP__CriteriaList=OMIT_VALUE;
    else {
      field_t__BCSM__CAMEL__TDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_t__BCSM__CAMEL__TDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vt_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vt__CSI=OMIT_VALUE;
    else {
      field_vt__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_vt__CSI_descr_, tmp_tlv, L_form);
      if(field_vt__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vt_BCSM_CAMEL_TDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vt__BCSM__CAMEL__TDP__CriteriaList=OMIT_VALUE;
    else {
      field_vt__BCSM__CAMEL__TDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_vt__BCSM__CAMEL__TDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("tif_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_tif__CSI=OMIT_VALUE;
    else {
      field_tif__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_tif__CSI_descr_, tmp_tlv, L_form);
      if(field_tif__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("tif_CSI_NotificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_tif__CSI__NotificationToCSE=OMIT_VALUE;
    else {
      field_tif__CSI__NotificationToCSE.BER_decode_TLV(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, tmp_tlv, L_form);
      if(field_tif__CSI__NotificationToCSE.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("gprs_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_gprs__CSI=OMIT_VALUE;
    else {
      field_gprs__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_gprs__CSI_descr_, tmp_tlv, L_form);
      if(field_gprs__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mo_sms_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mo__sms__CSI=OMIT_VALUE;
    else {
      field_mo__sms__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, tmp_tlv, L_form);
      if(field_mo__sms__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ss_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ss__CSI=OMIT_VALUE;
    else {
      field_ss__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_ss__CSI_descr_, tmp_tlv, L_form);
      if(field_ss__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("m_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_m__CSI=OMIT_VALUE;
    else {
      field_m__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_m__CSI_descr_, tmp_tlv, L_form);
      if(field_m__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(CAMEL__SubscriptionInfo_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("specificCSIDeletedList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_specificCSIDeletedList=OMIT_VALUE;
    else {
      field_specificCSIDeletedList.BER_decode_TLV(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, tmp_tlv, L_form);
      if(field_specificCSIDeletedList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mt_sms_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mt__sms__CSI=OMIT_VALUE;
    else {
      field_mt__sms__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, tmp_tlv, L_form);
      if(field_mt__sms__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mt_smsCAMELTDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mt__smsCAMELTDP__CriteriaList=OMIT_VALUE;
    else {
      field_mt__smsCAMELTDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_mt__smsCAMELTDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mg_csi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mg__csi=OMIT_VALUE;
    else {
      field_mg__csi.BER_decode_TLV(CAMEL__SubscriptionInfo_mg__csi_descr_, tmp_tlv, L_form);
      if(field_mg__csi.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("o_IM_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_o__IM__CSI=OMIT_VALUE;
    else {
      field_o__IM__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, tmp_tlv, L_form);
      if(field_o__IM__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("o_IM_BcsmCamelTDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_o__IM__BcsmCamelTDP__CriteriaList=OMIT_VALUE;
    else {
      field_o__IM__BcsmCamelTDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_o__IM__BcsmCamelTDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("d_IM_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_d__IM__CSI=OMIT_VALUE;
    else {
      field_d__IM__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, tmp_tlv, L_form);
      if(field_d__IM__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vt_IM_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vt__IM__CSI=OMIT_VALUE;
    else {
      field_vt__IM__CSI.BER_decode_TLV(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, tmp_tlv, L_form);
      if(field_vt__IM__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vt_IM_BCSM_CAMEL_TDP_CriteriaList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vt__IM__BCSM__CAMEL__TDP__CriteriaList=OMIT_VALUE;
    else {
      field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.BER_decode_TLV(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, tmp_tlv, L_form);
      if(field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int CAMEL__SubscriptionInfo::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_o__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "o_CSI");
    enc_len += field_o__CSI.JSON_encode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_tok, FALSE);
  }

  if (field_o__BcsmCamelTDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "o_BcsmCamelTDP_CriteriaList");
    enc_len += field_o__BcsmCamelTDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_tok, FALSE);
  }

  if (field_d__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "d_CSI");
    enc_len += field_d__CSI.JSON_encode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_tok, FALSE);
  }

  if (field_t__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "t_CSI");
    enc_len += field_t__CSI.JSON_encode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_tok, FALSE);
  }

  if (field_t__BCSM__CAMEL__TDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "t_BCSM_CAMEL_TDP_CriteriaList");
    enc_len += field_t__BCSM__CAMEL__TDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, FALSE);
  }

  if (field_vt__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vt_CSI");
    enc_len += field_vt__CSI.JSON_encode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_tok, FALSE);
  }

  if (field_vt__BCSM__CAMEL__TDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vt_BCSM_CAMEL_TDP_CriteriaList");
    enc_len += field_vt__BCSM__CAMEL__TDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, FALSE);
  }

  if (field_tif__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "tif_CSI");
    enc_len += field_tif__CSI.JSON_encode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_tok, FALSE);
  }

  if (field_tif__CSI__NotificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "tif_CSI_NotificationToCSE");
    enc_len += field_tif__CSI__NotificationToCSE.JSON_encode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_tok, FALSE);
  }

  if (field_gprs__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gprs_CSI");
    enc_len += field_gprs__CSI.JSON_encode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_tok, FALSE);
  }

  if (field_mo__sms__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mo_sms_CSI");
    enc_len += field_mo__sms__CSI.JSON_encode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_tok, FALSE);
  }

  if (field_ss__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_CSI");
    enc_len += field_ss__CSI.JSON_encode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_tok, FALSE);
  }

  if (field_m__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "m_CSI");
    enc_len += field_m__CSI.JSON_encode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_specificCSIDeletedList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "specificCSIDeletedList");
    enc_len += field_specificCSIDeletedList.JSON_encode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, p_tok, FALSE);
  }

  if (field_mt__sms__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mt_sms_CSI");
    enc_len += field_mt__sms__CSI.JSON_encode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, p_tok, FALSE);
  }

  if (field_mt__smsCAMELTDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mt_smsCAMELTDP_CriteriaList");
    enc_len += field_mt__smsCAMELTDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, p_tok, FALSE);
  }

  if (field_mg__csi.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mg_csi");
    enc_len += field_mg__csi.JSON_encode(CAMEL__SubscriptionInfo_mg__csi_descr_, p_tok, FALSE);
  }

  if (field_o__IM__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "o_IM_CSI");
    enc_len += field_o__IM__CSI.JSON_encode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, p_tok, FALSE);
  }

  if (field_o__IM__BcsmCamelTDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "o_IM_BcsmCamelTDP_CriteriaList");
    enc_len += field_o__IM__BcsmCamelTDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, p_tok, FALSE);
  }

  if (field_d__IM__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "d_IM_CSI");
    enc_len += field_d__IM__CSI.JSON_encode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, p_tok, FALSE);
  }

  if (field_vt__IM__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vt_IM_CSI");
    enc_len += field_vt__IM__CSI.JSON_encode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, p_tok, FALSE);
  }

  if (field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vt_IM_BCSM_CAMEL_TDP_CriteriaList");
    enc_len += field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.JSON_encode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int CAMEL__SubscriptionInfo::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const CAMEL__SubscriptionInfo*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean o__CSI_found = FALSE;
  boolean o__BcsmCamelTDP__CriteriaList_found = FALSE;
  boolean d__CSI_found = FALSE;
  boolean t__CSI_found = FALSE;
  boolean t__BCSM__CAMEL__TDP__CriteriaList_found = FALSE;
  boolean vt__CSI_found = FALSE;
  boolean vt__BCSM__CAMEL__TDP__CriteriaList_found = FALSE;
  boolean tif__CSI_found = FALSE;
  boolean tif__CSI__NotificationToCSE_found = FALSE;
  boolean gprs__CSI_found = FALSE;
  boolean mo__sms__CSI_found = FALSE;
  boolean ss__CSI_found = FALSE;
  boolean m__CSI_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean specificCSIDeletedList_found = FALSE;
  boolean mt__sms__CSI_found = FALSE;
  boolean mt__smsCAMELTDP__CriteriaList_found = FALSE;
  boolean mg__csi_found = FALSE;
  boolean o__IM__CSI_found = FALSE;
  boolean o__IM__BcsmCamelTDP__CriteriaList_found = FALSE;
  boolean d__IM__CSI_found = FALSE;
  boolean vt__IM__CSI_found = FALSE;
  boolean vt__IM__BCSM__CAMEL__TDP__CriteriaList_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (5 == name_len && 0 == strncmp(fld_name, "o_CSI", name_len)) {
        o__CSI_found = TRUE;
         int ret_val = field_o__CSI.JSON_decode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 5, "o_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "o_BcsmCamelTDP_CriteriaList", name_len)) {
        o__BcsmCamelTDP__CriteriaList_found = TRUE;
         int ret_val = field_o__BcsmCamelTDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "o_BcsmCamelTDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (5 == name_len && 0 == strncmp(fld_name, "d_CSI", name_len)) {
        d__CSI_found = TRUE;
         int ret_val = field_d__CSI.JSON_decode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 5, "d_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (5 == name_len && 0 == strncmp(fld_name, "t_CSI", name_len)) {
        t__CSI_found = TRUE;
         int ret_val = field_t__CSI.JSON_decode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 5, "t_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (29 == name_len && 0 == strncmp(fld_name, "t_BCSM_CAMEL_TDP_CriteriaList", name_len)) {
        t__BCSM__CAMEL__TDP__CriteriaList_found = TRUE;
         int ret_val = field_t__BCSM__CAMEL__TDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 29, "t_BCSM_CAMEL_TDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (6 == name_len && 0 == strncmp(fld_name, "vt_CSI", name_len)) {
        vt__CSI_found = TRUE;
         int ret_val = field_vt__CSI.JSON_decode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 6, "vt_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "vt_BCSM_CAMEL_TDP_CriteriaList", name_len)) {
        vt__BCSM__CAMEL__TDP__CriteriaList_found = TRUE;
         int ret_val = field_vt__BCSM__CAMEL__TDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "vt_BCSM_CAMEL_TDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (7 == name_len && 0 == strncmp(fld_name, "tif_CSI", name_len)) {
        tif__CSI_found = TRUE;
         int ret_val = field_tif__CSI.JSON_decode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 7, "tif_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (25 == name_len && 0 == strncmp(fld_name, "tif_CSI_NotificationToCSE", name_len)) {
        tif__CSI__NotificationToCSE_found = TRUE;
         int ret_val = field_tif__CSI__NotificationToCSE.JSON_decode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 25, "tif_CSI_NotificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "gprs_CSI", name_len)) {
        gprs__CSI_found = TRUE;
         int ret_val = field_gprs__CSI.JSON_decode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "gprs_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "mo_sms_CSI", name_len)) {
        mo__sms__CSI_found = TRUE;
         int ret_val = field_mo__sms__CSI.JSON_decode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "mo_sms_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (6 == name_len && 0 == strncmp(fld_name, "ss_CSI", name_len)) {
        ss__CSI_found = TRUE;
         int ret_val = field_ss__CSI.JSON_decode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 6, "ss_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (5 == name_len && 0 == strncmp(fld_name, "m_CSI", name_len)) {
        m__CSI_found = TRUE;
         int ret_val = field_m__CSI.JSON_decode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 5, "m_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (22 == name_len && 0 == strncmp(fld_name, "specificCSIDeletedList", name_len)) {
        specificCSIDeletedList_found = TRUE;
         int ret_val = field_specificCSIDeletedList.JSON_decode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 22, "specificCSIDeletedList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "mt_sms_CSI", name_len)) {
        mt__sms__CSI_found = TRUE;
         int ret_val = field_mt__sms__CSI.JSON_decode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "mt_sms_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "mt_smsCAMELTDP_CriteriaList", name_len)) {
        mt__smsCAMELTDP__CriteriaList_found = TRUE;
         int ret_val = field_mt__smsCAMELTDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "mt_smsCAMELTDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (6 == name_len && 0 == strncmp(fld_name, "mg_csi", name_len)) {
        mg__csi_found = TRUE;
         int ret_val = field_mg__csi.JSON_decode(CAMEL__SubscriptionInfo_mg__csi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 6, "mg_csi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "o_IM_CSI", name_len)) {
        o__IM__CSI_found = TRUE;
         int ret_val = field_o__IM__CSI.JSON_decode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "o_IM_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "o_IM_BcsmCamelTDP_CriteriaList", name_len)) {
        o__IM__BcsmCamelTDP__CriteriaList_found = TRUE;
         int ret_val = field_o__IM__BcsmCamelTDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "o_IM_BcsmCamelTDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "d_IM_CSI", name_len)) {
        d__IM__CSI_found = TRUE;
         int ret_val = field_d__IM__CSI.JSON_decode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "d_IM_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "vt_IM_CSI", name_len)) {
        vt__IM__CSI_found = TRUE;
         int ret_val = field_vt__IM__CSI.JSON_decode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "vt_IM_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (33 == name_len && 0 == strncmp(fld_name, "vt_IM_BCSM_CAMEL_TDP_CriteriaList", name_len)) {
        vt__IM__BCSM__CAMEL__TDP__CriteriaList_found = TRUE;
         int ret_val = field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.JSON_decode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 33, "vt_IM_BCSM_CAMEL_TDP_CriteriaList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!o__CSI_found) {
    field_o__CSI = OMIT_VALUE;
  }
  if (!o__BcsmCamelTDP__CriteriaList_found) {
    field_o__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
  }
  if (!d__CSI_found) {
    field_d__CSI = OMIT_VALUE;
  }
  if (!t__CSI_found) {
    field_t__CSI = OMIT_VALUE;
  }
  if (!t__BCSM__CAMEL__TDP__CriteriaList_found) {
    field_t__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  }
  if (!vt__CSI_found) {
    field_vt__CSI = OMIT_VALUE;
  }
  if (!vt__BCSM__CAMEL__TDP__CriteriaList_found) {
    field_vt__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  }
  if (!tif__CSI_found) {
    field_tif__CSI = OMIT_VALUE;
  }
  if (!tif__CSI__NotificationToCSE_found) {
    field_tif__CSI__NotificationToCSE = OMIT_VALUE;
  }
  if (!gprs__CSI_found) {
    field_gprs__CSI = OMIT_VALUE;
  }
  if (!mo__sms__CSI_found) {
    field_mo__sms__CSI = OMIT_VALUE;
  }
  if (!ss__CSI_found) {
    field_ss__CSI = OMIT_VALUE;
  }
  if (!m__CSI_found) {
    field_m__CSI = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!specificCSIDeletedList_found) {
    field_specificCSIDeletedList = OMIT_VALUE;
  }
  if (!mt__sms__CSI_found) {
    field_mt__sms__CSI = OMIT_VALUE;
  }
  if (!mt__smsCAMELTDP__CriteriaList_found) {
    field_mt__smsCAMELTDP__CriteriaList = OMIT_VALUE;
  }
  if (!mg__csi_found) {
    field_mg__csi = OMIT_VALUE;
  }
  if (!o__IM__CSI_found) {
    field_o__IM__CSI = OMIT_VALUE;
  }
  if (!o__IM__BcsmCamelTDP__CriteriaList_found) {
    field_o__IM__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
  }
  if (!d__IM__CSI_found) {
    field_d__IM__CSI = OMIT_VALUE;
  }
  if (!vt__IM__CSI_found) {
    field_vt__IM__CSI = OMIT_VALUE;
  }
  if (!vt__IM__BCSM__CAMEL__TDP__CriteriaList_found) {
    field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int CAMEL__SubscriptionInfo::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_specificCSIDeletedList.is_bound() && field_specificCSIDeletedList.is_present());
  has_extension = has_extension || (field_mt__sms__CSI.is_bound() && field_mt__sms__CSI.is_present());
  has_extension = has_extension || (field_mt__smsCAMELTDP__CriteriaList.is_bound() && field_mt__smsCAMELTDP__CriteriaList.is_present());
  has_extension = has_extension || (field_mg__csi.is_bound() && field_mg__csi.is_present());
  has_extension = has_extension || (field_o__IM__CSI.is_bound() && field_o__IM__CSI.is_present());
  has_extension = has_extension || (field_o__IM__BcsmCamelTDP__CriteriaList.is_bound() && field_o__IM__BcsmCamelTDP__CriteriaList.is_present());
  has_extension = has_extension || (field_d__IM__CSI.is_bound() && field_d__IM__CSI.is_present());
  has_extension = has_extension || (field_vt__IM__CSI.is_bound() && field_vt__IM__CSI.is_present());
  has_extension = has_extension || (field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_bound() && field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_o__CSI.is_present()) {
    c |= 64;
  }
  if (field_o__BcsmCamelTDP__CriteriaList.is_present()) {
    c |= 32;
  }
  if (field_d__CSI.is_present()) {
    c |= 16;
  }
  if (field_t__CSI.is_present()) {
    c |= 8;
  }
  if (field_t__BCSM__CAMEL__TDP__CriteriaList.is_present()) {
    c |= 4;
  }
  if (field_vt__CSI.is_present()) {
    c |= 2;
  }
  if (field_vt__BCSM__CAMEL__TDP__CriteriaList.is_present()) {
    c |= 1;
  }
  p_buf.put_c(c);
  c = 0
;  if (field_tif__CSI.is_present()) {
    c |= 128;
  }
  if (field_tif__CSI__NotificationToCSE.is_present()) {
    c |= 64;
  }
  if (field_gprs__CSI.is_present()) {
    c |= 32;
  }
  if (field_mo__sms__CSI.is_present()) {
    c |= 16;
  }
  if (field_ss__CSI.is_present()) {
    c |= 8;
  }
  if (field_m__CSI.is_present()) {
    c |= 4;
  }
  if (field_extensionContainer.is_present()) {
    c |= 2;
  }
  p_buf.put_c(c);
  if (field_o__CSI.is_present())
    field_o__CSI.OER_encode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_buf);
  if (field_o__BcsmCamelTDP__CriteriaList.is_present())
    field_o__BcsmCamelTDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_buf);
  if (field_d__CSI.is_present())
    field_d__CSI.OER_encode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_buf);
  if (field_t__CSI.is_present())
    field_t__CSI.OER_encode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_buf);
  if (field_t__BCSM__CAMEL__TDP__CriteriaList.is_present())
    field_t__BCSM__CAMEL__TDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf);
  if (field_vt__CSI.is_present())
    field_vt__CSI.OER_encode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_buf);
  if (field_vt__BCSM__CAMEL__TDP__CriteriaList.is_present())
    field_vt__BCSM__CAMEL__TDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf);
  if (field_tif__CSI.is_present())
    field_tif__CSI.OER_encode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_buf);
  if (field_tif__CSI__NotificationToCSE.is_present())
    field_tif__CSI__NotificationToCSE.OER_encode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_buf);
  if (field_gprs__CSI.is_present())
    field_gprs__CSI.OER_encode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_buf);
  if (field_mo__sms__CSI.is_present())
    field_mo__sms__CSI.OER_encode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_buf);
  if (field_ss__CSI.is_present())
    field_ss__CSI.OER_encode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_buf);
  if (field_m__CSI.is_present())
    field_m__CSI.OER_encode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_specificCSIDeletedList.is_present()) {
      c |= 128;
      field_specificCSIDeletedList.OER_encode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_mt__sms__CSI.is_present()) {
      c |= 64;
      field_mt__sms__CSI.OER_encode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_mt__smsCAMELTDP__CriteriaList.is_present()) {
      c |= 32;
      field_mt__smsCAMELTDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_mg__csi.is_present()) {
      c |= 16;
      field_mg__csi.OER_encode(CAMEL__SubscriptionInfo_mg__csi_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_o__IM__CSI.is_present()) {
      c |= 8;
      field_o__IM__CSI.OER_encode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_o__IM__BcsmCamelTDP__CriteriaList.is_present()) {
      c |= 4;
      field_o__IM__BcsmCamelTDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_d__IM__CSI.is_present()) {
      c |= 2;
      field_d__IM__CSI.OER_encode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_vt__IM__CSI.is_present()) {
      c |= 1;
      field_vt__IM__CSI.OER_encode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_present()) {
      c |= 128;
      field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.OER_encode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(7);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int CAMEL__SubscriptionInfo::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(2);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_o__CSI.OER_decode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_buf, p_oer);
 else
    field_o__CSI = OMIT_VALUE;
  if (uc[0] & 32)
    field_o__BcsmCamelTDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_buf, p_oer);
 else
    field_o__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
  if (uc[0] & 16)
    field_d__CSI.OER_decode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_buf, p_oer);
 else
    field_d__CSI = OMIT_VALUE;
  if (uc[0] & 8)
    field_t__CSI.OER_decode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_buf, p_oer);
 else
    field_t__CSI = OMIT_VALUE;
  if (uc[0] & 4)
    field_t__BCSM__CAMEL__TDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_oer);
 else
    field_t__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  if (uc[0] & 2)
    field_vt__CSI.OER_decode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_buf, p_oer);
 else
    field_vt__CSI = OMIT_VALUE;
  if (uc[0] & 1)
    field_vt__BCSM__CAMEL__TDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_oer);
 else
    field_vt__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  if (uc[1] & 128)
    field_tif__CSI.OER_decode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_buf, p_oer);
 else
    field_tif__CSI = OMIT_VALUE;
  if (uc[1] & 64)
    field_tif__CSI__NotificationToCSE.OER_decode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_buf, p_oer);
 else
    field_tif__CSI__NotificationToCSE = OMIT_VALUE;
  if (uc[1] & 32)
    field_gprs__CSI.OER_decode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_buf, p_oer);
 else
    field_gprs__CSI = OMIT_VALUE;
  if (uc[1] & 16)
    field_mo__sms__CSI.OER_decode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_buf, p_oer);
 else
    field_mo__sms__CSI = OMIT_VALUE;
  if (uc[1] & 8)
    field_ss__CSI.OER_decode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_buf, p_oer);
 else
    field_ss__CSI = OMIT_VALUE;
  if (uc[1] & 4)
    field_m__CSI.OER_decode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_buf, p_oer);
 else
    field_m__CSI = OMIT_VALUE;
  if (uc[1] & 2)
    field_extensionContainer.OER_decode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_specificCSIDeletedList = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_specificCSIDeletedList.OER_decode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_mt__sms__CSI = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mt__sms__CSI.OER_decode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_mt__smsCAMELTDP__CriteriaList = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mt__smsCAMELTDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_mg__csi = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mg__csi.OER_decode(CAMEL__SubscriptionInfo_mg__csi_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_o__IM__CSI = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_o__IM__CSI.OER_decode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_o__IM__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_o__IM__BcsmCamelTDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_d__IM__CSI = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_d__IM__CSI.OER_decode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_vt__IM__CSI = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_vt__IM__CSI.OER_decode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.OER_decode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_oer);
    }
  }
  else {
    field_specificCSIDeletedList = OMIT_VALUE;
    field_mt__sms__CSI = OMIT_VALUE;
    field_mt__smsCAMELTDP__CriteriaList = OMIT_VALUE;
    field_mg__csi = OMIT_VALUE;
    field_o__IM__CSI = OMIT_VALUE;
    field_o__IM__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
    field_d__IM__CSI = OMIT_VALUE;
    field_vt__IM__CSI = OMIT_VALUE;
    field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
  }
  return 0;
}

void CAMEL__SubscriptionInfo::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_specificCSIDeletedList.is_present();
boolean ext_1_present = field_mt__sms__CSI.is_present();
boolean ext_2_present = field_mt__smsCAMELTDP__CriteriaList.is_present();
boolean ext_3_present = field_mg__csi.is_present();
boolean ext_4_present = field_o__IM__CSI.is_present();
boolean ext_5_present = field_o__IM__BcsmCamelTDP__CriteriaList.is_present();
boolean ext_6_present = field_d__IM__CSI.is_present();
boolean ext_7_present = field_vt__IM__CSI.is_present();
boolean ext_8_present = field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present;
p_buf.PER_put_bit(ext_bit);
boolean field_o__CSI_present = field_o__CSI.is_present();
p_buf.PER_put_bit(field_o__CSI_present);
boolean field_o__BcsmCamelTDP__CriteriaList_present = field_o__BcsmCamelTDP__CriteriaList.is_present();
p_buf.PER_put_bit(field_o__BcsmCamelTDP__CriteriaList_present);
boolean field_d__CSI_present = field_d__CSI.is_present();
p_buf.PER_put_bit(field_d__CSI_present);
boolean field_t__CSI_present = field_t__CSI.is_present();
p_buf.PER_put_bit(field_t__CSI_present);
boolean field_t__BCSM__CAMEL__TDP__CriteriaList_present = field_t__BCSM__CAMEL__TDP__CriteriaList.is_present();
p_buf.PER_put_bit(field_t__BCSM__CAMEL__TDP__CriteriaList_present);
boolean field_vt__CSI_present = field_vt__CSI.is_present();
p_buf.PER_put_bit(field_vt__CSI_present);
boolean field_vt__BCSM__CAMEL__TDP__CriteriaList_present = field_vt__BCSM__CAMEL__TDP__CriteriaList.is_present();
p_buf.PER_put_bit(field_vt__BCSM__CAMEL__TDP__CriteriaList_present);
boolean field_tif__CSI_present = field_tif__CSI.is_present();
p_buf.PER_put_bit(field_tif__CSI_present);
boolean field_tif__CSI__NotificationToCSE_present = field_tif__CSI__NotificationToCSE.is_present();
p_buf.PER_put_bit(field_tif__CSI__NotificationToCSE_present);
boolean field_gprs__CSI_present = field_gprs__CSI.is_present();
p_buf.PER_put_bit(field_gprs__CSI_present);
boolean field_mo__sms__CSI_present = field_mo__sms__CSI.is_present();
p_buf.PER_put_bit(field_mo__sms__CSI_present);
boolean field_ss__CSI_present = field_ss__CSI.is_present();
p_buf.PER_put_bit(field_ss__CSI_present);
boolean field_m__CSI_present = field_m__CSI.is_present();
p_buf.PER_put_bit(field_m__CSI_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_o__CSI_present) field_o__CSI.PER_encode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_buf, p_options);
if (field_o__BcsmCamelTDP__CriteriaList_present) field_o__BcsmCamelTDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_buf, p_options);
if (field_d__CSI_present) field_d__CSI.PER_encode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_buf, p_options);
if (field_t__CSI_present) field_t__CSI.PER_encode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_buf, p_options);
if (field_t__BCSM__CAMEL__TDP__CriteriaList_present) field_t__BCSM__CAMEL__TDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_options);
if (field_vt__CSI_present) field_vt__CSI.PER_encode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_buf, p_options);
if (field_vt__BCSM__CAMEL__TDP__CriteriaList_present) field_vt__BCSM__CAMEL__TDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_options);
if (field_tif__CSI_present) field_tif__CSI.PER_encode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_buf, p_options);
if (field_tif__CSI__NotificationToCSE_present) field_tif__CSI__NotificationToCSE.PER_encode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_buf, p_options);
if (field_gprs__CSI_present) field_gprs__CSI.PER_encode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_buf, p_options);
if (field_mo__sms__CSI_present) field_mo__sms__CSI.PER_encode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_buf, p_options);
if (field_ss__CSI_present) field_ss__CSI.PER_encode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_buf, p_options);
if (field_m__CSI_present) field_m__CSI.PER_encode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(9);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_specificCSIDeletedList.PER_encode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_mt__sms__CSI.PER_encode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_mt__smsCAMELTDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_mg__csi.PER_encode(CAMEL__SubscriptionInfo_mg__csi_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_o__IM__CSI.PER_encode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_o__IM__BcsmCamelTDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_d__IM__CSI.PER_encode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_vt__IM__CSI.PER_encode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.PER_encode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void CAMEL__SubscriptionInfo::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_o__CSI_present = p_buf.PER_get_bit();
boolean field_o__BcsmCamelTDP__CriteriaList_present = p_buf.PER_get_bit();
boolean field_d__CSI_present = p_buf.PER_get_bit();
boolean field_t__CSI_present = p_buf.PER_get_bit();
boolean field_t__BCSM__CAMEL__TDP__CriteriaList_present = p_buf.PER_get_bit();
boolean field_vt__CSI_present = p_buf.PER_get_bit();
boolean field_vt__BCSM__CAMEL__TDP__CriteriaList_present = p_buf.PER_get_bit();
boolean field_tif__CSI_present = p_buf.PER_get_bit();
boolean field_tif__CSI__NotificationToCSE_present = p_buf.PER_get_bit();
boolean field_gprs__CSI_present = p_buf.PER_get_bit();
boolean field_mo__sms__CSI_present = p_buf.PER_get_bit();
boolean field_ss__CSI_present = p_buf.PER_get_bit();
boolean field_m__CSI_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_o__CSI_present) field_o__CSI.PER_decode(CAMEL__SubscriptionInfo_o__CSI_descr_, p_buf, p_options);
else field_o__CSI = OMIT_VALUE;
if (field_o__BcsmCamelTDP__CriteriaList_present) field_o__BcsmCamelTDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_o__BcsmCamelTDP__CriteriaList_descr_, p_buf, p_options);
else field_o__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
if (field_d__CSI_present) field_d__CSI.PER_decode(CAMEL__SubscriptionInfo_d__CSI_descr_, p_buf, p_options);
else field_d__CSI = OMIT_VALUE;
if (field_t__CSI_present) field_t__CSI.PER_decode(CAMEL__SubscriptionInfo_t__CSI_descr_, p_buf, p_options);
else field_t__CSI = OMIT_VALUE;
if (field_t__BCSM__CAMEL__TDP__CriteriaList_present) field_t__BCSM__CAMEL__TDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_t__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_options);
else field_t__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
if (field_vt__CSI_present) field_vt__CSI.PER_decode(CAMEL__SubscriptionInfo_vt__CSI_descr_, p_buf, p_options);
else field_vt__CSI = OMIT_VALUE;
if (field_vt__BCSM__CAMEL__TDP__CriteriaList_present) field_vt__BCSM__CAMEL__TDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_vt__BCSM__CAMEL__TDP__CriteriaList_descr_, p_buf, p_options);
else field_vt__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
if (field_tif__CSI_present) field_tif__CSI.PER_decode(CAMEL__SubscriptionInfo_tif__CSI_descr_, p_buf, p_options);
else field_tif__CSI = OMIT_VALUE;
if (field_tif__CSI__NotificationToCSE_present) field_tif__CSI__NotificationToCSE.PER_decode(CAMEL__SubscriptionInfo_tif__CSI__NotificationToCSE_descr_, p_buf, p_options);
else field_tif__CSI__NotificationToCSE = OMIT_VALUE;
if (field_gprs__CSI_present) field_gprs__CSI.PER_decode(CAMEL__SubscriptionInfo_gprs__CSI_descr_, p_buf, p_options);
else field_gprs__CSI = OMIT_VALUE;
if (field_mo__sms__CSI_present) field_mo__sms__CSI.PER_decode(CAMEL__SubscriptionInfo_mo__sms__CSI_descr_, p_buf, p_options);
else field_mo__sms__CSI = OMIT_VALUE;
if (field_ss__CSI_present) field_ss__CSI.PER_decode(CAMEL__SubscriptionInfo_ss__CSI_descr_, p_buf, p_options);
else field_ss__CSI = OMIT_VALUE;
if (field_m__CSI_present) field_m__CSI.PER_decode(CAMEL__SubscriptionInfo_m__CSI_descr_, p_buf, p_options);
else field_m__CSI = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(CAMEL__SubscriptionInfo_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 9) {
for (int i = nof_decoded_ext_adds; i < 9; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_specificCSIDeletedList.PER_decode(CAMEL__SubscriptionInfo_specificCSIDeletedList_descr_, ext_add_buf, p_options);
}
else {
field_specificCSIDeletedList = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mt__sms__CSI.PER_decode(CAMEL__SubscriptionInfo_mt__sms__CSI_descr_, ext_add_buf, p_options);
}
else {
field_mt__sms__CSI = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mt__smsCAMELTDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_mt__smsCAMELTDP__CriteriaList_descr_, ext_add_buf, p_options);
}
else {
field_mt__smsCAMELTDP__CriteriaList = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mg__csi.PER_decode(CAMEL__SubscriptionInfo_mg__csi_descr_, ext_add_buf, p_options);
}
else {
field_mg__csi = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_o__IM__CSI.PER_decode(CAMEL__SubscriptionInfo_o__IM__CSI_descr_, ext_add_buf, p_options);
}
else {
field_o__IM__CSI = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_o__IM__BcsmCamelTDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_o__IM__BcsmCamelTDP__CriteriaList_descr_, ext_add_buf, p_options);
}
else {
field_o__IM__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_d__IM__CSI.PER_decode(CAMEL__SubscriptionInfo_d__IM__CSI_descr_, ext_add_buf, p_options);
}
else {
field_d__IM__CSI = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_vt__IM__CSI.PER_decode(CAMEL__SubscriptionInfo_vt__IM__CSI_descr_, ext_add_buf, p_options);
}
else {
field_vt__IM__CSI = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.PER_decode(CAMEL__SubscriptionInfo_vt__IM__BCSM__CAMEL__TDP__CriteriaList_descr_, ext_add_buf, p_options);
}
else {
field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 9) for (int i = 9; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct CAMEL__SubscriptionInfo_template::single_value_struct {
O__CSI_template field_o__CSI;
O__BcsmCamelTDPCriteriaList_template field_o__BcsmCamelTDP__CriteriaList;
D__CSI_template field_d__CSI;
T__CSI_template field_t__CSI;
T__BCSM__CAMEL__TDP__CriteriaList_template field_t__BCSM__CAMEL__TDP__CriteriaList;
T__CSI_template field_vt__CSI;
T__BCSM__CAMEL__TDP__CriteriaList_template field_vt__BCSM__CAMEL__TDP__CriteriaList;
ASN_NULL_template field_tif__CSI;
ASN_NULL_template field_tif__CSI__NotificationToCSE;
GPRS__CSI_template field_gprs__CSI;
SMS__CSI_template field_mo__sms__CSI;
SS__CSI_template field_ss__CSI;
M__CSI_template field_m__CSI;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
BITSTRING_template field_specificCSIDeletedList;
SMS__CSI_template field_mt__sms__CSI;
MT__smsCAMELTDP__CriteriaList_template field_mt__smsCAMELTDP__CriteriaList;
MG__CSI_template field_mg__csi;
O__CSI_template field_o__IM__CSI;
O__BcsmCamelTDPCriteriaList_template field_o__IM__BcsmCamelTDP__CriteriaList;
D__CSI_template field_d__IM__CSI;
T__CSI_template field_vt__IM__CSI;
T__BCSM__CAMEL__TDP__CriteriaList_template field_vt__IM__BCSM__CAMEL__TDP__CriteriaList;
};

void CAMEL__SubscriptionInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_o__CSI = ANY_OR_OMIT;
single_value->field_o__BcsmCamelTDP__CriteriaList = ANY_OR_OMIT;
single_value->field_d__CSI = ANY_OR_OMIT;
single_value->field_t__CSI = ANY_OR_OMIT;
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList = ANY_OR_OMIT;
single_value->field_vt__CSI = ANY_OR_OMIT;
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList = ANY_OR_OMIT;
single_value->field_tif__CSI = ANY_OR_OMIT;
single_value->field_tif__CSI__NotificationToCSE = ANY_OR_OMIT;
single_value->field_gprs__CSI = ANY_OR_OMIT;
single_value->field_mo__sms__CSI = ANY_OR_OMIT;
single_value->field_ss__CSI = ANY_OR_OMIT;
single_value->field_m__CSI = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_specificCSIDeletedList = ANY_OR_OMIT;
single_value->field_mt__sms__CSI = ANY_OR_OMIT;
single_value->field_mt__smsCAMELTDP__CriteriaList = ANY_OR_OMIT;
single_value->field_mg__csi = ANY_OR_OMIT;
single_value->field_o__IM__CSI = ANY_OR_OMIT;
single_value->field_o__IM__BcsmCamelTDP__CriteriaList = ANY_OR_OMIT;
single_value->field_d__IM__CSI = ANY_OR_OMIT;
single_value->field_vt__IM__CSI = ANY_OR_OMIT;
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = ANY_OR_OMIT;
}
}
}

void CAMEL__SubscriptionInfo_template::copy_value(const CAMEL__SubscriptionInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.o__CSI().is_bound()) {
  if (other_value.o__CSI().ispresent()) single_value->field_o__CSI = other_value.o__CSI()();
  else single_value->field_o__CSI = OMIT_VALUE;
} else {
  single_value->field_o__CSI.clean_up();
}
if (other_value.o__BcsmCamelTDP__CriteriaList().is_bound()) {
  if (other_value.o__BcsmCamelTDP__CriteriaList().ispresent()) single_value->field_o__BcsmCamelTDP__CriteriaList = other_value.o__BcsmCamelTDP__CriteriaList()();
  else single_value->field_o__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_o__BcsmCamelTDP__CriteriaList.clean_up();
}
if (other_value.d__CSI().is_bound()) {
  if (other_value.d__CSI().ispresent()) single_value->field_d__CSI = other_value.d__CSI()();
  else single_value->field_d__CSI = OMIT_VALUE;
} else {
  single_value->field_d__CSI.clean_up();
}
if (other_value.t__CSI().is_bound()) {
  if (other_value.t__CSI().ispresent()) single_value->field_t__CSI = other_value.t__CSI()();
  else single_value->field_t__CSI = OMIT_VALUE;
} else {
  single_value->field_t__CSI.clean_up();
}
if (other_value.t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) {
  if (other_value.t__BCSM__CAMEL__TDP__CriteriaList().ispresent()) single_value->field_t__BCSM__CAMEL__TDP__CriteriaList = other_value.t__BCSM__CAMEL__TDP__CriteriaList()();
  else single_value->field_t__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
if (other_value.vt__CSI().is_bound()) {
  if (other_value.vt__CSI().ispresent()) single_value->field_vt__CSI = other_value.vt__CSI()();
  else single_value->field_vt__CSI = OMIT_VALUE;
} else {
  single_value->field_vt__CSI.clean_up();
}
if (other_value.vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) {
  if (other_value.vt__BCSM__CAMEL__TDP__CriteriaList().ispresent()) single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__BCSM__CAMEL__TDP__CriteriaList()();
  else single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
if (other_value.tif__CSI().is_bound()) {
  if (other_value.tif__CSI().ispresent()) single_value->field_tif__CSI = other_value.tif__CSI()();
  else single_value->field_tif__CSI = OMIT_VALUE;
} else {
  single_value->field_tif__CSI.clean_up();
}
if (other_value.tif__CSI__NotificationToCSE().is_bound()) {
  if (other_value.tif__CSI__NotificationToCSE().ispresent()) single_value->field_tif__CSI__NotificationToCSE = other_value.tif__CSI__NotificationToCSE()();
  else single_value->field_tif__CSI__NotificationToCSE = OMIT_VALUE;
} else {
  single_value->field_tif__CSI__NotificationToCSE.clean_up();
}
if (other_value.gprs__CSI().is_bound()) {
  if (other_value.gprs__CSI().ispresent()) single_value->field_gprs__CSI = other_value.gprs__CSI()();
  else single_value->field_gprs__CSI = OMIT_VALUE;
} else {
  single_value->field_gprs__CSI.clean_up();
}
if (other_value.mo__sms__CSI().is_bound()) {
  if (other_value.mo__sms__CSI().ispresent()) single_value->field_mo__sms__CSI = other_value.mo__sms__CSI()();
  else single_value->field_mo__sms__CSI = OMIT_VALUE;
} else {
  single_value->field_mo__sms__CSI.clean_up();
}
if (other_value.ss__CSI().is_bound()) {
  if (other_value.ss__CSI().ispresent()) single_value->field_ss__CSI = other_value.ss__CSI()();
  else single_value->field_ss__CSI = OMIT_VALUE;
} else {
  single_value->field_ss__CSI.clean_up();
}
if (other_value.m__CSI().is_bound()) {
  if (other_value.m__CSI().ispresent()) single_value->field_m__CSI = other_value.m__CSI()();
  else single_value->field_m__CSI = OMIT_VALUE;
} else {
  single_value->field_m__CSI.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.specificCSIDeletedList().is_bound()) {
  if (other_value.specificCSIDeletedList().ispresent()) single_value->field_specificCSIDeletedList = other_value.specificCSIDeletedList()();
  else single_value->field_specificCSIDeletedList = OMIT_VALUE;
} else {
  single_value->field_specificCSIDeletedList.clean_up();
}
if (other_value.mt__sms__CSI().is_bound()) {
  if (other_value.mt__sms__CSI().ispresent()) single_value->field_mt__sms__CSI = other_value.mt__sms__CSI()();
  else single_value->field_mt__sms__CSI = OMIT_VALUE;
} else {
  single_value->field_mt__sms__CSI.clean_up();
}
if (other_value.mt__smsCAMELTDP__CriteriaList().is_bound()) {
  if (other_value.mt__smsCAMELTDP__CriteriaList().ispresent()) single_value->field_mt__smsCAMELTDP__CriteriaList = other_value.mt__smsCAMELTDP__CriteriaList()();
  else single_value->field_mt__smsCAMELTDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_mt__smsCAMELTDP__CriteriaList.clean_up();
}
if (other_value.mg__csi().is_bound()) {
  if (other_value.mg__csi().ispresent()) single_value->field_mg__csi = other_value.mg__csi()();
  else single_value->field_mg__csi = OMIT_VALUE;
} else {
  single_value->field_mg__csi.clean_up();
}
if (other_value.o__IM__CSI().is_bound()) {
  if (other_value.o__IM__CSI().ispresent()) single_value->field_o__IM__CSI = other_value.o__IM__CSI()();
  else single_value->field_o__IM__CSI = OMIT_VALUE;
} else {
  single_value->field_o__IM__CSI.clean_up();
}
if (other_value.o__IM__BcsmCamelTDP__CriteriaList().is_bound()) {
  if (other_value.o__IM__BcsmCamelTDP__CriteriaList().ispresent()) single_value->field_o__IM__BcsmCamelTDP__CriteriaList = other_value.o__IM__BcsmCamelTDP__CriteriaList()();
  else single_value->field_o__IM__BcsmCamelTDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_o__IM__BcsmCamelTDP__CriteriaList.clean_up();
}
if (other_value.d__IM__CSI().is_bound()) {
  if (other_value.d__IM__CSI().ispresent()) single_value->field_d__IM__CSI = other_value.d__IM__CSI()();
  else single_value->field_d__IM__CSI = OMIT_VALUE;
} else {
  single_value->field_d__IM__CSI.clean_up();
}
if (other_value.vt__IM__CSI().is_bound()) {
  if (other_value.vt__IM__CSI().ispresent()) single_value->field_vt__IM__CSI = other_value.vt__IM__CSI()();
  else single_value->field_vt__IM__CSI = OMIT_VALUE;
} else {
  single_value->field_vt__IM__CSI.clean_up();
}
if (other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) {
  if (other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().ispresent()) single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList()();
  else single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = OMIT_VALUE;
} else {
  single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CAMEL__SubscriptionInfo_template::copy_template(const CAMEL__SubscriptionInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.o__CSI().get_selection()) {
single_value->field_o__CSI = other_value.o__CSI();
} else {
single_value->field_o__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.o__BcsmCamelTDP__CriteriaList().get_selection()) {
single_value->field_o__BcsmCamelTDP__CriteriaList = other_value.o__BcsmCamelTDP__CriteriaList();
} else {
single_value->field_o__BcsmCamelTDP__CriteriaList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.d__CSI().get_selection()) {
single_value->field_d__CSI = other_value.d__CSI();
} else {
single_value->field_d__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t__CSI().get_selection()) {
single_value->field_t__CSI = other_value.t__CSI();
} else {
single_value->field_t__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t__BCSM__CAMEL__TDP__CriteriaList().get_selection()) {
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList = other_value.t__BCSM__CAMEL__TDP__CriteriaList();
} else {
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vt__CSI().get_selection()) {
single_value->field_vt__CSI = other_value.vt__CSI();
} else {
single_value->field_vt__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vt__BCSM__CAMEL__TDP__CriteriaList().get_selection()) {
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__BCSM__CAMEL__TDP__CriteriaList();
} else {
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tif__CSI().get_selection()) {
single_value->field_tif__CSI = other_value.tif__CSI();
} else {
single_value->field_tif__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tif__CSI__NotificationToCSE().get_selection()) {
single_value->field_tif__CSI__NotificationToCSE = other_value.tif__CSI__NotificationToCSE();
} else {
single_value->field_tif__CSI__NotificationToCSE.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gprs__CSI().get_selection()) {
single_value->field_gprs__CSI = other_value.gprs__CSI();
} else {
single_value->field_gprs__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mo__sms__CSI().get_selection()) {
single_value->field_mo__sms__CSI = other_value.mo__sms__CSI();
} else {
single_value->field_mo__sms__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__CSI().get_selection()) {
single_value->field_ss__CSI = other_value.ss__CSI();
} else {
single_value->field_ss__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.m__CSI().get_selection()) {
single_value->field_m__CSI = other_value.m__CSI();
} else {
single_value->field_m__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.specificCSIDeletedList().get_selection()) {
single_value->field_specificCSIDeletedList = other_value.specificCSIDeletedList();
} else {
single_value->field_specificCSIDeletedList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mt__sms__CSI().get_selection()) {
single_value->field_mt__sms__CSI = other_value.mt__sms__CSI();
} else {
single_value->field_mt__sms__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mt__smsCAMELTDP__CriteriaList().get_selection()) {
single_value->field_mt__smsCAMELTDP__CriteriaList = other_value.mt__smsCAMELTDP__CriteriaList();
} else {
single_value->field_mt__smsCAMELTDP__CriteriaList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mg__csi().get_selection()) {
single_value->field_mg__csi = other_value.mg__csi();
} else {
single_value->field_mg__csi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.o__IM__CSI().get_selection()) {
single_value->field_o__IM__CSI = other_value.o__IM__CSI();
} else {
single_value->field_o__IM__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.o__IM__BcsmCamelTDP__CriteriaList().get_selection()) {
single_value->field_o__IM__BcsmCamelTDP__CriteriaList = other_value.o__IM__BcsmCamelTDP__CriteriaList();
} else {
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.d__IM__CSI().get_selection()) {
single_value->field_d__IM__CSI = other_value.d__IM__CSI();
} else {
single_value->field_d__IM__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vt__IM__CSI().get_selection()) {
single_value->field_vt__IM__CSI = other_value.vt__IM__CSI();
} else {
single_value->field_vt__IM__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().get_selection()) {
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList = other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList();
} else {
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CAMEL__SubscriptionInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CAMEL__SubscriptionInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new CAMEL__SubscriptionInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
break;
}
set_selection(other_value);
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template()
{
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(const CAMEL__SubscriptionInfo& other_value)
{
copy_value(other_value);
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(const OPTIONAL<CAMEL__SubscriptionInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CAMEL__SubscriptionInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo from an unbound optional field.");
}
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(CAMEL__SubscriptionInfo_template* p_precondition, CAMEL__SubscriptionInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(Dynamic_Match_Interface<CAMEL__SubscriptionInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CAMEL__SubscriptionInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CAMEL__SubscriptionInfo_template::CAMEL__SubscriptionInfo_template(const CAMEL__SubscriptionInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CAMEL__SubscriptionInfo_template::~CAMEL__SubscriptionInfo_template()
{
clean_up();
}

CAMEL__SubscriptionInfo_template& CAMEL__SubscriptionInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CAMEL__SubscriptionInfo_template& CAMEL__SubscriptionInfo_template::operator=(const CAMEL__SubscriptionInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CAMEL__SubscriptionInfo_template& CAMEL__SubscriptionInfo_template::operator=(const OPTIONAL<CAMEL__SubscriptionInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CAMEL__SubscriptionInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
}
return *this;
}

CAMEL__SubscriptionInfo_template& CAMEL__SubscriptionInfo_template::operator=(const CAMEL__SubscriptionInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CAMEL__SubscriptionInfo_template::match(const CAMEL__SubscriptionInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.o__CSI().is_bound()) return FALSE;
if((other_value.o__CSI().ispresent() ? !single_value->field_o__CSI.match((const O__CSI&)other_value.o__CSI(), legacy) : !single_value->field_o__CSI.match_omit(legacy)))return FALSE;
if(!other_value.o__BcsmCamelTDP__CriteriaList().is_bound()) return FALSE;
if((other_value.o__BcsmCamelTDP__CriteriaList().ispresent() ? !single_value->field_o__BcsmCamelTDP__CriteriaList.match((const O__BcsmCamelTDPCriteriaList&)other_value.o__BcsmCamelTDP__CriteriaList(), legacy) : !single_value->field_o__BcsmCamelTDP__CriteriaList.match_omit(legacy)))return FALSE;
if(!other_value.d__CSI().is_bound()) return FALSE;
if((other_value.d__CSI().ispresent() ? !single_value->field_d__CSI.match((const D__CSI&)other_value.d__CSI(), legacy) : !single_value->field_d__CSI.match_omit(legacy)))return FALSE;
if(!other_value.t__CSI().is_bound()) return FALSE;
if((other_value.t__CSI().ispresent() ? !single_value->field_t__CSI.match((const T__CSI&)other_value.t__CSI(), legacy) : !single_value->field_t__CSI.match_omit(legacy)))return FALSE;
if(!other_value.t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) return FALSE;
if((other_value.t__BCSM__CAMEL__TDP__CriteriaList().ispresent() ? !single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.match((const T__BCSM__CAMEL__TDP__CriteriaList&)other_value.t__BCSM__CAMEL__TDP__CriteriaList(), legacy) : !single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)))return FALSE;
if(!other_value.vt__CSI().is_bound()) return FALSE;
if((other_value.vt__CSI().ispresent() ? !single_value->field_vt__CSI.match((const T__CSI&)other_value.vt__CSI(), legacy) : !single_value->field_vt__CSI.match_omit(legacy)))return FALSE;
if(!other_value.vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) return FALSE;
if((other_value.vt__BCSM__CAMEL__TDP__CriteriaList().ispresent() ? !single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.match((const T__BCSM__CAMEL__TDP__CriteriaList&)other_value.vt__BCSM__CAMEL__TDP__CriteriaList(), legacy) : !single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)))return FALSE;
if(!other_value.tif__CSI().is_bound()) return FALSE;
if((other_value.tif__CSI().ispresent() ? !single_value->field_tif__CSI.match((const ASN_NULL&)other_value.tif__CSI(), legacy) : !single_value->field_tif__CSI.match_omit(legacy)))return FALSE;
if(!other_value.tif__CSI__NotificationToCSE().is_bound()) return FALSE;
if((other_value.tif__CSI__NotificationToCSE().ispresent() ? !single_value->field_tif__CSI__NotificationToCSE.match((const ASN_NULL&)other_value.tif__CSI__NotificationToCSE(), legacy) : !single_value->field_tif__CSI__NotificationToCSE.match_omit(legacy)))return FALSE;
if(!other_value.gprs__CSI().is_bound()) return FALSE;
if((other_value.gprs__CSI().ispresent() ? !single_value->field_gprs__CSI.match((const GPRS__CSI&)other_value.gprs__CSI(), legacy) : !single_value->field_gprs__CSI.match_omit(legacy)))return FALSE;
if(!other_value.mo__sms__CSI().is_bound()) return FALSE;
if((other_value.mo__sms__CSI().ispresent() ? !single_value->field_mo__sms__CSI.match((const SMS__CSI&)other_value.mo__sms__CSI(), legacy) : !single_value->field_mo__sms__CSI.match_omit(legacy)))return FALSE;
if(!other_value.ss__CSI().is_bound()) return FALSE;
if((other_value.ss__CSI().ispresent() ? !single_value->field_ss__CSI.match((const SS__CSI&)other_value.ss__CSI(), legacy) : !single_value->field_ss__CSI.match_omit(legacy)))return FALSE;
if(!other_value.m__CSI().is_bound()) return FALSE;
if((other_value.m__CSI().ispresent() ? !single_value->field_m__CSI.match((const M__CSI&)other_value.m__CSI(), legacy) : !single_value->field_m__CSI.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.specificCSIDeletedList().is_bound()) return FALSE;
if((other_value.specificCSIDeletedList().ispresent() ? !single_value->field_specificCSIDeletedList.match((const BITSTRING&)other_value.specificCSIDeletedList(), legacy) : !single_value->field_specificCSIDeletedList.match_omit(legacy)))return FALSE;
if(!other_value.mt__sms__CSI().is_bound()) return FALSE;
if((other_value.mt__sms__CSI().ispresent() ? !single_value->field_mt__sms__CSI.match((const SMS__CSI&)other_value.mt__sms__CSI(), legacy) : !single_value->field_mt__sms__CSI.match_omit(legacy)))return FALSE;
if(!other_value.mt__smsCAMELTDP__CriteriaList().is_bound()) return FALSE;
if((other_value.mt__smsCAMELTDP__CriteriaList().ispresent() ? !single_value->field_mt__smsCAMELTDP__CriteriaList.match((const MT__smsCAMELTDP__CriteriaList&)other_value.mt__smsCAMELTDP__CriteriaList(), legacy) : !single_value->field_mt__smsCAMELTDP__CriteriaList.match_omit(legacy)))return FALSE;
if(!other_value.mg__csi().is_bound()) return FALSE;
if((other_value.mg__csi().ispresent() ? !single_value->field_mg__csi.match((const MG__CSI&)other_value.mg__csi(), legacy) : !single_value->field_mg__csi.match_omit(legacy)))return FALSE;
if(!other_value.o__IM__CSI().is_bound()) return FALSE;
if((other_value.o__IM__CSI().ispresent() ? !single_value->field_o__IM__CSI.match((const O__CSI&)other_value.o__IM__CSI(), legacy) : !single_value->field_o__IM__CSI.match_omit(legacy)))return FALSE;
if(!other_value.o__IM__BcsmCamelTDP__CriteriaList().is_bound()) return FALSE;
if((other_value.o__IM__BcsmCamelTDP__CriteriaList().ispresent() ? !single_value->field_o__IM__BcsmCamelTDP__CriteriaList.match((const O__BcsmCamelTDPCriteriaList&)other_value.o__IM__BcsmCamelTDP__CriteriaList(), legacy) : !single_value->field_o__IM__BcsmCamelTDP__CriteriaList.match_omit(legacy)))return FALSE;
if(!other_value.d__IM__CSI().is_bound()) return FALSE;
if((other_value.d__IM__CSI().ispresent() ? !single_value->field_d__IM__CSI.match((const D__CSI&)other_value.d__IM__CSI(), legacy) : !single_value->field_d__IM__CSI.match_omit(legacy)))return FALSE;
if(!other_value.vt__IM__CSI().is_bound()) return FALSE;
if((other_value.vt__IM__CSI().ispresent() ? !single_value->field_vt__IM__CSI.match((const T__CSI&)other_value.vt__IM__CSI(), legacy) : !single_value->field_vt__IM__CSI.match_omit(legacy)))return FALSE;
if(!other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) return FALSE;
if((other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().ispresent() ? !single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.match((const T__BCSM__CAMEL__TDP__CriteriaList&)other_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList(), legacy) : !single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
}
return FALSE;
}

boolean CAMEL__SubscriptionInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_o__CSI.is_omit() || single_value->field_o__CSI.is_bound())
 || (single_value->field_o__BcsmCamelTDP__CriteriaList.is_omit() || single_value->field_o__BcsmCamelTDP__CriteriaList.is_bound())
 || (single_value->field_d__CSI.is_omit() || single_value->field_d__CSI.is_bound())
 || (single_value->field_t__CSI.is_omit() || single_value->field_t__CSI.is_bound())
 || (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_bound())
 || (single_value->field_vt__CSI.is_omit() || single_value->field_vt__CSI.is_bound())
 || (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_bound())
 || (single_value->field_tif__CSI.is_omit() || single_value->field_tif__CSI.is_bound())
 || (single_value->field_tif__CSI__NotificationToCSE.is_omit() || single_value->field_tif__CSI__NotificationToCSE.is_bound())
 || (single_value->field_gprs__CSI.is_omit() || single_value->field_gprs__CSI.is_bound())
 || (single_value->field_mo__sms__CSI.is_omit() || single_value->field_mo__sms__CSI.is_bound())
 || (single_value->field_ss__CSI.is_omit() || single_value->field_ss__CSI.is_bound())
 || (single_value->field_m__CSI.is_omit() || single_value->field_m__CSI.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_specificCSIDeletedList.is_omit() || single_value->field_specificCSIDeletedList.is_bound())
 || (single_value->field_mt__sms__CSI.is_omit() || single_value->field_mt__sms__CSI.is_bound())
 || (single_value->field_mt__smsCAMELTDP__CriteriaList.is_omit() || single_value->field_mt__smsCAMELTDP__CriteriaList.is_bound())
 || (single_value->field_mg__csi.is_omit() || single_value->field_mg__csi.is_bound())
 || (single_value->field_o__IM__CSI.is_omit() || single_value->field_o__IM__CSI.is_bound())
 || (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_omit() || single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_bound())
 || (single_value->field_d__IM__CSI.is_omit() || single_value->field_d__IM__CSI.is_bound())
 || (single_value->field_vt__IM__CSI.is_omit() || single_value->field_vt__IM__CSI.is_bound())
 || (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_bound());
}

boolean CAMEL__SubscriptionInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_o__CSI.is_omit() || single_value->field_o__CSI.is_value())
 && (single_value->field_o__BcsmCamelTDP__CriteriaList.is_omit() || single_value->field_o__BcsmCamelTDP__CriteriaList.is_value())
 && (single_value->field_d__CSI.is_omit() || single_value->field_d__CSI.is_value())
 && (single_value->field_t__CSI.is_omit() || single_value->field_t__CSI.is_value())
 && (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_value())
 && (single_value->field_vt__CSI.is_omit() || single_value->field_vt__CSI.is_value())
 && (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_value())
 && (single_value->field_tif__CSI.is_omit() || single_value->field_tif__CSI.is_value())
 && (single_value->field_tif__CSI__NotificationToCSE.is_omit() || single_value->field_tif__CSI__NotificationToCSE.is_value())
 && (single_value->field_gprs__CSI.is_omit() || single_value->field_gprs__CSI.is_value())
 && (single_value->field_mo__sms__CSI.is_omit() || single_value->field_mo__sms__CSI.is_value())
 && (single_value->field_ss__CSI.is_omit() || single_value->field_ss__CSI.is_value())
 && (single_value->field_m__CSI.is_omit() || single_value->field_m__CSI.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_specificCSIDeletedList.is_omit() || single_value->field_specificCSIDeletedList.is_value())
 && (single_value->field_mt__sms__CSI.is_omit() || single_value->field_mt__sms__CSI.is_value())
 && (single_value->field_mt__smsCAMELTDP__CriteriaList.is_omit() || single_value->field_mt__smsCAMELTDP__CriteriaList.is_value())
 && (single_value->field_mg__csi.is_omit() || single_value->field_mg__csi.is_value())
 && (single_value->field_o__IM__CSI.is_omit() || single_value->field_o__IM__CSI.is_value())
 && (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_omit() || single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_value())
 && (single_value->field_d__IM__CSI.is_omit() || single_value->field_d__IM__CSI.is_value())
 && (single_value->field_vt__IM__CSI.is_omit() || single_value->field_vt__IM__CSI.is_value())
 && (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_omit() || single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_value());
}

void CAMEL__SubscriptionInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CAMEL__SubscriptionInfo CAMEL__SubscriptionInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
CAMEL__SubscriptionInfo ret_val;
if (single_value->field_o__CSI.is_omit()) ret_val.o__CSI() = OMIT_VALUE;
else if (single_value->field_o__CSI.is_bound()) {
ret_val.o__CSI() = single_value->field_o__CSI.valueof();
}
if (single_value->field_o__BcsmCamelTDP__CriteriaList.is_omit()) ret_val.o__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_o__BcsmCamelTDP__CriteriaList.is_bound()) {
ret_val.o__BcsmCamelTDP__CriteriaList() = single_value->field_o__BcsmCamelTDP__CriteriaList.valueof();
}
if (single_value->field_d__CSI.is_omit()) ret_val.d__CSI() = OMIT_VALUE;
else if (single_value->field_d__CSI.is_bound()) {
ret_val.d__CSI() = single_value->field_d__CSI.valueof();
}
if (single_value->field_t__CSI.is_omit()) ret_val.t__CSI() = OMIT_VALUE;
else if (single_value->field_t__CSI.is_bound()) {
ret_val.t__CSI() = single_value->field_t__CSI.valueof();
}
if (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_omit()) ret_val.t__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_bound()) {
ret_val.t__BCSM__CAMEL__TDP__CriteriaList() = single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.valueof();
}
if (single_value->field_vt__CSI.is_omit()) ret_val.vt__CSI() = OMIT_VALUE;
else if (single_value->field_vt__CSI.is_bound()) {
ret_val.vt__CSI() = single_value->field_vt__CSI.valueof();
}
if (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_omit()) ret_val.vt__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_bound()) {
ret_val.vt__BCSM__CAMEL__TDP__CriteriaList() = single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.valueof();
}
if (single_value->field_tif__CSI.is_omit()) ret_val.tif__CSI() = OMIT_VALUE;
else if (single_value->field_tif__CSI.is_bound()) {
ret_val.tif__CSI() = single_value->field_tif__CSI.valueof();
}
if (single_value->field_tif__CSI__NotificationToCSE.is_omit()) ret_val.tif__CSI__NotificationToCSE() = OMIT_VALUE;
else if (single_value->field_tif__CSI__NotificationToCSE.is_bound()) {
ret_val.tif__CSI__NotificationToCSE() = single_value->field_tif__CSI__NotificationToCSE.valueof();
}
if (single_value->field_gprs__CSI.is_omit()) ret_val.gprs__CSI() = OMIT_VALUE;
else if (single_value->field_gprs__CSI.is_bound()) {
ret_val.gprs__CSI() = single_value->field_gprs__CSI.valueof();
}
if (single_value->field_mo__sms__CSI.is_omit()) ret_val.mo__sms__CSI() = OMIT_VALUE;
else if (single_value->field_mo__sms__CSI.is_bound()) {
ret_val.mo__sms__CSI() = single_value->field_mo__sms__CSI.valueof();
}
if (single_value->field_ss__CSI.is_omit()) ret_val.ss__CSI() = OMIT_VALUE;
else if (single_value->field_ss__CSI.is_bound()) {
ret_val.ss__CSI() = single_value->field_ss__CSI.valueof();
}
if (single_value->field_m__CSI.is_omit()) ret_val.m__CSI() = OMIT_VALUE;
else if (single_value->field_m__CSI.is_bound()) {
ret_val.m__CSI() = single_value->field_m__CSI.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_specificCSIDeletedList.is_omit()) ret_val.specificCSIDeletedList() = OMIT_VALUE;
else if (single_value->field_specificCSIDeletedList.is_bound()) {
ret_val.specificCSIDeletedList() = single_value->field_specificCSIDeletedList.valueof();
}
if (single_value->field_mt__sms__CSI.is_omit()) ret_val.mt__sms__CSI() = OMIT_VALUE;
else if (single_value->field_mt__sms__CSI.is_bound()) {
ret_val.mt__sms__CSI() = single_value->field_mt__sms__CSI.valueof();
}
if (single_value->field_mt__smsCAMELTDP__CriteriaList.is_omit()) ret_val.mt__smsCAMELTDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_mt__smsCAMELTDP__CriteriaList.is_bound()) {
ret_val.mt__smsCAMELTDP__CriteriaList() = single_value->field_mt__smsCAMELTDP__CriteriaList.valueof();
}
if (single_value->field_mg__csi.is_omit()) ret_val.mg__csi() = OMIT_VALUE;
else if (single_value->field_mg__csi.is_bound()) {
ret_val.mg__csi() = single_value->field_mg__csi.valueof();
}
if (single_value->field_o__IM__CSI.is_omit()) ret_val.o__IM__CSI() = OMIT_VALUE;
else if (single_value->field_o__IM__CSI.is_bound()) {
ret_val.o__IM__CSI() = single_value->field_o__IM__CSI.valueof();
}
if (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_omit()) ret_val.o__IM__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_bound()) {
ret_val.o__IM__BcsmCamelTDP__CriteriaList() = single_value->field_o__IM__BcsmCamelTDP__CriteriaList.valueof();
}
if (single_value->field_d__IM__CSI.is_omit()) ret_val.d__IM__CSI() = OMIT_VALUE;
else if (single_value->field_d__IM__CSI.is_bound()) {
ret_val.d__IM__CSI() = single_value->field_d__IM__CSI.valueof();
}
if (single_value->field_vt__IM__CSI.is_omit()) ret_val.vt__IM__CSI() = OMIT_VALUE;
else if (single_value->field_vt__IM__CSI.is_bound()) {
ret_val.vt__IM__CSI() = single_value->field_vt__IM__CSI.valueof();
}
if (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_omit()) ret_val.vt__IM__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else if (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_bound()) {
ret_val.vt__IM__BCSM__CAMEL__TDP__CriteriaList() = single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.valueof();
}
return ret_val;
}

void CAMEL__SubscriptionInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CAMEL__SubscriptionInfo_template[list_length];
}

CAMEL__SubscriptionInfo_template& CAMEL__SubscriptionInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return value_list.list_value[list_index];
}

O__CSI_template& CAMEL__SubscriptionInfo_template::o__CSI()
{
set_specific();
return single_value->field_o__CSI;
}

const O__CSI_template& CAMEL__SubscriptionInfo_template::o__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field o_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_o__CSI;
}

O__BcsmCamelTDPCriteriaList_template& CAMEL__SubscriptionInfo_template::o__BcsmCamelTDP__CriteriaList()
{
set_specific();
return single_value->field_o__BcsmCamelTDP__CriteriaList;
}

const O__BcsmCamelTDPCriteriaList_template& CAMEL__SubscriptionInfo_template::o__BcsmCamelTDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field o_BcsmCamelTDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_o__BcsmCamelTDP__CriteriaList;
}

D__CSI_template& CAMEL__SubscriptionInfo_template::d__CSI()
{
set_specific();
return single_value->field_d__CSI;
}

const D__CSI_template& CAMEL__SubscriptionInfo_template::d__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field d_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_d__CSI;
}

T__CSI_template& CAMEL__SubscriptionInfo_template::t__CSI()
{
set_specific();
return single_value->field_t__CSI;
}

const T__CSI_template& CAMEL__SubscriptionInfo_template::t__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_t__CSI;
}

T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::t__BCSM__CAMEL__TDP__CriteriaList()
{
set_specific();
return single_value->field_t__BCSM__CAMEL__TDP__CriteriaList;
}

const T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::t__BCSM__CAMEL__TDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t_BCSM_CAMEL_TDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_t__BCSM__CAMEL__TDP__CriteriaList;
}

T__CSI_template& CAMEL__SubscriptionInfo_template::vt__CSI()
{
set_specific();
return single_value->field_vt__CSI;
}

const T__CSI_template& CAMEL__SubscriptionInfo_template::vt__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vt_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_vt__CSI;
}

T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::vt__BCSM__CAMEL__TDP__CriteriaList()
{
set_specific();
return single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList;
}

const T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::vt__BCSM__CAMEL__TDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vt_BCSM_CAMEL_TDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList;
}

ASN_NULL_template& CAMEL__SubscriptionInfo_template::tif__CSI()
{
set_specific();
return single_value->field_tif__CSI;
}

const ASN_NULL_template& CAMEL__SubscriptionInfo_template::tif__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tif_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_tif__CSI;
}

ASN_NULL_template& CAMEL__SubscriptionInfo_template::tif__CSI__NotificationToCSE()
{
set_specific();
return single_value->field_tif__CSI__NotificationToCSE;
}

const ASN_NULL_template& CAMEL__SubscriptionInfo_template::tif__CSI__NotificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tif_CSI_NotificationToCSE of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_tif__CSI__NotificationToCSE;
}

GPRS__CSI_template& CAMEL__SubscriptionInfo_template::gprs__CSI()
{
set_specific();
return single_value->field_gprs__CSI;
}

const GPRS__CSI_template& CAMEL__SubscriptionInfo_template::gprs__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gprs_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_gprs__CSI;
}

SMS__CSI_template& CAMEL__SubscriptionInfo_template::mo__sms__CSI()
{
set_specific();
return single_value->field_mo__sms__CSI;
}

const SMS__CSI_template& CAMEL__SubscriptionInfo_template::mo__sms__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mo_sms_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_mo__sms__CSI;
}

SS__CSI_template& CAMEL__SubscriptionInfo_template::ss__CSI()
{
set_specific();
return single_value->field_ss__CSI;
}

const SS__CSI_template& CAMEL__SubscriptionInfo_template::ss__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_ss__CSI;
}

M__CSI_template& CAMEL__SubscriptionInfo_template::m__CSI()
{
set_specific();
return single_value->field_m__CSI;
}

const M__CSI_template& CAMEL__SubscriptionInfo_template::m__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field m_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_m__CSI;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& CAMEL__SubscriptionInfo_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& CAMEL__SubscriptionInfo_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_extensionContainer;
}

BITSTRING_template& CAMEL__SubscriptionInfo_template::specificCSIDeletedList()
{
set_specific();
return single_value->field_specificCSIDeletedList;
}

const BITSTRING_template& CAMEL__SubscriptionInfo_template::specificCSIDeletedList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field specificCSIDeletedList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_specificCSIDeletedList;
}

SMS__CSI_template& CAMEL__SubscriptionInfo_template::mt__sms__CSI()
{
set_specific();
return single_value->field_mt__sms__CSI;
}

const SMS__CSI_template& CAMEL__SubscriptionInfo_template::mt__sms__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mt_sms_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_mt__sms__CSI;
}

MT__smsCAMELTDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::mt__smsCAMELTDP__CriteriaList()
{
set_specific();
return single_value->field_mt__smsCAMELTDP__CriteriaList;
}

const MT__smsCAMELTDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::mt__smsCAMELTDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mt_smsCAMELTDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_mt__smsCAMELTDP__CriteriaList;
}

MG__CSI_template& CAMEL__SubscriptionInfo_template::mg__csi()
{
set_specific();
return single_value->field_mg__csi;
}

const MG__CSI_template& CAMEL__SubscriptionInfo_template::mg__csi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mg_csi of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_mg__csi;
}

O__CSI_template& CAMEL__SubscriptionInfo_template::o__IM__CSI()
{
set_specific();
return single_value->field_o__IM__CSI;
}

const O__CSI_template& CAMEL__SubscriptionInfo_template::o__IM__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field o_IM_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_o__IM__CSI;
}

O__BcsmCamelTDPCriteriaList_template& CAMEL__SubscriptionInfo_template::o__IM__BcsmCamelTDP__CriteriaList()
{
set_specific();
return single_value->field_o__IM__BcsmCamelTDP__CriteriaList;
}

const O__BcsmCamelTDPCriteriaList_template& CAMEL__SubscriptionInfo_template::o__IM__BcsmCamelTDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field o_IM_BcsmCamelTDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_o__IM__BcsmCamelTDP__CriteriaList;
}

D__CSI_template& CAMEL__SubscriptionInfo_template::d__IM__CSI()
{
set_specific();
return single_value->field_d__IM__CSI;
}

const D__CSI_template& CAMEL__SubscriptionInfo_template::d__IM__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field d_IM_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_d__IM__CSI;
}

T__CSI_template& CAMEL__SubscriptionInfo_template::vt__IM__CSI()
{
set_specific();
return single_value->field_vt__IM__CSI;
}

const T__CSI_template& CAMEL__SubscriptionInfo_template::vt__IM__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vt_IM_CSI of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_vt__IM__CSI;
}

T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::vt__IM__BCSM__CAMEL__TDP__CriteriaList()
{
set_specific();
return single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList;
}

const T__BCSM__CAMEL__TDP__CriteriaList_template& CAMEL__SubscriptionInfo_template::vt__IM__BCSM__CAMEL__TDP__CriteriaList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vt_IM_BCSM_CAMEL_TDP_CriteriaList of a non-specific template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
return single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList;
}

int CAMEL__SubscriptionInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_o__CSI.is_present()) ret_val++;
      if (single_value->field_o__BcsmCamelTDP__CriteriaList.is_present()) ret_val++;
      if (single_value->field_d__CSI.is_present()) ret_val++;
      if (single_value->field_t__CSI.is_present()) ret_val++;
      if (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.is_present()) ret_val++;
      if (single_value->field_vt__CSI.is_present()) ret_val++;
      if (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.is_present()) ret_val++;
      if (single_value->field_tif__CSI.is_present()) ret_val++;
      if (single_value->field_tif__CSI__NotificationToCSE.is_present()) ret_val++;
      if (single_value->field_gprs__CSI.is_present()) ret_val++;
      if (single_value->field_mo__sms__CSI.is_present()) ret_val++;
      if (single_value->field_ss__CSI.is_present()) ret_val++;
      if (single_value->field_m__CSI.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_specificCSIDeletedList.is_present()) ret_val++;
      if (single_value->field_mt__sms__CSI.is_present()) ret_val++;
      if (single_value->field_mt__smsCAMELTDP__CriteriaList.is_present()) ret_val++;
      if (single_value->field_mg__csi.is_present()) ret_val++;
      if (single_value->field_o__IM__CSI.is_present()) ret_val++;
      if (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.is_present()) ret_val++;
      if (single_value->field_d__IM__CSI.is_present()) ret_val++;
      if (single_value->field_vt__IM__CSI.is_present()) ret_val++;
      if (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
  }
  return 0;
}

void CAMEL__SubscriptionInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ o_CSI := ");
single_value->field_o__CSI.log();
TTCN_Logger::log_event_str(", o_BcsmCamelTDP_CriteriaList := ");
single_value->field_o__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", d_CSI := ");
single_value->field_d__CSI.log();
TTCN_Logger::log_event_str(", t_CSI := ");
single_value->field_t__CSI.log();
TTCN_Logger::log_event_str(", t_BCSM_CAMEL_TDP_CriteriaList := ");
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(", vt_CSI := ");
single_value->field_vt__CSI.log();
TTCN_Logger::log_event_str(", vt_BCSM_CAMEL_TDP_CriteriaList := ");
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(", tif_CSI := ");
single_value->field_tif__CSI.log();
TTCN_Logger::log_event_str(", tif_CSI_NotificationToCSE := ");
single_value->field_tif__CSI__NotificationToCSE.log();
TTCN_Logger::log_event_str(", gprs_CSI := ");
single_value->field_gprs__CSI.log();
TTCN_Logger::log_event_str(", mo_sms_CSI := ");
single_value->field_mo__sms__CSI.log();
TTCN_Logger::log_event_str(", ss_CSI := ");
single_value->field_ss__CSI.log();
TTCN_Logger::log_event_str(", m_CSI := ");
single_value->field_m__CSI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", specificCSIDeletedList := ");
single_value->field_specificCSIDeletedList.log();
TTCN_Logger::log_event_str(", mt_sms_CSI := ");
single_value->field_mt__sms__CSI.log();
TTCN_Logger::log_event_str(", mt_smsCAMELTDP_CriteriaList := ");
single_value->field_mt__smsCAMELTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", mg_csi := ");
single_value->field_mg__csi.log();
TTCN_Logger::log_event_str(", o_IM_CSI := ");
single_value->field_o__IM__CSI.log();
TTCN_Logger::log_event_str(", o_IM_BcsmCamelTDP_CriteriaList := ");
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(", d_IM_CSI := ");
single_value->field_d__IM__CSI.log();
TTCN_Logger::log_event_str(", vt_IM_CSI := ");
single_value->field_vt__IM__CSI.log();
TTCN_Logger::log_event_str(", vt_IM_BCSM_CAMEL_TDP_CriteriaList := ");
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CAMEL__SubscriptionInfo_template::log_match(const CAMEL__SubscriptionInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.o__CSI().ispresent()){
if(!single_value->field_o__CSI.match(match_value.o__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".o_CSI");
single_value->field_o__CSI.log_match(match_value.o__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_o__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".o_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_o__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.o__BcsmCamelTDP__CriteriaList().ispresent()){
if(!single_value->field_o__BcsmCamelTDP__CriteriaList.match(match_value.o__BcsmCamelTDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".o_BcsmCamelTDP_CriteriaList");
single_value->field_o__BcsmCamelTDP__CriteriaList.log_match(match_value.o__BcsmCamelTDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_o__BcsmCamelTDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".o_BcsmCamelTDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_o__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.d__CSI().ispresent()){
if(!single_value->field_d__CSI.match(match_value.d__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".d_CSI");
single_value->field_d__CSI.log_match(match_value.d__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_d__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".d_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_d__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.t__CSI().ispresent()){
if(!single_value->field_t__CSI.match(match_value.t__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".t_CSI");
single_value->field_t__CSI.log_match(match_value.t__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_t__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".t_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_t__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.t__BCSM__CAMEL__TDP__CriteriaList().ispresent()){
if(!single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.match(match_value.t__BCSM__CAMEL__TDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".t_BCSM_CAMEL_TDP_CriteriaList");
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.t__BCSM__CAMEL__TDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".t_BCSM_CAMEL_TDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vt__CSI().ispresent()){
if(!single_value->field_vt__CSI.match(match_value.vt__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".vt_CSI");
single_value->field_vt__CSI.log_match(match_value.vt__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vt__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vt_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vt__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vt__BCSM__CAMEL__TDP__CriteriaList().ispresent()){
if(!single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.match(match_value.vt__BCSM__CAMEL__TDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".vt_BCSM_CAMEL_TDP_CriteriaList");
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.vt__BCSM__CAMEL__TDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vt_BCSM_CAMEL_TDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.tif__CSI().ispresent()){
if(!single_value->field_tif__CSI.match(match_value.tif__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".tif_CSI");
single_value->field_tif__CSI.log_match(match_value.tif__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tif__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tif_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tif__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.tif__CSI__NotificationToCSE().ispresent()){
if(!single_value->field_tif__CSI__NotificationToCSE.match(match_value.tif__CSI__NotificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".tif_CSI_NotificationToCSE");
single_value->field_tif__CSI__NotificationToCSE.log_match(match_value.tif__CSI__NotificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tif__CSI__NotificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tif_CSI_NotificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tif__CSI__NotificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gprs__CSI().ispresent()){
if(!single_value->field_gprs__CSI.match(match_value.gprs__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".gprs_CSI");
single_value->field_gprs__CSI.log_match(match_value.gprs__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gprs__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gprs_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gprs__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mo__sms__CSI().ispresent()){
if(!single_value->field_mo__sms__CSI.match(match_value.mo__sms__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".mo_sms_CSI");
single_value->field_mo__sms__CSI.log_match(match_value.mo__sms__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mo__sms__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mo_sms_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mo__sms__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ss__CSI().ispresent()){
if(!single_value->field_ss__CSI.match(match_value.ss__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_CSI");
single_value->field_ss__CSI.log_match(match_value.ss__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ss__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ss_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ss__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.m__CSI().ispresent()){
if(!single_value->field_m__CSI.match(match_value.m__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".m_CSI");
single_value->field_m__CSI.log_match(match_value.m__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_m__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".m_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_m__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.specificCSIDeletedList().ispresent()){
if(!single_value->field_specificCSIDeletedList.match(match_value.specificCSIDeletedList(), legacy)){
TTCN_Logger::log_logmatch_info(".specificCSIDeletedList");
single_value->field_specificCSIDeletedList.log_match(match_value.specificCSIDeletedList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_specificCSIDeletedList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".specificCSIDeletedList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_specificCSIDeletedList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mt__sms__CSI().ispresent()){
if(!single_value->field_mt__sms__CSI.match(match_value.mt__sms__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".mt_sms_CSI");
single_value->field_mt__sms__CSI.log_match(match_value.mt__sms__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mt__sms__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mt_sms_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mt__sms__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mt__smsCAMELTDP__CriteriaList().ispresent()){
if(!single_value->field_mt__smsCAMELTDP__CriteriaList.match(match_value.mt__smsCAMELTDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".mt_smsCAMELTDP_CriteriaList");
single_value->field_mt__smsCAMELTDP__CriteriaList.log_match(match_value.mt__smsCAMELTDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mt__smsCAMELTDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mt_smsCAMELTDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mt__smsCAMELTDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mg__csi().ispresent()){
if(!single_value->field_mg__csi.match(match_value.mg__csi(), legacy)){
TTCN_Logger::log_logmatch_info(".mg_csi");
single_value->field_mg__csi.log_match(match_value.mg__csi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mg__csi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mg_csi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mg__csi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.o__IM__CSI().ispresent()){
if(!single_value->field_o__IM__CSI.match(match_value.o__IM__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".o_IM_CSI");
single_value->field_o__IM__CSI.log_match(match_value.o__IM__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_o__IM__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".o_IM_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_o__IM__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.o__IM__BcsmCamelTDP__CriteriaList().ispresent()){
if(!single_value->field_o__IM__BcsmCamelTDP__CriteriaList.match(match_value.o__IM__BcsmCamelTDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".o_IM_BcsmCamelTDP_CriteriaList");
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.log_match(match_value.o__IM__BcsmCamelTDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_o__IM__BcsmCamelTDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".o_IM_BcsmCamelTDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.d__IM__CSI().ispresent()){
if(!single_value->field_d__IM__CSI.match(match_value.d__IM__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".d_IM_CSI");
single_value->field_d__IM__CSI.log_match(match_value.d__IM__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_d__IM__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".d_IM_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_d__IM__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vt__IM__CSI().ispresent()){
if(!single_value->field_vt__IM__CSI.match(match_value.vt__IM__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".vt_IM_CSI");
single_value->field_vt__IM__CSI.log_match(match_value.vt__IM__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vt__IM__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vt_IM_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vt__IM__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().ispresent()){
if(!single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.match(match_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList(), legacy)){
TTCN_Logger::log_logmatch_info(".vt_IM_BCSM_CAMEL_TDP_CriteriaList");
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vt_IM_BCSM_CAMEL_TDP_CriteriaList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ o_CSI := ");
if (match_value.o__CSI().ispresent()) {
single_value->field_o__CSI.log_match(match_value.o__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_o__CSI.log();
if (single_value->field_o__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", o_BcsmCamelTDP_CriteriaList := ");
if (match_value.o__BcsmCamelTDP__CriteriaList().ispresent()) {
single_value->field_o__BcsmCamelTDP__CriteriaList.log_match(match_value.o__BcsmCamelTDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_o__BcsmCamelTDP__CriteriaList.log();
if (single_value->field_o__BcsmCamelTDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", d_CSI := ");
if (match_value.d__CSI().ispresent()) {
single_value->field_d__CSI.log_match(match_value.d__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_d__CSI.log();
if (single_value->field_d__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", t_CSI := ");
if (match_value.t__CSI().ispresent()) {
single_value->field_t__CSI.log_match(match_value.t__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_t__CSI.log();
if (single_value->field_t__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", t_BCSM_CAMEL_TDP_CriteriaList := ");
if (match_value.t__BCSM__CAMEL__TDP__CriteriaList().ispresent()) {
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.t__BCSM__CAMEL__TDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.log();
if (single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vt_CSI := ");
if (match_value.vt__CSI().ispresent()) {
single_value->field_vt__CSI.log_match(match_value.vt__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vt__CSI.log();
if (single_value->field_vt__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vt_BCSM_CAMEL_TDP_CriteriaList := ");
if (match_value.vt__BCSM__CAMEL__TDP__CriteriaList().ispresent()) {
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.vt__BCSM__CAMEL__TDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.log();
if (single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", tif_CSI := ");
if (match_value.tif__CSI().ispresent()) {
single_value->field_tif__CSI.log_match(match_value.tif__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tif__CSI.log();
if (single_value->field_tif__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", tif_CSI_NotificationToCSE := ");
if (match_value.tif__CSI__NotificationToCSE().ispresent()) {
single_value->field_tif__CSI__NotificationToCSE.log_match(match_value.tif__CSI__NotificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tif__CSI__NotificationToCSE.log();
if (single_value->field_tif__CSI__NotificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gprs_CSI := ");
if (match_value.gprs__CSI().ispresent()) {
single_value->field_gprs__CSI.log_match(match_value.gprs__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gprs__CSI.log();
if (single_value->field_gprs__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mo_sms_CSI := ");
if (match_value.mo__sms__CSI().ispresent()) {
single_value->field_mo__sms__CSI.log_match(match_value.mo__sms__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mo__sms__CSI.log();
if (single_value->field_mo__sms__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ss_CSI := ");
if (match_value.ss__CSI().ispresent()) {
single_value->field_ss__CSI.log_match(match_value.ss__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ss__CSI.log();
if (single_value->field_ss__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", m_CSI := ");
if (match_value.m__CSI().ispresent()) {
single_value->field_m__CSI.log_match(match_value.m__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_m__CSI.log();
if (single_value->field_m__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", specificCSIDeletedList := ");
if (match_value.specificCSIDeletedList().ispresent()) {
single_value->field_specificCSIDeletedList.log_match(match_value.specificCSIDeletedList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_specificCSIDeletedList.log();
if (single_value->field_specificCSIDeletedList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mt_sms_CSI := ");
if (match_value.mt__sms__CSI().ispresent()) {
single_value->field_mt__sms__CSI.log_match(match_value.mt__sms__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mt__sms__CSI.log();
if (single_value->field_mt__sms__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mt_smsCAMELTDP_CriteriaList := ");
if (match_value.mt__smsCAMELTDP__CriteriaList().ispresent()) {
single_value->field_mt__smsCAMELTDP__CriteriaList.log_match(match_value.mt__smsCAMELTDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mt__smsCAMELTDP__CriteriaList.log();
if (single_value->field_mt__smsCAMELTDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mg_csi := ");
if (match_value.mg__csi().ispresent()) {
single_value->field_mg__csi.log_match(match_value.mg__csi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mg__csi.log();
if (single_value->field_mg__csi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", o_IM_CSI := ");
if (match_value.o__IM__CSI().ispresent()) {
single_value->field_o__IM__CSI.log_match(match_value.o__IM__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_o__IM__CSI.log();
if (single_value->field_o__IM__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", o_IM_BcsmCamelTDP_CriteriaList := ");
if (match_value.o__IM__BcsmCamelTDP__CriteriaList().ispresent()) {
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.log_match(match_value.o__IM__BcsmCamelTDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.log();
if (single_value->field_o__IM__BcsmCamelTDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", d_IM_CSI := ");
if (match_value.d__IM__CSI().ispresent()) {
single_value->field_d__IM__CSI.log_match(match_value.d__IM__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_d__IM__CSI.log();
if (single_value->field_d__IM__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vt_IM_CSI := ");
if (match_value.vt__IM__CSI().ispresent()) {
single_value->field_vt__IM__CSI.log_match(match_value.vt__IM__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vt__IM__CSI.log();
if (single_value->field_vt__IM__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vt_IM_BCSM_CAMEL_TDP_CriteriaList := ");
if (match_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList().ispresent()) {
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log_match(match_value.vt__IM__BCSM__CAMEL__TDP__CriteriaList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.log();
if (single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CAMEL__SubscriptionInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!o__CSI().is_bound()) o__CSI() = OMIT_VALUE;
else o__CSI().set_implicit_omit();
if (!o__BcsmCamelTDP__CriteriaList().is_bound()) o__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else o__BcsmCamelTDP__CriteriaList().set_implicit_omit();
if (!d__CSI().is_bound()) d__CSI() = OMIT_VALUE;
else d__CSI().set_implicit_omit();
if (!t__CSI().is_bound()) t__CSI() = OMIT_VALUE;
else t__CSI().set_implicit_omit();
if (!t__BCSM__CAMEL__TDP__CriteriaList().is_bound()) t__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else t__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
if (!vt__CSI().is_bound()) vt__CSI() = OMIT_VALUE;
else vt__CSI().set_implicit_omit();
if (!vt__BCSM__CAMEL__TDP__CriteriaList().is_bound()) vt__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else vt__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
if (!tif__CSI().is_bound()) tif__CSI() = OMIT_VALUE;
else tif__CSI().set_implicit_omit();
if (!tif__CSI__NotificationToCSE().is_bound()) tif__CSI__NotificationToCSE() = OMIT_VALUE;
else tif__CSI__NotificationToCSE().set_implicit_omit();
if (!gprs__CSI().is_bound()) gprs__CSI() = OMIT_VALUE;
else gprs__CSI().set_implicit_omit();
if (!mo__sms__CSI().is_bound()) mo__sms__CSI() = OMIT_VALUE;
else mo__sms__CSI().set_implicit_omit();
if (!ss__CSI().is_bound()) ss__CSI() = OMIT_VALUE;
else ss__CSI().set_implicit_omit();
if (!m__CSI().is_bound()) m__CSI() = OMIT_VALUE;
else m__CSI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!specificCSIDeletedList().is_bound()) specificCSIDeletedList() = OMIT_VALUE;
else specificCSIDeletedList().set_implicit_omit();
if (!mt__sms__CSI().is_bound()) mt__sms__CSI() = OMIT_VALUE;
else mt__sms__CSI().set_implicit_omit();
if (!mt__smsCAMELTDP__CriteriaList().is_bound()) mt__smsCAMELTDP__CriteriaList() = OMIT_VALUE;
else mt__smsCAMELTDP__CriteriaList().set_implicit_omit();
if (!mg__csi().is_bound()) mg__csi() = OMIT_VALUE;
else mg__csi().set_implicit_omit();
if (!o__IM__CSI().is_bound()) o__IM__CSI() = OMIT_VALUE;
else o__IM__CSI().set_implicit_omit();
if (!o__IM__BcsmCamelTDP__CriteriaList().is_bound()) o__IM__BcsmCamelTDP__CriteriaList() = OMIT_VALUE;
else o__IM__BcsmCamelTDP__CriteriaList().set_implicit_omit();
if (!d__IM__CSI().is_bound()) d__IM__CSI() = OMIT_VALUE;
else d__IM__CSI().set_implicit_omit();
if (!vt__IM__CSI().is_bound()) vt__IM__CSI() = OMIT_VALUE;
else vt__IM__CSI().set_implicit_omit();
if (!vt__IM__BCSM__CAMEL__TDP__CriteriaList().is_bound()) vt__IM__BCSM__CAMEL__TDP__CriteriaList() = OMIT_VALUE;
else vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_implicit_omit();
}

void CAMEL__SubscriptionInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_o__CSI.encode_text(text_buf);
single_value->field_o__BcsmCamelTDP__CriteriaList.encode_text(text_buf);
single_value->field_d__CSI.encode_text(text_buf);
single_value->field_t__CSI.encode_text(text_buf);
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
single_value->field_vt__CSI.encode_text(text_buf);
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
single_value->field_tif__CSI.encode_text(text_buf);
single_value->field_tif__CSI__NotificationToCSE.encode_text(text_buf);
single_value->field_gprs__CSI.encode_text(text_buf);
single_value->field_mo__sms__CSI.encode_text(text_buf);
single_value->field_ss__CSI.encode_text(text_buf);
single_value->field_m__CSI.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_specificCSIDeletedList.encode_text(text_buf);
single_value->field_mt__sms__CSI.encode_text(text_buf);
single_value->field_mt__smsCAMELTDP__CriteriaList.encode_text(text_buf);
single_value->field_mg__csi.encode_text(text_buf);
single_value->field_o__IM__CSI.encode_text(text_buf);
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.encode_text(text_buf);
single_value->field_d__IM__CSI.encode_text(text_buf);
single_value->field_vt__IM__CSI.encode_text(text_buf);
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
}
}

void CAMEL__SubscriptionInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_o__CSI.decode_text(text_buf);
single_value->field_o__BcsmCamelTDP__CriteriaList.decode_text(text_buf);
single_value->field_d__CSI.decode_text(text_buf);
single_value->field_t__CSI.decode_text(text_buf);
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
single_value->field_vt__CSI.decode_text(text_buf);
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
single_value->field_tif__CSI.decode_text(text_buf);
single_value->field_tif__CSI__NotificationToCSE.decode_text(text_buf);
single_value->field_gprs__CSI.decode_text(text_buf);
single_value->field_mo__sms__CSI.decode_text(text_buf);
single_value->field_ss__CSI.decode_text(text_buf);
single_value->field_m__CSI.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_specificCSIDeletedList.decode_text(text_buf);
single_value->field_mt__sms__CSI.decode_text(text_buf);
single_value->field_mt__smsCAMELTDP__CriteriaList.decode_text(text_buf);
single_value->field_mg__csi.decode_text(text_buf);
single_value->field_o__IM__CSI.decode_text(text_buf);
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.decode_text(text_buf);
single_value->field_d__IM__CSI.decode_text(text_buf);
single_value->field_vt__IM__CSI.decode_text(text_buf);
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CAMEL__SubscriptionInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo.");
}
}

void CAMEL__SubscriptionInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CAMEL__SubscriptionInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (23<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo has 23 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) o__CSI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) o__BcsmCamelTDP__CriteriaList().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) d__CSI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) t__CSI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) t__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) vt__CSI().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) vt__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) tif__CSI().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) tif__CSI__NotificationToCSE().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) gprs__CSI().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) mo__sms__CSI().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) ss__CSI().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) m__CSI().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) specificCSIDeletedList().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) mt__sms__CSI().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) mt__smsCAMELTDP__CriteriaList().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) mg__csi().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) o__IM__CSI().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) o__IM__BcsmCamelTDP__CriteriaList().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) d__IM__CSI().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) vt__IM__CSI().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_param(*param.get_elem(22));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_BcsmCamelTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__BcsmCamelTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tif_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tif__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tif_CSI_NotificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tif__CSI__NotificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprs_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprs__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mo_sms_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mo__sms__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "m_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          m__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "specificCSIDeletedList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          specificCSIDeletedList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mt_sms_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mt__sms__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mt_smsCAMELTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mt__smsCAMELTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mg_csi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mg__csi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "o_IM_BcsmCamelTDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          o__IM__BcsmCamelTDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_IM_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__IM__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vt_IM_BCSM_CAMEL_TDP_CriteriaList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vt__IM__BCSM__CAMEL__TDP__CriteriaList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CAMEL-SubscriptionInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CAMEL__SubscriptionInfo_template* precondition = new CAMEL__SubscriptionInfo_template;
    precondition->set_param(*param.get_elem(0));
    CAMEL__SubscriptionInfo_template* implied_template = new CAMEL__SubscriptionInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CAMEL__SubscriptionInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void CAMEL__SubscriptionInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_o__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_o__BcsmCamelTDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_d__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_t__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_t__BCSM__CAMEL__TDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_vt__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_vt__BCSM__CAMEL__TDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_tif__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_tif__CSI__NotificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_gprs__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_mo__sms__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_ss__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_m__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_specificCSIDeletedList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_mt__sms__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_mt__smsCAMELTDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_mg__csi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_o__IM__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_o__IM__BcsmCamelTDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_d__IM__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_vt__IM__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
single_value->field_vt__IM__BCSM__CAMEL__TDP__CriteriaList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.CAMEL-SubscriptionInfo");
}

boolean CAMEL__SubscriptionInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CAMEL__SubscriptionInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const MSISDN__BS MSISDN__BS__List::UNBOUND_ELEM;
MSISDN__BS__List::MSISDN__BS__List()
{
val_ptr = NULL;
}

MSISDN__BS__List::MSISDN__BS__List(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

MSISDN__BS__List::MSISDN__BS__List(const MSISDN__BS__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

MSISDN__BS__List::~MSISDN__BS__List()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void MSISDN__BS__List::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

MSISDN__BS__List& MSISDN__BS__List::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

MSISDN__BS__List& MSISDN__BS__List::operator=(const MSISDN__BS__List& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean MSISDN__BS__List::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return val_ptr->n_elements == 0 ;
}

boolean MSISDN__BS__List::operator==(const MSISDN__BS__List& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

MSISDN__BS& MSISDN__BS__List::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MAP-MS-DataTypes.MSISDN-BS-List using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (MSISDN__BS**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new MSISDN__BS(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new MSISDN__BS;
}
return *val_ptr->value_elements[index_value];
}

MSISDN__BS& MSISDN__BS__List::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return (*this)[(int)index_value];
}

const MSISDN__BS& MSISDN__BS__List::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (index_value < 0) TTCN_error("Accessing an element of type @MAP-MS-DataTypes.MSISDN-BS-List using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MAP-MS-DataTypes.MSISDN-BS-List: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const MSISDN__BS& MSISDN__BS__List::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return (*this)[(int)index_value];
}

MSISDN__BS__List MSISDN__BS__List::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

MSISDN__BS__List MSISDN__BS__List::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

MSISDN__BS__List MSISDN__BS__List::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

MSISDN__BS__List MSISDN__BS__List::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
MSISDN__BS__List ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new MSISDN__BS(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

MSISDN__BS__List MSISDN__BS__List::operator+(const MSISDN__BS__List& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MAP-MS-DataTypes.MSISDN-BS-List concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
MSISDN__BS__List ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new MSISDN__BS(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new MSISDN__BS(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

MSISDN__BS__List MSISDN__BS__List::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MAP-MS-DataTypes.MSISDN-BS-List","element");
MSISDN__BS__List ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new MSISDN__BS(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

MSISDN__BS__List MSISDN__BS__List::replace(int index, int len, const MSISDN__BS__List& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MAP-MS-DataTypes.MSISDN-BS-List","element");
MSISDN__BS__List ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new MSISDN__BS(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new MSISDN__BS(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new MSISDN__BS(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

MSISDN__BS__List MSISDN__BS__List::replace(int index, int len, const MSISDN__BS__List_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void MSISDN__BS__List::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (MSISDN__BS**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new MSISDN__BS(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (MSISDN__BS**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MAP-MS-DataTypes.MSISDN-BS-List: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (MSISDN__BS**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean MSISDN__BS__List::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int MSISDN__BS__List::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return val_ptr->n_elements;
}

int MSISDN__BS__List::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void MSISDN__BS__List::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void MSISDN__BS__List::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void MSISDN__BS__List::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MAP-MS-DataTypes.MSISDN-BS-List");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MAP-MS-DataTypes.MSISDN-BS-List");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void MSISDN__BS__List::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void MSISDN__BS__List::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
val_ptr->value_elements = (MSISDN__BS**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new MSISDN__BS;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void MSISDN__BS__List::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MSISDN__BS__List::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* MSISDN__BS__List::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean MSISDN__BS__List::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (MSISDN__BS**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new MSISDN__BS;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int MSISDN__BS__List::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int MSISDN__BS__List::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const MSISDN__BS__List*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    MSISDN__BS* val = new MSISDN__BS;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (MSISDN__BS**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int MSISDN__BS__List::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.MSISDN-BS-List.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int MSISDN__BS__List::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void MSISDN__BS__List::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void MSISDN__BS__List::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void MSISDN__BS__List_template::copy_value(const MSISDN__BS__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MAP-MS-DataTypes.MSISDN-BS-List with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (MSISDN__BS_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new MSISDN__BS_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new MSISDN__BS_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void MSISDN__BS__List_template::copy_template(const MSISDN__BS__List_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (MSISDN__BS_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new MSISDN__BS_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new MSISDN__BS_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MSISDN__BS__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MSISDN__BS__List_template(*other_value.implication_.precondition);
implication_.implied_template = new MSISDN__BS__List_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
break;
}
set_selection(other_value);
}

boolean MSISDN__BS__List_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const MSISDN__BS__List_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const MSISDN__BS__List*)value_ptr)[value_index], legacy);
else return ((const MSISDN__BS__List_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

MSISDN__BS__List_template::MSISDN__BS__List_template()
{
}

MSISDN__BS__List_template::MSISDN__BS__List_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

MSISDN__BS__List_template::MSISDN__BS__List_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

MSISDN__BS__List_template::MSISDN__BS__List_template(const MSISDN__BS__List& other_value)
{
copy_value(other_value);
}

MSISDN__BS__List_template::MSISDN__BS__List_template(const OPTIONAL<MSISDN__BS__List>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSISDN__BS__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.MSISDN-BS-List from an unbound optional field.");
}
}

MSISDN__BS__List_template::MSISDN__BS__List_template(MSISDN__BS__List_template* p_precondition, MSISDN__BS__List_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MSISDN__BS__List_template::MSISDN__BS__List_template(Dynamic_Match_Interface<MSISDN__BS__List>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MSISDN__BS__List>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MSISDN__BS__List_template::MSISDN__BS__List_template(const MSISDN__BS__List_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

MSISDN__BS__List_template::~MSISDN__BS__List_template()
{
clean_up();
}

void MSISDN__BS__List_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MSISDN__BS__List_template& MSISDN__BS__List_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MSISDN__BS__List_template& MSISDN__BS__List_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

MSISDN__BS__List_template& MSISDN__BS__List_template::operator=(const MSISDN__BS__List& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MSISDN__BS__List_template& MSISDN__BS__List_template::operator=(const OPTIONAL<MSISDN__BS__List>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSISDN__BS__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
}
return *this;
}

MSISDN__BS__List_template& MSISDN__BS__List_template::operator=(const MSISDN__BS__List_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

MSISDN__BS_template& MSISDN__BS__List_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MAP-MS-DataTypes.MSISDN-BS-List using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MAP-MS-DataTypes.MSISDN-BS-List.");
    break;
}
return *single_value.value_elements[index_value];
}

MSISDN__BS_template& MSISDN__BS__List_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return (*this)[(int)index_value];
}

const MSISDN__BS_template& MSISDN__BS__List_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MAP-MS-DataTypes.MSISDN-BS-List using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MAP-MS-DataTypes.MSISDN-BS-List: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const MSISDN__BS_template& MSISDN__BS__List_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return (*this)[(int)index_value];
}

void MSISDN__BS__List_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (MSISDN__BS_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new MSISDN__BS_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new MSISDN__BS_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (MSISDN__BS_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int MSISDN__BS__List_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int MSISDN__BS__List_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS-List containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS-List.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @MAP-MS-DataTypes.MSISDN-BS-List");
}

boolean MSISDN__BS__List_template::match(const MSISDN__BS__List& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
}
return FALSE;
}

boolean MSISDN__BS__List_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

MSISDN__BS__List MSISDN__BS__List_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
MSISDN__BS__List ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

MSISDN__BS__List MSISDN__BS__List_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

MSISDN__BS__List MSISDN__BS__List_template::replace(int index, int len, const MSISDN__BS__List_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

MSISDN__BS__List MSISDN__BS__List_template::replace(int index, int len, const MSISDN__BS__List& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void MSISDN__BS__List_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new MSISDN__BS__List_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
}
set_selection(template_type);
}

MSISDN__BS__List_template& MSISDN__BS__List_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
return value_list.list_value[list_index];
}

void MSISDN__BS__List_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void MSISDN__BS__List_template::log_match(const MSISDN__BS__List& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MSISDN__BS__List_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
}
}

void MSISDN__BS__List_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
single_value.value_elements = (MSISDN__BS_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new MSISDN__BS_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MSISDN__BS__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @MAP-MS-DataTypes.MSISDN-BS-List.");
}
}

boolean MSISDN__BS__List_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MSISDN__BS__List_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void MSISDN__BS__List_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void MSISDN__BS__List_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MSISDN__BS__List_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MSISDN__BS__List_template* precondition = new MSISDN__BS__List_template;
    precondition->set_param(*param.get_elem(0));
    MSISDN__BS__List_template* implied_template = new MSISDN__BS__List_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MSISDN__BS__List_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@MAP-MS-DataTypes.MSISDN-BS-List");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void MSISDN__BS__List_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS-List");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS-List");
}

boolean MSISDN__BS__List_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
MSISDN__BS::MSISDN__BS()
{
}

MSISDN__BS::MSISDN__BS(const OCTETSTRING& par_msisdn,
    const OPTIONAL< BasicServiceList >& par_basicServiceList,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_msisdn(par_msisdn),
  field_basicServiceList(par_basicServiceList),
  field_extensionContainer(par_extensionContainer)
{
}

MSISDN__BS::MSISDN__BS(const MSISDN__BS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.MSISDN-BS.");
if (other_value.msisdn().is_bound()) field_msisdn = other_value.msisdn();
else field_msisdn.clean_up();
if (other_value.basicServiceList().is_bound()) field_basicServiceList = other_value.basicServiceList();
else field_basicServiceList.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void MSISDN__BS::clean_up()
{
field_msisdn.clean_up();
field_basicServiceList.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* MSISDN__BS::get_descriptor() const { return &MSISDN__BS_descr_; }
MSISDN__BS& MSISDN__BS::operator=(const MSISDN__BS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.MSISDN-BS.");
  if (other_value.msisdn().is_bound()) field_msisdn = other_value.msisdn();
  else field_msisdn.clean_up();
  if (other_value.basicServiceList().is_bound()) field_basicServiceList = other_value.basicServiceList();
  else field_basicServiceList.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean MSISDN__BS::operator==(const MSISDN__BS& other_value) const
{
return field_msisdn==other_value.field_msisdn
  && field_basicServiceList==other_value.field_basicServiceList
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean MSISDN__BS::is_bound() const
{
return (field_msisdn.is_bound())
  || (OPTIONAL_OMIT == field_basicServiceList.get_selection() || field_basicServiceList.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean MSISDN__BS::is_value() const
{
return field_msisdn.is_value()
  && (OPTIONAL_OMIT == field_basicServiceList.get_selection() || field_basicServiceList.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int MSISDN__BS::size_of() const
{
  int ret_val = 1;
  if (field_basicServiceList.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void MSISDN__BS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ msisdn := ");
field_msisdn.log();
TTCN_Logger::log_event_str(", basicServiceList := ");
field_basicServiceList.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void MSISDN__BS::set_implicit_omit()
{
if (msisdn().is_bound()) msisdn().set_implicit_omit();
if (!basicServiceList().is_bound()) basicServiceList() = OMIT_VALUE;
else basicServiceList().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void MSISDN__BS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.MSISDN-BS has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msisdn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) basicServiceList().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msisdn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msisdn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicServiceList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicServiceList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.MSISDN-BS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.MSISDN-BS");
  }
}

void MSISDN__BS::encode_text(Text_Buf& text_buf) const
{
field_msisdn.encode_text(text_buf);
field_basicServiceList.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void MSISDN__BS::decode_text(Text_Buf& text_buf)
{
field_msisdn.decode_text(text_buf);
field_basicServiceList.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void MSISDN__BS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MSISDN__BS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* MSISDN__BS::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("msisdn': ");
  new_tlv->add_TLV(field_msisdn.BER_encode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_coding));
  ec_1.set_msg("basicServiceList': ");
  new_tlv->add_TLV(field_basicServiceList.BER_encode_TLV(MSISDN__BS_basicServiceList_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(MSISDN__BS_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean MSISDN__BS::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.MSISDN-BS' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("msisdn': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_msisdn.BER_decode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("basicServiceList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_basicServiceList=OMIT_VALUE;
    else {
      field_basicServiceList.BER_decode_TLV(MSISDN__BS_basicServiceList_descr_, tmp_tlv, L_form);
      if(field_basicServiceList.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(MSISDN__BS_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int MSISDN__BS::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.MSISDN-BS.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "msisdn");
    enc_len += field_msisdn.JSON_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, FALSE);
  }

  if (field_basicServiceList.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "basicServiceList");
    enc_len += field_basicServiceList.JSON_encode(MSISDN__BS_basicServiceList_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(MSISDN__BS_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int MSISDN__BS::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const MSISDN__BS*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean msisdn_found = FALSE;
  boolean basicServiceList_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (6 == name_len && 0 == strncmp(fld_name, "msisdn", name_len)) {
        msisdn_found = TRUE;
         int ret_val = field_msisdn.JSON_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 6, "msisdn");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (16 == name_len && 0 == strncmp(fld_name, "basicServiceList", name_len)) {
        basicServiceList_found = TRUE;
         int ret_val = field_basicServiceList.JSON_decode(MSISDN__BS_basicServiceList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 16, "basicServiceList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(MSISDN__BS_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!msisdn_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "msisdn");
    return JSON_ERROR_FATAL;
  }
  if (!basicServiceList_found) {
    field_basicServiceList = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int MSISDN__BS::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_basicServiceList.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_msisdn.OER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf);
  if (field_basicServiceList.is_present())
    field_basicServiceList.OER_encode(MSISDN__BS_basicServiceList_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(MSISDN__BS_extensionContainer_descr_, p_buf);
  return 0;
}

int MSISDN__BS::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_msisdn.OER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_basicServiceList.OER_decode(MSISDN__BS_basicServiceList_descr_, p_buf, p_oer);
 else
    field_basicServiceList = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(MSISDN__BS_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void MSISDN__BS::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_basicServiceList_present = field_basicServiceList.is_present();
p_buf.PER_put_bit(field_basicServiceList_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_msisdn.PER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_basicServiceList_present) field_basicServiceList.PER_encode(MSISDN__BS_basicServiceList_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(MSISDN__BS_extensionContainer_descr_, p_buf, p_options);
}

void MSISDN__BS::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_basicServiceList_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_msisdn.PER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_basicServiceList_present) field_basicServiceList.PER_decode(MSISDN__BS_basicServiceList_descr_, p_buf, p_options);
else field_basicServiceList = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(MSISDN__BS_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct MSISDN__BS_template::single_value_struct {
OCTETSTRING_template field_msisdn;
BasicServiceList_template field_basicServiceList;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void MSISDN__BS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_msisdn = ANY_VALUE;
single_value->field_basicServiceList = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void MSISDN__BS_template::copy_value(const MSISDN__BS& other_value)
{
single_value = new single_value_struct;
if (other_value.msisdn().is_bound()) {
  single_value->field_msisdn = other_value.msisdn();
} else {
  single_value->field_msisdn.clean_up();
}
if (other_value.basicServiceList().is_bound()) {
  if (other_value.basicServiceList().ispresent()) single_value->field_basicServiceList = other_value.basicServiceList()();
  else single_value->field_basicServiceList = OMIT_VALUE;
} else {
  single_value->field_basicServiceList.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MSISDN__BS_template::copy_template(const MSISDN__BS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.msisdn().get_selection()) {
single_value->field_msisdn = other_value.msisdn();
} else {
single_value->field_msisdn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.basicServiceList().get_selection()) {
single_value->field_basicServiceList = other_value.basicServiceList();
} else {
single_value->field_basicServiceList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MSISDN__BS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MSISDN__BS_template(*other_value.implication_.precondition);
implication_.implied_template = new MSISDN__BS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS.");
break;
}
set_selection(other_value);
}

MSISDN__BS_template::MSISDN__BS_template()
{
}

MSISDN__BS_template::MSISDN__BS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MSISDN__BS_template::MSISDN__BS_template(const MSISDN__BS& other_value)
{
copy_value(other_value);
}

MSISDN__BS_template::MSISDN__BS_template(const OPTIONAL<MSISDN__BS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSISDN__BS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.MSISDN-BS from an unbound optional field.");
}
}

MSISDN__BS_template::MSISDN__BS_template(MSISDN__BS_template* p_precondition, MSISDN__BS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MSISDN__BS_template::MSISDN__BS_template(Dynamic_Match_Interface<MSISDN__BS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MSISDN__BS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MSISDN__BS_template::MSISDN__BS_template(const MSISDN__BS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MSISDN__BS_template::~MSISDN__BS_template()
{
clean_up();
}

MSISDN__BS_template& MSISDN__BS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MSISDN__BS_template& MSISDN__BS_template::operator=(const MSISDN__BS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MSISDN__BS_template& MSISDN__BS_template::operator=(const OPTIONAL<MSISDN__BS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSISDN__BS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.MSISDN-BS.");
}
return *this;
}

MSISDN__BS_template& MSISDN__BS_template::operator=(const MSISDN__BS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MSISDN__BS_template::match(const MSISDN__BS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.msisdn().is_bound()) return FALSE;
if(!single_value->field_msisdn.match(other_value.msisdn(), legacy))return FALSE;
if(!other_value.basicServiceList().is_bound()) return FALSE;
if((other_value.basicServiceList().ispresent() ? !single_value->field_basicServiceList.match((const BasicServiceList&)other_value.basicServiceList(), legacy) : !single_value->field_basicServiceList.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS.");
}
return FALSE;
}

boolean MSISDN__BS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_msisdn.is_bound()
 || (single_value->field_basicServiceList.is_omit() || single_value->field_basicServiceList.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean MSISDN__BS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_msisdn.is_value()
 && (single_value->field_basicServiceList.is_omit() || single_value->field_basicServiceList.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void MSISDN__BS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MSISDN__BS MSISDN__BS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.MSISDN-BS.");
MSISDN__BS ret_val;
if (single_value->field_msisdn.is_bound()) {
ret_val.msisdn() = single_value->field_msisdn.valueof();
}
if (single_value->field_basicServiceList.is_omit()) ret_val.basicServiceList() = OMIT_VALUE;
else if (single_value->field_basicServiceList.is_bound()) {
ret_val.basicServiceList() = single_value->field_basicServiceList.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void MSISDN__BS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.MSISDN-BS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MSISDN__BS_template[list_length];
}

MSISDN__BS_template& MSISDN__BS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.MSISDN-BS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.MSISDN-BS.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& MSISDN__BS_template::msisdn()
{
set_specific();
return single_value->field_msisdn;
}

const OCTETSTRING_template& MSISDN__BS_template::msisdn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msisdn of a non-specific template of type @MAP-MS-DataTypes.MSISDN-BS.");
return single_value->field_msisdn;
}

BasicServiceList_template& MSISDN__BS_template::basicServiceList()
{
set_specific();
return single_value->field_basicServiceList;
}

const BasicServiceList_template& MSISDN__BS_template::basicServiceList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field basicServiceList of a non-specific template of type @MAP-MS-DataTypes.MSISDN-BS.");
return single_value->field_basicServiceList;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& MSISDN__BS_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& MSISDN__BS_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.MSISDN-BS.");
return single_value->field_extensionContainer;
}

int MSISDN__BS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_basicServiceList.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.MSISDN-BS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS.");
  }
  return 0;
}

void MSISDN__BS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ msisdn := ");
single_value->field_msisdn.log();
TTCN_Logger::log_event_str(", basicServiceList := ");
single_value->field_basicServiceList.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MSISDN__BS_template::log_match(const MSISDN__BS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_msisdn.match(match_value.msisdn(), legacy)){
TTCN_Logger::log_logmatch_info(".msisdn");
single_value->field_msisdn.log_match(match_value.msisdn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.basicServiceList().ispresent()){
if(!single_value->field_basicServiceList.match(match_value.basicServiceList(), legacy)){
TTCN_Logger::log_logmatch_info(".basicServiceList");
single_value->field_basicServiceList.log_match(match_value.basicServiceList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_basicServiceList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".basicServiceList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_basicServiceList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ msisdn := ");
single_value->field_msisdn.log_match(match_value.msisdn(), legacy);
TTCN_Logger::log_event_str(", basicServiceList := ");
if (match_value.basicServiceList().ispresent()) {
single_value->field_basicServiceList.log_match(match_value.basicServiceList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_basicServiceList.log();
if (single_value->field_basicServiceList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MSISDN__BS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (msisdn().is_bound()) msisdn().set_implicit_omit();
if (!basicServiceList().is_bound()) basicServiceList() = OMIT_VALUE;
else basicServiceList().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void MSISDN__BS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_msisdn.encode_text(text_buf);
single_value->field_basicServiceList.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.MSISDN-BS.");
}
}

void MSISDN__BS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_msisdn.decode_text(text_buf);
single_value->field_basicServiceList.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MSISDN__BS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.MSISDN-BS.");
}
}

void MSISDN__BS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MSISDN__BS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.MSISDN-BS has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msisdn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) basicServiceList().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msisdn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msisdn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicServiceList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicServiceList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.MSISDN-BS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MSISDN__BS_template* precondition = new MSISDN__BS_template;
    precondition->set_param(*param.get_elem(0));
    MSISDN__BS_template* implied_template = new MSISDN__BS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MSISDN__BS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.MSISDN-BS");
  }
  is_ifpresent = param.get_ifpresent();
}

void MSISDN__BS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_msisdn.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS");
single_value->field_basicServiceList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.MSISDN-BS");
}

boolean MSISDN__BS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MSISDN__BS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const Ext__CwFeature Ext__CwFeatureList::UNBOUND_ELEM;
Ext__CwFeatureList::Ext__CwFeatureList()
{
val_ptr = NULL;
}

Ext__CwFeatureList::Ext__CwFeatureList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

Ext__CwFeatureList::Ext__CwFeatureList(const Ext__CwFeatureList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

Ext__CwFeatureList::~Ext__CwFeatureList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void Ext__CwFeatureList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

Ext__CwFeatureList& Ext__CwFeatureList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

Ext__CwFeatureList& Ext__CwFeatureList::operator=(const Ext__CwFeatureList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean Ext__CwFeatureList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return val_ptr->n_elements == 0 ;
}

boolean Ext__CwFeatureList::operator==(const Ext__CwFeatureList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Ext__CwFeature& Ext__CwFeatureList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MAP-MS-DataTypes.Ext-CwFeatureList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Ext__CwFeature**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Ext__CwFeature(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Ext__CwFeature;
}
return *val_ptr->value_elements[index_value];
}

Ext__CwFeature& Ext__CwFeatureList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return (*this)[(int)index_value];
}

const Ext__CwFeature& Ext__CwFeatureList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (index_value < 0) TTCN_error("Accessing an element of type @MAP-MS-DataTypes.Ext-CwFeatureList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MAP-MS-DataTypes.Ext-CwFeatureList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Ext__CwFeature& Ext__CwFeatureList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return (*this)[(int)index_value];
}

Ext__CwFeatureList Ext__CwFeatureList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

Ext__CwFeatureList Ext__CwFeatureList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

Ext__CwFeatureList Ext__CwFeatureList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

Ext__CwFeatureList Ext__CwFeatureList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
Ext__CwFeatureList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Ext__CwFeature(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

Ext__CwFeatureList Ext__CwFeatureList::operator+(const Ext__CwFeatureList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MAP-MS-DataTypes.Ext-CwFeatureList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
Ext__CwFeatureList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Ext__CwFeature(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Ext__CwFeature(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

Ext__CwFeatureList Ext__CwFeatureList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MAP-MS-DataTypes.Ext-CwFeatureList","element");
Ext__CwFeatureList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Ext__CwFeature(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

Ext__CwFeatureList Ext__CwFeatureList::replace(int index, int len, const Ext__CwFeatureList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MAP-MS-DataTypes.Ext-CwFeatureList","element");
Ext__CwFeatureList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Ext__CwFeature(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Ext__CwFeature(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Ext__CwFeature(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

Ext__CwFeatureList Ext__CwFeatureList::replace(int index, int len, const Ext__CwFeatureList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void Ext__CwFeatureList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Ext__CwFeature**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Ext__CwFeature(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Ext__CwFeature**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MAP-MS-DataTypes.Ext-CwFeatureList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Ext__CwFeature**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean Ext__CwFeatureList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int Ext__CwFeatureList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return val_ptr->n_elements;
}

int Ext__CwFeatureList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void Ext__CwFeatureList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void Ext__CwFeatureList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void Ext__CwFeatureList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MAP-MS-DataTypes.Ext-CwFeatureList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MAP-MS-DataTypes.Ext-CwFeatureList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void Ext__CwFeatureList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void Ext__CwFeatureList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
val_ptr->value_elements = (Ext__CwFeature**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Ext__CwFeature;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void Ext__CwFeatureList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Ext__CwFeatureList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Ext__CwFeatureList::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Ext__CwFeatureList::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (Ext__CwFeature**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new Ext__CwFeature;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int Ext__CwFeatureList::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int Ext__CwFeatureList::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Ext__CwFeatureList*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    Ext__CwFeature* val = new Ext__CwFeature;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (Ext__CwFeature**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int Ext__CwFeatureList::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int Ext__CwFeatureList::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void Ext__CwFeatureList::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void Ext__CwFeatureList::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void Ext__CwFeatureList_template::copy_value(const Ext__CwFeatureList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MAP-MS-DataTypes.Ext-CwFeatureList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Ext__CwFeature_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Ext__CwFeature_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Ext__CwFeature_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void Ext__CwFeatureList_template::copy_template(const Ext__CwFeatureList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Ext__CwFeature_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Ext__CwFeature_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Ext__CwFeature_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Ext__CwFeatureList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Ext__CwFeatureList_template(*other_value.implication_.precondition);
implication_.implied_template = new Ext__CwFeatureList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
break;
}
set_selection(other_value);
}

boolean Ext__CwFeatureList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const Ext__CwFeatureList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const Ext__CwFeatureList*)value_ptr)[value_index], legacy);
else return ((const Ext__CwFeatureList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template()
{
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(const Ext__CwFeatureList& other_value)
{
copy_value(other_value);
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(const OPTIONAL<Ext__CwFeatureList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ext__CwFeatureList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.Ext-CwFeatureList from an unbound optional field.");
}
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(Ext__CwFeatureList_template* p_precondition, Ext__CwFeatureList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(Dynamic_Match_Interface<Ext__CwFeatureList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Ext__CwFeatureList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Ext__CwFeatureList_template::Ext__CwFeatureList_template(const Ext__CwFeatureList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

Ext__CwFeatureList_template::~Ext__CwFeatureList_template()
{
clean_up();
}

void Ext__CwFeatureList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::operator=(const Ext__CwFeatureList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::operator=(const OPTIONAL<Ext__CwFeatureList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ext__CwFeatureList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
}
return *this;
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::operator=(const Ext__CwFeatureList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

Ext__CwFeature_template& Ext__CwFeatureList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MAP-MS-DataTypes.Ext-CwFeatureList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MAP-MS-DataTypes.Ext-CwFeatureList.");
    break;
}
return *single_value.value_elements[index_value];
}

Ext__CwFeature_template& Ext__CwFeatureList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return (*this)[(int)index_value];
}

const Ext__CwFeature_template& Ext__CwFeatureList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MAP-MS-DataTypes.Ext-CwFeatureList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MAP-MS-DataTypes.Ext-CwFeatureList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const Ext__CwFeature_template& Ext__CwFeatureList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return (*this)[(int)index_value];
}

void Ext__CwFeatureList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (Ext__CwFeature_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Ext__CwFeature_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Ext__CwFeature_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (Ext__CwFeature_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int Ext__CwFeatureList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int Ext__CwFeatureList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeatureList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeatureList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @MAP-MS-DataTypes.Ext-CwFeatureList");
}

boolean Ext__CwFeatureList_template::match(const Ext__CwFeatureList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
}
return FALSE;
}

boolean Ext__CwFeatureList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

Ext__CwFeatureList Ext__CwFeatureList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
Ext__CwFeatureList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

Ext__CwFeatureList Ext__CwFeatureList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

Ext__CwFeatureList Ext__CwFeatureList_template::replace(int index, int len, const Ext__CwFeatureList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

Ext__CwFeatureList Ext__CwFeatureList_template::replace(int index, int len, const Ext__CwFeatureList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void Ext__CwFeatureList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new Ext__CwFeatureList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
}
set_selection(template_type);
}

Ext__CwFeatureList_template& Ext__CwFeatureList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
return value_list.list_value[list_index];
}

void Ext__CwFeatureList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void Ext__CwFeatureList_template::log_match(const Ext__CwFeatureList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Ext__CwFeatureList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
}
}

void Ext__CwFeatureList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
single_value.value_elements = (Ext__CwFeature_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new Ext__CwFeature_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Ext__CwFeatureList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @MAP-MS-DataTypes.Ext-CwFeatureList.");
}
}

boolean Ext__CwFeatureList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Ext__CwFeatureList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Ext__CwFeatureList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void Ext__CwFeatureList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Ext__CwFeatureList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Ext__CwFeatureList_template* precondition = new Ext__CwFeatureList_template;
    precondition->set_param(*param.get_elem(0));
    Ext__CwFeatureList_template* implied_template = new Ext__CwFeatureList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Ext__CwFeatureList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@MAP-MS-DataTypes.Ext-CwFeatureList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void Ext__CwFeatureList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.Ext-CwFeatureList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.Ext-CwFeatureList");
}

boolean Ext__CwFeatureList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
Ext__CwFeature::Ext__CwFeature()
{
}

Ext__CwFeature::Ext__CwFeature(const MAP__CommonDataTypes::Ext__BasicServiceCode& par_basicService,
    const OCTETSTRING& par_ss__Status)
  :   field_basicService(par_basicService),
  field_ss__Status(par_ss__Status)
{
}

Ext__CwFeature::Ext__CwFeature(const Ext__CwFeature& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.Ext-CwFeature.");
if (other_value.basicService().is_bound()) field_basicService = other_value.basicService();
else field_basicService.clean_up();
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
}

void Ext__CwFeature::clean_up()
{
field_basicService.clean_up();
field_ss__Status.clean_up();
}

const TTCN_Typedescriptor_t* Ext__CwFeature::get_descriptor() const { return &Ext__CwFeature_descr_; }
Ext__CwFeature& Ext__CwFeature::operator=(const Ext__CwFeature& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.Ext-CwFeature.");
  if (other_value.basicService().is_bound()) field_basicService = other_value.basicService();
  else field_basicService.clean_up();
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
}
return *this;
}

boolean Ext__CwFeature::operator==(const Ext__CwFeature& other_value) const
{
return field_basicService==other_value.field_basicService
  && field_ss__Status==other_value.field_ss__Status;
}

boolean Ext__CwFeature::is_bound() const
{
return (field_basicService.is_bound())
  || (field_ss__Status.is_bound());
}
boolean Ext__CwFeature::is_value() const
{
return field_basicService.is_value()
  && field_ss__Status.is_value();
}
void Ext__CwFeature::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ basicService := ");
field_basicService.log();
TTCN_Logger::log_event_str(", ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(" }");
}

void Ext__CwFeature::set_implicit_omit()
{
if (basicService().is_bound()) basicService().set_implicit_omit();
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
}

void Ext__CwFeature::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.Ext-CwFeature has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) basicService().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicService")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicService().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.Ext-CwFeature: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.Ext-CwFeature");
  }
}

void Ext__CwFeature::encode_text(Text_Buf& text_buf) const
{
field_basicService.encode_text(text_buf);
field_ss__Status.encode_text(text_buf);
}

void Ext__CwFeature::decode_text(Text_Buf& text_buf)
{
field_basicService.decode_text(text_buf);
field_ss__Status.decode_text(text_buf);
}

void Ext__CwFeature::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Ext__CwFeature::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Ext__CwFeature::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("basicService': ");
  new_tlv->add_TLV(field_basicService.BER_encode_TLV(Ext__CwFeature_basicService_descr_, p_coding));
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(Ext__CwFeature_ss__Status_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Ext__CwFeature::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.Ext-CwFeature' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("basicService': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_basicService.BER_decode_TLV(Ext__CwFeature_basicService_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Status.BER_decode_TLV(Ext__CwFeature_ss__Status_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Ext__CwFeature::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.Ext-CwFeature.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "basicService");
    enc_len += field_basicService.JSON_encode(Ext__CwFeature_basicService_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(Ext__CwFeature_ss__Status_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int Ext__CwFeature::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Ext__CwFeature*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean basicService_found = FALSE;
  boolean ss__Status_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (12 == name_len && 0 == strncmp(fld_name, "basicService", name_len)) {
        basicService_found = TRUE;
         int ret_val = field_basicService.JSON_decode(Ext__CwFeature_basicService_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "basicService");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(Ext__CwFeature_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!basicService_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "basicService");
    return JSON_ERROR_FATAL;
  }
  if (!ss__Status_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Status");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int Ext__CwFeature::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  p_buf.put_c(c);
  field_basicService.OER_encode(Ext__CwFeature_basicService_descr_, p_buf);
  field_ss__Status.OER_encode(Ext__CwFeature_ss__Status_descr_, p_buf);
  return 0;
}

int Ext__CwFeature::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_basicService.OER_decode(Ext__CwFeature_basicService_descr_, p_buf, p_oer);
  field_ss__Status.OER_decode(Ext__CwFeature_ss__Status_descr_, p_buf, p_oer);
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void Ext__CwFeature::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
field_basicService.PER_encode(Ext__CwFeature_basicService_descr_, p_buf, p_options);
field_ss__Status.PER_encode(Ext__CwFeature_ss__Status_descr_, p_buf, p_options);
}

void Ext__CwFeature::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
field_basicService.PER_decode(Ext__CwFeature_basicService_descr_, p_buf, p_options);
field_ss__Status.PER_decode(Ext__CwFeature_ss__Status_descr_, p_buf, p_options);
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct Ext__CwFeature_template::single_value_struct {
MAP__CommonDataTypes::Ext__BasicServiceCode_template field_basicService;
OCTETSTRING_template field_ss__Status;
};

void Ext__CwFeature_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_basicService = ANY_VALUE;
single_value->field_ss__Status = ANY_VALUE;
}
}
}

void Ext__CwFeature_template::copy_value(const Ext__CwFeature& other_value)
{
single_value = new single_value_struct;
if (other_value.basicService().is_bound()) {
  single_value->field_basicService = other_value.basicService();
} else {
  single_value->field_basicService.clean_up();
}
if (other_value.ss__Status().is_bound()) {
  single_value->field_ss__Status = other_value.ss__Status();
} else {
  single_value->field_ss__Status.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Ext__CwFeature_template::copy_template(const Ext__CwFeature_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.basicService().get_selection()) {
single_value->field_basicService = other_value.basicService();
} else {
single_value->field_basicService.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Ext__CwFeature_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Ext__CwFeature_template(*other_value.implication_.precondition);
implication_.implied_template = new Ext__CwFeature_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeature.");
break;
}
set_selection(other_value);
}

Ext__CwFeature_template::Ext__CwFeature_template()
{
}

Ext__CwFeature_template::Ext__CwFeature_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Ext__CwFeature_template::Ext__CwFeature_template(const Ext__CwFeature& other_value)
{
copy_value(other_value);
}

Ext__CwFeature_template::Ext__CwFeature_template(const OPTIONAL<Ext__CwFeature>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ext__CwFeature&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.Ext-CwFeature from an unbound optional field.");
}
}

Ext__CwFeature_template::Ext__CwFeature_template(Ext__CwFeature_template* p_precondition, Ext__CwFeature_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Ext__CwFeature_template::Ext__CwFeature_template(Dynamic_Match_Interface<Ext__CwFeature>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Ext__CwFeature>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Ext__CwFeature_template::Ext__CwFeature_template(const Ext__CwFeature_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Ext__CwFeature_template::~Ext__CwFeature_template()
{
clean_up();
}

Ext__CwFeature_template& Ext__CwFeature_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Ext__CwFeature_template& Ext__CwFeature_template::operator=(const Ext__CwFeature& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Ext__CwFeature_template& Ext__CwFeature_template::operator=(const OPTIONAL<Ext__CwFeature>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ext__CwFeature&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.Ext-CwFeature.");
}
return *this;
}

Ext__CwFeature_template& Ext__CwFeature_template::operator=(const Ext__CwFeature_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Ext__CwFeature_template::match(const Ext__CwFeature& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.basicService().is_bound()) return FALSE;
if(!single_value->field_basicService.match(other_value.basicService(), legacy))return FALSE;
if(!other_value.ss__Status().is_bound()) return FALSE;
if(!single_value->field_ss__Status.match(other_value.ss__Status(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeature.");
}
return FALSE;
}

boolean Ext__CwFeature_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_basicService.is_bound()
 || single_value->field_ss__Status.is_bound();
}

boolean Ext__CwFeature_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_basicService.is_value()
 && single_value->field_ss__Status.is_value();
}

void Ext__CwFeature_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Ext__CwFeature Ext__CwFeature_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.Ext-CwFeature.");
Ext__CwFeature ret_val;
if (single_value->field_basicService.is_bound()) {
ret_val.basicService() = single_value->field_basicService.valueof();
}
if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
return ret_val;
}

void Ext__CwFeature_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.Ext-CwFeature.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Ext__CwFeature_template[list_length];
}

Ext__CwFeature_template& Ext__CwFeature_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.Ext-CwFeature.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.Ext-CwFeature.");
return value_list.list_value[list_index];
}

MAP__CommonDataTypes::Ext__BasicServiceCode_template& Ext__CwFeature_template::basicService()
{
set_specific();
return single_value->field_basicService;
}

const MAP__CommonDataTypes::Ext__BasicServiceCode_template& Ext__CwFeature_template::basicService() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field basicService of a non-specific template of type @MAP-MS-DataTypes.Ext-CwFeature.");
return single_value->field_basicService;
}

OCTETSTRING_template& Ext__CwFeature_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& Ext__CwFeature_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.Ext-CwFeature.");
return single_value->field_ss__Status;
}

int Ext__CwFeature_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.Ext-CwFeature containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeature.");
  }
  return 0;
}

void Ext__CwFeature_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ basicService := ");
single_value->field_basicService.log();
TTCN_Logger::log_event_str(", ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Ext__CwFeature_template::log_match(const Ext__CwFeature& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_basicService.match(match_value.basicService(), legacy)){
TTCN_Logger::log_logmatch_info(".basicService");
single_value->field_basicService.log_match(match_value.basicService(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ basicService := ");
single_value->field_basicService.log_match(match_value.basicService(), legacy);
TTCN_Logger::log_event_str(", ss_Status := ");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Ext__CwFeature_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (basicService().is_bound()) basicService().set_implicit_omit();
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
}

void Ext__CwFeature_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_basicService.encode_text(text_buf);
single_value->field_ss__Status.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.Ext-CwFeature.");
}
}

void Ext__CwFeature_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_basicService.decode_text(text_buf);
single_value->field_ss__Status.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Ext__CwFeature_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.Ext-CwFeature.");
}
}

void Ext__CwFeature_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Ext__CwFeature_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.Ext-CwFeature has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) basicService().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicService")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicService().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.Ext-CwFeature: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Ext__CwFeature_template* precondition = new Ext__CwFeature_template;
    precondition->set_param(*param.get_elem(0));
    Ext__CwFeature_template* implied_template = new Ext__CwFeature_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Ext__CwFeature_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.Ext-CwFeature");
  }
  is_ifpresent = param.get_ifpresent();
}

void Ext__CwFeature_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_basicService.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.Ext-CwFeature");
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.Ext-CwFeature");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.Ext-CwFeature");
}

boolean Ext__CwFeature_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Ext__CwFeature_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CallWaitingData::CallWaitingData()
{
}

CallWaitingData::CallWaitingData(const Ext__CwFeatureList& par_cwFeatureList,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE)
  :   field_cwFeatureList(par_cwFeatureList),
  field_notificationToCSE(par_notificationToCSE)
{
}

CallWaitingData::CallWaitingData(const CallWaitingData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.CallWaitingData.");
if (other_value.cwFeatureList().is_bound()) field_cwFeatureList = other_value.cwFeatureList();
else field_cwFeatureList.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
}

void CallWaitingData::clean_up()
{
field_cwFeatureList.clean_up();
field_notificationToCSE.clean_up();
}

const TTCN_Typedescriptor_t* CallWaitingData::get_descriptor() const { return &CallWaitingData_descr_; }
CallWaitingData& CallWaitingData::operator=(const CallWaitingData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.CallWaitingData.");
  if (other_value.cwFeatureList().is_bound()) field_cwFeatureList = other_value.cwFeatureList();
  else field_cwFeatureList.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
}
return *this;
}

boolean CallWaitingData::operator==(const CallWaitingData& other_value) const
{
return field_cwFeatureList==other_value.field_cwFeatureList
  && field_notificationToCSE==other_value.field_notificationToCSE;
}

boolean CallWaitingData::is_bound() const
{
return (field_cwFeatureList.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound());
}
boolean CallWaitingData::is_value() const
{
return field_cwFeatureList.is_value()
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value());
}
int CallWaitingData::size_of() const
{
  int ret_val = 1;
  if (field_notificationToCSE.ispresent()) ret_val++;
  return ret_val;
}

void CallWaitingData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ cwFeatureList := ");
field_cwFeatureList.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
}

void CallWaitingData::set_implicit_omit()
{
if (cwFeatureList().is_bound()) cwFeatureList().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void CallWaitingData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.CallWaitingData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cwFeatureList().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cwFeatureList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cwFeatureList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CallWaitingData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.CallWaitingData");
  }
}

void CallWaitingData::encode_text(Text_Buf& text_buf) const
{
field_cwFeatureList.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
}

void CallWaitingData::decode_text(Text_Buf& text_buf)
{
field_cwFeatureList.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
}

void CallWaitingData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CallWaitingData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* CallWaitingData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("cwFeatureList': ");
  new_tlv->add_TLV(field_cwFeatureList.BER_encode_TLV(CallWaitingData_cwFeatureList_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(CallWaitingData_notificationToCSE_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean CallWaitingData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.CallWaitingData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("cwFeatureList': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_cwFeatureList.BER_decode_TLV(CallWaitingData_cwFeatureList_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(CallWaitingData_notificationToCSE_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int CallWaitingData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.CallWaitingData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "cwFeatureList");
    enc_len += field_cwFeatureList.JSON_encode(CallWaitingData_cwFeatureList_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(CallWaitingData_notificationToCSE_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int CallWaitingData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const CallWaitingData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean cwFeatureList_found = FALSE;
  boolean notificationToCSE_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (13 == name_len && 0 == strncmp(fld_name, "cwFeatureList", name_len)) {
        cwFeatureList_found = TRUE;
         int ret_val = field_cwFeatureList.JSON_decode(CallWaitingData_cwFeatureList_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "cwFeatureList");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(CallWaitingData_notificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!cwFeatureList_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "cwFeatureList");
    return JSON_ERROR_FATAL;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int CallWaitingData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_notificationToCSE.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_cwFeatureList.OER_encode(CallWaitingData_cwFeatureList_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(CallWaitingData_notificationToCSE_descr_, p_buf);
  return 0;
}

int CallWaitingData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_cwFeatureList.OER_decode(CallWaitingData_cwFeatureList_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_notificationToCSE.OER_decode(CallWaitingData_notificationToCSE_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void CallWaitingData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
field_cwFeatureList.PER_encode(CallWaitingData_cwFeatureList_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(CallWaitingData_notificationToCSE_descr_, p_buf, p_options);
}

void CallWaitingData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
field_cwFeatureList.PER_decode(CallWaitingData_cwFeatureList_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(CallWaitingData_notificationToCSE_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct CallWaitingData_template::single_value_struct {
Ext__CwFeatureList_template field_cwFeatureList;
ASN_NULL_template field_notificationToCSE;
};

void CallWaitingData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_cwFeatureList = ANY_VALUE;
single_value->field_notificationToCSE = ANY_OR_OMIT;
}
}
}

void CallWaitingData_template::copy_value(const CallWaitingData& other_value)
{
single_value = new single_value_struct;
if (other_value.cwFeatureList().is_bound()) {
  single_value->field_cwFeatureList = other_value.cwFeatureList();
} else {
  single_value->field_cwFeatureList.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CallWaitingData_template::copy_template(const CallWaitingData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.cwFeatureList().get_selection()) {
single_value->field_cwFeatureList = other_value.cwFeatureList();
} else {
single_value->field_cwFeatureList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CallWaitingData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CallWaitingData_template(*other_value.implication_.precondition);
implication_.implied_template = new CallWaitingData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallWaitingData.");
break;
}
set_selection(other_value);
}

CallWaitingData_template::CallWaitingData_template()
{
}

CallWaitingData_template::CallWaitingData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CallWaitingData_template::CallWaitingData_template(const CallWaitingData& other_value)
{
copy_value(other_value);
}

CallWaitingData_template::CallWaitingData_template(const OPTIONAL<CallWaitingData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CallWaitingData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.CallWaitingData from an unbound optional field.");
}
}

CallWaitingData_template::CallWaitingData_template(CallWaitingData_template* p_precondition, CallWaitingData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CallWaitingData_template::CallWaitingData_template(Dynamic_Match_Interface<CallWaitingData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CallWaitingData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CallWaitingData_template::CallWaitingData_template(const CallWaitingData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CallWaitingData_template::~CallWaitingData_template()
{
clean_up();
}

CallWaitingData_template& CallWaitingData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CallWaitingData_template& CallWaitingData_template::operator=(const CallWaitingData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CallWaitingData_template& CallWaitingData_template::operator=(const OPTIONAL<CallWaitingData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CallWaitingData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.CallWaitingData.");
}
return *this;
}

CallWaitingData_template& CallWaitingData_template::operator=(const CallWaitingData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CallWaitingData_template::match(const CallWaitingData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.cwFeatureList().is_bound()) return FALSE;
if(!single_value->field_cwFeatureList.match(other_value.cwFeatureList(), legacy))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallWaitingData.");
}
return FALSE;
}

boolean CallWaitingData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_cwFeatureList.is_bound()
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound());
}

boolean CallWaitingData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_cwFeatureList.is_value()
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value());
}

void CallWaitingData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CallWaitingData CallWaitingData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.CallWaitingData.");
CallWaitingData ret_val;
if (single_value->field_cwFeatureList.is_bound()) {
ret_val.cwFeatureList() = single_value->field_cwFeatureList.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
return ret_val;
}

void CallWaitingData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.CallWaitingData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CallWaitingData_template[list_length];
}

CallWaitingData_template& CallWaitingData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.CallWaitingData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.CallWaitingData.");
return value_list.list_value[list_index];
}

Ext__CwFeatureList_template& CallWaitingData_template::cwFeatureList()
{
set_specific();
return single_value->field_cwFeatureList;
}

const Ext__CwFeatureList_template& CallWaitingData_template::cwFeatureList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cwFeatureList of a non-specific template of type @MAP-MS-DataTypes.CallWaitingData.");
return single_value->field_cwFeatureList;
}

ASN_NULL_template& CallWaitingData_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& CallWaitingData_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.CallWaitingData.");
return single_value->field_notificationToCSE;
}

int CallWaitingData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallWaitingData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallWaitingData.");
  }
  return 0;
}

void CallWaitingData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ cwFeatureList := ");
single_value->field_cwFeatureList.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CallWaitingData_template::log_match(const CallWaitingData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_cwFeatureList.match(match_value.cwFeatureList(), legacy)){
TTCN_Logger::log_logmatch_info(".cwFeatureList");
single_value->field_cwFeatureList.log_match(match_value.cwFeatureList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ cwFeatureList := ");
single_value->field_cwFeatureList.log_match(match_value.cwFeatureList(), legacy);
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CallWaitingData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (cwFeatureList().is_bound()) cwFeatureList().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void CallWaitingData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_cwFeatureList.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallWaitingData.");
}
}

void CallWaitingData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_cwFeatureList.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CallWaitingData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.CallWaitingData.");
}
}

void CallWaitingData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CallWaitingData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.CallWaitingData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cwFeatureList().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cwFeatureList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cwFeatureList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CallWaitingData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CallWaitingData_template* precondition = new CallWaitingData_template;
    precondition->set_param(*param.get_elem(0));
    CallWaitingData_template* implied_template = new CallWaitingData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CallWaitingData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.CallWaitingData");
  }
  is_ifpresent = param.get_ifpresent();
}

void CallWaitingData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_cwFeatureList.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CallWaitingData");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CallWaitingData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.CallWaitingData");
}

boolean CallWaitingData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CallWaitingData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CallHoldData::CallHoldData()
{
}

CallHoldData::CallHoldData(const OCTETSTRING& par_ss__Status,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE)
  :   field_ss__Status(par_ss__Status),
  field_notificationToCSE(par_notificationToCSE)
{
}

CallHoldData::CallHoldData(const CallHoldData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.CallHoldData.");
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
}

void CallHoldData::clean_up()
{
field_ss__Status.clean_up();
field_notificationToCSE.clean_up();
}

const TTCN_Typedescriptor_t* CallHoldData::get_descriptor() const { return &CallHoldData_descr_; }
CallHoldData& CallHoldData::operator=(const CallHoldData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.CallHoldData.");
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
}
return *this;
}

boolean CallHoldData::operator==(const CallHoldData& other_value) const
{
return field_ss__Status==other_value.field_ss__Status
  && field_notificationToCSE==other_value.field_notificationToCSE;
}

boolean CallHoldData::is_bound() const
{
return (field_ss__Status.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound());
}
boolean CallHoldData::is_value() const
{
return field_ss__Status.is_value()
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value());
}
int CallHoldData::size_of() const
{
  int ret_val = 1;
  if (field_notificationToCSE.ispresent()) ret_val++;
  return ret_val;
}

void CallHoldData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
}

void CallHoldData::set_implicit_omit()
{
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void CallHoldData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.CallHoldData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CallHoldData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.CallHoldData");
  }
}

void CallHoldData::encode_text(Text_Buf& text_buf) const
{
field_ss__Status.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
}

void CallHoldData::decode_text(Text_Buf& text_buf)
{
field_ss__Status.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
}

void CallHoldData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CallHoldData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* CallHoldData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(CallHoldData_ss__Status_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(CallHoldData_notificationToCSE_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean CallHoldData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.CallHoldData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Status.BER_decode_TLV(CallHoldData_ss__Status_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(CallHoldData_notificationToCSE_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int CallHoldData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.CallHoldData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(CallHoldData_ss__Status_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(CallHoldData_notificationToCSE_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int CallHoldData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const CallHoldData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ss__Status_found = FALSE;
  boolean notificationToCSE_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(CallHoldData_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(CallHoldData_notificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ss__Status_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Status");
    return JSON_ERROR_FATAL;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int CallHoldData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_notificationToCSE.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_ss__Status.OER_encode(CallHoldData_ss__Status_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(CallHoldData_notificationToCSE_descr_, p_buf);
  return 0;
}

int CallHoldData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ss__Status.OER_decode(CallHoldData_ss__Status_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_notificationToCSE.OER_decode(CallHoldData_notificationToCSE_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void CallHoldData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
field_ss__Status.PER_encode(CallHoldData_ss__Status_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(CallHoldData_notificationToCSE_descr_, p_buf, p_options);
}

void CallHoldData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
field_ss__Status.PER_decode(CallHoldData_ss__Status_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(CallHoldData_notificationToCSE_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct CallHoldData_template::single_value_struct {
OCTETSTRING_template field_ss__Status;
ASN_NULL_template field_notificationToCSE;
};

void CallHoldData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ss__Status = ANY_VALUE;
single_value->field_notificationToCSE = ANY_OR_OMIT;
}
}
}

void CallHoldData_template::copy_value(const CallHoldData& other_value)
{
single_value = new single_value_struct;
if (other_value.ss__Status().is_bound()) {
  single_value->field_ss__Status = other_value.ss__Status();
} else {
  single_value->field_ss__Status.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CallHoldData_template::copy_template(const CallHoldData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CallHoldData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CallHoldData_template(*other_value.implication_.precondition);
implication_.implied_template = new CallHoldData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallHoldData.");
break;
}
set_selection(other_value);
}

CallHoldData_template::CallHoldData_template()
{
}

CallHoldData_template::CallHoldData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CallHoldData_template::CallHoldData_template(const CallHoldData& other_value)
{
copy_value(other_value);
}

CallHoldData_template::CallHoldData_template(const OPTIONAL<CallHoldData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CallHoldData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.CallHoldData from an unbound optional field.");
}
}

CallHoldData_template::CallHoldData_template(CallHoldData_template* p_precondition, CallHoldData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CallHoldData_template::CallHoldData_template(Dynamic_Match_Interface<CallHoldData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CallHoldData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CallHoldData_template::CallHoldData_template(const CallHoldData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CallHoldData_template::~CallHoldData_template()
{
clean_up();
}

CallHoldData_template& CallHoldData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CallHoldData_template& CallHoldData_template::operator=(const CallHoldData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CallHoldData_template& CallHoldData_template::operator=(const OPTIONAL<CallHoldData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CallHoldData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.CallHoldData.");
}
return *this;
}

CallHoldData_template& CallHoldData_template::operator=(const CallHoldData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CallHoldData_template::match(const CallHoldData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ss__Status().is_bound()) return FALSE;
if(!single_value->field_ss__Status.match(other_value.ss__Status(), legacy))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallHoldData.");
}
return FALSE;
}

boolean CallHoldData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ss__Status.is_bound()
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound());
}

boolean CallHoldData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ss__Status.is_value()
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value());
}

void CallHoldData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CallHoldData CallHoldData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.CallHoldData.");
CallHoldData ret_val;
if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
return ret_val;
}

void CallHoldData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.CallHoldData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CallHoldData_template[list_length];
}

CallHoldData_template& CallHoldData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.CallHoldData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.CallHoldData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& CallHoldData_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& CallHoldData_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.CallHoldData.");
return single_value->field_ss__Status;
}

ASN_NULL_template& CallHoldData_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& CallHoldData_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.CallHoldData.");
return single_value->field_notificationToCSE;
}

int CallHoldData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.CallHoldData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallHoldData.");
  }
  return 0;
}

void CallHoldData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CallHoldData_template::log_match(const CallHoldData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CallHoldData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void CallHoldData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ss__Status.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.CallHoldData.");
}
}

void CallHoldData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ss__Status.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CallHoldData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.CallHoldData.");
}
}

void CallHoldData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CallHoldData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.CallHoldData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.CallHoldData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CallHoldData_template* precondition = new CallHoldData_template;
    precondition->set_param(*param.get_elem(0));
    CallHoldData_template* implied_template = new CallHoldData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CallHoldData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.CallHoldData");
  }
  is_ifpresent = param.get_ifpresent();
}

void CallHoldData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CallHoldData");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CallHoldData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.CallHoldData");
}

boolean CallHoldData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CallHoldData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ClipData::ClipData()
{
}

ClipData::ClipData(const OCTETSTRING& par_ss__Status,
    const MAP__SS__DataTypes::OverrideCategory& par_overrideCategory,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE)
  :   field_ss__Status(par_ss__Status),
  field_overrideCategory(par_overrideCategory),
  field_notificationToCSE(par_notificationToCSE)
{
}

ClipData::ClipData(const ClipData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ClipData.");
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
if (other_value.overrideCategory().is_bound()) field_overrideCategory = other_value.overrideCategory();
else field_overrideCategory.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
}

void ClipData::clean_up()
{
field_ss__Status.clean_up();
field_overrideCategory.clean_up();
field_notificationToCSE.clean_up();
}

const TTCN_Typedescriptor_t* ClipData::get_descriptor() const { return &ClipData_descr_; }
ClipData& ClipData::operator=(const ClipData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ClipData.");
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
  if (other_value.overrideCategory().is_bound()) field_overrideCategory = other_value.overrideCategory();
  else field_overrideCategory.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
}
return *this;
}

boolean ClipData::operator==(const ClipData& other_value) const
{
return field_ss__Status==other_value.field_ss__Status
  && field_overrideCategory==other_value.field_overrideCategory
  && field_notificationToCSE==other_value.field_notificationToCSE;
}

boolean ClipData::is_bound() const
{
return (field_ss__Status.is_bound())
  || (field_overrideCategory.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound());
}
boolean ClipData::is_value() const
{
return field_ss__Status.is_value()
  && field_overrideCategory.is_value()
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value());
}
int ClipData::size_of() const
{
  int ret_val = 2;
  if (field_notificationToCSE.ispresent()) ret_val++;
  return ret_val;
}

void ClipData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(", overrideCategory := ");
field_overrideCategory.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
}

void ClipData::set_implicit_omit()
{
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (overrideCategory().is_bound()) overrideCategory().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void ClipData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ClipData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) overrideCategory().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overrideCategory")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overrideCategory().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ClipData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ClipData");
  }
}

void ClipData::encode_text(Text_Buf& text_buf) const
{
field_ss__Status.encode_text(text_buf);
field_overrideCategory.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
}

void ClipData::decode_text(Text_Buf& text_buf)
{
field_ss__Status.decode_text(text_buf);
field_overrideCategory.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
}

void ClipData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ClipData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ClipData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(ClipData_ss__Status_descr_, p_coding));
  ec_1.set_msg("overrideCategory': ");
  new_tlv->add_TLV(field_overrideCategory.BER_encode_TLV(ClipData_overrideCategory_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(ClipData_notificationToCSE_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ClipData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ClipData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Status.BER_decode_TLV(ClipData_ss__Status_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("overrideCategory': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_overrideCategory.BER_decode_TLV(ClipData_overrideCategory_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(ClipData_notificationToCSE_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ClipData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ClipData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(ClipData_ss__Status_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "overrideCategory");
    enc_len += field_overrideCategory.JSON_encode(ClipData_overrideCategory_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(ClipData_notificationToCSE_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ClipData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ClipData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ss__Status_found = FALSE;
  boolean overrideCategory_found = FALSE;
  boolean notificationToCSE_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(ClipData_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (16 == name_len && 0 == strncmp(fld_name, "overrideCategory", name_len)) {
        overrideCategory_found = TRUE;
         int ret_val = field_overrideCategory.JSON_decode(ClipData_overrideCategory_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 16, "overrideCategory");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(ClipData_notificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ss__Status_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Status");
    return JSON_ERROR_FATAL;
  }
  if (!overrideCategory_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "overrideCategory");
    return JSON_ERROR_FATAL;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ClipData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_notificationToCSE.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_ss__Status.OER_encode(ClipData_ss__Status_descr_, p_buf);
  field_overrideCategory.OER_encode(ClipData_overrideCategory_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(ClipData_notificationToCSE_descr_, p_buf);
  return 0;
}

int ClipData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ss__Status.OER_decode(ClipData_ss__Status_descr_, p_buf, p_oer);
  field_overrideCategory.OER_decode(ClipData_overrideCategory_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_notificationToCSE.OER_decode(ClipData_notificationToCSE_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void ClipData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
field_ss__Status.PER_encode(ClipData_ss__Status_descr_, p_buf, p_options);
field_overrideCategory.PER_encode(ClipData_overrideCategory_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(ClipData_notificationToCSE_descr_, p_buf, p_options);
}

void ClipData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
field_ss__Status.PER_decode(ClipData_ss__Status_descr_, p_buf, p_options);
field_overrideCategory.PER_decode(ClipData_overrideCategory_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(ClipData_notificationToCSE_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ClipData_template::single_value_struct {
OCTETSTRING_template field_ss__Status;
MAP__SS__DataTypes::OverrideCategory_template field_overrideCategory;
ASN_NULL_template field_notificationToCSE;
};

void ClipData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ss__Status = ANY_VALUE;
single_value->field_overrideCategory = ANY_VALUE;
single_value->field_notificationToCSE = ANY_OR_OMIT;
}
}
}

void ClipData_template::copy_value(const ClipData& other_value)
{
single_value = new single_value_struct;
if (other_value.ss__Status().is_bound()) {
  single_value->field_ss__Status = other_value.ss__Status();
} else {
  single_value->field_ss__Status.clean_up();
}
if (other_value.overrideCategory().is_bound()) {
  single_value->field_overrideCategory = other_value.overrideCategory();
} else {
  single_value->field_overrideCategory.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ClipData_template::copy_template(const ClipData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.overrideCategory().get_selection()) {
single_value->field_overrideCategory = other_value.overrideCategory();
} else {
single_value->field_overrideCategory.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ClipData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ClipData_template(*other_value.implication_.precondition);
implication_.implied_template = new ClipData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClipData.");
break;
}
set_selection(other_value);
}

ClipData_template::ClipData_template()
{
}

ClipData_template::ClipData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ClipData_template::ClipData_template(const ClipData& other_value)
{
copy_value(other_value);
}

ClipData_template::ClipData_template(const OPTIONAL<ClipData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ClipData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ClipData from an unbound optional field.");
}
}

ClipData_template::ClipData_template(ClipData_template* p_precondition, ClipData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ClipData_template::ClipData_template(Dynamic_Match_Interface<ClipData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ClipData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ClipData_template::ClipData_template(const ClipData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ClipData_template::~ClipData_template()
{
clean_up();
}

ClipData_template& ClipData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ClipData_template& ClipData_template::operator=(const ClipData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ClipData_template& ClipData_template::operator=(const OPTIONAL<ClipData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ClipData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ClipData.");
}
return *this;
}

ClipData_template& ClipData_template::operator=(const ClipData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ClipData_template::match(const ClipData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ss__Status().is_bound()) return FALSE;
if(!single_value->field_ss__Status.match(other_value.ss__Status(), legacy))return FALSE;
if(!other_value.overrideCategory().is_bound()) return FALSE;
if(!single_value->field_overrideCategory.match(other_value.overrideCategory(), legacy))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClipData.");
}
return FALSE;
}

boolean ClipData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ss__Status.is_bound()
 || single_value->field_overrideCategory.is_bound()
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound());
}

boolean ClipData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ss__Status.is_value()
 && single_value->field_overrideCategory.is_value()
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value());
}

void ClipData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ClipData ClipData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ClipData.");
ClipData ret_val;
if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
if (single_value->field_overrideCategory.is_bound()) {
ret_val.overrideCategory() = single_value->field_overrideCategory.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
return ret_val;
}

void ClipData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ClipData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ClipData_template[list_length];
}

ClipData_template& ClipData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ClipData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ClipData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ClipData_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& ClipData_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.ClipData.");
return single_value->field_ss__Status;
}

MAP__SS__DataTypes::OverrideCategory_template& ClipData_template::overrideCategory()
{
set_specific();
return single_value->field_overrideCategory;
}

const MAP__SS__DataTypes::OverrideCategory_template& ClipData_template::overrideCategory() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field overrideCategory of a non-specific template of type @MAP-MS-DataTypes.ClipData.");
return single_value->field_overrideCategory;
}

ASN_NULL_template& ClipData_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& ClipData_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.ClipData.");
return single_value->field_notificationToCSE;
}

int ClipData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClipData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClipData.");
  }
  return 0;
}

void ClipData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(", overrideCategory := ");
single_value->field_overrideCategory.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ClipData_template::log_match(const ClipData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_overrideCategory.match(match_value.overrideCategory(), legacy)){
TTCN_Logger::log_logmatch_info(".overrideCategory");
single_value->field_overrideCategory.log_match(match_value.overrideCategory(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::log_event_str(", overrideCategory := ");
single_value->field_overrideCategory.log_match(match_value.overrideCategory(), legacy);
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ClipData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (overrideCategory().is_bound()) overrideCategory().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void ClipData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ss__Status.encode_text(text_buf);
single_value->field_overrideCategory.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClipData.");
}
}

void ClipData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ss__Status.decode_text(text_buf);
single_value->field_overrideCategory.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ClipData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ClipData.");
}
}

void ClipData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ClipData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ClipData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) overrideCategory().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overrideCategory")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overrideCategory().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ClipData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ClipData_template* precondition = new ClipData_template;
    precondition->set_param(*param.get_elem(0));
    ClipData_template* implied_template = new ClipData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ClipData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ClipData");
  }
  is_ifpresent = param.get_ifpresent();
}

void ClipData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClipData");
single_value->field_overrideCategory.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClipData");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClipData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ClipData");
}

boolean ClipData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ClipData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ClirData::ClirData()
{
}

ClirData::ClirData(const OCTETSTRING& par_ss__Status,
    const OPTIONAL< MAP__SS__DataTypes::CliRestrictionOption >& par_cliRestrictionOption,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE)
  :   field_ss__Status(par_ss__Status),
  field_cliRestrictionOption(par_cliRestrictionOption),
  field_notificationToCSE(par_notificationToCSE)
{
}

ClirData::ClirData(const ClirData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ClirData.");
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
if (other_value.cliRestrictionOption().is_bound()) field_cliRestrictionOption = other_value.cliRestrictionOption();
else field_cliRestrictionOption.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
}

void ClirData::clean_up()
{
field_ss__Status.clean_up();
field_cliRestrictionOption.clean_up();
field_notificationToCSE.clean_up();
}

const TTCN_Typedescriptor_t* ClirData::get_descriptor() const { return &ClirData_descr_; }
ClirData& ClirData::operator=(const ClirData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ClirData.");
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
  if (other_value.cliRestrictionOption().is_bound()) field_cliRestrictionOption = other_value.cliRestrictionOption();
  else field_cliRestrictionOption.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
}
return *this;
}

boolean ClirData::operator==(const ClirData& other_value) const
{
return field_ss__Status==other_value.field_ss__Status
  && field_cliRestrictionOption==other_value.field_cliRestrictionOption
  && field_notificationToCSE==other_value.field_notificationToCSE;
}

boolean ClirData::is_bound() const
{
return (field_ss__Status.is_bound())
  || (OPTIONAL_OMIT == field_cliRestrictionOption.get_selection() || field_cliRestrictionOption.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound());
}
boolean ClirData::is_value() const
{
return field_ss__Status.is_value()
  && (OPTIONAL_OMIT == field_cliRestrictionOption.get_selection() || field_cliRestrictionOption.is_value())
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value());
}
int ClirData::size_of() const
{
  int ret_val = 1;
  if (field_cliRestrictionOption.ispresent()) ret_val++;
  if (field_notificationToCSE.ispresent()) ret_val++;
  return ret_val;
}

void ClirData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(", cliRestrictionOption := ");
field_cliRestrictionOption.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
}

void ClirData::set_implicit_omit()
{
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!cliRestrictionOption().is_bound()) cliRestrictionOption() = OMIT_VALUE;
else cliRestrictionOption().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void ClirData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ClirData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cliRestrictionOption().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cliRestrictionOption")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cliRestrictionOption().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ClirData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ClirData");
  }
}

void ClirData::encode_text(Text_Buf& text_buf) const
{
field_ss__Status.encode_text(text_buf);
field_cliRestrictionOption.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
}

void ClirData::decode_text(Text_Buf& text_buf)
{
field_ss__Status.decode_text(text_buf);
field_cliRestrictionOption.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
}

void ClirData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ClirData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ClirData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(ClirData_ss__Status_descr_, p_coding));
  ec_1.set_msg("cliRestrictionOption': ");
  new_tlv->add_TLV(field_cliRestrictionOption.BER_encode_TLV(ClirData_cliRestrictionOption_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(ClirData_notificationToCSE_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ClirData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ClirData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Status.BER_decode_TLV(ClirData_ss__Status_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("cliRestrictionOption': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_cliRestrictionOption=OMIT_VALUE;
    else {
      field_cliRestrictionOption.BER_decode_TLV(ClirData_cliRestrictionOption_descr_, tmp_tlv, L_form);
      if(field_cliRestrictionOption.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(ClirData_notificationToCSE_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ClirData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ClirData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(ClirData_ss__Status_descr_, p_tok, FALSE);
  }

  if (field_cliRestrictionOption.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "cliRestrictionOption");
    enc_len += field_cliRestrictionOption.JSON_encode(ClirData_cliRestrictionOption_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(ClirData_notificationToCSE_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ClirData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ClirData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ss__Status_found = FALSE;
  boolean cliRestrictionOption_found = FALSE;
  boolean notificationToCSE_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(ClirData_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (20 == name_len && 0 == strncmp(fld_name, "cliRestrictionOption", name_len)) {
        cliRestrictionOption_found = TRUE;
         int ret_val = field_cliRestrictionOption.JSON_decode(ClirData_cliRestrictionOption_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "cliRestrictionOption");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(ClirData_notificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ss__Status_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Status");
    return JSON_ERROR_FATAL;
  }
  if (!cliRestrictionOption_found) {
    field_cliRestrictionOption = OMIT_VALUE;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ClirData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_cliRestrictionOption.is_present()) {
    c |= 64;
  }
  if (field_notificationToCSE.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_ss__Status.OER_encode(ClirData_ss__Status_descr_, p_buf);
  if (field_cliRestrictionOption.is_present())
    field_cliRestrictionOption.OER_encode(ClirData_cliRestrictionOption_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(ClirData_notificationToCSE_descr_, p_buf);
  return 0;
}

int ClirData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ss__Status.OER_decode(ClirData_ss__Status_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_cliRestrictionOption.OER_decode(ClirData_cliRestrictionOption_descr_, p_buf, p_oer);
 else
    field_cliRestrictionOption = OMIT_VALUE;
  if (uc[0] & 32)
    field_notificationToCSE.OER_decode(ClirData_notificationToCSE_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void ClirData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_cliRestrictionOption_present = field_cliRestrictionOption.is_present();
p_buf.PER_put_bit(field_cliRestrictionOption_present);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
field_ss__Status.PER_encode(ClirData_ss__Status_descr_, p_buf, p_options);
if (field_cliRestrictionOption_present) field_cliRestrictionOption.PER_encode(ClirData_cliRestrictionOption_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(ClirData_notificationToCSE_descr_, p_buf, p_options);
}

void ClirData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_cliRestrictionOption_present = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
field_ss__Status.PER_decode(ClirData_ss__Status_descr_, p_buf, p_options);
if (field_cliRestrictionOption_present) field_cliRestrictionOption.PER_decode(ClirData_cliRestrictionOption_descr_, p_buf, p_options);
else field_cliRestrictionOption = OMIT_VALUE;
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(ClirData_notificationToCSE_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ClirData_template::single_value_struct {
OCTETSTRING_template field_ss__Status;
MAP__SS__DataTypes::CliRestrictionOption_template field_cliRestrictionOption;
ASN_NULL_template field_notificationToCSE;
};

void ClirData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ss__Status = ANY_VALUE;
single_value->field_cliRestrictionOption = ANY_OR_OMIT;
single_value->field_notificationToCSE = ANY_OR_OMIT;
}
}
}

void ClirData_template::copy_value(const ClirData& other_value)
{
single_value = new single_value_struct;
if (other_value.ss__Status().is_bound()) {
  single_value->field_ss__Status = other_value.ss__Status();
} else {
  single_value->field_ss__Status.clean_up();
}
if (other_value.cliRestrictionOption().is_bound()) {
  if (other_value.cliRestrictionOption().ispresent()) single_value->field_cliRestrictionOption = other_value.cliRestrictionOption()();
  else single_value->field_cliRestrictionOption = OMIT_VALUE;
} else {
  single_value->field_cliRestrictionOption.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ClirData_template::copy_template(const ClirData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cliRestrictionOption().get_selection()) {
single_value->field_cliRestrictionOption = other_value.cliRestrictionOption();
} else {
single_value->field_cliRestrictionOption.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ClirData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ClirData_template(*other_value.implication_.precondition);
implication_.implied_template = new ClirData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClirData.");
break;
}
set_selection(other_value);
}

ClirData_template::ClirData_template()
{
}

ClirData_template::ClirData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ClirData_template::ClirData_template(const ClirData& other_value)
{
copy_value(other_value);
}

ClirData_template::ClirData_template(const OPTIONAL<ClirData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ClirData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ClirData from an unbound optional field.");
}
}

ClirData_template::ClirData_template(ClirData_template* p_precondition, ClirData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ClirData_template::ClirData_template(Dynamic_Match_Interface<ClirData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ClirData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ClirData_template::ClirData_template(const ClirData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ClirData_template::~ClirData_template()
{
clean_up();
}

ClirData_template& ClirData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ClirData_template& ClirData_template::operator=(const ClirData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ClirData_template& ClirData_template::operator=(const OPTIONAL<ClirData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ClirData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ClirData.");
}
return *this;
}

ClirData_template& ClirData_template::operator=(const ClirData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ClirData_template::match(const ClirData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ss__Status().is_bound()) return FALSE;
if(!single_value->field_ss__Status.match(other_value.ss__Status(), legacy))return FALSE;
if(!other_value.cliRestrictionOption().is_bound()) return FALSE;
if((other_value.cliRestrictionOption().ispresent() ? !single_value->field_cliRestrictionOption.match((const MAP__SS__DataTypes::CliRestrictionOption&)other_value.cliRestrictionOption(), legacy) : !single_value->field_cliRestrictionOption.match_omit(legacy)))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClirData.");
}
return FALSE;
}

boolean ClirData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ss__Status.is_bound()
 || (single_value->field_cliRestrictionOption.is_omit() || single_value->field_cliRestrictionOption.is_bound())
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound());
}

boolean ClirData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ss__Status.is_value()
 && (single_value->field_cliRestrictionOption.is_omit() || single_value->field_cliRestrictionOption.is_value())
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value());
}

void ClirData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ClirData ClirData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ClirData.");
ClirData ret_val;
if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
if (single_value->field_cliRestrictionOption.is_omit()) ret_val.cliRestrictionOption() = OMIT_VALUE;
else if (single_value->field_cliRestrictionOption.is_bound()) {
ret_val.cliRestrictionOption() = single_value->field_cliRestrictionOption.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
return ret_val;
}

void ClirData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ClirData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ClirData_template[list_length];
}

ClirData_template& ClirData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ClirData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ClirData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ClirData_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& ClirData_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.ClirData.");
return single_value->field_ss__Status;
}

MAP__SS__DataTypes::CliRestrictionOption_template& ClirData_template::cliRestrictionOption()
{
set_specific();
return single_value->field_cliRestrictionOption;
}

const MAP__SS__DataTypes::CliRestrictionOption_template& ClirData_template::cliRestrictionOption() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cliRestrictionOption of a non-specific template of type @MAP-MS-DataTypes.ClirData.");
return single_value->field_cliRestrictionOption;
}

ASN_NULL_template& ClirData_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& ClirData_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.ClirData.");
return single_value->field_notificationToCSE;
}

int ClirData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_cliRestrictionOption.is_present()) ret_val++;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ClirData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClirData.");
  }
  return 0;
}

void ClirData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(", cliRestrictionOption := ");
single_value->field_cliRestrictionOption.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ClirData_template::log_match(const ClirData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.cliRestrictionOption().ispresent()){
if(!single_value->field_cliRestrictionOption.match(match_value.cliRestrictionOption(), legacy)){
TTCN_Logger::log_logmatch_info(".cliRestrictionOption");
single_value->field_cliRestrictionOption.log_match(match_value.cliRestrictionOption(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cliRestrictionOption.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cliRestrictionOption := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cliRestrictionOption.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::log_event_str(", cliRestrictionOption := ");
if (match_value.cliRestrictionOption().ispresent()) {
single_value->field_cliRestrictionOption.log_match(match_value.cliRestrictionOption(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cliRestrictionOption.log();
if (single_value->field_cliRestrictionOption.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ClirData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!cliRestrictionOption().is_bound()) cliRestrictionOption() = OMIT_VALUE;
else cliRestrictionOption().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void ClirData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ss__Status.encode_text(text_buf);
single_value->field_cliRestrictionOption.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ClirData.");
}
}

void ClirData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ss__Status.decode_text(text_buf);
single_value->field_cliRestrictionOption.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ClirData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ClirData.");
}
}

void ClirData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ClirData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ClirData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cliRestrictionOption().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cliRestrictionOption")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cliRestrictionOption().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ClirData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ClirData_template* precondition = new ClirData_template;
    precondition->set_param(*param.get_elem(0));
    ClirData_template* implied_template = new ClirData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ClirData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ClirData");
  }
  is_ifpresent = param.get_ifpresent();
}

void ClirData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClirData");
single_value->field_cliRestrictionOption.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClirData");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ClirData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ClirData");
}

boolean ClirData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ClirData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EctData::EctData()
{
}

EctData::EctData(const OCTETSTRING& par_ss__Status,
    const OPTIONAL< ASN_NULL >& par_notificationToCSE)
  :   field_ss__Status(par_ss__Status),
  field_notificationToCSE(par_notificationToCSE)
{
}

EctData::EctData(const EctData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.EctData.");
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
else field_notificationToCSE.clean_up();
}

void EctData::clean_up()
{
field_ss__Status.clean_up();
field_notificationToCSE.clean_up();
}

const TTCN_Typedescriptor_t* EctData::get_descriptor() const { return &EctData_descr_; }
EctData& EctData::operator=(const EctData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.EctData.");
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
  if (other_value.notificationToCSE().is_bound()) field_notificationToCSE = other_value.notificationToCSE();
  else field_notificationToCSE.clean_up();
}
return *this;
}

boolean EctData::operator==(const EctData& other_value) const
{
return field_ss__Status==other_value.field_ss__Status
  && field_notificationToCSE==other_value.field_notificationToCSE;
}

boolean EctData::is_bound() const
{
return (field_ss__Status.is_bound())
  || (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_bound());
}
boolean EctData::is_value() const
{
return field_ss__Status.is_value()
  && (OPTIONAL_OMIT == field_notificationToCSE.get_selection() || field_notificationToCSE.is_value());
}
int EctData::size_of() const
{
  int ret_val = 1;
  if (field_notificationToCSE.ispresent()) ret_val++;
  return ret_val;
}

void EctData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
}

void EctData::set_implicit_omit()
{
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void EctData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.EctData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.EctData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.EctData");
  }
}

void EctData::encode_text(Text_Buf& text_buf) const
{
field_ss__Status.encode_text(text_buf);
field_notificationToCSE.encode_text(text_buf);
}

void EctData::decode_text(Text_Buf& text_buf)
{
field_ss__Status.decode_text(text_buf);
field_notificationToCSE.decode_text(text_buf);
}

void EctData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EctData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* EctData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(EctData_ss__Status_descr_, p_coding));
  ec_1.set_msg("notificationToCSE': ");
  new_tlv->add_TLV(field_notificationToCSE.BER_encode_TLV(EctData_notificationToCSE_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean EctData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.EctData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Status.BER_decode_TLV(EctData_ss__Status_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("notificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_notificationToCSE=OMIT_VALUE;
    else {
      field_notificationToCSE.BER_decode_TLV(EctData_notificationToCSE_descr_, tmp_tlv, L_form);
      if(field_notificationToCSE.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int EctData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.EctData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(EctData_ss__Status_descr_, p_tok, FALSE);
  }

  if (field_notificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "notificationToCSE");
    enc_len += field_notificationToCSE.JSON_encode(EctData_notificationToCSE_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int EctData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const EctData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ss__Status_found = FALSE;
  boolean notificationToCSE_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(EctData_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "notificationToCSE", name_len)) {
        notificationToCSE_found = TRUE;
         int ret_val = field_notificationToCSE.JSON_decode(EctData_notificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "notificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ss__Status_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Status");
    return JSON_ERROR_FATAL;
  }
  if (!notificationToCSE_found) {
    field_notificationToCSE = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int EctData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_notificationToCSE.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_ss__Status.OER_encode(EctData_ss__Status_descr_, p_buf);
  if (field_notificationToCSE.is_present())
    field_notificationToCSE.OER_encode(EctData_notificationToCSE_descr_, p_buf);
  return 0;
}

int EctData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ss__Status.OER_decode(EctData_ss__Status_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_notificationToCSE.OER_decode(EctData_notificationToCSE_descr_, p_buf, p_oer);
 else
    field_notificationToCSE = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void EctData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_notificationToCSE_present = field_notificationToCSE.is_present();
p_buf.PER_put_bit(field_notificationToCSE_present);
field_ss__Status.PER_encode(EctData_ss__Status_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_encode(EctData_notificationToCSE_descr_, p_buf, p_options);
}

void EctData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_notificationToCSE_present = p_buf.PER_get_bit();
field_ss__Status.PER_decode(EctData_ss__Status_descr_, p_buf, p_options);
if (field_notificationToCSE_present) field_notificationToCSE.PER_decode(EctData_notificationToCSE_descr_, p_buf, p_options);
else field_notificationToCSE = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct EctData_template::single_value_struct {
OCTETSTRING_template field_ss__Status;
ASN_NULL_template field_notificationToCSE;
};

void EctData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ss__Status = ANY_VALUE;
single_value->field_notificationToCSE = ANY_OR_OMIT;
}
}
}

void EctData_template::copy_value(const EctData& other_value)
{
single_value = new single_value_struct;
if (other_value.ss__Status().is_bound()) {
  single_value->field_ss__Status = other_value.ss__Status();
} else {
  single_value->field_ss__Status.clean_up();
}
if (other_value.notificationToCSE().is_bound()) {
  if (other_value.notificationToCSE().ispresent()) single_value->field_notificationToCSE = other_value.notificationToCSE()();
  else single_value->field_notificationToCSE = OMIT_VALUE;
} else {
  single_value->field_notificationToCSE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EctData_template::copy_template(const EctData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.notificationToCSE().get_selection()) {
single_value->field_notificationToCSE = other_value.notificationToCSE();
} else {
single_value->field_notificationToCSE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EctData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EctData_template(*other_value.implication_.precondition);
implication_.implied_template = new EctData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.EctData.");
break;
}
set_selection(other_value);
}

EctData_template::EctData_template()
{
}

EctData_template::EctData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EctData_template::EctData_template(const EctData& other_value)
{
copy_value(other_value);
}

EctData_template::EctData_template(const OPTIONAL<EctData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EctData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.EctData from an unbound optional field.");
}
}

EctData_template::EctData_template(EctData_template* p_precondition, EctData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EctData_template::EctData_template(Dynamic_Match_Interface<EctData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EctData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EctData_template::EctData_template(const EctData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EctData_template::~EctData_template()
{
clean_up();
}

EctData_template& EctData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EctData_template& EctData_template::operator=(const EctData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EctData_template& EctData_template::operator=(const OPTIONAL<EctData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EctData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.EctData.");
}
return *this;
}

EctData_template& EctData_template::operator=(const EctData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EctData_template::match(const EctData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ss__Status().is_bound()) return FALSE;
if(!single_value->field_ss__Status.match(other_value.ss__Status(), legacy))return FALSE;
if(!other_value.notificationToCSE().is_bound()) return FALSE;
if((other_value.notificationToCSE().ispresent() ? !single_value->field_notificationToCSE.match((const ASN_NULL&)other_value.notificationToCSE(), legacy) : !single_value->field_notificationToCSE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.EctData.");
}
return FALSE;
}

boolean EctData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ss__Status.is_bound()
 || (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_bound());
}

boolean EctData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ss__Status.is_value()
 && (single_value->field_notificationToCSE.is_omit() || single_value->field_notificationToCSE.is_value());
}

void EctData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EctData EctData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.EctData.");
EctData ret_val;
if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
if (single_value->field_notificationToCSE.is_omit()) ret_val.notificationToCSE() = OMIT_VALUE;
else if (single_value->field_notificationToCSE.is_bound()) {
ret_val.notificationToCSE() = single_value->field_notificationToCSE.valueof();
}
return ret_val;
}

void EctData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.EctData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EctData_template[list_length];
}

EctData_template& EctData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.EctData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.EctData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& EctData_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& EctData_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.EctData.");
return single_value->field_ss__Status;
}

ASN_NULL_template& EctData_template::notificationToCSE()
{
set_specific();
return single_value->field_notificationToCSE;
}

const ASN_NULL_template& EctData_template::notificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field notificationToCSE of a non-specific template of type @MAP-MS-DataTypes.EctData.");
return single_value->field_notificationToCSE;
}

int EctData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_notificationToCSE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.EctData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.EctData.");
  }
  return 0;
}

void EctData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(", notificationToCSE := ");
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EctData_template::log_match(const EctData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.notificationToCSE().ispresent()){
if(!single_value->field_notificationToCSE.match(match_value.notificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".notificationToCSE");
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_notificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".notificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_notificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ss_Status := ");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::log_event_str(", notificationToCSE := ");
if (match_value.notificationToCSE().ispresent()) {
single_value->field_notificationToCSE.log_match(match_value.notificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_notificationToCSE.log();
if (single_value->field_notificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EctData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ss__Status().is_bound()) ss__Status().set_implicit_omit();
if (!notificationToCSE().is_bound()) notificationToCSE() = OMIT_VALUE;
else notificationToCSE().set_implicit_omit();
}

void EctData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ss__Status.encode_text(text_buf);
single_value->field_notificationToCSE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.EctData.");
}
}

void EctData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ss__Status.decode_text(text_buf);
single_value->field_notificationToCSE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EctData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.EctData.");
}
}

void EctData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EctData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.EctData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) notificationToCSE().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "notificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          notificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.EctData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EctData_template* precondition = new EctData_template;
    precondition->set_param(*param.get_elem(0));
    EctData_template* implied_template = new EctData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EctData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.EctData");
  }
  is_ifpresent = param.get_ifpresent();
}

void EctData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.EctData");
single_value->field_notificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.EctData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.EctData");
}

boolean EctData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EctData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

AnyTimeModificationArg::AnyTimeModificationArg()
{
}

AnyTimeModificationArg::AnyTimeModificationArg(const MAP__CommonDataTypes::SubscriberIdentity& par_subscriberIdentity,
    const OCTETSTRING& par_gsmSCF__Address,
    const OPTIONAL< ModificationRequestFor__CF__Info >& par_modificationRequestFor__CF__Info,
    const OPTIONAL< ModificationRequestFor__CB__Info >& par_modificationRequestFor__CB__Info,
    const OPTIONAL< ModificationRequestFor__CSI >& par_modificationRequestFor__CSI,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< ASN_NULL >& par_longFTN__Supported,
    const OPTIONAL< ModificationRequestFor__ODB__data >& par_modificationRequestFor__ODB__data,
    const OPTIONAL< ModificationRequestFor__IP__SM__GW__Data >& par_modificationRequestFor__IP__SM__GW__Data,
    const OPTIONAL< BITSTRING >& par_activationRequestForUE__reachability,
    const OPTIONAL< ModificationRequestFor__CSG >& par_modificationRequestFor__CSG,
    const OPTIONAL< ModificationRequestFor__CW__Info >& par_modificationRequestFor__CW__Data,
    const OPTIONAL< ModificationRequestFor__CLIP__Info >& par_modificationRequestFor__CLIP__Data,
    const OPTIONAL< ModificationRequestFor__CLIR__Info >& par_modificationRequestFor__CLIR__Data,
    const OPTIONAL< ModificationRequestFor__CH__Info >& par_modificationRequestFor__HOLD__Data,
    const OPTIONAL< ModificationRequestFor__ECT__Info >& par_modificationRequestFor__ECT__Data)
  :   field_subscriberIdentity(par_subscriberIdentity),
  field_gsmSCF__Address(par_gsmSCF__Address),
  field_modificationRequestFor__CF__Info(par_modificationRequestFor__CF__Info),
  field_modificationRequestFor__CB__Info(par_modificationRequestFor__CB__Info),
  field_modificationRequestFor__CSI(par_modificationRequestFor__CSI),
  field_extensionContainer(par_extensionContainer),
  field_longFTN__Supported(par_longFTN__Supported),
  field_modificationRequestFor__ODB__data(par_modificationRequestFor__ODB__data),
  field_modificationRequestFor__IP__SM__GW__Data(par_modificationRequestFor__IP__SM__GW__Data),
  field_activationRequestForUE__reachability(par_activationRequestForUE__reachability),
  field_modificationRequestFor__CSG(par_modificationRequestFor__CSG),
  field_modificationRequestFor__CW__Data(par_modificationRequestFor__CW__Data),
  field_modificationRequestFor__CLIP__Data(par_modificationRequestFor__CLIP__Data),
  field_modificationRequestFor__CLIR__Data(par_modificationRequestFor__CLIR__Data),
  field_modificationRequestFor__HOLD__Data(par_modificationRequestFor__HOLD__Data),
  field_modificationRequestFor__ECT__Data(par_modificationRequestFor__ECT__Data)
{
}

AnyTimeModificationArg::AnyTimeModificationArg(const AnyTimeModificationArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
if (other_value.subscriberIdentity().is_bound()) field_subscriberIdentity = other_value.subscriberIdentity();
else field_subscriberIdentity.clean_up();
if (other_value.gsmSCF__Address().is_bound()) field_gsmSCF__Address = other_value.gsmSCF__Address();
else field_gsmSCF__Address.clean_up();
if (other_value.modificationRequestFor__CF__Info().is_bound()) field_modificationRequestFor__CF__Info = other_value.modificationRequestFor__CF__Info();
else field_modificationRequestFor__CF__Info.clean_up();
if (other_value.modificationRequestFor__CB__Info().is_bound()) field_modificationRequestFor__CB__Info = other_value.modificationRequestFor__CB__Info();
else field_modificationRequestFor__CB__Info.clean_up();
if (other_value.modificationRequestFor__CSI().is_bound()) field_modificationRequestFor__CSI = other_value.modificationRequestFor__CSI();
else field_modificationRequestFor__CSI.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.longFTN__Supported().is_bound()) field_longFTN__Supported = other_value.longFTN__Supported();
else field_longFTN__Supported.clean_up();
if (other_value.modificationRequestFor__ODB__data().is_bound()) field_modificationRequestFor__ODB__data = other_value.modificationRequestFor__ODB__data();
else field_modificationRequestFor__ODB__data.clean_up();
if (other_value.modificationRequestFor__IP__SM__GW__Data().is_bound()) field_modificationRequestFor__IP__SM__GW__Data = other_value.modificationRequestFor__IP__SM__GW__Data();
else field_modificationRequestFor__IP__SM__GW__Data.clean_up();
if (other_value.activationRequestForUE__reachability().is_bound()) field_activationRequestForUE__reachability = other_value.activationRequestForUE__reachability();
else field_activationRequestForUE__reachability.clean_up();
if (other_value.modificationRequestFor__CSG().is_bound()) field_modificationRequestFor__CSG = other_value.modificationRequestFor__CSG();
else field_modificationRequestFor__CSG.clean_up();
if (other_value.modificationRequestFor__CW__Data().is_bound()) field_modificationRequestFor__CW__Data = other_value.modificationRequestFor__CW__Data();
else field_modificationRequestFor__CW__Data.clean_up();
if (other_value.modificationRequestFor__CLIP__Data().is_bound()) field_modificationRequestFor__CLIP__Data = other_value.modificationRequestFor__CLIP__Data();
else field_modificationRequestFor__CLIP__Data.clean_up();
if (other_value.modificationRequestFor__CLIR__Data().is_bound()) field_modificationRequestFor__CLIR__Data = other_value.modificationRequestFor__CLIR__Data();
else field_modificationRequestFor__CLIR__Data.clean_up();
if (other_value.modificationRequestFor__HOLD__Data().is_bound()) field_modificationRequestFor__HOLD__Data = other_value.modificationRequestFor__HOLD__Data();
else field_modificationRequestFor__HOLD__Data.clean_up();
if (other_value.modificationRequestFor__ECT__Data().is_bound()) field_modificationRequestFor__ECT__Data = other_value.modificationRequestFor__ECT__Data();
else field_modificationRequestFor__ECT__Data.clean_up();
}

void AnyTimeModificationArg::clean_up()
{
field_subscriberIdentity.clean_up();
field_gsmSCF__Address.clean_up();
field_modificationRequestFor__CF__Info.clean_up();
field_modificationRequestFor__CB__Info.clean_up();
field_modificationRequestFor__CSI.clean_up();
field_extensionContainer.clean_up();
field_longFTN__Supported.clean_up();
field_modificationRequestFor__ODB__data.clean_up();
field_modificationRequestFor__IP__SM__GW__Data.clean_up();
field_activationRequestForUE__reachability.clean_up();
field_modificationRequestFor__CSG.clean_up();
field_modificationRequestFor__CW__Data.clean_up();
field_modificationRequestFor__CLIP__Data.clean_up();
field_modificationRequestFor__CLIR__Data.clean_up();
field_modificationRequestFor__HOLD__Data.clean_up();
field_modificationRequestFor__ECT__Data.clean_up();
}

const TTCN_Typedescriptor_t* AnyTimeModificationArg::get_descriptor() const { return &AnyTimeModificationArg_descr_; }
AnyTimeModificationArg& AnyTimeModificationArg::operator=(const AnyTimeModificationArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
  if (other_value.subscriberIdentity().is_bound()) field_subscriberIdentity = other_value.subscriberIdentity();
  else field_subscriberIdentity.clean_up();
  if (other_value.gsmSCF__Address().is_bound()) field_gsmSCF__Address = other_value.gsmSCF__Address();
  else field_gsmSCF__Address.clean_up();
  if (other_value.modificationRequestFor__CF__Info().is_bound()) field_modificationRequestFor__CF__Info = other_value.modificationRequestFor__CF__Info();
  else field_modificationRequestFor__CF__Info.clean_up();
  if (other_value.modificationRequestFor__CB__Info().is_bound()) field_modificationRequestFor__CB__Info = other_value.modificationRequestFor__CB__Info();
  else field_modificationRequestFor__CB__Info.clean_up();
  if (other_value.modificationRequestFor__CSI().is_bound()) field_modificationRequestFor__CSI = other_value.modificationRequestFor__CSI();
  else field_modificationRequestFor__CSI.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.longFTN__Supported().is_bound()) field_longFTN__Supported = other_value.longFTN__Supported();
  else field_longFTN__Supported.clean_up();
  if (other_value.modificationRequestFor__ODB__data().is_bound()) field_modificationRequestFor__ODB__data = other_value.modificationRequestFor__ODB__data();
  else field_modificationRequestFor__ODB__data.clean_up();
  if (other_value.modificationRequestFor__IP__SM__GW__Data().is_bound()) field_modificationRequestFor__IP__SM__GW__Data = other_value.modificationRequestFor__IP__SM__GW__Data();
  else field_modificationRequestFor__IP__SM__GW__Data.clean_up();
  if (other_value.activationRequestForUE__reachability().is_bound()) field_activationRequestForUE__reachability = other_value.activationRequestForUE__reachability();
  else field_activationRequestForUE__reachability.clean_up();
  if (other_value.modificationRequestFor__CSG().is_bound()) field_modificationRequestFor__CSG = other_value.modificationRequestFor__CSG();
  else field_modificationRequestFor__CSG.clean_up();
  if (other_value.modificationRequestFor__CW__Data().is_bound()) field_modificationRequestFor__CW__Data = other_value.modificationRequestFor__CW__Data();
  else field_modificationRequestFor__CW__Data.clean_up();
  if (other_value.modificationRequestFor__CLIP__Data().is_bound()) field_modificationRequestFor__CLIP__Data = other_value.modificationRequestFor__CLIP__Data();
  else field_modificationRequestFor__CLIP__Data.clean_up();
  if (other_value.modificationRequestFor__CLIR__Data().is_bound()) field_modificationRequestFor__CLIR__Data = other_value.modificationRequestFor__CLIR__Data();
  else field_modificationRequestFor__CLIR__Data.clean_up();
  if (other_value.modificationRequestFor__HOLD__Data().is_bound()) field_modificationRequestFor__HOLD__Data = other_value.modificationRequestFor__HOLD__Data();
  else field_modificationRequestFor__HOLD__Data.clean_up();
  if (other_value.modificationRequestFor__ECT__Data().is_bound()) field_modificationRequestFor__ECT__Data = other_value.modificationRequestFor__ECT__Data();
  else field_modificationRequestFor__ECT__Data.clean_up();
}
return *this;
}

boolean AnyTimeModificationArg::operator==(const AnyTimeModificationArg& other_value) const
{
return field_subscriberIdentity==other_value.field_subscriberIdentity
  && field_gsmSCF__Address==other_value.field_gsmSCF__Address
  && field_modificationRequestFor__CF__Info==other_value.field_modificationRequestFor__CF__Info
  && field_modificationRequestFor__CB__Info==other_value.field_modificationRequestFor__CB__Info
  && field_modificationRequestFor__CSI==other_value.field_modificationRequestFor__CSI
  && field_extensionContainer==other_value.field_extensionContainer
  && field_longFTN__Supported==other_value.field_longFTN__Supported
  && field_modificationRequestFor__ODB__data==other_value.field_modificationRequestFor__ODB__data
  && field_modificationRequestFor__IP__SM__GW__Data==other_value.field_modificationRequestFor__IP__SM__GW__Data
  && field_activationRequestForUE__reachability==other_value.field_activationRequestForUE__reachability
  && field_modificationRequestFor__CSG==other_value.field_modificationRequestFor__CSG
  && field_modificationRequestFor__CW__Data==other_value.field_modificationRequestFor__CW__Data
  && field_modificationRequestFor__CLIP__Data==other_value.field_modificationRequestFor__CLIP__Data
  && field_modificationRequestFor__CLIR__Data==other_value.field_modificationRequestFor__CLIR__Data
  && field_modificationRequestFor__HOLD__Data==other_value.field_modificationRequestFor__HOLD__Data
  && field_modificationRequestFor__ECT__Data==other_value.field_modificationRequestFor__ECT__Data;
}

boolean AnyTimeModificationArg::is_bound() const
{
return (field_subscriberIdentity.is_bound())
  || (field_gsmSCF__Address.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CF__Info.get_selection() || field_modificationRequestFor__CF__Info.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CB__Info.get_selection() || field_modificationRequestFor__CB__Info.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CSI.get_selection() || field_modificationRequestFor__CSI.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_longFTN__Supported.get_selection() || field_longFTN__Supported.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__ODB__data.get_selection() || field_modificationRequestFor__ODB__data.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__IP__SM__GW__Data.get_selection() || field_modificationRequestFor__IP__SM__GW__Data.is_bound())
  || (OPTIONAL_OMIT == field_activationRequestForUE__reachability.get_selection() || field_activationRequestForUE__reachability.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CSG.get_selection() || field_modificationRequestFor__CSG.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CW__Data.get_selection() || field_modificationRequestFor__CW__Data.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CLIP__Data.get_selection() || field_modificationRequestFor__CLIP__Data.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__CLIR__Data.get_selection() || field_modificationRequestFor__CLIR__Data.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__HOLD__Data.get_selection() || field_modificationRequestFor__HOLD__Data.is_bound())
  || (OPTIONAL_OMIT == field_modificationRequestFor__ECT__Data.get_selection() || field_modificationRequestFor__ECT__Data.is_bound());
}
boolean AnyTimeModificationArg::is_value() const
{
return field_subscriberIdentity.is_value()
  && field_gsmSCF__Address.is_value()
  && (OPTIONAL_OMIT == field_modificationRequestFor__CF__Info.get_selection() || field_modificationRequestFor__CF__Info.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CB__Info.get_selection() || field_modificationRequestFor__CB__Info.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CSI.get_selection() || field_modificationRequestFor__CSI.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_longFTN__Supported.get_selection() || field_longFTN__Supported.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__ODB__data.get_selection() || field_modificationRequestFor__ODB__data.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__IP__SM__GW__Data.get_selection() || field_modificationRequestFor__IP__SM__GW__Data.is_value())
  && (OPTIONAL_OMIT == field_activationRequestForUE__reachability.get_selection() || field_activationRequestForUE__reachability.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CSG.get_selection() || field_modificationRequestFor__CSG.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CW__Data.get_selection() || field_modificationRequestFor__CW__Data.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CLIP__Data.get_selection() || field_modificationRequestFor__CLIP__Data.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__CLIR__Data.get_selection() || field_modificationRequestFor__CLIR__Data.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__HOLD__Data.get_selection() || field_modificationRequestFor__HOLD__Data.is_value())
  && (OPTIONAL_OMIT == field_modificationRequestFor__ECT__Data.get_selection() || field_modificationRequestFor__ECT__Data.is_value());
}
int AnyTimeModificationArg::size_of() const
{
  int ret_val = 2;
  if (field_modificationRequestFor__CF__Info.ispresent()) ret_val++;
  if (field_modificationRequestFor__CB__Info.ispresent()) ret_val++;
  if (field_modificationRequestFor__CSI.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_longFTN__Supported.ispresent()) ret_val++;
  if (field_modificationRequestFor__ODB__data.ispresent()) ret_val++;
  if (field_modificationRequestFor__IP__SM__GW__Data.ispresent()) ret_val++;
  if (field_activationRequestForUE__reachability.ispresent()) ret_val++;
  if (field_modificationRequestFor__CSG.ispresent()) ret_val++;
  if (field_modificationRequestFor__CW__Data.ispresent()) ret_val++;
  if (field_modificationRequestFor__CLIP__Data.ispresent()) ret_val++;
  if (field_modificationRequestFor__CLIR__Data.ispresent()) ret_val++;
  if (field_modificationRequestFor__HOLD__Data.ispresent()) ret_val++;
  if (field_modificationRequestFor__ECT__Data.ispresent()) ret_val++;
  return ret_val;
}

void AnyTimeModificationArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ subscriberIdentity := ");
field_subscriberIdentity.log();
TTCN_Logger::log_event_str(", gsmSCF_Address := ");
field_gsmSCF__Address.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CF_Info := ");
field_modificationRequestFor__CF__Info.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CB_Info := ");
field_modificationRequestFor__CB__Info.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CSI := ");
field_modificationRequestFor__CSI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", longFTN_Supported := ");
field_longFTN__Supported.log();
TTCN_Logger::log_event_str(", modificationRequestFor_ODB_data := ");
field_modificationRequestFor__ODB__data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_IP_SM_GW_Data := ");
field_modificationRequestFor__IP__SM__GW__Data.log();
TTCN_Logger::log_event_str(", activationRequestForUE_reachability := ");
field_activationRequestForUE__reachability.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CSG := ");
field_modificationRequestFor__CSG.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CW_Data := ");
field_modificationRequestFor__CW__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CLIP_Data := ");
field_modificationRequestFor__CLIP__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CLIR_Data := ");
field_modificationRequestFor__CLIR__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_HOLD_Data := ");
field_modificationRequestFor__HOLD__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_ECT_Data := ");
field_modificationRequestFor__ECT__Data.log();
TTCN_Logger::log_event_str(" }");
}

void AnyTimeModificationArg::set_implicit_omit()
{
if (subscriberIdentity().is_bound()) subscriberIdentity().set_implicit_omit();
if (gsmSCF__Address().is_bound()) gsmSCF__Address().set_implicit_omit();
if (!modificationRequestFor__CF__Info().is_bound()) modificationRequestFor__CF__Info() = OMIT_VALUE;
else modificationRequestFor__CF__Info().set_implicit_omit();
if (!modificationRequestFor__CB__Info().is_bound()) modificationRequestFor__CB__Info() = OMIT_VALUE;
else modificationRequestFor__CB__Info().set_implicit_omit();
if (!modificationRequestFor__CSI().is_bound()) modificationRequestFor__CSI() = OMIT_VALUE;
else modificationRequestFor__CSI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!longFTN__Supported().is_bound()) longFTN__Supported() = OMIT_VALUE;
else longFTN__Supported().set_implicit_omit();
if (!modificationRequestFor__ODB__data().is_bound()) modificationRequestFor__ODB__data() = OMIT_VALUE;
else modificationRequestFor__ODB__data().set_implicit_omit();
if (!modificationRequestFor__IP__SM__GW__Data().is_bound()) modificationRequestFor__IP__SM__GW__Data() = OMIT_VALUE;
else modificationRequestFor__IP__SM__GW__Data().set_implicit_omit();
if (!activationRequestForUE__reachability().is_bound()) activationRequestForUE__reachability() = OMIT_VALUE;
else activationRequestForUE__reachability().set_implicit_omit();
if (!modificationRequestFor__CSG().is_bound()) modificationRequestFor__CSG() = OMIT_VALUE;
else modificationRequestFor__CSG().set_implicit_omit();
if (!modificationRequestFor__CW__Data().is_bound()) modificationRequestFor__CW__Data() = OMIT_VALUE;
else modificationRequestFor__CW__Data().set_implicit_omit();
if (!modificationRequestFor__CLIP__Data().is_bound()) modificationRequestFor__CLIP__Data() = OMIT_VALUE;
else modificationRequestFor__CLIP__Data().set_implicit_omit();
if (!modificationRequestFor__CLIR__Data().is_bound()) modificationRequestFor__CLIR__Data() = OMIT_VALUE;
else modificationRequestFor__CLIR__Data().set_implicit_omit();
if (!modificationRequestFor__HOLD__Data().is_bound()) modificationRequestFor__HOLD__Data() = OMIT_VALUE;
else modificationRequestFor__HOLD__Data().set_implicit_omit();
if (!modificationRequestFor__ECT__Data().is_bound()) modificationRequestFor__ECT__Data() = OMIT_VALUE;
else modificationRequestFor__ECT__Data().set_implicit_omit();
}

void AnyTimeModificationArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (16<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.AnyTimeModificationArg has 16 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) subscriberIdentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gsmSCF__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CF__Info().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CB__Info().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CSI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) longFTN__Supported().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__ODB__data().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__IP__SM__GW__Data().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) activationRequestForUE__reachability().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CSG().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CW__Data().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CLIP__Data().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CLIR__Data().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__HOLD__Data().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__ECT__Data().set_param(*param.get_elem(15));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gsmSCF_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gsmSCF__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CF_Info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CF__Info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CB_Info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CB__Info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "longFTN_Supported")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          longFTN__Supported().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_ODB_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__ODB__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_IP_SM_GW_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__IP__SM__GW__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "activationRequestForUE_reachability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          activationRequestForUE__reachability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CSG")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CSG().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CW_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CW__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CLIP_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CLIP__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CLIR_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CLIR__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_HOLD_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__HOLD__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_ECT_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__ECT__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AnyTimeModificationArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.AnyTimeModificationArg");
  }
}

void AnyTimeModificationArg::encode_text(Text_Buf& text_buf) const
{
field_subscriberIdentity.encode_text(text_buf);
field_gsmSCF__Address.encode_text(text_buf);
field_modificationRequestFor__CF__Info.encode_text(text_buf);
field_modificationRequestFor__CB__Info.encode_text(text_buf);
field_modificationRequestFor__CSI.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_longFTN__Supported.encode_text(text_buf);
field_modificationRequestFor__ODB__data.encode_text(text_buf);
field_modificationRequestFor__IP__SM__GW__Data.encode_text(text_buf);
field_activationRequestForUE__reachability.encode_text(text_buf);
field_modificationRequestFor__CSG.encode_text(text_buf);
field_modificationRequestFor__CW__Data.encode_text(text_buf);
field_modificationRequestFor__CLIP__Data.encode_text(text_buf);
field_modificationRequestFor__CLIR__Data.encode_text(text_buf);
field_modificationRequestFor__HOLD__Data.encode_text(text_buf);
field_modificationRequestFor__ECT__Data.encode_text(text_buf);
}

void AnyTimeModificationArg::decode_text(Text_Buf& text_buf)
{
field_subscriberIdentity.decode_text(text_buf);
field_gsmSCF__Address.decode_text(text_buf);
field_modificationRequestFor__CF__Info.decode_text(text_buf);
field_modificationRequestFor__CB__Info.decode_text(text_buf);
field_modificationRequestFor__CSI.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_longFTN__Supported.decode_text(text_buf);
field_modificationRequestFor__ODB__data.decode_text(text_buf);
field_modificationRequestFor__IP__SM__GW__Data.decode_text(text_buf);
field_activationRequestForUE__reachability.decode_text(text_buf);
field_modificationRequestFor__CSG.decode_text(text_buf);
field_modificationRequestFor__CW__Data.decode_text(text_buf);
field_modificationRequestFor__CLIP__Data.decode_text(text_buf);
field_modificationRequestFor__CLIR__Data.decode_text(text_buf);
field_modificationRequestFor__HOLD__Data.decode_text(text_buf);
field_modificationRequestFor__ECT__Data.decode_text(text_buf);
}

void AnyTimeModificationArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AnyTimeModificationArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* AnyTimeModificationArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("subscriberIdentity': ");
  new_tlv->add_TLV(field_subscriberIdentity.BER_encode_TLV(AnyTimeModificationArg_subscriberIdentity_descr_, p_coding));
  ec_1.set_msg("gsmSCF_Address': ");
  new_tlv->add_TLV(field_gsmSCF__Address.BER_encode_TLV(AnyTimeModificationArg_gsmSCF__Address_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CF_Info': ");
  new_tlv->add_TLV(field_modificationRequestFor__CF__Info.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CB_Info': ");
  new_tlv->add_TLV(field_modificationRequestFor__CB__Info.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CSI': ");
  new_tlv->add_TLV(field_modificationRequestFor__CSI.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(AnyTimeModificationArg_extensionContainer_descr_, p_coding));
  ec_1.set_msg("longFTN_Supported': ");
  new_tlv->add_TLV(field_longFTN__Supported.BER_encode_TLV(AnyTimeModificationArg_longFTN__Supported_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_ODB_data': ");
  new_tlv->add_TLV(field_modificationRequestFor__ODB__data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_IP_SM_GW_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__IP__SM__GW__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, p_coding));
  ec_1.set_msg("activationRequestForUE_reachability': ");
  new_tlv->add_TLV(field_activationRequestForUE__reachability.BER_encode_TLV(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CSG': ");
  new_tlv->add_TLV(field_modificationRequestFor__CSG.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CW_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__CW__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CLIP_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__CLIP__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_CLIR_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__CLIR__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_HOLD_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__HOLD__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, p_coding));
  ec_1.set_msg("modificationRequestFor_ECT_Data': ");
  new_tlv->add_TLV(field_modificationRequestFor__ECT__Data.BER_encode_TLV(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean AnyTimeModificationArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.AnyTimeModificationArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("subscriberIdentity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_subscriberIdentity.BER_decode_TLV(AnyTimeModificationArg_subscriberIdentity_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("gsmSCF_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_gsmSCF__Address.BER_decode_TLV(AnyTimeModificationArg_gsmSCF__Address_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("modificationRequestFor_CF_Info': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CF__Info=OMIT_VALUE;
    else {
      field_modificationRequestFor__CF__Info.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CF__Info.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CB_Info': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CB__Info=OMIT_VALUE;
    else {
      field_modificationRequestFor__CB__Info.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CB__Info.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CSI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CSI=OMIT_VALUE;
    else {
      field_modificationRequestFor__CSI.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CSI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(AnyTimeModificationArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("longFTN_Supported': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_longFTN__Supported=OMIT_VALUE;
    else {
      field_longFTN__Supported.BER_decode_TLV(AnyTimeModificationArg_longFTN__Supported_descr_, tmp_tlv, L_form);
      if(field_longFTN__Supported.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_ODB_data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__ODB__data=OMIT_VALUE;
    else {
      field_modificationRequestFor__ODB__data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__ODB__data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_IP_SM_GW_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__IP__SM__GW__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__IP__SM__GW__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__IP__SM__GW__Data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("activationRequestForUE_reachability': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_activationRequestForUE__reachability=OMIT_VALUE;
    else {
      field_activationRequestForUE__reachability.BER_decode_TLV(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, tmp_tlv, L_form);
      if(field_activationRequestForUE__reachability.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CSG': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CSG=OMIT_VALUE;
    else {
      field_modificationRequestFor__CSG.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CSG.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CW_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CW__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__CW__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CW__Data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CLIP_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CLIP__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__CLIP__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CLIP__Data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_CLIR_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__CLIR__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__CLIR__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__CLIR__Data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_HOLD_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__HOLD__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__HOLD__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__HOLD__Data.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modificationRequestFor_ECT_Data': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modificationRequestFor__ECT__Data=OMIT_VALUE;
    else {
      field_modificationRequestFor__ECT__Data.BER_decode_TLV(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, tmp_tlv, L_form);
      if(field_modificationRequestFor__ECT__Data.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int AnyTimeModificationArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "subscriberIdentity");
    enc_len += field_subscriberIdentity.JSON_encode(AnyTimeModificationArg_subscriberIdentity_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gsmSCF_Address");
    enc_len += field_gsmSCF__Address.JSON_encode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CF__Info.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CF_Info");
    enc_len += field_modificationRequestFor__CF__Info.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CB__Info.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CB_Info");
    enc_len += field_modificationRequestFor__CB__Info.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CSI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CSI");
    enc_len += field_modificationRequestFor__CSI.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(AnyTimeModificationArg_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_longFTN__Supported.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "longFTN_Supported");
    enc_len += field_longFTN__Supported.JSON_encode(AnyTimeModificationArg_longFTN__Supported_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__ODB__data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_ODB_data");
    enc_len += field_modificationRequestFor__ODB__data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__IP__SM__GW__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_IP_SM_GW_Data");
    enc_len += field_modificationRequestFor__IP__SM__GW__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, p_tok, FALSE);
  }

  if (field_activationRequestForUE__reachability.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "activationRequestForUE_reachability");
    enc_len += field_activationRequestForUE__reachability.JSON_encode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CSG.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CSG");
    enc_len += field_modificationRequestFor__CSG.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CW__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CW_Data");
    enc_len += field_modificationRequestFor__CW__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CLIP__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CLIP_Data");
    enc_len += field_modificationRequestFor__CLIP__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__CLIR__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_CLIR_Data");
    enc_len += field_modificationRequestFor__CLIR__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__HOLD__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_HOLD_Data");
    enc_len += field_modificationRequestFor__HOLD__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, p_tok, FALSE);
  }

  if (field_modificationRequestFor__ECT__Data.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modificationRequestFor_ECT_Data");
    enc_len += field_modificationRequestFor__ECT__Data.JSON_encode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int AnyTimeModificationArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const AnyTimeModificationArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean subscriberIdentity_found = FALSE;
  boolean gsmSCF__Address_found = FALSE;
  boolean modificationRequestFor__CF__Info_found = FALSE;
  boolean modificationRequestFor__CB__Info_found = FALSE;
  boolean modificationRequestFor__CSI_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean longFTN__Supported_found = FALSE;
  boolean modificationRequestFor__ODB__data_found = FALSE;
  boolean modificationRequestFor__IP__SM__GW__Data_found = FALSE;
  boolean activationRequestForUE__reachability_found = FALSE;
  boolean modificationRequestFor__CSG_found = FALSE;
  boolean modificationRequestFor__CW__Data_found = FALSE;
  boolean modificationRequestFor__CLIP__Data_found = FALSE;
  boolean modificationRequestFor__CLIR__Data_found = FALSE;
  boolean modificationRequestFor__HOLD__Data_found = FALSE;
  boolean modificationRequestFor__ECT__Data_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "subscriberIdentity", name_len)) {
        subscriberIdentity_found = TRUE;
         int ret_val = field_subscriberIdentity.JSON_decode(AnyTimeModificationArg_subscriberIdentity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "subscriberIdentity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "gsmSCF_Address", name_len)) {
        gsmSCF__Address_found = TRUE;
         int ret_val = field_gsmSCF__Address.JSON_decode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "gsmSCF_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CF_Info", name_len)) {
        modificationRequestFor__CF__Info_found = TRUE;
         int ret_val = field_modificationRequestFor__CF__Info.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "modificationRequestFor_CF_Info");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CB_Info", name_len)) {
        modificationRequestFor__CB__Info_found = TRUE;
         int ret_val = field_modificationRequestFor__CB__Info.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "modificationRequestFor_CB_Info");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (26 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CSI", name_len)) {
        modificationRequestFor__CSI_found = TRUE;
         int ret_val = field_modificationRequestFor__CSI.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 26, "modificationRequestFor_CSI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(AnyTimeModificationArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "longFTN_Supported", name_len)) {
        longFTN__Supported_found = TRUE;
         int ret_val = field_longFTN__Supported.JSON_decode(AnyTimeModificationArg_longFTN__Supported_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "longFTN_Supported");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (31 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_ODB_data", name_len)) {
        modificationRequestFor__ODB__data_found = TRUE;
         int ret_val = field_modificationRequestFor__ODB__data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 31, "modificationRequestFor_ODB_data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (36 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_IP_SM_GW_Data", name_len)) {
        modificationRequestFor__IP__SM__GW__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__IP__SM__GW__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 36, "modificationRequestFor_IP_SM_GW_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (35 == name_len && 0 == strncmp(fld_name, "activationRequestForUE_reachability", name_len)) {
        activationRequestForUE__reachability_found = TRUE;
         int ret_val = field_activationRequestForUE__reachability.JSON_decode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 35, "activationRequestForUE_reachability");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (26 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CSG", name_len)) {
        modificationRequestFor__CSG_found = TRUE;
         int ret_val = field_modificationRequestFor__CSG.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 26, "modificationRequestFor_CSG");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CW_Data", name_len)) {
        modificationRequestFor__CW__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__CW__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "modificationRequestFor_CW_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CLIP_Data", name_len)) {
        modificationRequestFor__CLIP__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__CLIP__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "modificationRequestFor_CLIP_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_CLIR_Data", name_len)) {
        modificationRequestFor__CLIR__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__CLIR__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "modificationRequestFor_CLIR_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_HOLD_Data", name_len)) {
        modificationRequestFor__HOLD__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__HOLD__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "modificationRequestFor_HOLD_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (31 == name_len && 0 == strncmp(fld_name, "modificationRequestFor_ECT_Data", name_len)) {
        modificationRequestFor__ECT__Data_found = TRUE;
         int ret_val = field_modificationRequestFor__ECT__Data.JSON_decode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 31, "modificationRequestFor_ECT_Data");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!subscriberIdentity_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "subscriberIdentity");
    return JSON_ERROR_FATAL;
  }
  if (!gsmSCF__Address_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "gsmSCF_Address");
    return JSON_ERROR_FATAL;
  }
  if (!modificationRequestFor__CF__Info_found) {
    field_modificationRequestFor__CF__Info = OMIT_VALUE;
  }
  if (!modificationRequestFor__CB__Info_found) {
    field_modificationRequestFor__CB__Info = OMIT_VALUE;
  }
  if (!modificationRequestFor__CSI_found) {
    field_modificationRequestFor__CSI = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!longFTN__Supported_found) {
    field_longFTN__Supported = OMIT_VALUE;
  }
  if (!modificationRequestFor__ODB__data_found) {
    field_modificationRequestFor__ODB__data = OMIT_VALUE;
  }
  if (!modificationRequestFor__IP__SM__GW__Data_found) {
    field_modificationRequestFor__IP__SM__GW__Data = OMIT_VALUE;
  }
  if (!activationRequestForUE__reachability_found) {
    field_activationRequestForUE__reachability = OMIT_VALUE;
  }
  if (!modificationRequestFor__CSG_found) {
    field_modificationRequestFor__CSG = OMIT_VALUE;
  }
  if (!modificationRequestFor__CW__Data_found) {
    field_modificationRequestFor__CW__Data = OMIT_VALUE;
  }
  if (!modificationRequestFor__CLIP__Data_found) {
    field_modificationRequestFor__CLIP__Data = OMIT_VALUE;
  }
  if (!modificationRequestFor__CLIR__Data_found) {
    field_modificationRequestFor__CLIR__Data = OMIT_VALUE;
  }
  if (!modificationRequestFor__HOLD__Data_found) {
    field_modificationRequestFor__HOLD__Data = OMIT_VALUE;
  }
  if (!modificationRequestFor__ECT__Data_found) {
    field_modificationRequestFor__ECT__Data = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int AnyTimeModificationArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_modificationRequestFor__ODB__data.is_bound() && field_modificationRequestFor__ODB__data.is_present());
  has_extension = has_extension || (field_modificationRequestFor__IP__SM__GW__Data.is_bound() && field_modificationRequestFor__IP__SM__GW__Data.is_present());
  has_extension = has_extension || (field_activationRequestForUE__reachability.is_bound() && field_activationRequestForUE__reachability.is_present());
  has_extension = has_extension || (field_modificationRequestFor__CSG.is_bound() && field_modificationRequestFor__CSG.is_present());
  has_extension = has_extension || (field_modificationRequestFor__CW__Data.is_bound() && field_modificationRequestFor__CW__Data.is_present());
  has_extension = has_extension || (field_modificationRequestFor__CLIP__Data.is_bound() && field_modificationRequestFor__CLIP__Data.is_present());
  has_extension = has_extension || (field_modificationRequestFor__CLIR__Data.is_bound() && field_modificationRequestFor__CLIR__Data.is_present());
  has_extension = has_extension || (field_modificationRequestFor__HOLD__Data.is_bound() && field_modificationRequestFor__HOLD__Data.is_present());
  has_extension = has_extension || (field_modificationRequestFor__ECT__Data.is_bound() && field_modificationRequestFor__ECT__Data.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_modificationRequestFor__CF__Info.is_present()) {
    c |= 64;
  }
  if (field_modificationRequestFor__CB__Info.is_present()) {
    c |= 32;
  }
  if (field_modificationRequestFor__CSI.is_present()) {
    c |= 16;
  }
  if (field_extensionContainer.is_present()) {
    c |= 8;
  }
  if (field_longFTN__Supported.is_present()) {
    c |= 4;
  }
  p_buf.put_c(c);
  field_subscriberIdentity.OER_encode(AnyTimeModificationArg_subscriberIdentity_descr_, p_buf);
  field_gsmSCF__Address.OER_encode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_buf);
  if (field_modificationRequestFor__CF__Info.is_present())
    field_modificationRequestFor__CF__Info.OER_encode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_buf);
  if (field_modificationRequestFor__CB__Info.is_present())
    field_modificationRequestFor__CB__Info.OER_encode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_buf);
  if (field_modificationRequestFor__CSI.is_present())
    field_modificationRequestFor__CSI.OER_encode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(AnyTimeModificationArg_extensionContainer_descr_, p_buf);
  if (field_longFTN__Supported.is_present())
    field_longFTN__Supported.OER_encode(AnyTimeModificationArg_longFTN__Supported_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_modificationRequestFor__ODB__data.is_present()) {
      c |= 128;
      field_modificationRequestFor__ODB__data.OER_encode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__IP__SM__GW__Data.is_present()) {
      c |= 64;
      field_modificationRequestFor__IP__SM__GW__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_activationRequestForUE__reachability.is_present()) {
      c |= 32;
      field_activationRequestForUE__reachability.OER_encode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__CSG.is_present()) {
      c |= 16;
      field_modificationRequestFor__CSG.OER_encode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__CW__Data.is_present()) {
      c |= 8;
      field_modificationRequestFor__CW__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__CLIP__Data.is_present()) {
      c |= 4;
      field_modificationRequestFor__CLIP__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__CLIR__Data.is_present()) {
      c |= 2;
      field_modificationRequestFor__CLIR__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_modificationRequestFor__HOLD__Data.is_present()) {
      c |= 1;
      field_modificationRequestFor__HOLD__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_modificationRequestFor__ECT__Data.is_present()) {
      c |= 128;
      field_modificationRequestFor__ECT__Data.OER_encode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(7);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int AnyTimeModificationArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_subscriberIdentity.OER_decode(AnyTimeModificationArg_subscriberIdentity_descr_, p_buf, p_oer);
  field_gsmSCF__Address.OER_decode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_modificationRequestFor__CF__Info.OER_decode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_buf, p_oer);
 else
    field_modificationRequestFor__CF__Info = OMIT_VALUE;
  if (uc[0] & 32)
    field_modificationRequestFor__CB__Info.OER_decode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_buf, p_oer);
 else
    field_modificationRequestFor__CB__Info = OMIT_VALUE;
  if (uc[0] & 16)
    field_modificationRequestFor__CSI.OER_decode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_buf, p_oer);
 else
    field_modificationRequestFor__CSI = OMIT_VALUE;
  if (uc[0] & 8)
    field_extensionContainer.OER_decode(AnyTimeModificationArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (uc[0] & 4)
    field_longFTN__Supported.OER_decode(AnyTimeModificationArg_longFTN__Supported_descr_, p_buf, p_oer);
 else
    field_longFTN__Supported = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_modificationRequestFor__ODB__data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__ODB__data.OER_decode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_modificationRequestFor__IP__SM__GW__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__IP__SM__GW__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_activationRequestForUE__reachability = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_activationRequestForUE__reachability.OER_decode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_modificationRequestFor__CSG = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__CSG.OER_decode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_modificationRequestFor__CW__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__CW__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_modificationRequestFor__CLIP__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__CLIP__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_modificationRequestFor__CLIR__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__CLIR__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_modificationRequestFor__HOLD__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__HOLD__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_modificationRequestFor__ECT__Data = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_modificationRequestFor__ECT__Data.OER_decode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, p_buf, p_oer);
    }
  }
  else {
    field_modificationRequestFor__ODB__data = OMIT_VALUE;
    field_modificationRequestFor__IP__SM__GW__Data = OMIT_VALUE;
    field_activationRequestForUE__reachability = OMIT_VALUE;
    field_modificationRequestFor__CSG = OMIT_VALUE;
    field_modificationRequestFor__CW__Data = OMIT_VALUE;
    field_modificationRequestFor__CLIP__Data = OMIT_VALUE;
    field_modificationRequestFor__CLIR__Data = OMIT_VALUE;
    field_modificationRequestFor__HOLD__Data = OMIT_VALUE;
    field_modificationRequestFor__ECT__Data = OMIT_VALUE;
  }
  return 0;
}

void AnyTimeModificationArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_modificationRequestFor__ODB__data.is_present();
boolean ext_1_present = field_modificationRequestFor__IP__SM__GW__Data.is_present();
boolean ext_2_present = field_activationRequestForUE__reachability.is_present();
boolean ext_3_present = field_modificationRequestFor__CSG.is_present();
boolean ext_4_present = field_modificationRequestFor__CW__Data.is_present();
boolean ext_5_present = field_modificationRequestFor__CLIP__Data.is_present();
boolean ext_6_present = field_modificationRequestFor__CLIR__Data.is_present();
boolean ext_7_present = field_modificationRequestFor__HOLD__Data.is_present();
boolean ext_8_present = field_modificationRequestFor__ECT__Data.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present;
p_buf.PER_put_bit(ext_bit);
boolean field_modificationRequestFor__CF__Info_present = field_modificationRequestFor__CF__Info.is_present();
p_buf.PER_put_bit(field_modificationRequestFor__CF__Info_present);
boolean field_modificationRequestFor__CB__Info_present = field_modificationRequestFor__CB__Info.is_present();
p_buf.PER_put_bit(field_modificationRequestFor__CB__Info_present);
boolean field_modificationRequestFor__CSI_present = field_modificationRequestFor__CSI.is_present();
p_buf.PER_put_bit(field_modificationRequestFor__CSI_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
boolean field_longFTN__Supported_present = field_longFTN__Supported.is_present();
p_buf.PER_put_bit(field_longFTN__Supported_present);
field_subscriberIdentity.PER_encode(AnyTimeModificationArg_subscriberIdentity_descr_, p_buf, p_options);
field_gsmSCF__Address.PER_encode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_buf, p_options);
if (field_modificationRequestFor__CF__Info_present) field_modificationRequestFor__CF__Info.PER_encode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_buf, p_options);
if (field_modificationRequestFor__CB__Info_present) field_modificationRequestFor__CB__Info.PER_encode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_buf, p_options);
if (field_modificationRequestFor__CSI_present) field_modificationRequestFor__CSI.PER_encode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(AnyTimeModificationArg_extensionContainer_descr_, p_buf, p_options);
if (field_longFTN__Supported_present) field_longFTN__Supported.PER_encode(AnyTimeModificationArg_longFTN__Supported_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(9);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__ODB__data.PER_encode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__IP__SM__GW__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_activationRequestForUE__reachability.PER_encode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__CSG.PER_encode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__CW__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__CLIP__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__CLIR__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__HOLD__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_modificationRequestFor__ECT__Data.PER_encode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void AnyTimeModificationArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_modificationRequestFor__CF__Info_present = p_buf.PER_get_bit();
boolean field_modificationRequestFor__CB__Info_present = p_buf.PER_get_bit();
boolean field_modificationRequestFor__CSI_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
boolean field_longFTN__Supported_present = p_buf.PER_get_bit();
field_subscriberIdentity.PER_decode(AnyTimeModificationArg_subscriberIdentity_descr_, p_buf, p_options);
field_gsmSCF__Address.PER_decode(AnyTimeModificationArg_gsmSCF__Address_descr_, p_buf, p_options);
if (field_modificationRequestFor__CF__Info_present) field_modificationRequestFor__CF__Info.PER_decode(AnyTimeModificationArg_modificationRequestFor__CF__Info_descr_, p_buf, p_options);
else field_modificationRequestFor__CF__Info = OMIT_VALUE;
if (field_modificationRequestFor__CB__Info_present) field_modificationRequestFor__CB__Info.PER_decode(AnyTimeModificationArg_modificationRequestFor__CB__Info_descr_, p_buf, p_options);
else field_modificationRequestFor__CB__Info = OMIT_VALUE;
if (field_modificationRequestFor__CSI_present) field_modificationRequestFor__CSI.PER_decode(AnyTimeModificationArg_modificationRequestFor__CSI_descr_, p_buf, p_options);
else field_modificationRequestFor__CSI = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(AnyTimeModificationArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
if (field_longFTN__Supported_present) field_longFTN__Supported.PER_decode(AnyTimeModificationArg_longFTN__Supported_descr_, p_buf, p_options);
else field_longFTN__Supported = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 9) {
for (int i = nof_decoded_ext_adds; i < 9; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__ODB__data.PER_decode(AnyTimeModificationArg_modificationRequestFor__ODB__data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__ODB__data = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__IP__SM__GW__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__IP__SM__GW__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__IP__SM__GW__Data = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_activationRequestForUE__reachability.PER_decode(AnyTimeModificationArg_activationRequestForUE__reachability_descr_, ext_add_buf, p_options);
}
else {
field_activationRequestForUE__reachability = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__CSG.PER_decode(AnyTimeModificationArg_modificationRequestFor__CSG_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__CSG = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__CW__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__CW__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__CW__Data = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__CLIP__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__CLIP__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__CLIP__Data = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__CLIR__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__CLIR__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__CLIR__Data = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__HOLD__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__HOLD__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__HOLD__Data = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_modificationRequestFor__ECT__Data.PER_decode(AnyTimeModificationArg_modificationRequestFor__ECT__Data_descr_, ext_add_buf, p_options);
}
else {
field_modificationRequestFor__ECT__Data = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 9) for (int i = 9; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct AnyTimeModificationArg_template::single_value_struct {
MAP__CommonDataTypes::SubscriberIdentity_template field_subscriberIdentity;
OCTETSTRING_template field_gsmSCF__Address;
ModificationRequestFor__CF__Info_template field_modificationRequestFor__CF__Info;
ModificationRequestFor__CB__Info_template field_modificationRequestFor__CB__Info;
ModificationRequestFor__CSI_template field_modificationRequestFor__CSI;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
ASN_NULL_template field_longFTN__Supported;
ModificationRequestFor__ODB__data_template field_modificationRequestFor__ODB__data;
ModificationRequestFor__IP__SM__GW__Data_template field_modificationRequestFor__IP__SM__GW__Data;
BITSTRING_template field_activationRequestForUE__reachability;
ModificationRequestFor__CSG_template field_modificationRequestFor__CSG;
ModificationRequestFor__CW__Info_template field_modificationRequestFor__CW__Data;
ModificationRequestFor__CLIP__Info_template field_modificationRequestFor__CLIP__Data;
ModificationRequestFor__CLIR__Info_template field_modificationRequestFor__CLIR__Data;
ModificationRequestFor__CH__Info_template field_modificationRequestFor__HOLD__Data;
ModificationRequestFor__ECT__Info_template field_modificationRequestFor__ECT__Data;
};

void AnyTimeModificationArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_subscriberIdentity = ANY_VALUE;
single_value->field_gsmSCF__Address = ANY_VALUE;
single_value->field_modificationRequestFor__CF__Info = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CB__Info = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CSI = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_longFTN__Supported = ANY_OR_OMIT;
single_value->field_modificationRequestFor__ODB__data = ANY_OR_OMIT;
single_value->field_modificationRequestFor__IP__SM__GW__Data = ANY_OR_OMIT;
single_value->field_activationRequestForUE__reachability = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CSG = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CW__Data = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CLIP__Data = ANY_OR_OMIT;
single_value->field_modificationRequestFor__CLIR__Data = ANY_OR_OMIT;
single_value->field_modificationRequestFor__HOLD__Data = ANY_OR_OMIT;
single_value->field_modificationRequestFor__ECT__Data = ANY_OR_OMIT;
}
}
}

void AnyTimeModificationArg_template::copy_value(const AnyTimeModificationArg& other_value)
{
single_value = new single_value_struct;
if (other_value.subscriberIdentity().is_bound()) {
  single_value->field_subscriberIdentity = other_value.subscriberIdentity();
} else {
  single_value->field_subscriberIdentity.clean_up();
}
if (other_value.gsmSCF__Address().is_bound()) {
  single_value->field_gsmSCF__Address = other_value.gsmSCF__Address();
} else {
  single_value->field_gsmSCF__Address.clean_up();
}
if (other_value.modificationRequestFor__CF__Info().is_bound()) {
  if (other_value.modificationRequestFor__CF__Info().ispresent()) single_value->field_modificationRequestFor__CF__Info = other_value.modificationRequestFor__CF__Info()();
  else single_value->field_modificationRequestFor__CF__Info = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CF__Info.clean_up();
}
if (other_value.modificationRequestFor__CB__Info().is_bound()) {
  if (other_value.modificationRequestFor__CB__Info().ispresent()) single_value->field_modificationRequestFor__CB__Info = other_value.modificationRequestFor__CB__Info()();
  else single_value->field_modificationRequestFor__CB__Info = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CB__Info.clean_up();
}
if (other_value.modificationRequestFor__CSI().is_bound()) {
  if (other_value.modificationRequestFor__CSI().ispresent()) single_value->field_modificationRequestFor__CSI = other_value.modificationRequestFor__CSI()();
  else single_value->field_modificationRequestFor__CSI = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CSI.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.longFTN__Supported().is_bound()) {
  if (other_value.longFTN__Supported().ispresent()) single_value->field_longFTN__Supported = other_value.longFTN__Supported()();
  else single_value->field_longFTN__Supported = OMIT_VALUE;
} else {
  single_value->field_longFTN__Supported.clean_up();
}
if (other_value.modificationRequestFor__ODB__data().is_bound()) {
  if (other_value.modificationRequestFor__ODB__data().ispresent()) single_value->field_modificationRequestFor__ODB__data = other_value.modificationRequestFor__ODB__data()();
  else single_value->field_modificationRequestFor__ODB__data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__ODB__data.clean_up();
}
if (other_value.modificationRequestFor__IP__SM__GW__Data().is_bound()) {
  if (other_value.modificationRequestFor__IP__SM__GW__Data().ispresent()) single_value->field_modificationRequestFor__IP__SM__GW__Data = other_value.modificationRequestFor__IP__SM__GW__Data()();
  else single_value->field_modificationRequestFor__IP__SM__GW__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__IP__SM__GW__Data.clean_up();
}
if (other_value.activationRequestForUE__reachability().is_bound()) {
  if (other_value.activationRequestForUE__reachability().ispresent()) single_value->field_activationRequestForUE__reachability = other_value.activationRequestForUE__reachability()();
  else single_value->field_activationRequestForUE__reachability = OMIT_VALUE;
} else {
  single_value->field_activationRequestForUE__reachability.clean_up();
}
if (other_value.modificationRequestFor__CSG().is_bound()) {
  if (other_value.modificationRequestFor__CSG().ispresent()) single_value->field_modificationRequestFor__CSG = other_value.modificationRequestFor__CSG()();
  else single_value->field_modificationRequestFor__CSG = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CSG.clean_up();
}
if (other_value.modificationRequestFor__CW__Data().is_bound()) {
  if (other_value.modificationRequestFor__CW__Data().ispresent()) single_value->field_modificationRequestFor__CW__Data = other_value.modificationRequestFor__CW__Data()();
  else single_value->field_modificationRequestFor__CW__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CW__Data.clean_up();
}
if (other_value.modificationRequestFor__CLIP__Data().is_bound()) {
  if (other_value.modificationRequestFor__CLIP__Data().ispresent()) single_value->field_modificationRequestFor__CLIP__Data = other_value.modificationRequestFor__CLIP__Data()();
  else single_value->field_modificationRequestFor__CLIP__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CLIP__Data.clean_up();
}
if (other_value.modificationRequestFor__CLIR__Data().is_bound()) {
  if (other_value.modificationRequestFor__CLIR__Data().ispresent()) single_value->field_modificationRequestFor__CLIR__Data = other_value.modificationRequestFor__CLIR__Data()();
  else single_value->field_modificationRequestFor__CLIR__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__CLIR__Data.clean_up();
}
if (other_value.modificationRequestFor__HOLD__Data().is_bound()) {
  if (other_value.modificationRequestFor__HOLD__Data().ispresent()) single_value->field_modificationRequestFor__HOLD__Data = other_value.modificationRequestFor__HOLD__Data()();
  else single_value->field_modificationRequestFor__HOLD__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__HOLD__Data.clean_up();
}
if (other_value.modificationRequestFor__ECT__Data().is_bound()) {
  if (other_value.modificationRequestFor__ECT__Data().ispresent()) single_value->field_modificationRequestFor__ECT__Data = other_value.modificationRequestFor__ECT__Data()();
  else single_value->field_modificationRequestFor__ECT__Data = OMIT_VALUE;
} else {
  single_value->field_modificationRequestFor__ECT__Data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AnyTimeModificationArg_template::copy_template(const AnyTimeModificationArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.subscriberIdentity().get_selection()) {
single_value->field_subscriberIdentity = other_value.subscriberIdentity();
} else {
single_value->field_subscriberIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gsmSCF__Address().get_selection()) {
single_value->field_gsmSCF__Address = other_value.gsmSCF__Address();
} else {
single_value->field_gsmSCF__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CF__Info().get_selection()) {
single_value->field_modificationRequestFor__CF__Info = other_value.modificationRequestFor__CF__Info();
} else {
single_value->field_modificationRequestFor__CF__Info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CB__Info().get_selection()) {
single_value->field_modificationRequestFor__CB__Info = other_value.modificationRequestFor__CB__Info();
} else {
single_value->field_modificationRequestFor__CB__Info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CSI().get_selection()) {
single_value->field_modificationRequestFor__CSI = other_value.modificationRequestFor__CSI();
} else {
single_value->field_modificationRequestFor__CSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.longFTN__Supported().get_selection()) {
single_value->field_longFTN__Supported = other_value.longFTN__Supported();
} else {
single_value->field_longFTN__Supported.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__ODB__data().get_selection()) {
single_value->field_modificationRequestFor__ODB__data = other_value.modificationRequestFor__ODB__data();
} else {
single_value->field_modificationRequestFor__ODB__data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__IP__SM__GW__Data().get_selection()) {
single_value->field_modificationRequestFor__IP__SM__GW__Data = other_value.modificationRequestFor__IP__SM__GW__Data();
} else {
single_value->field_modificationRequestFor__IP__SM__GW__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.activationRequestForUE__reachability().get_selection()) {
single_value->field_activationRequestForUE__reachability = other_value.activationRequestForUE__reachability();
} else {
single_value->field_activationRequestForUE__reachability.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CSG().get_selection()) {
single_value->field_modificationRequestFor__CSG = other_value.modificationRequestFor__CSG();
} else {
single_value->field_modificationRequestFor__CSG.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CW__Data().get_selection()) {
single_value->field_modificationRequestFor__CW__Data = other_value.modificationRequestFor__CW__Data();
} else {
single_value->field_modificationRequestFor__CW__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CLIP__Data().get_selection()) {
single_value->field_modificationRequestFor__CLIP__Data = other_value.modificationRequestFor__CLIP__Data();
} else {
single_value->field_modificationRequestFor__CLIP__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__CLIR__Data().get_selection()) {
single_value->field_modificationRequestFor__CLIR__Data = other_value.modificationRequestFor__CLIR__Data();
} else {
single_value->field_modificationRequestFor__CLIR__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__HOLD__Data().get_selection()) {
single_value->field_modificationRequestFor__HOLD__Data = other_value.modificationRequestFor__HOLD__Data();
} else {
single_value->field_modificationRequestFor__HOLD__Data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modificationRequestFor__ECT__Data().get_selection()) {
single_value->field_modificationRequestFor__ECT__Data = other_value.modificationRequestFor__ECT__Data();
} else {
single_value->field_modificationRequestFor__ECT__Data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AnyTimeModificationArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AnyTimeModificationArg_template(*other_value.implication_.precondition);
implication_.implied_template = new AnyTimeModificationArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
break;
}
set_selection(other_value);
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template()
{
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(const AnyTimeModificationArg& other_value)
{
copy_value(other_value);
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(const OPTIONAL<AnyTimeModificationArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AnyTimeModificationArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.AnyTimeModificationArg from an unbound optional field.");
}
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(AnyTimeModificationArg_template* p_precondition, AnyTimeModificationArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(Dynamic_Match_Interface<AnyTimeModificationArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AnyTimeModificationArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AnyTimeModificationArg_template::AnyTimeModificationArg_template(const AnyTimeModificationArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AnyTimeModificationArg_template::~AnyTimeModificationArg_template()
{
clean_up();
}

AnyTimeModificationArg_template& AnyTimeModificationArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AnyTimeModificationArg_template& AnyTimeModificationArg_template::operator=(const AnyTimeModificationArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AnyTimeModificationArg_template& AnyTimeModificationArg_template::operator=(const OPTIONAL<AnyTimeModificationArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AnyTimeModificationArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
}
return *this;
}

AnyTimeModificationArg_template& AnyTimeModificationArg_template::operator=(const AnyTimeModificationArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AnyTimeModificationArg_template::match(const AnyTimeModificationArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.subscriberIdentity().is_bound()) return FALSE;
if(!single_value->field_subscriberIdentity.match(other_value.subscriberIdentity(), legacy))return FALSE;
if(!other_value.gsmSCF__Address().is_bound()) return FALSE;
if(!single_value->field_gsmSCF__Address.match(other_value.gsmSCF__Address(), legacy))return FALSE;
if(!other_value.modificationRequestFor__CF__Info().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CF__Info().ispresent() ? !single_value->field_modificationRequestFor__CF__Info.match((const ModificationRequestFor__CF__Info&)other_value.modificationRequestFor__CF__Info(), legacy) : !single_value->field_modificationRequestFor__CF__Info.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CB__Info().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CB__Info().ispresent() ? !single_value->field_modificationRequestFor__CB__Info.match((const ModificationRequestFor__CB__Info&)other_value.modificationRequestFor__CB__Info(), legacy) : !single_value->field_modificationRequestFor__CB__Info.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CSI().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CSI().ispresent() ? !single_value->field_modificationRequestFor__CSI.match((const ModificationRequestFor__CSI&)other_value.modificationRequestFor__CSI(), legacy) : !single_value->field_modificationRequestFor__CSI.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.longFTN__Supported().is_bound()) return FALSE;
if((other_value.longFTN__Supported().ispresent() ? !single_value->field_longFTN__Supported.match((const ASN_NULL&)other_value.longFTN__Supported(), legacy) : !single_value->field_longFTN__Supported.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__ODB__data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__ODB__data().ispresent() ? !single_value->field_modificationRequestFor__ODB__data.match((const ModificationRequestFor__ODB__data&)other_value.modificationRequestFor__ODB__data(), legacy) : !single_value->field_modificationRequestFor__ODB__data.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__IP__SM__GW__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__IP__SM__GW__Data().ispresent() ? !single_value->field_modificationRequestFor__IP__SM__GW__Data.match((const ModificationRequestFor__IP__SM__GW__Data&)other_value.modificationRequestFor__IP__SM__GW__Data(), legacy) : !single_value->field_modificationRequestFor__IP__SM__GW__Data.match_omit(legacy)))return FALSE;
if(!other_value.activationRequestForUE__reachability().is_bound()) return FALSE;
if((other_value.activationRequestForUE__reachability().ispresent() ? !single_value->field_activationRequestForUE__reachability.match((const BITSTRING&)other_value.activationRequestForUE__reachability(), legacy) : !single_value->field_activationRequestForUE__reachability.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CSG().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CSG().ispresent() ? !single_value->field_modificationRequestFor__CSG.match((const ModificationRequestFor__CSG&)other_value.modificationRequestFor__CSG(), legacy) : !single_value->field_modificationRequestFor__CSG.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CW__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CW__Data().ispresent() ? !single_value->field_modificationRequestFor__CW__Data.match((const ModificationRequestFor__CW__Info&)other_value.modificationRequestFor__CW__Data(), legacy) : !single_value->field_modificationRequestFor__CW__Data.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CLIP__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CLIP__Data().ispresent() ? !single_value->field_modificationRequestFor__CLIP__Data.match((const ModificationRequestFor__CLIP__Info&)other_value.modificationRequestFor__CLIP__Data(), legacy) : !single_value->field_modificationRequestFor__CLIP__Data.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__CLIR__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__CLIR__Data().ispresent() ? !single_value->field_modificationRequestFor__CLIR__Data.match((const ModificationRequestFor__CLIR__Info&)other_value.modificationRequestFor__CLIR__Data(), legacy) : !single_value->field_modificationRequestFor__CLIR__Data.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__HOLD__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__HOLD__Data().ispresent() ? !single_value->field_modificationRequestFor__HOLD__Data.match((const ModificationRequestFor__CH__Info&)other_value.modificationRequestFor__HOLD__Data(), legacy) : !single_value->field_modificationRequestFor__HOLD__Data.match_omit(legacy)))return FALSE;
if(!other_value.modificationRequestFor__ECT__Data().is_bound()) return FALSE;
if((other_value.modificationRequestFor__ECT__Data().ispresent() ? !single_value->field_modificationRequestFor__ECT__Data.match((const ModificationRequestFor__ECT__Info&)other_value.modificationRequestFor__ECT__Data(), legacy) : !single_value->field_modificationRequestFor__ECT__Data.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
}
return FALSE;
}

boolean AnyTimeModificationArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_subscriberIdentity.is_bound()
 || single_value->field_gsmSCF__Address.is_bound()
 || (single_value->field_modificationRequestFor__CF__Info.is_omit() || single_value->field_modificationRequestFor__CF__Info.is_bound())
 || (single_value->field_modificationRequestFor__CB__Info.is_omit() || single_value->field_modificationRequestFor__CB__Info.is_bound())
 || (single_value->field_modificationRequestFor__CSI.is_omit() || single_value->field_modificationRequestFor__CSI.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_longFTN__Supported.is_omit() || single_value->field_longFTN__Supported.is_bound())
 || (single_value->field_modificationRequestFor__ODB__data.is_omit() || single_value->field_modificationRequestFor__ODB__data.is_bound())
 || (single_value->field_modificationRequestFor__IP__SM__GW__Data.is_omit() || single_value->field_modificationRequestFor__IP__SM__GW__Data.is_bound())
 || (single_value->field_activationRequestForUE__reachability.is_omit() || single_value->field_activationRequestForUE__reachability.is_bound())
 || (single_value->field_modificationRequestFor__CSG.is_omit() || single_value->field_modificationRequestFor__CSG.is_bound())
 || (single_value->field_modificationRequestFor__CW__Data.is_omit() || single_value->field_modificationRequestFor__CW__Data.is_bound())
 || (single_value->field_modificationRequestFor__CLIP__Data.is_omit() || single_value->field_modificationRequestFor__CLIP__Data.is_bound())
 || (single_value->field_modificationRequestFor__CLIR__Data.is_omit() || single_value->field_modificationRequestFor__CLIR__Data.is_bound())
 || (single_value->field_modificationRequestFor__HOLD__Data.is_omit() || single_value->field_modificationRequestFor__HOLD__Data.is_bound())
 || (single_value->field_modificationRequestFor__ECT__Data.is_omit() || single_value->field_modificationRequestFor__ECT__Data.is_bound());
}

boolean AnyTimeModificationArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_subscriberIdentity.is_value()
 && single_value->field_gsmSCF__Address.is_value()
 && (single_value->field_modificationRequestFor__CF__Info.is_omit() || single_value->field_modificationRequestFor__CF__Info.is_value())
 && (single_value->field_modificationRequestFor__CB__Info.is_omit() || single_value->field_modificationRequestFor__CB__Info.is_value())
 && (single_value->field_modificationRequestFor__CSI.is_omit() || single_value->field_modificationRequestFor__CSI.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_longFTN__Supported.is_omit() || single_value->field_longFTN__Supported.is_value())
 && (single_value->field_modificationRequestFor__ODB__data.is_omit() || single_value->field_modificationRequestFor__ODB__data.is_value())
 && (single_value->field_modificationRequestFor__IP__SM__GW__Data.is_omit() || single_value->field_modificationRequestFor__IP__SM__GW__Data.is_value())
 && (single_value->field_activationRequestForUE__reachability.is_omit() || single_value->field_activationRequestForUE__reachability.is_value())
 && (single_value->field_modificationRequestFor__CSG.is_omit() || single_value->field_modificationRequestFor__CSG.is_value())
 && (single_value->field_modificationRequestFor__CW__Data.is_omit() || single_value->field_modificationRequestFor__CW__Data.is_value())
 && (single_value->field_modificationRequestFor__CLIP__Data.is_omit() || single_value->field_modificationRequestFor__CLIP__Data.is_value())
 && (single_value->field_modificationRequestFor__CLIR__Data.is_omit() || single_value->field_modificationRequestFor__CLIR__Data.is_value())
 && (single_value->field_modificationRequestFor__HOLD__Data.is_omit() || single_value->field_modificationRequestFor__HOLD__Data.is_value())
 && (single_value->field_modificationRequestFor__ECT__Data.is_omit() || single_value->field_modificationRequestFor__ECT__Data.is_value());
}

void AnyTimeModificationArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AnyTimeModificationArg AnyTimeModificationArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
AnyTimeModificationArg ret_val;
if (single_value->field_subscriberIdentity.is_bound()) {
ret_val.subscriberIdentity() = single_value->field_subscriberIdentity.valueof();
}
if (single_value->field_gsmSCF__Address.is_bound()) {
ret_val.gsmSCF__Address() = single_value->field_gsmSCF__Address.valueof();
}
if (single_value->field_modificationRequestFor__CF__Info.is_omit()) ret_val.modificationRequestFor__CF__Info() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CF__Info.is_bound()) {
ret_val.modificationRequestFor__CF__Info() = single_value->field_modificationRequestFor__CF__Info.valueof();
}
if (single_value->field_modificationRequestFor__CB__Info.is_omit()) ret_val.modificationRequestFor__CB__Info() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CB__Info.is_bound()) {
ret_val.modificationRequestFor__CB__Info() = single_value->field_modificationRequestFor__CB__Info.valueof();
}
if (single_value->field_modificationRequestFor__CSI.is_omit()) ret_val.modificationRequestFor__CSI() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CSI.is_bound()) {
ret_val.modificationRequestFor__CSI() = single_value->field_modificationRequestFor__CSI.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_longFTN__Supported.is_omit()) ret_val.longFTN__Supported() = OMIT_VALUE;
else if (single_value->field_longFTN__Supported.is_bound()) {
ret_val.longFTN__Supported() = single_value->field_longFTN__Supported.valueof();
}
if (single_value->field_modificationRequestFor__ODB__data.is_omit()) ret_val.modificationRequestFor__ODB__data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__ODB__data.is_bound()) {
ret_val.modificationRequestFor__ODB__data() = single_value->field_modificationRequestFor__ODB__data.valueof();
}
if (single_value->field_modificationRequestFor__IP__SM__GW__Data.is_omit()) ret_val.modificationRequestFor__IP__SM__GW__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__IP__SM__GW__Data.is_bound()) {
ret_val.modificationRequestFor__IP__SM__GW__Data() = single_value->field_modificationRequestFor__IP__SM__GW__Data.valueof();
}
if (single_value->field_activationRequestForUE__reachability.is_omit()) ret_val.activationRequestForUE__reachability() = OMIT_VALUE;
else if (single_value->field_activationRequestForUE__reachability.is_bound()) {
ret_val.activationRequestForUE__reachability() = single_value->field_activationRequestForUE__reachability.valueof();
}
if (single_value->field_modificationRequestFor__CSG.is_omit()) ret_val.modificationRequestFor__CSG() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CSG.is_bound()) {
ret_val.modificationRequestFor__CSG() = single_value->field_modificationRequestFor__CSG.valueof();
}
if (single_value->field_modificationRequestFor__CW__Data.is_omit()) ret_val.modificationRequestFor__CW__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CW__Data.is_bound()) {
ret_val.modificationRequestFor__CW__Data() = single_value->field_modificationRequestFor__CW__Data.valueof();
}
if (single_value->field_modificationRequestFor__CLIP__Data.is_omit()) ret_val.modificationRequestFor__CLIP__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CLIP__Data.is_bound()) {
ret_val.modificationRequestFor__CLIP__Data() = single_value->field_modificationRequestFor__CLIP__Data.valueof();
}
if (single_value->field_modificationRequestFor__CLIR__Data.is_omit()) ret_val.modificationRequestFor__CLIR__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__CLIR__Data.is_bound()) {
ret_val.modificationRequestFor__CLIR__Data() = single_value->field_modificationRequestFor__CLIR__Data.valueof();
}
if (single_value->field_modificationRequestFor__HOLD__Data.is_omit()) ret_val.modificationRequestFor__HOLD__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__HOLD__Data.is_bound()) {
ret_val.modificationRequestFor__HOLD__Data() = single_value->field_modificationRequestFor__HOLD__Data.valueof();
}
if (single_value->field_modificationRequestFor__ECT__Data.is_omit()) ret_val.modificationRequestFor__ECT__Data() = OMIT_VALUE;
else if (single_value->field_modificationRequestFor__ECT__Data.is_bound()) {
ret_val.modificationRequestFor__ECT__Data() = single_value->field_modificationRequestFor__ECT__Data.valueof();
}
return ret_val;
}

void AnyTimeModificationArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AnyTimeModificationArg_template[list_length];
}

AnyTimeModificationArg_template& AnyTimeModificationArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return value_list.list_value[list_index];
}

MAP__CommonDataTypes::SubscriberIdentity_template& AnyTimeModificationArg_template::subscriberIdentity()
{
set_specific();
return single_value->field_subscriberIdentity;
}

const MAP__CommonDataTypes::SubscriberIdentity_template& AnyTimeModificationArg_template::subscriberIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subscriberIdentity of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_subscriberIdentity;
}

OCTETSTRING_template& AnyTimeModificationArg_template::gsmSCF__Address()
{
set_specific();
return single_value->field_gsmSCF__Address;
}

const OCTETSTRING_template& AnyTimeModificationArg_template::gsmSCF__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gsmSCF_Address of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_gsmSCF__Address;
}

ModificationRequestFor__CF__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CF__Info()
{
set_specific();
return single_value->field_modificationRequestFor__CF__Info;
}

const ModificationRequestFor__CF__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CF__Info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CF_Info of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CF__Info;
}

ModificationRequestFor__CB__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CB__Info()
{
set_specific();
return single_value->field_modificationRequestFor__CB__Info;
}

const ModificationRequestFor__CB__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CB__Info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CB_Info of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CB__Info;
}

ModificationRequestFor__CSI_template& AnyTimeModificationArg_template::modificationRequestFor__CSI()
{
set_specific();
return single_value->field_modificationRequestFor__CSI;
}

const ModificationRequestFor__CSI_template& AnyTimeModificationArg_template::modificationRequestFor__CSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CSI of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CSI;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& AnyTimeModificationArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& AnyTimeModificationArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_extensionContainer;
}

ASN_NULL_template& AnyTimeModificationArg_template::longFTN__Supported()
{
set_specific();
return single_value->field_longFTN__Supported;
}

const ASN_NULL_template& AnyTimeModificationArg_template::longFTN__Supported() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field longFTN_Supported of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_longFTN__Supported;
}

ModificationRequestFor__ODB__data_template& AnyTimeModificationArg_template::modificationRequestFor__ODB__data()
{
set_specific();
return single_value->field_modificationRequestFor__ODB__data;
}

const ModificationRequestFor__ODB__data_template& AnyTimeModificationArg_template::modificationRequestFor__ODB__data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_ODB_data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__ODB__data;
}

ModificationRequestFor__IP__SM__GW__Data_template& AnyTimeModificationArg_template::modificationRequestFor__IP__SM__GW__Data()
{
set_specific();
return single_value->field_modificationRequestFor__IP__SM__GW__Data;
}

const ModificationRequestFor__IP__SM__GW__Data_template& AnyTimeModificationArg_template::modificationRequestFor__IP__SM__GW__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_IP_SM_GW_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__IP__SM__GW__Data;
}

BITSTRING_template& AnyTimeModificationArg_template::activationRequestForUE__reachability()
{
set_specific();
return single_value->field_activationRequestForUE__reachability;
}

const BITSTRING_template& AnyTimeModificationArg_template::activationRequestForUE__reachability() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field activationRequestForUE_reachability of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_activationRequestForUE__reachability;
}

ModificationRequestFor__CSG_template& AnyTimeModificationArg_template::modificationRequestFor__CSG()
{
set_specific();
return single_value->field_modificationRequestFor__CSG;
}

const ModificationRequestFor__CSG_template& AnyTimeModificationArg_template::modificationRequestFor__CSG() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CSG of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CSG;
}

ModificationRequestFor__CW__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CW__Data()
{
set_specific();
return single_value->field_modificationRequestFor__CW__Data;
}

const ModificationRequestFor__CW__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CW__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CW_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CW__Data;
}

ModificationRequestFor__CLIP__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CLIP__Data()
{
set_specific();
return single_value->field_modificationRequestFor__CLIP__Data;
}

const ModificationRequestFor__CLIP__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CLIP__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CLIP_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CLIP__Data;
}

ModificationRequestFor__CLIR__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CLIR__Data()
{
set_specific();
return single_value->field_modificationRequestFor__CLIR__Data;
}

const ModificationRequestFor__CLIR__Info_template& AnyTimeModificationArg_template::modificationRequestFor__CLIR__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_CLIR_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__CLIR__Data;
}

ModificationRequestFor__CH__Info_template& AnyTimeModificationArg_template::modificationRequestFor__HOLD__Data()
{
set_specific();
return single_value->field_modificationRequestFor__HOLD__Data;
}

const ModificationRequestFor__CH__Info_template& AnyTimeModificationArg_template::modificationRequestFor__HOLD__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_HOLD_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__HOLD__Data;
}

ModificationRequestFor__ECT__Info_template& AnyTimeModificationArg_template::modificationRequestFor__ECT__Data()
{
set_specific();
return single_value->field_modificationRequestFor__ECT__Data;
}

const ModificationRequestFor__ECT__Info_template& AnyTimeModificationArg_template::modificationRequestFor__ECT__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modificationRequestFor_ECT_Data of a non-specific template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
return single_value->field_modificationRequestFor__ECT__Data;
}

int AnyTimeModificationArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_modificationRequestFor__CF__Info.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CB__Info.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CSI.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_longFTN__Supported.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__ODB__data.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__IP__SM__GW__Data.is_present()) ret_val++;
      if (single_value->field_activationRequestForUE__reachability.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CSG.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CW__Data.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CLIP__Data.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__CLIR__Data.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__HOLD__Data.is_present()) ret_val++;
      if (single_value->field_modificationRequestFor__ECT__Data.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AnyTimeModificationArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
  }
  return 0;
}

void AnyTimeModificationArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ subscriberIdentity := ");
single_value->field_subscriberIdentity.log();
TTCN_Logger::log_event_str(", gsmSCF_Address := ");
single_value->field_gsmSCF__Address.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CF_Info := ");
single_value->field_modificationRequestFor__CF__Info.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CB_Info := ");
single_value->field_modificationRequestFor__CB__Info.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CSI := ");
single_value->field_modificationRequestFor__CSI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", longFTN_Supported := ");
single_value->field_longFTN__Supported.log();
TTCN_Logger::log_event_str(", modificationRequestFor_ODB_data := ");
single_value->field_modificationRequestFor__ODB__data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_IP_SM_GW_Data := ");
single_value->field_modificationRequestFor__IP__SM__GW__Data.log();
TTCN_Logger::log_event_str(", activationRequestForUE_reachability := ");
single_value->field_activationRequestForUE__reachability.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CSG := ");
single_value->field_modificationRequestFor__CSG.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CW_Data := ");
single_value->field_modificationRequestFor__CW__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CLIP_Data := ");
single_value->field_modificationRequestFor__CLIP__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_CLIR_Data := ");
single_value->field_modificationRequestFor__CLIR__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_HOLD_Data := ");
single_value->field_modificationRequestFor__HOLD__Data.log();
TTCN_Logger::log_event_str(", modificationRequestFor_ECT_Data := ");
single_value->field_modificationRequestFor__ECT__Data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AnyTimeModificationArg_template::log_match(const AnyTimeModificationArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_subscriberIdentity.match(match_value.subscriberIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".subscriberIdentity");
single_value->field_subscriberIdentity.log_match(match_value.subscriberIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_gsmSCF__Address.match(match_value.gsmSCF__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".gsmSCF_Address");
single_value->field_gsmSCF__Address.log_match(match_value.gsmSCF__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.modificationRequestFor__CF__Info().ispresent()){
if(!single_value->field_modificationRequestFor__CF__Info.match(match_value.modificationRequestFor__CF__Info(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CF_Info");
single_value->field_modificationRequestFor__CF__Info.log_match(match_value.modificationRequestFor__CF__Info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CF__Info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CF_Info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CF__Info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CB__Info().ispresent()){
if(!single_value->field_modificationRequestFor__CB__Info.match(match_value.modificationRequestFor__CB__Info(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CB_Info");
single_value->field_modificationRequestFor__CB__Info.log_match(match_value.modificationRequestFor__CB__Info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CB__Info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CB_Info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CB__Info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CSI().ispresent()){
if(!single_value->field_modificationRequestFor__CSI.match(match_value.modificationRequestFor__CSI(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CSI");
single_value->field_modificationRequestFor__CSI.log_match(match_value.modificationRequestFor__CSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.longFTN__Supported().ispresent()){
if(!single_value->field_longFTN__Supported.match(match_value.longFTN__Supported(), legacy)){
TTCN_Logger::log_logmatch_info(".longFTN_Supported");
single_value->field_longFTN__Supported.log_match(match_value.longFTN__Supported(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_longFTN__Supported.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".longFTN_Supported := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_longFTN__Supported.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__ODB__data().ispresent()){
if(!single_value->field_modificationRequestFor__ODB__data.match(match_value.modificationRequestFor__ODB__data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_ODB_data");
single_value->field_modificationRequestFor__ODB__data.log_match(match_value.modificationRequestFor__ODB__data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__ODB__data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_ODB_data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__ODB__data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__IP__SM__GW__Data().ispresent()){
if(!single_value->field_modificationRequestFor__IP__SM__GW__Data.match(match_value.modificationRequestFor__IP__SM__GW__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_IP_SM_GW_Data");
single_value->field_modificationRequestFor__IP__SM__GW__Data.log_match(match_value.modificationRequestFor__IP__SM__GW__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__IP__SM__GW__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_IP_SM_GW_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__IP__SM__GW__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.activationRequestForUE__reachability().ispresent()){
if(!single_value->field_activationRequestForUE__reachability.match(match_value.activationRequestForUE__reachability(), legacy)){
TTCN_Logger::log_logmatch_info(".activationRequestForUE_reachability");
single_value->field_activationRequestForUE__reachability.log_match(match_value.activationRequestForUE__reachability(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_activationRequestForUE__reachability.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".activationRequestForUE_reachability := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_activationRequestForUE__reachability.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CSG().ispresent()){
if(!single_value->field_modificationRequestFor__CSG.match(match_value.modificationRequestFor__CSG(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CSG");
single_value->field_modificationRequestFor__CSG.log_match(match_value.modificationRequestFor__CSG(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CSG.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CSG := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CSG.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CW__Data().ispresent()){
if(!single_value->field_modificationRequestFor__CW__Data.match(match_value.modificationRequestFor__CW__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CW_Data");
single_value->field_modificationRequestFor__CW__Data.log_match(match_value.modificationRequestFor__CW__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CW__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CW_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CW__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CLIP__Data().ispresent()){
if(!single_value->field_modificationRequestFor__CLIP__Data.match(match_value.modificationRequestFor__CLIP__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CLIP_Data");
single_value->field_modificationRequestFor__CLIP__Data.log_match(match_value.modificationRequestFor__CLIP__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CLIP__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CLIP_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CLIP__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__CLIR__Data().ispresent()){
if(!single_value->field_modificationRequestFor__CLIR__Data.match(match_value.modificationRequestFor__CLIR__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_CLIR_Data");
single_value->field_modificationRequestFor__CLIR__Data.log_match(match_value.modificationRequestFor__CLIR__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__CLIR__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_CLIR_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__CLIR__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__HOLD__Data().ispresent()){
if(!single_value->field_modificationRequestFor__HOLD__Data.match(match_value.modificationRequestFor__HOLD__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_HOLD_Data");
single_value->field_modificationRequestFor__HOLD__Data.log_match(match_value.modificationRequestFor__HOLD__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__HOLD__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_HOLD_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__HOLD__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modificationRequestFor__ECT__Data().ispresent()){
if(!single_value->field_modificationRequestFor__ECT__Data.match(match_value.modificationRequestFor__ECT__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".modificationRequestFor_ECT_Data");
single_value->field_modificationRequestFor__ECT__Data.log_match(match_value.modificationRequestFor__ECT__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modificationRequestFor__ECT__Data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modificationRequestFor_ECT_Data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modificationRequestFor__ECT__Data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ subscriberIdentity := ");
single_value->field_subscriberIdentity.log_match(match_value.subscriberIdentity(), legacy);
TTCN_Logger::log_event_str(", gsmSCF_Address := ");
single_value->field_gsmSCF__Address.log_match(match_value.gsmSCF__Address(), legacy);
TTCN_Logger::log_event_str(", modificationRequestFor_CF_Info := ");
if (match_value.modificationRequestFor__CF__Info().ispresent()) {
single_value->field_modificationRequestFor__CF__Info.log_match(match_value.modificationRequestFor__CF__Info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CF__Info.log();
if (single_value->field_modificationRequestFor__CF__Info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CB_Info := ");
if (match_value.modificationRequestFor__CB__Info().ispresent()) {
single_value->field_modificationRequestFor__CB__Info.log_match(match_value.modificationRequestFor__CB__Info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CB__Info.log();
if (single_value->field_modificationRequestFor__CB__Info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CSI := ");
if (match_value.modificationRequestFor__CSI().ispresent()) {
single_value->field_modificationRequestFor__CSI.log_match(match_value.modificationRequestFor__CSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CSI.log();
if (single_value->field_modificationRequestFor__CSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", longFTN_Supported := ");
if (match_value.longFTN__Supported().ispresent()) {
single_value->field_longFTN__Supported.log_match(match_value.longFTN__Supported(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_longFTN__Supported.log();
if (single_value->field_longFTN__Supported.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_ODB_data := ");
if (match_value.modificationRequestFor__ODB__data().ispresent()) {
single_value->field_modificationRequestFor__ODB__data.log_match(match_value.modificationRequestFor__ODB__data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__ODB__data.log();
if (single_value->field_modificationRequestFor__ODB__data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_IP_SM_GW_Data := ");
if (match_value.modificationRequestFor__IP__SM__GW__Data().ispresent()) {
single_value->field_modificationRequestFor__IP__SM__GW__Data.log_match(match_value.modificationRequestFor__IP__SM__GW__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__IP__SM__GW__Data.log();
if (single_value->field_modificationRequestFor__IP__SM__GW__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", activationRequestForUE_reachability := ");
if (match_value.activationRequestForUE__reachability().ispresent()) {
single_value->field_activationRequestForUE__reachability.log_match(match_value.activationRequestForUE__reachability(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_activationRequestForUE__reachability.log();
if (single_value->field_activationRequestForUE__reachability.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CSG := ");
if (match_value.modificationRequestFor__CSG().ispresent()) {
single_value->field_modificationRequestFor__CSG.log_match(match_value.modificationRequestFor__CSG(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CSG.log();
if (single_value->field_modificationRequestFor__CSG.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CW_Data := ");
if (match_value.modificationRequestFor__CW__Data().ispresent()) {
single_value->field_modificationRequestFor__CW__Data.log_match(match_value.modificationRequestFor__CW__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CW__Data.log();
if (single_value->field_modificationRequestFor__CW__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CLIP_Data := ");
if (match_value.modificationRequestFor__CLIP__Data().ispresent()) {
single_value->field_modificationRequestFor__CLIP__Data.log_match(match_value.modificationRequestFor__CLIP__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CLIP__Data.log();
if (single_value->field_modificationRequestFor__CLIP__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_CLIR_Data := ");
if (match_value.modificationRequestFor__CLIR__Data().ispresent()) {
single_value->field_modificationRequestFor__CLIR__Data.log_match(match_value.modificationRequestFor__CLIR__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__CLIR__Data.log();
if (single_value->field_modificationRequestFor__CLIR__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_HOLD_Data := ");
if (match_value.modificationRequestFor__HOLD__Data().ispresent()) {
single_value->field_modificationRequestFor__HOLD__Data.log_match(match_value.modificationRequestFor__HOLD__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__HOLD__Data.log();
if (single_value->field_modificationRequestFor__HOLD__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modificationRequestFor_ECT_Data := ");
if (match_value.modificationRequestFor__ECT__Data().ispresent()) {
single_value->field_modificationRequestFor__ECT__Data.log_match(match_value.modificationRequestFor__ECT__Data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modificationRequestFor__ECT__Data.log();
if (single_value->field_modificationRequestFor__ECT__Data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AnyTimeModificationArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (subscriberIdentity().is_bound()) subscriberIdentity().set_implicit_omit();
if (gsmSCF__Address().is_bound()) gsmSCF__Address().set_implicit_omit();
if (!modificationRequestFor__CF__Info().is_bound()) modificationRequestFor__CF__Info() = OMIT_VALUE;
else modificationRequestFor__CF__Info().set_implicit_omit();
if (!modificationRequestFor__CB__Info().is_bound()) modificationRequestFor__CB__Info() = OMIT_VALUE;
else modificationRequestFor__CB__Info().set_implicit_omit();
if (!modificationRequestFor__CSI().is_bound()) modificationRequestFor__CSI() = OMIT_VALUE;
else modificationRequestFor__CSI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!longFTN__Supported().is_bound()) longFTN__Supported() = OMIT_VALUE;
else longFTN__Supported().set_implicit_omit();
if (!modificationRequestFor__ODB__data().is_bound()) modificationRequestFor__ODB__data() = OMIT_VALUE;
else modificationRequestFor__ODB__data().set_implicit_omit();
if (!modificationRequestFor__IP__SM__GW__Data().is_bound()) modificationRequestFor__IP__SM__GW__Data() = OMIT_VALUE;
else modificationRequestFor__IP__SM__GW__Data().set_implicit_omit();
if (!activationRequestForUE__reachability().is_bound()) activationRequestForUE__reachability() = OMIT_VALUE;
else activationRequestForUE__reachability().set_implicit_omit();
if (!modificationRequestFor__CSG().is_bound()) modificationRequestFor__CSG() = OMIT_VALUE;
else modificationRequestFor__CSG().set_implicit_omit();
if (!modificationRequestFor__CW__Data().is_bound()) modificationRequestFor__CW__Data() = OMIT_VALUE;
else modificationRequestFor__CW__Data().set_implicit_omit();
if (!modificationRequestFor__CLIP__Data().is_bound()) modificationRequestFor__CLIP__Data() = OMIT_VALUE;
else modificationRequestFor__CLIP__Data().set_implicit_omit();
if (!modificationRequestFor__CLIR__Data().is_bound()) modificationRequestFor__CLIR__Data() = OMIT_VALUE;
else modificationRequestFor__CLIR__Data().set_implicit_omit();
if (!modificationRequestFor__HOLD__Data().is_bound()) modificationRequestFor__HOLD__Data() = OMIT_VALUE;
else modificationRequestFor__HOLD__Data().set_implicit_omit();
if (!modificationRequestFor__ECT__Data().is_bound()) modificationRequestFor__ECT__Data() = OMIT_VALUE;
else modificationRequestFor__ECT__Data().set_implicit_omit();
}

void AnyTimeModificationArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_subscriberIdentity.encode_text(text_buf);
single_value->field_gsmSCF__Address.encode_text(text_buf);
single_value->field_modificationRequestFor__CF__Info.encode_text(text_buf);
single_value->field_modificationRequestFor__CB__Info.encode_text(text_buf);
single_value->field_modificationRequestFor__CSI.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_longFTN__Supported.encode_text(text_buf);
single_value->field_modificationRequestFor__ODB__data.encode_text(text_buf);
single_value->field_modificationRequestFor__IP__SM__GW__Data.encode_text(text_buf);
single_value->field_activationRequestForUE__reachability.encode_text(text_buf);
single_value->field_modificationRequestFor__CSG.encode_text(text_buf);
single_value->field_modificationRequestFor__CW__Data.encode_text(text_buf);
single_value->field_modificationRequestFor__CLIP__Data.encode_text(text_buf);
single_value->field_modificationRequestFor__CLIR__Data.encode_text(text_buf);
single_value->field_modificationRequestFor__HOLD__Data.encode_text(text_buf);
single_value->field_modificationRequestFor__ECT__Data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
}
}

void AnyTimeModificationArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_subscriberIdentity.decode_text(text_buf);
single_value->field_gsmSCF__Address.decode_text(text_buf);
single_value->field_modificationRequestFor__CF__Info.decode_text(text_buf);
single_value->field_modificationRequestFor__CB__Info.decode_text(text_buf);
single_value->field_modificationRequestFor__CSI.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_longFTN__Supported.decode_text(text_buf);
single_value->field_modificationRequestFor__ODB__data.decode_text(text_buf);
single_value->field_modificationRequestFor__IP__SM__GW__Data.decode_text(text_buf);
single_value->field_activationRequestForUE__reachability.decode_text(text_buf);
single_value->field_modificationRequestFor__CSG.decode_text(text_buf);
single_value->field_modificationRequestFor__CW__Data.decode_text(text_buf);
single_value->field_modificationRequestFor__CLIP__Data.decode_text(text_buf);
single_value->field_modificationRequestFor__CLIR__Data.decode_text(text_buf);
single_value->field_modificationRequestFor__HOLD__Data.decode_text(text_buf);
single_value->field_modificationRequestFor__ECT__Data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AnyTimeModificationArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.AnyTimeModificationArg.");
}
}

void AnyTimeModificationArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AnyTimeModificationArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (16<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.AnyTimeModificationArg has 16 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) subscriberIdentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gsmSCF__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CF__Info().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CB__Info().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CSI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) longFTN__Supported().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__ODB__data().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__IP__SM__GW__Data().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) activationRequestForUE__reachability().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CSG().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CW__Data().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CLIP__Data().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__CLIR__Data().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__HOLD__Data().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) modificationRequestFor__ECT__Data().set_param(*param.get_elem(15));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gsmSCF_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gsmSCF__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CF_Info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CF__Info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CB_Info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CB__Info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "longFTN_Supported")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          longFTN__Supported().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_ODB_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__ODB__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_IP_SM_GW_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__IP__SM__GW__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "activationRequestForUE_reachability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          activationRequestForUE__reachability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CSG")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CSG().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CW_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CW__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CLIP_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CLIP__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_CLIR_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__CLIR__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_HOLD_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__HOLD__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modificationRequestFor_ECT_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modificationRequestFor__ECT__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AnyTimeModificationArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AnyTimeModificationArg_template* precondition = new AnyTimeModificationArg_template;
    precondition->set_param(*param.get_elem(0));
    AnyTimeModificationArg_template* implied_template = new AnyTimeModificationArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AnyTimeModificationArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.AnyTimeModificationArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void AnyTimeModificationArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_subscriberIdentity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_gsmSCF__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CF__Info.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CB__Info.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CSI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_longFTN__Supported.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__ODB__data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__IP__SM__GW__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_activationRequestForUE__reachability.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CSG.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CW__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CLIP__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__CLIR__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__HOLD__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
single_value->field_modificationRequestFor__ECT__Data.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.AnyTimeModificationArg");
}

boolean AnyTimeModificationArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AnyTimeModificationArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ModificationRequestFor__CF__Info::ModificationRequestFor__CF__Info()
{
}

ModificationRequestFor__CF__Info::ModificationRequestFor__CF__Info(const OCTETSTRING& par_ss__Code,
    const OPTIONAL< MAP__CommonDataTypes::Ext__BasicServiceCode >& par_basicService,
    const OPTIONAL< OCTETSTRING >& par_ss__Status,
    const OPTIONAL< OCTETSTRING >& par_forwardedToNumber,
    const OPTIONAL< OCTETSTRING >& par_forwardedToSubaddress,
    const OPTIONAL< INTEGER >& par_noReplyConditionTime,
    const OPTIONAL< ModificationInstruction >& par_modifyNotificationToCSE,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_ss__Code(par_ss__Code),
  field_basicService(par_basicService),
  field_ss__Status(par_ss__Status),
  field_forwardedToNumber(par_forwardedToNumber),
  field_forwardedToSubaddress(par_forwardedToSubaddress),
  field_noReplyConditionTime(par_noReplyConditionTime),
  field_modifyNotificationToCSE(par_modifyNotificationToCSE),
  field_extensionContainer(par_extensionContainer)
{
}

ModificationRequestFor__CF__Info::ModificationRequestFor__CF__Info(const ModificationRequestFor__CF__Info& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
if (other_value.ss__Code().is_bound()) field_ss__Code = other_value.ss__Code();
else field_ss__Code.clean_up();
if (other_value.basicService().is_bound()) field_basicService = other_value.basicService();
else field_basicService.clean_up();
if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
else field_ss__Status.clean_up();
if (other_value.forwardedToNumber().is_bound()) field_forwardedToNumber = other_value.forwardedToNumber();
else field_forwardedToNumber.clean_up();
if (other_value.forwardedToSubaddress().is_bound()) field_forwardedToSubaddress = other_value.forwardedToSubaddress();
else field_forwardedToSubaddress.clean_up();
if (other_value.noReplyConditionTime().is_bound()) field_noReplyConditionTime = other_value.noReplyConditionTime();
else field_noReplyConditionTime.clean_up();
if (other_value.modifyNotificationToCSE().is_bound()) field_modifyNotificationToCSE = other_value.modifyNotificationToCSE();
else field_modifyNotificationToCSE.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void ModificationRequestFor__CF__Info::clean_up()
{
field_ss__Code.clean_up();
field_basicService.clean_up();
field_ss__Status.clean_up();
field_forwardedToNumber.clean_up();
field_forwardedToSubaddress.clean_up();
field_noReplyConditionTime.clean_up();
field_modifyNotificationToCSE.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* ModificationRequestFor__CF__Info::get_descriptor() const { return &ModificationRequestFor__CF__Info_descr_; }
ModificationRequestFor__CF__Info& ModificationRequestFor__CF__Info::operator=(const ModificationRequestFor__CF__Info& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
  if (other_value.ss__Code().is_bound()) field_ss__Code = other_value.ss__Code();
  else field_ss__Code.clean_up();
  if (other_value.basicService().is_bound()) field_basicService = other_value.basicService();
  else field_basicService.clean_up();
  if (other_value.ss__Status().is_bound()) field_ss__Status = other_value.ss__Status();
  else field_ss__Status.clean_up();
  if (other_value.forwardedToNumber().is_bound()) field_forwardedToNumber = other_value.forwardedToNumber();
  else field_forwardedToNumber.clean_up();
  if (other_value.forwardedToSubaddress().is_bound()) field_forwardedToSubaddress = other_value.forwardedToSubaddress();
  else field_forwardedToSubaddress.clean_up();
  if (other_value.noReplyConditionTime().is_bound()) field_noReplyConditionTime = other_value.noReplyConditionTime();
  else field_noReplyConditionTime.clean_up();
  if (other_value.modifyNotificationToCSE().is_bound()) field_modifyNotificationToCSE = other_value.modifyNotificationToCSE();
  else field_modifyNotificationToCSE.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean ModificationRequestFor__CF__Info::operator==(const ModificationRequestFor__CF__Info& other_value) const
{
return field_ss__Code==other_value.field_ss__Code
  && field_basicService==other_value.field_basicService
  && field_ss__Status==other_value.field_ss__Status
  && field_forwardedToNumber==other_value.field_forwardedToNumber
  && field_forwardedToSubaddress==other_value.field_forwardedToSubaddress
  && field_noReplyConditionTime==other_value.field_noReplyConditionTime
  && field_modifyNotificationToCSE==other_value.field_modifyNotificationToCSE
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean ModificationRequestFor__CF__Info::is_bound() const
{
return (field_ss__Code.is_bound())
  || (OPTIONAL_OMIT == field_basicService.get_selection() || field_basicService.is_bound())
  || (OPTIONAL_OMIT == field_ss__Status.get_selection() || field_ss__Status.is_bound())
  || (OPTIONAL_OMIT == field_forwardedToNumber.get_selection() || field_forwardedToNumber.is_bound())
  || (OPTIONAL_OMIT == field_forwardedToSubaddress.get_selection() || field_forwardedToSubaddress.is_bound())
  || (OPTIONAL_OMIT == field_noReplyConditionTime.get_selection() || field_noReplyConditionTime.is_bound())
  || (OPTIONAL_OMIT == field_modifyNotificationToCSE.get_selection() || field_modifyNotificationToCSE.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean ModificationRequestFor__CF__Info::is_value() const
{
return field_ss__Code.is_value()
  && (OPTIONAL_OMIT == field_basicService.get_selection() || field_basicService.is_value())
  && (OPTIONAL_OMIT == field_ss__Status.get_selection() || field_ss__Status.is_value())
  && (OPTIONAL_OMIT == field_forwardedToNumber.get_selection() || field_forwardedToNumber.is_value())
  && (OPTIONAL_OMIT == field_forwardedToSubaddress.get_selection() || field_forwardedToSubaddress.is_value())
  && (OPTIONAL_OMIT == field_noReplyConditionTime.get_selection() || field_noReplyConditionTime.is_value())
  && (OPTIONAL_OMIT == field_modifyNotificationToCSE.get_selection() || field_modifyNotificationToCSE.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int ModificationRequestFor__CF__Info::size_of() const
{
  int ret_val = 1;
  if (field_basicService.ispresent()) ret_val++;
  if (field_ss__Status.ispresent()) ret_val++;
  if (field_forwardedToNumber.ispresent()) ret_val++;
  if (field_forwardedToSubaddress.ispresent()) ret_val++;
  if (field_noReplyConditionTime.ispresent()) ret_val++;
  if (field_modifyNotificationToCSE.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void ModificationRequestFor__CF__Info::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ss_Code := ");
field_ss__Code.log();
TTCN_Logger::log_event_str(", basicService := ");
field_basicService.log();
TTCN_Logger::log_event_str(", ss_Status := ");
field_ss__Status.log();
TTCN_Logger::log_event_str(", forwardedToNumber := ");
field_forwardedToNumber.log();
TTCN_Logger::log_event_str(", forwardedToSubaddress := ");
field_forwardedToSubaddress.log();
TTCN_Logger::log_event_str(", noReplyConditionTime := ");
field_noReplyConditionTime.log();
TTCN_Logger::log_event_str(", modifyNotificationToCSE := ");
field_modifyNotificationToCSE.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void ModificationRequestFor__CF__Info::set_implicit_omit()
{
if (ss__Code().is_bound()) ss__Code().set_implicit_omit();
if (!basicService().is_bound()) basicService() = OMIT_VALUE;
else basicService().set_implicit_omit();
if (!ss__Status().is_bound()) ss__Status() = OMIT_VALUE;
else ss__Status().set_implicit_omit();
if (!forwardedToNumber().is_bound()) forwardedToNumber() = OMIT_VALUE;
else forwardedToNumber().set_implicit_omit();
if (!forwardedToSubaddress().is_bound()) forwardedToSubaddress() = OMIT_VALUE;
else forwardedToSubaddress().set_implicit_omit();
if (!noReplyConditionTime().is_bound()) noReplyConditionTime() = OMIT_VALUE;
else noReplyConditionTime().set_implicit_omit();
if (!modifyNotificationToCSE().is_bound()) modifyNotificationToCSE() = OMIT_VALUE;
else modifyNotificationToCSE().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void ModificationRequestFor__CF__Info::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Code().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) basicService().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) forwardedToNumber().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) forwardedToSubaddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) noReplyConditionTime().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) modifyNotificationToCSE().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicService")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicService().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardedToNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardedToNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardedToSubaddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardedToSubaddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "noReplyConditionTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          noReplyConditionTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modifyNotificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modifyNotificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
  }
}

void ModificationRequestFor__CF__Info::encode_text(Text_Buf& text_buf) const
{
field_ss__Code.encode_text(text_buf);
field_basicService.encode_text(text_buf);
field_ss__Status.encode_text(text_buf);
field_forwardedToNumber.encode_text(text_buf);
field_forwardedToSubaddress.encode_text(text_buf);
field_noReplyConditionTime.encode_text(text_buf);
field_modifyNotificationToCSE.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void ModificationRequestFor__CF__Info::decode_text(Text_Buf& text_buf)
{
field_ss__Code.decode_text(text_buf);
field_basicService.decode_text(text_buf);
field_ss__Status.decode_text(text_buf);
field_forwardedToNumber.decode_text(text_buf);
field_forwardedToSubaddress.decode_text(text_buf);
field_noReplyConditionTime.decode_text(text_buf);
field_modifyNotificationToCSE.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void ModificationRequestFor__CF__Info::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ModificationRequestFor__CF__Info::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ModificationRequestFor__CF__Info::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ss_Code': ");
  new_tlv->add_TLV(field_ss__Code.BER_encode_TLV(ModificationRequestFor__CF__Info_ss__Code_descr_, p_coding));
  ec_1.set_msg("basicService': ");
  new_tlv->add_TLV(field_basicService.BER_encode_TLV(ModificationRequestFor__CF__Info_basicService_descr_, p_coding));
  ec_1.set_msg("ss_Status': ");
  new_tlv->add_TLV(field_ss__Status.BER_encode_TLV(ModificationRequestFor__CF__Info_ss__Status_descr_, p_coding));
  ec_1.set_msg("forwardedToNumber': ");
  new_tlv->add_TLV(field_forwardedToNumber.BER_encode_TLV(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_coding));
  ec_1.set_msg("forwardedToSubaddress': ");
  new_tlv->add_TLV(field_forwardedToSubaddress.BER_encode_TLV(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_coding));
  ec_1.set_msg("noReplyConditionTime': ");
  new_tlv->add_TLV(field_noReplyConditionTime.BER_encode_TLV(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_coding));
  ec_1.set_msg("modifyNotificationToCSE': ");
  new_tlv->add_TLV(field_modifyNotificationToCSE.BER_encode_TLV(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ModificationRequestFor__CF__Info::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ModificationRequestFor-CF-Info' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ss_Code': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ss__Code.BER_decode_TLV(ModificationRequestFor__CF__Info_ss__Code_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("basicService': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_basicService=OMIT_VALUE;
    else {
      field_basicService.BER_decode_TLV(ModificationRequestFor__CF__Info_basicService_descr_, tmp_tlv, L_form);
      if(field_basicService.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ss_Status': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ss__Status=OMIT_VALUE;
    else {
      field_ss__Status.BER_decode_TLV(ModificationRequestFor__CF__Info_ss__Status_descr_, tmp_tlv, L_form);
      if(field_ss__Status.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("forwardedToNumber': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_forwardedToNumber=OMIT_VALUE;
    else {
      field_forwardedToNumber.BER_decode_TLV(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, tmp_tlv, L_form);
      if(field_forwardedToNumber.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("forwardedToSubaddress': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_forwardedToSubaddress=OMIT_VALUE;
    else {
      field_forwardedToSubaddress.BER_decode_TLV(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, tmp_tlv, L_form);
      if(field_forwardedToSubaddress.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("noReplyConditionTime': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_noReplyConditionTime=OMIT_VALUE;
    else {
      field_noReplyConditionTime.BER_decode_TLV(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, tmp_tlv, L_form);
      if(field_noReplyConditionTime.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("modifyNotificationToCSE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_modifyNotificationToCSE=OMIT_VALUE;
    else {
      field_modifyNotificationToCSE.BER_decode_TLV(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, tmp_tlv, L_form);
      if(field_modifyNotificationToCSE.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(ModificationRequestFor__CF__Info_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ModificationRequestFor__CF__Info::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Code");
    enc_len += field_ss__Code.JSON_encode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_tok, FALSE);
  }

  if (field_basicService.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "basicService");
    enc_len += field_basicService.JSON_encode(ModificationRequestFor__CF__Info_basicService_descr_, p_tok, FALSE);
  }

  if (field_ss__Status.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ss_Status");
    enc_len += field_ss__Status.JSON_encode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_tok, FALSE);
  }

  if (field_forwardedToNumber.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "forwardedToNumber");
    enc_len += field_forwardedToNumber.JSON_encode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_tok, FALSE);
  }

  if (field_forwardedToSubaddress.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "forwardedToSubaddress");
    enc_len += field_forwardedToSubaddress.JSON_encode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_tok, FALSE);
  }

  if (field_noReplyConditionTime.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "noReplyConditionTime");
    enc_len += field_noReplyConditionTime.JSON_encode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_tok, FALSE);
  }

  if (field_modifyNotificationToCSE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "modifyNotificationToCSE");
    enc_len += field_modifyNotificationToCSE.JSON_encode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ModificationRequestFor__CF__Info::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ModificationRequestFor__CF__Info*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ss__Code_found = FALSE;
  boolean basicService_found = FALSE;
  boolean ss__Status_found = FALSE;
  boolean forwardedToNumber_found = FALSE;
  boolean forwardedToSubaddress_found = FALSE;
  boolean noReplyConditionTime_found = FALSE;
  boolean modifyNotificationToCSE_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (7 == name_len && 0 == strncmp(fld_name, "ss_Code", name_len)) {
        ss__Code_found = TRUE;
         int ret_val = field_ss__Code.JSON_decode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 7, "ss_Code");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "basicService", name_len)) {
        basicService_found = TRUE;
         int ret_val = field_basicService.JSON_decode(ModificationRequestFor__CF__Info_basicService_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "basicService");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "ss_Status", name_len)) {
        ss__Status_found = TRUE;
         int ret_val = field_ss__Status.JSON_decode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "ss_Status");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "forwardedToNumber", name_len)) {
        forwardedToNumber_found = TRUE;
         int ret_val = field_forwardedToNumber.JSON_decode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "forwardedToNumber");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (21 == name_len && 0 == strncmp(fld_name, "forwardedToSubaddress", name_len)) {
        forwardedToSubaddress_found = TRUE;
         int ret_val = field_forwardedToSubaddress.JSON_decode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 21, "forwardedToSubaddress");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (20 == name_len && 0 == strncmp(fld_name, "noReplyConditionTime", name_len)) {
        noReplyConditionTime_found = TRUE;
         int ret_val = field_noReplyConditionTime.JSON_decode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "noReplyConditionTime");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (23 == name_len && 0 == strncmp(fld_name, "modifyNotificationToCSE", name_len)) {
        modifyNotificationToCSE_found = TRUE;
         int ret_val = field_modifyNotificationToCSE.JSON_decode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "modifyNotificationToCSE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ss__Code_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ss_Code");
    return JSON_ERROR_FATAL;
  }
  if (!basicService_found) {
    field_basicService = OMIT_VALUE;
  }
  if (!ss__Status_found) {
    field_ss__Status = OMIT_VALUE;
  }
  if (!forwardedToNumber_found) {
    field_forwardedToNumber = OMIT_VALUE;
  }
  if (!forwardedToSubaddress_found) {
    field_forwardedToSubaddress = OMIT_VALUE;
  }
  if (!noReplyConditionTime_found) {
    field_noReplyConditionTime = OMIT_VALUE;
  }
  if (!modifyNotificationToCSE_found) {
    field_modifyNotificationToCSE = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ModificationRequestFor__CF__Info::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_basicService.is_present()) {
    c |= 64;
  }
  if (field_ss__Status.is_present()) {
    c |= 32;
  }
  if (field_forwardedToNumber.is_present()) {
    c |= 16;
  }
  if (field_forwardedToSubaddress.is_present()) {
    c |= 8;
  }
  if (field_noReplyConditionTime.is_present()) {
    c |= 4;
  }
  if (field_modifyNotificationToCSE.is_present()) {
    c |= 2;
  }
  if (field_extensionContainer.is_present()) {
    c |= 1;
  }
  p_buf.put_c(c);
  c = 0
;  field_ss__Code.OER_encode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_buf);
  if (field_basicService.is_present())
    field_basicService.OER_encode(ModificationRequestFor__CF__Info_basicService_descr_, p_buf);
  if (field_ss__Status.is_present())
    field_ss__Status.OER_encode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_buf);
  if (field_forwardedToNumber.is_present())
    field_forwardedToNumber.OER_encode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_buf);
  if (field_forwardedToSubaddress.is_present())
    field_forwardedToSubaddress.OER_encode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_buf);
  if (field_noReplyConditionTime.is_present())
    field_noReplyConditionTime.OER_encode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_buf);
  if (field_modifyNotificationToCSE.is_present())
    field_modifyNotificationToCSE.OER_encode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_buf);
  return 0;
}

int ModificationRequestFor__CF__Info::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ss__Code.OER_decode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_basicService.OER_decode(ModificationRequestFor__CF__Info_basicService_descr_, p_buf, p_oer);
 else
    field_basicService = OMIT_VALUE;
  if (uc[0] & 32)
    field_ss__Status.OER_decode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_buf, p_oer);
 else
    field_ss__Status = OMIT_VALUE;
  if (uc[0] & 16)
    field_forwardedToNumber.OER_decode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_buf, p_oer);
 else
    field_forwardedToNumber = OMIT_VALUE;
  if (uc[0] & 8)
    field_forwardedToSubaddress.OER_decode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_buf, p_oer);
 else
    field_forwardedToSubaddress = OMIT_VALUE;
  if (uc[0] & 4)
    field_noReplyConditionTime.OER_decode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_buf, p_oer);
 else
    field_noReplyConditionTime = OMIT_VALUE;
  if (uc[0] & 2)
    field_modifyNotificationToCSE.OER_decode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_buf, p_oer);
 else
    field_modifyNotificationToCSE = OMIT_VALUE;
  if (uc[0] & 1)
    field_extensionContainer.OER_decode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void ModificationRequestFor__CF__Info::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_basicService_present = field_basicService.is_present();
p_buf.PER_put_bit(field_basicService_present);
boolean field_ss__Status_present = field_ss__Status.is_present();
p_buf.PER_put_bit(field_ss__Status_present);
boolean field_forwardedToNumber_present = field_forwardedToNumber.is_present();
p_buf.PER_put_bit(field_forwardedToNumber_present);
boolean field_forwardedToSubaddress_present = field_forwardedToSubaddress.is_present();
p_buf.PER_put_bit(field_forwardedToSubaddress_present);
boolean field_noReplyConditionTime_present = field_noReplyConditionTime.is_present();
p_buf.PER_put_bit(field_noReplyConditionTime_present);
boolean field_modifyNotificationToCSE_present = field_modifyNotificationToCSE.is_present();
p_buf.PER_put_bit(field_modifyNotificationToCSE_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_ss__Code.PER_encode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_buf, p_options);
if (field_basicService_present) field_basicService.PER_encode(ModificationRequestFor__CF__Info_basicService_descr_, p_buf, p_options);
if (field_ss__Status_present) field_ss__Status.PER_encode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_buf, p_options);
if (field_forwardedToNumber_present) field_forwardedToNumber.PER_encode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_buf, p_options);
if (field_forwardedToSubaddress_present) field_forwardedToSubaddress.PER_encode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_buf, p_options);
if (field_noReplyConditionTime_present) field_noReplyConditionTime.PER_encode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_buf, p_options);
if (field_modifyNotificationToCSE_present) field_modifyNotificationToCSE.PER_encode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_buf, p_options);
}

void ModificationRequestFor__CF__Info::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_basicService_present = p_buf.PER_get_bit();
boolean field_ss__Status_present = p_buf.PER_get_bit();
boolean field_forwardedToNumber_present = p_buf.PER_get_bit();
boolean field_forwardedToSubaddress_present = p_buf.PER_get_bit();
boolean field_noReplyConditionTime_present = p_buf.PER_get_bit();
boolean field_modifyNotificationToCSE_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_ss__Code.PER_decode(ModificationRequestFor__CF__Info_ss__Code_descr_, p_buf, p_options);
if (field_basicService_present) field_basicService.PER_decode(ModificationRequestFor__CF__Info_basicService_descr_, p_buf, p_options);
else field_basicService = OMIT_VALUE;
if (field_ss__Status_present) field_ss__Status.PER_decode(ModificationRequestFor__CF__Info_ss__Status_descr_, p_buf, p_options);
else field_ss__Status = OMIT_VALUE;
if (field_forwardedToNumber_present) field_forwardedToNumber.PER_decode(ModificationRequestFor__CF__Info_forwardedToNumber_descr_, p_buf, p_options);
else field_forwardedToNumber = OMIT_VALUE;
if (field_forwardedToSubaddress_present) field_forwardedToSubaddress.PER_decode(ModificationRequestFor__CF__Info_forwardedToSubaddress_descr_, p_buf, p_options);
else field_forwardedToSubaddress = OMIT_VALUE;
if (field_noReplyConditionTime_present) field_noReplyConditionTime.PER_decode(ModificationRequestFor__CF__Info_noReplyConditionTime_descr_, p_buf, p_options);
else field_noReplyConditionTime = OMIT_VALUE;
if (field_modifyNotificationToCSE_present) field_modifyNotificationToCSE.PER_decode(ModificationRequestFor__CF__Info_modifyNotificationToCSE_descr_, p_buf, p_options);
else field_modifyNotificationToCSE = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(ModificationRequestFor__CF__Info_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ModificationRequestFor__CF__Info_template::single_value_struct {
OCTETSTRING_template field_ss__Code;
MAP__CommonDataTypes::Ext__BasicServiceCode_template field_basicService;
OCTETSTRING_template field_ss__Status;
OCTETSTRING_template field_forwardedToNumber;
OCTETSTRING_template field_forwardedToSubaddress;
INTEGER_template field_noReplyConditionTime;
ModificationInstruction_template field_modifyNotificationToCSE;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void ModificationRequestFor__CF__Info_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ss__Code = ANY_VALUE;
single_value->field_basicService = ANY_OR_OMIT;
single_value->field_ss__Status = ANY_OR_OMIT;
single_value->field_forwardedToNumber = ANY_OR_OMIT;
single_value->field_forwardedToSubaddress = ANY_OR_OMIT;
single_value->field_noReplyConditionTime = ANY_OR_OMIT;
single_value->field_modifyNotificationToCSE = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void ModificationRequestFor__CF__Info_template::copy_value(const ModificationRequestFor__CF__Info& other_value)
{
single_value = new single_value_struct;
if (other_value.ss__Code().is_bound()) {
  single_value->field_ss__Code = other_value.ss__Code();
} else {
  single_value->field_ss__Code.clean_up();
}
if (other_value.basicService().is_bound()) {
  if (other_value.basicService().ispresent()) single_value->field_basicService = other_value.basicService()();
  else single_value->field_basicService = OMIT_VALUE;
} else {
  single_value->field_basicService.clean_up();
}
if (other_value.ss__Status().is_bound()) {
  if (other_value.ss__Status().ispresent()) single_value->field_ss__Status = other_value.ss__Status()();
  else single_value->field_ss__Status = OMIT_VALUE;
} else {
  single_value->field_ss__Status.clean_up();
}
if (other_value.forwardedToNumber().is_bound()) {
  if (other_value.forwardedToNumber().ispresent()) single_value->field_forwardedToNumber = other_value.forwardedToNumber()();
  else single_value->field_forwardedToNumber = OMIT_VALUE;
} else {
  single_value->field_forwardedToNumber.clean_up();
}
if (other_value.forwardedToSubaddress().is_bound()) {
  if (other_value.forwardedToSubaddress().ispresent()) single_value->field_forwardedToSubaddress = other_value.forwardedToSubaddress()();
  else single_value->field_forwardedToSubaddress = OMIT_VALUE;
} else {
  single_value->field_forwardedToSubaddress.clean_up();
}
if (other_value.noReplyConditionTime().is_bound()) {
  if (other_value.noReplyConditionTime().ispresent()) single_value->field_noReplyConditionTime = other_value.noReplyConditionTime()();
  else single_value->field_noReplyConditionTime = OMIT_VALUE;
} else {
  single_value->field_noReplyConditionTime.clean_up();
}
if (other_value.modifyNotificationToCSE().is_bound()) {
  if (other_value.modifyNotificationToCSE().ispresent()) single_value->field_modifyNotificationToCSE = other_value.modifyNotificationToCSE()();
  else single_value->field_modifyNotificationToCSE = OMIT_VALUE;
} else {
  single_value->field_modifyNotificationToCSE.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ModificationRequestFor__CF__Info_template::copy_template(const ModificationRequestFor__CF__Info_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ss__Code().get_selection()) {
single_value->field_ss__Code = other_value.ss__Code();
} else {
single_value->field_ss__Code.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.basicService().get_selection()) {
single_value->field_basicService = other_value.basicService();
} else {
single_value->field_basicService.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__Status().get_selection()) {
single_value->field_ss__Status = other_value.ss__Status();
} else {
single_value->field_ss__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwardedToNumber().get_selection()) {
single_value->field_forwardedToNumber = other_value.forwardedToNumber();
} else {
single_value->field_forwardedToNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwardedToSubaddress().get_selection()) {
single_value->field_forwardedToSubaddress = other_value.forwardedToSubaddress();
} else {
single_value->field_forwardedToSubaddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.noReplyConditionTime().get_selection()) {
single_value->field_noReplyConditionTime = other_value.noReplyConditionTime();
} else {
single_value->field_noReplyConditionTime.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.modifyNotificationToCSE().get_selection()) {
single_value->field_modifyNotificationToCSE = other_value.modifyNotificationToCSE();
} else {
single_value->field_modifyNotificationToCSE.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ModificationRequestFor__CF__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ModificationRequestFor__CF__Info_template(*other_value.implication_.precondition);
implication_.implied_template = new ModificationRequestFor__CF__Info_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
break;
}
set_selection(other_value);
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template()
{
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(const ModificationRequestFor__CF__Info& other_value)
{
copy_value(other_value);
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(const OPTIONAL<ModificationRequestFor__CF__Info>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ModificationRequestFor__CF__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info from an unbound optional field.");
}
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(ModificationRequestFor__CF__Info_template* p_precondition, ModificationRequestFor__CF__Info_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(Dynamic_Match_Interface<ModificationRequestFor__CF__Info>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ModificationRequestFor__CF__Info>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ModificationRequestFor__CF__Info_template::ModificationRequestFor__CF__Info_template(const ModificationRequestFor__CF__Info_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ModificationRequestFor__CF__Info_template::~ModificationRequestFor__CF__Info_template()
{
clean_up();
}

ModificationRequestFor__CF__Info_template& ModificationRequestFor__CF__Info_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ModificationRequestFor__CF__Info_template& ModificationRequestFor__CF__Info_template::operator=(const ModificationRequestFor__CF__Info& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ModificationRequestFor__CF__Info_template& ModificationRequestFor__CF__Info_template::operator=(const OPTIONAL<ModificationRequestFor__CF__Info>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ModificationRequestFor__CF__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
}
return *this;
}

ModificationRequestFor__CF__Info_template& ModificationRequestFor__CF__Info_template::operator=(const ModificationRequestFor__CF__Info_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ModificationRequestFor__CF__Info_template::match(const ModificationRequestFor__CF__Info& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ss__Code().is_bound()) return FALSE;
if(!single_value->field_ss__Code.match(other_value.ss__Code(), legacy))return FALSE;
if(!other_value.basicService().is_bound()) return FALSE;
if((other_value.basicService().ispresent() ? !single_value->field_basicService.match((const MAP__CommonDataTypes::Ext__BasicServiceCode&)other_value.basicService(), legacy) : !single_value->field_basicService.match_omit(legacy)))return FALSE;
if(!other_value.ss__Status().is_bound()) return FALSE;
if((other_value.ss__Status().ispresent() ? !single_value->field_ss__Status.match((const OCTETSTRING&)other_value.ss__Status(), legacy) : !single_value->field_ss__Status.match_omit(legacy)))return FALSE;
if(!other_value.forwardedToNumber().is_bound()) return FALSE;
if((other_value.forwardedToNumber().ispresent() ? !single_value->field_forwardedToNumber.match((const OCTETSTRING&)other_value.forwardedToNumber(), legacy) : !single_value->field_forwardedToNumber.match_omit(legacy)))return FALSE;
if(!other_value.forwardedToSubaddress().is_bound()) return FALSE;
if((other_value.forwardedToSubaddress().ispresent() ? !single_value->field_forwardedToSubaddress.match((const OCTETSTRING&)other_value.forwardedToSubaddress(), legacy) : !single_value->field_forwardedToSubaddress.match_omit(legacy)))return FALSE;
if(!other_value.noReplyConditionTime().is_bound()) return FALSE;
if((other_value.noReplyConditionTime().ispresent() ? !single_value->field_noReplyConditionTime.match((const INTEGER&)other_value.noReplyConditionTime(), legacy) : !single_value->field_noReplyConditionTime.match_omit(legacy)))return FALSE;
if(!other_value.modifyNotificationToCSE().is_bound()) return FALSE;
if((other_value.modifyNotificationToCSE().ispresent() ? !single_value->field_modifyNotificationToCSE.match((const ModificationInstruction&)other_value.modifyNotificationToCSE(), legacy) : !single_value->field_modifyNotificationToCSE.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
}
return FALSE;
}

boolean ModificationRequestFor__CF__Info_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ss__Code.is_bound()
 || (single_value->field_basicService.is_omit() || single_value->field_basicService.is_bound())
 || (single_value->field_ss__Status.is_omit() || single_value->field_ss__Status.is_bound())
 || (single_value->field_forwardedToNumber.is_omit() || single_value->field_forwardedToNumber.is_bound())
 || (single_value->field_forwardedToSubaddress.is_omit() || single_value->field_forwardedToSubaddress.is_bound())
 || (single_value->field_noReplyConditionTime.is_omit() || single_value->field_noReplyConditionTime.is_bound())
 || (single_value->field_modifyNotificationToCSE.is_omit() || single_value->field_modifyNotificationToCSE.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean ModificationRequestFor__CF__Info_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ss__Code.is_value()
 && (single_value->field_basicService.is_omit() || single_value->field_basicService.is_value())
 && (single_value->field_ss__Status.is_omit() || single_value->field_ss__Status.is_value())
 && (single_value->field_forwardedToNumber.is_omit() || single_value->field_forwardedToNumber.is_value())
 && (single_value->field_forwardedToSubaddress.is_omit() || single_value->field_forwardedToSubaddress.is_value())
 && (single_value->field_noReplyConditionTime.is_omit() || single_value->field_noReplyConditionTime.is_value())
 && (single_value->field_modifyNotificationToCSE.is_omit() || single_value->field_modifyNotificationToCSE.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void ModificationRequestFor__CF__Info_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ModificationRequestFor__CF__Info ModificationRequestFor__CF__Info_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
ModificationRequestFor__CF__Info ret_val;
if (single_value->field_ss__Code.is_bound()) {
ret_val.ss__Code() = single_value->field_ss__Code.valueof();
}
if (single_value->field_basicService.is_omit()) ret_val.basicService() = OMIT_VALUE;
else if (single_value->field_basicService.is_bound()) {
ret_val.basicService() = single_value->field_basicService.valueof();
}
if (single_value->field_ss__Status.is_omit()) ret_val.ss__Status() = OMIT_VALUE;
else if (single_value->field_ss__Status.is_bound()) {
ret_val.ss__Status() = single_value->field_ss__Status.valueof();
}
if (single_value->field_forwardedToNumber.is_omit()) ret_val.forwardedToNumber() = OMIT_VALUE;
else if (single_value->field_forwardedToNumber.is_bound()) {
ret_val.forwardedToNumber() = single_value->field_forwardedToNumber.valueof();
}
if (single_value->field_forwardedToSubaddress.is_omit()) ret_val.forwardedToSubaddress() = OMIT_VALUE;
else if (single_value->field_forwardedToSubaddress.is_bound()) {
ret_val.forwardedToSubaddress() = single_value->field_forwardedToSubaddress.valueof();
}
if (single_value->field_noReplyConditionTime.is_omit()) ret_val.noReplyConditionTime() = OMIT_VALUE;
else if (single_value->field_noReplyConditionTime.is_bound()) {
ret_val.noReplyConditionTime() = single_value->field_noReplyConditionTime.valueof();
}
if (single_value->field_modifyNotificationToCSE.is_omit()) ret_val.modifyNotificationToCSE() = OMIT_VALUE;
else if (single_value->field_modifyNotificationToCSE.is_bound()) {
ret_val.modifyNotificationToCSE() = single_value->field_modifyNotificationToCSE.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void ModificationRequestFor__CF__Info_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ModificationRequestFor__CF__Info_template[list_length];
}

ModificationRequestFor__CF__Info_template& ModificationRequestFor__CF__Info_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ModificationRequestFor__CF__Info_template::ss__Code()
{
set_specific();
return single_value->field_ss__Code;
}

const OCTETSTRING_template& ModificationRequestFor__CF__Info_template::ss__Code() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Code of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_ss__Code;
}

MAP__CommonDataTypes::Ext__BasicServiceCode_template& ModificationRequestFor__CF__Info_template::basicService()
{
set_specific();
return single_value->field_basicService;
}

const MAP__CommonDataTypes::Ext__BasicServiceCode_template& ModificationRequestFor__CF__Info_template::basicService() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field basicService of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_basicService;
}

OCTETSTRING_template& ModificationRequestFor__CF__Info_template::ss__Status()
{
set_specific();
return single_value->field_ss__Status;
}

const OCTETSTRING_template& ModificationRequestFor__CF__Info_template::ss__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_Status of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_ss__Status;
}

OCTETSTRING_template& ModificationRequestFor__CF__Info_template::forwardedToNumber()
{
set_specific();
return single_value->field_forwardedToNumber;
}

const OCTETSTRING_template& ModificationRequestFor__CF__Info_template::forwardedToNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwardedToNumber of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_forwardedToNumber;
}

OCTETSTRING_template& ModificationRequestFor__CF__Info_template::forwardedToSubaddress()
{
set_specific();
return single_value->field_forwardedToSubaddress;
}

const OCTETSTRING_template& ModificationRequestFor__CF__Info_template::forwardedToSubaddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwardedToSubaddress of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_forwardedToSubaddress;
}

INTEGER_template& ModificationRequestFor__CF__Info_template::noReplyConditionTime()
{
set_specific();
return single_value->field_noReplyConditionTime;
}

const INTEGER_template& ModificationRequestFor__CF__Info_template::noReplyConditionTime() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field noReplyConditionTime of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_noReplyConditionTime;
}

ModificationInstruction_template& ModificationRequestFor__CF__Info_template::modifyNotificationToCSE()
{
set_specific();
return single_value->field_modifyNotificationToCSE;
}

const ModificationInstruction_template& ModificationRequestFor__CF__Info_template::modifyNotificationToCSE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modifyNotificationToCSE of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_modifyNotificationToCSE;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& ModificationRequestFor__CF__Info_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& ModificationRequestFor__CF__Info_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
return single_value->field_extensionContainer;
}

int ModificationRequestFor__CF__Info_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_basicService.is_present()) ret_val++;
      if (single_value->field_ss__Status.is_present()) ret_val++;
      if (single_value->field_forwardedToNumber.is_present()) ret_val++;
      if (single_value->field_forwardedToSubaddress.is_present()) ret_val++;
      if (single_value->field_noReplyConditionTime.is_present()) ret_val++;
      if (single_value->field_modifyNotificationToCSE.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
  }
  return 0;
}

void ModificationRequestFor__CF__Info_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ss_Code := ");
single_value->field_ss__Code.log();
TTCN_Logger::log_event_str(", basicService := ");
single_value->field_basicService.log();
TTCN_Logger::log_event_str(", ss_Status := ");
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(", forwardedToNumber := ");
single_value->field_forwardedToNumber.log();
TTCN_Logger::log_event_str(", forwardedToSubaddress := ");
single_value->field_forwardedToSubaddress.log();
TTCN_Logger::log_event_str(", noReplyConditionTime := ");
single_value->field_noReplyConditionTime.log();
TTCN_Logger::log_event_str(", modifyNotificationToCSE := ");
single_value->field_modifyNotificationToCSE.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ModificationRequestFor__CF__Info_template::log_match(const ModificationRequestFor__CF__Info& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ss__Code.match(match_value.ss__Code(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Code");
single_value->field_ss__Code.log_match(match_value.ss__Code(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.basicService().ispresent()){
if(!single_value->field_basicService.match(match_value.basicService(), legacy)){
TTCN_Logger::log_logmatch_info(".basicService");
single_value->field_basicService.log_match(match_value.basicService(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_basicService.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".basicService := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_basicService.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ss__Status().ispresent()){
if(!single_value->field_ss__Status.match(match_value.ss__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_Status");
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ss__Status.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ss_Status := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ss__Status.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.forwardedToNumber().ispresent()){
if(!single_value->field_forwardedToNumber.match(match_value.forwardedToNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".forwardedToNumber");
single_value->field_forwardedToNumber.log_match(match_value.forwardedToNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_forwardedToNumber.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".forwardedToNumber := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_forwardedToNumber.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.forwardedToSubaddress().ispresent()){
if(!single_value->field_forwardedToSubaddress.match(match_value.forwardedToSubaddress(), legacy)){
TTCN_Logger::log_logmatch_info(".forwardedToSubaddress");
single_value->field_forwardedToSubaddress.log_match(match_value.forwardedToSubaddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_forwardedToSubaddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".forwardedToSubaddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_forwardedToSubaddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.noReplyConditionTime().ispresent()){
if(!single_value->field_noReplyConditionTime.match(match_value.noReplyConditionTime(), legacy)){
TTCN_Logger::log_logmatch_info(".noReplyConditionTime");
single_value->field_noReplyConditionTime.log_match(match_value.noReplyConditionTime(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_noReplyConditionTime.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".noReplyConditionTime := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_noReplyConditionTime.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.modifyNotificationToCSE().ispresent()){
if(!single_value->field_modifyNotificationToCSE.match(match_value.modifyNotificationToCSE(), legacy)){
TTCN_Logger::log_logmatch_info(".modifyNotificationToCSE");
single_value->field_modifyNotificationToCSE.log_match(match_value.modifyNotificationToCSE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_modifyNotificationToCSE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".modifyNotificationToCSE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_modifyNotificationToCSE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ss_Code := ");
single_value->field_ss__Code.log_match(match_value.ss__Code(), legacy);
TTCN_Logger::log_event_str(", basicService := ");
if (match_value.basicService().ispresent()) {
single_value->field_basicService.log_match(match_value.basicService(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_basicService.log();
if (single_value->field_basicService.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ss_Status := ");
if (match_value.ss__Status().ispresent()) {
single_value->field_ss__Status.log_match(match_value.ss__Status(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ss__Status.log();
if (single_value->field_ss__Status.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", forwardedToNumber := ");
if (match_value.forwardedToNumber().ispresent()) {
single_value->field_forwardedToNumber.log_match(match_value.forwardedToNumber(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_forwardedToNumber.log();
if (single_value->field_forwardedToNumber.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", forwardedToSubaddress := ");
if (match_value.forwardedToSubaddress().ispresent()) {
single_value->field_forwardedToSubaddress.log_match(match_value.forwardedToSubaddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_forwardedToSubaddress.log();
if (single_value->field_forwardedToSubaddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", noReplyConditionTime := ");
if (match_value.noReplyConditionTime().ispresent()) {
single_value->field_noReplyConditionTime.log_match(match_value.noReplyConditionTime(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_noReplyConditionTime.log();
if (single_value->field_noReplyConditionTime.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", modifyNotificationToCSE := ");
if (match_value.modifyNotificationToCSE().ispresent()) {
single_value->field_modifyNotificationToCSE.log_match(match_value.modifyNotificationToCSE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_modifyNotificationToCSE.log();
if (single_value->field_modifyNotificationToCSE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ModificationRequestFor__CF__Info_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ss__Code().is_bound()) ss__Code().set_implicit_omit();
if (!basicService().is_bound()) basicService() = OMIT_VALUE;
else basicService().set_implicit_omit();
if (!ss__Status().is_bound()) ss__Status() = OMIT_VALUE;
else ss__Status().set_implicit_omit();
if (!forwardedToNumber().is_bound()) forwardedToNumber() = OMIT_VALUE;
else forwardedToNumber().set_implicit_omit();
if (!forwardedToSubaddress().is_bound()) forwardedToSubaddress() = OMIT_VALUE;
else forwardedToSubaddress().set_implicit_omit();
if (!noReplyConditionTime().is_bound()) noReplyConditionTime() = OMIT_VALUE;
else noReplyConditionTime().set_implicit_omit();
if (!modifyNotificationToCSE().is_bound()) modifyNotificationToCSE() = OMIT_VALUE;
else modifyNotificationToCSE().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void ModificationRequestFor__CF__Info_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ss__Code.encode_text(text_buf);
single_value->field_basicService.encode_text(text_buf);
single_value->field_ss__Status.encode_text(text_buf);
single_value->field_forwardedToNumber.encode_text(text_buf);
single_value->field_forwardedToSubaddress.encode_text(text_buf);
single_value->field_noReplyConditionTime.encode_text(text_buf);
single_value->field_modifyNotificationToCSE.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
}
}

void ModificationRequestFor__CF__Info_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ss__Code.decode_text(text_buf);
single_value->field_basicService.decode_text(text_buf);
single_value->field_ss__Status.decode_text(text_buf);
single_value->field_forwardedToNumber.decode_text(text_buf);
single_value->field_forwardedToSubaddress.decode_text(text_buf);
single_value->field_noReplyConditionTime.decode_text(text_buf);
single_value->field_modifyNotificationToCSE.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ModificationRequestFor__CF__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info.");
}
}

void ModificationRequestFor__CF__Info_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ModificationRequestFor__CF__Info_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ss__Code().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) basicService().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ss__Status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) forwardedToNumber().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) forwardedToSubaddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) noReplyConditionTime().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) modifyNotificationToCSE().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "basicService")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          basicService().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardedToNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardedToNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardedToSubaddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardedToSubaddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "noReplyConditionTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          noReplyConditionTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modifyNotificationToCSE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modifyNotificationToCSE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ModificationRequestFor-CF-Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ModificationRequestFor__CF__Info_template* precondition = new ModificationRequestFor__CF__Info_template;
    precondition->set_param(*param.get_elem(0));
    ModificationRequestFor__CF__Info_template* implied_template = new ModificationRequestFor__CF__Info_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ModificationRequestFor__CF__Info_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
  }
  is_ifpresent = param.get_ifpresent();
}

void ModificationRequestFor__CF__Info_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ss__Code.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_basicService.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_ss__Status.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_forwardedToNumber.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_forwardedToSubaddress.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_noReplyConditionTime.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_modifyNotificationToCSE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ModificationRequestFor-CF-Info");
}

boolean ModificationRequestFor__CF__Info_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ModificationRequestFor__CF__Info_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ModificationInstruction::ModificationInstruction()
{
enum_value = UNBOUND_VALUE;
}

ModificationInstruction::ModificationInstruction(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.ModificationInstruction with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

ModificationInstruction::ModificationInstruction(enum_type other_value)
{
enum_value = other_value;
}

ModificationInstruction::ModificationInstruction(const ModificationInstruction& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
enum_value = other_value.enum_value;
}

ModificationInstruction& ModificationInstruction::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.ModificationInstruction.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

ModificationInstruction& ModificationInstruction::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

ModificationInstruction& ModificationInstruction::operator=(const ModificationInstruction& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
enum_value = other_value.enum_value;
return *this;
}

boolean ModificationInstruction::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.ModificationInstruction comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean ModificationInstruction::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value == other_value;
}

boolean ModificationInstruction::operator==(const ModificationInstruction& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value == other_value.enum_value;
}

boolean ModificationInstruction::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.ModificationInstruction comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean ModificationInstruction::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value < other_value;
}

boolean ModificationInstruction::operator<(const ModificationInstruction& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value < other_value.enum_value;
}

boolean ModificationInstruction::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.ModificationInstruction comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean ModificationInstruction::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value > other_value;
}

boolean ModificationInstruction::operator>(const ModificationInstruction& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value > other_value.enum_value;
}

const char *ModificationInstruction::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case deactivate__: return "deactivate_";
case activate__: return "activate_";
default:
return "<unknown>";
}
}

ModificationInstruction::enum_type ModificationInstruction::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "deactivate_")) return deactivate__;
if (!strcmp(str_par, "activate_")) return activate__;
}
return UNKNOWN_VALUE;
}

boolean ModificationInstruction::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int ModificationInstruction::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int ModificationInstruction::enum2int(const ModificationInstruction& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void ModificationInstruction::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.ModificationInstruction.", int_val);
enum_value = (enum_type)int_val;
}

ModificationInstruction::operator ModificationInstruction::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
return enum_value;
}

void ModificationInstruction::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void ModificationInstruction::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.ModificationInstruction");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.ModificationInstruction.");
  }
}

void ModificationInstruction::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
text_buf.push_int(enum_value);
}

void ModificationInstruction::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.ModificationInstruction.", enum_value);
}

void ModificationInstruction::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ModificationInstruction::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ModificationInstruction::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ModificationInstruction::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.ModificationInstruction: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int ModificationInstruction::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int ModificationInstruction::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ModificationInstruction*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = deactivate__;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int ModificationInstruction::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int ModificationInstruction::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void ModificationInstruction::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
switch (enum_value) {
case deactivate__:
enc_val = 0;
break;
case activate__:
enc_val = 1;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
}
INTEGER::PER_encode_int(p_buf, enc_val, 1);
}

void ModificationInstruction::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
dec_val.PER_decode_unaligned_constrained(p_buf, 1, FALSE);
int dec_int = dec_val;
switch (dec_int) {
case 0: enum_value = deactivate__; break;
case 1: enum_value = activate__; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.ModificationInstruction.", dec_int);
break;
}
}

void ModificationInstruction_template::copy_template(const ModificationInstruction_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ModificationInstruction_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ModificationInstruction_template(*other_value.implication_.precondition);
implication_.implied_template = new ModificationInstruction_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
}
}

ModificationInstruction_template::ModificationInstruction_template()
{
}

ModificationInstruction_template::ModificationInstruction_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ModificationInstruction_template::ModificationInstruction_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!ModificationInstruction::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.ModificationInstruction with unknown numeric value %d.", other_value);
single_value = (ModificationInstruction::enum_type)other_value;
}

ModificationInstruction_template::ModificationInstruction_template(ModificationInstruction::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

ModificationInstruction_template::ModificationInstruction_template(const ModificationInstruction& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == ModificationInstruction::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.ModificationInstruction.");
single_value = other_value.enum_value;
}

ModificationInstruction_template::ModificationInstruction_template(const OPTIONAL<ModificationInstruction>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (ModificationInstruction::enum_type)(const ModificationInstruction&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.ModificationInstruction from an unbound optional field.");
}
}

ModificationInstruction_template::ModificationInstruction_template(ModificationInstruction_template* p_precondition, ModificationInstruction_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ModificationInstruction_template::ModificationInstruction_template(Dynamic_Match_Interface<ModificationInstruction>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ModificationInstruction>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ModificationInstruction_template::ModificationInstruction_template(const ModificationInstruction_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

ModificationInstruction_template::~ModificationInstruction_template()
{
clean_up();
}

boolea