// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_CC_Types.hh"

namespace MobileL3__CC__Types {

/* Member functions of C++ classes */

PDU__ML3__StartCC::PDU__ML3__StartCC()
{
}

PDU__ML3__StartCC::PDU__ML3__StartCC(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< CallControlCapabilities >& par_cC__Capabilities)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_cC__Capabilities(par_cC__Capabilities)
{
}

PDU__ML3__StartCC::PDU__ML3__StartCC(const PDU__ML3__StartCC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.cC__Capabilities().is_bound()) field_cC__Capabilities = other_value.cC__Capabilities();
else field_cC__Capabilities.clean_up();
}

void PDU__ML3__StartCC::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_cC__Capabilities.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StartCC::get_descriptor() const { return &PDU__ML3__StartCC_descr_; }
PDU__ML3__StartCC& PDU__ML3__StartCC::operator=(const PDU__ML3__StartCC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.cC__Capabilities().is_bound()) field_cC__Capabilities = other_value.cC__Capabilities();
  else field_cC__Capabilities.clean_up();
}
return *this;
}

boolean PDU__ML3__StartCC::operator==(const PDU__ML3__StartCC& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_cC__Capabilities==other_value.field_cC__Capabilities;
}

boolean PDU__ML3__StartCC::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_cC__Capabilities.get_selection() || field_cC__Capabilities.is_bound());
}
boolean PDU__ML3__StartCC::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_cC__Capabilities.get_selection() || field_cC__Capabilities.is_value());
}
int PDU__ML3__StartCC::size_of() const
{
  int ret_val = 2;
  if (field_cC__Capabilities.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__StartCC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", cC_Capabilities := ");
field_cC__Capabilities.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StartCC::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!cC__Capabilities().is_bound()) cC__Capabilities() = OMIT_VALUE;
else cC__Capabilities().set_implicit_omit();
}

void PDU__ML3__StartCC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StartCC has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cC__Capabilities().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cC_Capabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cC__Capabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartCC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StartCC");
  }
}

void PDU__ML3__StartCC::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_cC__Capabilities.encode_text(text_buf);
}

void PDU__ML3__StartCC::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_cC__Capabilities.decode_text(text_buf);
}

void PDU__ML3__StartCC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StartCC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StartCC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_cC__Capabilities = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, CallControlCapabilities_descr_.raw->forceomit);
  decoded_field_length = field_cC__Capabilities().RAW_decode(CallControlCapabilities_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_cC__Capabilities = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_cC__Capabilities.ispresent() || field_cC__Capabilities().elementIdentifier() !=  os_6){
  field_cC__Capabilities=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_cC__Capabilities=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StartCC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_cC__Capabilities.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, CallControlCapabilities_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_cC__Capabilities.ispresent()) {
  encoded_length += field_cC__Capabilities().RAW_encode(CallControlCapabilities_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_cC__Capabilities.ispresent() && (!field_cC__Capabilities.ispresent() || field_cC__Capabilities().elementIdentifier() !=  os_6)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_6.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StartCC_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
CallControlCapabilities_template field_cC__Capabilities;
};

void PDU__ML3__StartCC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_cC__Capabilities = ANY_OR_OMIT;
}
}
}

void PDU__ML3__StartCC_template::copy_value(const PDU__ML3__StartCC& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.cC__Capabilities().is_bound()) {
  if (other_value.cC__Capabilities().ispresent()) single_value->field_cC__Capabilities = other_value.cC__Capabilities()();
  else single_value->field_cC__Capabilities = OMIT_VALUE;
} else {
  single_value->field_cC__Capabilities.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StartCC_template::copy_template(const PDU__ML3__StartCC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cC__Capabilities().get_selection()) {
single_value->field_cC__Capabilities = other_value.cC__Capabilities();
} else {
single_value->field_cC__Capabilities.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StartCC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StartCC_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StartCC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
break;
}
set_selection(other_value);
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template()
{
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(const PDU__ML3__StartCC& other_value)
{
copy_value(other_value);
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(const OPTIONAL<PDU__ML3__StartCC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartCC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StartCC from an unbound optional field.");
}
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(PDU__ML3__StartCC_template* p_precondition, PDU__ML3__StartCC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(Dynamic_Match_Interface<PDU__ML3__StartCC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StartCC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StartCC_template::PDU__ML3__StartCC_template(const PDU__ML3__StartCC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StartCC_template::~PDU__ML3__StartCC_template()
{
clean_up();
}

PDU__ML3__StartCC_template& PDU__ML3__StartCC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StartCC_template& PDU__ML3__StartCC_template::operator=(const PDU__ML3__StartCC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StartCC_template& PDU__ML3__StartCC_template::operator=(const OPTIONAL<PDU__ML3__StartCC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartCC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
}
return *this;
}

PDU__ML3__StartCC_template& PDU__ML3__StartCC_template::operator=(const PDU__ML3__StartCC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StartCC_template::match(const PDU__ML3__StartCC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.cC__Capabilities().is_bound()) return FALSE;
if((other_value.cC__Capabilities().ispresent() ? !single_value->field_cC__Capabilities.match((const CallControlCapabilities&)other_value.cC__Capabilities(), legacy) : !single_value->field_cC__Capabilities.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
}
return FALSE;
}

boolean PDU__ML3__StartCC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_cC__Capabilities.is_omit() || single_value->field_cC__Capabilities.is_bound());
}

boolean PDU__ML3__StartCC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_cC__Capabilities.is_omit() || single_value->field_cC__Capabilities.is_value());
}

void PDU__ML3__StartCC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StartCC PDU__ML3__StartCC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
PDU__ML3__StartCC ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_cC__Capabilities.is_omit()) ret_val.cC__Capabilities() = OMIT_VALUE;
else if (single_value->field_cC__Capabilities.is_bound()) {
ret_val.cC__Capabilities() = single_value->field_cC__Capabilities.valueof();
}
return ret_val;
}

void PDU__ML3__StartCC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StartCC_template[list_length];
}

PDU__ML3__StartCC_template& PDU__ML3__StartCC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StartCC_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StartCC_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StartCC_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StartCC_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
return single_value->field_nsd;
}

CallControlCapabilities_template& PDU__ML3__StartCC_template::cC__Capabilities()
{
set_specific();
return single_value->field_cC__Capabilities;
}

const CallControlCapabilities_template& PDU__ML3__StartCC_template::cC__Capabilities() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cC_Capabilities of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
return single_value->field_cC__Capabilities;
}

int PDU__ML3__StartCC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_cC__Capabilities.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartCC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
  }
  return 0;
}

void PDU__ML3__StartCC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", cC_Capabilities := ");
single_value->field_cC__Capabilities.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StartCC_template::log_match(const PDU__ML3__StartCC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.cC__Capabilities().ispresent()){
if(!single_value->field_cC__Capabilities.match(match_value.cC__Capabilities(), legacy)){
TTCN_Logger::log_logmatch_info(".cC_Capabilities");
single_value->field_cC__Capabilities.log_match(match_value.cC__Capabilities(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cC__Capabilities.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cC_Capabilities := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cC__Capabilities.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", cC_Capabilities := ");
if (match_value.cC__Capabilities().ispresent()) {
single_value->field_cC__Capabilities.log_match(match_value.cC__Capabilities(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cC__Capabilities.log();
if (single_value->field_cC__Capabilities.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StartCC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!cC__Capabilities().is_bound()) cC__Capabilities() = OMIT_VALUE;
else cC__Capabilities().set_implicit_omit();
}

void PDU__ML3__StartCC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_cC__Capabilities.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
}
}

void PDU__ML3__StartCC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_cC__Capabilities.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StartCC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StartCC.");
}
}

void PDU__ML3__StartCC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StartCC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StartCC has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cC__Capabilities().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cC_Capabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cC__Capabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartCC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StartCC_template* precondition = new PDU__ML3__StartCC_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StartCC_template* implied_template = new PDU__ML3__StartCC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StartCC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StartCC");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StartCC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartCC");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartCC");
single_value->field_cC__Capabilities.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartCC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartCC");
}

boolean PDU__ML3__StartCC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StartCC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StartDTMF::PDU__ML3__StartDTMF()
{
}

PDU__ML3__StartDTMF::PDU__ML3__StartDTMF(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const KeypadFacility& par_keypadFacility)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_keypadFacility(par_keypadFacility)
{
}

PDU__ML3__StartDTMF::PDU__ML3__StartDTMF(const PDU__ML3__StartDTMF& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.keypadFacility().is_bound()) field_keypadFacility = other_value.keypadFacility();
else field_keypadFacility.clean_up();
}

void PDU__ML3__StartDTMF::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_keypadFacility.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StartDTMF::get_descriptor() const { return &PDU__ML3__StartDTMF_descr_; }
PDU__ML3__StartDTMF& PDU__ML3__StartDTMF::operator=(const PDU__ML3__StartDTMF& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.keypadFacility().is_bound()) field_keypadFacility = other_value.keypadFacility();
  else field_keypadFacility.clean_up();
}
return *this;
}

boolean PDU__ML3__StartDTMF::operator==(const PDU__ML3__StartDTMF& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_keypadFacility==other_value.field_keypadFacility;
}

boolean PDU__ML3__StartDTMF::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_keypadFacility.is_bound());
}
boolean PDU__ML3__StartDTMF::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_keypadFacility.is_value();
}
void PDU__ML3__StartDTMF::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", keypadFacility := ");
field_keypadFacility.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StartDTMF::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (keypadFacility().is_bound()) keypadFacility().set_implicit_omit();
}

void PDU__ML3__StartDTMF::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StartDTMF has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) keypadFacility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "keypadFacility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          keypadFacility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMF: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
  }
}

void PDU__ML3__StartDTMF::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_keypadFacility.encode_text(text_buf);
}

void PDU__ML3__StartDTMF::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_keypadFacility.decode_text(text_buf);
}

void PDU__ML3__StartDTMF::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StartDTMF::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StartDTMF::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, KeypadFacility_descr_.raw->forceomit);
  decoded_field_length = field_keypadFacility.RAW_decode(KeypadFacility_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StartDTMF::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, KeypadFacility_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_keypadFacility.RAW_encode(KeypadFacility_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StartDTMF_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
KeypadFacility_template field_keypadFacility;
};

void PDU__ML3__StartDTMF_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_keypadFacility = ANY_VALUE;
}
}
}

void PDU__ML3__StartDTMF_template::copy_value(const PDU__ML3__StartDTMF& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.keypadFacility().is_bound()) {
  single_value->field_keypadFacility = other_value.keypadFacility();
} else {
  single_value->field_keypadFacility.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StartDTMF_template::copy_template(const PDU__ML3__StartDTMF_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.keypadFacility().get_selection()) {
single_value->field_keypadFacility = other_value.keypadFacility();
} else {
single_value->field_keypadFacility.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StartDTMF_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StartDTMF_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StartDTMF_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
break;
}
set_selection(other_value);
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template()
{
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(const PDU__ML3__StartDTMF& other_value)
{
copy_value(other_value);
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(const OPTIONAL<PDU__ML3__StartDTMF>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMF&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF from an unbound optional field.");
}
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(PDU__ML3__StartDTMF_template* p_precondition, PDU__ML3__StartDTMF_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(Dynamic_Match_Interface<PDU__ML3__StartDTMF>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StartDTMF>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StartDTMF_template::PDU__ML3__StartDTMF_template(const PDU__ML3__StartDTMF_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StartDTMF_template::~PDU__ML3__StartDTMF_template()
{
clean_up();
}

PDU__ML3__StartDTMF_template& PDU__ML3__StartDTMF_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StartDTMF_template& PDU__ML3__StartDTMF_template::operator=(const PDU__ML3__StartDTMF& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StartDTMF_template& PDU__ML3__StartDTMF_template::operator=(const OPTIONAL<PDU__ML3__StartDTMF>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMF&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
}
return *this;
}

PDU__ML3__StartDTMF_template& PDU__ML3__StartDTMF_template::operator=(const PDU__ML3__StartDTMF_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StartDTMF_template::match(const PDU__ML3__StartDTMF& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.keypadFacility().is_bound()) return FALSE;
if(!single_value->field_keypadFacility.match(other_value.keypadFacility(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
}
return FALSE;
}

boolean PDU__ML3__StartDTMF_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_keypadFacility.is_bound();
}

boolean PDU__ML3__StartDTMF_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_keypadFacility.is_value();
}

void PDU__ML3__StartDTMF_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StartDTMF PDU__ML3__StartDTMF_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
PDU__ML3__StartDTMF ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_keypadFacility.is_bound()) {
ret_val.keypadFacility() = single_value->field_keypadFacility.valueof();
}
return ret_val;
}

void PDU__ML3__StartDTMF_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StartDTMF_template[list_length];
}

PDU__ML3__StartDTMF_template& PDU__ML3__StartDTMF_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StartDTMF_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StartDTMF_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StartDTMF_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StartDTMF_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
return single_value->field_nsd;
}

KeypadFacility_template& PDU__ML3__StartDTMF_template::keypadFacility()
{
set_specific();
return single_value->field_keypadFacility;
}

const KeypadFacility_template& PDU__ML3__StartDTMF_template::keypadFacility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field keypadFacility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
return single_value->field_keypadFacility;
}

int PDU__ML3__StartDTMF_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
  }
  return 0;
}

void PDU__ML3__StartDTMF_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", keypadFacility := ");
single_value->field_keypadFacility.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StartDTMF_template::log_match(const PDU__ML3__StartDTMF& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_keypadFacility.match(match_value.keypadFacility(), legacy)){
TTCN_Logger::log_logmatch_info(".keypadFacility");
single_value->field_keypadFacility.log_match(match_value.keypadFacility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", keypadFacility := ");
single_value->field_keypadFacility.log_match(match_value.keypadFacility(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StartDTMF_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (keypadFacility().is_bound()) keypadFacility().set_implicit_omit();
}

void PDU__ML3__StartDTMF_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_keypadFacility.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
}
}

void PDU__ML3__StartDTMF_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_keypadFacility.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StartDTMF_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF.");
}
}

void PDU__ML3__StartDTMF_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StartDTMF_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StartDTMF has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) keypadFacility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "keypadFacility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          keypadFacility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMF: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StartDTMF_template* precondition = new PDU__ML3__StartDTMF_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StartDTMF_template* implied_template = new PDU__ML3__StartDTMF_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StartDTMF_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StartDTMF_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
single_value->field_keypadFacility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMF");
}

boolean PDU__ML3__StartDTMF_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StartDTMF_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StartDTMFAck::PDU__ML3__StartDTMFAck()
{
}

PDU__ML3__StartDTMFAck::PDU__ML3__StartDTMFAck(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const KeypadFacility& par_keypadFacility)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_keypadFacility(par_keypadFacility)
{
}

PDU__ML3__StartDTMFAck::PDU__ML3__StartDTMFAck(const PDU__ML3__StartDTMFAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.keypadFacility().is_bound()) field_keypadFacility = other_value.keypadFacility();
else field_keypadFacility.clean_up();
}

void PDU__ML3__StartDTMFAck::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_keypadFacility.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StartDTMFAck::get_descriptor() const { return &PDU__ML3__StartDTMFAck_descr_; }
PDU__ML3__StartDTMFAck& PDU__ML3__StartDTMFAck::operator=(const PDU__ML3__StartDTMFAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.keypadFacility().is_bound()) field_keypadFacility = other_value.keypadFacility();
  else field_keypadFacility.clean_up();
}
return *this;
}

boolean PDU__ML3__StartDTMFAck::operator==(const PDU__ML3__StartDTMFAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_keypadFacility==other_value.field_keypadFacility;
}

boolean PDU__ML3__StartDTMFAck::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_keypadFacility.is_bound());
}
boolean PDU__ML3__StartDTMFAck::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_keypadFacility.is_value();
}
void PDU__ML3__StartDTMFAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", keypadFacility := ");
field_keypadFacility.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StartDTMFAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (keypadFacility().is_bound()) keypadFacility().set_implicit_omit();
}

void PDU__ML3__StartDTMFAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) keypadFacility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "keypadFacility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          keypadFacility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
  }
}

void PDU__ML3__StartDTMFAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_keypadFacility.encode_text(text_buf);
}

void PDU__ML3__StartDTMFAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_keypadFacility.decode_text(text_buf);
}

void PDU__ML3__StartDTMFAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StartDTMFAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StartDTMFAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, KeypadFacility_descr_.raw->forceomit);
  decoded_field_length = field_keypadFacility.RAW_decode(KeypadFacility_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StartDTMFAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, KeypadFacility_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_keypadFacility.RAW_encode(KeypadFacility_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StartDTMFAck_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
KeypadFacility_template field_keypadFacility;
};

void PDU__ML3__StartDTMFAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_keypadFacility = ANY_VALUE;
}
}
}

void PDU__ML3__StartDTMFAck_template::copy_value(const PDU__ML3__StartDTMFAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.keypadFacility().is_bound()) {
  single_value->field_keypadFacility = other_value.keypadFacility();
} else {
  single_value->field_keypadFacility.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StartDTMFAck_template::copy_template(const PDU__ML3__StartDTMFAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.keypadFacility().get_selection()) {
single_value->field_keypadFacility = other_value.keypadFacility();
} else {
single_value->field_keypadFacility.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StartDTMFAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StartDTMFAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StartDTMFAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
break;
}
set_selection(other_value);
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template()
{
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(const PDU__ML3__StartDTMFAck& other_value)
{
copy_value(other_value);
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(const OPTIONAL<PDU__ML3__StartDTMFAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMFAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck from an unbound optional field.");
}
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(PDU__ML3__StartDTMFAck_template* p_precondition, PDU__ML3__StartDTMFAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(Dynamic_Match_Interface<PDU__ML3__StartDTMFAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StartDTMFAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StartDTMFAck_template::PDU__ML3__StartDTMFAck_template(const PDU__ML3__StartDTMFAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StartDTMFAck_template::~PDU__ML3__StartDTMFAck_template()
{
clean_up();
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__StartDTMFAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__StartDTMFAck_template::operator=(const PDU__ML3__StartDTMFAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__StartDTMFAck_template::operator=(const OPTIONAL<PDU__ML3__StartDTMFAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMFAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
}
return *this;
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__StartDTMFAck_template::operator=(const PDU__ML3__StartDTMFAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StartDTMFAck_template::match(const PDU__ML3__StartDTMFAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.keypadFacility().is_bound()) return FALSE;
if(!single_value->field_keypadFacility.match(other_value.keypadFacility(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
}
return FALSE;
}

boolean PDU__ML3__StartDTMFAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_keypadFacility.is_bound();
}

boolean PDU__ML3__StartDTMFAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_keypadFacility.is_value();
}

void PDU__ML3__StartDTMFAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StartDTMFAck PDU__ML3__StartDTMFAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
PDU__ML3__StartDTMFAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_keypadFacility.is_bound()) {
ret_val.keypadFacility() = single_value->field_keypadFacility.valueof();
}
return ret_val;
}

void PDU__ML3__StartDTMFAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StartDTMFAck_template[list_length];
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__StartDTMFAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StartDTMFAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StartDTMFAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StartDTMFAck_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StartDTMFAck_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
return single_value->field_nsd;
}

KeypadFacility_template& PDU__ML3__StartDTMFAck_template::keypadFacility()
{
set_specific();
return single_value->field_keypadFacility;
}

const KeypadFacility_template& PDU__ML3__StartDTMFAck_template::keypadFacility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field keypadFacility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
return single_value->field_keypadFacility;
}

int PDU__ML3__StartDTMFAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
  }
  return 0;
}

void PDU__ML3__StartDTMFAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", keypadFacility := ");
single_value->field_keypadFacility.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StartDTMFAck_template::log_match(const PDU__ML3__StartDTMFAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_keypadFacility.match(match_value.keypadFacility(), legacy)){
TTCN_Logger::log_logmatch_info(".keypadFacility");
single_value->field_keypadFacility.log_match(match_value.keypadFacility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", keypadFacility := ");
single_value->field_keypadFacility.log_match(match_value.keypadFacility(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StartDTMFAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (keypadFacility().is_bound()) keypadFacility().set_implicit_omit();
}

void PDU__ML3__StartDTMFAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_keypadFacility.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
}
}

void PDU__ML3__StartDTMFAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_keypadFacility.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StartDTMFAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck.");
}
}

void PDU__ML3__StartDTMFAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StartDTMFAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) keypadFacility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "keypadFacility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          keypadFacility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMFAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StartDTMFAck_template* precondition = new PDU__ML3__StartDTMFAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StartDTMFAck_template* implied_template = new PDU__ML3__StartDTMFAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StartDTMFAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StartDTMFAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
single_value->field_keypadFacility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFAck");
}

boolean PDU__ML3__StartDTMFAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StartDTMFAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StartDTMFRej::PDU__ML3__StartDTMFRej()
{
}

PDU__ML3__StartDTMFRej::PDU__ML3__StartDTMFRej(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::ML3__Cause__LV& par_cause)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_cause(par_cause)
{
}

PDU__ML3__StartDTMFRej::PDU__ML3__StartDTMFRej(const PDU__ML3__StartDTMFRej& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__ML3__StartDTMFRej::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StartDTMFRej::get_descriptor() const { return &PDU__ML3__StartDTMFRej_descr_; }
PDU__ML3__StartDTMFRej& PDU__ML3__StartDTMFRej::operator=(const PDU__ML3__StartDTMFRej& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__ML3__StartDTMFRej::operator==(const PDU__ML3__StartDTMFRej& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_cause==other_value.field_cause;
}

boolean PDU__ML3__StartDTMFRej::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_cause.is_bound());
}
boolean PDU__ML3__StartDTMFRej::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_cause.is_value();
}
void PDU__ML3__StartDTMFRej::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StartDTMFRej::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__ML3__StartDTMFRej::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
  }
}

void PDU__ML3__StartDTMFRej::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__ML3__StartDTMFRej::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__ML3__StartDTMFRej::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StartDTMFRej::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StartDTMFRej::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::ML3__Cause__LV_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(MobileL3__CommonIE__Types::ML3__Cause__LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StartDTMFRej::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::ML3__Cause__LV_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_cause.RAW_encode(MobileL3__CommonIE__Types::ML3__Cause__LV_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StartDTMFRej_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::ML3__Cause__LV_template field_cause;
};

void PDU__ML3__StartDTMFRej_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
}
}
}

void PDU__ML3__StartDTMFRej_template::copy_value(const PDU__ML3__StartDTMFRej& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StartDTMFRej_template::copy_template(const PDU__ML3__StartDTMFRej_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StartDTMFRej_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StartDTMFRej_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StartDTMFRej_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
break;
}
set_selection(other_value);
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template()
{
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(const PDU__ML3__StartDTMFRej& other_value)
{
copy_value(other_value);
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(const OPTIONAL<PDU__ML3__StartDTMFRej>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMFRej&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej from an unbound optional field.");
}
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(PDU__ML3__StartDTMFRej_template* p_precondition, PDU__ML3__StartDTMFRej_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(Dynamic_Match_Interface<PDU__ML3__StartDTMFRej>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StartDTMFRej>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StartDTMFRej_template::PDU__ML3__StartDTMFRej_template(const PDU__ML3__StartDTMFRej_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StartDTMFRej_template::~PDU__ML3__StartDTMFRej_template()
{
clean_up();
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__StartDTMFRej_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__StartDTMFRej_template::operator=(const PDU__ML3__StartDTMFRej& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__StartDTMFRej_template::operator=(const OPTIONAL<PDU__ML3__StartDTMFRej>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StartDTMFRej&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
}
return *this;
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__StartDTMFRej_template::operator=(const PDU__ML3__StartDTMFRej_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StartDTMFRej_template::match(const PDU__ML3__StartDTMFRej& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
}
return FALSE;
}

boolean PDU__ML3__StartDTMFRej_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_cause.is_bound();
}

boolean PDU__ML3__StartDTMFRej_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_cause.is_value();
}

void PDU__ML3__StartDTMFRej_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StartDTMFRej PDU__ML3__StartDTMFRej_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
PDU__ML3__StartDTMFRej ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__ML3__StartDTMFRej_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StartDTMFRej_template[list_length];
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__StartDTMFRej_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StartDTMFRej_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StartDTMFRej_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StartDTMFRej_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StartDTMFRej_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::ML3__Cause__LV_template& PDU__ML3__StartDTMFRej_template::cause()
{
set_specific();
return single_value->field_cause;
}

const MobileL3__CommonIE__Types::ML3__Cause__LV_template& PDU__ML3__StartDTMFRej_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
return single_value->field_cause;
}

int PDU__ML3__StartDTMFRej_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
  }
  return 0;
}

void PDU__ML3__StartDTMFRej_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StartDTMFRej_template::log_match(const PDU__ML3__StartDTMFRej& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StartDTMFRej_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__ML3__StartDTMFRej_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
}
}

void PDU__ML3__StartDTMFRej_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StartDTMFRej_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej.");
}
}

void PDU__ML3__StartDTMFRej_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StartDTMFRej_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StartDTMFRej: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StartDTMFRej_template* precondition = new PDU__ML3__StartDTMFRej_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StartDTMFRej_template* implied_template = new PDU__ML3__StartDTMFRej_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StartDTMFRej_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StartDTMFRej_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StartDTMFRej");
}

boolean PDU__ML3__StartDTMFRej_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StartDTMFRej_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Status::PDU__ML3__Status()
{
}

PDU__ML3__Status::PDU__ML3__Status(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::ML3__Cause__LV& par_cause,
    const CallState__V& par_callState,
    const OPTIONAL< AuxiliaryStates__TLV >& par_auxiliaryStates)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_cause(par_cause),
  field_callState(par_callState),
  field_auxiliaryStates(par_auxiliaryStates)
{
}

PDU__ML3__Status::PDU__ML3__Status(const PDU__ML3__Status& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Status.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.callState().is_bound()) field_callState = other_value.callState();
else field_callState.clean_up();
if (other_value.auxiliaryStates().is_bound()) field_auxiliaryStates = other_value.auxiliaryStates();
else field_auxiliaryStates.clean_up();
}

void PDU__ML3__Status::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_cause.clean_up();
field_callState.clean_up();
field_auxiliaryStates.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Status::get_descriptor() const { return &PDU__ML3__Status_descr_; }
PDU__ML3__Status& PDU__ML3__Status::operator=(const PDU__ML3__Status& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Status.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.callState().is_bound()) field_callState = other_value.callState();
  else field_callState.clean_up();
  if (other_value.auxiliaryStates().is_bound()) field_auxiliaryStates = other_value.auxiliaryStates();
  else field_auxiliaryStates.clean_up();
}
return *this;
}

boolean PDU__ML3__Status::operator==(const PDU__ML3__Status& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_cause==other_value.field_cause
  && field_callState==other_value.field_callState
  && field_auxiliaryStates==other_value.field_auxiliaryStates;
}

boolean PDU__ML3__Status::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_cause.is_bound())
  || (field_callState.is_bound())
  || (OPTIONAL_OMIT == field_auxiliaryStates.get_selection() || field_auxiliaryStates.is_bound());
}
boolean PDU__ML3__Status::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_cause.is_value()
  && field_callState.is_value()
  && (OPTIONAL_OMIT == field_auxiliaryStates.get_selection() || field_auxiliaryStates.is_value());
}
int PDU__ML3__Status::size_of() const
{
  int ret_val = 4;
  if (field_auxiliaryStates.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__Status::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", callState := ");
field_callState.log();
TTCN_Logger::log_event_str(", auxiliaryStates := ");
field_auxiliaryStates.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__Status::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (callState().is_bound()) callState().set_implicit_omit();
if (!auxiliaryStates().is_bound()) auxiliaryStates() = OMIT_VALUE;
else auxiliaryStates().set_implicit_omit();
}

void PDU__ML3__Status::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_Status has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) callState().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) auxiliaryStates().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "auxiliaryStates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          auxiliaryStates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_Status");
  }
}

void PDU__ML3__Status::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_callState.encode_text(text_buf);
field_auxiliaryStates.encode_text(text_buf);
}

void PDU__ML3__Status::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_callState.decode_text(text_buf);
field_auxiliaryStates.decode_text(text_buf);
}

void PDU__ML3__Status::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__Status::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__Status::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::ML3__Cause__LV_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(MobileL3__CommonIE__Types::ML3__Cause__LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, CallState__V_descr_.raw->forceomit);
  decoded_field_length = field_callState.RAW_decode(CallState__V_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_auxiliaryStates = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, AuxiliaryStates__TLV_descr_.raw->forceomit);
  decoded_field_length = field_auxiliaryStates().RAW_decode(AuxiliaryStates__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_auxiliaryStates = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_auxiliaryStates.ispresent() || field_auxiliaryStates().elementIdentifier() !=  os_31){
  field_auxiliaryStates=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_auxiliaryStates=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__Status::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::ML3__Cause__LV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, CallState__V_descr_.raw);
  if (field_auxiliaryStates.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, AuxiliaryStates__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_cause.RAW_encode(MobileL3__CommonIE__Types::ML3__Cause__LV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_callState.RAW_encode(CallState__V_descr_, *myleaf.body.node.nodes[3]);
  if (field_auxiliaryStates.ispresent()) {
  encoded_length += field_auxiliaryStates().RAW_encode(AuxiliaryStates__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_auxiliaryStates.ispresent() && (!field_auxiliaryStates.ispresent() || field_auxiliaryStates().elementIdentifier() !=  os_31)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_31.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__Status_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::ML3__Cause__LV_template field_cause;
CallState__V_template field_callState;
AuxiliaryStates__TLV_template field_auxiliaryStates;
};

void PDU__ML3__Status_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_callState = ANY_VALUE;
single_value->field_auxiliaryStates = ANY_OR_OMIT;
}
}
}

void PDU__ML3__Status_template::copy_value(const PDU__ML3__Status& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.callState().is_bound()) {
  single_value->field_callState = other_value.callState();
} else {
  single_value->field_callState.clean_up();
}
if (other_value.auxiliaryStates().is_bound()) {
  if (other_value.auxiliaryStates().ispresent()) single_value->field_auxiliaryStates = other_value.auxiliaryStates()();
  else single_value->field_auxiliaryStates = OMIT_VALUE;
} else {
  single_value->field_auxiliaryStates.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__Status_template::copy_template(const PDU__ML3__Status_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callState().get_selection()) {
single_value->field_callState = other_value.callState();
} else {
single_value->field_callState.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.auxiliaryStates().get_selection()) {
single_value->field_auxiliaryStates = other_value.auxiliaryStates();
} else {
single_value->field_auxiliaryStates.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__Status_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__Status_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Status.");
break;
}
set_selection(other_value);
}

PDU__ML3__Status_template::PDU__ML3__Status_template()
{
}

PDU__ML3__Status_template::PDU__ML3__Status_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__Status_template::PDU__ML3__Status_template(const PDU__ML3__Status& other_value)
{
copy_value(other_value);
}

PDU__ML3__Status_template::PDU__ML3__Status_template(const OPTIONAL<PDU__ML3__Status>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_Status from an unbound optional field.");
}
}

PDU__ML3__Status_template::PDU__ML3__Status_template(PDU__ML3__Status_template* p_precondition, PDU__ML3__Status_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__Status_template::PDU__ML3__Status_template(Dynamic_Match_Interface<PDU__ML3__Status>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__Status>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__Status_template::PDU__ML3__Status_template(const PDU__ML3__Status_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__Status_template::~PDU__ML3__Status_template()
{
clean_up();
}

PDU__ML3__Status_template& PDU__ML3__Status_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__Status_template& PDU__ML3__Status_template::operator=(const PDU__ML3__Status& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__Status_template& PDU__ML3__Status_template::operator=(const OPTIONAL<PDU__ML3__Status>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_Status.");
}
return *this;
}

PDU__ML3__Status_template& PDU__ML3__Status_template::operator=(const PDU__ML3__Status_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__Status_template::match(const PDU__ML3__Status& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.callState().is_bound()) return FALSE;
if(!single_value->field_callState.match(other_value.callState(), legacy))return FALSE;
if(!other_value.auxiliaryStates().is_bound()) return FALSE;
if((other_value.auxiliaryStates().ispresent() ? !single_value->field_auxiliaryStates.match((const AuxiliaryStates__TLV&)other_value.auxiliaryStates(), legacy) : !single_value->field_auxiliaryStates.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Status.");
}
return FALSE;
}

boolean PDU__ML3__Status_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_cause.is_bound()
 || single_value->field_callState.is_bound()
 || (single_value->field_auxiliaryStates.is_omit() || single_value->field_auxiliaryStates.is_bound());
}

boolean PDU__ML3__Status_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_cause.is_value()
 && single_value->field_callState.is_value()
 && (single_value->field_auxiliaryStates.is_omit() || single_value->field_auxiliaryStates.is_value());
}

void PDU__ML3__Status_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__Status PDU__ML3__Status_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
PDU__ML3__Status ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_callState.is_bound()) {
ret_val.callState() = single_value->field_callState.valueof();
}
if (single_value->field_auxiliaryStates.is_omit()) ret_val.auxiliaryStates() = OMIT_VALUE;
else if (single_value->field_auxiliaryStates.is_bound()) {
ret_val.auxiliaryStates() = single_value->field_auxiliaryStates.valueof();
}
return ret_val;
}

void PDU__ML3__Status_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_Status.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__Status_template[list_length];
}

PDU__ML3__Status_template& PDU__ML3__Status_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_Status.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__Status_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__Status_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__Status_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__Status_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::ML3__Cause__LV_template& PDU__ML3__Status_template::cause()
{
set_specific();
return single_value->field_cause;
}

const MobileL3__CommonIE__Types::ML3__Cause__LV_template& PDU__ML3__Status_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return single_value->field_cause;
}

CallState__V_template& PDU__ML3__Status_template::callState()
{
set_specific();
return single_value->field_callState;
}

const CallState__V_template& PDU__ML3__Status_template::callState() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callState of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return single_value->field_callState;
}

AuxiliaryStates__TLV_template& PDU__ML3__Status_template::auxiliaryStates()
{
set_specific();
return single_value->field_auxiliaryStates;
}

const AuxiliaryStates__TLV_template& PDU__ML3__Status_template::auxiliaryStates() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field auxiliaryStates of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Status.");
return single_value->field_auxiliaryStates;
}

int PDU__ML3__Status_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_auxiliaryStates.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Status containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Status.");
  }
  return 0;
}

void PDU__ML3__Status_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", callState := ");
single_value->field_callState.log();
TTCN_Logger::log_event_str(", auxiliaryStates := ");
single_value->field_auxiliaryStates.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__Status_template::log_match(const PDU__ML3__Status& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_callState.match(match_value.callState(), legacy)){
TTCN_Logger::log_logmatch_info(".callState");
single_value->field_callState.log_match(match_value.callState(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.auxiliaryStates().ispresent()){
if(!single_value->field_auxiliaryStates.match(match_value.auxiliaryStates(), legacy)){
TTCN_Logger::log_logmatch_info(".auxiliaryStates");
single_value->field_auxiliaryStates.log_match(match_value.auxiliaryStates(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_auxiliaryStates.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".auxiliaryStates := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_auxiliaryStates.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", callState := ");
single_value->field_callState.log_match(match_value.callState(), legacy);
TTCN_Logger::log_event_str(", auxiliaryStates := ");
if (match_value.auxiliaryStates().ispresent()) {
single_value->field_auxiliaryStates.log_match(match_value.auxiliaryStates(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_auxiliaryStates.log();
if (single_value->field_auxiliaryStates.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__Status_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (callState().is_bound()) callState().set_implicit_omit();
if (!auxiliaryStates().is_bound()) auxiliaryStates() = OMIT_VALUE;
else auxiliaryStates().set_implicit_omit();
}

void PDU__ML3__Status_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_callState.encode_text(text_buf);
single_value->field_auxiliaryStates.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Status.");
}
}

void PDU__ML3__Status_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_callState.decode_text(text_buf);
single_value->field_auxiliaryStates.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_Status.");
}
}

void PDU__ML3__Status_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__Status_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_Status has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) callState().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) auxiliaryStates().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "auxiliaryStates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          auxiliaryStates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__Status_template* precondition = new PDU__ML3__Status_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__Status_template* implied_template = new PDU__ML3__Status_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__Status_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_Status");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__Status_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
single_value->field_callState.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
single_value->field_auxiliaryStates.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Status");
}

boolean PDU__ML3__Status_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__Status_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StatusEnquiry::PDU__ML3__StatusEnquiry()
{
}

PDU__ML3__StatusEnquiry::PDU__ML3__StatusEnquiry(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd)
{
}

PDU__ML3__StatusEnquiry::PDU__ML3__StatusEnquiry(const PDU__ML3__StatusEnquiry& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
}

void PDU__ML3__StatusEnquiry::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StatusEnquiry::get_descriptor() const { return &PDU__ML3__StatusEnquiry_descr_; }
PDU__ML3__StatusEnquiry& PDU__ML3__StatusEnquiry::operator=(const PDU__ML3__StatusEnquiry& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
}
return *this;
}

boolean PDU__ML3__StatusEnquiry::operator==(const PDU__ML3__StatusEnquiry& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd;
}

boolean PDU__ML3__StatusEnquiry::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound());
}
boolean PDU__ML3__StatusEnquiry::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value();
}
void PDU__ML3__StatusEnquiry::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StatusEnquiry::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StatusEnquiry::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StatusEnquiry");
  }
}

void PDU__ML3__StatusEnquiry::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
}

void PDU__ML3__StatusEnquiry::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
}

void PDU__ML3__StatusEnquiry::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StatusEnquiry::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StatusEnquiry::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StatusEnquiry::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StatusEnquiry_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
};

void PDU__ML3__StatusEnquiry_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
}
}
}

void PDU__ML3__StatusEnquiry_template::copy_value(const PDU__ML3__StatusEnquiry& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StatusEnquiry_template::copy_template(const PDU__ML3__StatusEnquiry_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StatusEnquiry_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StatusEnquiry_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StatusEnquiry_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
break;
}
set_selection(other_value);
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template()
{
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(const PDU__ML3__StatusEnquiry& other_value)
{
copy_value(other_value);
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(const OPTIONAL<PDU__ML3__StatusEnquiry>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StatusEnquiry&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry from an unbound optional field.");
}
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(PDU__ML3__StatusEnquiry_template* p_precondition, PDU__ML3__StatusEnquiry_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(Dynamic_Match_Interface<PDU__ML3__StatusEnquiry>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StatusEnquiry>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StatusEnquiry_template::PDU__ML3__StatusEnquiry_template(const PDU__ML3__StatusEnquiry_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StatusEnquiry_template::~PDU__ML3__StatusEnquiry_template()
{
clean_up();
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__StatusEnquiry_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__StatusEnquiry_template::operator=(const PDU__ML3__StatusEnquiry& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__StatusEnquiry_template::operator=(const OPTIONAL<PDU__ML3__StatusEnquiry>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StatusEnquiry&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
}
return *this;
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__StatusEnquiry_template::operator=(const PDU__ML3__StatusEnquiry_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StatusEnquiry_template::match(const PDU__ML3__StatusEnquiry& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
}
return FALSE;
}

boolean PDU__ML3__StatusEnquiry_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound();
}

boolean PDU__ML3__StatusEnquiry_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value();
}

void PDU__ML3__StatusEnquiry_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StatusEnquiry PDU__ML3__StatusEnquiry_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
PDU__ML3__StatusEnquiry ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
return ret_val;
}

void PDU__ML3__StatusEnquiry_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StatusEnquiry_template[list_length];
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__StatusEnquiry_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StatusEnquiry_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StatusEnquiry_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StatusEnquiry_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StatusEnquiry_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
return single_value->field_nsd;
}

int PDU__ML3__StatusEnquiry_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
  }
  return 0;
}

void PDU__ML3__StatusEnquiry_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StatusEnquiry_template::log_match(const PDU__ML3__StatusEnquiry& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StatusEnquiry_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StatusEnquiry_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
}
}

void PDU__ML3__StatusEnquiry_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StatusEnquiry_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry.");
}
}

void PDU__ML3__StatusEnquiry_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StatusEnquiry_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StatusEnquiry: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StatusEnquiry_template* precondition = new PDU__ML3__StatusEnquiry_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StatusEnquiry_template* implied_template = new PDU__ML3__StatusEnquiry_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StatusEnquiry_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StatusEnquiry");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StatusEnquiry_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StatusEnquiry");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StatusEnquiry");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StatusEnquiry");
}

boolean PDU__ML3__StatusEnquiry_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StatusEnquiry_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StopDTMF::PDU__ML3__StopDTMF()
{
}

PDU__ML3__StopDTMF::PDU__ML3__StopDTMF(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd)
{
}

PDU__ML3__StopDTMF::PDU__ML3__StopDTMF(const PDU__ML3__StopDTMF& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
}

void PDU__ML3__StopDTMF::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StopDTMF::get_descriptor() const { return &PDU__ML3__StopDTMF_descr_; }
PDU__ML3__StopDTMF& PDU__ML3__StopDTMF::operator=(const PDU__ML3__StopDTMF& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
}
return *this;
}

boolean PDU__ML3__StopDTMF::operator==(const PDU__ML3__StopDTMF& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd;
}

boolean PDU__ML3__StopDTMF::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound());
}
boolean PDU__ML3__StopDTMF::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value();
}
void PDU__ML3__StopDTMF::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StopDTMF::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StopDTMF::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StopDTMF has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StopDTMF: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StopDTMF");
  }
}

void PDU__ML3__StopDTMF::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
}

void PDU__ML3__StopDTMF::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
}

void PDU__ML3__StopDTMF::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StopDTMF::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StopDTMF::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StopDTMF::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StopDTMF_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
};

void PDU__ML3__StopDTMF_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
}
}
}

void PDU__ML3__StopDTMF_template::copy_value(const PDU__ML3__StopDTMF& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StopDTMF_template::copy_template(const PDU__ML3__StopDTMF_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StopDTMF_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StopDTMF_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StopDTMF_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
break;
}
set_selection(other_value);
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template()
{
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(const PDU__ML3__StopDTMF& other_value)
{
copy_value(other_value);
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(const OPTIONAL<PDU__ML3__StopDTMF>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StopDTMF&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF from an unbound optional field.");
}
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(PDU__ML3__StopDTMF_template* p_precondition, PDU__ML3__StopDTMF_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(Dynamic_Match_Interface<PDU__ML3__StopDTMF>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StopDTMF>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StopDTMF_template::PDU__ML3__StopDTMF_template(const PDU__ML3__StopDTMF_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StopDTMF_template::~PDU__ML3__StopDTMF_template()
{
clean_up();
}

PDU__ML3__StopDTMF_template& PDU__ML3__StopDTMF_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StopDTMF_template& PDU__ML3__StopDTMF_template::operator=(const PDU__ML3__StopDTMF& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StopDTMF_template& PDU__ML3__StopDTMF_template::operator=(const OPTIONAL<PDU__ML3__StopDTMF>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StopDTMF&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
}
return *this;
}

PDU__ML3__StopDTMF_template& PDU__ML3__StopDTMF_template::operator=(const PDU__ML3__StopDTMF_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StopDTMF_template::match(const PDU__ML3__StopDTMF& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
}
return FALSE;
}

boolean PDU__ML3__StopDTMF_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound();
}

boolean PDU__ML3__StopDTMF_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value();
}

void PDU__ML3__StopDTMF_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StopDTMF PDU__ML3__StopDTMF_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
PDU__ML3__StopDTMF ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
return ret_val;
}

void PDU__ML3__StopDTMF_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StopDTMF_template[list_length];
}

PDU__ML3__StopDTMF_template& PDU__ML3__StopDTMF_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StopDTMF_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StopDTMF_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StopDTMF_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StopDTMF_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
return single_value->field_nsd;
}

int PDU__ML3__StopDTMF_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
  }
  return 0;
}

void PDU__ML3__StopDTMF_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StopDTMF_template::log_match(const PDU__ML3__StopDTMF& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StopDTMF_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StopDTMF_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
}
}

void PDU__ML3__StopDTMF_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StopDTMF_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF.");
}
}

void PDU__ML3__StopDTMF_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StopDTMF_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StopDTMF has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StopDTMF: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StopDTMF_template* precondition = new PDU__ML3__StopDTMF_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StopDTMF_template* implied_template = new PDU__ML3__StopDTMF_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StopDTMF_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StopDTMF");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StopDTMF_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMF");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMF");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMF");
}

boolean PDU__ML3__StopDTMF_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StopDTMF_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__StopDTMFAck::PDU__ML3__StopDTMFAck()
{
}

PDU__ML3__StopDTMFAck::PDU__ML3__StopDTMFAck(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd)
{
}

PDU__ML3__StopDTMFAck::PDU__ML3__StopDTMFAck(const PDU__ML3__StopDTMFAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
}

void PDU__ML3__StopDTMFAck::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__StopDTMFAck::get_descriptor() const { return &PDU__ML3__StopDTMFAck_descr_; }
PDU__ML3__StopDTMFAck& PDU__ML3__StopDTMFAck::operator=(const PDU__ML3__StopDTMFAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
}
return *this;
}

boolean PDU__ML3__StopDTMFAck::operator==(const PDU__ML3__StopDTMFAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd;
}

boolean PDU__ML3__StopDTMFAck::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound());
}
boolean PDU__ML3__StopDTMFAck::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value();
}
void PDU__ML3__StopDTMFAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__StopDTMFAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StopDTMFAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_StopDTMFAck");
  }
}

void PDU__ML3__StopDTMFAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
}

void PDU__ML3__StopDTMFAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
}

void PDU__ML3__StopDTMFAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__StopDTMFAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__StopDTMFAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__StopDTMFAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__StopDTMFAck_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
};

void PDU__ML3__StopDTMFAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
}
}
}

void PDU__ML3__StopDTMFAck_template::copy_value(const PDU__ML3__StopDTMFAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__StopDTMFAck_template::copy_template(const PDU__ML3__StopDTMFAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__StopDTMFAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__StopDTMFAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__StopDTMFAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
break;
}
set_selection(other_value);
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template()
{
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(const PDU__ML3__StopDTMFAck& other_value)
{
copy_value(other_value);
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(const OPTIONAL<PDU__ML3__StopDTMFAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StopDTMFAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck from an unbound optional field.");
}
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(PDU__ML3__StopDTMFAck_template* p_precondition, PDU__ML3__StopDTMFAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(Dynamic_Match_Interface<PDU__ML3__StopDTMFAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__StopDTMFAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__StopDTMFAck_template::PDU__ML3__StopDTMFAck_template(const PDU__ML3__StopDTMFAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__StopDTMFAck_template::~PDU__ML3__StopDTMFAck_template()
{
clean_up();
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__StopDTMFAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__StopDTMFAck_template::operator=(const PDU__ML3__StopDTMFAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__StopDTMFAck_template::operator=(const OPTIONAL<PDU__ML3__StopDTMFAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__StopDTMFAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
}
return *this;
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__StopDTMFAck_template::operator=(const PDU__ML3__StopDTMFAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__StopDTMFAck_template::match(const PDU__ML3__StopDTMFAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
}
return FALSE;
}

boolean PDU__ML3__StopDTMFAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound();
}

boolean PDU__ML3__StopDTMFAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value();
}

void PDU__ML3__StopDTMFAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__StopDTMFAck PDU__ML3__StopDTMFAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
PDU__ML3__StopDTMFAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
return ret_val;
}

void PDU__ML3__StopDTMFAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__StopDTMFAck_template[list_length];
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__StopDTMFAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__StopDTMFAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__StopDTMFAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__StopDTMFAck_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__StopDTMFAck_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
return single_value->field_nsd;
}

int PDU__ML3__StopDTMFAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
  }
  return 0;
}

void PDU__ML3__StopDTMFAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__StopDTMFAck_template::log_match(const PDU__ML3__StopDTMFAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__StopDTMFAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__StopDTMFAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
}
}

void PDU__ML3__StopDTMFAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__StopDTMFAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck.");
}
}

void PDU__ML3__StopDTMFAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__StopDTMFAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_StopDTMFAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__StopDTMFAck_template* precondition = new PDU__ML3__StopDTMFAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__StopDTMFAck_template* implied_template = new PDU__ML3__StopDTMFAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__StopDTMFAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_StopDTMFAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__StopDTMFAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMFAck");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMFAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_StopDTMFAck");
}

boolean PDU__ML3__StopDTMFAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__StopDTMFAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__UserInformation::PDU__ML3__UserInformation()
{
}

PDU__ML3__UserInformation::PDU__ML3__UserInformation(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const User__user__LV& par_user__user,
    const OPTIONAL< OCTETSTRING >& par_moreData)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_user__user(par_user__user),
  field_moreData(par_moreData)
{
}

PDU__ML3__UserInformation::PDU__ML3__UserInformation(const PDU__ML3__UserInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
if (other_value.moreData().is_bound()) field_moreData = other_value.moreData();
else field_moreData.clean_up();
}

void PDU__ML3__UserInformation::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_user__user.clean_up();
field_moreData.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__UserInformation::get_descriptor() const { return &PDU__ML3__UserInformation_descr_; }
PDU__ML3__UserInformation& PDU__ML3__UserInformation::operator=(const PDU__ML3__UserInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
  if (other_value.moreData().is_bound()) field_moreData = other_value.moreData();
  else field_moreData.clean_up();
}
return *this;
}

boolean PDU__ML3__UserInformation::operator==(const PDU__ML3__UserInformation& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_user__user==other_value.field_user__user
  && field_moreData==other_value.field_moreData;
}

boolean PDU__ML3__UserInformation::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_user__user.is_bound())
  || (OPTIONAL_OMIT == field_moreData.get_selection() || field_moreData.is_bound());
}
boolean PDU__ML3__UserInformation::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_user__user.is_value()
  && (OPTIONAL_OMIT == field_moreData.get_selection() || field_moreData.is_value());
}
int PDU__ML3__UserInformation::size_of() const
{
  int ret_val = 3;
  if (field_moreData.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__UserInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", user_user := ");
field_user__user.log();
TTCN_Logger::log_event_str(", moreData := ");
field_moreData.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__UserInformation::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (user__user().is_bound()) user__user().set_implicit_omit();
if (!moreData().is_bound()) moreData() = OMIT_VALUE;
else moreData().set_implicit_omit();
}

void PDU__ML3__UserInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_UserInformation has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) moreData().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "moreData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          moreData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_UserInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_UserInformation");
  }
}

void PDU__ML3__UserInformation::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_user__user.encode_text(text_buf);
field_moreData.encode_text(text_buf);
}

void PDU__ML3__UserInformation::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_user__user.decode_text(text_buf);
field_moreData.decode_text(text_buf);
}

void PDU__ML3__UserInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__UserInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__UserInformation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, User__user__LV_descr_.raw->forceomit);
  decoded_field_length = field_user__user.RAW_decode(User__user__LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_moreData = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_moreData().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_moreData = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_moreData=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__UserInformation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, User__user__LV_descr_.raw);
  if (field_moreData.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_user__user.RAW_encode(User__user__LV_descr_, *myleaf.body.node.nodes[2]);
  if (field_moreData.ispresent()) {
  encoded_length += field_moreData().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__UserInformation_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
User__user__LV_template field_user__user;
OCTETSTRING_template field_moreData;
};

void PDU__ML3__UserInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_user__user = ANY_VALUE;
single_value->field_moreData = ANY_OR_OMIT;
}
}
}

void PDU__ML3__UserInformation_template::copy_value(const PDU__ML3__UserInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.user__user().is_bound()) {
  single_value->field_user__user = other_value.user__user();
} else {
  single_value->field_user__user.clean_up();
}
if (other_value.moreData().is_bound()) {
  if (other_value.moreData().ispresent()) single_value->field_moreData = other_value.moreData()();
  else single_value->field_moreData = OMIT_VALUE;
} else {
  single_value->field_moreData.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__UserInformation_template::copy_template(const PDU__ML3__UserInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__user().get_selection()) {
single_value->field_user__user = other_value.user__user();
} else {
single_value->field_user__user.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.moreData().get_selection()) {
single_value->field_moreData = other_value.moreData();
} else {
single_value->field_moreData.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__UserInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__UserInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__UserInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
break;
}
set_selection(other_value);
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template()
{
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(const PDU__ML3__UserInformation& other_value)
{
copy_value(other_value);
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(const OPTIONAL<PDU__ML3__UserInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__UserInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation from an unbound optional field.");
}
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(PDU__ML3__UserInformation_template* p_precondition, PDU__ML3__UserInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(Dynamic_Match_Interface<PDU__ML3__UserInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__UserInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__UserInformation_template::PDU__ML3__UserInformation_template(const PDU__ML3__UserInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__UserInformation_template::~PDU__ML3__UserInformation_template()
{
clean_up();
}

PDU__ML3__UserInformation_template& PDU__ML3__UserInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__UserInformation_template& PDU__ML3__UserInformation_template::operator=(const PDU__ML3__UserInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__UserInformation_template& PDU__ML3__UserInformation_template::operator=(const OPTIONAL<PDU__ML3__UserInformation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__UserInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
}
return *this;
}

PDU__ML3__UserInformation_template& PDU__ML3__UserInformation_template::operator=(const PDU__ML3__UserInformation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__UserInformation_template::match(const PDU__ML3__UserInformation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.user__user().is_bound()) return FALSE;
if(!single_value->field_user__user.match(other_value.user__user(), legacy))return FALSE;
if(!other_value.moreData().is_bound()) return FALSE;
if((other_value.moreData().ispresent() ? !single_value->field_moreData.match((const OCTETSTRING&)other_value.moreData(), legacy) : !single_value->field_moreData.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
}
return FALSE;
}

boolean PDU__ML3__UserInformation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_user__user.is_bound()
 || (single_value->field_moreData.is_omit() || single_value->field_moreData.is_bound());
}

boolean PDU__ML3__UserInformation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_user__user.is_value()
 && (single_value->field_moreData.is_omit() || single_value->field_moreData.is_value());
}

void PDU__ML3__UserInformation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__UserInformation PDU__ML3__UserInformation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
PDU__ML3__UserInformation ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_user__user.is_bound()) {
ret_val.user__user() = single_value->field_user__user.valueof();
}
if (single_value->field_moreData.is_omit()) ret_val.moreData() = OMIT_VALUE;
else if (single_value->field_moreData.is_bound()) {
ret_val.moreData() = single_value->field_moreData.valueof();
}
return ret_val;
}

void PDU__ML3__UserInformation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__UserInformation_template[list_length];
}

PDU__ML3__UserInformation_template& PDU__ML3__UserInformation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__UserInformation_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__UserInformation_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__UserInformation_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__UserInformation_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
return single_value->field_nsd;
}

User__user__LV_template& PDU__ML3__UserInformation_template::user__user()
{
set_specific();
return single_value->field_user__user;
}

const User__user__LV_template& PDU__ML3__UserInformation_template::user__user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_user of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
return single_value->field_user__user;
}

OCTETSTRING_template& PDU__ML3__UserInformation_template::moreData()
{
set_specific();
return single_value->field_moreData;
}

const OCTETSTRING_template& PDU__ML3__UserInformation_template::moreData() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field moreData of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
return single_value->field_moreData;
}

int PDU__ML3__UserInformation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_moreData.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
  }
  return 0;
}

void PDU__ML3__UserInformation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log();
TTCN_Logger::log_event_str(", moreData := ");
single_value->field_moreData.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__UserInformation_template::log_match(const PDU__ML3__UserInformation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__user.match(match_value.user__user(), legacy)){
TTCN_Logger::log_logmatch_info(".user_user");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.moreData().ispresent()){
if(!single_value->field_moreData.match(match_value.moreData(), legacy)){
TTCN_Logger::log_logmatch_info(".moreData");
single_value->field_moreData.log_match(match_value.moreData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_moreData.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".moreData := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_moreData.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::log_event_str(", moreData := ");
if (match_value.moreData().ispresent()) {
single_value->field_moreData.log_match(match_value.moreData(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_moreData.log();
if (single_value->field_moreData.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__UserInformation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (user__user().is_bound()) user__user().set_implicit_omit();
if (!moreData().is_bound()) moreData() = OMIT_VALUE;
else moreData().set_implicit_omit();
}

void PDU__ML3__UserInformation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_user__user.encode_text(text_buf);
single_value->field_moreData.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
}
}

void PDU__ML3__UserInformation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_user__user.decode_text(text_buf);
single_value->field_moreData.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__UserInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_UserInformation.");
}
}

void PDU__ML3__UserInformation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__UserInformation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_UserInformation has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) moreData().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "moreData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          moreData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_UserInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__UserInformation_template* precondition = new PDU__ML3__UserInformation_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__UserInformation_template* implied_template = new PDU__ML3__UserInformation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__UserInformation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_UserInformation");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__UserInformation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_UserInformation");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_UserInformation");
single_value->field_user__user.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_UserInformation");
single_value->field_moreData.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_UserInformation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_UserInformation");
}

boolean PDU__ML3__UserInformation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__UserInformation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__CC__MS__NW::copy_value(const PDU__ML3__CC__MS__NW& other_value)
{
switch (other_value.union_selection) {
case ALT_alerting__MS__NW:
field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW(*other_value.field_alerting__MS__NW);
break;
case ALT_callConfirmed:
field_callConfirmed = new PDU__ML3__CallConfirmed(*other_value.field_callConfirmed);
break;
case ALT_connect__MS__NW:
field_connect__MS__NW = new PDU__ML3__Connect__MS__NW(*other_value.field_connect__MS__NW);
break;
case ALT_connectAck:
field_connectAck = new PDU__ML3__ConnectAck(*other_value.field_connectAck);
break;
case ALT_emergencySetup:
field_emergencySetup = new PDU__ML3__EmergencySetup(*other_value.field_emergencySetup);
break;
case ALT_cc__EstablishmentConf:
field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf(*other_value.field_cc__EstablishmentConf);
break;
case ALT_startCC:
field_startCC = new PDU__ML3__StartCC(*other_value.field_startCC);
break;
case ALT_setup__MS__NW:
field_setup__MS__NW = new PDU__ML3__Setup__MS__NW(*other_value.field_setup__MS__NW);
break;
case ALT_modify:
field_modify = new PDU__ML3__Modify(*other_value.field_modify);
break;
case ALT_modifyComplete:
field_modifyComplete = new PDU__ML3__ModifyComplete(*other_value.field_modifyComplete);
break;
case ALT_modifyReject:
field_modifyReject = new PDU__ML3__ModifyReject(*other_value.field_modifyReject);
break;
case ALT_userInformation:
field_userInformation = new PDU__ML3__UserInformation(*other_value.field_userInformation);
break;
case ALT_disconnect__MS__NW:
field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW(*other_value.field_disconnect__MS__NW);
break;
case ALT_release__MS__NW:
field_release__MS__NW = new PDU__ML3__Release__MS__NW(*other_value.field_release__MS__NW);
break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW(*other_value.field_releaseComplete__MS__NW);
break;
case ALT_facility:
field_facility = new PDU__ML3__Facility(*other_value.field_facility);
break;
case ALT_hold:
field_hold = new PDU__ML3__Hold(*other_value.field_hold);
break;
case ALT_retrieve:
field_retrieve = new PDU__ML3__Retrieve(*other_value.field_retrieve);
break;
case ALT_notify:
field_notify = new PDU__ML3__Notify(*other_value.field_notify);
break;
case ALT_startDTMF:
field_startDTMF = new PDU__ML3__StartDTMF(*other_value.field_startDTMF);
break;
case ALT_status:
field_status = new PDU__ML3__Status(*other_value.field_status);
break;
case ALT_statusEnquiry:
field_statusEnquiry = new PDU__ML3__StatusEnquiry(*other_value.field_statusEnquiry);
break;
case ALT_stopDTMF:
field_stopDTMF = new PDU__ML3__StopDTMF(*other_value.field_stopDTMF);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
union_selection = other_value.union_selection;
}

PDU__ML3__CC__MS__NW::PDU__ML3__CC__MS__NW()
{
union_selection = UNBOUND_VALUE;
}

PDU__ML3__CC__MS__NW::PDU__ML3__CC__MS__NW(const PDU__ML3__CC__MS__NW& other_value)
: Base_Type(){
copy_value(other_value);
}

PDU__ML3__CC__MS__NW::~PDU__ML3__CC__MS__NW()
{
clean_up();
}

PDU__ML3__CC__MS__NW& PDU__ML3__CC__MS__NW::operator=(const PDU__ML3__CC__MS__NW& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PDU__ML3__CC__MS__NW::operator==(const PDU__ML3__CC__MS__NW& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_alerting__MS__NW:
return *field_alerting__MS__NW == *other_value.field_alerting__MS__NW;
case ALT_callConfirmed:
return *field_callConfirmed == *other_value.field_callConfirmed;
case ALT_connect__MS__NW:
return *field_connect__MS__NW == *other_value.field_connect__MS__NW;
case ALT_connectAck:
return *field_connectAck == *other_value.field_connectAck;
case ALT_emergencySetup:
return *field_emergencySetup == *other_value.field_emergencySetup;
case ALT_cc__EstablishmentConf:
return *field_cc__EstablishmentConf == *other_value.field_cc__EstablishmentConf;
case ALT_startCC:
return *field_startCC == *other_value.field_startCC;
case ALT_setup__MS__NW:
return *field_setup__MS__NW == *other_value.field_setup__MS__NW;
case ALT_modify:
return *field_modify == *other_value.field_modify;
case ALT_modifyComplete:
return *field_modifyComplete == *other_value.field_modifyComplete;
case ALT_modifyReject:
return *field_modifyReject == *other_value.field_modifyReject;
case ALT_userInformation:
return *field_userInformation == *other_value.field_userInformation;
case ALT_disconnect__MS__NW:
return *field_disconnect__MS__NW == *other_value.field_disconnect__MS__NW;
case ALT_release__MS__NW:
return *field_release__MS__NW == *other_value.field_release__MS__NW;
case ALT_releaseComplete__MS__NW:
return *field_releaseComplete__MS__NW == *other_value.field_releaseComplete__MS__NW;
case ALT_facility:
return *field_facility == *other_value.field_facility;
case ALT_hold:
return *field_hold == *other_value.field_hold;
case ALT_retrieve:
return *field_retrieve == *other_value.field_retrieve;
case ALT_notify:
return *field_notify == *other_value.field_notify;
case ALT_startDTMF:
return *field_startDTMF == *other_value.field_startDTMF;
case ALT_status:
return *field_status == *other_value.field_status;
case ALT_statusEnquiry:
return *field_statusEnquiry == *other_value.field_statusEnquiry;
case ALT_stopDTMF:
return *field_stopDTMF == *other_value.field_stopDTMF;
default:
return FALSE;
}
}

PDU__ML3__Alerting__MS__NW& PDU__ML3__CC__MS__NW::alerting__MS__NW()
{
if (union_selection != ALT_alerting__MS__NW) {
clean_up();
field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW;
union_selection = ALT_alerting__MS__NW;
}
return *field_alerting__MS__NW;
}

const PDU__ML3__Alerting__MS__NW& PDU__ML3__CC__MS__NW::alerting__MS__NW() const
{
if (union_selection != ALT_alerting__MS__NW) TTCN_error("Using non-selected field alerting_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_alerting__MS__NW;
}

PDU__ML3__CallConfirmed& PDU__ML3__CC__MS__NW::callConfirmed()
{
if (union_selection != ALT_callConfirmed) {
clean_up();
field_callConfirmed = new PDU__ML3__CallConfirmed;
union_selection = ALT_callConfirmed;
}
return *field_callConfirmed;
}

const PDU__ML3__CallConfirmed& PDU__ML3__CC__MS__NW::callConfirmed() const
{
if (union_selection != ALT_callConfirmed) TTCN_error("Using non-selected field callConfirmed in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_callConfirmed;
}

PDU__ML3__Connect__MS__NW& PDU__ML3__CC__MS__NW::connect__MS__NW()
{
if (union_selection != ALT_connect__MS__NW) {
clean_up();
field_connect__MS__NW = new PDU__ML3__Connect__MS__NW;
union_selection = ALT_connect__MS__NW;
}
return *field_connect__MS__NW;
}

const PDU__ML3__Connect__MS__NW& PDU__ML3__CC__MS__NW::connect__MS__NW() const
{
if (union_selection != ALT_connect__MS__NW) TTCN_error("Using non-selected field connect_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_connect__MS__NW;
}

PDU__ML3__ConnectAck& PDU__ML3__CC__MS__NW::connectAck()
{
if (union_selection != ALT_connectAck) {
clean_up();
field_connectAck = new PDU__ML3__ConnectAck;
union_selection = ALT_connectAck;
}
return *field_connectAck;
}

const PDU__ML3__ConnectAck& PDU__ML3__CC__MS__NW::connectAck() const
{
if (union_selection != ALT_connectAck) TTCN_error("Using non-selected field connectAck in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_connectAck;
}

PDU__ML3__EmergencySetup& PDU__ML3__CC__MS__NW::emergencySetup()
{
if (union_selection != ALT_emergencySetup) {
clean_up();
field_emergencySetup = new PDU__ML3__EmergencySetup;
union_selection = ALT_emergencySetup;
}
return *field_emergencySetup;
}

const PDU__ML3__EmergencySetup& PDU__ML3__CC__MS__NW::emergencySetup() const
{
if (union_selection != ALT_emergencySetup) TTCN_error("Using non-selected field emergencySetup in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_emergencySetup;
}

PDU__ML3__CC__EstablishmentConf& PDU__ML3__CC__MS__NW::cc__EstablishmentConf()
{
if (union_selection != ALT_cc__EstablishmentConf) {
clean_up();
field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf;
union_selection = ALT_cc__EstablishmentConf;
}
return *field_cc__EstablishmentConf;
}

const PDU__ML3__CC__EstablishmentConf& PDU__ML3__CC__MS__NW::cc__EstablishmentConf() const
{
if (union_selection != ALT_cc__EstablishmentConf) TTCN_error("Using non-selected field cc_EstablishmentConf in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_cc__EstablishmentConf;
}

PDU__ML3__StartCC& PDU__ML3__CC__MS__NW::startCC()
{
if (union_selection != ALT_startCC) {
clean_up();
field_startCC = new PDU__ML3__StartCC;
union_selection = ALT_startCC;
}
return *field_startCC;
}

const PDU__ML3__StartCC& PDU__ML3__CC__MS__NW::startCC() const
{
if (union_selection != ALT_startCC) TTCN_error("Using non-selected field startCC in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_startCC;
}

PDU__ML3__Setup__MS__NW& PDU__ML3__CC__MS__NW::setup__MS__NW()
{
if (union_selection != ALT_setup__MS__NW) {
clean_up();
field_setup__MS__NW = new PDU__ML3__Setup__MS__NW;
union_selection = ALT_setup__MS__NW;
}
return *field_setup__MS__NW;
}

const PDU__ML3__Setup__MS__NW& PDU__ML3__CC__MS__NW::setup__MS__NW() const
{
if (union_selection != ALT_setup__MS__NW) TTCN_error("Using non-selected field setup_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_setup__MS__NW;
}

PDU__ML3__Modify& PDU__ML3__CC__MS__NW::modify()
{
if (union_selection != ALT_modify) {
clean_up();
field_modify = new PDU__ML3__Modify;
union_selection = ALT_modify;
}
return *field_modify;
}

const PDU__ML3__Modify& PDU__ML3__CC__MS__NW::modify() const
{
if (union_selection != ALT_modify) TTCN_error("Using non-selected field modify in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_modify;
}

PDU__ML3__ModifyComplete& PDU__ML3__CC__MS__NW::modifyComplete()
{
if (union_selection != ALT_modifyComplete) {
clean_up();
field_modifyComplete = new PDU__ML3__ModifyComplete;
union_selection = ALT_modifyComplete;
}
return *field_modifyComplete;
}

const PDU__ML3__ModifyComplete& PDU__ML3__CC__MS__NW::modifyComplete() const
{
if (union_selection != ALT_modifyComplete) TTCN_error("Using non-selected field modifyComplete in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_modifyComplete;
}

PDU__ML3__ModifyReject& PDU__ML3__CC__MS__NW::modifyReject()
{
if (union_selection != ALT_modifyReject) {
clean_up();
field_modifyReject = new PDU__ML3__ModifyReject;
union_selection = ALT_modifyReject;
}
return *field_modifyReject;
}

const PDU__ML3__ModifyReject& PDU__ML3__CC__MS__NW::modifyReject() const
{
if (union_selection != ALT_modifyReject) TTCN_error("Using non-selected field modifyReject in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_modifyReject;
}

PDU__ML3__UserInformation& PDU__ML3__CC__MS__NW::userInformation()
{
if (union_selection != ALT_userInformation) {
clean_up();
field_userInformation = new PDU__ML3__UserInformation;
union_selection = ALT_userInformation;
}
return *field_userInformation;
}

const PDU__ML3__UserInformation& PDU__ML3__CC__MS__NW::userInformation() const
{
if (union_selection != ALT_userInformation) TTCN_error("Using non-selected field userInformation in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_userInformation;
}

PDU__ML3__Disconnect__MS__NW& PDU__ML3__CC__MS__NW::disconnect__MS__NW()
{
if (union_selection != ALT_disconnect__MS__NW) {
clean_up();
field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW;
union_selection = ALT_disconnect__MS__NW;
}
return *field_disconnect__MS__NW;
}

const PDU__ML3__Disconnect__MS__NW& PDU__ML3__CC__MS__NW::disconnect__MS__NW() const
{
if (union_selection != ALT_disconnect__MS__NW) TTCN_error("Using non-selected field disconnect_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_disconnect__MS__NW;
}

PDU__ML3__Release__MS__NW& PDU__ML3__CC__MS__NW::release__MS__NW()
{
if (union_selection != ALT_release__MS__NW) {
clean_up();
field_release__MS__NW = new PDU__ML3__Release__MS__NW;
union_selection = ALT_release__MS__NW;
}
return *field_release__MS__NW;
}

const PDU__ML3__Release__MS__NW& PDU__ML3__CC__MS__NW::release__MS__NW() const
{
if (union_selection != ALT_release__MS__NW) TTCN_error("Using non-selected field release_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_release__MS__NW;
}

PDU__ML3__ReleaseComplete__MS__NW& PDU__ML3__CC__MS__NW::releaseComplete__MS__NW()
{
if (union_selection != ALT_releaseComplete__MS__NW) {
clean_up();
field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW;
union_selection = ALT_releaseComplete__MS__NW;
}
return *field_releaseComplete__MS__NW;
}

const PDU__ML3__ReleaseComplete__MS__NW& PDU__ML3__CC__MS__NW::releaseComplete__MS__NW() const
{
if (union_selection != ALT_releaseComplete__MS__NW) TTCN_error("Using non-selected field releaseComplete_MS_NW in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_releaseComplete__MS__NW;
}

PDU__ML3__Facility& PDU__ML3__CC__MS__NW::facility()
{
if (union_selection != ALT_facility) {
clean_up();
field_facility = new PDU__ML3__Facility;
union_selection = ALT_facility;
}
return *field_facility;
}

const PDU__ML3__Facility& PDU__ML3__CC__MS__NW::facility() const
{
if (union_selection != ALT_facility) TTCN_error("Using non-selected field facility in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_facility;
}

PDU__ML3__Hold& PDU__ML3__CC__MS__NW::hold()
{
if (union_selection != ALT_hold) {
clean_up();
field_hold = new PDU__ML3__Hold;
union_selection = ALT_hold;
}
return *field_hold;
}

const PDU__ML3__Hold& PDU__ML3__CC__MS__NW::hold() const
{
if (union_selection != ALT_hold) TTCN_error("Using non-selected field hold in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_hold;
}

PDU__ML3__Retrieve& PDU__ML3__CC__MS__NW::retrieve()
{
if (union_selection != ALT_retrieve) {
clean_up();
field_retrieve = new PDU__ML3__Retrieve;
union_selection = ALT_retrieve;
}
return *field_retrieve;
}

const PDU__ML3__Retrieve& PDU__ML3__CC__MS__NW::retrieve() const
{
if (union_selection != ALT_retrieve) TTCN_error("Using non-selected field retrieve in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_retrieve;
}

PDU__ML3__Notify& PDU__ML3__CC__MS__NW::notify()
{
if (union_selection != ALT_notify) {
clean_up();
field_notify = new PDU__ML3__Notify;
union_selection = ALT_notify;
}
return *field_notify;
}

const PDU__ML3__Notify& PDU__ML3__CC__MS__NW::notify() const
{
if (union_selection != ALT_notify) TTCN_error("Using non-selected field notify in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_notify;
}

PDU__ML3__StartDTMF& PDU__ML3__CC__MS__NW::startDTMF()
{
if (union_selection != ALT_startDTMF) {
clean_up();
field_startDTMF = new PDU__ML3__StartDTMF;
union_selection = ALT_startDTMF;
}
return *field_startDTMF;
}

const PDU__ML3__StartDTMF& PDU__ML3__CC__MS__NW::startDTMF() const
{
if (union_selection != ALT_startDTMF) TTCN_error("Using non-selected field startDTMF in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_startDTMF;
}

PDU__ML3__Status& PDU__ML3__CC__MS__NW::status()
{
if (union_selection != ALT_status) {
clean_up();
field_status = new PDU__ML3__Status;
union_selection = ALT_status;
}
return *field_status;
}

const PDU__ML3__Status& PDU__ML3__CC__MS__NW::status() const
{
if (union_selection != ALT_status) TTCN_error("Using non-selected field status in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_status;
}

PDU__ML3__StatusEnquiry& PDU__ML3__CC__MS__NW::statusEnquiry()
{
if (union_selection != ALT_statusEnquiry) {
clean_up();
field_statusEnquiry = new PDU__ML3__StatusEnquiry;
union_selection = ALT_statusEnquiry;
}
return *field_statusEnquiry;
}

const PDU__ML3__StatusEnquiry& PDU__ML3__CC__MS__NW::statusEnquiry() const
{
if (union_selection != ALT_statusEnquiry) TTCN_error("Using non-selected field statusEnquiry in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_statusEnquiry;
}

PDU__ML3__StopDTMF& PDU__ML3__CC__MS__NW::stopDTMF()
{
if (union_selection != ALT_stopDTMF) {
clean_up();
field_stopDTMF = new PDU__ML3__StopDTMF;
union_selection = ALT_stopDTMF;
}
return *field_stopDTMF;
}

const PDU__ML3__StopDTMF& PDU__ML3__CC__MS__NW::stopDTMF() const
{
if (union_selection != ALT_stopDTMF) TTCN_error("Using non-selected field stopDTMF in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *field_stopDTMF;
}

boolean PDU__ML3__CC__MS__NW::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return union_selection == checked_selection;
}

boolean PDU__ML3__CC__MS__NW::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PDU__ML3__CC__MS__NW::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_alerting__MS__NW: return field_alerting__MS__NW->is_value();
case ALT_callConfirmed: return field_callConfirmed->is_value();
case ALT_connect__MS__NW: return field_connect__MS__NW->is_value();
case ALT_connectAck: return field_connectAck->is_value();
case ALT_emergencySetup: return field_emergencySetup->is_value();
case ALT_cc__EstablishmentConf: return field_cc__EstablishmentConf->is_value();
case ALT_startCC: return field_startCC->is_value();
case ALT_setup__MS__NW: return field_setup__MS__NW->is_value();
case ALT_modify: return field_modify->is_value();
case ALT_modifyComplete: return field_modifyComplete->is_value();
case ALT_modifyReject: return field_modifyReject->is_value();
case ALT_userInformation: return field_userInformation->is_value();
case ALT_disconnect__MS__NW: return field_disconnect__MS__NW->is_value();
case ALT_release__MS__NW: return field_release__MS__NW->is_value();
case ALT_releaseComplete__MS__NW: return field_releaseComplete__MS__NW->is_value();
case ALT_facility: return field_facility->is_value();
case ALT_hold: return field_hold->is_value();
case ALT_retrieve: return field_retrieve->is_value();
case ALT_notify: return field_notify->is_value();
case ALT_startDTMF: return field_startDTMF->is_value();
case ALT_status: return field_status->is_value();
case ALT_statusEnquiry: return field_statusEnquiry->is_value();
case ALT_stopDTMF: return field_stopDTMF->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PDU__ML3__CC__MS__NW::clean_up()
{
switch (union_selection) {
case ALT_alerting__MS__NW:
  delete field_alerting__MS__NW;
  break;
case ALT_callConfirmed:
  delete field_callConfirmed;
  break;
case ALT_connect__MS__NW:
  delete field_connect__MS__NW;
  break;
case ALT_connectAck:
  delete field_connectAck;
  break;
case ALT_emergencySetup:
  delete field_emergencySetup;
  break;
case ALT_cc__EstablishmentConf:
  delete field_cc__EstablishmentConf;
  break;
case ALT_startCC:
  delete field_startCC;
  break;
case ALT_setup__MS__NW:
  delete field_setup__MS__NW;
  break;
case ALT_modify:
  delete field_modify;
  break;
case ALT_modifyComplete:
  delete field_modifyComplete;
  break;
case ALT_modifyReject:
  delete field_modifyReject;
  break;
case ALT_userInformation:
  delete field_userInformation;
  break;
case ALT_disconnect__MS__NW:
  delete field_disconnect__MS__NW;
  break;
case ALT_release__MS__NW:
  delete field_release__MS__NW;
  break;
case ALT_releaseComplete__MS__NW:
  delete field_releaseComplete__MS__NW;
  break;
case ALT_facility:
  delete field_facility;
  break;
case ALT_hold:
  delete field_hold;
  break;
case ALT_retrieve:
  delete field_retrieve;
  break;
case ALT_notify:
  delete field_notify;
  break;
case ALT_startDTMF:
  delete field_startDTMF;
  break;
case ALT_status:
  delete field_status;
  break;
case ALT_statusEnquiry:
  delete field_statusEnquiry;
  break;
case ALT_stopDTMF:
  delete field_stopDTMF;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PDU__ML3__CC__MS__NW::log() const
{
switch (union_selection) {
case ALT_alerting__MS__NW:
TTCN_Logger::log_event_str("{ alerting_MS_NW := ");
field_alerting__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_callConfirmed:
TTCN_Logger::log_event_str("{ callConfirmed := ");
field_callConfirmed->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_connect__MS__NW:
TTCN_Logger::log_event_str("{ connect_MS_NW := ");
field_connect__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_connectAck:
TTCN_Logger::log_event_str("{ connectAck := ");
field_connectAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_emergencySetup:
TTCN_Logger::log_event_str("{ emergencySetup := ");
field_emergencySetup->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cc__EstablishmentConf:
TTCN_Logger::log_event_str("{ cc_EstablishmentConf := ");
field_cc__EstablishmentConf->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_startCC:
TTCN_Logger::log_event_str("{ startCC := ");
field_startCC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_setup__MS__NW:
TTCN_Logger::log_event_str("{ setup_MS_NW := ");
field_setup__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modify:
TTCN_Logger::log_event_str("{ modify := ");
field_modify->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modifyComplete:
TTCN_Logger::log_event_str("{ modifyComplete := ");
field_modifyComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modifyReject:
TTCN_Logger::log_event_str("{ modifyReject := ");
field_modifyReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_userInformation:
TTCN_Logger::log_event_str("{ userInformation := ");
field_userInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_disconnect__MS__NW:
TTCN_Logger::log_event_str("{ disconnect_MS_NW := ");
field_disconnect__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_release__MS__NW:
TTCN_Logger::log_event_str("{ release_MS_NW := ");
field_release__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_releaseComplete__MS__NW:
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
field_releaseComplete__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_hold:
TTCN_Logger::log_event_str("{ hold := ");
field_hold->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_retrieve:
TTCN_Logger::log_event_str("{ retrieve := ");
field_retrieve->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_notify:
TTCN_Logger::log_event_str("{ notify := ");
field_notify->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_startDTMF:
TTCN_Logger::log_event_str("{ startDTMF := ");
field_startDTMF->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_status:
TTCN_Logger::log_event_str("{ status := ");
field_status->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_statusEnquiry:
TTCN_Logger::log_event_str("{ statusEnquiry := ");
field_statusEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_stopDTMF:
TTCN_Logger::log_event_str("{ stopDTMF := ");
field_stopDTMF->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PDU__ML3__CC__MS__NW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "alerting_MS_NW")) {
    alerting__MS__NW().set_param(*mp_last);
    if (!alerting__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "callConfirmed")) {
    callConfirmed().set_param(*mp_last);
    if (!callConfirmed().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "connect_MS_NW")) {
    connect__MS__NW().set_param(*mp_last);
    if (!connect__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "connectAck")) {
    connectAck().set_param(*mp_last);
    if (!connectAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "emergencySetup")) {
    emergencySetup().set_param(*mp_last);
    if (!emergencySetup().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cc_EstablishmentConf")) {
    cc__EstablishmentConf().set_param(*mp_last);
    if (!cc__EstablishmentConf().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "startCC")) {
    startCC().set_param(*mp_last);
    if (!startCC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "setup_MS_NW")) {
    setup__MS__NW().set_param(*mp_last);
    if (!setup__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modify")) {
    modify().set_param(*mp_last);
    if (!modify().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modifyComplete")) {
    modifyComplete().set_param(*mp_last);
    if (!modifyComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modifyReject")) {
    modifyReject().set_param(*mp_last);
    if (!modifyReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "userInformation")) {
    userInformation().set_param(*mp_last);
    if (!userInformation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "disconnect_MS_NW")) {
    disconnect__MS__NW().set_param(*mp_last);
    if (!disconnect__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "release_MS_NW")) {
    release__MS__NW().set_param(*mp_last);
    if (!release__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "releaseComplete_MS_NW")) {
    releaseComplete__MS__NW().set_param(*mp_last);
    if (!releaseComplete__MS__NW().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "facility")) {
    facility().set_param(*mp_last);
    if (!facility().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "hold")) {
    hold().set_param(*mp_last);
    if (!hold().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "retrieve")) {
    retrieve().set_param(*mp_last);
    if (!retrieve().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "notify")) {
    notify().set_param(*mp_last);
    if (!notify().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "startDTMF")) {
    startDTMF().set_param(*mp_last);
    if (!startDTMF().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "status")) {
    status().set_param(*mp_last);
    if (!status().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "statusEnquiry")) {
    statusEnquiry().set_param(*mp_last);
    if (!statusEnquiry().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "stopDTMF")) {
    stopDTMF().set_param(*mp_last);
    if (!stopDTMF().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.", last_name);
}

void PDU__ML3__CC__MS__NW::set_implicit_omit()
{
switch (union_selection) {
case ALT_alerting__MS__NW:
field_alerting__MS__NW->set_implicit_omit(); break;
case ALT_callConfirmed:
field_callConfirmed->set_implicit_omit(); break;
case ALT_connect__MS__NW:
field_connect__MS__NW->set_implicit_omit(); break;
case ALT_connectAck:
field_connectAck->set_implicit_omit(); break;
case ALT_emergencySetup:
field_emergencySetup->set_implicit_omit(); break;
case ALT_cc__EstablishmentConf:
field_cc__EstablishmentConf->set_implicit_omit(); break;
case ALT_startCC:
field_startCC->set_implicit_omit(); break;
case ALT_setup__MS__NW:
field_setup__MS__NW->set_implicit_omit(); break;
case ALT_modify:
field_modify->set_implicit_omit(); break;
case ALT_modifyComplete:
field_modifyComplete->set_implicit_omit(); break;
case ALT_modifyReject:
field_modifyReject->set_implicit_omit(); break;
case ALT_userInformation:
field_userInformation->set_implicit_omit(); break;
case ALT_disconnect__MS__NW:
field_disconnect__MS__NW->set_implicit_omit(); break;
case ALT_release__MS__NW:
field_release__MS__NW->set_implicit_omit(); break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW->set_implicit_omit(); break;
case ALT_facility:
field_facility->set_implicit_omit(); break;
case ALT_hold:
field_hold->set_implicit_omit(); break;
case ALT_retrieve:
field_retrieve->set_implicit_omit(); break;
case ALT_notify:
field_notify->set_implicit_omit(); break;
case ALT_startDTMF:
field_startDTMF->set_implicit_omit(); break;
case ALT_status:
field_status->set_implicit_omit(); break;
case ALT_statusEnquiry:
field_statusEnquiry->set_implicit_omit(); break;
case ALT_stopDTMF:
field_stopDTMF->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__CC__MS__NW::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_alerting__MS__NW:
field_alerting__MS__NW->encode_text(text_buf);
break;
case ALT_callConfirmed:
field_callConfirmed->encode_text(text_buf);
break;
case ALT_connect__MS__NW:
field_connect__MS__NW->encode_text(text_buf);
break;
case ALT_connectAck:
field_connectAck->encode_text(text_buf);
break;
case ALT_emergencySetup:
field_emergencySetup->encode_text(text_buf);
break;
case ALT_cc__EstablishmentConf:
field_cc__EstablishmentConf->encode_text(text_buf);
break;
case ALT_startCC:
field_startCC->encode_text(text_buf);
break;
case ALT_setup__MS__NW:
field_setup__MS__NW->encode_text(text_buf);
break;
case ALT_modify:
field_modify->encode_text(text_buf);
break;
case ALT_modifyComplete:
field_modifyComplete->encode_text(text_buf);
break;
case ALT_modifyReject:
field_modifyReject->encode_text(text_buf);
break;
case ALT_userInformation:
field_userInformation->encode_text(text_buf);
break;
case ALT_disconnect__MS__NW:
field_disconnect__MS__NW->encode_text(text_buf);
break;
case ALT_release__MS__NW:
field_release__MS__NW->encode_text(text_buf);
break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW->encode_text(text_buf);
break;
case ALT_facility:
field_facility->encode_text(text_buf);
break;
case ALT_hold:
field_hold->encode_text(text_buf);
break;
case ALT_retrieve:
field_retrieve->encode_text(text_buf);
break;
case ALT_notify:
field_notify->encode_text(text_buf);
break;
case ALT_startDTMF:
field_startDTMF->encode_text(text_buf);
break;
case ALT_status:
field_status->encode_text(text_buf);
break;
case ALT_statusEnquiry:
field_statusEnquiry->encode_text(text_buf);
break;
case ALT_stopDTMF:
field_stopDTMF->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}

void PDU__ML3__CC__MS__NW::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_alerting__MS__NW:
alerting__MS__NW().decode_text(text_buf);
break;
case ALT_callConfirmed:
callConfirmed().decode_text(text_buf);
break;
case ALT_connect__MS__NW:
connect__MS__NW().decode_text(text_buf);
break;
case ALT_connectAck:
connectAck().decode_text(text_buf);
break;
case ALT_emergencySetup:
emergencySetup().decode_text(text_buf);
break;
case ALT_cc__EstablishmentConf:
cc__EstablishmentConf().decode_text(text_buf);
break;
case ALT_startCC:
startCC().decode_text(text_buf);
break;
case ALT_setup__MS__NW:
setup__MS__NW().decode_text(text_buf);
break;
case ALT_modify:
modify().decode_text(text_buf);
break;
case ALT_modifyComplete:
modifyComplete().decode_text(text_buf);
break;
case ALT_modifyReject:
modifyReject().decode_text(text_buf);
break;
case ALT_userInformation:
userInformation().decode_text(text_buf);
break;
case ALT_disconnect__MS__NW:
disconnect__MS__NW().decode_text(text_buf);
break;
case ALT_release__MS__NW:
release__MS__NW().decode_text(text_buf);
break;
case ALT_releaseComplete__MS__NW:
releaseComplete__MS__NW().decode_text(text_buf);
break;
case ALT_facility:
facility().decode_text(text_buf);
break;
case ALT_hold:
hold().decode_text(text_buf);
break;
case ALT_retrieve:
retrieve().decode_text(text_buf);
break;
case ALT_notify:
notify().decode_text(text_buf);
break;
case ALT_startDTMF:
startDTMF().decode_text(text_buf);
break;
case ALT_status:
status().decode_text(text_buf);
break;
case ALT_statusEnquiry:
statusEnquiry().decode_text(text_buf);
break;
case ALT_stopDTMF:
stopDTMF().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}

void PDU__ML3__CC__MS__NW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__CC__MS__NW::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__CC__MS__NW::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__Alerting__MS__NW_descr_.raw->forceomit);
      decoded_length = alerting__MS__NW().RAW_decode(PDU__ML3__Alerting__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__CallConfirmed_descr_.raw->forceomit);
      decoded_length = callConfirmed().RAW_decode(PDU__ML3__CallConfirmed_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__Connect__MS__NW_descr_.raw->forceomit);
      decoded_length = connect__MS__NW().RAW_decode(PDU__ML3__Connect__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, PDU__ML3__ConnectAck_descr_.raw->forceomit);
      decoded_length = connectAck().RAW_decode(PDU__ML3__ConnectAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, PDU__ML3__EmergencySetup_descr_.raw->forceomit);
      decoded_length = emergencySetup().RAW_decode(PDU__ML3__EmergencySetup_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, PDU__ML3__CC__EstablishmentConf_descr_.raw->forceomit);
      decoded_length = cc__EstablishmentConf().RAW_decode(PDU__ML3__CC__EstablishmentConf_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, PDU__ML3__StartCC_descr_.raw->forceomit);
      decoded_length = startCC().RAW_decode(PDU__ML3__StartCC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, PDU__ML3__Setup__MS__NW_descr_.raw->forceomit);
      decoded_length = setup__MS__NW().RAW_decode(PDU__ML3__Setup__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, PDU__ML3__Modify_descr_.raw->forceomit);
      decoded_length = modify().RAW_decode(PDU__ML3__Modify_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, PDU__ML3__ModifyComplete_descr_.raw->forceomit);
      decoded_length = modifyComplete().RAW_decode(PDU__ML3__ModifyComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, PDU__ML3__ModifyReject_descr_.raw->forceomit);
      decoded_length = modifyReject().RAW_decode(PDU__ML3__ModifyReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, PDU__ML3__UserInformation_descr_.raw->forceomit);
      decoded_length = userInformation().RAW_decode(PDU__ML3__UserInformation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, PDU__ML3__Disconnect__MS__NW_descr_.raw->forceomit);
      decoded_length = disconnect__MS__NW().RAW_decode(PDU__ML3__Disconnect__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, PDU__ML3__Release__MS__NW_descr_.raw->forceomit);
      decoded_length = release__MS__NW().RAW_decode(PDU__ML3__Release__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, PDU__ML3__ReleaseComplete__MS__NW_descr_.raw->forceomit);
      decoded_length = releaseComplete__MS__NW().RAW_decode(PDU__ML3__ReleaseComplete__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 15: {
      RAW_Force_Omit field_force_omit(15, force_omit, PDU__ML3__Facility_descr_.raw->forceomit);
      decoded_length = facility().RAW_decode(PDU__ML3__Facility_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 16: {
      RAW_Force_Omit field_force_omit(16, force_omit, PDU__ML3__Hold_descr_.raw->forceomit);
      decoded_length = hold().RAW_decode(PDU__ML3__Hold_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 17: {
      RAW_Force_Omit field_force_omit(17, force_omit, PDU__ML3__Retrieve_descr_.raw->forceomit);
      decoded_length = retrieve().RAW_decode(PDU__ML3__Retrieve_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 18: {
      RAW_Force_Omit field_force_omit(18, force_omit, PDU__ML3__Notify_descr_.raw->forceomit);
      decoded_length = notify().RAW_decode(PDU__ML3__Notify_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 19: {
      RAW_Force_Omit field_force_omit(19, force_omit, PDU__ML3__StartDTMF_descr_.raw->forceomit);
      decoded_length = startDTMF().RAW_decode(PDU__ML3__StartDTMF_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 20: {
      RAW_Force_Omit field_force_omit(20, force_omit, PDU__ML3__Status_descr_.raw->forceomit);
      decoded_length = status().RAW_decode(PDU__ML3__Status_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 21: {
      RAW_Force_Omit field_force_omit(21, force_omit, PDU__ML3__StatusEnquiry_descr_.raw->forceomit);
      decoded_length = statusEnquiry().RAW_decode(PDU__ML3__StatusEnquiry_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 22: {
      RAW_Force_Omit field_force_omit(22, force_omit, PDU__ML3__StopDTMF_descr_.raw->forceomit);
      decoded_length = stopDTMF().RAW_decode(PDU__ML3__StopDTMF_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
    boolean already_failed = FALSE;
    BITSTRING temporal_0;
    int decoded_0_length;
    already_failed = FALSE;
    if (!already_failed) {
      p_buf.set_pos_bit(starting_pos + 0);
      decoded_0_length = temporal_0.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, top_bit_ord, TRUE);
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_2) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__Alerting__MS__NW_descr_.raw->forceomit);
          decoded_length = alerting__MS__NW().RAW_decode(PDU__ML3__Alerting__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_alerting__MS__NW).messageType() ==  bs_2) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_3) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__CallConfirmed_descr_.raw->forceomit);
          decoded_length = callConfirmed().RAW_decode(PDU__ML3__CallConfirmed_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_callConfirmed).messageType() ==  bs_3) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_4) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__Connect__MS__NW_descr_.raw->forceomit);
          decoded_length = connect__MS__NW().RAW_decode(PDU__ML3__Connect__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_connect__MS__NW).messageType() ==  bs_4) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_5) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(3, force_omit, PDU__ML3__ConnectAck_descr_.raw->forceomit);
          decoded_length = connectAck().RAW_decode(PDU__ML3__ConnectAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_connectAck).messageType() ==  bs_5) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_6) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(4, force_omit, PDU__ML3__EmergencySetup_descr_.raw->forceomit);
          decoded_length = emergencySetup().RAW_decode(PDU__ML3__EmergencySetup_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_emergencySetup).messageType() ==  bs_6) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_7) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(5, force_omit, PDU__ML3__CC__EstablishmentConf_descr_.raw->forceomit);
          decoded_length = cc__EstablishmentConf().RAW_decode(PDU__ML3__CC__EstablishmentConf_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_cc__EstablishmentConf).messageType() ==  bs_7) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_8) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(6, force_omit, PDU__ML3__StartCC_descr_.raw->forceomit);
          decoded_length = startCC().RAW_decode(PDU__ML3__StartCC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_startCC).messageType() ==  bs_8) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_9) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(7, force_omit, PDU__ML3__Setup__MS__NW_descr_.raw->forceomit);
          decoded_length = setup__MS__NW().RAW_decode(PDU__ML3__Setup__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_setup__MS__NW).messageType() ==  bs_9) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_10) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(8, force_omit, PDU__ML3__Modify_descr_.raw->forceomit);
          decoded_length = modify().RAW_decode(PDU__ML3__Modify_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modify).messageType() ==  bs_10) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_11) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(9, force_omit, PDU__ML3__ModifyComplete_descr_.raw->forceomit);
          decoded_length = modifyComplete().RAW_decode(PDU__ML3__ModifyComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modifyComplete).messageType() ==  bs_11) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_12) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(10, force_omit, PDU__ML3__ModifyReject_descr_.raw->forceomit);
          decoded_length = modifyReject().RAW_decode(PDU__ML3__ModifyReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modifyReject).messageType() ==  bs_12) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_13) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(11, force_omit, PDU__ML3__UserInformation_descr_.raw->forceomit);
          decoded_length = userInformation().RAW_decode(PDU__ML3__UserInformation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_userInformation).messageType() ==  bs_13) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_14) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(12, force_omit, PDU__ML3__Disconnect__MS__NW_descr_.raw->forceomit);
          decoded_length = disconnect__MS__NW().RAW_decode(PDU__ML3__Disconnect__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_disconnect__MS__NW).messageType() ==  bs_14) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_15) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(13, force_omit, PDU__ML3__Release__MS__NW_descr_.raw->forceomit);
          decoded_length = release__MS__NW().RAW_decode(PDU__ML3__Release__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_release__MS__NW).messageType() ==  bs_15) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_16) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(14, force_omit, PDU__ML3__ReleaseComplete__MS__NW_descr_.raw->forceomit);
          decoded_length = releaseComplete__MS__NW().RAW_decode(PDU__ML3__ReleaseComplete__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_releaseComplete__MS__NW).messageType() ==  bs_16) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_17) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(15, force_omit, PDU__ML3__Facility_descr_.raw->forceomit);
          decoded_length = facility().RAW_decode(PDU__ML3__Facility_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_facility).messageType() ==  bs_17) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_18) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(16, force_omit, PDU__ML3__Hold_descr_.raw->forceomit);
          decoded_length = hold().RAW_decode(PDU__ML3__Hold_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_hold).messageType() ==  bs_18) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_19) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(17, force_omit, PDU__ML3__Retrieve_descr_.raw->forceomit);
          decoded_length = retrieve().RAW_decode(PDU__ML3__Retrieve_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_retrieve).messageType() ==  bs_19) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_20) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(18, force_omit, PDU__ML3__Notify_descr_.raw->forceomit);
          decoded_length = notify().RAW_decode(PDU__ML3__Notify_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_notify).messageType() ==  bs_20) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_21) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(19, force_omit, PDU__ML3__StartDTMF_descr_.raw->forceomit);
          decoded_length = startDTMF().RAW_decode(PDU__ML3__StartDTMF_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_startDTMF).messageType() ==  bs_21) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_22) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(20, force_omit, PDU__ML3__Status_descr_.raw->forceomit);
          decoded_length = status().RAW_decode(PDU__ML3__Status_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_status).messageType() ==  bs_22) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_23) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(21, force_omit, PDU__ML3__StatusEnquiry_descr_.raw->forceomit);
          decoded_length = statusEnquiry().RAW_decode(PDU__ML3__StatusEnquiry_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_statusEnquiry).messageType() ==  bs_23) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_24) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(22, force_omit, PDU__ML3__StopDTMF_descr_.raw->forceomit);
          decoded_length = stopDTMF().RAW_decode(PDU__ML3__StopDTMF_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_stopDTMF).messageType() ==  bs_24) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
 }
 clean_up();
 return -1;
}

int PDU__ML3__CC__MS__NW::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 23;  myleaf.body.node.nodes = init_nodes_of_enc_tree(23);
  memset(myleaf.body.node.nodes, 0, 23 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_alerting__MS__NW:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__ML3__Alerting__MS__NW_descr_.raw);
    encoded_length = field_alerting__MS__NW->RAW_encode(PDU__ML3__Alerting__MS__NW_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__ML3__Alerting__MS__NW_descr_;
    if ((*field_alerting__MS__NW).messageType() !=  bs_2) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_2.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_callConfirmed:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PDU__ML3__CallConfirmed_descr_.raw);
    encoded_length = field_callConfirmed->RAW_encode(PDU__ML3__CallConfirmed_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PDU__ML3__CallConfirmed_descr_;
    if ((*field_callConfirmed).messageType() !=  bs_3) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_3.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_connect__MS__NW:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PDU__ML3__Connect__MS__NW_descr_.raw);
    encoded_length = field_connect__MS__NW->RAW_encode(PDU__ML3__Connect__MS__NW_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PDU__ML3__Connect__MS__NW_descr_;
    if ((*field_connect__MS__NW).messageType() !=  bs_4) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_4.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_connectAck:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, PDU__ML3__ConnectAck_descr_.raw);
    encoded_length = field_connectAck->RAW_encode(PDU__ML3__ConnectAck_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &PDU__ML3__ConnectAck_descr_;
    if ((*field_connectAck).messageType() !=  bs_5) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_5.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_emergencySetup:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, PDU__ML3__EmergencySetup_descr_.raw);
    encoded_length = field_emergencySetup->RAW_encode(PDU__ML3__EmergencySetup_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &PDU__ML3__EmergencySetup_descr_;
    if ((*field_emergencySetup).messageType() !=  bs_6) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_6.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_cc__EstablishmentConf:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, PDU__ML3__CC__EstablishmentConf_descr_.raw);
    encoded_length = field_cc__EstablishmentConf->RAW_encode(PDU__ML3__CC__EstablishmentConf_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &PDU__ML3__CC__EstablishmentConf_descr_;
    if ((*field_cc__EstablishmentConf).messageType() !=  bs_7) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_7.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_startCC:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, PDU__ML3__StartCC_descr_.raw);
    encoded_length = field_startCC->RAW_encode(PDU__ML3__StartCC_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &PDU__ML3__StartCC_descr_;
    if ((*field_startCC).messageType() !=  bs_8) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_8.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_setup__MS__NW:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, PDU__ML3__Setup__MS__NW_descr_.raw);
    encoded_length = field_setup__MS__NW->RAW_encode(PDU__ML3__Setup__MS__NW_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &PDU__ML3__Setup__MS__NW_descr_;
    if ((*field_setup__MS__NW).messageType() !=  bs_9) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_9.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modify:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, PDU__ML3__Modify_descr_.raw);
    encoded_length = field_modify->RAW_encode(PDU__ML3__Modify_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &PDU__ML3__Modify_descr_;
    if ((*field_modify).messageType() !=  bs_10) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={8,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_10.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modifyComplete:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, PDU__ML3__ModifyComplete_descr_.raw);
    encoded_length = field_modifyComplete->RAW_encode(PDU__ML3__ModifyComplete_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &PDU__ML3__ModifyComplete_descr_;
    if ((*field_modifyComplete).messageType() !=  bs_11) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={9,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_11.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modifyReject:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, PDU__ML3__ModifyReject_descr_.raw);
    encoded_length = field_modifyReject->RAW_encode(PDU__ML3__ModifyReject_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &PDU__ML3__ModifyReject_descr_;
    if ((*field_modifyReject).messageType() !=  bs_12) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={10,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_12.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_userInformation:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, PDU__ML3__UserInformation_descr_.raw);
    encoded_length = field_userInformation->RAW_encode(PDU__ML3__UserInformation_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &PDU__ML3__UserInformation_descr_;
    if ((*field_userInformation).messageType() !=  bs_13) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={11,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_13.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_disconnect__MS__NW:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, PDU__ML3__Disconnect__MS__NW_descr_.raw);
    encoded_length = field_disconnect__MS__NW->RAW_encode(PDU__ML3__Disconnect__MS__NW_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &PDU__ML3__Disconnect__MS__NW_descr_;
    if ((*field_disconnect__MS__NW).messageType() !=  bs_14) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={12,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_14.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_release__MS__NW:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, PDU__ML3__Release__MS__NW_descr_.raw);
    encoded_length = field_release__MS__NW->RAW_encode(PDU__ML3__Release__MS__NW_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &PDU__ML3__Release__MS__NW_descr_;
    if ((*field_release__MS__NW).messageType() !=  bs_15) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={13,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_15.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_releaseComplete__MS__NW:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, PDU__ML3__ReleaseComplete__MS__NW_descr_.raw);
    encoded_length = field_releaseComplete__MS__NW->RAW_encode(PDU__ML3__ReleaseComplete__MS__NW_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &PDU__ML3__ReleaseComplete__MS__NW_descr_;
    if ((*field_releaseComplete__MS__NW).messageType() !=  bs_16) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={14,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_16.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_facility:
    myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 15, PDU__ML3__Facility_descr_.raw);
    encoded_length = field_facility->RAW_encode(PDU__ML3__Facility_descr_, *myleaf.body.node.nodes[15]);
    myleaf.body.node.nodes[15]->coding_descr = &PDU__ML3__Facility_descr_;
    if ((*field_facility).messageType() !=  bs_17) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={15,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_17.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_hold:
    myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 16, PDU__ML3__Hold_descr_.raw);
    encoded_length = field_hold->RAW_encode(PDU__ML3__Hold_descr_, *myleaf.body.node.nodes[16]);
    myleaf.body.node.nodes[16]->coding_descr = &PDU__ML3__Hold_descr_;
    if ((*field_hold).messageType() !=  bs_18) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={16,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_18.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_retrieve:
    myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 17, PDU__ML3__Retrieve_descr_.raw);
    encoded_length = field_retrieve->RAW_encode(PDU__ML3__Retrieve_descr_, *myleaf.body.node.nodes[17]);
    myleaf.body.node.nodes[17]->coding_descr = &PDU__ML3__Retrieve_descr_;
    if ((*field_retrieve).messageType() !=  bs_19) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={17,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_19.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_notify:
    myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 18, PDU__ML3__Notify_descr_.raw);
    encoded_length = field_notify->RAW_encode(PDU__ML3__Notify_descr_, *myleaf.body.node.nodes[18]);
    myleaf.body.node.nodes[18]->coding_descr = &PDU__ML3__Notify_descr_;
    if ((*field_notify).messageType() !=  bs_20) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={18,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_20.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_startDTMF:
    myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 19, PDU__ML3__StartDTMF_descr_.raw);
    encoded_length = field_startDTMF->RAW_encode(PDU__ML3__StartDTMF_descr_, *myleaf.body.node.nodes[19]);
    myleaf.body.node.nodes[19]->coding_descr = &PDU__ML3__StartDTMF_descr_;
    if ((*field_startDTMF).messageType() !=  bs_21) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={19,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_21.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_status:
    myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 20, PDU__ML3__Status_descr_.raw);
    encoded_length = field_status->RAW_encode(PDU__ML3__Status_descr_, *myleaf.body.node.nodes[20]);
    myleaf.body.node.nodes[20]->coding_descr = &PDU__ML3__Status_descr_;
    if ((*field_status).messageType() !=  bs_22) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={20,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_22.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_statusEnquiry:
    myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 21, PDU__ML3__StatusEnquiry_descr_.raw);
    encoded_length = field_statusEnquiry->RAW_encode(PDU__ML3__StatusEnquiry_descr_, *myleaf.body.node.nodes[21]);
    myleaf.body.node.nodes[21]->coding_descr = &PDU__ML3__StatusEnquiry_descr_;
    if ((*field_statusEnquiry).messageType() !=  bs_23) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={21,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_23.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_stopDTMF:
    myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 22, PDU__ML3__StopDTMF_descr_.raw);
    encoded_length = field_stopDTMF->RAW_encode(PDU__ML3__StopDTMF_descr_, *myleaf.body.node.nodes[22]);
    myleaf.body.node.nodes[22]->coding_descr = &PDU__ML3__StopDTMF_descr_;
    if ((*field_stopDTMF).messageType() !=  bs_24) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={22,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_24.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PDU__ML3__CC__MS__NW_template::copy_value(const PDU__ML3__CC__MS__NW& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW_template(other_value.alerting__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(other_value.callConfirmed());
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW = new PDU__ML3__Connect__MS__NW_template(other_value.connect__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template(other_value.connectAck());
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup = new PDU__ML3__EmergencySetup_template(other_value.emergencySetup());
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf_template(other_value.cc__EstablishmentConf());
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC = new PDU__ML3__StartCC_template(other_value.startCC());
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW = new PDU__ML3__Setup__MS__NW_template(other_value.setup__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template(other_value.modify());
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(other_value.modifyComplete());
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(other_value.modifyReject());
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template(other_value.userInformation());
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW_template(other_value.disconnect__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW = new PDU__ML3__Release__MS__NW_template(other_value.release__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW_template(other_value.releaseComplete__MS__NW());
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template(other_value.facility());
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold = new PDU__ML3__Hold_template(other_value.hold());
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve = new PDU__ML3__Retrieve_template(other_value.retrieve());
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template(other_value.notify());
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF = new PDU__ML3__StartDTMF_template(other_value.startDTMF());
break;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status = new PDU__ML3__Status_template(other_value.status());
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(other_value.statusEnquiry());
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF = new PDU__ML3__StopDTMF_template(other_value.stopDTMF());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__CC__MS__NW_template::copy_template(const PDU__ML3__CC__MS__NW_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW_template(*other_value.single_value.field_alerting__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(*other_value.single_value.field_callConfirmed);
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW = new PDU__ML3__Connect__MS__NW_template(*other_value.single_value.field_connect__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template(*other_value.single_value.field_connectAck);
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup = new PDU__ML3__EmergencySetup_template(*other_value.single_value.field_emergencySetup);
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf_template(*other_value.single_value.field_cc__EstablishmentConf);
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC = new PDU__ML3__StartCC_template(*other_value.single_value.field_startCC);
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW = new PDU__ML3__Setup__MS__NW_template(*other_value.single_value.field_setup__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template(*other_value.single_value.field_modify);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(*other_value.single_value.field_modifyComplete);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(*other_value.single_value.field_modifyReject);
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template(*other_value.single_value.field_userInformation);
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW_template(*other_value.single_value.field_disconnect__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW = new PDU__ML3__Release__MS__NW_template(*other_value.single_value.field_release__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW_template(*other_value.single_value.field_releaseComplete__MS__NW);
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template(*other_value.single_value.field_facility);
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold = new PDU__ML3__Hold_template(*other_value.single_value.field_hold);
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve = new PDU__ML3__Retrieve_template(*other_value.single_value.field_retrieve);
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template(*other_value.single_value.field_notify);
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF = new PDU__ML3__StartDTMF_template(*other_value.single_value.field_startDTMF);
break;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status = new PDU__ML3__Status_template(*other_value.single_value.field_status);
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(*other_value.single_value.field_statusEnquiry);
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF = new PDU__ML3__StopDTMF_template(*other_value.single_value.field_stopDTMF);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__CC__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__CC__MS__NW_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__CC__MS__NW_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
set_selection(other_value);
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template()
{
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(const PDU__ML3__CC__MS__NW& other_value)
{
copy_value(other_value);
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(const OPTIONAL<PDU__ML3__CC__MS__NW>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CC__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW from an unbound optional field.");
}
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(PDU__ML3__CC__MS__NW_template* p_precondition, PDU__ML3__CC__MS__NW_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(Dynamic_Match_Interface<PDU__ML3__CC__MS__NW>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__CC__MS__NW>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__CC__MS__NW_template::PDU__ML3__CC__MS__NW_template(const PDU__ML3__CC__MS__NW_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PDU__ML3__CC__MS__NW_template::~PDU__ML3__CC__MS__NW_template()
{
clean_up();
}

void PDU__ML3__CC__MS__NW_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
delete single_value.field_alerting__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
delete single_value.field_callConfirmed;
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
delete single_value.field_connect__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
delete single_value.field_connectAck;
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
delete single_value.field_emergencySetup;
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
delete single_value.field_cc__EstablishmentConf;
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
delete single_value.field_startCC;
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
delete single_value.field_setup__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
delete single_value.field_modify;
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
delete single_value.field_modifyComplete;
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
delete single_value.field_modifyReject;
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
delete single_value.field_userInformation;
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
delete single_value.field_disconnect__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
delete single_value.field_release__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
delete single_value.field_releaseComplete__MS__NW;
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
delete single_value.field_facility;
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
delete single_value.field_hold;
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
delete single_value.field_retrieve;
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
delete single_value.field_notify;
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
delete single_value.field_startDTMF;
break;
case PDU__ML3__CC__MS__NW::ALT_status:
delete single_value.field_status;
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
delete single_value.field_statusEnquiry;
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
delete single_value.field_stopDTMF;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__CC__MS__NW_template& PDU__ML3__CC__MS__NW_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__CC__MS__NW_template& PDU__ML3__CC__MS__NW_template::operator=(const PDU__ML3__CC__MS__NW& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__CC__MS__NW_template& PDU__ML3__CC__MS__NW_template::operator=(const OPTIONAL<PDU__ML3__CC__MS__NW>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CC__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
return *this;
}

PDU__ML3__CC__MS__NW_template& PDU__ML3__CC__MS__NW_template::operator=(const PDU__ML3__CC__MS__NW_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__CC__MS__NW_template::match(const PDU__ML3__CC__MS__NW& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PDU__ML3__CC__MS__NW::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PDU__ML3__CC__MS__NW::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
return single_value.field_alerting__MS__NW->match(other_value.alerting__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
return single_value.field_callConfirmed->match(other_value.callConfirmed(), legacy);
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
return single_value.field_connect__MS__NW->match(other_value.connect__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_connectAck:
return single_value.field_connectAck->match(other_value.connectAck(), legacy);
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
return single_value.field_emergencySetup->match(other_value.emergencySetup(), legacy);
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
return single_value.field_cc__EstablishmentConf->match(other_value.cc__EstablishmentConf(), legacy);
case PDU__ML3__CC__MS__NW::ALT_startCC:
return single_value.field_startCC->match(other_value.startCC(), legacy);
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
return single_value.field_setup__MS__NW->match(other_value.setup__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_modify:
return single_value.field_modify->match(other_value.modify(), legacy);
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
return single_value.field_modifyComplete->match(other_value.modifyComplete(), legacy);
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
return single_value.field_modifyReject->match(other_value.modifyReject(), legacy);
case PDU__ML3__CC__MS__NW::ALT_userInformation:
return single_value.field_userInformation->match(other_value.userInformation(), legacy);
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
return single_value.field_disconnect__MS__NW->match(other_value.disconnect__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
return single_value.field_release__MS__NW->match(other_value.release__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
return single_value.field_releaseComplete__MS__NW->match(other_value.releaseComplete__MS__NW(), legacy);
case PDU__ML3__CC__MS__NW::ALT_facility:
return single_value.field_facility->match(other_value.facility(), legacy);
case PDU__ML3__CC__MS__NW::ALT_hold:
return single_value.field_hold->match(other_value.hold(), legacy);
case PDU__ML3__CC__MS__NW::ALT_retrieve:
return single_value.field_retrieve->match(other_value.retrieve(), legacy);
case PDU__ML3__CC__MS__NW::ALT_notify:
return single_value.field_notify->match(other_value.notify(), legacy);
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
return single_value.field_startDTMF->match(other_value.startDTMF(), legacy);
case PDU__ML3__CC__MS__NW::ALT_status:
return single_value.field_status->match(other_value.status(), legacy);
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
return single_value.field_statusEnquiry->match(other_value.statusEnquiry(), legacy);
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
return single_value.field_stopDTMF->match(other_value.stopDTMF(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
return FALSE;
}

boolean PDU__ML3__CC__MS__NW_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
return single_value.field_alerting__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
return single_value.field_callConfirmed->is_value();
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
return single_value.field_connect__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_connectAck:
return single_value.field_connectAck->is_value();
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
return single_value.field_emergencySetup->is_value();
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
return single_value.field_cc__EstablishmentConf->is_value();
case PDU__ML3__CC__MS__NW::ALT_startCC:
return single_value.field_startCC->is_value();
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
return single_value.field_setup__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_modify:
return single_value.field_modify->is_value();
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
return single_value.field_modifyComplete->is_value();
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
return single_value.field_modifyReject->is_value();
case PDU__ML3__CC__MS__NW::ALT_userInformation:
return single_value.field_userInformation->is_value();
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
return single_value.field_disconnect__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
return single_value.field_release__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
return single_value.field_releaseComplete__MS__NW->is_value();
case PDU__ML3__CC__MS__NW::ALT_facility:
return single_value.field_facility->is_value();
case PDU__ML3__CC__MS__NW::ALT_hold:
return single_value.field_hold->is_value();
case PDU__ML3__CC__MS__NW::ALT_retrieve:
return single_value.field_retrieve->is_value();
case PDU__ML3__CC__MS__NW::ALT_notify:
return single_value.field_notify->is_value();
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
return single_value.field_startDTMF->is_value();
case PDU__ML3__CC__MS__NW::ALT_status:
return single_value.field_status->is_value();
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
return single_value.field_statusEnquiry->is_value();
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
return single_value.field_stopDTMF->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}

PDU__ML3__CC__MS__NW PDU__ML3__CC__MS__NW_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
PDU__ML3__CC__MS__NW ret_val;
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
ret_val.alerting__MS__NW() = single_value.field_alerting__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
ret_val.callConfirmed() = single_value.field_callConfirmed->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
ret_val.connect__MS__NW() = single_value.field_connect__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
ret_val.connectAck() = single_value.field_connectAck->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
ret_val.emergencySetup() = single_value.field_emergencySetup->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
ret_val.cc__EstablishmentConf() = single_value.field_cc__EstablishmentConf->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
ret_val.startCC() = single_value.field_startCC->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
ret_val.setup__MS__NW() = single_value.field_setup__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
ret_val.modify() = single_value.field_modify->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
ret_val.modifyComplete() = single_value.field_modifyComplete->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
ret_val.modifyReject() = single_value.field_modifyReject->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
ret_val.userInformation() = single_value.field_userInformation->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
ret_val.disconnect__MS__NW() = single_value.field_disconnect__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
ret_val.release__MS__NW() = single_value.field_release__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
ret_val.releaseComplete__MS__NW() = single_value.field_releaseComplete__MS__NW->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
ret_val.facility() = single_value.field_facility->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
ret_val.hold() = single_value.field_hold->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
ret_val.retrieve() = single_value.field_retrieve->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
ret_val.notify() = single_value.field_notify->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
ret_val.startDTMF() = single_value.field_startDTMF->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_status:
ret_val.status() = single_value.field_status->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
ret_val.statusEnquiry() = single_value.field_statusEnquiry->valueof();
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
ret_val.stopDTMF() = single_value.field_stopDTMF->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
return ret_val;
}

PDU__ML3__CC__MS__NW_template& PDU__ML3__CC__MS__NW_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return value_list.list_value[list_index];
}
void PDU__ML3__CC__MS__NW_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__CC__MS__NW_template[list_length];
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__CC__MS__NW_template::alerting__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW_template(ANY_VALUE);
else single_value.field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_alerting__MS__NW;
}

const PDU__ML3__Alerting__MS__NW_template& PDU__ML3__CC__MS__NW_template::alerting__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field alerting_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW) TTCN_error("Accessing non-selected field alerting_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_alerting__MS__NW;
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CC__MS__NW_template::callConfirmed()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_callConfirmed) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(ANY_VALUE);
else single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_callConfirmed;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_callConfirmed;
}

const PDU__ML3__CallConfirmed_template& PDU__ML3__CC__MS__NW_template::callConfirmed() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field callConfirmed in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_callConfirmed) TTCN_error("Accessing non-selected field callConfirmed in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_callConfirmed;
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__CC__MS__NW_template::connect__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_connect__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_connect__MS__NW = new PDU__ML3__Connect__MS__NW_template(ANY_VALUE);
else single_value.field_connect__MS__NW = new PDU__ML3__Connect__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_connect__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_connect__MS__NW;
}

const PDU__ML3__Connect__MS__NW_template& PDU__ML3__CC__MS__NW_template::connect__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field connect_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_connect__MS__NW) TTCN_error("Accessing non-selected field connect_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_connect__MS__NW;
}

PDU__ML3__ConnectAck_template& PDU__ML3__CC__MS__NW_template::connectAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_connectAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_connectAck = new PDU__ML3__ConnectAck_template(ANY_VALUE);
else single_value.field_connectAck = new PDU__ML3__ConnectAck_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_connectAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_connectAck;
}

const PDU__ML3__ConnectAck_template& PDU__ML3__CC__MS__NW_template::connectAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field connectAck in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_connectAck) TTCN_error("Accessing non-selected field connectAck in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_connectAck;
}

PDU__ML3__EmergencySetup_template& PDU__ML3__CC__MS__NW_template::emergencySetup()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_emergencySetup) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_emergencySetup = new PDU__ML3__EmergencySetup_template(ANY_VALUE);
else single_value.field_emergencySetup = new PDU__ML3__EmergencySetup_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_emergencySetup;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_emergencySetup;
}

const PDU__ML3__EmergencySetup_template& PDU__ML3__CC__MS__NW_template::emergencySetup() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field emergencySetup in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_emergencySetup) TTCN_error("Accessing non-selected field emergencySetup in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_emergencySetup;
}

PDU__ML3__CC__EstablishmentConf_template& PDU__ML3__CC__MS__NW_template::cc__EstablishmentConf()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf_template(ANY_VALUE);
else single_value.field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cc__EstablishmentConf;
}

const PDU__ML3__CC__EstablishmentConf_template& PDU__ML3__CC__MS__NW_template::cc__EstablishmentConf() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cc_EstablishmentConf in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf) TTCN_error("Accessing non-selected field cc_EstablishmentConf in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_cc__EstablishmentConf;
}

PDU__ML3__StartCC_template& PDU__ML3__CC__MS__NW_template::startCC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_startCC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_startCC = new PDU__ML3__StartCC_template(ANY_VALUE);
else single_value.field_startCC = new PDU__ML3__StartCC_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_startCC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_startCC;
}

const PDU__ML3__StartCC_template& PDU__ML3__CC__MS__NW_template::startCC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field startCC in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_startCC) TTCN_error("Accessing non-selected field startCC in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_startCC;
}

PDU__ML3__Setup__MS__NW_template& PDU__ML3__CC__MS__NW_template::setup__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_setup__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_setup__MS__NW = new PDU__ML3__Setup__MS__NW_template(ANY_VALUE);
else single_value.field_setup__MS__NW = new PDU__ML3__Setup__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_setup__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_setup__MS__NW;
}

const PDU__ML3__Setup__MS__NW_template& PDU__ML3__CC__MS__NW_template::setup__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field setup_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_setup__MS__NW) TTCN_error("Accessing non-selected field setup_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_setup__MS__NW;
}

PDU__ML3__Modify_template& PDU__ML3__CC__MS__NW_template::modify()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modify) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modify = new PDU__ML3__Modify_template(ANY_VALUE);
else single_value.field_modify = new PDU__ML3__Modify_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_modify;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modify;
}

const PDU__ML3__Modify_template& PDU__ML3__CC__MS__NW_template::modify() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modify in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modify) TTCN_error("Accessing non-selected field modify in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_modify;
}

PDU__ML3__ModifyComplete_template& PDU__ML3__CC__MS__NW_template::modifyComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modifyComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(ANY_VALUE);
else single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_modifyComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modifyComplete;
}

const PDU__ML3__ModifyComplete_template& PDU__ML3__CC__MS__NW_template::modifyComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modifyComplete in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modifyComplete) TTCN_error("Accessing non-selected field modifyComplete in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_modifyComplete;
}

PDU__ML3__ModifyReject_template& PDU__ML3__CC__MS__NW_template::modifyReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modifyReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(ANY_VALUE);
else single_value.field_modifyReject = new PDU__ML3__ModifyReject_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_modifyReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modifyReject;
}

const PDU__ML3__ModifyReject_template& PDU__ML3__CC__MS__NW_template::modifyReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modifyReject in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_modifyReject) TTCN_error("Accessing non-selected field modifyReject in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_modifyReject;
}

PDU__ML3__UserInformation_template& PDU__ML3__CC__MS__NW_template::userInformation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_userInformation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_userInformation = new PDU__ML3__UserInformation_template(ANY_VALUE);
else single_value.field_userInformation = new PDU__ML3__UserInformation_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_userInformation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_userInformation;
}

const PDU__ML3__UserInformation_template& PDU__ML3__CC__MS__NW_template::userInformation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field userInformation in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_userInformation) TTCN_error("Accessing non-selected field userInformation in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_userInformation;
}

PDU__ML3__Disconnect__MS__NW_template& PDU__ML3__CC__MS__NW_template::disconnect__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW_template(ANY_VALUE);
else single_value.field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_disconnect__MS__NW;
}

const PDU__ML3__Disconnect__MS__NW_template& PDU__ML3__CC__MS__NW_template::disconnect__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field disconnect_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW) TTCN_error("Accessing non-selected field disconnect_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_disconnect__MS__NW;
}

PDU__ML3__Release__MS__NW_template& PDU__ML3__CC__MS__NW_template::release__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_release__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_release__MS__NW = new PDU__ML3__Release__MS__NW_template(ANY_VALUE);
else single_value.field_release__MS__NW = new PDU__ML3__Release__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_release__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_release__MS__NW;
}

const PDU__ML3__Release__MS__NW_template& PDU__ML3__CC__MS__NW_template::release__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field release_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_release__MS__NW) TTCN_error("Accessing non-selected field release_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_release__MS__NW;
}

PDU__ML3__ReleaseComplete__MS__NW_template& PDU__ML3__CC__MS__NW_template::releaseComplete__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW_template(ANY_VALUE);
else single_value.field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_releaseComplete__MS__NW;
}

const PDU__ML3__ReleaseComplete__MS__NW_template& PDU__ML3__CC__MS__NW_template::releaseComplete__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field releaseComplete_MS_NW in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW) TTCN_error("Accessing non-selected field releaseComplete_MS_NW in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_releaseComplete__MS__NW;
}

PDU__ML3__Facility_template& PDU__ML3__CC__MS__NW_template::facility()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_facility) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_facility = new PDU__ML3__Facility_template(ANY_VALUE);
else single_value.field_facility = new PDU__ML3__Facility_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_facility;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_facility;
}

const PDU__ML3__Facility_template& PDU__ML3__CC__MS__NW_template::facility() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field facility in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_facility) TTCN_error("Accessing non-selected field facility in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_facility;
}

PDU__ML3__Hold_template& PDU__ML3__CC__MS__NW_template::hold()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_hold) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_hold = new PDU__ML3__Hold_template(ANY_VALUE);
else single_value.field_hold = new PDU__ML3__Hold_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_hold;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_hold;
}

const PDU__ML3__Hold_template& PDU__ML3__CC__MS__NW_template::hold() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field hold in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_hold) TTCN_error("Accessing non-selected field hold in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_hold;
}

PDU__ML3__Retrieve_template& PDU__ML3__CC__MS__NW_template::retrieve()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_retrieve) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_retrieve = new PDU__ML3__Retrieve_template(ANY_VALUE);
else single_value.field_retrieve = new PDU__ML3__Retrieve_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_retrieve;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_retrieve;
}

const PDU__ML3__Retrieve_template& PDU__ML3__CC__MS__NW_template::retrieve() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field retrieve in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_retrieve) TTCN_error("Accessing non-selected field retrieve in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_retrieve;
}

PDU__ML3__Notify_template& PDU__ML3__CC__MS__NW_template::notify()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_notify) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_notify = new PDU__ML3__Notify_template(ANY_VALUE);
else single_value.field_notify = new PDU__ML3__Notify_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_notify;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_notify;
}

const PDU__ML3__Notify_template& PDU__ML3__CC__MS__NW_template::notify() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field notify in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_notify) TTCN_error("Accessing non-selected field notify in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_notify;
}

PDU__ML3__StartDTMF_template& PDU__ML3__CC__MS__NW_template::startDTMF()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_startDTMF) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_startDTMF = new PDU__ML3__StartDTMF_template(ANY_VALUE);
else single_value.field_startDTMF = new PDU__ML3__StartDTMF_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_startDTMF;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_startDTMF;
}

const PDU__ML3__StartDTMF_template& PDU__ML3__CC__MS__NW_template::startDTMF() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field startDTMF in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_startDTMF) TTCN_error("Accessing non-selected field startDTMF in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_startDTMF;
}

PDU__ML3__Status_template& PDU__ML3__CC__MS__NW_template::status()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_status) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_status = new PDU__ML3__Status_template(ANY_VALUE);
else single_value.field_status = new PDU__ML3__Status_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_status;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_status;
}

const PDU__ML3__Status_template& PDU__ML3__CC__MS__NW_template::status() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field status in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_status) TTCN_error("Accessing non-selected field status in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_status;
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__CC__MS__NW_template::statusEnquiry()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_statusEnquiry) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(ANY_VALUE);
else single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_statusEnquiry;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_statusEnquiry;
}

const PDU__ML3__StatusEnquiry_template& PDU__ML3__CC__MS__NW_template::statusEnquiry() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field statusEnquiry in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_statusEnquiry) TTCN_error("Accessing non-selected field statusEnquiry in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_statusEnquiry;
}

PDU__ML3__StopDTMF_template& PDU__ML3__CC__MS__NW_template::stopDTMF()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_stopDTMF) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_stopDTMF = new PDU__ML3__StopDTMF_template(ANY_VALUE);
else single_value.field_stopDTMF = new PDU__ML3__StopDTMF_template;
single_value.union_selection = PDU__ML3__CC__MS__NW::ALT_stopDTMF;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_stopDTMF;
}

const PDU__ML3__StopDTMF_template& PDU__ML3__CC__MS__NW_template::stopDTMF() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field stopDTMF in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
if (single_value.union_selection != PDU__ML3__CC__MS__NW::ALT_stopDTMF) TTCN_error("Accessing non-selected field stopDTMF in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return *single_value.field_stopDTMF;
}

boolean PDU__ML3__CC__MS__NW_template::ischosen(PDU__ML3__CC__MS__NW::union_selection_type checked_selection) const
{
if (checked_selection == PDU__ML3__CC__MS__NW::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PDU__ML3__CC__MS__NW::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__CC__MS__NW_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
TTCN_Logger::log_event_str("{ alerting_MS_NW := ");
single_value.field_alerting__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
TTCN_Logger::log_event_str("{ callConfirmed := ");
single_value.field_callConfirmed->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
TTCN_Logger::log_event_str("{ connect_MS_NW := ");
single_value.field_connect__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
TTCN_Logger::log_event_str("{ connectAck := ");
single_value.field_connectAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
TTCN_Logger::log_event_str("{ emergencySetup := ");
single_value.field_emergencySetup->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
TTCN_Logger::log_event_str("{ cc_EstablishmentConf := ");
single_value.field_cc__EstablishmentConf->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
TTCN_Logger::log_event_str("{ startCC := ");
single_value.field_startCC->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
TTCN_Logger::log_event_str("{ setup_MS_NW := ");
single_value.field_setup__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
TTCN_Logger::log_event_str("{ modify := ");
single_value.field_modify->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
TTCN_Logger::log_event_str("{ modifyComplete := ");
single_value.field_modifyComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
TTCN_Logger::log_event_str("{ modifyReject := ");
single_value.field_modifyReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
TTCN_Logger::log_event_str("{ userInformation := ");
single_value.field_userInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
TTCN_Logger::log_event_str("{ disconnect_MS_NW := ");
single_value.field_disconnect__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
TTCN_Logger::log_event_str("{ release_MS_NW := ");
single_value.field_release__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
single_value.field_releaseComplete__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
TTCN_Logger::log_event_str("{ hold := ");
single_value.field_hold->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
TTCN_Logger::log_event_str("{ retrieve := ");
single_value.field_retrieve->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
TTCN_Logger::log_event_str("{ notify := ");
single_value.field_notify->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
TTCN_Logger::log_event_str("{ startDTMF := ");
single_value.field_startDTMF->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_status:
TTCN_Logger::log_event_str("{ status := ");
single_value.field_status->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
TTCN_Logger::log_event_str("{ statusEnquiry := ");
single_value.field_statusEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
TTCN_Logger::log_event_str("{ stopDTMF := ");
single_value.field_stopDTMF->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__CC__MS__NW_template::log_match(const PDU__ML3__CC__MS__NW& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".alerting_MS_NW");
single_value.field_alerting__MS__NW->log_match(match_value.alerting__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ alerting_MS_NW := ");
single_value.field_alerting__MS__NW->log_match(match_value.alerting__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".callConfirmed");
single_value.field_callConfirmed->log_match(match_value.callConfirmed(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ callConfirmed := ");
single_value.field_callConfirmed->log_match(match_value.callConfirmed(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".connect_MS_NW");
single_value.field_connect__MS__NW->log_match(match_value.connect__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ connect_MS_NW := ");
single_value.field_connect__MS__NW->log_match(match_value.connect__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".connectAck");
single_value.field_connectAck->log_match(match_value.connectAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ connectAck := ");
single_value.field_connectAck->log_match(match_value.connectAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".emergencySetup");
single_value.field_emergencySetup->log_match(match_value.emergencySetup(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ emergencySetup := ");
single_value.field_emergencySetup->log_match(match_value.emergencySetup(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cc_EstablishmentConf");
single_value.field_cc__EstablishmentConf->log_match(match_value.cc__EstablishmentConf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cc_EstablishmentConf := ");
single_value.field_cc__EstablishmentConf->log_match(match_value.cc__EstablishmentConf(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".startCC");
single_value.field_startCC->log_match(match_value.startCC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ startCC := ");
single_value.field_startCC->log_match(match_value.startCC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".setup_MS_NW");
single_value.field_setup__MS__NW->log_match(match_value.setup__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ setup_MS_NW := ");
single_value.field_setup__MS__NW->log_match(match_value.setup__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modify");
single_value.field_modify->log_match(match_value.modify(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modify := ");
single_value.field_modify->log_match(match_value.modify(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modifyComplete");
single_value.field_modifyComplete->log_match(match_value.modifyComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modifyComplete := ");
single_value.field_modifyComplete->log_match(match_value.modifyComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modifyReject");
single_value.field_modifyReject->log_match(match_value.modifyReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modifyReject := ");
single_value.field_modifyReject->log_match(match_value.modifyReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".userInformation");
single_value.field_userInformation->log_match(match_value.userInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ userInformation := ");
single_value.field_userInformation->log_match(match_value.userInformation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".disconnect_MS_NW");
single_value.field_disconnect__MS__NW->log_match(match_value.disconnect__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ disconnect_MS_NW := ");
single_value.field_disconnect__MS__NW->log_match(match_value.disconnect__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".release_MS_NW");
single_value.field_release__MS__NW->log_match(match_value.release__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ release_MS_NW := ");
single_value.field_release__MS__NW->log_match(match_value.release__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".releaseComplete_MS_NW");
single_value.field_releaseComplete__MS__NW->log_match(match_value.releaseComplete__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
single_value.field_releaseComplete__MS__NW->log_match(match_value.releaseComplete__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".facility");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".hold");
single_value.field_hold->log_match(match_value.hold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ hold := ");
single_value.field_hold->log_match(match_value.hold(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".retrieve");
single_value.field_retrieve->log_match(match_value.retrieve(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ retrieve := ");
single_value.field_retrieve->log_match(match_value.retrieve(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".notify");
single_value.field_notify->log_match(match_value.notify(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ notify := ");
single_value.field_notify->log_match(match_value.notify(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".startDTMF");
single_value.field_startDTMF->log_match(match_value.startDTMF(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ startDTMF := ");
single_value.field_startDTMF->log_match(match_value.startDTMF(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_status:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".status");
single_value.field_status->log_match(match_value.status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ status := ");
single_value.field_status->log_match(match_value.status(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".statusEnquiry");
single_value.field_statusEnquiry->log_match(match_value.statusEnquiry(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ statusEnquiry := ");
single_value.field_statusEnquiry->log_match(match_value.statusEnquiry(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".stopDTMF");
single_value.field_stopDTMF->log_match(match_value.stopDTMF(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ stopDTMF := ");
single_value.field_stopDTMF->log_match(match_value.stopDTMF(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__CC__MS__NW_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry->set_implicit_omit(); break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__CC__MS__NW_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry->encode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}

void PDU__ML3__CC__MS__NW_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PDU__ML3__CC__MS__NW::UNBOUND_VALUE;
PDU__ML3__CC__MS__NW::union_selection_type new_selection = (PDU__ML3__CC__MS__NW::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW = new PDU__ML3__Alerting__MS__NW_template;
single_value.field_alerting__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template;
single_value.field_callConfirmed->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW = new PDU__ML3__Connect__MS__NW_template;
single_value.field_connect__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template;
single_value.field_connectAck->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup = new PDU__ML3__EmergencySetup_template;
single_value.field_emergencySetup->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf = new PDU__ML3__CC__EstablishmentConf_template;
single_value.field_cc__EstablishmentConf->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC = new PDU__ML3__StartCC_template;
single_value.field_startCC->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW = new PDU__ML3__Setup__MS__NW_template;
single_value.field_setup__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template;
single_value.field_modify->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template;
single_value.field_modifyComplete->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template;
single_value.field_modifyReject->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template;
single_value.field_userInformation->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW = new PDU__ML3__Disconnect__MS__NW_template;
single_value.field_disconnect__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW = new PDU__ML3__Release__MS__NW_template;
single_value.field_release__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__ReleaseComplete__MS__NW_template;
single_value.field_releaseComplete__MS__NW->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template;
single_value.field_facility->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold = new PDU__ML3__Hold_template;
single_value.field_hold->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve = new PDU__ML3__Retrieve_template;
single_value.field_retrieve->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template;
single_value.field_notify->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF = new PDU__ML3__StartDTMF_template;
single_value.field_startDTMF->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status = new PDU__ML3__Status_template;
single_value.field_status->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template;
single_value.field_statusEnquiry->decode_text(text_buf);
break;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF = new PDU__ML3__StopDTMF_template;
single_value.field_stopDTMF->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__CC__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
}

boolean PDU__ML3__CC__MS__NW_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__CC__MS__NW_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__CC__MS__NW_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MobileL3_CC_Types.PDU_ML3_CC_MS_NW'");
    }
    if (strcmp("alerting_MS_NW", param_field) == 0) {
      alerting__MS__NW().set_param(param);
      return;
    } else if (strcmp("callConfirmed", param_field) == 0) {
      callConfirmed().set_param(param);
      return;
    } else if (strcmp("connect_MS_NW", param_field) == 0) {
      connect__MS__NW().set_param(param);
      return;
    } else if (strcmp("connectAck", param_field) == 0) {
      connectAck().set_param(param);
      return;
    } else if (strcmp("emergencySetup", param_field) == 0) {
      emergencySetup().set_param(param);
      return;
    } else if (strcmp("cc_EstablishmentConf", param_field) == 0) {
      cc__EstablishmentConf().set_param(param);
      return;
    } else if (strcmp("startCC", param_field) == 0) {
      startCC().set_param(param);
      return;
    } else if (strcmp("setup_MS_NW", param_field) == 0) {
      setup__MS__NW().set_param(param);
      return;
    } else if (strcmp("modify", param_field) == 0) {
      modify().set_param(param);
      return;
    } else if (strcmp("modifyComplete", param_field) == 0) {
      modifyComplete().set_param(param);
      return;
    } else if (strcmp("modifyReject", param_field) == 0) {
      modifyReject().set_param(param);
      return;
    } else if (strcmp("userInformation", param_field) == 0) {
      userInformation().set_param(param);
      return;
    } else if (strcmp("disconnect_MS_NW", param_field) == 0) {
      disconnect__MS__NW().set_param(param);
      return;
    } else if (strcmp("release_MS_NW", param_field) == 0) {
      release__MS__NW().set_param(param);
      return;
    } else if (strcmp("releaseComplete_MS_NW", param_field) == 0) {
      releaseComplete__MS__NW().set_param(param);
      return;
    } else if (strcmp("facility", param_field) == 0) {
      facility().set_param(param);
      return;
    } else if (strcmp("hold", param_field) == 0) {
      hold().set_param(param);
      return;
    } else if (strcmp("retrieve", param_field) == 0) {
      retrieve().set_param(param);
      return;
    } else if (strcmp("notify", param_field) == 0) {
      notify().set_param(param);
      return;
    } else if (strcmp("startDTMF", param_field) == 0) {
      startDTMF().set_param(param);
      return;
    } else if (strcmp("status", param_field) == 0) {
      status().set_param(param);
      return;
    } else if (strcmp("statusEnquiry", param_field) == 0) {
      statusEnquiry().set_param(param);
      return;
    } else if (strcmp("stopDTMF", param_field) == 0) {
      stopDTMF().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MobileL3_CC_Types.PDU_ML3_CC_MS_NW'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__CC__MS__NW_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "alerting_MS_NW")) {
      alerting__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "callConfirmed")) {
      callConfirmed().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "connect_MS_NW")) {
      connect__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "connectAck")) {
      connectAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "emergencySetup")) {
      emergencySetup().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cc_EstablishmentConf")) {
      cc__EstablishmentConf().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "startCC")) {
      startCC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "setup_MS_NW")) {
      setup__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modify")) {
      modify().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modifyComplete")) {
      modifyComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modifyReject")) {
      modifyReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "userInformation")) {
      userInformation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "disconnect_MS_NW")) {
      disconnect__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "release_MS_NW")) {
      release__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "releaseComplete_MS_NW")) {
      releaseComplete__MS__NW().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "facility")) {
      facility().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "hold")) {
      hold().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "retrieve")) {
      retrieve().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "notify")) {
      notify().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "startDTMF")) {
      startDTMF().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "status")) {
      status().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "statusEnquiry")) {
      statusEnquiry().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "stopDTMF")) {
      stopDTMF().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__CC__MS__NW_template* precondition = new PDU__ML3__CC__MS__NW_template;
    precondition->set_param(*m_p->get_elem(0));
    PDU__ML3__CC__MS__NW_template* implied_template = new PDU__ML3__CC__MS__NW_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PDU__ML3__CC__MS__NW_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__CC__MS__NW_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PDU__ML3__CC__MS__NW::ALT_alerting__MS__NW:
single_value.field_alerting__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_callConfirmed:
single_value.field_callConfirmed->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_connect__MS__NW:
single_value.field_connect__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_connectAck:
single_value.field_connectAck->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_emergencySetup:
single_value.field_emergencySetup->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_cc__EstablishmentConf:
single_value.field_cc__EstablishmentConf->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_startCC:
single_value.field_startCC->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_setup__MS__NW:
single_value.field_setup__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_modify:
single_value.field_modify->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_modifyComplete:
single_value.field_modifyComplete->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_modifyReject:
single_value.field_modifyReject->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_userInformation:
single_value.field_userInformation->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_disconnect__MS__NW:
single_value.field_disconnect__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_release__MS__NW:
single_value.field_release__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_facility:
single_value.field_facility->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_hold:
single_value.field_hold->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_retrieve:
single_value.field_retrieve->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_notify:
single_value.field_notify->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_startDTMF:
single_value.field_startDTMF->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_status:
single_value.field_status->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_statusEnquiry:
single_value.field_statusEnquiry->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
case PDU__ML3__CC__MS__NW::ALT_stopDTMF:
single_value.field_stopDTMF->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_MS_NW.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_MS_NW");
}

void PDU__ML3__CC__NW__MS::copy_value(const PDU__ML3__CC__NW__MS& other_value)
{
switch (other_value.union_selection) {
case ALT_alerting__NW__MS:
field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS(*other_value.field_alerting__NW__MS);
break;
case ALT_callConfirmed:
field_callConfirmed = new PDU__ML3__CallConfirmed(*other_value.field_callConfirmed);
break;
case ALT_callProceeding:
field_callProceeding = new PDU__ML3__CallProceeding(*other_value.field_callProceeding);
break;
case ALT_connect__NW__MS:
field_connect__NW__MS = new PDU__ML3__Connect__NW__MS(*other_value.field_connect__NW__MS);
break;
case ALT_connectAck:
field_connectAck = new PDU__ML3__ConnectAck(*other_value.field_connectAck);
break;
case ALT_progress:
field_progress = new PDU__ML3__Progress(*other_value.field_progress);
break;
case ALT_cc__Establishment:
field_cc__Establishment = new PDU__ML3__CC__Establishment(*other_value.field_cc__Establishment);
break;
case ALT_setup__NW__MS:
field_setup__NW__MS = new PDU__ML3__Setup__NW__MS(*other_value.field_setup__NW__MS);
break;
case ALT_modify:
field_modify = new PDU__ML3__Modify(*other_value.field_modify);
break;
case ALT_modifyComplete:
field_modifyComplete = new PDU__ML3__ModifyComplete(*other_value.field_modifyComplete);
break;
case ALT_modifyReject:
field_modifyReject = new PDU__ML3__ModifyReject(*other_value.field_modifyReject);
break;
case ALT_userInformation:
field_userInformation = new PDU__ML3__UserInformation(*other_value.field_userInformation);
break;
case ALT_disconnect__NW__MS:
field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS(*other_value.field_disconnect__NW__MS);
break;
case ALT_release__NW__MS:
field_release__NW__MS = new PDU__ML3__Release__NW__MS(*other_value.field_release__NW__MS);
break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS(*other_value.field_releaseComplete__NW__MS);
break;
case ALT_facility:
field_facility = new PDU__ML3__Facility(*other_value.field_facility);
break;
case ALT_holdAcknowledge:
field_holdAcknowledge = new PDU__ML3__HoldAcknowledge(*other_value.field_holdAcknowledge);
break;
case ALT_holdReject:
field_holdReject = new PDU__ML3__HoldReject(*other_value.field_holdReject);
break;
case ALT_retrieveAck:
field_retrieveAck = new PDU__ML3__RetrieveAck(*other_value.field_retrieveAck);
break;
case ALT_retrieveRej:
field_retrieveRej = new PDU__ML3__RetrieveRej(*other_value.field_retrieveRej);
break;
case ALT_congestionControl:
field_congestionControl = new PDU__ML3__CongestionControl(*other_value.field_congestionControl);
break;
case ALT_notify:
field_notify = new PDU__ML3__Notify(*other_value.field_notify);
break;
case ALT_startDTMFAck:
field_startDTMFAck = new PDU__ML3__StartDTMFAck(*other_value.field_startDTMFAck);
break;
case ALT_startDTMFRej:
field_startDTMFRej = new PDU__ML3__StartDTMFRej(*other_value.field_startDTMFRej);
break;
case ALT_status:
field_status = new PDU__ML3__Status(*other_value.field_status);
break;
case ALT_statusEnquiry:
field_statusEnquiry = new PDU__ML3__StatusEnquiry(*other_value.field_statusEnquiry);
break;
case ALT_stopDTMFAck:
field_stopDTMFAck = new PDU__ML3__StopDTMFAck(*other_value.field_stopDTMFAck);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
union_selection = other_value.union_selection;
}

PDU__ML3__CC__NW__MS::PDU__ML3__CC__NW__MS()
{
union_selection = UNBOUND_VALUE;
}

PDU__ML3__CC__NW__MS::PDU__ML3__CC__NW__MS(const PDU__ML3__CC__NW__MS& other_value)
: Base_Type(){
copy_value(other_value);
}

PDU__ML3__CC__NW__MS::~PDU__ML3__CC__NW__MS()
{
clean_up();
}

PDU__ML3__CC__NW__MS& PDU__ML3__CC__NW__MS::operator=(const PDU__ML3__CC__NW__MS& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PDU__ML3__CC__NW__MS::operator==(const PDU__ML3__CC__NW__MS& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_alerting__NW__MS:
return *field_alerting__NW__MS == *other_value.field_alerting__NW__MS;
case ALT_callConfirmed:
return *field_callConfirmed == *other_value.field_callConfirmed;
case ALT_callProceeding:
return *field_callProceeding == *other_value.field_callProceeding;
case ALT_connect__NW__MS:
return *field_connect__NW__MS == *other_value.field_connect__NW__MS;
case ALT_connectAck:
return *field_connectAck == *other_value.field_connectAck;
case ALT_progress:
return *field_progress == *other_value.field_progress;
case ALT_cc__Establishment:
return *field_cc__Establishment == *other_value.field_cc__Establishment;
case ALT_setup__NW__MS:
return *field_setup__NW__MS == *other_value.field_setup__NW__MS;
case ALT_modify:
return *field_modify == *other_value.field_modify;
case ALT_modifyComplete:
return *field_modifyComplete == *other_value.field_modifyComplete;
case ALT_modifyReject:
return *field_modifyReject == *other_value.field_modifyReject;
case ALT_userInformation:
return *field_userInformation == *other_value.field_userInformation;
case ALT_disconnect__NW__MS:
return *field_disconnect__NW__MS == *other_value.field_disconnect__NW__MS;
case ALT_release__NW__MS:
return *field_release__NW__MS == *other_value.field_release__NW__MS;
case ALT_releaseComplete__NW__MS:
return *field_releaseComplete__NW__MS == *other_value.field_releaseComplete__NW__MS;
case ALT_facility:
return *field_facility == *other_value.field_facility;
case ALT_holdAcknowledge:
return *field_holdAcknowledge == *other_value.field_holdAcknowledge;
case ALT_holdReject:
return *field_holdReject == *other_value.field_holdReject;
case ALT_retrieveAck:
return *field_retrieveAck == *other_value.field_retrieveAck;
case ALT_retrieveRej:
return *field_retrieveRej == *other_value.field_retrieveRej;
case ALT_congestionControl:
return *field_congestionControl == *other_value.field_congestionControl;
case ALT_notify:
return *field_notify == *other_value.field_notify;
case ALT_startDTMFAck:
return *field_startDTMFAck == *other_value.field_startDTMFAck;
case ALT_startDTMFRej:
return *field_startDTMFRej == *other_value.field_startDTMFRej;
case ALT_status:
return *field_status == *other_value.field_status;
case ALT_statusEnquiry:
return *field_statusEnquiry == *other_value.field_statusEnquiry;
case ALT_stopDTMFAck:
return *field_stopDTMFAck == *other_value.field_stopDTMFAck;
default:
return FALSE;
}
}

PDU__ML3__Alerting__NW__MS& PDU__ML3__CC__NW__MS::alerting__NW__MS()
{
if (union_selection != ALT_alerting__NW__MS) {
clean_up();
field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS;
union_selection = ALT_alerting__NW__MS;
}
return *field_alerting__NW__MS;
}

const PDU__ML3__Alerting__NW__MS& PDU__ML3__CC__NW__MS::alerting__NW__MS() const
{
if (union_selection != ALT_alerting__NW__MS) TTCN_error("Using non-selected field alerting_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_alerting__NW__MS;
}

PDU__ML3__CallConfirmed& PDU__ML3__CC__NW__MS::callConfirmed()
{
if (union_selection != ALT_callConfirmed) {
clean_up();
field_callConfirmed = new PDU__ML3__CallConfirmed;
union_selection = ALT_callConfirmed;
}
return *field_callConfirmed;
}

const PDU__ML3__CallConfirmed& PDU__ML3__CC__NW__MS::callConfirmed() const
{
if (union_selection != ALT_callConfirmed) TTCN_error("Using non-selected field callConfirmed in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_callConfirmed;
}

PDU__ML3__CallProceeding& PDU__ML3__CC__NW__MS::callProceeding()
{
if (union_selection != ALT_callProceeding) {
clean_up();
field_callProceeding = new PDU__ML3__CallProceeding;
union_selection = ALT_callProceeding;
}
return *field_callProceeding;
}

const PDU__ML3__CallProceeding& PDU__ML3__CC__NW__MS::callProceeding() const
{
if (union_selection != ALT_callProceeding) TTCN_error("Using non-selected field callProceeding in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_callProceeding;
}

PDU__ML3__Connect__NW__MS& PDU__ML3__CC__NW__MS::connect__NW__MS()
{
if (union_selection != ALT_connect__NW__MS) {
clean_up();
field_connect__NW__MS = new PDU__ML3__Connect__NW__MS;
union_selection = ALT_connect__NW__MS;
}
return *field_connect__NW__MS;
}

const PDU__ML3__Connect__NW__MS& PDU__ML3__CC__NW__MS::connect__NW__MS() const
{
if (union_selection != ALT_connect__NW__MS) TTCN_error("Using non-selected field connect_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_connect__NW__MS;
}

PDU__ML3__ConnectAck& PDU__ML3__CC__NW__MS::connectAck()
{
if (union_selection != ALT_connectAck) {
clean_up();
field_connectAck = new PDU__ML3__ConnectAck;
union_selection = ALT_connectAck;
}
return *field_connectAck;
}

const PDU__ML3__ConnectAck& PDU__ML3__CC__NW__MS::connectAck() const
{
if (union_selection != ALT_connectAck) TTCN_error("Using non-selected field connectAck in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_connectAck;
}

PDU__ML3__Progress& PDU__ML3__CC__NW__MS::progress()
{
if (union_selection != ALT_progress) {
clean_up();
field_progress = new PDU__ML3__Progress;
union_selection = ALT_progress;
}
return *field_progress;
}

const PDU__ML3__Progress& PDU__ML3__CC__NW__MS::progress() const
{
if (union_selection != ALT_progress) TTCN_error("Using non-selected field progress in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_progress;
}

PDU__ML3__CC__Establishment& PDU__ML3__CC__NW__MS::cc__Establishment()
{
if (union_selection != ALT_cc__Establishment) {
clean_up();
field_cc__Establishment = new PDU__ML3__CC__Establishment;
union_selection = ALT_cc__Establishment;
}
return *field_cc__Establishment;
}

const PDU__ML3__CC__Establishment& PDU__ML3__CC__NW__MS::cc__Establishment() const
{
if (union_selection != ALT_cc__Establishment) TTCN_error("Using non-selected field cc_Establishment in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_cc__Establishment;
}

PDU__ML3__Setup__NW__MS& PDU__ML3__CC__NW__MS::setup__NW__MS()
{
if (union_selection != ALT_setup__NW__MS) {
clean_up();
field_setup__NW__MS = new PDU__ML3__Setup__NW__MS;
union_selection = ALT_setup__NW__MS;
}
return *field_setup__NW__MS;
}

const PDU__ML3__Setup__NW__MS& PDU__ML3__CC__NW__MS::setup__NW__MS() const
{
if (union_selection != ALT_setup__NW__MS) TTCN_error("Using non-selected field setup_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_setup__NW__MS;
}

PDU__ML3__Modify& PDU__ML3__CC__NW__MS::modify()
{
if (union_selection != ALT_modify) {
clean_up();
field_modify = new PDU__ML3__Modify;
union_selection = ALT_modify;
}
return *field_modify;
}

const PDU__ML3__Modify& PDU__ML3__CC__NW__MS::modify() const
{
if (union_selection != ALT_modify) TTCN_error("Using non-selected field modify in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_modify;
}

PDU__ML3__ModifyComplete& PDU__ML3__CC__NW__MS::modifyComplete()
{
if (union_selection != ALT_modifyComplete) {
clean_up();
field_modifyComplete = new PDU__ML3__ModifyComplete;
union_selection = ALT_modifyComplete;
}
return *field_modifyComplete;
}

const PDU__ML3__ModifyComplete& PDU__ML3__CC__NW__MS::modifyComplete() const
{
if (union_selection != ALT_modifyComplete) TTCN_error("Using non-selected field modifyComplete in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_modifyComplete;
}

PDU__ML3__ModifyReject& PDU__ML3__CC__NW__MS::modifyReject()
{
if (union_selection != ALT_modifyReject) {
clean_up();
field_modifyReject = new PDU__ML3__ModifyReject;
union_selection = ALT_modifyReject;
}
return *field_modifyReject;
}

const PDU__ML3__ModifyReject& PDU__ML3__CC__NW__MS::modifyReject() const
{
if (union_selection != ALT_modifyReject) TTCN_error("Using non-selected field modifyReject in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_modifyReject;
}

PDU__ML3__UserInformation& PDU__ML3__CC__NW__MS::userInformation()
{
if (union_selection != ALT_userInformation) {
clean_up();
field_userInformation = new PDU__ML3__UserInformation;
union_selection = ALT_userInformation;
}
return *field_userInformation;
}

const PDU__ML3__UserInformation& PDU__ML3__CC__NW__MS::userInformation() const
{
if (union_selection != ALT_userInformation) TTCN_error("Using non-selected field userInformation in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_userInformation;
}

PDU__ML3__Disconnect__NW__MS& PDU__ML3__CC__NW__MS::disconnect__NW__MS()
{
if (union_selection != ALT_disconnect__NW__MS) {
clean_up();
field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS;
union_selection = ALT_disconnect__NW__MS;
}
return *field_disconnect__NW__MS;
}

const PDU__ML3__Disconnect__NW__MS& PDU__ML3__CC__NW__MS::disconnect__NW__MS() const
{
if (union_selection != ALT_disconnect__NW__MS) TTCN_error("Using non-selected field disconnect_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_disconnect__NW__MS;
}

PDU__ML3__Release__NW__MS& PDU__ML3__CC__NW__MS::release__NW__MS()
{
if (union_selection != ALT_release__NW__MS) {
clean_up();
field_release__NW__MS = new PDU__ML3__Release__NW__MS;
union_selection = ALT_release__NW__MS;
}
return *field_release__NW__MS;
}

const PDU__ML3__Release__NW__MS& PDU__ML3__CC__NW__MS::release__NW__MS() const
{
if (union_selection != ALT_release__NW__MS) TTCN_error("Using non-selected field release_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_release__NW__MS;
}

PDU__ML3__ReleaseComplete__NW__MS& PDU__ML3__CC__NW__MS::releaseComplete__NW__MS()
{
if (union_selection != ALT_releaseComplete__NW__MS) {
clean_up();
field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS;
union_selection = ALT_releaseComplete__NW__MS;
}
return *field_releaseComplete__NW__MS;
}

const PDU__ML3__ReleaseComplete__NW__MS& PDU__ML3__CC__NW__MS::releaseComplete__NW__MS() const
{
if (union_selection != ALT_releaseComplete__NW__MS) TTCN_error("Using non-selected field releaseComplete_NW_MS in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_releaseComplete__NW__MS;
}

PDU__ML3__Facility& PDU__ML3__CC__NW__MS::facility()
{
if (union_selection != ALT_facility) {
clean_up();
field_facility = new PDU__ML3__Facility;
union_selection = ALT_facility;
}
return *field_facility;
}

const PDU__ML3__Facility& PDU__ML3__CC__NW__MS::facility() const
{
if (union_selection != ALT_facility) TTCN_error("Using non-selected field facility in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_facility;
}

PDU__ML3__HoldAcknowledge& PDU__ML3__CC__NW__MS::holdAcknowledge()
{
if (union_selection != ALT_holdAcknowledge) {
clean_up();
field_holdAcknowledge = new PDU__ML3__HoldAcknowledge;
union_selection = ALT_holdAcknowledge;
}
return *field_holdAcknowledge;
}

const PDU__ML3__HoldAcknowledge& PDU__ML3__CC__NW__MS::holdAcknowledge() const
{
if (union_selection != ALT_holdAcknowledge) TTCN_error("Using non-selected field holdAcknowledge in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_holdAcknowledge;
}

PDU__ML3__HoldReject& PDU__ML3__CC__NW__MS::holdReject()
{
if (union_selection != ALT_holdReject) {
clean_up();
field_holdReject = new PDU__ML3__HoldReject;
union_selection = ALT_holdReject;
}
return *field_holdReject;
}

const PDU__ML3__HoldReject& PDU__ML3__CC__NW__MS::holdReject() const
{
if (union_selection != ALT_holdReject) TTCN_error("Using non-selected field holdReject in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_holdReject;
}

PDU__ML3__RetrieveAck& PDU__ML3__CC__NW__MS::retrieveAck()
{
if (union_selection != ALT_retrieveAck) {
clean_up();
field_retrieveAck = new PDU__ML3__RetrieveAck;
union_selection = ALT_retrieveAck;
}
return *field_retrieveAck;
}

const PDU__ML3__RetrieveAck& PDU__ML3__CC__NW__MS::retrieveAck() const
{
if (union_selection != ALT_retrieveAck) TTCN_error("Using non-selected field retrieveAck in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_retrieveAck;
}

PDU__ML3__RetrieveRej& PDU__ML3__CC__NW__MS::retrieveRej()
{
if (union_selection != ALT_retrieveRej) {
clean_up();
field_retrieveRej = new PDU__ML3__RetrieveRej;
union_selection = ALT_retrieveRej;
}
return *field_retrieveRej;
}

const PDU__ML3__RetrieveRej& PDU__ML3__CC__NW__MS::retrieveRej() const
{
if (union_selection != ALT_retrieveRej) TTCN_error("Using non-selected field retrieveRej in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_retrieveRej;
}

PDU__ML3__CongestionControl& PDU__ML3__CC__NW__MS::congestionControl()
{
if (union_selection != ALT_congestionControl) {
clean_up();
field_congestionControl = new PDU__ML3__CongestionControl;
union_selection = ALT_congestionControl;
}
return *field_congestionControl;
}

const PDU__ML3__CongestionControl& PDU__ML3__CC__NW__MS::congestionControl() const
{
if (union_selection != ALT_congestionControl) TTCN_error("Using non-selected field congestionControl in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_congestionControl;
}

PDU__ML3__Notify& PDU__ML3__CC__NW__MS::notify()
{
if (union_selection != ALT_notify) {
clean_up();
field_notify = new PDU__ML3__Notify;
union_selection = ALT_notify;
}
return *field_notify;
}

const PDU__ML3__Notify& PDU__ML3__CC__NW__MS::notify() const
{
if (union_selection != ALT_notify) TTCN_error("Using non-selected field notify in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_notify;
}

PDU__ML3__StartDTMFAck& PDU__ML3__CC__NW__MS::startDTMFAck()
{
if (union_selection != ALT_startDTMFAck) {
clean_up();
field_startDTMFAck = new PDU__ML3__StartDTMFAck;
union_selection = ALT_startDTMFAck;
}
return *field_startDTMFAck;
}

const PDU__ML3__StartDTMFAck& PDU__ML3__CC__NW__MS::startDTMFAck() const
{
if (union_selection != ALT_startDTMFAck) TTCN_error("Using non-selected field startDTMFAck in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_startDTMFAck;
}

PDU__ML3__StartDTMFRej& PDU__ML3__CC__NW__MS::startDTMFRej()
{
if (union_selection != ALT_startDTMFRej) {
clean_up();
field_startDTMFRej = new PDU__ML3__StartDTMFRej;
union_selection = ALT_startDTMFRej;
}
return *field_startDTMFRej;
}

const PDU__ML3__StartDTMFRej& PDU__ML3__CC__NW__MS::startDTMFRej() const
{
if (union_selection != ALT_startDTMFRej) TTCN_error("Using non-selected field startDTMFRej in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_startDTMFRej;
}

PDU__ML3__Status& PDU__ML3__CC__NW__MS::status()
{
if (union_selection != ALT_status) {
clean_up();
field_status = new PDU__ML3__Status;
union_selection = ALT_status;
}
return *field_status;
}

const PDU__ML3__Status& PDU__ML3__CC__NW__MS::status() const
{
if (union_selection != ALT_status) TTCN_error("Using non-selected field status in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_status;
}

PDU__ML3__StatusEnquiry& PDU__ML3__CC__NW__MS::statusEnquiry()
{
if (union_selection != ALT_statusEnquiry) {
clean_up();
field_statusEnquiry = new PDU__ML3__StatusEnquiry;
union_selection = ALT_statusEnquiry;
}
return *field_statusEnquiry;
}

const PDU__ML3__StatusEnquiry& PDU__ML3__CC__NW__MS::statusEnquiry() const
{
if (union_selection != ALT_statusEnquiry) TTCN_error("Using non-selected field statusEnquiry in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_statusEnquiry;
}

PDU__ML3__StopDTMFAck& PDU__ML3__CC__NW__MS::stopDTMFAck()
{
if (union_selection != ALT_stopDTMFAck) {
clean_up();
field_stopDTMFAck = new PDU__ML3__StopDTMFAck;
union_selection = ALT_stopDTMFAck;
}
return *field_stopDTMFAck;
}

const PDU__ML3__StopDTMFAck& PDU__ML3__CC__NW__MS::stopDTMFAck() const
{
if (union_selection != ALT_stopDTMFAck) TTCN_error("Using non-selected field stopDTMFAck in a value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *field_stopDTMFAck;
}

boolean PDU__ML3__CC__NW__MS::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return union_selection == checked_selection;
}

boolean PDU__ML3__CC__NW__MS::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PDU__ML3__CC__NW__MS::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_alerting__NW__MS: return field_alerting__NW__MS->is_value();
case ALT_callConfirmed: return field_callConfirmed->is_value();
case ALT_callProceeding: return field_callProceeding->is_value();
case ALT_connect__NW__MS: return field_connect__NW__MS->is_value();
case ALT_connectAck: return field_connectAck->is_value();
case ALT_progress: return field_progress->is_value();
case ALT_cc__Establishment: return field_cc__Establishment->is_value();
case ALT_setup__NW__MS: return field_setup__NW__MS->is_value();
case ALT_modify: return field_modify->is_value();
case ALT_modifyComplete: return field_modifyComplete->is_value();
case ALT_modifyReject: return field_modifyReject->is_value();
case ALT_userInformation: return field_userInformation->is_value();
case ALT_disconnect__NW__MS: return field_disconnect__NW__MS->is_value();
case ALT_release__NW__MS: return field_release__NW__MS->is_value();
case ALT_releaseComplete__NW__MS: return field_releaseComplete__NW__MS->is_value();
case ALT_facility: return field_facility->is_value();
case ALT_holdAcknowledge: return field_holdAcknowledge->is_value();
case ALT_holdReject: return field_holdReject->is_value();
case ALT_retrieveAck: return field_retrieveAck->is_value();
case ALT_retrieveRej: return field_retrieveRej->is_value();
case ALT_congestionControl: return field_congestionControl->is_value();
case ALT_notify: return field_notify->is_value();
case ALT_startDTMFAck: return field_startDTMFAck->is_value();
case ALT_startDTMFRej: return field_startDTMFRej->is_value();
case ALT_status: return field_status->is_value();
case ALT_statusEnquiry: return field_statusEnquiry->is_value();
case ALT_stopDTMFAck: return field_stopDTMFAck->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PDU__ML3__CC__NW__MS::clean_up()
{
switch (union_selection) {
case ALT_alerting__NW__MS:
  delete field_alerting__NW__MS;
  break;
case ALT_callConfirmed:
  delete field_callConfirmed;
  break;
case ALT_callProceeding:
  delete field_callProceeding;
  break;
case ALT_connect__NW__MS:
  delete field_connect__NW__MS;
  break;
case ALT_connectAck:
  delete field_connectAck;
  break;
case ALT_progress:
  delete field_progress;
  break;
case ALT_cc__Establishment:
  delete field_cc__Establishment;
  break;
case ALT_setup__NW__MS:
  delete field_setup__NW__MS;
  break;
case ALT_modify:
  delete field_modify;
  break;
case ALT_modifyComplete:
  delete field_modifyComplete;
  break;
case ALT_modifyReject:
  delete field_modifyReject;
  break;
case ALT_userInformation:
  delete field_userInformation;
  break;
case ALT_disconnect__NW__MS:
  delete field_disconnect__NW__MS;
  break;
case ALT_release__NW__MS:
  delete field_release__NW__MS;
  break;
case ALT_releaseComplete__NW__MS:
  delete field_releaseComplete__NW__MS;
  break;
case ALT_facility:
  delete field_facility;
  break;
case ALT_holdAcknowledge:
  delete field_holdAcknowledge;
  break;
case ALT_holdReject:
  delete field_holdReject;
  break;
case ALT_retrieveAck:
  delete field_retrieveAck;
  break;
case ALT_retrieveRej:
  delete field_retrieveRej;
  break;
case ALT_congestionControl:
  delete field_congestionControl;
  break;
case ALT_notify:
  delete field_notify;
  break;
case ALT_startDTMFAck:
  delete field_startDTMFAck;
  break;
case ALT_startDTMFRej:
  delete field_startDTMFRej;
  break;
case ALT_status:
  delete field_status;
  break;
case ALT_statusEnquiry:
  delete field_statusEnquiry;
  break;
case ALT_stopDTMFAck:
  delete field_stopDTMFAck;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PDU__ML3__CC__NW__MS::log() const
{
switch (union_selection) {
case ALT_alerting__NW__MS:
TTCN_Logger::log_event_str("{ alerting_NW_MS := ");
field_alerting__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_callConfirmed:
TTCN_Logger::log_event_str("{ callConfirmed := ");
field_callConfirmed->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_callProceeding:
TTCN_Logger::log_event_str("{ callProceeding := ");
field_callProceeding->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_connect__NW__MS:
TTCN_Logger::log_event_str("{ connect_NW_MS := ");
field_connect__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_connectAck:
TTCN_Logger::log_event_str("{ connectAck := ");
field_connectAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_progress:
TTCN_Logger::log_event_str("{ progress := ");
field_progress->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cc__Establishment:
TTCN_Logger::log_event_str("{ cc_Establishment := ");
field_cc__Establishment->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_setup__NW__MS:
TTCN_Logger::log_event_str("{ setup_NW_MS := ");
field_setup__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modify:
TTCN_Logger::log_event_str("{ modify := ");
field_modify->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modifyComplete:
TTCN_Logger::log_event_str("{ modifyComplete := ");
field_modifyComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_modifyReject:
TTCN_Logger::log_event_str("{ modifyReject := ");
field_modifyReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_userInformation:
TTCN_Logger::log_event_str("{ userInformation := ");
field_userInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_disconnect__NW__MS:
TTCN_Logger::log_event_str("{ disconnect_NW_MS := ");
field_disconnect__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_release__NW__MS:
TTCN_Logger::log_event_str("{ release_NW_MS := ");
field_release__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_releaseComplete__NW__MS:
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
field_releaseComplete__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_holdAcknowledge:
TTCN_Logger::log_event_str("{ holdAcknowledge := ");
field_holdAcknowledge->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_holdReject:
TTCN_Logger::log_event_str("{ holdReject := ");
field_holdReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_retrieveAck:
TTCN_Logger::log_event_str("{ retrieveAck := ");
field_retrieveAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_retrieveRej:
TTCN_Logger::log_event_str("{ retrieveRej := ");
field_retrieveRej->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_congestionControl:
TTCN_Logger::log_event_str("{ congestionControl := ");
field_congestionControl->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_notify:
TTCN_Logger::log_event_str("{ notify := ");
field_notify->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_startDTMFAck:
TTCN_Logger::log_event_str("{ startDTMFAck := ");
field_startDTMFAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_startDTMFRej:
TTCN_Logger::log_event_str("{ startDTMFRej := ");
field_startDTMFRej->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_status:
TTCN_Logger::log_event_str("{ status := ");
field_status->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_statusEnquiry:
TTCN_Logger::log_event_str("{ statusEnquiry := ");
field_statusEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_stopDTMFAck:
TTCN_Logger::log_event_str("{ stopDTMFAck := ");
field_stopDTMFAck->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PDU__ML3__CC__NW__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "alerting_NW_MS")) {
    alerting__NW__MS().set_param(*mp_last);
    if (!alerting__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "callConfirmed")) {
    callConfirmed().set_param(*mp_last);
    if (!callConfirmed().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "callProceeding")) {
    callProceeding().set_param(*mp_last);
    if (!callProceeding().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "connect_NW_MS")) {
    connect__NW__MS().set_param(*mp_last);
    if (!connect__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "connectAck")) {
    connectAck().set_param(*mp_last);
    if (!connectAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "progress")) {
    progress().set_param(*mp_last);
    if (!progress().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cc_Establishment")) {
    cc__Establishment().set_param(*mp_last);
    if (!cc__Establishment().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "setup_NW_MS")) {
    setup__NW__MS().set_param(*mp_last);
    if (!setup__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modify")) {
    modify().set_param(*mp_last);
    if (!modify().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modifyComplete")) {
    modifyComplete().set_param(*mp_last);
    if (!modifyComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "modifyReject")) {
    modifyReject().set_param(*mp_last);
    if (!modifyReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "userInformation")) {
    userInformation().set_param(*mp_last);
    if (!userInformation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "disconnect_NW_MS")) {
    disconnect__NW__MS().set_param(*mp_last);
    if (!disconnect__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "release_NW_MS")) {
    release__NW__MS().set_param(*mp_last);
    if (!release__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "releaseComplete_NW_MS")) {
    releaseComplete__NW__MS().set_param(*mp_last);
    if (!releaseComplete__NW__MS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "facility")) {
    facility().set_param(*mp_last);
    if (!facility().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "holdAcknowledge")) {
    holdAcknowledge().set_param(*mp_last);
    if (!holdAcknowledge().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "holdReject")) {
    holdReject().set_param(*mp_last);
    if (!holdReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "retrieveAck")) {
    retrieveAck().set_param(*mp_last);
    if (!retrieveAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "retrieveRej")) {
    retrieveRej().set_param(*mp_last);
    if (!retrieveRej().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "congestionControl")) {
    congestionControl().set_param(*mp_last);
    if (!congestionControl().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "notify")) {
    notify().set_param(*mp_last);
    if (!notify().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "startDTMFAck")) {
    startDTMFAck().set_param(*mp_last);
    if (!startDTMFAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "startDTMFRej")) {
    startDTMFRej().set_param(*mp_last);
    if (!startDTMFRej().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "status")) {
    status().set_param(*mp_last);
    if (!status().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "statusEnquiry")) {
    statusEnquiry().set_param(*mp_last);
    if (!statusEnquiry().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "stopDTMFAck")) {
    stopDTMFAck().set_param(*mp_last);
    if (!stopDTMFAck().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.", last_name);
}

void PDU__ML3__CC__NW__MS::set_implicit_omit()
{
switch (union_selection) {
case ALT_alerting__NW__MS:
field_alerting__NW__MS->set_implicit_omit(); break;
case ALT_callConfirmed:
field_callConfirmed->set_implicit_omit(); break;
case ALT_callProceeding:
field_callProceeding->set_implicit_omit(); break;
case ALT_connect__NW__MS:
field_connect__NW__MS->set_implicit_omit(); break;
case ALT_connectAck:
field_connectAck->set_implicit_omit(); break;
case ALT_progress:
field_progress->set_implicit_omit(); break;
case ALT_cc__Establishment:
field_cc__Establishment->set_implicit_omit(); break;
case ALT_setup__NW__MS:
field_setup__NW__MS->set_implicit_omit(); break;
case ALT_modify:
field_modify->set_implicit_omit(); break;
case ALT_modifyComplete:
field_modifyComplete->set_implicit_omit(); break;
case ALT_modifyReject:
field_modifyReject->set_implicit_omit(); break;
case ALT_userInformation:
field_userInformation->set_implicit_omit(); break;
case ALT_disconnect__NW__MS:
field_disconnect__NW__MS->set_implicit_omit(); break;
case ALT_release__NW__MS:
field_release__NW__MS->set_implicit_omit(); break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS->set_implicit_omit(); break;
case ALT_facility:
field_facility->set_implicit_omit(); break;
case ALT_holdAcknowledge:
field_holdAcknowledge->set_implicit_omit(); break;
case ALT_holdReject:
field_holdReject->set_implicit_omit(); break;
case ALT_retrieveAck:
field_retrieveAck->set_implicit_omit(); break;
case ALT_retrieveRej:
field_retrieveRej->set_implicit_omit(); break;
case ALT_congestionControl:
field_congestionControl->set_implicit_omit(); break;
case ALT_notify:
field_notify->set_implicit_omit(); break;
case ALT_startDTMFAck:
field_startDTMFAck->set_implicit_omit(); break;
case ALT_startDTMFRej:
field_startDTMFRej->set_implicit_omit(); break;
case ALT_status:
field_status->set_implicit_omit(); break;
case ALT_statusEnquiry:
field_statusEnquiry->set_implicit_omit(); break;
case ALT_stopDTMFAck:
field_stopDTMFAck->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__CC__NW__MS::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_alerting__NW__MS:
field_alerting__NW__MS->encode_text(text_buf);
break;
case ALT_callConfirmed:
field_callConfirmed->encode_text(text_buf);
break;
case ALT_callProceeding:
field_callProceeding->encode_text(text_buf);
break;
case ALT_connect__NW__MS:
field_connect__NW__MS->encode_text(text_buf);
break;
case ALT_connectAck:
field_connectAck->encode_text(text_buf);
break;
case ALT_progress:
field_progress->encode_text(text_buf);
break;
case ALT_cc__Establishment:
field_cc__Establishment->encode_text(text_buf);
break;
case ALT_setup__NW__MS:
field_setup__NW__MS->encode_text(text_buf);
break;
case ALT_modify:
field_modify->encode_text(text_buf);
break;
case ALT_modifyComplete:
field_modifyComplete->encode_text(text_buf);
break;
case ALT_modifyReject:
field_modifyReject->encode_text(text_buf);
break;
case ALT_userInformation:
field_userInformation->encode_text(text_buf);
break;
case ALT_disconnect__NW__MS:
field_disconnect__NW__MS->encode_text(text_buf);
break;
case ALT_release__NW__MS:
field_release__NW__MS->encode_text(text_buf);
break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS->encode_text(text_buf);
break;
case ALT_facility:
field_facility->encode_text(text_buf);
break;
case ALT_holdAcknowledge:
field_holdAcknowledge->encode_text(text_buf);
break;
case ALT_holdReject:
field_holdReject->encode_text(text_buf);
break;
case ALT_retrieveAck:
field_retrieveAck->encode_text(text_buf);
break;
case ALT_retrieveRej:
field_retrieveRej->encode_text(text_buf);
break;
case ALT_congestionControl:
field_congestionControl->encode_text(text_buf);
break;
case ALT_notify:
field_notify->encode_text(text_buf);
break;
case ALT_startDTMFAck:
field_startDTMFAck->encode_text(text_buf);
break;
case ALT_startDTMFRej:
field_startDTMFRej->encode_text(text_buf);
break;
case ALT_status:
field_status->encode_text(text_buf);
break;
case ALT_statusEnquiry:
field_statusEnquiry->encode_text(text_buf);
break;
case ALT_stopDTMFAck:
field_stopDTMFAck->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}

void PDU__ML3__CC__NW__MS::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_alerting__NW__MS:
alerting__NW__MS().decode_text(text_buf);
break;
case ALT_callConfirmed:
callConfirmed().decode_text(text_buf);
break;
case ALT_callProceeding:
callProceeding().decode_text(text_buf);
break;
case ALT_connect__NW__MS:
connect__NW__MS().decode_text(text_buf);
break;
case ALT_connectAck:
connectAck().decode_text(text_buf);
break;
case ALT_progress:
progress().decode_text(text_buf);
break;
case ALT_cc__Establishment:
cc__Establishment().decode_text(text_buf);
break;
case ALT_setup__NW__MS:
setup__NW__MS().decode_text(text_buf);
break;
case ALT_modify:
modify().decode_text(text_buf);
break;
case ALT_modifyComplete:
modifyComplete().decode_text(text_buf);
break;
case ALT_modifyReject:
modifyReject().decode_text(text_buf);
break;
case ALT_userInformation:
userInformation().decode_text(text_buf);
break;
case ALT_disconnect__NW__MS:
disconnect__NW__MS().decode_text(text_buf);
break;
case ALT_release__NW__MS:
release__NW__MS().decode_text(text_buf);
break;
case ALT_releaseComplete__NW__MS:
releaseComplete__NW__MS().decode_text(text_buf);
break;
case ALT_facility:
facility().decode_text(text_buf);
break;
case ALT_holdAcknowledge:
holdAcknowledge().decode_text(text_buf);
break;
case ALT_holdReject:
holdReject().decode_text(text_buf);
break;
case ALT_retrieveAck:
retrieveAck().decode_text(text_buf);
break;
case ALT_retrieveRej:
retrieveRej().decode_text(text_buf);
break;
case ALT_congestionControl:
congestionControl().decode_text(text_buf);
break;
case ALT_notify:
notify().decode_text(text_buf);
break;
case ALT_startDTMFAck:
startDTMFAck().decode_text(text_buf);
break;
case ALT_startDTMFRej:
startDTMFRej().decode_text(text_buf);
break;
case ALT_status:
status().decode_text(text_buf);
break;
case ALT_statusEnquiry:
statusEnquiry().decode_text(text_buf);
break;
case ALT_stopDTMFAck:
stopDTMFAck().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}

void PDU__ML3__CC__NW__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__CC__NW__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__CC__NW__MS::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__Alerting__NW__MS_descr_.raw->forceomit);
      decoded_length = alerting__NW__MS().RAW_decode(PDU__ML3__Alerting__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__CallConfirmed_descr_.raw->forceomit);
      decoded_length = callConfirmed().RAW_decode(PDU__ML3__CallConfirmed_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__CallProceeding_descr_.raw->forceomit);
      decoded_length = callProceeding().RAW_decode(PDU__ML3__CallProceeding_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, PDU__ML3__Connect__NW__MS_descr_.raw->forceomit);
      decoded_length = connect__NW__MS().RAW_decode(PDU__ML3__Connect__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, PDU__ML3__ConnectAck_descr_.raw->forceomit);
      decoded_length = connectAck().RAW_decode(PDU__ML3__ConnectAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, PDU__ML3__Progress_descr_.raw->forceomit);
      decoded_length = progress().RAW_decode(PDU__ML3__Progress_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, PDU__ML3__CC__Establishment_descr_.raw->forceomit);
      decoded_length = cc__Establishment().RAW_decode(PDU__ML3__CC__Establishment_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, PDU__ML3__Setup__NW__MS_descr_.raw->forceomit);
      decoded_length = setup__NW__MS().RAW_decode(PDU__ML3__Setup__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, PDU__ML3__Modify_descr_.raw->forceomit);
      decoded_length = modify().RAW_decode(PDU__ML3__Modify_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, PDU__ML3__ModifyComplete_descr_.raw->forceomit);
      decoded_length = modifyComplete().RAW_decode(PDU__ML3__ModifyComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, PDU__ML3__ModifyReject_descr_.raw->forceomit);
      decoded_length = modifyReject().RAW_decode(PDU__ML3__ModifyReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, PDU__ML3__UserInformation_descr_.raw->forceomit);
      decoded_length = userInformation().RAW_decode(PDU__ML3__UserInformation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, PDU__ML3__Disconnect__NW__MS_descr_.raw->forceomit);
      decoded_length = disconnect__NW__MS().RAW_decode(PDU__ML3__Disconnect__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, PDU__ML3__Release__NW__MS_descr_.raw->forceomit);
      decoded_length = release__NW__MS().RAW_decode(PDU__ML3__Release__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, PDU__ML3__ReleaseComplete__NW__MS_descr_.raw->forceomit);
      decoded_length = releaseComplete__NW__MS().RAW_decode(PDU__ML3__ReleaseComplete__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 15: {
      RAW_Force_Omit field_force_omit(15, force_omit, PDU__ML3__Facility_descr_.raw->forceomit);
      decoded_length = facility().RAW_decode(PDU__ML3__Facility_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 16: {
      RAW_Force_Omit field_force_omit(16, force_omit, PDU__ML3__HoldAcknowledge_descr_.raw->forceomit);
      decoded_length = holdAcknowledge().RAW_decode(PDU__ML3__HoldAcknowledge_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 17: {
      RAW_Force_Omit field_force_omit(17, force_omit, PDU__ML3__HoldReject_descr_.raw->forceomit);
      decoded_length = holdReject().RAW_decode(PDU__ML3__HoldReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 18: {
      RAW_Force_Omit field_force_omit(18, force_omit, PDU__ML3__RetrieveAck_descr_.raw->forceomit);
      decoded_length = retrieveAck().RAW_decode(PDU__ML3__RetrieveAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 19: {
      RAW_Force_Omit field_force_omit(19, force_omit, PDU__ML3__RetrieveRej_descr_.raw->forceomit);
      decoded_length = retrieveRej().RAW_decode(PDU__ML3__RetrieveRej_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 20: {
      RAW_Force_Omit field_force_omit(20, force_omit, PDU__ML3__CongestionControl_descr_.raw->forceomit);
      decoded_length = congestionControl().RAW_decode(PDU__ML3__CongestionControl_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 21: {
      RAW_Force_Omit field_force_omit(21, force_omit, PDU__ML3__Notify_descr_.raw->forceomit);
      decoded_length = notify().RAW_decode(PDU__ML3__Notify_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 22: {
      RAW_Force_Omit field_force_omit(22, force_omit, PDU__ML3__StartDTMFAck_descr_.raw->forceomit);
      decoded_length = startDTMFAck().RAW_decode(PDU__ML3__StartDTMFAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 23: {
      RAW_Force_Omit field_force_omit(23, force_omit, PDU__ML3__StartDTMFRej_descr_.raw->forceomit);
      decoded_length = startDTMFRej().RAW_decode(PDU__ML3__StartDTMFRej_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 24: {
      RAW_Force_Omit field_force_omit(24, force_omit, PDU__ML3__Status_descr_.raw->forceomit);
      decoded_length = status().RAW_decode(PDU__ML3__Status_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 25: {
      RAW_Force_Omit field_force_omit(25, force_omit, PDU__ML3__StatusEnquiry_descr_.raw->forceomit);
      decoded_length = statusEnquiry().RAW_decode(PDU__ML3__StatusEnquiry_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 26: {
      RAW_Force_Omit field_force_omit(26, force_omit, PDU__ML3__StopDTMFAck_descr_.raw->forceomit);
      decoded_length = stopDTMFAck().RAW_decode(PDU__ML3__StopDTMFAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
    boolean already_failed = FALSE;
    BITSTRING temporal_0;
    int decoded_0_length;
    already_failed = FALSE;
    if (!already_failed) {
      p_buf.set_pos_bit(starting_pos + 0);
      decoded_0_length = temporal_0.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, top_bit_ord, TRUE);
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_2) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__Alerting__NW__MS_descr_.raw->forceomit);
          decoded_length = alerting__NW__MS().RAW_decode(PDU__ML3__Alerting__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_alerting__NW__MS).messageType() ==  bs_2) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_3) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__CallConfirmed_descr_.raw->forceomit);
          decoded_length = callConfirmed().RAW_decode(PDU__ML3__CallConfirmed_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_callConfirmed).messageType() ==  bs_3) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_25) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__CallProceeding_descr_.raw->forceomit);
          decoded_length = callProceeding().RAW_decode(PDU__ML3__CallProceeding_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_callProceeding).messageType() ==  bs_25) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_4) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(3, force_omit, PDU__ML3__Connect__NW__MS_descr_.raw->forceomit);
          decoded_length = connect__NW__MS().RAW_decode(PDU__ML3__Connect__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_connect__NW__MS).messageType() ==  bs_4) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_5) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(4, force_omit, PDU__ML3__ConnectAck_descr_.raw->forceomit);
          decoded_length = connectAck().RAW_decode(PDU__ML3__ConnectAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_connectAck).messageType() ==  bs_5) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_26) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(5, force_omit, PDU__ML3__Progress_descr_.raw->forceomit);
          decoded_length = progress().RAW_decode(PDU__ML3__Progress_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_progress).messageType() ==  bs_26) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_27) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(6, force_omit, PDU__ML3__CC__Establishment_descr_.raw->forceomit);
          decoded_length = cc__Establishment().RAW_decode(PDU__ML3__CC__Establishment_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_cc__Establishment).messageType() ==  bs_27) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_9) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(7, force_omit, PDU__ML3__Setup__NW__MS_descr_.raw->forceomit);
          decoded_length = setup__NW__MS().RAW_decode(PDU__ML3__Setup__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_setup__NW__MS).messageType() ==  bs_9) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_10) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(8, force_omit, PDU__ML3__Modify_descr_.raw->forceomit);
          decoded_length = modify().RAW_decode(PDU__ML3__Modify_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modify).messageType() ==  bs_10) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_11) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(9, force_omit, PDU__ML3__ModifyComplete_descr_.raw->forceomit);
          decoded_length = modifyComplete().RAW_decode(PDU__ML3__ModifyComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modifyComplete).messageType() ==  bs_11) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_12) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(10, force_omit, PDU__ML3__ModifyReject_descr_.raw->forceomit);
          decoded_length = modifyReject().RAW_decode(PDU__ML3__ModifyReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_modifyReject).messageType() ==  bs_12) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_13) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(11, force_omit, PDU__ML3__UserInformation_descr_.raw->forceomit);
          decoded_length = userInformation().RAW_decode(PDU__ML3__UserInformation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_userInformation).messageType() ==  bs_13) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_14) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(12, force_omit, PDU__ML3__Disconnect__NW__MS_descr_.raw->forceomit);
          decoded_length = disconnect__NW__MS().RAW_decode(PDU__ML3__Disconnect__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_disconnect__NW__MS).messageType() ==  bs_14) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_15) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(13, force_omit, PDU__ML3__Release__NW__MS_descr_.raw->forceomit);
          decoded_length = release__NW__MS().RAW_decode(PDU__ML3__Release__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_release__NW__MS).messageType() ==  bs_15) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_16) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(14, force_omit, PDU__ML3__ReleaseComplete__NW__MS_descr_.raw->forceomit);
          decoded_length = releaseComplete__NW__MS().RAW_decode(PDU__ML3__ReleaseComplete__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_releaseComplete__NW__MS).messageType() ==  bs_16) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_17) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(15, force_omit, PDU__ML3__Facility_descr_.raw->forceomit);
          decoded_length = facility().RAW_decode(PDU__ML3__Facility_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_facility).messageType() ==  bs_17) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_28) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(16, force_omit, PDU__ML3__HoldAcknowledge_descr_.raw->forceomit);
          decoded_length = holdAcknowledge().RAW_decode(PDU__ML3__HoldAcknowledge_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_holdAcknowledge).messageType() ==  bs_28) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_29) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(17, force_omit, PDU__ML3__HoldReject_descr_.raw->forceomit);
          decoded_length = holdReject().RAW_decode(PDU__ML3__HoldReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_holdReject).messageType() ==  bs_29) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_30) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(18, force_omit, PDU__ML3__RetrieveAck_descr_.raw->forceomit);
          decoded_length = retrieveAck().RAW_decode(PDU__ML3__RetrieveAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_retrieveAck).messageType() ==  bs_30) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_31) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(19, force_omit, PDU__ML3__RetrieveRej_descr_.raw->forceomit);
          decoded_length = retrieveRej().RAW_decode(PDU__ML3__RetrieveRej_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_retrieveRej).messageType() ==  bs_31) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_32) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(20, force_omit, PDU__ML3__CongestionControl_descr_.raw->forceomit);
          decoded_length = congestionControl().RAW_decode(PDU__ML3__CongestionControl_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_congestionControl).messageType() ==  bs_32) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_20) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(21, force_omit, PDU__ML3__Notify_descr_.raw->forceomit);
          decoded_length = notify().RAW_decode(PDU__ML3__Notify_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_notify).messageType() ==  bs_20) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_33) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(22, force_omit, PDU__ML3__StartDTMFAck_descr_.raw->forceomit);
          decoded_length = startDTMFAck().RAW_decode(PDU__ML3__StartDTMFAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_startDTMFAck).messageType() ==  bs_33) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_34) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(23, force_omit, PDU__ML3__StartDTMFRej_descr_.raw->forceomit);
          decoded_length = startDTMFRej().RAW_decode(PDU__ML3__StartDTMFRej_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_startDTMFRej).messageType() ==  bs_34) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_22) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(24, force_omit, PDU__ML3__Status_descr_.raw->forceomit);
          decoded_length = status().RAW_decode(PDU__ML3__Status_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_status).messageType() ==  bs_22) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_23) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(25, force_omit, PDU__ML3__StatusEnquiry_descr_.raw->forceomit);
          decoded_length = statusEnquiry().RAW_decode(PDU__ML3__StatusEnquiry_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_statusEnquiry).messageType() ==  bs_23) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_35) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(26, force_omit, PDU__ML3__StopDTMFAck_descr_.raw->forceomit);
          decoded_length = stopDTMFAck().RAW_decode(PDU__ML3__StopDTMFAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_stopDTMFAck).messageType() ==  bs_35) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
 }
 clean_up();
 return -1;
}

int PDU__ML3__CC__NW__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 27;  myleaf.body.node.nodes = init_nodes_of_enc_tree(27);
  memset(myleaf.body.node.nodes, 0, 27 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_alerting__NW__MS:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__ML3__Alerting__NW__MS_descr_.raw);
    encoded_length = field_alerting__NW__MS->RAW_encode(PDU__ML3__Alerting__NW__MS_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__ML3__Alerting__NW__MS_descr_;
    if ((*field_alerting__NW__MS).messageType() !=  bs_2) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_2.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_callConfirmed:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PDU__ML3__CallConfirmed_descr_.raw);
    encoded_length = field_callConfirmed->RAW_encode(PDU__ML3__CallConfirmed_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PDU__ML3__CallConfirmed_descr_;
    if ((*field_callConfirmed).messageType() !=  bs_3) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_3.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_callProceeding:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PDU__ML3__CallProceeding_descr_.raw);
    encoded_length = field_callProceeding->RAW_encode(PDU__ML3__CallProceeding_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PDU__ML3__CallProceeding_descr_;
    if ((*field_callProceeding).messageType() !=  bs_25) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_25.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_connect__NW__MS:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, PDU__ML3__Connect__NW__MS_descr_.raw);
    encoded_length = field_connect__NW__MS->RAW_encode(PDU__ML3__Connect__NW__MS_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &PDU__ML3__Connect__NW__MS_descr_;
    if ((*field_connect__NW__MS).messageType() !=  bs_4) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_4.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_connectAck:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, PDU__ML3__ConnectAck_descr_.raw);
    encoded_length = field_connectAck->RAW_encode(PDU__ML3__ConnectAck_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &PDU__ML3__ConnectAck_descr_;
    if ((*field_connectAck).messageType() !=  bs_5) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_5.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_progress:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, PDU__ML3__Progress_descr_.raw);
    encoded_length = field_progress->RAW_encode(PDU__ML3__Progress_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &PDU__ML3__Progress_descr_;
    if ((*field_progress).messageType() !=  bs_26) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_26.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_cc__Establishment:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, PDU__ML3__CC__Establishment_descr_.raw);
    encoded_length = field_cc__Establishment->RAW_encode(PDU__ML3__CC__Establishment_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &PDU__ML3__CC__Establishment_descr_;
    if ((*field_cc__Establishment).messageType() !=  bs_27) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_27.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_setup__NW__MS:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, PDU__ML3__Setup__NW__MS_descr_.raw);
    encoded_length = field_setup__NW__MS->RAW_encode(PDU__ML3__Setup__NW__MS_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &PDU__ML3__Setup__NW__MS_descr_;
    if ((*field_setup__NW__MS).messageType() !=  bs_9) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_9.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modify:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, PDU__ML3__Modify_descr_.raw);
    encoded_length = field_modify->RAW_encode(PDU__ML3__Modify_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &PDU__ML3__Modify_descr_;
    if ((*field_modify).messageType() !=  bs_10) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={8,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_10.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modifyComplete:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, PDU__ML3__ModifyComplete_descr_.raw);
    encoded_length = field_modifyComplete->RAW_encode(PDU__ML3__ModifyComplete_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &PDU__ML3__ModifyComplete_descr_;
    if ((*field_modifyComplete).messageType() !=  bs_11) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={9,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_11.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_modifyReject:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, PDU__ML3__ModifyReject_descr_.raw);
    encoded_length = field_modifyReject->RAW_encode(PDU__ML3__ModifyReject_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &PDU__ML3__ModifyReject_descr_;
    if ((*field_modifyReject).messageType() !=  bs_12) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={10,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_12.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_userInformation:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, PDU__ML3__UserInformation_descr_.raw);
    encoded_length = field_userInformation->RAW_encode(PDU__ML3__UserInformation_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &PDU__ML3__UserInformation_descr_;
    if ((*field_userInformation).messageType() !=  bs_13) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={11,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_13.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_disconnect__NW__MS:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, PDU__ML3__Disconnect__NW__MS_descr_.raw);
    encoded_length = field_disconnect__NW__MS->RAW_encode(PDU__ML3__Disconnect__NW__MS_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &PDU__ML3__Disconnect__NW__MS_descr_;
    if ((*field_disconnect__NW__MS).messageType() !=  bs_14) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={12,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_14.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_release__NW__MS:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, PDU__ML3__Release__NW__MS_descr_.raw);
    encoded_length = field_release__NW__MS->RAW_encode(PDU__ML3__Release__NW__MS_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &PDU__ML3__Release__NW__MS_descr_;
    if ((*field_release__NW__MS).messageType() !=  bs_15) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={13,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_15.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_releaseComplete__NW__MS:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, PDU__ML3__ReleaseComplete__NW__MS_descr_.raw);
    encoded_length = field_releaseComplete__NW__MS->RAW_encode(PDU__ML3__ReleaseComplete__NW__MS_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &PDU__ML3__ReleaseComplete__NW__MS_descr_;
    if ((*field_releaseComplete__NW__MS).messageType() !=  bs_16) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={14,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_16.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_facility:
    myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 15, PDU__ML3__Facility_descr_.raw);
    encoded_length = field_facility->RAW_encode(PDU__ML3__Facility_descr_, *myleaf.body.node.nodes[15]);
    myleaf.body.node.nodes[15]->coding_descr = &PDU__ML3__Facility_descr_;
    if ((*field_facility).messageType() !=  bs_17) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={15,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_17.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_holdAcknowledge:
    myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 16, PDU__ML3__HoldAcknowledge_descr_.raw);
    encoded_length = field_holdAcknowledge->RAW_encode(PDU__ML3__HoldAcknowledge_descr_, *myleaf.body.node.nodes[16]);
    myleaf.body.node.nodes[16]->coding_descr = &PDU__ML3__HoldAcknowledge_descr_;
    if ((*field_holdAcknowledge).messageType() !=  bs_28) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={16,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_28.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_holdReject:
    myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 17, PDU__ML3__HoldReject_descr_.raw);
    encoded_length = field_holdReject->RAW_encode(PDU__ML3__HoldReject_descr_, *myleaf.body.node.nodes[17]);
    myleaf.body.node.nodes[17]->coding_descr = &PDU__ML3__HoldReject_descr_;
    if ((*field_holdReject).messageType() !=  bs_29) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={17,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_29.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_retrieveAck:
    myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 18, PDU__ML3__RetrieveAck_descr_.raw);
    encoded_length = field_retrieveAck->RAW_encode(PDU__ML3__RetrieveAck_descr_, *myleaf.body.node.nodes[18]);
    myleaf.body.node.nodes[18]->coding_descr = &PDU__ML3__RetrieveAck_descr_;
    if ((*field_retrieveAck).messageType() !=  bs_30) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={18,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_30.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_retrieveRej:
    myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 19, PDU__ML3__RetrieveRej_descr_.raw);
    encoded_length = field_retrieveRej->RAW_encode(PDU__ML3__RetrieveRej_descr_, *myleaf.body.node.nodes[19]);
    myleaf.body.node.nodes[19]->coding_descr = &PDU__ML3__RetrieveRej_descr_;
    if ((*field_retrieveRej).messageType() !=  bs_31) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={19,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_31.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_congestionControl:
    myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 20, PDU__ML3__CongestionControl_descr_.raw);
    encoded_length = field_congestionControl->RAW_encode(PDU__ML3__CongestionControl_descr_, *myleaf.body.node.nodes[20]);
    myleaf.body.node.nodes[20]->coding_descr = &PDU__ML3__CongestionControl_descr_;
    if ((*field_congestionControl).messageType() !=  bs_32) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={20,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_32.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_notify:
    myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 21, PDU__ML3__Notify_descr_.raw);
    encoded_length = field_notify->RAW_encode(PDU__ML3__Notify_descr_, *myleaf.body.node.nodes[21]);
    myleaf.body.node.nodes[21]->coding_descr = &PDU__ML3__Notify_descr_;
    if ((*field_notify).messageType() !=  bs_20) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={21,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_20.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_startDTMFAck:
    myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 22, PDU__ML3__StartDTMFAck_descr_.raw);
    encoded_length = field_startDTMFAck->RAW_encode(PDU__ML3__StartDTMFAck_descr_, *myleaf.body.node.nodes[22]);
    myleaf.body.node.nodes[22]->coding_descr = &PDU__ML3__StartDTMFAck_descr_;
    if ((*field_startDTMFAck).messageType() !=  bs_33) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={22,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_33.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_startDTMFRej:
    myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 23, PDU__ML3__StartDTMFRej_descr_.raw);
    encoded_length = field_startDTMFRej->RAW_encode(PDU__ML3__StartDTMFRej_descr_, *myleaf.body.node.nodes[23]);
    myleaf.body.node.nodes[23]->coding_descr = &PDU__ML3__StartDTMFRej_descr_;
    if ((*field_startDTMFRej).messageType() !=  bs_34) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={23,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_34.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_status:
    myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 24, PDU__ML3__Status_descr_.raw);
    encoded_length = field_status->RAW_encode(PDU__ML3__Status_descr_, *myleaf.body.node.nodes[24]);
    myleaf.body.node.nodes[24]->coding_descr = &PDU__ML3__Status_descr_;
    if ((*field_status).messageType() !=  bs_22) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={24,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_22.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_statusEnquiry:
    myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 25, PDU__ML3__StatusEnquiry_descr_.raw);
    encoded_length = field_statusEnquiry->RAW_encode(PDU__ML3__StatusEnquiry_descr_, *myleaf.body.node.nodes[25]);
    myleaf.body.node.nodes[25]->coding_descr = &PDU__ML3__StatusEnquiry_descr_;
    if ((*field_statusEnquiry).messageType() !=  bs_23) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={25,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_23.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_stopDTMFAck:
    myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 26, PDU__ML3__StopDTMFAck_descr_.raw);
    encoded_length = field_stopDTMFAck->RAW_encode(PDU__ML3__StopDTMFAck_descr_, *myleaf.body.node.nodes[26]);
    myleaf.body.node.nodes[26]->coding_descr = &PDU__ML3__StopDTMFAck_descr_;
    if ((*field_stopDTMFAck).messageType() !=  bs_35) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={26,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_35.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PDU__ML3__CC__NW__MS_template::copy_value(const PDU__ML3__CC__NW__MS& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS_template(other_value.alerting__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(other_value.callConfirmed());
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding = new PDU__ML3__CallProceeding_template(other_value.callProceeding());
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS = new PDU__ML3__Connect__NW__MS_template(other_value.connect__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template(other_value.connectAck());
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress = new PDU__ML3__Progress_template(other_value.progress());
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment = new PDU__ML3__CC__Establishment_template(other_value.cc__Establishment());
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS = new PDU__ML3__Setup__NW__MS_template(other_value.setup__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template(other_value.modify());
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(other_value.modifyComplete());
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(other_value.modifyReject());
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template(other_value.userInformation());
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS_template(other_value.disconnect__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS = new PDU__ML3__Release__NW__MS_template(other_value.release__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS_template(other_value.releaseComplete__NW__MS());
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template(other_value.facility());
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge = new PDU__ML3__HoldAcknowledge_template(other_value.holdAcknowledge());
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject = new PDU__ML3__HoldReject_template(other_value.holdReject());
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck = new PDU__ML3__RetrieveAck_template(other_value.retrieveAck());
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej = new PDU__ML3__RetrieveRej_template(other_value.retrieveRej());
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl = new PDU__ML3__CongestionControl_template(other_value.congestionControl());
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template(other_value.notify());
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck = new PDU__ML3__StartDTMFAck_template(other_value.startDTMFAck());
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej = new PDU__ML3__StartDTMFRej_template(other_value.startDTMFRej());
break;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status = new PDU__ML3__Status_template(other_value.status());
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(other_value.statusEnquiry());
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck = new PDU__ML3__StopDTMFAck_template(other_value.stopDTMFAck());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__CC__NW__MS_template::copy_template(const PDU__ML3__CC__NW__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS_template(*other_value.single_value.field_alerting__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(*other_value.single_value.field_callConfirmed);
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding = new PDU__ML3__CallProceeding_template(*other_value.single_value.field_callProceeding);
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS = new PDU__ML3__Connect__NW__MS_template(*other_value.single_value.field_connect__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template(*other_value.single_value.field_connectAck);
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress = new PDU__ML3__Progress_template(*other_value.single_value.field_progress);
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment = new PDU__ML3__CC__Establishment_template(*other_value.single_value.field_cc__Establishment);
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS = new PDU__ML3__Setup__NW__MS_template(*other_value.single_value.field_setup__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template(*other_value.single_value.field_modify);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(*other_value.single_value.field_modifyComplete);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(*other_value.single_value.field_modifyReject);
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template(*other_value.single_value.field_userInformation);
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS_template(*other_value.single_value.field_disconnect__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS = new PDU__ML3__Release__NW__MS_template(*other_value.single_value.field_release__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS_template(*other_value.single_value.field_releaseComplete__NW__MS);
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template(*other_value.single_value.field_facility);
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge = new PDU__ML3__HoldAcknowledge_template(*other_value.single_value.field_holdAcknowledge);
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject = new PDU__ML3__HoldReject_template(*other_value.single_value.field_holdReject);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck = new PDU__ML3__RetrieveAck_template(*other_value.single_value.field_retrieveAck);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej = new PDU__ML3__RetrieveRej_template(*other_value.single_value.field_retrieveRej);
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl = new PDU__ML3__CongestionControl_template(*other_value.single_value.field_congestionControl);
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template(*other_value.single_value.field_notify);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck = new PDU__ML3__StartDTMFAck_template(*other_value.single_value.field_startDTMFAck);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej = new PDU__ML3__StartDTMFRej_template(*other_value.single_value.field_startDTMFRej);
break;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status = new PDU__ML3__Status_template(*other_value.single_value.field_status);
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(*other_value.single_value.field_statusEnquiry);
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck = new PDU__ML3__StopDTMFAck_template(*other_value.single_value.field_stopDTMFAck);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__CC__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__CC__NW__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__CC__NW__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
set_selection(other_value);
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template()
{
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(const PDU__ML3__CC__NW__MS& other_value)
{
copy_value(other_value);
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(const OPTIONAL<PDU__ML3__CC__NW__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CC__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS from an unbound optional field.");
}
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(PDU__ML3__CC__NW__MS_template* p_precondition, PDU__ML3__CC__NW__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(Dynamic_Match_Interface<PDU__ML3__CC__NW__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__CC__NW__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__CC__NW__MS_template::PDU__ML3__CC__NW__MS_template(const PDU__ML3__CC__NW__MS_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PDU__ML3__CC__NW__MS_template::~PDU__ML3__CC__NW__MS_template()
{
clean_up();
}

void PDU__ML3__CC__NW__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
delete single_value.field_alerting__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
delete single_value.field_callConfirmed;
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
delete single_value.field_callProceeding;
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
delete single_value.field_connect__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
delete single_value.field_connectAck;
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
delete single_value.field_progress;
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
delete single_value.field_cc__Establishment;
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
delete single_value.field_setup__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
delete single_value.field_modify;
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
delete single_value.field_modifyComplete;
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
delete single_value.field_modifyReject;
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
delete single_value.field_userInformation;
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
delete single_value.field_disconnect__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
delete single_value.field_release__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
delete single_value.field_releaseComplete__NW__MS;
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
delete single_value.field_facility;
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
delete single_value.field_holdAcknowledge;
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
delete single_value.field_holdReject;
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
delete single_value.field_retrieveAck;
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
delete single_value.field_retrieveRej;
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
delete single_value.field_congestionControl;
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
delete single_value.field_notify;
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
delete single_value.field_startDTMFAck;
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
delete single_value.field_startDTMFRej;
break;
case PDU__ML3__CC__NW__MS::ALT_status:
delete single_value.field_status;
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
delete single_value.field_statusEnquiry;
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
delete single_value.field_stopDTMFAck;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__CC__NW__MS_template& PDU__ML3__CC__NW__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__CC__NW__MS_template& PDU__ML3__CC__NW__MS_template::operator=(const PDU__ML3__CC__NW__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__CC__NW__MS_template& PDU__ML3__CC__NW__MS_template::operator=(const OPTIONAL<PDU__ML3__CC__NW__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CC__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
return *this;
}

PDU__ML3__CC__NW__MS_template& PDU__ML3__CC__NW__MS_template::operator=(const PDU__ML3__CC__NW__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__CC__NW__MS_template::match(const PDU__ML3__CC__NW__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PDU__ML3__CC__NW__MS::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PDU__ML3__CC__NW__MS::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
return single_value.field_alerting__NW__MS->match(other_value.alerting__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
return single_value.field_callConfirmed->match(other_value.callConfirmed(), legacy);
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
return single_value.field_callProceeding->match(other_value.callProceeding(), legacy);
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
return single_value.field_connect__NW__MS->match(other_value.connect__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_connectAck:
return single_value.field_connectAck->match(other_value.connectAck(), legacy);
case PDU__ML3__CC__NW__MS::ALT_progress:
return single_value.field_progress->match(other_value.progress(), legacy);
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
return single_value.field_cc__Establishment->match(other_value.cc__Establishment(), legacy);
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
return single_value.field_setup__NW__MS->match(other_value.setup__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_modify:
return single_value.field_modify->match(other_value.modify(), legacy);
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
return single_value.field_modifyComplete->match(other_value.modifyComplete(), legacy);
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
return single_value.field_modifyReject->match(other_value.modifyReject(), legacy);
case PDU__ML3__CC__NW__MS::ALT_userInformation:
return single_value.field_userInformation->match(other_value.userInformation(), legacy);
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
return single_value.field_disconnect__NW__MS->match(other_value.disconnect__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
return single_value.field_release__NW__MS->match(other_value.release__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
return single_value.field_releaseComplete__NW__MS->match(other_value.releaseComplete__NW__MS(), legacy);
case PDU__ML3__CC__NW__MS::ALT_facility:
return single_value.field_facility->match(other_value.facility(), legacy);
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
return single_value.field_holdAcknowledge->match(other_value.holdAcknowledge(), legacy);
case PDU__ML3__CC__NW__MS::ALT_holdReject:
return single_value.field_holdReject->match(other_value.holdReject(), legacy);
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
return single_value.field_retrieveAck->match(other_value.retrieveAck(), legacy);
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
return single_value.field_retrieveRej->match(other_value.retrieveRej(), legacy);
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
return single_value.field_congestionControl->match(other_value.congestionControl(), legacy);
case PDU__ML3__CC__NW__MS::ALT_notify:
return single_value.field_notify->match(other_value.notify(), legacy);
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
return single_value.field_startDTMFAck->match(other_value.startDTMFAck(), legacy);
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
return single_value.field_startDTMFRej->match(other_value.startDTMFRej(), legacy);
case PDU__ML3__CC__NW__MS::ALT_status:
return single_value.field_status->match(other_value.status(), legacy);
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
return single_value.field_statusEnquiry->match(other_value.statusEnquiry(), legacy);
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
return single_value.field_stopDTMFAck->match(other_value.stopDTMFAck(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
return FALSE;
}

boolean PDU__ML3__CC__NW__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
return single_value.field_alerting__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
return single_value.field_callConfirmed->is_value();
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
return single_value.field_callProceeding->is_value();
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
return single_value.field_connect__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_connectAck:
return single_value.field_connectAck->is_value();
case PDU__ML3__CC__NW__MS::ALT_progress:
return single_value.field_progress->is_value();
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
return single_value.field_cc__Establishment->is_value();
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
return single_value.field_setup__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_modify:
return single_value.field_modify->is_value();
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
return single_value.field_modifyComplete->is_value();
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
return single_value.field_modifyReject->is_value();
case PDU__ML3__CC__NW__MS::ALT_userInformation:
return single_value.field_userInformation->is_value();
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
return single_value.field_disconnect__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
return single_value.field_release__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
return single_value.field_releaseComplete__NW__MS->is_value();
case PDU__ML3__CC__NW__MS::ALT_facility:
return single_value.field_facility->is_value();
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
return single_value.field_holdAcknowledge->is_value();
case PDU__ML3__CC__NW__MS::ALT_holdReject:
return single_value.field_holdReject->is_value();
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
return single_value.field_retrieveAck->is_value();
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
return single_value.field_retrieveRej->is_value();
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
return single_value.field_congestionControl->is_value();
case PDU__ML3__CC__NW__MS::ALT_notify:
return single_value.field_notify->is_value();
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
return single_value.field_startDTMFAck->is_value();
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
return single_value.field_startDTMFRej->is_value();
case PDU__ML3__CC__NW__MS::ALT_status:
return single_value.field_status->is_value();
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
return single_value.field_statusEnquiry->is_value();
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
return single_value.field_stopDTMFAck->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}

PDU__ML3__CC__NW__MS PDU__ML3__CC__NW__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
PDU__ML3__CC__NW__MS ret_val;
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
ret_val.alerting__NW__MS() = single_value.field_alerting__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
ret_val.callConfirmed() = single_value.field_callConfirmed->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
ret_val.callProceeding() = single_value.field_callProceeding->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
ret_val.connect__NW__MS() = single_value.field_connect__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
ret_val.connectAck() = single_value.field_connectAck->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
ret_val.progress() = single_value.field_progress->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
ret_val.cc__Establishment() = single_value.field_cc__Establishment->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
ret_val.setup__NW__MS() = single_value.field_setup__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
ret_val.modify() = single_value.field_modify->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
ret_val.modifyComplete() = single_value.field_modifyComplete->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
ret_val.modifyReject() = single_value.field_modifyReject->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
ret_val.userInformation() = single_value.field_userInformation->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
ret_val.disconnect__NW__MS() = single_value.field_disconnect__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
ret_val.release__NW__MS() = single_value.field_release__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
ret_val.releaseComplete__NW__MS() = single_value.field_releaseComplete__NW__MS->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
ret_val.facility() = single_value.field_facility->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
ret_val.holdAcknowledge() = single_value.field_holdAcknowledge->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
ret_val.holdReject() = single_value.field_holdReject->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
ret_val.retrieveAck() = single_value.field_retrieveAck->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
ret_val.retrieveRej() = single_value.field_retrieveRej->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
ret_val.congestionControl() = single_value.field_congestionControl->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
ret_val.notify() = single_value.field_notify->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
ret_val.startDTMFAck() = single_value.field_startDTMFAck->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
ret_val.startDTMFRej() = single_value.field_startDTMFRej->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_status:
ret_val.status() = single_value.field_status->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
ret_val.statusEnquiry() = single_value.field_statusEnquiry->valueof();
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
ret_val.stopDTMFAck() = single_value.field_stopDTMFAck->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
return ret_val;
}

PDU__ML3__CC__NW__MS_template& PDU__ML3__CC__NW__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return value_list.list_value[list_index];
}
void PDU__ML3__CC__NW__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__CC__NW__MS_template[list_length];
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__CC__NW__MS_template::alerting__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS_template(ANY_VALUE);
else single_value.field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_alerting__NW__MS;
}

const PDU__ML3__Alerting__NW__MS_template& PDU__ML3__CC__NW__MS_template::alerting__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field alerting_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS) TTCN_error("Accessing non-selected field alerting_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_alerting__NW__MS;
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CC__NW__MS_template::callConfirmed()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_callConfirmed) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template(ANY_VALUE);
else single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_callConfirmed;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_callConfirmed;
}

const PDU__ML3__CallConfirmed_template& PDU__ML3__CC__NW__MS_template::callConfirmed() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field callConfirmed in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_callConfirmed) TTCN_error("Accessing non-selected field callConfirmed in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_callConfirmed;
}

PDU__ML3__CallProceeding_template& PDU__ML3__CC__NW__MS_template::callProceeding()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_callProceeding) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_callProceeding = new PDU__ML3__CallProceeding_template(ANY_VALUE);
else single_value.field_callProceeding = new PDU__ML3__CallProceeding_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_callProceeding;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_callProceeding;
}

const PDU__ML3__CallProceeding_template& PDU__ML3__CC__NW__MS_template::callProceeding() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field callProceeding in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_callProceeding) TTCN_error("Accessing non-selected field callProceeding in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_callProceeding;
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__CC__NW__MS_template::connect__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_connect__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_connect__NW__MS = new PDU__ML3__Connect__NW__MS_template(ANY_VALUE);
else single_value.field_connect__NW__MS = new PDU__ML3__Connect__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_connect__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_connect__NW__MS;
}

const PDU__ML3__Connect__NW__MS_template& PDU__ML3__CC__NW__MS_template::connect__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field connect_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_connect__NW__MS) TTCN_error("Accessing non-selected field connect_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_connect__NW__MS;
}

PDU__ML3__ConnectAck_template& PDU__ML3__CC__NW__MS_template::connectAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_connectAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_connectAck = new PDU__ML3__ConnectAck_template(ANY_VALUE);
else single_value.field_connectAck = new PDU__ML3__ConnectAck_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_connectAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_connectAck;
}

const PDU__ML3__ConnectAck_template& PDU__ML3__CC__NW__MS_template::connectAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field connectAck in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_connectAck) TTCN_error("Accessing non-selected field connectAck in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_connectAck;
}

PDU__ML3__Progress_template& PDU__ML3__CC__NW__MS_template::progress()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_progress) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_progress = new PDU__ML3__Progress_template(ANY_VALUE);
else single_value.field_progress = new PDU__ML3__Progress_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_progress;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_progress;
}

const PDU__ML3__Progress_template& PDU__ML3__CC__NW__MS_template::progress() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field progress in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_progress) TTCN_error("Accessing non-selected field progress in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_progress;
}

PDU__ML3__CC__Establishment_template& PDU__ML3__CC__NW__MS_template::cc__Establishment()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_cc__Establishment) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cc__Establishment = new PDU__ML3__CC__Establishment_template(ANY_VALUE);
else single_value.field_cc__Establishment = new PDU__ML3__CC__Establishment_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_cc__Establishment;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cc__Establishment;
}

const PDU__ML3__CC__Establishment_template& PDU__ML3__CC__NW__MS_template::cc__Establishment() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cc_Establishment in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_cc__Establishment) TTCN_error("Accessing non-selected field cc_Establishment in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_cc__Establishment;
}

PDU__ML3__Setup__NW__MS_template& PDU__ML3__CC__NW__MS_template::setup__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_setup__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_setup__NW__MS = new PDU__ML3__Setup__NW__MS_template(ANY_VALUE);
else single_value.field_setup__NW__MS = new PDU__ML3__Setup__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_setup__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_setup__NW__MS;
}

const PDU__ML3__Setup__NW__MS_template& PDU__ML3__CC__NW__MS_template::setup__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field setup_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_setup__NW__MS) TTCN_error("Accessing non-selected field setup_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_setup__NW__MS;
}

PDU__ML3__Modify_template& PDU__ML3__CC__NW__MS_template::modify()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modify) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modify = new PDU__ML3__Modify_template(ANY_VALUE);
else single_value.field_modify = new PDU__ML3__Modify_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_modify;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modify;
}

const PDU__ML3__Modify_template& PDU__ML3__CC__NW__MS_template::modify() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modify in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modify) TTCN_error("Accessing non-selected field modify in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_modify;
}

PDU__ML3__ModifyComplete_template& PDU__ML3__CC__NW__MS_template::modifyComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modifyComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template(ANY_VALUE);
else single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_modifyComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modifyComplete;
}

const PDU__ML3__ModifyComplete_template& PDU__ML3__CC__NW__MS_template::modifyComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modifyComplete in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modifyComplete) TTCN_error("Accessing non-selected field modifyComplete in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_modifyComplete;
}

PDU__ML3__ModifyReject_template& PDU__ML3__CC__NW__MS_template::modifyReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modifyReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_modifyReject = new PDU__ML3__ModifyReject_template(ANY_VALUE);
else single_value.field_modifyReject = new PDU__ML3__ModifyReject_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_modifyReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_modifyReject;
}

const PDU__ML3__ModifyReject_template& PDU__ML3__CC__NW__MS_template::modifyReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field modifyReject in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_modifyReject) TTCN_error("Accessing non-selected field modifyReject in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_modifyReject;
}

PDU__ML3__UserInformation_template& PDU__ML3__CC__NW__MS_template::userInformation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_userInformation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_userInformation = new PDU__ML3__UserInformation_template(ANY_VALUE);
else single_value.field_userInformation = new PDU__ML3__UserInformation_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_userInformation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_userInformation;
}

const PDU__ML3__UserInformation_template& PDU__ML3__CC__NW__MS_template::userInformation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field userInformation in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_userInformation) TTCN_error("Accessing non-selected field userInformation in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_userInformation;
}

PDU__ML3__Disconnect__NW__MS_template& PDU__ML3__CC__NW__MS_template::disconnect__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS_template(ANY_VALUE);
else single_value.field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_disconnect__NW__MS;
}

const PDU__ML3__Disconnect__NW__MS_template& PDU__ML3__CC__NW__MS_template::disconnect__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field disconnect_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS) TTCN_error("Accessing non-selected field disconnect_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_disconnect__NW__MS;
}

PDU__ML3__Release__NW__MS_template& PDU__ML3__CC__NW__MS_template::release__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_release__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_release__NW__MS = new PDU__ML3__Release__NW__MS_template(ANY_VALUE);
else single_value.field_release__NW__MS = new PDU__ML3__Release__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_release__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_release__NW__MS;
}

const PDU__ML3__Release__NW__MS_template& PDU__ML3__CC__NW__MS_template::release__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field release_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_release__NW__MS) TTCN_error("Accessing non-selected field release_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_release__NW__MS;
}

PDU__ML3__ReleaseComplete__NW__MS_template& PDU__ML3__CC__NW__MS_template::releaseComplete__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS_template(ANY_VALUE);
else single_value.field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_releaseComplete__NW__MS;
}

const PDU__ML3__ReleaseComplete__NW__MS_template& PDU__ML3__CC__NW__MS_template::releaseComplete__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field releaseComplete_NW_MS in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS) TTCN_error("Accessing non-selected field releaseComplete_NW_MS in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_releaseComplete__NW__MS;
}

PDU__ML3__Facility_template& PDU__ML3__CC__NW__MS_template::facility()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_facility) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_facility = new PDU__ML3__Facility_template(ANY_VALUE);
else single_value.field_facility = new PDU__ML3__Facility_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_facility;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_facility;
}

const PDU__ML3__Facility_template& PDU__ML3__CC__NW__MS_template::facility() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field facility in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_facility) TTCN_error("Accessing non-selected field facility in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_facility;
}

PDU__ML3__HoldAcknowledge_template& PDU__ML3__CC__NW__MS_template::holdAcknowledge()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_holdAcknowledge) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_holdAcknowledge = new PDU__ML3__HoldAcknowledge_template(ANY_VALUE);
else single_value.field_holdAcknowledge = new PDU__ML3__HoldAcknowledge_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_holdAcknowledge;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_holdAcknowledge;
}

const PDU__ML3__HoldAcknowledge_template& PDU__ML3__CC__NW__MS_template::holdAcknowledge() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field holdAcknowledge in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_holdAcknowledge) TTCN_error("Accessing non-selected field holdAcknowledge in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_holdAcknowledge;
}

PDU__ML3__HoldReject_template& PDU__ML3__CC__NW__MS_template::holdReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_holdReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_holdReject = new PDU__ML3__HoldReject_template(ANY_VALUE);
else single_value.field_holdReject = new PDU__ML3__HoldReject_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_holdReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_holdReject;
}

const PDU__ML3__HoldReject_template& PDU__ML3__CC__NW__MS_template::holdReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field holdReject in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_holdReject) TTCN_error("Accessing non-selected field holdReject in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_holdReject;
}

PDU__ML3__RetrieveAck_template& PDU__ML3__CC__NW__MS_template::retrieveAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_retrieveAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_retrieveAck = new PDU__ML3__RetrieveAck_template(ANY_VALUE);
else single_value.field_retrieveAck = new PDU__ML3__RetrieveAck_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_retrieveAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_retrieveAck;
}

const PDU__ML3__RetrieveAck_template& PDU__ML3__CC__NW__MS_template::retrieveAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field retrieveAck in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_retrieveAck) TTCN_error("Accessing non-selected field retrieveAck in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_retrieveAck;
}

PDU__ML3__RetrieveRej_template& PDU__ML3__CC__NW__MS_template::retrieveRej()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_retrieveRej) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_retrieveRej = new PDU__ML3__RetrieveRej_template(ANY_VALUE);
else single_value.field_retrieveRej = new PDU__ML3__RetrieveRej_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_retrieveRej;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_retrieveRej;
}

const PDU__ML3__RetrieveRej_template& PDU__ML3__CC__NW__MS_template::retrieveRej() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field retrieveRej in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_retrieveRej) TTCN_error("Accessing non-selected field retrieveRej in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_retrieveRej;
}

PDU__ML3__CongestionControl_template& PDU__ML3__CC__NW__MS_template::congestionControl()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_congestionControl) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_congestionControl = new PDU__ML3__CongestionControl_template(ANY_VALUE);
else single_value.field_congestionControl = new PDU__ML3__CongestionControl_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_congestionControl;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_congestionControl;
}

const PDU__ML3__CongestionControl_template& PDU__ML3__CC__NW__MS_template::congestionControl() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field congestionControl in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_congestionControl) TTCN_error("Accessing non-selected field congestionControl in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_congestionControl;
}

PDU__ML3__Notify_template& PDU__ML3__CC__NW__MS_template::notify()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_notify) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_notify = new PDU__ML3__Notify_template(ANY_VALUE);
else single_value.field_notify = new PDU__ML3__Notify_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_notify;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_notify;
}

const PDU__ML3__Notify_template& PDU__ML3__CC__NW__MS_template::notify() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field notify in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_notify) TTCN_error("Accessing non-selected field notify in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_notify;
}

PDU__ML3__StartDTMFAck_template& PDU__ML3__CC__NW__MS_template::startDTMFAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_startDTMFAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_startDTMFAck = new PDU__ML3__StartDTMFAck_template(ANY_VALUE);
else single_value.field_startDTMFAck = new PDU__ML3__StartDTMFAck_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_startDTMFAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_startDTMFAck;
}

const PDU__ML3__StartDTMFAck_template& PDU__ML3__CC__NW__MS_template::startDTMFAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field startDTMFAck in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_startDTMFAck) TTCN_error("Accessing non-selected field startDTMFAck in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_startDTMFAck;
}

PDU__ML3__StartDTMFRej_template& PDU__ML3__CC__NW__MS_template::startDTMFRej()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_startDTMFRej) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_startDTMFRej = new PDU__ML3__StartDTMFRej_template(ANY_VALUE);
else single_value.field_startDTMFRej = new PDU__ML3__StartDTMFRej_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_startDTMFRej;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_startDTMFRej;
}

const PDU__ML3__StartDTMFRej_template& PDU__ML3__CC__NW__MS_template::startDTMFRej() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field startDTMFRej in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_startDTMFRej) TTCN_error("Accessing non-selected field startDTMFRej in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_startDTMFRej;
}

PDU__ML3__Status_template& PDU__ML3__CC__NW__MS_template::status()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_status) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_status = new PDU__ML3__Status_template(ANY_VALUE);
else single_value.field_status = new PDU__ML3__Status_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_status;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_status;
}

const PDU__ML3__Status_template& PDU__ML3__CC__NW__MS_template::status() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field status in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_status) TTCN_error("Accessing non-selected field status in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_status;
}

PDU__ML3__StatusEnquiry_template& PDU__ML3__CC__NW__MS_template::statusEnquiry()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_statusEnquiry) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template(ANY_VALUE);
else single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_statusEnquiry;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_statusEnquiry;
}

const PDU__ML3__StatusEnquiry_template& PDU__ML3__CC__NW__MS_template::statusEnquiry() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field statusEnquiry in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_statusEnquiry) TTCN_error("Accessing non-selected field statusEnquiry in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_statusEnquiry;
}

PDU__ML3__StopDTMFAck_template& PDU__ML3__CC__NW__MS_template::stopDTMFAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_stopDTMFAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_stopDTMFAck = new PDU__ML3__StopDTMFAck_template(ANY_VALUE);
else single_value.field_stopDTMFAck = new PDU__ML3__StopDTMFAck_template;
single_value.union_selection = PDU__ML3__CC__NW__MS::ALT_stopDTMFAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_stopDTMFAck;
}

const PDU__ML3__StopDTMFAck_template& PDU__ML3__CC__NW__MS_template::stopDTMFAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field stopDTMFAck in a non-specific template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
if (single_value.union_selection != PDU__ML3__CC__NW__MS::ALT_stopDTMFAck) TTCN_error("Accessing non-selected field stopDTMFAck in a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return *single_value.field_stopDTMFAck;
}

boolean PDU__ML3__CC__NW__MS_template::ischosen(PDU__ML3__CC__NW__MS::union_selection_type checked_selection) const
{
if (checked_selection == PDU__ML3__CC__NW__MS::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PDU__ML3__CC__NW__MS::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__CC__NW__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
TTCN_Logger::log_event_str("{ alerting_NW_MS := ");
single_value.field_alerting__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
TTCN_Logger::log_event_str("{ callConfirmed := ");
single_value.field_callConfirmed->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
TTCN_Logger::log_event_str("{ callProceeding := ");
single_value.field_callProceeding->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
TTCN_Logger::log_event_str("{ connect_NW_MS := ");
single_value.field_connect__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
TTCN_Logger::log_event_str("{ connectAck := ");
single_value.field_connectAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
TTCN_Logger::log_event_str("{ progress := ");
single_value.field_progress->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
TTCN_Logger::log_event_str("{ cc_Establishment := ");
single_value.field_cc__Establishment->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
TTCN_Logger::log_event_str("{ setup_NW_MS := ");
single_value.field_setup__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
TTCN_Logger::log_event_str("{ modify := ");
single_value.field_modify->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
TTCN_Logger::log_event_str("{ modifyComplete := ");
single_value.field_modifyComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
TTCN_Logger::log_event_str("{ modifyReject := ");
single_value.field_modifyReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
TTCN_Logger::log_event_str("{ userInformation := ");
single_value.field_userInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
TTCN_Logger::log_event_str("{ disconnect_NW_MS := ");
single_value.field_disconnect__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
TTCN_Logger::log_event_str("{ release_NW_MS := ");
single_value.field_release__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
single_value.field_releaseComplete__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
TTCN_Logger::log_event_str("{ holdAcknowledge := ");
single_value.field_holdAcknowledge->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
TTCN_Logger::log_event_str("{ holdReject := ");
single_value.field_holdReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
TTCN_Logger::log_event_str("{ retrieveAck := ");
single_value.field_retrieveAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
TTCN_Logger::log_event_str("{ retrieveRej := ");
single_value.field_retrieveRej->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
TTCN_Logger::log_event_str("{ congestionControl := ");
single_value.field_congestionControl->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
TTCN_Logger::log_event_str("{ notify := ");
single_value.field_notify->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
TTCN_Logger::log_event_str("{ startDTMFAck := ");
single_value.field_startDTMFAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
TTCN_Logger::log_event_str("{ startDTMFRej := ");
single_value.field_startDTMFRej->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_status:
TTCN_Logger::log_event_str("{ status := ");
single_value.field_status->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
TTCN_Logger::log_event_str("{ statusEnquiry := ");
single_value.field_statusEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
TTCN_Logger::log_event_str("{ stopDTMFAck := ");
single_value.field_stopDTMFAck->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__CC__NW__MS_template::log_match(const PDU__ML3__CC__NW__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".alerting_NW_MS");
single_value.field_alerting__NW__MS->log_match(match_value.alerting__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ alerting_NW_MS := ");
single_value.field_alerting__NW__MS->log_match(match_value.alerting__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".callConfirmed");
single_value.field_callConfirmed->log_match(match_value.callConfirmed(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ callConfirmed := ");
single_value.field_callConfirmed->log_match(match_value.callConfirmed(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".callProceeding");
single_value.field_callProceeding->log_match(match_value.callProceeding(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ callProceeding := ");
single_value.field_callProceeding->log_match(match_value.callProceeding(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".connect_NW_MS");
single_value.field_connect__NW__MS->log_match(match_value.connect__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ connect_NW_MS := ");
single_value.field_connect__NW__MS->log_match(match_value.connect__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".connectAck");
single_value.field_connectAck->log_match(match_value.connectAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ connectAck := ");
single_value.field_connectAck->log_match(match_value.connectAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".progress");
single_value.field_progress->log_match(match_value.progress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ progress := ");
single_value.field_progress->log_match(match_value.progress(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cc_Establishment");
single_value.field_cc__Establishment->log_match(match_value.cc__Establishment(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cc_Establishment := ");
single_value.field_cc__Establishment->log_match(match_value.cc__Establishment(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".setup_NW_MS");
single_value.field_setup__NW__MS->log_match(match_value.setup__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ setup_NW_MS := ");
single_value.field_setup__NW__MS->log_match(match_value.setup__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modify");
single_value.field_modify->log_match(match_value.modify(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modify := ");
single_value.field_modify->log_match(match_value.modify(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modifyComplete");
single_value.field_modifyComplete->log_match(match_value.modifyComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modifyComplete := ");
single_value.field_modifyComplete->log_match(match_value.modifyComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".modifyReject");
single_value.field_modifyReject->log_match(match_value.modifyReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ modifyReject := ");
single_value.field_modifyReject->log_match(match_value.modifyReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".userInformation");
single_value.field_userInformation->log_match(match_value.userInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ userInformation := ");
single_value.field_userInformation->log_match(match_value.userInformation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".disconnect_NW_MS");
single_value.field_disconnect__NW__MS->log_match(match_value.disconnect__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ disconnect_NW_MS := ");
single_value.field_disconnect__NW__MS->log_match(match_value.disconnect__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".release_NW_MS");
single_value.field_release__NW__MS->log_match(match_value.release__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ release_NW_MS := ");
single_value.field_release__NW__MS->log_match(match_value.release__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".releaseComplete_NW_MS");
single_value.field_releaseComplete__NW__MS->log_match(match_value.releaseComplete__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
single_value.field_releaseComplete__NW__MS->log_match(match_value.releaseComplete__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".facility");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".holdAcknowledge");
single_value.field_holdAcknowledge->log_match(match_value.holdAcknowledge(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ holdAcknowledge := ");
single_value.field_holdAcknowledge->log_match(match_value.holdAcknowledge(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".holdReject");
single_value.field_holdReject->log_match(match_value.holdReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ holdReject := ");
single_value.field_holdReject->log_match(match_value.holdReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".retrieveAck");
single_value.field_retrieveAck->log_match(match_value.retrieveAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ retrieveAck := ");
single_value.field_retrieveAck->log_match(match_value.retrieveAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".retrieveRej");
single_value.field_retrieveRej->log_match(match_value.retrieveRej(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ retrieveRej := ");
single_value.field_retrieveRej->log_match(match_value.retrieveRej(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".congestionControl");
single_value.field_congestionControl->log_match(match_value.congestionControl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ congestionControl := ");
single_value.field_congestionControl->log_match(match_value.congestionControl(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".notify");
single_value.field_notify->log_match(match_value.notify(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ notify := ");
single_value.field_notify->log_match(match_value.notify(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".startDTMFAck");
single_value.field_startDTMFAck->log_match(match_value.startDTMFAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ startDTMFAck := ");
single_value.field_startDTMFAck->log_match(match_value.startDTMFAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".startDTMFRej");
single_value.field_startDTMFRej->log_match(match_value.startDTMFRej(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ startDTMFRej := ");
single_value.field_startDTMFRej->log_match(match_value.startDTMFRej(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_status:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".status");
single_value.field_status->log_match(match_value.status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ status := ");
single_value.field_status->log_match(match_value.status(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".statusEnquiry");
single_value.field_statusEnquiry->log_match(match_value.statusEnquiry(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ statusEnquiry := ");
single_value.field_statusEnquiry->log_match(match_value.statusEnquiry(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".stopDTMFAck");
single_value.field_stopDTMFAck->log_match(match_value.stopDTMFAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ stopDTMFAck := ");
single_value.field_stopDTMFAck->log_match(match_value.stopDTMFAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__CC__NW__MS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry->set_implicit_omit(); break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__CC__NW__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry->encode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}

void PDU__ML3__CC__NW__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PDU__ML3__CC__NW__MS::UNBOUND_VALUE;
PDU__ML3__CC__NW__MS::union_selection_type new_selection = (PDU__ML3__CC__NW__MS::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS = new PDU__ML3__Alerting__NW__MS_template;
single_value.field_alerting__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed = new PDU__ML3__CallConfirmed_template;
single_value.field_callConfirmed->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding = new PDU__ML3__CallProceeding_template;
single_value.field_callProceeding->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS = new PDU__ML3__Connect__NW__MS_template;
single_value.field_connect__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck = new PDU__ML3__ConnectAck_template;
single_value.field_connectAck->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress = new PDU__ML3__Progress_template;
single_value.field_progress->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment = new PDU__ML3__CC__Establishment_template;
single_value.field_cc__Establishment->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS = new PDU__ML3__Setup__NW__MS_template;
single_value.field_setup__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify = new PDU__ML3__Modify_template;
single_value.field_modify->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete = new PDU__ML3__ModifyComplete_template;
single_value.field_modifyComplete->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject = new PDU__ML3__ModifyReject_template;
single_value.field_modifyReject->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation = new PDU__ML3__UserInformation_template;
single_value.field_userInformation->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS = new PDU__ML3__Disconnect__NW__MS_template;
single_value.field_disconnect__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS = new PDU__ML3__Release__NW__MS_template;
single_value.field_release__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__ReleaseComplete__NW__MS_template;
single_value.field_releaseComplete__NW__MS->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__Facility_template;
single_value.field_facility->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge = new PDU__ML3__HoldAcknowledge_template;
single_value.field_holdAcknowledge->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject = new PDU__ML3__HoldReject_template;
single_value.field_holdReject->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck = new PDU__ML3__RetrieveAck_template;
single_value.field_retrieveAck->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej = new PDU__ML3__RetrieveRej_template;
single_value.field_retrieveRej->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl = new PDU__ML3__CongestionControl_template;
single_value.field_congestionControl->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify = new PDU__ML3__Notify_template;
single_value.field_notify->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck = new PDU__ML3__StartDTMFAck_template;
single_value.field_startDTMFAck->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej = new PDU__ML3__StartDTMFRej_template;
single_value.field_startDTMFRej->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status = new PDU__ML3__Status_template;
single_value.field_status->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry = new PDU__ML3__StatusEnquiry_template;
single_value.field_statusEnquiry->decode_text(text_buf);
break;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck = new PDU__ML3__StopDTMFAck_template;
single_value.field_stopDTMFAck->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__CC__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
}

boolean PDU__ML3__CC__NW__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__CC__NW__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__CC__NW__MS_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MobileL3_CC_Types.PDU_ML3_CC_NW_MS'");
    }
    if (strcmp("alerting_NW_MS", param_field) == 0) {
      alerting__NW__MS().set_param(param);
      return;
    } else if (strcmp("callConfirmed", param_field) == 0) {
      callConfirmed().set_param(param);
      return;
    } else if (strcmp("callProceeding", param_field) == 0) {
      callProceeding().set_param(param);
      return;
    } else if (strcmp("connect_NW_MS", param_field) == 0) {
      connect__NW__MS().set_param(param);
      return;
    } else if (strcmp("connectAck", param_field) == 0) {
      connectAck().set_param(param);
      return;
    } else if (strcmp("progress", param_field) == 0) {
      progress().set_param(param);
      return;
    } else if (strcmp("cc_Establishment", param_field) == 0) {
      cc__Establishment().set_param(param);
      return;
    } else if (strcmp("setup_NW_MS", param_field) == 0) {
      setup__NW__MS().set_param(param);
      return;
    } else if (strcmp("modify", param_field) == 0) {
      modify().set_param(param);
      return;
    } else if (strcmp("modifyComplete", param_field) == 0) {
      modifyComplete().set_param(param);
      return;
    } else if (strcmp("modifyReject", param_field) == 0) {
      modifyReject().set_param(param);
      return;
    } else if (strcmp("userInformation", param_field) == 0) {
      userInformation().set_param(param);
      return;
    } else if (strcmp("disconnect_NW_MS", param_field) == 0) {
      disconnect__NW__MS().set_param(param);
      return;
    } else if (strcmp("release_NW_MS", param_field) == 0) {
      release__NW__MS().set_param(param);
      return;
    } else if (strcmp("releaseComplete_NW_MS", param_field) == 0) {
      releaseComplete__NW__MS().set_param(param);
      return;
    } else if (strcmp("facility", param_field) == 0) {
      facility().set_param(param);
      return;
    } else if (strcmp("holdAcknowledge", param_field) == 0) {
      holdAcknowledge().set_param(param);
      return;
    } else if (strcmp("holdReject", param_field) == 0) {
      holdReject().set_param(param);
      return;
    } else if (strcmp("retrieveAck", param_field) == 0) {
      retrieveAck().set_param(param);
      return;
    } else if (strcmp("retrieveRej", param_field) == 0) {
      retrieveRej().set_param(param);
      return;
    } else if (strcmp("congestionControl", param_field) == 0) {
      congestionControl().set_param(param);
      return;
    } else if (strcmp("notify", param_field) == 0) {
      notify().set_param(param);
      return;
    } else if (strcmp("startDTMFAck", param_field) == 0) {
      startDTMFAck().set_param(param);
      return;
    } else if (strcmp("startDTMFRej", param_field) == 0) {
      startDTMFRej().set_param(param);
      return;
    } else if (strcmp("status", param_field) == 0) {
      status().set_param(param);
      return;
    } else if (strcmp("statusEnquiry", param_field) == 0) {
      statusEnquiry().set_param(param);
      return;
    } else if (strcmp("stopDTMFAck", param_field) == 0) {
      stopDTMFAck().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MobileL3_CC_Types.PDU_ML3_CC_NW_MS'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__CC__NW__MS_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "alerting_NW_MS")) {
      alerting__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "callConfirmed")) {
      callConfirmed().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "callProceeding")) {
      callProceeding().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "connect_NW_MS")) {
      connect__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "connectAck")) {
      connectAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "progress")) {
      progress().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cc_Establishment")) {
      cc__Establishment().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "setup_NW_MS")) {
      setup__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modify")) {
      modify().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modifyComplete")) {
      modifyComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "modifyReject")) {
      modifyReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "userInformation")) {
      userInformation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "disconnect_NW_MS")) {
      disconnect__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "release_NW_MS")) {
      release__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "releaseComplete_NW_MS")) {
      releaseComplete__NW__MS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "facility")) {
      facility().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "holdAcknowledge")) {
      holdAcknowledge().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "holdReject")) {
      holdReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "retrieveAck")) {
      retrieveAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "retrieveRej")) {
      retrieveRej().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "congestionControl")) {
      congestionControl().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "notify")) {
      notify().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "startDTMFAck")) {
      startDTMFAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "startDTMFRej")) {
      startDTMFRej().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "status")) {
      status().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "statusEnquiry")) {
      statusEnquiry().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "stopDTMFAck")) {
      stopDTMFAck().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__CC__NW__MS_template* precondition = new PDU__ML3__CC__NW__MS_template;
    precondition->set_param(*m_p->get_elem(0));
    PDU__ML3__CC__NW__MS_template* implied_template = new PDU__ML3__CC__NW__MS_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PDU__ML3__CC__NW__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__CC__NW__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PDU__ML3__CC__NW__MS::ALT_alerting__NW__MS:
single_value.field_alerting__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_callConfirmed:
single_value.field_callConfirmed->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_callProceeding:
single_value.field_callProceeding->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_connect__NW__MS:
single_value.field_connect__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_connectAck:
single_value.field_connectAck->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_progress:
single_value.field_progress->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_cc__Establishment:
single_value.field_cc__Establishment->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_setup__NW__MS:
single_value.field_setup__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_modify:
single_value.field_modify->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_modifyComplete:
single_value.field_modifyComplete->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_modifyReject:
single_value.field_modifyReject->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_userInformation:
single_value.field_userInformation->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_disconnect__NW__MS:
single_value.field_disconnect__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_release__NW__MS:
single_value.field_release__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_facility:
single_value.field_facility->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_holdAcknowledge:
single_value.field_holdAcknowledge->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_holdReject:
single_value.field_holdReject->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_retrieveAck:
single_value.field_retrieveAck->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_retrieveRej:
single_value.field_retrieveRej->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_congestionControl:
single_value.field_congestionControl->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_notify:
single_value.field_notify->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_startDTMFAck:
single_value.field_startDTMFAck->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_startDTMFRej:
single_value.field_startDTMFRej->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_status:
single_value.field_status->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_statusEnquiry:
single_value.field_statusEnquiry->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
case PDU__ML3__CC__NW__MS::ALT_stopDTMFAck:
single_value.field_stopDTMFAck->check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MobileL3_CC_Types.PDU_ML3_CC_NW_MS.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CC_NW_MS");
}


/* Bodies of functions, altsteps and testcases */

void AuxiliaryStates__TLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AuxiliaryStates__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AuxiliaryStates__TLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AuxiliaryStates__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AuxiliaryStates__TLV_encoder(const AuxiliaryStates__TLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AuxiliaryStates_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AuxiliaryStates__TLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AuxiliaryStates__TLV_decoder(OCTETSTRING& input_stream, AuxiliaryStates__TLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AuxiliaryStates_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AuxiliaryStates__TLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AuxiliaryStates__LV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AuxiliaryStates__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AuxiliaryStates__LV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AuxiliaryStates__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AuxiliaryStates__LV_encoder(const AuxiliaryStates__LV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AuxiliaryStates_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AuxiliaryStates__LV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AuxiliaryStates__LV_decoder(OCTETSTRING& input_stream, AuxiliaryStates__LV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AuxiliaryStates_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AuxiliaryStates__LV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BBC__octet3_encoder(const BBC__octet3& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BBC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BBC__octet3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BBC__octet3_decoder(OCTETSTRING& input_stream, BBC__octet3& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BBC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BBC__octet3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BBC__octet5_encoder(const BBC__octet5& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BBC_octet5' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BBC__octet5_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BBC__octet5_decoder(OCTETSTRING& input_stream, BBC__octet5& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BBC_octet5' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BBC__octet5_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BackupBearerCapacity_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BackupBearerCapacity_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BackupBearerCapacity_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BackupBearerCapacity_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BC__octet4_encoder(const BC__octet4& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BC__octet4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BC__octet4_decoder(OCTETSTRING& input_stream, BC__octet4& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BC__octet4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BC__octet6_encoder(const BC__octet6& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet6' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BC__octet6_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BC__octet6_decoder(OCTETSTRING& input_stream, BC__octet6& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet6' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BC__octet6_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BC__octet7_encoder(const BC__octet7& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet7' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BC__octet7_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BC__octet7_decoder(OCTETSTRING& input_stream, BC__octet7& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet7' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BC__octet7_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BackupBearerCapacity_encoder(const BackupBearerCapacity& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BackupBearerCapacity' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BackupBearerCapacity_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BackupBearerCapacity_decoder(OCTETSTRING& input_stream, BackupBearerCapacity& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BackupBearerCapacity' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BackupBearerCapacity_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BC__octet5_encoder(const BC__octet5& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet5' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BC__octet5_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BC__octet5_decoder(OCTETSTRING& input_stream, BC__octet5& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet5' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BC__octet5_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Speech__AuxiliarySpeech_encoder(const Speech__AuxiliarySpeech& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.Speech_AuxiliarySpeech' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Speech__AuxiliarySpeech_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Speech__AuxiliarySpeech_decoder(OCTETSTRING& input_stream, Speech__AuxiliarySpeech& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.Speech_AuxiliarySpeech' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Speech__AuxiliarySpeech_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const Speech__AuxiliarySpeech__List& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @MobileL3_CC_Types.Speech_AuxiliarySpeech_List.");
return other_value.val_ptr->n_elements == 0;
}

void Speech__AuxiliarySpeech__List_encoder(const Speech__AuxiliarySpeech__List& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.Speech_AuxiliarySpeech_List' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Speech__AuxiliarySpeech__List_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Speech__AuxiliarySpeech__List_decoder(OCTETSTRING& input_stream, Speech__AuxiliarySpeech__List& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.Speech_AuxiliarySpeech_List' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Speech__AuxiliarySpeech__List_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BC__octet3_encoder(const BC__octet3& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BC__octet3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BC__octet3_decoder(OCTETSTRING& input_stream, BC__octet3& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BC__octet3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerCapability__TLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerCapability__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerCapability__TLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerCapability__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerCapability__TLV_encoder(const BearerCapability__TLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BearerCapability_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerCapability__TLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerCapability__TLV_decoder(OCTETSTRING& input_stream, BearerCapability__TLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BearerCapability_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerCapability__TLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerCapability__LV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerCapability__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerCapability__LV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerCapability__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerCapability__LV_encoder(const BearerCapability__LV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BearerCapability_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerCapability__LV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerCapability__LV_decoder(OCTETSTRING& input_stream, BearerCapability__LV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.BearerCapability_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerCapability__LV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallControlCapabilities_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallControlCapabilities_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallControlCapabilities_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallControlCapabilities_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallControlCapabilities_encoder(const CallControlCapabilities& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallControlCapabilities' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallControlCapabilities_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallControlCapabilities_decoder(OCTETSTRING& input_stream, CallControlCapabilities& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallControlCapabilities' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallControlCapabilities_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallState__V_encoder(const CallState__V& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallState_V' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallState__V_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallState__V_decoder(OCTETSTRING& input_stream, CallState__V& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallState_V' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallState__V_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallState__TV_encoder(const CallState__TV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallState_TV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallState__TV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallState__TV_decoder(OCTETSTRING& input_stream, CallState__TV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallState_TV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallState__TV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CalledPartyBCD__Number_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CalledPartyBCD__Number_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CalledPartyBCD__Number_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CalledPartyBCD__Number_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CalledPartyBCD__Number_digits_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CalledPartyBCD__Number_digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CalledPartyBCD__Number_digits_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CalledPartyBCD__Number_digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CalledPartyBCD__Number_encoder(const CalledPartyBCD__Number& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CalledPartyBCD_Number' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CalledPartyBCD__Number_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CalledPartyBCD__Number_decoder(OCTETSTRING& input_stream, CalledPartyBCD__Number& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CalledPartyBCD_Number' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CalledPartyBCD__Number_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CalledPartySubAddress_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CalledPartySubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CalledPartySubAddress_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CalledPartySubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CalledPartySubAddress_encoder(const CalledPartySubAddress& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CalledPartySubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CalledPartySubAddress_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CalledPartySubAddress_decoder(OCTETSTRING& input_stream, CalledPartySubAddress& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CalledPartySubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CalledPartySubAddress_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingOrCalled__Number__oct3_encoder(const CallingOrCalled__Number__oct3& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingOrCalled_Number_oct3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingOrCalled__Number__oct3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingOrCalled__Number__oct3_decoder(OCTETSTRING& input_stream, CallingOrCalled__Number__oct3& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingOrCalled_Number_oct3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingOrCalled__Number__oct3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingPartyBCD__Number_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingPartyBCD__Number_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingPartyBCD__Number_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingPartyBCD__Number_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingPartyBCD__Number_digits_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingPartyBCD__Number_digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingPartyBCD__Number_digits_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingPartyBCD__Number_digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingPartyBCD__Number_encoder(const CallingPartyBCD__Number& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingPartyBCD_Number' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingPartyBCD__Number_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingPartyBCD__Number_decoder(OCTETSTRING& input_stream, CallingPartyBCD__Number& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingPartyBCD_Number' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingPartyBCD__Number_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingPartySubAddress_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingPartySubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingPartySubAddress_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingPartySubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallingPartySubAddress_encoder(const CallingPartySubAddress& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingPartySubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallingPartySubAddress_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallingPartySubAddress_decoder(OCTETSTRING& input_stream, CallingPartySubAddress& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CallingPartySubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallingPartySubAddress_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CLIR_encoder(const CLIR& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CLIR' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CLIR_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CLIR_decoder(OCTETSTRING& input_stream, CLIR& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CLIR' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CLIR_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CongestionLevel_encoder(const CongestionLevel& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CongestionLevel' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CongestionLevel_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CongestionLevel_decoder(OCTETSTRING& input_stream, CongestionLevel& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CongestionLevel' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CongestionLevel_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ConnectedNumber_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ConnectedNumber_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ConnectedNumber_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ConnectedNumber_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ConnectedNumber_digits_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ConnectedNumber_digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ConnectedNumber_digits_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ConnectedNumber_digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ConnectedNumber_encoder(const ConnectedNumber& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ConnectedNumber' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ConnectedNumber_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ConnectedNumber_decoder(OCTETSTRING& input_stream, ConnectedNumber& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ConnectedNumber' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ConnectedNumber_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ConnectedSubAddress_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ConnectedSubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ConnectedSubAddress_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ConnectedSubAddress_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ConnectedSubAddress_encoder(const ConnectedSubAddress& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ConnectedSubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ConnectedSubAddress_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ConnectedSubAddress_decoder(OCTETSTRING& input_stream, ConnectedSubAddress& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ConnectedSubAddress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ConnectedSubAddress_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void HLC__octet3_encoder(const HLC__octet3& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HLC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(HLC__octet3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER HLC__octet3_decoder(OCTETSTRING& input_stream, HLC__octet3& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HLC_octet3' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(HLC__octet3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void HLC__octet4_encoder(const HLC__octet4& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HLC_octet4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(HLC__octet4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER HLC__octet4_decoder(OCTETSTRING& input_stream, HLC__octet4& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HLC_octet4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(HLC__octet4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void HighLayerCompatibility_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(HighLayerCompatibility_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER HighLayerCompatibility_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(HighLayerCompatibility_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void HighLayerCompatibility_encoder(const HighLayerCompatibility& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HighLayerCompatibility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(HighLayerCompatibility_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER HighLayerCompatibility_decoder(OCTETSTRING& input_stream, HighLayerCompatibility& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.HighLayerCompatibility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(HighLayerCompatibility_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void KeypadFacility_encoder(const KeypadFacility& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.KeypadFacility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(KeypadFacility_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER KeypadFacility_decoder(OCTETSTRING& input_stream, KeypadFacility& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.KeypadFacility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(KeypadFacility_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void LowLayerCompatibility_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LowLayerCompatibility_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LowLayerCompatibility_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LowLayerCompatibility_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void LowLayerCompatibility_lowLayerCompatibilityContents_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LowLayerCompatibility_lowLayerCompatibilityContents_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void LowLayerCompatibility_encoder(const LowLayerCompatibility& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.LowLayerCompatibility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LowLayerCompatibility_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LowLayerCompatibility_decoder(OCTETSTRING& input_stream, LowLayerCompatibility& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.LowLayerCompatibility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LowLayerCompatibility_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NotificationIndicator_encoder(const NotificationIndicator& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NotificationIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NotificationIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NotificationIndicator_decoder(OCTETSTRING& input_stream, NotificationIndicator& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NotificationIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NotificationIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ProgressIndicator__LV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ProgressIndicator__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ProgressIndicator__LV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ProgressIndicator__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ProgressIndicator__LV_encoder(const ProgressIndicator__LV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ProgressIndicator_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ProgressIndicator__LV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ProgressIndicator__LV_decoder(OCTETSTRING& input_stream, ProgressIndicator__LV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ProgressIndicator_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ProgressIndicator__LV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ProgressIndicator__TLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ProgressIndicator__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ProgressIndicator__TLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ProgressIndicator__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ProgressIndicator__TLV_encoder(const ProgressIndicator__TLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ProgressIndicator_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ProgressIndicator__TLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ProgressIndicator__TLV_decoder(OCTETSTRING& input_stream, ProgressIndicator__TLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ProgressIndicator_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ProgressIndicator__TLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RecallType_encoder(const RecallType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RecallType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RecallType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RecallType_decoder(OCTETSTRING& input_stream, RecallType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RecallType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RecallType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RedirectingPartyBCDNumberTLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RedirectingPartyBCDNumberTLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RedirectingPartyBCDNumberTLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RedirectingPartyBCDNumberTLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RedirectingPartyBCDNumberTLV_digits_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RedirectingPartyBCDNumberTLV_digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RedirectingPartyBCDNumberTLV_digits_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RedirectingPartyBCDNumberTLV_digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RedirectingPartyBCDNumberTLV_encoder(const RedirectingPartyBCDNumberTLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RedirectingPartyBCDNumberTLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RedirectingPartyBCDNumberTLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RedirectingPartyBCDNumberTLV_decoder(OCTETSTRING& input_stream, RedirectingPartyBCDNumberTLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RedirectingPartyBCDNumberTLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RedirectingPartyBCDNumberTLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RedirectingPartySubaddressTLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RedirectingPartySubaddressTLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RedirectingPartySubaddressTLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RedirectingPartySubaddressTLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RedirectingPartySubaddressTLV_encoder(const RedirectingPartySubaddressTLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RedirectingPartySubaddressTLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RedirectingPartySubaddressTLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RedirectingPartySubaddressTLV_decoder(OCTETSTRING& input_stream, RedirectingPartySubaddressTLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RedirectingPartySubaddressTLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RedirectingPartySubaddressTLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RepeatIndicator_encoder(const RepeatIndicator& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RepeatIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RepeatIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RepeatIndicator_decoder(OCTETSTRING& input_stream, RepeatIndicator& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.RepeatIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RepeatIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReverseCallSetupDirection_encoder(const ReverseCallSetupDirection& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ReverseCallSetupDirection' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReverseCallSetupDirection_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReverseCallSetupDirection_decoder(OCTETSTRING& input_stream, ReverseCallSetupDirection& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ReverseCallSetupDirection' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReverseCallSetupDirection_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SetupContatinerCCBS_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SetupContatinerCCBS_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SetupContatinerCCBS_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SetupContatinerCCBS_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SetupContatinerCCBS_encoder(const SetupContatinerCCBS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.SetupContatinerCCBS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SetupContatinerCCBS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SetupContatinerCCBS_decoder(OCTETSTRING& input_stream, SetupContatinerCCBS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.SetupContatinerCCBS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SetupContatinerCCBS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SetupContatinerCCBS__LV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SetupContatinerCCBS__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SetupContatinerCCBS__LV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SetupContatinerCCBS__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SetupContatinerCCBS__LV_encoder(const SetupContatinerCCBS__LV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.SetupContatinerCCBS_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SetupContatinerCCBS__LV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SetupContatinerCCBS__LV_decoder(OCTETSTRING& input_stream, SetupContatinerCCBS__LV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.SetupContatinerCCBS_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SetupContatinerCCBS__LV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ML3__Signal_encoder(const ML3__Signal& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ML3_Signal' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ML3__Signal_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ML3__Signal_decoder(OCTETSTRING& input_stream, ML3__Signal& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ML3_Signal' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ML3__Signal_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__LV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__user__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__LV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__user__LV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__LV_user__userInformation_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__LV_user__userInformation_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__LV_encoder(const User__user__LV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_user_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__user__LV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__LV_decoder(OCTETSTRING& input_stream, User__user__LV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_user_LV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__user__LV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__TLV_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__user__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__TLV_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__user__TLV_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__TLV_user__userInformation_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__TLV_user__userInformation_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__user__TLV_encoder(const User__user__TLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_user_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__user__TLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__user__TLV_decoder(OCTETSTRING& input_stream, User__user__TLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_user_TLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__user__TLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__userShort_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__userShort_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__userShort_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__userShort_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__userShort_user__userInformation_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__userShort_user__userInformation_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void User__userShort_encoder(const User__userShort& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_userShort' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(User__userShort_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER User__userShort_decoder(OCTETSTRING& input_stream, User__userShort& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.User_userShort' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(User__userShort_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AlertingPattern_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AlertingPattern_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AlertingPattern_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AlertingPattern_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AlertingPattern_encoder(const AlertingPattern& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AlertingPattern' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AlertingPattern_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AlertingPattern_decoder(OCTETSTRING& input_stream, AlertingPattern& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AlertingPattern' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AlertingPattern_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AllowedActions_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AllowedActions_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AllowedActions_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AllowedActions_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AllowedActions_encoder(const AllowedActions& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AllowedActions' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AllowedActions_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AllowedActions_decoder(OCTETSTRING& input_stream, AllowedActions& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.AllowedActions' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AllowedActions_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void StreamIdentifier_lengthf_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(StreamIdentifier_lengthf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER StreamIdentifier_lengthf_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(StreamIdentifier_lengthf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void StreamIdentifier_encoder(const StreamIdentifier& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.StreamIdentifier' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(StreamIdentifier_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER StreamIdentifier_decoder(OCTETSTRING& input_stream, StreamIdentifier& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.StreamIdentifier' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(StreamIdentifier_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NetworkCallControlCapabilities_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NetworkCallControlCapabilities_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NetworkCallControlCapabilities_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NetworkCallControlCapabilities_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NetworkCallControlCapabilities_encoder(const NetworkCallControlCapabilities& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NetworkCallControlCapabilities' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NetworkCallControlCapabilities_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NetworkCallControlCapabilities_decoder(OCTETSTRING& input_stream, NetworkCallControlCapabilities& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NetworkCallControlCapabilities' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NetworkCallControlCapabilities_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CauseofNoCli_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CauseofNoCli_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CauseofNoCli_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CauseofNoCli_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CauseofNoCli_encoder(const CauseofNoCli& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CauseofNoCli' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CauseofNoCli_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CauseofNoCli_decoder(OCTETSTRING& input_stream, CauseofNoCli& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.CauseofNoCli' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CauseofNoCli_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ServiceCategory_lengthIndicator_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ServiceCategory_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ServiceCategory_lengthIndicator_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ServiceCategory_lengthIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ServiceCategory_encoder(const ServiceCategory& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ServiceCategory' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ServiceCategory_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ServiceCategory_decoder(OCTETSTRING& input_stream, ServiceCategory& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.ServiceCategory' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ServiceCategory_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NetworkInitiatedServiceUpgradeIndicator_encoder(const NetworkInitiatedServiceUpgradeIndicator& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NetworkInitiatedServiceUpgradeIndicator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NetworkInitiatedServiceUpgradeIndicator_decoder(OCTETSTRING& input_stream, NetworkInitiatedServiceUpgradeIndicator& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NetworkInitiatedServiceUpgradeIndicator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Alerting__NW__MS_encoder(const PDU__ML3__Alerting__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Alerting__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Alerting__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__Alerting__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Alerting__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Alerting__MS__NW_encoder(const PDU__ML3__Alerting__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Alerting__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Alerting__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__Alerting__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Alerting__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CallConfirmed_encoder(const PDU__ML3__CallConfirmed& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CallConfirmed' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CallConfirmed_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CallConfirmed_decoder(OCTETSTRING& input_stream, PDU__ML3__CallConfirmed& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CallConfirmed' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CallConfirmed_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CallProceeding_encoder(const PDU__ML3__CallProceeding& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CallProceeding' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CallProceeding_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CallProceeding_decoder(OCTETSTRING& input_stream, PDU__ML3__CallProceeding& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CallProceeding' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CallProceeding_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CongestionControl_encoder(const PDU__ML3__CongestionControl& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CongestionControl' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CongestionControl_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CongestionControl_decoder(OCTETSTRING& input_stream, PDU__ML3__CongestionControl& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CongestionControl' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CongestionControl_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Connect__NW__MS_encoder(const PDU__ML3__Connect__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Connect__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Connect__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__Connect__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Connect__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Connect__MS__NW_encoder(const PDU__ML3__Connect__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Connect__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Connect__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__Connect__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Connect__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__ConnectAck_encoder(const PDU__ML3__ConnectAck& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ConnectAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__ConnectAck_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__ConnectAck_decoder(OCTETSTRING& input_stream, PDU__ML3__ConnectAck& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ConnectAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__ConnectAck_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Disconnect__NW__MS_encoder(const PDU__ML3__Disconnect__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Disconnect_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Disconnect__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Disconnect__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__Disconnect__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Disconnect_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Disconnect__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Disconnect__MS__NW_encoder(const PDU__ML3__Disconnect__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Disconnect_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Disconnect__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Disconnect__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__Disconnect__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Disconnect_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Disconnect__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__EmergencySetup_encoder(const PDU__ML3__EmergencySetup& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_EmergencySetup' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__EmergencySetup_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__EmergencySetup_decoder(OCTETSTRING& input_stream, PDU__ML3__EmergencySetup& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_EmergencySetup' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__EmergencySetup_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Facility_encoder(const PDU__ML3__Facility& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Facility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Facility_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Facility_decoder(OCTETSTRING& input_stream, PDU__ML3__Facility& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Facility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Facility_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Hold_encoder(const PDU__ML3__Hold& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Hold' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Hold_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Hold_decoder(OCTETSTRING& input_stream, PDU__ML3__Hold& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Hold' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Hold_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__HoldAcknowledge_encoder(const PDU__ML3__HoldAcknowledge& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_HoldAcknowledge' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__HoldAcknowledge_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__HoldAcknowledge_decoder(OCTETSTRING& input_stream, PDU__ML3__HoldAcknowledge& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_HoldAcknowledge' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__HoldAcknowledge_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__HoldReject_encoder(const PDU__ML3__HoldReject& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_HoldReject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__HoldReject_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__HoldReject_decoder(OCTETSTRING& input_stream, PDU__ML3__HoldReject& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_HoldReject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__HoldReject_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Modify_encoder(const PDU__ML3__Modify& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Modify' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Modify_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Modify_decoder(OCTETSTRING& input_stream, PDU__ML3__Modify& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Modify' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Modify_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__ModifyComplete_encoder(const PDU__ML3__ModifyComplete& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ModifyComplete' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__ModifyComplete_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__ModifyComplete_decoder(OCTETSTRING& input_stream, PDU__ML3__ModifyComplete& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ModifyComplete' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__ModifyComplete_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__ModifyReject_encoder(const PDU__ML3__ModifyReject& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ModifyReject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__ModifyReject_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__ModifyReject_decoder(OCTETSTRING& input_stream, PDU__ML3__ModifyReject& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ModifyReject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__ModifyReject_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Notify_encoder(const PDU__ML3__Notify& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Notify' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Notify_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Notify_decoder(OCTETSTRING& input_stream, PDU__ML3__Notify& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Notify' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Notify_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Progress_encoder(const PDU__ML3__Progress& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Progress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Progress_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Progress_decoder(OCTETSTRING& input_stream, PDU__ML3__Progress& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Progress' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Progress_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CC__Establishment_encoder(const PDU__ML3__CC__Establishment& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_Establishment' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CC__Establishment_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CC__Establishment_decoder(OCTETSTRING& input_stream, PDU__ML3__CC__Establishment& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_Establishment' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CC__Establishment_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CC__EstablishmentConf_encoder(const PDU__ML3__CC__EstablishmentConf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_EstablishmentConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CC__EstablishmentConf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CC__EstablishmentConf_decoder(OCTETSTRING& input_stream, PDU__ML3__CC__EstablishmentConf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_EstablishmentConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CC__EstablishmentConf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Release__NW__MS_encoder(const PDU__ML3__Release__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Release_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Release__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Release__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__Release__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Release_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Release__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Release__MS__NW_encoder(const PDU__ML3__Release__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Release_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Release__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Release__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__Release__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Release_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Release__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Recall_encoder(const PDU__ML3__Recall& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Recall' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Recall_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Recall_decoder(OCTETSTRING& input_stream, PDU__ML3__Recall& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Recall' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Recall_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__ReleaseComplete__NW__MS_encoder(const PDU__ML3__ReleaseComplete__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ReleaseComplete_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__ReleaseComplete__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__ReleaseComplete__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__ReleaseComplete__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ReleaseComplete_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__ReleaseComplete__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__ReleaseComplete__MS__NW_encoder(const PDU__ML3__ReleaseComplete__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ReleaseComplete_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__ReleaseComplete__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__ReleaseComplete__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__ReleaseComplete__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_ReleaseComplete_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__ReleaseComplete__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Retrieve_encoder(const PDU__ML3__Retrieve& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Retrieve' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Retrieve_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Retrieve_decoder(OCTETSTRING& input_stream, PDU__ML3__Retrieve& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Retrieve' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Retrieve_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__RetrieveAck_encoder(const PDU__ML3__RetrieveAck& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_RetrieveAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__RetrieveAck_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__RetrieveAck_decoder(OCTETSTRING& input_stream, PDU__ML3__RetrieveAck& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_RetrieveAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__RetrieveAck_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__RetrieveRej_encoder(const PDU__ML3__RetrieveRej& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_RetrieveRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__RetrieveRej_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__RetrieveRej_decoder(OCTETSTRING& input_stream, PDU__ML3__RetrieveRej& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_RetrieveRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__RetrieveRej_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Setup__NW__MS_encoder(const PDU__ML3__Setup__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Setup_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Setup__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Setup__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__Setup__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Setup_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Setup__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Setup__MS__NW_encoder(const PDU__ML3__Setup__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Setup_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Setup__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Setup__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__Setup__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Setup_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Setup__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StartCC_encoder(const PDU__ML3__StartCC& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartCC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StartCC_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StartCC_decoder(OCTETSTRING& input_stream, PDU__ML3__StartCC& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartCC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StartCC_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StartDTMF_encoder(const PDU__ML3__StartDTMF& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMF' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StartDTMF_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StartDTMF_decoder(OCTETSTRING& input_stream, PDU__ML3__StartDTMF& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMF' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StartDTMF_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StartDTMFAck_encoder(const PDU__ML3__StartDTMFAck& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMFAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StartDTMFAck_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StartDTMFAck_decoder(OCTETSTRING& input_stream, PDU__ML3__StartDTMFAck& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMFAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StartDTMFAck_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StartDTMFRej_encoder(const PDU__ML3__StartDTMFRej& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMFRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StartDTMFRej_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StartDTMFRej_decoder(OCTETSTRING& input_stream, PDU__ML3__StartDTMFRej& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StartDTMFRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StartDTMFRej_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__Status_encoder(const PDU__ML3__Status& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Status' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__Status_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__Status_decoder(OCTETSTRING& input_stream, PDU__ML3__Status& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_Status' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__Status_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StatusEnquiry_encoder(const PDU__ML3__StatusEnquiry& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StatusEnquiry' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StatusEnquiry_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StatusEnquiry_decoder(OCTETSTRING& input_stream, PDU__ML3__StatusEnquiry& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StatusEnquiry' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StatusEnquiry_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StopDTMF_encoder(const PDU__ML3__StopDTMF& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StopDTMF' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StopDTMF_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StopDTMF_decoder(OCTETSTRING& input_stream, PDU__ML3__StopDTMF& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StopDTMF' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StopDTMF_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__StopDTMFAck_encoder(const PDU__ML3__StopDTMFAck& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StopDTMFAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__StopDTMFAck_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__StopDTMFAck_decoder(OCTETSTRING& input_stream, PDU__ML3__StopDTMFAck& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_StopDTMFAck' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__StopDTMFAck_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__UserInformation_encoder(const PDU__ML3__UserInformation& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_UserInformation' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__UserInformation_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__UserInformation_decoder(OCTETSTRING& input_stream, PDU__ML3__UserInformation& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_UserInformation' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__UserInformation_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CC__MS__NW_encoder(const PDU__ML3__CC__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CC__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CC__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__CC__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CC__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__CC__NW__MS_encoder(const PDU__ML3__CC__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__CC__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__CC__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__CC__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_CC_Types.PDU_ML3_CC_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__CC__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("MobileL3_CC_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "MobileL3_CC_Types");
MobileL3__CommonIE__Types::module_object.pre_init_module();
}

void post_init_module()
{
TTCN_Location current_location("MobileL3_CC_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "MobileL3_CC_Types");
MobileL3__CommonIE__Types::module_object.post_init_module();
}


} /* end of namespace */
