// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_GMM_SM_Types.hh"

namespace MobileL3__GMM__SM__Types {

/* Member functions of C++ classes */

PDU__GMM__ServiceRequest::PDU__GMM__ServiceRequest()
{
}

PDU__GMM__ServiceRequest::PDU__GMM__ServiceRequest(const BITSTRING& par_messageType,
    const MobileL3__CommonIE__Types::CipheringKeySequenceNumberV& par_cipheringKeySeqNum,
    const ServiceTypeV& par_serviceType,
    const MobileL3__CommonIE__Types::MobileIdentityLV& par_ptmsi,
    const OPTIONAL< PDPContextStatusTLV >& par_pdpContextStatus,
    const OPTIONAL< MBMS__ContextStatusTLV >& par_mBMS__ContextStatus,
    const OPTIONAL< UplinkDataStatusTLV >& par_uplinkDataStatus,
    const OPTIONAL< MobileL3__CommonIE__Types::DevicePropertiesTV >& par_deviceProperties)
  :   field_messageType(par_messageType),
  field_cipheringKeySeqNum(par_cipheringKeySeqNum),
  field_serviceType(par_serviceType),
  field_ptmsi(par_ptmsi),
  field_pdpContextStatus(par_pdpContextStatus),
  field_mBMS__ContextStatus(par_mBMS__ContextStatus),
  field_uplinkDataStatus(par_uplinkDataStatus),
  field_deviceProperties(par_deviceProperties)
{
}

PDU__GMM__ServiceRequest::PDU__GMM__ServiceRequest(const PDU__GMM__ServiceRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cipheringKeySeqNum().is_bound()) field_cipheringKeySeqNum = other_value.cipheringKeySeqNum();
else field_cipheringKeySeqNum.clean_up();
if (other_value.serviceType().is_bound()) field_serviceType = other_value.serviceType();
else field_serviceType.clean_up();
if (other_value.ptmsi().is_bound()) field_ptmsi = other_value.ptmsi();
else field_ptmsi.clean_up();
if (other_value.pdpContextStatus().is_bound()) field_pdpContextStatus = other_value.pdpContextStatus();
else field_pdpContextStatus.clean_up();
if (other_value.mBMS__ContextStatus().is_bound()) field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
else field_mBMS__ContextStatus.clean_up();
if (other_value.uplinkDataStatus().is_bound()) field_uplinkDataStatus = other_value.uplinkDataStatus();
else field_uplinkDataStatus.clean_up();
if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
else field_deviceProperties.clean_up();
}

void PDU__GMM__ServiceRequest::clean_up()
{
field_messageType.clean_up();
field_cipheringKeySeqNum.clean_up();
field_serviceType.clean_up();
field_ptmsi.clean_up();
field_pdpContextStatus.clean_up();
field_mBMS__ContextStatus.clean_up();
field_uplinkDataStatus.clean_up();
field_deviceProperties.clean_up();
}

const TTCN_Typedescriptor_t* PDU__GMM__ServiceRequest::get_descriptor() const { return &PDU__GMM__ServiceRequest_descr_; }
PDU__GMM__ServiceRequest& PDU__GMM__ServiceRequest::operator=(const PDU__GMM__ServiceRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cipheringKeySeqNum().is_bound()) field_cipheringKeySeqNum = other_value.cipheringKeySeqNum();
  else field_cipheringKeySeqNum.clean_up();
  if (other_value.serviceType().is_bound()) field_serviceType = other_value.serviceType();
  else field_serviceType.clean_up();
  if (other_value.ptmsi().is_bound()) field_ptmsi = other_value.ptmsi();
  else field_ptmsi.clean_up();
  if (other_value.pdpContextStatus().is_bound()) field_pdpContextStatus = other_value.pdpContextStatus();
  else field_pdpContextStatus.clean_up();
  if (other_value.mBMS__ContextStatus().is_bound()) field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
  else field_mBMS__ContextStatus.clean_up();
  if (other_value.uplinkDataStatus().is_bound()) field_uplinkDataStatus = other_value.uplinkDataStatus();
  else field_uplinkDataStatus.clean_up();
  if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
  else field_deviceProperties.clean_up();
}
return *this;
}

boolean PDU__GMM__ServiceRequest::operator==(const PDU__GMM__ServiceRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cipheringKeySeqNum==other_value.field_cipheringKeySeqNum
  && field_serviceType==other_value.field_serviceType
  && field_ptmsi==other_value.field_ptmsi
  && field_pdpContextStatus==other_value.field_pdpContextStatus
  && field_mBMS__ContextStatus==other_value.field_mBMS__ContextStatus
  && field_uplinkDataStatus==other_value.field_uplinkDataStatus
  && field_deviceProperties==other_value.field_deviceProperties;
}

boolean PDU__GMM__ServiceRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cipheringKeySeqNum.is_bound())
  || (field_serviceType.is_bound())
  || (field_ptmsi.is_bound())
  || (OPTIONAL_OMIT == field_pdpContextStatus.get_selection() || field_pdpContextStatus.is_bound())
  || (OPTIONAL_OMIT == field_mBMS__ContextStatus.get_selection() || field_mBMS__ContextStatus.is_bound())
  || (OPTIONAL_OMIT == field_uplinkDataStatus.get_selection() || field_uplinkDataStatus.is_bound())
  || (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_bound());
}
boolean PDU__GMM__ServiceRequest::is_value() const
{
return field_messageType.is_value()
  && field_cipheringKeySeqNum.is_value()
  && field_serviceType.is_value()
  && field_ptmsi.is_value()
  && (OPTIONAL_OMIT == field_pdpContextStatus.get_selection() || field_pdpContextStatus.is_value())
  && (OPTIONAL_OMIT == field_mBMS__ContextStatus.get_selection() || field_mBMS__ContextStatus.is_value())
  && (OPTIONAL_OMIT == field_uplinkDataStatus.get_selection() || field_uplinkDataStatus.is_value())
  && (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_value());
}
int PDU__GMM__ServiceRequest::size_of() const
{
  int ret_val = 4;
  if (field_pdpContextStatus.ispresent()) ret_val++;
  if (field_mBMS__ContextStatus.ispresent()) ret_val++;
  if (field_uplinkDataStatus.ispresent()) ret_val++;
  if (field_deviceProperties.ispresent()) ret_val++;
  return ret_val;
}

void PDU__GMM__ServiceRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cipheringKeySeqNum := ");
field_cipheringKeySeqNum.log();
TTCN_Logger::log_event_str(", serviceType := ");
field_serviceType.log();
TTCN_Logger::log_event_str(", ptmsi := ");
field_ptmsi.log();
TTCN_Logger::log_event_str(", pdpContextStatus := ");
field_pdpContextStatus.log();
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(", uplinkDataStatus := ");
field_uplinkDataStatus.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
field_deviceProperties.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__GMM__ServiceRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cipheringKeySeqNum().is_bound()) cipheringKeySeqNum().set_implicit_omit();
if (serviceType().is_bound()) serviceType().set_implicit_omit();
if (ptmsi().is_bound()) ptmsi().set_implicit_omit();
if (!pdpContextStatus().is_bound()) pdpContextStatus() = OMIT_VALUE;
else pdpContextStatus().set_implicit_omit();
if (!mBMS__ContextStatus().is_bound()) mBMS__ContextStatus() = OMIT_VALUE;
else mBMS__ContextStatus().set_implicit_omit();
if (!uplinkDataStatus().is_bound()) uplinkDataStatus() = OMIT_VALUE;
else uplinkDataStatus().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
}

void PDU__GMM__ServiceRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cipheringKeySeqNum().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ptmsi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pdpContextStatus().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mBMS__ContextStatus().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) uplinkDataStatus().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipheringKeySeqNum")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipheringKeySeqNum().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ptmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ptmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_ContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__ContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uplinkDataStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uplinkDataStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
  }
}

void PDU__GMM__ServiceRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cipheringKeySeqNum.encode_text(text_buf);
field_serviceType.encode_text(text_buf);
field_ptmsi.encode_text(text_buf);
field_pdpContextStatus.encode_text(text_buf);
field_mBMS__ContextStatus.encode_text(text_buf);
field_uplinkDataStatus.encode_text(text_buf);
field_deviceProperties.encode_text(text_buf);
}

void PDU__GMM__ServiceRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cipheringKeySeqNum.decode_text(text_buf);
field_serviceType.decode_text(text_buf);
field_ptmsi.decode_text(text_buf);
field_pdpContextStatus.decode_text(text_buf);
field_mBMS__ContextStatus.decode_text(text_buf);
field_uplinkDataStatus.decode_text(text_buf);
field_deviceProperties.decode_text(text_buf);
}

void PDU__GMM__ServiceRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__GMM__ServiceRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__GMM__ServiceRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_descr_.raw->forceomit);
  decoded_field_length = field_cipheringKeySeqNum.RAW_decode(MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, ServiceTypeV_descr_.raw->forceomit);
  decoded_field_length = field_serviceType.RAW_decode(ServiceTypeV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, MobileL3__CommonIE__Types::MobileIdentityLV_descr_.raw->forceomit);
  decoded_field_length = field_ptmsi.RAW_decode(MobileL3__CommonIE__Types::MobileIdentityLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_pdpContextStatus = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDPContextStatusTLV_descr_.raw->forceomit);
  decoded_field_length = field_pdpContextStatus().RAW_decode(PDPContextStatusTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_pdpContextStatus = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_pdpContextStatus=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_mBMS__ContextStatus = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, MBMS__ContextStatusTLV_descr_.raw->forceomit);
  decoded_field_length = field_mBMS__ContextStatus().RAW_decode(MBMS__ContextStatusTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_mBMS__ContextStatus = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mBMS__ContextStatus=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_uplinkDataStatus = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, UplinkDataStatusTLV_descr_.raw->forceomit);
  decoded_field_length = field_uplinkDataStatus().RAW_decode(UplinkDataStatusTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_uplinkDataStatus = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_uplinkDataStatus=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_deviceProperties = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw->forceomit);
  decoded_field_length = field_deviceProperties().RAW_decode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_deviceProperties = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_24){
  field_deviceProperties=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_deviceProperties=OMIT_VALUE;
  if (field_messageType !=  bs_48) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__GMM__ServiceRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ServiceTypeV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, MobileL3__CommonIE__Types::MobileIdentityLV_descr_.raw);
  if (field_pdpContextStatus.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDPContextStatusTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_mBMS__ContextStatus.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, MBMS__ContextStatusTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_uplinkDataStatus.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, UplinkDataStatusTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_deviceProperties.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cipheringKeySeqNum.RAW_encode(MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_serviceType.RAW_encode(ServiceTypeV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ptmsi.RAW_encode(MobileL3__CommonIE__Types::MobileIdentityLV_descr_, *myleaf.body.node.nodes[3]);
  if (field_pdpContextStatus.ispresent()) {
  encoded_length += field_pdpContextStatus().RAW_encode(PDPContextStatusTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_mBMS__ContextStatus.ispresent()) {
  encoded_length += field_mBMS__ContextStatus().RAW_encode(MBMS__ContextStatusTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_uplinkDataStatus.ispresent()) {
  encoded_length += field_uplinkDataStatus().RAW_encode(UplinkDataStatusTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_deviceProperties.ispresent()) {
  encoded_length += field_deviceProperties().RAW_encode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_deviceProperties.ispresent() && (!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_24)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_24.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_48) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_48.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__GMM__ServiceRequest_template::single_value_struct {
BITSTRING_template field_messageType;
MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_template field_cipheringKeySeqNum;
ServiceTypeV_template field_serviceType;
MobileL3__CommonIE__Types::MobileIdentityLV_template field_ptmsi;
PDPContextStatusTLV_template field_pdpContextStatus;
MBMS__ContextStatusTLV_template field_mBMS__ContextStatus;
UplinkDataStatusTLV_template field_uplinkDataStatus;
MobileL3__CommonIE__Types::DevicePropertiesTV_template field_deviceProperties;
};

void PDU__GMM__ServiceRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cipheringKeySeqNum = ANY_VALUE;
single_value->field_serviceType = ANY_VALUE;
single_value->field_ptmsi = ANY_VALUE;
single_value->field_pdpContextStatus = ANY_OR_OMIT;
single_value->field_mBMS__ContextStatus = ANY_OR_OMIT;
single_value->field_uplinkDataStatus = ANY_OR_OMIT;
single_value->field_deviceProperties = ANY_OR_OMIT;
}
}
}

void PDU__GMM__ServiceRequest_template::copy_value(const PDU__GMM__ServiceRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cipheringKeySeqNum().is_bound()) {
  single_value->field_cipheringKeySeqNum = other_value.cipheringKeySeqNum();
} else {
  single_value->field_cipheringKeySeqNum.clean_up();
}
if (other_value.serviceType().is_bound()) {
  single_value->field_serviceType = other_value.serviceType();
} else {
  single_value->field_serviceType.clean_up();
}
if (other_value.ptmsi().is_bound()) {
  single_value->field_ptmsi = other_value.ptmsi();
} else {
  single_value->field_ptmsi.clean_up();
}
if (other_value.pdpContextStatus().is_bound()) {
  if (other_value.pdpContextStatus().ispresent()) single_value->field_pdpContextStatus = other_value.pdpContextStatus()();
  else single_value->field_pdpContextStatus = OMIT_VALUE;
} else {
  single_value->field_pdpContextStatus.clean_up();
}
if (other_value.mBMS__ContextStatus().is_bound()) {
  if (other_value.mBMS__ContextStatus().ispresent()) single_value->field_mBMS__ContextStatus = other_value.mBMS__ContextStatus()();
  else single_value->field_mBMS__ContextStatus = OMIT_VALUE;
} else {
  single_value->field_mBMS__ContextStatus.clean_up();
}
if (other_value.uplinkDataStatus().is_bound()) {
  if (other_value.uplinkDataStatus().ispresent()) single_value->field_uplinkDataStatus = other_value.uplinkDataStatus()();
  else single_value->field_uplinkDataStatus = OMIT_VALUE;
} else {
  single_value->field_uplinkDataStatus.clean_up();
}
if (other_value.deviceProperties().is_bound()) {
  if (other_value.deviceProperties().ispresent()) single_value->field_deviceProperties = other_value.deviceProperties()();
  else single_value->field_deviceProperties = OMIT_VALUE;
} else {
  single_value->field_deviceProperties.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__GMM__ServiceRequest_template::copy_template(const PDU__GMM__ServiceRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cipheringKeySeqNum().get_selection()) {
single_value->field_cipheringKeySeqNum = other_value.cipheringKeySeqNum();
} else {
single_value->field_cipheringKeySeqNum.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.serviceType().get_selection()) {
single_value->field_serviceType = other_value.serviceType();
} else {
single_value->field_serviceType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ptmsi().get_selection()) {
single_value->field_ptmsi = other_value.ptmsi();
} else {
single_value->field_ptmsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpContextStatus().get_selection()) {
single_value->field_pdpContextStatus = other_value.pdpContextStatus();
} else {
single_value->field_pdpContextStatus.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mBMS__ContextStatus().get_selection()) {
single_value->field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
} else {
single_value->field_mBMS__ContextStatus.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.uplinkDataStatus().get_selection()) {
single_value->field_uplinkDataStatus = other_value.uplinkDataStatus();
} else {
single_value->field_uplinkDataStatus.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deviceProperties().get_selection()) {
single_value->field_deviceProperties = other_value.deviceProperties();
} else {
single_value->field_deviceProperties.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__GMM__ServiceRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__GMM__ServiceRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__GMM__ServiceRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
break;
}
set_selection(other_value);
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template()
{
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(const PDU__GMM__ServiceRequest& other_value)
{
copy_value(other_value);
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(const OPTIONAL<PDU__GMM__ServiceRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest from an unbound optional field.");
}
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(PDU__GMM__ServiceRequest_template* p_precondition, PDU__GMM__ServiceRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(Dynamic_Match_Interface<PDU__GMM__ServiceRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__GMM__ServiceRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__GMM__ServiceRequest_template::PDU__GMM__ServiceRequest_template(const PDU__GMM__ServiceRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__GMM__ServiceRequest_template::~PDU__GMM__ServiceRequest_template()
{
clean_up();
}

PDU__GMM__ServiceRequest_template& PDU__GMM__ServiceRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__GMM__ServiceRequest_template& PDU__GMM__ServiceRequest_template::operator=(const PDU__GMM__ServiceRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__GMM__ServiceRequest_template& PDU__GMM__ServiceRequest_template::operator=(const OPTIONAL<PDU__GMM__ServiceRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
}
return *this;
}

PDU__GMM__ServiceRequest_template& PDU__GMM__ServiceRequest_template::operator=(const PDU__GMM__ServiceRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__GMM__ServiceRequest_template::match(const PDU__GMM__ServiceRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cipheringKeySeqNum().is_bound()) return FALSE;
if(!single_value->field_cipheringKeySeqNum.match(other_value.cipheringKeySeqNum(), legacy))return FALSE;
if(!other_value.serviceType().is_bound()) return FALSE;
if(!single_value->field_serviceType.match(other_value.serviceType(), legacy))return FALSE;
if(!other_value.ptmsi().is_bound()) return FALSE;
if(!single_value->field_ptmsi.match(other_value.ptmsi(), legacy))return FALSE;
if(!other_value.pdpContextStatus().is_bound()) return FALSE;
if((other_value.pdpContextStatus().ispresent() ? !single_value->field_pdpContextStatus.match((const PDPContextStatusTLV&)other_value.pdpContextStatus(), legacy) : !single_value->field_pdpContextStatus.match_omit(legacy)))return FALSE;
if(!other_value.mBMS__ContextStatus().is_bound()) return FALSE;
if((other_value.mBMS__ContextStatus().ispresent() ? !single_value->field_mBMS__ContextStatus.match((const MBMS__ContextStatusTLV&)other_value.mBMS__ContextStatus(), legacy) : !single_value->field_mBMS__ContextStatus.match_omit(legacy)))return FALSE;
if(!other_value.uplinkDataStatus().is_bound()) return FALSE;
if((other_value.uplinkDataStatus().ispresent() ? !single_value->field_uplinkDataStatus.match((const UplinkDataStatusTLV&)other_value.uplinkDataStatus(), legacy) : !single_value->field_uplinkDataStatus.match_omit(legacy)))return FALSE;
if(!other_value.deviceProperties().is_bound()) return FALSE;
if((other_value.deviceProperties().ispresent() ? !single_value->field_deviceProperties.match((const MobileL3__CommonIE__Types::DevicePropertiesTV&)other_value.deviceProperties(), legacy) : !single_value->field_deviceProperties.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
}
return FALSE;
}

boolean PDU__GMM__ServiceRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cipheringKeySeqNum.is_bound()
 || single_value->field_serviceType.is_bound()
 || single_value->field_ptmsi.is_bound()
 || (single_value->field_pdpContextStatus.is_omit() || single_value->field_pdpContextStatus.is_bound())
 || (single_value->field_mBMS__ContextStatus.is_omit() || single_value->field_mBMS__ContextStatus.is_bound())
 || (single_value->field_uplinkDataStatus.is_omit() || single_value->field_uplinkDataStatus.is_bound())
 || (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_bound());
}

boolean PDU__GMM__ServiceRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cipheringKeySeqNum.is_value()
 && single_value->field_serviceType.is_value()
 && single_value->field_ptmsi.is_value()
 && (single_value->field_pdpContextStatus.is_omit() || single_value->field_pdpContextStatus.is_value())
 && (single_value->field_mBMS__ContextStatus.is_omit() || single_value->field_mBMS__ContextStatus.is_value())
 && (single_value->field_uplinkDataStatus.is_omit() || single_value->field_uplinkDataStatus.is_value())
 && (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_value());
}

void PDU__GMM__ServiceRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__GMM__ServiceRequest PDU__GMM__ServiceRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
PDU__GMM__ServiceRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cipheringKeySeqNum.is_bound()) {
ret_val.cipheringKeySeqNum() = single_value->field_cipheringKeySeqNum.valueof();
}
if (single_value->field_serviceType.is_bound()) {
ret_val.serviceType() = single_value->field_serviceType.valueof();
}
if (single_value->field_ptmsi.is_bound()) {
ret_val.ptmsi() = single_value->field_ptmsi.valueof();
}
if (single_value->field_pdpContextStatus.is_omit()) ret_val.pdpContextStatus() = OMIT_VALUE;
else if (single_value->field_pdpContextStatus.is_bound()) {
ret_val.pdpContextStatus() = single_value->field_pdpContextStatus.valueof();
}
if (single_value->field_mBMS__ContextStatus.is_omit()) ret_val.mBMS__ContextStatus() = OMIT_VALUE;
else if (single_value->field_mBMS__ContextStatus.is_bound()) {
ret_val.mBMS__ContextStatus() = single_value->field_mBMS__ContextStatus.valueof();
}
if (single_value->field_uplinkDataStatus.is_omit()) ret_val.uplinkDataStatus() = OMIT_VALUE;
else if (single_value->field_uplinkDataStatus.is_bound()) {
ret_val.uplinkDataStatus() = single_value->field_uplinkDataStatus.valueof();
}
if (single_value->field_deviceProperties.is_omit()) ret_val.deviceProperties() = OMIT_VALUE;
else if (single_value->field_deviceProperties.is_bound()) {
ret_val.deviceProperties() = single_value->field_deviceProperties.valueof();
}
return ret_val;
}

void PDU__GMM__ServiceRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__GMM__ServiceRequest_template[list_length];
}

PDU__GMM__ServiceRequest_template& PDU__GMM__ServiceRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__GMM__ServiceRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__GMM__ServiceRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_messageType;
}

MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_template& PDU__GMM__ServiceRequest_template::cipheringKeySeqNum()
{
set_specific();
return single_value->field_cipheringKeySeqNum;
}

const MobileL3__CommonIE__Types::CipheringKeySequenceNumberV_template& PDU__GMM__ServiceRequest_template::cipheringKeySeqNum() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cipheringKeySeqNum of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_cipheringKeySeqNum;
}

ServiceTypeV_template& PDU__GMM__ServiceRequest_template::serviceType()
{
set_specific();
return single_value->field_serviceType;
}

const ServiceTypeV_template& PDU__GMM__ServiceRequest_template::serviceType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field serviceType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_serviceType;
}

MobileL3__CommonIE__Types::MobileIdentityLV_template& PDU__GMM__ServiceRequest_template::ptmsi()
{
set_specific();
return single_value->field_ptmsi;
}

const MobileL3__CommonIE__Types::MobileIdentityLV_template& PDU__GMM__ServiceRequest_template::ptmsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ptmsi of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_ptmsi;
}

PDPContextStatusTLV_template& PDU__GMM__ServiceRequest_template::pdpContextStatus()
{
set_specific();
return single_value->field_pdpContextStatus;
}

const PDPContextStatusTLV_template& PDU__GMM__ServiceRequest_template::pdpContextStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpContextStatus of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_pdpContextStatus;
}

MBMS__ContextStatusTLV_template& PDU__GMM__ServiceRequest_template::mBMS__ContextStatus()
{
set_specific();
return single_value->field_mBMS__ContextStatus;
}

const MBMS__ContextStatusTLV_template& PDU__GMM__ServiceRequest_template::mBMS__ContextStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mBMS_ContextStatus of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_mBMS__ContextStatus;
}

UplinkDataStatusTLV_template& PDU__GMM__ServiceRequest_template::uplinkDataStatus()
{
set_specific();
return single_value->field_uplinkDataStatus;
}

const UplinkDataStatusTLV_template& PDU__GMM__ServiceRequest_template::uplinkDataStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field uplinkDataStatus of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_uplinkDataStatus;
}

MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__GMM__ServiceRequest_template::deviceProperties()
{
set_specific();
return single_value->field_deviceProperties;
}

const MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__GMM__ServiceRequest_template::deviceProperties() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deviceProperties of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
return single_value->field_deviceProperties;
}

int PDU__GMM__ServiceRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_pdpContextStatus.is_present()) ret_val++;
      if (single_value->field_mBMS__ContextStatus.is_present()) ret_val++;
      if (single_value->field_uplinkDataStatus.is_present()) ret_val++;
      if (single_value->field_deviceProperties.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
  }
  return 0;
}

void PDU__GMM__ServiceRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cipheringKeySeqNum := ");
single_value->field_cipheringKeySeqNum.log();
TTCN_Logger::log_event_str(", serviceType := ");
single_value->field_serviceType.log();
TTCN_Logger::log_event_str(", ptmsi := ");
single_value->field_ptmsi.log();
TTCN_Logger::log_event_str(", pdpContextStatus := ");
single_value->field_pdpContextStatus.log();
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
single_value->field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(", uplinkDataStatus := ");
single_value->field_uplinkDataStatus.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__GMM__ServiceRequest_template::log_match(const PDU__GMM__ServiceRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cipheringKeySeqNum.match(match_value.cipheringKeySeqNum(), legacy)){
TTCN_Logger::log_logmatch_info(".cipheringKeySeqNum");
single_value->field_cipheringKeySeqNum.log_match(match_value.cipheringKeySeqNum(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_serviceType.match(match_value.serviceType(), legacy)){
TTCN_Logger::log_logmatch_info(".serviceType");
single_value->field_serviceType.log_match(match_value.serviceType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ptmsi.match(match_value.ptmsi(), legacy)){
TTCN_Logger::log_logmatch_info(".ptmsi");
single_value->field_ptmsi.log_match(match_value.ptmsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pdpContextStatus().ispresent()){
if(!single_value->field_pdpContextStatus.match(match_value.pdpContextStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpContextStatus");
single_value->field_pdpContextStatus.log_match(match_value.pdpContextStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdpContextStatus.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdpContextStatus := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdpContextStatus.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mBMS__ContextStatus().ispresent()){
if(!single_value->field_mBMS__ContextStatus.match(match_value.mBMS__ContextStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".mBMS_ContextStatus");
single_value->field_mBMS__ContextStatus.log_match(match_value.mBMS__ContextStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mBMS__ContextStatus.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mBMS_ContextStatus := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.uplinkDataStatus().ispresent()){
if(!single_value->field_uplinkDataStatus.match(match_value.uplinkDataStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".uplinkDataStatus");
single_value->field_uplinkDataStatus.log_match(match_value.uplinkDataStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_uplinkDataStatus.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".uplinkDataStatus := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_uplinkDataStatus.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.deviceProperties().ispresent()){
if(!single_value->field_deviceProperties.match(match_value.deviceProperties(), legacy)){
TTCN_Logger::log_logmatch_info(".deviceProperties");
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deviceProperties.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deviceProperties := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cipheringKeySeqNum := ");
single_value->field_cipheringKeySeqNum.log_match(match_value.cipheringKeySeqNum(), legacy);
TTCN_Logger::log_event_str(", serviceType := ");
single_value->field_serviceType.log_match(match_value.serviceType(), legacy);
TTCN_Logger::log_event_str(", ptmsi := ");
single_value->field_ptmsi.log_match(match_value.ptmsi(), legacy);
TTCN_Logger::log_event_str(", pdpContextStatus := ");
if (match_value.pdpContextStatus().ispresent()) {
single_value->field_pdpContextStatus.log_match(match_value.pdpContextStatus(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdpContextStatus.log();
if (single_value->field_pdpContextStatus.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
if (match_value.mBMS__ContextStatus().ispresent()) {
single_value->field_mBMS__ContextStatus.log_match(match_value.mBMS__ContextStatus(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mBMS__ContextStatus.log();
if (single_value->field_mBMS__ContextStatus.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", uplinkDataStatus := ");
if (match_value.uplinkDataStatus().ispresent()) {
single_value->field_uplinkDataStatus.log_match(match_value.uplinkDataStatus(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_uplinkDataStatus.log();
if (single_value->field_uplinkDataStatus.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", deviceProperties := ");
if (match_value.deviceProperties().ispresent()) {
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deviceProperties.log();
if (single_value->field_deviceProperties.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__GMM__ServiceRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cipheringKeySeqNum().is_bound()) cipheringKeySeqNum().set_implicit_omit();
if (serviceType().is_bound()) serviceType().set_implicit_omit();
if (ptmsi().is_bound()) ptmsi().set_implicit_omit();
if (!pdpContextStatus().is_bound()) pdpContextStatus() = OMIT_VALUE;
else pdpContextStatus().set_implicit_omit();
if (!mBMS__ContextStatus().is_bound()) mBMS__ContextStatus() = OMIT_VALUE;
else mBMS__ContextStatus().set_implicit_omit();
if (!uplinkDataStatus().is_bound()) uplinkDataStatus() = OMIT_VALUE;
else uplinkDataStatus().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
}

void PDU__GMM__ServiceRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cipheringKeySeqNum.encode_text(text_buf);
single_value->field_serviceType.encode_text(text_buf);
single_value->field_ptmsi.encode_text(text_buf);
single_value->field_pdpContextStatus.encode_text(text_buf);
single_value->field_mBMS__ContextStatus.encode_text(text_buf);
single_value->field_uplinkDataStatus.encode_text(text_buf);
single_value->field_deviceProperties.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
}
}

void PDU__GMM__ServiceRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cipheringKeySeqNum.decode_text(text_buf);
single_value->field_serviceType.decode_text(text_buf);
single_value->field_ptmsi.decode_text(text_buf);
single_value->field_pdpContextStatus.decode_text(text_buf);
single_value->field_mBMS__ContextStatus.decode_text(text_buf);
single_value->field_uplinkDataStatus.decode_text(text_buf);
single_value->field_deviceProperties.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__GMM__ServiceRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest.");
}
}

void PDU__GMM__ServiceRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__GMM__ServiceRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cipheringKeySeqNum().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ptmsi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pdpContextStatus().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mBMS__ContextStatus().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) uplinkDataStatus().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipheringKeySeqNum")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipheringKeySeqNum().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ptmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ptmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_ContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__ContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uplinkDataStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uplinkDataStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__GMM__ServiceRequest_template* precondition = new PDU__GMM__ServiceRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__GMM__ServiceRequest_template* implied_template = new PDU__GMM__ServiceRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__GMM__ServiceRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__GMM__ServiceRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_cipheringKeySeqNum.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_serviceType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_ptmsi.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_pdpContextStatus.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_mBMS__ContextStatus.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_uplinkDataStatus.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
single_value->field_deviceProperties.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceRequest");
}

boolean PDU__GMM__ServiceRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__GMM__ServiceRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__GMM__ServiceAccept::PDU__GMM__ServiceAccept()
{
}

PDU__GMM__ServiceAccept::PDU__GMM__ServiceAccept(const BITSTRING& par_messageType,
    const OPTIONAL< PDPContextStatusTLV >& par_pdpContextStatus,
    const OPTIONAL< MBMS__ContextStatusTLV >& par_mBMS__ContextStatus)
  :   field_messageType(par_messageType),
  field_pdpContextStatus(par_pdpContextStatus),
  field_mBMS__ContextStatus(par_mBMS__ContextStatus)
{
}

PDU__GMM__ServiceAccept::PDU__GMM__ServiceAccept(const PDU__GMM__ServiceAccept& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.pdpContextStatus().is_bound()) field_pdpContextStatus = other_value.pdpContextStatus();
else field_pdpContextStatus.clean_up();
if (other_value.mBMS__ContextStatus().is_bound()) field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
else field_mBMS__ContextStatus.clean_up();
}

void PDU__GMM__ServiceAccept::clean_up()
{
field_messageType.clean_up();
field_pdpContextStatus.clean_up();
field_mBMS__ContextStatus.clean_up();
}

const TTCN_Typedescriptor_t* PDU__GMM__ServiceAccept::get_descriptor() const { return &PDU__GMM__ServiceAccept_descr_; }
PDU__GMM__ServiceAccept& PDU__GMM__ServiceAccept::operator=(const PDU__GMM__ServiceAccept& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.pdpContextStatus().is_bound()) field_pdpContextStatus = other_value.pdpContextStatus();
  else field_pdpContextStatus.clean_up();
  if (other_value.mBMS__ContextStatus().is_bound()) field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
  else field_mBMS__ContextStatus.clean_up();
}
return *this;
}

boolean PDU__GMM__ServiceAccept::operator==(const PDU__GMM__ServiceAccept& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_pdpContextStatus==other_value.field_pdpContextStatus
  && field_mBMS__ContextStatus==other_value.field_mBMS__ContextStatus;
}

boolean PDU__GMM__ServiceAccept::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_pdpContextStatus.get_selection() || field_pdpContextStatus.is_bound())
  || (OPTIONAL_OMIT == field_mBMS__ContextStatus.get_selection() || field_mBMS__ContextStatus.is_bound());
}
boolean PDU__GMM__ServiceAccept::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_pdpContextStatus.get_selection() || field_pdpContextStatus.is_value())
  && (OPTIONAL_OMIT == field_mBMS__ContextStatus.get_selection() || field_mBMS__ContextStatus.is_value());
}
int PDU__GMM__ServiceAccept::size_of() const
{
  int ret_val = 1;
  if (field_pdpContextStatus.ispresent()) ret_val++;
  if (field_mBMS__ContextStatus.ispresent()) ret_val++;
  return ret_val;
}

void PDU__GMM__ServiceAccept::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", pdpContextStatus := ");
field_pdpContextStatus.log();
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__GMM__ServiceAccept::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!pdpContextStatus().is_bound()) pdpContextStatus() = OMIT_VALUE;
else pdpContextStatus().set_implicit_omit();
if (!mBMS__ContextStatus().is_bound()) mBMS__ContextStatus() = OMIT_VALUE;
else mBMS__ContextStatus().set_implicit_omit();
}

void PDU__GMM__ServiceAccept::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdpContextStatus().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mBMS__ContextStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_ContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__ContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
  }
}

void PDU__GMM__ServiceAccept::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_pdpContextStatus.encode_text(text_buf);
field_mBMS__ContextStatus.encode_text(text_buf);
}

void PDU__GMM__ServiceAccept::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_pdpContextStatus.decode_text(text_buf);
field_mBMS__ContextStatus.decode_text(text_buf);
}

void PDU__GMM__ServiceAccept::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__GMM__ServiceAccept::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__GMM__ServiceAccept::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_pdpContextStatus = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PDPContextStatusTLV_descr_.raw->forceomit);
  decoded_field_length = field_pdpContextStatus().RAW_decode(PDPContextStatusTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_pdpContextStatus = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_pdpContextStatus=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_mBMS__ContextStatus = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MBMS__ContextStatusTLV_descr_.raw->forceomit);
  decoded_field_length = field_mBMS__ContextStatus().RAW_decode(MBMS__ContextStatusTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_mBMS__ContextStatus = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mBMS__ContextStatus=OMIT_VALUE;
  if (field_messageType !=  bs_49) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__GMM__ServiceAccept::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  if (field_pdpContextStatus.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PDPContextStatusTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_mBMS__ContextStatus.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MBMS__ContextStatusTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  if (field_pdpContextStatus.ispresent()) {
  encoded_length += field_pdpContextStatus().RAW_encode(PDPContextStatusTLV_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_mBMS__ContextStatus.ispresent()) {
  encoded_length += field_mBMS__ContextStatus().RAW_encode(MBMS__ContextStatusTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  bs_49) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_49.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__GMM__ServiceAccept_template::single_value_struct {
BITSTRING_template field_messageType;
PDPContextStatusTLV_template field_pdpContextStatus;
MBMS__ContextStatusTLV_template field_mBMS__ContextStatus;
};

void PDU__GMM__ServiceAccept_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_pdpContextStatus = ANY_OR_OMIT;
single_value->field_mBMS__ContextStatus = ANY_OR_OMIT;
}
}
}

void PDU__GMM__ServiceAccept_template::copy_value(const PDU__GMM__ServiceAccept& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.pdpContextStatus().is_bound()) {
  if (other_value.pdpContextStatus().ispresent()) single_value->field_pdpContextStatus = other_value.pdpContextStatus()();
  else single_value->field_pdpContextStatus = OMIT_VALUE;
} else {
  single_value->field_pdpContextStatus.clean_up();
}
if (other_value.mBMS__ContextStatus().is_bound()) {
  if (other_value.mBMS__ContextStatus().ispresent()) single_value->field_mBMS__ContextStatus = other_value.mBMS__ContextStatus()();
  else single_value->field_mBMS__ContextStatus = OMIT_VALUE;
} else {
  single_value->field_mBMS__ContextStatus.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__GMM__ServiceAccept_template::copy_template(const PDU__GMM__ServiceAccept_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpContextStatus().get_selection()) {
single_value->field_pdpContextStatus = other_value.pdpContextStatus();
} else {
single_value->field_pdpContextStatus.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mBMS__ContextStatus().get_selection()) {
single_value->field_mBMS__ContextStatus = other_value.mBMS__ContextStatus();
} else {
single_value->field_mBMS__ContextStatus.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__GMM__ServiceAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__GMM__ServiceAccept_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__GMM__ServiceAccept_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
break;
}
set_selection(other_value);
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template()
{
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(const PDU__GMM__ServiceAccept& other_value)
{
copy_value(other_value);
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(const OPTIONAL<PDU__GMM__ServiceAccept>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept from an unbound optional field.");
}
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(PDU__GMM__ServiceAccept_template* p_precondition, PDU__GMM__ServiceAccept_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(Dynamic_Match_Interface<PDU__GMM__ServiceAccept>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__GMM__ServiceAccept>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__GMM__ServiceAccept_template::PDU__GMM__ServiceAccept_template(const PDU__GMM__ServiceAccept_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__GMM__ServiceAccept_template::~PDU__GMM__ServiceAccept_template()
{
clean_up();
}

PDU__GMM__ServiceAccept_template& PDU__GMM__ServiceAccept_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__GMM__ServiceAccept_template& PDU__GMM__ServiceAccept_template::operator=(const PDU__GMM__ServiceAccept& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__GMM__ServiceAccept_template& PDU__GMM__ServiceAccept_template::operator=(const OPTIONAL<PDU__GMM__ServiceAccept>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
}
return *this;
}

PDU__GMM__ServiceAccept_template& PDU__GMM__ServiceAccept_template::operator=(const PDU__GMM__ServiceAccept_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__GMM__ServiceAccept_template::match(const PDU__GMM__ServiceAccept& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.pdpContextStatus().is_bound()) return FALSE;
if((other_value.pdpContextStatus().ispresent() ? !single_value->field_pdpContextStatus.match((const PDPContextStatusTLV&)other_value.pdpContextStatus(), legacy) : !single_value->field_pdpContextStatus.match_omit(legacy)))return FALSE;
if(!other_value.mBMS__ContextStatus().is_bound()) return FALSE;
if((other_value.mBMS__ContextStatus().ispresent() ? !single_value->field_mBMS__ContextStatus.match((const MBMS__ContextStatusTLV&)other_value.mBMS__ContextStatus(), legacy) : !single_value->field_mBMS__ContextStatus.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
}
return FALSE;
}

boolean PDU__GMM__ServiceAccept_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_pdpContextStatus.is_omit() || single_value->field_pdpContextStatus.is_bound())
 || (single_value->field_mBMS__ContextStatus.is_omit() || single_value->field_mBMS__ContextStatus.is_bound());
}

boolean PDU__GMM__ServiceAccept_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_pdpContextStatus.is_omit() || single_value->field_pdpContextStatus.is_value())
 && (single_value->field_mBMS__ContextStatus.is_omit() || single_value->field_mBMS__ContextStatus.is_value());
}

void PDU__GMM__ServiceAccept_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__GMM__ServiceAccept PDU__GMM__ServiceAccept_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
PDU__GMM__ServiceAccept ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_pdpContextStatus.is_omit()) ret_val.pdpContextStatus() = OMIT_VALUE;
else if (single_value->field_pdpContextStatus.is_bound()) {
ret_val.pdpContextStatus() = single_value->field_pdpContextStatus.valueof();
}
if (single_value->field_mBMS__ContextStatus.is_omit()) ret_val.mBMS__ContextStatus() = OMIT_VALUE;
else if (single_value->field_mBMS__ContextStatus.is_bound()) {
ret_val.mBMS__ContextStatus() = single_value->field_mBMS__ContextStatus.valueof();
}
return ret_val;
}

void PDU__GMM__ServiceAccept_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__GMM__ServiceAccept_template[list_length];
}

PDU__GMM__ServiceAccept_template& PDU__GMM__ServiceAccept_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__GMM__ServiceAccept_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__GMM__ServiceAccept_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
return single_value->field_messageType;
}

PDPContextStatusTLV_template& PDU__GMM__ServiceAccept_template::pdpContextStatus()
{
set_specific();
return single_value->field_pdpContextStatus;
}

const PDPContextStatusTLV_template& PDU__GMM__ServiceAccept_template::pdpContextStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpContextStatus of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
return single_value->field_pdpContextStatus;
}

MBMS__ContextStatusTLV_template& PDU__GMM__ServiceAccept_template::mBMS__ContextStatus()
{
set_specific();
return single_value->field_mBMS__ContextStatus;
}

const MBMS__ContextStatusTLV_template& PDU__GMM__ServiceAccept_template::mBMS__ContextStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mBMS_ContextStatus of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
return single_value->field_mBMS__ContextStatus;
}

int PDU__GMM__ServiceAccept_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_pdpContextStatus.is_present()) ret_val++;
      if (single_value->field_mBMS__ContextStatus.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
  }
  return 0;
}

void PDU__GMM__ServiceAccept_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", pdpContextStatus := ");
single_value->field_pdpContextStatus.log();
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
single_value->field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__GMM__ServiceAccept_template::log_match(const PDU__GMM__ServiceAccept& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pdpContextStatus().ispresent()){
if(!single_value->field_pdpContextStatus.match(match_value.pdpContextStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpContextStatus");
single_value->field_pdpContextStatus.log_match(match_value.pdpContextStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdpContextStatus.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdpContextStatus := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdpContextStatus.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mBMS__ContextStatus().ispresent()){
if(!single_value->field_mBMS__ContextStatus.match(match_value.mBMS__ContextStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".mBMS_ContextStatus");
single_value->field_mBMS__ContextStatus.log_match(match_value.mBMS__ContextStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mBMS__ContextStatus.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mBMS_ContextStatus := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mBMS__ContextStatus.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", pdpContextStatus := ");
if (match_value.pdpContextStatus().ispresent()) {
single_value->field_pdpContextStatus.log_match(match_value.pdpContextStatus(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdpContextStatus.log();
if (single_value->field_pdpContextStatus.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mBMS_ContextStatus := ");
if (match_value.mBMS__ContextStatus().ispresent()) {
single_value->field_mBMS__ContextStatus.log_match(match_value.mBMS__ContextStatus(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mBMS__ContextStatus.log();
if (single_value->field_mBMS__ContextStatus.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__GMM__ServiceAccept_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!pdpContextStatus().is_bound()) pdpContextStatus() = OMIT_VALUE;
else pdpContextStatus().set_implicit_omit();
if (!mBMS__ContextStatus().is_bound()) mBMS__ContextStatus() = OMIT_VALUE;
else mBMS__ContextStatus().set_implicit_omit();
}

void PDU__GMM__ServiceAccept_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_pdpContextStatus.encode_text(text_buf);
single_value->field_mBMS__ContextStatus.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
}
}

void PDU__GMM__ServiceAccept_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_pdpContextStatus.decode_text(text_buf);
single_value->field_mBMS__ContextStatus.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__GMM__ServiceAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept.");
}
}

void PDU__GMM__ServiceAccept_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__GMM__ServiceAccept_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdpContextStatus().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mBMS__ContextStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_ContextStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__ContextStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__GMM__ServiceAccept_template* precondition = new PDU__GMM__ServiceAccept_template;
    precondition->set_param(*param.get_elem(0));
    PDU__GMM__ServiceAccept_template* implied_template = new PDU__GMM__ServiceAccept_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__GMM__ServiceAccept_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__GMM__ServiceAccept_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
single_value->field_pdpContextStatus.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
single_value->field_mBMS__ContextStatus.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceAccept");
}

boolean PDU__GMM__ServiceAccept_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__GMM__ServiceAccept_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__GMM__ServiceReject::PDU__GMM__ServiceReject()
{
}

PDU__GMM__ServiceReject::PDU__GMM__ServiceReject(const BITSTRING& par_messageType,
    const GMM__CauseV& par_gmmCause,
    const OPTIONAL< GPRSTimer2TLV >& par_t3346)
  :   field_messageType(par_messageType),
  field_gmmCause(par_gmmCause),
  field_t3346(par_t3346)
{
}

PDU__GMM__ServiceReject::PDU__GMM__ServiceReject(const PDU__GMM__ServiceReject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.gmmCause().is_bound()) field_gmmCause = other_value.gmmCause();
else field_gmmCause.clean_up();
if (other_value.t3346().is_bound()) field_t3346 = other_value.t3346();
else field_t3346.clean_up();
}

void PDU__GMM__ServiceReject::clean_up()
{
field_messageType.clean_up();
field_gmmCause.clean_up();
field_t3346.clean_up();
}

const TTCN_Typedescriptor_t* PDU__GMM__ServiceReject::get_descriptor() const { return &PDU__GMM__ServiceReject_descr_; }
PDU__GMM__ServiceReject& PDU__GMM__ServiceReject::operator=(const PDU__GMM__ServiceReject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.gmmCause().is_bound()) field_gmmCause = other_value.gmmCause();
  else field_gmmCause.clean_up();
  if (other_value.t3346().is_bound()) field_t3346 = other_value.t3346();
  else field_t3346.clean_up();
}
return *this;
}

boolean PDU__GMM__ServiceReject::operator==(const PDU__GMM__ServiceReject& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_gmmCause==other_value.field_gmmCause
  && field_t3346==other_value.field_t3346;
}

boolean PDU__GMM__ServiceReject::is_bound() const
{
return (field_messageType.is_bound())
  || (field_gmmCause.is_bound())
  || (OPTIONAL_OMIT == field_t3346.get_selection() || field_t3346.is_bound());
}
boolean PDU__GMM__ServiceReject::is_value() const
{
return field_messageType.is_value()
  && field_gmmCause.is_value()
  && (OPTIONAL_OMIT == field_t3346.get_selection() || field_t3346.is_value());
}
int PDU__GMM__ServiceReject::size_of() const
{
  int ret_val = 2;
  if (field_t3346.ispresent()) ret_val++;
  return ret_val;
}

void PDU__GMM__ServiceReject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", gmmCause := ");
field_gmmCause.log();
TTCN_Logger::log_event_str(", t3346 := ");
field_t3346.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__GMM__ServiceReject::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (gmmCause().is_bound()) gmmCause().set_implicit_omit();
if (!t3346().is_bound()) t3346() = OMIT_VALUE;
else t3346().set_implicit_omit();
}

void PDU__GMM__ServiceReject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gmmCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) t3346().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmmCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmmCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t3346")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t3346().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
  }
}

void PDU__GMM__ServiceReject::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_gmmCause.encode_text(text_buf);
field_t3346.encode_text(text_buf);
}

void PDU__GMM__ServiceReject::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_gmmCause.decode_text(text_buf);
field_t3346.decode_text(text_buf);
}

void PDU__GMM__ServiceReject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__GMM__ServiceReject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__GMM__ServiceReject::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, GMM__CauseV_descr_.raw->forceomit);
  decoded_field_length = field_gmmCause.RAW_decode(GMM__CauseV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_t3346 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, GPRSTimer2TLV_descr_.raw->forceomit);
  decoded_field_length = field_t3346().RAW_decode(GPRSTimer2TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_t3346 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_t3346=OMIT_VALUE;
  if (field_messageType !=  bs_50) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__GMM__ServiceReject::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, GMM__CauseV_descr_.raw);
  if (field_t3346.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, GPRSTimer2TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_gmmCause.RAW_encode(GMM__CauseV_descr_, *myleaf.body.node.nodes[1]);
  if (field_t3346.ispresent()) {
  encoded_length += field_t3346().RAW_encode(GPRSTimer2TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  bs_50) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_50.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__GMM__ServiceReject_template::single_value_struct {
BITSTRING_template field_messageType;
GMM__CauseV_template field_gmmCause;
GPRSTimer2TLV_template field_t3346;
};

void PDU__GMM__ServiceReject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_gmmCause = ANY_VALUE;
single_value->field_t3346 = ANY_OR_OMIT;
}
}
}

void PDU__GMM__ServiceReject_template::copy_value(const PDU__GMM__ServiceReject& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.gmmCause().is_bound()) {
  single_value->field_gmmCause = other_value.gmmCause();
} else {
  single_value->field_gmmCause.clean_up();
}
if (other_value.t3346().is_bound()) {
  if (other_value.t3346().ispresent()) single_value->field_t3346 = other_value.t3346()();
  else single_value->field_t3346 = OMIT_VALUE;
} else {
  single_value->field_t3346.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__GMM__ServiceReject_template::copy_template(const PDU__GMM__ServiceReject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gmmCause().get_selection()) {
single_value->field_gmmCause = other_value.gmmCause();
} else {
single_value->field_gmmCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t3346().get_selection()) {
single_value->field_t3346 = other_value.t3346();
} else {
single_value->field_t3346.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__GMM__ServiceReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__GMM__ServiceReject_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__GMM__ServiceReject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
break;
}
set_selection(other_value);
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template()
{
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(const PDU__GMM__ServiceReject& other_value)
{
copy_value(other_value);
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(const OPTIONAL<PDU__GMM__ServiceReject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject from an unbound optional field.");
}
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(PDU__GMM__ServiceReject_template* p_precondition, PDU__GMM__ServiceReject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(Dynamic_Match_Interface<PDU__GMM__ServiceReject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__GMM__ServiceReject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__GMM__ServiceReject_template::PDU__GMM__ServiceReject_template(const PDU__GMM__ServiceReject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__GMM__ServiceReject_template::~PDU__GMM__ServiceReject_template()
{
clean_up();
}

PDU__GMM__ServiceReject_template& PDU__GMM__ServiceReject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__GMM__ServiceReject_template& PDU__GMM__ServiceReject_template::operator=(const PDU__GMM__ServiceReject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__GMM__ServiceReject_template& PDU__GMM__ServiceReject_template::operator=(const OPTIONAL<PDU__GMM__ServiceReject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__GMM__ServiceReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
}
return *this;
}

PDU__GMM__ServiceReject_template& PDU__GMM__ServiceReject_template::operator=(const PDU__GMM__ServiceReject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__GMM__ServiceReject_template::match(const PDU__GMM__ServiceReject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.gmmCause().is_bound()) return FALSE;
if(!single_value->field_gmmCause.match(other_value.gmmCause(), legacy))return FALSE;
if(!other_value.t3346().is_bound()) return FALSE;
if((other_value.t3346().ispresent() ? !single_value->field_t3346.match((const GPRSTimer2TLV&)other_value.t3346(), legacy) : !single_value->field_t3346.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
}
return FALSE;
}

boolean PDU__GMM__ServiceReject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_gmmCause.is_bound()
 || (single_value->field_t3346.is_omit() || single_value->field_t3346.is_bound());
}

boolean PDU__GMM__ServiceReject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_gmmCause.is_value()
 && (single_value->field_t3346.is_omit() || single_value->field_t3346.is_value());
}

void PDU__GMM__ServiceReject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__GMM__ServiceReject PDU__GMM__ServiceReject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
PDU__GMM__ServiceReject ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_gmmCause.is_bound()) {
ret_val.gmmCause() = single_value->field_gmmCause.valueof();
}
if (single_value->field_t3346.is_omit()) ret_val.t3346() = OMIT_VALUE;
else if (single_value->field_t3346.is_bound()) {
ret_val.t3346() = single_value->field_t3346.valueof();
}
return ret_val;
}

void PDU__GMM__ServiceReject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__GMM__ServiceReject_template[list_length];
}

PDU__GMM__ServiceReject_template& PDU__GMM__ServiceReject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__GMM__ServiceReject_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__GMM__ServiceReject_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
return single_value->field_messageType;
}

GMM__CauseV_template& PDU__GMM__ServiceReject_template::gmmCause()
{
set_specific();
return single_value->field_gmmCause;
}

const GMM__CauseV_template& PDU__GMM__ServiceReject_template::gmmCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gmmCause of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
return single_value->field_gmmCause;
}

GPRSTimer2TLV_template& PDU__GMM__ServiceReject_template::t3346()
{
set_specific();
return single_value->field_t3346;
}

const GPRSTimer2TLV_template& PDU__GMM__ServiceReject_template::t3346() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t3346 of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
return single_value->field_t3346;
}

int PDU__GMM__ServiceReject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_t3346.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
  }
  return 0;
}

void PDU__GMM__ServiceReject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", gmmCause := ");
single_value->field_gmmCause.log();
TTCN_Logger::log_event_str(", t3346 := ");
single_value->field_t3346.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__GMM__ServiceReject_template::log_match(const PDU__GMM__ServiceReject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_gmmCause.match(match_value.gmmCause(), legacy)){
TTCN_Logger::log_logmatch_info(".gmmCause");
single_value->field_gmmCause.log_match(match_value.gmmCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.t3346().ispresent()){
if(!single_value->field_t3346.match(match_value.t3346(), legacy)){
TTCN_Logger::log_logmatch_info(".t3346");
single_value->field_t3346.log_match(match_value.t3346(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_t3346.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".t3346 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_t3346.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", gmmCause := ");
single_value->field_gmmCause.log_match(match_value.gmmCause(), legacy);
TTCN_Logger::log_event_str(", t3346 := ");
if (match_value.t3346().ispresent()) {
single_value->field_t3346.log_match(match_value.t3346(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_t3346.log();
if (single_value->field_t3346.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__GMM__ServiceReject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (gmmCause().is_bound()) gmmCause().set_implicit_omit();
if (!t3346().is_bound()) t3346() = OMIT_VALUE;
else t3346().set_implicit_omit();
}

void PDU__GMM__ServiceReject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_gmmCause.encode_text(text_buf);
single_value->field_t3346.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
}
}

void PDU__GMM__ServiceReject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_gmmCause.decode_text(text_buf);
single_value->field_t3346.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__GMM__ServiceReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject.");
}
}

void PDU__GMM__ServiceReject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__GMM__ServiceReject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gmmCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) t3346().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmmCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmmCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t3346")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t3346().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__GMM__ServiceReject_template* precondition = new PDU__GMM__ServiceReject_template;
    precondition->set_param(*param.get_elem(0));
    PDU__GMM__ServiceReject_template* implied_template = new PDU__GMM__ServiceReject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__GMM__ServiceReject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__GMM__ServiceReject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
single_value->field_gmmCause.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
single_value->field_t3346.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_GMM_ServiceReject");
}

boolean PDU__GMM__ServiceReject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__GMM__ServiceReject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivatePDPContextRequest::PDU__SM__ActivatePDPContextRequest()
{
}

PDU__SM__ActivatePDPContextRequest::PDU__SM__ActivatePDPContextRequest(const BITSTRING& par_messageType,
    const NSAPIV& par_requestedNSAPI,
    const LLC__SAPIV& par_requestedLLCSAPI,
    const QoSLV& par_requestedQoS,
    const PDPAddressLV& par_requestedPDPaddress,
    const OPTIONAL< AccessPointNameTLV >& par_accessPointName,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< RequestTypeTV >& par_requestType,
    const OPTIONAL< MobileL3__CommonIE__Types::DevicePropertiesTV >& par_deviceProperties,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_requestedNSAPI(par_requestedNSAPI),
  field_requestedLLCSAPI(par_requestedLLCSAPI),
  field_requestedQoS(par_requestedQoS),
  field_requestedPDPaddress(par_requestedPDPaddress),
  field_accessPointName(par_accessPointName),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_requestType(par_requestType),
  field_deviceProperties(par_deviceProperties),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivatePDPContextRequest::PDU__SM__ActivatePDPContextRequest(const PDU__SM__ActivatePDPContextRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.requestedNSAPI().is_bound()) field_requestedNSAPI = other_value.requestedNSAPI();
else field_requestedNSAPI.clean_up();
if (other_value.requestedLLCSAPI().is_bound()) field_requestedLLCSAPI = other_value.requestedLLCSAPI();
else field_requestedLLCSAPI.clean_up();
if (other_value.requestedQoS().is_bound()) field_requestedQoS = other_value.requestedQoS();
else field_requestedQoS.clean_up();
if (other_value.requestedPDPaddress().is_bound()) field_requestedPDPaddress = other_value.requestedPDPaddress();
else field_requestedPDPaddress.clean_up();
if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
else field_accessPointName.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.requestType().is_bound()) field_requestType = other_value.requestType();
else field_requestType.clean_up();
if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
else field_deviceProperties.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivatePDPContextRequest::clean_up()
{
field_messageType.clean_up();
field_requestedNSAPI.clean_up();
field_requestedLLCSAPI.clean_up();
field_requestedQoS.clean_up();
field_requestedPDPaddress.clean_up();
field_accessPointName.clean_up();
field_protocolConfigOpts.clean_up();
field_requestType.clean_up();
field_deviceProperties.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivatePDPContextRequest::get_descriptor() const { return &PDU__SM__ActivatePDPContextRequest_descr_; }
PDU__SM__ActivatePDPContextRequest& PDU__SM__ActivatePDPContextRequest::operator=(const PDU__SM__ActivatePDPContextRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.requestedNSAPI().is_bound()) field_requestedNSAPI = other_value.requestedNSAPI();
  else field_requestedNSAPI.clean_up();
  if (other_value.requestedLLCSAPI().is_bound()) field_requestedLLCSAPI = other_value.requestedLLCSAPI();
  else field_requestedLLCSAPI.clean_up();
  if (other_value.requestedQoS().is_bound()) field_requestedQoS = other_value.requestedQoS();
  else field_requestedQoS.clean_up();
  if (other_value.requestedPDPaddress().is_bound()) field_requestedPDPaddress = other_value.requestedPDPaddress();
  else field_requestedPDPaddress.clean_up();
  if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
  else field_accessPointName.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.requestType().is_bound()) field_requestType = other_value.requestType();
  else field_requestType.clean_up();
  if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
  else field_deviceProperties.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivatePDPContextRequest::operator==(const PDU__SM__ActivatePDPContextRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_requestedNSAPI==other_value.field_requestedNSAPI
  && field_requestedLLCSAPI==other_value.field_requestedLLCSAPI
  && field_requestedQoS==other_value.field_requestedQoS
  && field_requestedPDPaddress==other_value.field_requestedPDPaddress
  && field_accessPointName==other_value.field_accessPointName
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_requestType==other_value.field_requestType
  && field_deviceProperties==other_value.field_deviceProperties
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivatePDPContextRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (field_requestedNSAPI.is_bound())
  || (field_requestedLLCSAPI.is_bound())
  || (field_requestedQoS.is_bound())
  || (field_requestedPDPaddress.is_bound())
  || (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_requestType.get_selection() || field_requestType.is_bound())
  || (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivatePDPContextRequest::is_value() const
{
return field_messageType.is_value()
  && field_requestedNSAPI.is_value()
  && field_requestedLLCSAPI.is_value()
  && field_requestedQoS.is_value()
  && field_requestedPDPaddress.is_value()
  && (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_requestType.get_selection() || field_requestType.is_value())
  && (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivatePDPContextRequest::size_of() const
{
  int ret_val = 5;
  if (field_accessPointName.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_requestType.ispresent()) ret_val++;
  if (field_deviceProperties.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivatePDPContextRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", requestedNSAPI := ");
field_requestedNSAPI.log();
TTCN_Logger::log_event_str(", requestedLLCSAPI := ");
field_requestedLLCSAPI.log();
TTCN_Logger::log_event_str(", requestedQoS := ");
field_requestedQoS.log();
TTCN_Logger::log_event_str(", requestedPDPaddress := ");
field_requestedPDPaddress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
field_accessPointName.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", requestType := ");
field_requestType.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivatePDPContextRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (requestedNSAPI().is_bound()) requestedNSAPI().set_implicit_omit();
if (requestedLLCSAPI().is_bound()) requestedLLCSAPI().set_implicit_omit();
if (requestedQoS().is_bound()) requestedQoS().set_implicit_omit();
if (requestedPDPaddress().is_bound()) requestedPDPaddress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!requestType().is_bound()) requestType() = OMIT_VALUE;
else requestType().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedNSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedLLCSAPI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedQoS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) requestedPDPaddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) requestType().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLCSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLCSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedPDPaddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedPDPaddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
  }
}

void PDU__SM__ActivatePDPContextRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_requestedNSAPI.encode_text(text_buf);
field_requestedLLCSAPI.encode_text(text_buf);
field_requestedQoS.encode_text(text_buf);
field_requestedPDPaddress.encode_text(text_buf);
field_accessPointName.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_requestType.encode_text(text_buf);
field_deviceProperties.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivatePDPContextRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_requestedNSAPI.decode_text(text_buf);
field_requestedLLCSAPI.decode_text(text_buf);
field_requestedQoS.decode_text(text_buf);
field_requestedPDPaddress.decode_text(text_buf);
field_accessPointName.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_requestType.decode_text(text_buf);
field_deviceProperties.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivatePDPContextRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivatePDPContextRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivatePDPContextRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NSAPIV_descr_.raw->forceomit);
  decoded_field_length = field_requestedNSAPI.RAW_decode(NSAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_requestedLLCSAPI.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_requestedQoS.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDPAddressLV_descr_.raw->forceomit);
  decoded_field_length = field_requestedPDPaddress.RAW_decode(PDPAddressLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_accessPointName = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, AccessPointNameTLV_descr_.raw->forceomit);
  decoded_field_length = field_accessPointName().RAW_decode(AccessPointNameTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_accessPointName = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_accessPointName=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_requestType = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RequestTypeTV_descr_.raw->forceomit);
  decoded_field_length = field_requestType().RAW_decode(RequestTypeTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_requestType = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_requestType=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_deviceProperties = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw->forceomit);
  decoded_field_length = field_deviceProperties().RAW_decode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_deviceProperties = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21){
  field_deviceProperties=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_deviceProperties=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_51) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivatePDPContextRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 10;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(10);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NSAPIV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, LLC__SAPIV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, QoSLV_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDPAddressLV_descr_.raw);
  if (field_accessPointName.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, AccessPointNameTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_requestType.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RequestTypeTV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_deviceProperties.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_requestedNSAPI.RAW_encode(NSAPIV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_requestedLLCSAPI.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_requestedQoS.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_requestedPDPaddress.RAW_encode(PDPAddressLV_descr_, *myleaf.body.node.nodes[4]);
  if (field_accessPointName.ispresent()) {
  encoded_length += field_accessPointName().RAW_encode(AccessPointNameTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_requestType.ispresent()) {
  encoded_length += field_requestType().RAW_encode(RequestTypeTV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_deviceProperties.ispresent()) {
  encoded_length += field_deviceProperties().RAW_encode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_deviceProperties.ispresent() && (!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={8,2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_21.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_51) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_51.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivatePDPContextRequest_template::single_value_struct {
BITSTRING_template field_messageType;
NSAPIV_template field_requestedNSAPI;
LLC__SAPIV_template field_requestedLLCSAPI;
QoSLV_template field_requestedQoS;
PDPAddressLV_template field_requestedPDPaddress;
AccessPointNameTLV_template field_accessPointName;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
RequestTypeTV_template field_requestType;
MobileL3__CommonIE__Types::DevicePropertiesTV_template field_deviceProperties;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivatePDPContextRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_requestedNSAPI = ANY_VALUE;
single_value->field_requestedLLCSAPI = ANY_VALUE;
single_value->field_requestedQoS = ANY_VALUE;
single_value->field_requestedPDPaddress = ANY_VALUE;
single_value->field_accessPointName = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_requestType = ANY_OR_OMIT;
single_value->field_deviceProperties = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivatePDPContextRequest_template::copy_value(const PDU__SM__ActivatePDPContextRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.requestedNSAPI().is_bound()) {
  single_value->field_requestedNSAPI = other_value.requestedNSAPI();
} else {
  single_value->field_requestedNSAPI.clean_up();
}
if (other_value.requestedLLCSAPI().is_bound()) {
  single_value->field_requestedLLCSAPI = other_value.requestedLLCSAPI();
} else {
  single_value->field_requestedLLCSAPI.clean_up();
}
if (other_value.requestedQoS().is_bound()) {
  single_value->field_requestedQoS = other_value.requestedQoS();
} else {
  single_value->field_requestedQoS.clean_up();
}
if (other_value.requestedPDPaddress().is_bound()) {
  single_value->field_requestedPDPaddress = other_value.requestedPDPaddress();
} else {
  single_value->field_requestedPDPaddress.clean_up();
}
if (other_value.accessPointName().is_bound()) {
  if (other_value.accessPointName().ispresent()) single_value->field_accessPointName = other_value.accessPointName()();
  else single_value->field_accessPointName = OMIT_VALUE;
} else {
  single_value->field_accessPointName.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.requestType().is_bound()) {
  if (other_value.requestType().ispresent()) single_value->field_requestType = other_value.requestType()();
  else single_value->field_requestType = OMIT_VALUE;
} else {
  single_value->field_requestType.clean_up();
}
if (other_value.deviceProperties().is_bound()) {
  if (other_value.deviceProperties().ispresent()) single_value->field_deviceProperties = other_value.deviceProperties()();
  else single_value->field_deviceProperties = OMIT_VALUE;
} else {
  single_value->field_deviceProperties.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivatePDPContextRequest_template::copy_template(const PDU__SM__ActivatePDPContextRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedNSAPI().get_selection()) {
single_value->field_requestedNSAPI = other_value.requestedNSAPI();
} else {
single_value->field_requestedNSAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedLLCSAPI().get_selection()) {
single_value->field_requestedLLCSAPI = other_value.requestedLLCSAPI();
} else {
single_value->field_requestedLLCSAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedQoS().get_selection()) {
single_value->field_requestedQoS = other_value.requestedQoS();
} else {
single_value->field_requestedQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedPDPaddress().get_selection()) {
single_value->field_requestedPDPaddress = other_value.requestedPDPaddress();
} else {
single_value->field_requestedPDPaddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.accessPointName().get_selection()) {
single_value->field_accessPointName = other_value.accessPointName();
} else {
single_value->field_accessPointName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestType().get_selection()) {
single_value->field_requestType = other_value.requestType();
} else {
single_value->field_requestType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deviceProperties().get_selection()) {
single_value->field_deviceProperties = other_value.deviceProperties();
} else {
single_value->field_deviceProperties.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivatePDPContextRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivatePDPContextRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template()
{
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(const PDU__SM__ActivatePDPContextRequest& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(const OPTIONAL<PDU__SM__ActivatePDPContextRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest from an unbound optional field.");
}
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(PDU__SM__ActivatePDPContextRequest_template* p_precondition, PDU__SM__ActivatePDPContextRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(Dynamic_Match_Interface<PDU__SM__ActivatePDPContextRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivatePDPContextRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivatePDPContextRequest_template::PDU__SM__ActivatePDPContextRequest_template(const PDU__SM__ActivatePDPContextRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivatePDPContextRequest_template::~PDU__SM__ActivatePDPContextRequest_template()
{
clean_up();
}

PDU__SM__ActivatePDPContextRequest_template& PDU__SM__ActivatePDPContextRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivatePDPContextRequest_template& PDU__SM__ActivatePDPContextRequest_template::operator=(const PDU__SM__ActivatePDPContextRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivatePDPContextRequest_template& PDU__SM__ActivatePDPContextRequest_template::operator=(const OPTIONAL<PDU__SM__ActivatePDPContextRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
}
return *this;
}

PDU__SM__ActivatePDPContextRequest_template& PDU__SM__ActivatePDPContextRequest_template::operator=(const PDU__SM__ActivatePDPContextRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivatePDPContextRequest_template::match(const PDU__SM__ActivatePDPContextRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.requestedNSAPI().is_bound()) return FALSE;
if(!single_value->field_requestedNSAPI.match(other_value.requestedNSAPI(), legacy))return FALSE;
if(!other_value.requestedLLCSAPI().is_bound()) return FALSE;
if(!single_value->field_requestedLLCSAPI.match(other_value.requestedLLCSAPI(), legacy))return FALSE;
if(!other_value.requestedQoS().is_bound()) return FALSE;
if(!single_value->field_requestedQoS.match(other_value.requestedQoS(), legacy))return FALSE;
if(!other_value.requestedPDPaddress().is_bound()) return FALSE;
if(!single_value->field_requestedPDPaddress.match(other_value.requestedPDPaddress(), legacy))return FALSE;
if(!other_value.accessPointName().is_bound()) return FALSE;
if((other_value.accessPointName().ispresent() ? !single_value->field_accessPointName.match((const AccessPointNameTLV&)other_value.accessPointName(), legacy) : !single_value->field_accessPointName.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.requestType().is_bound()) return FALSE;
if((other_value.requestType().ispresent() ? !single_value->field_requestType.match((const RequestTypeTV&)other_value.requestType(), legacy) : !single_value->field_requestType.match_omit(legacy)))return FALSE;
if(!other_value.deviceProperties().is_bound()) return FALSE;
if((other_value.deviceProperties().ispresent() ? !single_value->field_deviceProperties.match((const MobileL3__CommonIE__Types::DevicePropertiesTV&)other_value.deviceProperties(), legacy) : !single_value->field_deviceProperties.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
}
return FALSE;
}

boolean PDU__SM__ActivatePDPContextRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_requestedNSAPI.is_bound()
 || single_value->field_requestedLLCSAPI.is_bound()
 || single_value->field_requestedQoS.is_bound()
 || single_value->field_requestedPDPaddress.is_bound()
 || (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_requestType.is_omit() || single_value->field_requestType.is_bound())
 || (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivatePDPContextRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_requestedNSAPI.is_value()
 && single_value->field_requestedLLCSAPI.is_value()
 && single_value->field_requestedQoS.is_value()
 && single_value->field_requestedPDPaddress.is_value()
 && (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_requestType.is_omit() || single_value->field_requestType.is_value())
 && (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivatePDPContextRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivatePDPContextRequest PDU__SM__ActivatePDPContextRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
PDU__SM__ActivatePDPContextRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_requestedNSAPI.is_bound()) {
ret_val.requestedNSAPI() = single_value->field_requestedNSAPI.valueof();
}
if (single_value->field_requestedLLCSAPI.is_bound()) {
ret_val.requestedLLCSAPI() = single_value->field_requestedLLCSAPI.valueof();
}
if (single_value->field_requestedQoS.is_bound()) {
ret_val.requestedQoS() = single_value->field_requestedQoS.valueof();
}
if (single_value->field_requestedPDPaddress.is_bound()) {
ret_val.requestedPDPaddress() = single_value->field_requestedPDPaddress.valueof();
}
if (single_value->field_accessPointName.is_omit()) ret_val.accessPointName() = OMIT_VALUE;
else if (single_value->field_accessPointName.is_bound()) {
ret_val.accessPointName() = single_value->field_accessPointName.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_requestType.is_omit()) ret_val.requestType() = OMIT_VALUE;
else if (single_value->field_requestType.is_bound()) {
ret_val.requestType() = single_value->field_requestType.valueof();
}
if (single_value->field_deviceProperties.is_omit()) ret_val.deviceProperties() = OMIT_VALUE;
else if (single_value->field_deviceProperties.is_bound()) {
ret_val.deviceProperties() = single_value->field_deviceProperties.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivatePDPContextRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivatePDPContextRequest_template[list_length];
}

PDU__SM__ActivatePDPContextRequest_template& PDU__SM__ActivatePDPContextRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivatePDPContextRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivatePDPContextRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_messageType;
}

NSAPIV_template& PDU__SM__ActivatePDPContextRequest_template::requestedNSAPI()
{
set_specific();
return single_value->field_requestedNSAPI;
}

const NSAPIV_template& PDU__SM__ActivatePDPContextRequest_template::requestedNSAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedNSAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_requestedNSAPI;
}

LLC__SAPIV_template& PDU__SM__ActivatePDPContextRequest_template::requestedLLCSAPI()
{
set_specific();
return single_value->field_requestedLLCSAPI;
}

const LLC__SAPIV_template& PDU__SM__ActivatePDPContextRequest_template::requestedLLCSAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedLLCSAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_requestedLLCSAPI;
}

QoSLV_template& PDU__SM__ActivatePDPContextRequest_template::requestedQoS()
{
set_specific();
return single_value->field_requestedQoS;
}

const QoSLV_template& PDU__SM__ActivatePDPContextRequest_template::requestedQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_requestedQoS;
}

PDPAddressLV_template& PDU__SM__ActivatePDPContextRequest_template::requestedPDPaddress()
{
set_specific();
return single_value->field_requestedPDPaddress;
}

const PDPAddressLV_template& PDU__SM__ActivatePDPContextRequest_template::requestedPDPaddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedPDPaddress of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_requestedPDPaddress;
}

AccessPointNameTLV_template& PDU__SM__ActivatePDPContextRequest_template::accessPointName()
{
set_specific();
return single_value->field_accessPointName;
}

const AccessPointNameTLV_template& PDU__SM__ActivatePDPContextRequest_template::accessPointName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field accessPointName of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_accessPointName;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextRequest_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextRequest_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_protocolConfigOpts;
}

RequestTypeTV_template& PDU__SM__ActivatePDPContextRequest_template::requestType()
{
set_specific();
return single_value->field_requestType;
}

const RequestTypeTV_template& PDU__SM__ActivatePDPContextRequest_template::requestType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_requestType;
}

MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ActivatePDPContextRequest_template::deviceProperties()
{
set_specific();
return single_value->field_deviceProperties;
}

const MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ActivatePDPContextRequest_template::deviceProperties() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deviceProperties of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_deviceProperties;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextRequest_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextRequest_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivatePDPContextRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_accessPointName.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_requestType.is_present()) ret_val++;
      if (single_value->field_deviceProperties.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
  }
  return 0;
}

void PDU__SM__ActivatePDPContextRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", requestedNSAPI := ");
single_value->field_requestedNSAPI.log();
TTCN_Logger::log_event_str(", requestedLLCSAPI := ");
single_value->field_requestedLLCSAPI.log();
TTCN_Logger::log_event_str(", requestedQoS := ");
single_value->field_requestedQoS.log();
TTCN_Logger::log_event_str(", requestedPDPaddress := ");
single_value->field_requestedPDPaddress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", requestType := ");
single_value->field_requestType.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivatePDPContextRequest_template::log_match(const PDU__SM__ActivatePDPContextRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedNSAPI.match(match_value.requestedNSAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedNSAPI");
single_value->field_requestedNSAPI.log_match(match_value.requestedNSAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedLLCSAPI.match(match_value.requestedLLCSAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedLLCSAPI");
single_value->field_requestedLLCSAPI.log_match(match_value.requestedLLCSAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedQoS.match(match_value.requestedQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedQoS");
single_value->field_requestedQoS.log_match(match_value.requestedQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedPDPaddress.match(match_value.requestedPDPaddress(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedPDPaddress");
single_value->field_requestedPDPaddress.log_match(match_value.requestedPDPaddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.accessPointName().ispresent()){
if(!single_value->field_accessPointName.match(match_value.accessPointName(), legacy)){
TTCN_Logger::log_logmatch_info(".accessPointName");
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_accessPointName.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".accessPointName := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.requestType().ispresent()){
if(!single_value->field_requestType.match(match_value.requestType(), legacy)){
TTCN_Logger::log_logmatch_info(".requestType");
single_value->field_requestType.log_match(match_value.requestType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_requestType.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".requestType := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_requestType.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.deviceProperties().ispresent()){
if(!single_value->field_deviceProperties.match(match_value.deviceProperties(), legacy)){
TTCN_Logger::log_logmatch_info(".deviceProperties");
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deviceProperties.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deviceProperties := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", requestedNSAPI := ");
single_value->field_requestedNSAPI.log_match(match_value.requestedNSAPI(), legacy);
TTCN_Logger::log_event_str(", requestedLLCSAPI := ");
single_value->field_requestedLLCSAPI.log_match(match_value.requestedLLCSAPI(), legacy);
TTCN_Logger::log_event_str(", requestedQoS := ");
single_value->field_requestedQoS.log_match(match_value.requestedQoS(), legacy);
TTCN_Logger::log_event_str(", requestedPDPaddress := ");
single_value->field_requestedPDPaddress.log_match(match_value.requestedPDPaddress(), legacy);
TTCN_Logger::log_event_str(", accessPointName := ");
if (match_value.accessPointName().ispresent()) {
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_accessPointName.log();
if (single_value->field_accessPointName.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", requestType := ");
if (match_value.requestType().ispresent()) {
single_value->field_requestType.log_match(match_value.requestType(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_requestType.log();
if (single_value->field_requestType.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", deviceProperties := ");
if (match_value.deviceProperties().ispresent()) {
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deviceProperties.log();
if (single_value->field_deviceProperties.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivatePDPContextRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (requestedNSAPI().is_bound()) requestedNSAPI().set_implicit_omit();
if (requestedLLCSAPI().is_bound()) requestedLLCSAPI().set_implicit_omit();
if (requestedQoS().is_bound()) requestedQoS().set_implicit_omit();
if (requestedPDPaddress().is_bound()) requestedPDPaddress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!requestType().is_bound()) requestType() = OMIT_VALUE;
else requestType().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_requestedNSAPI.encode_text(text_buf);
single_value->field_requestedLLCSAPI.encode_text(text_buf);
single_value->field_requestedQoS.encode_text(text_buf);
single_value->field_requestedPDPaddress.encode_text(text_buf);
single_value->field_accessPointName.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_requestType.encode_text(text_buf);
single_value->field_deviceProperties.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
}
}

void PDU__SM__ActivatePDPContextRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_requestedNSAPI.decode_text(text_buf);
single_value->field_requestedLLCSAPI.decode_text(text_buf);
single_value->field_requestedQoS.decode_text(text_buf);
single_value->field_requestedPDPaddress.decode_text(text_buf);
single_value->field_accessPointName.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_requestType.decode_text(text_buf);
single_value->field_deviceProperties.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest.");
}
}

void PDU__SM__ActivatePDPContextRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivatePDPContextRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedNSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedLLCSAPI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedQoS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) requestedPDPaddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) requestType().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLCSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLCSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedPDPaddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedPDPaddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivatePDPContextRequest_template* precondition = new PDU__SM__ActivatePDPContextRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivatePDPContextRequest_template* implied_template = new PDU__SM__ActivatePDPContextRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivatePDPContextRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivatePDPContextRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_requestedNSAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_requestedLLCSAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_requestedQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_requestedPDPaddress.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_accessPointName.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_requestType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_deviceProperties.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextRequest");
}

boolean PDU__SM__ActivatePDPContextRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivatePDPContextRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivatePDPContextAccept::PDU__SM__ActivatePDPContextAccept()
{
}

PDU__SM__ActivatePDPContextAccept::PDU__SM__ActivatePDPContextAccept(const BITSTRING& par_messageType,
    const LLC__SAPIV& par_negotiatedLLCSAPI,
    const QoSLV& par_negotiatedQoS,
    const RadioPriorityV& par_radioPriority,
    const BITSTRING& par_spare,
    const OPTIONAL< PDPAddressTLV >& par_pdpAddress,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< PacketFlowIDTLV >& par_packetFlowID,
    const OPTIONAL< SMCause2TLV >& par_sMCause2,
    const OPTIONAL< ConnectivityTypeTV >& par_connectivityType,
    const OPTIONAL< WLANOffloadAcceptabilityTV >& par_wLANOffloadIndication,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_negotiatedLLCSAPI(par_negotiatedLLCSAPI),
  field_negotiatedQoS(par_negotiatedQoS),
  field_radioPriority(par_radioPriority),
  field_spare(par_spare),
  field_pdpAddress(par_pdpAddress),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_packetFlowID(par_packetFlowID),
  field_sMCause2(par_sMCause2),
  field_connectivityType(par_connectivityType),
  field_wLANOffloadIndication(par_wLANOffloadIndication),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivatePDPContextAccept::PDU__SM__ActivatePDPContextAccept(const PDU__SM__ActivatePDPContextAccept& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.negotiatedLLCSAPI().is_bound()) field_negotiatedLLCSAPI = other_value.negotiatedLLCSAPI();
else field_negotiatedLLCSAPI.clean_up();
if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
else field_negotiatedQoS.clean_up();
if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
else field_radioPriority.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.pdpAddress().is_bound()) field_pdpAddress = other_value.pdpAddress();
else field_pdpAddress.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.packetFlowID().is_bound()) field_packetFlowID = other_value.packetFlowID();
else field_packetFlowID.clean_up();
if (other_value.sMCause2().is_bound()) field_sMCause2 = other_value.sMCause2();
else field_sMCause2.clean_up();
if (other_value.connectivityType().is_bound()) field_connectivityType = other_value.connectivityType();
else field_connectivityType.clean_up();
if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
else field_wLANOffloadIndication.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivatePDPContextAccept::clean_up()
{
field_messageType.clean_up();
field_negotiatedLLCSAPI.clean_up();
field_negotiatedQoS.clean_up();
field_radioPriority.clean_up();
field_spare.clean_up();
field_pdpAddress.clean_up();
field_protocolConfigOpts.clean_up();
field_packetFlowID.clean_up();
field_sMCause2.clean_up();
field_connectivityType.clean_up();
field_wLANOffloadIndication.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivatePDPContextAccept::get_descriptor() const { return &PDU__SM__ActivatePDPContextAccept_descr_; }
PDU__SM__ActivatePDPContextAccept& PDU__SM__ActivatePDPContextAccept::operator=(const PDU__SM__ActivatePDPContextAccept& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.negotiatedLLCSAPI().is_bound()) field_negotiatedLLCSAPI = other_value.negotiatedLLCSAPI();
  else field_negotiatedLLCSAPI.clean_up();
  if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
  else field_negotiatedQoS.clean_up();
  if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
  else field_radioPriority.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.pdpAddress().is_bound()) field_pdpAddress = other_value.pdpAddress();
  else field_pdpAddress.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.packetFlowID().is_bound()) field_packetFlowID = other_value.packetFlowID();
  else field_packetFlowID.clean_up();
  if (other_value.sMCause2().is_bound()) field_sMCause2 = other_value.sMCause2();
  else field_sMCause2.clean_up();
  if (other_value.connectivityType().is_bound()) field_connectivityType = other_value.connectivityType();
  else field_connectivityType.clean_up();
  if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
  else field_wLANOffloadIndication.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivatePDPContextAccept::operator==(const PDU__SM__ActivatePDPContextAccept& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_negotiatedLLCSAPI==other_value.field_negotiatedLLCSAPI
  && field_negotiatedQoS==other_value.field_negotiatedQoS
  && field_radioPriority==other_value.field_radioPriority
  && field_spare==other_value.field_spare
  && field_pdpAddress==other_value.field_pdpAddress
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_packetFlowID==other_value.field_packetFlowID
  && field_sMCause2==other_value.field_sMCause2
  && field_connectivityType==other_value.field_connectivityType
  && field_wLANOffloadIndication==other_value.field_wLANOffloadIndication
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivatePDPContextAccept::is_bound() const
{
return (field_messageType.is_bound())
  || (field_negotiatedLLCSAPI.is_bound())
  || (field_negotiatedQoS.is_bound())
  || (field_radioPriority.is_bound())
  || (field_spare.is_bound())
  || (OPTIONAL_OMIT == field_pdpAddress.get_selection() || field_pdpAddress.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_packetFlowID.get_selection() || field_packetFlowID.is_bound())
  || (OPTIONAL_OMIT == field_sMCause2.get_selection() || field_sMCause2.is_bound())
  || (OPTIONAL_OMIT == field_connectivityType.get_selection() || field_connectivityType.is_bound())
  || (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivatePDPContextAccept::is_value() const
{
return field_messageType.is_value()
  && field_negotiatedLLCSAPI.is_value()
  && field_negotiatedQoS.is_value()
  && field_radioPriority.is_value()
  && field_spare.is_value()
  && (OPTIONAL_OMIT == field_pdpAddress.get_selection() || field_pdpAddress.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_packetFlowID.get_selection() || field_packetFlowID.is_value())
  && (OPTIONAL_OMIT == field_sMCause2.get_selection() || field_sMCause2.is_value())
  && (OPTIONAL_OMIT == field_connectivityType.get_selection() || field_connectivityType.is_value())
  && (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivatePDPContextAccept::size_of() const
{
  int ret_val = 5;
  if (field_pdpAddress.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_packetFlowID.ispresent()) ret_val++;
  if (field_sMCause2.ispresent()) ret_val++;
  if (field_connectivityType.ispresent()) ret_val++;
  if (field_wLANOffloadIndication.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivatePDPContextAccept::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", negotiatedLLCSAPI := ");
field_negotiatedLLCSAPI.log();
TTCN_Logger::log_event_str(", negotiatedQoS := ");
field_negotiatedQoS.log();
TTCN_Logger::log_event_str(", radioPriority := ");
field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", pdpAddress := ");
field_pdpAddress.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", packetFlowID := ");
field_packetFlowID.log();
TTCN_Logger::log_event_str(", sMCause2 := ");
field_sMCause2.log();
TTCN_Logger::log_event_str(", connectivityType := ");
field_connectivityType.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivatePDPContextAccept::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (negotiatedLLCSAPI().is_bound()) negotiatedLLCSAPI().set_implicit_omit();
if (negotiatedQoS().is_bound()) negotiatedQoS().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!pdpAddress().is_bound()) pdpAddress() = OMIT_VALUE;
else pdpAddress().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!packetFlowID().is_bound()) packetFlowID() = OMIT_VALUE;
else packetFlowID().set_implicit_omit();
if (!sMCause2().is_bound()) sMCause2() = OMIT_VALUE;
else sMCause2().set_implicit_omit();
if (!connectivityType().is_bound()) connectivityType() = OMIT_VALUE;
else connectivityType().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextAccept::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) negotiatedLLCSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) negotiatedQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) pdpAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) packetFlowID().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sMCause2().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) connectivityType().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedLLCSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedLLCSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectivityType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectivityType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
  }
}

void PDU__SM__ActivatePDPContextAccept::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_negotiatedLLCSAPI.encode_text(text_buf);
field_negotiatedQoS.encode_text(text_buf);
field_radioPriority.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_pdpAddress.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_packetFlowID.encode_text(text_buf);
field_sMCause2.encode_text(text_buf);
field_connectivityType.encode_text(text_buf);
field_wLANOffloadIndication.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivatePDPContextAccept::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_negotiatedLLCSAPI.decode_text(text_buf);
field_negotiatedQoS.decode_text(text_buf);
field_radioPriority.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_pdpAddress.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_packetFlowID.decode_text(text_buf);
field_sMCause2.decode_text(text_buf);
field_connectivityType.decode_text(text_buf);
field_wLANOffloadIndication.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivatePDPContextAccept::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivatePDPContextAccept::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivatePDPContextAccept::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedLLCSAPI.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedQoS.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RadioPriorityV_descr_.raw->forceomit);
  decoded_field_length = field_radioPriority.RAW_decode(RadioPriorityV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_pdpAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, PDPAddressTLV_descr_.raw->forceomit);
  decoded_field_length = field_pdpAddress().RAW_decode(PDPAddressTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_pdpAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_pdpAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_packetFlowID = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, PacketFlowIDTLV_descr_.raw->forceomit);
  decoded_field_length = field_packetFlowID().RAW_decode(PacketFlowIDTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_packetFlowID = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_packetFlowID=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_sMCause2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, SMCause2TLV_descr_.raw->forceomit);
  decoded_field_length = field_sMCause2().RAW_decode(SMCause2TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_sMCause2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sMCause2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_connectivityType = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, ConnectivityTypeTV_descr_.raw->forceomit);
  decoded_field_length = field_connectivityType().RAW_decode(ConnectivityTypeTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_connectivityType = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_connectivityType=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_wLANOffloadIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, WLANOffloadAcceptabilityTV_descr_.raw->forceomit);
  decoded_field_length = field_wLANOffloadIndication().RAW_decode(WLANOffloadAcceptabilityTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_wLANOffloadIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_wLANOffloadIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_52) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivatePDPContextAccept::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 12;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(12);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LLC__SAPIV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, QoSLV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RadioPriorityV_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT4_descr_.raw);
  if (field_pdpAddress.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PDPAddressTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_packetFlowID.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, PacketFlowIDTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_sMCause2.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, SMCause2TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_connectivityType.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, ConnectivityTypeTV_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_wLANOffloadIndication.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, WLANOffloadAcceptabilityTV_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_negotiatedLLCSAPI.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_negotiatedQoS.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_radioPriority.RAW_encode(RadioPriorityV_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[4]);
  if (field_pdpAddress.ispresent()) {
  encoded_length += field_pdpAddress().RAW_encode(PDPAddressTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_packetFlowID.ispresent()) {
  encoded_length += field_packetFlowID().RAW_encode(PacketFlowIDTLV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_sMCause2.ispresent()) {
  encoded_length += field_sMCause2().RAW_encode(SMCause2TLV_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_connectivityType.ispresent()) {
  encoded_length += field_connectivityType().RAW_encode(ConnectivityTypeTV_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_wLANOffloadIndication.ispresent()) {
  encoded_length += field_wLANOffloadIndication().RAW_encode(WLANOffloadAcceptabilityTV_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_messageType !=  bs_52) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_52.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivatePDPContextAccept_template::single_value_struct {
BITSTRING_template field_messageType;
LLC__SAPIV_template field_negotiatedLLCSAPI;
QoSLV_template field_negotiatedQoS;
RadioPriorityV_template field_radioPriority;
BITSTRING_template field_spare;
PDPAddressTLV_template field_pdpAddress;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
PacketFlowIDTLV_template field_packetFlowID;
SMCause2TLV_template field_sMCause2;
ConnectivityTypeTV_template field_connectivityType;
WLANOffloadAcceptabilityTV_template field_wLANOffloadIndication;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivatePDPContextAccept_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_negotiatedLLCSAPI = ANY_VALUE;
single_value->field_negotiatedQoS = ANY_VALUE;
single_value->field_radioPriority = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_pdpAddress = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_packetFlowID = ANY_OR_OMIT;
single_value->field_sMCause2 = ANY_OR_OMIT;
single_value->field_connectivityType = ANY_OR_OMIT;
single_value->field_wLANOffloadIndication = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivatePDPContextAccept_template::copy_value(const PDU__SM__ActivatePDPContextAccept& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.negotiatedLLCSAPI().is_bound()) {
  single_value->field_negotiatedLLCSAPI = other_value.negotiatedLLCSAPI();
} else {
  single_value->field_negotiatedLLCSAPI.clean_up();
}
if (other_value.negotiatedQoS().is_bound()) {
  single_value->field_negotiatedQoS = other_value.negotiatedQoS();
} else {
  single_value->field_negotiatedQoS.clean_up();
}
if (other_value.radioPriority().is_bound()) {
  single_value->field_radioPriority = other_value.radioPriority();
} else {
  single_value->field_radioPriority.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.pdpAddress().is_bound()) {
  if (other_value.pdpAddress().ispresent()) single_value->field_pdpAddress = other_value.pdpAddress()();
  else single_value->field_pdpAddress = OMIT_VALUE;
} else {
  single_value->field_pdpAddress.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.packetFlowID().is_bound()) {
  if (other_value.packetFlowID().ispresent()) single_value->field_packetFlowID = other_value.packetFlowID()();
  else single_value->field_packetFlowID = OMIT_VALUE;
} else {
  single_value->field_packetFlowID.clean_up();
}
if (other_value.sMCause2().is_bound()) {
  if (other_value.sMCause2().ispresent()) single_value->field_sMCause2 = other_value.sMCause2()();
  else single_value->field_sMCause2 = OMIT_VALUE;
} else {
  single_value->field_sMCause2.clean_up();
}
if (other_value.connectivityType().is_bound()) {
  if (other_value.connectivityType().ispresent()) single_value->field_connectivityType = other_value.connectivityType()();
  else single_value->field_connectivityType = OMIT_VALUE;
} else {
  single_value->field_connectivityType.clean_up();
}
if (other_value.wLANOffloadIndication().is_bound()) {
  if (other_value.wLANOffloadIndication().ispresent()) single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication()();
  else single_value->field_wLANOffloadIndication = OMIT_VALUE;
} else {
  single_value->field_wLANOffloadIndication.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivatePDPContextAccept_template::copy_template(const PDU__SM__ActivatePDPContextAccept_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedLLCSAPI().get_selection()) {
single_value->field_negotiatedLLCSAPI = other_value.negotiatedLLCSAPI();
} else {
single_value->field_negotiatedLLCSAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedQoS().get_selection()) {
single_value->field_negotiatedQoS = other_value.negotiatedQoS();
} else {
single_value->field_negotiatedQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.radioPriority().get_selection()) {
single_value->field_radioPriority = other_value.radioPriority();
} else {
single_value->field_radioPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpAddress().get_selection()) {
single_value->field_pdpAddress = other_value.pdpAddress();
} else {
single_value->field_pdpAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFlowID().get_selection()) {
single_value->field_packetFlowID = other_value.packetFlowID();
} else {
single_value->field_packetFlowID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sMCause2().get_selection()) {
single_value->field_sMCause2 = other_value.sMCause2();
} else {
single_value->field_sMCause2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connectivityType().get_selection()) {
single_value->field_connectivityType = other_value.connectivityType();
} else {
single_value->field_connectivityType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.wLANOffloadIndication().get_selection()) {
single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication();
} else {
single_value->field_wLANOffloadIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivatePDPContextAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivatePDPContextAccept_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivatePDPContextAccept_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template()
{
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(const PDU__SM__ActivatePDPContextAccept& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(const OPTIONAL<PDU__SM__ActivatePDPContextAccept>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept from an unbound optional field.");
}
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(PDU__SM__ActivatePDPContextAccept_template* p_precondition, PDU__SM__ActivatePDPContextAccept_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(Dynamic_Match_Interface<PDU__SM__ActivatePDPContextAccept>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivatePDPContextAccept>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivatePDPContextAccept_template::PDU__SM__ActivatePDPContextAccept_template(const PDU__SM__ActivatePDPContextAccept_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivatePDPContextAccept_template::~PDU__SM__ActivatePDPContextAccept_template()
{
clean_up();
}

PDU__SM__ActivatePDPContextAccept_template& PDU__SM__ActivatePDPContextAccept_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivatePDPContextAccept_template& PDU__SM__ActivatePDPContextAccept_template::operator=(const PDU__SM__ActivatePDPContextAccept& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivatePDPContextAccept_template& PDU__SM__ActivatePDPContextAccept_template::operator=(const OPTIONAL<PDU__SM__ActivatePDPContextAccept>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
}
return *this;
}

PDU__SM__ActivatePDPContextAccept_template& PDU__SM__ActivatePDPContextAccept_template::operator=(const PDU__SM__ActivatePDPContextAccept_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivatePDPContextAccept_template::match(const PDU__SM__ActivatePDPContextAccept& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.negotiatedLLCSAPI().is_bound()) return FALSE;
if(!single_value->field_negotiatedLLCSAPI.match(other_value.negotiatedLLCSAPI(), legacy))return FALSE;
if(!other_value.negotiatedQoS().is_bound()) return FALSE;
if(!single_value->field_negotiatedQoS.match(other_value.negotiatedQoS(), legacy))return FALSE;
if(!other_value.radioPriority().is_bound()) return FALSE;
if(!single_value->field_radioPriority.match(other_value.radioPriority(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.pdpAddress().is_bound()) return FALSE;
if((other_value.pdpAddress().ispresent() ? !single_value->field_pdpAddress.match((const PDPAddressTLV&)other_value.pdpAddress(), legacy) : !single_value->field_pdpAddress.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.packetFlowID().is_bound()) return FALSE;
if((other_value.packetFlowID().ispresent() ? !single_value->field_packetFlowID.match((const PacketFlowIDTLV&)other_value.packetFlowID(), legacy) : !single_value->field_packetFlowID.match_omit(legacy)))return FALSE;
if(!other_value.sMCause2().is_bound()) return FALSE;
if((other_value.sMCause2().ispresent() ? !single_value->field_sMCause2.match((const SMCause2TLV&)other_value.sMCause2(), legacy) : !single_value->field_sMCause2.match_omit(legacy)))return FALSE;
if(!other_value.connectivityType().is_bound()) return FALSE;
if((other_value.connectivityType().ispresent() ? !single_value->field_connectivityType.match((const ConnectivityTypeTV&)other_value.connectivityType(), legacy) : !single_value->field_connectivityType.match_omit(legacy)))return FALSE;
if(!other_value.wLANOffloadIndication().is_bound()) return FALSE;
if((other_value.wLANOffloadIndication().ispresent() ? !single_value->field_wLANOffloadIndication.match((const WLANOffloadAcceptabilityTV&)other_value.wLANOffloadIndication(), legacy) : !single_value->field_wLANOffloadIndication.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
}
return FALSE;
}

boolean PDU__SM__ActivatePDPContextAccept_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_negotiatedLLCSAPI.is_bound()
 || single_value->field_negotiatedQoS.is_bound()
 || single_value->field_radioPriority.is_bound()
 || single_value->field_spare.is_bound()
 || (single_value->field_pdpAddress.is_omit() || single_value->field_pdpAddress.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_packetFlowID.is_omit() || single_value->field_packetFlowID.is_bound())
 || (single_value->field_sMCause2.is_omit() || single_value->field_sMCause2.is_bound())
 || (single_value->field_connectivityType.is_omit() || single_value->field_connectivityType.is_bound())
 || (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivatePDPContextAccept_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_negotiatedLLCSAPI.is_value()
 && single_value->field_negotiatedQoS.is_value()
 && single_value->field_radioPriority.is_value()
 && single_value->field_spare.is_value()
 && (single_value->field_pdpAddress.is_omit() || single_value->field_pdpAddress.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_packetFlowID.is_omit() || single_value->field_packetFlowID.is_value())
 && (single_value->field_sMCause2.is_omit() || single_value->field_sMCause2.is_value())
 && (single_value->field_connectivityType.is_omit() || single_value->field_connectivityType.is_value())
 && (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivatePDPContextAccept_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivatePDPContextAccept PDU__SM__ActivatePDPContextAccept_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
PDU__SM__ActivatePDPContextAccept ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_negotiatedLLCSAPI.is_bound()) {
ret_val.negotiatedLLCSAPI() = single_value->field_negotiatedLLCSAPI.valueof();
}
if (single_value->field_negotiatedQoS.is_bound()) {
ret_val.negotiatedQoS() = single_value->field_negotiatedQoS.valueof();
}
if (single_value->field_radioPriority.is_bound()) {
ret_val.radioPriority() = single_value->field_radioPriority.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_pdpAddress.is_omit()) ret_val.pdpAddress() = OMIT_VALUE;
else if (single_value->field_pdpAddress.is_bound()) {
ret_val.pdpAddress() = single_value->field_pdpAddress.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_packetFlowID.is_omit()) ret_val.packetFlowID() = OMIT_VALUE;
else if (single_value->field_packetFlowID.is_bound()) {
ret_val.packetFlowID() = single_value->field_packetFlowID.valueof();
}
if (single_value->field_sMCause2.is_omit()) ret_val.sMCause2() = OMIT_VALUE;
else if (single_value->field_sMCause2.is_bound()) {
ret_val.sMCause2() = single_value->field_sMCause2.valueof();
}
if (single_value->field_connectivityType.is_omit()) ret_val.connectivityType() = OMIT_VALUE;
else if (single_value->field_connectivityType.is_bound()) {
ret_val.connectivityType() = single_value->field_connectivityType.valueof();
}
if (single_value->field_wLANOffloadIndication.is_omit()) ret_val.wLANOffloadIndication() = OMIT_VALUE;
else if (single_value->field_wLANOffloadIndication.is_bound()) {
ret_val.wLANOffloadIndication() = single_value->field_wLANOffloadIndication.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivatePDPContextAccept_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivatePDPContextAccept_template[list_length];
}

PDU__SM__ActivatePDPContextAccept_template& PDU__SM__ActivatePDPContextAccept_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivatePDPContextAccept_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivatePDPContextAccept_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_messageType;
}

LLC__SAPIV_template& PDU__SM__ActivatePDPContextAccept_template::negotiatedLLCSAPI()
{
set_specific();
return single_value->field_negotiatedLLCSAPI;
}

const LLC__SAPIV_template& PDU__SM__ActivatePDPContextAccept_template::negotiatedLLCSAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field negotiatedLLCSAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_negotiatedLLCSAPI;
}

QoSLV_template& PDU__SM__ActivatePDPContextAccept_template::negotiatedQoS()
{
set_specific();
return single_value->field_negotiatedQoS;
}

const QoSLV_template& PDU__SM__ActivatePDPContextAccept_template::negotiatedQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field negotiatedQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_negotiatedQoS;
}

RadioPriorityV_template& PDU__SM__ActivatePDPContextAccept_template::radioPriority()
{
set_specific();
return single_value->field_radioPriority;
}

const RadioPriorityV_template& PDU__SM__ActivatePDPContextAccept_template::radioPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field radioPriority of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_radioPriority;
}

BITSTRING_template& PDU__SM__ActivatePDPContextAccept_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PDU__SM__ActivatePDPContextAccept_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_spare;
}

PDPAddressTLV_template& PDU__SM__ActivatePDPContextAccept_template::pdpAddress()
{
set_specific();
return single_value->field_pdpAddress;
}

const PDPAddressTLV_template& PDU__SM__ActivatePDPContextAccept_template::pdpAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpAddress of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_pdpAddress;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextAccept_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextAccept_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_protocolConfigOpts;
}

PacketFlowIDTLV_template& PDU__SM__ActivatePDPContextAccept_template::packetFlowID()
{
set_specific();
return single_value->field_packetFlowID;
}

const PacketFlowIDTLV_template& PDU__SM__ActivatePDPContextAccept_template::packetFlowID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFlowID of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_packetFlowID;
}

SMCause2TLV_template& PDU__SM__ActivatePDPContextAccept_template::sMCause2()
{
set_specific();
return single_value->field_sMCause2;
}

const SMCause2TLV_template& PDU__SM__ActivatePDPContextAccept_template::sMCause2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sMCause2 of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_sMCause2;
}

ConnectivityTypeTV_template& PDU__SM__ActivatePDPContextAccept_template::connectivityType()
{
set_specific();
return single_value->field_connectivityType;
}

const ConnectivityTypeTV_template& PDU__SM__ActivatePDPContextAccept_template::connectivityType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connectivityType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_connectivityType;
}

WLANOffloadAcceptabilityTV_template& PDU__SM__ActivatePDPContextAccept_template::wLANOffloadIndication()
{
set_specific();
return single_value->field_wLANOffloadIndication;
}

const WLANOffloadAcceptabilityTV_template& PDU__SM__ActivatePDPContextAccept_template::wLANOffloadIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field wLANOffloadIndication of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_wLANOffloadIndication;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextAccept_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextAccept_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivatePDPContextAccept_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_pdpAddress.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_packetFlowID.is_present()) ret_val++;
      if (single_value->field_sMCause2.is_present()) ret_val++;
      if (single_value->field_connectivityType.is_present()) ret_val++;
      if (single_value->field_wLANOffloadIndication.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
  }
  return 0;
}

void PDU__SM__ActivatePDPContextAccept_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", negotiatedLLCSAPI := ");
single_value->field_negotiatedLLCSAPI.log();
TTCN_Logger::log_event_str(", negotiatedQoS := ");
single_value->field_negotiatedQoS.log();
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", pdpAddress := ");
single_value->field_pdpAddress.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", packetFlowID := ");
single_value->field_packetFlowID.log();
TTCN_Logger::log_event_str(", sMCause2 := ");
single_value->field_sMCause2.log();
TTCN_Logger::log_event_str(", connectivityType := ");
single_value->field_connectivityType.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivatePDPContextAccept_template::log_match(const PDU__SM__ActivatePDPContextAccept& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_negotiatedLLCSAPI.match(match_value.negotiatedLLCSAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".negotiatedLLCSAPI");
single_value->field_negotiatedLLCSAPI.log_match(match_value.negotiatedLLCSAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_negotiatedQoS.match(match_value.negotiatedQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".negotiatedQoS");
single_value->field_negotiatedQoS.log_match(match_value.negotiatedQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_radioPriority.match(match_value.radioPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".radioPriority");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pdpAddress().ispresent()){
if(!single_value->field_pdpAddress.match(match_value.pdpAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpAddress");
single_value->field_pdpAddress.log_match(match_value.pdpAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdpAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdpAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdpAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.packetFlowID().ispresent()){
if(!single_value->field_packetFlowID.match(match_value.packetFlowID(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFlowID");
single_value->field_packetFlowID.log_match(match_value.packetFlowID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_packetFlowID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".packetFlowID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_packetFlowID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sMCause2().ispresent()){
if(!single_value->field_sMCause2.match(match_value.sMCause2(), legacy)){
TTCN_Logger::log_logmatch_info(".sMCause2");
single_value->field_sMCause2.log_match(match_value.sMCause2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sMCause2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sMCause2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sMCause2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.connectivityType().ispresent()){
if(!single_value->field_connectivityType.match(match_value.connectivityType(), legacy)){
TTCN_Logger::log_logmatch_info(".connectivityType");
single_value->field_connectivityType.log_match(match_value.connectivityType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_connectivityType.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".connectivityType := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_connectivityType.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.wLANOffloadIndication().ispresent()){
if(!single_value->field_wLANOffloadIndication.match(match_value.wLANOffloadIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".wLANOffloadIndication");
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_wLANOffloadIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".wLANOffloadIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", negotiatedLLCSAPI := ");
single_value->field_negotiatedLLCSAPI.log_match(match_value.negotiatedLLCSAPI(), legacy);
TTCN_Logger::log_event_str(", negotiatedQoS := ");
single_value->field_negotiatedQoS.log_match(match_value.negotiatedQoS(), legacy);
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", pdpAddress := ");
if (match_value.pdpAddress().ispresent()) {
single_value->field_pdpAddress.log_match(match_value.pdpAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdpAddress.log();
if (single_value->field_pdpAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", packetFlowID := ");
if (match_value.packetFlowID().ispresent()) {
single_value->field_packetFlowID.log_match(match_value.packetFlowID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_packetFlowID.log();
if (single_value->field_packetFlowID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sMCause2 := ");
if (match_value.sMCause2().ispresent()) {
single_value->field_sMCause2.log_match(match_value.sMCause2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sMCause2.log();
if (single_value->field_sMCause2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", connectivityType := ");
if (match_value.connectivityType().ispresent()) {
single_value->field_connectivityType.log_match(match_value.connectivityType(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_connectivityType.log();
if (single_value->field_connectivityType.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
if (match_value.wLANOffloadIndication().ispresent()) {
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_wLANOffloadIndication.log();
if (single_value->field_wLANOffloadIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivatePDPContextAccept_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (negotiatedLLCSAPI().is_bound()) negotiatedLLCSAPI().set_implicit_omit();
if (negotiatedQoS().is_bound()) negotiatedQoS().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!pdpAddress().is_bound()) pdpAddress() = OMIT_VALUE;
else pdpAddress().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!packetFlowID().is_bound()) packetFlowID() = OMIT_VALUE;
else packetFlowID().set_implicit_omit();
if (!sMCause2().is_bound()) sMCause2() = OMIT_VALUE;
else sMCause2().set_implicit_omit();
if (!connectivityType().is_bound()) connectivityType() = OMIT_VALUE;
else connectivityType().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextAccept_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_negotiatedLLCSAPI.encode_text(text_buf);
single_value->field_negotiatedQoS.encode_text(text_buf);
single_value->field_radioPriority.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_pdpAddress.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_packetFlowID.encode_text(text_buf);
single_value->field_sMCause2.encode_text(text_buf);
single_value->field_connectivityType.encode_text(text_buf);
single_value->field_wLANOffloadIndication.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
}
}

void PDU__SM__ActivatePDPContextAccept_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_negotiatedLLCSAPI.decode_text(text_buf);
single_value->field_negotiatedQoS.decode_text(text_buf);
single_value->field_radioPriority.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_pdpAddress.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_packetFlowID.decode_text(text_buf);
single_value->field_sMCause2.decode_text(text_buf);
single_value->field_connectivityType.decode_text(text_buf);
single_value->field_wLANOffloadIndication.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivatePDPContextAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept.");
}
}

void PDU__SM__ActivatePDPContextAccept_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivatePDPContextAccept_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) negotiatedLLCSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) negotiatedQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) pdpAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) packetFlowID().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sMCause2().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) connectivityType().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedLLCSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedLLCSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectivityType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectivityType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivatePDPContextAccept_template* precondition = new PDU__SM__ActivatePDPContextAccept_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivatePDPContextAccept_template* implied_template = new PDU__SM__ActivatePDPContextAccept_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivatePDPContextAccept_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivatePDPContextAccept_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_negotiatedLLCSAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_negotiatedQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_radioPriority.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_pdpAddress.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_packetFlowID.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_sMCause2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_connectivityType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_wLANOffloadIndication.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextAccept");
}

boolean PDU__SM__ActivatePDPContextAccept_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivatePDPContextAccept_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivatePDPContextReject::PDU__SM__ActivatePDPContextReject()
{
}

PDU__SM__ActivatePDPContextReject::PDU__SM__ActivatePDPContextReject(const BITSTRING& par_messageType,
    const OCTETSTRING& par_smCause,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< MobileL3__CommonIE__Types::GPRSTimer3TLV >& par_backOffTimer,
    const OPTIONAL< ReAttemptIndicatorTLV >& par_reAttemptIndicator,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_smCause(par_smCause),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_backOffTimer(par_backOffTimer),
  field_reAttemptIndicator(par_reAttemptIndicator),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivatePDPContextReject::PDU__SM__ActivatePDPContextReject(const PDU__SM__ActivatePDPContextReject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
else field_smCause.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.backOffTimer().is_bound()) field_backOffTimer = other_value.backOffTimer();
else field_backOffTimer.clean_up();
if (other_value.reAttemptIndicator().is_bound()) field_reAttemptIndicator = other_value.reAttemptIndicator();
else field_reAttemptIndicator.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivatePDPContextReject::clean_up()
{
field_messageType.clean_up();
field_smCause.clean_up();
field_protocolConfigOpts.clean_up();
field_backOffTimer.clean_up();
field_reAttemptIndicator.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivatePDPContextReject::get_descriptor() const { return &PDU__SM__ActivatePDPContextReject_descr_; }
PDU__SM__ActivatePDPContextReject& PDU__SM__ActivatePDPContextReject::operator=(const PDU__SM__ActivatePDPContextReject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
  else field_smCause.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.backOffTimer().is_bound()) field_backOffTimer = other_value.backOffTimer();
  else field_backOffTimer.clean_up();
  if (other_value.reAttemptIndicator().is_bound()) field_reAttemptIndicator = other_value.reAttemptIndicator();
  else field_reAttemptIndicator.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivatePDPContextReject::operator==(const PDU__SM__ActivatePDPContextReject& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_smCause==other_value.field_smCause
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_backOffTimer==other_value.field_backOffTimer
  && field_reAttemptIndicator==other_value.field_reAttemptIndicator
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivatePDPContextReject::is_bound() const
{
return (field_messageType.is_bound())
  || (field_smCause.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_backOffTimer.get_selection() || field_backOffTimer.is_bound())
  || (OPTIONAL_OMIT == field_reAttemptIndicator.get_selection() || field_reAttemptIndicator.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivatePDPContextReject::is_value() const
{
return field_messageType.is_value()
  && field_smCause.is_value()
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_backOffTimer.get_selection() || field_backOffTimer.is_value())
  && (OPTIONAL_OMIT == field_reAttemptIndicator.get_selection() || field_reAttemptIndicator.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivatePDPContextReject::size_of() const
{
  int ret_val = 2;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_backOffTimer.ispresent()) ret_val++;
  if (field_reAttemptIndicator.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivatePDPContextReject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", backOffTimer := ");
field_backOffTimer.log();
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivatePDPContextReject::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!backOffTimer().is_bound()) backOffTimer() = OMIT_VALUE;
else backOffTimer().set_implicit_omit();
if (!reAttemptIndicator().is_bound()) reAttemptIndicator() = OMIT_VALUE;
else reAttemptIndicator().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextReject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) backOffTimer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "backOffTimer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          backOffTimer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
  }
}

void PDU__SM__ActivatePDPContextReject::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_smCause.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_backOffTimer.encode_text(text_buf);
field_reAttemptIndicator.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivatePDPContextReject::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_smCause.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_backOffTimer.decode_text(text_buf);
field_reAttemptIndicator.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivatePDPContextReject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivatePDPContextReject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivatePDPContextReject::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SMCauseV_descr_.raw->forceomit);
  decoded_field_length = field_smCause.RAW_decode(SMCauseV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_backOffTimer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_.raw->forceomit);
  decoded_field_length = field_backOffTimer().RAW_decode(MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_backOffTimer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_backOffTimer.ispresent() || field_backOffTimer().elementIdentifier() !=  os_33){
  field_backOffTimer=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_backOffTimer=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_reAttemptIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, ReAttemptIndicatorTLV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicator().RAW_decode(ReAttemptIndicatorTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_reAttemptIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_reAttemptIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_53) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivatePDPContextReject::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SMCauseV_descr_.raw);
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_backOffTimer.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_reAttemptIndicator.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ReAttemptIndicatorTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_smCause.RAW_encode(SMCauseV_descr_, *myleaf.body.node.nodes[1]);
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_backOffTimer.ispresent()) {
  encoded_length += field_backOffTimer().RAW_encode(MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_reAttemptIndicator.ispresent()) {
  encoded_length += field_reAttemptIndicator().RAW_encode(ReAttemptIndicatorTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_backOffTimer.ispresent() && (!field_backOffTimer.ispresent() || field_backOffTimer().elementIdentifier() !=  os_33)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_33.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_53) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_53.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivatePDPContextReject_template::single_value_struct {
BITSTRING_template field_messageType;
OCTETSTRING_template field_smCause;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
MobileL3__CommonIE__Types::GPRSTimer3TLV_template field_backOffTimer;
ReAttemptIndicatorTLV_template field_reAttemptIndicator;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivatePDPContextReject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_smCause = ANY_VALUE;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_backOffTimer = ANY_OR_OMIT;
single_value->field_reAttemptIndicator = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivatePDPContextReject_template::copy_value(const PDU__SM__ActivatePDPContextReject& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.smCause().is_bound()) {
  single_value->field_smCause = other_value.smCause();
} else {
  single_value->field_smCause.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.backOffTimer().is_bound()) {
  if (other_value.backOffTimer().ispresent()) single_value->field_backOffTimer = other_value.backOffTimer()();
  else single_value->field_backOffTimer = OMIT_VALUE;
} else {
  single_value->field_backOffTimer.clean_up();
}
if (other_value.reAttemptIndicator().is_bound()) {
  if (other_value.reAttemptIndicator().ispresent()) single_value->field_reAttemptIndicator = other_value.reAttemptIndicator()();
  else single_value->field_reAttemptIndicator = OMIT_VALUE;
} else {
  single_value->field_reAttemptIndicator.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivatePDPContextReject_template::copy_template(const PDU__SM__ActivatePDPContextReject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.smCause().get_selection()) {
single_value->field_smCause = other_value.smCause();
} else {
single_value->field_smCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.backOffTimer().get_selection()) {
single_value->field_backOffTimer = other_value.backOffTimer();
} else {
single_value->field_backOffTimer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicator().get_selection()) {
single_value->field_reAttemptIndicator = other_value.reAttemptIndicator();
} else {
single_value->field_reAttemptIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivatePDPContextReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivatePDPContextReject_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivatePDPContextReject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template()
{
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(const PDU__SM__ActivatePDPContextReject& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(const OPTIONAL<PDU__SM__ActivatePDPContextReject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject from an unbound optional field.");
}
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(PDU__SM__ActivatePDPContextReject_template* p_precondition, PDU__SM__ActivatePDPContextReject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(Dynamic_Match_Interface<PDU__SM__ActivatePDPContextReject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivatePDPContextReject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivatePDPContextReject_template::PDU__SM__ActivatePDPContextReject_template(const PDU__SM__ActivatePDPContextReject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivatePDPContextReject_template::~PDU__SM__ActivatePDPContextReject_template()
{
clean_up();
}

PDU__SM__ActivatePDPContextReject_template& PDU__SM__ActivatePDPContextReject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivatePDPContextReject_template& PDU__SM__ActivatePDPContextReject_template::operator=(const PDU__SM__ActivatePDPContextReject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivatePDPContextReject_template& PDU__SM__ActivatePDPContextReject_template::operator=(const OPTIONAL<PDU__SM__ActivatePDPContextReject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivatePDPContextReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
}
return *this;
}

PDU__SM__ActivatePDPContextReject_template& PDU__SM__ActivatePDPContextReject_template::operator=(const PDU__SM__ActivatePDPContextReject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivatePDPContextReject_template::match(const PDU__SM__ActivatePDPContextReject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.smCause().is_bound()) return FALSE;
if(!single_value->field_smCause.match(other_value.smCause(), legacy))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.backOffTimer().is_bound()) return FALSE;
if((other_value.backOffTimer().ispresent() ? !single_value->field_backOffTimer.match((const MobileL3__CommonIE__Types::GPRSTimer3TLV&)other_value.backOffTimer(), legacy) : !single_value->field_backOffTimer.match_omit(legacy)))return FALSE;
if(!other_value.reAttemptIndicator().is_bound()) return FALSE;
if((other_value.reAttemptIndicator().ispresent() ? !single_value->field_reAttemptIndicator.match((const ReAttemptIndicatorTLV&)other_value.reAttemptIndicator(), legacy) : !single_value->field_reAttemptIndicator.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
}
return FALSE;
}

boolean PDU__SM__ActivatePDPContextReject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_smCause.is_bound()
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_backOffTimer.is_omit() || single_value->field_backOffTimer.is_bound())
 || (single_value->field_reAttemptIndicator.is_omit() || single_value->field_reAttemptIndicator.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivatePDPContextReject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_smCause.is_value()
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_backOffTimer.is_omit() || single_value->field_backOffTimer.is_value())
 && (single_value->field_reAttemptIndicator.is_omit() || single_value->field_reAttemptIndicator.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivatePDPContextReject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivatePDPContextReject PDU__SM__ActivatePDPContextReject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
PDU__SM__ActivatePDPContextReject ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_smCause.is_bound()) {
ret_val.smCause() = single_value->field_smCause.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_backOffTimer.is_omit()) ret_val.backOffTimer() = OMIT_VALUE;
else if (single_value->field_backOffTimer.is_bound()) {
ret_val.backOffTimer() = single_value->field_backOffTimer.valueof();
}
if (single_value->field_reAttemptIndicator.is_omit()) ret_val.reAttemptIndicator() = OMIT_VALUE;
else if (single_value->field_reAttemptIndicator.is_bound()) {
ret_val.reAttemptIndicator() = single_value->field_reAttemptIndicator.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivatePDPContextReject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivatePDPContextReject_template[list_length];
}

PDU__SM__ActivatePDPContextReject_template& PDU__SM__ActivatePDPContextReject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivatePDPContextReject_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivatePDPContextReject_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SM__ActivatePDPContextReject_template::smCause()
{
set_specific();
return single_value->field_smCause;
}

const OCTETSTRING_template& PDU__SM__ActivatePDPContextReject_template::smCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field smCause of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_smCause;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextReject_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivatePDPContextReject_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_protocolConfigOpts;
}

MobileL3__CommonIE__Types::GPRSTimer3TLV_template& PDU__SM__ActivatePDPContextReject_template::backOffTimer()
{
set_specific();
return single_value->field_backOffTimer;
}

const MobileL3__CommonIE__Types::GPRSTimer3TLV_template& PDU__SM__ActivatePDPContextReject_template::backOffTimer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field backOffTimer of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_backOffTimer;
}

ReAttemptIndicatorTLV_template& PDU__SM__ActivatePDPContextReject_template::reAttemptIndicator()
{
set_specific();
return single_value->field_reAttemptIndicator;
}

const ReAttemptIndicatorTLV_template& PDU__SM__ActivatePDPContextReject_template::reAttemptIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_reAttemptIndicator;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextReject_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivatePDPContextReject_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivatePDPContextReject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_backOffTimer.is_present()) ret_val++;
      if (single_value->field_reAttemptIndicator.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
  }
  return 0;
}

void PDU__SM__ActivatePDPContextReject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", backOffTimer := ");
single_value->field_backOffTimer.log();
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
single_value->field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivatePDPContextReject_template::log_match(const PDU__SM__ActivatePDPContextReject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_smCause.match(match_value.smCause(), legacy)){
TTCN_Logger::log_logmatch_info(".smCause");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.backOffTimer().ispresent()){
if(!single_value->field_backOffTimer.match(match_value.backOffTimer(), legacy)){
TTCN_Logger::log_logmatch_info(".backOffTimer");
single_value->field_backOffTimer.log_match(match_value.backOffTimer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_backOffTimer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".backOffTimer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_backOffTimer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.reAttemptIndicator().ispresent()){
if(!single_value->field_reAttemptIndicator.match(match_value.reAttemptIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicator");
single_value->field_reAttemptIndicator.log_match(match_value.reAttemptIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_reAttemptIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".reAttemptIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", backOffTimer := ");
if (match_value.backOffTimer().ispresent()) {
single_value->field_backOffTimer.log_match(match_value.backOffTimer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_backOffTimer.log();
if (single_value->field_backOffTimer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
if (match_value.reAttemptIndicator().ispresent()) {
single_value->field_reAttemptIndicator.log_match(match_value.reAttemptIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_reAttemptIndicator.log();
if (single_value->field_reAttemptIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivatePDPContextReject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!backOffTimer().is_bound()) backOffTimer() = OMIT_VALUE;
else backOffTimer().set_implicit_omit();
if (!reAttemptIndicator().is_bound()) reAttemptIndicator() = OMIT_VALUE;
else reAttemptIndicator().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivatePDPContextReject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_smCause.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_backOffTimer.encode_text(text_buf);
single_value->field_reAttemptIndicator.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
}
}

void PDU__SM__ActivatePDPContextReject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_smCause.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_backOffTimer.decode_text(text_buf);
single_value->field_reAttemptIndicator.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivatePDPContextReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject.");
}
}

void PDU__SM__ActivatePDPContextReject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivatePDPContextReject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) backOffTimer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "backOffTimer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          backOffTimer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivatePDPContextReject_template* precondition = new PDU__SM__ActivatePDPContextReject_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivatePDPContextReject_template* implied_template = new PDU__SM__ActivatePDPContextReject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivatePDPContextReject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivatePDPContextReject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
single_value->field_smCause.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
single_value->field_backOffTimer.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
single_value->field_reAttemptIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivatePDPContextReject");
}

boolean PDU__SM__ActivatePDPContextReject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivatePDPContextReject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivateSecondaryPDPContextRequest::PDU__SM__ActivateSecondaryPDPContextRequest()
{
}

PDU__SM__ActivateSecondaryPDPContextRequest::PDU__SM__ActivateSecondaryPDPContextRequest(const BITSTRING& par_messageType,
    const NSAPIV& par_requestedNSAPI,
    const LLC__SAPIV& par_requestedLLC__SAPI,
    const QoSLV& par_requestedQoS,
    const LinkedTILV& par_linkedTI,
    const OPTIONAL< TrafficFlowTemplateTLV >& par_tft,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< MobileL3__CommonIE__Types::DevicePropertiesTV >& par_deviceProperties,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_requestedNSAPI(par_requestedNSAPI),
  field_requestedLLC__SAPI(par_requestedLLC__SAPI),
  field_requestedQoS(par_requestedQoS),
  field_linkedTI(par_linkedTI),
  field_tft(par_tft),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_deviceProperties(par_deviceProperties),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivateSecondaryPDPContextRequest::PDU__SM__ActivateSecondaryPDPContextRequest(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.requestedNSAPI().is_bound()) field_requestedNSAPI = other_value.requestedNSAPI();
else field_requestedNSAPI.clean_up();
if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
else field_requestedLLC__SAPI.clean_up();
if (other_value.requestedQoS().is_bound()) field_requestedQoS = other_value.requestedQoS();
else field_requestedQoS.clean_up();
if (other_value.linkedTI().is_bound()) field_linkedTI = other_value.linkedTI();
else field_linkedTI.clean_up();
if (other_value.tft().is_bound()) field_tft = other_value.tft();
else field_tft.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
else field_deviceProperties.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivateSecondaryPDPContextRequest::clean_up()
{
field_messageType.clean_up();
field_requestedNSAPI.clean_up();
field_requestedLLC__SAPI.clean_up();
field_requestedQoS.clean_up();
field_linkedTI.clean_up();
field_tft.clean_up();
field_protocolConfigOpts.clean_up();
field_deviceProperties.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivateSecondaryPDPContextRequest::get_descriptor() const { return &PDU__SM__ActivateSecondaryPDPContextRequest_descr_; }
PDU__SM__ActivateSecondaryPDPContextRequest& PDU__SM__ActivateSecondaryPDPContextRequest::operator=(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.requestedNSAPI().is_bound()) field_requestedNSAPI = other_value.requestedNSAPI();
  else field_requestedNSAPI.clean_up();
  if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
  else field_requestedLLC__SAPI.clean_up();
  if (other_value.requestedQoS().is_bound()) field_requestedQoS = other_value.requestedQoS();
  else field_requestedQoS.clean_up();
  if (other_value.linkedTI().is_bound()) field_linkedTI = other_value.linkedTI();
  else field_linkedTI.clean_up();
  if (other_value.tft().is_bound()) field_tft = other_value.tft();
  else field_tft.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
  else field_deviceProperties.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest::operator==(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_requestedNSAPI==other_value.field_requestedNSAPI
  && field_requestedLLC__SAPI==other_value.field_requestedLLC__SAPI
  && field_requestedQoS==other_value.field_requestedQoS
  && field_linkedTI==other_value.field_linkedTI
  && field_tft==other_value.field_tft
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_deviceProperties==other_value.field_deviceProperties
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (field_requestedNSAPI.is_bound())
  || (field_requestedLLC__SAPI.is_bound())
  || (field_requestedQoS.is_bound())
  || (field_linkedTI.is_bound())
  || (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivateSecondaryPDPContextRequest::is_value() const
{
return field_messageType.is_value()
  && field_requestedNSAPI.is_value()
  && field_requestedLLC__SAPI.is_value()
  && field_requestedQoS.is_value()
  && field_linkedTI.is_value()
  && (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivateSecondaryPDPContextRequest::size_of() const
{
  int ret_val = 5;
  if (field_tft.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_deviceProperties.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", requestedNSAPI := ");
field_requestedNSAPI.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", requestedQoS := ");
field_requestedQoS.log();
TTCN_Logger::log_event_str(", linkedTI := ");
field_linkedTI.log();
TTCN_Logger::log_event_str(", tft := ");
field_tft.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivateSecondaryPDPContextRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (requestedNSAPI().is_bound()) requestedNSAPI().set_implicit_omit();
if (requestedLLC__SAPI().is_bound()) requestedLLC__SAPI().set_implicit_omit();
if (requestedQoS().is_bound()) requestedQoS().set_implicit_omit();
if (linkedTI().is_bound()) linkedTI().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedNSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedQoS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) linkedTI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
  }
}

void PDU__SM__ActivateSecondaryPDPContextRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_requestedNSAPI.encode_text(text_buf);
field_requestedLLC__SAPI.encode_text(text_buf);
field_requestedQoS.encode_text(text_buf);
field_linkedTI.encode_text(text_buf);
field_tft.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_deviceProperties.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_requestedNSAPI.decode_text(text_buf);
field_requestedLLC__SAPI.decode_text(text_buf);
field_requestedQoS.decode_text(text_buf);
field_linkedTI.decode_text(text_buf);
field_tft.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_deviceProperties.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivateSecondaryPDPContextRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivateSecondaryPDPContextRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NSAPIV_descr_.raw->forceomit);
  decoded_field_length = field_requestedNSAPI.RAW_decode(NSAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_requestedLLC__SAPI.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_requestedQoS.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, LinkedTILV_descr_.raw->forceomit);
  decoded_field_length = field_linkedTI.RAW_decode(LinkedTILV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_tft = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, TrafficFlowTemplateTLV_descr_.raw->forceomit);
  decoded_field_length = field_tft().RAW_decode(TrafficFlowTemplateTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_tft = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tft=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_deviceProperties = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw->forceomit);
  decoded_field_length = field_deviceProperties().RAW_decode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_deviceProperties = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21){
  field_deviceProperties=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_deviceProperties=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_54) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivateSecondaryPDPContextRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NSAPIV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, LLC__SAPIV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, QoSLV_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, LinkedTILV_descr_.raw);
  if (field_tft.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, TrafficFlowTemplateTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_deviceProperties.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_requestedNSAPI.RAW_encode(NSAPIV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_requestedLLC__SAPI.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_requestedQoS.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_linkedTI.RAW_encode(LinkedTILV_descr_, *myleaf.body.node.nodes[4]);
  if (field_tft.ispresent()) {
  encoded_length += field_tft().RAW_encode(TrafficFlowTemplateTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_deviceProperties.ispresent()) {
  encoded_length += field_deviceProperties().RAW_encode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_deviceProperties.ispresent() && (!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_21.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_54) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_54.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivateSecondaryPDPContextRequest_template::single_value_struct {
BITSTRING_template field_messageType;
NSAPIV_template field_requestedNSAPI;
LLC__SAPIV_template field_requestedLLC__SAPI;
QoSLV_template field_requestedQoS;
LinkedTILV_template field_linkedTI;
TrafficFlowTemplateTLV_template field_tft;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
MobileL3__CommonIE__Types::DevicePropertiesTV_template field_deviceProperties;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivateSecondaryPDPContextRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_requestedNSAPI = ANY_VALUE;
single_value->field_requestedLLC__SAPI = ANY_VALUE;
single_value->field_requestedQoS = ANY_VALUE;
single_value->field_linkedTI = ANY_VALUE;
single_value->field_tft = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_deviceProperties = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::copy_value(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.requestedNSAPI().is_bound()) {
  single_value->field_requestedNSAPI = other_value.requestedNSAPI();
} else {
  single_value->field_requestedNSAPI.clean_up();
}
if (other_value.requestedLLC__SAPI().is_bound()) {
  single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
} else {
  single_value->field_requestedLLC__SAPI.clean_up();
}
if (other_value.requestedQoS().is_bound()) {
  single_value->field_requestedQoS = other_value.requestedQoS();
} else {
  single_value->field_requestedQoS.clean_up();
}
if (other_value.linkedTI().is_bound()) {
  single_value->field_linkedTI = other_value.linkedTI();
} else {
  single_value->field_linkedTI.clean_up();
}
if (other_value.tft().is_bound()) {
  if (other_value.tft().ispresent()) single_value->field_tft = other_value.tft()();
  else single_value->field_tft = OMIT_VALUE;
} else {
  single_value->field_tft.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.deviceProperties().is_bound()) {
  if (other_value.deviceProperties().ispresent()) single_value->field_deviceProperties = other_value.deviceProperties()();
  else single_value->field_deviceProperties = OMIT_VALUE;
} else {
  single_value->field_deviceProperties.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::copy_template(const PDU__SM__ActivateSecondaryPDPContextRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedNSAPI().get_selection()) {
single_value->field_requestedNSAPI = other_value.requestedNSAPI();
} else {
single_value->field_requestedNSAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedLLC__SAPI().get_selection()) {
single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
} else {
single_value->field_requestedLLC__SAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedQoS().get_selection()) {
single_value->field_requestedQoS = other_value.requestedQoS();
} else {
single_value->field_requestedQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.linkedTI().get_selection()) {
single_value->field_linkedTI = other_value.linkedTI();
} else {
single_value->field_linkedTI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tft().get_selection()) {
single_value->field_tft = other_value.tft();
} else {
single_value->field_tft.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deviceProperties().get_selection()) {
single_value->field_deviceProperties = other_value.deviceProperties();
} else {
single_value->field_deviceProperties.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivateSecondaryPDPContextRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivateSecondaryPDPContextRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template()
{
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest from an unbound optional field.");
}
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(PDU__SM__ActivateSecondaryPDPContextRequest_template* p_precondition, PDU__SM__ActivateSecondaryPDPContextRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(Dynamic_Match_Interface<PDU__SM__ActivateSecondaryPDPContextRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivateSecondaryPDPContextRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::PDU__SM__ActivateSecondaryPDPContextRequest_template(const PDU__SM__ActivateSecondaryPDPContextRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivateSecondaryPDPContextRequest_template::~PDU__SM__ActivateSecondaryPDPContextRequest_template()
{
clean_up();
}

PDU__SM__ActivateSecondaryPDPContextRequest_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextRequest_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::operator=(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextRequest_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::operator=(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
}
return *this;
}

PDU__SM__ActivateSecondaryPDPContextRequest_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::operator=(const PDU__SM__ActivateSecondaryPDPContextRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest_template::match(const PDU__SM__ActivateSecondaryPDPContextRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.requestedNSAPI().is_bound()) return FALSE;
if(!single_value->field_requestedNSAPI.match(other_value.requestedNSAPI(), legacy))return FALSE;
if(!other_value.requestedLLC__SAPI().is_bound()) return FALSE;
if(!single_value->field_requestedLLC__SAPI.match(other_value.requestedLLC__SAPI(), legacy))return FALSE;
if(!other_value.requestedQoS().is_bound()) return FALSE;
if(!single_value->field_requestedQoS.match(other_value.requestedQoS(), legacy))return FALSE;
if(!other_value.linkedTI().is_bound()) return FALSE;
if(!single_value->field_linkedTI.match(other_value.linkedTI(), legacy))return FALSE;
if(!other_value.tft().is_bound()) return FALSE;
if((other_value.tft().ispresent() ? !single_value->field_tft.match((const TrafficFlowTemplateTLV&)other_value.tft(), legacy) : !single_value->field_tft.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.deviceProperties().is_bound()) return FALSE;
if((other_value.deviceProperties().ispresent() ? !single_value->field_deviceProperties.match((const MobileL3__CommonIE__Types::DevicePropertiesTV&)other_value.deviceProperties(), legacy) : !single_value->field_deviceProperties.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
}
return FALSE;
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_requestedNSAPI.is_bound()
 || single_value->field_requestedLLC__SAPI.is_bound()
 || single_value->field_requestedQoS.is_bound()
 || single_value->field_linkedTI.is_bound()
 || (single_value->field_tft.is_omit() || single_value->field_tft.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_requestedNSAPI.is_value()
 && single_value->field_requestedLLC__SAPI.is_value()
 && single_value->field_requestedQoS.is_value()
 && single_value->field_linkedTI.is_value()
 && (single_value->field_tft.is_omit() || single_value->field_tft.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivateSecondaryPDPContextRequest PDU__SM__ActivateSecondaryPDPContextRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
PDU__SM__ActivateSecondaryPDPContextRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_requestedNSAPI.is_bound()) {
ret_val.requestedNSAPI() = single_value->field_requestedNSAPI.valueof();
}
if (single_value->field_requestedLLC__SAPI.is_bound()) {
ret_val.requestedLLC__SAPI() = single_value->field_requestedLLC__SAPI.valueof();
}
if (single_value->field_requestedQoS.is_bound()) {
ret_val.requestedQoS() = single_value->field_requestedQoS.valueof();
}
if (single_value->field_linkedTI.is_bound()) {
ret_val.linkedTI() = single_value->field_linkedTI.valueof();
}
if (single_value->field_tft.is_omit()) ret_val.tft() = OMIT_VALUE;
else if (single_value->field_tft.is_bound()) {
ret_val.tft() = single_value->field_tft.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_deviceProperties.is_omit()) ret_val.deviceProperties() = OMIT_VALUE;
else if (single_value->field_deviceProperties.is_bound()) {
ret_val.deviceProperties() = single_value->field_deviceProperties.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextRequest_template[list_length];
}

PDU__SM__ActivateSecondaryPDPContextRequest_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_messageType;
}

NSAPIV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedNSAPI()
{
set_specific();
return single_value->field_requestedNSAPI;
}

const NSAPIV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedNSAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedNSAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_requestedNSAPI;
}

LLC__SAPIV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedLLC__SAPI()
{
set_specific();
return single_value->field_requestedLLC__SAPI;
}

const LLC__SAPIV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedLLC__SAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedLLC_SAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_requestedLLC__SAPI;
}

QoSLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedQoS()
{
set_specific();
return single_value->field_requestedQoS;
}

const QoSLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::requestedQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_requestedQoS;
}

LinkedTILV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::linkedTI()
{
set_specific();
return single_value->field_linkedTI;
}

const LinkedTILV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::linkedTI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field linkedTI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_linkedTI;
}

TrafficFlowTemplateTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::tft()
{
set_specific();
return single_value->field_tft;
}

const TrafficFlowTemplateTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::tft() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tft of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_tft;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_protocolConfigOpts;
}

MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::deviceProperties()
{
set_specific();
return single_value->field_deviceProperties;
}

const MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::deviceProperties() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deviceProperties of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_deviceProperties;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextRequest_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivateSecondaryPDPContextRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_tft.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_deviceProperties.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
  }
  return 0;
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", requestedNSAPI := ");
single_value->field_requestedNSAPI.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
single_value->field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", requestedQoS := ");
single_value->field_requestedQoS.log();
TTCN_Logger::log_event_str(", linkedTI := ");
single_value->field_linkedTI.log();
TTCN_Logger::log_event_str(", tft := ");
single_value->field_tft.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::log_match(const PDU__SM__ActivateSecondaryPDPContextRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedNSAPI.match(match_value.requestedNSAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedNSAPI");
single_value->field_requestedNSAPI.log_match(match_value.requestedNSAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedLLC__SAPI.match(match_value.requestedLLC__SAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedLLC_SAPI");
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedQoS.match(match_value.requestedQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedQoS");
single_value->field_requestedQoS.log_match(match_value.requestedQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_linkedTI.match(match_value.linkedTI(), legacy)){
TTCN_Logger::log_logmatch_info(".linkedTI");
single_value->field_linkedTI.log_match(match_value.linkedTI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tft().ispresent()){
if(!single_value->field_tft.match(match_value.tft(), legacy)){
TTCN_Logger::log_logmatch_info(".tft");
single_value->field_tft.log_match(match_value.tft(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tft.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tft := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tft.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.deviceProperties().ispresent()){
if(!single_value->field_deviceProperties.match(match_value.deviceProperties(), legacy)){
TTCN_Logger::log_logmatch_info(".deviceProperties");
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deviceProperties.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deviceProperties := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", requestedNSAPI := ");
single_value->field_requestedNSAPI.log_match(match_value.requestedNSAPI(), legacy);
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
TTCN_Logger::log_event_str(", requestedQoS := ");
single_value->field_requestedQoS.log_match(match_value.requestedQoS(), legacy);
TTCN_Logger::log_event_str(", linkedTI := ");
single_value->field_linkedTI.log_match(match_value.linkedTI(), legacy);
TTCN_Logger::log_event_str(", tft := ");
if (match_value.tft().ispresent()) {
single_value->field_tft.log_match(match_value.tft(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tft.log();
if (single_value->field_tft.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", deviceProperties := ");
if (match_value.deviceProperties().ispresent()) {
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deviceProperties.log();
if (single_value->field_deviceProperties.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (requestedNSAPI().is_bound()) requestedNSAPI().set_implicit_omit();
if (requestedLLC__SAPI().is_bound()) requestedLLC__SAPI().set_implicit_omit();
if (requestedQoS().is_bound()) requestedQoS().set_implicit_omit();
if (linkedTI().is_bound()) linkedTI().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_requestedNSAPI.encode_text(text_buf);
single_value->field_requestedLLC__SAPI.encode_text(text_buf);
single_value->field_requestedQoS.encode_text(text_buf);
single_value->field_linkedTI.encode_text(text_buf);
single_value->field_tft.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_deviceProperties.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
}
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_requestedNSAPI.decode_text(text_buf);
single_value->field_requestedLLC__SAPI.decode_text(text_buf);
single_value->field_requestedQoS.decode_text(text_buf);
single_value->field_linkedTI.decode_text(text_buf);
single_value->field_tft.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_deviceProperties.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest.");
}
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivateSecondaryPDPContextRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedNSAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedQoS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) linkedTI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNSAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNSAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivateSecondaryPDPContextRequest_template* precondition = new PDU__SM__ActivateSecondaryPDPContextRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivateSecondaryPDPContextRequest_template* implied_template = new PDU__SM__ActivateSecondaryPDPContextRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivateSecondaryPDPContextRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_requestedNSAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_requestedLLC__SAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_requestedQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_linkedTI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_tft.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_deviceProperties.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextRequest");
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivateSecondaryPDPContextRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivateSecondaryPDPContextAccept::PDU__SM__ActivateSecondaryPDPContextAccept()
{
}

PDU__SM__ActivateSecondaryPDPContextAccept::PDU__SM__ActivateSecondaryPDPContextAccept(const BITSTRING& par_messageType,
    const LLC__SAPIV& par_negotiatedLLC__SAPI,
    const QoSLV& par_negotiatedQoS,
    const RadioPriorityV& par_radioPriority,
    const BITSTRING& par_spare,
    const OPTIONAL< PacketFlowIDTLV >& par_packetFlowIdentifier,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< WLANOffloadAcceptabilityTV >& par_wLANOffloadIndication,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_negotiatedLLC__SAPI(par_negotiatedLLC__SAPI),
  field_negotiatedQoS(par_negotiatedQoS),
  field_radioPriority(par_radioPriority),
  field_spare(par_spare),
  field_packetFlowIdentifier(par_packetFlowIdentifier),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_wLANOffloadIndication(par_wLANOffloadIndication),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivateSecondaryPDPContextAccept::PDU__SM__ActivateSecondaryPDPContextAccept(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.negotiatedLLC__SAPI().is_bound()) field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
else field_negotiatedLLC__SAPI.clean_up();
if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
else field_negotiatedQoS.clean_up();
if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
else field_radioPriority.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
else field_packetFlowIdentifier.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
else field_wLANOffloadIndication.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivateSecondaryPDPContextAccept::clean_up()
{
field_messageType.clean_up();
field_negotiatedLLC__SAPI.clean_up();
field_negotiatedQoS.clean_up();
field_radioPriority.clean_up();
field_spare.clean_up();
field_packetFlowIdentifier.clean_up();
field_protocolConfigOpts.clean_up();
field_wLANOffloadIndication.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivateSecondaryPDPContextAccept::get_descriptor() const { return &PDU__SM__ActivateSecondaryPDPContextAccept_descr_; }
PDU__SM__ActivateSecondaryPDPContextAccept& PDU__SM__ActivateSecondaryPDPContextAccept::operator=(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.negotiatedLLC__SAPI().is_bound()) field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
  else field_negotiatedLLC__SAPI.clean_up();
  if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
  else field_negotiatedQoS.clean_up();
  if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
  else field_radioPriority.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
  else field_packetFlowIdentifier.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
  else field_wLANOffloadIndication.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept::operator==(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_negotiatedLLC__SAPI==other_value.field_negotiatedLLC__SAPI
  && field_negotiatedQoS==other_value.field_negotiatedQoS
  && field_radioPriority==other_value.field_radioPriority
  && field_spare==other_value.field_spare
  && field_packetFlowIdentifier==other_value.field_packetFlowIdentifier
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_wLANOffloadIndication==other_value.field_wLANOffloadIndication
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept::is_bound() const
{
return (field_messageType.is_bound())
  || (field_negotiatedLLC__SAPI.is_bound())
  || (field_negotiatedQoS.is_bound())
  || (field_radioPriority.is_bound())
  || (field_spare.is_bound())
  || (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivateSecondaryPDPContextAccept::is_value() const
{
return field_messageType.is_value()
  && field_negotiatedLLC__SAPI.is_value()
  && field_negotiatedQoS.is_value()
  && field_radioPriority.is_value()
  && field_spare.is_value()
  && (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivateSecondaryPDPContextAccept::size_of() const
{
  int ret_val = 5;
  if (field_packetFlowIdentifier.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_wLANOffloadIndication.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextAccept::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", negotiatedLLC_SAPI := ");
field_negotiatedLLC__SAPI.log();
TTCN_Logger::log_event_str(", negotiatedQoS := ");
field_negotiatedQoS.log();
TTCN_Logger::log_event_str(", radioPriority := ");
field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivateSecondaryPDPContextAccept::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (negotiatedLLC__SAPI().is_bound()) negotiatedLLC__SAPI().set_implicit_omit();
if (negotiatedQoS().is_bound()) negotiatedQoS().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!packetFlowIdentifier().is_bound()) packetFlowIdentifier() = OMIT_VALUE;
else packetFlowIdentifier().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextAccept::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) negotiatedLLC__SAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) negotiatedQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) packetFlowIdentifier().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
  }
}

void PDU__SM__ActivateSecondaryPDPContextAccept::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_negotiatedLLC__SAPI.encode_text(text_buf);
field_negotiatedQoS.encode_text(text_buf);
field_radioPriority.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_packetFlowIdentifier.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_wLANOffloadIndication.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextAccept::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_negotiatedLLC__SAPI.decode_text(text_buf);
field_negotiatedQoS.decode_text(text_buf);
field_radioPriority.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_packetFlowIdentifier.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_wLANOffloadIndication.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextAccept::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivateSecondaryPDPContextAccept::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivateSecondaryPDPContextAccept::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedLLC__SAPI.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedQoS.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RadioPriorityV_descr_.raw->forceomit);
  decoded_field_length = field_radioPriority.RAW_decode(RadioPriorityV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_packetFlowIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, PacketFlowIDTLV_descr_.raw->forceomit);
  decoded_field_length = field_packetFlowIdentifier().RAW_decode(PacketFlowIDTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_packetFlowIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_packetFlowIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_wLANOffloadIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, WLANOffloadAcceptabilityTV_descr_.raw->forceomit);
  decoded_field_length = field_wLANOffloadIndication().RAW_decode(WLANOffloadAcceptabilityTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_wLANOffloadIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_wLANOffloadIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_55) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivateSecondaryPDPContextAccept::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LLC__SAPIV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, QoSLV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RadioPriorityV_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT4_descr_.raw);
  if (field_packetFlowIdentifier.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PacketFlowIDTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_wLANOffloadIndication.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, WLANOffloadAcceptabilityTV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_negotiatedLLC__SAPI.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_negotiatedQoS.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_radioPriority.RAW_encode(RadioPriorityV_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[4]);
  if (field_packetFlowIdentifier.ispresent()) {
  encoded_length += field_packetFlowIdentifier().RAW_encode(PacketFlowIDTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_wLANOffloadIndication.ispresent()) {
  encoded_length += field_wLANOffloadIndication().RAW_encode(WLANOffloadAcceptabilityTV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_messageType !=  bs_55) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_55.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivateSecondaryPDPContextAccept_template::single_value_struct {
BITSTRING_template field_messageType;
LLC__SAPIV_template field_negotiatedLLC__SAPI;
QoSLV_template field_negotiatedQoS;
RadioPriorityV_template field_radioPriority;
BITSTRING_template field_spare;
PacketFlowIDTLV_template field_packetFlowIdentifier;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
WLANOffloadAcceptabilityTV_template field_wLANOffloadIndication;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivateSecondaryPDPContextAccept_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_negotiatedLLC__SAPI = ANY_VALUE;
single_value->field_negotiatedQoS = ANY_VALUE;
single_value->field_radioPriority = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_packetFlowIdentifier = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_wLANOffloadIndication = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::copy_value(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.negotiatedLLC__SAPI().is_bound()) {
  single_value->field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
} else {
  single_value->field_negotiatedLLC__SAPI.clean_up();
}
if (other_value.negotiatedQoS().is_bound()) {
  single_value->field_negotiatedQoS = other_value.negotiatedQoS();
} else {
  single_value->field_negotiatedQoS.clean_up();
}
if (other_value.radioPriority().is_bound()) {
  single_value->field_radioPriority = other_value.radioPriority();
} else {
  single_value->field_radioPriority.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.packetFlowIdentifier().is_bound()) {
  if (other_value.packetFlowIdentifier().ispresent()) single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier()();
  else single_value->field_packetFlowIdentifier = OMIT_VALUE;
} else {
  single_value->field_packetFlowIdentifier.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.wLANOffloadIndication().is_bound()) {
  if (other_value.wLANOffloadIndication().ispresent()) single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication()();
  else single_value->field_wLANOffloadIndication = OMIT_VALUE;
} else {
  single_value->field_wLANOffloadIndication.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::copy_template(const PDU__SM__ActivateSecondaryPDPContextAccept_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedLLC__SAPI().get_selection()) {
single_value->field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
} else {
single_value->field_negotiatedLLC__SAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedQoS().get_selection()) {
single_value->field_negotiatedQoS = other_value.negotiatedQoS();
} else {
single_value->field_negotiatedQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.radioPriority().get_selection()) {
single_value->field_radioPriority = other_value.radioPriority();
} else {
single_value->field_radioPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFlowIdentifier().get_selection()) {
single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier();
} else {
single_value->field_packetFlowIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.wLANOffloadIndication().get_selection()) {
single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication();
} else {
single_value->field_wLANOffloadIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivateSecondaryPDPContextAccept_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivateSecondaryPDPContextAccept_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template()
{
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextAccept>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept from an unbound optional field.");
}
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(PDU__SM__ActivateSecondaryPDPContextAccept_template* p_precondition, PDU__SM__ActivateSecondaryPDPContextAccept_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(Dynamic_Match_Interface<PDU__SM__ActivateSecondaryPDPContextAccept>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivateSecondaryPDPContextAccept>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::PDU__SM__ActivateSecondaryPDPContextAccept_template(const PDU__SM__ActivateSecondaryPDPContextAccept_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivateSecondaryPDPContextAccept_template::~PDU__SM__ActivateSecondaryPDPContextAccept_template()
{
clean_up();
}

PDU__SM__ActivateSecondaryPDPContextAccept_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextAccept_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::operator=(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextAccept_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::operator=(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextAccept>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextAccept&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
}
return *this;
}

PDU__SM__ActivateSecondaryPDPContextAccept_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::operator=(const PDU__SM__ActivateSecondaryPDPContextAccept_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept_template::match(const PDU__SM__ActivateSecondaryPDPContextAccept& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.negotiatedLLC__SAPI().is_bound()) return FALSE;
if(!single_value->field_negotiatedLLC__SAPI.match(other_value.negotiatedLLC__SAPI(), legacy))return FALSE;
if(!other_value.negotiatedQoS().is_bound()) return FALSE;
if(!single_value->field_negotiatedQoS.match(other_value.negotiatedQoS(), legacy))return FALSE;
if(!other_value.radioPriority().is_bound()) return FALSE;
if(!single_value->field_radioPriority.match(other_value.radioPriority(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.packetFlowIdentifier().is_bound()) return FALSE;
if((other_value.packetFlowIdentifier().ispresent() ? !single_value->field_packetFlowIdentifier.match((const PacketFlowIDTLV&)other_value.packetFlowIdentifier(), legacy) : !single_value->field_packetFlowIdentifier.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.wLANOffloadIndication().is_bound()) return FALSE;
if((other_value.wLANOffloadIndication().ispresent() ? !single_value->field_wLANOffloadIndication.match((const WLANOffloadAcceptabilityTV&)other_value.wLANOffloadIndication(), legacy) : !single_value->field_wLANOffloadIndication.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
}
return FALSE;
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_negotiatedLLC__SAPI.is_bound()
 || single_value->field_negotiatedQoS.is_bound()
 || single_value->field_radioPriority.is_bound()
 || single_value->field_spare.is_bound()
 || (single_value->field_packetFlowIdentifier.is_omit() || single_value->field_packetFlowIdentifier.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_negotiatedLLC__SAPI.is_value()
 && single_value->field_negotiatedQoS.is_value()
 && single_value->field_radioPriority.is_value()
 && single_value->field_spare.is_value()
 && (single_value->field_packetFlowIdentifier.is_omit() || single_value->field_packetFlowIdentifier.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivateSecondaryPDPContextAccept PDU__SM__ActivateSecondaryPDPContextAccept_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
PDU__SM__ActivateSecondaryPDPContextAccept ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_negotiatedLLC__SAPI.is_bound()) {
ret_val.negotiatedLLC__SAPI() = single_value->field_negotiatedLLC__SAPI.valueof();
}
if (single_value->field_negotiatedQoS.is_bound()) {
ret_val.negotiatedQoS() = single_value->field_negotiatedQoS.valueof();
}
if (single_value->field_radioPriority.is_bound()) {
ret_val.radioPriority() = single_value->field_radioPriority.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_packetFlowIdentifier.is_omit()) ret_val.packetFlowIdentifier() = OMIT_VALUE;
else if (single_value->field_packetFlowIdentifier.is_bound()) {
ret_val.packetFlowIdentifier() = single_value->field_packetFlowIdentifier.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_wLANOffloadIndication.is_omit()) ret_val.wLANOffloadIndication() = OMIT_VALUE;
else if (single_value->field_wLANOffloadIndication.is_bound()) {
ret_val.wLANOffloadIndication() = single_value->field_wLANOffloadIndication.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextAccept_template[list_length];
}

PDU__SM__ActivateSecondaryPDPContextAccept_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_messageType;
}

LLC__SAPIV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::negotiatedLLC__SAPI()
{
set_specific();
return single_value->field_negotiatedLLC__SAPI;
}

const LLC__SAPIV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::negotiatedLLC__SAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field negotiatedLLC_SAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_negotiatedLLC__SAPI;
}

QoSLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::negotiatedQoS()
{
set_specific();
return single_value->field_negotiatedQoS;
}

const QoSLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::negotiatedQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field negotiatedQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_negotiatedQoS;
}

RadioPriorityV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::radioPriority()
{
set_specific();
return single_value->field_radioPriority;
}

const RadioPriorityV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::radioPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field radioPriority of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_radioPriority;
}

BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_spare;
}

PacketFlowIDTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::packetFlowIdentifier()
{
set_specific();
return single_value->field_packetFlowIdentifier;
}

const PacketFlowIDTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::packetFlowIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFlowIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_packetFlowIdentifier;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_protocolConfigOpts;
}

WLANOffloadAcceptabilityTV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::wLANOffloadIndication()
{
set_specific();
return single_value->field_wLANOffloadIndication;
}

const WLANOffloadAcceptabilityTV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::wLANOffloadIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field wLANOffloadIndication of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_wLANOffloadIndication;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextAccept_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivateSecondaryPDPContextAccept_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_packetFlowIdentifier.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_wLANOffloadIndication.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
  }
  return 0;
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", negotiatedLLC_SAPI := ");
single_value->field_negotiatedLLC__SAPI.log();
TTCN_Logger::log_event_str(", negotiatedQoS := ");
single_value->field_negotiatedQoS.log();
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
single_value->field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::log_match(const PDU__SM__ActivateSecondaryPDPContextAccept& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_negotiatedLLC__SAPI.match(match_value.negotiatedLLC__SAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".negotiatedLLC_SAPI");
single_value->field_negotiatedLLC__SAPI.log_match(match_value.negotiatedLLC__SAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_negotiatedQoS.match(match_value.negotiatedQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".negotiatedQoS");
single_value->field_negotiatedQoS.log_match(match_value.negotiatedQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_radioPriority.match(match_value.radioPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".radioPriority");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.packetFlowIdentifier().ispresent()){
if(!single_value->field_packetFlowIdentifier.match(match_value.packetFlowIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFlowIdentifier");
single_value->field_packetFlowIdentifier.log_match(match_value.packetFlowIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_packetFlowIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".packetFlowIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.wLANOffloadIndication().ispresent()){
if(!single_value->field_wLANOffloadIndication.match(match_value.wLANOffloadIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".wLANOffloadIndication");
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_wLANOffloadIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".wLANOffloadIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", negotiatedLLC_SAPI := ");
single_value->field_negotiatedLLC__SAPI.log_match(match_value.negotiatedLLC__SAPI(), legacy);
TTCN_Logger::log_event_str(", negotiatedQoS := ");
single_value->field_negotiatedQoS.log_match(match_value.negotiatedQoS(), legacy);
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
if (match_value.packetFlowIdentifier().ispresent()) {
single_value->field_packetFlowIdentifier.log_match(match_value.packetFlowIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_packetFlowIdentifier.log();
if (single_value->field_packetFlowIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
if (match_value.wLANOffloadIndication().ispresent()) {
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_wLANOffloadIndication.log();
if (single_value->field_wLANOffloadIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (negotiatedLLC__SAPI().is_bound()) negotiatedLLC__SAPI().set_implicit_omit();
if (negotiatedQoS().is_bound()) negotiatedQoS().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!packetFlowIdentifier().is_bound()) packetFlowIdentifier() = OMIT_VALUE;
else packetFlowIdentifier().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_negotiatedLLC__SAPI.encode_text(text_buf);
single_value->field_negotiatedQoS.encode_text(text_buf);
single_value->field_radioPriority.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_packetFlowIdentifier.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_wLANOffloadIndication.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
}
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_negotiatedLLC__SAPI.decode_text(text_buf);
single_value->field_negotiatedQoS.decode_text(text_buf);
single_value->field_radioPriority.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_packetFlowIdentifier.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_wLANOffloadIndication.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextAccept_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept.");
}
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivateSecondaryPDPContextAccept_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) negotiatedLLC__SAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) negotiatedQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) packetFlowIdentifier().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivateSecondaryPDPContextAccept_template* precondition = new PDU__SM__ActivateSecondaryPDPContextAccept_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivateSecondaryPDPContextAccept_template* implied_template = new PDU__SM__ActivateSecondaryPDPContextAccept_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivateSecondaryPDPContextAccept_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextAccept_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_negotiatedLLC__SAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_negotiatedQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_radioPriority.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_packetFlowIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_wLANOffloadIndication.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextAccept");
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivateSecondaryPDPContextAccept_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ActivateSecondaryPDPContextReject::PDU__SM__ActivateSecondaryPDPContextReject()
{
}

PDU__SM__ActivateSecondaryPDPContextReject::PDU__SM__ActivateSecondaryPDPContextReject(const BITSTRING& par_messageType,
    const OCTETSTRING& par_smCause,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< MobileL3__CommonIE__Types::GPRSTimer3TLV >& par_backOffTimer,
    const OPTIONAL< ReAttemptIndicatorTLV >& par_reAttemptIndicator,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_smCause(par_smCause),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_backOffTimer(par_backOffTimer),
  field_reAttemptIndicator(par_reAttemptIndicator),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ActivateSecondaryPDPContextReject::PDU__SM__ActivateSecondaryPDPContextReject(const PDU__SM__ActivateSecondaryPDPContextReject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
else field_smCause.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.backOffTimer().is_bound()) field_backOffTimer = other_value.backOffTimer();
else field_backOffTimer.clean_up();
if (other_value.reAttemptIndicator().is_bound()) field_reAttemptIndicator = other_value.reAttemptIndicator();
else field_reAttemptIndicator.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ActivateSecondaryPDPContextReject::clean_up()
{
field_messageType.clean_up();
field_smCause.clean_up();
field_protocolConfigOpts.clean_up();
field_backOffTimer.clean_up();
field_reAttemptIndicator.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ActivateSecondaryPDPContextReject::get_descriptor() const { return &PDU__SM__ActivateSecondaryPDPContextReject_descr_; }
PDU__SM__ActivateSecondaryPDPContextReject& PDU__SM__ActivateSecondaryPDPContextReject::operator=(const PDU__SM__ActivateSecondaryPDPContextReject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
  else field_smCause.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.backOffTimer().is_bound()) field_backOffTimer = other_value.backOffTimer();
  else field_backOffTimer.clean_up();
  if (other_value.reAttemptIndicator().is_bound()) field_reAttemptIndicator = other_value.reAttemptIndicator();
  else field_reAttemptIndicator.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextReject::operator==(const PDU__SM__ActivateSecondaryPDPContextReject& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_smCause==other_value.field_smCause
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_backOffTimer==other_value.field_backOffTimer
  && field_reAttemptIndicator==other_value.field_reAttemptIndicator
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ActivateSecondaryPDPContextReject::is_bound() const
{
return (field_messageType.is_bound())
  || (field_smCause.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_backOffTimer.get_selection() || field_backOffTimer.is_bound())
  || (OPTIONAL_OMIT == field_reAttemptIndicator.get_selection() || field_reAttemptIndicator.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ActivateSecondaryPDPContextReject::is_value() const
{
return field_messageType.is_value()
  && field_smCause.is_value()
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_backOffTimer.get_selection() || field_backOffTimer.is_value())
  && (OPTIONAL_OMIT == field_reAttemptIndicator.get_selection() || field_reAttemptIndicator.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ActivateSecondaryPDPContextReject::size_of() const
{
  int ret_val = 2;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_backOffTimer.ispresent()) ret_val++;
  if (field_reAttemptIndicator.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextReject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", backOffTimer := ");
field_backOffTimer.log();
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ActivateSecondaryPDPContextReject::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!backOffTimer().is_bound()) backOffTimer() = OMIT_VALUE;
else backOffTimer().set_implicit_omit();
if (!reAttemptIndicator().is_bound()) reAttemptIndicator() = OMIT_VALUE;
else reAttemptIndicator().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextReject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) backOffTimer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "backOffTimer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          backOffTimer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
  }
}

void PDU__SM__ActivateSecondaryPDPContextReject::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_smCause.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_backOffTimer.encode_text(text_buf);
field_reAttemptIndicator.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextReject::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_smCause.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_backOffTimer.decode_text(text_buf);
field_reAttemptIndicator.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ActivateSecondaryPDPContextReject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ActivateSecondaryPDPContextReject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ActivateSecondaryPDPContextReject::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SMCauseV_descr_.raw->forceomit);
  decoded_field_length = field_smCause.RAW_decode(SMCauseV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_backOffTimer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_.raw->forceomit);
  decoded_field_length = field_backOffTimer().RAW_decode(MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_backOffTimer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_backOffTimer.ispresent() || field_backOffTimer().elementIdentifier() !=  os_33){
  field_backOffTimer=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_backOffTimer=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_reAttemptIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, ReAttemptIndicatorTLV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicator().RAW_decode(ReAttemptIndicatorTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_reAttemptIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_reAttemptIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_56) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ActivateSecondaryPDPContextReject::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SMCauseV_descr_.raw);
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_backOffTimer.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_reAttemptIndicator.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ReAttemptIndicatorTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_smCause.RAW_encode(SMCauseV_descr_, *myleaf.body.node.nodes[1]);
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_backOffTimer.ispresent()) {
  encoded_length += field_backOffTimer().RAW_encode(MobileL3__CommonIE__Types::GPRSTimer3TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_reAttemptIndicator.ispresent()) {
  encoded_length += field_reAttemptIndicator().RAW_encode(ReAttemptIndicatorTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_backOffTimer.ispresent() && (!field_backOffTimer.ispresent() || field_backOffTimer().elementIdentifier() !=  os_33)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_33.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_56) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_56.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ActivateSecondaryPDPContextReject_template::single_value_struct {
BITSTRING_template field_messageType;
OCTETSTRING_template field_smCause;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
MobileL3__CommonIE__Types::GPRSTimer3TLV_template field_backOffTimer;
ReAttemptIndicatorTLV_template field_reAttemptIndicator;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ActivateSecondaryPDPContextReject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_smCause = ANY_VALUE;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_backOffTimer = ANY_OR_OMIT;
single_value->field_reAttemptIndicator = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::copy_value(const PDU__SM__ActivateSecondaryPDPContextReject& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.smCause().is_bound()) {
  single_value->field_smCause = other_value.smCause();
} else {
  single_value->field_smCause.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.backOffTimer().is_bound()) {
  if (other_value.backOffTimer().ispresent()) single_value->field_backOffTimer = other_value.backOffTimer()();
  else single_value->field_backOffTimer = OMIT_VALUE;
} else {
  single_value->field_backOffTimer.clean_up();
}
if (other_value.reAttemptIndicator().is_bound()) {
  if (other_value.reAttemptIndicator().ispresent()) single_value->field_reAttemptIndicator = other_value.reAttemptIndicator()();
  else single_value->field_reAttemptIndicator = OMIT_VALUE;
} else {
  single_value->field_reAttemptIndicator.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::copy_template(const PDU__SM__ActivateSecondaryPDPContextReject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.smCause().get_selection()) {
single_value->field_smCause = other_value.smCause();
} else {
single_value->field_smCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.backOffTimer().get_selection()) {
single_value->field_backOffTimer = other_value.backOffTimer();
} else {
single_value->field_backOffTimer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicator().get_selection()) {
single_value->field_reAttemptIndicator = other_value.reAttemptIndicator();
} else {
single_value->field_reAttemptIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ActivateSecondaryPDPContextReject_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ActivateSecondaryPDPContextReject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
break;
}
set_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template()
{
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(const PDU__SM__ActivateSecondaryPDPContextReject& other_value)
{
copy_value(other_value);
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextReject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject from an unbound optional field.");
}
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(PDU__SM__ActivateSecondaryPDPContextReject_template* p_precondition, PDU__SM__ActivateSecondaryPDPContextReject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(Dynamic_Match_Interface<PDU__SM__ActivateSecondaryPDPContextReject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ActivateSecondaryPDPContextReject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ActivateSecondaryPDPContextReject_template::PDU__SM__ActivateSecondaryPDPContextReject_template(const PDU__SM__ActivateSecondaryPDPContextReject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ActivateSecondaryPDPContextReject_template::~PDU__SM__ActivateSecondaryPDPContextReject_template()
{
clean_up();
}

PDU__SM__ActivateSecondaryPDPContextReject_template& PDU__SM__ActivateSecondaryPDPContextReject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextReject_template& PDU__SM__ActivateSecondaryPDPContextReject_template::operator=(const PDU__SM__ActivateSecondaryPDPContextReject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ActivateSecondaryPDPContextReject_template& PDU__SM__ActivateSecondaryPDPContextReject_template::operator=(const OPTIONAL<PDU__SM__ActivateSecondaryPDPContextReject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ActivateSecondaryPDPContextReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
}
return *this;
}

PDU__SM__ActivateSecondaryPDPContextReject_template& PDU__SM__ActivateSecondaryPDPContextReject_template::operator=(const PDU__SM__ActivateSecondaryPDPContextReject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ActivateSecondaryPDPContextReject_template::match(const PDU__SM__ActivateSecondaryPDPContextReject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.smCause().is_bound()) return FALSE;
if(!single_value->field_smCause.match(other_value.smCause(), legacy))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.backOffTimer().is_bound()) return FALSE;
if((other_value.backOffTimer().ispresent() ? !single_value->field_backOffTimer.match((const MobileL3__CommonIE__Types::GPRSTimer3TLV&)other_value.backOffTimer(), legacy) : !single_value->field_backOffTimer.match_omit(legacy)))return FALSE;
if(!other_value.reAttemptIndicator().is_bound()) return FALSE;
if((other_value.reAttemptIndicator().ispresent() ? !single_value->field_reAttemptIndicator.match((const ReAttemptIndicatorTLV&)other_value.reAttemptIndicator(), legacy) : !single_value->field_reAttemptIndicator.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
}
return FALSE;
}

boolean PDU__SM__ActivateSecondaryPDPContextReject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_smCause.is_bound()
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_backOffTimer.is_omit() || single_value->field_backOffTimer.is_bound())
 || (single_value->field_reAttemptIndicator.is_omit() || single_value->field_reAttemptIndicator.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ActivateSecondaryPDPContextReject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_smCause.is_value()
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_backOffTimer.is_omit() || single_value->field_backOffTimer.is_value())
 && (single_value->field_reAttemptIndicator.is_omit() || single_value->field_reAttemptIndicator.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ActivateSecondaryPDPContextReject PDU__SM__ActivateSecondaryPDPContextReject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
PDU__SM__ActivateSecondaryPDPContextReject ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_smCause.is_bound()) {
ret_val.smCause() = single_value->field_smCause.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_backOffTimer.is_omit()) ret_val.backOffTimer() = OMIT_VALUE;
else if (single_value->field_backOffTimer.is_bound()) {
ret_val.backOffTimer() = single_value->field_backOffTimer.valueof();
}
if (single_value->field_reAttemptIndicator.is_omit()) ret_val.reAttemptIndicator() = OMIT_VALUE;
else if (single_value->field_reAttemptIndicator.is_bound()) {
ret_val.reAttemptIndicator() = single_value->field_reAttemptIndicator.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextReject_template[list_length];
}

PDU__SM__ActivateSecondaryPDPContextReject_template& PDU__SM__ActivateSecondaryPDPContextReject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextReject_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ActivateSecondaryPDPContextReject_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SM__ActivateSecondaryPDPContextReject_template::smCause()
{
set_specific();
return single_value->field_smCause;
}

const OCTETSTRING_template& PDU__SM__ActivateSecondaryPDPContextReject_template::smCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field smCause of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_smCause;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_protocolConfigOpts;
}

MobileL3__CommonIE__Types::GPRSTimer3TLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::backOffTimer()
{
set_specific();
return single_value->field_backOffTimer;
}

const MobileL3__CommonIE__Types::GPRSTimer3TLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::backOffTimer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field backOffTimer of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_backOffTimer;
}

ReAttemptIndicatorTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::reAttemptIndicator()
{
set_specific();
return single_value->field_reAttemptIndicator;
}

const ReAttemptIndicatorTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::reAttemptIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_reAttemptIndicator;
}

NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ActivateSecondaryPDPContextReject_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ActivateSecondaryPDPContextReject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_backOffTimer.is_present()) ret_val++;
      if (single_value->field_reAttemptIndicator.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
  }
  return 0;
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", backOffTimer := ");
single_value->field_backOffTimer.log();
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
single_value->field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::log_match(const PDU__SM__ActivateSecondaryPDPContextReject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_smCause.match(match_value.smCause(), legacy)){
TTCN_Logger::log_logmatch_info(".smCause");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.backOffTimer().ispresent()){
if(!single_value->field_backOffTimer.match(match_value.backOffTimer(), legacy)){
TTCN_Logger::log_logmatch_info(".backOffTimer");
single_value->field_backOffTimer.log_match(match_value.backOffTimer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_backOffTimer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".backOffTimer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_backOffTimer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.reAttemptIndicator().ispresent()){
if(!single_value->field_reAttemptIndicator.match(match_value.reAttemptIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicator");
single_value->field_reAttemptIndicator.log_match(match_value.reAttemptIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_reAttemptIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".reAttemptIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_reAttemptIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", backOffTimer := ");
if (match_value.backOffTimer().ispresent()) {
single_value->field_backOffTimer.log_match(match_value.backOffTimer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_backOffTimer.log();
if (single_value->field_backOffTimer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", reAttemptIndicator := ");
if (match_value.reAttemptIndicator().ispresent()) {
single_value->field_reAttemptIndicator.log_match(match_value.reAttemptIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_reAttemptIndicator.log();
if (single_value->field_reAttemptIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!backOffTimer().is_bound()) backOffTimer() = OMIT_VALUE;
else backOffTimer().set_implicit_omit();
if (!reAttemptIndicator().is_bound()) reAttemptIndicator() = OMIT_VALUE;
else reAttemptIndicator().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_smCause.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_backOffTimer.encode_text(text_buf);
single_value->field_reAttemptIndicator.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
}
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_smCause.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_backOffTimer.decode_text(text_buf);
single_value->field_reAttemptIndicator.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ActivateSecondaryPDPContextReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject.");
}
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ActivateSecondaryPDPContextReject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) backOffTimer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "backOffTimer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          backOffTimer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ActivateSecondaryPDPContextReject_template* precondition = new PDU__SM__ActivateSecondaryPDPContextReject_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ActivateSecondaryPDPContextReject_template* implied_template = new PDU__SM__ActivateSecondaryPDPContextReject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ActivateSecondaryPDPContextReject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ActivateSecondaryPDPContextReject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
single_value->field_smCause.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
single_value->field_backOffTimer.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
single_value->field_reAttemptIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ActivateSecondaryPDPContextReject");
}

boolean PDU__SM__ActivateSecondaryPDPContextReject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ActivateSecondaryPDPContextReject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__RequestPDPContextActivation::PDU__SM__RequestPDPContextActivation()
{
}

PDU__SM__RequestPDPContextActivation::PDU__SM__RequestPDPContextActivation(const BITSTRING& par_messageType,
    const PDPAddressLV& par_offeredPDPAdress,
    const OPTIONAL< AccessPointNameTLV >& par_accessPointName,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_offeredPDPAdress(par_offeredPDPAdress),
  field_accessPointName(par_accessPointName),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__RequestPDPContextActivation::PDU__SM__RequestPDPContextActivation(const PDU__SM__RequestPDPContextActivation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.offeredPDPAdress().is_bound()) field_offeredPDPAdress = other_value.offeredPDPAdress();
else field_offeredPDPAdress.clean_up();
if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
else field_accessPointName.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__RequestPDPContextActivation::clean_up()
{
field_messageType.clean_up();
field_offeredPDPAdress.clean_up();
field_accessPointName.clean_up();
field_protocolConfigOpts.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__RequestPDPContextActivation::get_descriptor() const { return &PDU__SM__RequestPDPContextActivation_descr_; }
PDU__SM__RequestPDPContextActivation& PDU__SM__RequestPDPContextActivation::operator=(const PDU__SM__RequestPDPContextActivation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.offeredPDPAdress().is_bound()) field_offeredPDPAdress = other_value.offeredPDPAdress();
  else field_offeredPDPAdress.clean_up();
  if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
  else field_accessPointName.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__RequestPDPContextActivation::operator==(const PDU__SM__RequestPDPContextActivation& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_offeredPDPAdress==other_value.field_offeredPDPAdress
  && field_accessPointName==other_value.field_accessPointName
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__RequestPDPContextActivation::is_bound() const
{
return (field_messageType.is_bound())
  || (field_offeredPDPAdress.is_bound())
  || (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__RequestPDPContextActivation::is_value() const
{
return field_messageType.is_value()
  && field_offeredPDPAdress.is_value()
  && (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__RequestPDPContextActivation::size_of() const
{
  int ret_val = 2;
  if (field_accessPointName.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__RequestPDPContextActivation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", offeredPDPAdress := ");
field_offeredPDPAdress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
field_accessPointName.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__RequestPDPContextActivation::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (offeredPDPAdress().is_bound()) offeredPDPAdress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__RequestPDPContextActivation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) offeredPDPAdress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offeredPDPAdress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offeredPDPAdress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
  }
}

void PDU__SM__RequestPDPContextActivation::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_offeredPDPAdress.encode_text(text_buf);
field_accessPointName.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__RequestPDPContextActivation::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_offeredPDPAdress.decode_text(text_buf);
field_accessPointName.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__RequestPDPContextActivation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__RequestPDPContextActivation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__RequestPDPContextActivation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PDPAddressLV_descr_.raw->forceomit);
  decoded_field_length = field_offeredPDPAdress.RAW_decode(PDPAddressLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_accessPointName = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, AccessPointNameTLV_descr_.raw->forceomit);
  decoded_field_length = field_accessPointName().RAW_decode(AccessPointNameTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_accessPointName = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_accessPointName=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_57) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__RequestPDPContextActivation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PDPAddressLV_descr_.raw);
  if (field_accessPointName.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, AccessPointNameTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_offeredPDPAdress.RAW_encode(PDPAddressLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_accessPointName.ispresent()) {
  encoded_length += field_accessPointName().RAW_encode(AccessPointNameTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_messageType !=  bs_57) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_57.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__RequestPDPContextActivation_template::single_value_struct {
BITSTRING_template field_messageType;
PDPAddressLV_template field_offeredPDPAdress;
AccessPointNameTLV_template field_accessPointName;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__RequestPDPContextActivation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_offeredPDPAdress = ANY_VALUE;
single_value->field_accessPointName = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__RequestPDPContextActivation_template::copy_value(const PDU__SM__RequestPDPContextActivation& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.offeredPDPAdress().is_bound()) {
  single_value->field_offeredPDPAdress = other_value.offeredPDPAdress();
} else {
  single_value->field_offeredPDPAdress.clean_up();
}
if (other_value.accessPointName().is_bound()) {
  if (other_value.accessPointName().ispresent()) single_value->field_accessPointName = other_value.accessPointName()();
  else single_value->field_accessPointName = OMIT_VALUE;
} else {
  single_value->field_accessPointName.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__RequestPDPContextActivation_template::copy_template(const PDU__SM__RequestPDPContextActivation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.offeredPDPAdress().get_selection()) {
single_value->field_offeredPDPAdress = other_value.offeredPDPAdress();
} else {
single_value->field_offeredPDPAdress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.accessPointName().get_selection()) {
single_value->field_accessPointName = other_value.accessPointName();
} else {
single_value->field_accessPointName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__RequestPDPContextActivation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__RequestPDPContextActivation_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__RequestPDPContextActivation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
break;
}
set_selection(other_value);
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template()
{
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(const PDU__SM__RequestPDPContextActivation& other_value)
{
copy_value(other_value);
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(const OPTIONAL<PDU__SM__RequestPDPContextActivation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__RequestPDPContextActivation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation from an unbound optional field.");
}
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(PDU__SM__RequestPDPContextActivation_template* p_precondition, PDU__SM__RequestPDPContextActivation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(Dynamic_Match_Interface<PDU__SM__RequestPDPContextActivation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__RequestPDPContextActivation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__RequestPDPContextActivation_template::PDU__SM__RequestPDPContextActivation_template(const PDU__SM__RequestPDPContextActivation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__RequestPDPContextActivation_template::~PDU__SM__RequestPDPContextActivation_template()
{
clean_up();
}

PDU__SM__RequestPDPContextActivation_template& PDU__SM__RequestPDPContextActivation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__RequestPDPContextActivation_template& PDU__SM__RequestPDPContextActivation_template::operator=(const PDU__SM__RequestPDPContextActivation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__RequestPDPContextActivation_template& PDU__SM__RequestPDPContextActivation_template::operator=(const OPTIONAL<PDU__SM__RequestPDPContextActivation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__RequestPDPContextActivation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
}
return *this;
}

PDU__SM__RequestPDPContextActivation_template& PDU__SM__RequestPDPContextActivation_template::operator=(const PDU__SM__RequestPDPContextActivation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__RequestPDPContextActivation_template::match(const PDU__SM__RequestPDPContextActivation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.offeredPDPAdress().is_bound()) return FALSE;
if(!single_value->field_offeredPDPAdress.match(other_value.offeredPDPAdress(), legacy))return FALSE;
if(!other_value.accessPointName().is_bound()) return FALSE;
if((other_value.accessPointName().ispresent() ? !single_value->field_accessPointName.match((const AccessPointNameTLV&)other_value.accessPointName(), legacy) : !single_value->field_accessPointName.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
}
return FALSE;
}

boolean PDU__SM__RequestPDPContextActivation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_offeredPDPAdress.is_bound()
 || (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__RequestPDPContextActivation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_offeredPDPAdress.is_value()
 && (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__RequestPDPContextActivation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__RequestPDPContextActivation PDU__SM__RequestPDPContextActivation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
PDU__SM__RequestPDPContextActivation ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_offeredPDPAdress.is_bound()) {
ret_val.offeredPDPAdress() = single_value->field_offeredPDPAdress.valueof();
}
if (single_value->field_accessPointName.is_omit()) ret_val.accessPointName() = OMIT_VALUE;
else if (single_value->field_accessPointName.is_bound()) {
ret_val.accessPointName() = single_value->field_accessPointName.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__RequestPDPContextActivation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__RequestPDPContextActivation_template[list_length];
}

PDU__SM__RequestPDPContextActivation_template& PDU__SM__RequestPDPContextActivation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__RequestPDPContextActivation_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__RequestPDPContextActivation_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return single_value->field_messageType;
}

PDPAddressLV_template& PDU__SM__RequestPDPContextActivation_template::offeredPDPAdress()
{
set_specific();
return single_value->field_offeredPDPAdress;
}

const PDPAddressLV_template& PDU__SM__RequestPDPContextActivation_template::offeredPDPAdress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field offeredPDPAdress of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return single_value->field_offeredPDPAdress;
}

AccessPointNameTLV_template& PDU__SM__RequestPDPContextActivation_template::accessPointName()
{
set_specific();
return single_value->field_accessPointName;
}

const AccessPointNameTLV_template& PDU__SM__RequestPDPContextActivation_template::accessPointName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field accessPointName of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return single_value->field_accessPointName;
}

ProtocolConfigOptionsTLV_template& PDU__SM__RequestPDPContextActivation_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__RequestPDPContextActivation_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return single_value->field_protocolConfigOpts;
}

NBIFOM__ContainerTLV_template& PDU__SM__RequestPDPContextActivation_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__RequestPDPContextActivation_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__RequestPDPContextActivation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_accessPointName.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
  }
  return 0;
}

void PDU__SM__RequestPDPContextActivation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", offeredPDPAdress := ");
single_value->field_offeredPDPAdress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__RequestPDPContextActivation_template::log_match(const PDU__SM__RequestPDPContextActivation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_offeredPDPAdress.match(match_value.offeredPDPAdress(), legacy)){
TTCN_Logger::log_logmatch_info(".offeredPDPAdress");
single_value->field_offeredPDPAdress.log_match(match_value.offeredPDPAdress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.accessPointName().ispresent()){
if(!single_value->field_accessPointName.match(match_value.accessPointName(), legacy)){
TTCN_Logger::log_logmatch_info(".accessPointName");
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_accessPointName.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".accessPointName := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", offeredPDPAdress := ");
single_value->field_offeredPDPAdress.log_match(match_value.offeredPDPAdress(), legacy);
TTCN_Logger::log_event_str(", accessPointName := ");
if (match_value.accessPointName().ispresent()) {
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_accessPointName.log();
if (single_value->field_accessPointName.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__RequestPDPContextActivation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (offeredPDPAdress().is_bound()) offeredPDPAdress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__RequestPDPContextActivation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_offeredPDPAdress.encode_text(text_buf);
single_value->field_accessPointName.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
}
}

void PDU__SM__RequestPDPContextActivation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_offeredPDPAdress.decode_text(text_buf);
single_value->field_accessPointName.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__RequestPDPContextActivation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation.");
}
}

void PDU__SM__RequestPDPContextActivation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__RequestPDPContextActivation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) offeredPDPAdress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offeredPDPAdress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offeredPDPAdress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__RequestPDPContextActivation_template* precondition = new PDU__SM__RequestPDPContextActivation_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__RequestPDPContextActivation_template* implied_template = new PDU__SM__RequestPDPContextActivation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__RequestPDPContextActivation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__RequestPDPContextActivation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
single_value->field_offeredPDPAdress.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
single_value->field_accessPointName.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivation");
}

boolean PDU__SM__RequestPDPContextActivation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__RequestPDPContextActivation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__RequestPDPContextActivationReject::PDU__SM__RequestPDPContextActivationReject()
{
}

PDU__SM__RequestPDPContextActivationReject::PDU__SM__RequestPDPContextActivationReject(const BITSTRING& par_messageType,
    const OCTETSTRING& par_smCause,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_smCause(par_smCause),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__RequestPDPContextActivationReject::PDU__SM__RequestPDPContextActivationReject(const PDU__SM__RequestPDPContextActivationReject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
else field_smCause.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__RequestPDPContextActivationReject::clean_up()
{
field_messageType.clean_up();
field_smCause.clean_up();
field_protocolConfigOpts.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__RequestPDPContextActivationReject::get_descriptor() const { return &PDU__SM__RequestPDPContextActivationReject_descr_; }
PDU__SM__RequestPDPContextActivationReject& PDU__SM__RequestPDPContextActivationReject::operator=(const PDU__SM__RequestPDPContextActivationReject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.smCause().is_bound()) field_smCause = other_value.smCause();
  else field_smCause.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__RequestPDPContextActivationReject::operator==(const PDU__SM__RequestPDPContextActivationReject& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_smCause==other_value.field_smCause
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__RequestPDPContextActivationReject::is_bound() const
{
return (field_messageType.is_bound())
  || (field_smCause.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__RequestPDPContextActivationReject::is_value() const
{
return field_messageType.is_value()
  && field_smCause.is_value()
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__RequestPDPContextActivationReject::size_of() const
{
  int ret_val = 2;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__RequestPDPContextActivationReject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__RequestPDPContextActivationReject::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__RequestPDPContextActivationReject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
  }
}

void PDU__SM__RequestPDPContextActivationReject::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_smCause.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__RequestPDPContextActivationReject::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_smCause.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__RequestPDPContextActivationReject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__RequestPDPContextActivationReject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__RequestPDPContextActivationReject::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SMCauseV_descr_.raw->forceomit);
  decoded_field_length = field_smCause.RAW_decode(SMCauseV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_58) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__RequestPDPContextActivationReject::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SMCauseV_descr_.raw);
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_smCause.RAW_encode(SMCauseV_descr_, *myleaf.body.node.nodes[1]);
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_messageType !=  bs_58) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_58.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__RequestPDPContextActivationReject_template::single_value_struct {
BITSTRING_template field_messageType;
OCTETSTRING_template field_smCause;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__RequestPDPContextActivationReject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_smCause = ANY_VALUE;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__RequestPDPContextActivationReject_template::copy_value(const PDU__SM__RequestPDPContextActivationReject& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.smCause().is_bound()) {
  single_value->field_smCause = other_value.smCause();
} else {
  single_value->field_smCause.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__RequestPDPContextActivationReject_template::copy_template(const PDU__SM__RequestPDPContextActivationReject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.smCause().get_selection()) {
single_value->field_smCause = other_value.smCause();
} else {
single_value->field_smCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__RequestPDPContextActivationReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__RequestPDPContextActivationReject_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__RequestPDPContextActivationReject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
break;
}
set_selection(other_value);
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template()
{
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(const PDU__SM__RequestPDPContextActivationReject& other_value)
{
copy_value(other_value);
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(const OPTIONAL<PDU__SM__RequestPDPContextActivationReject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__RequestPDPContextActivationReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject from an unbound optional field.");
}
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(PDU__SM__RequestPDPContextActivationReject_template* p_precondition, PDU__SM__RequestPDPContextActivationReject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(Dynamic_Match_Interface<PDU__SM__RequestPDPContextActivationReject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__RequestPDPContextActivationReject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__RequestPDPContextActivationReject_template::PDU__SM__RequestPDPContextActivationReject_template(const PDU__SM__RequestPDPContextActivationReject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__RequestPDPContextActivationReject_template::~PDU__SM__RequestPDPContextActivationReject_template()
{
clean_up();
}

PDU__SM__RequestPDPContextActivationReject_template& PDU__SM__RequestPDPContextActivationReject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__RequestPDPContextActivationReject_template& PDU__SM__RequestPDPContextActivationReject_template::operator=(const PDU__SM__RequestPDPContextActivationReject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__RequestPDPContextActivationReject_template& PDU__SM__RequestPDPContextActivationReject_template::operator=(const OPTIONAL<PDU__SM__RequestPDPContextActivationReject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__RequestPDPContextActivationReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
}
return *this;
}

PDU__SM__RequestPDPContextActivationReject_template& PDU__SM__RequestPDPContextActivationReject_template::operator=(const PDU__SM__RequestPDPContextActivationReject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__RequestPDPContextActivationReject_template::match(const PDU__SM__RequestPDPContextActivationReject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.smCause().is_bound()) return FALSE;
if(!single_value->field_smCause.match(other_value.smCause(), legacy))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
}
return FALSE;
}

boolean PDU__SM__RequestPDPContextActivationReject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_smCause.is_bound()
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__RequestPDPContextActivationReject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_smCause.is_value()
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__RequestPDPContextActivationReject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__RequestPDPContextActivationReject PDU__SM__RequestPDPContextActivationReject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
PDU__SM__RequestPDPContextActivationReject ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_smCause.is_bound()) {
ret_val.smCause() = single_value->field_smCause.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__RequestPDPContextActivationReject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__RequestPDPContextActivationReject_template[list_length];
}

PDU__SM__RequestPDPContextActivationReject_template& PDU__SM__RequestPDPContextActivationReject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__RequestPDPContextActivationReject_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__RequestPDPContextActivationReject_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SM__RequestPDPContextActivationReject_template::smCause()
{
set_specific();
return single_value->field_smCause;
}

const OCTETSTRING_template& PDU__SM__RequestPDPContextActivationReject_template::smCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field smCause of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
return single_value->field_smCause;
}

ProtocolConfigOptionsTLV_template& PDU__SM__RequestPDPContextActivationReject_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__RequestPDPContextActivationReject_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
return single_value->field_protocolConfigOpts;
}

NBIFOM__ContainerTLV_template& PDU__SM__RequestPDPContextActivationReject_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__RequestPDPContextActivationReject_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__RequestPDPContextActivationReject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
  }
  return 0;
}

void PDU__SM__RequestPDPContextActivationReject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__RequestPDPContextActivationReject_template::log_match(const PDU__SM__RequestPDPContextActivationReject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_smCause.match(match_value.smCause(), legacy)){
TTCN_Logger::log_logmatch_info(".smCause");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", smCause := ");
single_value->field_smCause.log_match(match_value.smCause(), legacy);
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__RequestPDPContextActivationReject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (smCause().is_bound()) smCause().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__RequestPDPContextActivationReject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_smCause.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
}
}

void PDU__SM__RequestPDPContextActivationReject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_smCause.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__RequestPDPContextActivationReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject.");
}
}

void PDU__SM__RequestPDPContextActivationReject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__RequestPDPContextActivationReject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) smCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__RequestPDPContextActivationReject_template* precondition = new PDU__SM__RequestPDPContextActivationReject_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__RequestPDPContextActivationReject_template* implied_template = new PDU__SM__RequestPDPContextActivationReject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__RequestPDPContextActivationReject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__RequestPDPContextActivationReject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
single_value->field_smCause.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_RequestPDPContextActivationReject");
}

boolean PDU__SM__RequestPDPContextActivationReject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__RequestPDPContextActivationReject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS::PDU__SM__ModifyPDPContextRequest__SGSN__MS()
{
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS::PDU__SM__ModifyPDPContextRequest__SGSN__MS(const BITSTRING& par_messageType,
    const RadioPriorityV& par_radioPriority,
    const BITSTRING& par_spare,
    const LLC__SAPIV& par_requestedLLC__SAPI,
    const QoSLV& par_newQoS,
    const OPTIONAL< PDPAddressTLV >& par_pdpAddress,
    const OPTIONAL< PacketFlowIDTLV >& par_packetFlowIdentifier,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< TrafficFlowTemplateTLV >& par_tFT,
    const OPTIONAL< WLANOffloadAcceptabilityTV >& par_wLANOffloadIndication,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_radioPriority(par_radioPriority),
  field_spare(par_spare),
  field_requestedLLC__SAPI(par_requestedLLC__SAPI),
  field_newQoS(par_newQoS),
  field_pdpAddress(par_pdpAddress),
  field_packetFlowIdentifier(par_packetFlowIdentifier),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_tFT(par_tFT),
  field_wLANOffloadIndication(par_wLANOffloadIndication),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS::PDU__SM__ModifyPDPContextRequest__SGSN__MS(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
else field_radioPriority.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
else field_requestedLLC__SAPI.clean_up();
if (other_value.newQoS().is_bound()) field_newQoS = other_value.newQoS();
else field_newQoS.clean_up();
if (other_value.pdpAddress().is_bound()) field_pdpAddress = other_value.pdpAddress();
else field_pdpAddress.clean_up();
if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
else field_packetFlowIdentifier.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.tFT().is_bound()) field_tFT = other_value.tFT();
else field_tFT.clean_up();
if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
else field_wLANOffloadIndication.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::clean_up()
{
field_messageType.clean_up();
field_radioPriority.clean_up();
field_spare.clean_up();
field_requestedLLC__SAPI.clean_up();
field_newQoS.clean_up();
field_pdpAddress.clean_up();
field_packetFlowIdentifier.clean_up();
field_protocolConfigOpts.clean_up();
field_tFT.clean_up();
field_wLANOffloadIndication.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ModifyPDPContextRequest__SGSN__MS::get_descriptor() const { return &PDU__SM__ModifyPDPContextRequest__SGSN__MS_descr_; }
PDU__SM__ModifyPDPContextRequest__SGSN__MS& PDU__SM__ModifyPDPContextRequest__SGSN__MS::operator=(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.radioPriority().is_bound()) field_radioPriority = other_value.radioPriority();
  else field_radioPriority.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
  else field_requestedLLC__SAPI.clean_up();
  if (other_value.newQoS().is_bound()) field_newQoS = other_value.newQoS();
  else field_newQoS.clean_up();
  if (other_value.pdpAddress().is_bound()) field_pdpAddress = other_value.pdpAddress();
  else field_pdpAddress.clean_up();
  if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
  else field_packetFlowIdentifier.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.tFT().is_bound()) field_tFT = other_value.tFT();
  else field_tFT.clean_up();
  if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
  else field_wLANOffloadIndication.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS::operator==(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_radioPriority==other_value.field_radioPriority
  && field_spare==other_value.field_spare
  && field_requestedLLC__SAPI==other_value.field_requestedLLC__SAPI
  && field_newQoS==other_value.field_newQoS
  && field_pdpAddress==other_value.field_pdpAddress
  && field_packetFlowIdentifier==other_value.field_packetFlowIdentifier
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_tFT==other_value.field_tFT
  && field_wLANOffloadIndication==other_value.field_wLANOffloadIndication
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (field_radioPriority.is_bound())
  || (field_spare.is_bound())
  || (field_requestedLLC__SAPI.is_bound())
  || (field_newQoS.is_bound())
  || (OPTIONAL_OMIT == field_pdpAddress.get_selection() || field_pdpAddress.is_bound())
  || (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_tFT.get_selection() || field_tFT.is_bound())
  || (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS::is_value() const
{
return field_messageType.is_value()
  && field_radioPriority.is_value()
  && field_spare.is_value()
  && field_requestedLLC__SAPI.is_value()
  && field_newQoS.is_value()
  && (OPTIONAL_OMIT == field_pdpAddress.get_selection() || field_pdpAddress.is_value())
  && (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_tFT.get_selection() || field_tFT.is_value())
  && (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ModifyPDPContextRequest__SGSN__MS::size_of() const
{
  int ret_val = 5;
  if (field_pdpAddress.ispresent()) ret_val++;
  if (field_packetFlowIdentifier.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_tFT.ispresent()) ret_val++;
  if (field_wLANOffloadIndication.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", radioPriority := ");
field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", newQoS := ");
field_newQoS.log();
TTCN_Logger::log_event_str(", pdpAddress := ");
field_pdpAddress.log();
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", tFT := ");
field_tFT.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (requestedLLC__SAPI().is_bound()) requestedLLC__SAPI().set_implicit_omit();
if (newQoS().is_bound()) newQoS().set_implicit_omit();
if (!pdpAddress().is_bound()) pdpAddress() = OMIT_VALUE;
else pdpAddress().set_implicit_omit();
if (!packetFlowIdentifier().is_bound()) packetFlowIdentifier() = OMIT_VALUE;
else packetFlowIdentifier().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!tFT().is_bound()) tFT() = OMIT_VALUE;
else tFT().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) newQoS().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) pdpAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) packetFlowIdentifier().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) tFT().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
  }
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_radioPriority.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_requestedLLC__SAPI.encode_text(text_buf);
field_newQoS.encode_text(text_buf);
field_pdpAddress.encode_text(text_buf);
field_packetFlowIdentifier.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_tFT.encode_text(text_buf);
field_wLANOffloadIndication.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_radioPriority.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_requestedLLC__SAPI.decode_text(text_buf);
field_newQoS.decode_text(text_buf);
field_pdpAddress.decode_text(text_buf);
field_packetFlowIdentifier.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_tFT.decode_text(text_buf);
field_wLANOffloadIndication.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ModifyPDPContextRequest__SGSN__MS::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RadioPriorityV_descr_.raw->forceomit);
  decoded_field_length = field_radioPriority.RAW_decode(RadioPriorityV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_requestedLLC__SAPI.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_newQoS.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_pdpAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, PDPAddressTLV_descr_.raw->forceomit);
  decoded_field_length = field_pdpAddress().RAW_decode(PDPAddressTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_pdpAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_pdpAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_packetFlowIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, PacketFlowIDTLV_descr_.raw->forceomit);
  decoded_field_length = field_packetFlowIdentifier().RAW_decode(PacketFlowIDTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_packetFlowIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_packetFlowIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_tFT = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, TrafficFlowTemplateTLV_descr_.raw->forceomit);
  decoded_field_length = field_tFT().RAW_decode(TrafficFlowTemplateTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_tFT = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tFT=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_wLANOffloadIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, WLANOffloadAcceptabilityTV_descr_.raw->forceomit);
  decoded_field_length = field_wLANOffloadIndication().RAW_decode(WLANOffloadAcceptabilityTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_wLANOffloadIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_wLANOffloadIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_59) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ModifyPDPContextRequest__SGSN__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 11;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(11);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RadioPriorityV_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, LLC__SAPIV_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, QoSLV_descr_.raw);
  if (field_pdpAddress.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PDPAddressTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_packetFlowIdentifier.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, PacketFlowIDTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_tFT.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, TrafficFlowTemplateTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_wLANOffloadIndication.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, WLANOffloadAcceptabilityTV_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_radioPriority.RAW_encode(RadioPriorityV_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_requestedLLC__SAPI.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_newQoS.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[4]);
  if (field_pdpAddress.ispresent()) {
  encoded_length += field_pdpAddress().RAW_encode(PDPAddressTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_packetFlowIdentifier.ispresent()) {
  encoded_length += field_packetFlowIdentifier().RAW_encode(PacketFlowIDTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_tFT.ispresent()) {
  encoded_length += field_tFT().RAW_encode(TrafficFlowTemplateTLV_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_wLANOffloadIndication.ispresent()) {
  encoded_length += field_wLANOffloadIndication().RAW_encode(WLANOffloadAcceptabilityTV_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_messageType !=  bs_59) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_59.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::single_value_struct {
BITSTRING_template field_messageType;
RadioPriorityV_template field_radioPriority;
BITSTRING_template field_spare;
LLC__SAPIV_template field_requestedLLC__SAPI;
QoSLV_template field_newQoS;
PDPAddressTLV_template field_pdpAddress;
PacketFlowIDTLV_template field_packetFlowIdentifier;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
TrafficFlowTemplateTLV_template field_tFT;
WLANOffloadAcceptabilityTV_template field_wLANOffloadIndication;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_radioPriority = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_requestedLLC__SAPI = ANY_VALUE;
single_value->field_newQoS = ANY_VALUE;
single_value->field_pdpAddress = ANY_OR_OMIT;
single_value->field_packetFlowIdentifier = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_tFT = ANY_OR_OMIT;
single_value->field_wLANOffloadIndication = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::copy_value(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.radioPriority().is_bound()) {
  single_value->field_radioPriority = other_value.radioPriority();
} else {
  single_value->field_radioPriority.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.requestedLLC__SAPI().is_bound()) {
  single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
} else {
  single_value->field_requestedLLC__SAPI.clean_up();
}
if (other_value.newQoS().is_bound()) {
  single_value->field_newQoS = other_value.newQoS();
} else {
  single_value->field_newQoS.clean_up();
}
if (other_value.pdpAddress().is_bound()) {
  if (other_value.pdpAddress().ispresent()) single_value->field_pdpAddress = other_value.pdpAddress()();
  else single_value->field_pdpAddress = OMIT_VALUE;
} else {
  single_value->field_pdpAddress.clean_up();
}
if (other_value.packetFlowIdentifier().is_bound()) {
  if (other_value.packetFlowIdentifier().ispresent()) single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier()();
  else single_value->field_packetFlowIdentifier = OMIT_VALUE;
} else {
  single_value->field_packetFlowIdentifier.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.tFT().is_bound()) {
  if (other_value.tFT().ispresent()) single_value->field_tFT = other_value.tFT()();
  else single_value->field_tFT = OMIT_VALUE;
} else {
  single_value->field_tFT.clean_up();
}
if (other_value.wLANOffloadIndication().is_bound()) {
  if (other_value.wLANOffloadIndication().ispresent()) single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication()();
  else single_value->field_wLANOffloadIndication = OMIT_VALUE;
} else {
  single_value->field_wLANOffloadIndication.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::copy_template(const PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.radioPriority().get_selection()) {
single_value->field_radioPriority = other_value.radioPriority();
} else {
single_value->field_radioPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedLLC__SAPI().get_selection()) {
single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
} else {
single_value->field_requestedLLC__SAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.newQoS().get_selection()) {
single_value->field_newQoS = other_value.newQoS();
} else {
single_value->field_newQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpAddress().get_selection()) {
single_value->field_pdpAddress = other_value.pdpAddress();
} else {
single_value->field_pdpAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFlowIdentifier().get_selection()) {
single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier();
} else {
single_value->field_packetFlowIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tFT().get_selection()) {
single_value->field_tFT = other_value.tFT();
} else {
single_value->field_tFT.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.wLANOffloadIndication().get_selection()) {
single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication();
} else {
single_value->field_wLANOffloadIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
break;
}
set_selection(other_value);
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template()
{
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value)
{
copy_value(other_value);
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(const OPTIONAL<PDU__SM__ModifyPDPContextRequest__SGSN__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextRequest__SGSN__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS from an unbound optional field.");
}
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(PDU__SM__ModifyPDPContextRequest__SGSN__MS_template* p_precondition, PDU__SM__ModifyPDPContextRequest__SGSN__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(Dynamic_Match_Interface<PDU__SM__ModifyPDPContextRequest__SGSN__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ModifyPDPContextRequest__SGSN__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(const PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::~PDU__SM__ModifyPDPContextRequest__SGSN__MS_template()
{
clean_up();
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::operator=(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::operator=(const OPTIONAL<PDU__SM__ModifyPDPContextRequest__SGSN__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextRequest__SGSN__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
}
return *this;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::operator=(const PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::match(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.radioPriority().is_bound()) return FALSE;
if(!single_value->field_radioPriority.match(other_value.radioPriority(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.requestedLLC__SAPI().is_bound()) return FALSE;
if(!single_value->field_requestedLLC__SAPI.match(other_value.requestedLLC__SAPI(), legacy))return FALSE;
if(!other_value.newQoS().is_bound()) return FALSE;
if(!single_value->field_newQoS.match(other_value.newQoS(), legacy))return FALSE;
if(!other_value.pdpAddress().is_bound()) return FALSE;
if((other_value.pdpAddress().ispresent() ? !single_value->field_pdpAddress.match((const PDPAddressTLV&)other_value.pdpAddress(), legacy) : !single_value->field_pdpAddress.match_omit(legacy)))return FALSE;
if(!other_value.packetFlowIdentifier().is_bound()) return FALSE;
if((other_value.packetFlowIdentifier().ispresent() ? !single_value->field_packetFlowIdentifier.match((const PacketFlowIDTLV&)other_value.packetFlowIdentifier(), legacy) : !single_value->field_packetFlowIdentifier.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.tFT().is_bound()) return FALSE;
if((other_value.tFT().ispresent() ? !single_value->field_tFT.match((const TrafficFlowTemplateTLV&)other_value.tFT(), legacy) : !single_value->field_tFT.match_omit(legacy)))return FALSE;
if(!other_value.wLANOffloadIndication().is_bound()) return FALSE;
if((other_value.wLANOffloadIndication().ispresent() ? !single_value->field_wLANOffloadIndication.match((const WLANOffloadAcceptabilityTV&)other_value.wLANOffloadIndication(), legacy) : !single_value->field_wLANOffloadIndication.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
}
return FALSE;
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_radioPriority.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_requestedLLC__SAPI.is_bound()
 || single_value->field_newQoS.is_bound()
 || (single_value->field_pdpAddress.is_omit() || single_value->field_pdpAddress.is_bound())
 || (single_value->field_packetFlowIdentifier.is_omit() || single_value->field_packetFlowIdentifier.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_tFT.is_omit() || single_value->field_tFT.is_bound())
 || (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_radioPriority.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_requestedLLC__SAPI.is_value()
 && single_value->field_newQoS.is_value()
 && (single_value->field_pdpAddress.is_omit() || single_value->field_pdpAddress.is_value())
 && (single_value->field_packetFlowIdentifier.is_omit() || single_value->field_packetFlowIdentifier.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_tFT.is_omit() || single_value->field_tFT.is_value())
 && (single_value->field_wLANOffloadIndication.is_omit() || single_value->field_wLANOffloadIndication.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
PDU__SM__ModifyPDPContextRequest__SGSN__MS ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_radioPriority.is_bound()) {
ret_val.radioPriority() = single_value->field_radioPriority.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_requestedLLC__SAPI.is_bound()) {
ret_val.requestedLLC__SAPI() = single_value->field_requestedLLC__SAPI.valueof();
}
if (single_value->field_newQoS.is_bound()) {
ret_val.newQoS() = single_value->field_newQoS.valueof();
}
if (single_value->field_pdpAddress.is_omit()) ret_val.pdpAddress() = OMIT_VALUE;
else if (single_value->field_pdpAddress.is_bound()) {
ret_val.pdpAddress() = single_value->field_pdpAddress.valueof();
}
if (single_value->field_packetFlowIdentifier.is_omit()) ret_val.packetFlowIdentifier() = OMIT_VALUE;
else if (single_value->field_packetFlowIdentifier.is_bound()) {
ret_val.packetFlowIdentifier() = single_value->field_packetFlowIdentifier.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_tFT.is_omit()) ret_val.tFT() = OMIT_VALUE;
else if (single_value->field_tFT.is_bound()) {
ret_val.tFT() = single_value->field_tFT.valueof();
}
if (single_value->field_wLANOffloadIndication.is_omit()) ret_val.wLANOffloadIndication() = OMIT_VALUE;
else if (single_value->field_wLANOffloadIndication.is_bound()) {
ret_val.wLANOffloadIndication() = single_value->field_wLANOffloadIndication.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template[list_length];
}

PDU__SM__ModifyPDPContextRequest__SGSN__MS_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_messageType;
}

RadioPriorityV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::radioPriority()
{
set_specific();
return single_value->field_radioPriority;
}

const RadioPriorityV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::radioPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field radioPriority of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_radioPriority;
}

BITSTRING_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_spare;
}

LLC__SAPIV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::requestedLLC__SAPI()
{
set_specific();
return single_value->field_requestedLLC__SAPI;
}

const LLC__SAPIV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::requestedLLC__SAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedLLC_SAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_requestedLLC__SAPI;
}

QoSLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::newQoS()
{
set_specific();
return single_value->field_newQoS;
}

const QoSLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::newQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field newQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_newQoS;
}

PDPAddressTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::pdpAddress()
{
set_specific();
return single_value->field_pdpAddress;
}

const PDPAddressTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::pdpAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpAddress of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_pdpAddress;
}

PacketFlowIDTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::packetFlowIdentifier()
{
set_specific();
return single_value->field_packetFlowIdentifier;
}

const PacketFlowIDTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::packetFlowIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFlowIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_packetFlowIdentifier;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_protocolConfigOpts;
}

TrafficFlowTemplateTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::tFT()
{
set_specific();
return single_value->field_tFT;
}

const TrafficFlowTemplateTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::tFT() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tFT of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_tFT;
}

WLANOffloadAcceptabilityTV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::wLANOffloadIndication()
{
set_specific();
return single_value->field_wLANOffloadIndication;
}

const WLANOffloadAcceptabilityTV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::wLANOffloadIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field wLANOffloadIndication of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_wLANOffloadIndication;
}

NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_pdpAddress.is_present()) ret_val++;
      if (single_value->field_packetFlowIdentifier.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_tFT.is_present()) ret_val++;
      if (single_value->field_wLANOffloadIndication.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
  }
  return 0;
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
single_value->field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", newQoS := ");
single_value->field_newQoS.log();
TTCN_Logger::log_event_str(", pdpAddress := ");
single_value->field_pdpAddress.log();
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
single_value->field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", tFT := ");
single_value->field_tFT.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::log_match(const PDU__SM__ModifyPDPContextRequest__SGSN__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_radioPriority.match(match_value.radioPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".radioPriority");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requestedLLC__SAPI.match(match_value.requestedLLC__SAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedLLC_SAPI");
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_newQoS.match(match_value.newQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".newQoS");
single_value->field_newQoS.log_match(match_value.newQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pdpAddress().ispresent()){
if(!single_value->field_pdpAddress.match(match_value.pdpAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpAddress");
single_value->field_pdpAddress.log_match(match_value.pdpAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdpAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdpAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdpAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.packetFlowIdentifier().ispresent()){
if(!single_value->field_packetFlowIdentifier.match(match_value.packetFlowIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFlowIdentifier");
single_value->field_packetFlowIdentifier.log_match(match_value.packetFlowIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_packetFlowIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".packetFlowIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.tFT().ispresent()){
if(!single_value->field_tFT.match(match_value.tFT(), legacy)){
TTCN_Logger::log_logmatch_info(".tFT");
single_value->field_tFT.log_match(match_value.tFT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tFT.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tFT := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tFT.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.wLANOffloadIndication().ispresent()){
if(!single_value->field_wLANOffloadIndication.match(match_value.wLANOffloadIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".wLANOffloadIndication");
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_wLANOffloadIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".wLANOffloadIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", radioPriority := ");
single_value->field_radioPriority.log_match(match_value.radioPriority(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
TTCN_Logger::log_event_str(", newQoS := ");
single_value->field_newQoS.log_match(match_value.newQoS(), legacy);
TTCN_Logger::log_event_str(", pdpAddress := ");
if (match_value.pdpAddress().ispresent()) {
single_value->field_pdpAddress.log_match(match_value.pdpAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdpAddress.log();
if (single_value->field_pdpAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
if (match_value.packetFlowIdentifier().ispresent()) {
single_value->field_packetFlowIdentifier.log_match(match_value.packetFlowIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_packetFlowIdentifier.log();
if (single_value->field_packetFlowIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", tFT := ");
if (match_value.tFT().ispresent()) {
single_value->field_tFT.log_match(match_value.tFT(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tFT.log();
if (single_value->field_tFT.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
if (match_value.wLANOffloadIndication().ispresent()) {
single_value->field_wLANOffloadIndication.log_match(match_value.wLANOffloadIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_wLANOffloadIndication.log();
if (single_value->field_wLANOffloadIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (radioPriority().is_bound()) radioPriority().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (requestedLLC__SAPI().is_bound()) requestedLLC__SAPI().set_implicit_omit();
if (newQoS().is_bound()) newQoS().set_implicit_omit();
if (!pdpAddress().is_bound()) pdpAddress() = OMIT_VALUE;
else pdpAddress().set_implicit_omit();
if (!packetFlowIdentifier().is_bound()) packetFlowIdentifier() = OMIT_VALUE;
else packetFlowIdentifier().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!tFT().is_bound()) tFT() = OMIT_VALUE;
else tFT().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_radioPriority.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_requestedLLC__SAPI.encode_text(text_buf);
single_value->field_newQoS.encode_text(text_buf);
single_value->field_pdpAddress.encode_text(text_buf);
single_value->field_packetFlowIdentifier.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_tFT.encode_text(text_buf);
single_value->field_wLANOffloadIndication.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
}
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_radioPriority.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_requestedLLC__SAPI.decode_text(text_buf);
single_value->field_newQoS.decode_text(text_buf);
single_value->field_pdpAddress.decode_text(text_buf);
single_value->field_packetFlowIdentifier.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_tFT.decode_text(text_buf);
single_value->field_wLANOffloadIndication.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS.");
}
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ModifyPDPContextRequest__SGSN__MS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) radioPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) newQoS().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) pdpAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) packetFlowIdentifier().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) tFT().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "radioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          radioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ModifyPDPContextRequest__SGSN__MS_template* precondition = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ModifyPDPContextRequest__SGSN__MS_template* implied_template = new PDU__SM__ModifyPDPContextRequest__SGSN__MS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ModifyPDPContextRequest__SGSN__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_radioPriority.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_requestedLLC__SAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_newQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_pdpAddress.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_packetFlowIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_tFT.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_wLANOffloadIndication.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_SGSN_MS");
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ModifyPDPContextRequest__SGSN__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN::PDU__SM__ModifyPDPContextRequest__MS__SGSN()
{
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN::PDU__SM__ModifyPDPContextRequest__MS__SGSN(const BITSTRING& par_messageType,
    const OPTIONAL< LLC__SAPITV >& par_requestedLLC__SAPI,
    const OPTIONAL< QoSTLV >& par_requestedNewQoS,
    const OPTIONAL< TrafficFlowTemplateTLV >& par_newTFT,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< MobileL3__CommonIE__Types::DevicePropertiesTV >& par_deviceProperties,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_requestedLLC__SAPI(par_requestedLLC__SAPI),
  field_requestedNewQoS(par_requestedNewQoS),
  field_newTFT(par_newTFT),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_deviceProperties(par_deviceProperties),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN::PDU__SM__ModifyPDPContextRequest__MS__SGSN(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
else field_requestedLLC__SAPI.clean_up();
if (other_value.requestedNewQoS().is_bound()) field_requestedNewQoS = other_value.requestedNewQoS();
else field_requestedNewQoS.clean_up();
if (other_value.newTFT().is_bound()) field_newTFT = other_value.newTFT();
else field_newTFT.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
else field_deviceProperties.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::clean_up()
{
field_messageType.clean_up();
field_requestedLLC__SAPI.clean_up();
field_requestedNewQoS.clean_up();
field_newTFT.clean_up();
field_protocolConfigOpts.clean_up();
field_deviceProperties.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ModifyPDPContextRequest__MS__SGSN::get_descriptor() const { return &PDU__SM__ModifyPDPContextRequest__MS__SGSN_descr_; }
PDU__SM__ModifyPDPContextRequest__MS__SGSN& PDU__SM__ModifyPDPContextRequest__MS__SGSN::operator=(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.requestedLLC__SAPI().is_bound()) field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
  else field_requestedLLC__SAPI.clean_up();
  if (other_value.requestedNewQoS().is_bound()) field_requestedNewQoS = other_value.requestedNewQoS();
  else field_requestedNewQoS.clean_up();
  if (other_value.newTFT().is_bound()) field_newTFT = other_value.newTFT();
  else field_newTFT.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.deviceProperties().is_bound()) field_deviceProperties = other_value.deviceProperties();
  else field_deviceProperties.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN::operator==(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_requestedLLC__SAPI==other_value.field_requestedLLC__SAPI
  && field_requestedNewQoS==other_value.field_requestedNewQoS
  && field_newTFT==other_value.field_newTFT
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_deviceProperties==other_value.field_deviceProperties
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_requestedLLC__SAPI.get_selection() || field_requestedLLC__SAPI.is_bound())
  || (OPTIONAL_OMIT == field_requestedNewQoS.get_selection() || field_requestedNewQoS.is_bound())
  || (OPTIONAL_OMIT == field_newTFT.get_selection() || field_newTFT.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_requestedLLC__SAPI.get_selection() || field_requestedLLC__SAPI.is_value())
  && (OPTIONAL_OMIT == field_requestedNewQoS.get_selection() || field_requestedNewQoS.is_value())
  && (OPTIONAL_OMIT == field_newTFT.get_selection() || field_newTFT.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_deviceProperties.get_selection() || field_deviceProperties.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ModifyPDPContextRequest__MS__SGSN::size_of() const
{
  int ret_val = 1;
  if (field_requestedLLC__SAPI.ispresent()) ret_val++;
  if (field_requestedNewQoS.ispresent()) ret_val++;
  if (field_newTFT.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_deviceProperties.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", requestedNewQoS := ");
field_requestedNewQoS.log();
TTCN_Logger::log_event_str(", newTFT := ");
field_newTFT.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!requestedLLC__SAPI().is_bound()) requestedLLC__SAPI() = OMIT_VALUE;
else requestedLLC__SAPI().set_implicit_omit();
if (!requestedNewQoS().is_bound()) requestedNewQoS() = OMIT_VALUE;
else requestedNewQoS().set_implicit_omit();
if (!newTFT().is_bound()) newTFT() = OMIT_VALUE;
else newTFT().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedNewQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) newTFT().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNewQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNewQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
  }
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_requestedLLC__SAPI.encode_text(text_buf);
field_requestedNewQoS.encode_text(text_buf);
field_newTFT.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_deviceProperties.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_requestedLLC__SAPI.decode_text(text_buf);
field_requestedNewQoS.decode_text(text_buf);
field_newTFT.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_deviceProperties.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ModifyPDPContextRequest__MS__SGSN::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_requestedLLC__SAPI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, LLC__SAPITV_descr_.raw->forceomit);
  decoded_field_length = field_requestedLLC__SAPI().RAW_decode(LLC__SAPITV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_requestedLLC__SAPI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_requestedLLC__SAPI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_requestedNewQoS = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, QoSTLV_descr_.raw->forceomit);
  decoded_field_length = field_requestedNewQoS().RAW_decode(QoSTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_requestedNewQoS = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_requestedNewQoS=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_newTFT = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, TrafficFlowTemplateTLV_descr_.raw->forceomit);
  decoded_field_length = field_newTFT().RAW_decode(TrafficFlowTemplateTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_newTFT = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_newTFT=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_deviceProperties = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw->forceomit);
  decoded_field_length = field_deviceProperties().RAW_decode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_deviceProperties = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21){
  field_deviceProperties=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_deviceProperties=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_60) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ModifyPDPContextRequest__MS__SGSN::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  if (field_requestedLLC__SAPI.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LLC__SAPITV_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_requestedNewQoS.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, QoSTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_newTFT.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, TrafficFlowTemplateTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_deviceProperties.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, MobileL3__CommonIE__Types::DevicePropertiesTV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  if (field_requestedLLC__SAPI.ispresent()) {
  encoded_length += field_requestedLLC__SAPI().RAW_encode(LLC__SAPITV_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_requestedNewQoS.ispresent()) {
  encoded_length += field_requestedNewQoS().RAW_encode(QoSTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_newTFT.ispresent()) {
  encoded_length += field_newTFT().RAW_encode(TrafficFlowTemplateTLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_deviceProperties.ispresent()) {
  encoded_length += field_deviceProperties().RAW_encode(MobileL3__CommonIE__Types::DevicePropertiesTV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_deviceProperties.ispresent() && (!field_deviceProperties.ispresent() || field_deviceProperties().elementIdentifier() !=  bs_21)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_21.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_messageType !=  bs_60) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_60.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::single_value_struct {
BITSTRING_template field_messageType;
LLC__SAPITV_template field_requestedLLC__SAPI;
QoSTLV_template field_requestedNewQoS;
TrafficFlowTemplateTLV_template field_newTFT;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
MobileL3__CommonIE__Types::DevicePropertiesTV_template field_deviceProperties;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_requestedLLC__SAPI = ANY_OR_OMIT;
single_value->field_requestedNewQoS = ANY_OR_OMIT;
single_value->field_newTFT = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_deviceProperties = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::copy_value(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.requestedLLC__SAPI().is_bound()) {
  if (other_value.requestedLLC__SAPI().ispresent()) single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI()();
  else single_value->field_requestedLLC__SAPI = OMIT_VALUE;
} else {
  single_value->field_requestedLLC__SAPI.clean_up();
}
if (other_value.requestedNewQoS().is_bound()) {
  if (other_value.requestedNewQoS().ispresent()) single_value->field_requestedNewQoS = other_value.requestedNewQoS()();
  else single_value->field_requestedNewQoS = OMIT_VALUE;
} else {
  single_value->field_requestedNewQoS.clean_up();
}
if (other_value.newTFT().is_bound()) {
  if (other_value.newTFT().ispresent()) single_value->field_newTFT = other_value.newTFT()();
  else single_value->field_newTFT = OMIT_VALUE;
} else {
  single_value->field_newTFT.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.deviceProperties().is_bound()) {
  if (other_value.deviceProperties().ispresent()) single_value->field_deviceProperties = other_value.deviceProperties()();
  else single_value->field_deviceProperties = OMIT_VALUE;
} else {
  single_value->field_deviceProperties.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::copy_template(const PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedLLC__SAPI().get_selection()) {
single_value->field_requestedLLC__SAPI = other_value.requestedLLC__SAPI();
} else {
single_value->field_requestedLLC__SAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedNewQoS().get_selection()) {
single_value->field_requestedNewQoS = other_value.requestedNewQoS();
} else {
single_value->field_requestedNewQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.newTFT().get_selection()) {
single_value->field_newTFT = other_value.newTFT();
} else {
single_value->field_newTFT.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deviceProperties().get_selection()) {
single_value->field_deviceProperties = other_value.deviceProperties();
} else {
single_value->field_deviceProperties.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
break;
}
set_selection(other_value);
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template()
{
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value)
{
copy_value(other_value);
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(const OPTIONAL<PDU__SM__ModifyPDPContextRequest__MS__SGSN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextRequest__MS__SGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN from an unbound optional field.");
}
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(PDU__SM__ModifyPDPContextRequest__MS__SGSN_template* p_precondition, PDU__SM__ModifyPDPContextRequest__MS__SGSN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(Dynamic_Match_Interface<PDU__SM__ModifyPDPContextRequest__MS__SGSN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ModifyPDPContextRequest__MS__SGSN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(const PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::~PDU__SM__ModifyPDPContextRequest__MS__SGSN_template()
{
clean_up();
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::operator=(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::operator=(const OPTIONAL<PDU__SM__ModifyPDPContextRequest__MS__SGSN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextRequest__MS__SGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
}
return *this;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::operator=(const PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::match(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.requestedLLC__SAPI().is_bound()) return FALSE;
if((other_value.requestedLLC__SAPI().ispresent() ? !single_value->field_requestedLLC__SAPI.match((const LLC__SAPITV&)other_value.requestedLLC__SAPI(), legacy) : !single_value->field_requestedLLC__SAPI.match_omit(legacy)))return FALSE;
if(!other_value.requestedNewQoS().is_bound()) return FALSE;
if((other_value.requestedNewQoS().ispresent() ? !single_value->field_requestedNewQoS.match((const QoSTLV&)other_value.requestedNewQoS(), legacy) : !single_value->field_requestedNewQoS.match_omit(legacy)))return FALSE;
if(!other_value.newTFT().is_bound()) return FALSE;
if((other_value.newTFT().ispresent() ? !single_value->field_newTFT.match((const TrafficFlowTemplateTLV&)other_value.newTFT(), legacy) : !single_value->field_newTFT.match_omit(legacy)))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.deviceProperties().is_bound()) return FALSE;
if((other_value.deviceProperties().ispresent() ? !single_value->field_deviceProperties.match((const MobileL3__CommonIE__Types::DevicePropertiesTV&)other_value.deviceProperties(), legacy) : !single_value->field_deviceProperties.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
}
return FALSE;
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_requestedLLC__SAPI.is_omit() || single_value->field_requestedLLC__SAPI.is_bound())
 || (single_value->field_requestedNewQoS.is_omit() || single_value->field_requestedNewQoS.is_bound())
 || (single_value->field_newTFT.is_omit() || single_value->field_newTFT.is_bound())
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_requestedLLC__SAPI.is_omit() || single_value->field_requestedLLC__SAPI.is_value())
 && (single_value->field_requestedNewQoS.is_omit() || single_value->field_requestedNewQoS.is_value())
 && (single_value->field_newTFT.is_omit() || single_value->field_newTFT.is_value())
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_deviceProperties.is_omit() || single_value->field_deviceProperties.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
PDU__SM__ModifyPDPContextRequest__MS__SGSN ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_requestedLLC__SAPI.is_omit()) ret_val.requestedLLC__SAPI() = OMIT_VALUE;
else if (single_value->field_requestedLLC__SAPI.is_bound()) {
ret_val.requestedLLC__SAPI() = single_value->field_requestedLLC__SAPI.valueof();
}
if (single_value->field_requestedNewQoS.is_omit()) ret_val.requestedNewQoS() = OMIT_VALUE;
else if (single_value->field_requestedNewQoS.is_bound()) {
ret_val.requestedNewQoS() = single_value->field_requestedNewQoS.valueof();
}
if (single_value->field_newTFT.is_omit()) ret_val.newTFT() = OMIT_VALUE;
else if (single_value->field_newTFT.is_bound()) {
ret_val.newTFT() = single_value->field_newTFT.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_deviceProperties.is_omit()) ret_val.deviceProperties() = OMIT_VALUE;
else if (single_value->field_deviceProperties.is_bound()) {
ret_val.deviceProperties() = single_value->field_deviceProperties.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template[list_length];
}

PDU__SM__ModifyPDPContextRequest__MS__SGSN_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_messageType;
}

LLC__SAPITV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::requestedLLC__SAPI()
{
set_specific();
return single_value->field_requestedLLC__SAPI;
}

const LLC__SAPITV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::requestedLLC__SAPI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedLLC_SAPI of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_requestedLLC__SAPI;
}

QoSTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::requestedNewQoS()
{
set_specific();
return single_value->field_requestedNewQoS;
}

const QoSTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::requestedNewQoS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedNewQoS of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_requestedNewQoS;
}

TrafficFlowTemplateTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::newTFT()
{
set_specific();
return single_value->field_newTFT;
}

const TrafficFlowTemplateTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::newTFT() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field newTFT of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_newTFT;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_protocolConfigOpts;
}

MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::deviceProperties()
{
set_specific();
return single_value->field_deviceProperties;
}

const MobileL3__CommonIE__Types::DevicePropertiesTV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::deviceProperties() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deviceProperties of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_deviceProperties;
}

NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_requestedLLC__SAPI.is_present()) ret_val++;
      if (single_value->field_requestedNewQoS.is_present()) ret_val++;
      if (single_value->field_newTFT.is_present()) ret_val++;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_deviceProperties.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
  }
  return 0;
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
single_value->field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(", requestedNewQoS := ");
single_value->field_requestedNewQoS.log();
TTCN_Logger::log_event_str(", newTFT := ");
single_value->field_newTFT.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", deviceProperties := ");
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::log_match(const PDU__SM__ModifyPDPContextRequest__MS__SGSN& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.requestedLLC__SAPI().ispresent()){
if(!single_value->field_requestedLLC__SAPI.match(match_value.requestedLLC__SAPI(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedLLC_SAPI");
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_requestedLLC__SAPI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".requestedLLC_SAPI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_requestedLLC__SAPI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.requestedNewQoS().ispresent()){
if(!single_value->field_requestedNewQoS.match(match_value.requestedNewQoS(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedNewQoS");
single_value->field_requestedNewQoS.log_match(match_value.requestedNewQoS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_requestedNewQoS.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".requestedNewQoS := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_requestedNewQoS.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.newTFT().ispresent()){
if(!single_value->field_newTFT.match(match_value.newTFT(), legacy)){
TTCN_Logger::log_logmatch_info(".newTFT");
single_value->field_newTFT.log_match(match_value.newTFT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_newTFT.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".newTFT := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_newTFT.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.deviceProperties().ispresent()){
if(!single_value->field_deviceProperties.match(match_value.deviceProperties(), legacy)){
TTCN_Logger::log_logmatch_info(".deviceProperties");
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deviceProperties.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deviceProperties := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deviceProperties.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", requestedLLC_SAPI := ");
if (match_value.requestedLLC__SAPI().ispresent()) {
single_value->field_requestedLLC__SAPI.log_match(match_value.requestedLLC__SAPI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_requestedLLC__SAPI.log();
if (single_value->field_requestedLLC__SAPI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", requestedNewQoS := ");
if (match_value.requestedNewQoS().ispresent()) {
single_value->field_requestedNewQoS.log_match(match_value.requestedNewQoS(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_requestedNewQoS.log();
if (single_value->field_requestedNewQoS.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", newTFT := ");
if (match_value.newTFT().ispresent()) {
single_value->field_newTFT.log_match(match_value.newTFT(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_newTFT.log();
if (single_value->field_newTFT.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", deviceProperties := ");
if (match_value.deviceProperties().ispresent()) {
single_value->field_deviceProperties.log_match(match_value.deviceProperties(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deviceProperties.log();
if (single_value->field_deviceProperties.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!requestedLLC__SAPI().is_bound()) requestedLLC__SAPI() = OMIT_VALUE;
else requestedLLC__SAPI().set_implicit_omit();
if (!requestedNewQoS().is_bound()) requestedNewQoS() = OMIT_VALUE;
else requestedNewQoS().set_implicit_omit();
if (!newTFT().is_bound()) newTFT() = OMIT_VALUE;
else newTFT().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!deviceProperties().is_bound()) deviceProperties() = OMIT_VALUE;
else deviceProperties().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_requestedLLC__SAPI.encode_text(text_buf);
single_value->field_requestedNewQoS.encode_text(text_buf);
single_value->field_newTFT.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_deviceProperties.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
}
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_requestedLLC__SAPI.decode_text(text_buf);
single_value->field_requestedNewQoS.decode_text(text_buf);
single_value->field_newTFT.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_deviceProperties.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN.");
}
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ModifyPDPContextRequest__MS__SGSN_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) requestedLLC__SAPI().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedNewQoS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) newTFT().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) deviceProperties().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNewQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNewQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deviceProperties")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deviceProperties().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ModifyPDPContextRequest__MS__SGSN_template* precondition = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ModifyPDPContextRequest__MS__SGSN_template* implied_template = new PDU__SM__ModifyPDPContextRequest__MS__SGSN_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ModifyPDPContextRequest__MS__SGSN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_requestedLLC__SAPI.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_requestedNewQoS.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_newTFT.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_deviceProperties.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextRequest_MS_SGSN");
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ModifyPDPContextRequest__MS__SGSN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN::PDU__SM__ModifyPDPContextAccept__MS__SGSN()
{
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN::PDU__SM__ModifyPDPContextAccept__MS__SGSN(const BITSTRING& par_messageType,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN::PDU__SM__ModifyPDPContextAccept__MS__SGSN(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::clean_up()
{
field_messageType.clean_up();
field_protocolConfigOpts.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ModifyPDPContextAccept__MS__SGSN::get_descriptor() const { return &PDU__SM__ModifyPDPContextAccept__MS__SGSN_descr_; }
PDU__SM__ModifyPDPContextAccept__MS__SGSN& PDU__SM__ModifyPDPContextAccept__MS__SGSN::operator=(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN::operator==(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ModifyPDPContextAccept__MS__SGSN::size_of() const
{
  int ret_val = 1;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
  }
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ModifyPDPContextAccept__MS__SGSN::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_61) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ModifyPDPContextAccept__MS__SGSN::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  bs_61) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_61.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::single_value_struct {
BITSTRING_template field_messageType;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::copy_value(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::copy_template(const PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
break;
}
set_selection(other_value);
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template()
{
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value)
{
copy_value(other_value);
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(const OPTIONAL<PDU__SM__ModifyPDPContextAccept__MS__SGSN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextAccept__MS__SGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN from an unbound optional field.");
}
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(PDU__SM__ModifyPDPContextAccept__MS__SGSN_template* p_precondition, PDU__SM__ModifyPDPContextAccept__MS__SGSN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(Dynamic_Match_Interface<PDU__SM__ModifyPDPContextAccept__MS__SGSN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SM__ModifyPDPContextAccept__MS__SGSN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(const PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::~PDU__SM__ModifyPDPContextAccept__MS__SGSN_template()
{
clean_up();
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::operator=(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::operator=(const OPTIONAL<PDU__SM__ModifyPDPContextAccept__MS__SGSN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SM__ModifyPDPContextAccept__MS__SGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
}
return *this;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::operator=(const PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::match(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.protocolConfigOpts().is_bound()) return FALSE;
if((other_value.protocolConfigOpts().ispresent() ? !single_value->field_protocolConfigOpts.match((const ProtocolConfigOptionsTLV&)other_value.protocolConfigOpts(), legacy) : !single_value->field_protocolConfigOpts.match_omit(legacy)))return FALSE;
if(!other_value.nBIFOM__Container().is_bound()) return FALSE;
if((other_value.nBIFOM__Container().ispresent() ? !single_value->field_nBIFOM__Container.match((const NBIFOM__ContainerTLV&)other_value.nBIFOM__Container(), legacy) : !single_value->field_nBIFOM__Container.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
}
return FALSE;
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_bound())
 || (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_bound());
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_protocolConfigOpts.is_omit() || single_value->field_protocolConfigOpts.is_value())
 && (single_value->field_nBIFOM__Container.is_omit() || single_value->field_nBIFOM__Container.is_value());
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
PDU__SM__ModifyPDPContextAccept__MS__SGSN ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_protocolConfigOpts.is_omit()) ret_val.protocolConfigOpts() = OMIT_VALUE;
else if (single_value->field_protocolConfigOpts.is_bound()) {
ret_val.protocolConfigOpts() = single_value->field_protocolConfigOpts.valueof();
}
if (single_value->field_nBIFOM__Container.is_omit()) ret_val.nBIFOM__Container() = OMIT_VALUE;
else if (single_value->field_nBIFOM__Container.is_bound()) {
ret_val.nBIFOM__Container() = single_value->field_nBIFOM__Container.valueof();
}
return ret_val;
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template[list_length];
}

PDU__SM__ModifyPDPContextAccept__MS__SGSN_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
return single_value->field_messageType;
}

ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::protocolConfigOpts()
{
set_specific();
return single_value->field_protocolConfigOpts;
}

const ProtocolConfigOptionsTLV_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::protocolConfigOpts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOpts of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
return single_value->field_protocolConfigOpts;
}

NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::nBIFOM__Container()
{
set_specific();
return single_value->field_nBIFOM__Container;
}

const NBIFOM__ContainerTLV_template& PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::nBIFOM__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nBIFOM_Container of a non-specific template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
return single_value->field_nBIFOM__Container;
}

int PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_protocolConfigOpts.is_present()) ret_val++;
      if (single_value->field_nBIFOM__Container.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
  }
  return 0;
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::log_match(const PDU__SM__ModifyPDPContextAccept__MS__SGSN& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolConfigOpts().ispresent()){
if(!single_value->field_protocolConfigOpts.match(match_value.protocolConfigOpts(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOpts");
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolConfigOpts.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolConfigOpts := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nBIFOM__Container().ispresent()){
if(!single_value->field_nBIFOM__Container.match(match_value.nBIFOM__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".nBIFOM_Container");
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nBIFOM__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nBIFOM_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
if (match_value.protocolConfigOpts().ispresent()) {
single_value->field_protocolConfigOpts.log_match(match_value.protocolConfigOpts(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolConfigOpts.log();
if (single_value->field_protocolConfigOpts.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
if (match_value.nBIFOM__Container().ispresent()) {
single_value->field_nBIFOM__Container.log_match(match_value.nBIFOM__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nBIFOM__Container.log();
if (single_value->field_nBIFOM__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_protocolConfigOpts.encode_text(text_buf);
single_value->field_nBIFOM__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
}
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_protocolConfigOpts.decode_text(text_buf);
single_value->field_nBIFOM__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN.");
}
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SM__ModifyPDPContextAccept__MS__SGSN_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SM__ModifyPDPContextAccept__MS__SGSN_template* precondition = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SM__ModifyPDPContextAccept__MS__SGSN_template* implied_template = new PDU__SM__ModifyPDPContextAccept__MS__SGSN_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SM__ModifyPDPContextAccept__MS__SGSN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
single_value->field_protocolConfigOpts.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
single_value->field_nBIFOM__Container.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_MS_SGSN");
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SM__ModifyPDPContextAccept__MS__SGSN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SM__ModifyPDPContextAccept__SGSN__MS::PDU__SM__ModifyPDPContextAccept__SGSN__MS()
{
}

PDU__SM__ModifyPDPContextAccept__SGSN__MS::PDU__SM__ModifyPDPContextAccept__SGSN__MS(const BITSTRING& par_messageType,
    const OPTIONAL< QoSTLV >& par_negotiatedQoS,
    const OPTIONAL< LLC__SAPITV >& par_negotiatedLLC__SAPI,
    const OPTIONAL< RadioPriorityTV >& par_newRadioPriority,
    const OPTIONAL< PacketFlowIDTLV >& par_packetFlowIdentifier,
    const OPTIONAL< ProtocolConfigOptionsTLV >& par_protocolConfigOpts,
    const OPTIONAL< WLANOffloadAcceptabilityTV >& par_wLANOffloadIndication,
    const OPTIONAL< NBIFOM__ContainerTLV >& par_nBIFOM__Container)
  :   field_messageType(par_messageType),
  field_negotiatedQoS(par_negotiatedQoS),
  field_negotiatedLLC__SAPI(par_negotiatedLLC__SAPI),
  field_newRadioPriority(par_newRadioPriority),
  field_packetFlowIdentifier(par_packetFlowIdentifier),
  field_protocolConfigOpts(par_protocolConfigOpts),
  field_wLANOffloadIndication(par_wLANOffloadIndication),
  field_nBIFOM__Container(par_nBIFOM__Container)
{
}

PDU__SM__ModifyPDPContextAccept__SGSN__MS::PDU__SM__ModifyPDPContextAccept__SGSN__MS(const PDU__SM__ModifyPDPContextAccept__SGSN__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
else field_negotiatedQoS.clean_up();
if (other_value.negotiatedLLC__SAPI().is_bound()) field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
else field_negotiatedLLC__SAPI.clean_up();
if (other_value.newRadioPriority().is_bound()) field_newRadioPriority = other_value.newRadioPriority();
else field_newRadioPriority.clean_up();
if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
else field_packetFlowIdentifier.clean_up();
if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
else field_protocolConfigOpts.clean_up();
if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
else field_wLANOffloadIndication.clean_up();
if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
else field_nBIFOM__Container.clean_up();
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::clean_up()
{
field_messageType.clean_up();
field_negotiatedQoS.clean_up();
field_negotiatedLLC__SAPI.clean_up();
field_newRadioPriority.clean_up();
field_packetFlowIdentifier.clean_up();
field_protocolConfigOpts.clean_up();
field_wLANOffloadIndication.clean_up();
field_nBIFOM__Container.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SM__ModifyPDPContextAccept__SGSN__MS::get_descriptor() const { return &PDU__SM__ModifyPDPContextAccept__SGSN__MS_descr_; }
PDU__SM__ModifyPDPContextAccept__SGSN__MS& PDU__SM__ModifyPDPContextAccept__SGSN__MS::operator=(const PDU__SM__ModifyPDPContextAccept__SGSN__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.negotiatedQoS().is_bound()) field_negotiatedQoS = other_value.negotiatedQoS();
  else field_negotiatedQoS.clean_up();
  if (other_value.negotiatedLLC__SAPI().is_bound()) field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
  else field_negotiatedLLC__SAPI.clean_up();
  if (other_value.newRadioPriority().is_bound()) field_newRadioPriority = other_value.newRadioPriority();
  else field_newRadioPriority.clean_up();
  if (other_value.packetFlowIdentifier().is_bound()) field_packetFlowIdentifier = other_value.packetFlowIdentifier();
  else field_packetFlowIdentifier.clean_up();
  if (other_value.protocolConfigOpts().is_bound()) field_protocolConfigOpts = other_value.protocolConfigOpts();
  else field_protocolConfigOpts.clean_up();
  if (other_value.wLANOffloadIndication().is_bound()) field_wLANOffloadIndication = other_value.wLANOffloadIndication();
  else field_wLANOffloadIndication.clean_up();
  if (other_value.nBIFOM__Container().is_bound()) field_nBIFOM__Container = other_value.nBIFOM__Container();
  else field_nBIFOM__Container.clean_up();
}
return *this;
}

boolean PDU__SM__ModifyPDPContextAccept__SGSN__MS::operator==(const PDU__SM__ModifyPDPContextAccept__SGSN__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_negotiatedQoS==other_value.field_negotiatedQoS
  && field_negotiatedLLC__SAPI==other_value.field_negotiatedLLC__SAPI
  && field_newRadioPriority==other_value.field_newRadioPriority
  && field_packetFlowIdentifier==other_value.field_packetFlowIdentifier
  && field_protocolConfigOpts==other_value.field_protocolConfigOpts
  && field_wLANOffloadIndication==other_value.field_wLANOffloadIndication
  && field_nBIFOM__Container==other_value.field_nBIFOM__Container;
}

boolean PDU__SM__ModifyPDPContextAccept__SGSN__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_negotiatedQoS.get_selection() || field_negotiatedQoS.is_bound())
  || (OPTIONAL_OMIT == field_negotiatedLLC__SAPI.get_selection() || field_negotiatedLLC__SAPI.is_bound())
  || (OPTIONAL_OMIT == field_newRadioPriority.get_selection() || field_newRadioPriority.is_bound())
  || (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_bound())
  || (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_bound())
  || (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_bound());
}
boolean PDU__SM__ModifyPDPContextAccept__SGSN__MS::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_negotiatedQoS.get_selection() || field_negotiatedQoS.is_value())
  && (OPTIONAL_OMIT == field_negotiatedLLC__SAPI.get_selection() || field_negotiatedLLC__SAPI.is_value())
  && (OPTIONAL_OMIT == field_newRadioPriority.get_selection() || field_newRadioPriority.is_value())
  && (OPTIONAL_OMIT == field_packetFlowIdentifier.get_selection() || field_packetFlowIdentifier.is_value())
  && (OPTIONAL_OMIT == field_protocolConfigOpts.get_selection() || field_protocolConfigOpts.is_value())
  && (OPTIONAL_OMIT == field_wLANOffloadIndication.get_selection() || field_wLANOffloadIndication.is_value())
  && (OPTIONAL_OMIT == field_nBIFOM__Container.get_selection() || field_nBIFOM__Container.is_value());
}
int PDU__SM__ModifyPDPContextAccept__SGSN__MS::size_of() const
{
  int ret_val = 1;
  if (field_negotiatedQoS.ispresent()) ret_val++;
  if (field_negotiatedLLC__SAPI.ispresent()) ret_val++;
  if (field_newRadioPriority.ispresent()) ret_val++;
  if (field_packetFlowIdentifier.ispresent()) ret_val++;
  if (field_protocolConfigOpts.ispresent()) ret_val++;
  if (field_wLANOffloadIndication.ispresent()) ret_val++;
  if (field_nBIFOM__Container.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", negotiatedQoS := ");
field_negotiatedQoS.log();
TTCN_Logger::log_event_str(", negotiatedLLC_SAPI := ");
field_negotiatedLLC__SAPI.log();
TTCN_Logger::log_event_str(", newRadioPriority := ");
field_newRadioPriority.log();
TTCN_Logger::log_event_str(", packetFlowIdentifier := ");
field_packetFlowIdentifier.log();
TTCN_Logger::log_event_str(", protocolConfigOpts := ");
field_protocolConfigOpts.log();
TTCN_Logger::log_event_str(", wLANOffloadIndication := ");
field_wLANOffloadIndication.log();
TTCN_Logger::log_event_str(", nBIFOM_Container := ");
field_nBIFOM__Container.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!negotiatedQoS().is_bound()) negotiatedQoS() = OMIT_VALUE;
else negotiatedQoS().set_implicit_omit();
if (!negotiatedLLC__SAPI().is_bound()) negotiatedLLC__SAPI() = OMIT_VALUE;
else negotiatedLLC__SAPI().set_implicit_omit();
if (!newRadioPriority().is_bound()) newRadioPriority() = OMIT_VALUE;
else newRadioPriority().set_implicit_omit();
if (!packetFlowIdentifier().is_bound()) packetFlowIdentifier() = OMIT_VALUE;
else packetFlowIdentifier().set_implicit_omit();
if (!protocolConfigOpts().is_bound()) protocolConfigOpts() = OMIT_VALUE;
else protocolConfigOpts().set_implicit_omit();
if (!wLANOffloadIndication().is_bound()) wLANOffloadIndication() = OMIT_VALUE;
else wLANOffloadIndication().set_implicit_omit();
if (!nBIFOM__Container().is_bound()) nBIFOM__Container() = OMIT_VALUE;
else nBIFOM__Container().set_implicit_omit();
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) negotiatedQoS().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) negotiatedLLC__SAPI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) newRadioPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packetFlowIdentifier().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOpts().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) wLANOffloadIndication().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) nBIFOM__Container().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedQoS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedQoS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "negotiatedLLC_SAPI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          negotiatedLLC__SAPI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newRadioPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newRadioPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFlowIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFlowIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOpts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOpts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "wLANOffloadIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          wLANOffloadIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nBIFOM_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nBIFOM__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS");
  }
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_negotiatedQoS.encode_text(text_buf);
field_negotiatedLLC__SAPI.encode_text(text_buf);
field_newRadioPriority.encode_text(text_buf);
field_packetFlowIdentifier.encode_text(text_buf);
field_protocolConfigOpts.encode_text(text_buf);
field_wLANOffloadIndication.encode_text(text_buf);
field_nBIFOM__Container.encode_text(text_buf);
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_negotiatedQoS.decode_text(text_buf);
field_negotiatedLLC__SAPI.decode_text(text_buf);
field_newRadioPriority.decode_text(text_buf);
field_packetFlowIdentifier.decode_text(text_buf);
field_protocolConfigOpts.decode_text(text_buf);
field_wLANOffloadIndication.decode_text(text_buf);
field_nBIFOM__Container.decode_text(text_buf);
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SM__ModifyPDPContextAccept__SGSN__MS::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT8_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_negotiatedQoS = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, QoSTLV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedQoS().RAW_decode(QoSTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_negotiatedQoS = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_negotiatedQoS=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_negotiatedLLC__SAPI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, LLC__SAPITV_descr_.raw->forceomit);
  decoded_field_length = field_negotiatedLLC__SAPI().RAW_decode(LLC__SAPITV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_negotiatedLLC__SAPI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_negotiatedLLC__SAPI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_newRadioPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, RadioPriorityTV_descr_.raw->forceomit);
  decoded_field_length = field_newRadioPriority().RAW_decode(RadioPriorityTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_newRadioPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_newRadioPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_packetFlowIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PacketFlowIDTLV_descr_.raw->forceomit);
  decoded_field_length = field_packetFlowIdentifier().RAW_decode(PacketFlowIDTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_packetFlowIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_packetFlowIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_protocolConfigOpts = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, ProtocolConfigOptionsTLV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOpts().RAW_decode(ProtocolConfigOptionsTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_protocolConfigOpts = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolConfigOpts=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_wLANOffloadIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, WLANOffloadAcceptabilityTV_descr_.raw->forceomit);
  decoded_field_length = field_wLANOffloadIndication().RAW_decode(WLANOffloadAcceptabilityTV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_wLANOffloadIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_wLANOffloadIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_nBIFOM__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, NBIFOM__ContainerTLV_descr_.raw->forceomit);
  decoded_field_length = field_nBIFOM__Container().RAW_decode(NBIFOM__ContainerTLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_nBIFOM__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nBIFOM__Container=OMIT_VALUE;
  if (field_messageType !=  bs_62) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SM__ModifyPDPContextAccept__SGSN__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT8_descr_.raw);
  if (field_negotiatedQoS.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, QoSTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_negotiatedLLC__SAPI.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, LLC__SAPITV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_newRadioPriority.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RadioPriorityTV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_packetFlowIdentifier.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PacketFlowIDTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_protocolConfigOpts.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, ProtocolConfigOptionsTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_wLANOffloadIndication.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, WLANOffloadAcceptabilityTV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_nBIFOM__Container.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, NBIFOM__ContainerTLV_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[0]);
  if (field_negotiatedQoS.ispresent()) {
  encoded_length += field_negotiatedQoS().RAW_encode(QoSTLV_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_negotiatedLLC__SAPI.ispresent()) {
  encoded_length += field_negotiatedLLC__SAPI().RAW_encode(LLC__SAPITV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_newRadioPriority.ispresent()) {
  encoded_length += field_newRadioPriority().RAW_encode(RadioPriorityTV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_packetFlowIdentifier.ispresent()) {
  encoded_length += field_packetFlowIdentifier().RAW_encode(PacketFlowIDTLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_protocolConfigOpts.ispresent()) {
  encoded_length += field_protocolConfigOpts().RAW_encode(ProtocolConfigOptionsTLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_wLANOffloadIndication.ispresent()) {
  encoded_length += field_wLANOffloadIndication().RAW_encode(WLANOffloadAcceptabilityTV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_nBIFOM__Container.ispresent()) {
  encoded_length += field_nBIFOM__Container().RAW_encode(NBIFOM__ContainerTLV_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_messageType !=  bs_62) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_62.RAW_encode(General__Types::BIT8_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::single_value_struct {
BITSTRING_template field_messageType;
QoSTLV_template field_negotiatedQoS;
LLC__SAPITV_template field_negotiatedLLC__SAPI;
RadioPriorityTV_template field_newRadioPriority;
PacketFlowIDTLV_template field_packetFlowIdentifier;
ProtocolConfigOptionsTLV_template field_protocolConfigOpts;
WLANOffloadAcceptabilityTV_template field_wLANOffloadIndication;
NBIFOM__ContainerTLV_template field_nBIFOM__Container;
};

void PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_negotiatedQoS = ANY_OR_OMIT;
single_value->field_negotiatedLLC__SAPI = ANY_OR_OMIT;
single_value->field_newRadioPriority = ANY_OR_OMIT;
single_value->field_packetFlowIdentifier = ANY_OR_OMIT;
single_value->field_protocolConfigOpts = ANY_OR_OMIT;
single_value->field_wLANOffloadIndication = ANY_OR_OMIT;
single_value->field_nBIFOM__Container = ANY_OR_OMIT;
}
}
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::copy_value(const PDU__SM__ModifyPDPContextAccept__SGSN__MS& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.negotiatedQoS().is_bound()) {
  if (other_value.negotiatedQoS().ispresent()) single_value->field_negotiatedQoS = other_value.negotiatedQoS()();
  else single_value->field_negotiatedQoS = OMIT_VALUE;
} else {
  single_value->field_negotiatedQoS.clean_up();
}
if (other_value.negotiatedLLC__SAPI().is_bound()) {
  if (other_value.negotiatedLLC__SAPI().ispresent()) single_value->field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI()();
  else single_value->field_negotiatedLLC__SAPI = OMIT_VALUE;
} else {
  single_value->field_negotiatedLLC__SAPI.clean_up();
}
if (other_value.newRadioPriority().is_bound()) {
  if (other_value.newRadioPriority().ispresent()) single_value->field_newRadioPriority = other_value.newRadioPriority()();
  else single_value->field_newRadioPriority = OMIT_VALUE;
} else {
  single_value->field_newRadioPriority.clean_up();
}
if (other_value.packetFlowIdentifier().is_bound()) {
  if (other_value.packetFlowIdentifier().ispresent()) single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier()();
  else single_value->field_packetFlowIdentifier = OMIT_VALUE;
} else {
  single_value->field_packetFlowIdentifier.clean_up();
}
if (other_value.protocolConfigOpts().is_bound()) {
  if (other_value.protocolConfigOpts().ispresent()) single_value->field_protocolConfigOpts = other_value.protocolConfigOpts()();
  else single_value->field_protocolConfigOpts = OMIT_VALUE;
} else {
  single_value->field_protocolConfigOpts.clean_up();
}
if (other_value.wLANOffloadIndication().is_bound()) {
  if (other_value.wLANOffloadIndication().ispresent()) single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication()();
  else single_value->field_wLANOffloadIndication = OMIT_VALUE;
} else {
  single_value->field_wLANOffloadIndication.clean_up();
}
if (other_value.nBIFOM__Container().is_bound()) {
  if (other_value.nBIFOM__Container().ispresent()) single_value->field_nBIFOM__Container = other_value.nBIFOM__Container()();
  else single_value->field_nBIFOM__Container = OMIT_VALUE;
} else {
  single_value->field_nBIFOM__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::copy_template(const PDU__SM__ModifyPDPContextAccept__SGSN__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedQoS().get_selection()) {
single_value->field_negotiatedQoS = other_value.negotiatedQoS();
} else {
single_value->field_negotiatedQoS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.negotiatedLLC__SAPI().get_selection()) {
single_value->field_negotiatedLLC__SAPI = other_value.negotiatedLLC__SAPI();
} else {
single_value->field_negotiatedLLC__SAPI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.newRadioPriority().get_selection()) {
single_value->field_newRadioPriority = other_value.newRadioPriority();
} else {
single_value->field_newRadioPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFlowIdentifier().get_selection()) {
single_value->field_packetFlowIdentifier = other_value.packetFlowIdentifier();
} else {
single_value->field_packetFlowIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOpts().get_selection()) {
single_value->field_protocolConfigOpts = other_value.protocolConfigOpts();
} else {
single_value->field_protocolConfigOpts.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.wLANOffloadIndication().get_selection()) {
single_value->field_wLANOffloadIndication = other_value.wLANOffloadIndication();
} else {
single_value->field_wLANOffloadIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nBIFOM__Container().get_selection()) {
single_value->field_nBIFOM__Container = other_value.nBIFOM__Container();
} else {
single_value->field_nBIFOM__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SM__ModifyPDPContextAccept__SGSN__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SM__ModifyPDPContextAccept__SGSN__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SM__ModifyPDPContextAccept__SGSN__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDU_SM_ModifyPDPContextAccept_SGSN_MS.");
break;
}
set_selection(other_value);
}

PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::PDU__SM__ModifyPDPContextAccept__SGSN__MS_template()
{
}

PDU__SM__ModifyPDPContextAccept__SGSN__MS_template::PDU__SM__ModifyPDPContextAccept_