// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MAP_MS_DataTypes.hh"

namespace MAP__MS__DataTypes {

/* Member functions of C++ classes */

FailureReportArg::FailureReportArg()
{
}

FailureReportArg::FailureReportArg(const OCTETSTRING& par_imsi,
    const OCTETSTRING& par_ggsn__Number,
    const OPTIONAL< OCTETSTRING >& par_ggsn__Address,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_imsi(par_imsi),
  field_ggsn__Number(par_ggsn__Number),
  field_ggsn__Address(par_ggsn__Address),
  field_extensionContainer(par_extensionContainer)
{
}

FailureReportArg::FailureReportArg(const FailureReportArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.FailureReportArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.ggsn__Number().is_bound()) field_ggsn__Number = other_value.ggsn__Number();
else field_ggsn__Number.clean_up();
if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
else field_ggsn__Address.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void FailureReportArg::clean_up()
{
field_imsi.clean_up();
field_ggsn__Number.clean_up();
field_ggsn__Address.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* FailureReportArg::get_descriptor() const { return &FailureReportArg_descr_; }
FailureReportArg& FailureReportArg::operator=(const FailureReportArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.FailureReportArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.ggsn__Number().is_bound()) field_ggsn__Number = other_value.ggsn__Number();
  else field_ggsn__Number.clean_up();
  if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
  else field_ggsn__Address.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean FailureReportArg::operator==(const FailureReportArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_ggsn__Number==other_value.field_ggsn__Number
  && field_ggsn__Address==other_value.field_ggsn__Address
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean FailureReportArg::is_bound() const
{
return (field_imsi.is_bound())
  || (field_ggsn__Number.is_bound())
  || (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean FailureReportArg::is_value() const
{
return field_imsi.is_value()
  && field_ggsn__Number.is_value()
  && (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int FailureReportArg::size_of() const
{
  int ret_val = 2;
  if (field_ggsn__Address.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void FailureReportArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", ggsn_Number := ");
field_ggsn__Number.log();
TTCN_Logger::log_event_str(", ggsn_Address := ");
field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void FailureReportArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (ggsn__Number().is_bound()) ggsn__Number().set_implicit_omit();
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void FailureReportArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.FailureReportArg has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ggsn__Number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.FailureReportArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.FailureReportArg");
  }
}

void FailureReportArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_ggsn__Number.encode_text(text_buf);
field_ggsn__Address.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void FailureReportArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_ggsn__Number.decode_text(text_buf);
field_ggsn__Address.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void FailureReportArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void FailureReportArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* FailureReportArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(FailureReportArg_imsi_descr_, p_coding));
  ec_1.set_msg("ggsn_Number': ");
  new_tlv->add_TLV(field_ggsn__Number.BER_encode_TLV(FailureReportArg_ggsn__Number_descr_, p_coding));
  ec_1.set_msg("ggsn_Address': ");
  new_tlv->add_TLV(field_ggsn__Address.BER_encode_TLV(FailureReportArg_ggsn__Address_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(FailureReportArg_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean FailureReportArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.FailureReportArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(FailureReportArg_imsi_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ggsn_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ggsn__Number.BER_decode_TLV(FailureReportArg_ggsn__Number_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ggsn_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ggsn__Address=OMIT_VALUE;
    else {
      field_ggsn__Address.BER_decode_TLV(FailureReportArg_ggsn__Address_descr_, tmp_tlv, L_form);
      if(field_ggsn__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(FailureReportArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int FailureReportArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.FailureReportArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(FailureReportArg_imsi_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ggsn_Number");
    enc_len += field_ggsn__Number.JSON_encode(FailureReportArg_ggsn__Number_descr_, p_tok, FALSE);
  }

  if (field_ggsn__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ggsn_Address");
    enc_len += field_ggsn__Address.JSON_encode(FailureReportArg_ggsn__Address_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(FailureReportArg_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int FailureReportArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const FailureReportArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean ggsn__Number_found = FALSE;
  boolean ggsn__Address_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(FailureReportArg_imsi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "ggsn_Number", name_len)) {
        ggsn__Number_found = TRUE;
         int ret_val = field_ggsn__Number.JSON_decode(FailureReportArg_ggsn__Number_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "ggsn_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "ggsn_Address", name_len)) {
        ggsn__Address_found = TRUE;
         int ret_val = field_ggsn__Address.JSON_decode(FailureReportArg_ggsn__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "ggsn_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(FailureReportArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!ggsn__Number_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ggsn_Number");
    return JSON_ERROR_FATAL;
  }
  if (!ggsn__Address_found) {
    field_ggsn__Address = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int FailureReportArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_ggsn__Address.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(FailureReportArg_imsi_descr_, p_buf);
  field_ggsn__Number.OER_encode(FailureReportArg_ggsn__Number_descr_, p_buf);
  if (field_ggsn__Address.is_present())
    field_ggsn__Address.OER_encode(FailureReportArg_ggsn__Address_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(FailureReportArg_extensionContainer_descr_, p_buf);
  return 0;
}

int FailureReportArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(FailureReportArg_imsi_descr_, p_buf, p_oer);
  field_ggsn__Number.OER_decode(FailureReportArg_ggsn__Number_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_ggsn__Address.OER_decode(FailureReportArg_ggsn__Address_descr_, p_buf, p_oer);
 else
    field_ggsn__Address = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(FailureReportArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void FailureReportArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_ggsn__Address_present = field_ggsn__Address.is_present();
p_buf.PER_put_bit(field_ggsn__Address_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(FailureReportArg_imsi_descr_, p_buf, p_options);
field_ggsn__Number.PER_encode(FailureReportArg_ggsn__Number_descr_, p_buf, p_options);
if (field_ggsn__Address_present) field_ggsn__Address.PER_encode(FailureReportArg_ggsn__Address_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(FailureReportArg_extensionContainer_descr_, p_buf, p_options);
}

void FailureReportArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_ggsn__Address_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(FailureReportArg_imsi_descr_, p_buf, p_options);
field_ggsn__Number.PER_decode(FailureReportArg_ggsn__Number_descr_, p_buf, p_options);
if (field_ggsn__Address_present) field_ggsn__Address.PER_decode(FailureReportArg_ggsn__Address_descr_, p_buf, p_options);
else field_ggsn__Address = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(FailureReportArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct FailureReportArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
OCTETSTRING_template field_ggsn__Number;
OCTETSTRING_template field_ggsn__Address;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void FailureReportArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_ggsn__Number = ANY_VALUE;
single_value->field_ggsn__Address = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void FailureReportArg_template::copy_value(const FailureReportArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.ggsn__Number().is_bound()) {
  single_value->field_ggsn__Number = other_value.ggsn__Number();
} else {
  single_value->field_ggsn__Number.clean_up();
}
if (other_value.ggsn__Address().is_bound()) {
  if (other_value.ggsn__Address().ispresent()) single_value->field_ggsn__Address = other_value.ggsn__Address()();
  else single_value->field_ggsn__Address = OMIT_VALUE;
} else {
  single_value->field_ggsn__Address.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void FailureReportArg_template::copy_template(const FailureReportArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__Number().get_selection()) {
single_value->field_ggsn__Number = other_value.ggsn__Number();
} else {
single_value->field_ggsn__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__Address().get_selection()) {
single_value->field_ggsn__Address = other_value.ggsn__Address();
} else {
single_value->field_ggsn__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new FailureReportArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new FailureReportArg_template(*other_value.implication_.precondition);
implication_.implied_template = new FailureReportArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportArg.");
break;
}
set_selection(other_value);
}

FailureReportArg_template::FailureReportArg_template()
{
}

FailureReportArg_template::FailureReportArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

FailureReportArg_template::FailureReportArg_template(const FailureReportArg& other_value)
{
copy_value(other_value);
}

FailureReportArg_template::FailureReportArg_template(const OPTIONAL<FailureReportArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FailureReportArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.FailureReportArg from an unbound optional field.");
}
}

FailureReportArg_template::FailureReportArg_template(FailureReportArg_template* p_precondition, FailureReportArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

FailureReportArg_template::FailureReportArg_template(Dynamic_Match_Interface<FailureReportArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<FailureReportArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

FailureReportArg_template::FailureReportArg_template(const FailureReportArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

FailureReportArg_template::~FailureReportArg_template()
{
clean_up();
}

FailureReportArg_template& FailureReportArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

FailureReportArg_template& FailureReportArg_template::operator=(const FailureReportArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

FailureReportArg_template& FailureReportArg_template::operator=(const OPTIONAL<FailureReportArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FailureReportArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.FailureReportArg.");
}
return *this;
}

FailureReportArg_template& FailureReportArg_template::operator=(const FailureReportArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean FailureReportArg_template::match(const FailureReportArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.ggsn__Number().is_bound()) return FALSE;
if(!single_value->field_ggsn__Number.match(other_value.ggsn__Number(), legacy))return FALSE;
if(!other_value.ggsn__Address().is_bound()) return FALSE;
if((other_value.ggsn__Address().ispresent() ? !single_value->field_ggsn__Address.match((const OCTETSTRING&)other_value.ggsn__Address(), legacy) : !single_value->field_ggsn__Address.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportArg.");
}
return FALSE;
}

boolean FailureReportArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || single_value->field_ggsn__Number.is_bound()
 || (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean FailureReportArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && single_value->field_ggsn__Number.is_value()
 && (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void FailureReportArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

FailureReportArg FailureReportArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.FailureReportArg.");
FailureReportArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_ggsn__Number.is_bound()) {
ret_val.ggsn__Number() = single_value->field_ggsn__Number.valueof();
}
if (single_value->field_ggsn__Address.is_omit()) ret_val.ggsn__Address() = OMIT_VALUE;
else if (single_value->field_ggsn__Address.is_bound()) {
ret_val.ggsn__Address() = single_value->field_ggsn__Address.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void FailureReportArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.FailureReportArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new FailureReportArg_template[list_length];
}

FailureReportArg_template& FailureReportArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.FailureReportArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.FailureReportArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& FailureReportArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& FailureReportArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.FailureReportArg.");
return single_value->field_imsi;
}

OCTETSTRING_template& FailureReportArg_template::ggsn__Number()
{
set_specific();
return single_value->field_ggsn__Number;
}

const OCTETSTRING_template& FailureReportArg_template::ggsn__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_Number of a non-specific template of type @MAP-MS-DataTypes.FailureReportArg.");
return single_value->field_ggsn__Number;
}

OCTETSTRING_template& FailureReportArg_template::ggsn__Address()
{
set_specific();
return single_value->field_ggsn__Address;
}

const OCTETSTRING_template& FailureReportArg_template::ggsn__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_Address of a non-specific template of type @MAP-MS-DataTypes.FailureReportArg.");
return single_value->field_ggsn__Address;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& FailureReportArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& FailureReportArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.FailureReportArg.");
return single_value->field_extensionContainer;
}

int FailureReportArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_ggsn__Address.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportArg.");
  }
  return 0;
}

void FailureReportArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", ggsn_Number := ");
single_value->field_ggsn__Number.log();
TTCN_Logger::log_event_str(", ggsn_Address := ");
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void FailureReportArg_template::log_match(const FailureReportArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ggsn__Number.match(match_value.ggsn__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_Number");
single_value->field_ggsn__Number.log_match(match_value.ggsn__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ggsn__Address().ispresent()){
if(!single_value->field_ggsn__Address.match(match_value.ggsn__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_Address");
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ggsn__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ggsn_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", ggsn_Number := ");
single_value->field_ggsn__Number.log_match(match_value.ggsn__Number(), legacy);
TTCN_Logger::log_event_str(", ggsn_Address := ");
if (match_value.ggsn__Address().ispresent()) {
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ggsn__Address.log();
if (single_value->field_ggsn__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void FailureReportArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (ggsn__Number().is_bound()) ggsn__Number().set_implicit_omit();
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void FailureReportArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_ggsn__Number.encode_text(text_buf);
single_value->field_ggsn__Address.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportArg.");
}
}

void FailureReportArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_ggsn__Number.decode_text(text_buf);
single_value->field_ggsn__Address.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new FailureReportArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.FailureReportArg.");
}
}

void FailureReportArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    FailureReportArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.FailureReportArg has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ggsn__Number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.FailureReportArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    FailureReportArg_template* precondition = new FailureReportArg_template;
    precondition->set_param(*param.get_elem(0));
    FailureReportArg_template* implied_template = new FailureReportArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = FailureReportArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.FailureReportArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void FailureReportArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportArg");
single_value->field_ggsn__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportArg");
single_value->field_ggsn__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.FailureReportArg");
}

boolean FailureReportArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean FailureReportArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

FailureReportRes::FailureReportRes()
{
}

FailureReportRes::FailureReportRes(const OPTIONAL< OCTETSTRING >& par_ggsn__Address,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_ggsn__Address(par_ggsn__Address),
  field_extensionContainer(par_extensionContainer)
{
}

FailureReportRes::FailureReportRes(const FailureReportRes& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.FailureReportRes.");
if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
else field_ggsn__Address.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void FailureReportRes::clean_up()
{
field_ggsn__Address.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* FailureReportRes::get_descriptor() const { return &FailureReportRes_descr_; }
FailureReportRes& FailureReportRes::operator=(const FailureReportRes& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.FailureReportRes.");
  if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
  else field_ggsn__Address.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean FailureReportRes::operator==(const FailureReportRes& other_value) const
{
return field_ggsn__Address==other_value.field_ggsn__Address
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean FailureReportRes::is_bound() const
{
return (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean FailureReportRes::is_value() const
{
return (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int FailureReportRes::size_of() const
{
  int ret_val = 0;
  if (field_ggsn__Address.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void FailureReportRes::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ggsn_Address := ");
field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void FailureReportRes::set_implicit_omit()
{
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void FailureReportRes::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.FailureReportRes has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.FailureReportRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.FailureReportRes");
  }
}

void FailureReportRes::encode_text(Text_Buf& text_buf) const
{
field_ggsn__Address.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void FailureReportRes::decode_text(Text_Buf& text_buf)
{
field_ggsn__Address.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void FailureReportRes::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void FailureReportRes::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* FailureReportRes::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ggsn_Address': ");
  new_tlv->add_TLV(field_ggsn__Address.BER_encode_TLV(FailureReportRes_ggsn__Address_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(FailureReportRes_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean FailureReportRes::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.FailureReportRes' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ggsn_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ggsn__Address=OMIT_VALUE;
    else {
      field_ggsn__Address.BER_decode_TLV(FailureReportRes_ggsn__Address_descr_, tmp_tlv, L_form);
      if(field_ggsn__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(FailureReportRes_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int FailureReportRes::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.FailureReportRes.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_ggsn__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ggsn_Address");
    enc_len += field_ggsn__Address.JSON_encode(FailureReportRes_ggsn__Address_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(FailureReportRes_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int FailureReportRes::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const FailureReportRes*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ggsn__Address_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (12 == name_len && 0 == strncmp(fld_name, "ggsn_Address", name_len)) {
        ggsn__Address_found = TRUE;
         int ret_val = field_ggsn__Address.JSON_decode(FailureReportRes_ggsn__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "ggsn_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(FailureReportRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ggsn__Address_found) {
    field_ggsn__Address = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int FailureReportRes::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_ggsn__Address.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  if (field_ggsn__Address.is_present())
    field_ggsn__Address.OER_encode(FailureReportRes_ggsn__Address_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(FailureReportRes_extensionContainer_descr_, p_buf);
  return 0;
}

int FailureReportRes::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_ggsn__Address.OER_decode(FailureReportRes_ggsn__Address_descr_, p_buf, p_oer);
 else
    field_ggsn__Address = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(FailureReportRes_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void FailureReportRes::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_ggsn__Address_present = field_ggsn__Address.is_present();
p_buf.PER_put_bit(field_ggsn__Address_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_ggsn__Address_present) field_ggsn__Address.PER_encode(FailureReportRes_ggsn__Address_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(FailureReportRes_extensionContainer_descr_, p_buf, p_options);
}

void FailureReportRes::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_ggsn__Address_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_ggsn__Address_present) field_ggsn__Address.PER_decode(FailureReportRes_ggsn__Address_descr_, p_buf, p_options);
else field_ggsn__Address = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(FailureReportRes_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct FailureReportRes_template::single_value_struct {
OCTETSTRING_template field_ggsn__Address;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void FailureReportRes_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ggsn__Address = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void FailureReportRes_template::copy_value(const FailureReportRes& other_value)
{
single_value = new single_value_struct;
if (other_value.ggsn__Address().is_bound()) {
  if (other_value.ggsn__Address().ispresent()) single_value->field_ggsn__Address = other_value.ggsn__Address()();
  else single_value->field_ggsn__Address = OMIT_VALUE;
} else {
  single_value->field_ggsn__Address.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void FailureReportRes_template::copy_template(const FailureReportRes_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__Address().get_selection()) {
single_value->field_ggsn__Address = other_value.ggsn__Address();
} else {
single_value->field_ggsn__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new FailureReportRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new FailureReportRes_template(*other_value.implication_.precondition);
implication_.implied_template = new FailureReportRes_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportRes.");
break;
}
set_selection(other_value);
}

FailureReportRes_template::FailureReportRes_template()
{
}

FailureReportRes_template::FailureReportRes_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

FailureReportRes_template::FailureReportRes_template(const FailureReportRes& other_value)
{
copy_value(other_value);
}

FailureReportRes_template::FailureReportRes_template(const OPTIONAL<FailureReportRes>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FailureReportRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.FailureReportRes from an unbound optional field.");
}
}

FailureReportRes_template::FailureReportRes_template(FailureReportRes_template* p_precondition, FailureReportRes_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

FailureReportRes_template::FailureReportRes_template(Dynamic_Match_Interface<FailureReportRes>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<FailureReportRes>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

FailureReportRes_template::FailureReportRes_template(const FailureReportRes_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

FailureReportRes_template::~FailureReportRes_template()
{
clean_up();
}

FailureReportRes_template& FailureReportRes_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

FailureReportRes_template& FailureReportRes_template::operator=(const FailureReportRes& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

FailureReportRes_template& FailureReportRes_template::operator=(const OPTIONAL<FailureReportRes>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FailureReportRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.FailureReportRes.");
}
return *this;
}

FailureReportRes_template& FailureReportRes_template::operator=(const FailureReportRes_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean FailureReportRes_template::match(const FailureReportRes& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ggsn__Address().is_bound()) return FALSE;
if((other_value.ggsn__Address().ispresent() ? !single_value->field_ggsn__Address.match((const OCTETSTRING&)other_value.ggsn__Address(), legacy) : !single_value->field_ggsn__Address.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportRes.");
}
return FALSE;
}

boolean FailureReportRes_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean FailureReportRes_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void FailureReportRes_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

FailureReportRes FailureReportRes_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.FailureReportRes.");
FailureReportRes ret_val;
if (single_value->field_ggsn__Address.is_omit()) ret_val.ggsn__Address() = OMIT_VALUE;
else if (single_value->field_ggsn__Address.is_bound()) {
ret_val.ggsn__Address() = single_value->field_ggsn__Address.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void FailureReportRes_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.FailureReportRes.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new FailureReportRes_template[list_length];
}

FailureReportRes_template& FailureReportRes_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.FailureReportRes.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.FailureReportRes.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& FailureReportRes_template::ggsn__Address()
{
set_specific();
return single_value->field_ggsn__Address;
}

const OCTETSTRING_template& FailureReportRes_template::ggsn__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_Address of a non-specific template of type @MAP-MS-DataTypes.FailureReportRes.");
return single_value->field_ggsn__Address;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& FailureReportRes_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& FailureReportRes_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.FailureReportRes.");
return single_value->field_extensionContainer;
}

int FailureReportRes_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_ggsn__Address.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.FailureReportRes containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportRes.");
  }
  return 0;
}

void FailureReportRes_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ggsn_Address := ");
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void FailureReportRes_template::log_match(const FailureReportRes& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.ggsn__Address().ispresent()){
if(!single_value->field_ggsn__Address.match(match_value.ggsn__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_Address");
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ggsn__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ggsn_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ggsn_Address := ");
if (match_value.ggsn__Address().ispresent()) {
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ggsn__Address.log();
if (single_value->field_ggsn__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void FailureReportRes_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void FailureReportRes_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ggsn__Address.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.FailureReportRes.");
}
}

void FailureReportRes_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ggsn__Address.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new FailureReportRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.FailureReportRes.");
}
}

void FailureReportRes_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    FailureReportRes_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.FailureReportRes has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.FailureReportRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    FailureReportRes_template* precondition = new FailureReportRes_template;
    precondition->set_param(*param.get_elem(0));
    FailureReportRes_template* implied_template = new FailureReportRes_template;
    implied_template->set_param(*param.get_elem(1));
    *this = FailureReportRes_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.FailureReportRes");
  }
  is_ifpresent = param.get_ifpresent();
}

void FailureReportRes_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ggsn__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportRes");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.FailureReportRes");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.FailureReportRes");
}

boolean FailureReportRes_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean FailureReportRes_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NoteMsPresentForGprsArg::NoteMsPresentForGprsArg()
{
}

NoteMsPresentForGprsArg::NoteMsPresentForGprsArg(const OCTETSTRING& par_imsi,
    const OCTETSTRING& par_sgsn__Address,
    const OPTIONAL< OCTETSTRING >& par_ggsn__Address,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_imsi(par_imsi),
  field_sgsn__Address(par_sgsn__Address),
  field_ggsn__Address(par_ggsn__Address),
  field_extensionContainer(par_extensionContainer)
{
}

NoteMsPresentForGprsArg::NoteMsPresentForGprsArg(const NoteMsPresentForGprsArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.sgsn__Address().is_bound()) field_sgsn__Address = other_value.sgsn__Address();
else field_sgsn__Address.clean_up();
if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
else field_ggsn__Address.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void NoteMsPresentForGprsArg::clean_up()
{
field_imsi.clean_up();
field_sgsn__Address.clean_up();
field_ggsn__Address.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* NoteMsPresentForGprsArg::get_descriptor() const { return &NoteMsPresentForGprsArg_descr_; }
NoteMsPresentForGprsArg& NoteMsPresentForGprsArg::operator=(const NoteMsPresentForGprsArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.sgsn__Address().is_bound()) field_sgsn__Address = other_value.sgsn__Address();
  else field_sgsn__Address.clean_up();
  if (other_value.ggsn__Address().is_bound()) field_ggsn__Address = other_value.ggsn__Address();
  else field_ggsn__Address.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean NoteMsPresentForGprsArg::operator==(const NoteMsPresentForGprsArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_sgsn__Address==other_value.field_sgsn__Address
  && field_ggsn__Address==other_value.field_ggsn__Address
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean NoteMsPresentForGprsArg::is_bound() const
{
return (field_imsi.is_bound())
  || (field_sgsn__Address.is_bound())
  || (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean NoteMsPresentForGprsArg::is_value() const
{
return field_imsi.is_value()
  && field_sgsn__Address.is_value()
  && (OPTIONAL_OMIT == field_ggsn__Address.get_selection() || field_ggsn__Address.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int NoteMsPresentForGprsArg::size_of() const
{
  int ret_val = 2;
  if (field_ggsn__Address.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void NoteMsPresentForGprsArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", sgsn_Address := ");
field_sgsn__Address.log();
TTCN_Logger::log_event_str(", ggsn_Address := ");
field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void NoteMsPresentForGprsArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (sgsn__Address().is_bound()) sgsn__Address().set_implicit_omit();
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void NoteMsPresentForGprsArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sgsn__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.NoteMsPresentForGprsArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
  }
}

void NoteMsPresentForGprsArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_sgsn__Address.encode_text(text_buf);
field_ggsn__Address.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void NoteMsPresentForGprsArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_sgsn__Address.decode_text(text_buf);
field_ggsn__Address.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void NoteMsPresentForGprsArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NoteMsPresentForGprsArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* NoteMsPresentForGprsArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(NoteMsPresentForGprsArg_imsi_descr_, p_coding));
  ec_1.set_msg("sgsn_Address': ");
  new_tlv->add_TLV(field_sgsn__Address.BER_encode_TLV(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_coding));
  ec_1.set_msg("ggsn_Address': ");
  new_tlv->add_TLV(field_ggsn__Address.BER_encode_TLV(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(NoteMsPresentForGprsArg_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean NoteMsPresentForGprsArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.NoteMsPresentForGprsArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(NoteMsPresentForGprsArg_imsi_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("sgsn_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_sgsn__Address.BER_decode_TLV(NoteMsPresentForGprsArg_sgsn__Address_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ggsn_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ggsn__Address=OMIT_VALUE;
    else {
      field_ggsn__Address.BER_decode_TLV(NoteMsPresentForGprsArg_ggsn__Address_descr_, tmp_tlv, L_form);
      if(field_ggsn__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(NoteMsPresentForGprsArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int NoteMsPresentForGprsArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(NoteMsPresentForGprsArg_imsi_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_Address");
    enc_len += field_sgsn__Address.JSON_encode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_tok, FALSE);
  }

  if (field_ggsn__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ggsn_Address");
    enc_len += field_ggsn__Address.JSON_encode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int NoteMsPresentForGprsArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const NoteMsPresentForGprsArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean sgsn__Address_found = FALSE;
  boolean ggsn__Address_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(NoteMsPresentForGprsArg_imsi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "sgsn_Address", name_len)) {
        sgsn__Address_found = TRUE;
         int ret_val = field_sgsn__Address.JSON_decode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "sgsn_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "ggsn_Address", name_len)) {
        ggsn__Address_found = TRUE;
         int ret_val = field_ggsn__Address.JSON_decode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "ggsn_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!sgsn__Address_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "sgsn_Address");
    return JSON_ERROR_FATAL;
  }
  if (!ggsn__Address_found) {
    field_ggsn__Address = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int NoteMsPresentForGprsArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_ggsn__Address.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(NoteMsPresentForGprsArg_imsi_descr_, p_buf);
  field_sgsn__Address.OER_encode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_buf);
  if (field_ggsn__Address.is_present())
    field_ggsn__Address.OER_encode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_buf);
  return 0;
}

int NoteMsPresentForGprsArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(NoteMsPresentForGprsArg_imsi_descr_, p_buf, p_oer);
  field_sgsn__Address.OER_decode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_ggsn__Address.OER_decode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_buf, p_oer);
 else
    field_ggsn__Address = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void NoteMsPresentForGprsArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_ggsn__Address_present = field_ggsn__Address.is_present();
p_buf.PER_put_bit(field_ggsn__Address_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(NoteMsPresentForGprsArg_imsi_descr_, p_buf, p_options);
field_sgsn__Address.PER_encode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_buf, p_options);
if (field_ggsn__Address_present) field_ggsn__Address.PER_encode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_buf, p_options);
}

void NoteMsPresentForGprsArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_ggsn__Address_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(NoteMsPresentForGprsArg_imsi_descr_, p_buf, p_options);
field_sgsn__Address.PER_decode(NoteMsPresentForGprsArg_sgsn__Address_descr_, p_buf, p_options);
if (field_ggsn__Address_present) field_ggsn__Address.PER_decode(NoteMsPresentForGprsArg_ggsn__Address_descr_, p_buf, p_options);
else field_ggsn__Address = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(NoteMsPresentForGprsArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct NoteMsPresentForGprsArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
OCTETSTRING_template field_sgsn__Address;
OCTETSTRING_template field_ggsn__Address;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void NoteMsPresentForGprsArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_sgsn__Address = ANY_VALUE;
single_value->field_ggsn__Address = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void NoteMsPresentForGprsArg_template::copy_value(const NoteMsPresentForGprsArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.sgsn__Address().is_bound()) {
  single_value->field_sgsn__Address = other_value.sgsn__Address();
} else {
  single_value->field_sgsn__Address.clean_up();
}
if (other_value.ggsn__Address().is_bound()) {
  if (other_value.ggsn__Address().ispresent()) single_value->field_ggsn__Address = other_value.ggsn__Address()();
  else single_value->field_ggsn__Address = OMIT_VALUE;
} else {
  single_value->field_ggsn__Address.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NoteMsPresentForGprsArg_template::copy_template(const NoteMsPresentForGprsArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__Address().get_selection()) {
single_value->field_sgsn__Address = other_value.sgsn__Address();
} else {
single_value->field_sgsn__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__Address().get_selection()) {
single_value->field_ggsn__Address = other_value.ggsn__Address();
} else {
single_value->field_ggsn__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NoteMsPresentForGprsArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NoteMsPresentForGprsArg_template(*other_value.implication_.precondition);
implication_.implied_template = new NoteMsPresentForGprsArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
break;
}
set_selection(other_value);
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template()
{
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(const NoteMsPresentForGprsArg& other_value)
{
copy_value(other_value);
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(const OPTIONAL<NoteMsPresentForGprsArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NoteMsPresentForGprsArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg from an unbound optional field.");
}
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(NoteMsPresentForGprsArg_template* p_precondition, NoteMsPresentForGprsArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(Dynamic_Match_Interface<NoteMsPresentForGprsArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NoteMsPresentForGprsArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NoteMsPresentForGprsArg_template::NoteMsPresentForGprsArg_template(const NoteMsPresentForGprsArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NoteMsPresentForGprsArg_template::~NoteMsPresentForGprsArg_template()
{
clean_up();
}

NoteMsPresentForGprsArg_template& NoteMsPresentForGprsArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NoteMsPresentForGprsArg_template& NoteMsPresentForGprsArg_template::operator=(const NoteMsPresentForGprsArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NoteMsPresentForGprsArg_template& NoteMsPresentForGprsArg_template::operator=(const OPTIONAL<NoteMsPresentForGprsArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NoteMsPresentForGprsArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
}
return *this;
}

NoteMsPresentForGprsArg_template& NoteMsPresentForGprsArg_template::operator=(const NoteMsPresentForGprsArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NoteMsPresentForGprsArg_template::match(const NoteMsPresentForGprsArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.sgsn__Address().is_bound()) return FALSE;
if(!single_value->field_sgsn__Address.match(other_value.sgsn__Address(), legacy))return FALSE;
if(!other_value.ggsn__Address().is_bound()) return FALSE;
if((other_value.ggsn__Address().ispresent() ? !single_value->field_ggsn__Address.match((const OCTETSTRING&)other_value.ggsn__Address(), legacy) : !single_value->field_ggsn__Address.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
}
return FALSE;
}

boolean NoteMsPresentForGprsArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || single_value->field_sgsn__Address.is_bound()
 || (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean NoteMsPresentForGprsArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && single_value->field_sgsn__Address.is_value()
 && (single_value->field_ggsn__Address.is_omit() || single_value->field_ggsn__Address.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void NoteMsPresentForGprsArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NoteMsPresentForGprsArg NoteMsPresentForGprsArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
NoteMsPresentForGprsArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_sgsn__Address.is_bound()) {
ret_val.sgsn__Address() = single_value->field_sgsn__Address.valueof();
}
if (single_value->field_ggsn__Address.is_omit()) ret_val.ggsn__Address() = OMIT_VALUE;
else if (single_value->field_ggsn__Address.is_bound()) {
ret_val.ggsn__Address() = single_value->field_ggsn__Address.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void NoteMsPresentForGprsArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NoteMsPresentForGprsArg_template[list_length];
}

NoteMsPresentForGprsArg_template& NoteMsPresentForGprsArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& NoteMsPresentForGprsArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& NoteMsPresentForGprsArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
return single_value->field_imsi;
}

OCTETSTRING_template& NoteMsPresentForGprsArg_template::sgsn__Address()
{
set_specific();
return single_value->field_sgsn__Address;
}

const OCTETSTRING_template& NoteMsPresentForGprsArg_template::sgsn__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_Address of a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
return single_value->field_sgsn__Address;
}

OCTETSTRING_template& NoteMsPresentForGprsArg_template::ggsn__Address()
{
set_specific();
return single_value->field_ggsn__Address;
}

const OCTETSTRING_template& NoteMsPresentForGprsArg_template::ggsn__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_Address of a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
return single_value->field_ggsn__Address;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& NoteMsPresentForGprsArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& NoteMsPresentForGprsArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
return single_value->field_extensionContainer;
}

int NoteMsPresentForGprsArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_ggsn__Address.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
  }
  return 0;
}

void NoteMsPresentForGprsArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", sgsn_Address := ");
single_value->field_sgsn__Address.log();
TTCN_Logger::log_event_str(", ggsn_Address := ");
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NoteMsPresentForGprsArg_template::log_match(const NoteMsPresentForGprsArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sgsn__Address.match(match_value.sgsn__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_Address");
single_value->field_sgsn__Address.log_match(match_value.sgsn__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ggsn__Address().ispresent()){
if(!single_value->field_ggsn__Address.match(match_value.ggsn__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_Address");
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ggsn__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ggsn_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ggsn__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", sgsn_Address := ");
single_value->field_sgsn__Address.log_match(match_value.sgsn__Address(), legacy);
TTCN_Logger::log_event_str(", ggsn_Address := ");
if (match_value.ggsn__Address().ispresent()) {
single_value->field_ggsn__Address.log_match(match_value.ggsn__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ggsn__Address.log();
if (single_value->field_ggsn__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NoteMsPresentForGprsArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (sgsn__Address().is_bound()) sgsn__Address().set_implicit_omit();
if (!ggsn__Address().is_bound()) ggsn__Address() = OMIT_VALUE;
else ggsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void NoteMsPresentForGprsArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_sgsn__Address.encode_text(text_buf);
single_value->field_ggsn__Address.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
}
}

void NoteMsPresentForGprsArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_sgsn__Address.decode_text(text_buf);
single_value->field_ggsn__Address.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NoteMsPresentForGprsArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg.");
}
}

void NoteMsPresentForGprsArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NoteMsPresentForGprsArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.NoteMsPresentForGprsArg has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sgsn__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ggsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.NoteMsPresentForGprsArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NoteMsPresentForGprsArg_template* precondition = new NoteMsPresentForGprsArg_template;
    precondition->set_param(*param.get_elem(0));
    NoteMsPresentForGprsArg_template* implied_template = new NoteMsPresentForGprsArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NoteMsPresentForGprsArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void NoteMsPresentForGprsArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
single_value->field_sgsn__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
single_value->field_ggsn__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsArg");
}

boolean NoteMsPresentForGprsArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NoteMsPresentForGprsArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NoteMsPresentForGprsRes::NoteMsPresentForGprsRes()
{
}

NoteMsPresentForGprsRes::NoteMsPresentForGprsRes(const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_extensionContainer(par_extensionContainer)
{
}

NoteMsPresentForGprsRes::NoteMsPresentForGprsRes(const NoteMsPresentForGprsRes& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void NoteMsPresentForGprsRes::clean_up()
{
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* NoteMsPresentForGprsRes::get_descriptor() const { return &NoteMsPresentForGprsRes_descr_; }
NoteMsPresentForGprsRes& NoteMsPresentForGprsRes::operator=(const NoteMsPresentForGprsRes& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean NoteMsPresentForGprsRes::operator==(const NoteMsPresentForGprsRes& other_value) const
{
return field_extensionContainer==other_value.field_extensionContainer;
}

boolean NoteMsPresentForGprsRes::is_bound() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean NoteMsPresentForGprsRes::is_value() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int NoteMsPresentForGprsRes::size_of() const
{
  int ret_val = 0;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void NoteMsPresentForGprsRes::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void NoteMsPresentForGprsRes::set_implicit_omit()
{
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void NoteMsPresentForGprsRes::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.NoteMsPresentForGprsRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.NoteMsPresentForGprsRes");
  }
}

void NoteMsPresentForGprsRes::encode_text(Text_Buf& text_buf) const
{
field_extensionContainer.encode_text(text_buf);
}

void NoteMsPresentForGprsRes::decode_text(Text_Buf& text_buf)
{
field_extensionContainer.decode_text(text_buf);
}

void NoteMsPresentForGprsRes::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NoteMsPresentForGprsRes::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* NoteMsPresentForGprsRes::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(NoteMsPresentForGprsRes_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean NoteMsPresentForGprsRes::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.NoteMsPresentForGprsRes' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(NoteMsPresentForGprsRes_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int NoteMsPresentForGprsRes::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
    return -1;
  }

  if (p_td.json->as_value) {
   if (field_extensionContainer == OMIT_VALUE) {
     return p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL) + 
       p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
   }
   return field_extensionContainer.JSON_encode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_tok, FALSE);
  }
  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int NoteMsPresentForGprsRes::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const NoteMsPresentForGprsRes*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->as_value) {
   json_token_t j_token = JSON_TOKEN_NONE;
   size_t buf_pos = p_tok.get_buf_pos();
   size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
   if (j_token == JSON_TOKEN_LITERAL_NULL) {
     return JSON_ERROR_FATAL;
   }
   else if (j_token == JSON_TOKEN_OBJECT_START) {
     dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
     if (j_token == JSON_TOKEN_OBJECT_END) {
       field_extensionContainer = OMIT_VALUE;
       return dec_len;
     }
   }
   p_tok.set_buf_pos(buf_pos);
   return field_extensionContainer.JSON_decode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int NoteMsPresentForGprsRes::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_buf);
  return 0;
}

int NoteMsPresentForGprsRes::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void NoteMsPresentForGprsRes::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_buf, p_options);
}

void NoteMsPresentForGprsRes::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_extensionContainer_present) field_extensionContainer.PER_decode(NoteMsPresentForGprsRes_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct NoteMsPresentForGprsRes_template::single_value_struct {
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void NoteMsPresentForGprsRes_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void NoteMsPresentForGprsRes_template::copy_value(const NoteMsPresentForGprsRes& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NoteMsPresentForGprsRes_template::copy_template(const NoteMsPresentForGprsRes_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NoteMsPresentForGprsRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NoteMsPresentForGprsRes_template(*other_value.implication_.precondition);
implication_.implied_template = new NoteMsPresentForGprsRes_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
break;
}
set_selection(other_value);
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template()
{
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(const NoteMsPresentForGprsRes& other_value)
{
copy_value(other_value);
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(const OPTIONAL<NoteMsPresentForGprsRes>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NoteMsPresentForGprsRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes from an unbound optional field.");
}
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(NoteMsPresentForGprsRes_template* p_precondition, NoteMsPresentForGprsRes_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(Dynamic_Match_Interface<NoteMsPresentForGprsRes>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NoteMsPresentForGprsRes>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NoteMsPresentForGprsRes_template::NoteMsPresentForGprsRes_template(const NoteMsPresentForGprsRes_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NoteMsPresentForGprsRes_template::~NoteMsPresentForGprsRes_template()
{
clean_up();
}

NoteMsPresentForGprsRes_template& NoteMsPresentForGprsRes_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NoteMsPresentForGprsRes_template& NoteMsPresentForGprsRes_template::operator=(const NoteMsPresentForGprsRes& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NoteMsPresentForGprsRes_template& NoteMsPresentForGprsRes_template::operator=(const OPTIONAL<NoteMsPresentForGprsRes>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NoteMsPresentForGprsRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
}
return *this;
}

NoteMsPresentForGprsRes_template& NoteMsPresentForGprsRes_template::operator=(const NoteMsPresentForGprsRes_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NoteMsPresentForGprsRes_template::match(const NoteMsPresentForGprsRes& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
}
return FALSE;
}

boolean NoteMsPresentForGprsRes_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean NoteMsPresentForGprsRes_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void NoteMsPresentForGprsRes_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NoteMsPresentForGprsRes NoteMsPresentForGprsRes_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
NoteMsPresentForGprsRes ret_val;
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void NoteMsPresentForGprsRes_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NoteMsPresentForGprsRes_template[list_length];
}

NoteMsPresentForGprsRes_template& NoteMsPresentForGprsRes_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
return value_list.list_value[list_index];
}

MAP__ExtensionDataTypes::ExtensionContainer_template& NoteMsPresentForGprsRes_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& NoteMsPresentForGprsRes_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
return single_value->field_extensionContainer;
}

int NoteMsPresentForGprsRes_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
  }
  return 0;
}

void NoteMsPresentForGprsRes_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NoteMsPresentForGprsRes_template::log_match(const NoteMsPresentForGprsRes& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NoteMsPresentForGprsRes_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void NoteMsPresentForGprsRes_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
}
}

void NoteMsPresentForGprsRes_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NoteMsPresentForGprsRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes.");
}
}

void NoteMsPresentForGprsRes_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NoteMsPresentForGprsRes_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.NoteMsPresentForGprsRes has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.NoteMsPresentForGprsRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NoteMsPresentForGprsRes_template* precondition = new NoteMsPresentForGprsRes_template;
    precondition->set_param(*param.get_elem(0));
    NoteMsPresentForGprsRes_template* implied_template = new NoteMsPresentForGprsRes_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NoteMsPresentForGprsRes_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.NoteMsPresentForGprsRes");
  }
  is_ifpresent = param.get_ifpresent();
}

void NoteMsPresentForGprsRes_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsRes");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.NoteMsPresentForGprsRes");
}

boolean NoteMsPresentForGprsRes_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NoteMsPresentForGprsRes_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ResetArg::ResetArg()
{
}

ResetArg::ResetArg(const OCTETSTRING& par_hlr__Number,
    const OPTIONAL< MAP__CommonDataTypes::HLR__List >& par_hlr__List)
  :   field_hlr__Number(par_hlr__Number),
  field_hlr__List(par_hlr__List)
{
}

ResetArg::ResetArg(const ResetArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ResetArg.");
if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
else field_hlr__Number.clean_up();
if (other_value.hlr__List().is_bound()) field_hlr__List = other_value.hlr__List();
else field_hlr__List.clean_up();
}

void ResetArg::clean_up()
{
field_hlr__Number.clean_up();
field_hlr__List.clean_up();
}

const TTCN_Typedescriptor_t* ResetArg::get_descriptor() const { return &ResetArg_descr_; }
ResetArg& ResetArg::operator=(const ResetArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ResetArg.");
  if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
  else field_hlr__Number.clean_up();
  if (other_value.hlr__List().is_bound()) field_hlr__List = other_value.hlr__List();
  else field_hlr__List.clean_up();
}
return *this;
}

boolean ResetArg::operator==(const ResetArg& other_value) const
{
return field_hlr__Number==other_value.field_hlr__Number
  && field_hlr__List==other_value.field_hlr__List;
}

boolean ResetArg::is_bound() const
{
return (field_hlr__Number.is_bound())
  || (OPTIONAL_OMIT == field_hlr__List.get_selection() || field_hlr__List.is_bound());
}
boolean ResetArg::is_value() const
{
return field_hlr__Number.is_value()
  && (OPTIONAL_OMIT == field_hlr__List.get_selection() || field_hlr__List.is_value());
}
int ResetArg::size_of() const
{
  int ret_val = 1;
  if (field_hlr__List.ispresent()) ret_val++;
  return ret_val;
}

void ResetArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ hlr_Number := ");
field_hlr__Number.log();
TTCN_Logger::log_event_str(", hlr_List := ");
field_hlr__List.log();
TTCN_Logger::log_event_str(" }");
}

void ResetArg::set_implicit_omit()
{
if (hlr__Number().is_bound()) hlr__Number().set_implicit_omit();
if (!hlr__List().is_bound()) hlr__List() = OMIT_VALUE;
else hlr__List().set_implicit_omit();
}

void ResetArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ResetArg has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) hlr__Number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) hlr__List().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_List")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__List().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ResetArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ResetArg");
  }
}

void ResetArg::encode_text(Text_Buf& text_buf) const
{
field_hlr__Number.encode_text(text_buf);
field_hlr__List.encode_text(text_buf);
}

void ResetArg::decode_text(Text_Buf& text_buf)
{
field_hlr__Number.decode_text(text_buf);
field_hlr__List.decode_text(text_buf);
}

void ResetArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ResetArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ResetArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("hlr_Number': ");
  new_tlv->add_TLV(field_hlr__Number.BER_encode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_coding));
  ec_1.set_msg("hlr_List': ");
  new_tlv->add_TLV(field_hlr__List.BER_encode_TLV(MAP__CommonDataTypes::HLR__List_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ResetArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ResetArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("hlr_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_hlr__Number.BER_decode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("hlr_List': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_hlr__List=OMIT_VALUE;
    else {
      field_hlr__List.BER_decode_TLV(MAP__CommonDataTypes::HLR__List_descr_, tmp_tlv, L_form);
      if(field_hlr__List.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ResetArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ResetArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "hlr_Number");
    enc_len += field_hlr__Number.JSON_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, FALSE);
  }

  if (field_hlr__List.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "hlr_List");
    enc_len += field_hlr__List.JSON_encode(MAP__CommonDataTypes::HLR__List_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ResetArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ResetArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean hlr__Number_found = FALSE;
  boolean hlr__List_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (10 == name_len && 0 == strncmp(fld_name, "hlr_Number", name_len)) {
        hlr__Number_found = TRUE;
         int ret_val = field_hlr__Number.JSON_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "hlr_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "hlr_List", name_len)) {
        hlr__List_found = TRUE;
         int ret_val = field_hlr__List.JSON_decode(MAP__CommonDataTypes::HLR__List_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "hlr_List");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!hlr__Number_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "hlr_Number");
    return JSON_ERROR_FATAL;
  }
  if (!hlr__List_found) {
    field_hlr__List = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ResetArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_hlr__List.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_hlr__Number.OER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf);
  if (field_hlr__List.is_present())
    field_hlr__List.OER_encode(MAP__CommonDataTypes::HLR__List_descr_, p_buf);
  return 0;
}

int ResetArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_hlr__Number.OER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_hlr__List.OER_decode(MAP__CommonDataTypes::HLR__List_descr_, p_buf, p_oer);
 else
    field_hlr__List = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void ResetArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_hlr__List_present = field_hlr__List.is_present();
p_buf.PER_put_bit(field_hlr__List_present);
field_hlr__Number.PER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_hlr__List_present) field_hlr__List.PER_encode(MAP__CommonDataTypes::HLR__List_descr_, p_buf, p_options);
}

void ResetArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_hlr__List_present = p_buf.PER_get_bit();
field_hlr__Number.PER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_hlr__List_present) field_hlr__List.PER_decode(MAP__CommonDataTypes::HLR__List_descr_, p_buf, p_options);
else field_hlr__List = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ResetArg_template::single_value_struct {
OCTETSTRING_template field_hlr__Number;
MAP__CommonDataTypes::HLR__List_template field_hlr__List;
};

void ResetArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_hlr__Number = ANY_VALUE;
single_value->field_hlr__List = ANY_OR_OMIT;
}
}
}

void ResetArg_template::copy_value(const ResetArg& other_value)
{
single_value = new single_value_struct;
if (other_value.hlr__Number().is_bound()) {
  single_value->field_hlr__Number = other_value.hlr__Number();
} else {
  single_value->field_hlr__Number.clean_up();
}
if (other_value.hlr__List().is_bound()) {
  if (other_value.hlr__List().ispresent()) single_value->field_hlr__List = other_value.hlr__List()();
  else single_value->field_hlr__List = OMIT_VALUE;
} else {
  single_value->field_hlr__List.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ResetArg_template::copy_template(const ResetArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.hlr__Number().get_selection()) {
single_value->field_hlr__Number = other_value.hlr__Number();
} else {
single_value->field_hlr__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.hlr__List().get_selection()) {
single_value->field_hlr__List = other_value.hlr__List();
} else {
single_value->field_hlr__List.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ResetArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ResetArg_template(*other_value.implication_.precondition);
implication_.implied_template = new ResetArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ResetArg.");
break;
}
set_selection(other_value);
}

ResetArg_template::ResetArg_template()
{
}

ResetArg_template::ResetArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ResetArg_template::ResetArg_template(const ResetArg& other_value)
{
copy_value(other_value);
}

ResetArg_template::ResetArg_template(const OPTIONAL<ResetArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ResetArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ResetArg from an unbound optional field.");
}
}

ResetArg_template::ResetArg_template(ResetArg_template* p_precondition, ResetArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ResetArg_template::ResetArg_template(Dynamic_Match_Interface<ResetArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ResetArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ResetArg_template::ResetArg_template(const ResetArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ResetArg_template::~ResetArg_template()
{
clean_up();
}

ResetArg_template& ResetArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ResetArg_template& ResetArg_template::operator=(const ResetArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ResetArg_template& ResetArg_template::operator=(const OPTIONAL<ResetArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ResetArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ResetArg.");
}
return *this;
}

ResetArg_template& ResetArg_template::operator=(const ResetArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ResetArg_template::match(const ResetArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.hlr__Number().is_bound()) return FALSE;
if(!single_value->field_hlr__Number.match(other_value.hlr__Number(), legacy))return FALSE;
if(!other_value.hlr__List().is_bound()) return FALSE;
if((other_value.hlr__List().ispresent() ? !single_value->field_hlr__List.match((const MAP__CommonDataTypes::HLR__List&)other_value.hlr__List(), legacy) : !single_value->field_hlr__List.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ResetArg.");
}
return FALSE;
}

boolean ResetArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_hlr__Number.is_bound()
 || (single_value->field_hlr__List.is_omit() || single_value->field_hlr__List.is_bound());
}

boolean ResetArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_hlr__Number.is_value()
 && (single_value->field_hlr__List.is_omit() || single_value->field_hlr__List.is_value());
}

void ResetArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ResetArg ResetArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ResetArg.");
ResetArg ret_val;
if (single_value->field_hlr__Number.is_bound()) {
ret_val.hlr__Number() = single_value->field_hlr__Number.valueof();
}
if (single_value->field_hlr__List.is_omit()) ret_val.hlr__List() = OMIT_VALUE;
else if (single_value->field_hlr__List.is_bound()) {
ret_val.hlr__List() = single_value->field_hlr__List.valueof();
}
return ret_val;
}

void ResetArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ResetArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ResetArg_template[list_length];
}

ResetArg_template& ResetArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ResetArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ResetArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ResetArg_template::hlr__Number()
{
set_specific();
return single_value->field_hlr__Number;
}

const OCTETSTRING_template& ResetArg_template::hlr__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field hlr_Number of a non-specific template of type @MAP-MS-DataTypes.ResetArg.");
return single_value->field_hlr__Number;
}

MAP__CommonDataTypes::HLR__List_template& ResetArg_template::hlr__List()
{
set_specific();
return single_value->field_hlr__List;
}

const MAP__CommonDataTypes::HLR__List_template& ResetArg_template::hlr__List() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field hlr_List of a non-specific template of type @MAP-MS-DataTypes.ResetArg.");
return single_value->field_hlr__List;
}

int ResetArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_hlr__List.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ResetArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ResetArg.");
  }
  return 0;
}

void ResetArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ hlr_Number := ");
single_value->field_hlr__Number.log();
TTCN_Logger::log_event_str(", hlr_List := ");
single_value->field_hlr__List.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ResetArg_template::log_match(const ResetArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_hlr__Number.match(match_value.hlr__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".hlr_Number");
single_value->field_hlr__Number.log_match(match_value.hlr__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.hlr__List().ispresent()){
if(!single_value->field_hlr__List.match(match_value.hlr__List(), legacy)){
TTCN_Logger::log_logmatch_info(".hlr_List");
single_value->field_hlr__List.log_match(match_value.hlr__List(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_hlr__List.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".hlr_List := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_hlr__List.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ hlr_Number := ");
single_value->field_hlr__Number.log_match(match_value.hlr__Number(), legacy);
TTCN_Logger::log_event_str(", hlr_List := ");
if (match_value.hlr__List().ispresent()) {
single_value->field_hlr__List.log_match(match_value.hlr__List(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_hlr__List.log();
if (single_value->field_hlr__List.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ResetArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (hlr__Number().is_bound()) hlr__Number().set_implicit_omit();
if (!hlr__List().is_bound()) hlr__List() = OMIT_VALUE;
else hlr__List().set_implicit_omit();
}

void ResetArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_hlr__Number.encode_text(text_buf);
single_value->field_hlr__List.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ResetArg.");
}
}

void ResetArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_hlr__Number.decode_text(text_buf);
single_value->field_hlr__List.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ResetArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ResetArg.");
}
}

void ResetArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ResetArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ResetArg has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) hlr__Number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) hlr__List().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_List")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__List().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ResetArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ResetArg_template* precondition = new ResetArg_template;
    precondition->set_param(*param.get_elem(0));
    ResetArg_template* implied_template = new ResetArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ResetArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ResetArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void ResetArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_hlr__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ResetArg");
single_value->field_hlr__List.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ResetArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ResetArg");
}

boolean ResetArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ResetArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RestoreDataArg::RestoreDataArg()
{
}

RestoreDataArg::RestoreDataArg(const OCTETSTRING& par_imsi,
    const OPTIONAL< OCTETSTRING >& par_lmsi,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< VLR__Capability >& par_vlr__Capability,
    const OPTIONAL< ASN_NULL >& par_restorationIndicator)
  :   field_imsi(par_imsi),
  field_lmsi(par_lmsi),
  field_extensionContainer(par_extensionContainer),
  field_vlr__Capability(par_vlr__Capability),
  field_restorationIndicator(par_restorationIndicator)
{
}

RestoreDataArg::RestoreDataArg(const RestoreDataArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.RestoreDataArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.lmsi().is_bound()) field_lmsi = other_value.lmsi();
else field_lmsi.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.vlr__Capability().is_bound()) field_vlr__Capability = other_value.vlr__Capability();
else field_vlr__Capability.clean_up();
if (other_value.restorationIndicator().is_bound()) field_restorationIndicator = other_value.restorationIndicator();
else field_restorationIndicator.clean_up();
}

void RestoreDataArg::clean_up()
{
field_imsi.clean_up();
field_lmsi.clean_up();
field_extensionContainer.clean_up();
field_vlr__Capability.clean_up();
field_restorationIndicator.clean_up();
}

const TTCN_Typedescriptor_t* RestoreDataArg::get_descriptor() const { return &RestoreDataArg_descr_; }
RestoreDataArg& RestoreDataArg::operator=(const RestoreDataArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.RestoreDataArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.lmsi().is_bound()) field_lmsi = other_value.lmsi();
  else field_lmsi.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.vlr__Capability().is_bound()) field_vlr__Capability = other_value.vlr__Capability();
  else field_vlr__Capability.clean_up();
  if (other_value.restorationIndicator().is_bound()) field_restorationIndicator = other_value.restorationIndicator();
  else field_restorationIndicator.clean_up();
}
return *this;
}

boolean RestoreDataArg::operator==(const RestoreDataArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_lmsi==other_value.field_lmsi
  && field_extensionContainer==other_value.field_extensionContainer
  && field_vlr__Capability==other_value.field_vlr__Capability
  && field_restorationIndicator==other_value.field_restorationIndicator;
}

boolean RestoreDataArg::is_bound() const
{
return (field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_lmsi.get_selection() || field_lmsi.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_vlr__Capability.get_selection() || field_vlr__Capability.is_bound())
  || (OPTIONAL_OMIT == field_restorationIndicator.get_selection() || field_restorationIndicator.is_bound());
}
boolean RestoreDataArg::is_value() const
{
return field_imsi.is_value()
  && (OPTIONAL_OMIT == field_lmsi.get_selection() || field_lmsi.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_vlr__Capability.get_selection() || field_vlr__Capability.is_value())
  && (OPTIONAL_OMIT == field_restorationIndicator.get_selection() || field_restorationIndicator.is_value());
}
int RestoreDataArg::size_of() const
{
  int ret_val = 1;
  if (field_lmsi.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_vlr__Capability.ispresent()) ret_val++;
  if (field_restorationIndicator.ispresent()) ret_val++;
  return ret_val;
}

void RestoreDataArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", lmsi := ");
field_lmsi.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", vlr_Capability := ");
field_vlr__Capability.log();
TTCN_Logger::log_event_str(", restorationIndicator := ");
field_restorationIndicator.log();
TTCN_Logger::log_event_str(" }");
}

void RestoreDataArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (!lmsi().is_bound()) lmsi() = OMIT_VALUE;
else lmsi().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!vlr__Capability().is_bound()) vlr__Capability() = OMIT_VALUE;
else vlr__Capability().set_implicit_omit();
if (!restorationIndicator().is_bound()) restorationIndicator() = OMIT_VALUE;
else restorationIndicator().set_implicit_omit();
}

void RestoreDataArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.RestoreDataArg has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lmsi().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) vlr__Capability().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) restorationIndicator().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "restorationIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          restorationIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RestoreDataArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.RestoreDataArg");
  }
}

void RestoreDataArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_lmsi.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_vlr__Capability.encode_text(text_buf);
field_restorationIndicator.encode_text(text_buf);
}

void RestoreDataArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_lmsi.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_vlr__Capability.decode_text(text_buf);
field_restorationIndicator.decode_text(text_buf);
}

void RestoreDataArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RestoreDataArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* RestoreDataArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(MAP__CommonDataTypes::IMSI_descr_, p_coding));
  ec_1.set_msg("lmsi': ");
  new_tlv->add_TLV(field_lmsi.BER_encode_TLV(RestoreDataArg_lmsi_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(RestoreDataArg_extensionContainer_descr_, p_coding));
  ec_1.set_msg("vlr_Capability': ");
  new_tlv->add_TLV(field_vlr__Capability.BER_encode_TLV(RestoreDataArg_vlr__Capability_descr_, p_coding));
  ec_1.set_msg("restorationIndicator': ");
  new_tlv->add_TLV(field_restorationIndicator.BER_encode_TLV(RestoreDataArg_restorationIndicator_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean RestoreDataArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.RestoreDataArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(MAP__CommonDataTypes::IMSI_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("lmsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_lmsi=OMIT_VALUE;
    else {
      field_lmsi.BER_decode_TLV(RestoreDataArg_lmsi_descr_, tmp_tlv, L_form);
      if(field_lmsi.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(RestoreDataArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vlr_Capability': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vlr__Capability=OMIT_VALUE;
    else {
      field_vlr__Capability.BER_decode_TLV(RestoreDataArg_vlr__Capability_descr_, tmp_tlv, L_form);
      if(field_vlr__Capability.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("restorationIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_restorationIndicator=OMIT_VALUE;
    else {
      field_restorationIndicator.BER_decode_TLV(RestoreDataArg_restorationIndicator_descr_, tmp_tlv, L_form);
      if(field_restorationIndicator.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int RestoreDataArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.RestoreDataArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(MAP__CommonDataTypes::IMSI_descr_, p_tok, FALSE);
  }

  if (field_lmsi.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "lmsi");
    enc_len += field_lmsi.JSON_encode(RestoreDataArg_lmsi_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(RestoreDataArg_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_vlr__Capability.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vlr_Capability");
    enc_len += field_vlr__Capability.JSON_encode(RestoreDataArg_vlr__Capability_descr_, p_tok, FALSE);
  }

  if (field_restorationIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "restorationIndicator");
    enc_len += field_restorationIndicator.JSON_encode(RestoreDataArg_restorationIndicator_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int RestoreDataArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const RestoreDataArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean lmsi_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean vlr__Capability_found = FALSE;
  boolean restorationIndicator_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(MAP__CommonDataTypes::IMSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "lmsi", name_len)) {
        lmsi_found = TRUE;
         int ret_val = field_lmsi.JSON_decode(RestoreDataArg_lmsi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "lmsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(RestoreDataArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "vlr_Capability", name_len)) {
        vlr__Capability_found = TRUE;
         int ret_val = field_vlr__Capability.JSON_decode(RestoreDataArg_vlr__Capability_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "vlr_Capability");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (20 == name_len && 0 == strncmp(fld_name, "restorationIndicator", name_len)) {
        restorationIndicator_found = TRUE;
         int ret_val = field_restorationIndicator.JSON_decode(RestoreDataArg_restorationIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "restorationIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!lmsi_found) {
    field_lmsi = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!vlr__Capability_found) {
    field_vlr__Capability = OMIT_VALUE;
  }
  if (!restorationIndicator_found) {
    field_restorationIndicator = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int RestoreDataArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_vlr__Capability.is_bound() && field_vlr__Capability.is_present());
  has_extension = has_extension || (field_restorationIndicator.is_bound() && field_restorationIndicator.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_lmsi.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf);
  if (field_lmsi.is_present())
    field_lmsi.OER_encode(RestoreDataArg_lmsi_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(RestoreDataArg_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_vlr__Capability.is_present()) {
      c |= 128;
      field_vlr__Capability.OER_encode(RestoreDataArg_vlr__Capability_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_restorationIndicator.is_present()) {
      c |= 64;
      field_restorationIndicator.OER_encode(RestoreDataArg_restorationIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(6);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int RestoreDataArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_lmsi.OER_decode(RestoreDataArg_lmsi_descr_, p_buf, p_oer);
 else
    field_lmsi = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(RestoreDataArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_vlr__Capability = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_vlr__Capability.OER_decode(RestoreDataArg_vlr__Capability_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_restorationIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_restorationIndicator.OER_decode(RestoreDataArg_restorationIndicator_descr_, p_buf, p_oer);
    }
  }
  else {
    field_vlr__Capability = OMIT_VALUE;
    field_restorationIndicator = OMIT_VALUE;
  }
  return 0;
}

void RestoreDataArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_vlr__Capability.is_present();
boolean ext_1_present = field_restorationIndicator.is_present();
boolean ext_bit = ext_0_present || ext_1_present;
p_buf.PER_put_bit(ext_bit);
boolean field_lmsi_present = field_lmsi.is_present();
p_buf.PER_put_bit(field_lmsi_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
if (field_lmsi_present) field_lmsi.PER_encode(RestoreDataArg_lmsi_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(RestoreDataArg_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(2);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_vlr__Capability.PER_encode(RestoreDataArg_vlr__Capability_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_restorationIndicator.PER_encode(RestoreDataArg_restorationIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void RestoreDataArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_lmsi_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
if (field_lmsi_present) field_lmsi.PER_decode(RestoreDataArg_lmsi_descr_, p_buf, p_options);
else field_lmsi = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(RestoreDataArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 2) {
for (int i = nof_decoded_ext_adds; i < 2; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_vlr__Capability.PER_decode(RestoreDataArg_vlr__Capability_descr_, ext_add_buf, p_options);
}
else {
field_vlr__Capability = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_restorationIndicator.PER_decode(RestoreDataArg_restorationIndicator_descr_, ext_add_buf, p_options);
}
else {
field_restorationIndicator = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 2) for (int i = 2; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct RestoreDataArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
OCTETSTRING_template field_lmsi;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
VLR__Capability_template field_vlr__Capability;
ASN_NULL_template field_restorationIndicator;
};

void RestoreDataArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_lmsi = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_vlr__Capability = ANY_OR_OMIT;
single_value->field_restorationIndicator = ANY_OR_OMIT;
}
}
}

void RestoreDataArg_template::copy_value(const RestoreDataArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.lmsi().is_bound()) {
  if (other_value.lmsi().ispresent()) single_value->field_lmsi = other_value.lmsi()();
  else single_value->field_lmsi = OMIT_VALUE;
} else {
  single_value->field_lmsi.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.vlr__Capability().is_bound()) {
  if (other_value.vlr__Capability().ispresent()) single_value->field_vlr__Capability = other_value.vlr__Capability()();
  else single_value->field_vlr__Capability = OMIT_VALUE;
} else {
  single_value->field_vlr__Capability.clean_up();
}
if (other_value.restorationIndicator().is_bound()) {
  if (other_value.restorationIndicator().ispresent()) single_value->field_restorationIndicator = other_value.restorationIndicator()();
  else single_value->field_restorationIndicator = OMIT_VALUE;
} else {
  single_value->field_restorationIndicator.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RestoreDataArg_template::copy_template(const RestoreDataArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lmsi().get_selection()) {
single_value->field_lmsi = other_value.lmsi();
} else {
single_value->field_lmsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vlr__Capability().get_selection()) {
single_value->field_vlr__Capability = other_value.vlr__Capability();
} else {
single_value->field_vlr__Capability.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.restorationIndicator().get_selection()) {
single_value->field_restorationIndicator = other_value.restorationIndicator();
} else {
single_value->field_restorationIndicator.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RestoreDataArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RestoreDataArg_template(*other_value.implication_.precondition);
implication_.implied_template = new RestoreDataArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataArg.");
break;
}
set_selection(other_value);
}

RestoreDataArg_template::RestoreDataArg_template()
{
}

RestoreDataArg_template::RestoreDataArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RestoreDataArg_template::RestoreDataArg_template(const RestoreDataArg& other_value)
{
copy_value(other_value);
}

RestoreDataArg_template::RestoreDataArg_template(const OPTIONAL<RestoreDataArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RestoreDataArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.RestoreDataArg from an unbound optional field.");
}
}

RestoreDataArg_template::RestoreDataArg_template(RestoreDataArg_template* p_precondition, RestoreDataArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RestoreDataArg_template::RestoreDataArg_template(Dynamic_Match_Interface<RestoreDataArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RestoreDataArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RestoreDataArg_template::RestoreDataArg_template(const RestoreDataArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RestoreDataArg_template::~RestoreDataArg_template()
{
clean_up();
}

RestoreDataArg_template& RestoreDataArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RestoreDataArg_template& RestoreDataArg_template::operator=(const RestoreDataArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RestoreDataArg_template& RestoreDataArg_template::operator=(const OPTIONAL<RestoreDataArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RestoreDataArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.RestoreDataArg.");
}
return *this;
}

RestoreDataArg_template& RestoreDataArg_template::operator=(const RestoreDataArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RestoreDataArg_template::match(const RestoreDataArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.lmsi().is_bound()) return FALSE;
if((other_value.lmsi().ispresent() ? !single_value->field_lmsi.match((const OCTETSTRING&)other_value.lmsi(), legacy) : !single_value->field_lmsi.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.vlr__Capability().is_bound()) return FALSE;
if((other_value.vlr__Capability().ispresent() ? !single_value->field_vlr__Capability.match((const VLR__Capability&)other_value.vlr__Capability(), legacy) : !single_value->field_vlr__Capability.match_omit(legacy)))return FALSE;
if(!other_value.restorationIndicator().is_bound()) return FALSE;
if((other_value.restorationIndicator().ispresent() ? !single_value->field_restorationIndicator.match((const ASN_NULL&)other_value.restorationIndicator(), legacy) : !single_value->field_restorationIndicator.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataArg.");
}
return FALSE;
}

boolean RestoreDataArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || (single_value->field_lmsi.is_omit() || single_value->field_lmsi.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_vlr__Capability.is_omit() || single_value->field_vlr__Capability.is_bound())
 || (single_value->field_restorationIndicator.is_omit() || single_value->field_restorationIndicator.is_bound());
}

boolean RestoreDataArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && (single_value->field_lmsi.is_omit() || single_value->field_lmsi.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_vlr__Capability.is_omit() || single_value->field_vlr__Capability.is_value())
 && (single_value->field_restorationIndicator.is_omit() || single_value->field_restorationIndicator.is_value());
}

void RestoreDataArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RestoreDataArg RestoreDataArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
RestoreDataArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_lmsi.is_omit()) ret_val.lmsi() = OMIT_VALUE;
else if (single_value->field_lmsi.is_bound()) {
ret_val.lmsi() = single_value->field_lmsi.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_vlr__Capability.is_omit()) ret_val.vlr__Capability() = OMIT_VALUE;
else if (single_value->field_vlr__Capability.is_bound()) {
ret_val.vlr__Capability() = single_value->field_vlr__Capability.valueof();
}
if (single_value->field_restorationIndicator.is_omit()) ret_val.restorationIndicator() = OMIT_VALUE;
else if (single_value->field_restorationIndicator.is_bound()) {
ret_val.restorationIndicator() = single_value->field_restorationIndicator.valueof();
}
return ret_val;
}

void RestoreDataArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.RestoreDataArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RestoreDataArg_template[list_length];
}

RestoreDataArg_template& RestoreDataArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.RestoreDataArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.RestoreDataArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RestoreDataArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& RestoreDataArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
return single_value->field_imsi;
}

OCTETSTRING_template& RestoreDataArg_template::lmsi()
{
set_specific();
return single_value->field_lmsi;
}

const OCTETSTRING_template& RestoreDataArg_template::lmsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lmsi of a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
return single_value->field_lmsi;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& RestoreDataArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& RestoreDataArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
return single_value->field_extensionContainer;
}

VLR__Capability_template& RestoreDataArg_template::vlr__Capability()
{
set_specific();
return single_value->field_vlr__Capability;
}

const VLR__Capability_template& RestoreDataArg_template::vlr__Capability() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vlr_Capability of a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
return single_value->field_vlr__Capability;
}

ASN_NULL_template& RestoreDataArg_template::restorationIndicator()
{
set_specific();
return single_value->field_restorationIndicator;
}

const ASN_NULL_template& RestoreDataArg_template::restorationIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field restorationIndicator of a non-specific template of type @MAP-MS-DataTypes.RestoreDataArg.");
return single_value->field_restorationIndicator;
}

int RestoreDataArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_lmsi.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_vlr__Capability.is_present()) ret_val++;
      if (single_value->field_restorationIndicator.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataArg.");
  }
  return 0;
}

void RestoreDataArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", lmsi := ");
single_value->field_lmsi.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", vlr_Capability := ");
single_value->field_vlr__Capability.log();
TTCN_Logger::log_event_str(", restorationIndicator := ");
single_value->field_restorationIndicator.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RestoreDataArg_template::log_match(const RestoreDataArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.lmsi().ispresent()){
if(!single_value->field_lmsi.match(match_value.lmsi(), legacy)){
TTCN_Logger::log_logmatch_info(".lmsi");
single_value->field_lmsi.log_match(match_value.lmsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lmsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lmsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lmsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vlr__Capability().ispresent()){
if(!single_value->field_vlr__Capability.match(match_value.vlr__Capability(), legacy)){
TTCN_Logger::log_logmatch_info(".vlr_Capability");
single_value->field_vlr__Capability.log_match(match_value.vlr__Capability(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vlr__Capability.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vlr_Capability := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vlr__Capability.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.restorationIndicator().ispresent()){
if(!single_value->field_restorationIndicator.match(match_value.restorationIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".restorationIndicator");
single_value->field_restorationIndicator.log_match(match_value.restorationIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_restorationIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".restorationIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_restorationIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", lmsi := ");
if (match_value.lmsi().ispresent()) {
single_value->field_lmsi.log_match(match_value.lmsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lmsi.log();
if (single_value->field_lmsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vlr_Capability := ");
if (match_value.vlr__Capability().ispresent()) {
single_value->field_vlr__Capability.log_match(match_value.vlr__Capability(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vlr__Capability.log();
if (single_value->field_vlr__Capability.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", restorationIndicator := ");
if (match_value.restorationIndicator().ispresent()) {
single_value->field_restorationIndicator.log_match(match_value.restorationIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_restorationIndicator.log();
if (single_value->field_restorationIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RestoreDataArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (!lmsi().is_bound()) lmsi() = OMIT_VALUE;
else lmsi().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!vlr__Capability().is_bound()) vlr__Capability() = OMIT_VALUE;
else vlr__Capability().set_implicit_omit();
if (!restorationIndicator().is_bound()) restorationIndicator() = OMIT_VALUE;
else restorationIndicator().set_implicit_omit();
}

void RestoreDataArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_lmsi.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_vlr__Capability.encode_text(text_buf);
single_value->field_restorationIndicator.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataArg.");
}
}

void RestoreDataArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_lmsi.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_vlr__Capability.decode_text(text_buf);
single_value->field_restorationIndicator.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RestoreDataArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.RestoreDataArg.");
}
}

void RestoreDataArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RestoreDataArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.RestoreDataArg has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lmsi().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) vlr__Capability().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) restorationIndicator().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "restorationIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          restorationIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RestoreDataArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RestoreDataArg_template* precondition = new RestoreDataArg_template;
    precondition->set_param(*param.get_elem(0));
    RestoreDataArg_template* implied_template = new RestoreDataArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RestoreDataArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.RestoreDataArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void RestoreDataArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
single_value->field_lmsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
single_value->field_vlr__Capability.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
single_value->field_restorationIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataArg");
}

boolean RestoreDataArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RestoreDataArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RestoreDataRes::RestoreDataRes()
{
}

RestoreDataRes::RestoreDataRes(const OCTETSTRING& par_hlr__Number,
    const OPTIONAL< ASN_NULL >& par_msNotReachable,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_hlr__Number(par_hlr__Number),
  field_msNotReachable(par_msNotReachable),
  field_extensionContainer(par_extensionContainer)
{
}

RestoreDataRes::RestoreDataRes(const RestoreDataRes& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.RestoreDataRes.");
if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
else field_hlr__Number.clean_up();
if (other_value.msNotReachable().is_bound()) field_msNotReachable = other_value.msNotReachable();
else field_msNotReachable.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void RestoreDataRes::clean_up()
{
field_hlr__Number.clean_up();
field_msNotReachable.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* RestoreDataRes::get_descriptor() const { return &RestoreDataRes_descr_; }
RestoreDataRes& RestoreDataRes::operator=(const RestoreDataRes& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.RestoreDataRes.");
  if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
  else field_hlr__Number.clean_up();
  if (other_value.msNotReachable().is_bound()) field_msNotReachable = other_value.msNotReachable();
  else field_msNotReachable.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean RestoreDataRes::operator==(const RestoreDataRes& other_value) const
{
return field_hlr__Number==other_value.field_hlr__Number
  && field_msNotReachable==other_value.field_msNotReachable
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean RestoreDataRes::is_bound() const
{
return (field_hlr__Number.is_bound())
  || (OPTIONAL_OMIT == field_msNotReachable.get_selection() || field_msNotReachable.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean RestoreDataRes::is_value() const
{
return field_hlr__Number.is_value()
  && (OPTIONAL_OMIT == field_msNotReachable.get_selection() || field_msNotReachable.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int RestoreDataRes::size_of() const
{
  int ret_val = 1;
  if (field_msNotReachable.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void RestoreDataRes::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ hlr_Number := ");
field_hlr__Number.log();
TTCN_Logger::log_event_str(", msNotReachable := ");
field_msNotReachable.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void RestoreDataRes::set_implicit_omit()
{
if (hlr__Number().is_bound()) hlr__Number().set_implicit_omit();
if (!msNotReachable().is_bound()) msNotReachable() = OMIT_VALUE;
else msNotReachable().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void RestoreDataRes::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.RestoreDataRes has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) hlr__Number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msNotReachable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msNotReachable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msNotReachable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RestoreDataRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.RestoreDataRes");
  }
}

void RestoreDataRes::encode_text(Text_Buf& text_buf) const
{
field_hlr__Number.encode_text(text_buf);
field_msNotReachable.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void RestoreDataRes::decode_text(Text_Buf& text_buf)
{
field_hlr__Number.decode_text(text_buf);
field_msNotReachable.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void RestoreDataRes::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RestoreDataRes::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* RestoreDataRes::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("hlr_Number': ");
  new_tlv->add_TLV(field_hlr__Number.BER_encode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_coding));
  ec_1.set_msg("msNotReachable': ");
  new_tlv->add_TLV(field_msNotReachable.BER_encode_TLV(ASN_NULL_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(RestoreDataRes_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean RestoreDataRes::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.RestoreDataRes' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("hlr_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_hlr__Number.BER_decode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("msNotReachable': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_msNotReachable=OMIT_VALUE;
    else {
      field_msNotReachable.BER_decode_TLV(ASN_NULL_descr_, tmp_tlv, L_form);
      if(field_msNotReachable.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(RestoreDataRes_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int RestoreDataRes::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.RestoreDataRes.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "hlr_Number");
    enc_len += field_hlr__Number.JSON_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, FALSE);
  }

  if (field_msNotReachable.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "msNotReachable");
    enc_len += field_msNotReachable.JSON_encode(ASN_NULL_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(RestoreDataRes_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int RestoreDataRes::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const RestoreDataRes*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean hlr__Number_found = FALSE;
  boolean msNotReachable_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (10 == name_len && 0 == strncmp(fld_name, "hlr_Number", name_len)) {
        hlr__Number_found = TRUE;
         int ret_val = field_hlr__Number.JSON_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "hlr_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "msNotReachable", name_len)) {
        msNotReachable_found = TRUE;
         int ret_val = field_msNotReachable.JSON_decode(ASN_NULL_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "msNotReachable");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(RestoreDataRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!hlr__Number_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "hlr_Number");
    return JSON_ERROR_FATAL;
  }
  if (!msNotReachable_found) {
    field_msNotReachable = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int RestoreDataRes::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_msNotReachable.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_hlr__Number.OER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf);
  if (field_msNotReachable.is_present())
    field_msNotReachable.OER_encode(ASN_NULL_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(RestoreDataRes_extensionContainer_descr_, p_buf);
  return 0;
}

int RestoreDataRes::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_hlr__Number.OER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_msNotReachable.OER_decode(ASN_NULL_descr_, p_buf, p_oer);
 else
    field_msNotReachable = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(RestoreDataRes_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void RestoreDataRes::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_msNotReachable_present = field_msNotReachable.is_present();
p_buf.PER_put_bit(field_msNotReachable_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_hlr__Number.PER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_msNotReachable_present) field_msNotReachable.PER_encode(ASN_NULL_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(RestoreDataRes_extensionContainer_descr_, p_buf, p_options);
}

void RestoreDataRes::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_msNotReachable_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_hlr__Number.PER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_msNotReachable_present) field_msNotReachable.PER_decode(ASN_NULL_descr_, p_buf, p_options);
else field_msNotReachable = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(RestoreDataRes_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct RestoreDataRes_template::single_value_struct {
OCTETSTRING_template field_hlr__Number;
ASN_NULL_template field_msNotReachable;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void RestoreDataRes_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_hlr__Number = ANY_VALUE;
single_value->field_msNotReachable = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void RestoreDataRes_template::copy_value(const RestoreDataRes& other_value)
{
single_value = new single_value_struct;
if (other_value.hlr__Number().is_bound()) {
  single_value->field_hlr__Number = other_value.hlr__Number();
} else {
  single_value->field_hlr__Number.clean_up();
}
if (other_value.msNotReachable().is_bound()) {
  if (other_value.msNotReachable().ispresent()) single_value->field_msNotReachable = other_value.msNotReachable()();
  else single_value->field_msNotReachable = OMIT_VALUE;
} else {
  single_value->field_msNotReachable.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RestoreDataRes_template::copy_template(const RestoreDataRes_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.hlr__Number().get_selection()) {
single_value->field_hlr__Number = other_value.hlr__Number();
} else {
single_value->field_hlr__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msNotReachable().get_selection()) {
single_value->field_msNotReachable = other_value.msNotReachable();
} else {
single_value->field_msNotReachable.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RestoreDataRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RestoreDataRes_template(*other_value.implication_.precondition);
implication_.implied_template = new RestoreDataRes_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataRes.");
break;
}
set_selection(other_value);
}

RestoreDataRes_template::RestoreDataRes_template()
{
}

RestoreDataRes_template::RestoreDataRes_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RestoreDataRes_template::RestoreDataRes_template(const RestoreDataRes& other_value)
{
copy_value(other_value);
}

RestoreDataRes_template::RestoreDataRes_template(const OPTIONAL<RestoreDataRes>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RestoreDataRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.RestoreDataRes from an unbound optional field.");
}
}

RestoreDataRes_template::RestoreDataRes_template(RestoreDataRes_template* p_precondition, RestoreDataRes_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RestoreDataRes_template::RestoreDataRes_template(Dynamic_Match_Interface<RestoreDataRes>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RestoreDataRes>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RestoreDataRes_template::RestoreDataRes_template(const RestoreDataRes_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RestoreDataRes_template::~RestoreDataRes_template()
{
clean_up();
}

RestoreDataRes_template& RestoreDataRes_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RestoreDataRes_template& RestoreDataRes_template::operator=(const RestoreDataRes& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RestoreDataRes_template& RestoreDataRes_template::operator=(const OPTIONAL<RestoreDataRes>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RestoreDataRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.RestoreDataRes.");
}
return *this;
}

RestoreDataRes_template& RestoreDataRes_template::operator=(const RestoreDataRes_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RestoreDataRes_template::match(const RestoreDataRes& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.hlr__Number().is_bound()) return FALSE;
if(!single_value->field_hlr__Number.match(other_value.hlr__Number(), legacy))return FALSE;
if(!other_value.msNotReachable().is_bound()) return FALSE;
if((other_value.msNotReachable().ispresent() ? !single_value->field_msNotReachable.match((const ASN_NULL&)other_value.msNotReachable(), legacy) : !single_value->field_msNotReachable.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataRes.");
}
return FALSE;
}

boolean RestoreDataRes_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_hlr__Number.is_bound()
 || (single_value->field_msNotReachable.is_omit() || single_value->field_msNotReachable.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean RestoreDataRes_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_hlr__Number.is_value()
 && (single_value->field_msNotReachable.is_omit() || single_value->field_msNotReachable.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void RestoreDataRes_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RestoreDataRes RestoreDataRes_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.RestoreDataRes.");
RestoreDataRes ret_val;
if (single_value->field_hlr__Number.is_bound()) {
ret_val.hlr__Number() = single_value->field_hlr__Number.valueof();
}
if (single_value->field_msNotReachable.is_omit()) ret_val.msNotReachable() = OMIT_VALUE;
else if (single_value->field_msNotReachable.is_bound()) {
ret_val.msNotReachable() = single_value->field_msNotReachable.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void RestoreDataRes_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.RestoreDataRes.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RestoreDataRes_template[list_length];
}

RestoreDataRes_template& RestoreDataRes_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.RestoreDataRes.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.RestoreDataRes.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RestoreDataRes_template::hlr__Number()
{
set_specific();
return single_value->field_hlr__Number;
}

const OCTETSTRING_template& RestoreDataRes_template::hlr__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field hlr_Number of a non-specific template of type @MAP-MS-DataTypes.RestoreDataRes.");
return single_value->field_hlr__Number;
}

ASN_NULL_template& RestoreDataRes_template::msNotReachable()
{
set_specific();
return single_value->field_msNotReachable;
}

const ASN_NULL_template& RestoreDataRes_template::msNotReachable() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msNotReachable of a non-specific template of type @MAP-MS-DataTypes.RestoreDataRes.");
return single_value->field_msNotReachable;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& RestoreDataRes_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& RestoreDataRes_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.RestoreDataRes.");
return single_value->field_extensionContainer;
}

int RestoreDataRes_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_msNotReachable.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RestoreDataRes containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataRes.");
  }
  return 0;
}

void RestoreDataRes_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ hlr_Number := ");
single_value->field_hlr__Number.log();
TTCN_Logger::log_event_str(", msNotReachable := ");
single_value->field_msNotReachable.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RestoreDataRes_template::log_match(const RestoreDataRes& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_hlr__Number.match(match_value.hlr__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".hlr_Number");
single_value->field_hlr__Number.log_match(match_value.hlr__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.msNotReachable().ispresent()){
if(!single_value->field_msNotReachable.match(match_value.msNotReachable(), legacy)){
TTCN_Logger::log_logmatch_info(".msNotReachable");
single_value->field_msNotReachable.log_match(match_value.msNotReachable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_msNotReachable.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".msNotReachable := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_msNotReachable.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ hlr_Number := ");
single_value->field_hlr__Number.log_match(match_value.hlr__Number(), legacy);
TTCN_Logger::log_event_str(", msNotReachable := ");
if (match_value.msNotReachable().ispresent()) {
single_value->field_msNotReachable.log_match(match_value.msNotReachable(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_msNotReachable.log();
if (single_value->field_msNotReachable.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RestoreDataRes_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (hlr__Number().is_bound()) hlr__Number().set_implicit_omit();
if (!msNotReachable().is_bound()) msNotReachable() = OMIT_VALUE;
else msNotReachable().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void RestoreDataRes_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_hlr__Number.encode_text(text_buf);
single_value->field_msNotReachable.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.RestoreDataRes.");
}
}

void RestoreDataRes_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_hlr__Number.decode_text(text_buf);
single_value->field_msNotReachable.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RestoreDataRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.RestoreDataRes.");
}
}

void RestoreDataRes_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RestoreDataRes_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.RestoreDataRes has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) hlr__Number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msNotReachable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msNotReachable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msNotReachable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RestoreDataRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RestoreDataRes_template* precondition = new RestoreDataRes_template;
    precondition->set_param(*param.get_elem(0));
    RestoreDataRes_template* implied_template = new RestoreDataRes_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RestoreDataRes_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.RestoreDataRes");
  }
  is_ifpresent = param.get_ifpresent();
}

void RestoreDataRes_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_hlr__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataRes");
single_value->field_msNotReachable.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataRes");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataRes");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.RestoreDataRes");
}

boolean RestoreDataRes_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RestoreDataRes_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RequestedInfo::RequestedInfo()
{
}

RequestedInfo::RequestedInfo(const OPTIONAL< ASN_NULL >& par_locationInformation,
    const OPTIONAL< ASN_NULL >& par_subscriberState,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< ASN_NULL >& par_currentLocation,
    const OPTIONAL< DomainType >& par_requestedDomain,
    const OPTIONAL< ASN_NULL >& par_imei,
    const OPTIONAL< ASN_NULL >& par_ms__classmark,
    const OPTIONAL< ASN_NULL >& par_mnpRequestedInfo,
    const OPTIONAL< ASN_NULL >& par_locationInformationEPS__Supported,
    const OPTIONAL< ASN_NULL >& par_t__adsData,
    const OPTIONAL< BITSTRING >& par_requestedNodes,
    const OPTIONAL< ASN_NULL >& par_servingNodeIndication)
  :   field_locationInformation(par_locationInformation),
  field_subscriberState(par_subscriberState),
  field_extensionContainer(par_extensionContainer),
  field_currentLocation(par_currentLocation),
  field_requestedDomain(par_requestedDomain),
  field_imei(par_imei),
  field_ms__classmark(par_ms__classmark),
  field_mnpRequestedInfo(par_mnpRequestedInfo),
  field_locationInformationEPS__Supported(par_locationInformationEPS__Supported),
  field_t__adsData(par_t__adsData),
  field_requestedNodes(par_requestedNodes),
  field_servingNodeIndication(par_servingNodeIndication)
{
}

RequestedInfo::RequestedInfo(const RequestedInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.RequestedInfo.");
if (other_value.locationInformation().is_bound()) field_locationInformation = other_value.locationInformation();
else field_locationInformation.clean_up();
if (other_value.subscriberState().is_bound()) field_subscriberState = other_value.subscriberState();
else field_subscriberState.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.currentLocation().is_bound()) field_currentLocation = other_value.currentLocation();
else field_currentLocation.clean_up();
if (other_value.requestedDomain().is_bound()) field_requestedDomain = other_value.requestedDomain();
else field_requestedDomain.clean_up();
if (other_value.imei().is_bound()) field_imei = other_value.imei();
else field_imei.clean_up();
if (other_value.ms__classmark().is_bound()) field_ms__classmark = other_value.ms__classmark();
else field_ms__classmark.clean_up();
if (other_value.mnpRequestedInfo().is_bound()) field_mnpRequestedInfo = other_value.mnpRequestedInfo();
else field_mnpRequestedInfo.clean_up();
if (other_value.locationInformationEPS__Supported().is_bound()) field_locationInformationEPS__Supported = other_value.locationInformationEPS__Supported();
else field_locationInformationEPS__Supported.clean_up();
if (other_value.t__adsData().is_bound()) field_t__adsData = other_value.t__adsData();
else field_t__adsData.clean_up();
if (other_value.requestedNodes().is_bound()) field_requestedNodes = other_value.requestedNodes();
else field_requestedNodes.clean_up();
if (other_value.servingNodeIndication().is_bound()) field_servingNodeIndication = other_value.servingNodeIndication();
else field_servingNodeIndication.clean_up();
}

void RequestedInfo::clean_up()
{
field_locationInformation.clean_up();
field_subscriberState.clean_up();
field_extensionContainer.clean_up();
field_currentLocation.clean_up();
field_requestedDomain.clean_up();
field_imei.clean_up();
field_ms__classmark.clean_up();
field_mnpRequestedInfo.clean_up();
field_locationInformationEPS__Supported.clean_up();
field_t__adsData.clean_up();
field_requestedNodes.clean_up();
field_servingNodeIndication.clean_up();
}

const TTCN_Typedescriptor_t* RequestedInfo::get_descriptor() const { return &RequestedInfo_descr_; }
RequestedInfo& RequestedInfo::operator=(const RequestedInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.RequestedInfo.");
  if (other_value.locationInformation().is_bound()) field_locationInformation = other_value.locationInformation();
  else field_locationInformation.clean_up();
  if (other_value.subscriberState().is_bound()) field_subscriberState = other_value.subscriberState();
  else field_subscriberState.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.currentLocation().is_bound()) field_currentLocation = other_value.currentLocation();
  else field_currentLocation.clean_up();
  if (other_value.requestedDomain().is_bound()) field_requestedDomain = other_value.requestedDomain();
  else field_requestedDomain.clean_up();
  if (other_value.imei().is_bound()) field_imei = other_value.imei();
  else field_imei.clean_up();
  if (other_value.ms__classmark().is_bound()) field_ms__classmark = other_value.ms__classmark();
  else field_ms__classmark.clean_up();
  if (other_value.mnpRequestedInfo().is_bound()) field_mnpRequestedInfo = other_value.mnpRequestedInfo();
  else field_mnpRequestedInfo.clean_up();
  if (other_value.locationInformationEPS__Supported().is_bound()) field_locationInformationEPS__Supported = other_value.locationInformationEPS__Supported();
  else field_locationInformationEPS__Supported.clean_up();
  if (other_value.t__adsData().is_bound()) field_t__adsData = other_value.t__adsData();
  else field_t__adsData.clean_up();
  if (other_value.requestedNodes().is_bound()) field_requestedNodes = other_value.requestedNodes();
  else field_requestedNodes.clean_up();
  if (other_value.servingNodeIndication().is_bound()) field_servingNodeIndication = other_value.servingNodeIndication();
  else field_servingNodeIndication.clean_up();
}
return *this;
}

boolean RequestedInfo::operator==(const RequestedInfo& other_value) const
{
return field_locationInformation==other_value.field_locationInformation
  && field_subscriberState==other_value.field_subscriberState
  && field_extensionContainer==other_value.field_extensionContainer
  && field_currentLocation==other_value.field_currentLocation
  && field_requestedDomain==other_value.field_requestedDomain
  && field_imei==other_value.field_imei
  && field_ms__classmark==other_value.field_ms__classmark
  && field_mnpRequestedInfo==other_value.field_mnpRequestedInfo
  && field_locationInformationEPS__Supported==other_value.field_locationInformationEPS__Supported
  && field_t__adsData==other_value.field_t__adsData
  && field_requestedNodes==other_value.field_requestedNodes
  && field_servingNodeIndication==other_value.field_servingNodeIndication;
}

boolean RequestedInfo::is_bound() const
{
return (OPTIONAL_OMIT == field_locationInformation.get_selection() || field_locationInformation.is_bound())
  || (OPTIONAL_OMIT == field_subscriberState.get_selection() || field_subscriberState.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_currentLocation.get_selection() || field_currentLocation.is_bound())
  || (OPTIONAL_OMIT == field_requestedDomain.get_selection() || field_requestedDomain.is_bound())
  || (OPTIONAL_OMIT == field_imei.get_selection() || field_imei.is_bound())
  || (OPTIONAL_OMIT == field_ms__classmark.get_selection() || field_ms__classmark.is_bound())
  || (OPTIONAL_OMIT == field_mnpRequestedInfo.get_selection() || field_mnpRequestedInfo.is_bound())
  || (OPTIONAL_OMIT == field_locationInformationEPS__Supported.get_selection() || field_locationInformationEPS__Supported.is_bound())
  || (OPTIONAL_OMIT == field_t__adsData.get_selection() || field_t__adsData.is_bound())
  || (OPTIONAL_OMIT == field_requestedNodes.get_selection() || field_requestedNodes.is_bound())
  || (OPTIONAL_OMIT == field_servingNodeIndication.get_selection() || field_servingNodeIndication.is_bound());
}
boolean RequestedInfo::is_value() const
{
return (OPTIONAL_OMIT == field_locationInformation.get_selection() || field_locationInformation.is_value())
  && (OPTIONAL_OMIT == field_subscriberState.get_selection() || field_subscriberState.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_currentLocation.get_selection() || field_currentLocation.is_value())
  && (OPTIONAL_OMIT == field_requestedDomain.get_selection() || field_requestedDomain.is_value())
  && (OPTIONAL_OMIT == field_imei.get_selection() || field_imei.is_value())
  && (OPTIONAL_OMIT == field_ms__classmark.get_selection() || field_ms__classmark.is_value())
  && (OPTIONAL_OMIT == field_mnpRequestedInfo.get_selection() || field_mnpRequestedInfo.is_value())
  && (OPTIONAL_OMIT == field_locationInformationEPS__Supported.get_selection() || field_locationInformationEPS__Supported.is_value())
  && (OPTIONAL_OMIT == field_t__adsData.get_selection() || field_t__adsData.is_value())
  && (OPTIONAL_OMIT == field_requestedNodes.get_selection() || field_requestedNodes.is_value())
  && (OPTIONAL_OMIT == field_servingNodeIndication.get_selection() || field_servingNodeIndication.is_value());
}
int RequestedInfo::size_of() const
{
  int ret_val = 0;
  if (field_locationInformation.ispresent()) ret_val++;
  if (field_subscriberState.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_currentLocation.ispresent()) ret_val++;
  if (field_requestedDomain.ispresent()) ret_val++;
  if (field_imei.ispresent()) ret_val++;
  if (field_ms__classmark.ispresent()) ret_val++;
  if (field_mnpRequestedInfo.ispresent()) ret_val++;
  if (field_locationInformationEPS__Supported.ispresent()) ret_val++;
  if (field_t__adsData.ispresent()) ret_val++;
  if (field_requestedNodes.ispresent()) ret_val++;
  if (field_servingNodeIndication.ispresent()) ret_val++;
  return ret_val;
}

void RequestedInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ locationInformation := ");
field_locationInformation.log();
TTCN_Logger::log_event_str(", subscriberState := ");
field_subscriberState.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", currentLocation := ");
field_currentLocation.log();
TTCN_Logger::log_event_str(", requestedDomain := ");
field_requestedDomain.log();
TTCN_Logger::log_event_str(", imei := ");
field_imei.log();
TTCN_Logger::log_event_str(", ms_classmark := ");
field_ms__classmark.log();
TTCN_Logger::log_event_str(", mnpRequestedInfo := ");
field_mnpRequestedInfo.log();
TTCN_Logger::log_event_str(", locationInformationEPS_Supported := ");
field_locationInformationEPS__Supported.log();
TTCN_Logger::log_event_str(", t_adsData := ");
field_t__adsData.log();
TTCN_Logger::log_event_str(", requestedNodes := ");
field_requestedNodes.log();
TTCN_Logger::log_event_str(", servingNodeIndication := ");
field_servingNodeIndication.log();
TTCN_Logger::log_event_str(" }");
}

void RequestedInfo::set_implicit_omit()
{
if (!locationInformation().is_bound()) locationInformation() = OMIT_VALUE;
else locationInformation().set_implicit_omit();
if (!subscriberState().is_bound()) subscriberState() = OMIT_VALUE;
else subscriberState().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!currentLocation().is_bound()) currentLocation() = OMIT_VALUE;
else currentLocation().set_implicit_omit();
if (!requestedDomain().is_bound()) requestedDomain() = OMIT_VALUE;
else requestedDomain().set_implicit_omit();
if (!imei().is_bound()) imei() = OMIT_VALUE;
else imei().set_implicit_omit();
if (!ms__classmark().is_bound()) ms__classmark() = OMIT_VALUE;
else ms__classmark().set_implicit_omit();
if (!mnpRequestedInfo().is_bound()) mnpRequestedInfo() = OMIT_VALUE;
else mnpRequestedInfo().set_implicit_omit();
if (!locationInformationEPS__Supported().is_bound()) locationInformationEPS__Supported() = OMIT_VALUE;
else locationInformationEPS__Supported().set_implicit_omit();
if (!t__adsData().is_bound()) t__adsData() = OMIT_VALUE;
else t__adsData().set_implicit_omit();
if (!requestedNodes().is_bound()) requestedNodes() = OMIT_VALUE;
else requestedNodes().set_implicit_omit();
if (!servingNodeIndication().is_bound()) servingNodeIndication() = OMIT_VALUE;
else servingNodeIndication().set_implicit_omit();
}

void RequestedInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.RequestedInfo has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) locationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) subscriberState().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) currentLocation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) requestedDomain().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) imei().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ms__classmark().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mnpRequestedInfo().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS__Supported().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) t__adsData().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) requestedNodes().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) servingNodeIndication().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedDomain")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedDomain().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imei")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imei().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_classmark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__classmark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mnpRequestedInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mnpRequestedInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS_Supported")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS__Supported().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_adsData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__adsData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNodes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNodes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "servingNodeIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          servingNodeIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RequestedInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.RequestedInfo");
  }
}

void RequestedInfo::encode_text(Text_Buf& text_buf) const
{
field_locationInformation.encode_text(text_buf);
field_subscriberState.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_currentLocation.encode_text(text_buf);
field_requestedDomain.encode_text(text_buf);
field_imei.encode_text(text_buf);
field_ms__classmark.encode_text(text_buf);
field_mnpRequestedInfo.encode_text(text_buf);
field_locationInformationEPS__Supported.encode_text(text_buf);
field_t__adsData.encode_text(text_buf);
field_requestedNodes.encode_text(text_buf);
field_servingNodeIndication.encode_text(text_buf);
}

void RequestedInfo::decode_text(Text_Buf& text_buf)
{
field_locationInformation.decode_text(text_buf);
field_subscriberState.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_currentLocation.decode_text(text_buf);
field_requestedDomain.decode_text(text_buf);
field_imei.decode_text(text_buf);
field_ms__classmark.decode_text(text_buf);
field_mnpRequestedInfo.decode_text(text_buf);
field_locationInformationEPS__Supported.decode_text(text_buf);
field_t__adsData.decode_text(text_buf);
field_requestedNodes.decode_text(text_buf);
field_servingNodeIndication.decode_text(text_buf);
}

void RequestedInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RequestedInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* RequestedInfo::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("locationInformation': ");
  new_tlv->add_TLV(field_locationInformation.BER_encode_TLV(RequestedInfo_locationInformation_descr_, p_coding));
  ec_1.set_msg("subscriberState': ");
  new_tlv->add_TLV(field_subscriberState.BER_encode_TLV(RequestedInfo_subscriberState_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(RequestedInfo_extensionContainer_descr_, p_coding));
  ec_1.set_msg("currentLocation': ");
  new_tlv->add_TLV(field_currentLocation.BER_encode_TLV(RequestedInfo_currentLocation_descr_, p_coding));
  ec_1.set_msg("requestedDomain': ");
  new_tlv->add_TLV(field_requestedDomain.BER_encode_TLV(RequestedInfo_requestedDomain_descr_, p_coding));
  ec_1.set_msg("imei': ");
  new_tlv->add_TLV(field_imei.BER_encode_TLV(RequestedInfo_imei_descr_, p_coding));
  ec_1.set_msg("ms_classmark': ");
  new_tlv->add_TLV(field_ms__classmark.BER_encode_TLV(RequestedInfo_ms__classmark_descr_, p_coding));
  ec_1.set_msg("mnpRequestedInfo': ");
  new_tlv->add_TLV(field_mnpRequestedInfo.BER_encode_TLV(RequestedInfo_mnpRequestedInfo_descr_, p_coding));
  ec_1.set_msg("locationInformationEPS_Supported': ");
  new_tlv->add_TLV(field_locationInformationEPS__Supported.BER_encode_TLV(RequestedInfo_locationInformationEPS__Supported_descr_, p_coding));
  ec_1.set_msg("t_adsData': ");
  new_tlv->add_TLV(field_t__adsData.BER_encode_TLV(RequestedInfo_t__adsData_descr_, p_coding));
  ec_1.set_msg("requestedNodes': ");
  new_tlv->add_TLV(field_requestedNodes.BER_encode_TLV(RequestedInfo_requestedNodes_descr_, p_coding));
  ec_1.set_msg("servingNodeIndication': ");
  new_tlv->add_TLV(field_servingNodeIndication.BER_encode_TLV(RequestedInfo_servingNodeIndication_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean RequestedInfo::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.RequestedInfo' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("locationInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformation=OMIT_VALUE;
    else {
      field_locationInformation.BER_decode_TLV(RequestedInfo_locationInformation_descr_, tmp_tlv, L_form);
      if(field_locationInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("subscriberState': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_subscriberState=OMIT_VALUE;
    else {
      field_subscriberState.BER_decode_TLV(RequestedInfo_subscriberState_descr_, tmp_tlv, L_form);
      if(field_subscriberState.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(RequestedInfo_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("currentLocation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_currentLocation=OMIT_VALUE;
    else {
      field_currentLocation.BER_decode_TLV(RequestedInfo_currentLocation_descr_, tmp_tlv, L_form);
      if(field_currentLocation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("requestedDomain': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_requestedDomain=OMIT_VALUE;
    else {
      field_requestedDomain.BER_decode_TLV(RequestedInfo_requestedDomain_descr_, tmp_tlv, L_form);
      if(field_requestedDomain.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("imei': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_imei=OMIT_VALUE;
    else {
      field_imei.BER_decode_TLV(RequestedInfo_imei_descr_, tmp_tlv, L_form);
      if(field_imei.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ms_classmark': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ms__classmark=OMIT_VALUE;
    else {
      field_ms__classmark.BER_decode_TLV(RequestedInfo_ms__classmark_descr_, tmp_tlv, L_form);
      if(field_ms__classmark.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mnpRequestedInfo': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mnpRequestedInfo=OMIT_VALUE;
    else {
      field_mnpRequestedInfo.BER_decode_TLV(RequestedInfo_mnpRequestedInfo_descr_, tmp_tlv, L_form);
      if(field_mnpRequestedInfo.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("locationInformationEPS_Supported': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformationEPS__Supported=OMIT_VALUE;
    else {
      field_locationInformationEPS__Supported.BER_decode_TLV(RequestedInfo_locationInformationEPS__Supported_descr_, tmp_tlv, L_form);
      if(field_locationInformationEPS__Supported.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("t_adsData': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_t__adsData=OMIT_VALUE;
    else {
      field_t__adsData.BER_decode_TLV(RequestedInfo_t__adsData_descr_, tmp_tlv, L_form);
      if(field_t__adsData.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("requestedNodes': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_requestedNodes=OMIT_VALUE;
    else {
      field_requestedNodes.BER_decode_TLV(RequestedInfo_requestedNodes_descr_, tmp_tlv, L_form);
      if(field_requestedNodes.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("servingNodeIndication': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_servingNodeIndication=OMIT_VALUE;
    else {
      field_servingNodeIndication.BER_decode_TLV(RequestedInfo_servingNodeIndication_descr_, tmp_tlv, L_form);
      if(field_servingNodeIndication.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int RequestedInfo::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.RequestedInfo.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_locationInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformation");
    enc_len += field_locationInformation.JSON_encode(RequestedInfo_locationInformation_descr_, p_tok, FALSE);
  }

  if (field_subscriberState.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "subscriberState");
    enc_len += field_subscriberState.JSON_encode(RequestedInfo_subscriberState_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(RequestedInfo_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_currentLocation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "currentLocation");
    enc_len += field_currentLocation.JSON_encode(RequestedInfo_currentLocation_descr_, p_tok, FALSE);
  }

  if (field_requestedDomain.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "requestedDomain");
    enc_len += field_requestedDomain.JSON_encode(RequestedInfo_requestedDomain_descr_, p_tok, FALSE);
  }

  if (field_imei.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imei");
    enc_len += field_imei.JSON_encode(RequestedInfo_imei_descr_, p_tok, FALSE);
  }

  if (field_ms__classmark.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ms_classmark");
    enc_len += field_ms__classmark.JSON_encode(RequestedInfo_ms__classmark_descr_, p_tok, FALSE);
  }

  if (field_mnpRequestedInfo.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mnpRequestedInfo");
    enc_len += field_mnpRequestedInfo.JSON_encode(RequestedInfo_mnpRequestedInfo_descr_, p_tok, FALSE);
  }

  if (field_locationInformationEPS__Supported.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformationEPS_Supported");
    enc_len += field_locationInformationEPS__Supported.JSON_encode(RequestedInfo_locationInformationEPS__Supported_descr_, p_tok, FALSE);
  }

  if (field_t__adsData.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "t_adsData");
    enc_len += field_t__adsData.JSON_encode(RequestedInfo_t__adsData_descr_, p_tok, FALSE);
  }

  if (field_requestedNodes.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "requestedNodes");
    enc_len += field_requestedNodes.JSON_encode(RequestedInfo_requestedNodes_descr_, p_tok, FALSE);
  }

  if (field_servingNodeIndication.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "servingNodeIndication");
    enc_len += field_servingNodeIndication.JSON_encode(RequestedInfo_servingNodeIndication_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int RequestedInfo::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const RequestedInfo*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean locationInformation_found = FALSE;
  boolean subscriberState_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean currentLocation_found = FALSE;
  boolean requestedDomain_found = FALSE;
  boolean imei_found = FALSE;
  boolean ms__classmark_found = FALSE;
  boolean mnpRequestedInfo_found = FALSE;
  boolean locationInformationEPS__Supported_found = FALSE;
  boolean t__adsData_found = FALSE;
  boolean requestedNodes_found = FALSE;
  boolean servingNodeIndication_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (19 == name_len && 0 == strncmp(fld_name, "locationInformation", name_len)) {
        locationInformation_found = TRUE;
         int ret_val = field_locationInformation.JSON_decode(RequestedInfo_locationInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "locationInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "subscriberState", name_len)) {
        subscriberState_found = TRUE;
         int ret_val = field_subscriberState.JSON_decode(RequestedInfo_subscriberState_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "subscriberState");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(RequestedInfo_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "currentLocation", name_len)) {
        currentLocation_found = TRUE;
         int ret_val = field_currentLocation.JSON_decode(RequestedInfo_currentLocation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "currentLocation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "requestedDomain", name_len)) {
        requestedDomain_found = TRUE;
         int ret_val = field_requestedDomain.JSON_decode(RequestedInfo_requestedDomain_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "requestedDomain");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "imei", name_len)) {
        imei_found = TRUE;
         int ret_val = field_imei.JSON_decode(RequestedInfo_imei_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imei");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "ms_classmark", name_len)) {
        ms__classmark_found = TRUE;
         int ret_val = field_ms__classmark.JSON_decode(RequestedInfo_ms__classmark_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "ms_classmark");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (16 == name_len && 0 == strncmp(fld_name, "mnpRequestedInfo", name_len)) {
        mnpRequestedInfo_found = TRUE;
         int ret_val = field_mnpRequestedInfo.JSON_decode(RequestedInfo_mnpRequestedInfo_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 16, "mnpRequestedInfo");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "locationInformationEPS_Supported", name_len)) {
        locationInformationEPS__Supported_found = TRUE;
         int ret_val = field_locationInformationEPS__Supported.JSON_decode(RequestedInfo_locationInformationEPS__Supported_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "locationInformationEPS_Supported");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "t_adsData", name_len)) {
        t__adsData_found = TRUE;
         int ret_val = field_t__adsData.JSON_decode(RequestedInfo_t__adsData_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "t_adsData");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "requestedNodes", name_len)) {
        requestedNodes_found = TRUE;
         int ret_val = field_requestedNodes.JSON_decode(RequestedInfo_requestedNodes_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "requestedNodes");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (21 == name_len && 0 == strncmp(fld_name, "servingNodeIndication", name_len)) {
        servingNodeIndication_found = TRUE;
         int ret_val = field_servingNodeIndication.JSON_decode(RequestedInfo_servingNodeIndication_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 21, "servingNodeIndication");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!locationInformation_found) {
    field_locationInformation = OMIT_VALUE;
  }
  if (!subscriberState_found) {
    field_subscriberState = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!currentLocation_found) {
    field_currentLocation = OMIT_VALUE;
  }
  if (!requestedDomain_found) {
    field_requestedDomain = OMIT_VALUE;
  }
  if (!imei_found) {
    field_imei = OMIT_VALUE;
  }
  if (!ms__classmark_found) {
    field_ms__classmark = OMIT_VALUE;
  }
  if (!mnpRequestedInfo_found) {
    field_mnpRequestedInfo = OMIT_VALUE;
  }
  if (!locationInformationEPS__Supported_found) {
    field_locationInformationEPS__Supported = OMIT_VALUE;
  }
  if (!t__adsData_found) {
    field_t__adsData = OMIT_VALUE;
  }
  if (!requestedNodes_found) {
    field_requestedNodes = OMIT_VALUE;
  }
  if (!servingNodeIndication_found) {
    field_servingNodeIndication = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int RequestedInfo::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_currentLocation.is_bound() && field_currentLocation.is_present());
  has_extension = has_extension || (field_requestedDomain.is_bound() && field_requestedDomain.is_present());
  has_extension = has_extension || (field_imei.is_bound() && field_imei.is_present());
  has_extension = has_extension || (field_ms__classmark.is_bound() && field_ms__classmark.is_present());
  has_extension = has_extension || (field_mnpRequestedInfo.is_bound() && field_mnpRequestedInfo.is_present());
  has_extension = has_extension || (field_locationInformationEPS__Supported.is_bound() && field_locationInformationEPS__Supported.is_present());
  has_extension = has_extension || (field_t__adsData.is_bound() && field_t__adsData.is_present());
  has_extension = has_extension || (field_requestedNodes.is_bound() && field_requestedNodes.is_present());
  has_extension = has_extension || (field_servingNodeIndication.is_bound() && field_servingNodeIndication.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_locationInformation.is_present()) {
    c |= 64;
  }
  if (field_subscriberState.is_present()) {
    c |= 32;
  }
  if (field_extensionContainer.is_present()) {
    c |= 16;
  }
  p_buf.put_c(c);
  if (field_locationInformation.is_present())
    field_locationInformation.OER_encode(RequestedInfo_locationInformation_descr_, p_buf);
  if (field_subscriberState.is_present())
    field_subscriberState.OER_encode(RequestedInfo_subscriberState_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(RequestedInfo_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_currentLocation.is_present()) {
      c |= 128;
      field_currentLocation.OER_encode(RequestedInfo_currentLocation_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_requestedDomain.is_present()) {
      c |= 64;
      field_requestedDomain.OER_encode(RequestedInfo_requestedDomain_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_imei.is_present()) {
      c |= 32;
      field_imei.OER_encode(RequestedInfo_imei_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ms__classmark.is_present()) {
      c |= 16;
      field_ms__classmark.OER_encode(RequestedInfo_ms__classmark_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_mnpRequestedInfo.is_present()) {
      c |= 8;
      field_mnpRequestedInfo.OER_encode(RequestedInfo_mnpRequestedInfo_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_locationInformationEPS__Supported.is_present()) {
      c |= 4;
      field_locationInformationEPS__Supported.OER_encode(RequestedInfo_locationInformationEPS__Supported_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_t__adsData.is_present()) {
      c |= 2;
      field_t__adsData.OER_encode(RequestedInfo_t__adsData_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_requestedNodes.is_present()) {
      c |= 1;
      field_requestedNodes.OER_encode(RequestedInfo_requestedNodes_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_servingNodeIndication.is_present()) {
      c |= 128;
      field_servingNodeIndication.OER_encode(RequestedInfo_servingNodeIndication_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(7);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int RequestedInfo::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_locationInformation.OER_decode(RequestedInfo_locationInformation_descr_, p_buf, p_oer);
 else
    field_locationInformation = OMIT_VALUE;
  if (uc[0] & 32)
    field_subscriberState.OER_decode(RequestedInfo_subscriberState_descr_, p_buf, p_oer);
 else
    field_subscriberState = OMIT_VALUE;
  if (uc[0] & 16)
    field_extensionContainer.OER_decode(RequestedInfo_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_currentLocation = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_currentLocation.OER_decode(RequestedInfo_currentLocation_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_requestedDomain = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_requestedDomain.OER_decode(RequestedInfo_requestedDomain_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_imei = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_imei.OER_decode(RequestedInfo_imei_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_ms__classmark = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ms__classmark.OER_decode(RequestedInfo_ms__classmark_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_mnpRequestedInfo = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mnpRequestedInfo.OER_decode(RequestedInfo_mnpRequestedInfo_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_locationInformationEPS__Supported = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_locationInformationEPS__Supported.OER_decode(RequestedInfo_locationInformationEPS__Supported_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_t__adsData = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_t__adsData.OER_decode(RequestedInfo_t__adsData_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_requestedNodes = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_requestedNodes.OER_decode(RequestedInfo_requestedNodes_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_servingNodeIndication = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_servingNodeIndication.OER_decode(RequestedInfo_servingNodeIndication_descr_, p_buf, p_oer);
    }
  }
  else {
    field_currentLocation = OMIT_VALUE;
    field_requestedDomain = OMIT_VALUE;
    field_imei = OMIT_VALUE;
    field_ms__classmark = OMIT_VALUE;
    field_mnpRequestedInfo = OMIT_VALUE;
    field_locationInformationEPS__Supported = OMIT_VALUE;
    field_t__adsData = OMIT_VALUE;
    field_requestedNodes = OMIT_VALUE;
    field_servingNodeIndication = OMIT_VALUE;
  }
  return 0;
}

void RequestedInfo::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_currentLocation.is_present();
boolean ext_1_present = field_requestedDomain.is_present();
boolean ext_2_present = field_imei.is_present();
boolean ext_3_present = field_ms__classmark.is_present();
boolean ext_4_present = field_mnpRequestedInfo.is_present();
boolean ext_5_present = field_locationInformationEPS__Supported.is_present();
boolean ext_6_present = field_t__adsData.is_present();
boolean ext_7_present = field_requestedNodes.is_present();
boolean ext_8_present = field_servingNodeIndication.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present;
p_buf.PER_put_bit(ext_bit);
boolean field_locationInformation_present = field_locationInformation.is_present();
p_buf.PER_put_bit(field_locationInformation_present);
boolean field_subscriberState_present = field_subscriberState.is_present();
p_buf.PER_put_bit(field_subscriberState_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_locationInformation_present) field_locationInformation.PER_encode(RequestedInfo_locationInformation_descr_, p_buf, p_options);
if (field_subscriberState_present) field_subscriberState.PER_encode(RequestedInfo_subscriberState_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(RequestedInfo_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(9);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_currentLocation.PER_encode(RequestedInfo_currentLocation_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_requestedDomain.PER_encode(RequestedInfo_requestedDomain_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_imei.PER_encode(RequestedInfo_imei_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_ms__classmark.PER_encode(RequestedInfo_ms__classmark_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_mnpRequestedInfo.PER_encode(RequestedInfo_mnpRequestedInfo_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_locationInformationEPS__Supported.PER_encode(RequestedInfo_locationInformationEPS__Supported_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_t__adsData.PER_encode(RequestedInfo_t__adsData_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_requestedNodes.PER_encode(RequestedInfo_requestedNodes_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_servingNodeIndication.PER_encode(RequestedInfo_servingNodeIndication_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void RequestedInfo::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_locationInformation_present = p_buf.PER_get_bit();
boolean field_subscriberState_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_locationInformation_present) field_locationInformation.PER_decode(RequestedInfo_locationInformation_descr_, p_buf, p_options);
else field_locationInformation = OMIT_VALUE;
if (field_subscriberState_present) field_subscriberState.PER_decode(RequestedInfo_subscriberState_descr_, p_buf, p_options);
else field_subscriberState = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(RequestedInfo_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 9) {
for (int i = nof_decoded_ext_adds; i < 9; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_currentLocation.PER_decode(RequestedInfo_currentLocation_descr_, ext_add_buf, p_options);
}
else {
field_currentLocation = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_requestedDomain.PER_decode(RequestedInfo_requestedDomain_descr_, ext_add_buf, p_options);
}
else {
field_requestedDomain = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_imei.PER_decode(RequestedInfo_imei_descr_, ext_add_buf, p_options);
}
else {
field_imei = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ms__classmark.PER_decode(RequestedInfo_ms__classmark_descr_, ext_add_buf, p_options);
}
else {
field_ms__classmark = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mnpRequestedInfo.PER_decode(RequestedInfo_mnpRequestedInfo_descr_, ext_add_buf, p_options);
}
else {
field_mnpRequestedInfo = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_locationInformationEPS__Supported.PER_decode(RequestedInfo_locationInformationEPS__Supported_descr_, ext_add_buf, p_options);
}
else {
field_locationInformationEPS__Supported = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_t__adsData.PER_decode(RequestedInfo_t__adsData_descr_, ext_add_buf, p_options);
}
else {
field_t__adsData = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_requestedNodes.PER_decode(RequestedInfo_requestedNodes_descr_, ext_add_buf, p_options);
}
else {
field_requestedNodes = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_servingNodeIndication.PER_decode(RequestedInfo_servingNodeIndication_descr_, ext_add_buf, p_options);
}
else {
field_servingNodeIndication = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 9) for (int i = 9; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct RequestedInfo_template::single_value_struct {
ASN_NULL_template field_locationInformation;
ASN_NULL_template field_subscriberState;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
ASN_NULL_template field_currentLocation;
DomainType_template field_requestedDomain;
ASN_NULL_template field_imei;
ASN_NULL_template field_ms__classmark;
ASN_NULL_template field_mnpRequestedInfo;
ASN_NULL_template field_locationInformationEPS__Supported;
ASN_NULL_template field_t__adsData;
BITSTRING_template field_requestedNodes;
ASN_NULL_template field_servingNodeIndication;
};

void RequestedInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_locationInformation = ANY_OR_OMIT;
single_value->field_subscriberState = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_currentLocation = ANY_OR_OMIT;
single_value->field_requestedDomain = ANY_OR_OMIT;
single_value->field_imei = ANY_OR_OMIT;
single_value->field_ms__classmark = ANY_OR_OMIT;
single_value->field_mnpRequestedInfo = ANY_OR_OMIT;
single_value->field_locationInformationEPS__Supported = ANY_OR_OMIT;
single_value->field_t__adsData = ANY_OR_OMIT;
single_value->field_requestedNodes = ANY_OR_OMIT;
single_value->field_servingNodeIndication = ANY_OR_OMIT;
}
}
}

void RequestedInfo_template::copy_value(const RequestedInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.locationInformation().is_bound()) {
  if (other_value.locationInformation().ispresent()) single_value->field_locationInformation = other_value.locationInformation()();
  else single_value->field_locationInformation = OMIT_VALUE;
} else {
  single_value->field_locationInformation.clean_up();
}
if (other_value.subscriberState().is_bound()) {
  if (other_value.subscriberState().ispresent()) single_value->field_subscriberState = other_value.subscriberState()();
  else single_value->field_subscriberState = OMIT_VALUE;
} else {
  single_value->field_subscriberState.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.currentLocation().is_bound()) {
  if (other_value.currentLocation().ispresent()) single_value->field_currentLocation = other_value.currentLocation()();
  else single_value->field_currentLocation = OMIT_VALUE;
} else {
  single_value->field_currentLocation.clean_up();
}
if (other_value.requestedDomain().is_bound()) {
  if (other_value.requestedDomain().ispresent()) single_value->field_requestedDomain = other_value.requestedDomain()();
  else single_value->field_requestedDomain = OMIT_VALUE;
} else {
  single_value->field_requestedDomain.clean_up();
}
if (other_value.imei().is_bound()) {
  if (other_value.imei().ispresent()) single_value->field_imei = other_value.imei()();
  else single_value->field_imei = OMIT_VALUE;
} else {
  single_value->field_imei.clean_up();
}
if (other_value.ms__classmark().is_bound()) {
  if (other_value.ms__classmark().ispresent()) single_value->field_ms__classmark = other_value.ms__classmark()();
  else single_value->field_ms__classmark = OMIT_VALUE;
} else {
  single_value->field_ms__classmark.clean_up();
}
if (other_value.mnpRequestedInfo().is_bound()) {
  if (other_value.mnpRequestedInfo().ispresent()) single_value->field_mnpRequestedInfo = other_value.mnpRequestedInfo()();
  else single_value->field_mnpRequestedInfo = OMIT_VALUE;
} else {
  single_value->field_mnpRequestedInfo.clean_up();
}
if (other_value.locationInformationEPS__Supported().is_bound()) {
  if (other_value.locationInformationEPS__Supported().ispresent()) single_value->field_locationInformationEPS__Supported = other_value.locationInformationEPS__Supported()();
  else single_value->field_locationInformationEPS__Supported = OMIT_VALUE;
} else {
  single_value->field_locationInformationEPS__Supported.clean_up();
}
if (other_value.t__adsData().is_bound()) {
  if (other_value.t__adsData().ispresent()) single_value->field_t__adsData = other_value.t__adsData()();
  else single_value->field_t__adsData = OMIT_VALUE;
} else {
  single_value->field_t__adsData.clean_up();
}
if (other_value.requestedNodes().is_bound()) {
  if (other_value.requestedNodes().ispresent()) single_value->field_requestedNodes = other_value.requestedNodes()();
  else single_value->field_requestedNodes = OMIT_VALUE;
} else {
  single_value->field_requestedNodes.clean_up();
}
if (other_value.servingNodeIndication().is_bound()) {
  if (other_value.servingNodeIndication().ispresent()) single_value->field_servingNodeIndication = other_value.servingNodeIndication()();
  else single_value->field_servingNodeIndication = OMIT_VALUE;
} else {
  single_value->field_servingNodeIndication.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RequestedInfo_template::copy_template(const RequestedInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.locationInformation().get_selection()) {
single_value->field_locationInformation = other_value.locationInformation();
} else {
single_value->field_locationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subscriberState().get_selection()) {
single_value->field_subscriberState = other_value.subscriberState();
} else {
single_value->field_subscriberState.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.currentLocation().get_selection()) {
single_value->field_currentLocation = other_value.currentLocation();
} else {
single_value->field_currentLocation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedDomain().get_selection()) {
single_value->field_requestedDomain = other_value.requestedDomain();
} else {
single_value->field_requestedDomain.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.imei().get_selection()) {
single_value->field_imei = other_value.imei();
} else {
single_value->field_imei.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__classmark().get_selection()) {
single_value->field_ms__classmark = other_value.ms__classmark();
} else {
single_value->field_ms__classmark.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mnpRequestedInfo().get_selection()) {
single_value->field_mnpRequestedInfo = other_value.mnpRequestedInfo();
} else {
single_value->field_mnpRequestedInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locationInformationEPS__Supported().get_selection()) {
single_value->field_locationInformationEPS__Supported = other_value.locationInformationEPS__Supported();
} else {
single_value->field_locationInformationEPS__Supported.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t__adsData().get_selection()) {
single_value->field_t__adsData = other_value.t__adsData();
} else {
single_value->field_t__adsData.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedNodes().get_selection()) {
single_value->field_requestedNodes = other_value.requestedNodes();
} else {
single_value->field_requestedNodes.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.servingNodeIndication().get_selection()) {
single_value->field_servingNodeIndication = other_value.servingNodeIndication();
} else {
single_value->field_servingNodeIndication.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RequestedInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RequestedInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new RequestedInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.RequestedInfo.");
break;
}
set_selection(other_value);
}

RequestedInfo_template::RequestedInfo_template()
{
}

RequestedInfo_template::RequestedInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RequestedInfo_template::RequestedInfo_template(const RequestedInfo& other_value)
{
copy_value(other_value);
}

RequestedInfo_template::RequestedInfo_template(const OPTIONAL<RequestedInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RequestedInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.RequestedInfo from an unbound optional field.");
}
}

RequestedInfo_template::RequestedInfo_template(RequestedInfo_template* p_precondition, RequestedInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RequestedInfo_template::RequestedInfo_template(Dynamic_Match_Interface<RequestedInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RequestedInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RequestedInfo_template::RequestedInfo_template(const RequestedInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RequestedInfo_template::~RequestedInfo_template()
{
clean_up();
}

RequestedInfo_template& RequestedInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RequestedInfo_template& RequestedInfo_template::operator=(const RequestedInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RequestedInfo_template& RequestedInfo_template::operator=(const OPTIONAL<RequestedInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RequestedInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.RequestedInfo.");
}
return *this;
}

RequestedInfo_template& RequestedInfo_template::operator=(const RequestedInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RequestedInfo_template::match(const RequestedInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.locationInformation().is_bound()) return FALSE;
if((other_value.locationInformation().ispresent() ? !single_value->field_locationInformation.match((const ASN_NULL&)other_value.locationInformation(), legacy) : !single_value->field_locationInformation.match_omit(legacy)))return FALSE;
if(!other_value.subscriberState().is_bound()) return FALSE;
if((other_value.subscriberState().ispresent() ? !single_value->field_subscriberState.match((const ASN_NULL&)other_value.subscriberState(), legacy) : !single_value->field_subscriberState.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.currentLocation().is_bound()) return FALSE;
if((other_value.currentLocation().ispresent() ? !single_value->field_currentLocation.match((const ASN_NULL&)other_value.currentLocation(), legacy) : !single_value->field_currentLocation.match_omit(legacy)))return FALSE;
if(!other_value.requestedDomain().is_bound()) return FALSE;
if((other_value.requestedDomain().ispresent() ? !single_value->field_requestedDomain.match((const DomainType&)other_value.requestedDomain(), legacy) : !single_value->field_requestedDomain.match_omit(legacy)))return FALSE;
if(!other_value.imei().is_bound()) return FALSE;
if((other_value.imei().ispresent() ? !single_value->field_imei.match((const ASN_NULL&)other_value.imei(), legacy) : !single_value->field_imei.match_omit(legacy)))return FALSE;
if(!other_value.ms__classmark().is_bound()) return FALSE;
if((other_value.ms__classmark().ispresent() ? !single_value->field_ms__classmark.match((const ASN_NULL&)other_value.ms__classmark(), legacy) : !single_value->field_ms__classmark.match_omit(legacy)))return FALSE;
if(!other_value.mnpRequestedInfo().is_bound()) return FALSE;
if((other_value.mnpRequestedInfo().ispresent() ? !single_value->field_mnpRequestedInfo.match((const ASN_NULL&)other_value.mnpRequestedInfo(), legacy) : !single_value->field_mnpRequestedInfo.match_omit(legacy)))return FALSE;
if(!other_value.locationInformationEPS__Supported().is_bound()) return FALSE;
if((other_value.locationInformationEPS__Supported().ispresent() ? !single_value->field_locationInformationEPS__Supported.match((const ASN_NULL&)other_value.locationInformationEPS__Supported(), legacy) : !single_value->field_locationInformationEPS__Supported.match_omit(legacy)))return FALSE;
if(!other_value.t__adsData().is_bound()) return FALSE;
if((other_value.t__adsData().ispresent() ? !single_value->field_t__adsData.match((const ASN_NULL&)other_value.t__adsData(), legacy) : !single_value->field_t__adsData.match_omit(legacy)))return FALSE;
if(!other_value.requestedNodes().is_bound()) return FALSE;
if((other_value.requestedNodes().ispresent() ? !single_value->field_requestedNodes.match((const BITSTRING&)other_value.requestedNodes(), legacy) : !single_value->field_requestedNodes.match_omit(legacy)))return FALSE;
if(!other_value.servingNodeIndication().is_bound()) return FALSE;
if((other_value.servingNodeIndication().ispresent() ? !single_value->field_servingNodeIndication.match((const ASN_NULL&)other_value.servingNodeIndication(), legacy) : !single_value->field_servingNodeIndication.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.RequestedInfo.");
}
return FALSE;
}

boolean RequestedInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_locationInformation.is_omit() || single_value->field_locationInformation.is_bound())
 || (single_value->field_subscriberState.is_omit() || single_value->field_subscriberState.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_currentLocation.is_omit() || single_value->field_currentLocation.is_bound())
 || (single_value->field_requestedDomain.is_omit() || single_value->field_requestedDomain.is_bound())
 || (single_value->field_imei.is_omit() || single_value->field_imei.is_bound())
 || (single_value->field_ms__classmark.is_omit() || single_value->field_ms__classmark.is_bound())
 || (single_value->field_mnpRequestedInfo.is_omit() || single_value->field_mnpRequestedInfo.is_bound())
 || (single_value->field_locationInformationEPS__Supported.is_omit() || single_value->field_locationInformationEPS__Supported.is_bound())
 || (single_value->field_t__adsData.is_omit() || single_value->field_t__adsData.is_bound())
 || (single_value->field_requestedNodes.is_omit() || single_value->field_requestedNodes.is_bound())
 || (single_value->field_servingNodeIndication.is_omit() || single_value->field_servingNodeIndication.is_bound());
}

boolean RequestedInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_locationInformation.is_omit() || single_value->field_locationInformation.is_value())
 && (single_value->field_subscriberState.is_omit() || single_value->field_subscriberState.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_currentLocation.is_omit() || single_value->field_currentLocation.is_value())
 && (single_value->field_requestedDomain.is_omit() || single_value->field_requestedDomain.is_value())
 && (single_value->field_imei.is_omit() || single_value->field_imei.is_value())
 && (single_value->field_ms__classmark.is_omit() || single_value->field_ms__classmark.is_value())
 && (single_value->field_mnpRequestedInfo.is_omit() || single_value->field_mnpRequestedInfo.is_value())
 && (single_value->field_locationInformationEPS__Supported.is_omit() || single_value->field_locationInformationEPS__Supported.is_value())
 && (single_value->field_t__adsData.is_omit() || single_value->field_t__adsData.is_value())
 && (single_value->field_requestedNodes.is_omit() || single_value->field_requestedNodes.is_value())
 && (single_value->field_servingNodeIndication.is_omit() || single_value->field_servingNodeIndication.is_value());
}

void RequestedInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RequestedInfo RequestedInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
RequestedInfo ret_val;
if (single_value->field_locationInformation.is_omit()) ret_val.locationInformation() = OMIT_VALUE;
else if (single_value->field_locationInformation.is_bound()) {
ret_val.locationInformation() = single_value->field_locationInformation.valueof();
}
if (single_value->field_subscriberState.is_omit()) ret_val.subscriberState() = OMIT_VALUE;
else if (single_value->field_subscriberState.is_bound()) {
ret_val.subscriberState() = single_value->field_subscriberState.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_currentLocation.is_omit()) ret_val.currentLocation() = OMIT_VALUE;
else if (single_value->field_currentLocation.is_bound()) {
ret_val.currentLocation() = single_value->field_currentLocation.valueof();
}
if (single_value->field_requestedDomain.is_omit()) ret_val.requestedDomain() = OMIT_VALUE;
else if (single_value->field_requestedDomain.is_bound()) {
ret_val.requestedDomain() = single_value->field_requestedDomain.valueof();
}
if (single_value->field_imei.is_omit()) ret_val.imei() = OMIT_VALUE;
else if (single_value->field_imei.is_bound()) {
ret_val.imei() = single_value->field_imei.valueof();
}
if (single_value->field_ms__classmark.is_omit()) ret_val.ms__classmark() = OMIT_VALUE;
else if (single_value->field_ms__classmark.is_bound()) {
ret_val.ms__classmark() = single_value->field_ms__classmark.valueof();
}
if (single_value->field_mnpRequestedInfo.is_omit()) ret_val.mnpRequestedInfo() = OMIT_VALUE;
else if (single_value->field_mnpRequestedInfo.is_bound()) {
ret_val.mnpRequestedInfo() = single_value->field_mnpRequestedInfo.valueof();
}
if (single_value->field_locationInformationEPS__Supported.is_omit()) ret_val.locationInformationEPS__Supported() = OMIT_VALUE;
else if (single_value->field_locationInformationEPS__Supported.is_bound()) {
ret_val.locationInformationEPS__Supported() = single_value->field_locationInformationEPS__Supported.valueof();
}
if (single_value->field_t__adsData.is_omit()) ret_val.t__adsData() = OMIT_VALUE;
else if (single_value->field_t__adsData.is_bound()) {
ret_val.t__adsData() = single_value->field_t__adsData.valueof();
}
if (single_value->field_requestedNodes.is_omit()) ret_val.requestedNodes() = OMIT_VALUE;
else if (single_value->field_requestedNodes.is_bound()) {
ret_val.requestedNodes() = single_value->field_requestedNodes.valueof();
}
if (single_value->field_servingNodeIndication.is_omit()) ret_val.servingNodeIndication() = OMIT_VALUE;
else if (single_value->field_servingNodeIndication.is_bound()) {
ret_val.servingNodeIndication() = single_value->field_servingNodeIndication.valueof();
}
return ret_val;
}

void RequestedInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.RequestedInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RequestedInfo_template[list_length];
}

RequestedInfo_template& RequestedInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.RequestedInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.RequestedInfo.");
return value_list.list_value[list_index];
}

ASN_NULL_template& RequestedInfo_template::locationInformation()
{
set_specific();
return single_value->field_locationInformation;
}

const ASN_NULL_template& RequestedInfo_template::locationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformation of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_locationInformation;
}

ASN_NULL_template& RequestedInfo_template::subscriberState()
{
set_specific();
return single_value->field_subscriberState;
}

const ASN_NULL_template& RequestedInfo_template::subscriberState() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subscriberState of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_subscriberState;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& RequestedInfo_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& RequestedInfo_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_extensionContainer;
}

ASN_NULL_template& RequestedInfo_template::currentLocation()
{
set_specific();
return single_value->field_currentLocation;
}

const ASN_NULL_template& RequestedInfo_template::currentLocation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field currentLocation of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_currentLocation;
}

DomainType_template& RequestedInfo_template::requestedDomain()
{
set_specific();
return single_value->field_requestedDomain;
}

const DomainType_template& RequestedInfo_template::requestedDomain() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedDomain of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_requestedDomain;
}

ASN_NULL_template& RequestedInfo_template::imei()
{
set_specific();
return single_value->field_imei;
}

const ASN_NULL_template& RequestedInfo_template::imei() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imei of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_imei;
}

ASN_NULL_template& RequestedInfo_template::ms__classmark()
{
set_specific();
return single_value->field_ms__classmark;
}

const ASN_NULL_template& RequestedInfo_template::ms__classmark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_classmark of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_ms__classmark;
}

ASN_NULL_template& RequestedInfo_template::mnpRequestedInfo()
{
set_specific();
return single_value->field_mnpRequestedInfo;
}

const ASN_NULL_template& RequestedInfo_template::mnpRequestedInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mnpRequestedInfo of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_mnpRequestedInfo;
}

ASN_NULL_template& RequestedInfo_template::locationInformationEPS__Supported()
{
set_specific();
return single_value->field_locationInformationEPS__Supported;
}

const ASN_NULL_template& RequestedInfo_template::locationInformationEPS__Supported() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformationEPS_Supported of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_locationInformationEPS__Supported;
}

ASN_NULL_template& RequestedInfo_template::t__adsData()
{
set_specific();
return single_value->field_t__adsData;
}

const ASN_NULL_template& RequestedInfo_template::t__adsData() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t_adsData of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_t__adsData;
}

BITSTRING_template& RequestedInfo_template::requestedNodes()
{
set_specific();
return single_value->field_requestedNodes;
}

const BITSTRING_template& RequestedInfo_template::requestedNodes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedNodes of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_requestedNodes;
}

ASN_NULL_template& RequestedInfo_template::servingNodeIndication()
{
set_specific();
return single_value->field_servingNodeIndication;
}

const ASN_NULL_template& RequestedInfo_template::servingNodeIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field servingNodeIndication of a non-specific template of type @MAP-MS-DataTypes.RequestedInfo.");
return single_value->field_servingNodeIndication;
}

int RequestedInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_locationInformation.is_present()) ret_val++;
      if (single_value->field_subscriberState.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_currentLocation.is_present()) ret_val++;
      if (single_value->field_requestedDomain.is_present()) ret_val++;
      if (single_value->field_imei.is_present()) ret_val++;
      if (single_value->field_ms__classmark.is_present()) ret_val++;
      if (single_value->field_mnpRequestedInfo.is_present()) ret_val++;
      if (single_value->field_locationInformationEPS__Supported.is_present()) ret_val++;
      if (single_value->field_t__adsData.is_present()) ret_val++;
      if (single_value->field_requestedNodes.is_present()) ret_val++;
      if (single_value->field_servingNodeIndication.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.RequestedInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.RequestedInfo.");
  }
  return 0;
}

void RequestedInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ locationInformation := ");
single_value->field_locationInformation.log();
TTCN_Logger::log_event_str(", subscriberState := ");
single_value->field_subscriberState.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", currentLocation := ");
single_value->field_currentLocation.log();
TTCN_Logger::log_event_str(", requestedDomain := ");
single_value->field_requestedDomain.log();
TTCN_Logger::log_event_str(", imei := ");
single_value->field_imei.log();
TTCN_Logger::log_event_str(", ms_classmark := ");
single_value->field_ms__classmark.log();
TTCN_Logger::log_event_str(", mnpRequestedInfo := ");
single_value->field_mnpRequestedInfo.log();
TTCN_Logger::log_event_str(", locationInformationEPS_Supported := ");
single_value->field_locationInformationEPS__Supported.log();
TTCN_Logger::log_event_str(", t_adsData := ");
single_value->field_t__adsData.log();
TTCN_Logger::log_event_str(", requestedNodes := ");
single_value->field_requestedNodes.log();
TTCN_Logger::log_event_str(", servingNodeIndication := ");
single_value->field_servingNodeIndication.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RequestedInfo_template::log_match(const RequestedInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.locationInformation().ispresent()){
if(!single_value->field_locationInformation.match(match_value.locationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformation");
single_value->field_locationInformation.log_match(match_value.locationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subscriberState().ispresent()){
if(!single_value->field_subscriberState.match(match_value.subscriberState(), legacy)){
TTCN_Logger::log_logmatch_info(".subscriberState");
single_value->field_subscriberState.log_match(match_value.subscriberState(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subscriberState.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subscriberState := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subscriberState.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.currentLocation().ispresent()){
if(!single_value->field_currentLocation.match(match_value.currentLocation(), legacy)){
TTCN_Logger::log_logmatch_info(".currentLocation");
single_value->field_currentLocation.log_match(match_value.currentLocation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_currentLocation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".currentLocation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_currentLocation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.requestedDomain().ispresent()){
if(!single_value->field_requestedDomain.match(match_value.requestedDomain(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedDomain");
single_value->field_requestedDomain.log_match(match_value.requestedDomain(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_requestedDomain.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".requestedDomain := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_requestedDomain.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.imei().ispresent()){
if(!single_value->field_imei.match(match_value.imei(), legacy)){
TTCN_Logger::log_logmatch_info(".imei");
single_value->field_imei.log_match(match_value.imei(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imei.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imei := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imei.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ms__classmark().ispresent()){
if(!single_value->field_ms__classmark.match(match_value.ms__classmark(), legacy)){
TTCN_Logger::log_logmatch_info(".ms_classmark");
single_value->field_ms__classmark.log_match(match_value.ms__classmark(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ms__classmark.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ms_classmark := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ms__classmark.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mnpRequestedInfo().ispresent()){
if(!single_value->field_mnpRequestedInfo.match(match_value.mnpRequestedInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".mnpRequestedInfo");
single_value->field_mnpRequestedInfo.log_match(match_value.mnpRequestedInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mnpRequestedInfo.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mnpRequestedInfo := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mnpRequestedInfo.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.locationInformationEPS__Supported().ispresent()){
if(!single_value->field_locationInformationEPS__Supported.match(match_value.locationInformationEPS__Supported(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformationEPS_Supported");
single_value->field_locationInformationEPS__Supported.log_match(match_value.locationInformationEPS__Supported(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformationEPS__Supported.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformationEPS_Supported := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformationEPS__Supported.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.t__adsData().ispresent()){
if(!single_value->field_t__adsData.match(match_value.t__adsData(), legacy)){
TTCN_Logger::log_logmatch_info(".t_adsData");
single_value->field_t__adsData.log_match(match_value.t__adsData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_t__adsData.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".t_adsData := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_t__adsData.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.requestedNodes().ispresent()){
if(!single_value->field_requestedNodes.match(match_value.requestedNodes(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedNodes");
single_value->field_requestedNodes.log_match(match_value.requestedNodes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_requestedNodes.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".requestedNodes := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_requestedNodes.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.servingNodeIndication().ispresent()){
if(!single_value->field_servingNodeIndication.match(match_value.servingNodeIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".servingNodeIndication");
single_value->field_servingNodeIndication.log_match(match_value.servingNodeIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_servingNodeIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".servingNodeIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_servingNodeIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ locationInformation := ");
if (match_value.locationInformation().ispresent()) {
single_value->field_locationInformation.log_match(match_value.locationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformation.log();
if (single_value->field_locationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subscriberState := ");
if (match_value.subscriberState().ispresent()) {
single_value->field_subscriberState.log_match(match_value.subscriberState(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subscriberState.log();
if (single_value->field_subscriberState.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", currentLocation := ");
if (match_value.currentLocation().ispresent()) {
single_value->field_currentLocation.log_match(match_value.currentLocation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_currentLocation.log();
if (single_value->field_currentLocation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", requestedDomain := ");
if (match_value.requestedDomain().ispresent()) {
single_value->field_requestedDomain.log_match(match_value.requestedDomain(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_requestedDomain.log();
if (single_value->field_requestedDomain.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", imei := ");
if (match_value.imei().ispresent()) {
single_value->field_imei.log_match(match_value.imei(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imei.log();
if (single_value->field_imei.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ms_classmark := ");
if (match_value.ms__classmark().ispresent()) {
single_value->field_ms__classmark.log_match(match_value.ms__classmark(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ms__classmark.log();
if (single_value->field_ms__classmark.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mnpRequestedInfo := ");
if (match_value.mnpRequestedInfo().ispresent()) {
single_value->field_mnpRequestedInfo.log_match(match_value.mnpRequestedInfo(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mnpRequestedInfo.log();
if (single_value->field_mnpRequestedInfo.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", locationInformationEPS_Supported := ");
if (match_value.locationInformationEPS__Supported().ispresent()) {
single_value->field_locationInformationEPS__Supported.log_match(match_value.locationInformationEPS__Supported(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformationEPS__Supported.log();
if (single_value->field_locationInformationEPS__Supported.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", t_adsData := ");
if (match_value.t__adsData().ispresent()) {
single_value->field_t__adsData.log_match(match_value.t__adsData(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_t__adsData.log();
if (single_value->field_t__adsData.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", requestedNodes := ");
if (match_value.requestedNodes().ispresent()) {
single_value->field_requestedNodes.log_match(match_value.requestedNodes(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_requestedNodes.log();
if (single_value->field_requestedNodes.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", servingNodeIndication := ");
if (match_value.servingNodeIndication().ispresent()) {
single_value->field_servingNodeIndication.log_match(match_value.servingNodeIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_servingNodeIndication.log();
if (single_value->field_servingNodeIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RequestedInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!locationInformation().is_bound()) locationInformation() = OMIT_VALUE;
else locationInformation().set_implicit_omit();
if (!subscriberState().is_bound()) subscriberState() = OMIT_VALUE;
else subscriberState().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!currentLocation().is_bound()) currentLocation() = OMIT_VALUE;
else currentLocation().set_implicit_omit();
if (!requestedDomain().is_bound()) requestedDomain() = OMIT_VALUE;
else requestedDomain().set_implicit_omit();
if (!imei().is_bound()) imei() = OMIT_VALUE;
else imei().set_implicit_omit();
if (!ms__classmark().is_bound()) ms__classmark() = OMIT_VALUE;
else ms__classmark().set_implicit_omit();
if (!mnpRequestedInfo().is_bound()) mnpRequestedInfo() = OMIT_VALUE;
else mnpRequestedInfo().set_implicit_omit();
if (!locationInformationEPS__Supported().is_bound()) locationInformationEPS__Supported() = OMIT_VALUE;
else locationInformationEPS__Supported().set_implicit_omit();
if (!t__adsData().is_bound()) t__adsData() = OMIT_VALUE;
else t__adsData().set_implicit_omit();
if (!requestedNodes().is_bound()) requestedNodes() = OMIT_VALUE;
else requestedNodes().set_implicit_omit();
if (!servingNodeIndication().is_bound()) servingNodeIndication() = OMIT_VALUE;
else servingNodeIndication().set_implicit_omit();
}

void RequestedInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_locationInformation.encode_text(text_buf);
single_value->field_subscriberState.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_currentLocation.encode_text(text_buf);
single_value->field_requestedDomain.encode_text(text_buf);
single_value->field_imei.encode_text(text_buf);
single_value->field_ms__classmark.encode_text(text_buf);
single_value->field_mnpRequestedInfo.encode_text(text_buf);
single_value->field_locationInformationEPS__Supported.encode_text(text_buf);
single_value->field_t__adsData.encode_text(text_buf);
single_value->field_requestedNodes.encode_text(text_buf);
single_value->field_servingNodeIndication.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.RequestedInfo.");
}
}

void RequestedInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_locationInformation.decode_text(text_buf);
single_value->field_subscriberState.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_currentLocation.decode_text(text_buf);
single_value->field_requestedDomain.decode_text(text_buf);
single_value->field_imei.decode_text(text_buf);
single_value->field_ms__classmark.decode_text(text_buf);
single_value->field_mnpRequestedInfo.decode_text(text_buf);
single_value->field_locationInformationEPS__Supported.decode_text(text_buf);
single_value->field_t__adsData.decode_text(text_buf);
single_value->field_requestedNodes.decode_text(text_buf);
single_value->field_servingNodeIndication.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RequestedInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.RequestedInfo.");
}
}

void RequestedInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RequestedInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.RequestedInfo has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) locationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) subscriberState().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) currentLocation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) requestedDomain().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) imei().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ms__classmark().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mnpRequestedInfo().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS__Supported().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) t__adsData().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) requestedNodes().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) servingNodeIndication().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedDomain")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedDomain().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imei")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imei().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_classmark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__classmark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mnpRequestedInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mnpRequestedInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS_Supported")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS__Supported().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_adsData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__adsData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedNodes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedNodes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "servingNodeIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          servingNodeIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.RequestedInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RequestedInfo_template* precondition = new RequestedInfo_template;
    precondition->set_param(*param.get_elem(0));
    RequestedInfo_template* implied_template = new RequestedInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RequestedInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.RequestedInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void RequestedInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_locationInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_subscriberState.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_currentLocation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_requestedDomain.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_imei.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_ms__classmark.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_mnpRequestedInfo.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_locationInformationEPS__Supported.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_t__adsData.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_requestedNodes.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
single_value->field_servingNodeIndication.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.RequestedInfo");
}

boolean RequestedInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RequestedInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

DomainType::DomainType()
{
enum_value = UNBOUND_VALUE;
}

DomainType::DomainType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.DomainType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DomainType::DomainType(enum_type other_value)
{
enum_value = other_value;
}

DomainType::DomainType(const DomainType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
enum_value = other_value.enum_value;
}

DomainType& DomainType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.DomainType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DomainType& DomainType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DomainType& DomainType::operator=(const DomainType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
enum_value = other_value.enum_value;
return *this;
}

boolean DomainType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.DomainType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DomainType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value == other_value;
}

boolean DomainType::operator==(const DomainType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value == other_value.enum_value;
}

boolean DomainType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.DomainType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DomainType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value < other_value;
}

boolean DomainType::operator<(const DomainType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value < other_value.enum_value;
}

boolean DomainType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.DomainType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DomainType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value > other_value;
}

boolean DomainType::operator>(const DomainType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value > other_value.enum_value;
}

const char *DomainType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case cs__Domain: return "cs_Domain";
case ps__Domain: return "ps_Domain";
default:
return "<unknown>";
}
}

DomainType::enum_type DomainType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "cs_Domain")) return cs__Domain;
if (!strcmp(str_par, "ps_Domain")) return ps__Domain;
}
return UNKNOWN_VALUE;
}

boolean DomainType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DomainType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.DomainType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DomainType::enum2int(const DomainType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.DomainType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DomainType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.DomainType.", int_val);
enum_value = (enum_type)int_val;
}

DomainType::operator DomainType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.DomainType.");
return enum_value;
}

void DomainType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DomainType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.DomainType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.DomainType.");
  }
}

void DomainType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
text_buf.push_int(enum_value);
}

void DomainType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.DomainType.", enum_value);
}

void DomainType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DomainType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* DomainType::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean DomainType::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.DomainType: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int DomainType::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int DomainType::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const DomainType*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = cs__Domain;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int DomainType::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int DomainType::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void DomainType::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
boolean ext_bit = FALSE;
switch (enum_value) {
case cs__Domain:
enc_val = 0;
ext_bit = FALSE;
break;
case ps__Domain:
enc_val = 1;
ext_bit = FALSE;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.DomainType.");
}
p_buf.PER_put_bit(ext_bit);
if (ext_bit) enc_val.PER_encode_normally_small(p_buf, p_options);
else INTEGER::PER_encode_int(p_buf, enc_val, 1);
}

void DomainType::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
boolean ext_bit = p_buf.PER_get_bit();
if (ext_bit) dec_val.PER_decode_normally_small(p_buf, p_options);
else dec_val.PER_decode_unaligned_constrained(p_buf, 1, FALSE);
int dec_int = dec_val;
if (ext_bit) switch (dec_int) {
default: enum_value = UNBOUND_VALUE; break;
}
else switch (dec_int) {
case 0: enum_value = cs__Domain; break;
case 1: enum_value = ps__Domain; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.DomainType.", dec_int);
break;
}
}

void DomainType_template::copy_template(const DomainType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DomainType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DomainType_template(*other_value.implication_.precondition);
implication_.implied_template = new DomainType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
}

DomainType_template::DomainType_template()
{
}

DomainType_template::DomainType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DomainType_template::DomainType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DomainType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.DomainType with unknown numeric value %d.", other_value);
single_value = (DomainType::enum_type)other_value;
}

DomainType_template::DomainType_template(DomainType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DomainType_template::DomainType_template(const DomainType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DomainType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.DomainType.");
single_value = other_value.enum_value;
}

DomainType_template::DomainType_template(const OPTIONAL<DomainType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DomainType::enum_type)(const DomainType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.DomainType from an unbound optional field.");
}
}

DomainType_template::DomainType_template(DomainType_template* p_precondition, DomainType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DomainType_template::DomainType_template(Dynamic_Match_Interface<DomainType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DomainType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DomainType_template::DomainType_template(const DomainType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DomainType_template::~DomainType_template()
{
clean_up();
}

boolean DomainType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DomainType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DomainType::UNBOUND_VALUE;
}

void DomainType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DomainType_template& DomainType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DomainType_template& DomainType_template::operator=(int other_value)
{
if (!DomainType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @MAP-MS-DataTypes.DomainType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DomainType::enum_type)other_value;
return *this;
}

DomainType_template& DomainType_template::operator=(DomainType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DomainType_template& DomainType_template::operator=(const DomainType& other_value)
{
if (other_value.enum_value == DomainType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.DomainType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DomainType_template& DomainType_template::operator=(const OPTIONAL<DomainType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DomainType::enum_type)(const DomainType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
return *this;
}

DomainType_template& DomainType_template::operator=(const DomainType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DomainType_template::match(DomainType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
return FALSE;
}

boolean DomainType_template::match(const DomainType& other_value, boolean) const
{
if (other_value.enum_value == DomainType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @MAP-MS-DataTypes.DomainType with an unbound value.");
return match(other_value.enum_value);
}

DomainType::enum_type DomainType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @MAP-MS-DataTypes.DomainType.");
return single_value;
}

void DomainType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DomainType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
}

DomainType_template& DomainType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @MAP-MS-DataTypes.DomainType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @MAP-MS-DataTypes.DomainType.");
return value_list.list_value[list_index];
}

void DomainType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DomainType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DomainType_template::log_match(const DomainType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DomainType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
}

void DomainType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DomainType::enum_type)text_buf.pull_int().get_val();
if (!DomainType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @MAP-MS-DataTypes.DomainType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DomainType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @MAP-MS-DataTypes.DomainType.");
}
}

boolean DomainType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DomainType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DomainType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DomainType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DomainType::enum_type enum_val = DomainType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DomainType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @MAP-MS-DataTypes.DomainType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DomainType_template* precondition = new DomainType_template;
    precondition->set_param(*m_p->get_elem(0));
    DomainType_template* implied_template = new DomainType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DomainType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@MAP-MS-DataTypes.DomainType");
  }
  is_ifpresent = param.get_ifpresent();
}

void DomainType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.DomainType");
}

ProvideSubscriberInfoArg::ProvideSubscriberInfoArg()
{
}

ProvideSubscriberInfoArg::ProvideSubscriberInfoArg(const OCTETSTRING& par_imsi,
    const OPTIONAL< OCTETSTRING >& par_lmsi,
    const RequestedInfo& par_requestedInfo,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< INTEGER >& par_callPriority)
  :   field_imsi(par_imsi),
  field_lmsi(par_lmsi),
  field_requestedInfo(par_requestedInfo),
  field_extensionContainer(par_extensionContainer),
  field_callPriority(par_callPriority)
{
}

ProvideSubscriberInfoArg::ProvideSubscriberInfoArg(const ProvideSubscriberInfoArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.lmsi().is_bound()) field_lmsi = other_value.lmsi();
else field_lmsi.clean_up();
if (other_value.requestedInfo().is_bound()) field_requestedInfo = other_value.requestedInfo();
else field_requestedInfo.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.callPriority().is_bound()) field_callPriority = other_value.callPriority();
else field_callPriority.clean_up();
}

void ProvideSubscriberInfoArg::clean_up()
{
field_imsi.clean_up();
field_lmsi.clean_up();
field_requestedInfo.clean_up();
field_extensionContainer.clean_up();
field_callPriority.clean_up();
}

const TTCN_Typedescriptor_t* ProvideSubscriberInfoArg::get_descriptor() const { return &ProvideSubscriberInfoArg_descr_; }
ProvideSubscriberInfoArg& ProvideSubscriberInfoArg::operator=(const ProvideSubscriberInfoArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.lmsi().is_bound()) field_lmsi = other_value.lmsi();
  else field_lmsi.clean_up();
  if (other_value.requestedInfo().is_bound()) field_requestedInfo = other_value.requestedInfo();
  else field_requestedInfo.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.callPriority().is_bound()) field_callPriority = other_value.callPriority();
  else field_callPriority.clean_up();
}
return *this;
}

boolean ProvideSubscriberInfoArg::operator==(const ProvideSubscriberInfoArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_lmsi==other_value.field_lmsi
  && field_requestedInfo==other_value.field_requestedInfo
  && field_extensionContainer==other_value.field_extensionContainer
  && field_callPriority==other_value.field_callPriority;
}

boolean ProvideSubscriberInfoArg::is_bound() const
{
return (field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_lmsi.get_selection() || field_lmsi.is_bound())
  || (field_requestedInfo.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_callPriority.get_selection() || field_callPriority.is_bound());
}
boolean ProvideSubscriberInfoArg::is_value() const
{
return field_imsi.is_value()
  && (OPTIONAL_OMIT == field_lmsi.get_selection() || field_lmsi.is_value())
  && field_requestedInfo.is_value()
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_callPriority.get_selection() || field_callPriority.is_value());
}
int ProvideSubscriberInfoArg::size_of() const
{
  int ret_val = 2;
  if (field_lmsi.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_callPriority.ispresent()) ret_val++;
  return ret_val;
}

void ProvideSubscriberInfoArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", lmsi := ");
field_lmsi.log();
TTCN_Logger::log_event_str(", requestedInfo := ");
field_requestedInfo.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", callPriority := ");
field_callPriority.log();
TTCN_Logger::log_event_str(" }");
}

void ProvideSubscriberInfoArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (!lmsi().is_bound()) lmsi() = OMIT_VALUE;
else lmsi().set_implicit_omit();
if (requestedInfo().is_bound()) requestedInfo().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!callPriority().is_bound()) callPriority() = OMIT_VALUE;
else callPriority().set_implicit_omit();
}

void ProvideSubscriberInfoArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lmsi().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedInfo().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) callPriority().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ProvideSubscriberInfoArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
  }
}

void ProvideSubscriberInfoArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_lmsi.encode_text(text_buf);
field_requestedInfo.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_callPriority.encode_text(text_buf);
}

void ProvideSubscriberInfoArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_lmsi.decode_text(text_buf);
field_requestedInfo.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_callPriority.decode_text(text_buf);
}

void ProvideSubscriberInfoArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ProvideSubscriberInfoArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* ProvideSubscriberInfoArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(ProvideSubscriberInfoArg_imsi_descr_, p_coding));
  ec_1.set_msg("lmsi': ");
  new_tlv->add_TLV(field_lmsi.BER_encode_TLV(ProvideSubscriberInfoArg_lmsi_descr_, p_coding));
  ec_1.set_msg("requestedInfo': ");
  new_tlv->add_TLV(field_requestedInfo.BER_encode_TLV(ProvideSubscriberInfoArg_requestedInfo_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(ProvideSubscriberInfoArg_extensionContainer_descr_, p_coding));
  ec_1.set_msg("callPriority': ");
  new_tlv->add_TLV(field_callPriority.BER_encode_TLV(ProvideSubscriberInfoArg_callPriority_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean ProvideSubscriberInfoArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.ProvideSubscriberInfoArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(ProvideSubscriberInfoArg_imsi_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("lmsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_lmsi=OMIT_VALUE;
    else {
      field_lmsi.BER_decode_TLV(ProvideSubscriberInfoArg_lmsi_descr_, tmp_tlv, L_form);
      if(field_lmsi.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("requestedInfo': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_requestedInfo.BER_decode_TLV(ProvideSubscriberInfoArg_requestedInfo_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(ProvideSubscriberInfoArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("callPriority': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_callPriority=OMIT_VALUE;
    else {
      field_callPriority.BER_decode_TLV(ProvideSubscriberInfoArg_callPriority_descr_, tmp_tlv, L_form);
      if(field_callPriority.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int ProvideSubscriberInfoArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(ProvideSubscriberInfoArg_imsi_descr_, p_tok, FALSE);
  }

  if (field_lmsi.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "lmsi");
    enc_len += field_lmsi.JSON_encode(ProvideSubscriberInfoArg_lmsi_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "requestedInfo");
    enc_len += field_requestedInfo.JSON_encode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_callPriority.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "callPriority");
    enc_len += field_callPriority.JSON_encode(ProvideSubscriberInfoArg_callPriority_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int ProvideSubscriberInfoArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ProvideSubscriberInfoArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean lmsi_found = FALSE;
  boolean requestedInfo_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean callPriority_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(ProvideSubscriberInfoArg_imsi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "lmsi", name_len)) {
        lmsi_found = TRUE;
         int ret_val = field_lmsi.JSON_decode(ProvideSubscriberInfoArg_lmsi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "lmsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "requestedInfo", name_len)) {
        requestedInfo_found = TRUE;
         int ret_val = field_requestedInfo.JSON_decode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "requestedInfo");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "callPriority", name_len)) {
        callPriority_found = TRUE;
         int ret_val = field_callPriority.JSON_decode(ProvideSubscriberInfoArg_callPriority_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "callPriority");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!lmsi_found) {
    field_lmsi = OMIT_VALUE;
  }
  if (!requestedInfo_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "requestedInfo");
    return JSON_ERROR_FATAL;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!callPriority_found) {
    field_callPriority = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int ProvideSubscriberInfoArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_callPriority.is_bound() && field_callPriority.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_lmsi.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(ProvideSubscriberInfoArg_imsi_descr_, p_buf);
  if (field_lmsi.is_present())
    field_lmsi.OER_encode(ProvideSubscriberInfoArg_lmsi_descr_, p_buf);
  field_requestedInfo.OER_encode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_callPriority.is_present()) {
      c |= 128;
      field_callPriority.OER_encode(ProvideSubscriberInfoArg_callPriority_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(7);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int ProvideSubscriberInfoArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(ProvideSubscriberInfoArg_imsi_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_lmsi.OER_decode(ProvideSubscriberInfoArg_lmsi_descr_, p_buf, p_oer);
 else
    field_lmsi = OMIT_VALUE;
  field_requestedInfo.OER_decode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_buf, p_oer);
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_callPriority = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_callPriority.OER_decode(ProvideSubscriberInfoArg_callPriority_descr_, p_buf, p_oer);
    }
  }
  else {
    field_callPriority = OMIT_VALUE;
  }
  return 0;
}

void ProvideSubscriberInfoArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_callPriority.is_present();
boolean ext_bit = ext_0_present;
p_buf.PER_put_bit(ext_bit);
boolean field_lmsi_present = field_lmsi.is_present();
p_buf.PER_put_bit(field_lmsi_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(ProvideSubscriberInfoArg_imsi_descr_, p_buf, p_options);
if (field_lmsi_present) field_lmsi.PER_encode(ProvideSubscriberInfoArg_lmsi_descr_, p_buf, p_options);
field_requestedInfo.PER_encode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(1);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_callPriority.PER_encode(ProvideSubscriberInfoArg_callPriority_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void ProvideSubscriberInfoArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_lmsi_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(ProvideSubscriberInfoArg_imsi_descr_, p_buf, p_options);
if (field_lmsi_present) field_lmsi.PER_decode(ProvideSubscriberInfoArg_lmsi_descr_, p_buf, p_options);
else field_lmsi = OMIT_VALUE;
field_requestedInfo.PER_decode(ProvideSubscriberInfoArg_requestedInfo_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_decode(ProvideSubscriberInfoArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 1) {
for (int i = nof_decoded_ext_adds; i < 1; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_callPriority.PER_decode(ProvideSubscriberInfoArg_callPriority_descr_, ext_add_buf, p_options);
}
else {
field_callPriority = OMIT_VALUE;
}
for (int i = 1; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct ProvideSubscriberInfoArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
OCTETSTRING_template field_lmsi;
RequestedInfo_template field_requestedInfo;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
INTEGER_template field_callPriority;
};

void ProvideSubscriberInfoArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_lmsi = ANY_OR_OMIT;
single_value->field_requestedInfo = ANY_VALUE;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_callPriority = ANY_OR_OMIT;
}
}
}

void ProvideSubscriberInfoArg_template::copy_value(const ProvideSubscriberInfoArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.lmsi().is_bound()) {
  if (other_value.lmsi().ispresent()) single_value->field_lmsi = other_value.lmsi()();
  else single_value->field_lmsi = OMIT_VALUE;
} else {
  single_value->field_lmsi.clean_up();
}
if (other_value.requestedInfo().is_bound()) {
  single_value->field_requestedInfo = other_value.requestedInfo();
} else {
  single_value->field_requestedInfo.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.callPriority().is_bound()) {
  if (other_value.callPriority().ispresent()) single_value->field_callPriority = other_value.callPriority()();
  else single_value->field_callPriority = OMIT_VALUE;
} else {
  single_value->field_callPriority.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ProvideSubscriberInfoArg_template::copy_template(const ProvideSubscriberInfoArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lmsi().get_selection()) {
single_value->field_lmsi = other_value.lmsi();
} else {
single_value->field_lmsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requestedInfo().get_selection()) {
single_value->field_requestedInfo = other_value.requestedInfo();
} else {
single_value->field_requestedInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callPriority().get_selection()) {
single_value->field_callPriority = other_value.callPriority();
} else {
single_value->field_callPriority.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ProvideSubscriberInfoArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ProvideSubscriberInfoArg_template(*other_value.implication_.precondition);
implication_.implied_template = new ProvideSubscriberInfoArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
break;
}
set_selection(other_value);
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template()
{
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(const ProvideSubscriberInfoArg& other_value)
{
copy_value(other_value);
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(const OPTIONAL<ProvideSubscriberInfoArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProvideSubscriberInfoArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg from an unbound optional field.");
}
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(ProvideSubscriberInfoArg_template* p_precondition, ProvideSubscriberInfoArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(Dynamic_Match_Interface<ProvideSubscriberInfoArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ProvideSubscriberInfoArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ProvideSubscriberInfoArg_template::ProvideSubscriberInfoArg_template(const ProvideSubscriberInfoArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ProvideSubscriberInfoArg_template::~ProvideSubscriberInfoArg_template()
{
clean_up();
}

ProvideSubscriberInfoArg_template& ProvideSubscriberInfoArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ProvideSubscriberInfoArg_template& ProvideSubscriberInfoArg_template::operator=(const ProvideSubscriberInfoArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ProvideSubscriberInfoArg_template& ProvideSubscriberInfoArg_template::operator=(const OPTIONAL<ProvideSubscriberInfoArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProvideSubscriberInfoArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
}
return *this;
}

ProvideSubscriberInfoArg_template& ProvideSubscriberInfoArg_template::operator=(const ProvideSubscriberInfoArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ProvideSubscriberInfoArg_template::match(const ProvideSubscriberInfoArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.lmsi().is_bound()) return FALSE;
if((other_value.lmsi().ispresent() ? !single_value->field_lmsi.match((const OCTETSTRING&)other_value.lmsi(), legacy) : !single_value->field_lmsi.match_omit(legacy)))return FALSE;
if(!other_value.requestedInfo().is_bound()) return FALSE;
if(!single_value->field_requestedInfo.match(other_value.requestedInfo(), legacy))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.callPriority().is_bound()) return FALSE;
if((other_value.callPriority().ispresent() ? !single_value->field_callPriority.match((const INTEGER&)other_value.callPriority(), legacy) : !single_value->field_callPriority.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
}
return FALSE;
}

boolean ProvideSubscriberInfoArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || (single_value->field_lmsi.is_omit() || single_value->field_lmsi.is_bound())
 || single_value->field_requestedInfo.is_bound()
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_callPriority.is_omit() || single_value->field_callPriority.is_bound());
}

boolean ProvideSubscriberInfoArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && (single_value->field_lmsi.is_omit() || single_value->field_lmsi.is_value())
 && single_value->field_requestedInfo.is_value()
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_callPriority.is_omit() || single_value->field_callPriority.is_value());
}

void ProvideSubscriberInfoArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ProvideSubscriberInfoArg ProvideSubscriberInfoArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
ProvideSubscriberInfoArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_lmsi.is_omit()) ret_val.lmsi() = OMIT_VALUE;
else if (single_value->field_lmsi.is_bound()) {
ret_val.lmsi() = single_value->field_lmsi.valueof();
}
if (single_value->field_requestedInfo.is_bound()) {
ret_val.requestedInfo() = single_value->field_requestedInfo.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_callPriority.is_omit()) ret_val.callPriority() = OMIT_VALUE;
else if (single_value->field_callPriority.is_bound()) {
ret_val.callPriority() = single_value->field_callPriority.valueof();
}
return ret_val;
}

void ProvideSubscriberInfoArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ProvideSubscriberInfoArg_template[list_length];
}

ProvideSubscriberInfoArg_template& ProvideSubscriberInfoArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ProvideSubscriberInfoArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& ProvideSubscriberInfoArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return single_value->field_imsi;
}

OCTETSTRING_template& ProvideSubscriberInfoArg_template::lmsi()
{
set_specific();
return single_value->field_lmsi;
}

const OCTETSTRING_template& ProvideSubscriberInfoArg_template::lmsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lmsi of a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return single_value->field_lmsi;
}

RequestedInfo_template& ProvideSubscriberInfoArg_template::requestedInfo()
{
set_specific();
return single_value->field_requestedInfo;
}

const RequestedInfo_template& ProvideSubscriberInfoArg_template::requestedInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requestedInfo of a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return single_value->field_requestedInfo;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& ProvideSubscriberInfoArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& ProvideSubscriberInfoArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return single_value->field_extensionContainer;
}

INTEGER_template& ProvideSubscriberInfoArg_template::callPriority()
{
set_specific();
return single_value->field_callPriority;
}

const INTEGER_template& ProvideSubscriberInfoArg_template::callPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callPriority of a non-specific template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
return single_value->field_callPriority;
}

int ProvideSubscriberInfoArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_lmsi.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_callPriority.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
  }
  return 0;
}

void ProvideSubscriberInfoArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", lmsi := ");
single_value->field_lmsi.log();
TTCN_Logger::log_event_str(", requestedInfo := ");
single_value->field_requestedInfo.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", callPriority := ");
single_value->field_callPriority.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ProvideSubscriberInfoArg_template::log_match(const ProvideSubscriberInfoArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.lmsi().ispresent()){
if(!single_value->field_lmsi.match(match_value.lmsi(), legacy)){
TTCN_Logger::log_logmatch_info(".lmsi");
single_value->field_lmsi.log_match(match_value.lmsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lmsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lmsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lmsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_requestedInfo.match(match_value.requestedInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".requestedInfo");
single_value->field_requestedInfo.log_match(match_value.requestedInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.callPriority().ispresent()){
if(!single_value->field_callPriority.match(match_value.callPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".callPriority");
single_value->field_callPriority.log_match(match_value.callPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_callPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".callPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_callPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", lmsi := ");
if (match_value.lmsi().ispresent()) {
single_value->field_lmsi.log_match(match_value.lmsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lmsi.log();
if (single_value->field_lmsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", requestedInfo := ");
single_value->field_requestedInfo.log_match(match_value.requestedInfo(), legacy);
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", callPriority := ");
if (match_value.callPriority().ispresent()) {
single_value->field_callPriority.log_match(match_value.callPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_callPriority.log();
if (single_value->field_callPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ProvideSubscriberInfoArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (!lmsi().is_bound()) lmsi() = OMIT_VALUE;
else lmsi().set_implicit_omit();
if (requestedInfo().is_bound()) requestedInfo().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!callPriority().is_bound()) callPriority() = OMIT_VALUE;
else callPriority().set_implicit_omit();
}

void ProvideSubscriberInfoArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_lmsi.encode_text(text_buf);
single_value->field_requestedInfo.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_callPriority.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
}
}

void ProvideSubscriberInfoArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_lmsi.decode_text(text_buf);
single_value->field_requestedInfo.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_callPriority.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ProvideSubscriberInfoArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg.");
}
}

void ProvideSubscriberInfoArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ProvideSubscriberInfoArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.ProvideSubscriberInfoArg has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lmsi().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) requestedInfo().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) callPriority().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lmsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lmsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requestedInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requestedInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.ProvideSubscriberInfoArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ProvideSubscriberInfoArg_template* precondition = new ProvideSubscriberInfoArg_template;
    precondition->set_param(*param.get_elem(0));
    ProvideSubscriberInfoArg_template* implied_template = new ProvideSubscriberInfoArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ProvideSubscriberInfoArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void ProvideSubscriberInfoArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
single_value->field_lmsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
single_value->field_requestedInfo.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
single_value->field_callPriority.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.ProvideSubscriberInfoArg");
}

boolean ProvideSubscriberInfoArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ProvideSubscriberInfoArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SubscriberInfo::SubscriberInfo()
{
}

SubscriberInfo::SubscriberInfo(const OPTIONAL< LocationInformation >& par_locationInformation,
    const OPTIONAL< SubscriberState >& par_subscriberState,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< LocationInformationGPRS >& par_locationInformationGPRS,
    const OPTIONAL< PS__SubscriberState >& par_ps__SubscriberState,
    const OPTIONAL< OCTETSTRING >& par_imei,
    const OPTIONAL< OCTETSTRING >& par_ms__Classmark2,
    const OPTIONAL< GPRSMSClass >& par_gprs__MS__Class,
    const OPTIONAL< MNPInfoRes >& par_mnpInfoRes,
    const OPTIONAL< IMS__VoiceOverPS__SessionsInd >& par_imsVoiceOverPS__SessionsIndication,
    const OPTIONAL< OCTETSTRING >& par_lastUE__ActivityTime,
    const OPTIONAL< Used__RAT__Type >& par_lastRAT__Type,
    const OPTIONAL< PS__SubscriberState >& par_eps__SubscriberState,
    const OPTIONAL< LocationInformationEPS >& par_locationInformationEPS)
  :   field_locationInformation(par_locationInformation),
  field_subscriberState(par_subscriberState),
  field_extensionContainer(par_extensionContainer),
  field_locationInformationGPRS(par_locationInformationGPRS),
  field_ps__SubscriberState(par_ps__SubscriberState),
  field_imei(par_imei),
  field_ms__Classmark2(par_ms__Classmark2),
  field_gprs__MS__Class(par_gprs__MS__Class),
  field_mnpInfoRes(par_mnpInfoRes),
  field_imsVoiceOverPS__SessionsIndication(par_imsVoiceOverPS__SessionsIndication),
  field_lastUE__ActivityTime(par_lastUE__ActivityTime),
  field_lastRAT__Type(par_lastRAT__Type),
  field_eps__SubscriberState(par_eps__SubscriberState),
  field_locationInformationEPS(par_locationInformationEPS)
{
}

SubscriberInfo::SubscriberInfo(const SubscriberInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.SubscriberInfo.");
if (other_value.locationInformation().is_bound()) field_locationInformation = other_value.locationInformation();
else field_locationInformation.clean_up();
if (other_value.subscriberState().is_bound()) field_subscriberState = other_value.subscriberState();
else field_subscriberState.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.locationInformationGPRS().is_bound()) field_locationInformationGPRS = other_value.locationInformationGPRS();
else field_locationInformationGPRS.clean_up();
if (other_value.ps__SubscriberState().is_bound()) field_ps__SubscriberState = other_value.ps__SubscriberState();
else field_ps__SubscriberState.clean_up();
if (other_value.imei().is_bound()) field_imei = other_value.imei();
else field_imei.clean_up();
if (other_value.ms__Classmark2().is_bound()) field_ms__Classmark2 = other_value.ms__Classmark2();
else field_ms__Classmark2.clean_up();
if (other_value.gprs__MS__Class().is_bound()) field_gprs__MS__Class = other_value.gprs__MS__Class();
else field_gprs__MS__Class.clean_up();
if (other_value.mnpInfoRes().is_bound()) field_mnpInfoRes = other_value.mnpInfoRes();
else field_mnpInfoRes.clean_up();
if (other_value.imsVoiceOverPS__SessionsIndication().is_bound()) field_imsVoiceOverPS__SessionsIndication = other_value.imsVoiceOverPS__SessionsIndication();
else field_imsVoiceOverPS__SessionsIndication.clean_up();
if (other_value.lastUE__ActivityTime().is_bound()) field_lastUE__ActivityTime = other_value.lastUE__ActivityTime();
else field_lastUE__ActivityTime.clean_up();
if (other_value.lastRAT__Type().is_bound()) field_lastRAT__Type = other_value.lastRAT__Type();
else field_lastRAT__Type.clean_up();
if (other_value.eps__SubscriberState().is_bound()) field_eps__SubscriberState = other_value.eps__SubscriberState();
else field_eps__SubscriberState.clean_up();
if (other_value.locationInformationEPS().is_bound()) field_locationInformationEPS = other_value.locationInformationEPS();
else field_locationInformationEPS.clean_up();
}

void SubscriberInfo::clean_up()
{
field_locationInformation.clean_up();
field_subscriberState.clean_up();
field_extensionContainer.clean_up();
field_locationInformationGPRS.clean_up();
field_ps__SubscriberState.clean_up();
field_imei.clean_up();
field_ms__Classmark2.clean_up();
field_gprs__MS__Class.clean_up();
field_mnpInfoRes.clean_up();
field_imsVoiceOverPS__SessionsIndication.clean_up();
field_lastUE__ActivityTime.clean_up();
field_lastRAT__Type.clean_up();
field_eps__SubscriberState.clean_up();
field_locationInformationEPS.clean_up();
}

const TTCN_Typedescriptor_t* SubscriberInfo::get_descriptor() const { return &SubscriberInfo_descr_; }
SubscriberInfo& SubscriberInfo::operator=(const SubscriberInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.SubscriberInfo.");
  if (other_value.locationInformation().is_bound()) field_locationInformation = other_value.locationInformation();
  else field_locationInformation.clean_up();
  if (other_value.subscriberState().is_bound()) field_subscriberState = other_value.subscriberState();
  else field_subscriberState.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.locationInformationGPRS().is_bound()) field_locationInformationGPRS = other_value.locationInformationGPRS();
  else field_locationInformationGPRS.clean_up();
  if (other_value.ps__SubscriberState().is_bound()) field_ps__SubscriberState = other_value.ps__SubscriberState();
  else field_ps__SubscriberState.clean_up();
  if (other_value.imei().is_bound()) field_imei = other_value.imei();
  else field_imei.clean_up();
  if (other_value.ms__Classmark2().is_bound()) field_ms__Classmark2 = other_value.ms__Classmark2();
  else field_ms__Classmark2.clean_up();
  if (other_value.gprs__MS__Class().is_bound()) field_gprs__MS__Class = other_value.gprs__MS__Class();
  else field_gprs__MS__Class.clean_up();
  if (other_value.mnpInfoRes().is_bound()) field_mnpInfoRes = other_value.mnpInfoRes();
  else field_mnpInfoRes.clean_up();
  if (other_value.imsVoiceOverPS__SessionsIndication().is_bound()) field_imsVoiceOverPS__SessionsIndication = other_value.imsVoiceOverPS__SessionsIndication();
  else field_imsVoiceOverPS__SessionsIndication.clean_up();
  if (other_value.lastUE__ActivityTime().is_bound()) field_lastUE__ActivityTime = other_value.lastUE__ActivityTime();
  else field_lastUE__ActivityTime.clean_up();
  if (other_value.lastRAT__Type().is_bound()) field_lastRAT__Type = other_value.lastRAT__Type();
  else field_lastRAT__Type.clean_up();
  if (other_value.eps__SubscriberState().is_bound()) field_eps__SubscriberState = other_value.eps__SubscriberState();
  else field_eps__SubscriberState.clean_up();
  if (other_value.locationInformationEPS().is_bound()) field_locationInformationEPS = other_value.locationInformationEPS();
  else field_locationInformationEPS.clean_up();
}
return *this;
}

boolean SubscriberInfo::operator==(const SubscriberInfo& other_value) const
{
return field_locationInformation==other_value.field_locationInformation
  && field_subscriberState==other_value.field_subscriberState
  && field_extensionContainer==other_value.field_extensionContainer
  && field_locationInformationGPRS==other_value.field_locationInformationGPRS
  && field_ps__SubscriberState==other_value.field_ps__SubscriberState
  && field_imei==other_value.field_imei
  && field_ms__Classmark2==other_value.field_ms__Classmark2
  && field_gprs__MS__Class==other_value.field_gprs__MS__Class
  && field_mnpInfoRes==other_value.field_mnpInfoRes
  && field_imsVoiceOverPS__SessionsIndication==other_value.field_imsVoiceOverPS__SessionsIndication
  && field_lastUE__ActivityTime==other_value.field_lastUE__ActivityTime
  && field_lastRAT__Type==other_value.field_lastRAT__Type
  && field_eps__SubscriberState==other_value.field_eps__SubscriberState
  && field_locationInformationEPS==other_value.field_locationInformationEPS;
}

boolean SubscriberInfo::is_bound() const
{
return (OPTIONAL_OMIT == field_locationInformation.get_selection() || field_locationInformation.is_bound())
  || (OPTIONAL_OMIT == field_subscriberState.get_selection() || field_subscriberState.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_locationInformationGPRS.get_selection() || field_locationInformationGPRS.is_bound())
  || (OPTIONAL_OMIT == field_ps__SubscriberState.get_selection() || field_ps__SubscriberState.is_bound())
  || (OPTIONAL_OMIT == field_imei.get_selection() || field_imei.is_bound())
  || (OPTIONAL_OMIT == field_ms__Classmark2.get_selection() || field_ms__Classmark2.is_bound())
  || (OPTIONAL_OMIT == field_gprs__MS__Class.get_selection() || field_gprs__MS__Class.is_bound())
  || (OPTIONAL_OMIT == field_mnpInfoRes.get_selection() || field_mnpInfoRes.is_bound())
  || (OPTIONAL_OMIT == field_imsVoiceOverPS__SessionsIndication.get_selection() || field_imsVoiceOverPS__SessionsIndication.is_bound())
  || (OPTIONAL_OMIT == field_lastUE__ActivityTime.get_selection() || field_lastUE__ActivityTime.is_bound())
  || (OPTIONAL_OMIT == field_lastRAT__Type.get_selection() || field_lastRAT__Type.is_bound())
  || (OPTIONAL_OMIT == field_eps__SubscriberState.get_selection() || field_eps__SubscriberState.is_bound())
  || (OPTIONAL_OMIT == field_locationInformationEPS.get_selection() || field_locationInformationEPS.is_bound());
}
boolean SubscriberInfo::is_value() const
{
return (OPTIONAL_OMIT == field_locationInformation.get_selection() || field_locationInformation.is_value())
  && (OPTIONAL_OMIT == field_subscriberState.get_selection() || field_subscriberState.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_locationInformationGPRS.get_selection() || field_locationInformationGPRS.is_value())
  && (OPTIONAL_OMIT == field_ps__SubscriberState.get_selection() || field_ps__SubscriberState.is_value())
  && (OPTIONAL_OMIT == field_imei.get_selection() || field_imei.is_value())
  && (OPTIONAL_OMIT == field_ms__Classmark2.get_selection() || field_ms__Classmark2.is_value())
  && (OPTIONAL_OMIT == field_gprs__MS__Class.get_selection() || field_gprs__MS__Class.is_value())
  && (OPTIONAL_OMIT == field_mnpInfoRes.get_selection() || field_mnpInfoRes.is_value())
  && (OPTIONAL_OMIT == field_imsVoiceOverPS__SessionsIndication.get_selection() || field_imsVoiceOverPS__SessionsIndication.is_value())
  && (OPTIONAL_OMIT == field_lastUE__ActivityTime.get_selection() || field_lastUE__ActivityTime.is_value())
  && (OPTIONAL_OMIT == field_lastRAT__Type.get_selection() || field_lastRAT__Type.is_value())
  && (OPTIONAL_OMIT == field_eps__SubscriberState.get_selection() || field_eps__SubscriberState.is_value())
  && (OPTIONAL_OMIT == field_locationInformationEPS.get_selection() || field_locationInformationEPS.is_value());
}
int SubscriberInfo::size_of() const
{
  int ret_val = 0;
  if (field_locationInformation.ispresent()) ret_val++;
  if (field_subscriberState.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_locationInformationGPRS.ispresent()) ret_val++;
  if (field_ps__SubscriberState.ispresent()) ret_val++;
  if (field_imei.ispresent()) ret_val++;
  if (field_ms__Classmark2.ispresent()) ret_val++;
  if (field_gprs__MS__Class.ispresent()) ret_val++;
  if (field_mnpInfoRes.ispresent()) ret_val++;
  if (field_imsVoiceOverPS__SessionsIndication.ispresent()) ret_val++;
  if (field_lastUE__ActivityTime.ispresent()) ret_val++;
  if (field_lastRAT__Type.ispresent()) ret_val++;
  if (field_eps__SubscriberState.ispresent()) ret_val++;
  if (field_locationInformationEPS.ispresent()) ret_val++;
  return ret_val;
}

void SubscriberInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ locationInformation := ");
field_locationInformation.log();
TTCN_Logger::log_event_str(", subscriberState := ");
field_subscriberState.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", locationInformationGPRS := ");
field_locationInformationGPRS.log();
TTCN_Logger::log_event_str(", ps_SubscriberState := ");
field_ps__SubscriberState.log();
TTCN_Logger::log_event_str(", imei := ");
field_imei.log();
TTCN_Logger::log_event_str(", ms_Classmark2 := ");
field_ms__Classmark2.log();
TTCN_Logger::log_event_str(", gprs_MS_Class := ");
field_gprs__MS__Class.log();
TTCN_Logger::log_event_str(", mnpInfoRes := ");
field_mnpInfoRes.log();
TTCN_Logger::log_event_str(", imsVoiceOverPS_SessionsIndication := ");
field_imsVoiceOverPS__SessionsIndication.log();
TTCN_Logger::log_event_str(", lastUE_ActivityTime := ");
field_lastUE__ActivityTime.log();
TTCN_Logger::log_event_str(", lastRAT_Type := ");
field_lastRAT__Type.log();
TTCN_Logger::log_event_str(", eps_SubscriberState := ");
field_eps__SubscriberState.log();
TTCN_Logger::log_event_str(", locationInformationEPS := ");
field_locationInformationEPS.log();
TTCN_Logger::log_event_str(" }");
}

void SubscriberInfo::set_implicit_omit()
{
if (!locationInformation().is_bound()) locationInformation() = OMIT_VALUE;
else locationInformation().set_implicit_omit();
if (!subscriberState().is_bound()) subscriberState() = OMIT_VALUE;
else subscriberState().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!locationInformationGPRS().is_bound()) locationInformationGPRS() = OMIT_VALUE;
else locationInformationGPRS().set_implicit_omit();
if (!ps__SubscriberState().is_bound()) ps__SubscriberState() = OMIT_VALUE;
else ps__SubscriberState().set_implicit_omit();
if (!imei().is_bound()) imei() = OMIT_VALUE;
else imei().set_implicit_omit();
if (!ms__Classmark2().is_bound()) ms__Classmark2() = OMIT_VALUE;
else ms__Classmark2().set_implicit_omit();
if (!gprs__MS__Class().is_bound()) gprs__MS__Class() = OMIT_VALUE;
else gprs__MS__Class().set_implicit_omit();
if (!mnpInfoRes().is_bound()) mnpInfoRes() = OMIT_VALUE;
else mnpInfoRes().set_implicit_omit();
if (!imsVoiceOverPS__SessionsIndication().is_bound()) imsVoiceOverPS__SessionsIndication() = OMIT_VALUE;
else imsVoiceOverPS__SessionsIndication().set_implicit_omit();
if (!lastUE__ActivityTime().is_bound()) lastUE__ActivityTime() = OMIT_VALUE;
else lastUE__ActivityTime().set_implicit_omit();
if (!lastRAT__Type().is_bound()) lastRAT__Type() = OMIT_VALUE;
else lastRAT__Type().set_implicit_omit();
if (!eps__SubscriberState().is_bound()) eps__SubscriberState() = OMIT_VALUE;
else eps__SubscriberState().set_implicit_omit();
if (!locationInformationEPS().is_bound()) locationInformationEPS() = OMIT_VALUE;
else locationInformationEPS().set_implicit_omit();
}

void SubscriberInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (14<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.SubscriberInfo has 14 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) locationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) subscriberState().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locationInformationGPRS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ps__SubscriberState().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) imei().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ms__Classmark2().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) gprs__MS__Class().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) mnpInfoRes().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) imsVoiceOverPS__SessionsIndication().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) lastUE__ActivityTime().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) lastRAT__Type().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) eps__SubscriberState().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS().set_param(*param.get_elem(13));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationGPRS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationGPRS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ps_SubscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ps__SubscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imei")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imei().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_Classmark2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__Classmark2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprs_MS_Class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprs__MS__Class().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mnpInfoRes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mnpInfoRes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsVoiceOverPS_SessionsIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsVoiceOverPS__SessionsIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lastUE_ActivityTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lastUE__ActivityTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lastRAT_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lastRAT__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eps_SubscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eps__SubscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.SubscriberInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.SubscriberInfo");
  }
}

void SubscriberInfo::encode_text(Text_Buf& text_buf) const
{
field_locationInformation.encode_text(text_buf);
field_subscriberState.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_locationInformationGPRS.encode_text(text_buf);
field_ps__SubscriberState.encode_text(text_buf);
field_imei.encode_text(text_buf);
field_ms__Classmark2.encode_text(text_buf);
field_gprs__MS__Class.encode_text(text_buf);
field_mnpInfoRes.encode_text(text_buf);
field_imsVoiceOverPS__SessionsIndication.encode_text(text_buf);
field_lastUE__ActivityTime.encode_text(text_buf);
field_lastRAT__Type.encode_text(text_buf);
field_eps__SubscriberState.encode_text(text_buf);
field_locationInformationEPS.encode_text(text_buf);
}

void SubscriberInfo::decode_text(Text_Buf& text_buf)
{
field_locationInformation.decode_text(text_buf);
field_subscriberState.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_locationInformationGPRS.decode_text(text_buf);
field_ps__SubscriberState.decode_text(text_buf);
field_imei.decode_text(text_buf);
field_ms__Classmark2.decode_text(text_buf);
field_gprs__MS__Class.decode_text(text_buf);
field_mnpInfoRes.decode_text(text_buf);
field_imsVoiceOverPS__SessionsIndication.decode_text(text_buf);
field_lastUE__ActivityTime.decode_text(text_buf);
field_lastRAT__Type.decode_text(text_buf);
field_eps__SubscriberState.decode_text(text_buf);
field_locationInformationEPS.decode_text(text_buf);
}

void SubscriberInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SubscriberInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* SubscriberInfo::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("locationInformation': ");
  new_tlv->add_TLV(field_locationInformation.BER_encode_TLV(SubscriberInfo_locationInformation_descr_, p_coding));
  ec_1.set_msg("subscriberState': ");
  new_tlv->add_TLV(field_subscriberState.BER_encode_TLV(SubscriberInfo_subscriberState_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(SubscriberInfo_extensionContainer_descr_, p_coding));
  ec_1.set_msg("locationInformationGPRS': ");
  new_tlv->add_TLV(field_locationInformationGPRS.BER_encode_TLV(SubscriberInfo_locationInformationGPRS_descr_, p_coding));
  ec_1.set_msg("ps_SubscriberState': ");
  new_tlv->add_TLV(field_ps__SubscriberState.BER_encode_TLV(SubscriberInfo_ps__SubscriberState_descr_, p_coding));
  ec_1.set_msg("imei': ");
  new_tlv->add_TLV(field_imei.BER_encode_TLV(SubscriberInfo_imei_descr_, p_coding));
  ec_1.set_msg("ms_Classmark2': ");
  new_tlv->add_TLV(field_ms__Classmark2.BER_encode_TLV(SubscriberInfo_ms__Classmark2_descr_, p_coding));
  ec_1.set_msg("gprs_MS_Class': ");
  new_tlv->add_TLV(field_gprs__MS__Class.BER_encode_TLV(SubscriberInfo_gprs__MS__Class_descr_, p_coding));
  ec_1.set_msg("mnpInfoRes': ");
  new_tlv->add_TLV(field_mnpInfoRes.BER_encode_TLV(SubscriberInfo_mnpInfoRes_descr_, p_coding));
  ec_1.set_msg("imsVoiceOverPS_SessionsIndication': ");
  new_tlv->add_TLV(field_imsVoiceOverPS__SessionsIndication.BER_encode_TLV(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, p_coding));
  ec_1.set_msg("lastUE_ActivityTime': ");
  new_tlv->add_TLV(field_lastUE__ActivityTime.BER_encode_TLV(SubscriberInfo_lastUE__ActivityTime_descr_, p_coding));
  ec_1.set_msg("lastRAT_Type': ");
  new_tlv->add_TLV(field_lastRAT__Type.BER_encode_TLV(SubscriberInfo_lastRAT__Type_descr_, p_coding));
  ec_1.set_msg("eps_SubscriberState': ");
  new_tlv->add_TLV(field_eps__SubscriberState.BER_encode_TLV(SubscriberInfo_eps__SubscriberState_descr_, p_coding));
  ec_1.set_msg("locationInformationEPS': ");
  new_tlv->add_TLV(field_locationInformationEPS.BER_encode_TLV(SubscriberInfo_locationInformationEPS_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean SubscriberInfo::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.SubscriberInfo' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("locationInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformation=OMIT_VALUE;
    else {
      field_locationInformation.BER_decode_TLV(SubscriberInfo_locationInformation_descr_, tmp_tlv, L_form);
      if(field_locationInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("subscriberState': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_subscriberState=OMIT_VALUE;
    else {
      field_subscriberState.BER_decode_TLV(SubscriberInfo_subscriberState_descr_, tmp_tlv, L_form);
      if(field_subscriberState.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(SubscriberInfo_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("locationInformationGPRS': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformationGPRS=OMIT_VALUE;
    else {
      field_locationInformationGPRS.BER_decode_TLV(SubscriberInfo_locationInformationGPRS_descr_, tmp_tlv, L_form);
      if(field_locationInformationGPRS.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ps_SubscriberState': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ps__SubscriberState=OMIT_VALUE;
    else {
      field_ps__SubscriberState.BER_decode_TLV(SubscriberInfo_ps__SubscriberState_descr_, tmp_tlv, L_form);
      if(field_ps__SubscriberState.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("imei': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_imei=OMIT_VALUE;
    else {
      field_imei.BER_decode_TLV(SubscriberInfo_imei_descr_, tmp_tlv, L_form);
      if(field_imei.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ms_Classmark2': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ms__Classmark2=OMIT_VALUE;
    else {
      field_ms__Classmark2.BER_decode_TLV(SubscriberInfo_ms__Classmark2_descr_, tmp_tlv, L_form);
      if(field_ms__Classmark2.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("gprs_MS_Class': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_gprs__MS__Class=OMIT_VALUE;
    else {
      field_gprs__MS__Class.BER_decode_TLV(SubscriberInfo_gprs__MS__Class_descr_, tmp_tlv, L_form);
      if(field_gprs__MS__Class.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mnpInfoRes': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mnpInfoRes=OMIT_VALUE;
    else {
      field_mnpInfoRes.BER_decode_TLV(SubscriberInfo_mnpInfoRes_descr_, tmp_tlv, L_form);
      if(field_mnpInfoRes.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("imsVoiceOverPS_SessionsIndication': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_imsVoiceOverPS__SessionsIndication=OMIT_VALUE;
    else {
      field_imsVoiceOverPS__SessionsIndication.BER_decode_TLV(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, tmp_tlv, L_form);
      if(field_imsVoiceOverPS__SessionsIndication.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("lastUE_ActivityTime': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_lastUE__ActivityTime=OMIT_VALUE;
    else {
      field_lastUE__ActivityTime.BER_decode_TLV(SubscriberInfo_lastUE__ActivityTime_descr_, tmp_tlv, L_form);
      if(field_lastUE__ActivityTime.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("lastRAT_Type': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_lastRAT__Type=OMIT_VALUE;
    else {
      field_lastRAT__Type.BER_decode_TLV(SubscriberInfo_lastRAT__Type_descr_, tmp_tlv, L_form);
      if(field_lastRAT__Type.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("eps_SubscriberState': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_eps__SubscriberState=OMIT_VALUE;
    else {
      field_eps__SubscriberState.BER_decode_TLV(SubscriberInfo_eps__SubscriberState_descr_, tmp_tlv, L_form);
      if(field_eps__SubscriberState.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("locationInformationEPS': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformationEPS=OMIT_VALUE;
    else {
      field_locationInformationEPS.BER_decode_TLV(SubscriberInfo_locationInformationEPS_descr_, tmp_tlv, L_form);
      if(field_locationInformationEPS.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int SubscriberInfo::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.SubscriberInfo.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_locationInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformation");
    enc_len += field_locationInformation.JSON_encode(SubscriberInfo_locationInformation_descr_, p_tok, FALSE);
  }

  if (field_subscriberState.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "subscriberState");
    enc_len += field_subscriberState.JSON_encode(SubscriberInfo_subscriberState_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(SubscriberInfo_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_locationInformationGPRS.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformationGPRS");
    enc_len += field_locationInformationGPRS.JSON_encode(SubscriberInfo_locationInformationGPRS_descr_, p_tok, FALSE);
  }

  if (field_ps__SubscriberState.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ps_SubscriberState");
    enc_len += field_ps__SubscriberState.JSON_encode(SubscriberInfo_ps__SubscriberState_descr_, p_tok, FALSE);
  }

  if (field_imei.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imei");
    enc_len += field_imei.JSON_encode(SubscriberInfo_imei_descr_, p_tok, FALSE);
  }

  if (field_ms__Classmark2.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ms_Classmark2");
    enc_len += field_ms__Classmark2.JSON_encode(SubscriberInfo_ms__Classmark2_descr_, p_tok, FALSE);
  }

  if (field_gprs__MS__Class.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gprs_MS_Class");
    enc_len += field_gprs__MS__Class.JSON_encode(SubscriberInfo_gprs__MS__Class_descr_, p_tok, FALSE);
  }

  if (field_mnpInfoRes.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mnpInfoRes");
    enc_len += field_mnpInfoRes.JSON_encode(SubscriberInfo_mnpInfoRes_descr_, p_tok, FALSE);
  }

  if (field_imsVoiceOverPS__SessionsIndication.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsVoiceOverPS_SessionsIndication");
    enc_len += field_imsVoiceOverPS__SessionsIndication.JSON_encode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, p_tok, FALSE);
  }

  if (field_lastUE__ActivityTime.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "lastUE_ActivityTime");
    enc_len += field_lastUE__ActivityTime.JSON_encode(SubscriberInfo_lastUE__ActivityTime_descr_, p_tok, FALSE);
  }

  if (field_lastRAT__Type.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "lastRAT_Type");
    enc_len += field_lastRAT__Type.JSON_encode(SubscriberInfo_lastRAT__Type_descr_, p_tok, FALSE);
  }

  if (field_eps__SubscriberState.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "eps_SubscriberState");
    enc_len += field_eps__SubscriberState.JSON_encode(SubscriberInfo_eps__SubscriberState_descr_, p_tok, FALSE);
  }

  if (field_locationInformationEPS.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformationEPS");
    enc_len += field_locationInformationEPS.JSON_encode(SubscriberInfo_locationInformationEPS_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int SubscriberInfo::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const SubscriberInfo*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean locationInformation_found = FALSE;
  boolean subscriberState_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean locationInformationGPRS_found = FALSE;
  boolean ps__SubscriberState_found = FALSE;
  boolean imei_found = FALSE;
  boolean ms__Classmark2_found = FALSE;
  boolean gprs__MS__Class_found = FALSE;
  boolean mnpInfoRes_found = FALSE;
  boolean imsVoiceOverPS__SessionsIndication_found = FALSE;
  boolean lastUE__ActivityTime_found = FALSE;
  boolean lastRAT__Type_found = FALSE;
  boolean eps__SubscriberState_found = FALSE;
  boolean locationInformationEPS_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (19 == name_len && 0 == strncmp(fld_name, "locationInformation", name_len)) {
        locationInformation_found = TRUE;
         int ret_val = field_locationInformation.JSON_decode(SubscriberInfo_locationInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "locationInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "subscriberState", name_len)) {
        subscriberState_found = TRUE;
         int ret_val = field_subscriberState.JSON_decode(SubscriberInfo_subscriberState_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "subscriberState");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(SubscriberInfo_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (23 == name_len && 0 == strncmp(fld_name, "locationInformationGPRS", name_len)) {
        locationInformationGPRS_found = TRUE;
         int ret_val = field_locationInformationGPRS.JSON_decode(SubscriberInfo_locationInformationGPRS_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "locationInformationGPRS");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "ps_SubscriberState", name_len)) {
        ps__SubscriberState_found = TRUE;
         int ret_val = field_ps__SubscriberState.JSON_decode(SubscriberInfo_ps__SubscriberState_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "ps_SubscriberState");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "imei", name_len)) {
        imei_found = TRUE;
         int ret_val = field_imei.JSON_decode(SubscriberInfo_imei_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imei");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "ms_Classmark2", name_len)) {
        ms__Classmark2_found = TRUE;
         int ret_val = field_ms__Classmark2.JSON_decode(SubscriberInfo_ms__Classmark2_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "ms_Classmark2");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "gprs_MS_Class", name_len)) {
        gprs__MS__Class_found = TRUE;
         int ret_val = field_gprs__MS__Class.JSON_decode(SubscriberInfo_gprs__MS__Class_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "gprs_MS_Class");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "mnpInfoRes", name_len)) {
        mnpInfoRes_found = TRUE;
         int ret_val = field_mnpInfoRes.JSON_decode(SubscriberInfo_mnpInfoRes_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "mnpInfoRes");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (33 == name_len && 0 == strncmp(fld_name, "imsVoiceOverPS_SessionsIndication", name_len)) {
        imsVoiceOverPS__SessionsIndication_found = TRUE;
         int ret_val = field_imsVoiceOverPS__SessionsIndication.JSON_decode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 33, "imsVoiceOverPS_SessionsIndication");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "lastUE_ActivityTime", name_len)) {
        lastUE__ActivityTime_found = TRUE;
         int ret_val = field_lastUE__ActivityTime.JSON_decode(SubscriberInfo_lastUE__ActivityTime_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "lastUE_ActivityTime");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "lastRAT_Type", name_len)) {
        lastRAT__Type_found = TRUE;
         int ret_val = field_lastRAT__Type.JSON_decode(SubscriberInfo_lastRAT__Type_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "lastRAT_Type");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "eps_SubscriberState", name_len)) {
        eps__SubscriberState_found = TRUE;
         int ret_val = field_eps__SubscriberState.JSON_decode(SubscriberInfo_eps__SubscriberState_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "eps_SubscriberState");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (22 == name_len && 0 == strncmp(fld_name, "locationInformationEPS", name_len)) {
        locationInformationEPS_found = TRUE;
         int ret_val = field_locationInformationEPS.JSON_decode(SubscriberInfo_locationInformationEPS_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 22, "locationInformationEPS");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!locationInformation_found) {
    field_locationInformation = OMIT_VALUE;
  }
  if (!subscriberState_found) {
    field_subscriberState = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!locationInformationGPRS_found) {
    field_locationInformationGPRS = OMIT_VALUE;
  }
  if (!ps__SubscriberState_found) {
    field_ps__SubscriberState = OMIT_VALUE;
  }
  if (!imei_found) {
    field_imei = OMIT_VALUE;
  }
  if (!ms__Classmark2_found) {
    field_ms__Classmark2 = OMIT_VALUE;
  }
  if (!gprs__MS__Class_found) {
    field_gprs__MS__Class = OMIT_VALUE;
  }
  if (!mnpInfoRes_found) {
    field_mnpInfoRes = OMIT_VALUE;
  }
  if (!imsVoiceOverPS__SessionsIndication_found) {
    field_imsVoiceOverPS__SessionsIndication = OMIT_VALUE;
  }
  if (!lastUE__ActivityTime_found) {
    field_lastUE__ActivityTime = OMIT_VALUE;
  }
  if (!lastRAT__Type_found) {
    field_lastRAT__Type = OMIT_VALUE;
  }
  if (!eps__SubscriberState_found) {
    field_eps__SubscriberState = OMIT_VALUE;
  }
  if (!locationInformationEPS_found) {
    field_locationInformationEPS = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int SubscriberInfo::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_locationInformationGPRS.is_bound() && field_locationInformationGPRS.is_present());
  has_extension = has_extension || (field_ps__SubscriberState.is_bound() && field_ps__SubscriberState.is_present());
  has_extension = has_extension || (field_imei.is_bound() && field_imei.is_present());
  has_extension = has_extension || (field_ms__Classmark2.is_bound() && field_ms__Classmark2.is_present());
  has_extension = has_extension || (field_gprs__MS__Class.is_bound() && field_gprs__MS__Class.is_present());
  has_extension = has_extension || (field_mnpInfoRes.is_bound() && field_mnpInfoRes.is_present());
  has_extension = has_extension || (field_imsVoiceOverPS__SessionsIndication.is_bound() && field_imsVoiceOverPS__SessionsIndication.is_present());
  has_extension = has_extension || (field_lastUE__ActivityTime.is_bound() && field_lastUE__ActivityTime.is_present());
  has_extension = has_extension || (field_lastRAT__Type.is_bound() && field_lastRAT__Type.is_present());
  has_extension = has_extension || (field_eps__SubscriberState.is_bound() && field_eps__SubscriberState.is_present());
  has_extension = has_extension || (field_locationInformationEPS.is_bound() && field_locationInformationEPS.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_locationInformation.is_present()) {
    c |= 64;
  }
  if (field_subscriberState.is_present()) {
    c |= 32;
  }
  if (field_extensionContainer.is_present()) {
    c |= 16;
  }
  p_buf.put_c(c);
  if (field_locationInformation.is_present())
    field_locationInformation.OER_encode(SubscriberInfo_locationInformation_descr_, p_buf);
  if (field_subscriberState.is_present())
    field_subscriberState.OER_encode(SubscriberInfo_subscriberState_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(SubscriberInfo_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_locationInformationGPRS.is_present()) {
      c |= 128;
      field_locationInformationGPRS.OER_encode(SubscriberInfo_locationInformationGPRS_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ps__SubscriberState.is_present()) {
      c |= 64;
      field_ps__SubscriberState.OER_encode(SubscriberInfo_ps__SubscriberState_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_imei.is_present()) {
      c |= 32;
      field_imei.OER_encode(SubscriberInfo_imei_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ms__Classmark2.is_present()) {
      c |= 16;
      field_ms__Classmark2.OER_encode(SubscriberInfo_ms__Classmark2_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_gprs__MS__Class.is_present()) {
      c |= 8;
      field_gprs__MS__Class.OER_encode(SubscriberInfo_gprs__MS__Class_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_mnpInfoRes.is_present()) {
      c |= 4;
      field_mnpInfoRes.OER_encode(SubscriberInfo_mnpInfoRes_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_imsVoiceOverPS__SessionsIndication.is_present()) {
      c |= 2;
      field_imsVoiceOverPS__SessionsIndication.OER_encode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_lastUE__ActivityTime.is_present()) {
      c |= 1;
      field_lastUE__ActivityTime.OER_encode(SubscriberInfo_lastUE__ActivityTime_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_lastRAT__Type.is_present()) {
      c |= 128;
      field_lastRAT__Type.OER_encode(SubscriberInfo_lastRAT__Type_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_eps__SubscriberState.is_present()) {
      c |= 64;
      field_eps__SubscriberState.OER_encode(SubscriberInfo_eps__SubscriberState_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_locationInformationEPS.is_present()) {
      c |= 32;
      field_locationInformationEPS.OER_encode(SubscriberInfo_locationInformationEPS_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(5);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int SubscriberInfo::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_locationInformation.OER_decode(SubscriberInfo_locationInformation_descr_, p_buf, p_oer);
 else
    field_locationInformation = OMIT_VALUE;
  if (uc[0] & 32)
    field_subscriberState.OER_decode(SubscriberInfo_subscriberState_descr_, p_buf, p_oer);
 else
    field_subscriberState = OMIT_VALUE;
  if (uc[0] & 16)
    field_extensionContainer.OER_decode(SubscriberInfo_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_locationInformationGPRS = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_locationInformationGPRS.OER_decode(SubscriberInfo_locationInformationGPRS_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_ps__SubscriberState = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ps__SubscriberState.OER_decode(SubscriberInfo_ps__SubscriberState_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_imei = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_imei.OER_decode(SubscriberInfo_imei_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_ms__Classmark2 = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ms__Classmark2.OER_decode(SubscriberInfo_ms__Classmark2_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_gprs__MS__Class = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_gprs__MS__Class.OER_decode(SubscriberInfo_gprs__MS__Class_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_mnpInfoRes = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mnpInfoRes.OER_decode(SubscriberInfo_mnpInfoRes_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_imsVoiceOverPS__SessionsIndication = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_imsVoiceOverPS__SessionsIndication.OER_decode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_lastUE__ActivityTime = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_lastUE__ActivityTime.OER_decode(SubscriberInfo_lastUE__ActivityTime_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_lastRAT__Type = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_lastRAT__Type.OER_decode(SubscriberInfo_lastRAT__Type_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 64)) {
      field_eps__SubscriberState = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_eps__SubscriberState.OER_decode(SubscriberInfo_eps__SubscriberState_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 32)) {
      field_locationInformationEPS = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_locationInformationEPS.OER_decode(SubscriberInfo_locationInformationEPS_descr_, p_buf, p_oer);
    }
  }
  else {
    field_locationInformationGPRS = OMIT_VALUE;
    field_ps__SubscriberState = OMIT_VALUE;
    field_imei = OMIT_VALUE;
    field_ms__Classmark2 = OMIT_VALUE;
    field_gprs__MS__Class = OMIT_VALUE;
    field_mnpInfoRes = OMIT_VALUE;
    field_imsVoiceOverPS__SessionsIndication = OMIT_VALUE;
    field_lastUE__ActivityTime = OMIT_VALUE;
    field_lastRAT__Type = OMIT_VALUE;
    field_eps__SubscriberState = OMIT_VALUE;
    field_locationInformationEPS = OMIT_VALUE;
  }
  return 0;
}

void SubscriberInfo::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_locationInformationGPRS.is_present();
boolean ext_1_present = field_ps__SubscriberState.is_present();
boolean ext_2_present = field_imei.is_present();
boolean ext_3_present = field_ms__Classmark2.is_present();
boolean ext_4_present = field_gprs__MS__Class.is_present();
boolean ext_5_present = field_mnpInfoRes.is_present();
boolean ext_6_present = field_imsVoiceOverPS__SessionsIndication.is_present();
boolean ext_7_present = field_lastUE__ActivityTime.is_present();
boolean ext_8_present = field_lastRAT__Type.is_present();
boolean ext_9_present = field_eps__SubscriberState.is_present();
boolean ext_10_present = field_locationInformationEPS.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present || ext_9_present || ext_10_present;
p_buf.PER_put_bit(ext_bit);
boolean field_locationInformation_present = field_locationInformation.is_present();
p_buf.PER_put_bit(field_locationInformation_present);
boolean field_subscriberState_present = field_subscriberState.is_present();
p_buf.PER_put_bit(field_subscriberState_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_locationInformation_present) field_locationInformation.PER_encode(SubscriberInfo_locationInformation_descr_, p_buf, p_options);
if (field_subscriberState_present) field_subscriberState.PER_encode(SubscriberInfo_subscriberState_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(SubscriberInfo_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(11);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
p_buf.PER_put_bit(ext_9_present);
p_buf.PER_put_bit(ext_10_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_locationInformationGPRS.PER_encode(SubscriberInfo_locationInformationGPRS_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_ps__SubscriberState.PER_encode(SubscriberInfo_ps__SubscriberState_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_imei.PER_encode(SubscriberInfo_imei_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_ms__Classmark2.PER_encode(SubscriberInfo_ms__Classmark2_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_gprs__MS__Class.PER_encode(SubscriberInfo_gprs__MS__Class_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_mnpInfoRes.PER_encode(SubscriberInfo_mnpInfoRes_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_imsVoiceOverPS__SessionsIndication.PER_encode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_lastUE__ActivityTime.PER_encode(SubscriberInfo_lastUE__ActivityTime_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_lastRAT__Type.PER_encode(SubscriberInfo_lastRAT__Type_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_9_present) {
TTCN_Buffer ext_add_buf;
field_eps__SubscriberState.PER_encode(SubscriberInfo_eps__SubscriberState_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_10_present) {
TTCN_Buffer ext_add_buf;
field_locationInformationEPS.PER_encode(SubscriberInfo_locationInformationEPS_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void SubscriberInfo::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_locationInformation_present = p_buf.PER_get_bit();
boolean field_subscriberState_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_locationInformation_present) field_locationInformation.PER_decode(SubscriberInfo_locationInformation_descr_, p_buf, p_options);
else field_locationInformation = OMIT_VALUE;
if (field_subscriberState_present) field_subscriberState.PER_decode(SubscriberInfo_subscriberState_descr_, p_buf, p_options);
else field_subscriberState = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(SubscriberInfo_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 11) {
for (int i = nof_decoded_ext_adds; i < 11; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_locationInformationGPRS.PER_decode(SubscriberInfo_locationInformationGPRS_descr_, ext_add_buf, p_options);
}
else {
field_locationInformationGPRS = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ps__SubscriberState.PER_decode(SubscriberInfo_ps__SubscriberState_descr_, ext_add_buf, p_options);
}
else {
field_ps__SubscriberState = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_imei.PER_decode(SubscriberInfo_imei_descr_, ext_add_buf, p_options);
}
else {
field_imei = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ms__Classmark2.PER_decode(SubscriberInfo_ms__Classmark2_descr_, ext_add_buf, p_options);
}
else {
field_ms__Classmark2 = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_gprs__MS__Class.PER_decode(SubscriberInfo_gprs__MS__Class_descr_, ext_add_buf, p_options);
}
else {
field_gprs__MS__Class = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mnpInfoRes.PER_decode(SubscriberInfo_mnpInfoRes_descr_, ext_add_buf, p_options);
}
else {
field_mnpInfoRes = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_imsVoiceOverPS__SessionsIndication.PER_decode(SubscriberInfo_imsVoiceOverPS__SessionsIndication_descr_, ext_add_buf, p_options);
}
else {
field_imsVoiceOverPS__SessionsIndication = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_lastUE__ActivityTime.PER_decode(SubscriberInfo_lastUE__ActivityTime_descr_, ext_add_buf, p_options);
}
else {
field_lastUE__ActivityTime = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_lastRAT__Type.PER_decode(SubscriberInfo_lastRAT__Type_descr_, ext_add_buf, p_options);
}
else {
field_lastRAT__Type = OMIT_VALUE;
}
if (ext_presences[9]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_eps__SubscriberState.PER_decode(SubscriberInfo_eps__SubscriberState_descr_, ext_add_buf, p_options);
}
else {
field_eps__SubscriberState = OMIT_VALUE;
}
if (ext_presences[10]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_locationInformationEPS.PER_decode(SubscriberInfo_locationInformationEPS_descr_, ext_add_buf, p_options);
}
else {
field_locationInformationEPS = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 11) for (int i = 11; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct SubscriberInfo_template::single_value_struct {
LocationInformation_template field_locationInformation;
SubscriberState_template field_subscriberState;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
LocationInformationGPRS_template field_locationInformationGPRS;
PS__SubscriberState_template field_ps__SubscriberState;
OCTETSTRING_template field_imei;
OCTETSTRING_template field_ms__Classmark2;
GPRSMSClass_template field_gprs__MS__Class;
MNPInfoRes_template field_mnpInfoRes;
IMS__VoiceOverPS__SessionsInd_template field_imsVoiceOverPS__SessionsIndication;
OCTETSTRING_template field_lastUE__ActivityTime;
Used__RAT__Type_template field_lastRAT__Type;
PS__SubscriberState_template field_eps__SubscriberState;
LocationInformationEPS_template field_locationInformationEPS;
};

void SubscriberInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_locationInformation = ANY_OR_OMIT;
single_value->field_subscriberState = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_locationInformationGPRS = ANY_OR_OMIT;
single_value->field_ps__SubscriberState = ANY_OR_OMIT;
single_value->field_imei = ANY_OR_OMIT;
single_value->field_ms__Classmark2 = ANY_OR_OMIT;
single_value->field_gprs__MS__Class = ANY_OR_OMIT;
single_value->field_mnpInfoRes = ANY_OR_OMIT;
single_value->field_imsVoiceOverPS__SessionsIndication = ANY_OR_OMIT;
single_value->field_lastUE__ActivityTime = ANY_OR_OMIT;
single_value->field_lastRAT__Type = ANY_OR_OMIT;
single_value->field_eps__SubscriberState = ANY_OR_OMIT;
single_value->field_locationInformationEPS = ANY_OR_OMIT;
}
}
}

void SubscriberInfo_template::copy_value(const SubscriberInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.locationInformation().is_bound()) {
  if (other_value.locationInformation().ispresent()) single_value->field_locationInformation = other_value.locationInformation()();
  else single_value->field_locationInformation = OMIT_VALUE;
} else {
  single_value->field_locationInformation.clean_up();
}
if (other_value.subscriberState().is_bound()) {
  if (other_value.subscriberState().ispresent()) single_value->field_subscriberState = other_value.subscriberState()();
  else single_value->field_subscriberState = OMIT_VALUE;
} else {
  single_value->field_subscriberState.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.locationInformationGPRS().is_bound()) {
  if (other_value.locationInformationGPRS().ispresent()) single_value->field_locationInformationGPRS = other_value.locationInformationGPRS()();
  else single_value->field_locationInformationGPRS = OMIT_VALUE;
} else {
  single_value->field_locationInformationGPRS.clean_up();
}
if (other_value.ps__SubscriberState().is_bound()) {
  if (other_value.ps__SubscriberState().ispresent()) single_value->field_ps__SubscriberState = other_value.ps__SubscriberState()();
  else single_value->field_ps__SubscriberState = OMIT_VALUE;
} else {
  single_value->field_ps__SubscriberState.clean_up();
}
if (other_value.imei().is_bound()) {
  if (other_value.imei().ispresent()) single_value->field_imei = other_value.imei()();
  else single_value->field_imei = OMIT_VALUE;
} else {
  single_value->field_imei.clean_up();
}
if (other_value.ms__Classmark2().is_bound()) {
  if (other_value.ms__Classmark2().ispresent()) single_value->field_ms__Classmark2 = other_value.ms__Classmark2()();
  else single_value->field_ms__Classmark2 = OMIT_VALUE;
} else {
  single_value->field_ms__Classmark2.clean_up();
}
if (other_value.gprs__MS__Class().is_bound()) {
  if (other_value.gprs__MS__Class().ispresent()) single_value->field_gprs__MS__Class = other_value.gprs__MS__Class()();
  else single_value->field_gprs__MS__Class = OMIT_VALUE;
} else {
  single_value->field_gprs__MS__Class.clean_up();
}
if (other_value.mnpInfoRes().is_bound()) {
  if (other_value.mnpInfoRes().ispresent()) single_value->field_mnpInfoRes = other_value.mnpInfoRes()();
  else single_value->field_mnpInfoRes = OMIT_VALUE;
} else {
  single_value->field_mnpInfoRes.clean_up();
}
if (other_value.imsVoiceOverPS__SessionsIndication().is_bound()) {
  if (other_value.imsVoiceOverPS__SessionsIndication().ispresent()) single_value->field_imsVoiceOverPS__SessionsIndication = other_value.imsVoiceOverPS__SessionsIndication()();
  else single_value->field_imsVoiceOverPS__SessionsIndication = OMIT_VALUE;
} else {
  single_value->field_imsVoiceOverPS__SessionsIndication.clean_up();
}
if (other_value.lastUE__ActivityTime().is_bound()) {
  if (other_value.lastUE__ActivityTime().ispresent()) single_value->field_lastUE__ActivityTime = other_value.lastUE__ActivityTime()();
  else single_value->field_lastUE__ActivityTime = OMIT_VALUE;
} else {
  single_value->field_lastUE__ActivityTime.clean_up();
}
if (other_value.lastRAT__Type().is_bound()) {
  if (other_value.lastRAT__Type().ispresent()) single_value->field_lastRAT__Type = other_value.lastRAT__Type()();
  else single_value->field_lastRAT__Type = OMIT_VALUE;
} else {
  single_value->field_lastRAT__Type.clean_up();
}
if (other_value.eps__SubscriberState().is_bound()) {
  if (other_value.eps__SubscriberState().ispresent()) single_value->field_eps__SubscriberState = other_value.eps__SubscriberState()();
  else single_value->field_eps__SubscriberState = OMIT_VALUE;
} else {
  single_value->field_eps__SubscriberState.clean_up();
}
if (other_value.locationInformationEPS().is_bound()) {
  if (other_value.locationInformationEPS().ispresent()) single_value->field_locationInformationEPS = other_value.locationInformationEPS()();
  else single_value->field_locationInformationEPS = OMIT_VALUE;
} else {
  single_value->field_locationInformationEPS.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SubscriberInfo_template::copy_template(const SubscriberInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.locationInformation().get_selection()) {
single_value->field_locationInformation = other_value.locationInformation();
} else {
single_value->field_locationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subscriberState().get_selection()) {
single_value->field_subscriberState = other_value.subscriberState();
} else {
single_value->field_subscriberState.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locationInformationGPRS().get_selection()) {
single_value->field_locationInformationGPRS = other_value.locationInformationGPRS();
} else {
single_value->field_locationInformationGPRS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ps__SubscriberState().get_selection()) {
single_value->field_ps__SubscriberState = other_value.ps__SubscriberState();
} else {
single_value->field_ps__SubscriberState.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.imei().get_selection()) {
single_value->field_imei = other_value.imei();
} else {
single_value->field_imei.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__Classmark2().get_selection()) {
single_value->field_ms__Classmark2 = other_value.ms__Classmark2();
} else {
single_value->field_ms__Classmark2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gprs__MS__Class().get_selection()) {
single_value->field_gprs__MS__Class = other_value.gprs__MS__Class();
} else {
single_value->field_gprs__MS__Class.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mnpInfoRes().get_selection()) {
single_value->field_mnpInfoRes = other_value.mnpInfoRes();
} else {
single_value->field_mnpInfoRes.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.imsVoiceOverPS__SessionsIndication().get_selection()) {
single_value->field_imsVoiceOverPS__SessionsIndication = other_value.imsVoiceOverPS__SessionsIndication();
} else {
single_value->field_imsVoiceOverPS__SessionsIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lastUE__ActivityTime().get_selection()) {
single_value->field_lastUE__ActivityTime = other_value.lastUE__ActivityTime();
} else {
single_value->field_lastUE__ActivityTime.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lastRAT__Type().get_selection()) {
single_value->field_lastRAT__Type = other_value.lastRAT__Type();
} else {
single_value->field_lastRAT__Type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eps__SubscriberState().get_selection()) {
single_value->field_eps__SubscriberState = other_value.eps__SubscriberState();
} else {
single_value->field_eps__SubscriberState.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locationInformationEPS().get_selection()) {
single_value->field_locationInformationEPS = other_value.locationInformationEPS();
} else {
single_value->field_locationInformationEPS.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SubscriberInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SubscriberInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new SubscriberInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.SubscriberInfo.");
break;
}
set_selection(other_value);
}

SubscriberInfo_template::SubscriberInfo_template()
{
}

SubscriberInfo_template::SubscriberInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SubscriberInfo_template::SubscriberInfo_template(const SubscriberInfo& other_value)
{
copy_value(other_value);
}

SubscriberInfo_template::SubscriberInfo_template(const OPTIONAL<SubscriberInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SubscriberInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.SubscriberInfo from an unbound optional field.");
}
}

SubscriberInfo_template::SubscriberInfo_template(SubscriberInfo_template* p_precondition, SubscriberInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SubscriberInfo_template::SubscriberInfo_template(Dynamic_Match_Interface<SubscriberInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SubscriberInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SubscriberInfo_template::SubscriberInfo_template(const SubscriberInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SubscriberInfo_template::~SubscriberInfo_template()
{
clean_up();
}

SubscriberInfo_template& SubscriberInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SubscriberInfo_template& SubscriberInfo_template::operator=(const SubscriberInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SubscriberInfo_template& SubscriberInfo_template::operator=(const OPTIONAL<SubscriberInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SubscriberInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.SubscriberInfo.");
}
return *this;
}

SubscriberInfo_template& SubscriberInfo_template::operator=(const SubscriberInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SubscriberInfo_template::match(const SubscriberInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.locationInformation().is_bound()) return FALSE;
if((other_value.locationInformation().ispresent() ? !single_value->field_locationInformation.match((const LocationInformation&)other_value.locationInformation(), legacy) : !single_value->field_locationInformation.match_omit(legacy)))return FALSE;
if(!other_value.subscriberState().is_bound()) return FALSE;
if((other_value.subscriberState().ispresent() ? !single_value->field_subscriberState.match((const SubscriberState&)other_value.subscriberState(), legacy) : !single_value->field_subscriberState.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.locationInformationGPRS().is_bound()) return FALSE;
if((other_value.locationInformationGPRS().ispresent() ? !single_value->field_locationInformationGPRS.match((const LocationInformationGPRS&)other_value.locationInformationGPRS(), legacy) : !single_value->field_locationInformationGPRS.match_omit(legacy)))return FALSE;
if(!other_value.ps__SubscriberState().is_bound()) return FALSE;
if((other_value.ps__SubscriberState().ispresent() ? !single_value->field_ps__SubscriberState.match((const PS__SubscriberState&)other_value.ps__SubscriberState(), legacy) : !single_value->field_ps__SubscriberState.match_omit(legacy)))return FALSE;
if(!other_value.imei().is_bound()) return FALSE;
if((other_value.imei().ispresent() ? !single_value->field_imei.match((const OCTETSTRING&)other_value.imei(), legacy) : !single_value->field_imei.match_omit(legacy)))return FALSE;
if(!other_value.ms__Classmark2().is_bound()) return FALSE;
if((other_value.ms__Classmark2().ispresent() ? !single_value->field_ms__Classmark2.match((const OCTETSTRING&)other_value.ms__Classmark2(), legacy) : !single_value->field_ms__Classmark2.match_omit(legacy)))return FALSE;
if(!other_value.gprs__MS__Class().is_bound()) return FALSE;
if((other_value.gprs__MS__Class().ispresent() ? !single_value->field_gprs__MS__Class.match((const GPRSMSClass&)other_value.gprs__MS__Class(), legacy) : !single_value->field_gprs__MS__Class.match_omit(legacy)))return FALSE;
if(!other_value.mnpInfoRes().is_bound()) return FALSE;
if((other_value.mnpInfoRes().ispresent() ? !single_value->field_mnpInfoRes.match((const MNPInfoRes&)other_value.mnpInfoRes(), legacy) : !single_value->field_mnpInfoRes.match_omit(legacy)))return FALSE;
if(!other_value.imsVoiceOverPS__SessionsIndication().is_bound()) return FALSE;
if((other_value.imsVoiceOverPS__SessionsIndication().ispresent() ? !single_value->field_imsVoiceOverPS__SessionsIndication.match((const IMS__VoiceOverPS__SessionsInd&)other_value.imsVoiceOverPS__SessionsIndication(), legacy) : !single_value->field_imsVoiceOverPS__SessionsIndication.match_omit(legacy)))return FALSE;
if(!other_value.lastUE__ActivityTime().is_bound()) return FALSE;
if((other_value.lastUE__ActivityTime().ispresent() ? !single_value->field_lastUE__ActivityTime.match((const OCTETSTRING&)other_value.lastUE__ActivityTime(), legacy) : !single_value->field_lastUE__ActivityTime.match_omit(legacy)))return FALSE;
if(!other_value.lastRAT__Type().is_bound()) return FALSE;
if((other_value.lastRAT__Type().ispresent() ? !single_value->field_lastRAT__Type.match((const Used__RAT__Type&)other_value.lastRAT__Type(), legacy) : !single_value->field_lastRAT__Type.match_omit(legacy)))return FALSE;
if(!other_value.eps__SubscriberState().is_bound()) return FALSE;
if((other_value.eps__SubscriberState().ispresent() ? !single_value->field_eps__SubscriberState.match((const PS__SubscriberState&)other_value.eps__SubscriberState(), legacy) : !single_value->field_eps__SubscriberState.match_omit(legacy)))return FALSE;
if(!other_value.locationInformationEPS().is_bound()) return FALSE;
if((other_value.locationInformationEPS().ispresent() ? !single_value->field_locationInformationEPS.match((const LocationInformationEPS&)other_value.locationInformationEPS(), legacy) : !single_value->field_locationInformationEPS.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.SubscriberInfo.");
}
return FALSE;
}

boolean SubscriberInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_locationInformation.is_omit() || single_value->field_locationInformation.is_bound())
 || (single_value->field_subscriberState.is_omit() || single_value->field_subscriberState.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_locationInformationGPRS.is_omit() || single_value->field_locationInformationGPRS.is_bound())
 || (single_value->field_ps__SubscriberState.is_omit() || single_value->field_ps__SubscriberState.is_bound())
 || (single_value->field_imei.is_omit() || single_value->field_imei.is_bound())
 || (single_value->field_ms__Classmark2.is_omit() || single_value->field_ms__Classmark2.is_bound())
 || (single_value->field_gprs__MS__Class.is_omit() || single_value->field_gprs__MS__Class.is_bound())
 || (single_value->field_mnpInfoRes.is_omit() || single_value->field_mnpInfoRes.is_bound())
 || (single_value->field_imsVoiceOverPS__SessionsIndication.is_omit() || single_value->field_imsVoiceOverPS__SessionsIndication.is_bound())
 || (single_value->field_lastUE__ActivityTime.is_omit() || single_value->field_lastUE__ActivityTime.is_bound())
 || (single_value->field_lastRAT__Type.is_omit() || single_value->field_lastRAT__Type.is_bound())
 || (single_value->field_eps__SubscriberState.is_omit() || single_value->field_eps__SubscriberState.is_bound())
 || (single_value->field_locationInformationEPS.is_omit() || single_value->field_locationInformationEPS.is_bound());
}

boolean SubscriberInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_locationInformation.is_omit() || single_value->field_locationInformation.is_value())
 && (single_value->field_subscriberState.is_omit() || single_value->field_subscriberState.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_locationInformationGPRS.is_omit() || single_value->field_locationInformationGPRS.is_value())
 && (single_value->field_ps__SubscriberState.is_omit() || single_value->field_ps__SubscriberState.is_value())
 && (single_value->field_imei.is_omit() || single_value->field_imei.is_value())
 && (single_value->field_ms__Classmark2.is_omit() || single_value->field_ms__Classmark2.is_value())
 && (single_value->field_gprs__MS__Class.is_omit() || single_value->field_gprs__MS__Class.is_value())
 && (single_value->field_mnpInfoRes.is_omit() || single_value->field_mnpInfoRes.is_value())
 && (single_value->field_imsVoiceOverPS__SessionsIndication.is_omit() || single_value->field_imsVoiceOverPS__SessionsIndication.is_value())
 && (single_value->field_lastUE__ActivityTime.is_omit() || single_value->field_lastUE__ActivityTime.is_value())
 && (single_value->field_lastRAT__Type.is_omit() || single_value->field_lastRAT__Type.is_value())
 && (single_value->field_eps__SubscriberState.is_omit() || single_value->field_eps__SubscriberState.is_value())
 && (single_value->field_locationInformationEPS.is_omit() || single_value->field_locationInformationEPS.is_value());
}

void SubscriberInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SubscriberInfo SubscriberInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
SubscriberInfo ret_val;
if (single_value->field_locationInformation.is_omit()) ret_val.locationInformation() = OMIT_VALUE;
else if (single_value->field_locationInformation.is_bound()) {
ret_val.locationInformation() = single_value->field_locationInformation.valueof();
}
if (single_value->field_subscriberState.is_omit()) ret_val.subscriberState() = OMIT_VALUE;
else if (single_value->field_subscriberState.is_bound()) {
ret_val.subscriberState() = single_value->field_subscriberState.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_locationInformationGPRS.is_omit()) ret_val.locationInformationGPRS() = OMIT_VALUE;
else if (single_value->field_locationInformationGPRS.is_bound()) {
ret_val.locationInformationGPRS() = single_value->field_locationInformationGPRS.valueof();
}
if (single_value->field_ps__SubscriberState.is_omit()) ret_val.ps__SubscriberState() = OMIT_VALUE;
else if (single_value->field_ps__SubscriberState.is_bound()) {
ret_val.ps__SubscriberState() = single_value->field_ps__SubscriberState.valueof();
}
if (single_value->field_imei.is_omit()) ret_val.imei() = OMIT_VALUE;
else if (single_value->field_imei.is_bound()) {
ret_val.imei() = single_value->field_imei.valueof();
}
if (single_value->field_ms__Classmark2.is_omit()) ret_val.ms__Classmark2() = OMIT_VALUE;
else if (single_value->field_ms__Classmark2.is_bound()) {
ret_val.ms__Classmark2() = single_value->field_ms__Classmark2.valueof();
}
if (single_value->field_gprs__MS__Class.is_omit()) ret_val.gprs__MS__Class() = OMIT_VALUE;
else if (single_value->field_gprs__MS__Class.is_bound()) {
ret_val.gprs__MS__Class() = single_value->field_gprs__MS__Class.valueof();
}
if (single_value->field_mnpInfoRes.is_omit()) ret_val.mnpInfoRes() = OMIT_VALUE;
else if (single_value->field_mnpInfoRes.is_bound()) {
ret_val.mnpInfoRes() = single_value->field_mnpInfoRes.valueof();
}
if (single_value->field_imsVoiceOverPS__SessionsIndication.is_omit()) ret_val.imsVoiceOverPS__SessionsIndication() = OMIT_VALUE;
else if (single_value->field_imsVoiceOverPS__SessionsIndication.is_bound()) {
ret_val.imsVoiceOverPS__SessionsIndication() = single_value->field_imsVoiceOverPS__SessionsIndication.valueof();
}
if (single_value->field_lastUE__ActivityTime.is_omit()) ret_val.lastUE__ActivityTime() = OMIT_VALUE;
else if (single_value->field_lastUE__ActivityTime.is_bound()) {
ret_val.lastUE__ActivityTime() = single_value->field_lastUE__ActivityTime.valueof();
}
if (single_value->field_lastRAT__Type.is_omit()) ret_val.lastRAT__Type() = OMIT_VALUE;
else if (single_value->field_lastRAT__Type.is_bound()) {
ret_val.lastRAT__Type() = single_value->field_lastRAT__Type.valueof();
}
if (single_value->field_eps__SubscriberState.is_omit()) ret_val.eps__SubscriberState() = OMIT_VALUE;
else if (single_value->field_eps__SubscriberState.is_bound()) {
ret_val.eps__SubscriberState() = single_value->field_eps__SubscriberState.valueof();
}
if (single_value->field_locationInformationEPS.is_omit()) ret_val.locationInformationEPS() = OMIT_VALUE;
else if (single_value->field_locationInformationEPS.is_bound()) {
ret_val.locationInformationEPS() = single_value->field_locationInformationEPS.valueof();
}
return ret_val;
}

void SubscriberInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.SubscriberInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SubscriberInfo_template[list_length];
}

SubscriberInfo_template& SubscriberInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.SubscriberInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.SubscriberInfo.");
return value_list.list_value[list_index];
}

LocationInformation_template& SubscriberInfo_template::locationInformation()
{
set_specific();
return single_value->field_locationInformation;
}

const LocationInformation_template& SubscriberInfo_template::locationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformation of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_locationInformation;
}

SubscriberState_template& SubscriberInfo_template::subscriberState()
{
set_specific();
return single_value->field_subscriberState;
}

const SubscriberState_template& SubscriberInfo_template::subscriberState() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subscriberState of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_subscriberState;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& SubscriberInfo_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& SubscriberInfo_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_extensionContainer;
}

LocationInformationGPRS_template& SubscriberInfo_template::locationInformationGPRS()
{
set_specific();
return single_value->field_locationInformationGPRS;
}

const LocationInformationGPRS_template& SubscriberInfo_template::locationInformationGPRS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformationGPRS of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_locationInformationGPRS;
}

PS__SubscriberState_template& SubscriberInfo_template::ps__SubscriberState()
{
set_specific();
return single_value->field_ps__SubscriberState;
}

const PS__SubscriberState_template& SubscriberInfo_template::ps__SubscriberState() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ps_SubscriberState of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_ps__SubscriberState;
}

OCTETSTRING_template& SubscriberInfo_template::imei()
{
set_specific();
return single_value->field_imei;
}

const OCTETSTRING_template& SubscriberInfo_template::imei() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imei of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_imei;
}

OCTETSTRING_template& SubscriberInfo_template::ms__Classmark2()
{
set_specific();
return single_value->field_ms__Classmark2;
}

const OCTETSTRING_template& SubscriberInfo_template::ms__Classmark2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_Classmark2 of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_ms__Classmark2;
}

GPRSMSClass_template& SubscriberInfo_template::gprs__MS__Class()
{
set_specific();
return single_value->field_gprs__MS__Class;
}

const GPRSMSClass_template& SubscriberInfo_template::gprs__MS__Class() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gprs_MS_Class of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_gprs__MS__Class;
}

MNPInfoRes_template& SubscriberInfo_template::mnpInfoRes()
{
set_specific();
return single_value->field_mnpInfoRes;
}

const MNPInfoRes_template& SubscriberInfo_template::mnpInfoRes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mnpInfoRes of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_mnpInfoRes;
}

IMS__VoiceOverPS__SessionsInd_template& SubscriberInfo_template::imsVoiceOverPS__SessionsIndication()
{
set_specific();
return single_value->field_imsVoiceOverPS__SessionsIndication;
}

const IMS__VoiceOverPS__SessionsInd_template& SubscriberInfo_template::imsVoiceOverPS__SessionsIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsVoiceOverPS_SessionsIndication of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_imsVoiceOverPS__SessionsIndication;
}

OCTETSTRING_template& SubscriberInfo_template::lastUE__ActivityTime()
{
set_specific();
return single_value->field_lastUE__ActivityTime;
}

const OCTETSTRING_template& SubscriberInfo_template::lastUE__ActivityTime() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lastUE_ActivityTime of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_lastUE__ActivityTime;
}

Used__RAT__Type_template& SubscriberInfo_template::lastRAT__Type()
{
set_specific();
return single_value->field_lastRAT__Type;
}

const Used__RAT__Type_template& SubscriberInfo_template::lastRAT__Type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lastRAT_Type of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_lastRAT__Type;
}

PS__SubscriberState_template& SubscriberInfo_template::eps__SubscriberState()
{
set_specific();
return single_value->field_eps__SubscriberState;
}

const PS__SubscriberState_template& SubscriberInfo_template::eps__SubscriberState() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eps_SubscriberState of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_eps__SubscriberState;
}

LocationInformationEPS_template& SubscriberInfo_template::locationInformationEPS()
{
set_specific();
return single_value->field_locationInformationEPS;
}

const LocationInformationEPS_template& SubscriberInfo_template::locationInformationEPS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformationEPS of a non-specific template of type @MAP-MS-DataTypes.SubscriberInfo.");
return single_value->field_locationInformationEPS;
}

int SubscriberInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_locationInformation.is_present()) ret_val++;
      if (single_value->field_subscriberState.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_locationInformationGPRS.is_present()) ret_val++;
      if (single_value->field_ps__SubscriberState.is_present()) ret_val++;
      if (single_value->field_imei.is_present()) ret_val++;
      if (single_value->field_ms__Classmark2.is_present()) ret_val++;
      if (single_value->field_gprs__MS__Class.is_present()) ret_val++;
      if (single_value->field_mnpInfoRes.is_present()) ret_val++;
      if (single_value->field_imsVoiceOverPS__SessionsIndication.is_present()) ret_val++;
      if (single_value->field_lastUE__ActivityTime.is_present()) ret_val++;
      if (single_value->field_lastRAT__Type.is_present()) ret_val++;
      if (single_value->field_eps__SubscriberState.is_present()) ret_val++;
      if (single_value->field_locationInformationEPS.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SubscriberInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.SubscriberInfo.");
  }
  return 0;
}

void SubscriberInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ locationInformation := ");
single_value->field_locationInformation.log();
TTCN_Logger::log_event_str(", subscriberState := ");
single_value->field_subscriberState.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", locationInformationGPRS := ");
single_value->field_locationInformationGPRS.log();
TTCN_Logger::log_event_str(", ps_SubscriberState := ");
single_value->field_ps__SubscriberState.log();
TTCN_Logger::log_event_str(", imei := ");
single_value->field_imei.log();
TTCN_Logger::log_event_str(", ms_Classmark2 := ");
single_value->field_ms__Classmark2.log();
TTCN_Logger::log_event_str(", gprs_MS_Class := ");
single_value->field_gprs__MS__Class.log();
TTCN_Logger::log_event_str(", mnpInfoRes := ");
single_value->field_mnpInfoRes.log();
TTCN_Logger::log_event_str(", imsVoiceOverPS_SessionsIndication := ");
single_value->field_imsVoiceOverPS__SessionsIndication.log();
TTCN_Logger::log_event_str(", lastUE_ActivityTime := ");
single_value->field_lastUE__ActivityTime.log();
TTCN_Logger::log_event_str(", lastRAT_Type := ");
single_value->field_lastRAT__Type.log();
TTCN_Logger::log_event_str(", eps_SubscriberState := ");
single_value->field_eps__SubscriberState.log();
TTCN_Logger::log_event_str(", locationInformationEPS := ");
single_value->field_locationInformationEPS.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SubscriberInfo_template::log_match(const SubscriberInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.locationInformation().ispresent()){
if(!single_value->field_locationInformation.match(match_value.locationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformation");
single_value->field_locationInformation.log_match(match_value.locationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subscriberState().ispresent()){
if(!single_value->field_subscriberState.match(match_value.subscriberState(), legacy)){
TTCN_Logger::log_logmatch_info(".subscriberState");
single_value->field_subscriberState.log_match(match_value.subscriberState(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subscriberState.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subscriberState := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subscriberState.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.locationInformationGPRS().ispresent()){
if(!single_value->field_locationInformationGPRS.match(match_value.locationInformationGPRS(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformationGPRS");
single_value->field_locationInformationGPRS.log_match(match_value.locationInformationGPRS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformationGPRS.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformationGPRS := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformationGPRS.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ps__SubscriberState().ispresent()){
if(!single_value->field_ps__SubscriberState.match(match_value.ps__SubscriberState(), legacy)){
TTCN_Logger::log_logmatch_info(".ps_SubscriberState");
single_value->field_ps__SubscriberState.log_match(match_value.ps__SubscriberState(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ps__SubscriberState.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ps_SubscriberState := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ps__SubscriberState.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.imei().ispresent()){
if(!single_value->field_imei.match(match_value.imei(), legacy)){
TTCN_Logger::log_logmatch_info(".imei");
single_value->field_imei.log_match(match_value.imei(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imei.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imei := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imei.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ms__Classmark2().ispresent()){
if(!single_value->field_ms__Classmark2.match(match_value.ms__Classmark2(), legacy)){
TTCN_Logger::log_logmatch_info(".ms_Classmark2");
single_value->field_ms__Classmark2.log_match(match_value.ms__Classmark2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ms__Classmark2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ms_Classmark2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ms__Classmark2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gprs__MS__Class().ispresent()){
if(!single_value->field_gprs__MS__Class.match(match_value.gprs__MS__Class(), legacy)){
TTCN_Logger::log_logmatch_info(".gprs_MS_Class");
single_value->field_gprs__MS__Class.log_match(match_value.gprs__MS__Class(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gprs__MS__Class.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gprs_MS_Class := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gprs__MS__Class.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mnpInfoRes().ispresent()){
if(!single_value->field_mnpInfoRes.match(match_value.mnpInfoRes(), legacy)){
TTCN_Logger::log_logmatch_info(".mnpInfoRes");
single_value->field_mnpInfoRes.log_match(match_value.mnpInfoRes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mnpInfoRes.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mnpInfoRes := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mnpInfoRes.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.imsVoiceOverPS__SessionsIndication().ispresent()){
if(!single_value->field_imsVoiceOverPS__SessionsIndication.match(match_value.imsVoiceOverPS__SessionsIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".imsVoiceOverPS_SessionsIndication");
single_value->field_imsVoiceOverPS__SessionsIndication.log_match(match_value.imsVoiceOverPS__SessionsIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imsVoiceOverPS__SessionsIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imsVoiceOverPS_SessionsIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imsVoiceOverPS__SessionsIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.lastUE__ActivityTime().ispresent()){
if(!single_value->field_lastUE__ActivityTime.match(match_value.lastUE__ActivityTime(), legacy)){
TTCN_Logger::log_logmatch_info(".lastUE_ActivityTime");
single_value->field_lastUE__ActivityTime.log_match(match_value.lastUE__ActivityTime(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lastUE__ActivityTime.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lastUE_ActivityTime := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lastUE__ActivityTime.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.lastRAT__Type().ispresent()){
if(!single_value->field_lastRAT__Type.match(match_value.lastRAT__Type(), legacy)){
TTCN_Logger::log_logmatch_info(".lastRAT_Type");
single_value->field_lastRAT__Type.log_match(match_value.lastRAT__Type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lastRAT__Type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lastRAT_Type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lastRAT__Type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eps__SubscriberState().ispresent()){
if(!single_value->field_eps__SubscriberState.match(match_value.eps__SubscriberState(), legacy)){
TTCN_Logger::log_logmatch_info(".eps_SubscriberState");
single_value->field_eps__SubscriberState.log_match(match_value.eps__SubscriberState(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eps__SubscriberState.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eps_SubscriberState := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eps__SubscriberState.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.locationInformationEPS().ispresent()){
if(!single_value->field_locationInformationEPS.match(match_value.locationInformationEPS(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformationEPS");
single_value->field_locationInformationEPS.log_match(match_value.locationInformationEPS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformationEPS.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformationEPS := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformationEPS.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ locationInformation := ");
if (match_value.locationInformation().ispresent()) {
single_value->field_locationInformation.log_match(match_value.locationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformation.log();
if (single_value->field_locationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subscriberState := ");
if (match_value.subscriberState().ispresent()) {
single_value->field_subscriberState.log_match(match_value.subscriberState(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subscriberState.log();
if (single_value->field_subscriberState.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", locationInformationGPRS := ");
if (match_value.locationInformationGPRS().ispresent()) {
single_value->field_locationInformationGPRS.log_match(match_value.locationInformationGPRS(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformationGPRS.log();
if (single_value->field_locationInformationGPRS.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ps_SubscriberState := ");
if (match_value.ps__SubscriberState().ispresent()) {
single_value->field_ps__SubscriberState.log_match(match_value.ps__SubscriberState(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ps__SubscriberState.log();
if (single_value->field_ps__SubscriberState.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", imei := ");
if (match_value.imei().ispresent()) {
single_value->field_imei.log_match(match_value.imei(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imei.log();
if (single_value->field_imei.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ms_Classmark2 := ");
if (match_value.ms__Classmark2().ispresent()) {
single_value->field_ms__Classmark2.log_match(match_value.ms__Classmark2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ms__Classmark2.log();
if (single_value->field_ms__Classmark2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gprs_MS_Class := ");
if (match_value.gprs__MS__Class().ispresent()) {
single_value->field_gprs__MS__Class.log_match(match_value.gprs__MS__Class(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gprs__MS__Class.log();
if (single_value->field_gprs__MS__Class.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mnpInfoRes := ");
if (match_value.mnpInfoRes().ispresent()) {
single_value->field_mnpInfoRes.log_match(match_value.mnpInfoRes(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mnpInfoRes.log();
if (single_value->field_mnpInfoRes.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", imsVoiceOverPS_SessionsIndication := ");
if (match_value.imsVoiceOverPS__SessionsIndication().ispresent()) {
single_value->field_imsVoiceOverPS__SessionsIndication.log_match(match_value.imsVoiceOverPS__SessionsIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imsVoiceOverPS__SessionsIndication.log();
if (single_value->field_imsVoiceOverPS__SessionsIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", lastUE_ActivityTime := ");
if (match_value.lastUE__ActivityTime().ispresent()) {
single_value->field_lastUE__ActivityTime.log_match(match_value.lastUE__ActivityTime(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lastUE__ActivityTime.log();
if (single_value->field_lastUE__ActivityTime.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", lastRAT_Type := ");
if (match_value.lastRAT__Type().ispresent()) {
single_value->field_lastRAT__Type.log_match(match_value.lastRAT__Type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lastRAT__Type.log();
if (single_value->field_lastRAT__Type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eps_SubscriberState := ");
if (match_value.eps__SubscriberState().ispresent()) {
single_value->field_eps__SubscriberState.log_match(match_value.eps__SubscriberState(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eps__SubscriberState.log();
if (single_value->field_eps__SubscriberState.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", locationInformationEPS := ");
if (match_value.locationInformationEPS().ispresent()) {
single_value->field_locationInformationEPS.log_match(match_value.locationInformationEPS(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformationEPS.log();
if (single_value->field_locationInformationEPS.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SubscriberInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!locationInformation().is_bound()) locationInformation() = OMIT_VALUE;
else locationInformation().set_implicit_omit();
if (!subscriberState().is_bound()) subscriberState() = OMIT_VALUE;
else subscriberState().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!locationInformationGPRS().is_bound()) locationInformationGPRS() = OMIT_VALUE;
else locationInformationGPRS().set_implicit_omit();
if (!ps__SubscriberState().is_bound()) ps__SubscriberState() = OMIT_VALUE;
else ps__SubscriberState().set_implicit_omit();
if (!imei().is_bound()) imei() = OMIT_VALUE;
else imei().set_implicit_omit();
if (!ms__Classmark2().is_bound()) ms__Classmark2() = OMIT_VALUE;
else ms__Classmark2().set_implicit_omit();
if (!gprs__MS__Class().is_bound()) gprs__MS__Class() = OMIT_VALUE;
else gprs__MS__Class().set_implicit_omit();
if (!mnpInfoRes().is_bound()) mnpInfoRes() = OMIT_VALUE;
else mnpInfoRes().set_implicit_omit();
if (!imsVoiceOverPS__SessionsIndication().is_bound()) imsVoiceOverPS__SessionsIndication() = OMIT_VALUE;
else imsVoiceOverPS__SessionsIndication().set_implicit_omit();
if (!lastUE__ActivityTime().is_bound()) lastUE__ActivityTime() = OMIT_VALUE;
else lastUE__ActivityTime().set_implicit_omit();
if (!lastRAT__Type().is_bound()) lastRAT__Type() = OMIT_VALUE;
else lastRAT__Type().set_implicit_omit();
if (!eps__SubscriberState().is_bound()) eps__SubscriberState() = OMIT_VALUE;
else eps__SubscriberState().set_implicit_omit();
if (!locationInformationEPS().is_bound()) locationInformationEPS() = OMIT_VALUE;
else locationInformationEPS().set_implicit_omit();
}

void SubscriberInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_locationInformation.encode_text(text_buf);
single_value->field_subscriberState.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_locationInformationGPRS.encode_text(text_buf);
single_value->field_ps__SubscriberState.encode_text(text_buf);
single_value->field_imei.encode_text(text_buf);
single_value->field_ms__Classmark2.encode_text(text_buf);
single_value->field_gprs__MS__Class.encode_text(text_buf);
single_value->field_mnpInfoRes.encode_text(text_buf);
single_value->field_imsVoiceOverPS__SessionsIndication.encode_text(text_buf);
single_value->field_lastUE__ActivityTime.encode_text(text_buf);
single_value->field_lastRAT__Type.encode_text(text_buf);
single_value->field_eps__SubscriberState.encode_text(text_buf);
single_value->field_locationInformationEPS.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.SubscriberInfo.");
}
}

void SubscriberInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_locationInformation.decode_text(text_buf);
single_value->field_subscriberState.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_locationInformationGPRS.decode_text(text_buf);
single_value->field_ps__SubscriberState.decode_text(text_buf);
single_value->field_imei.decode_text(text_buf);
single_value->field_ms__Classmark2.decode_text(text_buf);
single_value->field_gprs__MS__Class.decode_text(text_buf);
single_value->field_mnpInfoRes.decode_text(text_buf);
single_value->field_imsVoiceOverPS__SessionsIndication.decode_text(text_buf);
single_value->field_lastUE__ActivityTime.decode_text(text_buf);
single_value->field_lastRAT__Type.decode_text(text_buf);
single_value->field_eps__SubscriberState.decode_text(text_buf);
single_value->field_locationInformationEPS.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SubscriberInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.SubscriberInfo.");
}
}

void SubscriberInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SubscriberInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (14<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.SubscriberInfo has 14 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) locationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) subscriberState().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locationInformationGPRS().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ps__SubscriberState().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) imei().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ms__Classmark2().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) gprs__MS__Class().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) mnpInfoRes().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) imsVoiceOverPS__SessionsIndication().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) lastUE__ActivityTime().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) lastRAT__Type().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) eps__SubscriberState().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS().set_param(*param.get_elem(13));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationGPRS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationGPRS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ps_SubscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ps__SubscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imei")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imei().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_Classmark2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__Classmark2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprs_MS_Class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprs__MS__Class().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mnpInfoRes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mnpInfoRes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsVoiceOverPS_SessionsIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsVoiceOverPS__SessionsIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lastUE_ActivityTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lastUE__ActivityTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lastRAT_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lastRAT__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eps_SubscriberState")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eps__SubscriberState().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.SubscriberInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SubscriberInfo_template* precondition = new SubscriberInfo_template;
    precondition->set_param(*param.get_elem(0));
    SubscriberInfo_template* implied_template = new SubscriberInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SubscriberInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.SubscriberInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void SubscriberInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_locationInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_subscriberState.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_locationInformationGPRS.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_ps__SubscriberState.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_imei.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_ms__Classmark2.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_gprs__MS__Class.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_mnpInfoRes.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_imsVoiceOverPS__SessionsIndication.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_lastUE__ActivityTime.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_lastRAT__Type.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_eps__SubscriberState.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
single_value->field_locationInformationEPS.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.SubscriberInfo");
}

boolean SubscriberInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SubscriberInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LocationInformation::LocationInformation()
{
}

LocationInformation::LocationInformation(const OPTIONAL< INTEGER >& par_ageOfLocationInformation,
    const OPTIONAL< OCTETSTRING >& par_geographicalInformation,
    const OPTIONAL< OCTETSTRING >& par_vlr__number,
    const OPTIONAL< OCTETSTRING >& par_locationNumber,
    const OPTIONAL< MAP__CommonDataTypes::CellGlobalIdOrServiceAreaIdOrLAI >& par_cellGlobalIdOrServiceAreaIdOrLAI,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< OCTETSTRING >& par_selectedLSA__Id,
    const OPTIONAL< OCTETSTRING >& par_msc__Number,
    const OPTIONAL< OCTETSTRING >& par_geodeticInformation,
    const OPTIONAL< ASN_NULL >& par_currentLocationRetrieved,
    const OPTIONAL< ASN_NULL >& par_sai__Present,
    const OPTIONAL< LocationInformationEPS >& par_locationInformationEPS,
    const OPTIONAL< UserCSGInformation >& par_userCSGInformation)
  :   field_ageOfLocationInformation(par_ageOfLocationInformation),
  field_geographicalInformation(par_geographicalInformation),
  field_vlr__number(par_vlr__number),
  field_locationNumber(par_locationNumber),
  field_cellGlobalIdOrServiceAreaIdOrLAI(par_cellGlobalIdOrServiceAreaIdOrLAI),
  field_extensionContainer(par_extensionContainer),
  field_selectedLSA__Id(par_selectedLSA__Id),
  field_msc__Number(par_msc__Number),
  field_geodeticInformation(par_geodeticInformation),
  field_currentLocationRetrieved(par_currentLocationRetrieved),
  field_sai__Present(par_sai__Present),
  field_locationInformationEPS(par_locationInformationEPS),
  field_userCSGInformation(par_userCSGInformation)
{
}

LocationInformation::LocationInformation(const LocationInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.LocationInformation.");
if (other_value.ageOfLocationInformation().is_bound()) field_ageOfLocationInformation = other_value.ageOfLocationInformation();
else field_ageOfLocationInformation.clean_up();
if (other_value.geographicalInformation().is_bound()) field_geographicalInformation = other_value.geographicalInformation();
else field_geographicalInformation.clean_up();
if (other_value.vlr__number().is_bound()) field_vlr__number = other_value.vlr__number();
else field_vlr__number.clean_up();
if (other_value.locationNumber().is_bound()) field_locationNumber = other_value.locationNumber();
else field_locationNumber.clean_up();
if (other_value.cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) field_cellGlobalIdOrServiceAreaIdOrLAI = other_value.cellGlobalIdOrServiceAreaIdOrLAI();
else field_cellGlobalIdOrServiceAreaIdOrLAI.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.selectedLSA__Id().is_bound()) field_selectedLSA__Id = other_value.selectedLSA__Id();
else field_selectedLSA__Id.clean_up();
if (other_value.msc__Number().is_bound()) field_msc__Number = other_value.msc__Number();
else field_msc__Number.clean_up();
if (other_value.geodeticInformation().is_bound()) field_geodeticInformation = other_value.geodeticInformation();
else field_geodeticInformation.clean_up();
if (other_value.currentLocationRetrieved().is_bound()) field_currentLocationRetrieved = other_value.currentLocationRetrieved();
else field_currentLocationRetrieved.clean_up();
if (other_value.sai__Present().is_bound()) field_sai__Present = other_value.sai__Present();
else field_sai__Present.clean_up();
if (other_value.locationInformationEPS().is_bound()) field_locationInformationEPS = other_value.locationInformationEPS();
else field_locationInformationEPS.clean_up();
if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
else field_userCSGInformation.clean_up();
}

void LocationInformation::clean_up()
{
field_ageOfLocationInformation.clean_up();
field_geographicalInformation.clean_up();
field_vlr__number.clean_up();
field_locationNumber.clean_up();
field_cellGlobalIdOrServiceAreaIdOrLAI.clean_up();
field_extensionContainer.clean_up();
field_selectedLSA__Id.clean_up();
field_msc__Number.clean_up();
field_geodeticInformation.clean_up();
field_currentLocationRetrieved.clean_up();
field_sai__Present.clean_up();
field_locationInformationEPS.clean_up();
field_userCSGInformation.clean_up();
}

const TTCN_Typedescriptor_t* LocationInformation::get_descriptor() const { return &LocationInformation_descr_; }
LocationInformation& LocationInformation::operator=(const LocationInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.LocationInformation.");
  if (other_value.ageOfLocationInformation().is_bound()) field_ageOfLocationInformation = other_value.ageOfLocationInformation();
  else field_ageOfLocationInformation.clean_up();
  if (other_value.geographicalInformation().is_bound()) field_geographicalInformation = other_value.geographicalInformation();
  else field_geographicalInformation.clean_up();
  if (other_value.vlr__number().is_bound()) field_vlr__number = other_value.vlr__number();
  else field_vlr__number.clean_up();
  if (other_value.locationNumber().is_bound()) field_locationNumber = other_value.locationNumber();
  else field_locationNumber.clean_up();
  if (other_value.cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) field_cellGlobalIdOrServiceAreaIdOrLAI = other_value.cellGlobalIdOrServiceAreaIdOrLAI();
  else field_cellGlobalIdOrServiceAreaIdOrLAI.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.selectedLSA__Id().is_bound()) field_selectedLSA__Id = other_value.selectedLSA__Id();
  else field_selectedLSA__Id.clean_up();
  if (other_value.msc__Number().is_bound()) field_msc__Number = other_value.msc__Number();
  else field_msc__Number.clean_up();
  if (other_value.geodeticInformation().is_bound()) field_geodeticInformation = other_value.geodeticInformation();
  else field_geodeticInformation.clean_up();
  if (other_value.currentLocationRetrieved().is_bound()) field_currentLocationRetrieved = other_value.currentLocationRetrieved();
  else field_currentLocationRetrieved.clean_up();
  if (other_value.sai__Present().is_bound()) field_sai__Present = other_value.sai__Present();
  else field_sai__Present.clean_up();
  if (other_value.locationInformationEPS().is_bound()) field_locationInformationEPS = other_value.locationInformationEPS();
  else field_locationInformationEPS.clean_up();
  if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
  else field_userCSGInformation.clean_up();
}
return *this;
}

boolean LocationInformation::operator==(const LocationInformation& other_value) const
{
return field_ageOfLocationInformation==other_value.field_ageOfLocationInformation
  && field_geographicalInformation==other_value.field_geographicalInformation
  && field_vlr__number==other_value.field_vlr__number
  && field_locationNumber==other_value.field_locationNumber
  && field_cellGlobalIdOrServiceAreaIdOrLAI==other_value.field_cellGlobalIdOrServiceAreaIdOrLAI
  && field_extensionContainer==other_value.field_extensionContainer
  && field_selectedLSA__Id==other_value.field_selectedLSA__Id
  && field_msc__Number==other_value.field_msc__Number
  && field_geodeticInformation==other_value.field_geodeticInformation
  && field_currentLocationRetrieved==other_value.field_currentLocationRetrieved
  && field_sai__Present==other_value.field_sai__Present
  && field_locationInformationEPS==other_value.field_locationInformationEPS
  && field_userCSGInformation==other_value.field_userCSGInformation;
}

boolean LocationInformation::is_bound() const
{
return (OPTIONAL_OMIT == field_ageOfLocationInformation.get_selection() || field_ageOfLocationInformation.is_bound())
  || (OPTIONAL_OMIT == field_geographicalInformation.get_selection() || field_geographicalInformation.is_bound())
  || (OPTIONAL_OMIT == field_vlr__number.get_selection() || field_vlr__number.is_bound())
  || (OPTIONAL_OMIT == field_locationNumber.get_selection() || field_locationNumber.is_bound())
  || (OPTIONAL_OMIT == field_cellGlobalIdOrServiceAreaIdOrLAI.get_selection() || field_cellGlobalIdOrServiceAreaIdOrLAI.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_selectedLSA__Id.get_selection() || field_selectedLSA__Id.is_bound())
  || (OPTIONAL_OMIT == field_msc__Number.get_selection() || field_msc__Number.is_bound())
  || (OPTIONAL_OMIT == field_geodeticInformation.get_selection() || field_geodeticInformation.is_bound())
  || (OPTIONAL_OMIT == field_currentLocationRetrieved.get_selection() || field_currentLocationRetrieved.is_bound())
  || (OPTIONAL_OMIT == field_sai__Present.get_selection() || field_sai__Present.is_bound())
  || (OPTIONAL_OMIT == field_locationInformationEPS.get_selection() || field_locationInformationEPS.is_bound())
  || (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_bound());
}
boolean LocationInformation::is_value() const
{
return (OPTIONAL_OMIT == field_ageOfLocationInformation.get_selection() || field_ageOfLocationInformation.is_value())
  && (OPTIONAL_OMIT == field_geographicalInformation.get_selection() || field_geographicalInformation.is_value())
  && (OPTIONAL_OMIT == field_vlr__number.get_selection() || field_vlr__number.is_value())
  && (OPTIONAL_OMIT == field_locationNumber.get_selection() || field_locationNumber.is_value())
  && (OPTIONAL_OMIT == field_cellGlobalIdOrServiceAreaIdOrLAI.get_selection() || field_cellGlobalIdOrServiceAreaIdOrLAI.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_selectedLSA__Id.get_selection() || field_selectedLSA__Id.is_value())
  && (OPTIONAL_OMIT == field_msc__Number.get_selection() || field_msc__Number.is_value())
  && (OPTIONAL_OMIT == field_geodeticInformation.get_selection() || field_geodeticInformation.is_value())
  && (OPTIONAL_OMIT == field_currentLocationRetrieved.get_selection() || field_currentLocationRetrieved.is_value())
  && (OPTIONAL_OMIT == field_sai__Present.get_selection() || field_sai__Present.is_value())
  && (OPTIONAL_OMIT == field_locationInformationEPS.get_selection() || field_locationInformationEPS.is_value())
  && (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_value());
}
int LocationInformation::size_of() const
{
  int ret_val = 0;
  if (field_ageOfLocationInformation.ispresent()) ret_val++;
  if (field_geographicalInformation.ispresent()) ret_val++;
  if (field_vlr__number.ispresent()) ret_val++;
  if (field_locationNumber.ispresent()) ret_val++;
  if (field_cellGlobalIdOrServiceAreaIdOrLAI.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_selectedLSA__Id.ispresent()) ret_val++;
  if (field_msc__Number.ispresent()) ret_val++;
  if (field_geodeticInformation.ispresent()) ret_val++;
  if (field_currentLocationRetrieved.ispresent()) ret_val++;
  if (field_sai__Present.ispresent()) ret_val++;
  if (field_locationInformationEPS.ispresent()) ret_val++;
  if (field_userCSGInformation.ispresent()) ret_val++;
  return ret_val;
}

void LocationInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ageOfLocationInformation := ");
field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(", geographicalInformation := ");
field_geographicalInformation.log();
TTCN_Logger::log_event_str(", vlr_number := ");
field_vlr__number.log();
TTCN_Logger::log_event_str(", locationNumber := ");
field_locationNumber.log();
TTCN_Logger::log_event_str(", cellGlobalIdOrServiceAreaIdOrLAI := ");
field_cellGlobalIdOrServiceAreaIdOrLAI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", selectedLSA_Id := ");
field_selectedLSA__Id.log();
TTCN_Logger::log_event_str(", msc_Number := ");
field_msc__Number.log();
TTCN_Logger::log_event_str(", geodeticInformation := ");
field_geodeticInformation.log();
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(", sai_Present := ");
field_sai__Present.log();
TTCN_Logger::log_event_str(", locationInformationEPS := ");
field_locationInformationEPS.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
field_userCSGInformation.log();
TTCN_Logger::log_event_str(" }");
}

void LocationInformation::set_implicit_omit()
{
if (!ageOfLocationInformation().is_bound()) ageOfLocationInformation() = OMIT_VALUE;
else ageOfLocationInformation().set_implicit_omit();
if (!geographicalInformation().is_bound()) geographicalInformation() = OMIT_VALUE;
else geographicalInformation().set_implicit_omit();
if (!vlr__number().is_bound()) vlr__number() = OMIT_VALUE;
else vlr__number().set_implicit_omit();
if (!locationNumber().is_bound()) locationNumber() = OMIT_VALUE;
else locationNumber().set_implicit_omit();
if (!cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) cellGlobalIdOrServiceAreaIdOrLAI() = OMIT_VALUE;
else cellGlobalIdOrServiceAreaIdOrLAI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!selectedLSA__Id().is_bound()) selectedLSA__Id() = OMIT_VALUE;
else selectedLSA__Id().set_implicit_omit();
if (!msc__Number().is_bound()) msc__Number() = OMIT_VALUE;
else msc__Number().set_implicit_omit();
if (!geodeticInformation().is_bound()) geodeticInformation() = OMIT_VALUE;
else geodeticInformation().set_implicit_omit();
if (!currentLocationRetrieved().is_bound()) currentLocationRetrieved() = OMIT_VALUE;
else currentLocationRetrieved().set_implicit_omit();
if (!sai__Present().is_bound()) sai__Present() = OMIT_VALUE;
else sai__Present().set_implicit_omit();
if (!locationInformationEPS().is_bound()) locationInformationEPS() = OMIT_VALUE;
else locationInformationEPS().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
}

void LocationInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (13<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.LocationInformation has 13 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ageOfLocationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) geographicalInformation().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) vlr__number().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locationNumber().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellGlobalIdOrServiceAreaIdOrLAI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) selectedLSA__Id().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) msc__Number().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) geodeticInformation().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) currentLocationRetrieved().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sai__Present().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(12));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ageOfLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ageOfLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellGlobalIdOrServiceAreaIdOrLAI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellGlobalIdOrServiceAreaIdOrLAI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "selectedLSA_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          selectedLSA__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msc_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msc__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geodeticInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geodeticInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocationRetrieved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocationRetrieved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sai_Present")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sai__Present().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.LocationInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.LocationInformation");
  }
}

void LocationInformation::encode_text(Text_Buf& text_buf) const
{
field_ageOfLocationInformation.encode_text(text_buf);
field_geographicalInformation.encode_text(text_buf);
field_vlr__number.encode_text(text_buf);
field_locationNumber.encode_text(text_buf);
field_cellGlobalIdOrServiceAreaIdOrLAI.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_selectedLSA__Id.encode_text(text_buf);
field_msc__Number.encode_text(text_buf);
field_geodeticInformation.encode_text(text_buf);
field_currentLocationRetrieved.encode_text(text_buf);
field_sai__Present.encode_text(text_buf);
field_locationInformationEPS.encode_text(text_buf);
field_userCSGInformation.encode_text(text_buf);
}

void LocationInformation::decode_text(Text_Buf& text_buf)
{
field_ageOfLocationInformation.decode_text(text_buf);
field_geographicalInformation.decode_text(text_buf);
field_vlr__number.decode_text(text_buf);
field_locationNumber.decode_text(text_buf);
field_cellGlobalIdOrServiceAreaIdOrLAI.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_selectedLSA__Id.decode_text(text_buf);
field_msc__Number.decode_text(text_buf);
field_geodeticInformation.decode_text(text_buf);
field_currentLocationRetrieved.decode_text(text_buf);
field_sai__Present.decode_text(text_buf);
field_locationInformationEPS.decode_text(text_buf);
field_userCSGInformation.decode_text(text_buf);
}

void LocationInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LocationInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* LocationInformation::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ageOfLocationInformation': ");
  new_tlv->add_TLV(field_ageOfLocationInformation.BER_encode_TLV(LocationInformation_ageOfLocationInformation_descr_, p_coding));
  ec_1.set_msg("geographicalInformation': ");
  new_tlv->add_TLV(field_geographicalInformation.BER_encode_TLV(LocationInformation_geographicalInformation_descr_, p_coding));
  ec_1.set_msg("vlr_number': ");
  new_tlv->add_TLV(field_vlr__number.BER_encode_TLV(LocationInformation_vlr__number_descr_, p_coding));
  ec_1.set_msg("locationNumber': ");
  new_tlv->add_TLV(field_locationNumber.BER_encode_TLV(LocationInformation_locationNumber_descr_, p_coding));
  ec_1.set_msg("cellGlobalIdOrServiceAreaIdOrLAI': ");
  new_tlv->add_TLV(field_cellGlobalIdOrServiceAreaIdOrLAI.BER_encode_TLV(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(LocationInformation_extensionContainer_descr_, p_coding));
  ec_1.set_msg("selectedLSA_Id': ");
  new_tlv->add_TLV(field_selectedLSA__Id.BER_encode_TLV(LocationInformation_selectedLSA__Id_descr_, p_coding));
  ec_1.set_msg("msc_Number': ");
  new_tlv->add_TLV(field_msc__Number.BER_encode_TLV(LocationInformation_msc__Number_descr_, p_coding));
  ec_1.set_msg("geodeticInformation': ");
  new_tlv->add_TLV(field_geodeticInformation.BER_encode_TLV(LocationInformation_geodeticInformation_descr_, p_coding));
  ec_1.set_msg("currentLocationRetrieved': ");
  new_tlv->add_TLV(field_currentLocationRetrieved.BER_encode_TLV(LocationInformation_currentLocationRetrieved_descr_, p_coding));
  ec_1.set_msg("sai_Present': ");
  new_tlv->add_TLV(field_sai__Present.BER_encode_TLV(LocationInformation_sai__Present_descr_, p_coding));
  ec_1.set_msg("locationInformationEPS': ");
  new_tlv->add_TLV(field_locationInformationEPS.BER_encode_TLV(LocationInformation_locationInformationEPS_descr_, p_coding));
  ec_1.set_msg("userCSGInformation': ");
  new_tlv->add_TLV(field_userCSGInformation.BER_encode_TLV(LocationInformation_userCSGInformation_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean LocationInformation::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.LocationInformation' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ageOfLocationInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ageOfLocationInformation=OMIT_VALUE;
    else {
      field_ageOfLocationInformation.BER_decode_TLV(LocationInformation_ageOfLocationInformation_descr_, tmp_tlv, L_form);
      if(field_ageOfLocationInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("geographicalInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_geographicalInformation=OMIT_VALUE;
    else {
      field_geographicalInformation.BER_decode_TLV(LocationInformation_geographicalInformation_descr_, tmp_tlv, L_form);
      if(field_geographicalInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vlr_number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vlr__number=OMIT_VALUE;
    else {
      field_vlr__number.BER_decode_TLV(LocationInformation_vlr__number_descr_, tmp_tlv, L_form);
      if(field_vlr__number.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("locationNumber': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationNumber=OMIT_VALUE;
    else {
      field_locationNumber.BER_decode_TLV(LocationInformation_locationNumber_descr_, tmp_tlv, L_form);
      if(field_locationNumber.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("cellGlobalIdOrServiceAreaIdOrLAI': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_cellGlobalIdOrServiceAreaIdOrLAI=OMIT_VALUE;
    else {
      field_cellGlobalIdOrServiceAreaIdOrLAI.BER_decode_TLV(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, tmp_tlv, L_form);
      if(field_cellGlobalIdOrServiceAreaIdOrLAI.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(LocationInformation_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("selectedLSA_Id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_selectedLSA__Id=OMIT_VALUE;
    else {
      field_selectedLSA__Id.BER_decode_TLV(LocationInformation_selectedLSA__Id_descr_, tmp_tlv, L_form);
      if(field_selectedLSA__Id.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("msc_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_msc__Number=OMIT_VALUE;
    else {
      field_msc__Number.BER_decode_TLV(LocationInformation_msc__Number_descr_, tmp_tlv, L_form);
      if(field_msc__Number.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("geodeticInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_geodeticInformation=OMIT_VALUE;
    else {
      field_geodeticInformation.BER_decode_TLV(LocationInformation_geodeticInformation_descr_, tmp_tlv, L_form);
      if(field_geodeticInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("currentLocationRetrieved': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_currentLocationRetrieved=OMIT_VALUE;
    else {
      field_currentLocationRetrieved.BER_decode_TLV(LocationInformation_currentLocationRetrieved_descr_, tmp_tlv, L_form);
      if(field_currentLocationRetrieved.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("sai_Present': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_sai__Present=OMIT_VALUE;
    else {
      field_sai__Present.BER_decode_TLV(LocationInformation_sai__Present_descr_, tmp_tlv, L_form);
      if(field_sai__Present.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("locationInformationEPS': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_locationInformationEPS=OMIT_VALUE;
    else {
      field_locationInformationEPS.BER_decode_TLV(LocationInformation_locationInformationEPS_descr_, tmp_tlv, L_form);
      if(field_locationInformationEPS.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("userCSGInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_userCSGInformation=OMIT_VALUE;
    else {
      field_userCSGInformation.BER_decode_TLV(LocationInformation_userCSGInformation_descr_, tmp_tlv, L_form);
      if(field_userCSGInformation.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int LocationInformation::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.LocationInformation.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_ageOfLocationInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ageOfLocationInformation");
    enc_len += field_ageOfLocationInformation.JSON_encode(LocationInformation_ageOfLocationInformation_descr_, p_tok, FALSE);
  }

  if (field_geographicalInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geographicalInformation");
    enc_len += field_geographicalInformation.JSON_encode(LocationInformation_geographicalInformation_descr_, p_tok, FALSE);
  }

  if (field_vlr__number.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vlr_number");
    enc_len += field_vlr__number.JSON_encode(LocationInformation_vlr__number_descr_, p_tok, FALSE);
  }

  if (field_locationNumber.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationNumber");
    enc_len += field_locationNumber.JSON_encode(LocationInformation_locationNumber_descr_, p_tok, FALSE);
  }

  if (field_cellGlobalIdOrServiceAreaIdOrLAI.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "cellGlobalIdOrServiceAreaIdOrLAI");
    enc_len += field_cellGlobalIdOrServiceAreaIdOrLAI.JSON_encode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(LocationInformation_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_selectedLSA__Id.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "selectedLSA_Id");
    enc_len += field_selectedLSA__Id.JSON_encode(LocationInformation_selectedLSA__Id_descr_, p_tok, FALSE);
  }

  if (field_msc__Number.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "msc_Number");
    enc_len += field_msc__Number.JSON_encode(LocationInformation_msc__Number_descr_, p_tok, FALSE);
  }

  if (field_geodeticInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geodeticInformation");
    enc_len += field_geodeticInformation.JSON_encode(LocationInformation_geodeticInformation_descr_, p_tok, FALSE);
  }

  if (field_currentLocationRetrieved.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "currentLocationRetrieved");
    enc_len += field_currentLocationRetrieved.JSON_encode(LocationInformation_currentLocationRetrieved_descr_, p_tok, FALSE);
  }

  if (field_sai__Present.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sai_Present");
    enc_len += field_sai__Present.JSON_encode(LocationInformation_sai__Present_descr_, p_tok, FALSE);
  }

  if (field_locationInformationEPS.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "locationInformationEPS");
    enc_len += field_locationInformationEPS.JSON_encode(LocationInformation_locationInformationEPS_descr_, p_tok, FALSE);
  }

  if (field_userCSGInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "userCSGInformation");
    enc_len += field_userCSGInformation.JSON_encode(LocationInformation_userCSGInformation_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int LocationInformation::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const LocationInformation*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ageOfLocationInformation_found = FALSE;
  boolean geographicalInformation_found = FALSE;
  boolean vlr__number_found = FALSE;
  boolean locationNumber_found = FALSE;
  boolean cellGlobalIdOrServiceAreaIdOrLAI_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean selectedLSA__Id_found = FALSE;
  boolean msc__Number_found = FALSE;
  boolean geodeticInformation_found = FALSE;
  boolean currentLocationRetrieved_found = FALSE;
  boolean sai__Present_found = FALSE;
  boolean locationInformationEPS_found = FALSE;
  boolean userCSGInformation_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (24 == name_len && 0 == strncmp(fld_name, "ageOfLocationInformation", name_len)) {
        ageOfLocationInformation_found = TRUE;
         int ret_val = field_ageOfLocationInformation.JSON_decode(LocationInformation_ageOfLocationInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "ageOfLocationInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (23 == name_len && 0 == strncmp(fld_name, "geographicalInformation", name_len)) {
        geographicalInformation_found = TRUE;
         int ret_val = field_geographicalInformation.JSON_decode(LocationInformation_geographicalInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "geographicalInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "vlr_number", name_len)) {
        vlr__number_found = TRUE;
         int ret_val = field_vlr__number.JSON_decode(LocationInformation_vlr__number_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "vlr_number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "locationNumber", name_len)) {
        locationNumber_found = TRUE;
         int ret_val = field_locationNumber.JSON_decode(LocationInformation_locationNumber_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "locationNumber");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "cellGlobalIdOrServiceAreaIdOrLAI", name_len)) {
        cellGlobalIdOrServiceAreaIdOrLAI_found = TRUE;
         int ret_val = field_cellGlobalIdOrServiceAreaIdOrLAI.JSON_decode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "cellGlobalIdOrServiceAreaIdOrLAI");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(LocationInformation_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "selectedLSA_Id", name_len)) {
        selectedLSA__Id_found = TRUE;
         int ret_val = field_selectedLSA__Id.JSON_decode(LocationInformation_selectedLSA__Id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "selectedLSA_Id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "msc_Number", name_len)) {
        msc__Number_found = TRUE;
         int ret_val = field_msc__Number.JSON_decode(LocationInformation_msc__Number_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "msc_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "geodeticInformation", name_len)) {
        geodeticInformation_found = TRUE;
         int ret_val = field_geodeticInformation.JSON_decode(LocationInformation_geodeticInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "geodeticInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (24 == name_len && 0 == strncmp(fld_name, "currentLocationRetrieved", name_len)) {
        currentLocationRetrieved_found = TRUE;
         int ret_val = field_currentLocationRetrieved.JSON_decode(LocationInformation_currentLocationRetrieved_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "currentLocationRetrieved");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "sai_Present", name_len)) {
        sai__Present_found = TRUE;
         int ret_val = field_sai__Present.JSON_decode(LocationInformation_sai__Present_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "sai_Present");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (22 == name_len && 0 == strncmp(fld_name, "locationInformationEPS", name_len)) {
        locationInformationEPS_found = TRUE;
         int ret_val = field_locationInformationEPS.JSON_decode(LocationInformation_locationInformationEPS_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 22, "locationInformationEPS");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "userCSGInformation", name_len)) {
        userCSGInformation_found = TRUE;
         int ret_val = field_userCSGInformation.JSON_decode(LocationInformation_userCSGInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "userCSGInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ageOfLocationInformation_found) {
    field_ageOfLocationInformation = OMIT_VALUE;
  }
  if (!geographicalInformation_found) {
    field_geographicalInformation = OMIT_VALUE;
  }
  if (!vlr__number_found) {
    field_vlr__number = OMIT_VALUE;
  }
  if (!locationNumber_found) {
    field_locationNumber = OMIT_VALUE;
  }
  if (!cellGlobalIdOrServiceAreaIdOrLAI_found) {
    field_cellGlobalIdOrServiceAreaIdOrLAI = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!selectedLSA__Id_found) {
    field_selectedLSA__Id = OMIT_VALUE;
  }
  if (!msc__Number_found) {
    field_msc__Number = OMIT_VALUE;
  }
  if (!geodeticInformation_found) {
    field_geodeticInformation = OMIT_VALUE;
  }
  if (!currentLocationRetrieved_found) {
    field_currentLocationRetrieved = OMIT_VALUE;
  }
  if (!sai__Present_found) {
    field_sai__Present = OMIT_VALUE;
  }
  if (!locationInformationEPS_found) {
    field_locationInformationEPS = OMIT_VALUE;
  }
  if (!userCSGInformation_found) {
    field_userCSGInformation = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int LocationInformation::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_selectedLSA__Id.is_bound() && field_selectedLSA__Id.is_present());
  has_extension = has_extension || (field_msc__Number.is_bound() && field_msc__Number.is_present());
  has_extension = has_extension || (field_geodeticInformation.is_bound() && field_geodeticInformation.is_present());
  has_extension = has_extension || (field_currentLocationRetrieved.is_bound() && field_currentLocationRetrieved.is_present());
  has_extension = has_extension || (field_sai__Present.is_bound() && field_sai__Present.is_present());
  has_extension = has_extension || (field_locationInformationEPS.is_bound() && field_locationInformationEPS.is_present());
  has_extension = has_extension || (field_userCSGInformation.is_bound() && field_userCSGInformation.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_ageOfLocationInformation.is_present()) {
    c |= 64;
  }
  if (field_geographicalInformation.is_present()) {
    c |= 32;
  }
  if (field_vlr__number.is_present()) {
    c |= 16;
  }
  if (field_locationNumber.is_present()) {
    c |= 8;
  }
  if (field_cellGlobalIdOrServiceAreaIdOrLAI.is_present()) {
    c |= 4;
  }
  if (field_extensionContainer.is_present()) {
    c |= 2;
  }
  p_buf.put_c(c);
  if (field_ageOfLocationInformation.is_present())
    field_ageOfLocationInformation.OER_encode(LocationInformation_ageOfLocationInformation_descr_, p_buf);
  if (field_geographicalInformation.is_present())
    field_geographicalInformation.OER_encode(LocationInformation_geographicalInformation_descr_, p_buf);
  if (field_vlr__number.is_present())
    field_vlr__number.OER_encode(LocationInformation_vlr__number_descr_, p_buf);
  if (field_locationNumber.is_present())
    field_locationNumber.OER_encode(LocationInformation_locationNumber_descr_, p_buf);
  if (field_cellGlobalIdOrServiceAreaIdOrLAI.is_present())
    field_cellGlobalIdOrServiceAreaIdOrLAI.OER_encode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(LocationInformation_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_selectedLSA__Id.is_present()) {
      c |= 128;
      field_selectedLSA__Id.OER_encode(LocationInformation_selectedLSA__Id_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_msc__Number.is_present()) {
      c |= 64;
      field_msc__Number.OER_encode(LocationInformation_msc__Number_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_geodeticInformation.is_present()) {
      c |= 32;
      field_geodeticInformation.OER_encode(LocationInformation_geodeticInformation_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_currentLocationRetrieved.is_present()) {
      c |= 16;
      field_currentLocationRetrieved.OER_encode(LocationInformation_currentLocationRetrieved_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_sai__Present.is_present()) {
      c |= 8;
      field_sai__Present.OER_encode(LocationInformation_sai__Present_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_locationInformationEPS.is_present()) {
      c |= 4;
      field_locationInformationEPS.OER_encode(LocationInformation_locationInformationEPS_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_userCSGInformation.is_present()) {
      c |= 2;
      field_userCSGInformation.OER_encode(LocationInformation_userCSGInformation_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(1);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int LocationInformation::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_ageOfLocationInformation.OER_decode(LocationInformation_ageOfLocationInformation_descr_, p_buf, p_oer);
 else
    field_ageOfLocationInformation = OMIT_VALUE;
  if (uc[0] & 32)
    field_geographicalInformation.OER_decode(LocationInformation_geographicalInformation_descr_, p_buf, p_oer);
 else
    field_geographicalInformation = OMIT_VALUE;
  if (uc[0] & 16)
    field_vlr__number.OER_decode(LocationInformation_vlr__number_descr_, p_buf, p_oer);
 else
    field_vlr__number = OMIT_VALUE;
  if (uc[0] & 8)
    field_locationNumber.OER_decode(LocationInformation_locationNumber_descr_, p_buf, p_oer);
 else
    field_locationNumber = OMIT_VALUE;
  if (uc[0] & 4)
    field_cellGlobalIdOrServiceAreaIdOrLAI.OER_decode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_buf, p_oer);
 else
    field_cellGlobalIdOrServiceAreaIdOrLAI = OMIT_VALUE;
  if (uc[0] & 2)
    field_extensionContainer.OER_decode(LocationInformation_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_selectedLSA__Id = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_selectedLSA__Id.OER_decode(LocationInformation_selectedLSA__Id_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_msc__Number = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_msc__Number.OER_decode(LocationInformation_msc__Number_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_geodeticInformation = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_geodeticInformation.OER_decode(LocationInformation_geodeticInformation_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_currentLocationRetrieved = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_currentLocationRetrieved.OER_decode(LocationInformation_currentLocationRetrieved_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_sai__Present = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_sai__Present.OER_decode(LocationInformation_sai__Present_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_locationInformationEPS = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_locationInformationEPS.OER_decode(LocationInformation_locationInformationEPS_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_userCSGInformation = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_userCSGInformation.OER_decode(LocationInformation_userCSGInformation_descr_, p_buf, p_oer);
    }
  }
  else {
    field_selectedLSA__Id = OMIT_VALUE;
    field_msc__Number = OMIT_VALUE;
    field_geodeticInformation = OMIT_VALUE;
    field_currentLocationRetrieved = OMIT_VALUE;
    field_sai__Present = OMIT_VALUE;
    field_locationInformationEPS = OMIT_VALUE;
    field_userCSGInformation = OMIT_VALUE;
  }
  return 0;
}

void LocationInformation::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_selectedLSA__Id.is_present();
boolean ext_1_present = field_msc__Number.is_present();
boolean ext_2_present = field_geodeticInformation.is_present();
boolean ext_3_present = field_currentLocationRetrieved.is_present();
boolean ext_4_present = field_sai__Present.is_present();
boolean ext_5_present = field_locationInformationEPS.is_present();
boolean ext_6_present = field_userCSGInformation.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present;
p_buf.PER_put_bit(ext_bit);
boolean field_ageOfLocationInformation_present = field_ageOfLocationInformation.is_present();
p_buf.PER_put_bit(field_ageOfLocationInformation_present);
boolean field_geographicalInformation_present = field_geographicalInformation.is_present();
p_buf.PER_put_bit(field_geographicalInformation_present);
boolean field_vlr__number_present = field_vlr__number.is_present();
p_buf.PER_put_bit(field_vlr__number_present);
boolean field_locationNumber_present = field_locationNumber.is_present();
p_buf.PER_put_bit(field_locationNumber_present);
boolean field_cellGlobalIdOrServiceAreaIdOrLAI_present = field_cellGlobalIdOrServiceAreaIdOrLAI.is_present();
p_buf.PER_put_bit(field_cellGlobalIdOrServiceAreaIdOrLAI_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_ageOfLocationInformation_present) field_ageOfLocationInformation.PER_encode(LocationInformation_ageOfLocationInformation_descr_, p_buf, p_options);
if (field_geographicalInformation_present) field_geographicalInformation.PER_encode(LocationInformation_geographicalInformation_descr_, p_buf, p_options);
if (field_vlr__number_present) field_vlr__number.PER_encode(LocationInformation_vlr__number_descr_, p_buf, p_options);
if (field_locationNumber_present) field_locationNumber.PER_encode(LocationInformation_locationNumber_descr_, p_buf, p_options);
if (field_cellGlobalIdOrServiceAreaIdOrLAI_present) field_cellGlobalIdOrServiceAreaIdOrLAI.PER_encode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(LocationInformation_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(7);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_selectedLSA__Id.PER_encode(LocationInformation_selectedLSA__Id_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_msc__Number.PER_encode(LocationInformation_msc__Number_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_geodeticInformation.PER_encode(LocationInformation_geodeticInformation_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_currentLocationRetrieved.PER_encode(LocationInformation_currentLocationRetrieved_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_sai__Present.PER_encode(LocationInformation_sai__Present_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_locationInformationEPS.PER_encode(LocationInformation_locationInformationEPS_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_userCSGInformation.PER_encode(LocationInformation_userCSGInformation_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void LocationInformation::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_ageOfLocationInformation_present = p_buf.PER_get_bit();
boolean field_geographicalInformation_present = p_buf.PER_get_bit();
boolean field_vlr__number_present = p_buf.PER_get_bit();
boolean field_locationNumber_present = p_buf.PER_get_bit();
boolean field_cellGlobalIdOrServiceAreaIdOrLAI_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_ageOfLocationInformation_present) field_ageOfLocationInformation.PER_decode(LocationInformation_ageOfLocationInformation_descr_, p_buf, p_options);
else field_ageOfLocationInformation = OMIT_VALUE;
if (field_geographicalInformation_present) field_geographicalInformation.PER_decode(LocationInformation_geographicalInformation_descr_, p_buf, p_options);
else field_geographicalInformation = OMIT_VALUE;
if (field_vlr__number_present) field_vlr__number.PER_decode(LocationInformation_vlr__number_descr_, p_buf, p_options);
else field_vlr__number = OMIT_VALUE;
if (field_locationNumber_present) field_locationNumber.PER_decode(LocationInformation_locationNumber_descr_, p_buf, p_options);
else field_locationNumber = OMIT_VALUE;
if (field_cellGlobalIdOrServiceAreaIdOrLAI_present) field_cellGlobalIdOrServiceAreaIdOrLAI.PER_decode(LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI_descr_, p_buf, p_options);
else field_cellGlobalIdOrServiceAreaIdOrLAI = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(LocationInformation_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 7) {
for (int i = nof_decoded_ext_adds; i < 7; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_selectedLSA__Id.PER_decode(LocationInformation_selectedLSA__Id_descr_, ext_add_buf, p_options);
}
else {
field_selectedLSA__Id = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_msc__Number.PER_decode(LocationInformation_msc__Number_descr_, ext_add_buf, p_options);
}
else {
field_msc__Number = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_geodeticInformation.PER_decode(LocationInformation_geodeticInformation_descr_, ext_add_buf, p_options);
}
else {
field_geodeticInformation = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_currentLocationRetrieved.PER_decode(LocationInformation_currentLocationRetrieved_descr_, ext_add_buf, p_options);
}
else {
field_currentLocationRetrieved = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_sai__Present.PER_decode(LocationInformation_sai__Present_descr_, ext_add_buf, p_options);
}
else {
field_sai__Present = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_locationInformationEPS.PER_decode(LocationInformation_locationInformationEPS_descr_, ext_add_buf, p_options);
}
else {
field_locationInformationEPS = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_userCSGInformation.PER_decode(LocationInformation_userCSGInformation_descr_, ext_add_buf, p_options);
}
else {
field_userCSGInformation = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 7) for (int i = 7; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct LocationInformation_template::single_value_struct {
INTEGER_template field_ageOfLocationInformation;
OCTETSTRING_template field_geographicalInformation;
OCTETSTRING_template field_vlr__number;
OCTETSTRING_template field_locationNumber;
MAP__CommonDataTypes::CellGlobalIdOrServiceAreaIdOrLAI_template field_cellGlobalIdOrServiceAreaIdOrLAI;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
OCTETSTRING_template field_selectedLSA__Id;
OCTETSTRING_template field_msc__Number;
OCTETSTRING_template field_geodeticInformation;
ASN_NULL_template field_currentLocationRetrieved;
ASN_NULL_template field_sai__Present;
LocationInformationEPS_template field_locationInformationEPS;
UserCSGInformation_template field_userCSGInformation;
};

void LocationInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ageOfLocationInformation = ANY_OR_OMIT;
single_value->field_geographicalInformation = ANY_OR_OMIT;
single_value->field_vlr__number = ANY_OR_OMIT;
single_value->field_locationNumber = ANY_OR_OMIT;
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_selectedLSA__Id = ANY_OR_OMIT;
single_value->field_msc__Number = ANY_OR_OMIT;
single_value->field_geodeticInformation = ANY_OR_OMIT;
single_value->field_currentLocationRetrieved = ANY_OR_OMIT;
single_value->field_sai__Present = ANY_OR_OMIT;
single_value->field_locationInformationEPS = ANY_OR_OMIT;
single_value->field_userCSGInformation = ANY_OR_OMIT;
}
}
}

void LocationInformation_template::copy_value(const LocationInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.ageOfLocationInformation().is_bound()) {
  if (other_value.ageOfLocationInformation().ispresent()) single_value->field_ageOfLocationInformation = other_value.ageOfLocationInformation()();
  else single_value->field_ageOfLocationInformation = OMIT_VALUE;
} else {
  single_value->field_ageOfLocationInformation.clean_up();
}
if (other_value.geographicalInformation().is_bound()) {
  if (other_value.geographicalInformation().ispresent()) single_value->field_geographicalInformation = other_value.geographicalInformation()();
  else single_value->field_geographicalInformation = OMIT_VALUE;
} else {
  single_value->field_geographicalInformation.clean_up();
}
if (other_value.vlr__number().is_bound()) {
  if (other_value.vlr__number().ispresent()) single_value->field_vlr__number = other_value.vlr__number()();
  else single_value->field_vlr__number = OMIT_VALUE;
} else {
  single_value->field_vlr__number.clean_up();
}
if (other_value.locationNumber().is_bound()) {
  if (other_value.locationNumber().ispresent()) single_value->field_locationNumber = other_value.locationNumber()();
  else single_value->field_locationNumber = OMIT_VALUE;
} else {
  single_value->field_locationNumber.clean_up();
}
if (other_value.cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) {
  if (other_value.cellGlobalIdOrServiceAreaIdOrLAI().ispresent()) single_value->field_cellGlobalIdOrServiceAreaIdOrLAI = other_value.cellGlobalIdOrServiceAreaIdOrLAI()();
  else single_value->field_cellGlobalIdOrServiceAreaIdOrLAI = OMIT_VALUE;
} else {
  single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.selectedLSA__Id().is_bound()) {
  if (other_value.selectedLSA__Id().ispresent()) single_value->field_selectedLSA__Id = other_value.selectedLSA__Id()();
  else single_value->field_selectedLSA__Id = OMIT_VALUE;
} else {
  single_value->field_selectedLSA__Id.clean_up();
}
if (other_value.msc__Number().is_bound()) {
  if (other_value.msc__Number().ispresent()) single_value->field_msc__Number = other_value.msc__Number()();
  else single_value->field_msc__Number = OMIT_VALUE;
} else {
  single_value->field_msc__Number.clean_up();
}
if (other_value.geodeticInformation().is_bound()) {
  if (other_value.geodeticInformation().ispresent()) single_value->field_geodeticInformation = other_value.geodeticInformation()();
  else single_value->field_geodeticInformation = OMIT_VALUE;
} else {
  single_value->field_geodeticInformation.clean_up();
}
if (other_value.currentLocationRetrieved().is_bound()) {
  if (other_value.currentLocationRetrieved().ispresent()) single_value->field_currentLocationRetrieved = other_value.currentLocationRetrieved()();
  else single_value->field_currentLocationRetrieved = OMIT_VALUE;
} else {
  single_value->field_currentLocationRetrieved.clean_up();
}
if (other_value.sai__Present().is_bound()) {
  if (other_value.sai__Present().ispresent()) single_value->field_sai__Present = other_value.sai__Present()();
  else single_value->field_sai__Present = OMIT_VALUE;
} else {
  single_value->field_sai__Present.clean_up();
}
if (other_value.locationInformationEPS().is_bound()) {
  if (other_value.locationInformationEPS().ispresent()) single_value->field_locationInformationEPS = other_value.locationInformationEPS()();
  else single_value->field_locationInformationEPS = OMIT_VALUE;
} else {
  single_value->field_locationInformationEPS.clean_up();
}
if (other_value.userCSGInformation().is_bound()) {
  if (other_value.userCSGInformation().ispresent()) single_value->field_userCSGInformation = other_value.userCSGInformation()();
  else single_value->field_userCSGInformation = OMIT_VALUE;
} else {
  single_value->field_userCSGInformation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LocationInformation_template::copy_template(const LocationInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ageOfLocationInformation().get_selection()) {
single_value->field_ageOfLocationInformation = other_value.ageOfLocationInformation();
} else {
single_value->field_ageOfLocationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.geographicalInformation().get_selection()) {
single_value->field_geographicalInformation = other_value.geographicalInformation();
} else {
single_value->field_geographicalInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vlr__number().get_selection()) {
single_value->field_vlr__number = other_value.vlr__number();
} else {
single_value->field_vlr__number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locationNumber().get_selection()) {
single_value->field_locationNumber = other_value.locationNumber();
} else {
single_value->field_locationNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellGlobalIdOrServiceAreaIdOrLAI().get_selection()) {
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI = other_value.cellGlobalIdOrServiceAreaIdOrLAI();
} else {
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.selectedLSA__Id().get_selection()) {
single_value->field_selectedLSA__Id = other_value.selectedLSA__Id();
} else {
single_value->field_selectedLSA__Id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msc__Number().get_selection()) {
single_value->field_msc__Number = other_value.msc__Number();
} else {
single_value->field_msc__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.geodeticInformation().get_selection()) {
single_value->field_geodeticInformation = other_value.geodeticInformation();
} else {
single_value->field_geodeticInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.currentLocationRetrieved().get_selection()) {
single_value->field_currentLocationRetrieved = other_value.currentLocationRetrieved();
} else {
single_value->field_currentLocationRetrieved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sai__Present().get_selection()) {
single_value->field_sai__Present = other_value.sai__Present();
} else {
single_value->field_sai__Present.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locationInformationEPS().get_selection()) {
single_value->field_locationInformationEPS = other_value.locationInformationEPS();
} else {
single_value->field_locationInformationEPS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userCSGInformation().get_selection()) {
single_value->field_userCSGInformation = other_value.userCSGInformation();
} else {
single_value->field_userCSGInformation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LocationInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LocationInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new LocationInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformation.");
break;
}
set_selection(other_value);
}

LocationInformation_template::LocationInformation_template()
{
}

LocationInformation_template::LocationInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LocationInformation_template::LocationInformation_template(const LocationInformation& other_value)
{
copy_value(other_value);
}

LocationInformation_template::LocationInformation_template(const OPTIONAL<LocationInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.LocationInformation from an unbound optional field.");
}
}

LocationInformation_template::LocationInformation_template(LocationInformation_template* p_precondition, LocationInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LocationInformation_template::LocationInformation_template(Dynamic_Match_Interface<LocationInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LocationInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LocationInformation_template::LocationInformation_template(const LocationInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LocationInformation_template::~LocationInformation_template()
{
clean_up();
}

LocationInformation_template& LocationInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LocationInformation_template& LocationInformation_template::operator=(const LocationInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LocationInformation_template& LocationInformation_template::operator=(const OPTIONAL<LocationInformation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.LocationInformation.");
}
return *this;
}

LocationInformation_template& LocationInformation_template::operator=(const LocationInformation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LocationInformation_template::match(const LocationInformation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ageOfLocationInformation().is_bound()) return FALSE;
if((other_value.ageOfLocationInformation().ispresent() ? !single_value->field_ageOfLocationInformation.match((const INTEGER&)other_value.ageOfLocationInformation(), legacy) : !single_value->field_ageOfLocationInformation.match_omit(legacy)))return FALSE;
if(!other_value.geographicalInformation().is_bound()) return FALSE;
if((other_value.geographicalInformation().ispresent() ? !single_value->field_geographicalInformation.match((const OCTETSTRING&)other_value.geographicalInformation(), legacy) : !single_value->field_geographicalInformation.match_omit(legacy)))return FALSE;
if(!other_value.vlr__number().is_bound()) return FALSE;
if((other_value.vlr__number().ispresent() ? !single_value->field_vlr__number.match((const OCTETSTRING&)other_value.vlr__number(), legacy) : !single_value->field_vlr__number.match_omit(legacy)))return FALSE;
if(!other_value.locationNumber().is_bound()) return FALSE;
if((other_value.locationNumber().ispresent() ? !single_value->field_locationNumber.match((const OCTETSTRING&)other_value.locationNumber(), legacy) : !single_value->field_locationNumber.match_omit(legacy)))return FALSE;
if(!other_value.cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) return FALSE;
if((other_value.cellGlobalIdOrServiceAreaIdOrLAI().ispresent() ? !single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.match((const MAP__CommonDataTypes::CellGlobalIdOrServiceAreaIdOrLAI&)other_value.cellGlobalIdOrServiceAreaIdOrLAI(), legacy) : !single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.selectedLSA__Id().is_bound()) return FALSE;
if((other_value.selectedLSA__Id().ispresent() ? !single_value->field_selectedLSA__Id.match((const OCTETSTRING&)other_value.selectedLSA__Id(), legacy) : !single_value->field_selectedLSA__Id.match_omit(legacy)))return FALSE;
if(!other_value.msc__Number().is_bound()) return FALSE;
if((other_value.msc__Number().ispresent() ? !single_value->field_msc__Number.match((const OCTETSTRING&)other_value.msc__Number(), legacy) : !single_value->field_msc__Number.match_omit(legacy)))return FALSE;
if(!other_value.geodeticInformation().is_bound()) return FALSE;
if((other_value.geodeticInformation().ispresent() ? !single_value->field_geodeticInformation.match((const OCTETSTRING&)other_value.geodeticInformation(), legacy) : !single_value->field_geodeticInformation.match_omit(legacy)))return FALSE;
if(!other_value.currentLocationRetrieved().is_bound()) return FALSE;
if((other_value.currentLocationRetrieved().ispresent() ? !single_value->field_currentLocationRetrieved.match((const ASN_NULL&)other_value.currentLocationRetrieved(), legacy) : !single_value->field_currentLocationRetrieved.match_omit(legacy)))return FALSE;
if(!other_value.sai__Present().is_bound()) return FALSE;
if((other_value.sai__Present().ispresent() ? !single_value->field_sai__Present.match((const ASN_NULL&)other_value.sai__Present(), legacy) : !single_value->field_sai__Present.match_omit(legacy)))return FALSE;
if(!other_value.locationInformationEPS().is_bound()) return FALSE;
if((other_value.locationInformationEPS().ispresent() ? !single_value->field_locationInformationEPS.match((const LocationInformationEPS&)other_value.locationInformationEPS(), legacy) : !single_value->field_locationInformationEPS.match_omit(legacy)))return FALSE;
if(!other_value.userCSGInformation().is_bound()) return FALSE;
if((other_value.userCSGInformation().ispresent() ? !single_value->field_userCSGInformation.match((const UserCSGInformation&)other_value.userCSGInformation(), legacy) : !single_value->field_userCSGInformation.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformation.");
}
return FALSE;
}

boolean LocationInformation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_ageOfLocationInformation.is_omit() || single_value->field_ageOfLocationInformation.is_bound())
 || (single_value->field_geographicalInformation.is_omit() || single_value->field_geographicalInformation.is_bound())
 || (single_value->field_vlr__number.is_omit() || single_value->field_vlr__number.is_bound())
 || (single_value->field_locationNumber.is_omit() || single_value->field_locationNumber.is_bound())
 || (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_omit() || single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_selectedLSA__Id.is_omit() || single_value->field_selectedLSA__Id.is_bound())
 || (single_value->field_msc__Number.is_omit() || single_value->field_msc__Number.is_bound())
 || (single_value->field_geodeticInformation.is_omit() || single_value->field_geodeticInformation.is_bound())
 || (single_value->field_currentLocationRetrieved.is_omit() || single_value->field_currentLocationRetrieved.is_bound())
 || (single_value->field_sai__Present.is_omit() || single_value->field_sai__Present.is_bound())
 || (single_value->field_locationInformationEPS.is_omit() || single_value->field_locationInformationEPS.is_bound())
 || (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_bound());
}

boolean LocationInformation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_ageOfLocationInformation.is_omit() || single_value->field_ageOfLocationInformation.is_value())
 && (single_value->field_geographicalInformation.is_omit() || single_value->field_geographicalInformation.is_value())
 && (single_value->field_vlr__number.is_omit() || single_value->field_vlr__number.is_value())
 && (single_value->field_locationNumber.is_omit() || single_value->field_locationNumber.is_value())
 && (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_omit() || single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_selectedLSA__Id.is_omit() || single_value->field_selectedLSA__Id.is_value())
 && (single_value->field_msc__Number.is_omit() || single_value->field_msc__Number.is_value())
 && (single_value->field_geodeticInformation.is_omit() || single_value->field_geodeticInformation.is_value())
 && (single_value->field_currentLocationRetrieved.is_omit() || single_value->field_currentLocationRetrieved.is_value())
 && (single_value->field_sai__Present.is_omit() || single_value->field_sai__Present.is_value())
 && (single_value->field_locationInformationEPS.is_omit() || single_value->field_locationInformationEPS.is_value())
 && (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_value());
}

void LocationInformation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LocationInformation LocationInformation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
LocationInformation ret_val;
if (single_value->field_ageOfLocationInformation.is_omit()) ret_val.ageOfLocationInformation() = OMIT_VALUE;
else if (single_value->field_ageOfLocationInformation.is_bound()) {
ret_val.ageOfLocationInformation() = single_value->field_ageOfLocationInformation.valueof();
}
if (single_value->field_geographicalInformation.is_omit()) ret_val.geographicalInformation() = OMIT_VALUE;
else if (single_value->field_geographicalInformation.is_bound()) {
ret_val.geographicalInformation() = single_value->field_geographicalInformation.valueof();
}
if (single_value->field_vlr__number.is_omit()) ret_val.vlr__number() = OMIT_VALUE;
else if (single_value->field_vlr__number.is_bound()) {
ret_val.vlr__number() = single_value->field_vlr__number.valueof();
}
if (single_value->field_locationNumber.is_omit()) ret_val.locationNumber() = OMIT_VALUE;
else if (single_value->field_locationNumber.is_bound()) {
ret_val.locationNumber() = single_value->field_locationNumber.valueof();
}
if (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_omit()) ret_val.cellGlobalIdOrServiceAreaIdOrLAI() = OMIT_VALUE;
else if (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_bound()) {
ret_val.cellGlobalIdOrServiceAreaIdOrLAI() = single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_selectedLSA__Id.is_omit()) ret_val.selectedLSA__Id() = OMIT_VALUE;
else if (single_value->field_selectedLSA__Id.is_bound()) {
ret_val.selectedLSA__Id() = single_value->field_selectedLSA__Id.valueof();
}
if (single_value->field_msc__Number.is_omit()) ret_val.msc__Number() = OMIT_VALUE;
else if (single_value->field_msc__Number.is_bound()) {
ret_val.msc__Number() = single_value->field_msc__Number.valueof();
}
if (single_value->field_geodeticInformation.is_omit()) ret_val.geodeticInformation() = OMIT_VALUE;
else if (single_value->field_geodeticInformation.is_bound()) {
ret_val.geodeticInformation() = single_value->field_geodeticInformation.valueof();
}
if (single_value->field_currentLocationRetrieved.is_omit()) ret_val.currentLocationRetrieved() = OMIT_VALUE;
else if (single_value->field_currentLocationRetrieved.is_bound()) {
ret_val.currentLocationRetrieved() = single_value->field_currentLocationRetrieved.valueof();
}
if (single_value->field_sai__Present.is_omit()) ret_val.sai__Present() = OMIT_VALUE;
else if (single_value->field_sai__Present.is_bound()) {
ret_val.sai__Present() = single_value->field_sai__Present.valueof();
}
if (single_value->field_locationInformationEPS.is_omit()) ret_val.locationInformationEPS() = OMIT_VALUE;
else if (single_value->field_locationInformationEPS.is_bound()) {
ret_val.locationInformationEPS() = single_value->field_locationInformationEPS.valueof();
}
if (single_value->field_userCSGInformation.is_omit()) ret_val.userCSGInformation() = OMIT_VALUE;
else if (single_value->field_userCSGInformation.is_bound()) {
ret_val.userCSGInformation() = single_value->field_userCSGInformation.valueof();
}
return ret_val;
}

void LocationInformation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.LocationInformation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LocationInformation_template[list_length];
}

LocationInformation_template& LocationInformation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.LocationInformation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.LocationInformation.");
return value_list.list_value[list_index];
}

INTEGER_template& LocationInformation_template::ageOfLocationInformation()
{
set_specific();
return single_value->field_ageOfLocationInformation;
}

const INTEGER_template& LocationInformation_template::ageOfLocationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ageOfLocationInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_ageOfLocationInformation;
}

OCTETSTRING_template& LocationInformation_template::geographicalInformation()
{
set_specific();
return single_value->field_geographicalInformation;
}

const OCTETSTRING_template& LocationInformation_template::geographicalInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geographicalInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_geographicalInformation;
}

OCTETSTRING_template& LocationInformation_template::vlr__number()
{
set_specific();
return single_value->field_vlr__number;
}

const OCTETSTRING_template& LocationInformation_template::vlr__number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vlr_number of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_vlr__number;
}

OCTETSTRING_template& LocationInformation_template::locationNumber()
{
set_specific();
return single_value->field_locationNumber;
}

const OCTETSTRING_template& LocationInformation_template::locationNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationNumber of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_locationNumber;
}

MAP__CommonDataTypes::CellGlobalIdOrServiceAreaIdOrLAI_template& LocationInformation_template::cellGlobalIdOrServiceAreaIdOrLAI()
{
set_specific();
return single_value->field_cellGlobalIdOrServiceAreaIdOrLAI;
}

const MAP__CommonDataTypes::CellGlobalIdOrServiceAreaIdOrLAI_template& LocationInformation_template::cellGlobalIdOrServiceAreaIdOrLAI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellGlobalIdOrServiceAreaIdOrLAI of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_cellGlobalIdOrServiceAreaIdOrLAI;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& LocationInformation_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& LocationInformation_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_extensionContainer;
}

OCTETSTRING_template& LocationInformation_template::selectedLSA__Id()
{
set_specific();
return single_value->field_selectedLSA__Id;
}

const OCTETSTRING_template& LocationInformation_template::selectedLSA__Id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field selectedLSA_Id of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_selectedLSA__Id;
}

OCTETSTRING_template& LocationInformation_template::msc__Number()
{
set_specific();
return single_value->field_msc__Number;
}

const OCTETSTRING_template& LocationInformation_template::msc__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msc_Number of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_msc__Number;
}

OCTETSTRING_template& LocationInformation_template::geodeticInformation()
{
set_specific();
return single_value->field_geodeticInformation;
}

const OCTETSTRING_template& LocationInformation_template::geodeticInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geodeticInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_geodeticInformation;
}

ASN_NULL_template& LocationInformation_template::currentLocationRetrieved()
{
set_specific();
return single_value->field_currentLocationRetrieved;
}

const ASN_NULL_template& LocationInformation_template::currentLocationRetrieved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field currentLocationRetrieved of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_currentLocationRetrieved;
}

ASN_NULL_template& LocationInformation_template::sai__Present()
{
set_specific();
return single_value->field_sai__Present;
}

const ASN_NULL_template& LocationInformation_template::sai__Present() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sai_Present of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_sai__Present;
}

LocationInformationEPS_template& LocationInformation_template::locationInformationEPS()
{
set_specific();
return single_value->field_locationInformationEPS;
}

const LocationInformationEPS_template& LocationInformation_template::locationInformationEPS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locationInformationEPS of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_locationInformationEPS;
}

UserCSGInformation_template& LocationInformation_template::userCSGInformation()
{
set_specific();
return single_value->field_userCSGInformation;
}

const UserCSGInformation_template& LocationInformation_template::userCSGInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userCSGInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformation.");
return single_value->field_userCSGInformation;
}

int LocationInformation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_ageOfLocationInformation.is_present()) ret_val++;
      if (single_value->field_geographicalInformation.is_present()) ret_val++;
      if (single_value->field_vlr__number.is_present()) ret_val++;
      if (single_value->field_locationNumber.is_present()) ret_val++;
      if (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_selectedLSA__Id.is_present()) ret_val++;
      if (single_value->field_msc__Number.is_present()) ret_val++;
      if (single_value->field_geodeticInformation.is_present()) ret_val++;
      if (single_value->field_currentLocationRetrieved.is_present()) ret_val++;
      if (single_value->field_sai__Present.is_present()) ret_val++;
      if (single_value->field_locationInformationEPS.is_present()) ret_val++;
      if (single_value->field_userCSGInformation.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformation.");
  }
  return 0;
}

void LocationInformation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ageOfLocationInformation := ");
single_value->field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(", geographicalInformation := ");
single_value->field_geographicalInformation.log();
TTCN_Logger::log_event_str(", vlr_number := ");
single_value->field_vlr__number.log();
TTCN_Logger::log_event_str(", locationNumber := ");
single_value->field_locationNumber.log();
TTCN_Logger::log_event_str(", cellGlobalIdOrServiceAreaIdOrLAI := ");
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", selectedLSA_Id := ");
single_value->field_selectedLSA__Id.log();
TTCN_Logger::log_event_str(", msc_Number := ");
single_value->field_msc__Number.log();
TTCN_Logger::log_event_str(", geodeticInformation := ");
single_value->field_geodeticInformation.log();
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
single_value->field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(", sai_Present := ");
single_value->field_sai__Present.log();
TTCN_Logger::log_event_str(", locationInformationEPS := ");
single_value->field_locationInformationEPS.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LocationInformation_template::log_match(const LocationInformation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.ageOfLocationInformation().ispresent()){
if(!single_value->field_ageOfLocationInformation.match(match_value.ageOfLocationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".ageOfLocationInformation");
single_value->field_ageOfLocationInformation.log_match(match_value.ageOfLocationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ageOfLocationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ageOfLocationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.geographicalInformation().ispresent()){
if(!single_value->field_geographicalInformation.match(match_value.geographicalInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".geographicalInformation");
single_value->field_geographicalInformation.log_match(match_value.geographicalInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_geographicalInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".geographicalInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_geographicalInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vlr__number().ispresent()){
if(!single_value->field_vlr__number.match(match_value.vlr__number(), legacy)){
TTCN_Logger::log_logmatch_info(".vlr_number");
single_value->field_vlr__number.log_match(match_value.vlr__number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vlr__number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vlr_number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vlr__number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.locationNumber().ispresent()){
if(!single_value->field_locationNumber.match(match_value.locationNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".locationNumber");
single_value->field_locationNumber.log_match(match_value.locationNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationNumber.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationNumber := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationNumber.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cellGlobalIdOrServiceAreaIdOrLAI().ispresent()){
if(!single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.match(match_value.cellGlobalIdOrServiceAreaIdOrLAI(), legacy)){
TTCN_Logger::log_logmatch_info(".cellGlobalIdOrServiceAreaIdOrLAI");
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.log_match(match_value.cellGlobalIdOrServiceAreaIdOrLAI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cellGlobalIdOrServiceAreaIdOrLAI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.selectedLSA__Id().ispresent()){
if(!single_value->field_selectedLSA__Id.match(match_value.selectedLSA__Id(), legacy)){
TTCN_Logger::log_logmatch_info(".selectedLSA_Id");
single_value->field_selectedLSA__Id.log_match(match_value.selectedLSA__Id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_selectedLSA__Id.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".selectedLSA_Id := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_selectedLSA__Id.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.msc__Number().ispresent()){
if(!single_value->field_msc__Number.match(match_value.msc__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".msc_Number");
single_value->field_msc__Number.log_match(match_value.msc__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_msc__Number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".msc_Number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_msc__Number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.geodeticInformation().ispresent()){
if(!single_value->field_geodeticInformation.match(match_value.geodeticInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".geodeticInformation");
single_value->field_geodeticInformation.log_match(match_value.geodeticInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_geodeticInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".geodeticInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_geodeticInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.currentLocationRetrieved().ispresent()){
if(!single_value->field_currentLocationRetrieved.match(match_value.currentLocationRetrieved(), legacy)){
TTCN_Logger::log_logmatch_info(".currentLocationRetrieved");
single_value->field_currentLocationRetrieved.log_match(match_value.currentLocationRetrieved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_currentLocationRetrieved.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".currentLocationRetrieved := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sai__Present().ispresent()){
if(!single_value->field_sai__Present.match(match_value.sai__Present(), legacy)){
TTCN_Logger::log_logmatch_info(".sai_Present");
single_value->field_sai__Present.log_match(match_value.sai__Present(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sai__Present.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sai_Present := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sai__Present.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.locationInformationEPS().ispresent()){
if(!single_value->field_locationInformationEPS.match(match_value.locationInformationEPS(), legacy)){
TTCN_Logger::log_logmatch_info(".locationInformationEPS");
single_value->field_locationInformationEPS.log_match(match_value.locationInformationEPS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_locationInformationEPS.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".locationInformationEPS := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_locationInformationEPS.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.userCSGInformation().ispresent()){
if(!single_value->field_userCSGInformation.match(match_value.userCSGInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".userCSGInformation");
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_userCSGInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".userCSGInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ageOfLocationInformation := ");
if (match_value.ageOfLocationInformation().ispresent()) {
single_value->field_ageOfLocationInformation.log_match(match_value.ageOfLocationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ageOfLocationInformation.log();
if (single_value->field_ageOfLocationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", geographicalInformation := ");
if (match_value.geographicalInformation().ispresent()) {
single_value->field_geographicalInformation.log_match(match_value.geographicalInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_geographicalInformation.log();
if (single_value->field_geographicalInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vlr_number := ");
if (match_value.vlr__number().ispresent()) {
single_value->field_vlr__number.log_match(match_value.vlr__number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vlr__number.log();
if (single_value->field_vlr__number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", locationNumber := ");
if (match_value.locationNumber().ispresent()) {
single_value->field_locationNumber.log_match(match_value.locationNumber(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationNumber.log();
if (single_value->field_locationNumber.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cellGlobalIdOrServiceAreaIdOrLAI := ");
if (match_value.cellGlobalIdOrServiceAreaIdOrLAI().ispresent()) {
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.log_match(match_value.cellGlobalIdOrServiceAreaIdOrLAI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.log();
if (single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", selectedLSA_Id := ");
if (match_value.selectedLSA__Id().ispresent()) {
single_value->field_selectedLSA__Id.log_match(match_value.selectedLSA__Id(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_selectedLSA__Id.log();
if (single_value->field_selectedLSA__Id.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", msc_Number := ");
if (match_value.msc__Number().ispresent()) {
single_value->field_msc__Number.log_match(match_value.msc__Number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_msc__Number.log();
if (single_value->field_msc__Number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", geodeticInformation := ");
if (match_value.geodeticInformation().ispresent()) {
single_value->field_geodeticInformation.log_match(match_value.geodeticInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_geodeticInformation.log();
if (single_value->field_geodeticInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
if (match_value.currentLocationRetrieved().ispresent()) {
single_value->field_currentLocationRetrieved.log_match(match_value.currentLocationRetrieved(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_currentLocationRetrieved.log();
if (single_value->field_currentLocationRetrieved.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sai_Present := ");
if (match_value.sai__Present().ispresent()) {
single_value->field_sai__Present.log_match(match_value.sai__Present(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sai__Present.log();
if (single_value->field_sai__Present.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", locationInformationEPS := ");
if (match_value.locationInformationEPS().ispresent()) {
single_value->field_locationInformationEPS.log_match(match_value.locationInformationEPS(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_locationInformationEPS.log();
if (single_value->field_locationInformationEPS.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", userCSGInformation := ");
if (match_value.userCSGInformation().ispresent()) {
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_userCSGInformation.log();
if (single_value->field_userCSGInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LocationInformation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!ageOfLocationInformation().is_bound()) ageOfLocationInformation() = OMIT_VALUE;
else ageOfLocationInformation().set_implicit_omit();
if (!geographicalInformation().is_bound()) geographicalInformation() = OMIT_VALUE;
else geographicalInformation().set_implicit_omit();
if (!vlr__number().is_bound()) vlr__number() = OMIT_VALUE;
else vlr__number().set_implicit_omit();
if (!locationNumber().is_bound()) locationNumber() = OMIT_VALUE;
else locationNumber().set_implicit_omit();
if (!cellGlobalIdOrServiceAreaIdOrLAI().is_bound()) cellGlobalIdOrServiceAreaIdOrLAI() = OMIT_VALUE;
else cellGlobalIdOrServiceAreaIdOrLAI().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!selectedLSA__Id().is_bound()) selectedLSA__Id() = OMIT_VALUE;
else selectedLSA__Id().set_implicit_omit();
if (!msc__Number().is_bound()) msc__Number() = OMIT_VALUE;
else msc__Number().set_implicit_omit();
if (!geodeticInformation().is_bound()) geodeticInformation() = OMIT_VALUE;
else geodeticInformation().set_implicit_omit();
if (!currentLocationRetrieved().is_bound()) currentLocationRetrieved() = OMIT_VALUE;
else currentLocationRetrieved().set_implicit_omit();
if (!sai__Present().is_bound()) sai__Present() = OMIT_VALUE;
else sai__Present().set_implicit_omit();
if (!locationInformationEPS().is_bound()) locationInformationEPS() = OMIT_VALUE;
else locationInformationEPS().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
}

void LocationInformation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ageOfLocationInformation.encode_text(text_buf);
single_value->field_geographicalInformation.encode_text(text_buf);
single_value->field_vlr__number.encode_text(text_buf);
single_value->field_locationNumber.encode_text(text_buf);
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_selectedLSA__Id.encode_text(text_buf);
single_value->field_msc__Number.encode_text(text_buf);
single_value->field_geodeticInformation.encode_text(text_buf);
single_value->field_currentLocationRetrieved.encode_text(text_buf);
single_value->field_sai__Present.encode_text(text_buf);
single_value->field_locationInformationEPS.encode_text(text_buf);
single_value->field_userCSGInformation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformation.");
}
}

void LocationInformation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ageOfLocationInformation.decode_text(text_buf);
single_value->field_geographicalInformation.decode_text(text_buf);
single_value->field_vlr__number.decode_text(text_buf);
single_value->field_locationNumber.decode_text(text_buf);
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_selectedLSA__Id.decode_text(text_buf);
single_value->field_msc__Number.decode_text(text_buf);
single_value->field_geodeticInformation.decode_text(text_buf);
single_value->field_currentLocationRetrieved.decode_text(text_buf);
single_value->field_sai__Present.decode_text(text_buf);
single_value->field_locationInformationEPS.decode_text(text_buf);
single_value->field_userCSGInformation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LocationInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.LocationInformation.");
}
}

void LocationInformation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LocationInformation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (13<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.LocationInformation has 13 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ageOfLocationInformation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) geographicalInformation().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) vlr__number().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locationNumber().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellGlobalIdOrServiceAreaIdOrLAI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) selectedLSA__Id().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) msc__Number().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) geodeticInformation().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) currentLocationRetrieved().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sai__Present().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) locationInformationEPS().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(12));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ageOfLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ageOfLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellGlobalIdOrServiceAreaIdOrLAI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellGlobalIdOrServiceAreaIdOrLAI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "selectedLSA_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          selectedLSA__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msc_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msc__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geodeticInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geodeticInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocationRetrieved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocationRetrieved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sai_Present")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sai__Present().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locationInformationEPS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locationInformationEPS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.LocationInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LocationInformation_template* precondition = new LocationInformation_template;
    precondition->set_param(*param.get_elem(0));
    LocationInformation_template* implied_template = new LocationInformation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LocationInformation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.LocationInformation");
  }
  is_ifpresent = param.get_ifpresent();
}

void LocationInformation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ageOfLocationInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_geographicalInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_vlr__number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_locationNumber.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_cellGlobalIdOrServiceAreaIdOrLAI.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_selectedLSA__Id.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_msc__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_geodeticInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_currentLocationRetrieved.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_sai__Present.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_locationInformationEPS.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
single_value->field_userCSGInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.LocationInformation");
}

boolean LocationInformation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LocationInformation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LocationInformationEPS::LocationInformationEPS()
{
}

LocationInformationEPS::LocationInformationEPS(const OPTIONAL< OCTETSTRING >& par_e__utranCellGlobalIdentity,
    const OPTIONAL< OCTETSTRING >& par_trackingAreaIdentity,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< OCTETSTRING >& par_geographicalInformation,
    const OPTIONAL< OCTETSTRING >& par_geodeticInformation,
    const OPTIONAL< ASN_NULL >& par_currentLocationRetrieved,
    const OPTIONAL< INTEGER >& par_ageOfLocationInformation,
    const OPTIONAL< OCTETSTRING >& par_mme__Name)
  :   field_e__utranCellGlobalIdentity(par_e__utranCellGlobalIdentity),
  field_trackingAreaIdentity(par_trackingAreaIdentity),
  field_extensionContainer(par_extensionContainer),
  field_geographicalInformation(par_geographicalInformation),
  field_geodeticInformation(par_geodeticInformation),
  field_currentLocationRetrieved(par_currentLocationRetrieved),
  field_ageOfLocationInformation(par_ageOfLocationInformation),
  field_mme__Name(par_mme__Name)
{
}

LocationInformationEPS::LocationInformationEPS(const LocationInformationEPS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.LocationInformationEPS.");
if (other_value.e__utranCellGlobalIdentity().is_bound()) field_e__utranCellGlobalIdentity = other_value.e__utranCellGlobalIdentity();
else field_e__utranCellGlobalIdentity.clean_up();
if (other_value.trackingAreaIdentity().is_bound()) field_trackingAreaIdentity = other_value.trackingAreaIdentity();
else field_trackingAreaIdentity.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.geographicalInformation().is_bound()) field_geographicalInformation = other_value.geographicalInformation();
else field_geographicalInformation.clean_up();
if (other_value.geodeticInformation().is_bound()) field_geodeticInformation = other_value.geodeticInformation();
else field_geodeticInformation.clean_up();
if (other_value.currentLocationRetrieved().is_bound()) field_currentLocationRetrieved = other_value.currentLocationRetrieved();
else field_currentLocationRetrieved.clean_up();
if (other_value.ageOfLocationInformation().is_bound()) field_ageOfLocationInformation = other_value.ageOfLocationInformation();
else field_ageOfLocationInformation.clean_up();
if (other_value.mme__Name().is_bound()) field_mme__Name = other_value.mme__Name();
else field_mme__Name.clean_up();
}

void LocationInformationEPS::clean_up()
{
field_e__utranCellGlobalIdentity.clean_up();
field_trackingAreaIdentity.clean_up();
field_extensionContainer.clean_up();
field_geographicalInformation.clean_up();
field_geodeticInformation.clean_up();
field_currentLocationRetrieved.clean_up();
field_ageOfLocationInformation.clean_up();
field_mme__Name.clean_up();
}

const TTCN_Typedescriptor_t* LocationInformationEPS::get_descriptor() const { return &LocationInformationEPS_descr_; }
LocationInformationEPS& LocationInformationEPS::operator=(const LocationInformationEPS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.LocationInformationEPS.");
  if (other_value.e__utranCellGlobalIdentity().is_bound()) field_e__utranCellGlobalIdentity = other_value.e__utranCellGlobalIdentity();
  else field_e__utranCellGlobalIdentity.clean_up();
  if (other_value.trackingAreaIdentity().is_bound()) field_trackingAreaIdentity = other_value.trackingAreaIdentity();
  else field_trackingAreaIdentity.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.geographicalInformation().is_bound()) field_geographicalInformation = other_value.geographicalInformation();
  else field_geographicalInformation.clean_up();
  if (other_value.geodeticInformation().is_bound()) field_geodeticInformation = other_value.geodeticInformation();
  else field_geodeticInformation.clean_up();
  if (other_value.currentLocationRetrieved().is_bound()) field_currentLocationRetrieved = other_value.currentLocationRetrieved();
  else field_currentLocationRetrieved.clean_up();
  if (other_value.ageOfLocationInformation().is_bound()) field_ageOfLocationInformation = other_value.ageOfLocationInformation();
  else field_ageOfLocationInformation.clean_up();
  if (other_value.mme__Name().is_bound()) field_mme__Name = other_value.mme__Name();
  else field_mme__Name.clean_up();
}
return *this;
}

boolean LocationInformationEPS::operator==(const LocationInformationEPS& other_value) const
{
return field_e__utranCellGlobalIdentity==other_value.field_e__utranCellGlobalIdentity
  && field_trackingAreaIdentity==other_value.field_trackingAreaIdentity
  && field_extensionContainer==other_value.field_extensionContainer
  && field_geographicalInformation==other_value.field_geographicalInformation
  && field_geodeticInformation==other_value.field_geodeticInformation
  && field_currentLocationRetrieved==other_value.field_currentLocationRetrieved
  && field_ageOfLocationInformation==other_value.field_ageOfLocationInformation
  && field_mme__Name==other_value.field_mme__Name;
}

boolean LocationInformationEPS::is_bound() const
{
return (OPTIONAL_OMIT == field_e__utranCellGlobalIdentity.get_selection() || field_e__utranCellGlobalIdentity.is_bound())
  || (OPTIONAL_OMIT == field_trackingAreaIdentity.get_selection() || field_trackingAreaIdentity.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_geographicalInformation.get_selection() || field_geographicalInformation.is_bound())
  || (OPTIONAL_OMIT == field_geodeticInformation.get_selection() || field_geodeticInformation.is_bound())
  || (OPTIONAL_OMIT == field_currentLocationRetrieved.get_selection() || field_currentLocationRetrieved.is_bound())
  || (OPTIONAL_OMIT == field_ageOfLocationInformation.get_selection() || field_ageOfLocationInformation.is_bound())
  || (OPTIONAL_OMIT == field_mme__Name.get_selection() || field_mme__Name.is_bound());
}
boolean LocationInformationEPS::is_value() const
{
return (OPTIONAL_OMIT == field_e__utranCellGlobalIdentity.get_selection() || field_e__utranCellGlobalIdentity.is_value())
  && (OPTIONAL_OMIT == field_trackingAreaIdentity.get_selection() || field_trackingAreaIdentity.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_geographicalInformation.get_selection() || field_geographicalInformation.is_value())
  && (OPTIONAL_OMIT == field_geodeticInformation.get_selection() || field_geodeticInformation.is_value())
  && (OPTIONAL_OMIT == field_currentLocationRetrieved.get_selection() || field_currentLocationRetrieved.is_value())
  && (OPTIONAL_OMIT == field_ageOfLocationInformation.get_selection() || field_ageOfLocationInformation.is_value())
  && (OPTIONAL_OMIT == field_mme__Name.get_selection() || field_mme__Name.is_value());
}
int LocationInformationEPS::size_of() const
{
  int ret_val = 0;
  if (field_e__utranCellGlobalIdentity.ispresent()) ret_val++;
  if (field_trackingAreaIdentity.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_geographicalInformation.ispresent()) ret_val++;
  if (field_geodeticInformation.ispresent()) ret_val++;
  if (field_currentLocationRetrieved.ispresent()) ret_val++;
  if (field_ageOfLocationInformation.ispresent()) ret_val++;
  if (field_mme__Name.ispresent()) ret_val++;
  return ret_val;
}

void LocationInformationEPS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ e_utranCellGlobalIdentity := ");
field_e__utranCellGlobalIdentity.log();
TTCN_Logger::log_event_str(", trackingAreaIdentity := ");
field_trackingAreaIdentity.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", geographicalInformation := ");
field_geographicalInformation.log();
TTCN_Logger::log_event_str(", geodeticInformation := ");
field_geodeticInformation.log();
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(", ageOfLocationInformation := ");
field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(", mme_Name := ");
field_mme__Name.log();
TTCN_Logger::log_event_str(" }");
}

void LocationInformationEPS::set_implicit_omit()
{
if (!e__utranCellGlobalIdentity().is_bound()) e__utranCellGlobalIdentity() = OMIT_VALUE;
else e__utranCellGlobalIdentity().set_implicit_omit();
if (!trackingAreaIdentity().is_bound()) trackingAreaIdentity() = OMIT_VALUE;
else trackingAreaIdentity().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!geographicalInformation().is_bound()) geographicalInformation() = OMIT_VALUE;
else geographicalInformation().set_implicit_omit();
if (!geodeticInformation().is_bound()) geodeticInformation() = OMIT_VALUE;
else geodeticInformation().set_implicit_omit();
if (!currentLocationRetrieved().is_bound()) currentLocationRetrieved() = OMIT_VALUE;
else currentLocationRetrieved().set_implicit_omit();
if (!ageOfLocationInformation().is_bound()) ageOfLocationInformation() = OMIT_VALUE;
else ageOfLocationInformation().set_implicit_omit();
if (!mme__Name().is_bound()) mme__Name() = OMIT_VALUE;
else mme__Name().set_implicit_omit();
}

void LocationInformationEPS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.LocationInformationEPS has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) e__utranCellGlobalIdentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) trackingAreaIdentity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) geographicalInformation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) geodeticInformation().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) currentLocationRetrieved().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ageOfLocationInformation().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mme__Name().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "e_utranCellGlobalIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          e__utranCellGlobalIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trackingAreaIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trackingAreaIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geodeticInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geodeticInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocationRetrieved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocationRetrieved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ageOfLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ageOfLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mme_Name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mme__Name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.LocationInformationEPS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.LocationInformationEPS");
  }
}

void LocationInformationEPS::encode_text(Text_Buf& text_buf) const
{
field_e__utranCellGlobalIdentity.encode_text(text_buf);
field_trackingAreaIdentity.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_geographicalInformation.encode_text(text_buf);
field_geodeticInformation.encode_text(text_buf);
field_currentLocationRetrieved.encode_text(text_buf);
field_ageOfLocationInformation.encode_text(text_buf);
field_mme__Name.encode_text(text_buf);
}

void LocationInformationEPS::decode_text(Text_Buf& text_buf)
{
field_e__utranCellGlobalIdentity.decode_text(text_buf);
field_trackingAreaIdentity.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_geographicalInformation.decode_text(text_buf);
field_geodeticInformation.decode_text(text_buf);
field_currentLocationRetrieved.decode_text(text_buf);
field_ageOfLocationInformation.decode_text(text_buf);
field_mme__Name.decode_text(text_buf);
}

void LocationInformationEPS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LocationInformationEPS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* LocationInformationEPS::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("e_utranCellGlobalIdentity': ");
  new_tlv->add_TLV(field_e__utranCellGlobalIdentity.BER_encode_TLV(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_coding));
  ec_1.set_msg("trackingAreaIdentity': ");
  new_tlv->add_TLV(field_trackingAreaIdentity.BER_encode_TLV(LocationInformationEPS_trackingAreaIdentity_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(LocationInformationEPS_extensionContainer_descr_, p_coding));
  ec_1.set_msg("geographicalInformation': ");
  new_tlv->add_TLV(field_geographicalInformation.BER_encode_TLV(LocationInformationEPS_geographicalInformation_descr_, p_coding));
  ec_1.set_msg("geodeticInformation': ");
  new_tlv->add_TLV(field_geodeticInformation.BER_encode_TLV(LocationInformationEPS_geodeticInformation_descr_, p_coding));
  ec_1.set_msg("currentLocationRetrieved': ");
  new_tlv->add_TLV(field_currentLocationRetrieved.BER_encode_TLV(LocationInformationEPS_currentLocationRetrieved_descr_, p_coding));
  ec_1.set_msg("ageOfLocationInformation': ");
  new_tlv->add_TLV(field_ageOfLocationInformation.BER_encode_TLV(LocationInformationEPS_ageOfLocationInformation_descr_, p_coding));
  ec_1.set_msg("mme_Name': ");
  new_tlv->add_TLV(field_mme__Name.BER_encode_TLV(LocationInformationEPS_mme__Name_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean LocationInformationEPS::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.LocationInformationEPS' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("e_utranCellGlobalIdentity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_e__utranCellGlobalIdentity=OMIT_VALUE;
    else {
      field_e__utranCellGlobalIdentity.BER_decode_TLV(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, tmp_tlv, L_form);
      if(field_e__utranCellGlobalIdentity.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("trackingAreaIdentity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_trackingAreaIdentity=OMIT_VALUE;
    else {
      field_trackingAreaIdentity.BER_decode_TLV(LocationInformationEPS_trackingAreaIdentity_descr_, tmp_tlv, L_form);
      if(field_trackingAreaIdentity.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(LocationInformationEPS_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("geographicalInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_geographicalInformation=OMIT_VALUE;
    else {
      field_geographicalInformation.BER_decode_TLV(LocationInformationEPS_geographicalInformation_descr_, tmp_tlv, L_form);
      if(field_geographicalInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("geodeticInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_geodeticInformation=OMIT_VALUE;
    else {
      field_geodeticInformation.BER_decode_TLV(LocationInformationEPS_geodeticInformation_descr_, tmp_tlv, L_form);
      if(field_geodeticInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("currentLocationRetrieved': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_currentLocationRetrieved=OMIT_VALUE;
    else {
      field_currentLocationRetrieved.BER_decode_TLV(LocationInformationEPS_currentLocationRetrieved_descr_, tmp_tlv, L_form);
      if(field_currentLocationRetrieved.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ageOfLocationInformation': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ageOfLocationInformation=OMIT_VALUE;
    else {
      field_ageOfLocationInformation.BER_decode_TLV(LocationInformationEPS_ageOfLocationInformation_descr_, tmp_tlv, L_form);
      if(field_ageOfLocationInformation.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("mme_Name': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_mme__Name=OMIT_VALUE;
    else {
      field_mme__Name.BER_decode_TLV(LocationInformationEPS_mme__Name_descr_, tmp_tlv, L_form);
      if(field_mme__Name.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int LocationInformationEPS::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.LocationInformationEPS.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_e__utranCellGlobalIdentity.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "e_utranCellGlobalIdentity");
    enc_len += field_e__utranCellGlobalIdentity.JSON_encode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_tok, FALSE);
  }

  if (field_trackingAreaIdentity.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "trackingAreaIdentity");
    enc_len += field_trackingAreaIdentity.JSON_encode(LocationInformationEPS_trackingAreaIdentity_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(LocationInformationEPS_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_geographicalInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geographicalInformation");
    enc_len += field_geographicalInformation.JSON_encode(LocationInformationEPS_geographicalInformation_descr_, p_tok, FALSE);
  }

  if (field_geodeticInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geodeticInformation");
    enc_len += field_geodeticInformation.JSON_encode(LocationInformationEPS_geodeticInformation_descr_, p_tok, FALSE);
  }

  if (field_currentLocationRetrieved.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "currentLocationRetrieved");
    enc_len += field_currentLocationRetrieved.JSON_encode(LocationInformationEPS_currentLocationRetrieved_descr_, p_tok, FALSE);
  }

  if (field_ageOfLocationInformation.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ageOfLocationInformation");
    enc_len += field_ageOfLocationInformation.JSON_encode(LocationInformationEPS_ageOfLocationInformation_descr_, p_tok, FALSE);
  }

  if (field_mme__Name.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "mme_Name");
    enc_len += field_mme__Name.JSON_encode(LocationInformationEPS_mme__Name_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int LocationInformationEPS::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const LocationInformationEPS*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean e__utranCellGlobalIdentity_found = FALSE;
  boolean trackingAreaIdentity_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean geographicalInformation_found = FALSE;
  boolean geodeticInformation_found = FALSE;
  boolean currentLocationRetrieved_found = FALSE;
  boolean ageOfLocationInformation_found = FALSE;
  boolean mme__Name_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (25 == name_len && 0 == strncmp(fld_name, "e_utranCellGlobalIdentity", name_len)) {
        e__utranCellGlobalIdentity_found = TRUE;
         int ret_val = field_e__utranCellGlobalIdentity.JSON_decode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 25, "e_utranCellGlobalIdentity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (20 == name_len && 0 == strncmp(fld_name, "trackingAreaIdentity", name_len)) {
        trackingAreaIdentity_found = TRUE;
         int ret_val = field_trackingAreaIdentity.JSON_decode(LocationInformationEPS_trackingAreaIdentity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "trackingAreaIdentity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(LocationInformationEPS_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (23 == name_len && 0 == strncmp(fld_name, "geographicalInformation", name_len)) {
        geographicalInformation_found = TRUE;
         int ret_val = field_geographicalInformation.JSON_decode(LocationInformationEPS_geographicalInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "geographicalInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "geodeticInformation", name_len)) {
        geodeticInformation_found = TRUE;
         int ret_val = field_geodeticInformation.JSON_decode(LocationInformationEPS_geodeticInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "geodeticInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (24 == name_len && 0 == strncmp(fld_name, "currentLocationRetrieved", name_len)) {
        currentLocationRetrieved_found = TRUE;
         int ret_val = field_currentLocationRetrieved.JSON_decode(LocationInformationEPS_currentLocationRetrieved_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "currentLocationRetrieved");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (24 == name_len && 0 == strncmp(fld_name, "ageOfLocationInformation", name_len)) {
        ageOfLocationInformation_found = TRUE;
         int ret_val = field_ageOfLocationInformation.JSON_decode(LocationInformationEPS_ageOfLocationInformation_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "ageOfLocationInformation");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "mme_Name", name_len)) {
        mme__Name_found = TRUE;
         int ret_val = field_mme__Name.JSON_decode(LocationInformationEPS_mme__Name_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "mme_Name");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!e__utranCellGlobalIdentity_found) {
    field_e__utranCellGlobalIdentity = OMIT_VALUE;
  }
  if (!trackingAreaIdentity_found) {
    field_trackingAreaIdentity = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!geographicalInformation_found) {
    field_geographicalInformation = OMIT_VALUE;
  }
  if (!geodeticInformation_found) {
    field_geodeticInformation = OMIT_VALUE;
  }
  if (!currentLocationRetrieved_found) {
    field_currentLocationRetrieved = OMIT_VALUE;
  }
  if (!ageOfLocationInformation_found) {
    field_ageOfLocationInformation = OMIT_VALUE;
  }
  if (!mme__Name_found) {
    field_mme__Name = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int LocationInformationEPS::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_mme__Name.is_bound() && field_mme__Name.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_e__utranCellGlobalIdentity.is_present()) {
    c |= 64;
  }
  if (field_trackingAreaIdentity.is_present()) {
    c |= 32;
  }
  if (field_extensionContainer.is_present()) {
    c |= 16;
  }
  if (field_geographicalInformation.is_present()) {
    c |= 8;
  }
  if (field_geodeticInformation.is_present()) {
    c |= 4;
  }
  if (field_currentLocationRetrieved.is_present()) {
    c |= 2;
  }
  if (field_ageOfLocationInformation.is_present()) {
    c |= 1;
  }
  p_buf.put_c(c);
  c = 0
;  if (field_e__utranCellGlobalIdentity.is_present())
    field_e__utranCellGlobalIdentity.OER_encode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_buf);
  if (field_trackingAreaIdentity.is_present())
    field_trackingAreaIdentity.OER_encode(LocationInformationEPS_trackingAreaIdentity_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(LocationInformationEPS_extensionContainer_descr_, p_buf);
  if (field_geographicalInformation.is_present())
    field_geographicalInformation.OER_encode(LocationInformationEPS_geographicalInformation_descr_, p_buf);
  if (field_geodeticInformation.is_present())
    field_geodeticInformation.OER_encode(LocationInformationEPS_geodeticInformation_descr_, p_buf);
  if (field_currentLocationRetrieved.is_present())
    field_currentLocationRetrieved.OER_encode(LocationInformationEPS_currentLocationRetrieved_descr_, p_buf);
  if (field_ageOfLocationInformation.is_present())
    field_ageOfLocationInformation.OER_encode(LocationInformationEPS_ageOfLocationInformation_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_mme__Name.is_present()) {
      c |= 128;
      field_mme__Name.OER_encode(LocationInformationEPS_mme__Name_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(7);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int LocationInformationEPS::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_e__utranCellGlobalIdentity.OER_decode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_buf, p_oer);
 else
    field_e__utranCellGlobalIdentity = OMIT_VALUE;
  if (uc[0] & 32)
    field_trackingAreaIdentity.OER_decode(LocationInformationEPS_trackingAreaIdentity_descr_, p_buf, p_oer);
 else
    field_trackingAreaIdentity = OMIT_VALUE;
  if (uc[0] & 16)
    field_extensionContainer.OER_decode(LocationInformationEPS_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (uc[0] & 8)
    field_geographicalInformation.OER_decode(LocationInformationEPS_geographicalInformation_descr_, p_buf, p_oer);
 else
    field_geographicalInformation = OMIT_VALUE;
  if (uc[0] & 4)
    field_geodeticInformation.OER_decode(LocationInformationEPS_geodeticInformation_descr_, p_buf, p_oer);
 else
    field_geodeticInformation = OMIT_VALUE;
  if (uc[0] & 2)
    field_currentLocationRetrieved.OER_decode(LocationInformationEPS_currentLocationRetrieved_descr_, p_buf, p_oer);
 else
    field_currentLocationRetrieved = OMIT_VALUE;
  if (uc[0] & 1)
    field_ageOfLocationInformation.OER_decode(LocationInformationEPS_ageOfLocationInformation_descr_, p_buf, p_oer);
 else
    field_ageOfLocationInformation = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_mme__Name = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_mme__Name.OER_decode(LocationInformationEPS_mme__Name_descr_, p_buf, p_oer);
    }
  }
  else {
    field_mme__Name = OMIT_VALUE;
  }
  return 0;
}

void LocationInformationEPS::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_mme__Name.is_present();
boolean ext_bit = ext_0_present;
p_buf.PER_put_bit(ext_bit);
boolean field_e__utranCellGlobalIdentity_present = field_e__utranCellGlobalIdentity.is_present();
p_buf.PER_put_bit(field_e__utranCellGlobalIdentity_present);
boolean field_trackingAreaIdentity_present = field_trackingAreaIdentity.is_present();
p_buf.PER_put_bit(field_trackingAreaIdentity_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
boolean field_geographicalInformation_present = field_geographicalInformation.is_present();
p_buf.PER_put_bit(field_geographicalInformation_present);
boolean field_geodeticInformation_present = field_geodeticInformation.is_present();
p_buf.PER_put_bit(field_geodeticInformation_present);
boolean field_currentLocationRetrieved_present = field_currentLocationRetrieved.is_present();
p_buf.PER_put_bit(field_currentLocationRetrieved_present);
boolean field_ageOfLocationInformation_present = field_ageOfLocationInformation.is_present();
p_buf.PER_put_bit(field_ageOfLocationInformation_present);
if (field_e__utranCellGlobalIdentity_present) field_e__utranCellGlobalIdentity.PER_encode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_buf, p_options);
if (field_trackingAreaIdentity_present) field_trackingAreaIdentity.PER_encode(LocationInformationEPS_trackingAreaIdentity_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(LocationInformationEPS_extensionContainer_descr_, p_buf, p_options);
if (field_geographicalInformation_present) field_geographicalInformation.PER_encode(LocationInformationEPS_geographicalInformation_descr_, p_buf, p_options);
if (field_geodeticInformation_present) field_geodeticInformation.PER_encode(LocationInformationEPS_geodeticInformation_descr_, p_buf, p_options);
if (field_currentLocationRetrieved_present) field_currentLocationRetrieved.PER_encode(LocationInformationEPS_currentLocationRetrieved_descr_, p_buf, p_options);
if (field_ageOfLocationInformation_present) field_ageOfLocationInformation.PER_encode(LocationInformationEPS_ageOfLocationInformation_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(1);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_mme__Name.PER_encode(LocationInformationEPS_mme__Name_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void LocationInformationEPS::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_e__utranCellGlobalIdentity_present = p_buf.PER_get_bit();
boolean field_trackingAreaIdentity_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
boolean field_geographicalInformation_present = p_buf.PER_get_bit();
boolean field_geodeticInformation_present = p_buf.PER_get_bit();
boolean field_currentLocationRetrieved_present = p_buf.PER_get_bit();
boolean field_ageOfLocationInformation_present = p_buf.PER_get_bit();
if (field_e__utranCellGlobalIdentity_present) field_e__utranCellGlobalIdentity.PER_decode(LocationInformationEPS_e__utranCellGlobalIdentity_descr_, p_buf, p_options);
else field_e__utranCellGlobalIdentity = OMIT_VALUE;
if (field_trackingAreaIdentity_present) field_trackingAreaIdentity.PER_decode(LocationInformationEPS_trackingAreaIdentity_descr_, p_buf, p_options);
else field_trackingAreaIdentity = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(LocationInformationEPS_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
if (field_geographicalInformation_present) field_geographicalInformation.PER_decode(LocationInformationEPS_geographicalInformation_descr_, p_buf, p_options);
else field_geographicalInformation = OMIT_VALUE;
if (field_geodeticInformation_present) field_geodeticInformation.PER_decode(LocationInformationEPS_geodeticInformation_descr_, p_buf, p_options);
else field_geodeticInformation = OMIT_VALUE;
if (field_currentLocationRetrieved_present) field_currentLocationRetrieved.PER_decode(LocationInformationEPS_currentLocationRetrieved_descr_, p_buf, p_options);
else field_currentLocationRetrieved = OMIT_VALUE;
if (field_ageOfLocationInformation_present) field_ageOfLocationInformation.PER_decode(LocationInformationEPS_ageOfLocationInformation_descr_, p_buf, p_options);
else field_ageOfLocationInformation = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 1) {
for (int i = nof_decoded_ext_adds; i < 1; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_mme__Name.PER_decode(LocationInformationEPS_mme__Name_descr_, ext_add_buf, p_options);
}
else {
field_mme__Name = OMIT_VALUE;
}
for (int i = 1; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct LocationInformationEPS_template::single_value_struct {
OCTETSTRING_template field_e__utranCellGlobalIdentity;
OCTETSTRING_template field_trackingAreaIdentity;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
OCTETSTRING_template field_geographicalInformation;
OCTETSTRING_template field_geodeticInformation;
ASN_NULL_template field_currentLocationRetrieved;
INTEGER_template field_ageOfLocationInformation;
OCTETSTRING_template field_mme__Name;
};

void LocationInformationEPS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_e__utranCellGlobalIdentity = ANY_OR_OMIT;
single_value->field_trackingAreaIdentity = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_geographicalInformation = ANY_OR_OMIT;
single_value->field_geodeticInformation = ANY_OR_OMIT;
single_value->field_currentLocationRetrieved = ANY_OR_OMIT;
single_value->field_ageOfLocationInformation = ANY_OR_OMIT;
single_value->field_mme__Name = ANY_OR_OMIT;
}
}
}

void LocationInformationEPS_template::copy_value(const LocationInformationEPS& other_value)
{
single_value = new single_value_struct;
if (other_value.e__utranCellGlobalIdentity().is_bound()) {
  if (other_value.e__utranCellGlobalIdentity().ispresent()) single_value->field_e__utranCellGlobalIdentity = other_value.e__utranCellGlobalIdentity()();
  else single_value->field_e__utranCellGlobalIdentity = OMIT_VALUE;
} else {
  single_value->field_e__utranCellGlobalIdentity.clean_up();
}
if (other_value.trackingAreaIdentity().is_bound()) {
  if (other_value.trackingAreaIdentity().ispresent()) single_value->field_trackingAreaIdentity = other_value.trackingAreaIdentity()();
  else single_value->field_trackingAreaIdentity = OMIT_VALUE;
} else {
  single_value->field_trackingAreaIdentity.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.geographicalInformation().is_bound()) {
  if (other_value.geographicalInformation().ispresent()) single_value->field_geographicalInformation = other_value.geographicalInformation()();
  else single_value->field_geographicalInformation = OMIT_VALUE;
} else {
  single_value->field_geographicalInformation.clean_up();
}
if (other_value.geodeticInformation().is_bound()) {
  if (other_value.geodeticInformation().ispresent()) single_value->field_geodeticInformation = other_value.geodeticInformation()();
  else single_value->field_geodeticInformation = OMIT_VALUE;
} else {
  single_value->field_geodeticInformation.clean_up();
}
if (other_value.currentLocationRetrieved().is_bound()) {
  if (other_value.currentLocationRetrieved().ispresent()) single_value->field_currentLocationRetrieved = other_value.currentLocationRetrieved()();
  else single_value->field_currentLocationRetrieved = OMIT_VALUE;
} else {
  single_value->field_currentLocationRetrieved.clean_up();
}
if (other_value.ageOfLocationInformation().is_bound()) {
  if (other_value.ageOfLocationInformation().ispresent()) single_value->field_ageOfLocationInformation = other_value.ageOfLocationInformation()();
  else single_value->field_ageOfLocationInformation = OMIT_VALUE;
} else {
  single_value->field_ageOfLocationInformation.clean_up();
}
if (other_value.mme__Name().is_bound()) {
  if (other_value.mme__Name().ispresent()) single_value->field_mme__Name = other_value.mme__Name()();
  else single_value->field_mme__Name = OMIT_VALUE;
} else {
  single_value->field_mme__Name.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LocationInformationEPS_template::copy_template(const LocationInformationEPS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.e__utranCellGlobalIdentity().get_selection()) {
single_value->field_e__utranCellGlobalIdentity = other_value.e__utranCellGlobalIdentity();
} else {
single_value->field_e__utranCellGlobalIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trackingAreaIdentity().get_selection()) {
single_value->field_trackingAreaIdentity = other_value.trackingAreaIdentity();
} else {
single_value->field_trackingAreaIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.geographicalInformation().get_selection()) {
single_value->field_geographicalInformation = other_value.geographicalInformation();
} else {
single_value->field_geographicalInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.geodeticInformation().get_selection()) {
single_value->field_geodeticInformation = other_value.geodeticInformation();
} else {
single_value->field_geodeticInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.currentLocationRetrieved().get_selection()) {
single_value->field_currentLocationRetrieved = other_value.currentLocationRetrieved();
} else {
single_value->field_currentLocationRetrieved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ageOfLocationInformation().get_selection()) {
single_value->field_ageOfLocationInformation = other_value.ageOfLocationInformation();
} else {
single_value->field_ageOfLocationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mme__Name().get_selection()) {
single_value->field_mme__Name = other_value.mme__Name();
} else {
single_value->field_mme__Name.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LocationInformationEPS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LocationInformationEPS_template(*other_value.implication_.precondition);
implication_.implied_template = new LocationInformationEPS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformationEPS.");
break;
}
set_selection(other_value);
}

LocationInformationEPS_template::LocationInformationEPS_template()
{
}

LocationInformationEPS_template::LocationInformationEPS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LocationInformationEPS_template::LocationInformationEPS_template(const LocationInformationEPS& other_value)
{
copy_value(other_value);
}

LocationInformationEPS_template::LocationInformationEPS_template(const OPTIONAL<LocationInformationEPS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationInformationEPS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.LocationInformationEPS from an unbound optional field.");
}
}

LocationInformationEPS_template::LocationInformationEPS_template(LocationInformationEPS_template* p_precondition, LocationInformationEPS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LocationInformationEPS_template::LocationInformationEPS_template(Dynamic_Match_Interface<LocationInformationEPS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LocationInformationEPS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LocationInformationEPS_template::LocationInformationEPS_template(const LocationInformationEPS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LocationInformationEPS_template::~LocationInformationEPS_template()
{
clean_up();
}

LocationInformationEPS_template& LocationInformationEPS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LocationInformationEPS_template& LocationInformationEPS_template::operator=(const LocationInformationEPS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LocationInformationEPS_template& LocationInformationEPS_template::operator=(const OPTIONAL<LocationInformationEPS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationInformationEPS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.LocationInformationEPS.");
}
return *this;
}

LocationInformationEPS_template& LocationInformationEPS_template::operator=(const LocationInformationEPS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LocationInformationEPS_template::match(const LocationInformationEPS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.e__utranCellGlobalIdentity().is_bound()) return FALSE;
if((other_value.e__utranCellGlobalIdentity().ispresent() ? !single_value->field_e__utranCellGlobalIdentity.match((const OCTETSTRING&)other_value.e__utranCellGlobalIdentity(), legacy) : !single_value->field_e__utranCellGlobalIdentity.match_omit(legacy)))return FALSE;
if(!other_value.trackingAreaIdentity().is_bound()) return FALSE;
if((other_value.trackingAreaIdentity().ispresent() ? !single_value->field_trackingAreaIdentity.match((const OCTETSTRING&)other_value.trackingAreaIdentity(), legacy) : !single_value->field_trackingAreaIdentity.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.geographicalInformation().is_bound()) return FALSE;
if((other_value.geographicalInformation().ispresent() ? !single_value->field_geographicalInformation.match((const OCTETSTRING&)other_value.geographicalInformation(), legacy) : !single_value->field_geographicalInformation.match_omit(legacy)))return FALSE;
if(!other_value.geodeticInformation().is_bound()) return FALSE;
if((other_value.geodeticInformation().ispresent() ? !single_value->field_geodeticInformation.match((const OCTETSTRING&)other_value.geodeticInformation(), legacy) : !single_value->field_geodeticInformation.match_omit(legacy)))return FALSE;
if(!other_value.currentLocationRetrieved().is_bound()) return FALSE;
if((other_value.currentLocationRetrieved().ispresent() ? !single_value->field_currentLocationRetrieved.match((const ASN_NULL&)other_value.currentLocationRetrieved(), legacy) : !single_value->field_currentLocationRetrieved.match_omit(legacy)))return FALSE;
if(!other_value.ageOfLocationInformation().is_bound()) return FALSE;
if((other_value.ageOfLocationInformation().ispresent() ? !single_value->field_ageOfLocationInformation.match((const INTEGER&)other_value.ageOfLocationInformation(), legacy) : !single_value->field_ageOfLocationInformation.match_omit(legacy)))return FALSE;
if(!other_value.mme__Name().is_bound()) return FALSE;
if((other_value.mme__Name().ispresent() ? !single_value->field_mme__Name.match((const OCTETSTRING&)other_value.mme__Name(), legacy) : !single_value->field_mme__Name.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformationEPS.");
}
return FALSE;
}

boolean LocationInformationEPS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_e__utranCellGlobalIdentity.is_omit() || single_value->field_e__utranCellGlobalIdentity.is_bound())
 || (single_value->field_trackingAreaIdentity.is_omit() || single_value->field_trackingAreaIdentity.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_geographicalInformation.is_omit() || single_value->field_geographicalInformation.is_bound())
 || (single_value->field_geodeticInformation.is_omit() || single_value->field_geodeticInformation.is_bound())
 || (single_value->field_currentLocationRetrieved.is_omit() || single_value->field_currentLocationRetrieved.is_bound())
 || (single_value->field_ageOfLocationInformation.is_omit() || single_value->field_ageOfLocationInformation.is_bound())
 || (single_value->field_mme__Name.is_omit() || single_value->field_mme__Name.is_bound());
}

boolean LocationInformationEPS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_e__utranCellGlobalIdentity.is_omit() || single_value->field_e__utranCellGlobalIdentity.is_value())
 && (single_value->field_trackingAreaIdentity.is_omit() || single_value->field_trackingAreaIdentity.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_geographicalInformation.is_omit() || single_value->field_geographicalInformation.is_value())
 && (single_value->field_geodeticInformation.is_omit() || single_value->field_geodeticInformation.is_value())
 && (single_value->field_currentLocationRetrieved.is_omit() || single_value->field_currentLocationRetrieved.is_value())
 && (single_value->field_ageOfLocationInformation.is_omit() || single_value->field_ageOfLocationInformation.is_value())
 && (single_value->field_mme__Name.is_omit() || single_value->field_mme__Name.is_value());
}

void LocationInformationEPS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LocationInformationEPS LocationInformationEPS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
LocationInformationEPS ret_val;
if (single_value->field_e__utranCellGlobalIdentity.is_omit()) ret_val.e__utranCellGlobalIdentity() = OMIT_VALUE;
else if (single_value->field_e__utranCellGlobalIdentity.is_bound()) {
ret_val.e__utranCellGlobalIdentity() = single_value->field_e__utranCellGlobalIdentity.valueof();
}
if (single_value->field_trackingAreaIdentity.is_omit()) ret_val.trackingAreaIdentity() = OMIT_VALUE;
else if (single_value->field_trackingAreaIdentity.is_bound()) {
ret_val.trackingAreaIdentity() = single_value->field_trackingAreaIdentity.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_geographicalInformation.is_omit()) ret_val.geographicalInformation() = OMIT_VALUE;
else if (single_value->field_geographicalInformation.is_bound()) {
ret_val.geographicalInformation() = single_value->field_geographicalInformation.valueof();
}
if (single_value->field_geodeticInformation.is_omit()) ret_val.geodeticInformation() = OMIT_VALUE;
else if (single_value->field_geodeticInformation.is_bound()) {
ret_val.geodeticInformation() = single_value->field_geodeticInformation.valueof();
}
if (single_value->field_currentLocationRetrieved.is_omit()) ret_val.currentLocationRetrieved() = OMIT_VALUE;
else if (single_value->field_currentLocationRetrieved.is_bound()) {
ret_val.currentLocationRetrieved() = single_value->field_currentLocationRetrieved.valueof();
}
if (single_value->field_ageOfLocationInformation.is_omit()) ret_val.ageOfLocationInformation() = OMIT_VALUE;
else if (single_value->field_ageOfLocationInformation.is_bound()) {
ret_val.ageOfLocationInformation() = single_value->field_ageOfLocationInformation.valueof();
}
if (single_value->field_mme__Name.is_omit()) ret_val.mme__Name() = OMIT_VALUE;
else if (single_value->field_mme__Name.is_bound()) {
ret_val.mme__Name() = single_value->field_mme__Name.valueof();
}
return ret_val;
}

void LocationInformationEPS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.LocationInformationEPS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LocationInformationEPS_template[list_length];
}

LocationInformationEPS_template& LocationInformationEPS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.LocationInformationEPS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& LocationInformationEPS_template::e__utranCellGlobalIdentity()
{
set_specific();
return single_value->field_e__utranCellGlobalIdentity;
}

const OCTETSTRING_template& LocationInformationEPS_template::e__utranCellGlobalIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field e_utranCellGlobalIdentity of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_e__utranCellGlobalIdentity;
}

OCTETSTRING_template& LocationInformationEPS_template::trackingAreaIdentity()
{
set_specific();
return single_value->field_trackingAreaIdentity;
}

const OCTETSTRING_template& LocationInformationEPS_template::trackingAreaIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trackingAreaIdentity of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_trackingAreaIdentity;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& LocationInformationEPS_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& LocationInformationEPS_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_extensionContainer;
}

OCTETSTRING_template& LocationInformationEPS_template::geographicalInformation()
{
set_specific();
return single_value->field_geographicalInformation;
}

const OCTETSTRING_template& LocationInformationEPS_template::geographicalInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geographicalInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_geographicalInformation;
}

OCTETSTRING_template& LocationInformationEPS_template::geodeticInformation()
{
set_specific();
return single_value->field_geodeticInformation;
}

const OCTETSTRING_template& LocationInformationEPS_template::geodeticInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geodeticInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_geodeticInformation;
}

ASN_NULL_template& LocationInformationEPS_template::currentLocationRetrieved()
{
set_specific();
return single_value->field_currentLocationRetrieved;
}

const ASN_NULL_template& LocationInformationEPS_template::currentLocationRetrieved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field currentLocationRetrieved of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_currentLocationRetrieved;
}

INTEGER_template& LocationInformationEPS_template::ageOfLocationInformation()
{
set_specific();
return single_value->field_ageOfLocationInformation;
}

const INTEGER_template& LocationInformationEPS_template::ageOfLocationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ageOfLocationInformation of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_ageOfLocationInformation;
}

OCTETSTRING_template& LocationInformationEPS_template::mme__Name()
{
set_specific();
return single_value->field_mme__Name;
}

const OCTETSTRING_template& LocationInformationEPS_template::mme__Name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mme_Name of a non-specific template of type @MAP-MS-DataTypes.LocationInformationEPS.");
return single_value->field_mme__Name;
}

int LocationInformationEPS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_e__utranCellGlobalIdentity.is_present()) ret_val++;
      if (single_value->field_trackingAreaIdentity.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_geographicalInformation.is_present()) ret_val++;
      if (single_value->field_geodeticInformation.is_present()) ret_val++;
      if (single_value->field_currentLocationRetrieved.is_present()) ret_val++;
      if (single_value->field_ageOfLocationInformation.is_present()) ret_val++;
      if (single_value->field_mme__Name.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.LocationInformationEPS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformationEPS.");
  }
  return 0;
}

void LocationInformationEPS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ e_utranCellGlobalIdentity := ");
single_value->field_e__utranCellGlobalIdentity.log();
TTCN_Logger::log_event_str(", trackingAreaIdentity := ");
single_value->field_trackingAreaIdentity.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", geographicalInformation := ");
single_value->field_geographicalInformation.log();
TTCN_Logger::log_event_str(", geodeticInformation := ");
single_value->field_geodeticInformation.log();
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
single_value->field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(", ageOfLocationInformation := ");
single_value->field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(", mme_Name := ");
single_value->field_mme__Name.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LocationInformationEPS_template::log_match(const LocationInformationEPS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.e__utranCellGlobalIdentity().ispresent()){
if(!single_value->field_e__utranCellGlobalIdentity.match(match_value.e__utranCellGlobalIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".e_utranCellGlobalIdentity");
single_value->field_e__utranCellGlobalIdentity.log_match(match_value.e__utranCellGlobalIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_e__utranCellGlobalIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".e_utranCellGlobalIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_e__utranCellGlobalIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trackingAreaIdentity().ispresent()){
if(!single_value->field_trackingAreaIdentity.match(match_value.trackingAreaIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".trackingAreaIdentity");
single_value->field_trackingAreaIdentity.log_match(match_value.trackingAreaIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trackingAreaIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trackingAreaIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trackingAreaIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.geographicalInformation().ispresent()){
if(!single_value->field_geographicalInformation.match(match_value.geographicalInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".geographicalInformation");
single_value->field_geographicalInformation.log_match(match_value.geographicalInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_geographicalInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".geographicalInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_geographicalInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.geodeticInformation().ispresent()){
if(!single_value->field_geodeticInformation.match(match_value.geodeticInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".geodeticInformation");
single_value->field_geodeticInformation.log_match(match_value.geodeticInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_geodeticInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".geodeticInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_geodeticInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.currentLocationRetrieved().ispresent()){
if(!single_value->field_currentLocationRetrieved.match(match_value.currentLocationRetrieved(), legacy)){
TTCN_Logger::log_logmatch_info(".currentLocationRetrieved");
single_value->field_currentLocationRetrieved.log_match(match_value.currentLocationRetrieved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_currentLocationRetrieved.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".currentLocationRetrieved := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_currentLocationRetrieved.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ageOfLocationInformation().ispresent()){
if(!single_value->field_ageOfLocationInformation.match(match_value.ageOfLocationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".ageOfLocationInformation");
single_value->field_ageOfLocationInformation.log_match(match_value.ageOfLocationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ageOfLocationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ageOfLocationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ageOfLocationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mme__Name().ispresent()){
if(!single_value->field_mme__Name.match(match_value.mme__Name(), legacy)){
TTCN_Logger::log_logmatch_info(".mme_Name");
single_value->field_mme__Name.log_match(match_value.mme__Name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mme__Name.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mme_Name := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mme__Name.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ e_utranCellGlobalIdentity := ");
if (match_value.e__utranCellGlobalIdentity().ispresent()) {
single_value->field_e__utranCellGlobalIdentity.log_match(match_value.e__utranCellGlobalIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_e__utranCellGlobalIdentity.log();
if (single_value->field_e__utranCellGlobalIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trackingAreaIdentity := ");
if (match_value.trackingAreaIdentity().ispresent()) {
single_value->field_trackingAreaIdentity.log_match(match_value.trackingAreaIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trackingAreaIdentity.log();
if (single_value->field_trackingAreaIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", geographicalInformation := ");
if (match_value.geographicalInformation().ispresent()) {
single_value->field_geographicalInformation.log_match(match_value.geographicalInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_geographicalInformation.log();
if (single_value->field_geographicalInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", geodeticInformation := ");
if (match_value.geodeticInformation().ispresent()) {
single_value->field_geodeticInformation.log_match(match_value.geodeticInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_geodeticInformation.log();
if (single_value->field_geodeticInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", currentLocationRetrieved := ");
if (match_value.currentLocationRetrieved().ispresent()) {
single_value->field_currentLocationRetrieved.log_match(match_value.currentLocationRetrieved(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_currentLocationRetrieved.log();
if (single_value->field_currentLocationRetrieved.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ageOfLocationInformation := ");
if (match_value.ageOfLocationInformation().ispresent()) {
single_value->field_ageOfLocationInformation.log_match(match_value.ageOfLocationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ageOfLocationInformation.log();
if (single_value->field_ageOfLocationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mme_Name := ");
if (match_value.mme__Name().ispresent()) {
single_value->field_mme__Name.log_match(match_value.mme__Name(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mme__Name.log();
if (single_value->field_mme__Name.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LocationInformationEPS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!e__utranCellGlobalIdentity().is_bound()) e__utranCellGlobalIdentity() = OMIT_VALUE;
else e__utranCellGlobalIdentity().set_implicit_omit();
if (!trackingAreaIdentity().is_bound()) trackingAreaIdentity() = OMIT_VALUE;
else trackingAreaIdentity().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!geographicalInformation().is_bound()) geographicalInformation() = OMIT_VALUE;
else geographicalInformation().set_implicit_omit();
if (!geodeticInformation().is_bound()) geodeticInformation() = OMIT_VALUE;
else geodeticInformation().set_implicit_omit();
if (!currentLocationRetrieved().is_bound()) currentLocationRetrieved() = OMIT_VALUE;
else currentLocationRetrieved().set_implicit_omit();
if (!ageOfLocationInformation().is_bound()) ageOfLocationInformation() = OMIT_VALUE;
else ageOfLocationInformation().set_implicit_omit();
if (!mme__Name().is_bound()) mme__Name() = OMIT_VALUE;
else mme__Name().set_implicit_omit();
}

void LocationInformationEPS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_e__utranCellGlobalIdentity.encode_text(text_buf);
single_value->field_trackingAreaIdentity.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_geographicalInformation.encode_text(text_buf);
single_value->field_geodeticInformation.encode_text(text_buf);
single_value->field_currentLocationRetrieved.encode_text(text_buf);
single_value->field_ageOfLocationInformation.encode_text(text_buf);
single_value->field_mme__Name.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.LocationInformationEPS.");
}
}

void LocationInformationEPS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_e__utranCellGlobalIdentity.decode_text(text_buf);
single_value->field_trackingAreaIdentity.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_geographicalInformation.decode_text(text_buf);
single_value->field_geodeticInformation.decode_text(text_buf);
single_value->field_currentLocationRetrieved.decode_text(text_buf);
single_value->field_ageOfLocationInformation.decode_text(text_buf);
single_value->field_mme__Name.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LocationInformationEPS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.LocationInformationEPS.");
}
}

void LocationInformationEPS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LocationInformationEPS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.LocationInformationEPS has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) e__utranCellGlobalIdentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) trackingAreaIdentity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) geographicalInformation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) geodeticInformation().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) currentLocationRetrieved().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ageOfLocationInformation().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mme__Name().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "e_utranCellGlobalIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          e__utranCellGlobalIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trackingAreaIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trackingAreaIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geodeticInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geodeticInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentLocationRetrieved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentLocationRetrieved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ageOfLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ageOfLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mme_Name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mme__Name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.LocationInformationEPS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LocationInformationEPS_template* precondition = new LocationInformationEPS_template;
    precondition->set_param(*param.get_elem(0));
    LocationInformationEPS_template* implied_template = new LocationInformationEPS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LocationInformationEPS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.LocationInformationEPS");
  }
  is_ifpresent = param.get_ifpresent();
}

void LocationInformationEPS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_e__utranCellGlobalIdentity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_trackingAreaIdentity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_geographicalInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_geodeticInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_currentLocationRetrieved.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_ageOfLocationInformation.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
single_value->field_mme__Name.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.LocationInformationEPS");
}

boolean LocationInformationEPS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LocationInformationEPS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UserCSGInformation::UserCSGInformation()
{
}

UserCSGInformation::UserCSGInformation(const BITSTRING& par_csg__Id,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< OCTETSTRING >& par_accessMode,
    const OPTIONAL< OCTETSTRING >& par_cmi)
  :   field_csg__Id(par_csg__Id),
  field_extensionContainer(par_extensionContainer),
  field_accessMode(par_accessMode),
  field_cmi(par_cmi)
{
}

UserCSGInformation::UserCSGInformation(const UserCSGInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.UserCSGInformation.");
if (other_value.csg__Id().is_bound()) field_csg__Id = other_value.csg__Id();
else field_csg__Id.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.accessMode().is_bound()) field_accessMode = other_value.accessMode();
else field_accessMode.clean_up();
if (other_value.cmi().is_bound()) field_cmi = other_value.cmi();
else field_cmi.clean_up();
}

void UserCSGInformation::clean_up()
{
field_csg__Id.clean_up();
field_extensionContainer.clean_up();
field_accessMode.clean_up();
field_cmi.clean_up();
}

const TTCN_Typedescriptor_t* UserCSGInformation::get_descriptor() const { return &UserCSGInformation_descr_; }
UserCSGInformation& UserCSGInformation::operator=(const UserCSGInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.UserCSGInformation.");
  if (other_value.csg__Id().is_bound()) field_csg__Id = other_value.csg__Id();
  else field_csg__Id.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.accessMode().is_bound()) field_accessMode = other_value.accessMode();
  else field_accessMode.clean_up();
  if (other_value.cmi().is_bound()) field_cmi = other_value.cmi();
  else field_cmi.clean_up();
}
return *this;
}

boolean UserCSGInformation::operator==(const UserCSGInformation& other_value) const
{
return field_csg__Id==other_value.field_csg__Id
  && field_extensionContainer==other_value.field_extensionContainer
  && field_accessMode==other_value.field_accessMode
  && field_cmi==other_value.field_cmi;
}

boolean UserCSGInformation::is_bound() const
{
return (field_csg__Id.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_accessMode.get_selection() || field_accessMode.is_bound())
  || (OPTIONAL_OMIT == field_cmi.get_selection() || field_cmi.is_bound());
}
boolean UserCSGInformation::is_value() const
{
return field_csg__Id.is_value()
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_accessMode.get_selection() || field_accessMode.is_value())
  && (OPTIONAL_OMIT == field_cmi.get_selection() || field_cmi.is_value());
}
int UserCSGInformation::size_of() const
{
  int ret_val = 1;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_accessMode.ispresent()) ret_val++;
  if (field_cmi.ispresent()) ret_val++;
  return ret_val;
}

void UserCSGInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ csg_Id := ");
field_csg__Id.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", accessMode := ");
field_accessMode.log();
TTCN_Logger::log_event_str(", cmi := ");
field_cmi.log();
TTCN_Logger::log_event_str(" }");
}

void UserCSGInformation::set_implicit_omit()
{
if (csg__Id().is_bound()) csg__Id().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!accessMode().is_bound()) accessMode() = OMIT_VALUE;
else accessMode().set_implicit_omit();
if (!cmi().is_bound()) cmi() = OMIT_VALUE;
else cmi().set_implicit_omit();
}

void UserCSGInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.UserCSGInformation has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) csg__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) accessMode().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cmi().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "csg_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          csg__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cmi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cmi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UserCSGInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.UserCSGInformation");
  }
}

void UserCSGInformation::encode_text(Text_Buf& text_buf) const
{
field_csg__Id.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_accessMode.encode_text(text_buf);
field_cmi.encode_text(text_buf);
}

void UserCSGInformation::decode_text(Text_Buf& text_buf)
{
field_csg__Id.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_accessMode.decode_text(text_buf);
field_cmi.decode_text(text_buf);
}

void UserCSGInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UserCSGInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* UserCSGInformation::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("csg_Id': ");
  new_tlv->add_TLV(field_csg__Id.BER_encode_TLV(UserCSGInformation_csg__Id_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(UserCSGInformation_extensionContainer_descr_, p_coding));
  ec_1.set_msg("accessMode': ");
  new_tlv->add_TLV(field_accessMode.BER_encode_TLV(UserCSGInformation_accessMode_descr_, p_coding));
  ec_1.set_msg("cmi': ");
  new_tlv->add_TLV(field_cmi.BER_encode_TLV(UserCSGInformation_cmi_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean UserCSGInformation::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.UserCSGInformation' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("csg_Id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_csg__Id.BER_decode_TLV(UserCSGInformation_csg__Id_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(UserCSGInformation_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("accessMode': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_accessMode=OMIT_VALUE;
    else {
      field_accessMode.BER_decode_TLV(UserCSGInformation_accessMode_descr_, tmp_tlv, L_form);
      if(field_accessMode.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("cmi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_cmi=OMIT_VALUE;
    else {
      field_cmi.BER_decode_TLV(UserCSGInformation_cmi_descr_, tmp_tlv, L_form);
      if(field_cmi.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int UserCSGInformation::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.UserCSGInformation.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "csg_Id");
    enc_len += field_csg__Id.JSON_encode(UserCSGInformation_csg__Id_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(UserCSGInformation_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_accessMode.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "accessMode");
    enc_len += field_accessMode.JSON_encode(UserCSGInformation_accessMode_descr_, p_tok, FALSE);
  }

  if (field_cmi.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "cmi");
    enc_len += field_cmi.JSON_encode(UserCSGInformation_cmi_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int UserCSGInformation::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const UserCSGInformation*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean csg__Id_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean accessMode_found = FALSE;
  boolean cmi_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (6 == name_len && 0 == strncmp(fld_name, "csg_Id", name_len)) {
        csg__Id_found = TRUE;
         int ret_val = field_csg__Id.JSON_decode(UserCSGInformation_csg__Id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 6, "csg_Id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(UserCSGInformation_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "accessMode", name_len)) {
        accessMode_found = TRUE;
         int ret_val = field_accessMode.JSON_decode(UserCSGInformation_accessMode_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "accessMode");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (3 == name_len && 0 == strncmp(fld_name, "cmi", name_len)) {
        cmi_found = TRUE;
         int ret_val = field_cmi.JSON_decode(UserCSGInformation_cmi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 3, "cmi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!csg__Id_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "csg_Id");
    return JSON_ERROR_FATAL;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!accessMode_found) {
    field_accessMode = OMIT_VALUE;
  }
  if (!cmi_found) {
    field_cmi = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int UserCSGInformation::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_accessMode.is_bound() && field_accessMode.is_present());
  has_extension = has_extension || (field_cmi.is_bound() && field_cmi.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_csg__Id.OER_encode(UserCSGInformation_csg__Id_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(UserCSGInformation_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_accessMode.is_present()) {
      c |= 128;
      field_accessMode.OER_encode(UserCSGInformation_accessMode_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_cmi.is_present()) {
      c |= 64;
      field_cmi.OER_encode(UserCSGInformation_cmi_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(6);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int UserCSGInformation::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_csg__Id.OER_decode(UserCSGInformation_csg__Id_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(UserCSGInformation_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_accessMode = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_accessMode.OER_decode(UserCSGInformation_accessMode_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_cmi = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_cmi.OER_decode(UserCSGInformation_cmi_descr_, p_buf, p_oer);
    }
  }
  else {
    field_accessMode = OMIT_VALUE;
    field_cmi = OMIT_VALUE;
  }
  return 0;
}

void UserCSGInformation::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_accessMode.is_present();
boolean ext_1_present = field_cmi.is_present();
boolean ext_bit = ext_0_present || ext_1_present;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_csg__Id.PER_encode(UserCSGInformation_csg__Id_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(UserCSGInformation_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(2);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_accessMode.PER_encode(UserCSGInformation_accessMode_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_cmi.PER_encode(UserCSGInformation_cmi_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void UserCSGInformation::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_csg__Id.PER_decode(UserCSGInformation_csg__Id_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_decode(UserCSGInformation_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 2) {
for (int i = nof_decoded_ext_adds; i < 2; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_accessMode.PER_decode(UserCSGInformation_accessMode_descr_, ext_add_buf, p_options);
}
else {
field_accessMode = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_cmi.PER_decode(UserCSGInformation_cmi_descr_, ext_add_buf, p_options);
}
else {
field_cmi = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 2) for (int i = 2; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct UserCSGInformation_template::single_value_struct {
BITSTRING_template field_csg__Id;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
OCTETSTRING_template field_accessMode;
OCTETSTRING_template field_cmi;
};

void UserCSGInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_csg__Id = ANY_VALUE;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_accessMode = ANY_OR_OMIT;
single_value->field_cmi = ANY_OR_OMIT;
}
}
}

void UserCSGInformation_template::copy_value(const UserCSGInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.csg__Id().is_bound()) {
  single_value->field_csg__Id = other_value.csg__Id();
} else {
  single_value->field_csg__Id.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.accessMode().is_bound()) {
  if (other_value.accessMode().ispresent()) single_value->field_accessMode = other_value.accessMode()();
  else single_value->field_accessMode = OMIT_VALUE;
} else {
  single_value->field_accessMode.clean_up();
}
if (other_value.cmi().is_bound()) {
  if (other_value.cmi().ispresent()) single_value->field_cmi = other_value.cmi()();
  else single_value->field_cmi = OMIT_VALUE;
} else {
  single_value->field_cmi.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UserCSGInformation_template::copy_template(const UserCSGInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.csg__Id().get_selection()) {
single_value->field_csg__Id = other_value.csg__Id();
} else {
single_value->field_csg__Id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.accessMode().get_selection()) {
single_value->field_accessMode = other_value.accessMode();
} else {
single_value->field_accessMode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cmi().get_selection()) {
single_value->field_cmi = other_value.cmi();
} else {
single_value->field_cmi.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UserCSGInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UserCSGInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new UserCSGInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.UserCSGInformation.");
break;
}
set_selection(other_value);
}

UserCSGInformation_template::UserCSGInformation_template()
{
}

UserCSGInformation_template::UserCSGInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UserCSGInformation_template::UserCSGInformation_template(const UserCSGInformation& other_value)
{
copy_value(other_value);
}

UserCSGInformation_template::UserCSGInformation_template(const OPTIONAL<UserCSGInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UserCSGInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.UserCSGInformation from an unbound optional field.");
}
}

UserCSGInformation_template::UserCSGInformation_template(UserCSGInformation_template* p_precondition, UserCSGInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UserCSGInformation_template::UserCSGInformation_template(Dynamic_Match_Interface<UserCSGInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UserCSGInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UserCSGInformation_template::UserCSGInformation_template(const UserCSGInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UserCSGInformation_template::~UserCSGInformation_template()
{
clean_up();
}

UserCSGInformation_template& UserCSGInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UserCSGInformation_template& UserCSGInformation_template::operator=(const UserCSGInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UserCSGInformation_template& UserCSGInformation_template::operator=(const OPTIONAL<UserCSGInformation>& other_value)
{
clean_up();
switch (other_v