// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RTP_Types.hh"

namespace RTP__Types {

/* Member functions of C++ classes */

RTCP__IE__SDES::RTCP__IE__SDES()
{
}

RTCP__IE__SDES::RTCP__IE__SDES(const INTEGER& par_version,
    const BITSTRING& par_padding__ind,
    const INTEGER& par_source__count,
    const INTEGER& par_payload__type,
    const INTEGER& par_packet__length,
    const OPTIONAL< RTCP__SDES__chunk__list >& par_chunks,
    const OPTIONAL< OCTETSTRING >& par_padding)
  :   field_version(par_version),
  field_padding__ind(par_padding__ind),
  field_source__count(par_source__count),
  field_payload__type(par_payload__type),
  field_packet__length(par_packet__length),
  field_chunks(par_chunks),
  field_padding(par_padding)
{
}

RTCP__IE__SDES::RTCP__IE__SDES(const RTCP__IE__SDES& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_IE_SDES.");
if (other_value.version().is_bound()) field_version = other_value.version();
else field_version.clean_up();
if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
else field_padding__ind.clean_up();
if (other_value.source__count().is_bound()) field_source__count = other_value.source__count();
else field_source__count.clean_up();
if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
else field_payload__type.clean_up();
if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
else field_packet__length.clean_up();
if (other_value.chunks().is_bound()) field_chunks = other_value.chunks();
else field_chunks.clean_up();
if (other_value.padding().is_bound()) field_padding = other_value.padding();
else field_padding.clean_up();
}

void RTCP__IE__SDES::clean_up()
{
field_version.clean_up();
field_padding__ind.clean_up();
field_source__count.clean_up();
field_payload__type.clean_up();
field_packet__length.clean_up();
field_chunks.clean_up();
field_padding.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__IE__SDES::get_descriptor() const { return &RTCP__IE__SDES_descr_; }
RTCP__IE__SDES& RTCP__IE__SDES::operator=(const RTCP__IE__SDES& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_IE_SDES.");
  if (other_value.version().is_bound()) field_version = other_value.version();
  else field_version.clean_up();
  if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
  else field_padding__ind.clean_up();
  if (other_value.source__count().is_bound()) field_source__count = other_value.source__count();
  else field_source__count.clean_up();
  if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
  else field_payload__type.clean_up();
  if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
  else field_packet__length.clean_up();
  if (other_value.chunks().is_bound()) field_chunks = other_value.chunks();
  else field_chunks.clean_up();
  if (other_value.padding().is_bound()) field_padding = other_value.padding();
  else field_padding.clean_up();
}
return *this;
}

boolean RTCP__IE__SDES::operator==(const RTCP__IE__SDES& other_value) const
{
return field_version==other_value.field_version
  && field_padding__ind==other_value.field_padding__ind
  && field_source__count==other_value.field_source__count
  && field_payload__type==other_value.field_payload__type
  && field_packet__length==other_value.field_packet__length
  && field_chunks==other_value.field_chunks
  && field_padding==other_value.field_padding;
}

boolean RTCP__IE__SDES::is_bound() const
{
return (field_version.is_bound())
  || (field_padding__ind.is_bound())
  || (field_source__count.is_bound())
  || (field_payload__type.is_bound())
  || (field_packet__length.is_bound())
  || (OPTIONAL_OMIT == field_chunks.get_selection() || field_chunks.is_bound())
  || (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_bound());
}
boolean RTCP__IE__SDES::is_value() const
{
return field_version.is_value()
  && field_padding__ind.is_value()
  && field_source__count.is_value()
  && field_payload__type.is_value()
  && field_packet__length.is_value()
  && (OPTIONAL_OMIT == field_chunks.get_selection() || field_chunks.is_value())
  && (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_value());
}
int RTCP__IE__SDES::size_of() const
{
  int ret_val = 5;
  if (field_chunks.ispresent()) ret_val++;
  if (field_padding.ispresent()) ret_val++;
  return ret_val;
}

void RTCP__IE__SDES::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version := ");
field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
field_padding__ind.log();
TTCN_Logger::log_event_str(", source_count := ");
field_source__count.log();
TTCN_Logger::log_event_str(", payload_type := ");
field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
field_packet__length.log();
TTCN_Logger::log_event_str(", chunks := ");
field_chunks.log();
TTCN_Logger::log_event_str(", padding := ");
field_padding.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__IE__SDES::set_implicit_omit()
{
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (source__count().is_bound()) source__count().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (!chunks().is_bound()) chunks() = OMIT_VALUE;
else chunks().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__SDES::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_IE_SDES has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) source__count().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) chunks().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chunks")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chunks().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_SDES: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_IE_SDES");
  }
}

void RTCP__IE__SDES::encode_text(Text_Buf& text_buf) const
{
field_version.encode_text(text_buf);
field_padding__ind.encode_text(text_buf);
field_source__count.encode_text(text_buf);
field_payload__type.encode_text(text_buf);
field_packet__length.encode_text(text_buf);
field_chunks.encode_text(text_buf);
field_padding.encode_text(text_buf);
}

void RTCP__IE__SDES::decode_text(Text_Buf& text_buf)
{
field_version.decode_text(text_buf);
field_padding__ind.decode_text(text_buf);
field_source__count.decode_text(text_buf);
field_payload__type.decode_text(text_buf);
field_packet__length.decode_text(text_buf);
field_chunks.decode_text(text_buf);
field_padding.decode_text(text_buf);
}

void RTCP__IE__SDES::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__IE__SDES::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__IE__SDES::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  int value_of_length_field4 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__IE__SDES_version_descr_.raw->forceomit);
  decoded_field_length = field_version.RAW_decode(RTCP__IE__SDES_version_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__IE__SDES_padding__ind_descr_.raw->forceomit);
  decoded_field_length = field_padding__ind.RAW_decode(RTCP__IE__SDES_padding__ind_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__IE__SDES_source__count_descr_.raw->forceomit);
  decoded_field_length = field_source__count.RAW_decode(RTCP__IE__SDES_source__count_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp2 = field_source__count.convert_to_Integer(RTCP__IE__SDES_source__count_descr_);
  field_source__count = tmp2;
  value_of_length_field2 += tmp2.get_long_long_val() * 1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__IE__SDES_payload__type_descr_.raw->forceomit);
  decoded_field_length = field_payload__type.RAW_decode(RTCP__IE__SDES_payload__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RTCP__IE__SDES_packet__length_descr_.raw->forceomit);
  decoded_field_length = field_packet__length.RAW_decode(RTCP__IE__SDES_packet__length_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp4 = field_packet__length.convert_to_Integer(RTCP__IE__SDES_packet__length_descr_);
  field_packet__length = tmp4;
  value_of_length_field4 += tmp4.get_long_long_val() * 32;
  if (limit > 0 && value_of_length_field2 > 0 && value_of_length_field4 > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_chunks = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, RTCP__IE__SDES_chunks_descr_.raw->forceomit);
  decoded_field_length = field_chunks().RAW_decode(RTCP__IE__SDES_chunks_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, value_of_length_field2, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_chunks = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_chunks=OMIT_VALUE;
  if (limit > 0 && value_of_length_field4 > 0 && field_padding__ind ==  bs_0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_padding = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, RTCP__IE__SDES_padding_descr_.raw->forceomit);
  decoded_field_length = field_padding().RAW_decode(RTCP__IE__SDES_padding_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_padding = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_padding=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__IE__SDES::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__IE__SDES_version_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__IE__SDES_padding__ind_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__IE__SDES_source__count_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RTCP__IE__SDES_payload__type_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RTCP__IE__SDES_packet__length_descr_.raw);
  if (field_chunks.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RTCP__IE__SDES_chunks_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RTCP__IE__SDES_padding_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_version.RAW_encode(RTCP__IE__SDES_version_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_padding__ind.RAW_encode(RTCP__IE__SDES_padding__ind_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += 5;
  myleaf.body.node.nodes[2]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->coding_descr = &RTCP__IE__SDES_source__count_descr_;
  myleaf.body.node.nodes[2]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[2]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->length = 5;
  if (field_chunks.ispresent()) {
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].pos = 0;
  }
  encoded_length += field_payload__type.RAW_encode(RTCP__IE__SDES_payload__type_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += 16;
  myleaf.body.node.nodes[4]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[4]->coding_descr = &RTCP__IE__SDES_packet__length_descr_;
  myleaf.body.node.nodes[4]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[4]->calcof.lengthto.unit = 32;
  myleaf.body.node.nodes[4]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[4]->length = 16;
  if (field_chunks.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = 0;
  }
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = 0;
  }
  if (field_chunks.ispresent()) {
  encoded_length += field_chunks().RAW_encode(RTCP__IE__SDES_chunks_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_padding.ispresent()) {
  encoded_length += field_padding().RAW_encode(RTCP__IE__SDES_padding_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_padding.ispresent() && (field_padding__ind !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(RTCP__IE__SDES_padding__ind_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RTCP__IE__SDES_template::single_value_struct {
INTEGER_template field_version;
BITSTRING_template field_padding__ind;
INTEGER_template field_source__count;
INTEGER_template field_payload__type;
INTEGER_template field_packet__length;
RTCP__SDES__chunk__list_template field_chunks;
OCTETSTRING_template field_padding;
};

void RTCP__IE__SDES_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version = ANY_VALUE;
single_value->field_padding__ind = ANY_VALUE;
single_value->field_source__count = ANY_VALUE;
single_value->field_payload__type = ANY_VALUE;
single_value->field_packet__length = ANY_VALUE;
single_value->field_chunks = ANY_OR_OMIT;
single_value->field_padding = ANY_OR_OMIT;
}
}
}

void RTCP__IE__SDES_template::copy_value(const RTCP__IE__SDES& other_value)
{
single_value = new single_value_struct;
if (other_value.version().is_bound()) {
  single_value->field_version = other_value.version();
} else {
  single_value->field_version.clean_up();
}
if (other_value.padding__ind().is_bound()) {
  single_value->field_padding__ind = other_value.padding__ind();
} else {
  single_value->field_padding__ind.clean_up();
}
if (other_value.source__count().is_bound()) {
  single_value->field_source__count = other_value.source__count();
} else {
  single_value->field_source__count.clean_up();
}
if (other_value.payload__type().is_bound()) {
  single_value->field_payload__type = other_value.payload__type();
} else {
  single_value->field_payload__type.clean_up();
}
if (other_value.packet__length().is_bound()) {
  single_value->field_packet__length = other_value.packet__length();
} else {
  single_value->field_packet__length.clean_up();
}
if (other_value.chunks().is_bound()) {
  if (other_value.chunks().ispresent()) single_value->field_chunks = other_value.chunks()();
  else single_value->field_chunks = OMIT_VALUE;
} else {
  single_value->field_chunks.clean_up();
}
if (other_value.padding().is_bound()) {
  if (other_value.padding().ispresent()) single_value->field_padding = other_value.padding()();
  else single_value->field_padding = OMIT_VALUE;
} else {
  single_value->field_padding.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__IE__SDES_template::copy_template(const RTCP__IE__SDES_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version().get_selection()) {
single_value->field_version = other_value.version();
} else {
single_value->field_version.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding__ind().get_selection()) {
single_value->field_padding__ind = other_value.padding__ind();
} else {
single_value->field_padding__ind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.source__count().get_selection()) {
single_value->field_source__count = other_value.source__count();
} else {
single_value->field_source__count.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload__type().get_selection()) {
single_value->field_payload__type = other_value.payload__type();
} else {
single_value->field_payload__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packet__length().get_selection()) {
single_value->field_packet__length = other_value.packet__length();
} else {
single_value->field_packet__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chunks().get_selection()) {
single_value->field_chunks = other_value.chunks();
} else {
single_value->field_chunks.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding().get_selection()) {
single_value->field_padding = other_value.padding();
} else {
single_value->field_padding.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__IE__SDES_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__IE__SDES_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__IE__SDES_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_SDES.");
break;
}
set_selection(other_value);
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template()
{
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(const RTCP__IE__SDES& other_value)
{
copy_value(other_value);
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(const OPTIONAL<RTCP__IE__SDES>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__SDES&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_IE_SDES from an unbound optional field.");
}
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(RTCP__IE__SDES_template* p_precondition, RTCP__IE__SDES_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(Dynamic_Match_Interface<RTCP__IE__SDES>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__IE__SDES>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__IE__SDES_template::RTCP__IE__SDES_template(const RTCP__IE__SDES_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__IE__SDES_template::~RTCP__IE__SDES_template()
{
clean_up();
}

RTCP__IE__SDES_template& RTCP__IE__SDES_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__IE__SDES_template& RTCP__IE__SDES_template::operator=(const RTCP__IE__SDES& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__IE__SDES_template& RTCP__IE__SDES_template::operator=(const OPTIONAL<RTCP__IE__SDES>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__SDES&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_IE_SDES.");
}
return *this;
}

RTCP__IE__SDES_template& RTCP__IE__SDES_template::operator=(const RTCP__IE__SDES_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__IE__SDES_template::match(const RTCP__IE__SDES& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version().is_bound()) return FALSE;
if(!single_value->field_version.match(other_value.version(), legacy))return FALSE;
if(!other_value.padding__ind().is_bound()) return FALSE;
if(!single_value->field_padding__ind.match(other_value.padding__ind(), legacy))return FALSE;
if(!other_value.source__count().is_bound()) return FALSE;
if(!single_value->field_source__count.match(other_value.source__count(), legacy))return FALSE;
if(!other_value.payload__type().is_bound()) return FALSE;
if(!single_value->field_payload__type.match(other_value.payload__type(), legacy))return FALSE;
if(!other_value.packet__length().is_bound()) return FALSE;
if(!single_value->field_packet__length.match(other_value.packet__length(), legacy))return FALSE;
if(!other_value.chunks().is_bound()) return FALSE;
if((other_value.chunks().ispresent() ? !single_value->field_chunks.match((const RTCP__SDES__chunk__list&)other_value.chunks(), legacy) : !single_value->field_chunks.match_omit(legacy)))return FALSE;
if(!other_value.padding().is_bound()) return FALSE;
if((other_value.padding().ispresent() ? !single_value->field_padding.match((const OCTETSTRING&)other_value.padding(), legacy) : !single_value->field_padding.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_SDES.");
}
return FALSE;
}

boolean RTCP__IE__SDES_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version.is_bound()
 || single_value->field_padding__ind.is_bound()
 || single_value->field_source__count.is_bound()
 || single_value->field_payload__type.is_bound()
 || single_value->field_packet__length.is_bound()
 || (single_value->field_chunks.is_omit() || single_value->field_chunks.is_bound())
 || (single_value->field_padding.is_omit() || single_value->field_padding.is_bound());
}

boolean RTCP__IE__SDES_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version.is_value()
 && single_value->field_padding__ind.is_value()
 && single_value->field_source__count.is_value()
 && single_value->field_payload__type.is_value()
 && single_value->field_packet__length.is_value()
 && (single_value->field_chunks.is_omit() || single_value->field_chunks.is_value())
 && (single_value->field_padding.is_omit() || single_value->field_padding.is_value());
}

void RTCP__IE__SDES_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__IE__SDES RTCP__IE__SDES_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
RTCP__IE__SDES ret_val;
if (single_value->field_version.is_bound()) {
ret_val.version() = single_value->field_version.valueof();
}
if (single_value->field_padding__ind.is_bound()) {
ret_val.padding__ind() = single_value->field_padding__ind.valueof();
}
if (single_value->field_source__count.is_bound()) {
ret_val.source__count() = single_value->field_source__count.valueof();
}
if (single_value->field_payload__type.is_bound()) {
ret_val.payload__type() = single_value->field_payload__type.valueof();
}
if (single_value->field_packet__length.is_bound()) {
ret_val.packet__length() = single_value->field_packet__length.valueof();
}
if (single_value->field_chunks.is_omit()) ret_val.chunks() = OMIT_VALUE;
else if (single_value->field_chunks.is_bound()) {
ret_val.chunks() = single_value->field_chunks.valueof();
}
if (single_value->field_padding.is_omit()) ret_val.padding() = OMIT_VALUE;
else if (single_value->field_padding.is_bound()) {
ret_val.padding() = single_value->field_padding.valueof();
}
return ret_val;
}

void RTCP__IE__SDES_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_IE_SDES.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__IE__SDES_template[list_length];
}

RTCP__IE__SDES_template& RTCP__IE__SDES_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_IE_SDES.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_IE_SDES.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__IE__SDES_template::version()
{
set_specific();
return single_value->field_version;
}

const INTEGER_template& RTCP__IE__SDES_template::version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_version;
}

BITSTRING_template& RTCP__IE__SDES_template::padding__ind()
{
set_specific();
return single_value->field_padding__ind;
}

const BITSTRING_template& RTCP__IE__SDES_template::padding__ind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding_ind of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_padding__ind;
}

INTEGER_template& RTCP__IE__SDES_template::source__count()
{
set_specific();
return single_value->field_source__count;
}

const INTEGER_template& RTCP__IE__SDES_template::source__count() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field source_count of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_source__count;
}

INTEGER_template& RTCP__IE__SDES_template::payload__type()
{
set_specific();
return single_value->field_payload__type;
}

const INTEGER_template& RTCP__IE__SDES_template::payload__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload_type of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_payload__type;
}

INTEGER_template& RTCP__IE__SDES_template::packet__length()
{
set_specific();
return single_value->field_packet__length;
}

const INTEGER_template& RTCP__IE__SDES_template::packet__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packet_length of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_packet__length;
}

RTCP__SDES__chunk__list_template& RTCP__IE__SDES_template::chunks()
{
set_specific();
return single_value->field_chunks;
}

const RTCP__SDES__chunk__list_template& RTCP__IE__SDES_template::chunks() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chunks of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_chunks;
}

OCTETSTRING_template& RTCP__IE__SDES_template::padding()
{
set_specific();
return single_value->field_padding;
}

const OCTETSTRING_template& RTCP__IE__SDES_template::padding() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding of a non-specific template of type @RTP_Types.RTCP_IE_SDES.");
return single_value->field_padding;
}

int RTCP__IE__SDES_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_chunks.is_present()) ret_val++;
      if (single_value->field_padding.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_SDES containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_SDES.");
  }
  return 0;
}

void RTCP__IE__SDES_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log();
TTCN_Logger::log_event_str(", source_count := ");
single_value->field_source__count.log();
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log();
TTCN_Logger::log_event_str(", chunks := ");
single_value->field_chunks.log();
TTCN_Logger::log_event_str(", padding := ");
single_value->field_padding.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__IE__SDES_template::log_match(const RTCP__IE__SDES& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version.match(match_value.version(), legacy)){
TTCN_Logger::log_logmatch_info(".version");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_padding__ind.match(match_value.padding__ind(), legacy)){
TTCN_Logger::log_logmatch_info(".padding_ind");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_source__count.match(match_value.source__count(), legacy)){
TTCN_Logger::log_logmatch_info(".source_count");
single_value->field_source__count.log_match(match_value.source__count(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload__type.match(match_value.payload__type(), legacy)){
TTCN_Logger::log_logmatch_info(".payload_type");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packet__length.match(match_value.packet__length(), legacy)){
TTCN_Logger::log_logmatch_info(".packet_length");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.chunks().ispresent()){
if(!single_value->field_chunks.match(match_value.chunks(), legacy)){
TTCN_Logger::log_logmatch_info(".chunks");
single_value->field_chunks.log_match(match_value.chunks(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_chunks.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".chunks := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_chunks.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.padding().ispresent()){
if(!single_value->field_padding.match(match_value.padding(), legacy)){
TTCN_Logger::log_logmatch_info(".padding");
single_value->field_padding.log_match(match_value.padding(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_padding.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".padding := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_padding.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::log_event_str(", source_count := ");
single_value->field_source__count.log_match(match_value.source__count(), legacy);
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::log_event_str(", chunks := ");
if (match_value.chunks().ispresent()) {
single_value->field_chunks.log_match(match_value.chunks(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_chunks.log();
if (single_value->field_chunks.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", padding := ");
if (match_value.padding().ispresent()) {
single_value->field_padding.log_match(match_value.padding(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_padding.log();
if (single_value->field_padding.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__IE__SDES_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (source__count().is_bound()) source__count().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (!chunks().is_bound()) chunks() = OMIT_VALUE;
else chunks().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__SDES_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version.encode_text(text_buf);
single_value->field_padding__ind.encode_text(text_buf);
single_value->field_source__count.encode_text(text_buf);
single_value->field_payload__type.encode_text(text_buf);
single_value->field_packet__length.encode_text(text_buf);
single_value->field_chunks.encode_text(text_buf);
single_value->field_padding.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_SDES.");
}
}

void RTCP__IE__SDES_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version.decode_text(text_buf);
single_value->field_padding__ind.decode_text(text_buf);
single_value->field_source__count.decode_text(text_buf);
single_value->field_payload__type.decode_text(text_buf);
single_value->field_packet__length.decode_text(text_buf);
single_value->field_chunks.decode_text(text_buf);
single_value->field_padding.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__IE__SDES_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_IE_SDES.");
}
}

void RTCP__IE__SDES_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__IE__SDES_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_IE_SDES has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) source__count().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) chunks().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chunks")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chunks().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_SDES: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__IE__SDES_template* precondition = new RTCP__IE__SDES_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__IE__SDES_template* implied_template = new RTCP__IE__SDES_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__IE__SDES_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_IE_SDES");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__IE__SDES_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_padding__ind.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_source__count.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_payload__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_packet__length.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_chunks.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
single_value->field_padding.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_IE_SDES");
}

boolean RTCP__IE__SDES_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__IE__SDES_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RTCP__field__reason::RTCP__field__reason()
{
}

RTCP__field__reason::RTCP__field__reason(const INTEGER& par_reason__length,
    const CHARSTRING& par_reason)
  :   field_reason__length(par_reason__length),
  field_reason(par_reason)
{
}

RTCP__field__reason::RTCP__field__reason(const RTCP__field__reason& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_field_reason.");
if (other_value.reason__length().is_bound()) field_reason__length = other_value.reason__length();
else field_reason__length.clean_up();
if (other_value.reason().is_bound()) field_reason = other_value.reason();
else field_reason.clean_up();
}

void RTCP__field__reason::clean_up()
{
field_reason__length.clean_up();
field_reason.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__field__reason::get_descriptor() const { return &RTCP__field__reason_descr_; }
RTCP__field__reason& RTCP__field__reason::operator=(const RTCP__field__reason& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_field_reason.");
  if (other_value.reason__length().is_bound()) field_reason__length = other_value.reason__length();
  else field_reason__length.clean_up();
  if (other_value.reason().is_bound()) field_reason = other_value.reason();
  else field_reason.clean_up();
}
return *this;
}

boolean RTCP__field__reason::operator==(const RTCP__field__reason& other_value) const
{
return field_reason__length==other_value.field_reason__length
  && field_reason==other_value.field_reason;
}

boolean RTCP__field__reason::is_bound() const
{
return (field_reason__length.is_bound())
  || (field_reason.is_bound());
}
boolean RTCP__field__reason::is_value() const
{
return field_reason__length.is_value()
  && field_reason.is_value();
}
void RTCP__field__reason::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reason_length := ");
field_reason__length.log();
TTCN_Logger::log_event_str(", reason := ");
field_reason.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__field__reason::set_implicit_omit()
{
if (reason__length().is_bound()) reason__length().set_implicit_omit();
if (reason().is_bound()) reason().set_implicit_omit();
}

void RTCP__field__reason::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_field_reason has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reason__length().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_field_reason: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_field_reason");
  }
}

void RTCP__field__reason::encode_text(Text_Buf& text_buf) const
{
field_reason__length.encode_text(text_buf);
field_reason.encode_text(text_buf);
}

void RTCP__field__reason::decode_text(Text_Buf& text_buf)
{
field_reason__length.decode_text(text_buf);
field_reason.decode_text(text_buf);
}

void RTCP__field__reason::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__field__reason::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__field__reason::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__field__reason_reason__length_descr_.raw->forceomit);
  decoded_field_length = field_reason__length.RAW_decode(RTCP__field__reason_reason__length_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_reason__length.convert_to_Integer(RTCP__field__reason_reason__length_descr_);
  field_reason__length = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, CHARSTRING_descr_.raw->forceomit);
  decoded_field_length = field_reason.RAW_decode(CHARSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__field__reason::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__field__reason_reason__length_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CHARSTRING_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RTCP__field__reason_reason__length_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_reason.RAW_encode(CHARSTRING_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RTCP__field__reason_template::single_value_struct {
INTEGER_template field_reason__length;
CHARSTRING_template field_reason;
};

void RTCP__field__reason_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reason__length = ANY_VALUE;
single_value->field_reason = ANY_VALUE;
}
}
}

void RTCP__field__reason_template::copy_value(const RTCP__field__reason& other_value)
{
single_value = new single_value_struct;
if (other_value.reason__length().is_bound()) {
  single_value->field_reason__length = other_value.reason__length();
} else {
  single_value->field_reason__length.clean_up();
}
if (other_value.reason().is_bound()) {
  single_value->field_reason = other_value.reason();
} else {
  single_value->field_reason.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__field__reason_template::copy_template(const RTCP__field__reason_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reason__length().get_selection()) {
single_value->field_reason__length = other_value.reason__length();
} else {
single_value->field_reason__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reason().get_selection()) {
single_value->field_reason = other_value.reason();
} else {
single_value->field_reason.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__field__reason_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__field__reason_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__field__reason_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_field_reason.");
break;
}
set_selection(other_value);
}

RTCP__field__reason_template::RTCP__field__reason_template()
{
}

RTCP__field__reason_template::RTCP__field__reason_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__field__reason_template::RTCP__field__reason_template(const RTCP__field__reason& other_value)
{
copy_value(other_value);
}

RTCP__field__reason_template::RTCP__field__reason_template(const OPTIONAL<RTCP__field__reason>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__field__reason&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_field_reason from an unbound optional field.");
}
}

RTCP__field__reason_template::RTCP__field__reason_template(RTCP__field__reason_template* p_precondition, RTCP__field__reason_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__field__reason_template::RTCP__field__reason_template(Dynamic_Match_Interface<RTCP__field__reason>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__field__reason>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__field__reason_template::RTCP__field__reason_template(const RTCP__field__reason_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__field__reason_template::~RTCP__field__reason_template()
{
clean_up();
}

RTCP__field__reason_template& RTCP__field__reason_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__field__reason_template& RTCP__field__reason_template::operator=(const RTCP__field__reason& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__field__reason_template& RTCP__field__reason_template::operator=(const OPTIONAL<RTCP__field__reason>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__field__reason&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_field_reason.");
}
return *this;
}

RTCP__field__reason_template& RTCP__field__reason_template::operator=(const RTCP__field__reason_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__field__reason_template::match(const RTCP__field__reason& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reason__length().is_bound()) return FALSE;
if(!single_value->field_reason__length.match(other_value.reason__length(), legacy))return FALSE;
if(!other_value.reason().is_bound()) return FALSE;
if(!single_value->field_reason.match(other_value.reason(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_field_reason.");
}
return FALSE;
}

boolean RTCP__field__reason_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reason__length.is_bound()
 || single_value->field_reason.is_bound();
}

boolean RTCP__field__reason_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reason__length.is_value()
 && single_value->field_reason.is_value();
}

void RTCP__field__reason_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__field__reason RTCP__field__reason_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_field_reason.");
RTCP__field__reason ret_val;
if (single_value->field_reason__length.is_bound()) {
ret_val.reason__length() = single_value->field_reason__length.valueof();
}
if (single_value->field_reason.is_bound()) {
ret_val.reason() = single_value->field_reason.valueof();
}
return ret_val;
}

void RTCP__field__reason_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_field_reason.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__field__reason_template[list_length];
}

RTCP__field__reason_template& RTCP__field__reason_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_field_reason.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_field_reason.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__field__reason_template::reason__length()
{
set_specific();
return single_value->field_reason__length;
}

const INTEGER_template& RTCP__field__reason_template::reason__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reason_length of a non-specific template of type @RTP_Types.RTCP_field_reason.");
return single_value->field_reason__length;
}

CHARSTRING_template& RTCP__field__reason_template::reason()
{
set_specific();
return single_value->field_reason;
}

const CHARSTRING_template& RTCP__field__reason_template::reason() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reason of a non-specific template of type @RTP_Types.RTCP_field_reason.");
return single_value->field_reason;
}

int RTCP__field__reason_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_field_reason containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_field_reason.");
  }
  return 0;
}

void RTCP__field__reason_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reason_length := ");
single_value->field_reason__length.log();
TTCN_Logger::log_event_str(", reason := ");
single_value->field_reason.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__field__reason_template::log_match(const RTCP__field__reason& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reason__length.match(match_value.reason__length(), legacy)){
TTCN_Logger::log_logmatch_info(".reason_length");
single_value->field_reason__length.log_match(match_value.reason__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reason.match(match_value.reason(), legacy)){
TTCN_Logger::log_logmatch_info(".reason");
single_value->field_reason.log_match(match_value.reason(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reason_length := ");
single_value->field_reason__length.log_match(match_value.reason__length(), legacy);
TTCN_Logger::log_event_str(", reason := ");
single_value->field_reason.log_match(match_value.reason(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__field__reason_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (reason__length().is_bound()) reason__length().set_implicit_omit();
if (reason().is_bound()) reason().set_implicit_omit();
}

void RTCP__field__reason_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reason__length.encode_text(text_buf);
single_value->field_reason.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_field_reason.");
}
}

void RTCP__field__reason_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reason__length.decode_text(text_buf);
single_value->field_reason.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__field__reason_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_field_reason.");
}
}

void RTCP__field__reason_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__field__reason_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_field_reason has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reason__length().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_field_reason: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__field__reason_template* precondition = new RTCP__field__reason_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__field__reason_template* implied_template = new RTCP__field__reason_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__field__reason_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_field_reason");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__field__reason_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reason__length.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_field_reason");
single_value->field_reason.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_field_reason");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_field_reason");
}

boolean RTCP__field__reason_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__field__reason_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RTCP__IE__BYE::RTCP__IE__BYE()
{
}

RTCP__IE__BYE::RTCP__IE__BYE(const INTEGER& par_version,
    const BITSTRING& par_padding__ind,
    const INTEGER& par_source__count,
    const INTEGER& par_payload__type,
    const INTEGER& par_packet__length,
    const OPTIONAL< RTP__CSRC__list >& par_SSRC__CSRC__ids,
    const OPTIONAL< RTCP__field__reason >& par_reason,
    const OPTIONAL< OCTETSTRING >& par_padding)
  :   field_version(par_version),
  field_padding__ind(par_padding__ind),
  field_source__count(par_source__count),
  field_payload__type(par_payload__type),
  field_packet__length(par_packet__length),
  field_SSRC__CSRC__ids(par_SSRC__CSRC__ids),
  field_reason(par_reason),
  field_padding(par_padding)
{
}

RTCP__IE__BYE::RTCP__IE__BYE(const RTCP__IE__BYE& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_IE_BYE.");
if (other_value.version().is_bound()) field_version = other_value.version();
else field_version.clean_up();
if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
else field_padding__ind.clean_up();
if (other_value.source__count().is_bound()) field_source__count = other_value.source__count();
else field_source__count.clean_up();
if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
else field_payload__type.clean_up();
if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
else field_packet__length.clean_up();
if (other_value.SSRC__CSRC__ids().is_bound()) field_SSRC__CSRC__ids = other_value.SSRC__CSRC__ids();
else field_SSRC__CSRC__ids.clean_up();
if (other_value.reason().is_bound()) field_reason = other_value.reason();
else field_reason.clean_up();
if (other_value.padding().is_bound()) field_padding = other_value.padding();
else field_padding.clean_up();
}

void RTCP__IE__BYE::clean_up()
{
field_version.clean_up();
field_padding__ind.clean_up();
field_source__count.clean_up();
field_payload__type.clean_up();
field_packet__length.clean_up();
field_SSRC__CSRC__ids.clean_up();
field_reason.clean_up();
field_padding.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__IE__BYE::get_descriptor() const { return &RTCP__IE__BYE_descr_; }
RTCP__IE__BYE& RTCP__IE__BYE::operator=(const RTCP__IE__BYE& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_IE_BYE.");
  if (other_value.version().is_bound()) field_version = other_value.version();
  else field_version.clean_up();
  if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
  else field_padding__ind.clean_up();
  if (other_value.source__count().is_bound()) field_source__count = other_value.source__count();
  else field_source__count.clean_up();
  if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
  else field_payload__type.clean_up();
  if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
  else field_packet__length.clean_up();
  if (other_value.SSRC__CSRC__ids().is_bound()) field_SSRC__CSRC__ids = other_value.SSRC__CSRC__ids();
  else field_SSRC__CSRC__ids.clean_up();
  if (other_value.reason().is_bound()) field_reason = other_value.reason();
  else field_reason.clean_up();
  if (other_value.padding().is_bound()) field_padding = other_value.padding();
  else field_padding.clean_up();
}
return *this;
}

boolean RTCP__IE__BYE::operator==(const RTCP__IE__BYE& other_value) const
{
return field_version==other_value.field_version
  && field_padding__ind==other_value.field_padding__ind
  && field_source__count==other_value.field_source__count
  && field_payload__type==other_value.field_payload__type
  && field_packet__length==other_value.field_packet__length
  && field_SSRC__CSRC__ids==other_value.field_SSRC__CSRC__ids
  && field_reason==other_value.field_reason
  && field_padding==other_value.field_padding;
}

boolean RTCP__IE__BYE::is_bound() const
{
return (field_version.is_bound())
  || (field_padding__ind.is_bound())
  || (field_source__count.is_bound())
  || (field_payload__type.is_bound())
  || (field_packet__length.is_bound())
  || (OPTIONAL_OMIT == field_SSRC__CSRC__ids.get_selection() || field_SSRC__CSRC__ids.is_bound())
  || (OPTIONAL_OMIT == field_reason.get_selection() || field_reason.is_bound())
  || (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_bound());
}
boolean RTCP__IE__BYE::is_value() const
{
return field_version.is_value()
  && field_padding__ind.is_value()
  && field_source__count.is_value()
  && field_payload__type.is_value()
  && field_packet__length.is_value()
  && (OPTIONAL_OMIT == field_SSRC__CSRC__ids.get_selection() || field_SSRC__CSRC__ids.is_value())
  && (OPTIONAL_OMIT == field_reason.get_selection() || field_reason.is_value())
  && (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_value());
}
int RTCP__IE__BYE::size_of() const
{
  int ret_val = 5;
  if (field_SSRC__CSRC__ids.ispresent()) ret_val++;
  if (field_reason.ispresent()) ret_val++;
  if (field_padding.ispresent()) ret_val++;
  return ret_val;
}

void RTCP__IE__BYE::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version := ");
field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
field_padding__ind.log();
TTCN_Logger::log_event_str(", source_count := ");
field_source__count.log();
TTCN_Logger::log_event_str(", payload_type := ");
field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_CSRC_ids := ");
field_SSRC__CSRC__ids.log();
TTCN_Logger::log_event_str(", reason := ");
field_reason.log();
TTCN_Logger::log_event_str(", padding := ");
field_padding.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__IE__BYE::set_implicit_omit()
{
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (source__count().is_bound()) source__count().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (!SSRC__CSRC__ids().is_bound()) SSRC__CSRC__ids() = OMIT_VALUE;
else SSRC__CSRC__ids().set_implicit_omit();
if (!reason().is_bound()) reason() = OMIT_VALUE;
else reason().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__BYE::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_IE_BYE has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) source__count().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__CSRC__ids().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_CSRC_ids")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__CSRC__ids().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_BYE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_IE_BYE");
  }
}

void RTCP__IE__BYE::encode_text(Text_Buf& text_buf) const
{
field_version.encode_text(text_buf);
field_padding__ind.encode_text(text_buf);
field_source__count.encode_text(text_buf);
field_payload__type.encode_text(text_buf);
field_packet__length.encode_text(text_buf);
field_SSRC__CSRC__ids.encode_text(text_buf);
field_reason.encode_text(text_buf);
field_padding.encode_text(text_buf);
}

void RTCP__IE__BYE::decode_text(Text_Buf& text_buf)
{
field_version.decode_text(text_buf);
field_padding__ind.decode_text(text_buf);
field_source__count.decode_text(text_buf);
field_payload__type.decode_text(text_buf);
field_packet__length.decode_text(text_buf);
field_SSRC__CSRC__ids.decode_text(text_buf);
field_reason.decode_text(text_buf);
field_padding.decode_text(text_buf);
}

void RTCP__IE__BYE::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__IE__BYE::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__IE__BYE::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  int value_of_length_field4 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__IE__BYE_version_descr_.raw->forceomit);
  decoded_field_length = field_version.RAW_decode(RTCP__IE__BYE_version_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__IE__BYE_padding__ind_descr_.raw->forceomit);
  decoded_field_length = field_padding__ind.RAW_decode(RTCP__IE__BYE_padding__ind_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__IE__BYE_source__count_descr_.raw->forceomit);
  decoded_field_length = field_source__count.RAW_decode(RTCP__IE__BYE_source__count_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp2 = field_source__count.convert_to_Integer(RTCP__IE__BYE_source__count_descr_);
  field_source__count = tmp2;
  value_of_length_field2 += tmp2.get_long_long_val() * 1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__IE__BYE_payload__type_descr_.raw->forceomit);
  decoded_field_length = field_payload__type.RAW_decode(RTCP__IE__BYE_payload__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RTCP__IE__BYE_packet__length_descr_.raw->forceomit);
  decoded_field_length = field_packet__length.RAW_decode(RTCP__IE__BYE_packet__length_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp4 = field_packet__length.convert_to_Integer(RTCP__IE__BYE_packet__length_descr_);
  field_packet__length = tmp4;
  value_of_length_field4 += tmp4.get_long_long_val() * 32;
  if (limit > 0 && value_of_length_field2 > 0 && value_of_length_field4 > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_SSRC__CSRC__ids = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, RTCP__IE__BYE_SSRC__CSRC__ids_descr_.raw->forceomit);
  decoded_field_length = field_SSRC__CSRC__ids().RAW_decode(RTCP__IE__BYE_SSRC__CSRC__ids_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, value_of_length_field2, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_SSRC__CSRC__ids = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_SSRC__CSRC__ids=OMIT_VALUE;
  if (limit > 0 && value_of_length_field4 > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_reason = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, RTCP__IE__BYE_reason_descr_.raw->forceomit);
  decoded_field_length = field_reason().RAW_decode(RTCP__IE__BYE_reason_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_reason = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_reason=OMIT_VALUE;
  if (limit > 0 && value_of_length_field4 > 0 && field_padding__ind ==  bs_0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_padding = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RTCP__IE__BYE_padding_descr_.raw->forceomit);
  decoded_field_length = field_padding().RAW_decode(RTCP__IE__BYE_padding_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_padding = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_padding=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__IE__BYE::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__IE__BYE_version_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__IE__BYE_padding__ind_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__IE__BYE_source__count_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RTCP__IE__BYE_payload__type_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RTCP__IE__BYE_packet__length_descr_.raw);
  if (field_SSRC__CSRC__ids.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RTCP__IE__BYE_SSRC__CSRC__ids_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_reason.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RTCP__IE__BYE_reason_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RTCP__IE__BYE_padding_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_version.RAW_encode(RTCP__IE__BYE_version_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_padding__ind.RAW_encode(RTCP__IE__BYE_padding__ind_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += 5;
  myleaf.body.node.nodes[2]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->coding_descr = &RTCP__IE__BYE_source__count_descr_;
  myleaf.body.node.nodes[2]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[2]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->length = 5;
  if (field_SSRC__CSRC__ids.ispresent()) {
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].pos = 0;
  }
  encoded_length += field_payload__type.RAW_encode(RTCP__IE__BYE_payload__type_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += 16;
  myleaf.body.node.nodes[4]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[4]->coding_descr = &RTCP__IE__BYE_packet__length_descr_;
  myleaf.body.node.nodes[4]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[4]->calcof.lengthto.unit = 32;
  myleaf.body.node.nodes[4]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[4]->length = 16;
  if (field_SSRC__CSRC__ids.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = 0;
  }
  if (field_reason.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = 0;
  }
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = 0;
  }
  if (field_SSRC__CSRC__ids.ispresent()) {
  encoded_length += field_SSRC__CSRC__ids().RAW_encode(RTCP__IE__BYE_SSRC__CSRC__ids_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_reason.ispresent()) {
  encoded_length += field_reason().RAW_encode(RTCP__IE__BYE_reason_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_padding.ispresent()) {
  encoded_length += field_padding().RAW_encode(RTCP__IE__BYE_padding_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_padding.ispresent() && (field_padding__ind !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(RTCP__IE__BYE_padding__ind_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RTCP__IE__BYE_template::single_value_struct {
INTEGER_template field_version;
BITSTRING_template field_padding__ind;
INTEGER_template field_source__count;
INTEGER_template field_payload__type;
INTEGER_template field_packet__length;
RTP__CSRC__list_template field_SSRC__CSRC__ids;
RTCP__field__reason_template field_reason;
OCTETSTRING_template field_padding;
};

void RTCP__IE__BYE_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version = ANY_VALUE;
single_value->field_padding__ind = ANY_VALUE;
single_value->field_source__count = ANY_VALUE;
single_value->field_payload__type = ANY_VALUE;
single_value->field_packet__length = ANY_VALUE;
single_value->field_SSRC__CSRC__ids = ANY_OR_OMIT;
single_value->field_reason = ANY_OR_OMIT;
single_value->field_padding = ANY_OR_OMIT;
}
}
}

void RTCP__IE__BYE_template::copy_value(const RTCP__IE__BYE& other_value)
{
single_value = new single_value_struct;
if (other_value.version().is_bound()) {
  single_value->field_version = other_value.version();
} else {
  single_value->field_version.clean_up();
}
if (other_value.padding__ind().is_bound()) {
  single_value->field_padding__ind = other_value.padding__ind();
} else {
  single_value->field_padding__ind.clean_up();
}
if (other_value.source__count().is_bound()) {
  single_value->field_source__count = other_value.source__count();
} else {
  single_value->field_source__count.clean_up();
}
if (other_value.payload__type().is_bound()) {
  single_value->field_payload__type = other_value.payload__type();
} else {
  single_value->field_payload__type.clean_up();
}
if (other_value.packet__length().is_bound()) {
  single_value->field_packet__length = other_value.packet__length();
} else {
  single_value->field_packet__length.clean_up();
}
if (other_value.SSRC__CSRC__ids().is_bound()) {
  if (other_value.SSRC__CSRC__ids().ispresent()) single_value->field_SSRC__CSRC__ids = other_value.SSRC__CSRC__ids()();
  else single_value->field_SSRC__CSRC__ids = OMIT_VALUE;
} else {
  single_value->field_SSRC__CSRC__ids.clean_up();
}
if (other_value.reason().is_bound()) {
  if (other_value.reason().ispresent()) single_value->field_reason = other_value.reason()();
  else single_value->field_reason = OMIT_VALUE;
} else {
  single_value->field_reason.clean_up();
}
if (other_value.padding().is_bound()) {
  if (other_value.padding().ispresent()) single_value->field_padding = other_value.padding()();
  else single_value->field_padding = OMIT_VALUE;
} else {
  single_value->field_padding.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__IE__BYE_template::copy_template(const RTCP__IE__BYE_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version().get_selection()) {
single_value->field_version = other_value.version();
} else {
single_value->field_version.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding__ind().get_selection()) {
single_value->field_padding__ind = other_value.padding__ind();
} else {
single_value->field_padding__ind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.source__count().get_selection()) {
single_value->field_source__count = other_value.source__count();
} else {
single_value->field_source__count.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload__type().get_selection()) {
single_value->field_payload__type = other_value.payload__type();
} else {
single_value->field_payload__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packet__length().get_selection()) {
single_value->field_packet__length = other_value.packet__length();
} else {
single_value->field_packet__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.SSRC__CSRC__ids().get_selection()) {
single_value->field_SSRC__CSRC__ids = other_value.SSRC__CSRC__ids();
} else {
single_value->field_SSRC__CSRC__ids.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reason().get_selection()) {
single_value->field_reason = other_value.reason();
} else {
single_value->field_reason.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding().get_selection()) {
single_value->field_padding = other_value.padding();
} else {
single_value->field_padding.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__IE__BYE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__IE__BYE_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__IE__BYE_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_BYE.");
break;
}
set_selection(other_value);
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template()
{
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(const RTCP__IE__BYE& other_value)
{
copy_value(other_value);
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(const OPTIONAL<RTCP__IE__BYE>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__BYE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_IE_BYE from an unbound optional field.");
}
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(RTCP__IE__BYE_template* p_precondition, RTCP__IE__BYE_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(Dynamic_Match_Interface<RTCP__IE__BYE>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__IE__BYE>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__IE__BYE_template::RTCP__IE__BYE_template(const RTCP__IE__BYE_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__IE__BYE_template::~RTCP__IE__BYE_template()
{
clean_up();
}

RTCP__IE__BYE_template& RTCP__IE__BYE_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__IE__BYE_template& RTCP__IE__BYE_template::operator=(const RTCP__IE__BYE& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__IE__BYE_template& RTCP__IE__BYE_template::operator=(const OPTIONAL<RTCP__IE__BYE>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__BYE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_IE_BYE.");
}
return *this;
}

RTCP__IE__BYE_template& RTCP__IE__BYE_template::operator=(const RTCP__IE__BYE_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__IE__BYE_template::match(const RTCP__IE__BYE& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version().is_bound()) return FALSE;
if(!single_value->field_version.match(other_value.version(), legacy))return FALSE;
if(!other_value.padding__ind().is_bound()) return FALSE;
if(!single_value->field_padding__ind.match(other_value.padding__ind(), legacy))return FALSE;
if(!other_value.source__count().is_bound()) return FALSE;
if(!single_value->field_source__count.match(other_value.source__count(), legacy))return FALSE;
if(!other_value.payload__type().is_bound()) return FALSE;
if(!single_value->field_payload__type.match(other_value.payload__type(), legacy))return FALSE;
if(!other_value.packet__length().is_bound()) return FALSE;
if(!single_value->field_packet__length.match(other_value.packet__length(), legacy))return FALSE;
if(!other_value.SSRC__CSRC__ids().is_bound()) return FALSE;
if((other_value.SSRC__CSRC__ids().ispresent() ? !single_value->field_SSRC__CSRC__ids.match((const RTP__CSRC__list&)other_value.SSRC__CSRC__ids(), legacy) : !single_value->field_SSRC__CSRC__ids.match_omit(legacy)))return FALSE;
if(!other_value.reason().is_bound()) return FALSE;
if((other_value.reason().ispresent() ? !single_value->field_reason.match((const RTCP__field__reason&)other_value.reason(), legacy) : !single_value->field_reason.match_omit(legacy)))return FALSE;
if(!other_value.padding().is_bound()) return FALSE;
if((other_value.padding().ispresent() ? !single_value->field_padding.match((const OCTETSTRING&)other_value.padding(), legacy) : !single_value->field_padding.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_BYE.");
}
return FALSE;
}

boolean RTCP__IE__BYE_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version.is_bound()
 || single_value->field_padding__ind.is_bound()
 || single_value->field_source__count.is_bound()
 || single_value->field_payload__type.is_bound()
 || single_value->field_packet__length.is_bound()
 || (single_value->field_SSRC__CSRC__ids.is_omit() || single_value->field_SSRC__CSRC__ids.is_bound())
 || (single_value->field_reason.is_omit() || single_value->field_reason.is_bound())
 || (single_value->field_padding.is_omit() || single_value->field_padding.is_bound());
}

boolean RTCP__IE__BYE_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version.is_value()
 && single_value->field_padding__ind.is_value()
 && single_value->field_source__count.is_value()
 && single_value->field_payload__type.is_value()
 && single_value->field_packet__length.is_value()
 && (single_value->field_SSRC__CSRC__ids.is_omit() || single_value->field_SSRC__CSRC__ids.is_value())
 && (single_value->field_reason.is_omit() || single_value->field_reason.is_value())
 && (single_value->field_padding.is_omit() || single_value->field_padding.is_value());
}

void RTCP__IE__BYE_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__IE__BYE RTCP__IE__BYE_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
RTCP__IE__BYE ret_val;
if (single_value->field_version.is_bound()) {
ret_val.version() = single_value->field_version.valueof();
}
if (single_value->field_padding__ind.is_bound()) {
ret_val.padding__ind() = single_value->field_padding__ind.valueof();
}
if (single_value->field_source__count.is_bound()) {
ret_val.source__count() = single_value->field_source__count.valueof();
}
if (single_value->field_payload__type.is_bound()) {
ret_val.payload__type() = single_value->field_payload__type.valueof();
}
if (single_value->field_packet__length.is_bound()) {
ret_val.packet__length() = single_value->field_packet__length.valueof();
}
if (single_value->field_SSRC__CSRC__ids.is_omit()) ret_val.SSRC__CSRC__ids() = OMIT_VALUE;
else if (single_value->field_SSRC__CSRC__ids.is_bound()) {
ret_val.SSRC__CSRC__ids() = single_value->field_SSRC__CSRC__ids.valueof();
}
if (single_value->field_reason.is_omit()) ret_val.reason() = OMIT_VALUE;
else if (single_value->field_reason.is_bound()) {
ret_val.reason() = single_value->field_reason.valueof();
}
if (single_value->field_padding.is_omit()) ret_val.padding() = OMIT_VALUE;
else if (single_value->field_padding.is_bound()) {
ret_val.padding() = single_value->field_padding.valueof();
}
return ret_val;
}

void RTCP__IE__BYE_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_IE_BYE.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__IE__BYE_template[list_length];
}

RTCP__IE__BYE_template& RTCP__IE__BYE_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_IE_BYE.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_IE_BYE.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__IE__BYE_template::version()
{
set_specific();
return single_value->field_version;
}

const INTEGER_template& RTCP__IE__BYE_template::version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_version;
}

BITSTRING_template& RTCP__IE__BYE_template::padding__ind()
{
set_specific();
return single_value->field_padding__ind;
}

const BITSTRING_template& RTCP__IE__BYE_template::padding__ind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding_ind of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_padding__ind;
}

INTEGER_template& RTCP__IE__BYE_template::source__count()
{
set_specific();
return single_value->field_source__count;
}

const INTEGER_template& RTCP__IE__BYE_template::source__count() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field source_count of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_source__count;
}

INTEGER_template& RTCP__IE__BYE_template::payload__type()
{
set_specific();
return single_value->field_payload__type;
}

const INTEGER_template& RTCP__IE__BYE_template::payload__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload_type of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_payload__type;
}

INTEGER_template& RTCP__IE__BYE_template::packet__length()
{
set_specific();
return single_value->field_packet__length;
}

const INTEGER_template& RTCP__IE__BYE_template::packet__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packet_length of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_packet__length;
}

RTP__CSRC__list_template& RTCP__IE__BYE_template::SSRC__CSRC__ids()
{
set_specific();
return single_value->field_SSRC__CSRC__ids;
}

const RTP__CSRC__list_template& RTCP__IE__BYE_template::SSRC__CSRC__ids() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC_CSRC_ids of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_SSRC__CSRC__ids;
}

RTCP__field__reason_template& RTCP__IE__BYE_template::reason()
{
set_specific();
return single_value->field_reason;
}

const RTCP__field__reason_template& RTCP__IE__BYE_template::reason() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reason of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_reason;
}

OCTETSTRING_template& RTCP__IE__BYE_template::padding()
{
set_specific();
return single_value->field_padding;
}

const OCTETSTRING_template& RTCP__IE__BYE_template::padding() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding of a non-specific template of type @RTP_Types.RTCP_IE_BYE.");
return single_value->field_padding;
}

int RTCP__IE__BYE_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_SSRC__CSRC__ids.is_present()) ret_val++;
      if (single_value->field_reason.is_present()) ret_val++;
      if (single_value->field_padding.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_BYE containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_BYE.");
  }
  return 0;
}

void RTCP__IE__BYE_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log();
TTCN_Logger::log_event_str(", source_count := ");
single_value->field_source__count.log();
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_CSRC_ids := ");
single_value->field_SSRC__CSRC__ids.log();
TTCN_Logger::log_event_str(", reason := ");
single_value->field_reason.log();
TTCN_Logger::log_event_str(", padding := ");
single_value->field_padding.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__IE__BYE_template::log_match(const RTCP__IE__BYE& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version.match(match_value.version(), legacy)){
TTCN_Logger::log_logmatch_info(".version");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_padding__ind.match(match_value.padding__ind(), legacy)){
TTCN_Logger::log_logmatch_info(".padding_ind");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_source__count.match(match_value.source__count(), legacy)){
TTCN_Logger::log_logmatch_info(".source_count");
single_value->field_source__count.log_match(match_value.source__count(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload__type.match(match_value.payload__type(), legacy)){
TTCN_Logger::log_logmatch_info(".payload_type");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packet__length.match(match_value.packet__length(), legacy)){
TTCN_Logger::log_logmatch_info(".packet_length");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.SSRC__CSRC__ids().ispresent()){
if(!single_value->field_SSRC__CSRC__ids.match(match_value.SSRC__CSRC__ids(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC_CSRC_ids");
single_value->field_SSRC__CSRC__ids.log_match(match_value.SSRC__CSRC__ids(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_SSRC__CSRC__ids.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".SSRC_CSRC_ids := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_SSRC__CSRC__ids.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.reason().ispresent()){
if(!single_value->field_reason.match(match_value.reason(), legacy)){
TTCN_Logger::log_logmatch_info(".reason");
single_value->field_reason.log_match(match_value.reason(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_reason.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".reason := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_reason.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.padding().ispresent()){
if(!single_value->field_padding.match(match_value.padding(), legacy)){
TTCN_Logger::log_logmatch_info(".padding");
single_value->field_padding.log_match(match_value.padding(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_padding.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".padding := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_padding.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::log_event_str(", source_count := ");
single_value->field_source__count.log_match(match_value.source__count(), legacy);
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::log_event_str(", SSRC_CSRC_ids := ");
if (match_value.SSRC__CSRC__ids().ispresent()) {
single_value->field_SSRC__CSRC__ids.log_match(match_value.SSRC__CSRC__ids(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_SSRC__CSRC__ids.log();
if (single_value->field_SSRC__CSRC__ids.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", reason := ");
if (match_value.reason().ispresent()) {
single_value->field_reason.log_match(match_value.reason(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_reason.log();
if (single_value->field_reason.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", padding := ");
if (match_value.padding().ispresent()) {
single_value->field_padding.log_match(match_value.padding(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_padding.log();
if (single_value->field_padding.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__IE__BYE_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (source__count().is_bound()) source__count().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (!SSRC__CSRC__ids().is_bound()) SSRC__CSRC__ids() = OMIT_VALUE;
else SSRC__CSRC__ids().set_implicit_omit();
if (!reason().is_bound()) reason() = OMIT_VALUE;
else reason().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__BYE_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version.encode_text(text_buf);
single_value->field_padding__ind.encode_text(text_buf);
single_value->field_source__count.encode_text(text_buf);
single_value->field_payload__type.encode_text(text_buf);
single_value->field_packet__length.encode_text(text_buf);
single_value->field_SSRC__CSRC__ids.encode_text(text_buf);
single_value->field_reason.encode_text(text_buf);
single_value->field_padding.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_BYE.");
}
}

void RTCP__IE__BYE_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version.decode_text(text_buf);
single_value->field_padding__ind.decode_text(text_buf);
single_value->field_source__count.decode_text(text_buf);
single_value->field_payload__type.decode_text(text_buf);
single_value->field_packet__length.decode_text(text_buf);
single_value->field_SSRC__CSRC__ids.decode_text(text_buf);
single_value->field_reason.decode_text(text_buf);
single_value->field_padding.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__IE__BYE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_IE_BYE.");
}
}

void RTCP__IE__BYE_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__IE__BYE_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_IE_BYE has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) source__count().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__CSRC__ids().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_CSRC_ids")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__CSRC__ids().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_BYE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__IE__BYE_template* precondition = new RTCP__IE__BYE_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__IE__BYE_template* implied_template = new RTCP__IE__BYE_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__IE__BYE_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_IE_BYE");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__IE__BYE_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_padding__ind.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_source__count.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_payload__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_packet__length.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_SSRC__CSRC__ids.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_reason.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
single_value->field_padding.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_IE_BYE");
}

boolean RTCP__IE__BYE_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__IE__BYE_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RTCP__IE__APP::RTCP__IE__APP()
{
}

RTCP__IE__APP::RTCP__IE__APP(const INTEGER& par_version,
    const BITSTRING& par_padding__ind,
    const INTEGER& par_sub__type,
    const INTEGER& par_payload__type,
    const INTEGER& par_packet__length,
    const BITSTRING& par_SSRC__CSRC__id,
    const CHARSTRING& par_name,
    const OPTIONAL< OCTETSTRING >& par_appdata,
    const OPTIONAL< OCTETSTRING >& par_padding)
  :   field_version(par_version),
  field_padding__ind(par_padding__ind),
  field_sub__type(par_sub__type),
  field_payload__type(par_payload__type),
  field_packet__length(par_packet__length),
  field_SSRC__CSRC__id(par_SSRC__CSRC__id),
  field_name(par_name),
  field_appdata(par_appdata),
  field_padding(par_padding)
{
}

RTCP__IE__APP::RTCP__IE__APP(const RTCP__IE__APP& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_IE_APP.");
if (other_value.version().is_bound()) field_version = other_value.version();
else field_version.clean_up();
if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
else field_padding__ind.clean_up();
if (other_value.sub__type().is_bound()) field_sub__type = other_value.sub__type();
else field_sub__type.clean_up();
if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
else field_payload__type.clean_up();
if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
else field_packet__length.clean_up();
if (other_value.SSRC__CSRC__id().is_bound()) field_SSRC__CSRC__id = other_value.SSRC__CSRC__id();
else field_SSRC__CSRC__id.clean_up();
if (other_value.name().is_bound()) field_name = other_value.name();
else field_name.clean_up();
if (other_value.appdata().is_bound()) field_appdata = other_value.appdata();
else field_appdata.clean_up();
if (other_value.padding().is_bound()) field_padding = other_value.padding();
else field_padding.clean_up();
}

void RTCP__IE__APP::clean_up()
{
field_version.clean_up();
field_padding__ind.clean_up();
field_sub__type.clean_up();
field_payload__type.clean_up();
field_packet__length.clean_up();
field_SSRC__CSRC__id.clean_up();
field_name.clean_up();
field_appdata.clean_up();
field_padding.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__IE__APP::get_descriptor() const { return &RTCP__IE__APP_descr_; }
RTCP__IE__APP& RTCP__IE__APP::operator=(const RTCP__IE__APP& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_IE_APP.");
  if (other_value.version().is_bound()) field_version = other_value.version();
  else field_version.clean_up();
  if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
  else field_padding__ind.clean_up();
  if (other_value.sub__type().is_bound()) field_sub__type = other_value.sub__type();
  else field_sub__type.clean_up();
  if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
  else field_payload__type.clean_up();
  if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
  else field_packet__length.clean_up();
  if (other_value.SSRC__CSRC__id().is_bound()) field_SSRC__CSRC__id = other_value.SSRC__CSRC__id();
  else field_SSRC__CSRC__id.clean_up();
  if (other_value.name().is_bound()) field_name = other_value.name();
  else field_name.clean_up();
  if (other_value.appdata().is_bound()) field_appdata = other_value.appdata();
  else field_appdata.clean_up();
  if (other_value.padding().is_bound()) field_padding = other_value.padding();
  else field_padding.clean_up();
}
return *this;
}

boolean RTCP__IE__APP::operator==(const RTCP__IE__APP& other_value) const
{
return field_version==other_value.field_version
  && field_padding__ind==other_value.field_padding__ind
  && field_sub__type==other_value.field_sub__type
  && field_payload__type==other_value.field_payload__type
  && field_packet__length==other_value.field_packet__length
  && field_SSRC__CSRC__id==other_value.field_SSRC__CSRC__id
  && field_name==other_value.field_name
  && field_appdata==other_value.field_appdata
  && field_padding==other_value.field_padding;
}

boolean RTCP__IE__APP::is_bound() const
{
return (field_version.is_bound())
  || (field_padding__ind.is_bound())
  || (field_sub__type.is_bound())
  || (field_payload__type.is_bound())
  || (field_packet__length.is_bound())
  || (field_SSRC__CSRC__id.is_bound())
  || (field_name.is_bound())
  || (OPTIONAL_OMIT == field_appdata.get_selection() || field_appdata.is_bound())
  || (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_bound());
}
boolean RTCP__IE__APP::is_value() const
{
return field_version.is_value()
  && field_padding__ind.is_value()
  && field_sub__type.is_value()
  && field_payload__type.is_value()
  && field_packet__length.is_value()
  && field_SSRC__CSRC__id.is_value()
  && field_name.is_value()
  && (OPTIONAL_OMIT == field_appdata.get_selection() || field_appdata.is_value())
  && (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_value());
}
int RTCP__IE__APP::size_of() const
{
  int ret_val = 7;
  if (field_appdata.ispresent()) ret_val++;
  if (field_padding.ispresent()) ret_val++;
  return ret_val;
}

void RTCP__IE__APP::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version := ");
field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
field_padding__ind.log();
TTCN_Logger::log_event_str(", sub_type := ");
field_sub__type.log();
TTCN_Logger::log_event_str(", payload_type := ");
field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_CSRC_id := ");
field_SSRC__CSRC__id.log();
TTCN_Logger::log_event_str(", name := ");
field_name.log();
TTCN_Logger::log_event_str(", appdata := ");
field_appdata.log();
TTCN_Logger::log_event_str(", padding := ");
field_padding.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__IE__APP::set_implicit_omit()
{
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (sub__type().is_bound()) sub__type().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (SSRC__CSRC__id().is_bound()) SSRC__CSRC__id().set_implicit_omit();
if (name().is_bound()) name().set_implicit_omit();
if (!appdata().is_bound()) appdata() = OMIT_VALUE;
else appdata().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__APP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_IE_APP has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sub__type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__CSRC__id().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) name().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) appdata().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sub_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sub__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_CSRC_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__CSRC__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "appdata")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          appdata().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_APP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_IE_APP");
  }
}

void RTCP__IE__APP::encode_text(Text_Buf& text_buf) const
{
field_version.encode_text(text_buf);
field_padding__ind.encode_text(text_buf);
field_sub__type.encode_text(text_buf);
field_payload__type.encode_text(text_buf);
field_packet__length.encode_text(text_buf);
field_SSRC__CSRC__id.encode_text(text_buf);
field_name.encode_text(text_buf);
field_appdata.encode_text(text_buf);
field_padding.encode_text(text_buf);
}

void RTCP__IE__APP::decode_text(Text_Buf& text_buf)
{
field_version.decode_text(text_buf);
field_padding__ind.decode_text(text_buf);
field_sub__type.decode_text(text_buf);
field_payload__type.decode_text(text_buf);
field_packet__length.decode_text(text_buf);
field_SSRC__CSRC__id.decode_text(text_buf);
field_name.decode_text(text_buf);
field_appdata.decode_text(text_buf);
field_padding.decode_text(text_buf);
}

void RTCP__IE__APP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__IE__APP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__IE__APP::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field4 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__IE__APP_version_descr_.raw->forceomit);
  decoded_field_length = field_version.RAW_decode(RTCP__IE__APP_version_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__IE__APP_padding__ind_descr_.raw->forceomit);
  decoded_field_length = field_padding__ind.RAW_decode(RTCP__IE__APP_padding__ind_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__IE__APP_sub__type_descr_.raw->forceomit);
  decoded_field_length = field_sub__type.RAW_decode(RTCP__IE__APP_sub__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__IE__APP_payload__type_descr_.raw->forceomit);
  decoded_field_length = field_payload__type.RAW_decode(RTCP__IE__APP_payload__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RTCP__IE__APP_packet__length_descr_.raw->forceomit);
  decoded_field_length = field_packet__length.RAW_decode(RTCP__IE__APP_packet__length_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp4 = field_packet__length.convert_to_Integer(RTCP__IE__APP_packet__length_descr_);
  field_packet__length = tmp4;
  value_of_length_field4 += tmp4.get_long_long_val() * 32;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RTCP__IE__APP_SSRC__CSRC__id_descr_.raw->forceomit);
  decoded_field_length = field_SSRC__CSRC__id.RAW_decode(RTCP__IE__APP_SSRC__CSRC__id_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RTCP__IE__APP_name_descr_.raw->forceomit);
  decoded_field_length = field_name.RAW_decode(RTCP__IE__APP_name_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  if (limit > 0 && value_of_length_field4 > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_appdata = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RTCP__IE__APP_appdata_descr_.raw->forceomit);
  decoded_field_length = field_appdata().RAW_decode(RTCP__IE__APP_appdata_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_appdata = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_appdata=OMIT_VALUE;
  if (limit > 0 && value_of_length_field4 > 0 && field_padding__ind ==  bs_0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_padding = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, RTCP__IE__APP_padding_descr_.raw->forceomit);
  decoded_field_length = field_padding().RAW_decode(RTCP__IE__APP_padding_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_padding = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_padding=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__IE__APP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__IE__APP_version_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__IE__APP_padding__ind_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__IE__APP_sub__type_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RTCP__IE__APP_payload__type_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RTCP__IE__APP_packet__length_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RTCP__IE__APP_SSRC__CSRC__id_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RTCP__IE__APP_name_descr_.raw);
  if (field_appdata.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RTCP__IE__APP_appdata_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, RTCP__IE__APP_padding_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_version.RAW_encode(RTCP__IE__APP_version_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_padding__ind.RAW_encode(RTCP__IE__APP_padding__ind_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_sub__type.RAW_encode(RTCP__IE__APP_sub__type_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_payload__type.RAW_encode(RTCP__IE__APP_payload__type_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += 16;
  myleaf.body.node.nodes[4]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[4]->coding_descr = &RTCP__IE__APP_packet__length_descr_;
  myleaf.body.node.nodes[4]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[4]->calcof.lengthto.unit = 32;
  myleaf.body.node.nodes[4]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[4]->length = 16;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  if (field_appdata.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = 0;
  }
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].pos = 0;
  }
  encoded_length += field_SSRC__CSRC__id.RAW_encode(RTCP__IE__APP_SSRC__CSRC__id_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_name.RAW_encode(RTCP__IE__APP_name_descr_, *myleaf.body.node.nodes[6]);
  if (field_appdata.ispresent()) {
  encoded_length += field_appdata().RAW_encode(RTCP__IE__APP_appdata_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_padding.ispresent()) {
  encoded_length += field_padding().RAW_encode(RTCP__IE__APP_padding_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_padding.ispresent() && (field_padding__ind !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(RTCP__IE__APP_padding__ind_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RTCP__IE__APP_template::single_value_struct {
INTEGER_template field_version;
BITSTRING_template field_padding__ind;
INTEGER_template field_sub__type;
INTEGER_template field_payload__type;
INTEGER_template field_packet__length;
BITSTRING_template field_SSRC__CSRC__id;
CHARSTRING_template field_name;
OCTETSTRING_template field_appdata;
OCTETSTRING_template field_padding;
};

void RTCP__IE__APP_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version = ANY_VALUE;
single_value->field_padding__ind = ANY_VALUE;
single_value->field_sub__type = ANY_VALUE;
single_value->field_payload__type = ANY_VALUE;
single_value->field_packet__length = ANY_VALUE;
single_value->field_SSRC__CSRC__id = ANY_VALUE;
single_value->field_name = ANY_VALUE;
single_value->field_appdata = ANY_OR_OMIT;
single_value->field_padding = ANY_OR_OMIT;
}
}
}

void RTCP__IE__APP_template::copy_value(const RTCP__IE__APP& other_value)
{
single_value = new single_value_struct;
if (other_value.version().is_bound()) {
  single_value->field_version = other_value.version();
} else {
  single_value->field_version.clean_up();
}
if (other_value.padding__ind().is_bound()) {
  single_value->field_padding__ind = other_value.padding__ind();
} else {
  single_value->field_padding__ind.clean_up();
}
if (other_value.sub__type().is_bound()) {
  single_value->field_sub__type = other_value.sub__type();
} else {
  single_value->field_sub__type.clean_up();
}
if (other_value.payload__type().is_bound()) {
  single_value->field_payload__type = other_value.payload__type();
} else {
  single_value->field_payload__type.clean_up();
}
if (other_value.packet__length().is_bound()) {
  single_value->field_packet__length = other_value.packet__length();
} else {
  single_value->field_packet__length.clean_up();
}
if (other_value.SSRC__CSRC__id().is_bound()) {
  single_value->field_SSRC__CSRC__id = other_value.SSRC__CSRC__id();
} else {
  single_value->field_SSRC__CSRC__id.clean_up();
}
if (other_value.name().is_bound()) {
  single_value->field_name = other_value.name();
} else {
  single_value->field_name.clean_up();
}
if (other_value.appdata().is_bound()) {
  if (other_value.appdata().ispresent()) single_value->field_appdata = other_value.appdata()();
  else single_value->field_appdata = OMIT_VALUE;
} else {
  single_value->field_appdata.clean_up();
}
if (other_value.padding().is_bound()) {
  if (other_value.padding().ispresent()) single_value->field_padding = other_value.padding()();
  else single_value->field_padding = OMIT_VALUE;
} else {
  single_value->field_padding.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__IE__APP_template::copy_template(const RTCP__IE__APP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version().get_selection()) {
single_value->field_version = other_value.version();
} else {
single_value->field_version.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding__ind().get_selection()) {
single_value->field_padding__ind = other_value.padding__ind();
} else {
single_value->field_padding__ind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sub__type().get_selection()) {
single_value->field_sub__type = other_value.sub__type();
} else {
single_value->field_sub__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload__type().get_selection()) {
single_value->field_payload__type = other_value.payload__type();
} else {
single_value->field_payload__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packet__length().get_selection()) {
single_value->field_packet__length = other_value.packet__length();
} else {
single_value->field_packet__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.SSRC__CSRC__id().get_selection()) {
single_value->field_SSRC__CSRC__id = other_value.SSRC__CSRC__id();
} else {
single_value->field_SSRC__CSRC__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.name().get_selection()) {
single_value->field_name = other_value.name();
} else {
single_value->field_name.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.appdata().get_selection()) {
single_value->field_appdata = other_value.appdata();
} else {
single_value->field_appdata.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding().get_selection()) {
single_value->field_padding = other_value.padding();
} else {
single_value->field_padding.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__IE__APP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__IE__APP_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__IE__APP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_APP.");
break;
}
set_selection(other_value);
}

RTCP__IE__APP_template::RTCP__IE__APP_template()
{
}

RTCP__IE__APP_template::RTCP__IE__APP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__IE__APP_template::RTCP__IE__APP_template(const RTCP__IE__APP& other_value)
{
copy_value(other_value);
}

RTCP__IE__APP_template::RTCP__IE__APP_template(const OPTIONAL<RTCP__IE__APP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__APP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_IE_APP from an unbound optional field.");
}
}

RTCP__IE__APP_template::RTCP__IE__APP_template(RTCP__IE__APP_template* p_precondition, RTCP__IE__APP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__IE__APP_template::RTCP__IE__APP_template(Dynamic_Match_Interface<RTCP__IE__APP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__IE__APP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__IE__APP_template::RTCP__IE__APP_template(const RTCP__IE__APP_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__IE__APP_template::~RTCP__IE__APP_template()
{
clean_up();
}

RTCP__IE__APP_template& RTCP__IE__APP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__IE__APP_template& RTCP__IE__APP_template::operator=(const RTCP__IE__APP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__IE__APP_template& RTCP__IE__APP_template::operator=(const OPTIONAL<RTCP__IE__APP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__APP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_IE_APP.");
}
return *this;
}

RTCP__IE__APP_template& RTCP__IE__APP_template::operator=(const RTCP__IE__APP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__IE__APP_template::match(const RTCP__IE__APP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version().is_bound()) return FALSE;
if(!single_value->field_version.match(other_value.version(), legacy))return FALSE;
if(!other_value.padding__ind().is_bound()) return FALSE;
if(!single_value->field_padding__ind.match(other_value.padding__ind(), legacy))return FALSE;
if(!other_value.sub__type().is_bound()) return FALSE;
if(!single_value->field_sub__type.match(other_value.sub__type(), legacy))return FALSE;
if(!other_value.payload__type().is_bound()) return FALSE;
if(!single_value->field_payload__type.match(other_value.payload__type(), legacy))return FALSE;
if(!other_value.packet__length().is_bound()) return FALSE;
if(!single_value->field_packet__length.match(other_value.packet__length(), legacy))return FALSE;
if(!other_value.SSRC__CSRC__id().is_bound()) return FALSE;
if(!single_value->field_SSRC__CSRC__id.match(other_value.SSRC__CSRC__id(), legacy))return FALSE;
if(!other_value.name().is_bound()) return FALSE;
if(!single_value->field_name.match(other_value.name(), legacy))return FALSE;
if(!other_value.appdata().is_bound()) return FALSE;
if((other_value.appdata().ispresent() ? !single_value->field_appdata.match((const OCTETSTRING&)other_value.appdata(), legacy) : !single_value->field_appdata.match_omit(legacy)))return FALSE;
if(!other_value.padding().is_bound()) return FALSE;
if((other_value.padding().ispresent() ? !single_value->field_padding.match((const OCTETSTRING&)other_value.padding(), legacy) : !single_value->field_padding.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_APP.");
}
return FALSE;
}

boolean RTCP__IE__APP_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version.is_bound()
 || single_value->field_padding__ind.is_bound()
 || single_value->field_sub__type.is_bound()
 || single_value->field_payload__type.is_bound()
 || single_value->field_packet__length.is_bound()
 || single_value->field_SSRC__CSRC__id.is_bound()
 || single_value->field_name.is_bound()
 || (single_value->field_appdata.is_omit() || single_value->field_appdata.is_bound())
 || (single_value->field_padding.is_omit() || single_value->field_padding.is_bound());
}

boolean RTCP__IE__APP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version.is_value()
 && single_value->field_padding__ind.is_value()
 && single_value->field_sub__type.is_value()
 && single_value->field_payload__type.is_value()
 && single_value->field_packet__length.is_value()
 && single_value->field_SSRC__CSRC__id.is_value()
 && single_value->field_name.is_value()
 && (single_value->field_appdata.is_omit() || single_value->field_appdata.is_value())
 && (single_value->field_padding.is_omit() || single_value->field_padding.is_value());
}

void RTCP__IE__APP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__IE__APP RTCP__IE__APP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_IE_APP.");
RTCP__IE__APP ret_val;
if (single_value->field_version.is_bound()) {
ret_val.version() = single_value->field_version.valueof();
}
if (single_value->field_padding__ind.is_bound()) {
ret_val.padding__ind() = single_value->field_padding__ind.valueof();
}
if (single_value->field_sub__type.is_bound()) {
ret_val.sub__type() = single_value->field_sub__type.valueof();
}
if (single_value->field_payload__type.is_bound()) {
ret_val.payload__type() = single_value->field_payload__type.valueof();
}
if (single_value->field_packet__length.is_bound()) {
ret_val.packet__length() = single_value->field_packet__length.valueof();
}
if (single_value->field_SSRC__CSRC__id.is_bound()) {
ret_val.SSRC__CSRC__id() = single_value->field_SSRC__CSRC__id.valueof();
}
if (single_value->field_name.is_bound()) {
ret_val.name() = single_value->field_name.valueof();
}
if (single_value->field_appdata.is_omit()) ret_val.appdata() = OMIT_VALUE;
else if (single_value->field_appdata.is_bound()) {
ret_val.appdata() = single_value->field_appdata.valueof();
}
if (single_value->field_padding.is_omit()) ret_val.padding() = OMIT_VALUE;
else if (single_value->field_padding.is_bound()) {
ret_val.padding() = single_value->field_padding.valueof();
}
return ret_val;
}

void RTCP__IE__APP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_IE_APP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__IE__APP_template[list_length];
}

RTCP__IE__APP_template& RTCP__IE__APP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_IE_APP.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_IE_APP.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__IE__APP_template::version()
{
set_specific();
return single_value->field_version;
}

const INTEGER_template& RTCP__IE__APP_template::version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_version;
}

BITSTRING_template& RTCP__IE__APP_template::padding__ind()
{
set_specific();
return single_value->field_padding__ind;
}

const BITSTRING_template& RTCP__IE__APP_template::padding__ind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding_ind of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_padding__ind;
}

INTEGER_template& RTCP__IE__APP_template::sub__type()
{
set_specific();
return single_value->field_sub__type;
}

const INTEGER_template& RTCP__IE__APP_template::sub__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sub_type of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_sub__type;
}

INTEGER_template& RTCP__IE__APP_template::payload__type()
{
set_specific();
return single_value->field_payload__type;
}

const INTEGER_template& RTCP__IE__APP_template::payload__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload_type of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_payload__type;
}

INTEGER_template& RTCP__IE__APP_template::packet__length()
{
set_specific();
return single_value->field_packet__length;
}

const INTEGER_template& RTCP__IE__APP_template::packet__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packet_length of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_packet__length;
}

BITSTRING_template& RTCP__IE__APP_template::SSRC__CSRC__id()
{
set_specific();
return single_value->field_SSRC__CSRC__id;
}

const BITSTRING_template& RTCP__IE__APP_template::SSRC__CSRC__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC_CSRC_id of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_SSRC__CSRC__id;
}

CHARSTRING_template& RTCP__IE__APP_template::name()
{
set_specific();
return single_value->field_name;
}

const CHARSTRING_template& RTCP__IE__APP_template::name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field name of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_name;
}

OCTETSTRING_template& RTCP__IE__APP_template::appdata()
{
set_specific();
return single_value->field_appdata;
}

const OCTETSTRING_template& RTCP__IE__APP_template::appdata() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field appdata of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_appdata;
}

OCTETSTRING_template& RTCP__IE__APP_template::padding()
{
set_specific();
return single_value->field_padding;
}

const OCTETSTRING_template& RTCP__IE__APP_template::padding() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding of a non-specific template of type @RTP_Types.RTCP_IE_APP.");
return single_value->field_padding;
}

int RTCP__IE__APP_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 7;
      if (single_value->field_appdata.is_present()) ret_val++;
      if (single_value->field_padding.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_APP containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_APP.");
  }
  return 0;
}

void RTCP__IE__APP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log();
TTCN_Logger::log_event_str(", sub_type := ");
single_value->field_sub__type.log();
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_CSRC_id := ");
single_value->field_SSRC__CSRC__id.log();
TTCN_Logger::log_event_str(", name := ");
single_value->field_name.log();
TTCN_Logger::log_event_str(", appdata := ");
single_value->field_appdata.log();
TTCN_Logger::log_event_str(", padding := ");
single_value->field_padding.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__IE__APP_template::log_match(const RTCP__IE__APP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version.match(match_value.version(), legacy)){
TTCN_Logger::log_logmatch_info(".version");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_padding__ind.match(match_value.padding__ind(), legacy)){
TTCN_Logger::log_logmatch_info(".padding_ind");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sub__type.match(match_value.sub__type(), legacy)){
TTCN_Logger::log_logmatch_info(".sub_type");
single_value->field_sub__type.log_match(match_value.sub__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload__type.match(match_value.payload__type(), legacy)){
TTCN_Logger::log_logmatch_info(".payload_type");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packet__length.match(match_value.packet__length(), legacy)){
TTCN_Logger::log_logmatch_info(".packet_length");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_SSRC__CSRC__id.match(match_value.SSRC__CSRC__id(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC_CSRC_id");
single_value->field_SSRC__CSRC__id.log_match(match_value.SSRC__CSRC__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_name.match(match_value.name(), legacy)){
TTCN_Logger::log_logmatch_info(".name");
single_value->field_name.log_match(match_value.name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.appdata().ispresent()){
if(!single_value->field_appdata.match(match_value.appdata(), legacy)){
TTCN_Logger::log_logmatch_info(".appdata");
single_value->field_appdata.log_match(match_value.appdata(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_appdata.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".appdata := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_appdata.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.padding().ispresent()){
if(!single_value->field_padding.match(match_value.padding(), legacy)){
TTCN_Logger::log_logmatch_info(".padding");
single_value->field_padding.log_match(match_value.padding(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_padding.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".padding := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_padding.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::log_event_str(", sub_type := ");
single_value->field_sub__type.log_match(match_value.sub__type(), legacy);
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::log_event_str(", SSRC_CSRC_id := ");
single_value->field_SSRC__CSRC__id.log_match(match_value.SSRC__CSRC__id(), legacy);
TTCN_Logger::log_event_str(", name := ");
single_value->field_name.log_match(match_value.name(), legacy);
TTCN_Logger::log_event_str(", appdata := ");
if (match_value.appdata().ispresent()) {
single_value->field_appdata.log_match(match_value.appdata(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_appdata.log();
if (single_value->field_appdata.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", padding := ");
if (match_value.padding().ispresent()) {
single_value->field_padding.log_match(match_value.padding(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_padding.log();
if (single_value->field_padding.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__IE__APP_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (sub__type().is_bound()) sub__type().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (SSRC__CSRC__id().is_bound()) SSRC__CSRC__id().set_implicit_omit();
if (name().is_bound()) name().set_implicit_omit();
if (!appdata().is_bound()) appdata() = OMIT_VALUE;
else appdata().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__APP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version.encode_text(text_buf);
single_value->field_padding__ind.encode_text(text_buf);
single_value->field_sub__type.encode_text(text_buf);
single_value->field_payload__type.encode_text(text_buf);
single_value->field_packet__length.encode_text(text_buf);
single_value->field_SSRC__CSRC__id.encode_text(text_buf);
single_value->field_name.encode_text(text_buf);
single_value->field_appdata.encode_text(text_buf);
single_value->field_padding.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_APP.");
}
}

void RTCP__IE__APP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version.decode_text(text_buf);
single_value->field_padding__ind.decode_text(text_buf);
single_value->field_sub__type.decode_text(text_buf);
single_value->field_payload__type.decode_text(text_buf);
single_value->field_packet__length.decode_text(text_buf);
single_value->field_SSRC__CSRC__id.decode_text(text_buf);
single_value->field_name.decode_text(text_buf);
single_value->field_appdata.decode_text(text_buf);
single_value->field_padding.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__IE__APP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_IE_APP.");
}
}

void RTCP__IE__APP_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__IE__APP_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_IE_APP has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sub__type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__CSRC__id().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) name().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) appdata().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sub_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sub__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_CSRC_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__CSRC__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "appdata")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          appdata().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_APP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__IE__APP_template* precondition = new RTCP__IE__APP_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__IE__APP_template* implied_template = new RTCP__IE__APP_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__IE__APP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_IE_APP");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__IE__APP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_padding__ind.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_sub__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_payload__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_packet__length.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_SSRC__CSRC__id.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_name.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_appdata.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
single_value->field_padding.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_IE_APP");
}

boolean RTCP__IE__APP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__IE__APP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RTCP__IE__RTPFB::RTCP__IE__RTPFB()
{
}

RTCP__IE__RTPFB::RTCP__IE__RTPFB(const INTEGER& par_version,
    const BITSTRING& par_padding__ind,
    const INTEGER& par_fmt,
    const INTEGER& par_payload__type,
    const INTEGER& par_packet__length,
    const BITSTRING& par_SSRC__packet__sender,
    const BITSTRING& par_SSRC__media__sender,
    const OPTIONAL< RTCP__RTPFB__union >& par_fci,
    const OPTIONAL< OCTETSTRING >& par_padding)
  :   field_version(par_version),
  field_padding__ind(par_padding__ind),
  field_fmt(par_fmt),
  field_payload__type(par_payload__type),
  field_packet__length(par_packet__length),
  field_SSRC__packet__sender(par_SSRC__packet__sender),
  field_SSRC__media__sender(par_SSRC__media__sender),
  field_fci(par_fci),
  field_padding(par_padding)
{
}

RTCP__IE__RTPFB::RTCP__IE__RTPFB(const RTCP__IE__RTPFB& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_IE_RTPFB.");
if (other_value.version().is_bound()) field_version = other_value.version();
else field_version.clean_up();
if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
else field_padding__ind.clean_up();
if (other_value.fmt().is_bound()) field_fmt = other_value.fmt();
else field_fmt.clean_up();
if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
else field_payload__type.clean_up();
if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
else field_packet__length.clean_up();
if (other_value.SSRC__packet__sender().is_bound()) field_SSRC__packet__sender = other_value.SSRC__packet__sender();
else field_SSRC__packet__sender.clean_up();
if (other_value.SSRC__media__sender().is_bound()) field_SSRC__media__sender = other_value.SSRC__media__sender();
else field_SSRC__media__sender.clean_up();
if (other_value.fci().is_bound()) field_fci = other_value.fci();
else field_fci.clean_up();
if (other_value.padding().is_bound()) field_padding = other_value.padding();
else field_padding.clean_up();
}

void RTCP__IE__RTPFB::clean_up()
{
field_version.clean_up();
field_padding__ind.clean_up();
field_fmt.clean_up();
field_payload__type.clean_up();
field_packet__length.clean_up();
field_SSRC__packet__sender.clean_up();
field_SSRC__media__sender.clean_up();
field_fci.clean_up();
field_padding.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__IE__RTPFB::get_descriptor() const { return &RTCP__IE__RTPFB_descr_; }
RTCP__IE__RTPFB& RTCP__IE__RTPFB::operator=(const RTCP__IE__RTPFB& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_IE_RTPFB.");
  if (other_value.version().is_bound()) field_version = other_value.version();
  else field_version.clean_up();
  if (other_value.padding__ind().is_bound()) field_padding__ind = other_value.padding__ind();
  else field_padding__ind.clean_up();
  if (other_value.fmt().is_bound()) field_fmt = other_value.fmt();
  else field_fmt.clean_up();
  if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
  else field_payload__type.clean_up();
  if (other_value.packet__length().is_bound()) field_packet__length = other_value.packet__length();
  else field_packet__length.clean_up();
  if (other_value.SSRC__packet__sender().is_bound()) field_SSRC__packet__sender = other_value.SSRC__packet__sender();
  else field_SSRC__packet__sender.clean_up();
  if (other_value.SSRC__media__sender().is_bound()) field_SSRC__media__sender = other_value.SSRC__media__sender();
  else field_SSRC__media__sender.clean_up();
  if (other_value.fci().is_bound()) field_fci = other_value.fci();
  else field_fci.clean_up();
  if (other_value.padding().is_bound()) field_padding = other_value.padding();
  else field_padding.clean_up();
}
return *this;
}

boolean RTCP__IE__RTPFB::operator==(const RTCP__IE__RTPFB& other_value) const
{
return field_version==other_value.field_version
  && field_padding__ind==other_value.field_padding__ind
  && field_fmt==other_value.field_fmt
  && field_payload__type==other_value.field_payload__type
  && field_packet__length==other_value.field_packet__length
  && field_SSRC__packet__sender==other_value.field_SSRC__packet__sender
  && field_SSRC__media__sender==other_value.field_SSRC__media__sender
  && field_fci==other_value.field_fci
  && field_padding==other_value.field_padding;
}

boolean RTCP__IE__RTPFB::is_bound() const
{
return (field_version.is_bound())
  || (field_padding__ind.is_bound())
  || (field_fmt.is_bound())
  || (field_payload__type.is_bound())
  || (field_packet__length.is_bound())
  || (field_SSRC__packet__sender.is_bound())
  || (field_SSRC__media__sender.is_bound())
  || (OPTIONAL_OMIT == field_fci.get_selection() || field_fci.is_bound())
  || (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_bound());
}
boolean RTCP__IE__RTPFB::is_value() const
{
return field_version.is_value()
  && field_padding__ind.is_value()
  && field_fmt.is_value()
  && field_payload__type.is_value()
  && field_packet__length.is_value()
  && field_SSRC__packet__sender.is_value()
  && field_SSRC__media__sender.is_value()
  && (OPTIONAL_OMIT == field_fci.get_selection() || field_fci.is_value())
  && (OPTIONAL_OMIT == field_padding.get_selection() || field_padding.is_value());
}
int RTCP__IE__RTPFB::size_of() const
{
  int ret_val = 7;
  if (field_fci.ispresent()) ret_val++;
  if (field_padding.ispresent()) ret_val++;
  return ret_val;
}

void RTCP__IE__RTPFB::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version := ");
field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
field_padding__ind.log();
TTCN_Logger::log_event_str(", fmt := ");
field_fmt.log();
TTCN_Logger::log_event_str(", payload_type := ");
field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_packet_sender := ");
field_SSRC__packet__sender.log();
TTCN_Logger::log_event_str(", SSRC_media_sender := ");
field_SSRC__media__sender.log();
TTCN_Logger::log_event_str(", fci := ");
field_fci.log();
TTCN_Logger::log_event_str(", padding := ");
field_padding.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__IE__RTPFB::set_implicit_omit()
{
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (fmt().is_bound()) fmt().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (SSRC__packet__sender().is_bound()) SSRC__packet__sender().set_implicit_omit();
if (SSRC__media__sender().is_bound()) SSRC__media__sender().set_implicit_omit();
if (!fci().is_bound()) fci() = OMIT_VALUE;
else fci().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__RTPFB::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_IE_RTPFB has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) fmt().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__packet__sender().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) SSRC__media__sender().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) fci().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fmt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fmt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_packet_sender")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__packet__sender().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_media_sender")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__media__sender().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_RTPFB: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_IE_RTPFB");
  }
}

void RTCP__IE__RTPFB::encode_text(Text_Buf& text_buf) const
{
field_version.encode_text(text_buf);
field_padding__ind.encode_text(text_buf);
field_fmt.encode_text(text_buf);
field_payload__type.encode_text(text_buf);
field_packet__length.encode_text(text_buf);
field_SSRC__packet__sender.encode_text(text_buf);
field_SSRC__media__sender.encode_text(text_buf);
field_fci.encode_text(text_buf);
field_padding.encode_text(text_buf);
}

void RTCP__IE__RTPFB::decode_text(Text_Buf& text_buf)
{
field_version.decode_text(text_buf);
field_padding__ind.decode_text(text_buf);
field_fmt.decode_text(text_buf);
field_payload__type.decode_text(text_buf);
field_packet__length.decode_text(text_buf);
field_SSRC__packet__sender.decode_text(text_buf);
field_SSRC__media__sender.decode_text(text_buf);
field_fci.decode_text(text_buf);
field_padding.decode_text(text_buf);
}

void RTCP__IE__RTPFB::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__IE__RTPFB::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__IE__RTPFB::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field4 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__IE__RTPFB_version_descr_.raw->forceomit);
  decoded_field_length = field_version.RAW_decode(RTCP__IE__RTPFB_version_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__IE__RTPFB_padding__ind_descr_.raw->forceomit);
  decoded_field_length = field_padding__ind.RAW_decode(RTCP__IE__RTPFB_padding__ind_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__IE__RTPFB_fmt_descr_.raw->forceomit);
  decoded_field_length = field_fmt.RAW_decode(RTCP__IE__RTPFB_fmt_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__IE__RTPFB_payload__type_descr_.raw->forceomit);
  decoded_field_length = field_payload__type.RAW_decode(RTCP__IE__RTPFB_payload__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RTCP__IE__RTPFB_packet__length_descr_.raw->forceomit);
  decoded_field_length = field_packet__length.RAW_decode(RTCP__IE__RTPFB_packet__length_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp4 = field_packet__length.convert_to_Integer(RTCP__IE__RTPFB_packet__length_descr_);
  field_packet__length = tmp4;
  value_of_length_field4 += tmp4.get_long_long_val() * 32;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RTCP__IE__RTPFB_SSRC__packet__sender_descr_.raw->forceomit);
  decoded_field_length = field_SSRC__packet__sender.RAW_decode(RTCP__IE__RTPFB_SSRC__packet__sender_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RTCP__IE__RTPFB_SSRC__media__sender_descr_.raw->forceomit);
  decoded_field_length = field_SSRC__media__sender.RAW_decode(RTCP__IE__RTPFB_SSRC__media__sender_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  if (field_fmt == 1) selected_field = 0;
  else if (field_fmt == 3) selected_field = 1;
  else if (field_fmt == 4) selected_field = 2;
  else selected_field = 3;
  if (limit > 0 && value_of_length_field4 > 0&& selected_field!=-1){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_fci = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RTCP__IE__RTPFB_fci_descr_.raw->forceomit);
  decoded_field_length = field_fci().RAW_decode(RTCP__IE__RTPFB_fci_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, selected_field, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_fci = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_fci=OMIT_VALUE;
  if (limit > 0 && value_of_length_field4 > 0 && field_padding__ind ==  bs_0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_padding = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, RTCP__IE__RTPFB_padding_descr_.raw->forceomit);
  decoded_field_length = field_padding().RAW_decode(RTCP__IE__RTPFB_padding_descr_, p_buf, min_of_ints(2, limit, value_of_length_field4), local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_padding = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field4 -= decoded_field_length;
  }
  }
  }
  else field_padding=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__IE__RTPFB::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__IE__RTPFB_version_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__IE__RTPFB_padding__ind_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__IE__RTPFB_fmt_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RTCP__IE__RTPFB_payload__type_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RTCP__IE__RTPFB_packet__length_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RTCP__IE__RTPFB_SSRC__packet__sender_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RTCP__IE__RTPFB_SSRC__media__sender_descr_.raw);
  if (field_fci.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RTCP__IE__RTPFB_fci_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, RTCP__IE__RTPFB_padding_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_version.RAW_encode(RTCP__IE__RTPFB_version_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_padding__ind.RAW_encode(RTCP__IE__RTPFB_padding__ind_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_fmt.RAW_encode(RTCP__IE__RTPFB_fmt_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_payload__type.RAW_encode(RTCP__IE__RTPFB_payload__type_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += 16;
  myleaf.body.node.nodes[4]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[4]->coding_descr = &RTCP__IE__RTPFB_packet__length_descr_;
  myleaf.body.node.nodes[4]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[4]->calcof.lengthto.unit = 32;
  myleaf.body.node.nodes[4]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[4]->length = 16;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  if (field_fci.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[2].pos = 0;
  }
  if (field_padding.ispresent()) {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].level = 0;
  myleaf.body.node.nodes[4]->calcof.lengthto.fields[3].pos = 0;
  }
  encoded_length += field_SSRC__packet__sender.RAW_encode(RTCP__IE__RTPFB_SSRC__packet__sender_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_SSRC__media__sender.RAW_encode(RTCP__IE__RTPFB_SSRC__media__sender_descr_, *myleaf.body.node.nodes[6]);
  if (field_fci.ispresent()) {
  encoded_length += field_fci().RAW_encode(RTCP__IE__RTPFB_fci_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_padding.ispresent()) {
  encoded_length += field_padding().RAW_encode(RTCP__IE__RTPFB_padding_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_fci.ispresent()) {
  switch (field_fci().get_selection()) {
  case RTCP__RTPFB__union::ALT_gen__naks:
  if (field_fmt != 1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  INTEGER new_val(1);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(RTCP__IE__RTPFB_fmt_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RTCP__RTPFB__union::ALT_tmmbr:
  if (field_fmt != 3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  INTEGER new_val(3);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(RTCP__IE__RTPFB_fmt_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RTCP__RTPFB__union::ALT_tmmbn:
  if (field_fmt != 4) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  INTEGER new_val(4);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(RTCP__IE__RTPFB_fmt_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  }
  if (field_padding.ispresent() && (field_padding__ind !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(RTCP__IE__RTPFB_padding__ind_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RTCP__IE__RTPFB_template::single_value_struct {
INTEGER_template field_version;
BITSTRING_template field_padding__ind;
INTEGER_template field_fmt;
INTEGER_template field_payload__type;
INTEGER_template field_packet__length;
BITSTRING_template field_SSRC__packet__sender;
BITSTRING_template field_SSRC__media__sender;
RTCP__RTPFB__union_template field_fci;
OCTETSTRING_template field_padding;
};

void RTCP__IE__RTPFB_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version = ANY_VALUE;
single_value->field_padding__ind = ANY_VALUE;
single_value->field_fmt = ANY_VALUE;
single_value->field_payload__type = ANY_VALUE;
single_value->field_packet__length = ANY_VALUE;
single_value->field_SSRC__packet__sender = ANY_VALUE;
single_value->field_SSRC__media__sender = ANY_VALUE;
single_value->field_fci = ANY_OR_OMIT;
single_value->field_padding = ANY_OR_OMIT;
}
}
}

void RTCP__IE__RTPFB_template::copy_value(const RTCP__IE__RTPFB& other_value)
{
single_value = new single_value_struct;
if (other_value.version().is_bound()) {
  single_value->field_version = other_value.version();
} else {
  single_value->field_version.clean_up();
}
if (other_value.padding__ind().is_bound()) {
  single_value->field_padding__ind = other_value.padding__ind();
} else {
  single_value->field_padding__ind.clean_up();
}
if (other_value.fmt().is_bound()) {
  single_value->field_fmt = other_value.fmt();
} else {
  single_value->field_fmt.clean_up();
}
if (other_value.payload__type().is_bound()) {
  single_value->field_payload__type = other_value.payload__type();
} else {
  single_value->field_payload__type.clean_up();
}
if (other_value.packet__length().is_bound()) {
  single_value->field_packet__length = other_value.packet__length();
} else {
  single_value->field_packet__length.clean_up();
}
if (other_value.SSRC__packet__sender().is_bound()) {
  single_value->field_SSRC__packet__sender = other_value.SSRC__packet__sender();
} else {
  single_value->field_SSRC__packet__sender.clean_up();
}
if (other_value.SSRC__media__sender().is_bound()) {
  single_value->field_SSRC__media__sender = other_value.SSRC__media__sender();
} else {
  single_value->field_SSRC__media__sender.clean_up();
}
if (other_value.fci().is_bound()) {
  if (other_value.fci().ispresent()) single_value->field_fci = other_value.fci()();
  else single_value->field_fci = OMIT_VALUE;
} else {
  single_value->field_fci.clean_up();
}
if (other_value.padding().is_bound()) {
  if (other_value.padding().ispresent()) single_value->field_padding = other_value.padding()();
  else single_value->field_padding = OMIT_VALUE;
} else {
  single_value->field_padding.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__IE__RTPFB_template::copy_template(const RTCP__IE__RTPFB_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version().get_selection()) {
single_value->field_version = other_value.version();
} else {
single_value->field_version.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding__ind().get_selection()) {
single_value->field_padding__ind = other_value.padding__ind();
} else {
single_value->field_padding__ind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.fmt().get_selection()) {
single_value->field_fmt = other_value.fmt();
} else {
single_value->field_fmt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload__type().get_selection()) {
single_value->field_payload__type = other_value.payload__type();
} else {
single_value->field_payload__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packet__length().get_selection()) {
single_value->field_packet__length = other_value.packet__length();
} else {
single_value->field_packet__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.SSRC__packet__sender().get_selection()) {
single_value->field_SSRC__packet__sender = other_value.SSRC__packet__sender();
} else {
single_value->field_SSRC__packet__sender.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.SSRC__media__sender().get_selection()) {
single_value->field_SSRC__media__sender = other_value.SSRC__media__sender();
} else {
single_value->field_SSRC__media__sender.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.fci().get_selection()) {
single_value->field_fci = other_value.fci();
} else {
single_value->field_fci.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.padding().get_selection()) {
single_value->field_padding = other_value.padding();
} else {
single_value->field_padding.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__IE__RTPFB_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__IE__RTPFB_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__IE__RTPFB_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_RTPFB.");
break;
}
set_selection(other_value);
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template()
{
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(const RTCP__IE__RTPFB& other_value)
{
copy_value(other_value);
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(const OPTIONAL<RTCP__IE__RTPFB>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__RTPFB&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_IE_RTPFB from an unbound optional field.");
}
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(RTCP__IE__RTPFB_template* p_precondition, RTCP__IE__RTPFB_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(Dynamic_Match_Interface<RTCP__IE__RTPFB>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__IE__RTPFB>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__IE__RTPFB_template::RTCP__IE__RTPFB_template(const RTCP__IE__RTPFB_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__IE__RTPFB_template::~RTCP__IE__RTPFB_template()
{
clean_up();
}

RTCP__IE__RTPFB_template& RTCP__IE__RTPFB_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__IE__RTPFB_template& RTCP__IE__RTPFB_template::operator=(const RTCP__IE__RTPFB& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__IE__RTPFB_template& RTCP__IE__RTPFB_template::operator=(const OPTIONAL<RTCP__IE__RTPFB>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__IE__RTPFB&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_IE_RTPFB.");
}
return *this;
}

RTCP__IE__RTPFB_template& RTCP__IE__RTPFB_template::operator=(const RTCP__IE__RTPFB_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__IE__RTPFB_template::match(const RTCP__IE__RTPFB& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version().is_bound()) return FALSE;
if(!single_value->field_version.match(other_value.version(), legacy))return FALSE;
if(!other_value.padding__ind().is_bound()) return FALSE;
if(!single_value->field_padding__ind.match(other_value.padding__ind(), legacy))return FALSE;
if(!other_value.fmt().is_bound()) return FALSE;
if(!single_value->field_fmt.match(other_value.fmt(), legacy))return FALSE;
if(!other_value.payload__type().is_bound()) return FALSE;
if(!single_value->field_payload__type.match(other_value.payload__type(), legacy))return FALSE;
if(!other_value.packet__length().is_bound()) return FALSE;
if(!single_value->field_packet__length.match(other_value.packet__length(), legacy))return FALSE;
if(!other_value.SSRC__packet__sender().is_bound()) return FALSE;
if(!single_value->field_SSRC__packet__sender.match(other_value.SSRC__packet__sender(), legacy))return FALSE;
if(!other_value.SSRC__media__sender().is_bound()) return FALSE;
if(!single_value->field_SSRC__media__sender.match(other_value.SSRC__media__sender(), legacy))return FALSE;
if(!other_value.fci().is_bound()) return FALSE;
if((other_value.fci().ispresent() ? !single_value->field_fci.match((const RTCP__RTPFB__union&)other_value.fci(), legacy) : !single_value->field_fci.match_omit(legacy)))return FALSE;
if(!other_value.padding().is_bound()) return FALSE;
if((other_value.padding().ispresent() ? !single_value->field_padding.match((const OCTETSTRING&)other_value.padding(), legacy) : !single_value->field_padding.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_RTPFB.");
}
return FALSE;
}

boolean RTCP__IE__RTPFB_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version.is_bound()
 || single_value->field_padding__ind.is_bound()
 || single_value->field_fmt.is_bound()
 || single_value->field_payload__type.is_bound()
 || single_value->field_packet__length.is_bound()
 || single_value->field_SSRC__packet__sender.is_bound()
 || single_value->field_SSRC__media__sender.is_bound()
 || (single_value->field_fci.is_omit() || single_value->field_fci.is_bound())
 || (single_value->field_padding.is_omit() || single_value->field_padding.is_bound());
}

boolean RTCP__IE__RTPFB_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version.is_value()
 && single_value->field_padding__ind.is_value()
 && single_value->field_fmt.is_value()
 && single_value->field_payload__type.is_value()
 && single_value->field_packet__length.is_value()
 && single_value->field_SSRC__packet__sender.is_value()
 && single_value->field_SSRC__media__sender.is_value()
 && (single_value->field_fci.is_omit() || single_value->field_fci.is_value())
 && (single_value->field_padding.is_omit() || single_value->field_padding.is_value());
}

void RTCP__IE__RTPFB_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__IE__RTPFB RTCP__IE__RTPFB_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
RTCP__IE__RTPFB ret_val;
if (single_value->field_version.is_bound()) {
ret_val.version() = single_value->field_version.valueof();
}
if (single_value->field_padding__ind.is_bound()) {
ret_val.padding__ind() = single_value->field_padding__ind.valueof();
}
if (single_value->field_fmt.is_bound()) {
ret_val.fmt() = single_value->field_fmt.valueof();
}
if (single_value->field_payload__type.is_bound()) {
ret_val.payload__type() = single_value->field_payload__type.valueof();
}
if (single_value->field_packet__length.is_bound()) {
ret_val.packet__length() = single_value->field_packet__length.valueof();
}
if (single_value->field_SSRC__packet__sender.is_bound()) {
ret_val.SSRC__packet__sender() = single_value->field_SSRC__packet__sender.valueof();
}
if (single_value->field_SSRC__media__sender.is_bound()) {
ret_val.SSRC__media__sender() = single_value->field_SSRC__media__sender.valueof();
}
if (single_value->field_fci.is_omit()) ret_val.fci() = OMIT_VALUE;
else if (single_value->field_fci.is_bound()) {
ret_val.fci() = single_value->field_fci.valueof();
}
if (single_value->field_padding.is_omit()) ret_val.padding() = OMIT_VALUE;
else if (single_value->field_padding.is_bound()) {
ret_val.padding() = single_value->field_padding.valueof();
}
return ret_val;
}

void RTCP__IE__RTPFB_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_IE_RTPFB.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__IE__RTPFB_template[list_length];
}

RTCP__IE__RTPFB_template& RTCP__IE__RTPFB_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_IE_RTPFB.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_IE_RTPFB.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__IE__RTPFB_template::version()
{
set_specific();
return single_value->field_version;
}

const INTEGER_template& RTCP__IE__RTPFB_template::version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_version;
}

BITSTRING_template& RTCP__IE__RTPFB_template::padding__ind()
{
set_specific();
return single_value->field_padding__ind;
}

const BITSTRING_template& RTCP__IE__RTPFB_template::padding__ind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding_ind of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_padding__ind;
}

INTEGER_template& RTCP__IE__RTPFB_template::fmt()
{
set_specific();
return single_value->field_fmt;
}

const INTEGER_template& RTCP__IE__RTPFB_template::fmt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fmt of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_fmt;
}

INTEGER_template& RTCP__IE__RTPFB_template::payload__type()
{
set_specific();
return single_value->field_payload__type;
}

const INTEGER_template& RTCP__IE__RTPFB_template::payload__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload_type of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_payload__type;
}

INTEGER_template& RTCP__IE__RTPFB_template::packet__length()
{
set_specific();
return single_value->field_packet__length;
}

const INTEGER_template& RTCP__IE__RTPFB_template::packet__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packet_length of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_packet__length;
}

BITSTRING_template& RTCP__IE__RTPFB_template::SSRC__packet__sender()
{
set_specific();
return single_value->field_SSRC__packet__sender;
}

const BITSTRING_template& RTCP__IE__RTPFB_template::SSRC__packet__sender() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC_packet_sender of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_SSRC__packet__sender;
}

BITSTRING_template& RTCP__IE__RTPFB_template::SSRC__media__sender()
{
set_specific();
return single_value->field_SSRC__media__sender;
}

const BITSTRING_template& RTCP__IE__RTPFB_template::SSRC__media__sender() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC_media_sender of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_SSRC__media__sender;
}

RTCP__RTPFB__union_template& RTCP__IE__RTPFB_template::fci()
{
set_specific();
return single_value->field_fci;
}

const RTCP__RTPFB__union_template& RTCP__IE__RTPFB_template::fci() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fci of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_fci;
}

OCTETSTRING_template& RTCP__IE__RTPFB_template::padding()
{
set_specific();
return single_value->field_padding;
}

const OCTETSTRING_template& RTCP__IE__RTPFB_template::padding() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field padding of a non-specific template of type @RTP_Types.RTCP_IE_RTPFB.");
return single_value->field_padding;
}

int RTCP__IE__RTPFB_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 7;
      if (single_value->field_fci.is_present()) ret_val++;
      if (single_value->field_padding.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_IE_RTPFB containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_RTPFB.");
  }
  return 0;
}

void RTCP__IE__RTPFB_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log();
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log();
TTCN_Logger::log_event_str(", fmt := ");
single_value->field_fmt.log();
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log();
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log();
TTCN_Logger::log_event_str(", SSRC_packet_sender := ");
single_value->field_SSRC__packet__sender.log();
TTCN_Logger::log_event_str(", SSRC_media_sender := ");
single_value->field_SSRC__media__sender.log();
TTCN_Logger::log_event_str(", fci := ");
single_value->field_fci.log();
TTCN_Logger::log_event_str(", padding := ");
single_value->field_padding.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__IE__RTPFB_template::log_match(const RTCP__IE__RTPFB& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version.match(match_value.version(), legacy)){
TTCN_Logger::log_logmatch_info(".version");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_padding__ind.match(match_value.padding__ind(), legacy)){
TTCN_Logger::log_logmatch_info(".padding_ind");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_fmt.match(match_value.fmt(), legacy)){
TTCN_Logger::log_logmatch_info(".fmt");
single_value->field_fmt.log_match(match_value.fmt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload__type.match(match_value.payload__type(), legacy)){
TTCN_Logger::log_logmatch_info(".payload_type");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packet__length.match(match_value.packet__length(), legacy)){
TTCN_Logger::log_logmatch_info(".packet_length");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_SSRC__packet__sender.match(match_value.SSRC__packet__sender(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC_packet_sender");
single_value->field_SSRC__packet__sender.log_match(match_value.SSRC__packet__sender(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_SSRC__media__sender.match(match_value.SSRC__media__sender(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC_media_sender");
single_value->field_SSRC__media__sender.log_match(match_value.SSRC__media__sender(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.fci().ispresent()){
if(!single_value->field_fci.match(match_value.fci(), legacy)){
TTCN_Logger::log_logmatch_info(".fci");
single_value->field_fci.log_match(match_value.fci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_fci.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".fci := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_fci.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.padding().ispresent()){
if(!single_value->field_padding.match(match_value.padding(), legacy)){
TTCN_Logger::log_logmatch_info(".padding");
single_value->field_padding.log_match(match_value.padding(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_padding.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".padding := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_padding.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(", padding_ind := ");
single_value->field_padding__ind.log_match(match_value.padding__ind(), legacy);
TTCN_Logger::log_event_str(", fmt := ");
single_value->field_fmt.log_match(match_value.fmt(), legacy);
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::log_event_str(", packet_length := ");
single_value->field_packet__length.log_match(match_value.packet__length(), legacy);
TTCN_Logger::log_event_str(", SSRC_packet_sender := ");
single_value->field_SSRC__packet__sender.log_match(match_value.SSRC__packet__sender(), legacy);
TTCN_Logger::log_event_str(", SSRC_media_sender := ");
single_value->field_SSRC__media__sender.log_match(match_value.SSRC__media__sender(), legacy);
TTCN_Logger::log_event_str(", fci := ");
if (match_value.fci().ispresent()) {
single_value->field_fci.log_match(match_value.fci(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_fci.log();
if (single_value->field_fci.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", padding := ");
if (match_value.padding().ispresent()) {
single_value->field_padding.log_match(match_value.padding(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_padding.log();
if (single_value->field_padding.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__IE__RTPFB_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version().is_bound()) version().set_implicit_omit();
if (padding__ind().is_bound()) padding__ind().set_implicit_omit();
if (fmt().is_bound()) fmt().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (packet__length().is_bound()) packet__length().set_implicit_omit();
if (SSRC__packet__sender().is_bound()) SSRC__packet__sender().set_implicit_omit();
if (SSRC__media__sender().is_bound()) SSRC__media__sender().set_implicit_omit();
if (!fci().is_bound()) fci() = OMIT_VALUE;
else fci().set_implicit_omit();
if (!padding().is_bound()) padding() = OMIT_VALUE;
else padding().set_implicit_omit();
}

void RTCP__IE__RTPFB_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version.encode_text(text_buf);
single_value->field_padding__ind.encode_text(text_buf);
single_value->field_fmt.encode_text(text_buf);
single_value->field_payload__type.encode_text(text_buf);
single_value->field_packet__length.encode_text(text_buf);
single_value->field_SSRC__packet__sender.encode_text(text_buf);
single_value->field_SSRC__media__sender.encode_text(text_buf);
single_value->field_fci.encode_text(text_buf);
single_value->field_padding.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_IE_RTPFB.");
}
}

void RTCP__IE__RTPFB_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version.decode_text(text_buf);
single_value->field_padding__ind.decode_text(text_buf);
single_value->field_fmt.decode_text(text_buf);
single_value->field_payload__type.decode_text(text_buf);
single_value->field_packet__length.decode_text(text_buf);
single_value->field_SSRC__packet__sender.decode_text(text_buf);
single_value->field_SSRC__media__sender.decode_text(text_buf);
single_value->field_fci.decode_text(text_buf);
single_value->field_padding.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__IE__RTPFB_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_IE_RTPFB.");
}
}

void RTCP__IE__RTPFB_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__IE__RTPFB_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_IE_RTPFB has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) padding__ind().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) fmt().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) packet__length().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) SSRC__packet__sender().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) SSRC__media__sender().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) fci().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) padding().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding_ind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding__ind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fmt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fmt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packet_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packet__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_packet_sender")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__packet__sender().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC_media_sender")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC__media__sender().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "padding")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          padding().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_IE_RTPFB: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__IE__RTPFB_template* precondition = new RTCP__IE__RTPFB_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__IE__RTPFB_template* implied_template = new RTCP__IE__RTPFB_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__IE__RTPFB_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_IE_RTPFB");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__IE__RTPFB_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_padding__ind.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_fmt.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_payload__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_packet__length.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_SSRC__packet__sender.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_SSRC__media__sender.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_fci.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
single_value->field_padding.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_IE_RTPFB");
}

boolean RTCP__IE__RTPFB_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__IE__RTPFB_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__RTPFB__union::copy_value(const RTCP__RTPFB__union& other_value)
{
switch (other_value.union_selection) {
case ALT_gen__naks:
field_gen__naks = new RTCP__generic__NAKs(*other_value.field_gen__naks);
break;
case ALT_tmmbr:
field_tmmbr = new RTCP__RTPFB__TMMBRs(*other_value.field_tmmbr);
break;
case ALT_tmmbn:
field_tmmbn = new RTCP__RTPFB__TMMBNs(*other_value.field_tmmbn);
break;
case ALT_unknown__fci:
field_unknown__fci = new OCTETSTRING(*other_value.field_unknown__fci);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RTP_Types.RTCP_RTPFB_union.");
}
union_selection = other_value.union_selection;
}

RTCP__RTPFB__union::RTCP__RTPFB__union()
{
union_selection = UNBOUND_VALUE;
}

RTCP__RTPFB__union::RTCP__RTPFB__union(const RTCP__RTPFB__union& other_value)
: Base_Type(){
copy_value(other_value);
}

RTCP__RTPFB__union::~RTCP__RTPFB__union()
{
clean_up();
}

RTCP__RTPFB__union& RTCP__RTPFB__union::operator=(const RTCP__RTPFB__union& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean RTCP__RTPFB__union::operator==(const RTCP__RTPFB__union& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RTP_Types.RTCP_RTPFB_union.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RTP_Types.RTCP_RTPFB_union.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_gen__naks:
return *field_gen__naks == *other_value.field_gen__naks;
case ALT_tmmbr:
return *field_tmmbr == *other_value.field_tmmbr;
case ALT_tmmbn:
return *field_tmmbn == *other_value.field_tmmbn;
case ALT_unknown__fci:
return *field_unknown__fci == *other_value.field_unknown__fci;
default:
return FALSE;
}
}

RTCP__generic__NAKs& RTCP__RTPFB__union::gen__naks()
{
if (union_selection != ALT_gen__naks) {
clean_up();
field_gen__naks = new RTCP__generic__NAKs;
union_selection = ALT_gen__naks;
}
return *field_gen__naks;
}

const RTCP__generic__NAKs& RTCP__RTPFB__union::gen__naks() const
{
if (union_selection != ALT_gen__naks) TTCN_error("Using non-selected field gen_naks in a value of union type @RTP_Types.RTCP_RTPFB_union.");
return *field_gen__naks;
}

RTCP__RTPFB__TMMBRs& RTCP__RTPFB__union::tmmbr()
{
if (union_selection != ALT_tmmbr) {
clean_up();
field_tmmbr = new RTCP__RTPFB__TMMBRs;
union_selection = ALT_tmmbr;
}
return *field_tmmbr;
}

const RTCP__RTPFB__TMMBRs& RTCP__RTPFB__union::tmmbr() const
{
if (union_selection != ALT_tmmbr) TTCN_error("Using non-selected field tmmbr in a value of union type @RTP_Types.RTCP_RTPFB_union.");
return *field_tmmbr;
}

RTCP__RTPFB__TMMBNs& RTCP__RTPFB__union::tmmbn()
{
if (union_selection != ALT_tmmbn) {
clean_up();
field_tmmbn = new RTCP__RTPFB__TMMBNs;
union_selection = ALT_tmmbn;
}
return *field_tmmbn;
}

const RTCP__RTPFB__TMMBNs& RTCP__RTPFB__union::tmmbn() const
{
if (union_selection != ALT_tmmbn) TTCN_error("Using non-selected field tmmbn in a value of union type @RTP_Types.RTCP_RTPFB_union.");
return *field_tmmbn;
}

OCTETSTRING& RTCP__RTPFB__union::unknown__fci()
{
if (union_selection != ALT_unknown__fci) {
clean_up();
field_unknown__fci = new OCTETSTRING;
union_selection = ALT_unknown__fci;
}
return *field_unknown__fci;
}

const OCTETSTRING& RTCP__RTPFB__union::unknown__fci() const
{
if (union_selection != ALT_unknown__fci) TTCN_error("Using non-selected field unknown_fci in a value of union type @RTP_Types.RTCP_RTPFB_union.");
return *field_unknown__fci;
}

boolean RTCP__RTPFB__union::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RTP_Types.RTCP_RTPFB_union.");
return union_selection == checked_selection;
}

boolean RTCP__RTPFB__union::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean RTCP__RTPFB__union::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_gen__naks: return field_gen__naks->is_value();
case ALT_tmmbr: return field_tmmbr->is_value();
case ALT_tmmbn: return field_tmmbn->is_value();
case ALT_unknown__fci: return field_unknown__fci->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void RTCP__RTPFB__union::clean_up()
{
switch (union_selection) {
case ALT_gen__naks:
  delete field_gen__naks;
  break;
case ALT_tmmbr:
  delete field_tmmbr;
  break;
case ALT_tmmbn:
  delete field_tmmbn;
  break;
case ALT_unknown__fci:
  delete field_unknown__fci;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void RTCP__RTPFB__union::log() const
{
switch (union_selection) {
case ALT_gen__naks:
TTCN_Logger::log_event_str("{ gen_naks := ");
field_gen__naks->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tmmbr:
TTCN_Logger::log_event_str("{ tmmbr := ");
field_tmmbr->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tmmbn:
TTCN_Logger::log_event_str("{ tmmbn := ");
field_tmmbn->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_unknown__fci:
TTCN_Logger::log_event_str("{ unknown_fci := ");
field_unknown__fci->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void RTCP__RTPFB__union::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "gen_naks")) {
    gen__naks().set_param(*mp_last);
    if (!gen__naks().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tmmbr")) {
    tmmbr().set_param(*mp_last);
    if (!tmmbr().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tmmbn")) {
    tmmbn().set_param(*mp_last);
    if (!tmmbn().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "unknown_fci")) {
    unknown__fci().set_param(*mp_last);
    if (!unknown__fci().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RTP_Types.RTCP_RTPFB_union.", last_name);
}

void RTCP__RTPFB__union::set_implicit_omit()
{
switch (union_selection) {
case ALT_gen__naks:
field_gen__naks->set_implicit_omit(); break;
case ALT_tmmbr:
field_tmmbr->set_implicit_omit(); break;
case ALT_tmmbn:
field_tmmbn->set_implicit_omit(); break;
case ALT_unknown__fci:
field_unknown__fci->set_implicit_omit(); break;
default: break;
}
}

void RTCP__RTPFB__union::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_gen__naks:
field_gen__naks->encode_text(text_buf);
break;
case ALT_tmmbr:
field_tmmbr->encode_text(text_buf);
break;
case ALT_tmmbn:
field_tmmbn->encode_text(text_buf);
break;
case ALT_unknown__fci:
field_unknown__fci->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RTP_Types.RTCP_RTPFB_union.");
}
}

void RTCP__RTPFB__union::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_gen__naks:
gen__naks().decode_text(text_buf);
break;
case ALT_tmmbr:
tmmbr().decode_text(text_buf);
break;
case ALT_tmmbn:
tmmbn().decode_text(text_buf);
break;
case ALT_unknown__fci:
unknown__fci().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RTP_Types.RTCP_RTPFB_union.");
}
}

void RTCP__RTPFB__union::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__RTPFB__union::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__RTPFB__union::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, RTCP__generic__NAKs_descr_.raw->forceomit);
      decoded_length = gen__naks().RAW_decode(RTCP__generic__NAKs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, RTCP__RTPFB__TMMBRs_descr_.raw->forceomit);
      decoded_length = tmmbr().RAW_decode(RTCP__RTPFB__TMMBRs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, RTCP__RTPFB__TMMBNs_descr_.raw->forceomit);
      decoded_length = tmmbn().RAW_decode(RTCP__RTPFB__TMMBNs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = unknown__fci().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__generic__NAKs_descr_.raw->forceomit);
      decoded_length = gen__naks().RAW_decode(RTCP__generic__NAKs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__RTPFB__TMMBRs_descr_.raw->forceomit);
      decoded_length = tmmbr().RAW_decode(RTCP__RTPFB__TMMBRs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__RTPFB__TMMBNs_descr_.raw->forceomit);
      decoded_length = tmmbn().RAW_decode(RTCP__RTPFB__TMMBNs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = unknown__fci().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int RTCP__RTPFB__union::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  memset(myleaf.body.node.nodes, 0, 4 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_gen__naks:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, RTCP__generic__NAKs_descr_.raw);
    encoded_length = field_gen__naks->RAW_encode(RTCP__generic__NAKs_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &RTCP__generic__NAKs_descr_;
    break;
  case ALT_tmmbr:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, RTCP__RTPFB__TMMBRs_descr_.raw);
    encoded_length = field_tmmbr->RAW_encode(RTCP__RTPFB__TMMBRs_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &RTCP__RTPFB__TMMBRs_descr_;
    break;
  case ALT_tmmbn:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, RTCP__RTPFB__TMMBNs_descr_.raw);
    encoded_length = field_tmmbn->RAW_encode(RTCP__RTPFB__TMMBNs_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &RTCP__RTPFB__TMMBNs_descr_;
    break;
  case ALT_unknown__fci:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, OCTETSTRING_descr_.raw);
    encoded_length = field_unknown__fci->RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &OCTETSTRING_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void RTCP__RTPFB__union_template::copy_value(const RTCP__RTPFB__union& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks = new RTCP__generic__NAKs_template(other_value.gen__naks());
break;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr = new RTCP__RTPFB__TMMBRs_template(other_value.tmmbr());
break;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn = new RTCP__RTPFB__TMMBNs_template(other_value.tmmbn());
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template(other_value.unknown__fci());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RTP_Types.RTCP_RTPFB_union.");
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__RTPFB__union_template::copy_template(const RTCP__RTPFB__union_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks = new RTCP__generic__NAKs_template(*other_value.single_value.field_gen__naks);
break;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr = new RTCP__RTPFB__TMMBRs_template(*other_value.single_value.field_tmmbr);
break;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn = new RTCP__RTPFB__TMMBNs_template(*other_value.single_value.field_tmmbn);
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template(*other_value.single_value.field_unknown__fci);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RTP_Types.RTCP_RTPFB_union.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__RTPFB__union_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__RTPFB__union_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__RTPFB__union_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RTP_Types.RTCP_RTPFB_union.");
}
set_selection(other_value);
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template()
{
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(const RTCP__RTPFB__union& other_value)
{
copy_value(other_value);
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(const OPTIONAL<RTCP__RTPFB__union>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__union&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RTP_Types.RTCP_RTPFB_union from an unbound optional field.");
}
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(RTCP__RTPFB__union_template* p_precondition, RTCP__RTPFB__union_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(Dynamic_Match_Interface<RTCP__RTPFB__union>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__RTPFB__union>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__RTPFB__union_template::RTCP__RTPFB__union_template(const RTCP__RTPFB__union_template& other_value)
: Base_Template(){
copy_template(other_value);
}

RTCP__RTPFB__union_template::~RTCP__RTPFB__union_template()
{
clean_up();
}

void RTCP__RTPFB__union_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
delete single_value.field_gen__naks;
break;
case RTCP__RTPFB__union::ALT_tmmbr:
delete single_value.field_tmmbr;
break;
case RTCP__RTPFB__union::ALT_tmmbn:
delete single_value.field_tmmbn;
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
delete single_value.field_unknown__fci;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__RTPFB__union_template& RTCP__RTPFB__union_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__RTPFB__union_template& RTCP__RTPFB__union_template::operator=(const RTCP__RTPFB__union& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__RTPFB__union_template& RTCP__RTPFB__union_template::operator=(const OPTIONAL<RTCP__RTPFB__union>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__union&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
return *this;
}

RTCP__RTPFB__union_template& RTCP__RTPFB__union_template::operator=(const RTCP__RTPFB__union_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__RTPFB__union_template::match(const RTCP__RTPFB__union& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
RTCP__RTPFB__union::union_selection_type value_selection = other_value.get_selection();
if (value_selection == RTCP__RTPFB__union::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
return single_value.field_gen__naks->match(other_value.gen__naks(), legacy);
case RTCP__RTPFB__union::ALT_tmmbr:
return single_value.field_tmmbr->match(other_value.tmmbr(), legacy);
case RTCP__RTPFB__union::ALT_tmmbn:
return single_value.field_tmmbn->match(other_value.tmmbn(), legacy);
case RTCP__RTPFB__union::ALT_unknown__fci:
return single_value.field_unknown__fci->match(other_value.unknown__fci(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RTP_Types.RTCP_RTPFB_union.");
}
return FALSE;
}

boolean RTCP__RTPFB__union_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
return single_value.field_gen__naks->is_value();
case RTCP__RTPFB__union::ALT_tmmbr:
return single_value.field_tmmbr->is_value();
case RTCP__RTPFB__union::ALT_tmmbn:
return single_value.field_tmmbn->is_value();
case RTCP__RTPFB__union::ALT_unknown__fci:
return single_value.field_unknown__fci->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
}

RTCP__RTPFB__union RTCP__RTPFB__union_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RTP_Types.RTCP_RTPFB_union.");
RTCP__RTPFB__union ret_val;
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
ret_val.gen__naks() = single_value.field_gen__naks->valueof();
break;
case RTCP__RTPFB__union::ALT_tmmbr:
ret_val.tmmbr() = single_value.field_tmmbr->valueof();
break;
case RTCP__RTPFB__union::ALT_tmmbn:
ret_val.tmmbn() = single_value.field_tmmbn->valueof();
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
ret_val.unknown__fci() = single_value.field_unknown__fci->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
return ret_val;
}

RTCP__RTPFB__union_template& RTCP__RTPFB__union_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RTP_Types.RTCP_RTPFB_union.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RTP_Types.RTCP_RTPFB_union.");
return value_list.list_value[list_index];
}
void RTCP__RTPFB__union_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RTP_Types.RTCP_RTPFB_union.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__RTPFB__union_template[list_length];
}

RTCP__generic__NAKs_template& RTCP__RTPFB__union_template::gen__naks()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__RTPFB__union::ALT_gen__naks) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_gen__naks = new RTCP__generic__NAKs_template(ANY_VALUE);
else single_value.field_gen__naks = new RTCP__generic__NAKs_template;
single_value.union_selection = RTCP__RTPFB__union::ALT_gen__naks;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_gen__naks;
}

const RTCP__generic__NAKs_template& RTCP__RTPFB__union_template::gen__naks() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field gen_naks in a non-specific template of union type @RTP_Types.RTCP_RTPFB_union.");
if (single_value.union_selection != RTCP__RTPFB__union::ALT_gen__naks) TTCN_error("Accessing non-selected field gen_naks in a template of union type @RTP_Types.RTCP_RTPFB_union.");
return *single_value.field_gen__naks;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__union_template::tmmbr()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__RTPFB__union::ALT_tmmbr) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tmmbr = new RTCP__RTPFB__TMMBRs_template(ANY_VALUE);
else single_value.field_tmmbr = new RTCP__RTPFB__TMMBRs_template;
single_value.union_selection = RTCP__RTPFB__union::ALT_tmmbr;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tmmbr;
}

const RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__union_template::tmmbr() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tmmbr in a non-specific template of union type @RTP_Types.RTCP_RTPFB_union.");
if (single_value.union_selection != RTCP__RTPFB__union::ALT_tmmbr) TTCN_error("Accessing non-selected field tmmbr in a template of union type @RTP_Types.RTCP_RTPFB_union.");
return *single_value.field_tmmbr;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__union_template::tmmbn()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__RTPFB__union::ALT_tmmbn) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tmmbn = new RTCP__RTPFB__TMMBNs_template(ANY_VALUE);
else single_value.field_tmmbn = new RTCP__RTPFB__TMMBNs_template;
single_value.union_selection = RTCP__RTPFB__union::ALT_tmmbn;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tmmbn;
}

const RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__union_template::tmmbn() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tmmbn in a non-specific template of union type @RTP_Types.RTCP_RTPFB_union.");
if (single_value.union_selection != RTCP__RTPFB__union::ALT_tmmbn) TTCN_error("Accessing non-selected field tmmbn in a template of union type @RTP_Types.RTCP_RTPFB_union.");
return *single_value.field_tmmbn;
}

OCTETSTRING_template& RTCP__RTPFB__union_template::unknown__fci()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__RTPFB__union::ALT_unknown__fci) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_unknown__fci = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_unknown__fci = new OCTETSTRING_template;
single_value.union_selection = RTCP__RTPFB__union::ALT_unknown__fci;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_unknown__fci;
}

const OCTETSTRING_template& RTCP__RTPFB__union_template::unknown__fci() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field unknown_fci in a non-specific template of union type @RTP_Types.RTCP_RTPFB_union.");
if (single_value.union_selection != RTCP__RTPFB__union::ALT_unknown__fci) TTCN_error("Accessing non-selected field unknown_fci in a template of union type @RTP_Types.RTCP_RTPFB_union.");
return *single_value.field_unknown__fci;
}

boolean RTCP__RTPFB__union_template::ischosen(RTCP__RTPFB__union::union_selection_type checked_selection) const
{
if (checked_selection == RTCP__RTPFB__union::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RTP_Types.RTCP_RTPFB_union.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == RTCP__RTPFB__union::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RTP_Types.RTCP_RTPFB_union.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RTP_Types.RTCP_RTPFB_union containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void RTCP__RTPFB__union_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
TTCN_Logger::log_event_str("{ gen_naks := ");
single_value.field_gen__naks->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__RTPFB__union::ALT_tmmbr:
TTCN_Logger::log_event_str("{ tmmbr := ");
single_value.field_tmmbr->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__RTPFB__union::ALT_tmmbn:
TTCN_Logger::log_event_str("{ tmmbn := ");
single_value.field_tmmbn->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
TTCN_Logger::log_event_str("{ unknown_fci := ");
single_value.field_unknown__fci->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__RTPFB__union_template::log_match(const RTCP__RTPFB__union& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".gen_naks");
single_value.field_gen__naks->log_match(match_value.gen__naks(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ gen_naks := ");
single_value.field_gen__naks->log_match(match_value.gen__naks(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__RTPFB__union::ALT_tmmbr:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tmmbr");
single_value.field_tmmbr->log_match(match_value.tmmbr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tmmbr := ");
single_value.field_tmmbr->log_match(match_value.tmmbr(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__RTPFB__union::ALT_tmmbn:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tmmbn");
single_value.field_tmmbn->log_match(match_value.tmmbn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tmmbn := ");
single_value.field_tmmbn->log_match(match_value.tmmbn(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".unknown_fci");
single_value.field_unknown__fci->log_match(match_value.unknown__fci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ unknown_fci := ");
single_value.field_unknown__fci->log_match(match_value.unknown__fci(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__RTPFB__union_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks->set_implicit_omit(); break;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr->set_implicit_omit(); break;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn->set_implicit_omit(); break;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->set_implicit_omit(); break;
default: break;
}
}

void RTCP__RTPFB__union_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks->encode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr->encode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn->encode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RTP_Types.RTCP_RTPFB_union.");
}
}

void RTCP__RTPFB__union_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = RTCP__RTPFB__union::UNBOUND_VALUE;
RTCP__RTPFB__union::union_selection_type new_selection = (RTCP__RTPFB__union::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks = new RTCP__generic__NAKs_template;
single_value.field_gen__naks->decode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr = new RTCP__RTPFB__TMMBRs_template;
single_value.field_tmmbr->decode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn = new RTCP__RTPFB__TMMBNs_template;
single_value.field_tmmbn->decode_text(text_buf);
break;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template;
single_value.field_unknown__fci->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RTP_Types.RTCP_RTPFB_union.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__RTPFB__union_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RTP_Types.RTCP_RTPFB_union.");
}
}

boolean RTCP__RTPFB__union_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__RTPFB__union_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__RTPFB__union_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RTP_Types.RTCP_RTPFB_union'");
    }
    if (strcmp("gen_naks", param_field) == 0) {
      gen__naks().set_param(param);
      return;
    } else if (strcmp("tmmbr", param_field) == 0) {
      tmmbr().set_param(param);
      return;
    } else if (strcmp("tmmbn", param_field) == 0) {
      tmmbn().set_param(param);
      return;
    } else if (strcmp("unknown_fci", param_field) == 0) {
      unknown__fci().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RTP_Types.RTCP_RTPFB_union'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__RTPFB__union_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RTP_Types.RTCP_RTPFB_union");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "gen_naks")) {
      gen__naks().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tmmbr")) {
      tmmbr().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tmmbn")) {
      tmmbn().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "unknown_fci")) {
      unknown__fci().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RTP_Types.RTCP_RTPFB_union.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__RTPFB__union_template* precondition = new RTCP__RTPFB__union_template;
    precondition->set_param(*m_p->get_elem(0));
    RTCP__RTPFB__union_template* implied_template = new RTCP__RTPFB__union_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RTCP__RTPFB__union_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RTP_Types.RTCP_RTPFB_union");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__RTPFB__union_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case RTCP__RTPFB__union::ALT_gen__naks:
single_value.field_gen__naks->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_union");
return;
case RTCP__RTPFB__union::ALT_tmmbr:
single_value.field_tmmbr->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_union");
return;
case RTCP__RTPFB__union::ALT_tmmbn:
single_value.field_tmmbn->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_union");
return;
case RTCP__RTPFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_union");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RTP_Types.RTCP_RTPFB_union.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_RTPFB_union");
}


const RTCP__generic__NAK RTCP__generic__NAKs::UNBOUND_ELEM;
RTCP__generic__NAKs::RTCP__generic__NAKs()
{
val_ptr = NULL;
}

RTCP__generic__NAKs::RTCP__generic__NAKs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__generic__NAKs::RTCP__generic__NAKs(const RTCP__generic__NAKs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__generic__NAKs::~RTCP__generic__NAKs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__generic__NAKs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__generic__NAKs& RTCP__generic__NAKs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__generic__NAKs& RTCP__generic__NAKs::operator=(const RTCP__generic__NAKs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__generic__NAKs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__generic__NAKs::operator==(const RTCP__generic__NAKs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__generic__NAK& RTCP__generic__NAKs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_generic_NAKs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__generic__NAK**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__generic__NAK(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__generic__NAK;
}
return *val_ptr->value_elements[index_value];
}

RTCP__generic__NAK& RTCP__generic__NAKs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_generic_NAKs.");
return (*this)[(int)index_value];
}

const RTCP__generic__NAK& RTCP__generic__NAKs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_generic_NAKs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_generic_NAKs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__generic__NAK& RTCP__generic__NAKs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_generic_NAKs.");
return (*this)[(int)index_value];
}

RTCP__generic__NAKs RTCP__generic__NAKs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__generic__NAKs RTCP__generic__NAKs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__generic__NAKs RTCP__generic__NAKs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__generic__NAKs RTCP__generic__NAKs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__generic__NAKs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__generic__NAK(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__generic__NAKs RTCP__generic__NAKs::operator+(const RTCP__generic__NAKs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_generic_NAKs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__generic__NAKs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__generic__NAK(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__generic__NAK(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__generic__NAKs RTCP__generic__NAKs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_generic_NAKs","element");
RTCP__generic__NAKs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__generic__NAK(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__generic__NAKs RTCP__generic__NAKs::replace(int index, int len, const RTCP__generic__NAKs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_generic_NAKs","element");
RTCP__generic__NAKs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__generic__NAK(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__generic__NAK(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__generic__NAK(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__generic__NAKs RTCP__generic__NAKs::replace(int index, int len, const RTCP__generic__NAKs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__generic__NAKs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_generic_NAKs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__generic__NAK**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__generic__NAK(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__generic__NAK**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_generic_NAKs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__generic__NAK**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__generic__NAKs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__generic__NAKs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
return val_ptr->n_elements;
}

int RTCP__generic__NAKs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__generic__NAKs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__generic__NAKs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__generic__NAKs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_generic_NAKs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_generic_NAKs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__generic__NAKs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_generic_NAKs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__generic__NAKs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_generic_NAKs.");
val_ptr->value_elements = (RTCP__generic__NAK**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__generic__NAK;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__generic__NAKs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__generic__NAKs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__generic__NAKs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__generic__NAKs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__generic__NAKs_template::copy_value(const RTCP__generic__NAKs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_generic_NAKs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__generic__NAK_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__generic__NAKs_template::copy_template(const RTCP__generic__NAKs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__generic__NAK_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__generic__NAKs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__generic__NAKs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__generic__NAKs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAKs.");
break;
}
set_selection(other_value);
}

boolean RTCP__generic__NAKs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__generic__NAKs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__generic__NAKs*)value_ptr)[value_index], legacy);
else return ((const RTCP__generic__NAKs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template()
{
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(const RTCP__generic__NAKs& other_value)
{
copy_value(other_value);
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(const OPTIONAL<RTCP__generic__NAKs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__generic__NAKs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_generic_NAKs from an unbound optional field.");
}
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(RTCP__generic__NAKs_template* p_precondition, RTCP__generic__NAKs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(Dynamic_Match_Interface<RTCP__generic__NAKs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__generic__NAKs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__generic__NAKs_template::RTCP__generic__NAKs_template(const RTCP__generic__NAKs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__generic__NAKs_template::~RTCP__generic__NAKs_template()
{
clean_up();
}

void RTCP__generic__NAKs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::operator=(const RTCP__generic__NAKs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::operator=(const OPTIONAL<RTCP__generic__NAKs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__generic__NAKs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_generic_NAKs.");
}
return *this;
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::operator=(const RTCP__generic__NAKs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__generic__NAK_template& RTCP__generic__NAKs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_generic_NAKs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_generic_NAKs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__generic__NAK_template& RTCP__generic__NAKs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_generic_NAKs.");
return (*this)[(int)index_value];
}

const RTCP__generic__NAK_template& RTCP__generic__NAKs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_generic_NAKs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_generic_NAKs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_generic_NAKs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__generic__NAK_template& RTCP__generic__NAKs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_generic_NAKs.");
return (*this)[(int)index_value];
}

void RTCP__generic__NAKs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_generic_NAKs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__generic__NAK_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__generic__NAK_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__generic__NAKs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__generic__NAKs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_generic_NAKs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAKs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_generic_NAKs");
}

boolean RTCP__generic__NAKs_template::match(const RTCP__generic__NAKs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAKs.");
}
return FALSE;
}

boolean RTCP__generic__NAKs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__generic__NAKs RTCP__generic__NAKs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_generic_NAKs.");
RTCP__generic__NAKs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__generic__NAKs RTCP__generic__NAKs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__generic__NAKs RTCP__generic__NAKs_template::replace(int index, int len, const RTCP__generic__NAKs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__generic__NAKs RTCP__generic__NAKs_template::replace(int index, int len, const RTCP__generic__NAKs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__generic__NAKs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__generic__NAKs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_generic_NAKs.");
}
set_selection(template_type);
}

RTCP__generic__NAKs_template& RTCP__generic__NAKs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_generic_NAKs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_generic_NAKs.");
return value_list.list_value[list_index];
}

void RTCP__generic__NAKs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__generic__NAKs_template::log_match(const RTCP__generic__NAKs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__generic__NAKs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAKs.");
}
}

void RTCP__generic__NAKs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_generic_NAKs.");
single_value.value_elements = (RTCP__generic__NAK_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__generic__NAK_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__generic__NAKs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_generic_NAKs.");
}
}

boolean RTCP__generic__NAKs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__generic__NAKs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__generic__NAKs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__generic__NAKs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__generic__NAKs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__generic__NAKs_template* precondition = new RTCP__generic__NAKs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__generic__NAKs_template* implied_template = new RTCP__generic__NAKs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__generic__NAKs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_generic_NAKs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__generic__NAKs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_generic_NAKs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_generic_NAKs");
}

boolean RTCP__generic__NAKs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
RTCP__generic__NAK::RTCP__generic__NAK()
{
}

RTCP__generic__NAK::RTCP__generic__NAK(const INTEGER& par_pid,
    const BITSTRING& par_blb)
  :   field_pid(par_pid),
  field_blb(par_blb)
{
}

RTCP__generic__NAK::RTCP__generic__NAK(const RTCP__generic__NAK& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_generic_NAK.");
if (other_value.pid().is_bound()) field_pid = other_value.pid();
else field_pid.clean_up();
if (other_value.blb().is_bound()) field_blb = other_value.blb();
else field_blb.clean_up();
}

void RTCP__generic__NAK::clean_up()
{
field_pid.clean_up();
field_blb.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__generic__NAK::get_descriptor() const { return &RTCP__generic__NAK_descr_; }
RTCP__generic__NAK& RTCP__generic__NAK::operator=(const RTCP__generic__NAK& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_generic_NAK.");
  if (other_value.pid().is_bound()) field_pid = other_value.pid();
  else field_pid.clean_up();
  if (other_value.blb().is_bound()) field_blb = other_value.blb();
  else field_blb.clean_up();
}
return *this;
}

boolean RTCP__generic__NAK::operator==(const RTCP__generic__NAK& other_value) const
{
return field_pid==other_value.field_pid
  && field_blb==other_value.field_blb;
}

boolean RTCP__generic__NAK::is_bound() const
{
return (field_pid.is_bound())
  || (field_blb.is_bound());
}
boolean RTCP__generic__NAK::is_value() const
{
return field_pid.is_value()
  && field_blb.is_value();
}
void RTCP__generic__NAK::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pid := ");
field_pid.log();
TTCN_Logger::log_event_str(", blb := ");
field_blb.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__generic__NAK::set_implicit_omit()
{
if (pid().is_bound()) pid().set_implicit_omit();
if (blb().is_bound()) blb().set_implicit_omit();
}

void RTCP__generic__NAK::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_generic_NAK has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) blb().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "blb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          blb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_generic_NAK: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_generic_NAK");
  }
}

void RTCP__generic__NAK::encode_text(Text_Buf& text_buf) const
{
field_pid.encode_text(text_buf);
field_blb.encode_text(text_buf);
}

void RTCP__generic__NAK::decode_text(Text_Buf& text_buf)
{
field_pid.decode_text(text_buf);
field_blb.decode_text(text_buf);
}

void RTCP__generic__NAK::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__generic__NAK::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__generic__NAK::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_pid.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT16_descr_.raw->forceomit);
  decoded_field_length = field_blb.RAW_decode(General__Types::BIT16_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__generic__NAK::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT16_descr_.raw);
  encoded_length += field_pid.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_blb.RAW_encode(General__Types::BIT16_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RTCP__generic__NAK_template::single_value_struct {
INTEGER_template field_pid;
BITSTRING_template field_blb;
};

void RTCP__generic__NAK_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pid = ANY_VALUE;
single_value->field_blb = ANY_VALUE;
}
}
}

void RTCP__generic__NAK_template::copy_value(const RTCP__generic__NAK& other_value)
{
single_value = new single_value_struct;
if (other_value.pid().is_bound()) {
  single_value->field_pid = other_value.pid();
} else {
  single_value->field_pid.clean_up();
}
if (other_value.blb().is_bound()) {
  single_value->field_blb = other_value.blb();
} else {
  single_value->field_blb.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__generic__NAK_template::copy_template(const RTCP__generic__NAK_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pid().get_selection()) {
single_value->field_pid = other_value.pid();
} else {
single_value->field_pid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.blb().get_selection()) {
single_value->field_blb = other_value.blb();
} else {
single_value->field_blb.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__generic__NAK_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__generic__NAK_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__generic__NAK_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAK.");
break;
}
set_selection(other_value);
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template()
{
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(const RTCP__generic__NAK& other_value)
{
copy_value(other_value);
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(const OPTIONAL<RTCP__generic__NAK>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__generic__NAK&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_generic_NAK from an unbound optional field.");
}
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(RTCP__generic__NAK_template* p_precondition, RTCP__generic__NAK_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(Dynamic_Match_Interface<RTCP__generic__NAK>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__generic__NAK>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__generic__NAK_template::RTCP__generic__NAK_template(const RTCP__generic__NAK_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__generic__NAK_template::~RTCP__generic__NAK_template()
{
clean_up();
}

RTCP__generic__NAK_template& RTCP__generic__NAK_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__generic__NAK_template& RTCP__generic__NAK_template::operator=(const RTCP__generic__NAK& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__generic__NAK_template& RTCP__generic__NAK_template::operator=(const OPTIONAL<RTCP__generic__NAK>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__generic__NAK&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_generic_NAK.");
}
return *this;
}

RTCP__generic__NAK_template& RTCP__generic__NAK_template::operator=(const RTCP__generic__NAK_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__generic__NAK_template::match(const RTCP__generic__NAK& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pid().is_bound()) return FALSE;
if(!single_value->field_pid.match(other_value.pid(), legacy))return FALSE;
if(!other_value.blb().is_bound()) return FALSE;
if(!single_value->field_blb.match(other_value.blb(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAK.");
}
return FALSE;
}

boolean RTCP__generic__NAK_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_pid.is_bound()
 || single_value->field_blb.is_bound();
}

boolean RTCP__generic__NAK_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_pid.is_value()
 && single_value->field_blb.is_value();
}

void RTCP__generic__NAK_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__generic__NAK RTCP__generic__NAK_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_generic_NAK.");
RTCP__generic__NAK ret_val;
if (single_value->field_pid.is_bound()) {
ret_val.pid() = single_value->field_pid.valueof();
}
if (single_value->field_blb.is_bound()) {
ret_val.blb() = single_value->field_blb.valueof();
}
return ret_val;
}

void RTCP__generic__NAK_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_generic_NAK.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__generic__NAK_template[list_length];
}

RTCP__generic__NAK_template& RTCP__generic__NAK_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_generic_NAK.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_generic_NAK.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__generic__NAK_template::pid()
{
set_specific();
return single_value->field_pid;
}

const INTEGER_template& RTCP__generic__NAK_template::pid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pid of a non-specific template of type @RTP_Types.RTCP_generic_NAK.");
return single_value->field_pid;
}

BITSTRING_template& RTCP__generic__NAK_template::blb()
{
set_specific();
return single_value->field_blb;
}

const BITSTRING_template& RTCP__generic__NAK_template::blb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field blb of a non-specific template of type @RTP_Types.RTCP_generic_NAK.");
return single_value->field_blb;
}

int RTCP__generic__NAK_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_generic_NAK containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAK.");
  }
  return 0;
}

void RTCP__generic__NAK_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pid := ");
single_value->field_pid.log();
TTCN_Logger::log_event_str(", blb := ");
single_value->field_blb.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__generic__NAK_template::log_match(const RTCP__generic__NAK& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_pid.match(match_value.pid(), legacy)){
TTCN_Logger::log_logmatch_info(".pid");
single_value->field_pid.log_match(match_value.pid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_blb.match(match_value.blb(), legacy)){
TTCN_Logger::log_logmatch_info(".blb");
single_value->field_blb.log_match(match_value.blb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pid := ");
single_value->field_pid.log_match(match_value.pid(), legacy);
TTCN_Logger::log_event_str(", blb := ");
single_value->field_blb.log_match(match_value.blb(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__generic__NAK_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (pid().is_bound()) pid().set_implicit_omit();
if (blb().is_bound()) blb().set_implicit_omit();
}

void RTCP__generic__NAK_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pid.encode_text(text_buf);
single_value->field_blb.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_generic_NAK.");
}
}

void RTCP__generic__NAK_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pid.decode_text(text_buf);
single_value->field_blb.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__generic__NAK_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_generic_NAK.");
}
}

void RTCP__generic__NAK_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__generic__NAK_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_generic_NAK has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) blb().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "blb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          blb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_generic_NAK: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__generic__NAK_template* precondition = new RTCP__generic__NAK_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__generic__NAK_template* implied_template = new RTCP__generic__NAK_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__generic__NAK_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_generic_NAK");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__generic__NAK_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pid.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_generic_NAK");
single_value->field_blb.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_generic_NAK");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_generic_NAK");
}

boolean RTCP__generic__NAK_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__generic__NAK_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const RTCP__RTPFB__TMMB RTCP__RTPFB__TMMBRs::UNBOUND_ELEM;
RTCP__RTPFB__TMMBRs::RTCP__RTPFB__TMMBRs()
{
val_ptr = NULL;
}

RTCP__RTPFB__TMMBRs::RTCP__RTPFB__TMMBRs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__RTPFB__TMMBRs::RTCP__RTPFB__TMMBRs(const RTCP__RTPFB__TMMBRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__RTPFB__TMMBRs::~RTCP__RTPFB__TMMBRs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__RTPFB__TMMBRs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__RTPFB__TMMBRs& RTCP__RTPFB__TMMBRs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__RTPFB__TMMBRs& RTCP__RTPFB__TMMBRs::operator=(const RTCP__RTPFB__TMMBRs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__RTPFB__TMMBRs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__RTPFB__TMMBRs::operator==(const RTCP__RTPFB__TMMBRs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBRs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_RTPFB_TMMBRs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__RTPFB__TMMB;
}
return *val_ptr->value_elements[index_value];
}

RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBRs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return (*this)[(int)index_value];
}

const RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBRs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_RTPFB_TMMBRs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_RTPFB_TMMBRs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBRs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return (*this)[(int)index_value];
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__RTPFB__TMMBRs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::operator+(const RTCP__RTPFB__TMMBRs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_RTPFB_TMMBRs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__RTPFB__TMMBRs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__RTPFB__TMMB(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_RTPFB_TMMBRs","element");
RTCP__RTPFB__TMMBRs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::replace(int index, int len, const RTCP__RTPFB__TMMBRs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_RTPFB_TMMBRs","element");
RTCP__RTPFB__TMMBRs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__RTPFB__TMMB(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs::replace(int index, int len, const RTCP__RTPFB__TMMBRs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__RTPFB__TMMBRs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_RTPFB_TMMBRs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__RTPFB__TMMBRs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__RTPFB__TMMBRs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return val_ptr->n_elements;
}

int RTCP__RTPFB__TMMBRs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__RTPFB__TMMBRs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__RTPFB__TMMBRs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__RTPFB__TMMBRs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_RTPFB_TMMBRs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_RTPFB_TMMBRs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__RTPFB__TMMBRs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__RTPFB__TMMBRs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__RTPFB__TMMBRs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__RTPFB__TMMBRs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__RTPFB__TMMBRs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__RTPFB__TMMBRs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__RTPFB__TMMBRs_template::copy_value(const RTCP__RTPFB__TMMBRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_RTPFB_TMMBRs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__RTPFB__TMMBRs_template::copy_template(const RTCP__RTPFB__TMMBRs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__RTPFB__TMMBRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__RTPFB__TMMBRs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__RTPFB__TMMBRs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
break;
}
set_selection(other_value);
}

boolean RTCP__RTPFB__TMMBRs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__RTPFB__TMMBRs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__RTPFB__TMMBRs*)value_ptr)[value_index], legacy);
else return ((const RTCP__RTPFB__TMMBRs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template()
{
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(const RTCP__RTPFB__TMMBRs& other_value)
{
copy_value(other_value);
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(const OPTIONAL<RTCP__RTPFB__TMMBRs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMBRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_RTPFB_TMMBRs from an unbound optional field.");
}
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(RTCP__RTPFB__TMMBRs_template* p_precondition, RTCP__RTPFB__TMMBRs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(Dynamic_Match_Interface<RTCP__RTPFB__TMMBRs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__RTPFB__TMMBRs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__RTPFB__TMMBRs_template::RTCP__RTPFB__TMMBRs_template(const RTCP__RTPFB__TMMBRs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__RTPFB__TMMBRs_template::~RTCP__RTPFB__TMMBRs_template()
{
clean_up();
}

void RTCP__RTPFB__TMMBRs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::operator=(const RTCP__RTPFB__TMMBRs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::operator=(const OPTIONAL<RTCP__RTPFB__TMMBRs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMBRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
}
return *this;
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::operator=(const RTCP__RTPFB__TMMBRs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBRs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_RTPFB_TMMBRs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_RTPFB_TMMBRs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBRs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return (*this)[(int)index_value];
}

const RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBRs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_RTPFB_TMMBRs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_RTPFB_TMMBRs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBRs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return (*this)[(int)index_value];
}

void RTCP__RTPFB__TMMBRs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__RTPFB__TMMBRs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__RTPFB__TMMBRs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBRs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBRs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_RTPFB_TMMBRs");
}

boolean RTCP__RTPFB__TMMBRs_template::match(const RTCP__RTPFB__TMMBRs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
}
return FALSE;
}

boolean RTCP__RTPFB__TMMBRs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
RTCP__RTPFB__TMMBRs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs_template::replace(int index, int len, const RTCP__RTPFB__TMMBRs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__RTPFB__TMMBRs RTCP__RTPFB__TMMBRs_template::replace(int index, int len, const RTCP__RTPFB__TMMBRs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__RTPFB__TMMBRs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__RTPFB__TMMBRs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
}
set_selection(template_type);
}

RTCP__RTPFB__TMMBRs_template& RTCP__RTPFB__TMMBRs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
return value_list.list_value[list_index];
}

void RTCP__RTPFB__TMMBRs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__RTPFB__TMMBRs_template::log_match(const RTCP__RTPFB__TMMBRs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__RTPFB__TMMBRs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
}
}

void RTCP__RTPFB__TMMBRs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__RTPFB__TMMBRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_RTPFB_TMMBRs.");
}
}

boolean RTCP__RTPFB__TMMBRs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__RTPFB__TMMBRs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__RTPFB__TMMBRs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__RTPFB__TMMBRs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__RTPFB__TMMBRs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__RTPFB__TMMBRs_template* precondition = new RTCP__RTPFB__TMMBRs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__RTPFB__TMMBRs_template* implied_template = new RTCP__RTPFB__TMMBRs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__RTPFB__TMMBRs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_RTPFB_TMMBRs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__RTPFB__TMMBRs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMBRs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMBRs");
}

boolean RTCP__RTPFB__TMMBRs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
RTCP__RTPFB__TMMB::RTCP__RTPFB__TMMB()
{
}

RTCP__RTPFB__TMMB::RTCP__RTPFB__TMMB(const BITSTRING& par_SSRC,
    const INTEGER& par_exp,
    const INTEGER& par_mantissa,
    const INTEGER& par_measured__overhead)
  :   field_SSRC(par_SSRC),
  field_exp(par_exp),
  field_mantissa(par_mantissa),
  field_measured__overhead(par_measured__overhead)
{
}

RTCP__RTPFB__TMMB::RTCP__RTPFB__TMMB(const RTCP__RTPFB__TMMB& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_RTPFB_TMMB.");
if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
else field_SSRC.clean_up();
if (other_value.exp().is_bound()) field_exp = other_value.exp();
else field_exp.clean_up();
if (other_value.mantissa().is_bound()) field_mantissa = other_value.mantissa();
else field_mantissa.clean_up();
if (other_value.measured__overhead().is_bound()) field_measured__overhead = other_value.measured__overhead();
else field_measured__overhead.clean_up();
}

void RTCP__RTPFB__TMMB::clean_up()
{
field_SSRC.clean_up();
field_exp.clean_up();
field_mantissa.clean_up();
field_measured__overhead.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__RTPFB__TMMB::get_descriptor() const { return &RTCP__RTPFB__TMMB_descr_; }
RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMB::operator=(const RTCP__RTPFB__TMMB& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_RTPFB_TMMB.");
  if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
  else field_SSRC.clean_up();
  if (other_value.exp().is_bound()) field_exp = other_value.exp();
  else field_exp.clean_up();
  if (other_value.mantissa().is_bound()) field_mantissa = other_value.mantissa();
  else field_mantissa.clean_up();
  if (other_value.measured__overhead().is_bound()) field_measured__overhead = other_value.measured__overhead();
  else field_measured__overhead.clean_up();
}
return *this;
}

boolean RTCP__RTPFB__TMMB::operator==(const RTCP__RTPFB__TMMB& other_value) const
{
return field_SSRC==other_value.field_SSRC
  && field_exp==other_value.field_exp
  && field_mantissa==other_value.field_mantissa
  && field_measured__overhead==other_value.field_measured__overhead;
}

boolean RTCP__RTPFB__TMMB::is_bound() const
{
return (field_SSRC.is_bound())
  || (field_exp.is_bound())
  || (field_mantissa.is_bound())
  || (field_measured__overhead.is_bound());
}
boolean RTCP__RTPFB__TMMB::is_value() const
{
return field_SSRC.is_value()
  && field_exp.is_value()
  && field_mantissa.is_value()
  && field_measured__overhead.is_value();
}
void RTCP__RTPFB__TMMB::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ SSRC := ");
field_SSRC.log();
TTCN_Logger::log_event_str(", exp := ");
field_exp.log();
TTCN_Logger::log_event_str(", mantissa := ");
field_mantissa.log();
TTCN_Logger::log_event_str(", measured_overhead := ");
field_measured__overhead.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__RTPFB__TMMB::set_implicit_omit()
{
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (exp().is_bound()) exp().set_implicit_omit();
if (mantissa().is_bound()) mantissa().set_implicit_omit();
if (measured__overhead().is_bound()) measured__overhead().set_implicit_omit();
}

void RTCP__RTPFB__TMMB::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_RTPFB_TMMB has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) exp().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mantissa().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) measured__overhead().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "exp")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          exp().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mantissa")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mantissa().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measured_overhead")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measured__overhead().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_RTPFB_TMMB: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_RTPFB_TMMB");
  }
}

void RTCP__RTPFB__TMMB::encode_text(Text_Buf& text_buf) const
{
field_SSRC.encode_text(text_buf);
field_exp.encode_text(text_buf);
field_mantissa.encode_text(text_buf);
field_measured__overhead.encode_text(text_buf);
}

void RTCP__RTPFB__TMMB::decode_text(Text_Buf& text_buf)
{
field_SSRC.decode_text(text_buf);
field_exp.decode_text(text_buf);
field_mantissa.decode_text(text_buf);
field_measured__overhead.decode_text(text_buf);
}

void RTCP__RTPFB__TMMB::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__RTPFB__TMMB::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__RTPFB__TMMB::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__RTPFB__TMMB_SSRC_descr_.raw->forceomit);
  decoded_field_length = field_SSRC.RAW_decode(RTCP__RTPFB__TMMB_SSRC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__RTPFB__TMMB_exp_descr_.raw->forceomit);
  decoded_field_length = field_exp.RAW_decode(RTCP__RTPFB__TMMB_exp_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__RTPFB__TMMB_mantissa_descr_.raw->forceomit);
  decoded_field_length = field_mantissa.RAW_decode(RTCP__RTPFB__TMMB_mantissa_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__RTPFB__TMMB_measured__overhead_descr_.raw->forceomit);
  decoded_field_length = field_measured__overhead.RAW_decode(RTCP__RTPFB__TMMB_measured__overhead_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__RTPFB__TMMB::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__RTPFB__TMMB_SSRC_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__RTPFB__TMMB_exp_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__RTPFB__TMMB_mantissa_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RTCP__RTPFB__TMMB_measured__overhead_descr_.raw);
  encoded_length += field_SSRC.RAW_encode(RTCP__RTPFB__TMMB_SSRC_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_exp.RAW_encode(RTCP__RTPFB__TMMB_exp_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_mantissa.RAW_encode(RTCP__RTPFB__TMMB_mantissa_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_measured__overhead.RAW_encode(RTCP__RTPFB__TMMB_measured__overhead_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct RTCP__RTPFB__TMMB_template::single_value_struct {
BITSTRING_template field_SSRC;
INTEGER_template field_exp;
INTEGER_template field_mantissa;
INTEGER_template field_measured__overhead;
};

void RTCP__RTPFB__TMMB_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_SSRC = ANY_VALUE;
single_value->field_exp = ANY_VALUE;
single_value->field_mantissa = ANY_VALUE;
single_value->field_measured__overhead = ANY_VALUE;
}
}
}

void RTCP__RTPFB__TMMB_template::copy_value(const RTCP__RTPFB__TMMB& other_value)
{
single_value = new single_value_struct;
if (other_value.SSRC().is_bound()) {
  single_value->field_SSRC = other_value.SSRC();
} else {
  single_value->field_SSRC.clean_up();
}
if (other_value.exp().is_bound()) {
  single_value->field_exp = other_value.exp();
} else {
  single_value->field_exp.clean_up();
}
if (other_value.mantissa().is_bound()) {
  single_value->field_mantissa = other_value.mantissa();
} else {
  single_value->field_mantissa.clean_up();
}
if (other_value.measured__overhead().is_bound()) {
  single_value->field_measured__overhead = other_value.measured__overhead();
} else {
  single_value->field_measured__overhead.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__RTPFB__TMMB_template::copy_template(const RTCP__RTPFB__TMMB_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.SSRC().get_selection()) {
single_value->field_SSRC = other_value.SSRC();
} else {
single_value->field_SSRC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.exp().get_selection()) {
single_value->field_exp = other_value.exp();
} else {
single_value->field_exp.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mantissa().get_selection()) {
single_value->field_mantissa = other_value.mantissa();
} else {
single_value->field_mantissa.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.measured__overhead().get_selection()) {
single_value->field_measured__overhead = other_value.measured__overhead();
} else {
single_value->field_measured__overhead.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__RTPFB__TMMB_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__RTPFB__TMMB_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__RTPFB__TMMB_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMB.");
break;
}
set_selection(other_value);
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template()
{
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(const RTCP__RTPFB__TMMB& other_value)
{
copy_value(other_value);
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(const OPTIONAL<RTCP__RTPFB__TMMB>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMB&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_RTPFB_TMMB from an unbound optional field.");
}
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(RTCP__RTPFB__TMMB_template* p_precondition, RTCP__RTPFB__TMMB_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(Dynamic_Match_Interface<RTCP__RTPFB__TMMB>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__RTPFB__TMMB>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__RTPFB__TMMB_template::RTCP__RTPFB__TMMB_template(const RTCP__RTPFB__TMMB_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__RTPFB__TMMB_template::~RTCP__RTPFB__TMMB_template()
{
clean_up();
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMB_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMB_template::operator=(const RTCP__RTPFB__TMMB& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMB_template::operator=(const OPTIONAL<RTCP__RTPFB__TMMB>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMB&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_RTPFB_TMMB.");
}
return *this;
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMB_template::operator=(const RTCP__RTPFB__TMMB_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__RTPFB__TMMB_template::match(const RTCP__RTPFB__TMMB& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.SSRC().is_bound()) return FALSE;
if(!single_value->field_SSRC.match(other_value.SSRC(), legacy))return FALSE;
if(!other_value.exp().is_bound()) return FALSE;
if(!single_value->field_exp.match(other_value.exp(), legacy))return FALSE;
if(!other_value.mantissa().is_bound()) return FALSE;
if(!single_value->field_mantissa.match(other_value.mantissa(), legacy))return FALSE;
if(!other_value.measured__overhead().is_bound()) return FALSE;
if(!single_value->field_measured__overhead.match(other_value.measured__overhead(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMB.");
}
return FALSE;
}

boolean RTCP__RTPFB__TMMB_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_SSRC.is_bound()
 || single_value->field_exp.is_bound()
 || single_value->field_mantissa.is_bound()
 || single_value->field_measured__overhead.is_bound();
}

boolean RTCP__RTPFB__TMMB_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_SSRC.is_value()
 && single_value->field_exp.is_value()
 && single_value->field_mantissa.is_value()
 && single_value->field_measured__overhead.is_value();
}

void RTCP__RTPFB__TMMB_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__RTPFB__TMMB RTCP__RTPFB__TMMB_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMB.");
RTCP__RTPFB__TMMB ret_val;
if (single_value->field_SSRC.is_bound()) {
ret_val.SSRC() = single_value->field_SSRC.valueof();
}
if (single_value->field_exp.is_bound()) {
ret_val.exp() = single_value->field_exp.valueof();
}
if (single_value->field_mantissa.is_bound()) {
ret_val.mantissa() = single_value->field_mantissa.valueof();
}
if (single_value->field_measured__overhead.is_bound()) {
ret_val.measured__overhead() = single_value->field_measured__overhead.valueof();
}
return ret_val;
}

void RTCP__RTPFB__TMMB_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_RTPFB_TMMB.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__RTPFB__TMMB_template[list_length];
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMB_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_RTPFB_TMMB.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_RTPFB_TMMB.");
return value_list.list_value[list_index];
}

BITSTRING_template& RTCP__RTPFB__TMMB_template::SSRC()
{
set_specific();
return single_value->field_SSRC;
}

const BITSTRING_template& RTCP__RTPFB__TMMB_template::SSRC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC of a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMB.");
return single_value->field_SSRC;
}

INTEGER_template& RTCP__RTPFB__TMMB_template::exp()
{
set_specific();
return single_value->field_exp;
}

const INTEGER_template& RTCP__RTPFB__TMMB_template::exp() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field exp of a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMB.");
return single_value->field_exp;
}

INTEGER_template& RTCP__RTPFB__TMMB_template::mantissa()
{
set_specific();
return single_value->field_mantissa;
}

const INTEGER_template& RTCP__RTPFB__TMMB_template::mantissa() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mantissa of a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMB.");
return single_value->field_mantissa;
}

INTEGER_template& RTCP__RTPFB__TMMB_template::measured__overhead()
{
set_specific();
return single_value->field_measured__overhead;
}

const INTEGER_template& RTCP__RTPFB__TMMB_template::measured__overhead() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field measured_overhead of a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMB.");
return single_value->field_measured__overhead;
}

int RTCP__RTPFB__TMMB_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMB containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMB.");
  }
  return 0;
}

void RTCP__RTPFB__TMMB_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log();
TTCN_Logger::log_event_str(", exp := ");
single_value->field_exp.log();
TTCN_Logger::log_event_str(", mantissa := ");
single_value->field_mantissa.log();
TTCN_Logger::log_event_str(", measured_overhead := ");
single_value->field_measured__overhead.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__RTPFB__TMMB_template::log_match(const RTCP__RTPFB__TMMB& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_SSRC.match(match_value.SSRC(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_exp.match(match_value.exp(), legacy)){
TTCN_Logger::log_logmatch_info(".exp");
single_value->field_exp.log_match(match_value.exp(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mantissa.match(match_value.mantissa(), legacy)){
TTCN_Logger::log_logmatch_info(".mantissa");
single_value->field_mantissa.log_match(match_value.mantissa(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_measured__overhead.match(match_value.measured__overhead(), legacy)){
TTCN_Logger::log_logmatch_info(".measured_overhead");
single_value->field_measured__overhead.log_match(match_value.measured__overhead(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::log_event_str(", exp := ");
single_value->field_exp.log_match(match_value.exp(), legacy);
TTCN_Logger::log_event_str(", mantissa := ");
single_value->field_mantissa.log_match(match_value.mantissa(), legacy);
TTCN_Logger::log_event_str(", measured_overhead := ");
single_value->field_measured__overhead.log_match(match_value.measured__overhead(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__RTPFB__TMMB_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (exp().is_bound()) exp().set_implicit_omit();
if (mantissa().is_bound()) mantissa().set_implicit_omit();
if (measured__overhead().is_bound()) measured__overhead().set_implicit_omit();
}

void RTCP__RTPFB__TMMB_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_SSRC.encode_text(text_buf);
single_value->field_exp.encode_text(text_buf);
single_value->field_mantissa.encode_text(text_buf);
single_value->field_measured__overhead.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMB.");
}
}

void RTCP__RTPFB__TMMB_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_SSRC.decode_text(text_buf);
single_value->field_exp.decode_text(text_buf);
single_value->field_mantissa.decode_text(text_buf);
single_value->field_measured__overhead.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__RTPFB__TMMB_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_RTPFB_TMMB.");
}
}

void RTCP__RTPFB__TMMB_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__RTPFB__TMMB_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_RTPFB_TMMB has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) exp().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mantissa().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) measured__overhead().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "exp")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          exp().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mantissa")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mantissa().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measured_overhead")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measured__overhead().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_RTPFB_TMMB: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__RTPFB__TMMB_template* precondition = new RTCP__RTPFB__TMMB_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__RTPFB__TMMB_template* implied_template = new RTCP__RTPFB__TMMB_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__RTPFB__TMMB_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_RTPFB_TMMB");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__RTPFB__TMMB_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_SSRC.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMB");
single_value->field_exp.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMB");
single_value->field_mantissa.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMB");
single_value->field_measured__overhead.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMB");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMB");
}

boolean RTCP__RTPFB__TMMB_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__RTPFB__TMMB_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const RTCP__RTPFB__TMMB RTCP__RTPFB__TMMBNs::UNBOUND_ELEM;
RTCP__RTPFB__TMMBNs::RTCP__RTPFB__TMMBNs()
{
val_ptr = NULL;
}

RTCP__RTPFB__TMMBNs::RTCP__RTPFB__TMMBNs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__RTPFB__TMMBNs::RTCP__RTPFB__TMMBNs(const RTCP__RTPFB__TMMBNs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__RTPFB__TMMBNs::~RTCP__RTPFB__TMMBNs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__RTPFB__TMMBNs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__RTPFB__TMMBNs& RTCP__RTPFB__TMMBNs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__RTPFB__TMMBNs& RTCP__RTPFB__TMMBNs::operator=(const RTCP__RTPFB__TMMBNs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__RTPFB__TMMBNs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__RTPFB__TMMBNs::operator==(const RTCP__RTPFB__TMMBNs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBNs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_RTPFB_TMMBNs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__RTPFB__TMMB;
}
return *val_ptr->value_elements[index_value];
}

RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBNs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return (*this)[(int)index_value];
}

const RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBNs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_RTPFB_TMMBNs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_RTPFB_TMMBNs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__RTPFB__TMMB& RTCP__RTPFB__TMMBNs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return (*this)[(int)index_value];
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__RTPFB__TMMBNs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::operator+(const RTCP__RTPFB__TMMBNs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_RTPFB_TMMBNs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__RTPFB__TMMBNs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__RTPFB__TMMB(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_RTPFB_TMMBNs","element");
RTCP__RTPFB__TMMBNs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::replace(int index, int len, const RTCP__RTPFB__TMMBNs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_RTPFB_TMMBNs","element");
RTCP__RTPFB__TMMBNs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__RTPFB__TMMB(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__RTPFB__TMMB(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs::replace(int index, int len, const RTCP__RTPFB__TMMBNs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__RTPFB__TMMBNs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_RTPFB_TMMBNs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__RTPFB__TMMBNs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__RTPFB__TMMBNs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return val_ptr->n_elements;
}

int RTCP__RTPFB__TMMBNs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__RTPFB__TMMBNs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__RTPFB__TMMBNs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__RTPFB__TMMBNs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_RTPFB_TMMBNs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_RTPFB_TMMBNs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__RTPFB__TMMBNs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__RTPFB__TMMBNs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
val_ptr->value_elements = (RTCP__RTPFB__TMMB**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__RTPFB__TMMB;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__RTPFB__TMMBNs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__RTPFB__TMMBNs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__RTPFB__TMMBNs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__RTPFB__TMMBNs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__RTPFB__TMMBNs_template::copy_value(const RTCP__RTPFB__TMMBNs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_RTPFB_TMMBNs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__RTPFB__TMMBNs_template::copy_template(const RTCP__RTPFB__TMMBNs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__RTPFB__TMMBNs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__RTPFB__TMMBNs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__RTPFB__TMMBNs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
break;
}
set_selection(other_value);
}

boolean RTCP__RTPFB__TMMBNs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__RTPFB__TMMBNs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__RTPFB__TMMBNs*)value_ptr)[value_index], legacy);
else return ((const RTCP__RTPFB__TMMBNs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template()
{
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(const RTCP__RTPFB__TMMBNs& other_value)
{
copy_value(other_value);
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(const OPTIONAL<RTCP__RTPFB__TMMBNs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMBNs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_RTPFB_TMMBNs from an unbound optional field.");
}
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(RTCP__RTPFB__TMMBNs_template* p_precondition, RTCP__RTPFB__TMMBNs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(Dynamic_Match_Interface<RTCP__RTPFB__TMMBNs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__RTPFB__TMMBNs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__RTPFB__TMMBNs_template::RTCP__RTPFB__TMMBNs_template(const RTCP__RTPFB__TMMBNs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__RTPFB__TMMBNs_template::~RTCP__RTPFB__TMMBNs_template()
{
clean_up();
}

void RTCP__RTPFB__TMMBNs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::operator=(const RTCP__RTPFB__TMMBNs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::operator=(const OPTIONAL<RTCP__RTPFB__TMMBNs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__RTPFB__TMMBNs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
}
return *this;
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::operator=(const RTCP__RTPFB__TMMBNs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBNs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_RTPFB_TMMBNs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_RTPFB_TMMBNs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBNs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return (*this)[(int)index_value];
}

const RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBNs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_RTPFB_TMMBNs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_RTPFB_TMMBNs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__RTPFB__TMMB_template& RTCP__RTPFB__TMMBNs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return (*this)[(int)index_value];
}

void RTCP__RTPFB__TMMBNs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__RTPFB__TMMBNs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__RTPFB__TMMBNs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_RTPFB_TMMBNs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBNs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_RTPFB_TMMBNs");
}

boolean RTCP__RTPFB__TMMBNs_template::match(const RTCP__RTPFB__TMMBNs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
}
return FALSE;
}

boolean RTCP__RTPFB__TMMBNs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
RTCP__RTPFB__TMMBNs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs_template::replace(int index, int len, const RTCP__RTPFB__TMMBNs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__RTPFB__TMMBNs RTCP__RTPFB__TMMBNs_template::replace(int index, int len, const RTCP__RTPFB__TMMBNs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__RTPFB__TMMBNs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__RTPFB__TMMBNs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
}
set_selection(template_type);
}

RTCP__RTPFB__TMMBNs_template& RTCP__RTPFB__TMMBNs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
return value_list.list_value[list_index];
}

void RTCP__RTPFB__TMMBNs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__RTPFB__TMMBNs_template::log_match(const RTCP__RTPFB__TMMBNs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__RTPFB__TMMBNs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
}
}

void RTCP__RTPFB__TMMBNs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
single_value.value_elements = (RTCP__RTPFB__TMMB_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__RTPFB__TMMB_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__RTPFB__TMMBNs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_RTPFB_TMMBNs.");
}
}

boolean RTCP__RTPFB__TMMBNs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__RTPFB__TMMBNs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__RTPFB__TMMBNs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__RTPFB__TMMBNs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__RTPFB__TMMBNs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__RTPFB__TMMBNs_template* precondition = new RTCP__RTPFB__TMMBNs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__RTPFB__TMMBNs_template* implied_template = new RTCP__RTPFB__TMMBNs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__RTPFB__TMMBNs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_RTPFB_TMMBNs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__RTPFB__TMMBNs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMBNs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_RTPFB_TMMBNs");
}

boolean RTCP__RTPFB__TMMBNs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void RTCP__PSFB__union::copy_value(const RTCP__PSFB__union& other_value)
{
switch (other_value.union_selection) {
case ALT_pli:
field_pli = new RTCP__PSFB__PLI(*other_value.field_pli);
break;
case ALT_sli:
field_sli = new RTCP__PSFB__SLIs(*other_value.field_sli);
break;
case ALT_rpsi:
field_rpsi = new RTCP__PSFB__RPSI(*other_value.field_rpsi);
break;
case ALT_fir:
field_fir = new RTCP__PSFB__FIRs(*other_value.field_fir);
break;
case ALT_tstr:
field_tstr = new RTCP__PSFB__TSTRs(*other_value.field_tstr);
break;
case ALT_tstn:
field_tstn = new RTCP__PSFB__TSTNs(*other_value.field_tstn);
break;
case ALT_vbcm:
field_vbcm = new RTCP__PSFB__VBCMs(*other_value.field_vbcm);
break;
case ALT_afb:
field_afb = new OCTETSTRING(*other_value.field_afb);
break;
case ALT_unknown__fci:
field_unknown__fci = new OCTETSTRING(*other_value.field_unknown__fci);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RTP_Types.RTCP_PSFB_union.");
}
union_selection = other_value.union_selection;
}

RTCP__PSFB__union::RTCP__PSFB__union()
{
union_selection = UNBOUND_VALUE;
}

RTCP__PSFB__union::RTCP__PSFB__union(const RTCP__PSFB__union& other_value)
: Base_Type(){
copy_value(other_value);
}

RTCP__PSFB__union::~RTCP__PSFB__union()
{
clean_up();
}

RTCP__PSFB__union& RTCP__PSFB__union::operator=(const RTCP__PSFB__union& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean RTCP__PSFB__union::operator==(const RTCP__PSFB__union& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RTP_Types.RTCP_PSFB_union.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RTP_Types.RTCP_PSFB_union.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_pli:
return *field_pli == *other_value.field_pli;
case ALT_sli:
return *field_sli == *other_value.field_sli;
case ALT_rpsi:
return *field_rpsi == *other_value.field_rpsi;
case ALT_fir:
return *field_fir == *other_value.field_fir;
case ALT_tstr:
return *field_tstr == *other_value.field_tstr;
case ALT_tstn:
return *field_tstn == *other_value.field_tstn;
case ALT_vbcm:
return *field_vbcm == *other_value.field_vbcm;
case ALT_afb:
return *field_afb == *other_value.field_afb;
case ALT_unknown__fci:
return *field_unknown__fci == *other_value.field_unknown__fci;
default:
return FALSE;
}
}

RTCP__PSFB__PLI& RTCP__PSFB__union::pli()
{
if (union_selection != ALT_pli) {
clean_up();
field_pli = new RTCP__PSFB__PLI;
union_selection = ALT_pli;
}
return *field_pli;
}

const RTCP__PSFB__PLI& RTCP__PSFB__union::pli() const
{
if (union_selection != ALT_pli) TTCN_error("Using non-selected field pli in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_pli;
}

RTCP__PSFB__SLIs& RTCP__PSFB__union::sli()
{
if (union_selection != ALT_sli) {
clean_up();
field_sli = new RTCP__PSFB__SLIs;
union_selection = ALT_sli;
}
return *field_sli;
}

const RTCP__PSFB__SLIs& RTCP__PSFB__union::sli() const
{
if (union_selection != ALT_sli) TTCN_error("Using non-selected field sli in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_sli;
}

RTCP__PSFB__RPSI& RTCP__PSFB__union::rpsi()
{
if (union_selection != ALT_rpsi) {
clean_up();
field_rpsi = new RTCP__PSFB__RPSI;
union_selection = ALT_rpsi;
}
return *field_rpsi;
}

const RTCP__PSFB__RPSI& RTCP__PSFB__union::rpsi() const
{
if (union_selection != ALT_rpsi) TTCN_error("Using non-selected field rpsi in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_rpsi;
}

RTCP__PSFB__FIRs& RTCP__PSFB__union::fir()
{
if (union_selection != ALT_fir) {
clean_up();
field_fir = new RTCP__PSFB__FIRs;
union_selection = ALT_fir;
}
return *field_fir;
}

const RTCP__PSFB__FIRs& RTCP__PSFB__union::fir() const
{
if (union_selection != ALT_fir) TTCN_error("Using non-selected field fir in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_fir;
}

RTCP__PSFB__TSTRs& RTCP__PSFB__union::tstr()
{
if (union_selection != ALT_tstr) {
clean_up();
field_tstr = new RTCP__PSFB__TSTRs;
union_selection = ALT_tstr;
}
return *field_tstr;
}

const RTCP__PSFB__TSTRs& RTCP__PSFB__union::tstr() const
{
if (union_selection != ALT_tstr) TTCN_error("Using non-selected field tstr in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_tstr;
}

RTCP__PSFB__TSTNs& RTCP__PSFB__union::tstn()
{
if (union_selection != ALT_tstn) {
clean_up();
field_tstn = new RTCP__PSFB__TSTNs;
union_selection = ALT_tstn;
}
return *field_tstn;
}

const RTCP__PSFB__TSTNs& RTCP__PSFB__union::tstn() const
{
if (union_selection != ALT_tstn) TTCN_error("Using non-selected field tstn in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_tstn;
}

RTCP__PSFB__VBCMs& RTCP__PSFB__union::vbcm()
{
if (union_selection != ALT_vbcm) {
clean_up();
field_vbcm = new RTCP__PSFB__VBCMs;
union_selection = ALT_vbcm;
}
return *field_vbcm;
}

const RTCP__PSFB__VBCMs& RTCP__PSFB__union::vbcm() const
{
if (union_selection != ALT_vbcm) TTCN_error("Using non-selected field vbcm in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_vbcm;
}

OCTETSTRING& RTCP__PSFB__union::afb()
{
if (union_selection != ALT_afb) {
clean_up();
field_afb = new OCTETSTRING;
union_selection = ALT_afb;
}
return *field_afb;
}

const OCTETSTRING& RTCP__PSFB__union::afb() const
{
if (union_selection != ALT_afb) TTCN_error("Using non-selected field afb in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_afb;
}

OCTETSTRING& RTCP__PSFB__union::unknown__fci()
{
if (union_selection != ALT_unknown__fci) {
clean_up();
field_unknown__fci = new OCTETSTRING;
union_selection = ALT_unknown__fci;
}
return *field_unknown__fci;
}

const OCTETSTRING& RTCP__PSFB__union::unknown__fci() const
{
if (union_selection != ALT_unknown__fci) TTCN_error("Using non-selected field unknown_fci in a value of union type @RTP_Types.RTCP_PSFB_union.");
return *field_unknown__fci;
}

boolean RTCP__PSFB__union::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RTP_Types.RTCP_PSFB_union.");
return union_selection == checked_selection;
}

boolean RTCP__PSFB__union::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean RTCP__PSFB__union::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_pli: return field_pli->is_value();
case ALT_sli: return field_sli->is_value();
case ALT_rpsi: return field_rpsi->is_value();
case ALT_fir: return field_fir->is_value();
case ALT_tstr: return field_tstr->is_value();
case ALT_tstn: return field_tstn->is_value();
case ALT_vbcm: return field_vbcm->is_value();
case ALT_afb: return field_afb->is_value();
case ALT_unknown__fci: return field_unknown__fci->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void RTCP__PSFB__union::clean_up()
{
switch (union_selection) {
case ALT_pli:
  delete field_pli;
  break;
case ALT_sli:
  delete field_sli;
  break;
case ALT_rpsi:
  delete field_rpsi;
  break;
case ALT_fir:
  delete field_fir;
  break;
case ALT_tstr:
  delete field_tstr;
  break;
case ALT_tstn:
  delete field_tstn;
  break;
case ALT_vbcm:
  delete field_vbcm;
  break;
case ALT_afb:
  delete field_afb;
  break;
case ALT_unknown__fci:
  delete field_unknown__fci;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void RTCP__PSFB__union::log() const
{
switch (union_selection) {
case ALT_pli:
TTCN_Logger::log_event_str("{ pli := ");
field_pli->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sli:
TTCN_Logger::log_event_str("{ sli := ");
field_sli->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rpsi:
TTCN_Logger::log_event_str("{ rpsi := ");
field_rpsi->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_fir:
TTCN_Logger::log_event_str("{ fir := ");
field_fir->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tstr:
TTCN_Logger::log_event_str("{ tstr := ");
field_tstr->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tstn:
TTCN_Logger::log_event_str("{ tstn := ");
field_tstn->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vbcm:
TTCN_Logger::log_event_str("{ vbcm := ");
field_vbcm->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_afb:
TTCN_Logger::log_event_str("{ afb := ");
field_afb->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_unknown__fci:
TTCN_Logger::log_event_str("{ unknown_fci := ");
field_unknown__fci->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void RTCP__PSFB__union::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "pli")) {
    pli().set_param(*mp_last);
    if (!pli().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sli")) {
    sli().set_param(*mp_last);
    if (!sli().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rpsi")) {
    rpsi().set_param(*mp_last);
    if (!rpsi().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "fir")) {
    fir().set_param(*mp_last);
    if (!fir().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tstr")) {
    tstr().set_param(*mp_last);
    if (!tstr().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tstn")) {
    tstn().set_param(*mp_last);
    if (!tstn().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vbcm")) {
    vbcm().set_param(*mp_last);
    if (!vbcm().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "afb")) {
    afb().set_param(*mp_last);
    if (!afb().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "unknown_fci")) {
    unknown__fci().set_param(*mp_last);
    if (!unknown__fci().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RTP_Types.RTCP_PSFB_union.", last_name);
}

void RTCP__PSFB__union::set_implicit_omit()
{
switch (union_selection) {
case ALT_pli:
field_pli->set_implicit_omit(); break;
case ALT_sli:
field_sli->set_implicit_omit(); break;
case ALT_rpsi:
field_rpsi->set_implicit_omit(); break;
case ALT_fir:
field_fir->set_implicit_omit(); break;
case ALT_tstr:
field_tstr->set_implicit_omit(); break;
case ALT_tstn:
field_tstn->set_implicit_omit(); break;
case ALT_vbcm:
field_vbcm->set_implicit_omit(); break;
case ALT_afb:
field_afb->set_implicit_omit(); break;
case ALT_unknown__fci:
field_unknown__fci->set_implicit_omit(); break;
default: break;
}
}

void RTCP__PSFB__union::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_pli:
field_pli->encode_text(text_buf);
break;
case ALT_sli:
field_sli->encode_text(text_buf);
break;
case ALT_rpsi:
field_rpsi->encode_text(text_buf);
break;
case ALT_fir:
field_fir->encode_text(text_buf);
break;
case ALT_tstr:
field_tstr->encode_text(text_buf);
break;
case ALT_tstn:
field_tstn->encode_text(text_buf);
break;
case ALT_vbcm:
field_vbcm->encode_text(text_buf);
break;
case ALT_afb:
field_afb->encode_text(text_buf);
break;
case ALT_unknown__fci:
field_unknown__fci->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RTP_Types.RTCP_PSFB_union.");
}
}

void RTCP__PSFB__union::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_pli:
pli().decode_text(text_buf);
break;
case ALT_sli:
sli().decode_text(text_buf);
break;
case ALT_rpsi:
rpsi().decode_text(text_buf);
break;
case ALT_fir:
fir().decode_text(text_buf);
break;
case ALT_tstr:
tstr().decode_text(text_buf);
break;
case ALT_tstn:
tstn().decode_text(text_buf);
break;
case ALT_vbcm:
vbcm().decode_text(text_buf);
break;
case ALT_afb:
afb().decode_text(text_buf);
break;
case ALT_unknown__fci:
unknown__fci().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RTP_Types.RTCP_PSFB_union.");
}
}

void RTCP__PSFB__union::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__union::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__union::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, RTCP__PSFB__PLI_descr_.raw->forceomit);
      decoded_length = pli().RAW_decode(RTCP__PSFB__PLI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, RTCP__PSFB__SLIs_descr_.raw->forceomit);
      decoded_length = sli().RAW_decode(RTCP__PSFB__SLIs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, RTCP__PSFB__RPSI_descr_.raw->forceomit);
      decoded_length = rpsi().RAW_decode(RTCP__PSFB__RPSI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, RTCP__PSFB__FIRs_descr_.raw->forceomit);
      decoded_length = fir().RAW_decode(RTCP__PSFB__FIRs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, RTCP__PSFB__TSTRs_descr_.raw->forceomit);
      decoded_length = tstr().RAW_decode(RTCP__PSFB__TSTRs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, RTCP__PSFB__TSTNs_descr_.raw->forceomit);
      decoded_length = tstn().RAW_decode(RTCP__PSFB__TSTNs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, RTCP__PSFB__VBCMs_descr_.raw->forceomit);
      decoded_length = vbcm().RAW_decode(RTCP__PSFB__VBCMs_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = afb().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = unknown__fci().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__PSFB__PLI_descr_.raw->forceomit);
      decoded_length = pli().RAW_decode(RTCP__PSFB__PLI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__PSFB__SLIs_descr_.raw->forceomit);
      decoded_length = sli().RAW_decode(RTCP__PSFB__SLIs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__PSFB__RPSI_descr_.raw->forceomit);
      decoded_length = rpsi().RAW_decode(RTCP__PSFB__RPSI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, RTCP__PSFB__FIRs_descr_.raw->forceomit);
      decoded_length = fir().RAW_decode(RTCP__PSFB__FIRs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, RTCP__PSFB__TSTRs_descr_.raw->forceomit);
      decoded_length = tstr().RAW_decode(RTCP__PSFB__TSTRs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, RTCP__PSFB__TSTNs_descr_.raw->forceomit);
      decoded_length = tstn().RAW_decode(RTCP__PSFB__TSTNs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, RTCP__PSFB__VBCMs_descr_.raw->forceomit);
      decoded_length = vbcm().RAW_decode(RTCP__PSFB__VBCMs_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = afb().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = unknown__fci().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int RTCP__PSFB__union::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  memset(myleaf.body.node.nodes, 0, 9 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_pli:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, RTCP__PSFB__PLI_descr_.raw);
    encoded_length = field_pli->RAW_encode(RTCP__PSFB__PLI_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &RTCP__PSFB__PLI_descr_;
    break;
  case ALT_sli:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, RTCP__PSFB__SLIs_descr_.raw);
    encoded_length = field_sli->RAW_encode(RTCP__PSFB__SLIs_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &RTCP__PSFB__SLIs_descr_;
    break;
  case ALT_rpsi:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, RTCP__PSFB__RPSI_descr_.raw);
    encoded_length = field_rpsi->RAW_encode(RTCP__PSFB__RPSI_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &RTCP__PSFB__RPSI_descr_;
    break;
  case ALT_fir:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, RTCP__PSFB__FIRs_descr_.raw);
    encoded_length = field_fir->RAW_encode(RTCP__PSFB__FIRs_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &RTCP__PSFB__FIRs_descr_;
    break;
  case ALT_tstr:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, RTCP__PSFB__TSTRs_descr_.raw);
    encoded_length = field_tstr->RAW_encode(RTCP__PSFB__TSTRs_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &RTCP__PSFB__TSTRs_descr_;
    break;
  case ALT_tstn:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, RTCP__PSFB__TSTNs_descr_.raw);
    encoded_length = field_tstn->RAW_encode(RTCP__PSFB__TSTNs_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &RTCP__PSFB__TSTNs_descr_;
    break;
  case ALT_vbcm:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, RTCP__PSFB__VBCMs_descr_.raw);
    encoded_length = field_vbcm->RAW_encode(RTCP__PSFB__VBCMs_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &RTCP__PSFB__VBCMs_descr_;
    break;
  case ALT_afb:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, OCTETSTRING_descr_.raw);
    encoded_length = field_afb->RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &OCTETSTRING_descr_;
    break;
  case ALT_unknown__fci:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, OCTETSTRING_descr_.raw);
    encoded_length = field_unknown__fci->RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &OCTETSTRING_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void RTCP__PSFB__union_template::copy_value(const RTCP__PSFB__union& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli = new RTCP__PSFB__PLI_template(other_value.pli());
break;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli = new RTCP__PSFB__SLIs_template(other_value.sli());
break;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi = new RTCP__PSFB__RPSI_template(other_value.rpsi());
break;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir = new RTCP__PSFB__FIRs_template(other_value.fir());
break;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr = new RTCP__PSFB__TSTRs_template(other_value.tstr());
break;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn = new RTCP__PSFB__TSTNs_template(other_value.tstn());
break;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm = new RTCP__PSFB__VBCMs_template(other_value.vbcm());
break;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb = new OCTETSTRING_template(other_value.afb());
break;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template(other_value.unknown__fci());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RTP_Types.RTCP_PSFB_union.");
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__union_template::copy_template(const RTCP__PSFB__union_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli = new RTCP__PSFB__PLI_template(*other_value.single_value.field_pli);
break;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli = new RTCP__PSFB__SLIs_template(*other_value.single_value.field_sli);
break;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi = new RTCP__PSFB__RPSI_template(*other_value.single_value.field_rpsi);
break;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir = new RTCP__PSFB__FIRs_template(*other_value.single_value.field_fir);
break;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr = new RTCP__PSFB__TSTRs_template(*other_value.single_value.field_tstr);
break;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn = new RTCP__PSFB__TSTNs_template(*other_value.single_value.field_tstn);
break;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm = new RTCP__PSFB__VBCMs_template(*other_value.single_value.field_vbcm);
break;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb = new OCTETSTRING_template(*other_value.single_value.field_afb);
break;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template(*other_value.single_value.field_unknown__fci);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RTP_Types.RTCP_PSFB_union.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__union_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__union_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__union_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RTP_Types.RTCP_PSFB_union.");
}
set_selection(other_value);
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template()
{
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(const RTCP__PSFB__union& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(const OPTIONAL<RTCP__PSFB__union>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__union&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RTP_Types.RTCP_PSFB_union from an unbound optional field.");
}
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(RTCP__PSFB__union_template* p_precondition, RTCP__PSFB__union_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(Dynamic_Match_Interface<RTCP__PSFB__union>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__union>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__union_template::RTCP__PSFB__union_template(const RTCP__PSFB__union_template& other_value)
: Base_Template(){
copy_template(other_value);
}

RTCP__PSFB__union_template::~RTCP__PSFB__union_template()
{
clean_up();
}

void RTCP__PSFB__union_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
delete single_value.field_pli;
break;
case RTCP__PSFB__union::ALT_sli:
delete single_value.field_sli;
break;
case RTCP__PSFB__union::ALT_rpsi:
delete single_value.field_rpsi;
break;
case RTCP__PSFB__union::ALT_fir:
delete single_value.field_fir;
break;
case RTCP__PSFB__union::ALT_tstr:
delete single_value.field_tstr;
break;
case RTCP__PSFB__union::ALT_tstn:
delete single_value.field_tstn;
break;
case RTCP__PSFB__union::ALT_vbcm:
delete single_value.field_vbcm;
break;
case RTCP__PSFB__union::ALT_afb:
delete single_value.field_afb;
break;
case RTCP__PSFB__union::ALT_unknown__fci:
delete single_value.field_unknown__fci;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__union_template& RTCP__PSFB__union_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__union_template& RTCP__PSFB__union_template::operator=(const RTCP__PSFB__union& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__union_template& RTCP__PSFB__union_template::operator=(const OPTIONAL<RTCP__PSFB__union>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__union&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RTP_Types.RTCP_PSFB_union.");
}
return *this;
}

RTCP__PSFB__union_template& RTCP__PSFB__union_template::operator=(const RTCP__PSFB__union_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__PSFB__union_template::match(const RTCP__PSFB__union& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
RTCP__PSFB__union::union_selection_type value_selection = other_value.get_selection();
if (value_selection == RTCP__PSFB__union::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case RTCP__PSFB__union::ALT_pli:
return single_value.field_pli->match(other_value.pli(), legacy);
case RTCP__PSFB__union::ALT_sli:
return single_value.field_sli->match(other_value.sli(), legacy);
case RTCP__PSFB__union::ALT_rpsi:
return single_value.field_rpsi->match(other_value.rpsi(), legacy);
case RTCP__PSFB__union::ALT_fir:
return single_value.field_fir->match(other_value.fir(), legacy);
case RTCP__PSFB__union::ALT_tstr:
return single_value.field_tstr->match(other_value.tstr(), legacy);
case RTCP__PSFB__union::ALT_tstn:
return single_value.field_tstn->match(other_value.tstn(), legacy);
case RTCP__PSFB__union::ALT_vbcm:
return single_value.field_vbcm->match(other_value.vbcm(), legacy);
case RTCP__PSFB__union::ALT_afb:
return single_value.field_afb->match(other_value.afb(), legacy);
case RTCP__PSFB__union::ALT_unknown__fci:
return single_value.field_unknown__fci->match(other_value.unknown__fci(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RTP_Types.RTCP_PSFB_union.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RTP_Types.RTCP_PSFB_union.");
}
return FALSE;
}

boolean RTCP__PSFB__union_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
return single_value.field_pli->is_value();
case RTCP__PSFB__union::ALT_sli:
return single_value.field_sli->is_value();
case RTCP__PSFB__union::ALT_rpsi:
return single_value.field_rpsi->is_value();
case RTCP__PSFB__union::ALT_fir:
return single_value.field_fir->is_value();
case RTCP__PSFB__union::ALT_tstr:
return single_value.field_tstr->is_value();
case RTCP__PSFB__union::ALT_tstn:
return single_value.field_tstn->is_value();
case RTCP__PSFB__union::ALT_vbcm:
return single_value.field_vbcm->is_value();
case RTCP__PSFB__union::ALT_afb:
return single_value.field_afb->is_value();
case RTCP__PSFB__union::ALT_unknown__fci:
return single_value.field_unknown__fci->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RTP_Types.RTCP_PSFB_union.");
}
}

RTCP__PSFB__union RTCP__PSFB__union_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
RTCP__PSFB__union ret_val;
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
ret_val.pli() = single_value.field_pli->valueof();
break;
case RTCP__PSFB__union::ALT_sli:
ret_val.sli() = single_value.field_sli->valueof();
break;
case RTCP__PSFB__union::ALT_rpsi:
ret_val.rpsi() = single_value.field_rpsi->valueof();
break;
case RTCP__PSFB__union::ALT_fir:
ret_val.fir() = single_value.field_fir->valueof();
break;
case RTCP__PSFB__union::ALT_tstr:
ret_val.tstr() = single_value.field_tstr->valueof();
break;
case RTCP__PSFB__union::ALT_tstn:
ret_val.tstn() = single_value.field_tstn->valueof();
break;
case RTCP__PSFB__union::ALT_vbcm:
ret_val.vbcm() = single_value.field_vbcm->valueof();
break;
case RTCP__PSFB__union::ALT_afb:
ret_val.afb() = single_value.field_afb->valueof();
break;
case RTCP__PSFB__union::ALT_unknown__fci:
ret_val.unknown__fci() = single_value.field_unknown__fci->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RTP_Types.RTCP_PSFB_union.");
}
return ret_val;
}

RTCP__PSFB__union_template& RTCP__PSFB__union_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RTP_Types.RTCP_PSFB_union.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RTP_Types.RTCP_PSFB_union.");
return value_list.list_value[list_index];
}
void RTCP__PSFB__union_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RTP_Types.RTCP_PSFB_union.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__union_template[list_length];
}

RTCP__PSFB__PLI_template& RTCP__PSFB__union_template::pli()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_pli) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pli = new RTCP__PSFB__PLI_template(ANY_VALUE);
else single_value.field_pli = new RTCP__PSFB__PLI_template;
single_value.union_selection = RTCP__PSFB__union::ALT_pli;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pli;
}

const RTCP__PSFB__PLI_template& RTCP__PSFB__union_template::pli() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pli in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_pli) TTCN_error("Accessing non-selected field pli in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_pli;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__union_template::sli()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_sli) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_sli = new RTCP__PSFB__SLIs_template(ANY_VALUE);
else single_value.field_sli = new RTCP__PSFB__SLIs_template;
single_value.union_selection = RTCP__PSFB__union::ALT_sli;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_sli;
}

const RTCP__PSFB__SLIs_template& RTCP__PSFB__union_template::sli() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field sli in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_sli) TTCN_error("Accessing non-selected field sli in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_sli;
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__union_template::rpsi()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_rpsi) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rpsi = new RTCP__PSFB__RPSI_template(ANY_VALUE);
else single_value.field_rpsi = new RTCP__PSFB__RPSI_template;
single_value.union_selection = RTCP__PSFB__union::ALT_rpsi;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rpsi;
}

const RTCP__PSFB__RPSI_template& RTCP__PSFB__union_template::rpsi() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rpsi in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_rpsi) TTCN_error("Accessing non-selected field rpsi in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_rpsi;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__union_template::fir()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_fir) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_fir = new RTCP__PSFB__FIRs_template(ANY_VALUE);
else single_value.field_fir = new RTCP__PSFB__FIRs_template;
single_value.union_selection = RTCP__PSFB__union::ALT_fir;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_fir;
}

const RTCP__PSFB__FIRs_template& RTCP__PSFB__union_template::fir() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field fir in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_fir) TTCN_error("Accessing non-selected field fir in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_fir;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__union_template::tstr()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_tstr) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tstr = new RTCP__PSFB__TSTRs_template(ANY_VALUE);
else single_value.field_tstr = new RTCP__PSFB__TSTRs_template;
single_value.union_selection = RTCP__PSFB__union::ALT_tstr;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tstr;
}

const RTCP__PSFB__TSTRs_template& RTCP__PSFB__union_template::tstr() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tstr in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_tstr) TTCN_error("Accessing non-selected field tstr in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_tstr;
}

RTCP__PSFB__TSTNs_template& RTCP__PSFB__union_template::tstn()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_tstn) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tstn = new RTCP__PSFB__TSTNs_template(ANY_VALUE);
else single_value.field_tstn = new RTCP__PSFB__TSTNs_template;
single_value.union_selection = RTCP__PSFB__union::ALT_tstn;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tstn;
}

const RTCP__PSFB__TSTNs_template& RTCP__PSFB__union_template::tstn() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tstn in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_tstn) TTCN_error("Accessing non-selected field tstn in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_tstn;
}

RTCP__PSFB__VBCMs_template& RTCP__PSFB__union_template::vbcm()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_vbcm) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vbcm = new RTCP__PSFB__VBCMs_template(ANY_VALUE);
else single_value.field_vbcm = new RTCP__PSFB__VBCMs_template;
single_value.union_selection = RTCP__PSFB__union::ALT_vbcm;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vbcm;
}

const RTCP__PSFB__VBCMs_template& RTCP__PSFB__union_template::vbcm() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vbcm in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_vbcm) TTCN_error("Accessing non-selected field vbcm in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_vbcm;
}

OCTETSTRING_template& RTCP__PSFB__union_template::afb()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_afb) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_afb = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_afb = new OCTETSTRING_template;
single_value.union_selection = RTCP__PSFB__union::ALT_afb;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_afb;
}

const OCTETSTRING_template& RTCP__PSFB__union_template::afb() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field afb in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_afb) TTCN_error("Accessing non-selected field afb in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_afb;
}

OCTETSTRING_template& RTCP__PSFB__union_template::unknown__fci()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RTCP__PSFB__union::ALT_unknown__fci) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_unknown__fci = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_unknown__fci = new OCTETSTRING_template;
single_value.union_selection = RTCP__PSFB__union::ALT_unknown__fci;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_unknown__fci;
}

const OCTETSTRING_template& RTCP__PSFB__union_template::unknown__fci() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field unknown_fci in a non-specific template of union type @RTP_Types.RTCP_PSFB_union.");
if (single_value.union_selection != RTCP__PSFB__union::ALT_unknown__fci) TTCN_error("Accessing non-selected field unknown_fci in a template of union type @RTP_Types.RTCP_PSFB_union.");
return *single_value.field_unknown__fci;
}

boolean RTCP__PSFB__union_template::ischosen(RTCP__PSFB__union::union_selection_type checked_selection) const
{
if (checked_selection == RTCP__PSFB__union::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RTP_Types.RTCP_PSFB_union.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == RTCP__PSFB__union::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RTP_Types.RTCP_PSFB_union.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RTP_Types.RTCP_PSFB_union containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void RTCP__PSFB__union_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
TTCN_Logger::log_event_str("{ pli := ");
single_value.field_pli->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_sli:
TTCN_Logger::log_event_str("{ sli := ");
single_value.field_sli->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_rpsi:
TTCN_Logger::log_event_str("{ rpsi := ");
single_value.field_rpsi->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_fir:
TTCN_Logger::log_event_str("{ fir := ");
single_value.field_fir->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_tstr:
TTCN_Logger::log_event_str("{ tstr := ");
single_value.field_tstr->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_tstn:
TTCN_Logger::log_event_str("{ tstn := ");
single_value.field_tstn->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_vbcm:
TTCN_Logger::log_event_str("{ vbcm := ");
single_value.field_vbcm->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_afb:
TTCN_Logger::log_event_str("{ afb := ");
single_value.field_afb->log();
TTCN_Logger::log_event_str(" }");
break;
case RTCP__PSFB__union::ALT_unknown__fci:
TTCN_Logger::log_event_str("{ unknown_fci := ");
single_value.field_unknown__fci->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__union_template::log_match(const RTCP__PSFB__union& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pli");
single_value.field_pli->log_match(match_value.pli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pli := ");
single_value.field_pli->log_match(match_value.pli(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_sli:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".sli");
single_value.field_sli->log_match(match_value.sli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ sli := ");
single_value.field_sli->log_match(match_value.sli(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_rpsi:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rpsi");
single_value.field_rpsi->log_match(match_value.rpsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rpsi := ");
single_value.field_rpsi->log_match(match_value.rpsi(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_fir:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".fir");
single_value.field_fir->log_match(match_value.fir(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ fir := ");
single_value.field_fir->log_match(match_value.fir(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_tstr:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tstr");
single_value.field_tstr->log_match(match_value.tstr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tstr := ");
single_value.field_tstr->log_match(match_value.tstr(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_tstn:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tstn");
single_value.field_tstn->log_match(match_value.tstn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tstn := ");
single_value.field_tstn->log_match(match_value.tstn(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_vbcm:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vbcm");
single_value.field_vbcm->log_match(match_value.vbcm(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vbcm := ");
single_value.field_vbcm->log_match(match_value.vbcm(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_afb:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".afb");
single_value.field_afb->log_match(match_value.afb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ afb := ");
single_value.field_afb->log_match(match_value.afb(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RTCP__PSFB__union::ALT_unknown__fci:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".unknown_fci");
single_value.field_unknown__fci->log_match(match_value.unknown__fci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ unknown_fci := ");
single_value.field_unknown__fci->log_match(match_value.unknown__fci(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__union_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb->set_implicit_omit(); break;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->set_implicit_omit(); break;
default: break;
}
}

void RTCP__PSFB__union_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb->encode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RTP_Types.RTCP_PSFB_union.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RTP_Types.RTCP_PSFB_union.");
}
}

void RTCP__PSFB__union_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = RTCP__PSFB__union::UNBOUND_VALUE;
RTCP__PSFB__union::union_selection_type new_selection = (RTCP__PSFB__union::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli = new RTCP__PSFB__PLI_template;
single_value.field_pli->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli = new RTCP__PSFB__SLIs_template;
single_value.field_sli->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi = new RTCP__PSFB__RPSI_template;
single_value.field_rpsi->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir = new RTCP__PSFB__FIRs_template;
single_value.field_fir->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr = new RTCP__PSFB__TSTRs_template;
single_value.field_tstr->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn = new RTCP__PSFB__TSTNs_template;
single_value.field_tstn->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm = new RTCP__PSFB__VBCMs_template;
single_value.field_vbcm->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb = new OCTETSTRING_template;
single_value.field_afb->decode_text(text_buf);
break;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci = new OCTETSTRING_template;
single_value.field_unknown__fci->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RTP_Types.RTCP_PSFB_union.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__union_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RTP_Types.RTCP_PSFB_union.");
}
}

boolean RTCP__PSFB__union_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__union_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__PSFB__union_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RTP_Types.RTCP_PSFB_union'");
    }
    if (strcmp("pli", param_field) == 0) {
      pli().set_param(param);
      return;
    } else if (strcmp("sli", param_field) == 0) {
      sli().set_param(param);
      return;
    } else if (strcmp("rpsi", param_field) == 0) {
      rpsi().set_param(param);
      return;
    } else if (strcmp("fir", param_field) == 0) {
      fir().set_param(param);
      return;
    } else if (strcmp("tstr", param_field) == 0) {
      tstr().set_param(param);
      return;
    } else if (strcmp("tstn", param_field) == 0) {
      tstn().set_param(param);
      return;
    } else if (strcmp("vbcm", param_field) == 0) {
      vbcm().set_param(param);
      return;
    } else if (strcmp("afb", param_field) == 0) {
      afb().set_param(param);
      return;
    } else if (strcmp("unknown_fci", param_field) == 0) {
      unknown__fci().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RTP_Types.RTCP_PSFB_union'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__union_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RTP_Types.RTCP_PSFB_union");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "pli")) {
      pli().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "sli")) {
      sli().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rpsi")) {
      rpsi().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "fir")) {
      fir().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tstr")) {
      tstr().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tstn")) {
      tstn().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vbcm")) {
      vbcm().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "afb")) {
      afb().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "unknown_fci")) {
      unknown__fci().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RTP_Types.RTCP_PSFB_union.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__union_template* precondition = new RTCP__PSFB__union_template;
    precondition->set_param(*m_p->get_elem(0));
    RTCP__PSFB__union_template* implied_template = new RTCP__PSFB__union_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RTCP__PSFB__union_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RTP_Types.RTCP_PSFB_union");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__union_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case RTCP__PSFB__union::ALT_pli:
single_value.field_pli->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_sli:
single_value.field_sli->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_rpsi:
single_value.field_rpsi->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_fir:
single_value.field_fir->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_tstr:
single_value.field_tstr->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_tstn:
single_value.field_tstn->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_vbcm:
single_value.field_vbcm->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_afb:
single_value.field_afb->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
case RTCP__PSFB__union::ALT_unknown__fci:
single_value.field_unknown__fci->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RTP_Types.RTCP_PSFB_union.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_union");
}

RTCP__PSFB__PLI::RTCP__PSFB__PLI()
{
bound_flag = FALSE;
}

RTCP__PSFB__PLI::RTCP__PSFB__PLI(null_type)
{
bound_flag = TRUE;
}

RTCP__PSFB__PLI::RTCP__PSFB__PLI(const RTCP__PSFB__PLI& other_value)
{
other_value.must_bound("Copying an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
bound_flag = TRUE;
}

RTCP__PSFB__PLI& RTCP__PSFB__PLI::operator=(null_type)
{
bound_flag = TRUE;
return *this;
}

RTCP__PSFB__PLI& RTCP__PSFB__PLI::operator=(const RTCP__PSFB__PLI& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
bound_flag = TRUE;
return *this;
}

boolean RTCP__PSFB__PLI::operator==(null_type) const
{
must_bound("Comparison of an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
return TRUE;
}

boolean RTCP__PSFB__PLI::operator==(const RTCP__PSFB__PLI& other_value) const
{
must_bound("Comparison of an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
other_value.must_bound("Comparison of an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
return TRUE;
}

void RTCP__PSFB__PLI::log() const
{
if (bound_flag) TTCN_Logger::log_event_str("{ }");
else TTCN_Logger::log_event_unbound();
}

void RTCP__PSFB__PLI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "empty record/set value (i.e. { })");
  if (param.get_type()!=Module_Param::MP_Value_List || param.get_size()>0) {
    param.type_error("empty record/set value (i.e. { })", "@RTP_Types.RTCP_PSFB_PLI");
  }
  bound_flag = TRUE;
}

void RTCP__PSFB__PLI::encode_text(Text_Buf& /*text_buf*/) const
{
must_bound("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
}

void RTCP__PSFB__PLI::decode_text(Text_Buf& /*text_buf*/)
{
bound_flag = TRUE;
}

void RTCP__PSFB__PLI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__PLI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__PLI::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& /*myleaf*/) const
{
if (!bound_flag) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value of type %s.", p_td.name);
return 0;
}

int RTCP__PSFB__PLI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int, raw_order_t, boolean, int, boolean, const RAW_Force_Omit*)
{
bound_flag = TRUE;
return p_buf.increase_pos_padd(p_td.raw->prepadding) + p_buf.increase_pos_padd(p_td.raw->padding);
}

void RTCP__PSFB__PLI_template::copy_template(const RTCP__PSFB__PLI_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__PLI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__PLI_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__PLI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_PLI.");
break;
}
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template()
{
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(null_type)
 : Base_Template(SPECIFIC_VALUE)
{
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(const RTCP__PSFB__PLI& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound value of type @RTP_Types.RTCP_PSFB_PLI.");
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(const OPTIONAL<RTCP__PSFB__PLI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_PLI from an unbound optional field.");
}
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(RTCP__PSFB__PLI_template* p_precondition, RTCP__PSFB__PLI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(Dynamic_Match_Interface<RTCP__PSFB__PLI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__PLI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__PLI_template::RTCP__PSFB__PLI_template(const RTCP__PSFB__PLI_template& other_value)
: Base_Template(){
copy_template(other_value);
}

RTCP__PSFB__PLI_template::~RTCP__PSFB__PLI_template()
{
clean_up();
}

void RTCP__PSFB__PLI_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::operator=(const RTCP__PSFB__PLI& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_PLI to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::operator=(const OPTIONAL<RTCP__PSFB__PLI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_PLI.");
}
return *this;
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::operator=(const RTCP__PSFB__PLI_template& other_value)
{
if (&other_value != this) {
clean_up();
set_selection(other_value);
}
return *this;
}

boolean RTCP__PSFB__PLI_template::match(null_type other_value,boolean) const
{
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
return TRUE;
case OMIT_VALUE:
return FALSE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_PLI.");
}
return FALSE;
}

boolean RTCP__PSFB__PLI_template::match(const RTCP__PSFB__PLI& other_value, boolean) const
{
if (!other_value.is_bound()) return FALSE;
return match(NULL_VALUE);
}

RTCP__PSFB__PLI RTCP__PSFB__PLI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_PLI.");
return NULL_VALUE;
}

void RTCP__PSFB__PLI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_PSFB_PLI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__PLI_template[list_length];
}

RTCP__PSFB__PLI_template& RTCP__PSFB__PLI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_PLI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_PLI.");
return value_list.list_value[list_index];
}

void RTCP__PSFB__PLI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__PLI_template::log_match(const RTCP__PSFB__PLI& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RTCP__PSFB__PLI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_PLI.");
}
}

void RTCP__PSFB__PLI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__PLI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_PSFB_PLI.");
}
}

void RTCP__PSFB__PLI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "empty record/set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__PLI_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Value_List:
    if (param.get_size()>0) param.type_error("empty record/set template", "@RTP_Types.RTCP_PSFB_PLI");
    *this = NULL_VALUE;
    break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__PLI_template* precondition = new RTCP__PSFB__PLI_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__PLI_template* implied_template = new RTCP__PSFB__PLI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__PLI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("empty record/set template", "@RTP_Types.RTCP_PSFB_PLI");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__PLI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_PLI");
}

boolean RTCP__PSFB__PLI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__PLI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const RTCP__PSFB__SLI RTCP__PSFB__SLIs::UNBOUND_ELEM;
RTCP__PSFB__SLIs::RTCP__PSFB__SLIs()
{
val_ptr = NULL;
}

RTCP__PSFB__SLIs::RTCP__PSFB__SLIs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__PSFB__SLIs::RTCP__PSFB__SLIs(const RTCP__PSFB__SLIs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__PSFB__SLIs::~RTCP__PSFB__SLIs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__PSFB__SLIs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__PSFB__SLIs& RTCP__PSFB__SLIs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__PSFB__SLIs& RTCP__PSFB__SLIs::operator=(const RTCP__PSFB__SLIs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__PSFB__SLIs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__PSFB__SLIs::operator==(const RTCP__PSFB__SLIs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__PSFB__SLI& RTCP__PSFB__SLIs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_SLIs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__SLI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__SLI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__PSFB__SLI;
}
return *val_ptr->value_elements[index_value];
}

RTCP__PSFB__SLI& RTCP__PSFB__SLIs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_SLIs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__SLI& RTCP__PSFB__SLIs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_SLIs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_PSFB_SLIs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__PSFB__SLI& RTCP__PSFB__SLIs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_SLIs.");
return (*this)[(int)index_value];
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__PSFB__SLIs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__PSFB__SLI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::operator+(const RTCP__PSFB__SLIs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_PSFB_SLIs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__PSFB__SLIs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__SLI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__PSFB__SLI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_PSFB_SLIs","element");
RTCP__PSFB__SLIs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__SLI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::replace(int index, int len, const RTCP__PSFB__SLIs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_PSFB_SLIs","element");
RTCP__PSFB__SLIs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__SLI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__PSFB__SLI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__PSFB__SLI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs::replace(int index, int len, const RTCP__PSFB__SLIs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__PSFB__SLIs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_PSFB_SLIs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__SLI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__SLI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__PSFB__SLI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_PSFB_SLIs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__PSFB__SLI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__PSFB__SLIs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__PSFB__SLIs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
return val_ptr->n_elements;
}

int RTCP__PSFB__SLIs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__PSFB__SLIs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__PSFB__SLIs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__SLIs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_SLIs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_SLIs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__PSFB__SLIs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_PSFB_SLIs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__PSFB__SLIs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_PSFB_SLIs.");
val_ptr->value_elements = (RTCP__PSFB__SLI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__PSFB__SLI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__PSFB__SLIs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__SLIs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__SLIs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__PSFB__SLIs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__PSFB__SLIs_template::copy_value(const RTCP__PSFB__SLIs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_PSFB_SLIs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__PSFB__SLI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__SLIs_template::copy_template(const RTCP__PSFB__SLIs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__PSFB__SLI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__SLIs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__SLIs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__SLIs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLIs.");
break;
}
set_selection(other_value);
}

boolean RTCP__PSFB__SLIs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__PSFB__SLIs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__PSFB__SLIs*)value_ptr)[value_index], legacy);
else return ((const RTCP__PSFB__SLIs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template()
{
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(const RTCP__PSFB__SLIs& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(const OPTIONAL<RTCP__PSFB__SLIs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__SLIs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_SLIs from an unbound optional field.");
}
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(RTCP__PSFB__SLIs_template* p_precondition, RTCP__PSFB__SLIs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(Dynamic_Match_Interface<RTCP__PSFB__SLIs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__SLIs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__SLIs_template::RTCP__PSFB__SLIs_template(const RTCP__PSFB__SLIs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__PSFB__SLIs_template::~RTCP__PSFB__SLIs_template()
{
clean_up();
}

void RTCP__PSFB__SLIs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::operator=(const RTCP__PSFB__SLIs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::operator=(const OPTIONAL<RTCP__PSFB__SLIs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__SLIs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_SLIs.");
}
return *this;
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::operator=(const RTCP__PSFB__SLIs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLIs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_SLIs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_SLIs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLIs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_SLIs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__SLI_template& RTCP__PSFB__SLIs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_SLIs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_SLIs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_PSFB_SLIs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__PSFB__SLI_template& RTCP__PSFB__SLIs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_SLIs.");
return (*this)[(int)index_value];
}

void RTCP__PSFB__SLIs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_PSFB_SLIs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__PSFB__SLI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__PSFB__SLI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__PSFB__SLIs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__PSFB__SLIs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_SLIs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLIs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_PSFB_SLIs");
}

boolean RTCP__PSFB__SLIs_template::match(const RTCP__PSFB__SLIs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLIs.");
}
return FALSE;
}

boolean RTCP__PSFB__SLIs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_SLIs.");
RTCP__PSFB__SLIs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs_template::replace(int index, int len, const RTCP__PSFB__SLIs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__PSFB__SLIs RTCP__PSFB__SLIs_template::replace(int index, int len, const RTCP__PSFB__SLIs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__PSFB__SLIs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__SLIs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_PSFB_SLIs.");
}
set_selection(template_type);
}

RTCP__PSFB__SLIs_template& RTCP__PSFB__SLIs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_SLIs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_SLIs.");
return value_list.list_value[list_index];
}

void RTCP__PSFB__SLIs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__PSFB__SLIs_template::log_match(const RTCP__PSFB__SLIs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__SLIs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLIs.");
}
}

void RTCP__PSFB__SLIs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_PSFB_SLIs.");
single_value.value_elements = (RTCP__PSFB__SLI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__PSFB__SLI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__SLIs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_PSFB_SLIs.");
}
}

boolean RTCP__PSFB__SLIs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__SLIs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__PSFB__SLIs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__SLIs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__SLIs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__SLIs_template* precondition = new RTCP__PSFB__SLIs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__SLIs_template* implied_template = new RTCP__PSFB__SLIs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__SLIs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_PSFB_SLIs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__PSFB__SLIs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLIs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLIs");
}

boolean RTCP__PSFB__SLIs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
RTCP__PSFB__SLI::RTCP__PSFB__SLI()
{
}

RTCP__PSFB__SLI::RTCP__PSFB__SLI(const INTEGER& par_first,
    const INTEGER& par_number,
    const INTEGER& par_picture__id)
  :   field_first(par_first),
  field_number(par_number),
  field_picture__id(par_picture__id)
{
}

RTCP__PSFB__SLI::RTCP__PSFB__SLI(const RTCP__PSFB__SLI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_SLI.");
if (other_value.first().is_bound()) field_first = other_value.first();
else field_first.clean_up();
if (other_value.number().is_bound()) field_number = other_value.number();
else field_number.clean_up();
if (other_value.picture__id().is_bound()) field_picture__id = other_value.picture__id();
else field_picture__id.clean_up();
}

void RTCP__PSFB__SLI::clean_up()
{
field_first.clean_up();
field_number.clean_up();
field_picture__id.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__PSFB__SLI::get_descriptor() const { return &RTCP__PSFB__SLI_descr_; }
RTCP__PSFB__SLI& RTCP__PSFB__SLI::operator=(const RTCP__PSFB__SLI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_SLI.");
  if (other_value.first().is_bound()) field_first = other_value.first();
  else field_first.clean_up();
  if (other_value.number().is_bound()) field_number = other_value.number();
  else field_number.clean_up();
  if (other_value.picture__id().is_bound()) field_picture__id = other_value.picture__id();
  else field_picture__id.clean_up();
}
return *this;
}

boolean RTCP__PSFB__SLI::operator==(const RTCP__PSFB__SLI& other_value) const
{
return field_first==other_value.field_first
  && field_number==other_value.field_number
  && field_picture__id==other_value.field_picture__id;
}

boolean RTCP__PSFB__SLI::is_bound() const
{
return (field_first.is_bound())
  || (field_number.is_bound())
  || (field_picture__id.is_bound());
}
boolean RTCP__PSFB__SLI::is_value() const
{
return field_first.is_value()
  && field_number.is_value()
  && field_picture__id.is_value();
}
void RTCP__PSFB__SLI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ first := ");
field_first.log();
TTCN_Logger::log_event_str(", number := ");
field_number.log();
TTCN_Logger::log_event_str(", picture_id := ");
field_picture__id.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__PSFB__SLI::set_implicit_omit()
{
if (first().is_bound()) first().set_implicit_omit();
if (number().is_bound()) number().set_implicit_omit();
if (picture__id().is_bound()) picture__id().set_implicit_omit();
}

void RTCP__PSFB__SLI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_PSFB_SLI has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) first().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) picture__id().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "first")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          first().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "picture_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          picture__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_SLI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_PSFB_SLI");
  }
}

void RTCP__PSFB__SLI::encode_text(Text_Buf& text_buf) const
{
field_first.encode_text(text_buf);
field_number.encode_text(text_buf);
field_picture__id.encode_text(text_buf);
}

void RTCP__PSFB__SLI::decode_text(Text_Buf& text_buf)
{
field_first.decode_text(text_buf);
field_number.decode_text(text_buf);
field_picture__id.decode_text(text_buf);
}

void RTCP__PSFB__SLI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__SLI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__SLI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RTCP__PSFB__SLI_first_descr_.raw->forceomit);
  decoded_field_length = field_first.RAW_decode(RTCP__PSFB__SLI_first_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__PSFB__SLI_number_descr_.raw->forceomit);
  decoded_field_length = field_number.RAW_decode(RTCP__PSFB__SLI_number_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RTCP__PSFB__SLI_picture__id_descr_.raw->forceomit);
  decoded_field_length = field_picture__id.RAW_decode(RTCP__PSFB__SLI_picture__id_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__PSFB__SLI::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RTCP__PSFB__SLI_first_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__PSFB__SLI_number_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RTCP__PSFB__SLI_picture__id_descr_.raw);
  encoded_length += field_first.RAW_encode(RTCP__PSFB__SLI_first_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_number.RAW_encode(RTCP__PSFB__SLI_number_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_picture__id.RAW_encode(RTCP__PSFB__SLI_picture__id_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RTCP__PSFB__SLI_template::single_value_struct {
INTEGER_template field_first;
INTEGER_template field_number;
INTEGER_template field_picture__id;
};

void RTCP__PSFB__SLI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_first = ANY_VALUE;
single_value->field_number = ANY_VALUE;
single_value->field_picture__id = ANY_VALUE;
}
}
}

void RTCP__PSFB__SLI_template::copy_value(const RTCP__PSFB__SLI& other_value)
{
single_value = new single_value_struct;
if (other_value.first().is_bound()) {
  single_value->field_first = other_value.first();
} else {
  single_value->field_first.clean_up();
}
if (other_value.number().is_bound()) {
  single_value->field_number = other_value.number();
} else {
  single_value->field_number.clean_up();
}
if (other_value.picture__id().is_bound()) {
  single_value->field_picture__id = other_value.picture__id();
} else {
  single_value->field_picture__id.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__SLI_template::copy_template(const RTCP__PSFB__SLI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.first().get_selection()) {
single_value->field_first = other_value.first();
} else {
single_value->field_first.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.number().get_selection()) {
single_value->field_number = other_value.number();
} else {
single_value->field_number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.picture__id().get_selection()) {
single_value->field_picture__id = other_value.picture__id();
} else {
single_value->field_picture__id.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__SLI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__SLI_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__SLI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLI.");
break;
}
set_selection(other_value);
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template()
{
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(const RTCP__PSFB__SLI& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(const OPTIONAL<RTCP__PSFB__SLI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__SLI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_SLI from an unbound optional field.");
}
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(RTCP__PSFB__SLI_template* p_precondition, RTCP__PSFB__SLI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(Dynamic_Match_Interface<RTCP__PSFB__SLI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__SLI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__SLI_template::RTCP__PSFB__SLI_template(const RTCP__PSFB__SLI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__PSFB__SLI_template::~RTCP__PSFB__SLI_template()
{
clean_up();
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLI_template::operator=(const RTCP__PSFB__SLI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLI_template::operator=(const OPTIONAL<RTCP__PSFB__SLI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__SLI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_SLI.");
}
return *this;
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLI_template::operator=(const RTCP__PSFB__SLI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__PSFB__SLI_template::match(const RTCP__PSFB__SLI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.first().is_bound()) return FALSE;
if(!single_value->field_first.match(other_value.first(), legacy))return FALSE;
if(!other_value.number().is_bound()) return FALSE;
if(!single_value->field_number.match(other_value.number(), legacy))return FALSE;
if(!other_value.picture__id().is_bound()) return FALSE;
if(!single_value->field_picture__id.match(other_value.picture__id(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLI.");
}
return FALSE;
}

boolean RTCP__PSFB__SLI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_first.is_bound()
 || single_value->field_number.is_bound()
 || single_value->field_picture__id.is_bound();
}

boolean RTCP__PSFB__SLI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_first.is_value()
 && single_value->field_number.is_value()
 && single_value->field_picture__id.is_value();
}

void RTCP__PSFB__SLI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__SLI RTCP__PSFB__SLI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_SLI.");
RTCP__PSFB__SLI ret_val;
if (single_value->field_first.is_bound()) {
ret_val.first() = single_value->field_first.valueof();
}
if (single_value->field_number.is_bound()) {
ret_val.number() = single_value->field_number.valueof();
}
if (single_value->field_picture__id.is_bound()) {
ret_val.picture__id() = single_value->field_picture__id.valueof();
}
return ret_val;
}

void RTCP__PSFB__SLI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_PSFB_SLI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__SLI_template[list_length];
}

RTCP__PSFB__SLI_template& RTCP__PSFB__SLI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_SLI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_SLI.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__PSFB__SLI_template::first()
{
set_specific();
return single_value->field_first;
}

const INTEGER_template& RTCP__PSFB__SLI_template::first() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field first of a non-specific template of type @RTP_Types.RTCP_PSFB_SLI.");
return single_value->field_first;
}

INTEGER_template& RTCP__PSFB__SLI_template::number()
{
set_specific();
return single_value->field_number;
}

const INTEGER_template& RTCP__PSFB__SLI_template::number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field number of a non-specific template of type @RTP_Types.RTCP_PSFB_SLI.");
return single_value->field_number;
}

INTEGER_template& RTCP__PSFB__SLI_template::picture__id()
{
set_specific();
return single_value->field_picture__id;
}

const INTEGER_template& RTCP__PSFB__SLI_template::picture__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field picture_id of a non-specific template of type @RTP_Types.RTCP_PSFB_SLI.");
return single_value->field_picture__id;
}

int RTCP__PSFB__SLI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_SLI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLI.");
  }
  return 0;
}

void RTCP__PSFB__SLI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ first := ");
single_value->field_first.log();
TTCN_Logger::log_event_str(", number := ");
single_value->field_number.log();
TTCN_Logger::log_event_str(", picture_id := ");
single_value->field_picture__id.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__SLI_template::log_match(const RTCP__PSFB__SLI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_first.match(match_value.first(), legacy)){
TTCN_Logger::log_logmatch_info(".first");
single_value->field_first.log_match(match_value.first(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_number.match(match_value.number(), legacy)){
TTCN_Logger::log_logmatch_info(".number");
single_value->field_number.log_match(match_value.number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_picture__id.match(match_value.picture__id(), legacy)){
TTCN_Logger::log_logmatch_info(".picture_id");
single_value->field_picture__id.log_match(match_value.picture__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ first := ");
single_value->field_first.log_match(match_value.first(), legacy);
TTCN_Logger::log_event_str(", number := ");
single_value->field_number.log_match(match_value.number(), legacy);
TTCN_Logger::log_event_str(", picture_id := ");
single_value->field_picture__id.log_match(match_value.picture__id(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__SLI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (first().is_bound()) first().set_implicit_omit();
if (number().is_bound()) number().set_implicit_omit();
if (picture__id().is_bound()) picture__id().set_implicit_omit();
}

void RTCP__PSFB__SLI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_first.encode_text(text_buf);
single_value->field_number.encode_text(text_buf);
single_value->field_picture__id.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_SLI.");
}
}

void RTCP__PSFB__SLI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_first.decode_text(text_buf);
single_value->field_number.decode_text(text_buf);
single_value->field_picture__id.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__SLI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_PSFB_SLI.");
}
}

void RTCP__PSFB__SLI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__SLI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_PSFB_SLI has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) first().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) picture__id().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "first")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          first().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "picture_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          picture__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_SLI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__SLI_template* precondition = new RTCP__PSFB__SLI_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__SLI_template* implied_template = new RTCP__PSFB__SLI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__SLI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_PSFB_SLI");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__SLI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_first.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLI");
single_value->field_number.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLI");
single_value->field_picture__id.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_SLI");
}

boolean RTCP__PSFB__SLI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__SLI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RTCP__PSFB__RPSI::RTCP__PSFB__RPSI()
{
}

RTCP__PSFB__RPSI::RTCP__PSFB__RPSI(const INTEGER& par_pb,
    const INTEGER& par_payload__type,
    const OCTETSTRING& par_rpsi__string)
  :   field_pb(par_pb),
  field_payload__type(par_payload__type),
  field_rpsi__string(par_rpsi__string)
{
}

RTCP__PSFB__RPSI::RTCP__PSFB__RPSI(const RTCP__PSFB__RPSI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_RPSI.");
if (other_value.pb().is_bound()) field_pb = other_value.pb();
else field_pb.clean_up();
if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
else field_payload__type.clean_up();
if (other_value.rpsi__string().is_bound()) field_rpsi__string = other_value.rpsi__string();
else field_rpsi__string.clean_up();
}

void RTCP__PSFB__RPSI::clean_up()
{
field_pb.clean_up();
field_payload__type.clean_up();
field_rpsi__string.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__PSFB__RPSI::get_descriptor() const { return &RTCP__PSFB__RPSI_descr_; }
RTCP__PSFB__RPSI& RTCP__PSFB__RPSI::operator=(const RTCP__PSFB__RPSI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_RPSI.");
  if (other_value.pb().is_bound()) field_pb = other_value.pb();
  else field_pb.clean_up();
  if (other_value.payload__type().is_bound()) field_payload__type = other_value.payload__type();
  else field_payload__type.clean_up();
  if (other_value.rpsi__string().is_bound()) field_rpsi__string = other_value.rpsi__string();
  else field_rpsi__string.clean_up();
}
return *this;
}

boolean RTCP__PSFB__RPSI::operator==(const RTCP__PSFB__RPSI& other_value) const
{
return field_pb==other_value.field_pb
  && field_payload__type==other_value.field_payload__type
  && field_rpsi__string==other_value.field_rpsi__string;
}

boolean RTCP__PSFB__RPSI::is_bound() const
{
return (field_pb.is_bound())
  || (field_payload__type.is_bound())
  || (field_rpsi__string.is_bound());
}
boolean RTCP__PSFB__RPSI::is_value() const
{
return field_pb.is_value()
  && field_payload__type.is_value()
  && field_rpsi__string.is_value();
}
void RTCP__PSFB__RPSI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pb := ");
field_pb.log();
TTCN_Logger::log_event_str(", payload_type := ");
field_payload__type.log();
TTCN_Logger::log_event_str(", rpsi_string := ");
field_rpsi__string.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__PSFB__RPSI::set_implicit_omit()
{
if (pb().is_bound()) pb().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (rpsi__string().is_bound()) rpsi__string().set_implicit_omit();
}

void RTCP__PSFB__RPSI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_PSFB_RPSI has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pb().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rpsi__string().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rpsi_string")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rpsi__string().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_RPSI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_PSFB_RPSI");
  }
}

void RTCP__PSFB__RPSI::encode_text(Text_Buf& text_buf) const
{
field_pb.encode_text(text_buf);
field_payload__type.encode_text(text_buf);
field_rpsi__string.encode_text(text_buf);
}

void RTCP__PSFB__RPSI::decode_text(Text_Buf& text_buf)
{
field_pb.decode_text(text_buf);
field_payload__type.decode_text(text_buf);
field_rpsi__string.decode_text(text_buf);
}

void RTCP__PSFB__RPSI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__RPSI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__RPSI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::INT1_descr_.raw->forceomit);
  decoded_field_length = field_pb.RAW_decode(General__Types::INT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::INT1_descr_.raw->forceomit);
  decoded_field_length = field_payload__type.RAW_decode(General__Types::INT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_rpsi__string.RAW_decode(OCTETSTRING_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__PSFB__RPSI::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::INT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::INT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_pb.RAW_encode(General__Types::INT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_payload__type.RAW_encode(General__Types::INT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rpsi__string.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RTCP__PSFB__RPSI_template::single_value_struct {
INTEGER_template field_pb;
INTEGER_template field_payload__type;
OCTETSTRING_template field_rpsi__string;
};

void RTCP__PSFB__RPSI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pb = ANY_VALUE;
single_value->field_payload__type = ANY_VALUE;
single_value->field_rpsi__string = ANY_VALUE;
}
}
}

void RTCP__PSFB__RPSI_template::copy_value(const RTCP__PSFB__RPSI& other_value)
{
single_value = new single_value_struct;
if (other_value.pb().is_bound()) {
  single_value->field_pb = other_value.pb();
} else {
  single_value->field_pb.clean_up();
}
if (other_value.payload__type().is_bound()) {
  single_value->field_payload__type = other_value.payload__type();
} else {
  single_value->field_payload__type.clean_up();
}
if (other_value.rpsi__string().is_bound()) {
  single_value->field_rpsi__string = other_value.rpsi__string();
} else {
  single_value->field_rpsi__string.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__RPSI_template::copy_template(const RTCP__PSFB__RPSI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pb().get_selection()) {
single_value->field_pb = other_value.pb();
} else {
single_value->field_pb.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload__type().get_selection()) {
single_value->field_payload__type = other_value.payload__type();
} else {
single_value->field_payload__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rpsi__string().get_selection()) {
single_value->field_rpsi__string = other_value.rpsi__string();
} else {
single_value->field_rpsi__string.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__RPSI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__RPSI_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__RPSI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_RPSI.");
break;
}
set_selection(other_value);
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template()
{
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(const RTCP__PSFB__RPSI& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(const OPTIONAL<RTCP__PSFB__RPSI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__RPSI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_RPSI from an unbound optional field.");
}
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(RTCP__PSFB__RPSI_template* p_precondition, RTCP__PSFB__RPSI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(Dynamic_Match_Interface<RTCP__PSFB__RPSI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__RPSI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__RPSI_template::RTCP__PSFB__RPSI_template(const RTCP__PSFB__RPSI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__PSFB__RPSI_template::~RTCP__PSFB__RPSI_template()
{
clean_up();
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__RPSI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__RPSI_template::operator=(const RTCP__PSFB__RPSI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__RPSI_template::operator=(const OPTIONAL<RTCP__PSFB__RPSI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__RPSI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_RPSI.");
}
return *this;
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__RPSI_template::operator=(const RTCP__PSFB__RPSI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__PSFB__RPSI_template::match(const RTCP__PSFB__RPSI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pb().is_bound()) return FALSE;
if(!single_value->field_pb.match(other_value.pb(), legacy))return FALSE;
if(!other_value.payload__type().is_bound()) return FALSE;
if(!single_value->field_payload__type.match(other_value.payload__type(), legacy))return FALSE;
if(!other_value.rpsi__string().is_bound()) return FALSE;
if(!single_value->field_rpsi__string.match(other_value.rpsi__string(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_RPSI.");
}
return FALSE;
}

boolean RTCP__PSFB__RPSI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_pb.is_bound()
 || single_value->field_payload__type.is_bound()
 || single_value->field_rpsi__string.is_bound();
}

boolean RTCP__PSFB__RPSI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_pb.is_value()
 && single_value->field_payload__type.is_value()
 && single_value->field_rpsi__string.is_value();
}

void RTCP__PSFB__RPSI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__RPSI RTCP__PSFB__RPSI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_RPSI.");
RTCP__PSFB__RPSI ret_val;
if (single_value->field_pb.is_bound()) {
ret_val.pb() = single_value->field_pb.valueof();
}
if (single_value->field_payload__type.is_bound()) {
ret_val.payload__type() = single_value->field_payload__type.valueof();
}
if (single_value->field_rpsi__string.is_bound()) {
ret_val.rpsi__string() = single_value->field_rpsi__string.valueof();
}
return ret_val;
}

void RTCP__PSFB__RPSI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_PSFB_RPSI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__RPSI_template[list_length];
}

RTCP__PSFB__RPSI_template& RTCP__PSFB__RPSI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_RPSI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_RPSI.");
return value_list.list_value[list_index];
}

INTEGER_template& RTCP__PSFB__RPSI_template::pb()
{
set_specific();
return single_value->field_pb;
}

const INTEGER_template& RTCP__PSFB__RPSI_template::pb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pb of a non-specific template of type @RTP_Types.RTCP_PSFB_RPSI.");
return single_value->field_pb;
}

INTEGER_template& RTCP__PSFB__RPSI_template::payload__type()
{
set_specific();
return single_value->field_payload__type;
}

const INTEGER_template& RTCP__PSFB__RPSI_template::payload__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload_type of a non-specific template of type @RTP_Types.RTCP_PSFB_RPSI.");
return single_value->field_payload__type;
}

OCTETSTRING_template& RTCP__PSFB__RPSI_template::rpsi__string()
{
set_specific();
return single_value->field_rpsi__string;
}

const OCTETSTRING_template& RTCP__PSFB__RPSI_template::rpsi__string() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rpsi_string of a non-specific template of type @RTP_Types.RTCP_PSFB_RPSI.");
return single_value->field_rpsi__string;
}

int RTCP__PSFB__RPSI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_RPSI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_RPSI.");
  }
  return 0;
}

void RTCP__PSFB__RPSI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pb := ");
single_value->field_pb.log();
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log();
TTCN_Logger::log_event_str(", rpsi_string := ");
single_value->field_rpsi__string.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__RPSI_template::log_match(const RTCP__PSFB__RPSI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_pb.match(match_value.pb(), legacy)){
TTCN_Logger::log_logmatch_info(".pb");
single_value->field_pb.log_match(match_value.pb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload__type.match(match_value.payload__type(), legacy)){
TTCN_Logger::log_logmatch_info(".payload_type");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rpsi__string.match(match_value.rpsi__string(), legacy)){
TTCN_Logger::log_logmatch_info(".rpsi_string");
single_value->field_rpsi__string.log_match(match_value.rpsi__string(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pb := ");
single_value->field_pb.log_match(match_value.pb(), legacy);
TTCN_Logger::log_event_str(", payload_type := ");
single_value->field_payload__type.log_match(match_value.payload__type(), legacy);
TTCN_Logger::log_event_str(", rpsi_string := ");
single_value->field_rpsi__string.log_match(match_value.rpsi__string(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__RPSI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (pb().is_bound()) pb().set_implicit_omit();
if (payload__type().is_bound()) payload__type().set_implicit_omit();
if (rpsi__string().is_bound()) rpsi__string().set_implicit_omit();
}

void RTCP__PSFB__RPSI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pb.encode_text(text_buf);
single_value->field_payload__type.encode_text(text_buf);
single_value->field_rpsi__string.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_RPSI.");
}
}

void RTCP__PSFB__RPSI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pb.decode_text(text_buf);
single_value->field_payload__type.decode_text(text_buf);
single_value->field_rpsi__string.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__RPSI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_PSFB_RPSI.");
}
}

void RTCP__PSFB__RPSI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__RPSI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_PSFB_RPSI has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pb().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) payload__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rpsi__string().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rpsi_string")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rpsi__string().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_RPSI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__RPSI_template* precondition = new RTCP__PSFB__RPSI_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__RPSI_template* implied_template = new RTCP__PSFB__RPSI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__RPSI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_PSFB_RPSI");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__RPSI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pb.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_RPSI");
single_value->field_payload__type.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_RPSI");
single_value->field_rpsi__string.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_RPSI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_RPSI");
}

boolean RTCP__PSFB__RPSI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__RPSI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const RTCP__PSFB__FIR RTCP__PSFB__FIRs::UNBOUND_ELEM;
RTCP__PSFB__FIRs::RTCP__PSFB__FIRs()
{
val_ptr = NULL;
}

RTCP__PSFB__FIRs::RTCP__PSFB__FIRs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__PSFB__FIRs::RTCP__PSFB__FIRs(const RTCP__PSFB__FIRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__PSFB__FIRs::~RTCP__PSFB__FIRs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__PSFB__FIRs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__PSFB__FIRs& RTCP__PSFB__FIRs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__PSFB__FIRs& RTCP__PSFB__FIRs::operator=(const RTCP__PSFB__FIRs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__PSFB__FIRs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__PSFB__FIRs::operator==(const RTCP__PSFB__FIRs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__PSFB__FIR& RTCP__PSFB__FIRs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_FIRs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__FIR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__FIR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__PSFB__FIR;
}
return *val_ptr->value_elements[index_value];
}

RTCP__PSFB__FIR& RTCP__PSFB__FIRs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_FIRs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__FIR& RTCP__PSFB__FIRs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_FIRs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_PSFB_FIRs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__PSFB__FIR& RTCP__PSFB__FIRs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_FIRs.");
return (*this)[(int)index_value];
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__PSFB__FIRs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__PSFB__FIR(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::operator+(const RTCP__PSFB__FIRs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_PSFB_FIRs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__PSFB__FIRs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__FIR(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__PSFB__FIR(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_PSFB_FIRs","element");
RTCP__PSFB__FIRs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__FIR(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::replace(int index, int len, const RTCP__PSFB__FIRs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_PSFB_FIRs","element");
RTCP__PSFB__FIRs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__FIR(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__PSFB__FIR(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__PSFB__FIR(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs::replace(int index, int len, const RTCP__PSFB__FIRs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__PSFB__FIRs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_PSFB_FIRs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__FIR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__FIR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__PSFB__FIR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_PSFB_FIRs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__PSFB__FIR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__PSFB__FIRs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__PSFB__FIRs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
return val_ptr->n_elements;
}

int RTCP__PSFB__FIRs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__PSFB__FIRs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__PSFB__FIRs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__FIRs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_FIRs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_FIRs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__PSFB__FIRs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_PSFB_FIRs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__PSFB__FIRs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_PSFB_FIRs.");
val_ptr->value_elements = (RTCP__PSFB__FIR**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__PSFB__FIR;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__PSFB__FIRs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__FIRs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__FIRs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__PSFB__FIRs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__PSFB__FIRs_template::copy_value(const RTCP__PSFB__FIRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_PSFB_FIRs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__PSFB__FIR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__FIRs_template::copy_template(const RTCP__PSFB__FIRs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__PSFB__FIR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__FIRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__FIRs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__FIRs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIRs.");
break;
}
set_selection(other_value);
}

boolean RTCP__PSFB__FIRs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__PSFB__FIRs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__PSFB__FIRs*)value_ptr)[value_index], legacy);
else return ((const RTCP__PSFB__FIRs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template()
{
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(const RTCP__PSFB__FIRs& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(const OPTIONAL<RTCP__PSFB__FIRs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__FIRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_FIRs from an unbound optional field.");
}
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(RTCP__PSFB__FIRs_template* p_precondition, RTCP__PSFB__FIRs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(Dynamic_Match_Interface<RTCP__PSFB__FIRs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__FIRs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__FIRs_template::RTCP__PSFB__FIRs_template(const RTCP__PSFB__FIRs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__PSFB__FIRs_template::~RTCP__PSFB__FIRs_template()
{
clean_up();
}

void RTCP__PSFB__FIRs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::operator=(const RTCP__PSFB__FIRs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::operator=(const OPTIONAL<RTCP__PSFB__FIRs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__FIRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_FIRs.");
}
return *this;
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::operator=(const RTCP__PSFB__FIRs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIRs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_FIRs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_FIRs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIRs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_FIRs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__FIR_template& RTCP__PSFB__FIRs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_FIRs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_FIRs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_PSFB_FIRs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__PSFB__FIR_template& RTCP__PSFB__FIRs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_FIRs.");
return (*this)[(int)index_value];
}

void RTCP__PSFB__FIRs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_PSFB_FIRs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__PSFB__FIR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__PSFB__FIR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__PSFB__FIRs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__PSFB__FIRs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_FIRs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIRs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_PSFB_FIRs");
}

boolean RTCP__PSFB__FIRs_template::match(const RTCP__PSFB__FIRs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIRs.");
}
return FALSE;
}

boolean RTCP__PSFB__FIRs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_FIRs.");
RTCP__PSFB__FIRs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs_template::replace(int index, int len, const RTCP__PSFB__FIRs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__PSFB__FIRs RTCP__PSFB__FIRs_template::replace(int index, int len, const RTCP__PSFB__FIRs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__PSFB__FIRs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__FIRs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_PSFB_FIRs.");
}
set_selection(template_type);
}

RTCP__PSFB__FIRs_template& RTCP__PSFB__FIRs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_FIRs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_FIRs.");
return value_list.list_value[list_index];
}

void RTCP__PSFB__FIRs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__PSFB__FIRs_template::log_match(const RTCP__PSFB__FIRs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__FIRs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIRs.");
}
}

void RTCP__PSFB__FIRs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_PSFB_FIRs.");
single_value.value_elements = (RTCP__PSFB__FIR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__PSFB__FIR_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__FIRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_PSFB_FIRs.");
}
}

boolean RTCP__PSFB__FIRs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__FIRs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__PSFB__FIRs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__FIRs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__FIRs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__FIRs_template* precondition = new RTCP__PSFB__FIRs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__FIRs_template* implied_template = new RTCP__PSFB__FIRs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__FIRs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_PSFB_FIRs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__PSFB__FIRs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIRs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIRs");
}

boolean RTCP__PSFB__FIRs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
RTCP__PSFB__FIR::RTCP__PSFB__FIR()
{
}

RTCP__PSFB__FIR::RTCP__PSFB__FIR(const BITSTRING& par_SSRC,
    const INTEGER& par_seq__no,
    const OCTETSTRING& par_reserved)
  :   field_SSRC(par_SSRC),
  field_seq__no(par_seq__no),
  field_reserved(par_reserved)
{
}

RTCP__PSFB__FIR::RTCP__PSFB__FIR(const RTCP__PSFB__FIR& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_FIR.");
if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
else field_SSRC.clean_up();
if (other_value.seq__no().is_bound()) field_seq__no = other_value.seq__no();
else field_seq__no.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void RTCP__PSFB__FIR::clean_up()
{
field_SSRC.clean_up();
field_seq__no.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__PSFB__FIR::get_descriptor() const { return &RTCP__PSFB__FIR_descr_; }
RTCP__PSFB__FIR& RTCP__PSFB__FIR::operator=(const RTCP__PSFB__FIR& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_FIR.");
  if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
  else field_SSRC.clean_up();
  if (other_value.seq__no().is_bound()) field_seq__no = other_value.seq__no();
  else field_seq__no.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean RTCP__PSFB__FIR::operator==(const RTCP__PSFB__FIR& other_value) const
{
return field_SSRC==other_value.field_SSRC
  && field_seq__no==other_value.field_seq__no
  && field_reserved==other_value.field_reserved;
}

boolean RTCP__PSFB__FIR::is_bound() const
{
return (field_SSRC.is_bound())
  || (field_seq__no.is_bound())
  || (field_reserved.is_bound());
}
boolean RTCP__PSFB__FIR::is_value() const
{
return field_SSRC.is_value()
  && field_seq__no.is_value()
  && field_reserved.is_value();
}
void RTCP__PSFB__FIR::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ SSRC := ");
field_SSRC.log();
TTCN_Logger::log_event_str(", seq_no := ");
field_seq__no.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__PSFB__FIR::set_implicit_omit()
{
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (seq__no().is_bound()) seq__no().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void RTCP__PSFB__FIR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_PSFB_FIR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) seq__no().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_no")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__no().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_FIR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_PSFB_FIR");
  }
}

void RTCP__PSFB__FIR::encode_text(Text_Buf& text_buf) const
{
field_SSRC.encode_text(text_buf);
field_seq__no.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void RTCP__PSFB__FIR::decode_text(Text_Buf& text_buf)
{
field_SSRC.decode_text(text_buf);
field_seq__no.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void RTCP__PSFB__FIR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__FIR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__FIR::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT32__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_SSRC.RAW_decode(General__Types::BIT32__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::INT1_descr_.raw->forceomit);
  decoded_field_length = field_seq__no.RAW_decode(General__Types::INT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__PSFB__FIR::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT32__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::INT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT3_descr_.raw);
  encoded_length += field_SSRC.RAW_encode(General__Types::BIT32__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_seq__no.RAW_encode(General__Types::INT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_reserved.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RTCP__PSFB__FIR_template::single_value_struct {
BITSTRING_template field_SSRC;
INTEGER_template field_seq__no;
OCTETSTRING_template field_reserved;
};

void RTCP__PSFB__FIR_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_SSRC = ANY_VALUE;
single_value->field_seq__no = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void RTCP__PSFB__FIR_template::copy_value(const RTCP__PSFB__FIR& other_value)
{
single_value = new single_value_struct;
if (other_value.SSRC().is_bound()) {
  single_value->field_SSRC = other_value.SSRC();
} else {
  single_value->field_SSRC.clean_up();
}
if (other_value.seq__no().is_bound()) {
  single_value->field_seq__no = other_value.seq__no();
} else {
  single_value->field_seq__no.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__FIR_template::copy_template(const RTCP__PSFB__FIR_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.SSRC().get_selection()) {
single_value->field_SSRC = other_value.SSRC();
} else {
single_value->field_SSRC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.seq__no().get_selection()) {
single_value->field_seq__no = other_value.seq__no();
} else {
single_value->field_seq__no.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__FIR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__FIR_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__FIR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIR.");
break;
}
set_selection(other_value);
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template()
{
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(const RTCP__PSFB__FIR& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(const OPTIONAL<RTCP__PSFB__FIR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__FIR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_FIR from an unbound optional field.");
}
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(RTCP__PSFB__FIR_template* p_precondition, RTCP__PSFB__FIR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(Dynamic_Match_Interface<RTCP__PSFB__FIR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__FIR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__FIR_template::RTCP__PSFB__FIR_template(const RTCP__PSFB__FIR_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__PSFB__FIR_template::~RTCP__PSFB__FIR_template()
{
clean_up();
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIR_template::operator=(const RTCP__PSFB__FIR& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIR_template::operator=(const OPTIONAL<RTCP__PSFB__FIR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__FIR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_FIR.");
}
return *this;
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIR_template::operator=(const RTCP__PSFB__FIR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__PSFB__FIR_template::match(const RTCP__PSFB__FIR& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.SSRC().is_bound()) return FALSE;
if(!single_value->field_SSRC.match(other_value.SSRC(), legacy))return FALSE;
if(!other_value.seq__no().is_bound()) return FALSE;
if(!single_value->field_seq__no.match(other_value.seq__no(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIR.");
}
return FALSE;
}

boolean RTCP__PSFB__FIR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_SSRC.is_bound()
 || single_value->field_seq__no.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean RTCP__PSFB__FIR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_SSRC.is_value()
 && single_value->field_seq__no.is_value()
 && single_value->field_reserved.is_value();
}

void RTCP__PSFB__FIR_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__FIR RTCP__PSFB__FIR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_FIR.");
RTCP__PSFB__FIR ret_val;
if (single_value->field_SSRC.is_bound()) {
ret_val.SSRC() = single_value->field_SSRC.valueof();
}
if (single_value->field_seq__no.is_bound()) {
ret_val.seq__no() = single_value->field_seq__no.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void RTCP__PSFB__FIR_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_PSFB_FIR.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__FIR_template[list_length];
}

RTCP__PSFB__FIR_template& RTCP__PSFB__FIR_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_FIR.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_FIR.");
return value_list.list_value[list_index];
}

BITSTRING_template& RTCP__PSFB__FIR_template::SSRC()
{
set_specific();
return single_value->field_SSRC;
}

const BITSTRING_template& RTCP__PSFB__FIR_template::SSRC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC of a non-specific template of type @RTP_Types.RTCP_PSFB_FIR.");
return single_value->field_SSRC;
}

INTEGER_template& RTCP__PSFB__FIR_template::seq__no()
{
set_specific();
return single_value->field_seq__no;
}

const INTEGER_template& RTCP__PSFB__FIR_template::seq__no() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field seq_no of a non-specific template of type @RTP_Types.RTCP_PSFB_FIR.");
return single_value->field_seq__no;
}

OCTETSTRING_template& RTCP__PSFB__FIR_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const OCTETSTRING_template& RTCP__PSFB__FIR_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @RTP_Types.RTCP_PSFB_FIR.");
return single_value->field_reserved;
}

int RTCP__PSFB__FIR_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_FIR containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIR.");
  }
  return 0;
}

void RTCP__PSFB__FIR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log();
TTCN_Logger::log_event_str(", seq_no := ");
single_value->field_seq__no.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__FIR_template::log_match(const RTCP__PSFB__FIR& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_SSRC.match(match_value.SSRC(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_seq__no.match(match_value.seq__no(), legacy)){
TTCN_Logger::log_logmatch_info(".seq_no");
single_value->field_seq__no.log_match(match_value.seq__no(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::log_event_str(", seq_no := ");
single_value->field_seq__no.log_match(match_value.seq__no(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__FIR_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (seq__no().is_bound()) seq__no().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void RTCP__PSFB__FIR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_SSRC.encode_text(text_buf);
single_value->field_seq__no.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_FIR.");
}
}

void RTCP__PSFB__FIR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_SSRC.decode_text(text_buf);
single_value->field_seq__no.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__FIR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_PSFB_FIR.");
}
}

void RTCP__PSFB__FIR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__FIR_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_PSFB_FIR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) seq__no().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_no")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__no().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_FIR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__FIR_template* precondition = new RTCP__PSFB__FIR_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__FIR_template* implied_template = new RTCP__PSFB__FIR_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__FIR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_PSFB_FIR");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__FIR_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_SSRC.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIR");
single_value->field_seq__no.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIR");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIR");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_FIR");
}

boolean RTCP__PSFB__FIR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__FIR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const RTCP__PSFB__TST RTCP__PSFB__TSTRs::UNBOUND_ELEM;
RTCP__PSFB__TSTRs::RTCP__PSFB__TSTRs()
{
val_ptr = NULL;
}

RTCP__PSFB__TSTRs::RTCP__PSFB__TSTRs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

RTCP__PSFB__TSTRs::RTCP__PSFB__TSTRs(const RTCP__PSFB__TSTRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

RTCP__PSFB__TSTRs::~RTCP__PSFB__TSTRs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void RTCP__PSFB__TSTRs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

RTCP__PSFB__TSTRs& RTCP__PSFB__TSTRs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

RTCP__PSFB__TSTRs& RTCP__PSFB__TSTRs::operator=(const RTCP__PSFB__TSTRs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean RTCP__PSFB__TSTRs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
return val_ptr->n_elements == 0 ;
}

boolean RTCP__PSFB__TSTRs::operator==(const RTCP__PSFB__TSTRs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

RTCP__PSFB__TST& RTCP__PSFB__TSTRs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_TSTRs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__TST**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__TST(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new RTCP__PSFB__TST;
}
return *val_ptr->value_elements[index_value];
}

RTCP__PSFB__TST& RTCP__PSFB__TSTRs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_TSTRs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__TST& RTCP__PSFB__TSTRs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (index_value < 0) TTCN_error("Accessing an element of type @RTP_Types.RTCP_PSFB_TSTRs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RTP_Types.RTCP_PSFB_TSTRs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const RTCP__PSFB__TST& RTCP__PSFB__TSTRs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RTP_Types.RTCP_PSFB_TSTRs.");
return (*this)[(int)index_value];
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
RTCP__PSFB__TSTRs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new RTCP__PSFB__TST(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::operator+(const RTCP__PSFB__TSTRs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RTP_Types.RTCP_PSFB_TSTRs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
RTCP__PSFB__TSTRs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__TST(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new RTCP__PSFB__TST(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RTP_Types.RTCP_PSFB_TSTRs","element");
RTCP__PSFB__TSTRs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__TST(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::replace(int index, int len, const RTCP__PSFB__TSTRs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RTP_Types.RTCP_PSFB_TSTRs","element");
RTCP__PSFB__TSTRs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new RTCP__PSFB__TST(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new RTCP__PSFB__TST(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new RTCP__PSFB__TST(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs::replace(int index, int len, const RTCP__PSFB__TSTRs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void RTCP__PSFB__TSTRs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (RTCP__PSFB__TST**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new RTCP__PSFB__TST(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (RTCP__PSFB__TST**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RTP_Types.RTCP_PSFB_TSTRs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (RTCP__PSFB__TST**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean RTCP__PSFB__TSTRs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int RTCP__PSFB__TSTRs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
return val_ptr->n_elements;
}

int RTCP__PSFB__TSTRs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void RTCP__PSFB__TSTRs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void RTCP__PSFB__TSTRs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__TSTRs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_TSTRs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RTP_Types.RTCP_PSFB_TSTRs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void RTCP__PSFB__TSTRs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RTP_Types.RTCP_PSFB_TSTRs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void RTCP__PSFB__TSTRs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RTP_Types.RTCP_PSFB_TSTRs.");
val_ptr->value_elements = (RTCP__PSFB__TST**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new RTCP__PSFB__TST;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void RTCP__PSFB__TSTRs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__TSTRs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__TSTRs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int RTCP__PSFB__TSTRs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void RTCP__PSFB__TSTRs_template::copy_value(const RTCP__PSFB__TSTRs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RTP_Types.RTCP_PSFB_TSTRs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (RTCP__PSFB__TST_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__TSTRs_template::copy_template(const RTCP__PSFB__TSTRs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (RTCP__PSFB__TST_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__TSTRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__TSTRs_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__TSTRs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TSTRs.");
break;
}
set_selection(other_value);
}

boolean RTCP__PSFB__TSTRs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const RTCP__PSFB__TSTRs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const RTCP__PSFB__TSTRs*)value_ptr)[value_index], legacy);
else return ((const RTCP__PSFB__TSTRs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template()
{
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(const RTCP__PSFB__TSTRs& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(const OPTIONAL<RTCP__PSFB__TSTRs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__TSTRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_TSTRs from an unbound optional field.");
}
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(RTCP__PSFB__TSTRs_template* p_precondition, RTCP__PSFB__TSTRs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(Dynamic_Match_Interface<RTCP__PSFB__TSTRs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__TSTRs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__TSTRs_template::RTCP__PSFB__TSTRs_template(const RTCP__PSFB__TSTRs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

RTCP__PSFB__TSTRs_template::~RTCP__PSFB__TSTRs_template()
{
clean_up();
}

void RTCP__PSFB__TSTRs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::operator=(const RTCP__PSFB__TSTRs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::operator=(const OPTIONAL<RTCP__PSFB__TSTRs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__TSTRs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
}
return *this;
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::operator=(const RTCP__PSFB__TSTRs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

RTCP__PSFB__TST_template& RTCP__PSFB__TSTRs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_TSTRs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_TSTRs.");
    break;
}
return *single_value.value_elements[index_value];
}

RTCP__PSFB__TST_template& RTCP__PSFB__TSTRs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
return (*this)[(int)index_value];
}

const RTCP__PSFB__TST_template& RTCP__PSFB__TSTRs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RTP_Types.RTCP_PSFB_TSTRs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RTP_Types.RTCP_PSFB_TSTRs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RTP_Types.RTCP_PSFB_TSTRs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const RTCP__PSFB__TST_template& RTCP__PSFB__TSTRs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
return (*this)[(int)index_value];
}

void RTCP__PSFB__TSTRs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (RTCP__PSFB__TST_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (RTCP__PSFB__TST_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int RTCP__PSFB__TSTRs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int RTCP__PSFB__TSTRs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RTP_Types.RTCP_PSFB_TSTRs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TSTRs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RTP_Types.RTCP_PSFB_TSTRs");
}

boolean RTCP__PSFB__TSTRs_template::match(const RTCP__PSFB__TSTRs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TSTRs.");
}
return FALSE;
}

boolean RTCP__PSFB__TSTRs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_TSTRs.");
RTCP__PSFB__TSTRs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs_template::replace(int index, int len, const RTCP__PSFB__TSTRs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

RTCP__PSFB__TSTRs RTCP__PSFB__TSTRs_template::replace(int index, int len, const RTCP__PSFB__TSTRs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void RTCP__PSFB__TSTRs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__TSTRs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
}
set_selection(template_type);
}

RTCP__PSFB__TSTRs_template& RTCP__PSFB__TSTRs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_TSTRs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_TSTRs.");
return value_list.list_value[list_index];
}

void RTCP__PSFB__TSTRs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void RTCP__PSFB__TSTRs_template::log_match(const RTCP__PSFB__TSTRs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__TSTRs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TSTRs.");
}
}

void RTCP__PSFB__TSTRs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
single_value.value_elements = (RTCP__PSFB__TST_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new RTCP__PSFB__TST_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__TSTRs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RTP_Types.RTCP_PSFB_TSTRs.");
}
}

boolean RTCP__PSFB__TSTRs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__TSTRs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RTCP__PSFB__TSTRs_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void RTCP__PSFB__TSTRs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__TSTRs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__TSTRs_template* precondition = new RTCP__PSFB__TSTRs_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__TSTRs_template* implied_template = new RTCP__PSFB__TSTRs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__TSTRs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RTP_Types.RTCP_PSFB_TSTRs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void RTCP__PSFB__TSTRs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_TSTRs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_TSTRs");
}

boolean RTCP__PSFB__TSTRs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
RTCP__PSFB__TST::RTCP__PSFB__TST()
{
}

RTCP__PSFB__TST::RTCP__PSFB__TST(const BITSTRING& par_SSRC,
    const INTEGER& par_seq__no,
    const OCTETSTRING& par_reserved,
    const INTEGER& par_index)
  :   field_SSRC(par_SSRC),
  field_seq__no(par_seq__no),
  field_reserved(par_reserved),
  field_index(par_index)
{
}

RTCP__PSFB__TST::RTCP__PSFB__TST(const RTCP__PSFB__TST& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RTP_Types.RTCP_PSFB_TST.");
if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
else field_SSRC.clean_up();
if (other_value.seq__no().is_bound()) field_seq__no = other_value.seq__no();
else field_seq__no.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.index().is_bound()) field_index = other_value.index();
else field_index.clean_up();
}

void RTCP__PSFB__TST::clean_up()
{
field_SSRC.clean_up();
field_seq__no.clean_up();
field_reserved.clean_up();
field_index.clean_up();
}

const TTCN_Typedescriptor_t* RTCP__PSFB__TST::get_descriptor() const { return &RTCP__PSFB__TST_descr_; }
RTCP__PSFB__TST& RTCP__PSFB__TST::operator=(const RTCP__PSFB__TST& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RTP_Types.RTCP_PSFB_TST.");
  if (other_value.SSRC().is_bound()) field_SSRC = other_value.SSRC();
  else field_SSRC.clean_up();
  if (other_value.seq__no().is_bound()) field_seq__no = other_value.seq__no();
  else field_seq__no.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.index().is_bound()) field_index = other_value.index();
  else field_index.clean_up();
}
return *this;
}

boolean RTCP__PSFB__TST::operator==(const RTCP__PSFB__TST& other_value) const
{
return field_SSRC==other_value.field_SSRC
  && field_seq__no==other_value.field_seq__no
  && field_reserved==other_value.field_reserved
  && field_index==other_value.field_index;
}

boolean RTCP__PSFB__TST::is_bound() const
{
return (field_SSRC.is_bound())
  || (field_seq__no.is_bound())
  || (field_reserved.is_bound())
  || (field_index.is_bound());
}
boolean RTCP__PSFB__TST::is_value() const
{
return field_SSRC.is_value()
  && field_seq__no.is_value()
  && field_reserved.is_value()
  && field_index.is_value();
}
void RTCP__PSFB__TST::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ SSRC := ");
field_SSRC.log();
TTCN_Logger::log_event_str(", seq_no := ");
field_seq__no.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", index := ");
field_index.log();
TTCN_Logger::log_event_str(" }");
}

void RTCP__PSFB__TST::set_implicit_omit()
{
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (seq__no().is_bound()) seq__no().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (index().is_bound()) index().set_implicit_omit();
}

void RTCP__PSFB__TST::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RTP_Types.RTCP_PSFB_TST has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) seq__no().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) index().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_no")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__no().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_TST: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RTP_Types.RTCP_PSFB_TST");
  }
}

void RTCP__PSFB__TST::encode_text(Text_Buf& text_buf) const
{
field_SSRC.encode_text(text_buf);
field_seq__no.encode_text(text_buf);
field_reserved.encode_text(text_buf);
field_index.encode_text(text_buf);
}

void RTCP__PSFB__TST::decode_text(Text_Buf& text_buf)
{
field_SSRC.decode_text(text_buf);
field_seq__no.decode_text(text_buf);
field_reserved.decode_text(text_buf);
field_index.decode_text(text_buf);
}

void RTCP__PSFB__TST::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RTCP__PSFB__TST::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RTCP__PSFB__TST::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT32__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_SSRC.RAW_decode(General__Types::BIT32__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RTCP__PSFB__TST_seq__no_descr_.raw->forceomit);
  decoded_field_length = field_seq__no.RAW_decode(RTCP__PSFB__TST_seq__no_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, INTEGER_descr_.raw->forceomit);
  decoded_field_length = field_index.RAW_decode(INTEGER_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RTCP__PSFB__TST::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT32__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RTCP__PSFB__TST_seq__no_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, INTEGER_descr_.raw);
  encoded_length += field_SSRC.RAW_encode(General__Types::BIT32__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_seq__no.RAW_encode(RTCP__PSFB__TST_seq__no_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_reserved.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_index.RAW_encode(INTEGER_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct RTCP__PSFB__TST_template::single_value_struct {
BITSTRING_template field_SSRC;
INTEGER_template field_seq__no;
OCTETSTRING_template field_reserved;
INTEGER_template field_index;
};

void RTCP__PSFB__TST_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_SSRC = ANY_VALUE;
single_value->field_seq__no = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
single_value->field_index = ANY_VALUE;
}
}
}

void RTCP__PSFB__TST_template::copy_value(const RTCP__PSFB__TST& other_value)
{
single_value = new single_value_struct;
if (other_value.SSRC().is_bound()) {
  single_value->field_SSRC = other_value.SSRC();
} else {
  single_value->field_SSRC.clean_up();
}
if (other_value.seq__no().is_bound()) {
  single_value->field_seq__no = other_value.seq__no();
} else {
  single_value->field_seq__no.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.index().is_bound()) {
  single_value->field_index = other_value.index();
} else {
  single_value->field_index.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RTCP__PSFB__TST_template::copy_template(const RTCP__PSFB__TST_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.SSRC().get_selection()) {
single_value->field_SSRC = other_value.SSRC();
} else {
single_value->field_SSRC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.seq__no().get_selection()) {
single_value->field_seq__no = other_value.seq__no();
} else {
single_value->field_seq__no.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.index().get_selection()) {
single_value->field_index = other_value.index();
} else {
single_value->field_index.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RTCP__PSFB__TST_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RTCP__PSFB__TST_template(*other_value.implication_.precondition);
implication_.implied_template = new RTCP__PSFB__TST_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TST.");
break;
}
set_selection(other_value);
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template()
{
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(const RTCP__PSFB__TST& other_value)
{
copy_value(other_value);
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(const OPTIONAL<RTCP__PSFB__TST>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__TST&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RTP_Types.RTCP_PSFB_TST from an unbound optional field.");
}
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(RTCP__PSFB__TST_template* p_precondition, RTCP__PSFB__TST_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(Dynamic_Match_Interface<RTCP__PSFB__TST>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RTCP__PSFB__TST>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RTCP__PSFB__TST_template::RTCP__PSFB__TST_template(const RTCP__PSFB__TST_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RTCP__PSFB__TST_template::~RTCP__PSFB__TST_template()
{
clean_up();
}

RTCP__PSFB__TST_template& RTCP__PSFB__TST_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RTCP__PSFB__TST_template& RTCP__PSFB__TST_template::operator=(const RTCP__PSFB__TST& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RTCP__PSFB__TST_template& RTCP__PSFB__TST_template::operator=(const OPTIONAL<RTCP__PSFB__TST>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RTCP__PSFB__TST&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RTP_Types.RTCP_PSFB_TST.");
}
return *this;
}

RTCP__PSFB__TST_template& RTCP__PSFB__TST_template::operator=(const RTCP__PSFB__TST_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RTCP__PSFB__TST_template::match(const RTCP__PSFB__TST& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.SSRC().is_bound()) return FALSE;
if(!single_value->field_SSRC.match(other_value.SSRC(), legacy))return FALSE;
if(!other_value.seq__no().is_bound()) return FALSE;
if(!single_value->field_seq__no.match(other_value.seq__no(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.index().is_bound()) return FALSE;
if(!single_value->field_index.match(other_value.index(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TST.");
}
return FALSE;
}

boolean RTCP__PSFB__TST_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_SSRC.is_bound()
 || single_value->field_seq__no.is_bound()
 || single_value->field_reserved.is_bound()
 || single_value->field_index.is_bound();
}

boolean RTCP__PSFB__TST_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_SSRC.is_value()
 && single_value->field_seq__no.is_value()
 && single_value->field_reserved.is_value()
 && single_value->field_index.is_value();
}

void RTCP__PSFB__TST_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RTCP__PSFB__TST RTCP__PSFB__TST_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RTP_Types.RTCP_PSFB_TST.");
RTCP__PSFB__TST ret_val;
if (single_value->field_SSRC.is_bound()) {
ret_val.SSRC() = single_value->field_SSRC.valueof();
}
if (single_value->field_seq__no.is_bound()) {
ret_val.seq__no() = single_value->field_seq__no.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_index.is_bound()) {
ret_val.index() = single_value->field_index.valueof();
}
return ret_val;
}

void RTCP__PSFB__TST_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RTP_Types.RTCP_PSFB_TST.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RTCP__PSFB__TST_template[list_length];
}

RTCP__PSFB__TST_template& RTCP__PSFB__TST_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RTP_Types.RTCP_PSFB_TST.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RTP_Types.RTCP_PSFB_TST.");
return value_list.list_value[list_index];
}

BITSTRING_template& RTCP__PSFB__TST_template::SSRC()
{
set_specific();
return single_value->field_SSRC;
}

const BITSTRING_template& RTCP__PSFB__TST_template::SSRC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field SSRC of a non-specific template of type @RTP_Types.RTCP_PSFB_TST.");
return single_value->field_SSRC;
}

INTEGER_template& RTCP__PSFB__TST_template::seq__no()
{
set_specific();
return single_value->field_seq__no;
}

const INTEGER_template& RTCP__PSFB__TST_template::seq__no() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field seq_no of a non-specific template of type @RTP_Types.RTCP_PSFB_TST.");
return single_value->field_seq__no;
}

OCTETSTRING_template& RTCP__PSFB__TST_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const OCTETSTRING_template& RTCP__PSFB__TST_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @RTP_Types.RTCP_PSFB_TST.");
return single_value->field_reserved;
}

INTEGER_template& RTCP__PSFB__TST_template::index()
{
set_specific();
return single_value->field_index;
}

const INTEGER_template& RTCP__PSFB__TST_template::index() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field index of a non-specific template of type @RTP_Types.RTCP_PSFB_TST.");
return single_value->field_index;
}

int RTCP__PSFB__TST_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RTP_Types.RTCP_PSFB_TST containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TST.");
  }
  return 0;
}

void RTCP__PSFB__TST_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log();
TTCN_Logger::log_event_str(", seq_no := ");
single_value->field_seq__no.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", index := ");
single_value->field_index.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RTCP__PSFB__TST_template::log_match(const RTCP__PSFB__TST& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_SSRC.match(match_value.SSRC(), legacy)){
TTCN_Logger::log_logmatch_info(".SSRC");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_seq__no.match(match_value.seq__no(), legacy)){
TTCN_Logger::log_logmatch_info(".seq_no");
single_value->field_seq__no.log_match(match_value.seq__no(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_index.match(match_value.index(), legacy)){
TTCN_Logger::log_logmatch_info(".index");
single_value->field_index.log_match(match_value.index(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ SSRC := ");
single_value->field_SSRC.log_match(match_value.SSRC(), legacy);
TTCN_Logger::log_event_str(", seq_no := ");
single_value->field_seq__no.log_match(match_value.seq__no(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", index := ");
single_value->field_index.log_match(match_value.index(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RTCP__PSFB__TST_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (SSRC().is_bound()) SSRC().set_implicit_omit();
if (seq__no().is_bound()) seq__no().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (index().is_bound()) index().set_implicit_omit();
}

void RTCP__PSFB__TST_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_SSRC.encode_text(text_buf);
single_value->field_seq__no.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
single_value->field_index.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RTP_Types.RTCP_PSFB_TST.");
}
}

void RTCP__PSFB__TST_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_SSRC.decode_text(text_buf);
single_value->field_seq__no.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
single_value->field_index.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RTCP__PSFB__TST_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RTP_Types.RTCP_PSFB_TST.");
}
}

void RTCP__PSFB__TST_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RTCP__PSFB__TST_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RTP_Types.RTCP_PSFB_TST has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) SSRC().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) seq__no().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) index().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "SSRC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          SSRC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_no")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__no().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RTP_Types.RTCP_PSFB_TST: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RTCP__PSFB__TST_template* precondition = new RTCP__PSFB__TST_template;
    precondition->set_param(*param.get_elem(0));
    RTCP__PSFB__TST_template* implied_template = new RTCP__PSFB__TST_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RTCP__PSFB__TST_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RTP_Types.RTCP_PSFB_TST");
  }
  is_ifpresent = param.get_ifpresent();
}

void RTCP__PSFB__TST_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_SSRC.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_TST");
single_value->field_seq__no.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_TST");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_TST");
single_value->field_index.check_restriction(t_res, t_name ? t_name : "@RTP_Types.RTCP_PSFB_TST");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RTP_Types.RTCP_PSFB_TST");
}

boolean RTCP__PSFB__TST_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RTCP__PSFB__TST_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
