// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "SDP_Types.hh"

namespace SDP__Types {

/* Member functions of C++ classes */

SDP__attribute__unknown::SDP__attribute__unknown()
{
}

SDP__attribute__unknown::SDP__attribute__unknown(const CHARSTRING& par_name,
    const OPTIONAL< CHARSTRING >& par_attr__value)
  :   field_name(par_name),
  field_attr__value(par_attr__value)
{
}

SDP__attribute__unknown::SDP__attribute__unknown(const SDP__attribute__unknown& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_unknown.");
if (other_value.name().is_bound()) field_name = other_value.name();
else field_name.clean_up();
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__unknown::clean_up()
{
field_name.clean_up();
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__unknown::get_descriptor() const { return &SDP__attribute__unknown_descr_; }
SDP__attribute__unknown& SDP__attribute__unknown::operator=(const SDP__attribute__unknown& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_unknown.");
  if (other_value.name().is_bound()) field_name = other_value.name();
  else field_name.clean_up();
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__unknown::operator==(const SDP__attribute__unknown& other_value) const
{
return field_name==other_value.field_name
  && field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__unknown::is_bound() const
{
return (field_name.is_bound())
  || (OPTIONAL_OMIT == field_attr__value.get_selection() || field_attr__value.is_bound());
}
boolean SDP__attribute__unknown::is_value() const
{
return field_name.is_value()
  && (OPTIONAL_OMIT == field_attr__value.get_selection() || field_attr__value.is_value());
}
int SDP__attribute__unknown::size_of() const
{
  int ret_val = 1;
  if (field_attr__value.ispresent()) ret_val++;
  return ret_val;
}

void SDP__attribute__unknown::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ name := ");
field_name.log();
TTCN_Logger::log_event_str(", attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__unknown::set_implicit_omit()
{
if (name().is_bound()) name().set_implicit_omit();
if (!attr__value().is_bound()) attr__value() = OMIT_VALUE;
else attr__value().set_implicit_omit();
}

void SDP__attribute__unknown::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_unknown has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) name().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_unknown: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_unknown");
  }
}

void SDP__attribute__unknown::encode_text(Text_Buf& text_buf) const
{
field_name.encode_text(text_buf);
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__unknown::decode_text(Text_Buf& text_buf)
{
field_name.decode_text(text_buf);
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__unknown::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__unknown::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__unknown::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_name.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(field_attr__value.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value().TEXT_encode(SDP__attribute__unknown_attr__value_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__unknown::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_attr__value=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_name.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'name' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_attr__value().TEXT_decode(SDP__attribute__unknown_attr__value_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_attr__value=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__unknown_template::single_value_struct {
CHARSTRING_template field_name;
CHARSTRING_template field_attr__value;
};

void SDP__attribute__unknown_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_name = ANY_VALUE;
single_value->field_attr__value = ANY_OR_OMIT;
}
}
}

void SDP__attribute__unknown_template::copy_value(const SDP__attribute__unknown& other_value)
{
single_value = new single_value_struct;
if (other_value.name().is_bound()) {
  single_value->field_name = other_value.name();
} else {
  single_value->field_name.clean_up();
}
if (other_value.attr__value().is_bound()) {
  if (other_value.attr__value().ispresent()) single_value->field_attr__value = other_value.attr__value()();
  else single_value->field_attr__value = OMIT_VALUE;
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__unknown_template::copy_template(const SDP__attribute__unknown_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.name().get_selection()) {
single_value->field_name = other_value.name();
} else {
single_value->field_name.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__unknown_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__unknown_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__unknown_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_unknown.");
break;
}
set_selection(other_value);
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template()
{
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(const SDP__attribute__unknown& other_value)
{
copy_value(other_value);
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(const OPTIONAL<SDP__attribute__unknown>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__unknown&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_unknown from an unbound optional field.");
}
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(SDP__attribute__unknown_template* p_precondition, SDP__attribute__unknown_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(Dynamic_Match_Interface<SDP__attribute__unknown>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__unknown>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__unknown_template::SDP__attribute__unknown_template(const SDP__attribute__unknown_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__unknown_template::~SDP__attribute__unknown_template()
{
clean_up();
}

SDP__attribute__unknown_template& SDP__attribute__unknown_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__unknown_template& SDP__attribute__unknown_template::operator=(const SDP__attribute__unknown& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__unknown_template& SDP__attribute__unknown_template::operator=(const OPTIONAL<SDP__attribute__unknown>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__unknown&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_unknown.");
}
return *this;
}

SDP__attribute__unknown_template& SDP__attribute__unknown_template::operator=(const SDP__attribute__unknown_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__unknown_template::match(const SDP__attribute__unknown& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.name().is_bound()) return FALSE;
if(!single_value->field_name.match(other_value.name(), legacy))return FALSE;
if(!other_value.attr__value().is_bound()) return FALSE;
if((other_value.attr__value().ispresent() ? !single_value->field_attr__value.match((const CHARSTRING&)other_value.attr__value(), legacy) : !single_value->field_attr__value.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_unknown.");
}
return FALSE;
}

boolean SDP__attribute__unknown_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_name.is_bound()
 || (single_value->field_attr__value.is_omit() || single_value->field_attr__value.is_bound());
}

boolean SDP__attribute__unknown_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_name.is_value()
 && (single_value->field_attr__value.is_omit() || single_value->field_attr__value.is_value());
}

void SDP__attribute__unknown_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__unknown SDP__attribute__unknown_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_unknown.");
SDP__attribute__unknown ret_val;
if (single_value->field_name.is_bound()) {
ret_val.name() = single_value->field_name.valueof();
}
if (single_value->field_attr__value.is_omit()) ret_val.attr__value() = OMIT_VALUE;
else if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__unknown_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_unknown.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__unknown_template[list_length];
}

SDP__attribute__unknown_template& SDP__attribute__unknown_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_unknown.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_unknown.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__unknown_template::name()
{
set_specific();
return single_value->field_name;
}

const CHARSTRING_template& SDP__attribute__unknown_template::name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field name of a non-specific template of type @SDP_Types.SDP_attribute_unknown.");
return single_value->field_name;
}

CHARSTRING_template& SDP__attribute__unknown_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__unknown_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_unknown.");
return single_value->field_attr__value;
}

int SDP__attribute__unknown_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_attr__value.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_unknown containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_unknown.");
  }
  return 0;
}

void SDP__attribute__unknown_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ name := ");
single_value->field_name.log();
TTCN_Logger::log_event_str(", attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__unknown_template::log_match(const SDP__attribute__unknown& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_name.match(match_value.name(), legacy)){
TTCN_Logger::log_logmatch_info(".name");
single_value->field_name.log_match(match_value.name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.attr__value().ispresent()){
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_attr__value.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".attr_value := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ name := ");
single_value->field_name.log_match(match_value.name(), legacy);
TTCN_Logger::log_event_str(", attr_value := ");
if (match_value.attr__value().ispresent()) {
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_attr__value.log();
if (single_value->field_attr__value.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__unknown_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (name().is_bound()) name().set_implicit_omit();
if (!attr__value().is_bound()) attr__value() = OMIT_VALUE;
else attr__value().set_implicit_omit();
}

void SDP__attribute__unknown_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_name.encode_text(text_buf);
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_unknown.");
}
}

void SDP__attribute__unknown_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_name.decode_text(text_buf);
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__unknown_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_unknown.");
}
}

void SDP__attribute__unknown_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__unknown_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_unknown has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) name().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_unknown: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__unknown_template* precondition = new SDP__attribute__unknown_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__unknown_template* implied_template = new SDP__attribute__unknown_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__unknown_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_unknown");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__unknown_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_name.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_unknown");
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_unknown");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_unknown");
}

boolean SDP__attribute__unknown_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__unknown_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__file__selector::SDP__attribute__file__selector()
{
}

SDP__attribute__file__selector::SDP__attribute__file__selector(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__file__selector::SDP__attribute__file__selector(const SDP__attribute__file__selector& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_file_selector.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__file__selector::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__file__selector::get_descriptor() const { return &SDP__attribute__file__selector_descr_; }
SDP__attribute__file__selector& SDP__attribute__file__selector::operator=(const SDP__attribute__file__selector& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_file_selector.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__file__selector::operator==(const SDP__attribute__file__selector& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__file__selector::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__file__selector::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__file__selector::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__file__selector::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__file__selector::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_file_selector has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_file_selector: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_file_selector");
  }
}

void SDP__attribute__file__selector::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__file__selector::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__file__selector::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__file__selector::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__file__selector::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__file__selector::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__file__selector_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__file__selector_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__file__selector_template::copy_value(const SDP__attribute__file__selector& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__file__selector_template::copy_template(const SDP__attribute__file__selector_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__file__selector_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__file__selector_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__file__selector_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_selector.");
break;
}
set_selection(other_value);
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template()
{
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(const SDP__attribute__file__selector& other_value)
{
copy_value(other_value);
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(const OPTIONAL<SDP__attribute__file__selector>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__file__selector&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_file_selector from an unbound optional field.");
}
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(SDP__attribute__file__selector_template* p_precondition, SDP__attribute__file__selector_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(Dynamic_Match_Interface<SDP__attribute__file__selector>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__file__selector>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__file__selector_template::SDP__attribute__file__selector_template(const SDP__attribute__file__selector_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__file__selector_template::~SDP__attribute__file__selector_template()
{
clean_up();
}

SDP__attribute__file__selector_template& SDP__attribute__file__selector_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__file__selector_template& SDP__attribute__file__selector_template::operator=(const SDP__attribute__file__selector& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__file__selector_template& SDP__attribute__file__selector_template::operator=(const OPTIONAL<SDP__attribute__file__selector>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__file__selector&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_file_selector.");
}
return *this;
}

SDP__attribute__file__selector_template& SDP__attribute__file__selector_template::operator=(const SDP__attribute__file__selector_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__file__selector_template::match(const SDP__attribute__file__selector& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_selector.");
}
return FALSE;
}

boolean SDP__attribute__file__selector_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__file__selector_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__file__selector_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__file__selector SDP__attribute__file__selector_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_file_selector.");
SDP__attribute__file__selector ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__file__selector_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_file_selector.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__file__selector_template[list_length];
}

SDP__attribute__file__selector_template& SDP__attribute__file__selector_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_file_selector.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_file_selector.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__file__selector_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__file__selector_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_file_selector.");
return single_value->field_attr__value;
}

int SDP__attribute__file__selector_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_selector containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_selector.");
  }
  return 0;
}

void SDP__attribute__file__selector_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__file__selector_template::log_match(const SDP__attribute__file__selector& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__file__selector_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__file__selector_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_selector.");
}
}

void SDP__attribute__file__selector_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__file__selector_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_file_selector.");
}
}

void SDP__attribute__file__selector_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__file__selector_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_file_selector has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_file_selector: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__file__selector_template* precondition = new SDP__attribute__file__selector_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__file__selector_template* implied_template = new SDP__attribute__file__selector_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__file__selector_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_file_selector");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__file__selector_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_file_selector");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_file_selector");
}

boolean SDP__attribute__file__selector_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__file__selector_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__file__transfer__id::SDP__attribute__file__transfer__id()
{
}

SDP__attribute__file__transfer__id::SDP__attribute__file__transfer__id(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__file__transfer__id::SDP__attribute__file__transfer__id(const SDP__attribute__file__transfer__id& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_file_transfer_id.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__file__transfer__id::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__file__transfer__id::get_descriptor() const { return &SDP__attribute__file__transfer__id_descr_; }
SDP__attribute__file__transfer__id& SDP__attribute__file__transfer__id::operator=(const SDP__attribute__file__transfer__id& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_file_transfer_id.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__file__transfer__id::operator==(const SDP__attribute__file__transfer__id& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__file__transfer__id::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__file__transfer__id::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__file__transfer__id::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__file__transfer__id::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__file__transfer__id::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_file_transfer_id has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_file_transfer_id: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_file_transfer_id");
  }
}

void SDP__attribute__file__transfer__id::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__file__transfer__id::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__file__transfer__id::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__file__transfer__id::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__file__transfer__id::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__file__transfer__id::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__file__transfer__id_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__file__transfer__id_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__file__transfer__id_template::copy_value(const SDP__attribute__file__transfer__id& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__file__transfer__id_template::copy_template(const SDP__attribute__file__transfer__id_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__file__transfer__id_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__file__transfer__id_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__file__transfer__id_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_transfer_id.");
break;
}
set_selection(other_value);
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template()
{
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(const SDP__attribute__file__transfer__id& other_value)
{
copy_value(other_value);
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(const OPTIONAL<SDP__attribute__file__transfer__id>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__file__transfer__id&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_file_transfer_id from an unbound optional field.");
}
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(SDP__attribute__file__transfer__id_template* p_precondition, SDP__attribute__file__transfer__id_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(Dynamic_Match_Interface<SDP__attribute__file__transfer__id>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__file__transfer__id>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__file__transfer__id_template::SDP__attribute__file__transfer__id_template(const SDP__attribute__file__transfer__id_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__file__transfer__id_template::~SDP__attribute__file__transfer__id_template()
{
clean_up();
}

SDP__attribute__file__transfer__id_template& SDP__attribute__file__transfer__id_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__file__transfer__id_template& SDP__attribute__file__transfer__id_template::operator=(const SDP__attribute__file__transfer__id& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__file__transfer__id_template& SDP__attribute__file__transfer__id_template::operator=(const OPTIONAL<SDP__attribute__file__transfer__id>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__file__transfer__id&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_file_transfer_id.");
}
return *this;
}

SDP__attribute__file__transfer__id_template& SDP__attribute__file__transfer__id_template::operator=(const SDP__attribute__file__transfer__id_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__file__transfer__id_template::match(const SDP__attribute__file__transfer__id& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_transfer_id.");
}
return FALSE;
}

boolean SDP__attribute__file__transfer__id_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__file__transfer__id_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__file__transfer__id_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__file__transfer__id SDP__attribute__file__transfer__id_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_file_transfer_id.");
SDP__attribute__file__transfer__id ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__file__transfer__id_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_file_transfer_id.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__file__transfer__id_template[list_length];
}

SDP__attribute__file__transfer__id_template& SDP__attribute__file__transfer__id_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_file_transfer_id.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_file_transfer_id.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__file__transfer__id_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__file__transfer__id_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_file_transfer_id.");
return single_value->field_attr__value;
}

int SDP__attribute__file__transfer__id_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_file_transfer_id containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_transfer_id.");
  }
  return 0;
}

void SDP__attribute__file__transfer__id_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__file__transfer__id_template::log_match(const SDP__attribute__file__transfer__id& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__file__transfer__id_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__file__transfer__id_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_file_transfer_id.");
}
}

void SDP__attribute__file__transfer__id_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__file__transfer__id_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_file_transfer_id.");
}
}

void SDP__attribute__file__transfer__id_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__file__transfer__id_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_file_transfer_id has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_file_transfer_id: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__file__transfer__id_template* precondition = new SDP__attribute__file__transfer__id_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__file__transfer__id_template* implied_template = new SDP__attribute__file__transfer__id_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__file__transfer__id_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_file_transfer_id");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__file__transfer__id_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_file_transfer_id");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_file_transfer_id");
}

boolean SDP__attribute__file__transfer__id_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__file__transfer__id_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__inactive::SDP__attribute__inactive()
{
bound_flag = FALSE;
}

SDP__attribute__inactive::SDP__attribute__inactive(null_type)
{
bound_flag = TRUE;
}

SDP__attribute__inactive::SDP__attribute__inactive(const SDP__attribute__inactive& other_value)
{
other_value.must_bound("Copying an unbound value of type @SDP_Types.SDP_attribute_inactive.");
bound_flag = TRUE;
}

SDP__attribute__inactive& SDP__attribute__inactive::operator=(null_type)
{
bound_flag = TRUE;
return *this;
}

SDP__attribute__inactive& SDP__attribute__inactive::operator=(const SDP__attribute__inactive& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_inactive.");
bound_flag = TRUE;
return *this;
}

boolean SDP__attribute__inactive::operator==(null_type) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_inactive.");
return TRUE;
}

boolean SDP__attribute__inactive::operator==(const SDP__attribute__inactive& other_value) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_inactive.");
other_value.must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_inactive.");
return TRUE;
}

void SDP__attribute__inactive::log() const
{
if (bound_flag) TTCN_Logger::log_event_str("{ }");
else TTCN_Logger::log_event_unbound();
}

void SDP__attribute__inactive::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "empty record/set value (i.e. { })");
  if (param.get_type()!=Module_Param::MP_Value_List || param.get_size()>0) {
    param.type_error("empty record/set value (i.e. { })", "@SDP_Types.SDP_attribute_inactive");
  }
  bound_flag = TRUE;
}

void SDP__attribute__inactive::encode_text(Text_Buf& /*text_buf*/) const
{
must_bound("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_attribute_inactive.");
}

void SDP__attribute__inactive::decode_text(Text_Buf& /*text_buf*/)
{
bound_flag = TRUE;
}

void SDP__attribute__inactive::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__inactive::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__inactive::TEXT_encode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(!bound_flag) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__inactive::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  bound_flag = TRUE;
  int decoded_length=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
void SDP__attribute__inactive_template::copy_template(const SDP__attribute__inactive_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__inactive_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__inactive_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__inactive_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_inactive.");
break;
}
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template()
{
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(null_type)
 : Base_Template(SPECIFIC_VALUE)
{
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(const SDP__attribute__inactive& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound value of type @SDP_Types.SDP_attribute_inactive.");
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(const OPTIONAL<SDP__attribute__inactive>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_inactive from an unbound optional field.");
}
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(SDP__attribute__inactive_template* p_precondition, SDP__attribute__inactive_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(Dynamic_Match_Interface<SDP__attribute__inactive>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__inactive>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__inactive_template::SDP__attribute__inactive_template(const SDP__attribute__inactive_template& other_value)
: Base_Template(){
copy_template(other_value);
}

SDP__attribute__inactive_template::~SDP__attribute__inactive_template()
{
clean_up();
}

void SDP__attribute__inactive_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::operator=(const SDP__attribute__inactive& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_inactive to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::operator=(const OPTIONAL<SDP__attribute__inactive>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_inactive.");
}
return *this;
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::operator=(const SDP__attribute__inactive_template& other_value)
{
if (&other_value != this) {
clean_up();
set_selection(other_value);
}
return *this;
}

boolean SDP__attribute__inactive_template::match(null_type other_value,boolean) const
{
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
return TRUE;
case OMIT_VALUE:
return FALSE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_inactive.");
}
return FALSE;
}

boolean SDP__attribute__inactive_template::match(const SDP__attribute__inactive& other_value, boolean) const
{
if (!other_value.is_bound()) return FALSE;
return match(NULL_VALUE);
}

SDP__attribute__inactive SDP__attribute__inactive_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_inactive.");
return NULL_VALUE;
}

void SDP__attribute__inactive_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_inactive.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__inactive_template[list_length];
}

SDP__attribute__inactive_template& SDP__attribute__inactive_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_inactive.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_inactive.");
return value_list.list_value[list_index];
}

void SDP__attribute__inactive_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__inactive_template::log_match(const SDP__attribute__inactive& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void SDP__attribute__inactive_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_inactive.");
}
}

void SDP__attribute__inactive_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__inactive_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_inactive.");
}
}

void SDP__attribute__inactive_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "empty record/set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__inactive_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Value_List:
    if (param.get_size()>0) param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_inactive");
    *this = NULL_VALUE;
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__inactive_template* precondition = new SDP__attribute__inactive_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__inactive_template* implied_template = new SDP__attribute__inactive_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__inactive_template(precondition, implied_template);
  } break;
  default:
    param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_inactive");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__inactive_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_inactive");
}

boolean SDP__attribute__inactive_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__inactive_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__setup::SDP__attribute__setup()
{
}

SDP__attribute__setup::SDP__attribute__setup(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__setup::SDP__attribute__setup(const SDP__attribute__setup& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_setup.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__setup::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__setup::get_descriptor() const { return &SDP__attribute__setup_descr_; }
SDP__attribute__setup& SDP__attribute__setup::operator=(const SDP__attribute__setup& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_setup.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__setup::operator==(const SDP__attribute__setup& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__setup::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__setup::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__setup::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__setup::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__setup::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_setup has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_setup: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_setup");
  }
}

void SDP__attribute__setup::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__setup::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__setup::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__setup::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__setup::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__setup::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__setup_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__setup_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__setup_template::copy_value(const SDP__attribute__setup& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__setup_template::copy_template(const SDP__attribute__setup_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__setup_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__setup_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__setup_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_setup.");
break;
}
set_selection(other_value);
}

SDP__attribute__setup_template::SDP__attribute__setup_template()
{
}

SDP__attribute__setup_template::SDP__attribute__setup_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__setup_template::SDP__attribute__setup_template(const SDP__attribute__setup& other_value)
{
copy_value(other_value);
}

SDP__attribute__setup_template::SDP__attribute__setup_template(const OPTIONAL<SDP__attribute__setup>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__setup&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_setup from an unbound optional field.");
}
}

SDP__attribute__setup_template::SDP__attribute__setup_template(SDP__attribute__setup_template* p_precondition, SDP__attribute__setup_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__setup_template::SDP__attribute__setup_template(Dynamic_Match_Interface<SDP__attribute__setup>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__setup>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__setup_template::SDP__attribute__setup_template(const SDP__attribute__setup_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__setup_template::~SDP__attribute__setup_template()
{
clean_up();
}

SDP__attribute__setup_template& SDP__attribute__setup_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__setup_template& SDP__attribute__setup_template::operator=(const SDP__attribute__setup& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__setup_template& SDP__attribute__setup_template::operator=(const OPTIONAL<SDP__attribute__setup>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__setup&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_setup.");
}
return *this;
}

SDP__attribute__setup_template& SDP__attribute__setup_template::operator=(const SDP__attribute__setup_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__setup_template::match(const SDP__attribute__setup& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_setup.");
}
return FALSE;
}

boolean SDP__attribute__setup_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__setup_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__setup_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__setup SDP__attribute__setup_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_setup.");
SDP__attribute__setup ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__setup_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_setup.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__setup_template[list_length];
}

SDP__attribute__setup_template& SDP__attribute__setup_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_setup.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_setup.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__setup_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__setup_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_setup.");
return single_value->field_attr__value;
}

int SDP__attribute__setup_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_setup containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_setup.");
  }
  return 0;
}

void SDP__attribute__setup_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__setup_template::log_match(const SDP__attribute__setup& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__setup_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__setup_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_setup.");
}
}

void SDP__attribute__setup_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__setup_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_setup.");
}
}

void SDP__attribute__setup_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__setup_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_setup has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_setup: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__setup_template* precondition = new SDP__attribute__setup_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__setup_template* implied_template = new SDP__attribute__setup_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__setup_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_setup");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__setup_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_setup");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_setup");
}

boolean SDP__attribute__setup_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__setup_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__connection::SDP__attribute__connection()
{
}

SDP__attribute__connection::SDP__attribute__connection(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__connection::SDP__attribute__connection(const SDP__attribute__connection& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_connection.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__connection::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__connection::get_descriptor() const { return &SDP__attribute__connection_descr_; }
SDP__attribute__connection& SDP__attribute__connection::operator=(const SDP__attribute__connection& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_connection.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__connection::operator==(const SDP__attribute__connection& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__connection::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__connection::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__connection::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__connection::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__connection::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_connection has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_connection: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_connection");
  }
}

void SDP__attribute__connection::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__connection::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__connection::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__connection::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__connection::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__connection::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__connection_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__connection_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__connection_template::copy_value(const SDP__attribute__connection& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__connection_template::copy_template(const SDP__attribute__connection_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__connection_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__connection_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__connection_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_connection.");
break;
}
set_selection(other_value);
}

SDP__attribute__connection_template::SDP__attribute__connection_template()
{
}

SDP__attribute__connection_template::SDP__attribute__connection_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__connection_template::SDP__attribute__connection_template(const SDP__attribute__connection& other_value)
{
copy_value(other_value);
}

SDP__attribute__connection_template::SDP__attribute__connection_template(const OPTIONAL<SDP__attribute__connection>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__connection&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_connection from an unbound optional field.");
}
}

SDP__attribute__connection_template::SDP__attribute__connection_template(SDP__attribute__connection_template* p_precondition, SDP__attribute__connection_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__connection_template::SDP__attribute__connection_template(Dynamic_Match_Interface<SDP__attribute__connection>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__connection>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__connection_template::SDP__attribute__connection_template(const SDP__attribute__connection_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__connection_template::~SDP__attribute__connection_template()
{
clean_up();
}

SDP__attribute__connection_template& SDP__attribute__connection_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__connection_template& SDP__attribute__connection_template::operator=(const SDP__attribute__connection& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__connection_template& SDP__attribute__connection_template::operator=(const OPTIONAL<SDP__attribute__connection>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__connection&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_connection.");
}
return *this;
}

SDP__attribute__connection_template& SDP__attribute__connection_template::operator=(const SDP__attribute__connection_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__connection_template::match(const SDP__attribute__connection& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_connection.");
}
return FALSE;
}

boolean SDP__attribute__connection_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__connection_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__connection_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__connection SDP__attribute__connection_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_connection.");
SDP__attribute__connection ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__connection_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_connection.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__connection_template[list_length];
}

SDP__attribute__connection_template& SDP__attribute__connection_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_connection.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_connection.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__connection_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__connection_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_connection.");
return single_value->field_attr__value;
}

int SDP__attribute__connection_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_connection containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_connection.");
  }
  return 0;
}

void SDP__attribute__connection_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__connection_template::log_match(const SDP__attribute__connection& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__connection_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__connection_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_connection.");
}
}

void SDP__attribute__connection_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__connection_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_connection.");
}
}

void SDP__attribute__connection_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__connection_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_connection has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_connection: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__connection_template* precondition = new SDP__attribute__connection_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__connection_template* implied_template = new SDP__attribute__connection_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__connection_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_connection");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__connection_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_connection");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_connection");
}

boolean SDP__attribute__connection_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__connection_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__crypto::SDP__attribute__crypto()
{
}

SDP__attribute__crypto::SDP__attribute__crypto(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__crypto::SDP__attribute__crypto(const SDP__attribute__crypto& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_crypto.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__crypto::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__crypto::get_descriptor() const { return &SDP__attribute__crypto_descr_; }
SDP__attribute__crypto& SDP__attribute__crypto::operator=(const SDP__attribute__crypto& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_crypto.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__crypto::operator==(const SDP__attribute__crypto& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__crypto::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__crypto::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__crypto::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__crypto::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__crypto::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_crypto has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_crypto: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_crypto");
  }
}

void SDP__attribute__crypto::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__crypto::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__crypto::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__crypto::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__crypto::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__crypto::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__crypto_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__crypto_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__crypto_template::copy_value(const SDP__attribute__crypto& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__crypto_template::copy_template(const SDP__attribute__crypto_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__crypto_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__crypto_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__crypto_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_crypto.");
break;
}
set_selection(other_value);
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template()
{
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(const SDP__attribute__crypto& other_value)
{
copy_value(other_value);
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(const OPTIONAL<SDP__attribute__crypto>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__crypto&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_crypto from an unbound optional field.");
}
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(SDP__attribute__crypto_template* p_precondition, SDP__attribute__crypto_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(Dynamic_Match_Interface<SDP__attribute__crypto>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__crypto>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__crypto_template::SDP__attribute__crypto_template(const SDP__attribute__crypto_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__crypto_template::~SDP__attribute__crypto_template()
{
clean_up();
}

SDP__attribute__crypto_template& SDP__attribute__crypto_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__crypto_template& SDP__attribute__crypto_template::operator=(const SDP__attribute__crypto& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__crypto_template& SDP__attribute__crypto_template::operator=(const OPTIONAL<SDP__attribute__crypto>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__crypto&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_crypto.");
}
return *this;
}

SDP__attribute__crypto_template& SDP__attribute__crypto_template::operator=(const SDP__attribute__crypto_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__crypto_template::match(const SDP__attribute__crypto& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_crypto.");
}
return FALSE;
}

boolean SDP__attribute__crypto_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__crypto_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__crypto_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__crypto SDP__attribute__crypto_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_crypto.");
SDP__attribute__crypto ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__crypto_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_crypto.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__crypto_template[list_length];
}

SDP__attribute__crypto_template& SDP__attribute__crypto_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_crypto.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_crypto.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__crypto_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__crypto_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_crypto.");
return single_value->field_attr__value;
}

int SDP__attribute__crypto_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_crypto containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_crypto.");
  }
  return 0;
}

void SDP__attribute__crypto_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__crypto_template::log_match(const SDP__attribute__crypto& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__crypto_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__crypto_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_crypto.");
}
}

void SDP__attribute__crypto_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__crypto_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_crypto.");
}
}

void SDP__attribute__crypto_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__crypto_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_crypto has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_crypto: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__crypto_template* precondition = new SDP__attribute__crypto_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__crypto_template* implied_template = new SDP__attribute__crypto_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__crypto_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_crypto");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__crypto_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_crypto");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_crypto");
}

boolean SDP__attribute__crypto_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__crypto_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__content::SDP__attribute__content()
{
}

SDP__attribute__content::SDP__attribute__content(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__content::SDP__attribute__content(const SDP__attribute__content& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_content.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__content::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__content::get_descriptor() const { return &SDP__attribute__content_descr_; }
SDP__attribute__content& SDP__attribute__content::operator=(const SDP__attribute__content& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_content.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__content::operator==(const SDP__attribute__content& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__content::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__content::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__content::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__content::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__content::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_content has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_content: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_content");
  }
}

void SDP__attribute__content::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__content::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__content::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__content::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__content::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__content::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__content_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__content_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__content_template::copy_value(const SDP__attribute__content& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__content_template::copy_template(const SDP__attribute__content_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__content_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__content_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__content_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_content.");
break;
}
set_selection(other_value);
}

SDP__attribute__content_template::SDP__attribute__content_template()
{
}

SDP__attribute__content_template::SDP__attribute__content_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__content_template::SDP__attribute__content_template(const SDP__attribute__content& other_value)
{
copy_value(other_value);
}

SDP__attribute__content_template::SDP__attribute__content_template(const OPTIONAL<SDP__attribute__content>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__content&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_content from an unbound optional field.");
}
}

SDP__attribute__content_template::SDP__attribute__content_template(SDP__attribute__content_template* p_precondition, SDP__attribute__content_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__content_template::SDP__attribute__content_template(Dynamic_Match_Interface<SDP__attribute__content>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__content>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__content_template::SDP__attribute__content_template(const SDP__attribute__content_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__content_template::~SDP__attribute__content_template()
{
clean_up();
}

SDP__attribute__content_template& SDP__attribute__content_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__content_template& SDP__attribute__content_template::operator=(const SDP__attribute__content& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__content_template& SDP__attribute__content_template::operator=(const OPTIONAL<SDP__attribute__content>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__content&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_content.");
}
return *this;
}

SDP__attribute__content_template& SDP__attribute__content_template::operator=(const SDP__attribute__content_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__content_template::match(const SDP__attribute__content& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_content.");
}
return FALSE;
}

boolean SDP__attribute__content_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__content_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__content_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__content SDP__attribute__content_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_content.");
SDP__attribute__content ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__content_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_content.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__content_template[list_length];
}

SDP__attribute__content_template& SDP__attribute__content_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_content.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_content.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__content_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__content_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_content.");
return single_value->field_attr__value;
}

int SDP__attribute__content_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_content containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_content.");
  }
  return 0;
}

void SDP__attribute__content_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__content_template::log_match(const SDP__attribute__content& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__content_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__content_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_content.");
}
}

void SDP__attribute__content_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__content_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_content.");
}
}

void SDP__attribute__content_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__content_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_content has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_content: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__content_template* precondition = new SDP__attribute__content_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__content_template* implied_template = new SDP__attribute__content_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__content_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_content");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__content_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_content");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_content");
}

boolean SDP__attribute__content_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__content_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__label::SDP__attribute__label()
{
}

SDP__attribute__label::SDP__attribute__label(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__label::SDP__attribute__label(const SDP__attribute__label& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_label.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__label::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__label::get_descriptor() const { return &SDP__attribute__label_descr_; }
SDP__attribute__label& SDP__attribute__label::operator=(const SDP__attribute__label& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_label.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__label::operator==(const SDP__attribute__label& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__label::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__label::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__label::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__label::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__label::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_label has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_label: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_label");
  }
}

void SDP__attribute__label::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__label::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__label::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__label::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__label::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__label::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__label_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__label_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__label_template::copy_value(const SDP__attribute__label& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__label_template::copy_template(const SDP__attribute__label_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__label_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__label_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__label_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_label.");
break;
}
set_selection(other_value);
}

SDP__attribute__label_template::SDP__attribute__label_template()
{
}

SDP__attribute__label_template::SDP__attribute__label_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__label_template::SDP__attribute__label_template(const SDP__attribute__label& other_value)
{
copy_value(other_value);
}

SDP__attribute__label_template::SDP__attribute__label_template(const OPTIONAL<SDP__attribute__label>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__label&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_label from an unbound optional field.");
}
}

SDP__attribute__label_template::SDP__attribute__label_template(SDP__attribute__label_template* p_precondition, SDP__attribute__label_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__label_template::SDP__attribute__label_template(Dynamic_Match_Interface<SDP__attribute__label>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__label>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__label_template::SDP__attribute__label_template(const SDP__attribute__label_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__label_template::~SDP__attribute__label_template()
{
clean_up();
}

SDP__attribute__label_template& SDP__attribute__label_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__label_template& SDP__attribute__label_template::operator=(const SDP__attribute__label& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__label_template& SDP__attribute__label_template::operator=(const OPTIONAL<SDP__attribute__label>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__label&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_label.");
}
return *this;
}

SDP__attribute__label_template& SDP__attribute__label_template::operator=(const SDP__attribute__label_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__label_template::match(const SDP__attribute__label& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_label.");
}
return FALSE;
}

boolean SDP__attribute__label_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__label_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__label_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__label SDP__attribute__label_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_label.");
SDP__attribute__label ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__label_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_label.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__label_template[list_length];
}

SDP__attribute__label_template& SDP__attribute__label_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_label.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_label.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__label_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__label_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_label.");
return single_value->field_attr__value;
}

int SDP__attribute__label_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_label containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_label.");
  }
  return 0;
}

void SDP__attribute__label_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__label_template::log_match(const SDP__attribute__label& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__label_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__label_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_label.");
}
}

void SDP__attribute__label_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__label_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_label.");
}
}

void SDP__attribute__label_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__label_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_label has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_label: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__label_template* precondition = new SDP__attribute__label_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__label_template* implied_template = new SDP__attribute__label_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__label_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_label");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__label_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_label");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_label");
}

boolean SDP__attribute__label_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__label_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__floorctrl::SDP__attribute__floorctrl()
{
}

SDP__attribute__floorctrl::SDP__attribute__floorctrl(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__floorctrl::SDP__attribute__floorctrl(const SDP__attribute__floorctrl& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_floorctrl.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__floorctrl::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__floorctrl::get_descriptor() const { return &SDP__attribute__floorctrl_descr_; }
SDP__attribute__floorctrl& SDP__attribute__floorctrl::operator=(const SDP__attribute__floorctrl& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_floorctrl.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__floorctrl::operator==(const SDP__attribute__floorctrl& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__floorctrl::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__floorctrl::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__floorctrl::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__floorctrl::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__floorctrl::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_floorctrl has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_floorctrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_floorctrl");
  }
}

void SDP__attribute__floorctrl::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__floorctrl::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__floorctrl::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__floorctrl::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__floorctrl::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__floorctrl::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__floorctrl_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__floorctrl_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__floorctrl_template::copy_value(const SDP__attribute__floorctrl& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__floorctrl_template::copy_template(const SDP__attribute__floorctrl_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__floorctrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__floorctrl_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__floorctrl_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorctrl.");
break;
}
set_selection(other_value);
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template()
{
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(const SDP__attribute__floorctrl& other_value)
{
copy_value(other_value);
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(const OPTIONAL<SDP__attribute__floorctrl>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__floorctrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_floorctrl from an unbound optional field.");
}
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(SDP__attribute__floorctrl_template* p_precondition, SDP__attribute__floorctrl_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(Dynamic_Match_Interface<SDP__attribute__floorctrl>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__floorctrl>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__floorctrl_template::SDP__attribute__floorctrl_template(const SDP__attribute__floorctrl_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__floorctrl_template::~SDP__attribute__floorctrl_template()
{
clean_up();
}

SDP__attribute__floorctrl_template& SDP__attribute__floorctrl_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__floorctrl_template& SDP__attribute__floorctrl_template::operator=(const SDP__attribute__floorctrl& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__floorctrl_template& SDP__attribute__floorctrl_template::operator=(const OPTIONAL<SDP__attribute__floorctrl>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__floorctrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_floorctrl.");
}
return *this;
}

SDP__attribute__floorctrl_template& SDP__attribute__floorctrl_template::operator=(const SDP__attribute__floorctrl_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__floorctrl_template::match(const SDP__attribute__floorctrl& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorctrl.");
}
return FALSE;
}

boolean SDP__attribute__floorctrl_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__floorctrl_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__floorctrl_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__floorctrl SDP__attribute__floorctrl_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_floorctrl.");
SDP__attribute__floorctrl ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__floorctrl_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_floorctrl.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__floorctrl_template[list_length];
}

SDP__attribute__floorctrl_template& SDP__attribute__floorctrl_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_floorctrl.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_floorctrl.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__floorctrl_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__floorctrl_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_floorctrl.");
return single_value->field_attr__value;
}

int SDP__attribute__floorctrl_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorctrl containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorctrl.");
  }
  return 0;
}

void SDP__attribute__floorctrl_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__floorctrl_template::log_match(const SDP__attribute__floorctrl& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__floorctrl_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__floorctrl_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorctrl.");
}
}

void SDP__attribute__floorctrl_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__floorctrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_floorctrl.");
}
}

void SDP__attribute__floorctrl_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__floorctrl_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_floorctrl has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_floorctrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__floorctrl_template* precondition = new SDP__attribute__floorctrl_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__floorctrl_template* implied_template = new SDP__attribute__floorctrl_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__floorctrl_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_floorctrl");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__floorctrl_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_floorctrl");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_floorctrl");
}

boolean SDP__attribute__floorctrl_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__floorctrl_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__confid::SDP__attribute__confid()
{
}

SDP__attribute__confid::SDP__attribute__confid(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__confid::SDP__attribute__confid(const SDP__attribute__confid& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_confid.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__confid::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__confid::get_descriptor() const { return &SDP__attribute__confid_descr_; }
SDP__attribute__confid& SDP__attribute__confid::operator=(const SDP__attribute__confid& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_confid.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__confid::operator==(const SDP__attribute__confid& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__confid::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__confid::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__confid::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__confid::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__confid::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_confid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_confid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_confid");
  }
}

void SDP__attribute__confid::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__confid::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__confid::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__confid::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__confid::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__confid::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__confid_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__confid_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__confid_template::copy_value(const SDP__attribute__confid& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__confid_template::copy_template(const SDP__attribute__confid_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__confid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__confid_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__confid_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_confid.");
break;
}
set_selection(other_value);
}

SDP__attribute__confid_template::SDP__attribute__confid_template()
{
}

SDP__attribute__confid_template::SDP__attribute__confid_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__confid_template::SDP__attribute__confid_template(const SDP__attribute__confid& other_value)
{
copy_value(other_value);
}

SDP__attribute__confid_template::SDP__attribute__confid_template(const OPTIONAL<SDP__attribute__confid>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__confid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_confid from an unbound optional field.");
}
}

SDP__attribute__confid_template::SDP__attribute__confid_template(SDP__attribute__confid_template* p_precondition, SDP__attribute__confid_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__confid_template::SDP__attribute__confid_template(Dynamic_Match_Interface<SDP__attribute__confid>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__confid>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__confid_template::SDP__attribute__confid_template(const SDP__attribute__confid_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__confid_template::~SDP__attribute__confid_template()
{
clean_up();
}

SDP__attribute__confid_template& SDP__attribute__confid_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__confid_template& SDP__attribute__confid_template::operator=(const SDP__attribute__confid& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__confid_template& SDP__attribute__confid_template::operator=(const OPTIONAL<SDP__attribute__confid>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__confid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_confid.");
}
return *this;
}

SDP__attribute__confid_template& SDP__attribute__confid_template::operator=(const SDP__attribute__confid_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__confid_template::match(const SDP__attribute__confid& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_confid.");
}
return FALSE;
}

boolean SDP__attribute__confid_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__confid_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__confid_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__confid SDP__attribute__confid_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_confid.");
SDP__attribute__confid ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__confid_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_confid.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__confid_template[list_length];
}

SDP__attribute__confid_template& SDP__attribute__confid_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_confid.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_confid.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__confid_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__confid_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_confid.");
return single_value->field_attr__value;
}

int SDP__attribute__confid_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_confid containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_confid.");
  }
  return 0;
}

void SDP__attribute__confid_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__confid_template::log_match(const SDP__attribute__confid& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__confid_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__confid_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_confid.");
}
}

void SDP__attribute__confid_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__confid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_confid.");
}
}

void SDP__attribute__confid_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__confid_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_confid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_confid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__confid_template* precondition = new SDP__attribute__confid_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__confid_template* implied_template = new SDP__attribute__confid_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__confid_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_confid");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__confid_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_confid");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_confid");
}

boolean SDP__attribute__confid_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__confid_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__userid::SDP__attribute__userid()
{
}

SDP__attribute__userid::SDP__attribute__userid(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__userid::SDP__attribute__userid(const SDP__attribute__userid& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_userid.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__userid::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__userid::get_descriptor() const { return &SDP__attribute__userid_descr_; }
SDP__attribute__userid& SDP__attribute__userid::operator=(const SDP__attribute__userid& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_userid.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__userid::operator==(const SDP__attribute__userid& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__userid::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__userid::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__userid::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__userid::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__userid::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_userid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_userid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_userid");
  }
}

void SDP__attribute__userid::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__userid::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__userid::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__userid::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__userid::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__userid::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__userid_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__userid_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__userid_template::copy_value(const SDP__attribute__userid& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__userid_template::copy_template(const SDP__attribute__userid_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__userid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__userid_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__userid_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_userid.");
break;
}
set_selection(other_value);
}

SDP__attribute__userid_template::SDP__attribute__userid_template()
{
}

SDP__attribute__userid_template::SDP__attribute__userid_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__userid_template::SDP__attribute__userid_template(const SDP__attribute__userid& other_value)
{
copy_value(other_value);
}

SDP__attribute__userid_template::SDP__attribute__userid_template(const OPTIONAL<SDP__attribute__userid>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__userid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_userid from an unbound optional field.");
}
}

SDP__attribute__userid_template::SDP__attribute__userid_template(SDP__attribute__userid_template* p_precondition, SDP__attribute__userid_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__userid_template::SDP__attribute__userid_template(Dynamic_Match_Interface<SDP__attribute__userid>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__userid>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__userid_template::SDP__attribute__userid_template(const SDP__attribute__userid_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__userid_template::~SDP__attribute__userid_template()
{
clean_up();
}

SDP__attribute__userid_template& SDP__attribute__userid_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__userid_template& SDP__attribute__userid_template::operator=(const SDP__attribute__userid& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__userid_template& SDP__attribute__userid_template::operator=(const OPTIONAL<SDP__attribute__userid>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__userid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_userid.");
}
return *this;
}

SDP__attribute__userid_template& SDP__attribute__userid_template::operator=(const SDP__attribute__userid_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__userid_template::match(const SDP__attribute__userid& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_userid.");
}
return FALSE;
}

boolean SDP__attribute__userid_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__userid_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__userid_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__userid SDP__attribute__userid_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_userid.");
SDP__attribute__userid ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__userid_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_userid.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__userid_template[list_length];
}

SDP__attribute__userid_template& SDP__attribute__userid_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_userid.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_userid.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__userid_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__userid_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_userid.");
return single_value->field_attr__value;
}

int SDP__attribute__userid_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_userid containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_userid.");
  }
  return 0;
}

void SDP__attribute__userid_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__userid_template::log_match(const SDP__attribute__userid& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__userid_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__userid_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_userid.");
}
}

void SDP__attribute__userid_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__userid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_userid.");
}
}

void SDP__attribute__userid_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__userid_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_userid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_userid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__userid_template* precondition = new SDP__attribute__userid_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__userid_template* implied_template = new SDP__attribute__userid_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__userid_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_userid");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__userid_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_userid");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_userid");
}

boolean SDP__attribute__userid_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__userid_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__floorid::SDP__attribute__floorid()
{
}

SDP__attribute__floorid::SDP__attribute__floorid(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__floorid::SDP__attribute__floorid(const SDP__attribute__floorid& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_floorid.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__floorid::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__floorid::get_descriptor() const { return &SDP__attribute__floorid_descr_; }
SDP__attribute__floorid& SDP__attribute__floorid::operator=(const SDP__attribute__floorid& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_floorid.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__floorid::operator==(const SDP__attribute__floorid& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__floorid::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__floorid::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__floorid::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__floorid::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__floorid::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_floorid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_floorid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_floorid");
  }
}

void SDP__attribute__floorid::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__floorid::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__floorid::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__floorid::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__floorid::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__floorid::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__floorid_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__floorid_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__floorid_template::copy_value(const SDP__attribute__floorid& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__floorid_template::copy_template(const SDP__attribute__floorid_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__floorid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__floorid_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__floorid_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorid.");
break;
}
set_selection(other_value);
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template()
{
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(const SDP__attribute__floorid& other_value)
{
copy_value(other_value);
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(const OPTIONAL<SDP__attribute__floorid>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__floorid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_floorid from an unbound optional field.");
}
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(SDP__attribute__floorid_template* p_precondition, SDP__attribute__floorid_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(Dynamic_Match_Interface<SDP__attribute__floorid>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__floorid>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__floorid_template::SDP__attribute__floorid_template(const SDP__attribute__floorid_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__floorid_template::~SDP__attribute__floorid_template()
{
clean_up();
}

SDP__attribute__floorid_template& SDP__attribute__floorid_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__floorid_template& SDP__attribute__floorid_template::operator=(const SDP__attribute__floorid& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__floorid_template& SDP__attribute__floorid_template::operator=(const OPTIONAL<SDP__attribute__floorid>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__floorid&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_floorid.");
}
return *this;
}

SDP__attribute__floorid_template& SDP__attribute__floorid_template::operator=(const SDP__attribute__floorid_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__floorid_template::match(const SDP__attribute__floorid& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorid.");
}
return FALSE;
}

boolean SDP__attribute__floorid_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__floorid_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__floorid_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__floorid SDP__attribute__floorid_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_floorid.");
SDP__attribute__floorid ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__floorid_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_floorid.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__floorid_template[list_length];
}

SDP__attribute__floorid_template& SDP__attribute__floorid_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_floorid.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_floorid.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__floorid_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__floorid_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_floorid.");
return single_value->field_attr__value;
}

int SDP__attribute__floorid_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_floorid containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorid.");
  }
  return 0;
}

void SDP__attribute__floorid_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__floorid_template::log_match(const SDP__attribute__floorid& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__floorid_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__floorid_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_floorid.");
}
}

void SDP__attribute__floorid_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__floorid_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_floorid.");
}
}

void SDP__attribute__floorid_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__floorid_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_floorid has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_floorid: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__floorid_template* precondition = new SDP__attribute__floorid_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__floorid_template* implied_template = new SDP__attribute__floorid_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__floorid_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_floorid");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__floorid_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_floorid");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_floorid");
}

boolean SDP__attribute__floorid_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__floorid_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__fingerprint::SDP__attribute__fingerprint()
{
}

SDP__attribute__fingerprint::SDP__attribute__fingerprint(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__fingerprint::SDP__attribute__fingerprint(const SDP__attribute__fingerprint& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_fingerprint.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__fingerprint::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__fingerprint::get_descriptor() const { return &SDP__attribute__fingerprint_descr_; }
SDP__attribute__fingerprint& SDP__attribute__fingerprint::operator=(const SDP__attribute__fingerprint& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_fingerprint.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__fingerprint::operator==(const SDP__attribute__fingerprint& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__fingerprint::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__fingerprint::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__fingerprint::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__fingerprint::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__fingerprint::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_fingerprint has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_fingerprint: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_fingerprint");
  }
}

void SDP__attribute__fingerprint::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__fingerprint::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__fingerprint::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__fingerprint::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__fingerprint::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__fingerprint::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__fingerprint_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__fingerprint_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__fingerprint_template::copy_value(const SDP__attribute__fingerprint& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__fingerprint_template::copy_template(const SDP__attribute__fingerprint_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__fingerprint_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__fingerprint_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__fingerprint_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_fingerprint.");
break;
}
set_selection(other_value);
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template()
{
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(const SDP__attribute__fingerprint& other_value)
{
copy_value(other_value);
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(const OPTIONAL<SDP__attribute__fingerprint>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__fingerprint&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_fingerprint from an unbound optional field.");
}
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(SDP__attribute__fingerprint_template* p_precondition, SDP__attribute__fingerprint_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(Dynamic_Match_Interface<SDP__attribute__fingerprint>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__fingerprint>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__fingerprint_template::SDP__attribute__fingerprint_template(const SDP__attribute__fingerprint_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__fingerprint_template::~SDP__attribute__fingerprint_template()
{
clean_up();
}

SDP__attribute__fingerprint_template& SDP__attribute__fingerprint_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__fingerprint_template& SDP__attribute__fingerprint_template::operator=(const SDP__attribute__fingerprint& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__fingerprint_template& SDP__attribute__fingerprint_template::operator=(const OPTIONAL<SDP__attribute__fingerprint>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__fingerprint&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_fingerprint.");
}
return *this;
}

SDP__attribute__fingerprint_template& SDP__attribute__fingerprint_template::operator=(const SDP__attribute__fingerprint_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__fingerprint_template::match(const SDP__attribute__fingerprint& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_fingerprint.");
}
return FALSE;
}

boolean SDP__attribute__fingerprint_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__fingerprint_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__fingerprint_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__fingerprint SDP__attribute__fingerprint_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_fingerprint.");
SDP__attribute__fingerprint ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__fingerprint_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_fingerprint.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__fingerprint_template[list_length];
}

SDP__attribute__fingerprint_template& SDP__attribute__fingerprint_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_fingerprint.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_fingerprint.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__fingerprint_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__fingerprint_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_fingerprint.");
return single_value->field_attr__value;
}

int SDP__attribute__fingerprint_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_fingerprint containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_fingerprint.");
  }
  return 0;
}

void SDP__attribute__fingerprint_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__fingerprint_template::log_match(const SDP__attribute__fingerprint& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__fingerprint_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__fingerprint_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_fingerprint.");
}
}

void SDP__attribute__fingerprint_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__fingerprint_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_fingerprint.");
}
}

void SDP__attribute__fingerprint_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__fingerprint_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_fingerprint has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_fingerprint: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__fingerprint_template* precondition = new SDP__attribute__fingerprint_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__fingerprint_template* implied_template = new SDP__attribute__fingerprint_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__fingerprint_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_fingerprint");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__fingerprint_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_fingerprint");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_fingerprint");
}

boolean SDP__attribute__fingerprint_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__fingerprint_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__ice__ufrag::SDP__attribute__ice__ufrag()
{
}

SDP__attribute__ice__ufrag::SDP__attribute__ice__ufrag(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__ice__ufrag::SDP__attribute__ice__ufrag(const SDP__attribute__ice__ufrag& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_ice_ufrag.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__ice__ufrag::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__ice__ufrag::get_descriptor() const { return &SDP__attribute__ice__ufrag_descr_; }
SDP__attribute__ice__ufrag& SDP__attribute__ice__ufrag::operator=(const SDP__attribute__ice__ufrag& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_ufrag.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__ice__ufrag::operator==(const SDP__attribute__ice__ufrag& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__ice__ufrag::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__ice__ufrag::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__ice__ufrag::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__ice__ufrag::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__ufrag::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_ice_ufrag has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_ufrag: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_ice_ufrag");
  }
}

void SDP__attribute__ice__ufrag::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__ice__ufrag::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__ice__ufrag::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__ice__ufrag::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__ice__ufrag::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__ice__ufrag::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__ice__ufrag_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__ice__ufrag_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__ice__ufrag_template::copy_value(const SDP__attribute__ice__ufrag& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__ice__ufrag_template::copy_template(const SDP__attribute__ice__ufrag_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__ice__ufrag_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__ice__ufrag_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__ice__ufrag_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_ufrag.");
break;
}
set_selection(other_value);
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template()
{
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(const SDP__attribute__ice__ufrag& other_value)
{
copy_value(other_value);
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(const OPTIONAL<SDP__attribute__ice__ufrag>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__ufrag&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_ice_ufrag from an unbound optional field.");
}
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(SDP__attribute__ice__ufrag_template* p_precondition, SDP__attribute__ice__ufrag_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(Dynamic_Match_Interface<SDP__attribute__ice__ufrag>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__ice__ufrag>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__ice__ufrag_template::SDP__attribute__ice__ufrag_template(const SDP__attribute__ice__ufrag_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__ice__ufrag_template::~SDP__attribute__ice__ufrag_template()
{
clean_up();
}

SDP__attribute__ice__ufrag_template& SDP__attribute__ice__ufrag_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__ice__ufrag_template& SDP__attribute__ice__ufrag_template::operator=(const SDP__attribute__ice__ufrag& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__ice__ufrag_template& SDP__attribute__ice__ufrag_template::operator=(const OPTIONAL<SDP__attribute__ice__ufrag>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__ufrag&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_ice_ufrag.");
}
return *this;
}

SDP__attribute__ice__ufrag_template& SDP__attribute__ice__ufrag_template::operator=(const SDP__attribute__ice__ufrag_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__ice__ufrag_template::match(const SDP__attribute__ice__ufrag& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_ufrag.");
}
return FALSE;
}

boolean SDP__attribute__ice__ufrag_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__ice__ufrag_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__ice__ufrag_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__ice__ufrag SDP__attribute__ice__ufrag_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_ice_ufrag.");
SDP__attribute__ice__ufrag ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__ice__ufrag_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_ice_ufrag.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__ice__ufrag_template[list_length];
}

SDP__attribute__ice__ufrag_template& SDP__attribute__ice__ufrag_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_ice_ufrag.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_ice_ufrag.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__ice__ufrag_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__ice__ufrag_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_ice_ufrag.");
return single_value->field_attr__value;
}

int SDP__attribute__ice__ufrag_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_ufrag containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_ufrag.");
  }
  return 0;
}

void SDP__attribute__ice__ufrag_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__ice__ufrag_template::log_match(const SDP__attribute__ice__ufrag& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__ice__ufrag_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__ufrag_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_ufrag.");
}
}

void SDP__attribute__ice__ufrag_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__ice__ufrag_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_ice_ufrag.");
}
}

void SDP__attribute__ice__ufrag_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__ice__ufrag_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_ice_ufrag has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_ufrag: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__ice__ufrag_template* precondition = new SDP__attribute__ice__ufrag_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__ice__ufrag_template* implied_template = new SDP__attribute__ice__ufrag_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__ice__ufrag_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_ice_ufrag");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__ice__ufrag_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_ice_ufrag");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_ice_ufrag");
}

boolean SDP__attribute__ice__ufrag_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__ice__ufrag_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__ice__pwd::SDP__attribute__ice__pwd()
{
}

SDP__attribute__ice__pwd::SDP__attribute__ice__pwd(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__ice__pwd::SDP__attribute__ice__pwd(const SDP__attribute__ice__pwd& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_ice_pwd.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__ice__pwd::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__ice__pwd::get_descriptor() const { return &SDP__attribute__ice__pwd_descr_; }
SDP__attribute__ice__pwd& SDP__attribute__ice__pwd::operator=(const SDP__attribute__ice__pwd& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_pwd.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__ice__pwd::operator==(const SDP__attribute__ice__pwd& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__ice__pwd::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__ice__pwd::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__ice__pwd::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__ice__pwd::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__pwd::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_ice_pwd has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_pwd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_ice_pwd");
  }
}

void SDP__attribute__ice__pwd::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__ice__pwd::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__ice__pwd::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__ice__pwd::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__ice__pwd::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__ice__pwd::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__ice__pwd_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__ice__pwd_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__ice__pwd_template::copy_value(const SDP__attribute__ice__pwd& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__ice__pwd_template::copy_template(const SDP__attribute__ice__pwd_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__ice__pwd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__ice__pwd_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__ice__pwd_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_pwd.");
break;
}
set_selection(other_value);
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template()
{
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(const SDP__attribute__ice__pwd& other_value)
{
copy_value(other_value);
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(const OPTIONAL<SDP__attribute__ice__pwd>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__pwd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_ice_pwd from an unbound optional field.");
}
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(SDP__attribute__ice__pwd_template* p_precondition, SDP__attribute__ice__pwd_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(Dynamic_Match_Interface<SDP__attribute__ice__pwd>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__ice__pwd>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__ice__pwd_template::SDP__attribute__ice__pwd_template(const SDP__attribute__ice__pwd_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__ice__pwd_template::~SDP__attribute__ice__pwd_template()
{
clean_up();
}

SDP__attribute__ice__pwd_template& SDP__attribute__ice__pwd_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__ice__pwd_template& SDP__attribute__ice__pwd_template::operator=(const SDP__attribute__ice__pwd& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__ice__pwd_template& SDP__attribute__ice__pwd_template::operator=(const OPTIONAL<SDP__attribute__ice__pwd>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__pwd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_ice_pwd.");
}
return *this;
}

SDP__attribute__ice__pwd_template& SDP__attribute__ice__pwd_template::operator=(const SDP__attribute__ice__pwd_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__ice__pwd_template::match(const SDP__attribute__ice__pwd& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_pwd.");
}
return FALSE;
}

boolean SDP__attribute__ice__pwd_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__ice__pwd_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__ice__pwd_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__ice__pwd SDP__attribute__ice__pwd_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_ice_pwd.");
SDP__attribute__ice__pwd ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__ice__pwd_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_ice_pwd.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__ice__pwd_template[list_length];
}

SDP__attribute__ice__pwd_template& SDP__attribute__ice__pwd_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_ice_pwd.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_ice_pwd.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__ice__pwd_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__ice__pwd_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_ice_pwd.");
return single_value->field_attr__value;
}

int SDP__attribute__ice__pwd_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_pwd containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_pwd.");
  }
  return 0;
}

void SDP__attribute__ice__pwd_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__ice__pwd_template::log_match(const SDP__attribute__ice__pwd& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__ice__pwd_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__pwd_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_pwd.");
}
}

void SDP__attribute__ice__pwd_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__ice__pwd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_ice_pwd.");
}
}

void SDP__attribute__ice__pwd_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__ice__pwd_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_ice_pwd has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_pwd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__ice__pwd_template* precondition = new SDP__attribute__ice__pwd_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__ice__pwd_template* implied_template = new SDP__attribute__ice__pwd_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__ice__pwd_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_ice_pwd");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__ice__pwd_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_ice_pwd");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_ice_pwd");
}

boolean SDP__attribute__ice__pwd_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__ice__pwd_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__candidate::SDP__attribute__candidate()
{
}

SDP__attribute__candidate::SDP__attribute__candidate(const CHARSTRING& par_foundation,
    const INTEGER& par_component__id,
    const CHARSTRING& par_transport,
    const INTEGER& par_priority,
    const CHARSTRING& par_connection__address,
    const INTEGER& par_connection__port,
    const CHARSTRING& par_candidate__type,
    const OPTIONAL< CHARSTRING >& par_rel__address,
    const OPTIONAL< CHARSTRING >& par_rel__port,
    const OPTIONAL< SDP__extension__list >& par_extensions)
  :   field_foundation(par_foundation),
  field_component__id(par_component__id),
  field_transport(par_transport),
  field_priority(par_priority),
  field_connection__address(par_connection__address),
  field_connection__port(par_connection__port),
  field_candidate__type(par_candidate__type),
  field_rel__address(par_rel__address),
  field_rel__port(par_rel__port),
  field_extensions(par_extensions)
{
}

SDP__attribute__candidate::SDP__attribute__candidate(const SDP__attribute__candidate& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_candidate.");
if (other_value.foundation().is_bound()) field_foundation = other_value.foundation();
else field_foundation.clean_up();
if (other_value.component__id().is_bound()) field_component__id = other_value.component__id();
else field_component__id.clean_up();
if (other_value.transport().is_bound()) field_transport = other_value.transport();
else field_transport.clean_up();
if (other_value.priority().is_bound()) field_priority = other_value.priority();
else field_priority.clean_up();
if (other_value.connection__address().is_bound()) field_connection__address = other_value.connection__address();
else field_connection__address.clean_up();
if (other_value.connection__port().is_bound()) field_connection__port = other_value.connection__port();
else field_connection__port.clean_up();
if (other_value.candidate__type().is_bound()) field_candidate__type = other_value.candidate__type();
else field_candidate__type.clean_up();
if (other_value.rel__address().is_bound()) field_rel__address = other_value.rel__address();
else field_rel__address.clean_up();
if (other_value.rel__port().is_bound()) field_rel__port = other_value.rel__port();
else field_rel__port.clean_up();
if (other_value.extensions().is_bound()) field_extensions = other_value.extensions();
else field_extensions.clean_up();
}

void SDP__attribute__candidate::clean_up()
{
field_foundation.clean_up();
field_component__id.clean_up();
field_transport.clean_up();
field_priority.clean_up();
field_connection__address.clean_up();
field_connection__port.clean_up();
field_candidate__type.clean_up();
field_rel__address.clean_up();
field_rel__port.clean_up();
field_extensions.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__candidate::get_descriptor() const { return &SDP__attribute__candidate_descr_; }
SDP__attribute__candidate& SDP__attribute__candidate::operator=(const SDP__attribute__candidate& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_candidate.");
  if (other_value.foundation().is_bound()) field_foundation = other_value.foundation();
  else field_foundation.clean_up();
  if (other_value.component__id().is_bound()) field_component__id = other_value.component__id();
  else field_component__id.clean_up();
  if (other_value.transport().is_bound()) field_transport = other_value.transport();
  else field_transport.clean_up();
  if (other_value.priority().is_bound()) field_priority = other_value.priority();
  else field_priority.clean_up();
  if (other_value.connection__address().is_bound()) field_connection__address = other_value.connection__address();
  else field_connection__address.clean_up();
  if (other_value.connection__port().is_bound()) field_connection__port = other_value.connection__port();
  else field_connection__port.clean_up();
  if (other_value.candidate__type().is_bound()) field_candidate__type = other_value.candidate__type();
  else field_candidate__type.clean_up();
  if (other_value.rel__address().is_bound()) field_rel__address = other_value.rel__address();
  else field_rel__address.clean_up();
  if (other_value.rel__port().is_bound()) field_rel__port = other_value.rel__port();
  else field_rel__port.clean_up();
  if (other_value.extensions().is_bound()) field_extensions = other_value.extensions();
  else field_extensions.clean_up();
}
return *this;
}

boolean SDP__attribute__candidate::operator==(const SDP__attribute__candidate& other_value) const
{
return field_foundation==other_value.field_foundation
  && field_component__id==other_value.field_component__id
  && field_transport==other_value.field_transport
  && field_priority==other_value.field_priority
  && field_connection__address==other_value.field_connection__address
  && field_connection__port==other_value.field_connection__port
  && field_candidate__type==other_value.field_candidate__type
  && field_rel__address==other_value.field_rel__address
  && field_rel__port==other_value.field_rel__port
  && field_extensions==other_value.field_extensions;
}

boolean SDP__attribute__candidate::is_bound() const
{
return (field_foundation.is_bound())
  || (field_component__id.is_bound())
  || (field_transport.is_bound())
  || (field_priority.is_bound())
  || (field_connection__address.is_bound())
  || (field_connection__port.is_bound())
  || (field_candidate__type.is_bound())
  || (OPTIONAL_OMIT == field_rel__address.get_selection() || field_rel__address.is_bound())
  || (OPTIONAL_OMIT == field_rel__port.get_selection() || field_rel__port.is_bound())
  || (OPTIONAL_OMIT == field_extensions.get_selection() || field_extensions.is_bound());
}
boolean SDP__attribute__candidate::is_value() const
{
return field_foundation.is_value()
  && field_component__id.is_value()
  && field_transport.is_value()
  && field_priority.is_value()
  && field_connection__address.is_value()
  && field_connection__port.is_value()
  && field_candidate__type.is_value()
  && (OPTIONAL_OMIT == field_rel__address.get_selection() || field_rel__address.is_value())
  && (OPTIONAL_OMIT == field_rel__port.get_selection() || field_rel__port.is_value())
  && (OPTIONAL_OMIT == field_extensions.get_selection() || field_extensions.is_value());
}
int SDP__attribute__candidate::size_of() const
{
  int ret_val = 7;
  if (field_rel__address.ispresent()) ret_val++;
  if (field_rel__port.ispresent()) ret_val++;
  if (field_extensions.ispresent()) ret_val++;
  return ret_val;
}

void SDP__attribute__candidate::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ foundation := ");
field_foundation.log();
TTCN_Logger::log_event_str(", component_id := ");
field_component__id.log();
TTCN_Logger::log_event_str(", transport := ");
field_transport.log();
TTCN_Logger::log_event_str(", priority := ");
field_priority.log();
TTCN_Logger::log_event_str(", connection_address := ");
field_connection__address.log();
TTCN_Logger::log_event_str(", connection_port := ");
field_connection__port.log();
TTCN_Logger::log_event_str(", candidate_type := ");
field_candidate__type.log();
TTCN_Logger::log_event_str(", rel_address := ");
field_rel__address.log();
TTCN_Logger::log_event_str(", rel_port := ");
field_rel__port.log();
TTCN_Logger::log_event_str(", extensions := ");
field_extensions.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__candidate::set_implicit_omit()
{
if (foundation().is_bound()) foundation().set_implicit_omit();
if (component__id().is_bound()) component__id().set_implicit_omit();
if (transport().is_bound()) transport().set_implicit_omit();
if (priority().is_bound()) priority().set_implicit_omit();
if (connection__address().is_bound()) connection__address().set_implicit_omit();
if (connection__port().is_bound()) connection__port().set_implicit_omit();
if (candidate__type().is_bound()) candidate__type().set_implicit_omit();
if (!rel__address().is_bound()) rel__address() = OMIT_VALUE;
else rel__address().set_implicit_omit();
if (!rel__port().is_bound()) rel__port() = OMIT_VALUE;
else rel__port().set_implicit_omit();
if (!extensions().is_bound()) extensions() = OMIT_VALUE;
else extensions().set_implicit_omit();
}

void SDP__attribute__candidate::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_candidate has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) foundation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) component__id().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) connection__address().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) connection__port().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) candidate__type().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) rel__address().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) rel__port().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) extensions().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "foundation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          foundation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "component_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          component__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_port")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__port().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "candidate_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          candidate__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel_port")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel__port().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_candidate");
  }
}

void SDP__attribute__candidate::encode_text(Text_Buf& text_buf) const
{
field_foundation.encode_text(text_buf);
field_component__id.encode_text(text_buf);
field_transport.encode_text(text_buf);
field_priority.encode_text(text_buf);
field_connection__address.encode_text(text_buf);
field_connection__port.encode_text(text_buf);
field_candidate__type.encode_text(text_buf);
field_rel__address.encode_text(text_buf);
field_rel__port.encode_text(text_buf);
field_extensions.encode_text(text_buf);
}

void SDP__attribute__candidate::decode_text(Text_Buf& text_buf)
{
field_foundation.decode_text(text_buf);
field_component__id.decode_text(text_buf);
field_transport.decode_text(text_buf);
field_priority.decode_text(text_buf);
field_connection__address.decode_text(text_buf);
field_connection__port.decode_text(text_buf);
field_candidate__type.decode_text(text_buf);
field_rel__address.decode_text(text_buf);
field_rel__port.decode_text(text_buf);
field_extensions.decode_text(text_buf);
}

void SDP__attribute__candidate::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__candidate::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__candidate::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_foundation.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_component__id.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_transport.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_priority.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_connection__address.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_connection__port.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_candidate__type.TEXT_encode(SDP__attribute__candidate_candidate__type_descr_,p_buf);
 need_separator=TRUE;
  if(field_rel__address.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_rel__address().TEXT_encode(SDP__attribute__candidate_rel__address_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_rel__port.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_rel__port().TEXT_encode(SDP__attribute__candidate_rel__port_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_extensions.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_extensions().TEXT_encode(SDP__extension__list_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__candidate::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_rel__address=OMIT_VALUE;
    field_rel__port=OMIT_VALUE;
    field_extensions=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_foundation.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'foundation' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_component__id.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'component__id' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_transport.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'transport' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_priority.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'priority' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_connection__address.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'connection__address' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_connection__port.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'connection__port' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_candidate__type.TEXT_decode(SDP__attribute__candidate_candidate__type_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'candidate__type' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_rel__address().TEXT_decode(SDP__attribute__candidate_rel__address_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_rel__address=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_rel__address=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_rel__port().TEXT_decode(SDP__attribute__candidate_rel__port_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_rel__port=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_rel__port=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_extensions().TEXT_decode(SDP__extension__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_extensions=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__candidate_template::single_value_struct {
CHARSTRING_template field_foundation;
INTEGER_template field_component__id;
CHARSTRING_template field_transport;
INTEGER_template field_priority;
CHARSTRING_template field_connection__address;
INTEGER_template field_connection__port;
CHARSTRING_template field_candidate__type;
CHARSTRING_template field_rel__address;
CHARSTRING_template field_rel__port;
SDP__extension__list_template field_extensions;
};

void SDP__attribute__candidate_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_foundation = ANY_VALUE;
single_value->field_component__id = ANY_VALUE;
single_value->field_transport = ANY_VALUE;
single_value->field_priority = ANY_VALUE;
single_value->field_connection__address = ANY_VALUE;
single_value->field_connection__port = ANY_VALUE;
single_value->field_candidate__type = ANY_VALUE;
single_value->field_rel__address = ANY_OR_OMIT;
single_value->field_rel__port = ANY_OR_OMIT;
single_value->field_extensions = ANY_OR_OMIT;
}
}
}

void SDP__attribute__candidate_template::copy_value(const SDP__attribute__candidate& other_value)
{
single_value = new single_value_struct;
if (other_value.foundation().is_bound()) {
  single_value->field_foundation = other_value.foundation();
} else {
  single_value->field_foundation.clean_up();
}
if (other_value.component__id().is_bound()) {
  single_value->field_component__id = other_value.component__id();
} else {
  single_value->field_component__id.clean_up();
}
if (other_value.transport().is_bound()) {
  single_value->field_transport = other_value.transport();
} else {
  single_value->field_transport.clean_up();
}
if (other_value.priority().is_bound()) {
  single_value->field_priority = other_value.priority();
} else {
  single_value->field_priority.clean_up();
}
if (other_value.connection__address().is_bound()) {
  single_value->field_connection__address = other_value.connection__address();
} else {
  single_value->field_connection__address.clean_up();
}
if (other_value.connection__port().is_bound()) {
  single_value->field_connection__port = other_value.connection__port();
} else {
  single_value->field_connection__port.clean_up();
}
if (other_value.candidate__type().is_bound()) {
  single_value->field_candidate__type = other_value.candidate__type();
} else {
  single_value->field_candidate__type.clean_up();
}
if (other_value.rel__address().is_bound()) {
  if (other_value.rel__address().ispresent()) single_value->field_rel__address = other_value.rel__address()();
  else single_value->field_rel__address = OMIT_VALUE;
} else {
  single_value->field_rel__address.clean_up();
}
if (other_value.rel__port().is_bound()) {
  if (other_value.rel__port().ispresent()) single_value->field_rel__port = other_value.rel__port()();
  else single_value->field_rel__port = OMIT_VALUE;
} else {
  single_value->field_rel__port.clean_up();
}
if (other_value.extensions().is_bound()) {
  if (other_value.extensions().ispresent()) single_value->field_extensions = other_value.extensions()();
  else single_value->field_extensions = OMIT_VALUE;
} else {
  single_value->field_extensions.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__candidate_template::copy_template(const SDP__attribute__candidate_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.foundation().get_selection()) {
single_value->field_foundation = other_value.foundation();
} else {
single_value->field_foundation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.component__id().get_selection()) {
single_value->field_component__id = other_value.component__id();
} else {
single_value->field_component__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transport().get_selection()) {
single_value->field_transport = other_value.transport();
} else {
single_value->field_transport.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.priority().get_selection()) {
single_value->field_priority = other_value.priority();
} else {
single_value->field_priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connection__address().get_selection()) {
single_value->field_connection__address = other_value.connection__address();
} else {
single_value->field_connection__address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connection__port().get_selection()) {
single_value->field_connection__port = other_value.connection__port();
} else {
single_value->field_connection__port.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.candidate__type().get_selection()) {
single_value->field_candidate__type = other_value.candidate__type();
} else {
single_value->field_candidate__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rel__address().get_selection()) {
single_value->field_rel__address = other_value.rel__address();
} else {
single_value->field_rel__address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rel__port().get_selection()) {
single_value->field_rel__port = other_value.rel__port();
} else {
single_value->field_rel__port.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensions().get_selection()) {
single_value->field_extensions = other_value.extensions();
} else {
single_value->field_extensions.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__candidate_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__candidate_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_candidate.");
break;
}
set_selection(other_value);
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template()
{
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(const SDP__attribute__candidate& other_value)
{
copy_value(other_value);
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(const OPTIONAL<SDP__attribute__candidate>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_candidate from an unbound optional field.");
}
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(SDP__attribute__candidate_template* p_precondition, SDP__attribute__candidate_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(Dynamic_Match_Interface<SDP__attribute__candidate>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__candidate>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__candidate_template::SDP__attribute__candidate_template(const SDP__attribute__candidate_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__candidate_template::~SDP__attribute__candidate_template()
{
clean_up();
}

SDP__attribute__candidate_template& SDP__attribute__candidate_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__candidate_template& SDP__attribute__candidate_template::operator=(const SDP__attribute__candidate& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__candidate_template& SDP__attribute__candidate_template::operator=(const OPTIONAL<SDP__attribute__candidate>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_candidate.");
}
return *this;
}

SDP__attribute__candidate_template& SDP__attribute__candidate_template::operator=(const SDP__attribute__candidate_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__candidate_template::match(const SDP__attribute__candidate& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.foundation().is_bound()) return FALSE;
if(!single_value->field_foundation.match(other_value.foundation(), legacy))return FALSE;
if(!other_value.component__id().is_bound()) return FALSE;
if(!single_value->field_component__id.match(other_value.component__id(), legacy))return FALSE;
if(!other_value.transport().is_bound()) return FALSE;
if(!single_value->field_transport.match(other_value.transport(), legacy))return FALSE;
if(!other_value.priority().is_bound()) return FALSE;
if(!single_value->field_priority.match(other_value.priority(), legacy))return FALSE;
if(!other_value.connection__address().is_bound()) return FALSE;
if(!single_value->field_connection__address.match(other_value.connection__address(), legacy))return FALSE;
if(!other_value.connection__port().is_bound()) return FALSE;
if(!single_value->field_connection__port.match(other_value.connection__port(), legacy))return FALSE;
if(!other_value.candidate__type().is_bound()) return FALSE;
if(!single_value->field_candidate__type.match(other_value.candidate__type(), legacy))return FALSE;
if(!other_value.rel__address().is_bound()) return FALSE;
if((other_value.rel__address().ispresent() ? !single_value->field_rel__address.match((const CHARSTRING&)other_value.rel__address(), legacy) : !single_value->field_rel__address.match_omit(legacy)))return FALSE;
if(!other_value.rel__port().is_bound()) return FALSE;
if((other_value.rel__port().ispresent() ? !single_value->field_rel__port.match((const CHARSTRING&)other_value.rel__port(), legacy) : !single_value->field_rel__port.match_omit(legacy)))return FALSE;
if(!other_value.extensions().is_bound()) return FALSE;
if((other_value.extensions().ispresent() ? !single_value->field_extensions.match((const SDP__extension__list&)other_value.extensions(), legacy) : !single_value->field_extensions.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_candidate.");
}
return FALSE;
}

boolean SDP__attribute__candidate_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_foundation.is_bound()
 || single_value->field_component__id.is_bound()
 || single_value->field_transport.is_bound()
 || single_value->field_priority.is_bound()
 || single_value->field_connection__address.is_bound()
 || single_value->field_connection__port.is_bound()
 || single_value->field_candidate__type.is_bound()
 || (single_value->field_rel__address.is_omit() || single_value->field_rel__address.is_bound())
 || (single_value->field_rel__port.is_omit() || single_value->field_rel__port.is_bound())
 || (single_value->field_extensions.is_omit() || single_value->field_extensions.is_bound());
}

boolean SDP__attribute__candidate_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_foundation.is_value()
 && single_value->field_component__id.is_value()
 && single_value->field_transport.is_value()
 && single_value->field_priority.is_value()
 && single_value->field_connection__address.is_value()
 && single_value->field_connection__port.is_value()
 && single_value->field_candidate__type.is_value()
 && (single_value->field_rel__address.is_omit() || single_value->field_rel__address.is_value())
 && (single_value->field_rel__port.is_omit() || single_value->field_rel__port.is_value())
 && (single_value->field_extensions.is_omit() || single_value->field_extensions.is_value());
}

void SDP__attribute__candidate_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__candidate SDP__attribute__candidate_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
SDP__attribute__candidate ret_val;
if (single_value->field_foundation.is_bound()) {
ret_val.foundation() = single_value->field_foundation.valueof();
}
if (single_value->field_component__id.is_bound()) {
ret_val.component__id() = single_value->field_component__id.valueof();
}
if (single_value->field_transport.is_bound()) {
ret_val.transport() = single_value->field_transport.valueof();
}
if (single_value->field_priority.is_bound()) {
ret_val.priority() = single_value->field_priority.valueof();
}
if (single_value->field_connection__address.is_bound()) {
ret_val.connection__address() = single_value->field_connection__address.valueof();
}
if (single_value->field_connection__port.is_bound()) {
ret_val.connection__port() = single_value->field_connection__port.valueof();
}
if (single_value->field_candidate__type.is_bound()) {
ret_val.candidate__type() = single_value->field_candidate__type.valueof();
}
if (single_value->field_rel__address.is_omit()) ret_val.rel__address() = OMIT_VALUE;
else if (single_value->field_rel__address.is_bound()) {
ret_val.rel__address() = single_value->field_rel__address.valueof();
}
if (single_value->field_rel__port.is_omit()) ret_val.rel__port() = OMIT_VALUE;
else if (single_value->field_rel__port.is_bound()) {
ret_val.rel__port() = single_value->field_rel__port.valueof();
}
if (single_value->field_extensions.is_omit()) ret_val.extensions() = OMIT_VALUE;
else if (single_value->field_extensions.is_bound()) {
ret_val.extensions() = single_value->field_extensions.valueof();
}
return ret_val;
}

void SDP__attribute__candidate_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_candidate.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__candidate_template[list_length];
}

SDP__attribute__candidate_template& SDP__attribute__candidate_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_candidate.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_candidate.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__candidate_template::foundation()
{
set_specific();
return single_value->field_foundation;
}

const CHARSTRING_template& SDP__attribute__candidate_template::foundation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field foundation of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_foundation;
}

INTEGER_template& SDP__attribute__candidate_template::component__id()
{
set_specific();
return single_value->field_component__id;
}

const INTEGER_template& SDP__attribute__candidate_template::component__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field component_id of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_component__id;
}

CHARSTRING_template& SDP__attribute__candidate_template::transport()
{
set_specific();
return single_value->field_transport;
}

const CHARSTRING_template& SDP__attribute__candidate_template::transport() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transport of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_transport;
}

INTEGER_template& SDP__attribute__candidate_template::priority()
{
set_specific();
return single_value->field_priority;
}

const INTEGER_template& SDP__attribute__candidate_template::priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field priority of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_priority;
}

CHARSTRING_template& SDP__attribute__candidate_template::connection__address()
{
set_specific();
return single_value->field_connection__address;
}

const CHARSTRING_template& SDP__attribute__candidate_template::connection__address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connection_address of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_connection__address;
}

INTEGER_template& SDP__attribute__candidate_template::connection__port()
{
set_specific();
return single_value->field_connection__port;
}

const INTEGER_template& SDP__attribute__candidate_template::connection__port() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connection_port of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_connection__port;
}

CHARSTRING_template& SDP__attribute__candidate_template::candidate__type()
{
set_specific();
return single_value->field_candidate__type;
}

const CHARSTRING_template& SDP__attribute__candidate_template::candidate__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field candidate_type of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_candidate__type;
}

CHARSTRING_template& SDP__attribute__candidate_template::rel__address()
{
set_specific();
return single_value->field_rel__address;
}

const CHARSTRING_template& SDP__attribute__candidate_template::rel__address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rel_address of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_rel__address;
}

CHARSTRING_template& SDP__attribute__candidate_template::rel__port()
{
set_specific();
return single_value->field_rel__port;
}

const CHARSTRING_template& SDP__attribute__candidate_template::rel__port() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rel_port of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_rel__port;
}

SDP__extension__list_template& SDP__attribute__candidate_template::extensions()
{
set_specific();
return single_value->field_extensions;
}

const SDP__extension__list_template& SDP__attribute__candidate_template::extensions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensions of a non-specific template of type @SDP_Types.SDP_attribute_candidate.");
return single_value->field_extensions;
}

int SDP__attribute__candidate_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 7;
      if (single_value->field_rel__address.is_present()) ret_val++;
      if (single_value->field_rel__port.is_present()) ret_val++;
      if (single_value->field_extensions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_candidate containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_candidate.");
  }
  return 0;
}

void SDP__attribute__candidate_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ foundation := ");
single_value->field_foundation.log();
TTCN_Logger::log_event_str(", component_id := ");
single_value->field_component__id.log();
TTCN_Logger::log_event_str(", transport := ");
single_value->field_transport.log();
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log();
TTCN_Logger::log_event_str(", connection_address := ");
single_value->field_connection__address.log();
TTCN_Logger::log_event_str(", connection_port := ");
single_value->field_connection__port.log();
TTCN_Logger::log_event_str(", candidate_type := ");
single_value->field_candidate__type.log();
TTCN_Logger::log_event_str(", rel_address := ");
single_value->field_rel__address.log();
TTCN_Logger::log_event_str(", rel_port := ");
single_value->field_rel__port.log();
TTCN_Logger::log_event_str(", extensions := ");
single_value->field_extensions.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__candidate_template::log_match(const SDP__attribute__candidate& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_foundation.match(match_value.foundation(), legacy)){
TTCN_Logger::log_logmatch_info(".foundation");
single_value->field_foundation.log_match(match_value.foundation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_component__id.match(match_value.component__id(), legacy)){
TTCN_Logger::log_logmatch_info(".component_id");
single_value->field_component__id.log_match(match_value.component__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_transport.match(match_value.transport(), legacy)){
TTCN_Logger::log_logmatch_info(".transport");
single_value->field_transport.log_match(match_value.transport(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_priority.match(match_value.priority(), legacy)){
TTCN_Logger::log_logmatch_info(".priority");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_connection__address.match(match_value.connection__address(), legacy)){
TTCN_Logger::log_logmatch_info(".connection_address");
single_value->field_connection__address.log_match(match_value.connection__address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_connection__port.match(match_value.connection__port(), legacy)){
TTCN_Logger::log_logmatch_info(".connection_port");
single_value->field_connection__port.log_match(match_value.connection__port(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_candidate__type.match(match_value.candidate__type(), legacy)){
TTCN_Logger::log_logmatch_info(".candidate_type");
single_value->field_candidate__type.log_match(match_value.candidate__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.rel__address().ispresent()){
if(!single_value->field_rel__address.match(match_value.rel__address(), legacy)){
TTCN_Logger::log_logmatch_info(".rel_address");
single_value->field_rel__address.log_match(match_value.rel__address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rel__address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rel_address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rel__address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.rel__port().ispresent()){
if(!single_value->field_rel__port.match(match_value.rel__port(), legacy)){
TTCN_Logger::log_logmatch_info(".rel_port");
single_value->field_rel__port.log_match(match_value.rel__port(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rel__port.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rel_port := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rel__port.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensions().ispresent()){
if(!single_value->field_extensions.match(match_value.extensions(), legacy)){
TTCN_Logger::log_logmatch_info(".extensions");
single_value->field_extensions.log_match(match_value.extensions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ foundation := ");
single_value->field_foundation.log_match(match_value.foundation(), legacy);
TTCN_Logger::log_event_str(", component_id := ");
single_value->field_component__id.log_match(match_value.component__id(), legacy);
TTCN_Logger::log_event_str(", transport := ");
single_value->field_transport.log_match(match_value.transport(), legacy);
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::log_event_str(", connection_address := ");
single_value->field_connection__address.log_match(match_value.connection__address(), legacy);
TTCN_Logger::log_event_str(", connection_port := ");
single_value->field_connection__port.log_match(match_value.connection__port(), legacy);
TTCN_Logger::log_event_str(", candidate_type := ");
single_value->field_candidate__type.log_match(match_value.candidate__type(), legacy);
TTCN_Logger::log_event_str(", rel_address := ");
if (match_value.rel__address().ispresent()) {
single_value->field_rel__address.log_match(match_value.rel__address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rel__address.log();
if (single_value->field_rel__address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rel_port := ");
if (match_value.rel__port().ispresent()) {
single_value->field_rel__port.log_match(match_value.rel__port(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rel__port.log();
if (single_value->field_rel__port.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensions := ");
if (match_value.extensions().ispresent()) {
single_value->field_extensions.log_match(match_value.extensions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensions.log();
if (single_value->field_extensions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__candidate_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (foundation().is_bound()) foundation().set_implicit_omit();
if (component__id().is_bound()) component__id().set_implicit_omit();
if (transport().is_bound()) transport().set_implicit_omit();
if (priority().is_bound()) priority().set_implicit_omit();
if (connection__address().is_bound()) connection__address().set_implicit_omit();
if (connection__port().is_bound()) connection__port().set_implicit_omit();
if (candidate__type().is_bound()) candidate__type().set_implicit_omit();
if (!rel__address().is_bound()) rel__address() = OMIT_VALUE;
else rel__address().set_implicit_omit();
if (!rel__port().is_bound()) rel__port() = OMIT_VALUE;
else rel__port().set_implicit_omit();
if (!extensions().is_bound()) extensions() = OMIT_VALUE;
else extensions().set_implicit_omit();
}

void SDP__attribute__candidate_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_foundation.encode_text(text_buf);
single_value->field_component__id.encode_text(text_buf);
single_value->field_transport.encode_text(text_buf);
single_value->field_priority.encode_text(text_buf);
single_value->field_connection__address.encode_text(text_buf);
single_value->field_connection__port.encode_text(text_buf);
single_value->field_candidate__type.encode_text(text_buf);
single_value->field_rel__address.encode_text(text_buf);
single_value->field_rel__port.encode_text(text_buf);
single_value->field_extensions.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_candidate.");
}
}

void SDP__attribute__candidate_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_foundation.decode_text(text_buf);
single_value->field_component__id.decode_text(text_buf);
single_value->field_transport.decode_text(text_buf);
single_value->field_priority.decode_text(text_buf);
single_value->field_connection__address.decode_text(text_buf);
single_value->field_connection__port.decode_text(text_buf);
single_value->field_candidate__type.decode_text(text_buf);
single_value->field_rel__address.decode_text(text_buf);
single_value->field_rel__port.decode_text(text_buf);
single_value->field_extensions.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_candidate.");
}
}

void SDP__attribute__candidate_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__candidate_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_candidate has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) foundation().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) component__id().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) connection__address().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) connection__port().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) candidate__type().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) rel__address().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) rel__port().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) extensions().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "foundation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          foundation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "component_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          component__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_port")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__port().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "candidate_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          candidate__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel_port")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel__port().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__candidate_template* precondition = new SDP__attribute__candidate_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__candidate_template* implied_template = new SDP__attribute__candidate_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__candidate_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_candidate");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__candidate_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_foundation.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_component__id.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_transport.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_priority.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_connection__address.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_connection__port.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_candidate__type.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_rel__address.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_rel__port.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
single_value->field_extensions.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_candidate");
}

boolean SDP__attribute__candidate_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__candidate_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__extension SDP__extension__list::UNBOUND_ELEM;
boolean SDP__extension__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__extension__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_extension_list.");
if (((const SDP__extension__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_extension_list.");
if (((const SDP__extension__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__extension__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__extension__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__extension__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__extension__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__extension__list::SDP__extension__list()
{
val_ptr = NULL;
}

SDP__extension__list::SDP__extension__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__extension__list::SDP__extension__list(const SDP__extension__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_extension_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__extension__list::~SDP__extension__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__extension__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__extension__list& SDP__extension__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__extension__list& SDP__extension__list::operator=(const SDP__extension__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_extension_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__extension__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_extension_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__extension__list::operator==(const SDP__extension__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_extension_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_extension_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__extension& SDP__extension__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_extension_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__extension**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__extension(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__extension;
}
return *val_ptr->value_elements[index_value];
}

SDP__extension& SDP__extension__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_extension_list.");
return (*this)[(int)index_value];
}

const SDP__extension& SDP__extension__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_extension_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_extension_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_extension_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__extension& SDP__extension__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_extension_list.");
return (*this)[(int)index_value];
}

SDP__extension__list SDP__extension__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__extension__list SDP__extension__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__extension__list SDP__extension__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__extension__list SDP__extension__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_extension_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__extension__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__extension(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__extension__list SDP__extension__list::operator+(const SDP__extension__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_extension_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__extension__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__extension(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__extension(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__extension__list SDP__extension__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_extension_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_extension_list","element");
SDP__extension__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__extension(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__extension__list SDP__extension__list::replace(int index, int len, const SDP__extension__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_extension_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_extension_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_extension_list","element");
SDP__extension__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__extension(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__extension(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__extension(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__extension__list SDP__extension__list::replace(int index, int len, const SDP__extension__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__extension__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_extension_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__extension**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__extension(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__extension**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_extension_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__extension**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__extension__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__extension__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_extension_list.");
return val_ptr->n_elements;
}

int SDP__extension__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_extension_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__extension__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__extension__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__extension__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_extension_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_extension_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__extension__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_extension_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__extension__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_extension_list.");
val_ptr->value_elements = (SDP__extension**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__extension;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__extension__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__extension__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__extension__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__extension__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__extension *val=new SDP__extension;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__extension**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__extension__list_template::copy_value(const SDP__extension__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_extension_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__extension_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__extension_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__extension_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__extension__list_template::copy_template(const SDP__extension__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__extension_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__extension_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__extension_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__extension__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__extension_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__extension__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__extension__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_extension_list.");
break;
}
set_selection(other_value);
}

boolean SDP__extension__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__extension__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__extension__list*)value_ptr)[value_index], legacy);
else return ((const SDP__extension__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__extension__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__extension__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__extension__list*)value_ptr)[value_index], legacy);
else return ((const SDP__extension__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__extension__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__extension__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__extension__list*)value_ptr)[index_value].log();
} else {
((const SDP__extension__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__extension__list*)value_ptr)[index_value], legacy);
}
}

SDP__extension__list_template::SDP__extension__list_template()
{
}

SDP__extension__list_template::SDP__extension__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__extension__list_template::SDP__extension__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__extension__list_template::SDP__extension__list_template(const SDP__extension__list& other_value)
{
copy_value(other_value);
}

SDP__extension__list_template::SDP__extension__list_template(const OPTIONAL<SDP__extension__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__extension__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_extension_list from an unbound optional field.");
}
}

SDP__extension__list_template::SDP__extension__list_template(SDP__extension__list_template* p_precondition, SDP__extension__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__extension__list_template::SDP__extension__list_template(Dynamic_Match_Interface<SDP__extension__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__extension__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__extension__list_template::SDP__extension__list_template(const SDP__extension__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__extension__list_template::~SDP__extension__list_template()
{
clean_up();
}

void SDP__extension__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__extension__list_template& SDP__extension__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__extension__list_template& SDP__extension__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__extension__list_template& SDP__extension__list_template::operator=(const SDP__extension__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__extension__list_template& SDP__extension__list_template::operator=(const OPTIONAL<SDP__extension__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__extension__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_extension_list.");
}
return *this;
}

SDP__extension__list_template& SDP__extension__list_template::operator=(const SDP__extension__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__extension_template& SDP__extension__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_extension_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_extension_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__extension_template& SDP__extension__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_extension_list.");
return (*this)[(int)index_value];
}

const SDP__extension_template& SDP__extension__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_extension_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_extension_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_extension_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__extension_template& SDP__extension__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_extension_list.");
return (*this)[(int)index_value];
}

void SDP__extension__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_extension_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__extension_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__extension_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__extension_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__extension_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__extension__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__extension__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_extension_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_extension_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_extension_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_extension_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_extension_list");
}

boolean SDP__extension__list_template::match(const SDP__extension__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_extension_list.");
}
return FALSE;
}

boolean SDP__extension__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__extension__list SDP__extension__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_extension_list.");
SDP__extension__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__extension__list SDP__extension__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__extension__list SDP__extension__list_template::replace(int index, int len, const SDP__extension__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__extension__list SDP__extension__list_template::replace(int index, int len, const SDP__extension__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__extension__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__extension__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__extension_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_extension_list.");
}
set_selection(template_type);
}

SDP__extension__list_template& SDP__extension__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_extension_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_extension_list.");
return value_list.list_value[list_index];
}

SDP__extension_template& SDP__extension__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_extension_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_extension_list.");
return value_set.set_items[set_index];
}

void SDP__extension__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__extension__list_template::log_match(const SDP__extension__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__extension__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_extension_list.");
}
}

void SDP__extension__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_extension_list.");
single_value.value_elements = (SDP__extension_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__extension_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__extension__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__extension_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_extension_list.");
}
}

boolean SDP__extension__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__extension__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__extension__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__extension__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__extension__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__extension__list_template* precondition = new SDP__extension__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__extension__list_template* implied_template = new SDP__extension__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__extension__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_extension_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__extension__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_extension_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_extension_list");
}

boolean SDP__extension__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__extension::SDP__extension()
{
}

SDP__extension::SDP__extension(const CHARSTRING& par_extension__attr__name,
    const CHARSTRING& par_extension__attr__value)
  :   field_extension__attr__name(par_extension__attr__name),
  field_extension__attr__value(par_extension__attr__value)
{
}

SDP__extension::SDP__extension(const SDP__extension& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_extension.");
if (other_value.extension__attr__name().is_bound()) field_extension__attr__name = other_value.extension__attr__name();
else field_extension__attr__name.clean_up();
if (other_value.extension__attr__value().is_bound()) field_extension__attr__value = other_value.extension__attr__value();
else field_extension__attr__value.clean_up();
}

void SDP__extension::clean_up()
{
field_extension__attr__name.clean_up();
field_extension__attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__extension::get_descriptor() const { return &SDP__extension_descr_; }
SDP__extension& SDP__extension::operator=(const SDP__extension& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_extension.");
  if (other_value.extension__attr__name().is_bound()) field_extension__attr__name = other_value.extension__attr__name();
  else field_extension__attr__name.clean_up();
  if (other_value.extension__attr__value().is_bound()) field_extension__attr__value = other_value.extension__attr__value();
  else field_extension__attr__value.clean_up();
}
return *this;
}

boolean SDP__extension::operator==(const SDP__extension& other_value) const
{
return field_extension__attr__name==other_value.field_extension__attr__name
  && field_extension__attr__value==other_value.field_extension__attr__value;
}

boolean SDP__extension::is_bound() const
{
return (field_extension__attr__name.is_bound())
  || (field_extension__attr__value.is_bound());
}
boolean SDP__extension::is_value() const
{
return field_extension__attr__name.is_value()
  && field_extension__attr__value.is_value();
}
void SDP__extension::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extension_attr_name := ");
field_extension__attr__name.log();
TTCN_Logger::log_event_str(", extension_attr_value := ");
field_extension__attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__extension::set_implicit_omit()
{
if (extension__attr__name().is_bound()) extension__attr__name().set_implicit_omit();
if (extension__attr__value().is_bound()) extension__attr__value().set_implicit_omit();
}

void SDP__extension::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extension__attr__name().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extension__attr__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extension_attr_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extension__attr__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extension_attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extension__attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_extension");
  }
}

void SDP__extension::encode_text(Text_Buf& text_buf) const
{
field_extension__attr__name.encode_text(text_buf);
field_extension__attr__value.encode_text(text_buf);
}

void SDP__extension::decode_text(Text_Buf& text_buf)
{
field_extension__attr__name.decode_text(text_buf);
field_extension__attr__value.decode_text(text_buf);
}

void SDP__extension::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__extension::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__extension::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_extension__attr__name.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_extension__attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__extension::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_extension__attr__name.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'extension__attr__name' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_extension__attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'extension__attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__extension_template::single_value_struct {
CHARSTRING_template field_extension__attr__name;
CHARSTRING_template field_extension__attr__value;
};

void SDP__extension_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extension__attr__name = ANY_VALUE;
single_value->field_extension__attr__value = ANY_VALUE;
}
}
}

void SDP__extension_template::copy_value(const SDP__extension& other_value)
{
single_value = new single_value_struct;
if (other_value.extension__attr__name().is_bound()) {
  single_value->field_extension__attr__name = other_value.extension__attr__name();
} else {
  single_value->field_extension__attr__name.clean_up();
}
if (other_value.extension__attr__value().is_bound()) {
  single_value->field_extension__attr__value = other_value.extension__attr__value();
} else {
  single_value->field_extension__attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__extension_template::copy_template(const SDP__extension_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extension__attr__name().get_selection()) {
single_value->field_extension__attr__name = other_value.extension__attr__name();
} else {
single_value->field_extension__attr__name.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extension__attr__value().get_selection()) {
single_value->field_extension__attr__value = other_value.extension__attr__value();
} else {
single_value->field_extension__attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__extension_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__extension_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_extension.");
break;
}
set_selection(other_value);
}

SDP__extension_template::SDP__extension_template()
{
}

SDP__extension_template::SDP__extension_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__extension_template::SDP__extension_template(const SDP__extension& other_value)
{
copy_value(other_value);
}

SDP__extension_template::SDP__extension_template(const OPTIONAL<SDP__extension>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_extension from an unbound optional field.");
}
}

SDP__extension_template::SDP__extension_template(SDP__extension_template* p_precondition, SDP__extension_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__extension_template::SDP__extension_template(Dynamic_Match_Interface<SDP__extension>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__extension>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__extension_template::SDP__extension_template(const SDP__extension_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__extension_template::~SDP__extension_template()
{
clean_up();
}

SDP__extension_template& SDP__extension_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__extension_template& SDP__extension_template::operator=(const SDP__extension& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__extension_template& SDP__extension_template::operator=(const OPTIONAL<SDP__extension>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_extension.");
}
return *this;
}

SDP__extension_template& SDP__extension_template::operator=(const SDP__extension_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__extension_template::match(const SDP__extension& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extension__attr__name().is_bound()) return FALSE;
if(!single_value->field_extension__attr__name.match(other_value.extension__attr__name(), legacy))return FALSE;
if(!other_value.extension__attr__value().is_bound()) return FALSE;
if(!single_value->field_extension__attr__value.match(other_value.extension__attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_extension.");
}
return FALSE;
}

boolean SDP__extension_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_extension__attr__name.is_bound()
 || single_value->field_extension__attr__value.is_bound();
}

boolean SDP__extension_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_extension__attr__name.is_value()
 && single_value->field_extension__attr__value.is_value();
}

void SDP__extension_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__extension SDP__extension_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_extension.");
SDP__extension ret_val;
if (single_value->field_extension__attr__name.is_bound()) {
ret_val.extension__attr__name() = single_value->field_extension__attr__name.valueof();
}
if (single_value->field_extension__attr__value.is_bound()) {
ret_val.extension__attr__value() = single_value->field_extension__attr__value.valueof();
}
return ret_val;
}

void SDP__extension_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_extension.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__extension_template[list_length];
}

SDP__extension_template& SDP__extension_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_extension.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_extension.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__extension_template::extension__attr__name()
{
set_specific();
return single_value->field_extension__attr__name;
}

const CHARSTRING_template& SDP__extension_template::extension__attr__name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extension_attr_name of a non-specific template of type @SDP_Types.SDP_extension.");
return single_value->field_extension__attr__name;
}

CHARSTRING_template& SDP__extension_template::extension__attr__value()
{
set_specific();
return single_value->field_extension__attr__value;
}

const CHARSTRING_template& SDP__extension_template::extension__attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extension_attr_value of a non-specific template of type @SDP_Types.SDP_extension.");
return single_value->field_extension__attr__value;
}

int SDP__extension_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_extension containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_extension.");
  }
  return 0;
}

void SDP__extension_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extension_attr_name := ");
single_value->field_extension__attr__name.log();
TTCN_Logger::log_event_str(", extension_attr_value := ");
single_value->field_extension__attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__extension_template::log_match(const SDP__extension& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_extension__attr__name.match(match_value.extension__attr__name(), legacy)){
TTCN_Logger::log_logmatch_info(".extension_attr_name");
single_value->field_extension__attr__name.log_match(match_value.extension__attr__name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extension__attr__value.match(match_value.extension__attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".extension_attr_value");
single_value->field_extension__attr__value.log_match(match_value.extension__attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extension_attr_name := ");
single_value->field_extension__attr__name.log_match(match_value.extension__attr__name(), legacy);
TTCN_Logger::log_event_str(", extension_attr_value := ");
single_value->field_extension__attr__value.log_match(match_value.extension__attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__extension_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (extension__attr__name().is_bound()) extension__attr__name().set_implicit_omit();
if (extension__attr__value().is_bound()) extension__attr__value().set_implicit_omit();
}

void SDP__extension_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extension__attr__name.encode_text(text_buf);
single_value->field_extension__attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_extension.");
}
}

void SDP__extension_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extension__attr__name.decode_text(text_buf);
single_value->field_extension__attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_extension.");
}
}

void SDP__extension_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__extension_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extension__attr__name().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extension__attr__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extension_attr_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extension__attr__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extension_attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extension__attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__extension_template* precondition = new SDP__extension_template;
    precondition->set_param(*param.get_elem(0));
    SDP__extension_template* implied_template = new SDP__extension_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__extension_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_extension");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__extension_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extension__attr__name.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_extension");
single_value->field_extension__attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_extension");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_extension");
}

boolean SDP__extension_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__extension_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__ice__lite::SDP__attribute__ice__lite()
{
bound_flag = FALSE;
}

SDP__attribute__ice__lite::SDP__attribute__ice__lite(null_type)
{
bound_flag = TRUE;
}

SDP__attribute__ice__lite::SDP__attribute__ice__lite(const SDP__attribute__ice__lite& other_value)
{
other_value.must_bound("Copying an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
bound_flag = TRUE;
}

SDP__attribute__ice__lite& SDP__attribute__ice__lite::operator=(null_type)
{
bound_flag = TRUE;
return *this;
}

SDP__attribute__ice__lite& SDP__attribute__ice__lite::operator=(const SDP__attribute__ice__lite& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
bound_flag = TRUE;
return *this;
}

boolean SDP__attribute__ice__lite::operator==(null_type) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
return TRUE;
}

boolean SDP__attribute__ice__lite::operator==(const SDP__attribute__ice__lite& other_value) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
other_value.must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
return TRUE;
}

void SDP__attribute__ice__lite::log() const
{
if (bound_flag) TTCN_Logger::log_event_str("{ }");
else TTCN_Logger::log_event_unbound();
}

void SDP__attribute__ice__lite::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "empty record/set value (i.e. { })");
  if (param.get_type()!=Module_Param::MP_Value_List || param.get_size()>0) {
    param.type_error("empty record/set value (i.e. { })", "@SDP_Types.SDP_attribute_ice_lite");
  }
  bound_flag = TRUE;
}

void SDP__attribute__ice__lite::encode_text(Text_Buf& /*text_buf*/) const
{
must_bound("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
}

void SDP__attribute__ice__lite::decode_text(Text_Buf& /*text_buf*/)
{
bound_flag = TRUE;
}

void SDP__attribute__ice__lite::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__ice__lite::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__ice__lite::TEXT_encode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(!bound_flag) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__ice__lite::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  bound_flag = TRUE;
  int decoded_length=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
void SDP__attribute__ice__lite_template::copy_template(const SDP__attribute__ice__lite_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__ice__lite_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__ice__lite_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__ice__lite_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_lite.");
break;
}
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template()
{
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(null_type)
 : Base_Template(SPECIFIC_VALUE)
{
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(const SDP__attribute__ice__lite& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound value of type @SDP_Types.SDP_attribute_ice_lite.");
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(const OPTIONAL<SDP__attribute__ice__lite>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_ice_lite from an unbound optional field.");
}
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(SDP__attribute__ice__lite_template* p_precondition, SDP__attribute__ice__lite_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(Dynamic_Match_Interface<SDP__attribute__ice__lite>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__ice__lite>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__ice__lite_template::SDP__attribute__ice__lite_template(const SDP__attribute__ice__lite_template& other_value)
: Base_Template(){
copy_template(other_value);
}

SDP__attribute__ice__lite_template::~SDP__attribute__ice__lite_template()
{
clean_up();
}

void SDP__attribute__ice__lite_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::operator=(const SDP__attribute__ice__lite& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_lite to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::operator=(const OPTIONAL<SDP__attribute__ice__lite>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_ice_lite.");
}
return *this;
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::operator=(const SDP__attribute__ice__lite_template& other_value)
{
if (&other_value != this) {
clean_up();
set_selection(other_value);
}
return *this;
}

boolean SDP__attribute__ice__lite_template::match(null_type other_value,boolean) const
{
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
return TRUE;
case OMIT_VALUE:
return FALSE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_lite.");
}
return FALSE;
}

boolean SDP__attribute__ice__lite_template::match(const SDP__attribute__ice__lite& other_value, boolean) const
{
if (!other_value.is_bound()) return FALSE;
return match(NULL_VALUE);
}

SDP__attribute__ice__lite SDP__attribute__ice__lite_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_ice_lite.");
return NULL_VALUE;
}

void SDP__attribute__ice__lite_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_ice_lite.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__ice__lite_template[list_length];
}

SDP__attribute__ice__lite_template& SDP__attribute__ice__lite_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_ice_lite.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_ice_lite.");
return value_list.list_value[list_index];
}

void SDP__attribute__ice__lite_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__ice__lite_template::log_match(const SDP__attribute__ice__lite& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void SDP__attribute__ice__lite_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_lite.");
}
}

void SDP__attribute__ice__lite_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__ice__lite_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_ice_lite.");
}
}

void SDP__attribute__ice__lite_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "empty record/set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__ice__lite_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Value_List:
    if (param.get_size()>0) param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_ice_lite");
    *this = NULL_VALUE;
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__ice__lite_template* precondition = new SDP__attribute__ice__lite_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__ice__lite_template* implied_template = new SDP__attribute__ice__lite_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__ice__lite_template(precondition, implied_template);
  } break;
  default:
    param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_ice_lite");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__ice__lite_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_ice_lite");
}

boolean SDP__attribute__ice__lite_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__ice__lite_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__ice__mismatch::SDP__attribute__ice__mismatch()
{
bound_flag = FALSE;
}

SDP__attribute__ice__mismatch::SDP__attribute__ice__mismatch(null_type)
{
bound_flag = TRUE;
}

SDP__attribute__ice__mismatch::SDP__attribute__ice__mismatch(const SDP__attribute__ice__mismatch& other_value)
{
other_value.must_bound("Copying an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
bound_flag = TRUE;
}

SDP__attribute__ice__mismatch& SDP__attribute__ice__mismatch::operator=(null_type)
{
bound_flag = TRUE;
return *this;
}

SDP__attribute__ice__mismatch& SDP__attribute__ice__mismatch::operator=(const SDP__attribute__ice__mismatch& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
bound_flag = TRUE;
return *this;
}

boolean SDP__attribute__ice__mismatch::operator==(null_type) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
return TRUE;
}

boolean SDP__attribute__ice__mismatch::operator==(const SDP__attribute__ice__mismatch& other_value) const
{
must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
other_value.must_bound("Comparison of an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
return TRUE;
}

void SDP__attribute__ice__mismatch::log() const
{
if (bound_flag) TTCN_Logger::log_event_str("{ }");
else TTCN_Logger::log_event_unbound();
}

void SDP__attribute__ice__mismatch::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "empty record/set value (i.e. { })");
  if (param.get_type()!=Module_Param::MP_Value_List || param.get_size()>0) {
    param.type_error("empty record/set value (i.e. { })", "@SDP_Types.SDP_attribute_ice_mismatch");
  }
  bound_flag = TRUE;
}

void SDP__attribute__ice__mismatch::encode_text(Text_Buf& /*text_buf*/) const
{
must_bound("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
}

void SDP__attribute__ice__mismatch::decode_text(Text_Buf& /*text_buf*/)
{
bound_flag = TRUE;
}

void SDP__attribute__ice__mismatch::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__ice__mismatch::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__ice__mismatch::TEXT_encode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(!bound_flag) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__ice__mismatch::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  bound_flag = TRUE;
  int decoded_length=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
void SDP__attribute__ice__mismatch_template::copy_template(const SDP__attribute__ice__mismatch_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__ice__mismatch_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__ice__mismatch_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__ice__mismatch_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_mismatch.");
break;
}
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template()
{
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(null_type)
 : Base_Template(SPECIFIC_VALUE)
{
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(const SDP__attribute__ice__mismatch& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch.");
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(const OPTIONAL<SDP__attribute__ice__mismatch>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_ice_mismatch from an unbound optional field.");
}
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(SDP__attribute__ice__mismatch_template* p_precondition, SDP__attribute__ice__mismatch_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(Dynamic_Match_Interface<SDP__attribute__ice__mismatch>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__ice__mismatch>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__ice__mismatch_template::SDP__attribute__ice__mismatch_template(const SDP__attribute__ice__mismatch_template& other_value)
: Base_Template(){
copy_template(other_value);
}

SDP__attribute__ice__mismatch_template::~SDP__attribute__ice__mismatch_template()
{
clean_up();
}

void SDP__attribute__ice__mismatch_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::operator=(const SDP__attribute__ice__mismatch& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_mismatch to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::operator=(const OPTIONAL<SDP__attribute__ice__mismatch>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_ice_mismatch.");
}
return *this;
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::operator=(const SDP__attribute__ice__mismatch_template& other_value)
{
if (&other_value != this) {
clean_up();
set_selection(other_value);
}
return *this;
}

boolean SDP__attribute__ice__mismatch_template::match(null_type other_value,boolean) const
{
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
return TRUE;
case OMIT_VALUE:
return FALSE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_mismatch.");
}
return FALSE;
}

boolean SDP__attribute__ice__mismatch_template::match(const SDP__attribute__ice__mismatch& other_value, boolean) const
{
if (!other_value.is_bound()) return FALSE;
return match(NULL_VALUE);
}

SDP__attribute__ice__mismatch SDP__attribute__ice__mismatch_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_ice_mismatch.");
return NULL_VALUE;
}

void SDP__attribute__ice__mismatch_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_ice_mismatch.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__ice__mismatch_template[list_length];
}

SDP__attribute__ice__mismatch_template& SDP__attribute__ice__mismatch_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_ice_mismatch.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_ice_mismatch.");
return value_list.list_value[list_index];
}

void SDP__attribute__ice__mismatch_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__ice__mismatch_template::log_match(const SDP__attribute__ice__mismatch& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void SDP__attribute__ice__mismatch_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_mismatch.");
}
}

void SDP__attribute__ice__mismatch_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__ice__mismatch_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_ice_mismatch.");
}
}

void SDP__attribute__ice__mismatch_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "empty record/set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__ice__mismatch_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Value_List:
    if (param.get_size()>0) param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_ice_mismatch");
    *this = NULL_VALUE;
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__ice__mismatch_template* precondition = new SDP__attribute__ice__mismatch_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__ice__mismatch_template* implied_template = new SDP__attribute__ice__mismatch_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__ice__mismatch_template(precondition, implied_template);
  } break;
  default:
    param.type_error("empty record/set template", "@SDP_Types.SDP_attribute_ice_mismatch");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__ice__mismatch_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_ice_mismatch");
}

boolean SDP__attribute__ice__mismatch_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__ice__mismatch_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__Remote__candidate::SDP__Remote__candidate()
{
}

SDP__Remote__candidate::SDP__Remote__candidate(const CHARSTRING& par_component__Id,
    const CHARSTRING& par_connection__address,
    const INTEGER& par_portValue)
  :   field_component__Id(par_component__Id),
  field_connection__address(par_connection__address),
  field_portValue(par_portValue)
{
}

SDP__Remote__candidate::SDP__Remote__candidate(const SDP__Remote__candidate& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_Remote_candidate.");
if (other_value.component__Id().is_bound()) field_component__Id = other_value.component__Id();
else field_component__Id.clean_up();
if (other_value.connection__address().is_bound()) field_connection__address = other_value.connection__address();
else field_connection__address.clean_up();
if (other_value.portValue().is_bound()) field_portValue = other_value.portValue();
else field_portValue.clean_up();
}

void SDP__Remote__candidate::clean_up()
{
field_component__Id.clean_up();
field_connection__address.clean_up();
field_portValue.clean_up();
}

const TTCN_Typedescriptor_t* SDP__Remote__candidate::get_descriptor() const { return &SDP__Remote__candidate_descr_; }
SDP__Remote__candidate& SDP__Remote__candidate::operator=(const SDP__Remote__candidate& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_Remote_candidate.");
  if (other_value.component__Id().is_bound()) field_component__Id = other_value.component__Id();
  else field_component__Id.clean_up();
  if (other_value.connection__address().is_bound()) field_connection__address = other_value.connection__address();
  else field_connection__address.clean_up();
  if (other_value.portValue().is_bound()) field_portValue = other_value.portValue();
  else field_portValue.clean_up();
}
return *this;
}

boolean SDP__Remote__candidate::operator==(const SDP__Remote__candidate& other_value) const
{
return field_component__Id==other_value.field_component__Id
  && field_connection__address==other_value.field_connection__address
  && field_portValue==other_value.field_portValue;
}

boolean SDP__Remote__candidate::is_bound() const
{
return (field_component__Id.is_bound())
  || (field_connection__address.is_bound())
  || (field_portValue.is_bound());
}
boolean SDP__Remote__candidate::is_value() const
{
return field_component__Id.is_value()
  && field_connection__address.is_value()
  && field_portValue.is_value();
}
void SDP__Remote__candidate::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ component_Id := ");
field_component__Id.log();
TTCN_Logger::log_event_str(", connection_address := ");
field_connection__address.log();
TTCN_Logger::log_event_str(", portValue := ");
field_portValue.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__Remote__candidate::set_implicit_omit()
{
if (component__Id().is_bound()) component__Id().set_implicit_omit();
if (connection__address().is_bound()) connection__address().set_implicit_omit();
if (portValue().is_bound()) portValue().set_implicit_omit();
}

void SDP__Remote__candidate::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_Remote_candidate has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) component__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) connection__address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) portValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "component_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          component__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "portValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          portValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_Remote_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_Remote_candidate");
  }
}

void SDP__Remote__candidate::encode_text(Text_Buf& text_buf) const
{
field_component__Id.encode_text(text_buf);
field_connection__address.encode_text(text_buf);
field_portValue.encode_text(text_buf);
}

void SDP__Remote__candidate::decode_text(Text_Buf& text_buf)
{
field_component__Id.decode_text(text_buf);
field_connection__address.decode_text(text_buf);
field_portValue.decode_text(text_buf);
}

void SDP__Remote__candidate::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__Remote__candidate::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__Remote__candidate::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_component__Id.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_connection__address.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_portValue.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__Remote__candidate::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_component__Id.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'component__Id' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_connection__address.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'connection__address' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_portValue.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'portValue' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__Remote__candidate_template::single_value_struct {
CHARSTRING_template field_component__Id;
CHARSTRING_template field_connection__address;
INTEGER_template field_portValue;
};

void SDP__Remote__candidate_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_component__Id = ANY_VALUE;
single_value->field_connection__address = ANY_VALUE;
single_value->field_portValue = ANY_VALUE;
}
}
}

void SDP__Remote__candidate_template::copy_value(const SDP__Remote__candidate& other_value)
{
single_value = new single_value_struct;
if (other_value.component__Id().is_bound()) {
  single_value->field_component__Id = other_value.component__Id();
} else {
  single_value->field_component__Id.clean_up();
}
if (other_value.connection__address().is_bound()) {
  single_value->field_connection__address = other_value.connection__address();
} else {
  single_value->field_connection__address.clean_up();
}
if (other_value.portValue().is_bound()) {
  single_value->field_portValue = other_value.portValue();
} else {
  single_value->field_portValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__Remote__candidate_template::copy_template(const SDP__Remote__candidate_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.component__Id().get_selection()) {
single_value->field_component__Id = other_value.component__Id();
} else {
single_value->field_component__Id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connection__address().get_selection()) {
single_value->field_connection__address = other_value.connection__address();
} else {
single_value->field_connection__address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.portValue().get_selection()) {
single_value->field_portValue = other_value.portValue();
} else {
single_value->field_portValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__Remote__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__Remote__candidate_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__Remote__candidate_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate.");
break;
}
set_selection(other_value);
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template()
{
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(const SDP__Remote__candidate& other_value)
{
copy_value(other_value);
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(const OPTIONAL<SDP__Remote__candidate>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__Remote__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_Remote_candidate from an unbound optional field.");
}
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(SDP__Remote__candidate_template* p_precondition, SDP__Remote__candidate_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(Dynamic_Match_Interface<SDP__Remote__candidate>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__Remote__candidate>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__Remote__candidate_template::SDP__Remote__candidate_template(const SDP__Remote__candidate_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__Remote__candidate_template::~SDP__Remote__candidate_template()
{
clean_up();
}

SDP__Remote__candidate_template& SDP__Remote__candidate_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__Remote__candidate_template& SDP__Remote__candidate_template::operator=(const SDP__Remote__candidate& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__Remote__candidate_template& SDP__Remote__candidate_template::operator=(const OPTIONAL<SDP__Remote__candidate>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__Remote__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_Remote_candidate.");
}
return *this;
}

SDP__Remote__candidate_template& SDP__Remote__candidate_template::operator=(const SDP__Remote__candidate_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__Remote__candidate_template::match(const SDP__Remote__candidate& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.component__Id().is_bound()) return FALSE;
if(!single_value->field_component__Id.match(other_value.component__Id(), legacy))return FALSE;
if(!other_value.connection__address().is_bound()) return FALSE;
if(!single_value->field_connection__address.match(other_value.connection__address(), legacy))return FALSE;
if(!other_value.portValue().is_bound()) return FALSE;
if(!single_value->field_portValue.match(other_value.portValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate.");
}
return FALSE;
}

boolean SDP__Remote__candidate_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_component__Id.is_bound()
 || single_value->field_connection__address.is_bound()
 || single_value->field_portValue.is_bound();
}

boolean SDP__Remote__candidate_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_component__Id.is_value()
 && single_value->field_connection__address.is_value()
 && single_value->field_portValue.is_value();
}

void SDP__Remote__candidate_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__Remote__candidate SDP__Remote__candidate_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_Remote_candidate.");
SDP__Remote__candidate ret_val;
if (single_value->field_component__Id.is_bound()) {
ret_val.component__Id() = single_value->field_component__Id.valueof();
}
if (single_value->field_connection__address.is_bound()) {
ret_val.connection__address() = single_value->field_connection__address.valueof();
}
if (single_value->field_portValue.is_bound()) {
ret_val.portValue() = single_value->field_portValue.valueof();
}
return ret_val;
}

void SDP__Remote__candidate_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_Remote_candidate.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__Remote__candidate_template[list_length];
}

SDP__Remote__candidate_template& SDP__Remote__candidate_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_Remote_candidate.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_Remote_candidate.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__Remote__candidate_template::component__Id()
{
set_specific();
return single_value->field_component__Id;
}

const CHARSTRING_template& SDP__Remote__candidate_template::component__Id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field component_Id of a non-specific template of type @SDP_Types.SDP_Remote_candidate.");
return single_value->field_component__Id;
}

CHARSTRING_template& SDP__Remote__candidate_template::connection__address()
{
set_specific();
return single_value->field_connection__address;
}

const CHARSTRING_template& SDP__Remote__candidate_template::connection__address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connection_address of a non-specific template of type @SDP_Types.SDP_Remote_candidate.");
return single_value->field_connection__address;
}

INTEGER_template& SDP__Remote__candidate_template::portValue()
{
set_specific();
return single_value->field_portValue;
}

const INTEGER_template& SDP__Remote__candidate_template::portValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field portValue of a non-specific template of type @SDP_Types.SDP_Remote_candidate.");
return single_value->field_portValue;
}

int SDP__Remote__candidate_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_Remote_candidate containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate.");
  }
  return 0;
}

void SDP__Remote__candidate_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ component_Id := ");
single_value->field_component__Id.log();
TTCN_Logger::log_event_str(", connection_address := ");
single_value->field_connection__address.log();
TTCN_Logger::log_event_str(", portValue := ");
single_value->field_portValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__Remote__candidate_template::log_match(const SDP__Remote__candidate& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_component__Id.match(match_value.component__Id(), legacy)){
TTCN_Logger::log_logmatch_info(".component_Id");
single_value->field_component__Id.log_match(match_value.component__Id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_connection__address.match(match_value.connection__address(), legacy)){
TTCN_Logger::log_logmatch_info(".connection_address");
single_value->field_connection__address.log_match(match_value.connection__address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_portValue.match(match_value.portValue(), legacy)){
TTCN_Logger::log_logmatch_info(".portValue");
single_value->field_portValue.log_match(match_value.portValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ component_Id := ");
single_value->field_component__Id.log_match(match_value.component__Id(), legacy);
TTCN_Logger::log_event_str(", connection_address := ");
single_value->field_connection__address.log_match(match_value.connection__address(), legacy);
TTCN_Logger::log_event_str(", portValue := ");
single_value->field_portValue.log_match(match_value.portValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__Remote__candidate_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (component__Id().is_bound()) component__Id().set_implicit_omit();
if (connection__address().is_bound()) connection__address().set_implicit_omit();
if (portValue().is_bound()) portValue().set_implicit_omit();
}

void SDP__Remote__candidate_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_component__Id.encode_text(text_buf);
single_value->field_connection__address.encode_text(text_buf);
single_value->field_portValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate.");
}
}

void SDP__Remote__candidate_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_component__Id.decode_text(text_buf);
single_value->field_connection__address.decode_text(text_buf);
single_value->field_portValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__Remote__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_Remote_candidate.");
}
}

void SDP__Remote__candidate_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__Remote__candidate_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_Remote_candidate has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) component__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) connection__address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) portValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "component_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          component__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connection_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connection__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "portValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          portValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_Remote_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__Remote__candidate_template* precondition = new SDP__Remote__candidate_template;
    precondition->set_param(*param.get_elem(0));
    SDP__Remote__candidate_template* implied_template = new SDP__Remote__candidate_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__Remote__candidate_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_Remote_candidate");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__Remote__candidate_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_component__Id.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_Remote_candidate");
single_value->field_connection__address.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_Remote_candidate");
single_value->field_portValue.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_Remote_candidate");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_Remote_candidate");
}

boolean SDP__Remote__candidate_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__Remote__candidate_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__Remote__candidate SDP__Remote__candidate__list::UNBOUND_ELEM;
boolean SDP__Remote__candidate__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__Remote__candidate__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (((const SDP__Remote__candidate__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (((const SDP__Remote__candidate__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__Remote__candidate__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__Remote__candidate__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__Remote__candidate__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__Remote__candidate__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__Remote__candidate__list::SDP__Remote__candidate__list()
{
val_ptr = NULL;
}

SDP__Remote__candidate__list::SDP__Remote__candidate__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__Remote__candidate__list::SDP__Remote__candidate__list(const SDP__Remote__candidate__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__Remote__candidate__list::~SDP__Remote__candidate__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__Remote__candidate__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__Remote__candidate__list& SDP__Remote__candidate__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__Remote__candidate__list& SDP__Remote__candidate__list::operator=(const SDP__Remote__candidate__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__Remote__candidate__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__Remote__candidate__list::operator==(const SDP__Remote__candidate__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__Remote__candidate& SDP__Remote__candidate__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_Remote_candidate_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__Remote__candidate**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__Remote__candidate(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__Remote__candidate;
}
return *val_ptr->value_elements[index_value];
}

SDP__Remote__candidate& SDP__Remote__candidate__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_Remote_candidate_list.");
return (*this)[(int)index_value];
}

const SDP__Remote__candidate& SDP__Remote__candidate__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_Remote_candidate_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_Remote_candidate_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__Remote__candidate& SDP__Remote__candidate__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_Remote_candidate_list.");
return (*this)[(int)index_value];
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__Remote__candidate__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__Remote__candidate(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::operator+(const SDP__Remote__candidate__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_Remote_candidate_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__Remote__candidate__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__Remote__candidate(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__Remote__candidate(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_Remote_candidate_list","element");
SDP__Remote__candidate__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__Remote__candidate(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::replace(int index, int len, const SDP__Remote__candidate__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_Remote_candidate_list","element");
SDP__Remote__candidate__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__Remote__candidate(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__Remote__candidate(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__Remote__candidate(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list::replace(int index, int len, const SDP__Remote__candidate__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__Remote__candidate__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_Remote_candidate_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__Remote__candidate**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__Remote__candidate(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__Remote__candidate**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_Remote_candidate_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__Remote__candidate**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__Remote__candidate__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__Remote__candidate__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
return val_ptr->n_elements;
}

int SDP__Remote__candidate__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__Remote__candidate__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__Remote__candidate__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__Remote__candidate__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_Remote_candidate_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_Remote_candidate_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__Remote__candidate__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_Remote_candidate_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__Remote__candidate__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_Remote_candidate_list.");
val_ptr->value_elements = (SDP__Remote__candidate**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__Remote__candidate;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__Remote__candidate__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__Remote__candidate__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__Remote__candidate__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__Remote__candidate__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__Remote__candidate *val=new SDP__Remote__candidate;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__Remote__candidate**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__Remote__candidate__list_template::copy_value(const SDP__Remote__candidate__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_Remote_candidate_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__Remote__candidate_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__Remote__candidate__list_template::copy_template(const SDP__Remote__candidate__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__Remote__candidate_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__Remote__candidate__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__Remote__candidate_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__Remote__candidate__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__Remote__candidate__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate_list.");
break;
}
set_selection(other_value);
}

boolean SDP__Remote__candidate__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__Remote__candidate__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__Remote__candidate__list*)value_ptr)[value_index], legacy);
else return ((const SDP__Remote__candidate__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__Remote__candidate__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__Remote__candidate__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__Remote__candidate__list*)value_ptr)[value_index], legacy);
else return ((const SDP__Remote__candidate__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__Remote__candidate__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__Remote__candidate__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__Remote__candidate__list*)value_ptr)[index_value].log();
} else {
((const SDP__Remote__candidate__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__Remote__candidate__list*)value_ptr)[index_value], legacy);
}
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template()
{
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(const SDP__Remote__candidate__list& other_value)
{
copy_value(other_value);
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(const OPTIONAL<SDP__Remote__candidate__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__Remote__candidate__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_Remote_candidate_list from an unbound optional field.");
}
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(SDP__Remote__candidate__list_template* p_precondition, SDP__Remote__candidate__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(Dynamic_Match_Interface<SDP__Remote__candidate__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__Remote__candidate__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__Remote__candidate__list_template::SDP__Remote__candidate__list_template(const SDP__Remote__candidate__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__Remote__candidate__list_template::~SDP__Remote__candidate__list_template()
{
clean_up();
}

void SDP__Remote__candidate__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::operator=(const SDP__Remote__candidate__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::operator=(const OPTIONAL<SDP__Remote__candidate__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__Remote__candidate__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_Remote_candidate_list.");
}
return *this;
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::operator=(const SDP__Remote__candidate__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__Remote__candidate_template& SDP__Remote__candidate__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_Remote_candidate_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_Remote_candidate_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__Remote__candidate_template& SDP__Remote__candidate__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_Remote_candidate_list.");
return (*this)[(int)index_value];
}

const SDP__Remote__candidate_template& SDP__Remote__candidate__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_Remote_candidate_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_Remote_candidate_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_Remote_candidate_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__Remote__candidate_template& SDP__Remote__candidate__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_Remote_candidate_list.");
return (*this)[(int)index_value];
}

void SDP__Remote__candidate__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_Remote_candidate_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__Remote__candidate_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__Remote__candidate_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__Remote__candidate__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__Remote__candidate__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_Remote_candidate_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_Remote_candidate_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_Remote_candidate_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_Remote_candidate_list");
}

boolean SDP__Remote__candidate__list_template::match(const SDP__Remote__candidate__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate_list.");
}
return FALSE;
}

boolean SDP__Remote__candidate__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_Remote_candidate_list.");
SDP__Remote__candidate__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__Remote__candidate__list SDP__Remote__candidate__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__Remote__candidate__list SDP__Remote__candidate__list_template::replace(int index, int len, const SDP__Remote__candidate__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__Remote__candidate__list SDP__Remote__candidate__list_template::replace(int index, int len, const SDP__Remote__candidate__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__Remote__candidate__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__Remote__candidate__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__Remote__candidate_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_Remote_candidate_list.");
}
set_selection(template_type);
}

SDP__Remote__candidate__list_template& SDP__Remote__candidate__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_Remote_candidate_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_Remote_candidate_list.");
return value_list.list_value[list_index];
}

SDP__Remote__candidate_template& SDP__Remote__candidate__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_Remote_candidate_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_Remote_candidate_list.");
return value_set.set_items[set_index];
}

void SDP__Remote__candidate__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__Remote__candidate__list_template::log_match(const SDP__Remote__candidate__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__Remote__candidate__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_Remote_candidate_list.");
}
}

void SDP__Remote__candidate__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_Remote_candidate_list.");
single_value.value_elements = (SDP__Remote__candidate_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__Remote__candidate_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__Remote__candidate__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__Remote__candidate_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_Remote_candidate_list.");
}
}

boolean SDP__Remote__candidate__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__Remote__candidate__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__Remote__candidate__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__Remote__candidate__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__Remote__candidate__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__Remote__candidate__list_template* precondition = new SDP__Remote__candidate__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__Remote__candidate__list_template* implied_template = new SDP__Remote__candidate__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__Remote__candidate__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_Remote_candidate_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__Remote__candidate__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_Remote_candidate_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_Remote_candidate_list");
}

boolean SDP__Remote__candidate__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__attribute__remote__candidate::SDP__attribute__remote__candidate()
{
}

SDP__attribute__remote__candidate::SDP__attribute__remote__candidate(const SDP__Remote__candidate__list& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__remote__candidate::SDP__attribute__remote__candidate(const SDP__attribute__remote__candidate& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_remote_candidate.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__remote__candidate::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__remote__candidate::get_descriptor() const { return &SDP__attribute__remote__candidate_descr_; }
SDP__attribute__remote__candidate& SDP__attribute__remote__candidate::operator=(const SDP__attribute__remote__candidate& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_remote_candidate.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__remote__candidate::operator==(const SDP__attribute__remote__candidate& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__remote__candidate::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__remote__candidate::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__remote__candidate::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__remote__candidate::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__remote__candidate::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_remote_candidate has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_remote_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_remote_candidate");
  }
}

void SDP__attribute__remote__candidate::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__remote__candidate::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__remote__candidate::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__remote__candidate::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__remote__candidate::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(SDP__Remote__candidate__list_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__remote__candidate::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(SDP__Remote__candidate__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__remote__candidate_template::single_value_struct {
SDP__Remote__candidate__list_template field_attr__value;
};

void SDP__attribute__remote__candidate_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__remote__candidate_template::copy_value(const SDP__attribute__remote__candidate& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__remote__candidate_template::copy_template(const SDP__attribute__remote__candidate_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__remote__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__remote__candidate_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__remote__candidate_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_remote_candidate.");
break;
}
set_selection(other_value);
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template()
{
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(const SDP__attribute__remote__candidate& other_value)
{
copy_value(other_value);
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(const OPTIONAL<SDP__attribute__remote__candidate>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__remote__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_remote_candidate from an unbound optional field.");
}
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(SDP__attribute__remote__candidate_template* p_precondition, SDP__attribute__remote__candidate_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(Dynamic_Match_Interface<SDP__attribute__remote__candidate>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__remote__candidate>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__remote__candidate_template::SDP__attribute__remote__candidate_template(const SDP__attribute__remote__candidate_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__remote__candidate_template::~SDP__attribute__remote__candidate_template()
{
clean_up();
}

SDP__attribute__remote__candidate_template& SDP__attribute__remote__candidate_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__remote__candidate_template& SDP__attribute__remote__candidate_template::operator=(const SDP__attribute__remote__candidate& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__remote__candidate_template& SDP__attribute__remote__candidate_template::operator=(const OPTIONAL<SDP__attribute__remote__candidate>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__remote__candidate&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_remote_candidate.");
}
return *this;
}

SDP__attribute__remote__candidate_template& SDP__attribute__remote__candidate_template::operator=(const SDP__attribute__remote__candidate_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__remote__candidate_template::match(const SDP__attribute__remote__candidate& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_remote_candidate.");
}
return FALSE;
}

boolean SDP__attribute__remote__candidate_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__remote__candidate_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__remote__candidate_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__remote__candidate SDP__attribute__remote__candidate_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_remote_candidate.");
SDP__attribute__remote__candidate ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__remote__candidate_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_remote_candidate.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__remote__candidate_template[list_length];
}

SDP__attribute__remote__candidate_template& SDP__attribute__remote__candidate_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_remote_candidate.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_remote_candidate.");
return value_list.list_value[list_index];
}

SDP__Remote__candidate__list_template& SDP__attribute__remote__candidate_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const SDP__Remote__candidate__list_template& SDP__attribute__remote__candidate_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_remote_candidate.");
return single_value->field_attr__value;
}

int SDP__attribute__remote__candidate_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_remote_candidate containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_remote_candidate.");
  }
  return 0;
}

void SDP__attribute__remote__candidate_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__remote__candidate_template::log_match(const SDP__attribute__remote__candidate& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__remote__candidate_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__remote__candidate_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_remote_candidate.");
}
}

void SDP__attribute__remote__candidate_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__remote__candidate_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_remote_candidate.");
}
}

void SDP__attribute__remote__candidate_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__remote__candidate_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_remote_candidate has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_remote_candidate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__remote__candidate_template* precondition = new SDP__attribute__remote__candidate_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__remote__candidate_template* implied_template = new SDP__attribute__remote__candidate_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__remote__candidate_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_remote_candidate");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__remote__candidate_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_remote_candidate");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_remote_candidate");
}

boolean SDP__attribute__remote__candidate_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__remote__candidate_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__ice__options::SDP__attribute__ice__options()
{
}

SDP__attribute__ice__options::SDP__attribute__ice__options(const SDP__ice__options__list& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__ice__options::SDP__attribute__ice__options(const SDP__attribute__ice__options& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_ice_options.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__ice__options::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__ice__options::get_descriptor() const { return &SDP__attribute__ice__options_descr_; }
SDP__attribute__ice__options& SDP__attribute__ice__options::operator=(const SDP__attribute__ice__options& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_ice_options.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__ice__options::operator==(const SDP__attribute__ice__options& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__ice__options::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__ice__options::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__ice__options::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__ice__options::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__options::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_ice_options has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_options: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_ice_options");
  }
}

void SDP__attribute__ice__options::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__ice__options::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__ice__options::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__ice__options::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__ice__options::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(SDP__ice__options__list_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__ice__options::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(SDP__ice__options__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__ice__options_template::single_value_struct {
SDP__ice__options__list_template field_attr__value;
};

void SDP__attribute__ice__options_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__ice__options_template::copy_value(const SDP__attribute__ice__options& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__ice__options_template::copy_template(const SDP__attribute__ice__options_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__ice__options_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__ice__options_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__ice__options_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_options.");
break;
}
set_selection(other_value);
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template()
{
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(const SDP__attribute__ice__options& other_value)
{
copy_value(other_value);
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(const OPTIONAL<SDP__attribute__ice__options>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__options&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_ice_options from an unbound optional field.");
}
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(SDP__attribute__ice__options_template* p_precondition, SDP__attribute__ice__options_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(Dynamic_Match_Interface<SDP__attribute__ice__options>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__ice__options>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__ice__options_template::SDP__attribute__ice__options_template(const SDP__attribute__ice__options_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__ice__options_template::~SDP__attribute__ice__options_template()
{
clean_up();
}

SDP__attribute__ice__options_template& SDP__attribute__ice__options_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__ice__options_template& SDP__attribute__ice__options_template::operator=(const SDP__attribute__ice__options& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__ice__options_template& SDP__attribute__ice__options_template::operator=(const OPTIONAL<SDP__attribute__ice__options>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__ice__options&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_ice_options.");
}
return *this;
}

SDP__attribute__ice__options_template& SDP__attribute__ice__options_template::operator=(const SDP__attribute__ice__options_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__ice__options_template::match(const SDP__attribute__ice__options& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_options.");
}
return FALSE;
}

boolean SDP__attribute__ice__options_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__ice__options_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__ice__options_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__ice__options SDP__attribute__ice__options_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_ice_options.");
SDP__attribute__ice__options ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__ice__options_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_ice_options.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__ice__options_template[list_length];
}

SDP__attribute__ice__options_template& SDP__attribute__ice__options_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_ice_options.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_ice_options.");
return value_list.list_value[list_index];
}

SDP__ice__options__list_template& SDP__attribute__ice__options_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const SDP__ice__options__list_template& SDP__attribute__ice__options_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_ice_options.");
return single_value->field_attr__value;
}

int SDP__attribute__ice__options_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_ice_options containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_options.");
  }
  return 0;
}

void SDP__attribute__ice__options_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__ice__options_template::log_match(const SDP__attribute__ice__options& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__ice__options_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__ice__options_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_ice_options.");
}
}

void SDP__attribute__ice__options_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__ice__options_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_ice_options.");
}
}

void SDP__attribute__ice__options_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__ice__options_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_ice_options has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_ice_options: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__ice__options_template* precondition = new SDP__attribute__ice__options_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__ice__options_template* implied_template = new SDP__attribute__ice__options_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__ice__options_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_ice_options");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__ice__options_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_ice_options");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_ice_options");
}

boolean SDP__attribute__ice__options_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__ice__options_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__rtcp__fb::SDP__attribute__rtcp__fb()
{
}

SDP__attribute__rtcp__fb::SDP__attribute__rtcp__fb(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__rtcp__fb::SDP__attribute__rtcp__fb(const SDP__attribute__rtcp__fb& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_rtcp_fb.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__rtcp__fb::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__rtcp__fb::get_descriptor() const { return &SDP__attribute__rtcp__fb_descr_; }
SDP__attribute__rtcp__fb& SDP__attribute__rtcp__fb::operator=(const SDP__attribute__rtcp__fb& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_rtcp_fb.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__rtcp__fb::operator==(const SDP__attribute__rtcp__fb& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__rtcp__fb::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__rtcp__fb::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__rtcp__fb::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__rtcp__fb::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__rtcp__fb::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_rtcp_fb has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_rtcp_fb: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_rtcp_fb");
  }
}

void SDP__attribute__rtcp__fb::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__rtcp__fb::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__rtcp__fb::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__rtcp__fb::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__rtcp__fb::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__rtcp__fb::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__rtcp__fb_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__rtcp__fb_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__rtcp__fb_template::copy_value(const SDP__attribute__rtcp__fb& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__rtcp__fb_template::copy_template(const SDP__attribute__rtcp__fb_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__rtcp__fb_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__rtcp__fb_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__rtcp__fb_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_rtcp_fb.");
break;
}
set_selection(other_value);
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template()
{
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(const SDP__attribute__rtcp__fb& other_value)
{
copy_value(other_value);
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(const OPTIONAL<SDP__attribute__rtcp__fb>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__rtcp__fb&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_rtcp_fb from an unbound optional field.");
}
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(SDP__attribute__rtcp__fb_template* p_precondition, SDP__attribute__rtcp__fb_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(Dynamic_Match_Interface<SDP__attribute__rtcp__fb>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__rtcp__fb>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__rtcp__fb_template::SDP__attribute__rtcp__fb_template(const SDP__attribute__rtcp__fb_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__rtcp__fb_template::~SDP__attribute__rtcp__fb_template()
{
clean_up();
}

SDP__attribute__rtcp__fb_template& SDP__attribute__rtcp__fb_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__rtcp__fb_template& SDP__attribute__rtcp__fb_template::operator=(const SDP__attribute__rtcp__fb& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__rtcp__fb_template& SDP__attribute__rtcp__fb_template::operator=(const OPTIONAL<SDP__attribute__rtcp__fb>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__rtcp__fb&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_rtcp_fb.");
}
return *this;
}

SDP__attribute__rtcp__fb_template& SDP__attribute__rtcp__fb_template::operator=(const SDP__attribute__rtcp__fb_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__rtcp__fb_template::match(const SDP__attribute__rtcp__fb& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_rtcp_fb.");
}
return FALSE;
}

boolean SDP__attribute__rtcp__fb_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__rtcp__fb_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__rtcp__fb_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__rtcp__fb SDP__attribute__rtcp__fb_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_rtcp_fb.");
SDP__attribute__rtcp__fb ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__rtcp__fb_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_rtcp_fb.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__rtcp__fb_template[list_length];
}

SDP__attribute__rtcp__fb_template& SDP__attribute__rtcp__fb_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_rtcp_fb.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_rtcp_fb.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__rtcp__fb_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__rtcp__fb_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_rtcp_fb.");
return single_value->field_attr__value;
}

int SDP__attribute__rtcp__fb_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_rtcp_fb containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_rtcp_fb.");
  }
  return 0;
}

void SDP__attribute__rtcp__fb_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__rtcp__fb_template::log_match(const SDP__attribute__rtcp__fb& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__rtcp__fb_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__rtcp__fb_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_rtcp_fb.");
}
}

void SDP__attribute__rtcp__fb_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__rtcp__fb_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_rtcp_fb.");
}
}

void SDP__attribute__rtcp__fb_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__rtcp__fb_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_rtcp_fb has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_rtcp_fb: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__rtcp__fb_template* precondition = new SDP__attribute__rtcp__fb_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__rtcp__fb_template* implied_template = new SDP__attribute__rtcp__fb_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__rtcp__fb_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_rtcp_fb");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__rtcp__fb_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_rtcp_fb");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_rtcp_fb");
}

boolean SDP__attribute__rtcp__fb_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__rtcp__fb_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__maxptime::SDP__attribute__maxptime()
{
}

SDP__attribute__maxptime::SDP__attribute__maxptime(const CHARSTRING& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__maxptime::SDP__attribute__maxptime(const SDP__attribute__maxptime& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_maxptime.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__maxptime::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__maxptime::get_descriptor() const { return &SDP__attribute__maxptime_descr_; }
SDP__attribute__maxptime& SDP__attribute__maxptime::operator=(const SDP__attribute__maxptime& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_maxptime.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__maxptime::operator==(const SDP__attribute__maxptime& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__maxptime::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__maxptime::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__maxptime::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__maxptime::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__maxptime::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_maxptime has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_maxptime: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_maxptime");
  }
}

void SDP__attribute__maxptime::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__maxptime::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__maxptime::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__maxptime::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__maxptime::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__maxptime::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__maxptime_template::single_value_struct {
CHARSTRING_template field_attr__value;
};

void SDP__attribute__maxptime_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__maxptime_template::copy_value(const SDP__attribute__maxptime& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__maxptime_template::copy_template(const SDP__attribute__maxptime_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__maxptime_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__maxptime_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__maxptime_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_maxptime.");
break;
}
set_selection(other_value);
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template()
{
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(const SDP__attribute__maxptime& other_value)
{
copy_value(other_value);
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(const OPTIONAL<SDP__attribute__maxptime>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__maxptime&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_maxptime from an unbound optional field.");
}
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(SDP__attribute__maxptime_template* p_precondition, SDP__attribute__maxptime_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(Dynamic_Match_Interface<SDP__attribute__maxptime>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__maxptime>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__maxptime_template::SDP__attribute__maxptime_template(const SDP__attribute__maxptime_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__maxptime_template::~SDP__attribute__maxptime_template()
{
clean_up();
}

SDP__attribute__maxptime_template& SDP__attribute__maxptime_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__maxptime_template& SDP__attribute__maxptime_template::operator=(const SDP__attribute__maxptime& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__maxptime_template& SDP__attribute__maxptime_template::operator=(const OPTIONAL<SDP__attribute__maxptime>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__maxptime&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_maxptime.");
}
return *this;
}

SDP__attribute__maxptime_template& SDP__attribute__maxptime_template::operator=(const SDP__attribute__maxptime_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__maxptime_template::match(const SDP__attribute__maxptime& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_maxptime.");
}
return FALSE;
}

boolean SDP__attribute__maxptime_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__maxptime_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__maxptime_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__maxptime SDP__attribute__maxptime_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_maxptime.");
SDP__attribute__maxptime ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__maxptime_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_maxptime.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__maxptime_template[list_length];
}

SDP__attribute__maxptime_template& SDP__attribute__maxptime_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_maxptime.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_maxptime.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__attribute__maxptime_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const CHARSTRING_template& SDP__attribute__maxptime_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_maxptime.");
return single_value->field_attr__value;
}

int SDP__attribute__maxptime_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_maxptime containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_maxptime.");
  }
  return 0;
}

void SDP__attribute__maxptime_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__maxptime_template::log_match(const SDP__attribute__maxptime& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__maxptime_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__maxptime_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_maxptime.");
}
}

void SDP__attribute__maxptime_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__maxptime_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_maxptime.");
}
}

void SDP__attribute__maxptime_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__maxptime_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_maxptime has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_maxptime: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__maxptime_template* precondition = new SDP__attribute__maxptime_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__maxptime_template* implied_template = new SDP__attribute__maxptime_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__maxptime_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_maxptime");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__maxptime_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_maxptime");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_maxptime");
}

boolean SDP__attribute__maxptime_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__maxptime_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__attribute__T38FaxVersion::SDP__attribute__T38FaxVersion()
{
}

SDP__attribute__T38FaxVersion::SDP__attribute__T38FaxVersion(const INTEGER& par_attr__value)
  :   field_attr__value(par_attr__value)
{
}

SDP__attribute__T38FaxVersion::SDP__attribute__T38FaxVersion(const SDP__attribute__T38FaxVersion& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_T38FaxVersion.");
if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
else field_attr__value.clean_up();
}

void SDP__attribute__T38FaxVersion::clean_up()
{
field_attr__value.clean_up();
}

const TTCN_Typedescriptor_t* SDP__attribute__T38FaxVersion::get_descriptor() const { return &SDP__attribute__T38FaxVersion_descr_; }
SDP__attribute__T38FaxVersion& SDP__attribute__T38FaxVersion::operator=(const SDP__attribute__T38FaxVersion& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_attribute_T38FaxVersion.");
  if (other_value.attr__value().is_bound()) field_attr__value = other_value.attr__value();
  else field_attr__value.clean_up();
}
return *this;
}

boolean SDP__attribute__T38FaxVersion::operator==(const SDP__attribute__T38FaxVersion& other_value) const
{
return field_attr__value==other_value.field_attr__value;
}

boolean SDP__attribute__T38FaxVersion::is_bound() const
{
return (field_attr__value.is_bound());
}
boolean SDP__attribute__T38FaxVersion::is_value() const
{
return field_attr__value.is_value();
}
void SDP__attribute__T38FaxVersion::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attr_value := ");
field_attr__value.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__attribute__T38FaxVersion::set_implicit_omit()
{
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__T38FaxVersion::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_attribute_T38FaxVersion has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_T38FaxVersion: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_attribute_T38FaxVersion");
  }
}

void SDP__attribute__T38FaxVersion::encode_text(Text_Buf& text_buf) const
{
field_attr__value.encode_text(text_buf);
}

void SDP__attribute__T38FaxVersion::decode_text(Text_Buf& text_buf)
{
field_attr__value.decode_text(text_buf);
}

void SDP__attribute__T38FaxVersion::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__T38FaxVersion::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__T38FaxVersion::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attr__value.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__T38FaxVersion::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_attr__value.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'attr__value' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__attribute__T38FaxVersion_template::single_value_struct {
INTEGER_template field_attr__value;
};

void SDP__attribute__T38FaxVersion_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attr__value = ANY_VALUE;
}
}
}

void SDP__attribute__T38FaxVersion_template::copy_value(const SDP__attribute__T38FaxVersion& other_value)
{
single_value = new single_value_struct;
if (other_value.attr__value().is_bound()) {
  single_value->field_attr__value = other_value.attr__value();
} else {
  single_value->field_attr__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__T38FaxVersion_template::copy_template(const SDP__attribute__T38FaxVersion_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attr__value().get_selection()) {
single_value->field_attr__value = other_value.attr__value();
} else {
single_value->field_attr__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__T38FaxVersion_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__T38FaxVersion_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__T38FaxVersion_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
break;
}
set_selection(other_value);
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template()
{
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(const SDP__attribute__T38FaxVersion& other_value)
{
copy_value(other_value);
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(const OPTIONAL<SDP__attribute__T38FaxVersion>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__T38FaxVersion&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_T38FaxVersion from an unbound optional field.");
}
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(SDP__attribute__T38FaxVersion_template* p_precondition, SDP__attribute__T38FaxVersion_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(Dynamic_Match_Interface<SDP__attribute__T38FaxVersion>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__T38FaxVersion>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__T38FaxVersion_template::SDP__attribute__T38FaxVersion_template(const SDP__attribute__T38FaxVersion_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__attribute__T38FaxVersion_template::~SDP__attribute__T38FaxVersion_template()
{
clean_up();
}

SDP__attribute__T38FaxVersion_template& SDP__attribute__T38FaxVersion_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__T38FaxVersion_template& SDP__attribute__T38FaxVersion_template::operator=(const SDP__attribute__T38FaxVersion& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__T38FaxVersion_template& SDP__attribute__T38FaxVersion_template::operator=(const OPTIONAL<SDP__attribute__T38FaxVersion>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__T38FaxVersion&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
}
return *this;
}

SDP__attribute__T38FaxVersion_template& SDP__attribute__T38FaxVersion_template::operator=(const SDP__attribute__T38FaxVersion_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__attribute__T38FaxVersion_template::match(const SDP__attribute__T38FaxVersion& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attr__value().is_bound()) return FALSE;
if(!single_value->field_attr__value.match(other_value.attr__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
}
return FALSE;
}

boolean SDP__attribute__T38FaxVersion_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attr__value.is_bound();
}

boolean SDP__attribute__T38FaxVersion_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attr__value.is_value();
}

void SDP__attribute__T38FaxVersion_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__T38FaxVersion SDP__attribute__T38FaxVersion_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
SDP__attribute__T38FaxVersion ret_val;
if (single_value->field_attr__value.is_bound()) {
ret_val.attr__value() = single_value->field_attr__value.valueof();
}
return ret_val;
}

void SDP__attribute__T38FaxVersion_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__T38FaxVersion_template[list_length];
}

SDP__attribute__T38FaxVersion_template& SDP__attribute__T38FaxVersion_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
return value_list.list_value[list_index];
}

INTEGER_template& SDP__attribute__T38FaxVersion_template::attr__value()
{
set_specific();
return single_value->field_attr__value;
}

const INTEGER_template& SDP__attribute__T38FaxVersion_template::attr__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attr_value of a non-specific template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
return single_value->field_attr__value;
}

int SDP__attribute__T38FaxVersion_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_attribute_T38FaxVersion containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
  }
  return 0;
}

void SDP__attribute__T38FaxVersion_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__attribute__T38FaxVersion_template::log_match(const SDP__attribute__T38FaxVersion& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attr__value.match(match_value.attr__value(), legacy)){
TTCN_Logger::log_logmatch_info(".attr_value");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attr_value := ");
single_value->field_attr__value.log_match(match_value.attr__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__attribute__T38FaxVersion_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (attr__value().is_bound()) attr__value().set_implicit_omit();
}

void SDP__attribute__T38FaxVersion_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attr__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
}
}

void SDP__attribute__T38FaxVersion_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attr__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__T38FaxVersion_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_attribute_T38FaxVersion.");
}
}

void SDP__attribute__T38FaxVersion_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__T38FaxVersion_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_attribute_T38FaxVersion has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attr__value().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attr_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attr__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_attribute_T38FaxVersion: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__T38FaxVersion_template* precondition = new SDP__attribute__T38FaxVersion_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__T38FaxVersion_template* implied_template = new SDP__attribute__T38FaxVersion_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__T38FaxVersion_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_attribute_T38FaxVersion");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__attribute__T38FaxVersion_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attr__value.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_T38FaxVersion");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_T38FaxVersion");
}

boolean SDP__attribute__T38FaxVersion_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__T38FaxVersion_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
