// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "SDP_Types.hh"

namespace SDP__Types {

/* Member functions of C++ classes */


const SDP__attribute SDP__attribute__list::UNBOUND_ELEM;
boolean SDP__attribute__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__attribute__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_attribute_list.");
if (((const SDP__attribute__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_attribute_list.");
if (((const SDP__attribute__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__attribute__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__attribute__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__attribute__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__attribute__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__attribute__list::SDP__attribute__list()
{
val_ptr = NULL;
}

SDP__attribute__list::SDP__attribute__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__attribute__list::SDP__attribute__list(const SDP__attribute__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_attribute_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__attribute__list::~SDP__attribute__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__attribute__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__attribute__list& SDP__attribute__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__attribute__list& SDP__attribute__list::operator=(const SDP__attribute__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_attribute_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__attribute__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_attribute_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__attribute__list::operator==(const SDP__attribute__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_attribute_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_attribute_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__attribute& SDP__attribute__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_attribute_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__attribute**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__attribute(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__attribute;
}
return *val_ptr->value_elements[index_value];
}

SDP__attribute& SDP__attribute__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_attribute_list.");
return (*this)[(int)index_value];
}

const SDP__attribute& SDP__attribute__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_attribute_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_attribute_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_attribute_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__attribute& SDP__attribute__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_attribute_list.");
return (*this)[(int)index_value];
}

SDP__attribute__list SDP__attribute__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__attribute__list SDP__attribute__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__attribute__list SDP__attribute__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__attribute__list SDP__attribute__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_attribute_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__attribute__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__attribute(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__attribute__list SDP__attribute__list::operator+(const SDP__attribute__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_attribute_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__attribute__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__attribute(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__attribute(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__attribute__list SDP__attribute__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_attribute_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_attribute_list","element");
SDP__attribute__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__attribute(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__attribute__list SDP__attribute__list::replace(int index, int len, const SDP__attribute__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_attribute_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_attribute_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_attribute_list","element");
SDP__attribute__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__attribute(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__attribute(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__attribute(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__attribute__list SDP__attribute__list::replace(int index, int len, const SDP__attribute__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__attribute__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_attribute_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__attribute**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__attribute(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__attribute**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_attribute_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__attribute**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__attribute__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__attribute__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_attribute_list.");
return val_ptr->n_elements;
}

int SDP__attribute__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_attribute_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__attribute__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__attribute__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__attribute__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_attribute_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_attribute_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__attribute__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_attribute_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__attribute__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_attribute_list.");
val_ptr->value_elements = (SDP__attribute**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__attribute;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__attribute__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__attribute__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__attribute__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__attribute__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__attribute *val=new SDP__attribute;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__attribute**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__attribute__list_template::copy_value(const SDP__attribute__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_attribute_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__attribute_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__attribute_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__attribute_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__attribute__list_template::copy_template(const SDP__attribute__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__attribute_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__attribute_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__attribute_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__attribute__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__attribute_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__attribute__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__attribute__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_list.");
break;
}
set_selection(other_value);
}

boolean SDP__attribute__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__attribute__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__attribute__list*)value_ptr)[value_index], legacy);
else return ((const SDP__attribute__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__attribute__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__attribute__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__attribute__list*)value_ptr)[value_index], legacy);
else return ((const SDP__attribute__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__attribute__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__attribute__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__attribute__list*)value_ptr)[index_value].log();
} else {
((const SDP__attribute__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__attribute__list*)value_ptr)[index_value], legacy);
}
}

SDP__attribute__list_template::SDP__attribute__list_template()
{
}

SDP__attribute__list_template::SDP__attribute__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__attribute__list_template::SDP__attribute__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__attribute__list_template::SDP__attribute__list_template(const SDP__attribute__list& other_value)
{
copy_value(other_value);
}

SDP__attribute__list_template::SDP__attribute__list_template(const OPTIONAL<SDP__attribute__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_attribute_list from an unbound optional field.");
}
}

SDP__attribute__list_template::SDP__attribute__list_template(SDP__attribute__list_template* p_precondition, SDP__attribute__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__attribute__list_template::SDP__attribute__list_template(Dynamic_Match_Interface<SDP__attribute__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__attribute__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__attribute__list_template::SDP__attribute__list_template(const SDP__attribute__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__attribute__list_template::~SDP__attribute__list_template()
{
clean_up();
}

void SDP__attribute__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__attribute__list_template& SDP__attribute__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__attribute__list_template& SDP__attribute__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__attribute__list_template& SDP__attribute__list_template::operator=(const SDP__attribute__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__attribute__list_template& SDP__attribute__list_template::operator=(const OPTIONAL<SDP__attribute__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__attribute__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_attribute_list.");
}
return *this;
}

SDP__attribute__list_template& SDP__attribute__list_template::operator=(const SDP__attribute__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__attribute_template& SDP__attribute__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_attribute_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_attribute_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__attribute_template& SDP__attribute__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_attribute_list.");
return (*this)[(int)index_value];
}

const SDP__attribute_template& SDP__attribute__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_attribute_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_attribute_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_attribute_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__attribute_template& SDP__attribute__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_attribute_list.");
return (*this)[(int)index_value];
}

void SDP__attribute__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_attribute_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__attribute_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__attribute_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__attribute_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__attribute_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__attribute__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__attribute__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_attribute_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_attribute_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_attribute_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_attribute_list");
}

boolean SDP__attribute__list_template::match(const SDP__attribute__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_list.");
}
return FALSE;
}

boolean SDP__attribute__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__attribute__list SDP__attribute__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_attribute_list.");
SDP__attribute__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__attribute__list SDP__attribute__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__attribute__list SDP__attribute__list_template::replace(int index, int len, const SDP__attribute__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__attribute__list SDP__attribute__list_template::replace(int index, int len, const SDP__attribute__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__attribute__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__attribute__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__attribute_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_attribute_list.");
}
set_selection(template_type);
}

SDP__attribute__list_template& SDP__attribute__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_attribute_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_attribute_list.");
return value_list.list_value[list_index];
}

SDP__attribute_template& SDP__attribute__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_attribute_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_attribute_list.");
return value_set.set_items[set_index];
}

void SDP__attribute__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__attribute__list_template::log_match(const SDP__attribute__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__attribute__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_attribute_list.");
}
}

void SDP__attribute__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_attribute_list.");
single_value.value_elements = (SDP__attribute_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__attribute_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__attribute__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__attribute_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_attribute_list.");
}
}

boolean SDP__attribute__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__attribute__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__attribute__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__attribute__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__attribute__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__attribute__list_template* precondition = new SDP__attribute__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__attribute__list_template* implied_template = new SDP__attribute__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__attribute__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_attribute_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__attribute__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_attribute_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_attribute_list");
}

boolean SDP__attribute__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

const SDP__bandwidth SDP__bandwidth__list::UNBOUND_ELEM;
boolean SDP__bandwidth__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__bandwidth__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (((const SDP__bandwidth__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (((const SDP__bandwidth__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__bandwidth__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__bandwidth__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__bandwidth__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__bandwidth__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__bandwidth__list::SDP__bandwidth__list()
{
val_ptr = NULL;
}

SDP__bandwidth__list::SDP__bandwidth__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__bandwidth__list::SDP__bandwidth__list(const SDP__bandwidth__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_bandwidth_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__bandwidth__list::~SDP__bandwidth__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__bandwidth__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__bandwidth__list& SDP__bandwidth__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__bandwidth__list& SDP__bandwidth__list::operator=(const SDP__bandwidth__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__bandwidth__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__bandwidth__list::operator==(const SDP__bandwidth__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__bandwidth& SDP__bandwidth__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_bandwidth_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__bandwidth**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__bandwidth(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__bandwidth;
}
return *val_ptr->value_elements[index_value];
}

SDP__bandwidth& SDP__bandwidth__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_bandwidth_list.");
return (*this)[(int)index_value];
}

const SDP__bandwidth& SDP__bandwidth__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_bandwidth_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_bandwidth_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__bandwidth& SDP__bandwidth__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_bandwidth_list.");
return (*this)[(int)index_value];
}

SDP__bandwidth__list SDP__bandwidth__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__bandwidth__list SDP__bandwidth__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__bandwidth__list SDP__bandwidth__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__bandwidth__list SDP__bandwidth__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__bandwidth__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__bandwidth(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__bandwidth__list SDP__bandwidth__list::operator+(const SDP__bandwidth__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_bandwidth_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__bandwidth__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__bandwidth(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__bandwidth(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__bandwidth__list SDP__bandwidth__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_bandwidth_list","element");
SDP__bandwidth__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__bandwidth(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__bandwidth__list SDP__bandwidth__list::replace(int index, int len, const SDP__bandwidth__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_bandwidth_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_bandwidth_list","element");
SDP__bandwidth__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__bandwidth(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__bandwidth(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__bandwidth(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__bandwidth__list SDP__bandwidth__list::replace(int index, int len, const SDP__bandwidth__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__bandwidth__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_bandwidth_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__bandwidth**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__bandwidth(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__bandwidth**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_bandwidth_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__bandwidth**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__bandwidth__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__bandwidth__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_bandwidth_list.");
return val_ptr->n_elements;
}

int SDP__bandwidth__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_bandwidth_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__bandwidth__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__bandwidth__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__bandwidth__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_bandwidth_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_bandwidth_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__bandwidth__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_bandwidth_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__bandwidth__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_bandwidth_list.");
val_ptr->value_elements = (SDP__bandwidth**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__bandwidth;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__bandwidth__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__bandwidth__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__bandwidth__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__bandwidth__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__bandwidth *val=new SDP__bandwidth;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__bandwidth**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__bandwidth__list_template::copy_value(const SDP__bandwidth__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_bandwidth_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__bandwidth_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__bandwidth_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__bandwidth_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__bandwidth__list_template::copy_template(const SDP__bandwidth__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__bandwidth_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__bandwidth_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__bandwidth_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__bandwidth__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__bandwidth_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__bandwidth__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__bandwidth__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth_list.");
break;
}
set_selection(other_value);
}

boolean SDP__bandwidth__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__bandwidth__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__bandwidth__list*)value_ptr)[value_index], legacy);
else return ((const SDP__bandwidth__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__bandwidth__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__bandwidth__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__bandwidth__list*)value_ptr)[value_index], legacy);
else return ((const SDP__bandwidth__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__bandwidth__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__bandwidth__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__bandwidth__list*)value_ptr)[index_value].log();
} else {
((const SDP__bandwidth__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__bandwidth__list*)value_ptr)[index_value], legacy);
}
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template()
{
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(const SDP__bandwidth__list& other_value)
{
copy_value(other_value);
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(const OPTIONAL<SDP__bandwidth__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__bandwidth__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_bandwidth_list from an unbound optional field.");
}
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(SDP__bandwidth__list_template* p_precondition, SDP__bandwidth__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(Dynamic_Match_Interface<SDP__bandwidth__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__bandwidth__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__bandwidth__list_template::SDP__bandwidth__list_template(const SDP__bandwidth__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__bandwidth__list_template::~SDP__bandwidth__list_template()
{
clean_up();
}

void SDP__bandwidth__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::operator=(const SDP__bandwidth__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::operator=(const OPTIONAL<SDP__bandwidth__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__bandwidth__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_bandwidth_list.");
}
return *this;
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::operator=(const SDP__bandwidth__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__bandwidth_template& SDP__bandwidth__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_bandwidth_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_bandwidth_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__bandwidth_template& SDP__bandwidth__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_bandwidth_list.");
return (*this)[(int)index_value];
}

const SDP__bandwidth_template& SDP__bandwidth__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_bandwidth_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_bandwidth_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_bandwidth_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__bandwidth_template& SDP__bandwidth__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_bandwidth_list.");
return (*this)[(int)index_value];
}

void SDP__bandwidth__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_bandwidth_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__bandwidth_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__bandwidth_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__bandwidth_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__bandwidth_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__bandwidth__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__bandwidth__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_bandwidth_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_bandwidth_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_bandwidth_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_bandwidth_list");
}

boolean SDP__bandwidth__list_template::match(const SDP__bandwidth__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth_list.");
}
return FALSE;
}

boolean SDP__bandwidth__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__bandwidth__list SDP__bandwidth__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_bandwidth_list.");
SDP__bandwidth__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__bandwidth__list SDP__bandwidth__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__bandwidth__list SDP__bandwidth__list_template::replace(int index, int len, const SDP__bandwidth__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__bandwidth__list SDP__bandwidth__list_template::replace(int index, int len, const SDP__bandwidth__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__bandwidth__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__bandwidth__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__bandwidth_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_bandwidth_list.");
}
set_selection(template_type);
}

SDP__bandwidth__list_template& SDP__bandwidth__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_bandwidth_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_bandwidth_list.");
return value_list.list_value[list_index];
}

SDP__bandwidth_template& SDP__bandwidth__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_bandwidth_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_bandwidth_list.");
return value_set.set_items[set_index];
}

void SDP__bandwidth__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__bandwidth__list_template::log_match(const SDP__bandwidth__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__bandwidth__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth_list.");
}
}

void SDP__bandwidth__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_bandwidth_list.");
single_value.value_elements = (SDP__bandwidth_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__bandwidth_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__bandwidth__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__bandwidth_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_bandwidth_list.");
}
}

boolean SDP__bandwidth__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__bandwidth__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__bandwidth__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__bandwidth__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__bandwidth__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__bandwidth__list_template* precondition = new SDP__bandwidth__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__bandwidth__list_template* implied_template = new SDP__bandwidth__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__bandwidth__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_bandwidth_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__bandwidth__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_bandwidth_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_bandwidth_list");
}

boolean SDP__bandwidth__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__bandwidth::SDP__bandwidth()
{
}

SDP__bandwidth::SDP__bandwidth(const CHARSTRING& par_modifier,
    const INTEGER& par_bandwidth)
  :   field_modifier(par_modifier),
  field_bandwidth(par_bandwidth)
{
}

SDP__bandwidth::SDP__bandwidth(const SDP__bandwidth& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_bandwidth.");
if (other_value.modifier().is_bound()) field_modifier = other_value.modifier();
else field_modifier.clean_up();
if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
else field_bandwidth.clean_up();
}

void SDP__bandwidth::clean_up()
{
field_modifier.clean_up();
field_bandwidth.clean_up();
}

const TTCN_Typedescriptor_t* SDP__bandwidth::get_descriptor() const { return &SDP__bandwidth_descr_; }
SDP__bandwidth& SDP__bandwidth::operator=(const SDP__bandwidth& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_bandwidth.");
  if (other_value.modifier().is_bound()) field_modifier = other_value.modifier();
  else field_modifier.clean_up();
  if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
  else field_bandwidth.clean_up();
}
return *this;
}

boolean SDP__bandwidth::operator==(const SDP__bandwidth& other_value) const
{
return field_modifier==other_value.field_modifier
  && field_bandwidth==other_value.field_bandwidth;
}

boolean SDP__bandwidth::is_bound() const
{
return (field_modifier.is_bound())
  || (field_bandwidth.is_bound());
}
boolean SDP__bandwidth::is_value() const
{
return field_modifier.is_value()
  && field_bandwidth.is_value();
}
void SDP__bandwidth::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ modifier := ");
field_modifier.log();
TTCN_Logger::log_event_str(", bandwidth := ");
field_bandwidth.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__bandwidth::set_implicit_omit()
{
if (modifier().is_bound()) modifier().set_implicit_omit();
if (bandwidth().is_bound()) bandwidth().set_implicit_omit();
}

void SDP__bandwidth::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_bandwidth has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) modifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_bandwidth: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_bandwidth");
  }
}

void SDP__bandwidth::encode_text(Text_Buf& text_buf) const
{
field_modifier.encode_text(text_buf);
field_bandwidth.encode_text(text_buf);
}

void SDP__bandwidth::decode_text(Text_Buf& text_buf)
{
field_modifier.decode_text(text_buf);
field_bandwidth.decode_text(text_buf);
}

void SDP__bandwidth::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__bandwidth::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__bandwidth::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_modifier.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_bandwidth.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__bandwidth::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_modifier.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'modifier' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_bandwidth.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'bandwidth' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__bandwidth_template::single_value_struct {
CHARSTRING_template field_modifier;
INTEGER_template field_bandwidth;
};

void SDP__bandwidth_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_modifier = ANY_VALUE;
single_value->field_bandwidth = ANY_VALUE;
}
}
}

void SDP__bandwidth_template::copy_value(const SDP__bandwidth& other_value)
{
single_value = new single_value_struct;
if (other_value.modifier().is_bound()) {
  single_value->field_modifier = other_value.modifier();
} else {
  single_value->field_modifier.clean_up();
}
if (other_value.bandwidth().is_bound()) {
  single_value->field_bandwidth = other_value.bandwidth();
} else {
  single_value->field_bandwidth.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__bandwidth_template::copy_template(const SDP__bandwidth_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.modifier().get_selection()) {
single_value->field_modifier = other_value.modifier();
} else {
single_value->field_modifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth().get_selection()) {
single_value->field_bandwidth = other_value.bandwidth();
} else {
single_value->field_bandwidth.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__bandwidth_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__bandwidth_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__bandwidth_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth.");
break;
}
set_selection(other_value);
}

SDP__bandwidth_template::SDP__bandwidth_template()
{
}

SDP__bandwidth_template::SDP__bandwidth_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__bandwidth_template::SDP__bandwidth_template(const SDP__bandwidth& other_value)
{
copy_value(other_value);
}

SDP__bandwidth_template::SDP__bandwidth_template(const OPTIONAL<SDP__bandwidth>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__bandwidth&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_bandwidth from an unbound optional field.");
}
}

SDP__bandwidth_template::SDP__bandwidth_template(SDP__bandwidth_template* p_precondition, SDP__bandwidth_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__bandwidth_template::SDP__bandwidth_template(Dynamic_Match_Interface<SDP__bandwidth>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__bandwidth>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__bandwidth_template::SDP__bandwidth_template(const SDP__bandwidth_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__bandwidth_template::~SDP__bandwidth_template()
{
clean_up();
}

SDP__bandwidth_template& SDP__bandwidth_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__bandwidth_template& SDP__bandwidth_template::operator=(const SDP__bandwidth& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__bandwidth_template& SDP__bandwidth_template::operator=(const OPTIONAL<SDP__bandwidth>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__bandwidth&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_bandwidth.");
}
return *this;
}

SDP__bandwidth_template& SDP__bandwidth_template::operator=(const SDP__bandwidth_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__bandwidth_template::match(const SDP__bandwidth& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.modifier().is_bound()) return FALSE;
if(!single_value->field_modifier.match(other_value.modifier(), legacy))return FALSE;
if(!other_value.bandwidth().is_bound()) return FALSE;
if(!single_value->field_bandwidth.match(other_value.bandwidth(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth.");
}
return FALSE;
}

boolean SDP__bandwidth_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_modifier.is_bound()
 || single_value->field_bandwidth.is_bound();
}

boolean SDP__bandwidth_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_modifier.is_value()
 && single_value->field_bandwidth.is_value();
}

void SDP__bandwidth_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__bandwidth SDP__bandwidth_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_bandwidth.");
SDP__bandwidth ret_val;
if (single_value->field_modifier.is_bound()) {
ret_val.modifier() = single_value->field_modifier.valueof();
}
if (single_value->field_bandwidth.is_bound()) {
ret_val.bandwidth() = single_value->field_bandwidth.valueof();
}
return ret_val;
}

void SDP__bandwidth_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_bandwidth.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__bandwidth_template[list_length];
}

SDP__bandwidth_template& SDP__bandwidth_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_bandwidth.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_bandwidth.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__bandwidth_template::modifier()
{
set_specific();
return single_value->field_modifier;
}

const CHARSTRING_template& SDP__bandwidth_template::modifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field modifier of a non-specific template of type @SDP_Types.SDP_bandwidth.");
return single_value->field_modifier;
}

INTEGER_template& SDP__bandwidth_template::bandwidth()
{
set_specific();
return single_value->field_bandwidth;
}

const INTEGER_template& SDP__bandwidth_template::bandwidth() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth of a non-specific template of type @SDP_Types.SDP_bandwidth.");
return single_value->field_bandwidth;
}

int SDP__bandwidth_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_bandwidth containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth.");
  }
  return 0;
}

void SDP__bandwidth_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ modifier := ");
single_value->field_modifier.log();
TTCN_Logger::log_event_str(", bandwidth := ");
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__bandwidth_template::log_match(const SDP__bandwidth& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_modifier.match(match_value.modifier(), legacy)){
TTCN_Logger::log_logmatch_info(".modifier");
single_value->field_modifier.log_match(match_value.modifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bandwidth.match(match_value.bandwidth(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth");
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ modifier := ");
single_value->field_modifier.log_match(match_value.modifier(), legacy);
TTCN_Logger::log_event_str(", bandwidth := ");
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__bandwidth_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (modifier().is_bound()) modifier().set_implicit_omit();
if (bandwidth().is_bound()) bandwidth().set_implicit_omit();
}

void SDP__bandwidth_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_modifier.encode_text(text_buf);
single_value->field_bandwidth.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_bandwidth.");
}
}

void SDP__bandwidth_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_modifier.decode_text(text_buf);
single_value->field_bandwidth.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__bandwidth_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_bandwidth.");
}
}

void SDP__bandwidth_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__bandwidth_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_bandwidth has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) modifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "modifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          modifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_bandwidth: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__bandwidth_template* precondition = new SDP__bandwidth_template;
    precondition->set_param(*param.get_elem(0));
    SDP__bandwidth_template* implied_template = new SDP__bandwidth_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__bandwidth_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_bandwidth");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__bandwidth_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_modifier.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_bandwidth");
single_value->field_bandwidth.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_bandwidth");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_bandwidth");
}

boolean SDP__bandwidth_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__bandwidth_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__conn__addr::SDP__conn__addr()
{
}

SDP__conn__addr::SDP__conn__addr(const CHARSTRING& par_addr,
    const OPTIONAL< INTEGER >& par_ttl,
    const OPTIONAL< INTEGER >& par_num__of__addr)
  :   field_addr(par_addr),
  field_ttl(par_ttl),
  field_num__of__addr(par_num__of__addr)
{
}

SDP__conn__addr::SDP__conn__addr(const SDP__conn__addr& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_conn_addr.");
if (other_value.addr().is_bound()) field_addr = other_value.addr();
else field_addr.clean_up();
if (other_value.ttl().is_bound()) field_ttl = other_value.ttl();
else field_ttl.clean_up();
if (other_value.num__of__addr().is_bound()) field_num__of__addr = other_value.num__of__addr();
else field_num__of__addr.clean_up();
}

void SDP__conn__addr::clean_up()
{
field_addr.clean_up();
field_ttl.clean_up();
field_num__of__addr.clean_up();
}

const TTCN_Typedescriptor_t* SDP__conn__addr::get_descriptor() const { return &SDP__conn__addr_descr_; }
SDP__conn__addr& SDP__conn__addr::operator=(const SDP__conn__addr& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_conn_addr.");
  if (other_value.addr().is_bound()) field_addr = other_value.addr();
  else field_addr.clean_up();
  if (other_value.ttl().is_bound()) field_ttl = other_value.ttl();
  else field_ttl.clean_up();
  if (other_value.num__of__addr().is_bound()) field_num__of__addr = other_value.num__of__addr();
  else field_num__of__addr.clean_up();
}
return *this;
}

boolean SDP__conn__addr::operator==(const SDP__conn__addr& other_value) const
{
return field_addr==other_value.field_addr
  && field_ttl==other_value.field_ttl
  && field_num__of__addr==other_value.field_num__of__addr;
}

boolean SDP__conn__addr::is_bound() const
{
return (field_addr.is_bound())
  || (OPTIONAL_OMIT == field_ttl.get_selection() || field_ttl.is_bound())
  || (OPTIONAL_OMIT == field_num__of__addr.get_selection() || field_num__of__addr.is_bound());
}
boolean SDP__conn__addr::is_value() const
{
return field_addr.is_value()
  && (OPTIONAL_OMIT == field_ttl.get_selection() || field_ttl.is_value())
  && (OPTIONAL_OMIT == field_num__of__addr.get_selection() || field_num__of__addr.is_value());
}
int SDP__conn__addr::size_of() const
{
  int ret_val = 1;
  if (field_ttl.ispresent()) ret_val++;
  if (field_num__of__addr.ispresent()) ret_val++;
  return ret_val;
}

void SDP__conn__addr::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ addr := ");
field_addr.log();
TTCN_Logger::log_event_str(", ttl := ");
field_ttl.log();
TTCN_Logger::log_event_str(", num_of_addr := ");
field_num__of__addr.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__conn__addr::set_implicit_omit()
{
if (addr().is_bound()) addr().set_implicit_omit();
if (!ttl().is_bound()) ttl() = OMIT_VALUE;
else ttl().set_implicit_omit();
if (!num__of__addr().is_bound()) num__of__addr() = OMIT_VALUE;
else num__of__addr().set_implicit_omit();
}

void SDP__conn__addr::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_conn_addr has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) addr().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ttl().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) num__of__addr().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ttl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ttl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_of_addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__of__addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_conn_addr: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_conn_addr");
  }
}

void SDP__conn__addr::encode_text(Text_Buf& text_buf) const
{
field_addr.encode_text(text_buf);
field_ttl.encode_text(text_buf);
field_num__of__addr.encode_text(text_buf);
}

void SDP__conn__addr::decode_text(Text_Buf& text_buf)
{
field_addr.decode_text(text_buf);
field_ttl.decode_text(text_buf);
field_num__of__addr.decode_text(text_buf);
}

void SDP__conn__addr::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__conn__addr::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__conn__addr::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_addr.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(field_ttl.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_ttl().TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_num__of__addr.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_num__of__addr().TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__conn__addr::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_ttl=OMIT_VALUE;
    field_num__of__addr=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_addr.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'addr' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_ttl().TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_ttl=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_ttl=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_num__of__addr().TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_num__of__addr=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__conn__addr_template::single_value_struct {
CHARSTRING_template field_addr;
INTEGER_template field_ttl;
INTEGER_template field_num__of__addr;
};

void SDP__conn__addr_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_addr = ANY_VALUE;
single_value->field_ttl = ANY_OR_OMIT;
single_value->field_num__of__addr = ANY_OR_OMIT;
}
}
}

void SDP__conn__addr_template::copy_value(const SDP__conn__addr& other_value)
{
single_value = new single_value_struct;
if (other_value.addr().is_bound()) {
  single_value->field_addr = other_value.addr();
} else {
  single_value->field_addr.clean_up();
}
if (other_value.ttl().is_bound()) {
  if (other_value.ttl().ispresent()) single_value->field_ttl = other_value.ttl()();
  else single_value->field_ttl = OMIT_VALUE;
} else {
  single_value->field_ttl.clean_up();
}
if (other_value.num__of__addr().is_bound()) {
  if (other_value.num__of__addr().ispresent()) single_value->field_num__of__addr = other_value.num__of__addr()();
  else single_value->field_num__of__addr = OMIT_VALUE;
} else {
  single_value->field_num__of__addr.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__conn__addr_template::copy_template(const SDP__conn__addr_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.addr().get_selection()) {
single_value->field_addr = other_value.addr();
} else {
single_value->field_addr.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ttl().get_selection()) {
single_value->field_ttl = other_value.ttl();
} else {
single_value->field_ttl.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.num__of__addr().get_selection()) {
single_value->field_num__of__addr = other_value.num__of__addr();
} else {
single_value->field_num__of__addr.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__conn__addr_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__conn__addr_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__conn__addr_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_conn_addr.");
break;
}
set_selection(other_value);
}

SDP__conn__addr_template::SDP__conn__addr_template()
{
}

SDP__conn__addr_template::SDP__conn__addr_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__conn__addr_template::SDP__conn__addr_template(const SDP__conn__addr& other_value)
{
copy_value(other_value);
}

SDP__conn__addr_template::SDP__conn__addr_template(const OPTIONAL<SDP__conn__addr>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__conn__addr&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_conn_addr from an unbound optional field.");
}
}

SDP__conn__addr_template::SDP__conn__addr_template(SDP__conn__addr_template* p_precondition, SDP__conn__addr_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__conn__addr_template::SDP__conn__addr_template(Dynamic_Match_Interface<SDP__conn__addr>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__conn__addr>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__conn__addr_template::SDP__conn__addr_template(const SDP__conn__addr_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__conn__addr_template::~SDP__conn__addr_template()
{
clean_up();
}

SDP__conn__addr_template& SDP__conn__addr_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__conn__addr_template& SDP__conn__addr_template::operator=(const SDP__conn__addr& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__conn__addr_template& SDP__conn__addr_template::operator=(const OPTIONAL<SDP__conn__addr>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__conn__addr&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_conn_addr.");
}
return *this;
}

SDP__conn__addr_template& SDP__conn__addr_template::operator=(const SDP__conn__addr_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__conn__addr_template::match(const SDP__conn__addr& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.addr().is_bound()) return FALSE;
if(!single_value->field_addr.match(other_value.addr(), legacy))return FALSE;
if(!other_value.ttl().is_bound()) return FALSE;
if((other_value.ttl().ispresent() ? !single_value->field_ttl.match((const INTEGER&)other_value.ttl(), legacy) : !single_value->field_ttl.match_omit(legacy)))return FALSE;
if(!other_value.num__of__addr().is_bound()) return FALSE;
if((other_value.num__of__addr().ispresent() ? !single_value->field_num__of__addr.match((const INTEGER&)other_value.num__of__addr(), legacy) : !single_value->field_num__of__addr.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_conn_addr.");
}
return FALSE;
}

boolean SDP__conn__addr_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_addr.is_bound()
 || (single_value->field_ttl.is_omit() || single_value->field_ttl.is_bound())
 || (single_value->field_num__of__addr.is_omit() || single_value->field_num__of__addr.is_bound());
}

boolean SDP__conn__addr_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_addr.is_value()
 && (single_value->field_ttl.is_omit() || single_value->field_ttl.is_value())
 && (single_value->field_num__of__addr.is_omit() || single_value->field_num__of__addr.is_value());
}

void SDP__conn__addr_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__conn__addr SDP__conn__addr_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_conn_addr.");
SDP__conn__addr ret_val;
if (single_value->field_addr.is_bound()) {
ret_val.addr() = single_value->field_addr.valueof();
}
if (single_value->field_ttl.is_omit()) ret_val.ttl() = OMIT_VALUE;
else if (single_value->field_ttl.is_bound()) {
ret_val.ttl() = single_value->field_ttl.valueof();
}
if (single_value->field_num__of__addr.is_omit()) ret_val.num__of__addr() = OMIT_VALUE;
else if (single_value->field_num__of__addr.is_bound()) {
ret_val.num__of__addr() = single_value->field_num__of__addr.valueof();
}
return ret_val;
}

void SDP__conn__addr_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_conn_addr.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__conn__addr_template[list_length];
}

SDP__conn__addr_template& SDP__conn__addr_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_conn_addr.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_conn_addr.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__conn__addr_template::addr()
{
set_specific();
return single_value->field_addr;
}

const CHARSTRING_template& SDP__conn__addr_template::addr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field addr of a non-specific template of type @SDP_Types.SDP_conn_addr.");
return single_value->field_addr;
}

INTEGER_template& SDP__conn__addr_template::ttl()
{
set_specific();
return single_value->field_ttl;
}

const INTEGER_template& SDP__conn__addr_template::ttl() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ttl of a non-specific template of type @SDP_Types.SDP_conn_addr.");
return single_value->field_ttl;
}

INTEGER_template& SDP__conn__addr_template::num__of__addr()
{
set_specific();
return single_value->field_num__of__addr;
}

const INTEGER_template& SDP__conn__addr_template::num__of__addr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field num_of_addr of a non-specific template of type @SDP_Types.SDP_conn_addr.");
return single_value->field_num__of__addr;
}

int SDP__conn__addr_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_ttl.is_present()) ret_val++;
      if (single_value->field_num__of__addr.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_conn_addr containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_conn_addr.");
  }
  return 0;
}

void SDP__conn__addr_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ addr := ");
single_value->field_addr.log();
TTCN_Logger::log_event_str(", ttl := ");
single_value->field_ttl.log();
TTCN_Logger::log_event_str(", num_of_addr := ");
single_value->field_num__of__addr.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__conn__addr_template::log_match(const SDP__conn__addr& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_addr.match(match_value.addr(), legacy)){
TTCN_Logger::log_logmatch_info(".addr");
single_value->field_addr.log_match(match_value.addr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ttl().ispresent()){
if(!single_value->field_ttl.match(match_value.ttl(), legacy)){
TTCN_Logger::log_logmatch_info(".ttl");
single_value->field_ttl.log_match(match_value.ttl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ttl.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ttl := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ttl.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.num__of__addr().ispresent()){
if(!single_value->field_num__of__addr.match(match_value.num__of__addr(), legacy)){
TTCN_Logger::log_logmatch_info(".num_of_addr");
single_value->field_num__of__addr.log_match(match_value.num__of__addr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_num__of__addr.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".num_of_addr := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_num__of__addr.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ addr := ");
single_value->field_addr.log_match(match_value.addr(), legacy);
TTCN_Logger::log_event_str(", ttl := ");
if (match_value.ttl().ispresent()) {
single_value->field_ttl.log_match(match_value.ttl(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ttl.log();
if (single_value->field_ttl.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", num_of_addr := ");
if (match_value.num__of__addr().ispresent()) {
single_value->field_num__of__addr.log_match(match_value.num__of__addr(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_num__of__addr.log();
if (single_value->field_num__of__addr.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__conn__addr_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (addr().is_bound()) addr().set_implicit_omit();
if (!ttl().is_bound()) ttl() = OMIT_VALUE;
else ttl().set_implicit_omit();
if (!num__of__addr().is_bound()) num__of__addr() = OMIT_VALUE;
else num__of__addr().set_implicit_omit();
}

void SDP__conn__addr_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_addr.encode_text(text_buf);
single_value->field_ttl.encode_text(text_buf);
single_value->field_num__of__addr.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_conn_addr.");
}
}

void SDP__conn__addr_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_addr.decode_text(text_buf);
single_value->field_ttl.decode_text(text_buf);
single_value->field_num__of__addr.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__conn__addr_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_conn_addr.");
}
}

void SDP__conn__addr_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__conn__addr_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_conn_addr has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) addr().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ttl().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) num__of__addr().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ttl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ttl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_of_addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__of__addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_conn_addr: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__conn__addr_template* precondition = new SDP__conn__addr_template;
    precondition->set_param(*param.get_elem(0));
    SDP__conn__addr_template* implied_template = new SDP__conn__addr_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__conn__addr_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_conn_addr");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__conn__addr_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_addr.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_conn_addr");
single_value->field_ttl.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_conn_addr");
single_value->field_num__of__addr.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_conn_addr");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_conn_addr");
}

boolean SDP__conn__addr_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__conn__addr_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__connection::SDP__connection()
{
}

SDP__connection::SDP__connection(const CHARSTRING& par_net__type,
    const CHARSTRING& par_addr__type,
    const SDP__conn__addr& par_conn__addr)
  :   field_net__type(par_net__type),
  field_addr__type(par_addr__type),
  field_conn__addr(par_conn__addr)
{
}

SDP__connection::SDP__connection(const SDP__connection& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_connection.");
if (other_value.net__type().is_bound()) field_net__type = other_value.net__type();
else field_net__type.clean_up();
if (other_value.addr__type().is_bound()) field_addr__type = other_value.addr__type();
else field_addr__type.clean_up();
if (other_value.conn__addr().is_bound()) field_conn__addr = other_value.conn__addr();
else field_conn__addr.clean_up();
}

void SDP__connection::clean_up()
{
field_net__type.clean_up();
field_addr__type.clean_up();
field_conn__addr.clean_up();
}

const TTCN_Typedescriptor_t* SDP__connection::get_descriptor() const { return &SDP__connection_descr_; }
SDP__connection& SDP__connection::operator=(const SDP__connection& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_connection.");
  if (other_value.net__type().is_bound()) field_net__type = other_value.net__type();
  else field_net__type.clean_up();
  if (other_value.addr__type().is_bound()) field_addr__type = other_value.addr__type();
  else field_addr__type.clean_up();
  if (other_value.conn__addr().is_bound()) field_conn__addr = other_value.conn__addr();
  else field_conn__addr.clean_up();
}
return *this;
}

boolean SDP__connection::operator==(const SDP__connection& other_value) const
{
return field_net__type==other_value.field_net__type
  && field_addr__type==other_value.field_addr__type
  && field_conn__addr==other_value.field_conn__addr;
}

boolean SDP__connection::is_bound() const
{
return (field_net__type.is_bound())
  || (field_addr__type.is_bound())
  || (field_conn__addr.is_bound());
}
boolean SDP__connection::is_value() const
{
return field_net__type.is_value()
  && field_addr__type.is_value()
  && field_conn__addr.is_value();
}
void SDP__connection::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ net_type := ");
field_net__type.log();
TTCN_Logger::log_event_str(", addr_type := ");
field_addr__type.log();
TTCN_Logger::log_event_str(", conn_addr := ");
field_conn__addr.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__connection::set_implicit_omit()
{
if (net__type().is_bound()) net__type().set_implicit_omit();
if (addr__type().is_bound()) addr__type().set_implicit_omit();
if (conn__addr().is_bound()) conn__addr().set_implicit_omit();
}

void SDP__connection::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_connection has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) net__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) addr__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) conn__addr().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "net_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          net__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "conn_addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          conn__addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_connection: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_connection");
  }
}

void SDP__connection::encode_text(Text_Buf& text_buf) const
{
field_net__type.encode_text(text_buf);
field_addr__type.encode_text(text_buf);
field_conn__addr.encode_text(text_buf);
}

void SDP__connection::decode_text(Text_Buf& text_buf)
{
field_net__type.decode_text(text_buf);
field_addr__type.decode_text(text_buf);
field_conn__addr.decode_text(text_buf);
}

void SDP__connection::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__connection::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__connection::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_net__type.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_addr__type.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_conn__addr.TEXT_encode(SDP__conn__addr_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__connection::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_net__type.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'net__type' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_addr__type.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'addr__type' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_conn__addr.TEXT_decode(SDP__conn__addr_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'conn__addr' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__connection_template::single_value_struct {
CHARSTRING_template field_net__type;
CHARSTRING_template field_addr__type;
SDP__conn__addr_template field_conn__addr;
};

void SDP__connection_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_net__type = ANY_VALUE;
single_value->field_addr__type = ANY_VALUE;
single_value->field_conn__addr = ANY_VALUE;
}
}
}

void SDP__connection_template::copy_value(const SDP__connection& other_value)
{
single_value = new single_value_struct;
if (other_value.net__type().is_bound()) {
  single_value->field_net__type = other_value.net__type();
} else {
  single_value->field_net__type.clean_up();
}
if (other_value.addr__type().is_bound()) {
  single_value->field_addr__type = other_value.addr__type();
} else {
  single_value->field_addr__type.clean_up();
}
if (other_value.conn__addr().is_bound()) {
  single_value->field_conn__addr = other_value.conn__addr();
} else {
  single_value->field_conn__addr.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__connection_template::copy_template(const SDP__connection_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.net__type().get_selection()) {
single_value->field_net__type = other_value.net__type();
} else {
single_value->field_net__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.addr__type().get_selection()) {
single_value->field_addr__type = other_value.addr__type();
} else {
single_value->field_addr__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.conn__addr().get_selection()) {
single_value->field_conn__addr = other_value.conn__addr();
} else {
single_value->field_conn__addr.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__connection_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__connection_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__connection_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_connection.");
break;
}
set_selection(other_value);
}

SDP__connection_template::SDP__connection_template()
{
}

SDP__connection_template::SDP__connection_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__connection_template::SDP__connection_template(const SDP__connection& other_value)
{
copy_value(other_value);
}

SDP__connection_template::SDP__connection_template(const OPTIONAL<SDP__connection>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__connection&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_connection from an unbound optional field.");
}
}

SDP__connection_template::SDP__connection_template(SDP__connection_template* p_precondition, SDP__connection_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__connection_template::SDP__connection_template(Dynamic_Match_Interface<SDP__connection>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__connection>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__connection_template::SDP__connection_template(const SDP__connection_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__connection_template::~SDP__connection_template()
{
clean_up();
}

SDP__connection_template& SDP__connection_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__connection_template& SDP__connection_template::operator=(const SDP__connection& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__connection_template& SDP__connection_template::operator=(const OPTIONAL<SDP__connection>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__connection&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_connection.");
}
return *this;
}

SDP__connection_template& SDP__connection_template::operator=(const SDP__connection_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__connection_template::match(const SDP__connection& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.net__type().is_bound()) return FALSE;
if(!single_value->field_net__type.match(other_value.net__type(), legacy))return FALSE;
if(!other_value.addr__type().is_bound()) return FALSE;
if(!single_value->field_addr__type.match(other_value.addr__type(), legacy))return FALSE;
if(!other_value.conn__addr().is_bound()) return FALSE;
if(!single_value->field_conn__addr.match(other_value.conn__addr(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_connection.");
}
return FALSE;
}

boolean SDP__connection_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_net__type.is_bound()
 || single_value->field_addr__type.is_bound()
 || single_value->field_conn__addr.is_bound();
}

boolean SDP__connection_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_net__type.is_value()
 && single_value->field_addr__type.is_value()
 && single_value->field_conn__addr.is_value();
}

void SDP__connection_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__connection SDP__connection_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_connection.");
SDP__connection ret_val;
if (single_value->field_net__type.is_bound()) {
ret_val.net__type() = single_value->field_net__type.valueof();
}
if (single_value->field_addr__type.is_bound()) {
ret_val.addr__type() = single_value->field_addr__type.valueof();
}
if (single_value->field_conn__addr.is_bound()) {
ret_val.conn__addr() = single_value->field_conn__addr.valueof();
}
return ret_val;
}

void SDP__connection_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_connection.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__connection_template[list_length];
}

SDP__connection_template& SDP__connection_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_connection.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_connection.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__connection_template::net__type()
{
set_specific();
return single_value->field_net__type;
}

const CHARSTRING_template& SDP__connection_template::net__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field net_type of a non-specific template of type @SDP_Types.SDP_connection.");
return single_value->field_net__type;
}

CHARSTRING_template& SDP__connection_template::addr__type()
{
set_specific();
return single_value->field_addr__type;
}

const CHARSTRING_template& SDP__connection_template::addr__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field addr_type of a non-specific template of type @SDP_Types.SDP_connection.");
return single_value->field_addr__type;
}

SDP__conn__addr_template& SDP__connection_template::conn__addr()
{
set_specific();
return single_value->field_conn__addr;
}

const SDP__conn__addr_template& SDP__connection_template::conn__addr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field conn_addr of a non-specific template of type @SDP_Types.SDP_connection.");
return single_value->field_conn__addr;
}

int SDP__connection_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_connection containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_connection.");
  }
  return 0;
}

void SDP__connection_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ net_type := ");
single_value->field_net__type.log();
TTCN_Logger::log_event_str(", addr_type := ");
single_value->field_addr__type.log();
TTCN_Logger::log_event_str(", conn_addr := ");
single_value->field_conn__addr.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__connection_template::log_match(const SDP__connection& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_net__type.match(match_value.net__type(), legacy)){
TTCN_Logger::log_logmatch_info(".net_type");
single_value->field_net__type.log_match(match_value.net__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_addr__type.match(match_value.addr__type(), legacy)){
TTCN_Logger::log_logmatch_info(".addr_type");
single_value->field_addr__type.log_match(match_value.addr__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_conn__addr.match(match_value.conn__addr(), legacy)){
TTCN_Logger::log_logmatch_info(".conn_addr");
single_value->field_conn__addr.log_match(match_value.conn__addr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ net_type := ");
single_value->field_net__type.log_match(match_value.net__type(), legacy);
TTCN_Logger::log_event_str(", addr_type := ");
single_value->field_addr__type.log_match(match_value.addr__type(), legacy);
TTCN_Logger::log_event_str(", conn_addr := ");
single_value->field_conn__addr.log_match(match_value.conn__addr(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__connection_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (net__type().is_bound()) net__type().set_implicit_omit();
if (addr__type().is_bound()) addr__type().set_implicit_omit();
if (conn__addr().is_bound()) conn__addr().set_implicit_omit();
}

void SDP__connection_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_net__type.encode_text(text_buf);
single_value->field_addr__type.encode_text(text_buf);
single_value->field_conn__addr.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_connection.");
}
}

void SDP__connection_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_net__type.decode_text(text_buf);
single_value->field_addr__type.decode_text(text_buf);
single_value->field_conn__addr.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__connection_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_connection.");
}
}

void SDP__connection_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__connection_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_connection has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) net__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) addr__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) conn__addr().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "net_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          net__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "conn_addr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          conn__addr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_connection: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__connection_template* precondition = new SDP__connection_template;
    precondition->set_param(*param.get_elem(0));
    SDP__connection_template* implied_template = new SDP__connection_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__connection_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_connection");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__connection_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_net__type.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_connection");
single_value->field_addr__type.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_connection");
single_value->field_conn__addr.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_connection");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_connection");
}

boolean SDP__connection_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__connection_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__connection SDP__connection__list::UNBOUND_ELEM;
boolean SDP__connection__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__connection__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_connection_list.");
if (((const SDP__connection__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_connection_list.");
if (((const SDP__connection__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__connection__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__connection__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__connection__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__connection__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__connection__list::SDP__connection__list()
{
val_ptr = NULL;
}

SDP__connection__list::SDP__connection__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__connection__list::SDP__connection__list(const SDP__connection__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_connection_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__connection__list::~SDP__connection__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__connection__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__connection__list& SDP__connection__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__connection__list& SDP__connection__list::operator=(const SDP__connection__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_connection_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__connection__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_connection_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__connection__list::operator==(const SDP__connection__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_connection_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_connection_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__connection& SDP__connection__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_connection_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__connection**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__connection(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__connection;
}
return *val_ptr->value_elements[index_value];
}

SDP__connection& SDP__connection__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_connection_list.");
return (*this)[(int)index_value];
}

const SDP__connection& SDP__connection__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_connection_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_connection_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_connection_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__connection& SDP__connection__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_connection_list.");
return (*this)[(int)index_value];
}

SDP__connection__list SDP__connection__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__connection__list SDP__connection__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__connection__list SDP__connection__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__connection__list SDP__connection__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_connection_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__connection__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__connection(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__connection__list SDP__connection__list::operator+(const SDP__connection__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_connection_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__connection__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__connection(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__connection(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__connection__list SDP__connection__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_connection_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_connection_list","element");
SDP__connection__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__connection(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__connection__list SDP__connection__list::replace(int index, int len, const SDP__connection__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_connection_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_connection_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_connection_list","element");
SDP__connection__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__connection(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__connection(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__connection(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__connection__list SDP__connection__list::replace(int index, int len, const SDP__connection__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__connection__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_connection_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__connection**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__connection(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__connection**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_connection_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__connection**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__connection__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__connection__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_connection_list.");
return val_ptr->n_elements;
}

int SDP__connection__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_connection_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__connection__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__connection__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__connection__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_connection_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_connection_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__connection__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_connection_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__connection__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_connection_list.");
val_ptr->value_elements = (SDP__connection**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__connection;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__connection__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__connection__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__connection__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__connection__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__connection *val=new SDP__connection;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__connection**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__connection__list_template::copy_value(const SDP__connection__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_connection_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__connection_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__connection_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__connection_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__connection__list_template::copy_template(const SDP__connection__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__connection_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__connection_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__connection_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__connection__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__connection_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__connection__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__connection__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_connection_list.");
break;
}
set_selection(other_value);
}

boolean SDP__connection__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__connection__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__connection__list*)value_ptr)[value_index], legacy);
else return ((const SDP__connection__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__connection__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__connection__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__connection__list*)value_ptr)[value_index], legacy);
else return ((const SDP__connection__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__connection__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__connection__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__connection__list*)value_ptr)[index_value].log();
} else {
((const SDP__connection__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__connection__list*)value_ptr)[index_value], legacy);
}
}

SDP__connection__list_template::SDP__connection__list_template()
{
}

SDP__connection__list_template::SDP__connection__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__connection__list_template::SDP__connection__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__connection__list_template::SDP__connection__list_template(const SDP__connection__list& other_value)
{
copy_value(other_value);
}

SDP__connection__list_template::SDP__connection__list_template(const OPTIONAL<SDP__connection__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__connection__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_connection_list from an unbound optional field.");
}
}

SDP__connection__list_template::SDP__connection__list_template(SDP__connection__list_template* p_precondition, SDP__connection__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__connection__list_template::SDP__connection__list_template(Dynamic_Match_Interface<SDP__connection__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__connection__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__connection__list_template::SDP__connection__list_template(const SDP__connection__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__connection__list_template::~SDP__connection__list_template()
{
clean_up();
}

void SDP__connection__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__connection__list_template& SDP__connection__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__connection__list_template& SDP__connection__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__connection__list_template& SDP__connection__list_template::operator=(const SDP__connection__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__connection__list_template& SDP__connection__list_template::operator=(const OPTIONAL<SDP__connection__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__connection__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_connection_list.");
}
return *this;
}

SDP__connection__list_template& SDP__connection__list_template::operator=(const SDP__connection__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__connection_template& SDP__connection__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_connection_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_connection_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__connection_template& SDP__connection__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_connection_list.");
return (*this)[(int)index_value];
}

const SDP__connection_template& SDP__connection__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_connection_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_connection_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_connection_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__connection_template& SDP__connection__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_connection_list.");
return (*this)[(int)index_value];
}

void SDP__connection__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_connection_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__connection_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__connection_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__connection_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__connection_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__connection__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__connection__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_connection_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_connection_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_connection_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_connection_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_connection_list");
}

boolean SDP__connection__list_template::match(const SDP__connection__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_connection_list.");
}
return FALSE;
}

boolean SDP__connection__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__connection__list SDP__connection__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_connection_list.");
SDP__connection__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__connection__list SDP__connection__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__connection__list SDP__connection__list_template::replace(int index, int len, const SDP__connection__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__connection__list SDP__connection__list_template::replace(int index, int len, const SDP__connection__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__connection__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__connection__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__connection_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_connection_list.");
}
set_selection(template_type);
}

SDP__connection__list_template& SDP__connection__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_connection_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_connection_list.");
return value_list.list_value[list_index];
}

SDP__connection_template& SDP__connection__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_connection_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_connection_list.");
return value_set.set_items[set_index];
}

void SDP__connection__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__connection__list_template::log_match(const SDP__connection__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__connection__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_connection_list.");
}
}

void SDP__connection__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_connection_list.");
single_value.value_elements = (SDP__connection_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__connection_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__connection__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__connection_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_connection_list.");
}
}

boolean SDP__connection__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__connection__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__connection__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__connection__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__connection__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__connection__list_template* precondition = new SDP__connection__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__connection__list_template* implied_template = new SDP__connection__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__connection__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_connection_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__connection__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_connection_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_connection_list");
}

boolean SDP__connection__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__contact::SDP__contact()
{
}

SDP__contact::SDP__contact(const CHARSTRING& par_addr__or__phone,
    const OPTIONAL< CHARSTRING >& par_disp__name)
  :   field_addr__or__phone(par_addr__or__phone),
  field_disp__name(par_disp__name)
{
}

SDP__contact::SDP__contact(const SDP__contact& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_contact.");
if (other_value.addr__or__phone().is_bound()) field_addr__or__phone = other_value.addr__or__phone();
else field_addr__or__phone.clean_up();
if (other_value.disp__name().is_bound()) field_disp__name = other_value.disp__name();
else field_disp__name.clean_up();
}

void SDP__contact::clean_up()
{
field_addr__or__phone.clean_up();
field_disp__name.clean_up();
}

const TTCN_Typedescriptor_t* SDP__contact::get_descriptor() const { return &SDP__contact_descr_; }
SDP__contact& SDP__contact::operator=(const SDP__contact& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_contact.");
  if (other_value.addr__or__phone().is_bound()) field_addr__or__phone = other_value.addr__or__phone();
  else field_addr__or__phone.clean_up();
  if (other_value.disp__name().is_bound()) field_disp__name = other_value.disp__name();
  else field_disp__name.clean_up();
}
return *this;
}

boolean SDP__contact::operator==(const SDP__contact& other_value) const
{
return field_addr__or__phone==other_value.field_addr__or__phone
  && field_disp__name==other_value.field_disp__name;
}

boolean SDP__contact::is_bound() const
{
return (field_addr__or__phone.is_bound())
  || (OPTIONAL_OMIT == field_disp__name.get_selection() || field_disp__name.is_bound());
}
boolean SDP__contact::is_value() const
{
return field_addr__or__phone.is_value()
  && (OPTIONAL_OMIT == field_disp__name.get_selection() || field_disp__name.is_value());
}
int SDP__contact::size_of() const
{
  int ret_val = 1;
  if (field_disp__name.ispresent()) ret_val++;
  return ret_val;
}

void SDP__contact::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ addr_or_phone := ");
field_addr__or__phone.log();
TTCN_Logger::log_event_str(", disp_name := ");
field_disp__name.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__contact::set_implicit_omit()
{
if (addr__or__phone().is_bound()) addr__or__phone().set_implicit_omit();
if (!disp__name().is_bound()) disp__name() = OMIT_VALUE;
else disp__name().set_implicit_omit();
}

void SDP__contact::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_contact has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) addr__or__phone().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) disp__name().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr_or_phone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr__or__phone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "disp_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          disp__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_contact: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_contact");
  }
}

void SDP__contact::encode_text(Text_Buf& text_buf) const
{
field_addr__or__phone.encode_text(text_buf);
field_disp__name.encode_text(text_buf);
}

void SDP__contact::decode_text(Text_Buf& text_buf)
{
field_addr__or__phone.decode_text(text_buf);
field_disp__name.decode_text(text_buf);
}

void SDP__contact::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__contact::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__contact::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_addr__or__phone.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(field_disp__name.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_disp__name().TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__contact::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_disp__name=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_addr__or__phone.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'addr__or__phone' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_disp__name().TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_disp__name=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__contact_template::single_value_struct {
CHARSTRING_template field_addr__or__phone;
CHARSTRING_template field_disp__name;
};

void SDP__contact_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_addr__or__phone = ANY_VALUE;
single_value->field_disp__name = ANY_OR_OMIT;
}
}
}

void SDP__contact_template::copy_value(const SDP__contact& other_value)
{
single_value = new single_value_struct;
if (other_value.addr__or__phone().is_bound()) {
  single_value->field_addr__or__phone = other_value.addr__or__phone();
} else {
  single_value->field_addr__or__phone.clean_up();
}
if (other_value.disp__name().is_bound()) {
  if (other_value.disp__name().ispresent()) single_value->field_disp__name = other_value.disp__name()();
  else single_value->field_disp__name = OMIT_VALUE;
} else {
  single_value->field_disp__name.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__contact_template::copy_template(const SDP__contact_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.addr__or__phone().get_selection()) {
single_value->field_addr__or__phone = other_value.addr__or__phone();
} else {
single_value->field_addr__or__phone.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.disp__name().get_selection()) {
single_value->field_disp__name = other_value.disp__name();
} else {
single_value->field_disp__name.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__contact_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__contact_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__contact_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_contact.");
break;
}
set_selection(other_value);
}

SDP__contact_template::SDP__contact_template()
{
}

SDP__contact_template::SDP__contact_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__contact_template::SDP__contact_template(const SDP__contact& other_value)
{
copy_value(other_value);
}

SDP__contact_template::SDP__contact_template(const OPTIONAL<SDP__contact>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__contact&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_contact from an unbound optional field.");
}
}

SDP__contact_template::SDP__contact_template(SDP__contact_template* p_precondition, SDP__contact_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__contact_template::SDP__contact_template(Dynamic_Match_Interface<SDP__contact>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__contact>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__contact_template::SDP__contact_template(const SDP__contact_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__contact_template::~SDP__contact_template()
{
clean_up();
}

SDP__contact_template& SDP__contact_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__contact_template& SDP__contact_template::operator=(const SDP__contact& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__contact_template& SDP__contact_template::operator=(const OPTIONAL<SDP__contact>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__contact&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_contact.");
}
return *this;
}

SDP__contact_template& SDP__contact_template::operator=(const SDP__contact_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__contact_template::match(const SDP__contact& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.addr__or__phone().is_bound()) return FALSE;
if(!single_value->field_addr__or__phone.match(other_value.addr__or__phone(), legacy))return FALSE;
if(!other_value.disp__name().is_bound()) return FALSE;
if((other_value.disp__name().ispresent() ? !single_value->field_disp__name.match((const CHARSTRING&)other_value.disp__name(), legacy) : !single_value->field_disp__name.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_contact.");
}
return FALSE;
}

boolean SDP__contact_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_addr__or__phone.is_bound()
 || (single_value->field_disp__name.is_omit() || single_value->field_disp__name.is_bound());
}

boolean SDP__contact_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_addr__or__phone.is_value()
 && (single_value->field_disp__name.is_omit() || single_value->field_disp__name.is_value());
}

void SDP__contact_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__contact SDP__contact_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_contact.");
SDP__contact ret_val;
if (single_value->field_addr__or__phone.is_bound()) {
ret_val.addr__or__phone() = single_value->field_addr__or__phone.valueof();
}
if (single_value->field_disp__name.is_omit()) ret_val.disp__name() = OMIT_VALUE;
else if (single_value->field_disp__name.is_bound()) {
ret_val.disp__name() = single_value->field_disp__name.valueof();
}
return ret_val;
}

void SDP__contact_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_contact.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__contact_template[list_length];
}

SDP__contact_template& SDP__contact_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_contact.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_contact.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__contact_template::addr__or__phone()
{
set_specific();
return single_value->field_addr__or__phone;
}

const CHARSTRING_template& SDP__contact_template::addr__or__phone() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field addr_or_phone of a non-specific template of type @SDP_Types.SDP_contact.");
return single_value->field_addr__or__phone;
}

CHARSTRING_template& SDP__contact_template::disp__name()
{
set_specific();
return single_value->field_disp__name;
}

const CHARSTRING_template& SDP__contact_template::disp__name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field disp_name of a non-specific template of type @SDP_Types.SDP_contact.");
return single_value->field_disp__name;
}

int SDP__contact_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_disp__name.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_contact containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_contact.");
  }
  return 0;
}

void SDP__contact_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ addr_or_phone := ");
single_value->field_addr__or__phone.log();
TTCN_Logger::log_event_str(", disp_name := ");
single_value->field_disp__name.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__contact_template::log_match(const SDP__contact& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_addr__or__phone.match(match_value.addr__or__phone(), legacy)){
TTCN_Logger::log_logmatch_info(".addr_or_phone");
single_value->field_addr__or__phone.log_match(match_value.addr__or__phone(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.disp__name().ispresent()){
if(!single_value->field_disp__name.match(match_value.disp__name(), legacy)){
TTCN_Logger::log_logmatch_info(".disp_name");
single_value->field_disp__name.log_match(match_value.disp__name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_disp__name.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".disp_name := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_disp__name.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ addr_or_phone := ");
single_value->field_addr__or__phone.log_match(match_value.addr__or__phone(), legacy);
TTCN_Logger::log_event_str(", disp_name := ");
if (match_value.disp__name().ispresent()) {
single_value->field_disp__name.log_match(match_value.disp__name(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_disp__name.log();
if (single_value->field_disp__name.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__contact_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (addr__or__phone().is_bound()) addr__or__phone().set_implicit_omit();
if (!disp__name().is_bound()) disp__name() = OMIT_VALUE;
else disp__name().set_implicit_omit();
}

void SDP__contact_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_addr__or__phone.encode_text(text_buf);
single_value->field_disp__name.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_contact.");
}
}

void SDP__contact_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_addr__or__phone.decode_text(text_buf);
single_value->field_disp__name.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__contact_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_contact.");
}
}

void SDP__contact_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__contact_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_contact has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) addr__or__phone().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) disp__name().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addr_or_phone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addr__or__phone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "disp_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          disp__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_contact: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__contact_template* precondition = new SDP__contact_template;
    precondition->set_param(*param.get_elem(0));
    SDP__contact_template* implied_template = new SDP__contact_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__contact_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_contact");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__contact_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_addr__or__phone.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_contact");
single_value->field_disp__name.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_contact");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_contact");
}

boolean SDP__contact_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__contact_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__contact SDP__email__list::UNBOUND_ELEM;
boolean SDP__email__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__email__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_email_list.");
if (((const SDP__email__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_email_list.");
if (((const SDP__email__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__email__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__email__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__email__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__email__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__email__list::SDP__email__list()
{
val_ptr = NULL;
}

SDP__email__list::SDP__email__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__email__list::SDP__email__list(const SDP__email__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_email_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__email__list::~SDP__email__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__email__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__email__list& SDP__email__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__email__list& SDP__email__list::operator=(const SDP__email__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_email_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__email__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_email_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__email__list::operator==(const SDP__email__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_email_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_email_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__contact& SDP__email__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_email_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__contact**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__contact(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__contact;
}
return *val_ptr->value_elements[index_value];
}

SDP__contact& SDP__email__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_email_list.");
return (*this)[(int)index_value];
}

const SDP__contact& SDP__email__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_email_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_email_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_email_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__contact& SDP__email__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_email_list.");
return (*this)[(int)index_value];
}

SDP__email__list SDP__email__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__email__list SDP__email__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__email__list SDP__email__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__email__list SDP__email__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_email_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__email__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__contact(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__email__list SDP__email__list::operator+(const SDP__email__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_email_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__email__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__contact(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__contact(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__email__list SDP__email__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_email_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_email_list","element");
SDP__email__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__contact(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__email__list SDP__email__list::replace(int index, int len, const SDP__email__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_email_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_email_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_email_list","element");
SDP__email__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__contact(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__contact(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__contact(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__email__list SDP__email__list::replace(int index, int len, const SDP__email__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__email__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_email_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__contact**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__contact(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__contact**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_email_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__contact**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__email__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__email__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_email_list.");
return val_ptr->n_elements;
}

int SDP__email__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_email_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__email__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__email__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__email__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_email_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_email_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__email__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_email_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__email__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_email_list.");
val_ptr->value_elements = (SDP__contact**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__contact;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__email__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__email__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__email__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__email__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__contact *val=new SDP__contact;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__contact**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__email__list_template::copy_value(const SDP__email__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_email_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__contact_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__contact_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__contact_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__email__list_template::copy_template(const SDP__email__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__contact_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__contact_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__contact_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__email__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__contact_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__email__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__email__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_email_list.");
break;
}
set_selection(other_value);
}

boolean SDP__email__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__email__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__email__list*)value_ptr)[value_index], legacy);
else return ((const SDP__email__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__email__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__email__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__email__list*)value_ptr)[value_index], legacy);
else return ((const SDP__email__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__email__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__email__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__email__list*)value_ptr)[index_value].log();
} else {
((const SDP__email__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__email__list*)value_ptr)[index_value], legacy);
}
}

SDP__email__list_template::SDP__email__list_template()
{
}

SDP__email__list_template::SDP__email__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__email__list_template::SDP__email__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__email__list_template::SDP__email__list_template(const SDP__email__list& other_value)
{
copy_value(other_value);
}

SDP__email__list_template::SDP__email__list_template(const OPTIONAL<SDP__email__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__email__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_email_list from an unbound optional field.");
}
}

SDP__email__list_template::SDP__email__list_template(SDP__email__list_template* p_precondition, SDP__email__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__email__list_template::SDP__email__list_template(Dynamic_Match_Interface<SDP__email__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__email__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__email__list_template::SDP__email__list_template(const SDP__email__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__email__list_template::~SDP__email__list_template()
{
clean_up();
}

void SDP__email__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__email__list_template& SDP__email__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__email__list_template& SDP__email__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__email__list_template& SDP__email__list_template::operator=(const SDP__email__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__email__list_template& SDP__email__list_template::operator=(const OPTIONAL<SDP__email__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__email__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_email_list.");
}
return *this;
}

SDP__email__list_template& SDP__email__list_template::operator=(const SDP__email__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__contact_template& SDP__email__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_email_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_email_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__contact_template& SDP__email__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_email_list.");
return (*this)[(int)index_value];
}

const SDP__contact_template& SDP__email__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_email_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_email_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_email_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__contact_template& SDP__email__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_email_list.");
return (*this)[(int)index_value];
}

void SDP__email__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_email_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__contact_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__contact_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__contact_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__contact_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__email__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__email__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_email_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_email_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_email_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_email_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_email_list");
}

boolean SDP__email__list_template::match(const SDP__email__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_email_list.");
}
return FALSE;
}

boolean SDP__email__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__email__list SDP__email__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_email_list.");
SDP__email__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__email__list SDP__email__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__email__list SDP__email__list_template::replace(int index, int len, const SDP__email__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__email__list SDP__email__list_template::replace(int index, int len, const SDP__email__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__email__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__email__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__contact_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_email_list.");
}
set_selection(template_type);
}

SDP__email__list_template& SDP__email__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_email_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_email_list.");
return value_list.list_value[list_index];
}

SDP__contact_template& SDP__email__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_email_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_email_list.");
return value_set.set_items[set_index];
}

void SDP__email__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__email__list_template::log_match(const SDP__email__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__email__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_email_list.");
}
}

void SDP__email__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_email_list.");
single_value.value_elements = (SDP__contact_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__contact_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__email__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__contact_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_email_list.");
}
}

boolean SDP__email__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__email__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__email__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__email__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__email__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__email__list_template* precondition = new SDP__email__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__email__list_template* implied_template = new SDP__email__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__email__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_email_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__email__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_email_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_email_list");
}

boolean SDP__email__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__key::SDP__key()
{
}

SDP__key::SDP__key(const CHARSTRING& par_method,
    const OPTIONAL< CHARSTRING >& par_key)
  :   field_method(par_method),
  field_key(par_key)
{
}

SDP__key::SDP__key(const SDP__key& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_key.");
if (other_value.method().is_bound()) field_method = other_value.method();
else field_method.clean_up();
if (other_value.key().is_bound()) field_key = other_value.key();
else field_key.clean_up();
}

void SDP__key::clean_up()
{
field_method.clean_up();
field_key.clean_up();
}

const TTCN_Typedescriptor_t* SDP__key::get_descriptor() const { return &SDP__key_descr_; }
SDP__key& SDP__key::operator=(const SDP__key& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_key.");
  if (other_value.method().is_bound()) field_method = other_value.method();
  else field_method.clean_up();
  if (other_value.key().is_bound()) field_key = other_value.key();
  else field_key.clean_up();
}
return *this;
}

boolean SDP__key::operator==(const SDP__key& other_value) const
{
return field_method==other_value.field_method
  && field_key==other_value.field_key;
}

boolean SDP__key::is_bound() const
{
return (field_method.is_bound())
  || (OPTIONAL_OMIT == field_key.get_selection() || field_key.is_bound());
}
boolean SDP__key::is_value() const
{
return field_method.is_value()
  && (OPTIONAL_OMIT == field_key.get_selection() || field_key.is_value());
}
int SDP__key::size_of() const
{
  int ret_val = 1;
  if (field_key.ispresent()) ret_val++;
  return ret_val;
}

void SDP__key::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ method := ");
field_method.log();
TTCN_Logger::log_event_str(", key := ");
field_key.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__key::set_implicit_omit()
{
if (method().is_bound()) method().set_implicit_omit();
if (!key().is_bound()) key() = OMIT_VALUE;
else key().set_implicit_omit();
}

void SDP__key::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_key has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) method().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) key().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "key")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          key().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_key: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_key");
  }
}

void SDP__key::encode_text(Text_Buf& text_buf) const
{
field_method.encode_text(text_buf);
field_key.encode_text(text_buf);
}

void SDP__key::decode_text(Text_Buf& text_buf)
{
field_method.decode_text(text_buf);
field_key.decode_text(text_buf);
}

void SDP__key::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__key::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__key::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_method.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(field_key.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_key().TEXT_encode(SDP__key_key_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__key::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_key=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_method.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'method' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_key().TEXT_decode(SDP__key_key_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_key=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__key_template::single_value_struct {
CHARSTRING_template field_method;
CHARSTRING_template field_key;
};

void SDP__key_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_method = ANY_VALUE;
single_value->field_key = ANY_OR_OMIT;
}
}
}

void SDP__key_template::copy_value(const SDP__key& other_value)
{
single_value = new single_value_struct;
if (other_value.method().is_bound()) {
  single_value->field_method = other_value.method();
} else {
  single_value->field_method.clean_up();
}
if (other_value.key().is_bound()) {
  if (other_value.key().ispresent()) single_value->field_key = other_value.key()();
  else single_value->field_key = OMIT_VALUE;
} else {
  single_value->field_key.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__key_template::copy_template(const SDP__key_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.method().get_selection()) {
single_value->field_method = other_value.method();
} else {
single_value->field_method.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.key().get_selection()) {
single_value->field_key = other_value.key();
} else {
single_value->field_key.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__key_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__key_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__key_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_key.");
break;
}
set_selection(other_value);
}

SDP__key_template::SDP__key_template()
{
}

SDP__key_template::SDP__key_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__key_template::SDP__key_template(const SDP__key& other_value)
{
copy_value(other_value);
}

SDP__key_template::SDP__key_template(const OPTIONAL<SDP__key>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__key&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_key from an unbound optional field.");
}
}

SDP__key_template::SDP__key_template(SDP__key_template* p_precondition, SDP__key_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__key_template::SDP__key_template(Dynamic_Match_Interface<SDP__key>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__key>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__key_template::SDP__key_template(const SDP__key_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__key_template::~SDP__key_template()
{
clean_up();
}

SDP__key_template& SDP__key_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__key_template& SDP__key_template::operator=(const SDP__key& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__key_template& SDP__key_template::operator=(const OPTIONAL<SDP__key>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__key&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_key.");
}
return *this;
}

SDP__key_template& SDP__key_template::operator=(const SDP__key_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__key_template::match(const SDP__key& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.method().is_bound()) return FALSE;
if(!single_value->field_method.match(other_value.method(), legacy))return FALSE;
if(!other_value.key().is_bound()) return FALSE;
if((other_value.key().ispresent() ? !single_value->field_key.match((const CHARSTRING&)other_value.key(), legacy) : !single_value->field_key.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_key.");
}
return FALSE;
}

boolean SDP__key_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_method.is_bound()
 || (single_value->field_key.is_omit() || single_value->field_key.is_bound());
}

boolean SDP__key_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_method.is_value()
 && (single_value->field_key.is_omit() || single_value->field_key.is_value());
}

void SDP__key_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__key SDP__key_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_key.");
SDP__key ret_val;
if (single_value->field_method.is_bound()) {
ret_val.method() = single_value->field_method.valueof();
}
if (single_value->field_key.is_omit()) ret_val.key() = OMIT_VALUE;
else if (single_value->field_key.is_bound()) {
ret_val.key() = single_value->field_key.valueof();
}
return ret_val;
}

void SDP__key_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_key.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__key_template[list_length];
}

SDP__key_template& SDP__key_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_key.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_key.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__key_template::method()
{
set_specific();
return single_value->field_method;
}

const CHARSTRING_template& SDP__key_template::method() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field method of a non-specific template of type @SDP_Types.SDP_key.");
return single_value->field_method;
}

CHARSTRING_template& SDP__key_template::key()
{
set_specific();
return single_value->field_key;
}

const CHARSTRING_template& SDP__key_template::key() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field key of a non-specific template of type @SDP_Types.SDP_key.");
return single_value->field_key;
}

int SDP__key_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_key.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_key containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_key.");
  }
  return 0;
}

void SDP__key_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ method := ");
single_value->field_method.log();
TTCN_Logger::log_event_str(", key := ");
single_value->field_key.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__key_template::log_match(const SDP__key& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_method.match(match_value.method(), legacy)){
TTCN_Logger::log_logmatch_info(".method");
single_value->field_method.log_match(match_value.method(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.key().ispresent()){
if(!single_value->field_key.match(match_value.key(), legacy)){
TTCN_Logger::log_logmatch_info(".key");
single_value->field_key.log_match(match_value.key(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_key.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".key := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_key.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ method := ");
single_value->field_method.log_match(match_value.method(), legacy);
TTCN_Logger::log_event_str(", key := ");
if (match_value.key().ispresent()) {
single_value->field_key.log_match(match_value.key(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_key.log();
if (single_value->field_key.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__key_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (method().is_bound()) method().set_implicit_omit();
if (!key().is_bound()) key() = OMIT_VALUE;
else key().set_implicit_omit();
}

void SDP__key_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_method.encode_text(text_buf);
single_value->field_key.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_key.");
}
}

void SDP__key_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_method.decode_text(text_buf);
single_value->field_key.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__key_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_key.");
}
}

void SDP__key_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__key_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_key has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) method().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) key().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "key")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          key().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_key: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__key_template* precondition = new SDP__key_template;
    precondition->set_param(*param.get_elem(0));
    SDP__key_template* implied_template = new SDP__key_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__key_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_key");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__key_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_method.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_key");
single_value->field_key.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_key");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_key");
}

boolean SDP__key_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__key_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__media__port::SDP__media__port()
{
}

SDP__media__port::SDP__media__port(const INTEGER& par_port__number,
    const OPTIONAL< INTEGER >& par_num__of__ports)
  :   field_port__number(par_port__number),
  field_num__of__ports(par_num__of__ports)
{
}

SDP__media__port::SDP__media__port(const SDP__media__port& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_media_port.");
if (other_value.port__number().is_bound()) field_port__number = other_value.port__number();
else field_port__number.clean_up();
if (other_value.num__of__ports().is_bound()) field_num__of__ports = other_value.num__of__ports();
else field_num__of__ports.clean_up();
}

void SDP__media__port::clean_up()
{
field_port__number.clean_up();
field_num__of__ports.clean_up();
}

const TTCN_Typedescriptor_t* SDP__media__port::get_descriptor() const { return &SDP__media__port_descr_; }
SDP__media__port& SDP__media__port::operator=(const SDP__media__port& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_media_port.");
  if (other_value.port__number().is_bound()) field_port__number = other_value.port__number();
  else field_port__number.clean_up();
  if (other_value.num__of__ports().is_bound()) field_num__of__ports = other_value.num__of__ports();
  else field_num__of__ports.clean_up();
}
return *this;
}

boolean SDP__media__port::operator==(const SDP__media__port& other_value) const
{
return field_port__number==other_value.field_port__number
  && field_num__of__ports==other_value.field_num__of__ports;
}

boolean SDP__media__port::is_bound() const
{
return (field_port__number.is_bound())
  || (OPTIONAL_OMIT == field_num__of__ports.get_selection() || field_num__of__ports.is_bound());
}
boolean SDP__media__port::is_value() const
{
return field_port__number.is_value()
  && (OPTIONAL_OMIT == field_num__of__ports.get_selection() || field_num__of__ports.is_value());
}
int SDP__media__port::size_of() const
{
  int ret_val = 1;
  if (field_num__of__ports.ispresent()) ret_val++;
  return ret_val;
}

void SDP__media__port::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ port_number := ");
field_port__number.log();
TTCN_Logger::log_event_str(", num_of_ports := ");
field_num__of__ports.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__media__port::set_implicit_omit()
{
if (port__number().is_bound()) port__number().set_implicit_omit();
if (!num__of__ports().is_bound()) num__of__ports() = OMIT_VALUE;
else num__of__ports().set_implicit_omit();
}

void SDP__media__port::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_media_port has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) port__number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) num__of__ports().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "port_number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          port__number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_of_ports")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__of__ports().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_port: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_media_port");
  }
}

void SDP__media__port::encode_text(Text_Buf& text_buf) const
{
field_port__number.encode_text(text_buf);
field_num__of__ports.encode_text(text_buf);
}

void SDP__media__port::decode_text(Text_Buf& text_buf)
{
field_port__number.decode_text(text_buf);
field_num__of__ports.decode_text(text_buf);
}

void SDP__media__port::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__media__port::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__media__port::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_port__number.TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  if(field_num__of__ports.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_num__of__ports().TEXT_encode(INTEGER_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__media__port::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_num__of__ports=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_port__number.TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'port__number' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_num__of__ports().TEXT_decode(INTEGER_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_num__of__ports=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__media__port_template::single_value_struct {
INTEGER_template field_port__number;
INTEGER_template field_num__of__ports;
};

void SDP__media__port_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_port__number = ANY_VALUE;
single_value->field_num__of__ports = ANY_OR_OMIT;
}
}
}

void SDP__media__port_template::copy_value(const SDP__media__port& other_value)
{
single_value = new single_value_struct;
if (other_value.port__number().is_bound()) {
  single_value->field_port__number = other_value.port__number();
} else {
  single_value->field_port__number.clean_up();
}
if (other_value.num__of__ports().is_bound()) {
  if (other_value.num__of__ports().ispresent()) single_value->field_num__of__ports = other_value.num__of__ports()();
  else single_value->field_num__of__ports = OMIT_VALUE;
} else {
  single_value->field_num__of__ports.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__media__port_template::copy_template(const SDP__media__port_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.port__number().get_selection()) {
single_value->field_port__number = other_value.port__number();
} else {
single_value->field_port__number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.num__of__ports().get_selection()) {
single_value->field_num__of__ports = other_value.num__of__ports();
} else {
single_value->field_num__of__ports.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__media__port_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__media__port_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__media__port_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_media_port.");
break;
}
set_selection(other_value);
}

SDP__media__port_template::SDP__media__port_template()
{
}

SDP__media__port_template::SDP__media__port_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__media__port_template::SDP__media__port_template(const SDP__media__port& other_value)
{
copy_value(other_value);
}

SDP__media__port_template::SDP__media__port_template(const OPTIONAL<SDP__media__port>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__port&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_media_port from an unbound optional field.");
}
}

SDP__media__port_template::SDP__media__port_template(SDP__media__port_template* p_precondition, SDP__media__port_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__media__port_template::SDP__media__port_template(Dynamic_Match_Interface<SDP__media__port>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__media__port>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__media__port_template::SDP__media__port_template(const SDP__media__port_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__media__port_template::~SDP__media__port_template()
{
clean_up();
}

SDP__media__port_template& SDP__media__port_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__media__port_template& SDP__media__port_template::operator=(const SDP__media__port& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__media__port_template& SDP__media__port_template::operator=(const OPTIONAL<SDP__media__port>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__port&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_media_port.");
}
return *this;
}

SDP__media__port_template& SDP__media__port_template::operator=(const SDP__media__port_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__media__port_template::match(const SDP__media__port& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.port__number().is_bound()) return FALSE;
if(!single_value->field_port__number.match(other_value.port__number(), legacy))return FALSE;
if(!other_value.num__of__ports().is_bound()) return FALSE;
if((other_value.num__of__ports().ispresent() ? !single_value->field_num__of__ports.match((const INTEGER&)other_value.num__of__ports(), legacy) : !single_value->field_num__of__ports.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_media_port.");
}
return FALSE;
}

boolean SDP__media__port_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_port__number.is_bound()
 || (single_value->field_num__of__ports.is_omit() || single_value->field_num__of__ports.is_bound());
}

boolean SDP__media__port_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_port__number.is_value()
 && (single_value->field_num__of__ports.is_omit() || single_value->field_num__of__ports.is_value());
}

void SDP__media__port_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__media__port SDP__media__port_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_media_port.");
SDP__media__port ret_val;
if (single_value->field_port__number.is_bound()) {
ret_val.port__number() = single_value->field_port__number.valueof();
}
if (single_value->field_num__of__ports.is_omit()) ret_val.num__of__ports() = OMIT_VALUE;
else if (single_value->field_num__of__ports.is_bound()) {
ret_val.num__of__ports() = single_value->field_num__of__ports.valueof();
}
return ret_val;
}

void SDP__media__port_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_media_port.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__media__port_template[list_length];
}

SDP__media__port_template& SDP__media__port_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_media_port.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_media_port.");
return value_list.list_value[list_index];
}

INTEGER_template& SDP__media__port_template::port__number()
{
set_specific();
return single_value->field_port__number;
}

const INTEGER_template& SDP__media__port_template::port__number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field port_number of a non-specific template of type @SDP_Types.SDP_media_port.");
return single_value->field_port__number;
}

INTEGER_template& SDP__media__port_template::num__of__ports()
{
set_specific();
return single_value->field_num__of__ports;
}

const INTEGER_template& SDP__media__port_template::num__of__ports() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field num_of_ports of a non-specific template of type @SDP_Types.SDP_media_port.");
return single_value->field_num__of__ports;
}

int SDP__media__port_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_num__of__ports.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_port containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_media_port.");
  }
  return 0;
}

void SDP__media__port_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ port_number := ");
single_value->field_port__number.log();
TTCN_Logger::log_event_str(", num_of_ports := ");
single_value->field_num__of__ports.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__media__port_template::log_match(const SDP__media__port& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_port__number.match(match_value.port__number(), legacy)){
TTCN_Logger::log_logmatch_info(".port_number");
single_value->field_port__number.log_match(match_value.port__number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.num__of__ports().ispresent()){
if(!single_value->field_num__of__ports.match(match_value.num__of__ports(), legacy)){
TTCN_Logger::log_logmatch_info(".num_of_ports");
single_value->field_num__of__ports.log_match(match_value.num__of__ports(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_num__of__ports.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".num_of_ports := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_num__of__ports.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ port_number := ");
single_value->field_port__number.log_match(match_value.port__number(), legacy);
TTCN_Logger::log_event_str(", num_of_ports := ");
if (match_value.num__of__ports().ispresent()) {
single_value->field_num__of__ports.log_match(match_value.num__of__ports(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_num__of__ports.log();
if (single_value->field_num__of__ports.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__media__port_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (port__number().is_bound()) port__number().set_implicit_omit();
if (!num__of__ports().is_bound()) num__of__ports() = OMIT_VALUE;
else num__of__ports().set_implicit_omit();
}

void SDP__media__port_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_port__number.encode_text(text_buf);
single_value->field_num__of__ports.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_media_port.");
}
}

void SDP__media__port_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_port__number.decode_text(text_buf);
single_value->field_num__of__ports.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__media__port_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_media_port.");
}
}

void SDP__media__port_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__media__port_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_media_port has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) port__number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) num__of__ports().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "port_number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          port__number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_of_ports")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__of__ports().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_port: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__media__port_template* precondition = new SDP__media__port_template;
    precondition->set_param(*param.get_elem(0));
    SDP__media__port_template* implied_template = new SDP__media__port_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__media__port_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_media_port");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__media__port_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_port__number.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_port");
single_value->field_num__of__ports.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_port");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_media_port");
}

boolean SDP__media__port_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__media__port_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__media__field::SDP__media__field()
{
}

SDP__media__field::SDP__media__field(const CHARSTRING& par_media,
    const SDP__media__port& par_ports,
    const CHARSTRING& par_transport,
    const SDP__fmt__list& par_fmts)
  :   field_media(par_media),
  field_ports(par_ports),
  field_transport(par_transport),
  field_fmts(par_fmts)
{
}

SDP__media__field::SDP__media__field(const SDP__media__field& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_media_field.");
if (other_value.media().is_bound()) field_media = other_value.media();
else field_media.clean_up();
if (other_value.ports().is_bound()) field_ports = other_value.ports();
else field_ports.clean_up();
if (other_value.transport().is_bound()) field_transport = other_value.transport();
else field_transport.clean_up();
if (other_value.fmts().is_bound()) field_fmts = other_value.fmts();
else field_fmts.clean_up();
}

void SDP__media__field::clean_up()
{
field_media.clean_up();
field_ports.clean_up();
field_transport.clean_up();
field_fmts.clean_up();
}

const TTCN_Typedescriptor_t* SDP__media__field::get_descriptor() const { return &SDP__media__field_descr_; }
SDP__media__field& SDP__media__field::operator=(const SDP__media__field& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_media_field.");
  if (other_value.media().is_bound()) field_media = other_value.media();
  else field_media.clean_up();
  if (other_value.ports().is_bound()) field_ports = other_value.ports();
  else field_ports.clean_up();
  if (other_value.transport().is_bound()) field_transport = other_value.transport();
  else field_transport.clean_up();
  if (other_value.fmts().is_bound()) field_fmts = other_value.fmts();
  else field_fmts.clean_up();
}
return *this;
}

boolean SDP__media__field::operator==(const SDP__media__field& other_value) const
{
return field_media==other_value.field_media
  && field_ports==other_value.field_ports
  && field_transport==other_value.field_transport
  && field_fmts==other_value.field_fmts;
}

boolean SDP__media__field::is_bound() const
{
return (field_media.is_bound())
  || (field_ports.is_bound())
  || (field_transport.is_bound())
  || (field_fmts.is_bound());
}
boolean SDP__media__field::is_value() const
{
return field_media.is_value()
  && field_ports.is_value()
  && field_transport.is_value()
  && field_fmts.is_value();
}
void SDP__media__field::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ media := ");
field_media.log();
TTCN_Logger::log_event_str(", ports := ");
field_ports.log();
TTCN_Logger::log_event_str(", transport := ");
field_transport.log();
TTCN_Logger::log_event_str(", fmts := ");
field_fmts.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__media__field::set_implicit_omit()
{
if (media().is_bound()) media().set_implicit_omit();
if (ports().is_bound()) ports().set_implicit_omit();
if (transport().is_bound()) transport().set_implicit_omit();
if (fmts().is_bound()) fmts().set_implicit_omit();
}

void SDP__media__field::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_media_field has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) media().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ports().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) fmts().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "media")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          media().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ports")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ports().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fmts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fmts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_field: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_media_field");
  }
}

void SDP__media__field::encode_text(Text_Buf& text_buf) const
{
field_media.encode_text(text_buf);
field_ports.encode_text(text_buf);
field_transport.encode_text(text_buf);
field_fmts.encode_text(text_buf);
}

void SDP__media__field::decode_text(Text_Buf& text_buf)
{
field_media.decode_text(text_buf);
field_ports.decode_text(text_buf);
field_transport.decode_text(text_buf);
field_fmts.decode_text(text_buf);
}

void SDP__media__field::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__media__field::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__media__field::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_media.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_ports.TEXT_encode(SDP__media__port_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_transport.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_fmts.TEXT_encode(SDP__fmt__list_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__media__field::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_media.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'media' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_ports.TEXT_decode(SDP__media__port_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'ports' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_transport.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'transport' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_fmts.TEXT_decode(SDP__fmt__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'fmts' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__media__field_template::single_value_struct {
CHARSTRING_template field_media;
SDP__media__port_template field_ports;
CHARSTRING_template field_transport;
SDP__fmt__list_template field_fmts;
};

void SDP__media__field_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_media = ANY_VALUE;
single_value->field_ports = ANY_VALUE;
single_value->field_transport = ANY_VALUE;
single_value->field_fmts = ANY_VALUE;
}
}
}

void SDP__media__field_template::copy_value(const SDP__media__field& other_value)
{
single_value = new single_value_struct;
if (other_value.media().is_bound()) {
  single_value->field_media = other_value.media();
} else {
  single_value->field_media.clean_up();
}
if (other_value.ports().is_bound()) {
  single_value->field_ports = other_value.ports();
} else {
  single_value->field_ports.clean_up();
}
if (other_value.transport().is_bound()) {
  single_value->field_transport = other_value.transport();
} else {
  single_value->field_transport.clean_up();
}
if (other_value.fmts().is_bound()) {
  single_value->field_fmts = other_value.fmts();
} else {
  single_value->field_fmts.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__media__field_template::copy_template(const SDP__media__field_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.media().get_selection()) {
single_value->field_media = other_value.media();
} else {
single_value->field_media.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ports().get_selection()) {
single_value->field_ports = other_value.ports();
} else {
single_value->field_ports.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transport().get_selection()) {
single_value->field_transport = other_value.transport();
} else {
single_value->field_transport.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.fmts().get_selection()) {
single_value->field_fmts = other_value.fmts();
} else {
single_value->field_fmts.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__media__field_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__media__field_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__media__field_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_media_field.");
break;
}
set_selection(other_value);
}

SDP__media__field_template::SDP__media__field_template()
{
}

SDP__media__field_template::SDP__media__field_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__media__field_template::SDP__media__field_template(const SDP__media__field& other_value)
{
copy_value(other_value);
}

SDP__media__field_template::SDP__media__field_template(const OPTIONAL<SDP__media__field>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__field&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_media_field from an unbound optional field.");
}
}

SDP__media__field_template::SDP__media__field_template(SDP__media__field_template* p_precondition, SDP__media__field_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__media__field_template::SDP__media__field_template(Dynamic_Match_Interface<SDP__media__field>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__media__field>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__media__field_template::SDP__media__field_template(const SDP__media__field_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__media__field_template::~SDP__media__field_template()
{
clean_up();
}

SDP__media__field_template& SDP__media__field_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__media__field_template& SDP__media__field_template::operator=(const SDP__media__field& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__media__field_template& SDP__media__field_template::operator=(const OPTIONAL<SDP__media__field>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__field&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_media_field.");
}
return *this;
}

SDP__media__field_template& SDP__media__field_template::operator=(const SDP__media__field_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__media__field_template::match(const SDP__media__field& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.media().is_bound()) return FALSE;
if(!single_value->field_media.match(other_value.media(), legacy))return FALSE;
if(!other_value.ports().is_bound()) return FALSE;
if(!single_value->field_ports.match(other_value.ports(), legacy))return FALSE;
if(!other_value.transport().is_bound()) return FALSE;
if(!single_value->field_transport.match(other_value.transport(), legacy))return FALSE;
if(!other_value.fmts().is_bound()) return FALSE;
if(!single_value->field_fmts.match(other_value.fmts(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_media_field.");
}
return FALSE;
}

boolean SDP__media__field_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_media.is_bound()
 || single_value->field_ports.is_bound()
 || single_value->field_transport.is_bound()
 || single_value->field_fmts.is_bound();
}

boolean SDP__media__field_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_media.is_value()
 && single_value->field_ports.is_value()
 && single_value->field_transport.is_value()
 && single_value->field_fmts.is_value();
}

void SDP__media__field_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__media__field SDP__media__field_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_media_field.");
SDP__media__field ret_val;
if (single_value->field_media.is_bound()) {
ret_val.media() = single_value->field_media.valueof();
}
if (single_value->field_ports.is_bound()) {
ret_val.ports() = single_value->field_ports.valueof();
}
if (single_value->field_transport.is_bound()) {
ret_val.transport() = single_value->field_transport.valueof();
}
if (single_value->field_fmts.is_bound()) {
ret_val.fmts() = single_value->field_fmts.valueof();
}
return ret_val;
}

void SDP__media__field_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_media_field.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__media__field_template[list_length];
}

SDP__media__field_template& SDP__media__field_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_media_field.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_media_field.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__media__field_template::media()
{
set_specific();
return single_value->field_media;
}

const CHARSTRING_template& SDP__media__field_template::media() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field media of a non-specific template of type @SDP_Types.SDP_media_field.");
return single_value->field_media;
}

SDP__media__port_template& SDP__media__field_template::ports()
{
set_specific();
return single_value->field_ports;
}

const SDP__media__port_template& SDP__media__field_template::ports() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ports of a non-specific template of type @SDP_Types.SDP_media_field.");
return single_value->field_ports;
}

CHARSTRING_template& SDP__media__field_template::transport()
{
set_specific();
return single_value->field_transport;
}

const CHARSTRING_template& SDP__media__field_template::transport() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transport of a non-specific template of type @SDP_Types.SDP_media_field.");
return single_value->field_transport;
}

SDP__fmt__list_template& SDP__media__field_template::fmts()
{
set_specific();
return single_value->field_fmts;
}

const SDP__fmt__list_template& SDP__media__field_template::fmts() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fmts of a non-specific template of type @SDP_Types.SDP_media_field.");
return single_value->field_fmts;
}

int SDP__media__field_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_field containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_media_field.");
  }
  return 0;
}

void SDP__media__field_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ media := ");
single_value->field_media.log();
TTCN_Logger::log_event_str(", ports := ");
single_value->field_ports.log();
TTCN_Logger::log_event_str(", transport := ");
single_value->field_transport.log();
TTCN_Logger::log_event_str(", fmts := ");
single_value->field_fmts.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__media__field_template::log_match(const SDP__media__field& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_media.match(match_value.media(), legacy)){
TTCN_Logger::log_logmatch_info(".media");
single_value->field_media.log_match(match_value.media(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ports.match(match_value.ports(), legacy)){
TTCN_Logger::log_logmatch_info(".ports");
single_value->field_ports.log_match(match_value.ports(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_transport.match(match_value.transport(), legacy)){
TTCN_Logger::log_logmatch_info(".transport");
single_value->field_transport.log_match(match_value.transport(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_fmts.match(match_value.fmts(), legacy)){
TTCN_Logger::log_logmatch_info(".fmts");
single_value->field_fmts.log_match(match_value.fmts(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ media := ");
single_value->field_media.log_match(match_value.media(), legacy);
TTCN_Logger::log_event_str(", ports := ");
single_value->field_ports.log_match(match_value.ports(), legacy);
TTCN_Logger::log_event_str(", transport := ");
single_value->field_transport.log_match(match_value.transport(), legacy);
TTCN_Logger::log_event_str(", fmts := ");
single_value->field_fmts.log_match(match_value.fmts(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__media__field_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (media().is_bound()) media().set_implicit_omit();
if (ports().is_bound()) ports().set_implicit_omit();
if (transport().is_bound()) transport().set_implicit_omit();
if (fmts().is_bound()) fmts().set_implicit_omit();
}

void SDP__media__field_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_media.encode_text(text_buf);
single_value->field_ports.encode_text(text_buf);
single_value->field_transport.encode_text(text_buf);
single_value->field_fmts.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_media_field.");
}
}

void SDP__media__field_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_media.decode_text(text_buf);
single_value->field_ports.decode_text(text_buf);
single_value->field_transport.decode_text(text_buf);
single_value->field_fmts.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__media__field_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_media_field.");
}
}

void SDP__media__field_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__media__field_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_media_field has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) media().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ports().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) fmts().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "media")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          media().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ports")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ports().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fmts")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fmts().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_field: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__media__field_template* precondition = new SDP__media__field_template;
    precondition->set_param(*param.get_elem(0));
    SDP__media__field_template* implied_template = new SDP__media__field_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__media__field_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_media_field");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__media__field_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_media.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_field");
single_value->field_ports.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_field");
single_value->field_transport.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_field");
single_value->field_fmts.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_field");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_media_field");
}

boolean SDP__media__field_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__media__field_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__media__desc::SDP__media__desc()
{
}

SDP__media__desc::SDP__media__desc(const SDP__media__field& par_media__field,
    const OPTIONAL< CHARSTRING >& par_information,
    const OPTIONAL< SDP__connection__list >& par_connections,
    const OPTIONAL< SDP__bandwidth__list >& par_bandwidth,
    const OPTIONAL< SDP__key >& par_key,
    const OPTIONAL< SDP__attribute__list >& par_attributes)
  :   field_media__field(par_media__field),
  field_information(par_information),
  field_connections(par_connections),
  field_bandwidth(par_bandwidth),
  field_key(par_key),
  field_attributes(par_attributes)
{
}

SDP__media__desc::SDP__media__desc(const SDP__media__desc& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_media_desc.");
if (other_value.media__field().is_bound()) field_media__field = other_value.media__field();
else field_media__field.clean_up();
if (other_value.information().is_bound()) field_information = other_value.information();
else field_information.clean_up();
if (other_value.connections().is_bound()) field_connections = other_value.connections();
else field_connections.clean_up();
if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
else field_bandwidth.clean_up();
if (other_value.key().is_bound()) field_key = other_value.key();
else field_key.clean_up();
if (other_value.attributes().is_bound()) field_attributes = other_value.attributes();
else field_attributes.clean_up();
}

void SDP__media__desc::clean_up()
{
field_media__field.clean_up();
field_information.clean_up();
field_connections.clean_up();
field_bandwidth.clean_up();
field_key.clean_up();
field_attributes.clean_up();
}

const TTCN_Typedescriptor_t* SDP__media__desc::get_descriptor() const { return &SDP__media__desc_descr_; }
SDP__media__desc& SDP__media__desc::operator=(const SDP__media__desc& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_media_desc.");
  if (other_value.media__field().is_bound()) field_media__field = other_value.media__field();
  else field_media__field.clean_up();
  if (other_value.information().is_bound()) field_information = other_value.information();
  else field_information.clean_up();
  if (other_value.connections().is_bound()) field_connections = other_value.connections();
  else field_connections.clean_up();
  if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
  else field_bandwidth.clean_up();
  if (other_value.key().is_bound()) field_key = other_value.key();
  else field_key.clean_up();
  if (other_value.attributes().is_bound()) field_attributes = other_value.attributes();
  else field_attributes.clean_up();
}
return *this;
}

boolean SDP__media__desc::operator==(const SDP__media__desc& other_value) const
{
return field_media__field==other_value.field_media__field
  && field_information==other_value.field_information
  && field_connections==other_value.field_connections
  && field_bandwidth==other_value.field_bandwidth
  && field_key==other_value.field_key
  && field_attributes==other_value.field_attributes;
}

boolean SDP__media__desc::is_bound() const
{
return (field_media__field.is_bound())
  || (OPTIONAL_OMIT == field_information.get_selection() || field_information.is_bound())
  || (OPTIONAL_OMIT == field_connections.get_selection() || field_connections.is_bound())
  || (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_bound())
  || (OPTIONAL_OMIT == field_key.get_selection() || field_key.is_bound())
  || (OPTIONAL_OMIT == field_attributes.get_selection() || field_attributes.is_bound());
}
boolean SDP__media__desc::is_value() const
{
return field_media__field.is_value()
  && (OPTIONAL_OMIT == field_information.get_selection() || field_information.is_value())
  && (OPTIONAL_OMIT == field_connections.get_selection() || field_connections.is_value())
  && (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_value())
  && (OPTIONAL_OMIT == field_key.get_selection() || field_key.is_value())
  && (OPTIONAL_OMIT == field_attributes.get_selection() || field_attributes.is_value());
}
int SDP__media__desc::size_of() const
{
  int ret_val = 1;
  if (field_information.ispresent()) ret_val++;
  if (field_connections.ispresent()) ret_val++;
  if (field_bandwidth.ispresent()) ret_val++;
  if (field_key.ispresent()) ret_val++;
  if (field_attributes.ispresent()) ret_val++;
  return ret_val;
}

void SDP__media__desc::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ media_field := ");
field_media__field.log();
TTCN_Logger::log_event_str(", information := ");
field_information.log();
TTCN_Logger::log_event_str(", connections := ");
field_connections.log();
TTCN_Logger::log_event_str(", bandwidth := ");
field_bandwidth.log();
TTCN_Logger::log_event_str(", key := ");
field_key.log();
TTCN_Logger::log_event_str(", attributes := ");
field_attributes.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__media__desc::set_implicit_omit()
{
if (media__field().is_bound()) media__field().set_implicit_omit();
if (!information().is_bound()) information() = OMIT_VALUE;
else information().set_implicit_omit();
if (!connections().is_bound()) connections() = OMIT_VALUE;
else connections().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (!key().is_bound()) key() = OMIT_VALUE;
else key().set_implicit_omit();
if (!attributes().is_bound()) attributes() = OMIT_VALUE;
else attributes().set_implicit_omit();
}

void SDP__media__desc::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_media_desc has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) media__field().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) information().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) connections().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) key().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) attributes().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "media_field")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          media__field().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connections")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connections().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "key")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          key().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attributes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attributes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_desc: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_media_desc");
  }
}

void SDP__media__desc::encode_text(Text_Buf& text_buf) const
{
field_media__field.encode_text(text_buf);
field_information.encode_text(text_buf);
field_connections.encode_text(text_buf);
field_bandwidth.encode_text(text_buf);
field_key.encode_text(text_buf);
field_attributes.encode_text(text_buf);
}

void SDP__media__desc::decode_text(Text_Buf& text_buf)
{
field_media__field.decode_text(text_buf);
field_information.decode_text(text_buf);
field_connections.decode_text(text_buf);
field_bandwidth.decode_text(text_buf);
field_key.decode_text(text_buf);
field_attributes.decode_text(text_buf);
}

void SDP__media__desc::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__media__desc::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__media__desc::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_media__field.TEXT_encode(SDP__media__field_descr_,p_buf);
 need_separator=TRUE;
  if(field_information.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_information().TEXT_encode(SDP__media__desc_information_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_connections.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_connections().TEXT_encode(SDP__connection__list_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_bandwidth.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_bandwidth().TEXT_encode(SDP__bandwidth__list_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_key.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_key().TEXT_encode(SDP__key_descr_,p_buf);
 need_separator=TRUE;
  }
  if(field_attributes.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_attributes().TEXT_encode(SDP__attribute__list_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__media__desc::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_information=OMIT_VALUE;
    field_connections=OMIT_VALUE;
    field_bandwidth=OMIT_VALUE;
    field_key=OMIT_VALUE;
    field_attributes=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_media__field.TEXT_decode(SDP__media__field_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'media__field' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_information().TEXT_decode(SDP__media__desc_information_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_information=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_information=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_connections().TEXT_decode(SDP__connection__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_connections=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_connections=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_bandwidth().TEXT_decode(SDP__bandwidth__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_bandwidth=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_bandwidth=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_key().TEXT_decode(SDP__key_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_key=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      if(p_td.text->end_decode){
      int tl;
     if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if((tl=limit.match(p_buf,ml))==0){
        sep_found=FALSE;
        break;
      }
    } else break;
    field_key=OMIT_VALUE;
    p_buf.set_pos(pos);
    decoded_length-=decoded_field_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_attributes().TEXT_decode(SDP__attribute__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_attributes=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__media__desc_template::single_value_struct {
SDP__media__field_template field_media__field;
CHARSTRING_template field_information;
SDP__connection__list_template field_connections;
SDP__bandwidth__list_template field_bandwidth;
SDP__key_template field_key;
SDP__attribute__list_template field_attributes;
};

void SDP__media__desc_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_media__field = ANY_VALUE;
single_value->field_information = ANY_OR_OMIT;
single_value->field_connections = ANY_OR_OMIT;
single_value->field_bandwidth = ANY_OR_OMIT;
single_value->field_key = ANY_OR_OMIT;
single_value->field_attributes = ANY_OR_OMIT;
}
}
}

void SDP__media__desc_template::copy_value(const SDP__media__desc& other_value)
{
single_value = new single_value_struct;
if (other_value.media__field().is_bound()) {
  single_value->field_media__field = other_value.media__field();
} else {
  single_value->field_media__field.clean_up();
}
if (other_value.information().is_bound()) {
  if (other_value.information().ispresent()) single_value->field_information = other_value.information()();
  else single_value->field_information = OMIT_VALUE;
} else {
  single_value->field_information.clean_up();
}
if (other_value.connections().is_bound()) {
  if (other_value.connections().ispresent()) single_value->field_connections = other_value.connections()();
  else single_value->field_connections = OMIT_VALUE;
} else {
  single_value->field_connections.clean_up();
}
if (other_value.bandwidth().is_bound()) {
  if (other_value.bandwidth().ispresent()) single_value->field_bandwidth = other_value.bandwidth()();
  else single_value->field_bandwidth = OMIT_VALUE;
} else {
  single_value->field_bandwidth.clean_up();
}
if (other_value.key().is_bound()) {
  if (other_value.key().ispresent()) single_value->field_key = other_value.key()();
  else single_value->field_key = OMIT_VALUE;
} else {
  single_value->field_key.clean_up();
}
if (other_value.attributes().is_bound()) {
  if (other_value.attributes().ispresent()) single_value->field_attributes = other_value.attributes()();
  else single_value->field_attributes = OMIT_VALUE;
} else {
  single_value->field_attributes.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__media__desc_template::copy_template(const SDP__media__desc_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.media__field().get_selection()) {
single_value->field_media__field = other_value.media__field();
} else {
single_value->field_media__field.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.information().get_selection()) {
single_value->field_information = other_value.information();
} else {
single_value->field_information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connections().get_selection()) {
single_value->field_connections = other_value.connections();
} else {
single_value->field_connections.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth().get_selection()) {
single_value->field_bandwidth = other_value.bandwidth();
} else {
single_value->field_bandwidth.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.key().get_selection()) {
single_value->field_key = other_value.key();
} else {
single_value->field_key.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.attributes().get_selection()) {
single_value->field_attributes = other_value.attributes();
} else {
single_value->field_attributes.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__media__desc_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__media__desc_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__media__desc_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc.");
break;
}
set_selection(other_value);
}

SDP__media__desc_template::SDP__media__desc_template()
{
}

SDP__media__desc_template::SDP__media__desc_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__media__desc_template::SDP__media__desc_template(const SDP__media__desc& other_value)
{
copy_value(other_value);
}

SDP__media__desc_template::SDP__media__desc_template(const OPTIONAL<SDP__media__desc>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__desc&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_media_desc from an unbound optional field.");
}
}

SDP__media__desc_template::SDP__media__desc_template(SDP__media__desc_template* p_precondition, SDP__media__desc_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__media__desc_template::SDP__media__desc_template(Dynamic_Match_Interface<SDP__media__desc>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__media__desc>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__media__desc_template::SDP__media__desc_template(const SDP__media__desc_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__media__desc_template::~SDP__media__desc_template()
{
clean_up();
}

SDP__media__desc_template& SDP__media__desc_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__media__desc_template& SDP__media__desc_template::operator=(const SDP__media__desc& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__media__desc_template& SDP__media__desc_template::operator=(const OPTIONAL<SDP__media__desc>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__desc&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_media_desc.");
}
return *this;
}

SDP__media__desc_template& SDP__media__desc_template::operator=(const SDP__media__desc_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__media__desc_template::match(const SDP__media__desc& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.media__field().is_bound()) return FALSE;
if(!single_value->field_media__field.match(other_value.media__field(), legacy))return FALSE;
if(!other_value.information().is_bound()) return FALSE;
if((other_value.information().ispresent() ? !single_value->field_information.match((const CHARSTRING&)other_value.information(), legacy) : !single_value->field_information.match_omit(legacy)))return FALSE;
if(!other_value.connections().is_bound()) return FALSE;
if((other_value.connections().ispresent() ? !single_value->field_connections.match((const SDP__connection__list&)other_value.connections(), legacy) : !single_value->field_connections.match_omit(legacy)))return FALSE;
if(!other_value.bandwidth().is_bound()) return FALSE;
if((other_value.bandwidth().ispresent() ? !single_value->field_bandwidth.match((const SDP__bandwidth__list&)other_value.bandwidth(), legacy) : !single_value->field_bandwidth.match_omit(legacy)))return FALSE;
if(!other_value.key().is_bound()) return FALSE;
if((other_value.key().ispresent() ? !single_value->field_key.match((const SDP__key&)other_value.key(), legacy) : !single_value->field_key.match_omit(legacy)))return FALSE;
if(!other_value.attributes().is_bound()) return FALSE;
if((other_value.attributes().ispresent() ? !single_value->field_attributes.match((const SDP__attribute__list&)other_value.attributes(), legacy) : !single_value->field_attributes.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc.");
}
return FALSE;
}

boolean SDP__media__desc_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_media__field.is_bound()
 || (single_value->field_information.is_omit() || single_value->field_information.is_bound())
 || (single_value->field_connections.is_omit() || single_value->field_connections.is_bound())
 || (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_bound())
 || (single_value->field_key.is_omit() || single_value->field_key.is_bound())
 || (single_value->field_attributes.is_omit() || single_value->field_attributes.is_bound());
}

boolean SDP__media__desc_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_media__field.is_value()
 && (single_value->field_information.is_omit() || single_value->field_information.is_value())
 && (single_value->field_connections.is_omit() || single_value->field_connections.is_value())
 && (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_value())
 && (single_value->field_key.is_omit() || single_value->field_key.is_value())
 && (single_value->field_attributes.is_omit() || single_value->field_attributes.is_value());
}

void SDP__media__desc_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__media__desc SDP__media__desc_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_media_desc.");
SDP__media__desc ret_val;
if (single_value->field_media__field.is_bound()) {
ret_val.media__field() = single_value->field_media__field.valueof();
}
if (single_value->field_information.is_omit()) ret_val.information() = OMIT_VALUE;
else if (single_value->field_information.is_bound()) {
ret_val.information() = single_value->field_information.valueof();
}
if (single_value->field_connections.is_omit()) ret_val.connections() = OMIT_VALUE;
else if (single_value->field_connections.is_bound()) {
ret_val.connections() = single_value->field_connections.valueof();
}
if (single_value->field_bandwidth.is_omit()) ret_val.bandwidth() = OMIT_VALUE;
else if (single_value->field_bandwidth.is_bound()) {
ret_val.bandwidth() = single_value->field_bandwidth.valueof();
}
if (single_value->field_key.is_omit()) ret_val.key() = OMIT_VALUE;
else if (single_value->field_key.is_bound()) {
ret_val.key() = single_value->field_key.valueof();
}
if (single_value->field_attributes.is_omit()) ret_val.attributes() = OMIT_VALUE;
else if (single_value->field_attributes.is_bound()) {
ret_val.attributes() = single_value->field_attributes.valueof();
}
return ret_val;
}

void SDP__media__desc_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_media_desc.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__media__desc_template[list_length];
}

SDP__media__desc_template& SDP__media__desc_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_media_desc.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_media_desc.");
return value_list.list_value[list_index];
}

SDP__media__field_template& SDP__media__desc_template::media__field()
{
set_specific();
return single_value->field_media__field;
}

const SDP__media__field_template& SDP__media__desc_template::media__field() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field media_field of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_media__field;
}

CHARSTRING_template& SDP__media__desc_template::information()
{
set_specific();
return single_value->field_information;
}

const CHARSTRING_template& SDP__media__desc_template::information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field information of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_information;
}

SDP__connection__list_template& SDP__media__desc_template::connections()
{
set_specific();
return single_value->field_connections;
}

const SDP__connection__list_template& SDP__media__desc_template::connections() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connections of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_connections;
}

SDP__bandwidth__list_template& SDP__media__desc_template::bandwidth()
{
set_specific();
return single_value->field_bandwidth;
}

const SDP__bandwidth__list_template& SDP__media__desc_template::bandwidth() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_bandwidth;
}

SDP__key_template& SDP__media__desc_template::key()
{
set_specific();
return single_value->field_key;
}

const SDP__key_template& SDP__media__desc_template::key() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field key of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_key;
}

SDP__attribute__list_template& SDP__media__desc_template::attributes()
{
set_specific();
return single_value->field_attributes;
}

const SDP__attribute__list_template& SDP__media__desc_template::attributes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attributes of a non-specific template of type @SDP_Types.SDP_media_desc.");
return single_value->field_attributes;
}

int SDP__media__desc_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_information.is_present()) ret_val++;
      if (single_value->field_connections.is_present()) ret_val++;
      if (single_value->field_bandwidth.is_present()) ret_val++;
      if (single_value->field_key.is_present()) ret_val++;
      if (single_value->field_attributes.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_media_desc containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc.");
  }
  return 0;
}

void SDP__media__desc_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ media_field := ");
single_value->field_media__field.log();
TTCN_Logger::log_event_str(", information := ");
single_value->field_information.log();
TTCN_Logger::log_event_str(", connections := ");
single_value->field_connections.log();
TTCN_Logger::log_event_str(", bandwidth := ");
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(", key := ");
single_value->field_key.log();
TTCN_Logger::log_event_str(", attributes := ");
single_value->field_attributes.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__media__desc_template::log_match(const SDP__media__desc& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_media__field.match(match_value.media__field(), legacy)){
TTCN_Logger::log_logmatch_info(".media_field");
single_value->field_media__field.log_match(match_value.media__field(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.information().ispresent()){
if(!single_value->field_information.match(match_value.information(), legacy)){
TTCN_Logger::log_logmatch_info(".information");
single_value->field_information.log_match(match_value.information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.connections().ispresent()){
if(!single_value->field_connections.match(match_value.connections(), legacy)){
TTCN_Logger::log_logmatch_info(".connections");
single_value->field_connections.log_match(match_value.connections(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_connections.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".connections := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_connections.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bandwidth().ispresent()){
if(!single_value->field_bandwidth.match(match_value.bandwidth(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth");
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bandwidth.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bandwidth := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.key().ispresent()){
if(!single_value->field_key.match(match_value.key(), legacy)){
TTCN_Logger::log_logmatch_info(".key");
single_value->field_key.log_match(match_value.key(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_key.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".key := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_key.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.attributes().ispresent()){
if(!single_value->field_attributes.match(match_value.attributes(), legacy)){
TTCN_Logger::log_logmatch_info(".attributes");
single_value->field_attributes.log_match(match_value.attributes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_attributes.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".attributes := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_attributes.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ media_field := ");
single_value->field_media__field.log_match(match_value.media__field(), legacy);
TTCN_Logger::log_event_str(", information := ");
if (match_value.information().ispresent()) {
single_value->field_information.log_match(match_value.information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_information.log();
if (single_value->field_information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", connections := ");
if (match_value.connections().ispresent()) {
single_value->field_connections.log_match(match_value.connections(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_connections.log();
if (single_value->field_connections.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bandwidth := ");
if (match_value.bandwidth().ispresent()) {
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bandwidth.log();
if (single_value->field_bandwidth.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", key := ");
if (match_value.key().ispresent()) {
single_value->field_key.log_match(match_value.key(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_key.log();
if (single_value->field_key.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", attributes := ");
if (match_value.attributes().ispresent()) {
single_value->field_attributes.log_match(match_value.attributes(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_attributes.log();
if (single_value->field_attributes.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__media__desc_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (media__field().is_bound()) media__field().set_implicit_omit();
if (!information().is_bound()) information() = OMIT_VALUE;
else information().set_implicit_omit();
if (!connections().is_bound()) connections() = OMIT_VALUE;
else connections().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (!key().is_bound()) key() = OMIT_VALUE;
else key().set_implicit_omit();
if (!attributes().is_bound()) attributes() = OMIT_VALUE;
else attributes().set_implicit_omit();
}

void SDP__media__desc_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_media__field.encode_text(text_buf);
single_value->field_information.encode_text(text_buf);
single_value->field_connections.encode_text(text_buf);
single_value->field_bandwidth.encode_text(text_buf);
single_value->field_key.encode_text(text_buf);
single_value->field_attributes.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc.");
}
}

void SDP__media__desc_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_media__field.decode_text(text_buf);
single_value->field_information.decode_text(text_buf);
single_value->field_connections.decode_text(text_buf);
single_value->field_bandwidth.decode_text(text_buf);
single_value->field_key.decode_text(text_buf);
single_value->field_attributes.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__media__desc_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_media_desc.");
}
}

void SDP__media__desc_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__media__desc_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_media_desc has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) media__field().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) information().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) connections().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) key().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) attributes().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "media_field")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          media__field().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connections")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connections().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "key")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          key().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attributes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attributes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_media_desc: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__media__desc_template* precondition = new SDP__media__desc_template;
    precondition->set_param(*param.get_elem(0));
    SDP__media__desc_template* implied_template = new SDP__media__desc_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__media__desc_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_media_desc");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__media__desc_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_media__field.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
single_value->field_information.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
single_value->field_connections.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
single_value->field_bandwidth.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
single_value->field_key.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
single_value->field_attributes.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_media_desc");
}

boolean SDP__media__desc_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__media__desc_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__media__desc SDP__media__desc__list::UNBOUND_ELEM;
boolean SDP__media__desc__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__media__desc__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (((const SDP__media__desc__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (((const SDP__media__desc__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__media__desc__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__media__desc__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__media__desc__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__media__desc__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__media__desc__list::SDP__media__desc__list()
{
val_ptr = NULL;
}

SDP__media__desc__list::SDP__media__desc__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__media__desc__list::SDP__media__desc__list(const SDP__media__desc__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_media_desc_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__media__desc__list::~SDP__media__desc__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__media__desc__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__media__desc__list& SDP__media__desc__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__media__desc__list& SDP__media__desc__list::operator=(const SDP__media__desc__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__media__desc__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_media_desc_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__media__desc__list::operator==(const SDP__media__desc__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__media__desc& SDP__media__desc__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_media_desc_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__media__desc**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__media__desc(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__media__desc;
}
return *val_ptr->value_elements[index_value];
}

SDP__media__desc& SDP__media__desc__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_media_desc_list.");
return (*this)[(int)index_value];
}

const SDP__media__desc& SDP__media__desc__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_media_desc_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_media_desc_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__media__desc& SDP__media__desc__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_media_desc_list.");
return (*this)[(int)index_value];
}

SDP__media__desc__list SDP__media__desc__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__media__desc__list SDP__media__desc__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__media__desc__list SDP__media__desc__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__media__desc__list SDP__media__desc__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__media__desc__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__media__desc(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__media__desc__list SDP__media__desc__list::operator+(const SDP__media__desc__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_media_desc_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__media__desc__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__media__desc(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__media__desc(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__media__desc__list SDP__media__desc__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_media_desc_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_media_desc_list","element");
SDP__media__desc__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__media__desc(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__media__desc__list SDP__media__desc__list::replace(int index, int len, const SDP__media__desc__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_media_desc_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_media_desc_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_media_desc_list","element");
SDP__media__desc__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__media__desc(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__media__desc(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__media__desc(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__media__desc__list SDP__media__desc__list::replace(int index, int len, const SDP__media__desc__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__media__desc__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_media_desc_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__media__desc**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__media__desc(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__media__desc**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_media_desc_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__media__desc**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__media__desc__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__media__desc__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_media_desc_list.");
return val_ptr->n_elements;
}

int SDP__media__desc__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_media_desc_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__media__desc__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__media__desc__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__media__desc__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_media_desc_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_media_desc_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__media__desc__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_media_desc_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__media__desc__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_media_desc_list.");
val_ptr->value_elements = (SDP__media__desc**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__media__desc;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__media__desc__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__media__desc__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__media__desc__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__media__desc__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__media__desc *val=new SDP__media__desc;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__media__desc**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__media__desc__list_template::copy_value(const SDP__media__desc__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_media_desc_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__media__desc_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__media__desc_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__media__desc_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__media__desc__list_template::copy_template(const SDP__media__desc__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__media__desc_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__media__desc_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__media__desc_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__media__desc__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__media__desc_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__media__desc__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__media__desc__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc_list.");
break;
}
set_selection(other_value);
}

boolean SDP__media__desc__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__media__desc__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__media__desc__list*)value_ptr)[value_index], legacy);
else return ((const SDP__media__desc__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__media__desc__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__media__desc__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__media__desc__list*)value_ptr)[value_index], legacy);
else return ((const SDP__media__desc__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__media__desc__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__media__desc__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__media__desc__list*)value_ptr)[index_value].log();
} else {
((const SDP__media__desc__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__media__desc__list*)value_ptr)[index_value], legacy);
}
}

SDP__media__desc__list_template::SDP__media__desc__list_template()
{
}

SDP__media__desc__list_template::SDP__media__desc__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__media__desc__list_template::SDP__media__desc__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__media__desc__list_template::SDP__media__desc__list_template(const SDP__media__desc__list& other_value)
{
copy_value(other_value);
}

SDP__media__desc__list_template::SDP__media__desc__list_template(const OPTIONAL<SDP__media__desc__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__desc__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_media_desc_list from an unbound optional field.");
}
}

SDP__media__desc__list_template::SDP__media__desc__list_template(SDP__media__desc__list_template* p_precondition, SDP__media__desc__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__media__desc__list_template::SDP__media__desc__list_template(Dynamic_Match_Interface<SDP__media__desc__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__media__desc__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__media__desc__list_template::SDP__media__desc__list_template(const SDP__media__desc__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__media__desc__list_template::~SDP__media__desc__list_template()
{
clean_up();
}

void SDP__media__desc__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__media__desc__list_template& SDP__media__desc__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__media__desc__list_template& SDP__media__desc__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__media__desc__list_template& SDP__media__desc__list_template::operator=(const SDP__media__desc__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__media__desc__list_template& SDP__media__desc__list_template::operator=(const OPTIONAL<SDP__media__desc__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__media__desc__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_media_desc_list.");
}
return *this;
}

SDP__media__desc__list_template& SDP__media__desc__list_template::operator=(const SDP__media__desc__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__media__desc_template& SDP__media__desc__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_media_desc_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_media_desc_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__media__desc_template& SDP__media__desc__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_media_desc_list.");
return (*this)[(int)index_value];
}

const SDP__media__desc_template& SDP__media__desc__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_media_desc_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_media_desc_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_media_desc_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__media__desc_template& SDP__media__desc__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_media_desc_list.");
return (*this)[(int)index_value];
}

void SDP__media__desc__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_media_desc_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__media__desc_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__media__desc_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__media__desc_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__media__desc_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__media__desc__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__media__desc__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_media_desc_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_media_desc_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_media_desc_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_media_desc_list");
}

boolean SDP__media__desc__list_template::match(const SDP__media__desc__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc_list.");
}
return FALSE;
}

boolean SDP__media__desc__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__media__desc__list SDP__media__desc__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_media_desc_list.");
SDP__media__desc__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__media__desc__list SDP__media__desc__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__media__desc__list SDP__media__desc__list_template::replace(int index, int len, const SDP__media__desc__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__media__desc__list SDP__media__desc__list_template::replace(int index, int len, const SDP__media__desc__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__media__desc__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__media__desc__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__media__desc_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_media_desc_list.");
}
set_selection(template_type);
}

SDP__media__desc__list_template& SDP__media__desc__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_media_desc_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_media_desc_list.");
return value_list.list_value[list_index];
}

SDP__media__desc_template& SDP__media__desc__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_media_desc_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_media_desc_list.");
return value_set.set_items[set_index];
}

void SDP__media__desc__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__media__desc__list_template::log_match(const SDP__media__desc__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__media__desc__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_media_desc_list.");
}
}

void SDP__media__desc__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_media_desc_list.");
single_value.value_elements = (SDP__media__desc_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__media__desc_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__media__desc__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__media__desc_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_media_desc_list.");
}
}

boolean SDP__media__desc__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__media__desc__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__media__desc__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__media__desc__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__media__desc__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__media__desc__list_template* precondition = new SDP__media__desc__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__media__desc__list_template* implied_template = new SDP__media__desc__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__media__desc__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_media_desc_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__media__desc__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_media_desc_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_media_desc_list");
}

boolean SDP__media__desc__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__time__field::SDP__time__field()
{
}

SDP__time__field::SDP__time__field(const CHARSTRING& par_start__time,
    const CHARSTRING& par_stop__time)
  :   field_start__time(par_start__time),
  field_stop__time(par_stop__time)
{
}

SDP__time__field::SDP__time__field(const SDP__time__field& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_time_field.");
if (other_value.start__time().is_bound()) field_start__time = other_value.start__time();
else field_start__time.clean_up();
if (other_value.stop__time().is_bound()) field_stop__time = other_value.stop__time();
else field_stop__time.clean_up();
}

void SDP__time__field::clean_up()
{
field_start__time.clean_up();
field_stop__time.clean_up();
}

const TTCN_Typedescriptor_t* SDP__time__field::get_descriptor() const { return &SDP__time__field_descr_; }
SDP__time__field& SDP__time__field::operator=(const SDP__time__field& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_time_field.");
  if (other_value.start__time().is_bound()) field_start__time = other_value.start__time();
  else field_start__time.clean_up();
  if (other_value.stop__time().is_bound()) field_stop__time = other_value.stop__time();
  else field_stop__time.clean_up();
}
return *this;
}

boolean SDP__time__field::operator==(const SDP__time__field& other_value) const
{
return field_start__time==other_value.field_start__time
  && field_stop__time==other_value.field_stop__time;
}

boolean SDP__time__field::is_bound() const
{
return (field_start__time.is_bound())
  || (field_stop__time.is_bound());
}
boolean SDP__time__field::is_value() const
{
return field_start__time.is_value()
  && field_stop__time.is_value();
}
void SDP__time__field::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ start_time := ");
field_start__time.log();
TTCN_Logger::log_event_str(", stop_time := ");
field_stop__time.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__time__field::set_implicit_omit()
{
if (start__time().is_bound()) start__time().set_implicit_omit();
if (stop__time().is_bound()) stop__time().set_implicit_omit();
}

void SDP__time__field::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_time_field has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) start__time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) stop__time().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "stop_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          stop__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_time_field: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_time_field");
  }
}

void SDP__time__field::encode_text(Text_Buf& text_buf) const
{
field_start__time.encode_text(text_buf);
field_stop__time.encode_text(text_buf);
}

void SDP__time__field::decode_text(Text_Buf& text_buf)
{
field_start__time.decode_text(text_buf);
field_stop__time.decode_text(text_buf);
}

void SDP__time__field::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__time__field::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__time__field::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_start__time.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_stop__time.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__time__field::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_start__time.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'start__time' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_stop__time.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'stop__time' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__time__field_template::single_value_struct {
CHARSTRING_template field_start__time;
CHARSTRING_template field_stop__time;
};

void SDP__time__field_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_start__time = ANY_VALUE;
single_value->field_stop__time = ANY_VALUE;
}
}
}

void SDP__time__field_template::copy_value(const SDP__time__field& other_value)
{
single_value = new single_value_struct;
if (other_value.start__time().is_bound()) {
  single_value->field_start__time = other_value.start__time();
} else {
  single_value->field_start__time.clean_up();
}
if (other_value.stop__time().is_bound()) {
  single_value->field_stop__time = other_value.stop__time();
} else {
  single_value->field_stop__time.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__time__field_template::copy_template(const SDP__time__field_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.start__time().get_selection()) {
single_value->field_start__time = other_value.start__time();
} else {
single_value->field_start__time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.stop__time().get_selection()) {
single_value->field_stop__time = other_value.stop__time();
} else {
single_value->field_stop__time.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__time__field_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__time__field_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__time__field_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_time_field.");
break;
}
set_selection(other_value);
}

SDP__time__field_template::SDP__time__field_template()
{
}

SDP__time__field_template::SDP__time__field_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__time__field_template::SDP__time__field_template(const SDP__time__field& other_value)
{
copy_value(other_value);
}

SDP__time__field_template::SDP__time__field_template(const OPTIONAL<SDP__time__field>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time__field&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_time_field from an unbound optional field.");
}
}

SDP__time__field_template::SDP__time__field_template(SDP__time__field_template* p_precondition, SDP__time__field_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__time__field_template::SDP__time__field_template(Dynamic_Match_Interface<SDP__time__field>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__time__field>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__time__field_template::SDP__time__field_template(const SDP__time__field_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__time__field_template::~SDP__time__field_template()
{
clean_up();
}

SDP__time__field_template& SDP__time__field_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__time__field_template& SDP__time__field_template::operator=(const SDP__time__field& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__time__field_template& SDP__time__field_template::operator=(const OPTIONAL<SDP__time__field>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time__field&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_time_field.");
}
return *this;
}

SDP__time__field_template& SDP__time__field_template::operator=(const SDP__time__field_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__time__field_template::match(const SDP__time__field& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.start__time().is_bound()) return FALSE;
if(!single_value->field_start__time.match(other_value.start__time(), legacy))return FALSE;
if(!other_value.stop__time().is_bound()) return FALSE;
if(!single_value->field_stop__time.match(other_value.stop__time(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_time_field.");
}
return FALSE;
}

boolean SDP__time__field_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_start__time.is_bound()
 || single_value->field_stop__time.is_bound();
}

boolean SDP__time__field_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_start__time.is_value()
 && single_value->field_stop__time.is_value();
}

void SDP__time__field_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__time__field SDP__time__field_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_time_field.");
SDP__time__field ret_val;
if (single_value->field_start__time.is_bound()) {
ret_val.start__time() = single_value->field_start__time.valueof();
}
if (single_value->field_stop__time.is_bound()) {
ret_val.stop__time() = single_value->field_stop__time.valueof();
}
return ret_val;
}

void SDP__time__field_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_time_field.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__time__field_template[list_length];
}

SDP__time__field_template& SDP__time__field_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_time_field.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_time_field.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__time__field_template::start__time()
{
set_specific();
return single_value->field_start__time;
}

const CHARSTRING_template& SDP__time__field_template::start__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field start_time of a non-specific template of type @SDP_Types.SDP_time_field.");
return single_value->field_start__time;
}

CHARSTRING_template& SDP__time__field_template::stop__time()
{
set_specific();
return single_value->field_stop__time;
}

const CHARSTRING_template& SDP__time__field_template::stop__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field stop_time of a non-specific template of type @SDP_Types.SDP_time_field.");
return single_value->field_stop__time;
}

int SDP__time__field_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time_field containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_time_field.");
  }
  return 0;
}

void SDP__time__field_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ start_time := ");
single_value->field_start__time.log();
TTCN_Logger::log_event_str(", stop_time := ");
single_value->field_stop__time.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__time__field_template::log_match(const SDP__time__field& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_start__time.match(match_value.start__time(), legacy)){
TTCN_Logger::log_logmatch_info(".start_time");
single_value->field_start__time.log_match(match_value.start__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_stop__time.match(match_value.stop__time(), legacy)){
TTCN_Logger::log_logmatch_info(".stop_time");
single_value->field_stop__time.log_match(match_value.stop__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ start_time := ");
single_value->field_start__time.log_match(match_value.start__time(), legacy);
TTCN_Logger::log_event_str(", stop_time := ");
single_value->field_stop__time.log_match(match_value.stop__time(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__time__field_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (start__time().is_bound()) start__time().set_implicit_omit();
if (stop__time().is_bound()) stop__time().set_implicit_omit();
}

void SDP__time__field_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_start__time.encode_text(text_buf);
single_value->field_stop__time.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_time_field.");
}
}

void SDP__time__field_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_start__time.decode_text(text_buf);
single_value->field_stop__time.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__time__field_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_time_field.");
}
}

void SDP__time__field_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__time__field_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_time_field has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) start__time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) stop__time().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "stop_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          stop__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_time_field: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__time__field_template* precondition = new SDP__time__field_template;
    precondition->set_param(*param.get_elem(0));
    SDP__time__field_template* implied_template = new SDP__time__field_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__time__field_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_time_field");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__time__field_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_start__time.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_time_field");
single_value->field_stop__time.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_time_field");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_time_field");
}

boolean SDP__time__field_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__time__field_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SDP__time::SDP__time()
{
}

SDP__time::SDP__time(const SDP__time__field& par_time__field,
    const OPTIONAL< SDP__repeat__list >& par_time__repeat)
  :   field_time__field(par_time__field),
  field_time__repeat(par_time__repeat)
{
}

SDP__time::SDP__time(const SDP__time& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_time.");
if (other_value.time__field().is_bound()) field_time__field = other_value.time__field();
else field_time__field.clean_up();
if (other_value.time__repeat().is_bound()) field_time__repeat = other_value.time__repeat();
else field_time__repeat.clean_up();
}

void SDP__time::clean_up()
{
field_time__field.clean_up();
field_time__repeat.clean_up();
}

const TTCN_Typedescriptor_t* SDP__time::get_descriptor() const { return &SDP__time_descr_; }
SDP__time& SDP__time::operator=(const SDP__time& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_time.");
  if (other_value.time__field().is_bound()) field_time__field = other_value.time__field();
  else field_time__field.clean_up();
  if (other_value.time__repeat().is_bound()) field_time__repeat = other_value.time__repeat();
  else field_time__repeat.clean_up();
}
return *this;
}

boolean SDP__time::operator==(const SDP__time& other_value) const
{
return field_time__field==other_value.field_time__field
  && field_time__repeat==other_value.field_time__repeat;
}

boolean SDP__time::is_bound() const
{
return (field_time__field.is_bound())
  || (OPTIONAL_OMIT == field_time__repeat.get_selection() || field_time__repeat.is_bound());
}
boolean SDP__time::is_value() const
{
return field_time__field.is_value()
  && (OPTIONAL_OMIT == field_time__repeat.get_selection() || field_time__repeat.is_value());
}
int SDP__time::size_of() const
{
  int ret_val = 1;
  if (field_time__repeat.ispresent()) ret_val++;
  return ret_val;
}

void SDP__time::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ time_field := ");
field_time__field.log();
TTCN_Logger::log_event_str(", time_repeat := ");
field_time__repeat.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__time::set_implicit_omit()
{
if (time__field().is_bound()) time__field().set_implicit_omit();
if (!time__repeat().is_bound()) time__repeat() = OMIT_VALUE;
else time__repeat().set_implicit_omit();
}

void SDP__time::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_time has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) time__field().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) time__repeat().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_field")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__field().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_repeat")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__repeat().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_time: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_time");
  }
}

void SDP__time::encode_text(Text_Buf& text_buf) const
{
field_time__field.encode_text(text_buf);
field_time__repeat.encode_text(text_buf);
}

void SDP__time::decode_text(Text_Buf& text_buf)
{
field_time__field.decode_text(text_buf);
field_time__repeat.decode_text(text_buf);
}

void SDP__time::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__time::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__time::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_time__field.TEXT_encode(SDP__time__field_descr_,p_buf);
 need_separator=TRUE;
  if(field_time__repeat.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_time__repeat().TEXT_encode(SDP__repeat__list_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__time::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_time__repeat=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_time__field.TEXT_decode(SDP__time__field_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'time__field' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_time__repeat().TEXT_decode(SDP__repeat__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_time__repeat=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__time_template::single_value_struct {
SDP__time__field_template field_time__field;
SDP__repeat__list_template field_time__repeat;
};

void SDP__time_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_time__field = ANY_VALUE;
single_value->field_time__repeat = ANY_OR_OMIT;
}
}
}

void SDP__time_template::copy_value(const SDP__time& other_value)
{
single_value = new single_value_struct;
if (other_value.time__field().is_bound()) {
  single_value->field_time__field = other_value.time__field();
} else {
  single_value->field_time__field.clean_up();
}
if (other_value.time__repeat().is_bound()) {
  if (other_value.time__repeat().ispresent()) single_value->field_time__repeat = other_value.time__repeat()();
  else single_value->field_time__repeat = OMIT_VALUE;
} else {
  single_value->field_time__repeat.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__time_template::copy_template(const SDP__time_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.time__field().get_selection()) {
single_value->field_time__field = other_value.time__field();
} else {
single_value->field_time__field.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.time__repeat().get_selection()) {
single_value->field_time__repeat = other_value.time__repeat();
} else {
single_value->field_time__repeat.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__time_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__time_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__time_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_time.");
break;
}
set_selection(other_value);
}

SDP__time_template::SDP__time_template()
{
}

SDP__time_template::SDP__time_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__time_template::SDP__time_template(const SDP__time& other_value)
{
copy_value(other_value);
}

SDP__time_template::SDP__time_template(const OPTIONAL<SDP__time>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_time from an unbound optional field.");
}
}

SDP__time_template::SDP__time_template(SDP__time_template* p_precondition, SDP__time_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__time_template::SDP__time_template(Dynamic_Match_Interface<SDP__time>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__time>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__time_template::SDP__time_template(const SDP__time_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__time_template::~SDP__time_template()
{
clean_up();
}

SDP__time_template& SDP__time_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__time_template& SDP__time_template::operator=(const SDP__time& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__time_template& SDP__time_template::operator=(const OPTIONAL<SDP__time>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_time.");
}
return *this;
}

SDP__time_template& SDP__time_template::operator=(const SDP__time_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__time_template::match(const SDP__time& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.time__field().is_bound()) return FALSE;
if(!single_value->field_time__field.match(other_value.time__field(), legacy))return FALSE;
if(!other_value.time__repeat().is_bound()) return FALSE;
if((other_value.time__repeat().ispresent() ? !single_value->field_time__repeat.match((const SDP__repeat__list&)other_value.time__repeat(), legacy) : !single_value->field_time__repeat.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_time.");
}
return FALSE;
}

boolean SDP__time_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_time__field.is_bound()
 || (single_value->field_time__repeat.is_omit() || single_value->field_time__repeat.is_bound());
}

boolean SDP__time_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_time__field.is_value()
 && (single_value->field_time__repeat.is_omit() || single_value->field_time__repeat.is_value());
}

void SDP__time_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__time SDP__time_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_time.");
SDP__time ret_val;
if (single_value->field_time__field.is_bound()) {
ret_val.time__field() = single_value->field_time__field.valueof();
}
if (single_value->field_time__repeat.is_omit()) ret_val.time__repeat() = OMIT_VALUE;
else if (single_value->field_time__repeat.is_bound()) {
ret_val.time__repeat() = single_value->field_time__repeat.valueof();
}
return ret_val;
}

void SDP__time_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_time.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__time_template[list_length];
}

SDP__time_template& SDP__time_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_time.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_time.");
return value_list.list_value[list_index];
}

SDP__time__field_template& SDP__time_template::time__field()
{
set_specific();
return single_value->field_time__field;
}

const SDP__time__field_template& SDP__time_template::time__field() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time_field of a non-specific template of type @SDP_Types.SDP_time.");
return single_value->field_time__field;
}

SDP__repeat__list_template& SDP__time_template::time__repeat()
{
set_specific();
return single_value->field_time__repeat;
}

const SDP__repeat__list_template& SDP__time_template::time__repeat() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time_repeat of a non-specific template of type @SDP_Types.SDP_time.");
return single_value->field_time__repeat;
}

int SDP__time_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_time__repeat.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_time containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_time.");
  }
  return 0;
}

void SDP__time_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ time_field := ");
single_value->field_time__field.log();
TTCN_Logger::log_event_str(", time_repeat := ");
single_value->field_time__repeat.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__time_template::log_match(const SDP__time& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_time__field.match(match_value.time__field(), legacy)){
TTCN_Logger::log_logmatch_info(".time_field");
single_value->field_time__field.log_match(match_value.time__field(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.time__repeat().ispresent()){
if(!single_value->field_time__repeat.match(match_value.time__repeat(), legacy)){
TTCN_Logger::log_logmatch_info(".time_repeat");
single_value->field_time__repeat.log_match(match_value.time__repeat(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_time__repeat.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".time_repeat := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_time__repeat.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ time_field := ");
single_value->field_time__field.log_match(match_value.time__field(), legacy);
TTCN_Logger::log_event_str(", time_repeat := ");
if (match_value.time__repeat().ispresent()) {
single_value->field_time__repeat.log_match(match_value.time__repeat(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_time__repeat.log();
if (single_value->field_time__repeat.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__time_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (time__field().is_bound()) time__field().set_implicit_omit();
if (!time__repeat().is_bound()) time__repeat() = OMIT_VALUE;
else time__repeat().set_implicit_omit();
}

void SDP__time_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_time__field.encode_text(text_buf);
single_value->field_time__repeat.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_time.");
}
}

void SDP__time_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_time__field.decode_text(text_buf);
single_value->field_time__repeat.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__time_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_time.");
}
}

void SDP__time_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__time_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_time has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) time__field().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) time__repeat().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_field")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__field().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_repeat")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__repeat().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_time: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__time_template* precondition = new SDP__time_template;
    precondition->set_param(*param.get_elem(0));
    SDP__time_template* implied_template = new SDP__time_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__time_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_time");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__time_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_time__field.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_time");
single_value->field_time__repeat.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_time");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_time");
}

boolean SDP__time_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__time_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__repeat SDP__repeat__list::UNBOUND_ELEM;
boolean SDP__repeat__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__repeat__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_repeat_list.");
if (((const SDP__repeat__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_repeat_list.");
if (((const SDP__repeat__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__repeat__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__repeat__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__repeat__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__repeat__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__repeat__list::SDP__repeat__list()
{
val_ptr = NULL;
}

SDP__repeat__list::SDP__repeat__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__repeat__list::SDP__repeat__list(const SDP__repeat__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_repeat_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__repeat__list::~SDP__repeat__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__repeat__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__repeat__list& SDP__repeat__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__repeat__list& SDP__repeat__list::operator=(const SDP__repeat__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_repeat_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__repeat__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_repeat_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__repeat__list::operator==(const SDP__repeat__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_repeat_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_repeat_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__repeat& SDP__repeat__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_repeat_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__repeat**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__repeat(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__repeat;
}
return *val_ptr->value_elements[index_value];
}

SDP__repeat& SDP__repeat__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_repeat_list.");
return (*this)[(int)index_value];
}

const SDP__repeat& SDP__repeat__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_repeat_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_repeat_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_repeat_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__repeat& SDP__repeat__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_repeat_list.");
return (*this)[(int)index_value];
}

SDP__repeat__list SDP__repeat__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__repeat__list SDP__repeat__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__repeat__list SDP__repeat__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__repeat__list SDP__repeat__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_repeat_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__repeat__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__repeat(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__repeat__list SDP__repeat__list::operator+(const SDP__repeat__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_repeat_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__repeat__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__repeat(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__repeat(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__repeat__list SDP__repeat__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_repeat_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_repeat_list","element");
SDP__repeat__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__repeat(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__repeat__list SDP__repeat__list::replace(int index, int len, const SDP__repeat__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_repeat_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_repeat_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_repeat_list","element");
SDP__repeat__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__repeat(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__repeat(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__repeat(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__repeat__list SDP__repeat__list::replace(int index, int len, const SDP__repeat__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__repeat__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_repeat_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__repeat**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__repeat(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__repeat**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_repeat_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__repeat**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__repeat__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__repeat__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_repeat_list.");
return val_ptr->n_elements;
}

int SDP__repeat__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_repeat_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__repeat__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__repeat__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__repeat__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_repeat_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_repeat_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__repeat__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_repeat_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__repeat__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_repeat_list.");
val_ptr->value_elements = (SDP__repeat**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__repeat;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__repeat__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__repeat__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__repeat__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__repeat__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__repeat *val=new SDP__repeat;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__repeat**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__repeat__list_template::copy_value(const SDP__repeat__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_repeat_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__repeat_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__repeat_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__repeat_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__repeat__list_template::copy_template(const SDP__repeat__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__repeat_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__repeat_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__repeat_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__repeat__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__repeat_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__repeat__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__repeat__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_repeat_list.");
break;
}
set_selection(other_value);
}

boolean SDP__repeat__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__repeat__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__repeat__list*)value_ptr)[value_index], legacy);
else return ((const SDP__repeat__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__repeat__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__repeat__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__repeat__list*)value_ptr)[value_index], legacy);
else return ((const SDP__repeat__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__repeat__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__repeat__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__repeat__list*)value_ptr)[index_value].log();
} else {
((const SDP__repeat__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__repeat__list*)value_ptr)[index_value], legacy);
}
}

SDP__repeat__list_template::SDP__repeat__list_template()
{
}

SDP__repeat__list_template::SDP__repeat__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__repeat__list_template::SDP__repeat__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__repeat__list_template::SDP__repeat__list_template(const SDP__repeat__list& other_value)
{
copy_value(other_value);
}

SDP__repeat__list_template::SDP__repeat__list_template(const OPTIONAL<SDP__repeat__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__repeat__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_repeat_list from an unbound optional field.");
}
}

SDP__repeat__list_template::SDP__repeat__list_template(SDP__repeat__list_template* p_precondition, SDP__repeat__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__repeat__list_template::SDP__repeat__list_template(Dynamic_Match_Interface<SDP__repeat__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__repeat__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__repeat__list_template::SDP__repeat__list_template(const SDP__repeat__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__repeat__list_template::~SDP__repeat__list_template()
{
clean_up();
}

void SDP__repeat__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__repeat__list_template& SDP__repeat__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__repeat__list_template& SDP__repeat__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__repeat__list_template& SDP__repeat__list_template::operator=(const SDP__repeat__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__repeat__list_template& SDP__repeat__list_template::operator=(const OPTIONAL<SDP__repeat__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__repeat__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_repeat_list.");
}
return *this;
}

SDP__repeat__list_template& SDP__repeat__list_template::operator=(const SDP__repeat__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__repeat_template& SDP__repeat__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_repeat_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_repeat_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__repeat_template& SDP__repeat__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_repeat_list.");
return (*this)[(int)index_value];
}

const SDP__repeat_template& SDP__repeat__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_repeat_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_repeat_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_repeat_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__repeat_template& SDP__repeat__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_repeat_list.");
return (*this)[(int)index_value];
}

void SDP__repeat__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_repeat_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__repeat_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__repeat_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__repeat_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__repeat_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__repeat__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__repeat__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_repeat_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_repeat_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_repeat_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_repeat_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_repeat_list");
}

boolean SDP__repeat__list_template::match(const SDP__repeat__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_repeat_list.");
}
return FALSE;
}

boolean SDP__repeat__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__repeat__list SDP__repeat__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_repeat_list.");
SDP__repeat__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__repeat__list SDP__repeat__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__repeat__list SDP__repeat__list_template::replace(int index, int len, const SDP__repeat__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__repeat__list SDP__repeat__list_template::replace(int index, int len, const SDP__repeat__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__repeat__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__repeat__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__repeat_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_repeat_list.");
}
set_selection(template_type);
}

SDP__repeat__list_template& SDP__repeat__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_repeat_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_repeat_list.");
return value_list.list_value[list_index];
}

SDP__repeat_template& SDP__repeat__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_repeat_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_repeat_list.");
return value_set.set_items[set_index];
}

void SDP__repeat__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__repeat__list_template::log_match(const SDP__repeat__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__repeat__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_repeat_list.");
}
}

void SDP__repeat__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_repeat_list.");
single_value.value_elements = (SDP__repeat_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__repeat_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__repeat__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__repeat_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_repeat_list.");
}
}

boolean SDP__repeat__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__repeat__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__repeat__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__repeat__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__repeat__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__repeat__list_template* precondition = new SDP__repeat__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__repeat__list_template* implied_template = new SDP__repeat__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__repeat__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_repeat_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__repeat__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_repeat_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_repeat_list");
}

boolean SDP__repeat__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__typed__time::SDP__typed__time()
{
}

SDP__typed__time::SDP__typed__time(const INTEGER& par_time,
    const OPTIONAL< CHARSTRING >& par_unit)
  :   field_time(par_time),
  field_unit(par_unit)
{
}

SDP__typed__time::SDP__typed__time(const SDP__typed__time& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_typed_time.");
if (other_value.time().is_bound()) field_time = other_value.time();
else field_time.clean_up();
if (other_value.unit().is_bound()) field_unit = other_value.unit();
else field_unit.clean_up();
}

void SDP__typed__time::clean_up()
{
field_time.clean_up();
field_unit.clean_up();
}

const TTCN_Typedescriptor_t* SDP__typed__time::get_descriptor() const { return &SDP__typed__time_descr_; }
SDP__typed__time& SDP__typed__time::operator=(const SDP__typed__time& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_typed_time.");
  if (other_value.time().is_bound()) field_time = other_value.time();
  else field_time.clean_up();
  if (other_value.unit().is_bound()) field_unit = other_value.unit();
  else field_unit.clean_up();
}
return *this;
}

boolean SDP__typed__time::operator==(const SDP__typed__time& other_value) const
{
return field_time==other_value.field_time
  && field_unit==other_value.field_unit;
}

boolean SDP__typed__time::is_bound() const
{
return (field_time.is_bound())
  || (OPTIONAL_OMIT == field_unit.get_selection() || field_unit.is_bound());
}
boolean SDP__typed__time::is_value() const
{
return field_time.is_value()
  && (OPTIONAL_OMIT == field_unit.get_selection() || field_unit.is_value());
}
int SDP__typed__time::size_of() const
{
  int ret_val = 1;
  if (field_unit.ispresent()) ret_val++;
  return ret_val;
}

void SDP__typed__time::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ time := ");
field_time.log();
TTCN_Logger::log_event_str(", unit := ");
field_unit.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__typed__time::set_implicit_omit()
{
if (time().is_bound()) time().set_implicit_omit();
if (!unit().is_bound()) unit() = OMIT_VALUE;
else unit().set_implicit_omit();
}

void SDP__typed__time::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_typed_time has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) unit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "unit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          unit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_typed_time: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_typed_time");
  }
}

void SDP__typed__time::encode_text(Text_Buf& text_buf) const
{
field_time.encode_text(text_buf);
field_unit.encode_text(text_buf);
}

void SDP__typed__time::decode_text(Text_Buf& text_buf)
{
field_time.decode_text(text_buf);
field_unit.decode_text(text_buf);
}

void SDP__typed__time::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__typed__time::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__typed__time::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_time.TEXT_encode(SDP__typed__time_time_descr_,p_buf);
 need_separator=TRUE;
  if(field_unit.ispresent()){
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_unit().TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__typed__time::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    field_unit=OMIT_VALUE;
    while(TRUE){
    decoded_field_length=field_time.TEXT_decode(SDP__typed__time_time_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'time' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
      sep_found=FALSE;
      break;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else {
      sep_found=FALSE;
      if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
    }
  }
    pos=p_buf.get_pos();
    decoded_field_length=field_unit().TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
    field_unit=OMIT_VALUE;
    p_buf.set_pos(pos);
    } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__typed__time_template::single_value_struct {
INTEGER_template field_time;
CHARSTRING_template field_unit;
};

void SDP__typed__time_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_time = ANY_VALUE;
single_value->field_unit = ANY_OR_OMIT;
}
}
}

void SDP__typed__time_template::copy_value(const SDP__typed__time& other_value)
{
single_value = new single_value_struct;
if (other_value.time().is_bound()) {
  single_value->field_time = other_value.time();
} else {
  single_value->field_time.clean_up();
}
if (other_value.unit().is_bound()) {
  if (other_value.unit().ispresent()) single_value->field_unit = other_value.unit()();
  else single_value->field_unit = OMIT_VALUE;
} else {
  single_value->field_unit.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__typed__time_template::copy_template(const SDP__typed__time_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.time().get_selection()) {
single_value->field_time = other_value.time();
} else {
single_value->field_time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.unit().get_selection()) {
single_value->field_unit = other_value.unit();
} else {
single_value->field_unit.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__typed__time_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__typed__time_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__typed__time_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time.");
break;
}
set_selection(other_value);
}

SDP__typed__time_template::SDP__typed__time_template()
{
}

SDP__typed__time_template::SDP__typed__time_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__typed__time_template::SDP__typed__time_template(const SDP__typed__time& other_value)
{
copy_value(other_value);
}

SDP__typed__time_template::SDP__typed__time_template(const OPTIONAL<SDP__typed__time>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__typed__time&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_typed_time from an unbound optional field.");
}
}

SDP__typed__time_template::SDP__typed__time_template(SDP__typed__time_template* p_precondition, SDP__typed__time_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__typed__time_template::SDP__typed__time_template(Dynamic_Match_Interface<SDP__typed__time>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__typed__time>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__typed__time_template::SDP__typed__time_template(const SDP__typed__time_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__typed__time_template::~SDP__typed__time_template()
{
clean_up();
}

SDP__typed__time_template& SDP__typed__time_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__typed__time_template& SDP__typed__time_template::operator=(const SDP__typed__time& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__typed__time_template& SDP__typed__time_template::operator=(const OPTIONAL<SDP__typed__time>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__typed__time&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_typed_time.");
}
return *this;
}

SDP__typed__time_template& SDP__typed__time_template::operator=(const SDP__typed__time_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__typed__time_template::match(const SDP__typed__time& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.time().is_bound()) return FALSE;
if(!single_value->field_time.match(other_value.time(), legacy))return FALSE;
if(!other_value.unit().is_bound()) return FALSE;
if((other_value.unit().ispresent() ? !single_value->field_unit.match((const CHARSTRING&)other_value.unit(), legacy) : !single_value->field_unit.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time.");
}
return FALSE;
}

boolean SDP__typed__time_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_time.is_bound()
 || (single_value->field_unit.is_omit() || single_value->field_unit.is_bound());
}

boolean SDP__typed__time_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_time.is_value()
 && (single_value->field_unit.is_omit() || single_value->field_unit.is_value());
}

void SDP__typed__time_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__typed__time SDP__typed__time_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_typed_time.");
SDP__typed__time ret_val;
if (single_value->field_time.is_bound()) {
ret_val.time() = single_value->field_time.valueof();
}
if (single_value->field_unit.is_omit()) ret_val.unit() = OMIT_VALUE;
else if (single_value->field_unit.is_bound()) {
ret_val.unit() = single_value->field_unit.valueof();
}
return ret_val;
}

void SDP__typed__time_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_typed_time.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__typed__time_template[list_length];
}

SDP__typed__time_template& SDP__typed__time_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_typed_time.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_typed_time.");
return value_list.list_value[list_index];
}

INTEGER_template& SDP__typed__time_template::time()
{
set_specific();
return single_value->field_time;
}

const INTEGER_template& SDP__typed__time_template::time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time of a non-specific template of type @SDP_Types.SDP_typed_time.");
return single_value->field_time;
}

CHARSTRING_template& SDP__typed__time_template::unit()
{
set_specific();
return single_value->field_unit;
}

const CHARSTRING_template& SDP__typed__time_template::unit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field unit of a non-specific template of type @SDP_Types.SDP_typed_time.");
return single_value->field_unit;
}

int SDP__typed__time_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_unit.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_typed_time containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time.");
  }
  return 0;
}

void SDP__typed__time_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ time := ");
single_value->field_time.log();
TTCN_Logger::log_event_str(", unit := ");
single_value->field_unit.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__typed__time_template::log_match(const SDP__typed__time& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_time.match(match_value.time(), legacy)){
TTCN_Logger::log_logmatch_info(".time");
single_value->field_time.log_match(match_value.time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.unit().ispresent()){
if(!single_value->field_unit.match(match_value.unit(), legacy)){
TTCN_Logger::log_logmatch_info(".unit");
single_value->field_unit.log_match(match_value.unit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_unit.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".unit := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_unit.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ time := ");
single_value->field_time.log_match(match_value.time(), legacy);
TTCN_Logger::log_event_str(", unit := ");
if (match_value.unit().ispresent()) {
single_value->field_unit.log_match(match_value.unit(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_unit.log();
if (single_value->field_unit.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__typed__time_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (time().is_bound()) time().set_implicit_omit();
if (!unit().is_bound()) unit() = OMIT_VALUE;
else unit().set_implicit_omit();
}

void SDP__typed__time_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_time.encode_text(text_buf);
single_value->field_unit.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time.");
}
}

void SDP__typed__time_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_time.decode_text(text_buf);
single_value->field_unit.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__typed__time_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_typed_time.");
}
}

void SDP__typed__time_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__typed__time_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_typed_time has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) unit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "unit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          unit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_typed_time: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__typed__time_template* precondition = new SDP__typed__time_template;
    precondition->set_param(*param.get_elem(0));
    SDP__typed__time_template* implied_template = new SDP__typed__time_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__typed__time_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_typed_time");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__typed__time_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_time.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_typed_time");
single_value->field_unit.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_typed_time");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_typed_time");
}

boolean SDP__typed__time_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__typed__time_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__typed__time SDP__typed__time__list::UNBOUND_ELEM;
boolean SDP__typed__time__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__typed__time__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (((const SDP__typed__time__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (((const SDP__typed__time__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__typed__time__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__typed__time__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__typed__time__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__typed__time__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__typed__time__list::SDP__typed__time__list()
{
val_ptr = NULL;
}

SDP__typed__time__list::SDP__typed__time__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__typed__time__list::SDP__typed__time__list(const SDP__typed__time__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_typed_time_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__typed__time__list::~SDP__typed__time__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__typed__time__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__typed__time__list& SDP__typed__time__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__typed__time__list& SDP__typed__time__list::operator=(const SDP__typed__time__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__typed__time__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_typed_time_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__typed__time__list::operator==(const SDP__typed__time__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__typed__time& SDP__typed__time__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_typed_time_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__typed__time**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__typed__time(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__typed__time;
}
return *val_ptr->value_elements[index_value];
}

SDP__typed__time& SDP__typed__time__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_typed_time_list.");
return (*this)[(int)index_value];
}

const SDP__typed__time& SDP__typed__time__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_typed_time_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_typed_time_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__typed__time& SDP__typed__time__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_typed_time_list.");
return (*this)[(int)index_value];
}

SDP__typed__time__list SDP__typed__time__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__typed__time__list SDP__typed__time__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__typed__time__list SDP__typed__time__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__typed__time__list SDP__typed__time__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__typed__time__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__typed__time(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__typed__time__list SDP__typed__time__list::operator+(const SDP__typed__time__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_typed_time_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__typed__time__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__typed__time(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__typed__time(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__typed__time__list SDP__typed__time__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_typed_time_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_typed_time_list","element");
SDP__typed__time__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__typed__time(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__typed__time__list SDP__typed__time__list::replace(int index, int len, const SDP__typed__time__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_typed_time_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_typed_time_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_typed_time_list","element");
SDP__typed__time__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__typed__time(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__typed__time(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__typed__time(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__typed__time__list SDP__typed__time__list::replace(int index, int len, const SDP__typed__time__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__typed__time__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_typed_time_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__typed__time**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__typed__time(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__typed__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_typed_time_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__typed__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__typed__time__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__typed__time__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_typed_time_list.");
return val_ptr->n_elements;
}

int SDP__typed__time__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_typed_time_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__typed__time__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__typed__time__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__typed__time__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_typed_time_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_typed_time_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__typed__time__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_typed_time_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__typed__time__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_typed_time_list.");
val_ptr->value_elements = (SDP__typed__time**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__typed__time;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__typed__time__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__typed__time__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__typed__time__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__typed__time__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__typed__time *val=new SDP__typed__time;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__typed__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__typed__time__list_template::copy_value(const SDP__typed__time__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_typed_time_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__typed__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__typed__time_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__typed__time_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__typed__time__list_template::copy_template(const SDP__typed__time__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__typed__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__typed__time_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__typed__time_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__typed__time__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__typed__time_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__typed__time__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__typed__time__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time_list.");
break;
}
set_selection(other_value);
}

boolean SDP__typed__time__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__typed__time__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__typed__time__list*)value_ptr)[value_index], legacy);
else return ((const SDP__typed__time__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__typed__time__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__typed__time__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__typed__time__list*)value_ptr)[value_index], legacy);
else return ((const SDP__typed__time__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__typed__time__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__typed__time__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__typed__time__list*)value_ptr)[index_value].log();
} else {
((const SDP__typed__time__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__typed__time__list*)value_ptr)[index_value], legacy);
}
}

SDP__typed__time__list_template::SDP__typed__time__list_template()
{
}

SDP__typed__time__list_template::SDP__typed__time__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__typed__time__list_template::SDP__typed__time__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__typed__time__list_template::SDP__typed__time__list_template(const SDP__typed__time__list& other_value)
{
copy_value(other_value);
}

SDP__typed__time__list_template::SDP__typed__time__list_template(const OPTIONAL<SDP__typed__time__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__typed__time__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_typed_time_list from an unbound optional field.");
}
}

SDP__typed__time__list_template::SDP__typed__time__list_template(SDP__typed__time__list_template* p_precondition, SDP__typed__time__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__typed__time__list_template::SDP__typed__time__list_template(Dynamic_Match_Interface<SDP__typed__time__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__typed__time__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__typed__time__list_template::SDP__typed__time__list_template(const SDP__typed__time__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__typed__time__list_template::~SDP__typed__time__list_template()
{
clean_up();
}

void SDP__typed__time__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__typed__time__list_template& SDP__typed__time__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__typed__time__list_template& SDP__typed__time__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__typed__time__list_template& SDP__typed__time__list_template::operator=(const SDP__typed__time__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__typed__time__list_template& SDP__typed__time__list_template::operator=(const OPTIONAL<SDP__typed__time__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__typed__time__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_typed_time_list.");
}
return *this;
}

SDP__typed__time__list_template& SDP__typed__time__list_template::operator=(const SDP__typed__time__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__typed__time_template& SDP__typed__time__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_typed_time_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_typed_time_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__typed__time_template& SDP__typed__time__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_typed_time_list.");
return (*this)[(int)index_value];
}

const SDP__typed__time_template& SDP__typed__time__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_typed_time_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_typed_time_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_typed_time_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__typed__time_template& SDP__typed__time__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_typed_time_list.");
return (*this)[(int)index_value];
}

void SDP__typed__time__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_typed_time_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__typed__time_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__typed__time_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__typed__time_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__typed__time_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__typed__time__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__typed__time__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_typed_time_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_typed_time_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_typed_time_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_typed_time_list");
}

boolean SDP__typed__time__list_template::match(const SDP__typed__time__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time_list.");
}
return FALSE;
}

boolean SDP__typed__time__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__typed__time__list SDP__typed__time__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_typed_time_list.");
SDP__typed__time__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__typed__time__list SDP__typed__time__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__typed__time__list SDP__typed__time__list_template::replace(int index, int len, const SDP__typed__time__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__typed__time__list SDP__typed__time__list_template::replace(int index, int len, const SDP__typed__time__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__typed__time__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__typed__time__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__typed__time_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_typed_time_list.");
}
set_selection(template_type);
}

SDP__typed__time__list_template& SDP__typed__time__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_typed_time_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_typed_time_list.");
return value_list.list_value[list_index];
}

SDP__typed__time_template& SDP__typed__time__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_typed_time_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_typed_time_list.");
return value_set.set_items[set_index];
}

void SDP__typed__time__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__typed__time__list_template::log_match(const SDP__typed__time__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__typed__time__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_typed_time_list.");
}
}

void SDP__typed__time__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_typed_time_list.");
single_value.value_elements = (SDP__typed__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__typed__time_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__typed__time__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__typed__time_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_typed_time_list.");
}
}

boolean SDP__typed__time__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__typed__time__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__typed__time__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__typed__time__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__typed__time__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__typed__time__list_template* precondition = new SDP__typed__time__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__typed__time__list_template* implied_template = new SDP__typed__time__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__typed__time__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_typed_time_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__typed__time__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_typed_time_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_typed_time_list");
}

boolean SDP__typed__time__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__repeat::SDP__repeat()
{
}

SDP__repeat::SDP__repeat(const SDP__typed__time& par_repeat__interval,
    const SDP__typed__time& par_active,
    const SDP__typed__time__list& par_offsets)
  :   field_repeat__interval(par_repeat__interval),
  field_active(par_active),
  field_offsets(par_offsets)
{
}

SDP__repeat::SDP__repeat(const SDP__repeat& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_repeat.");
if (other_value.repeat__interval().is_bound()) field_repeat__interval = other_value.repeat__interval();
else field_repeat__interval.clean_up();
if (other_value.active().is_bound()) field_active = other_value.active();
else field_active.clean_up();
if (other_value.offsets().is_bound()) field_offsets = other_value.offsets();
else field_offsets.clean_up();
}

void SDP__repeat::clean_up()
{
field_repeat__interval.clean_up();
field_active.clean_up();
field_offsets.clean_up();
}

const TTCN_Typedescriptor_t* SDP__repeat::get_descriptor() const { return &SDP__repeat_descr_; }
SDP__repeat& SDP__repeat::operator=(const SDP__repeat& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_repeat.");
  if (other_value.repeat__interval().is_bound()) field_repeat__interval = other_value.repeat__interval();
  else field_repeat__interval.clean_up();
  if (other_value.active().is_bound()) field_active = other_value.active();
  else field_active.clean_up();
  if (other_value.offsets().is_bound()) field_offsets = other_value.offsets();
  else field_offsets.clean_up();
}
return *this;
}

boolean SDP__repeat::operator==(const SDP__repeat& other_value) const
{
return field_repeat__interval==other_value.field_repeat__interval
  && field_active==other_value.field_active
  && field_offsets==other_value.field_offsets;
}

boolean SDP__repeat::is_bound() const
{
return (field_repeat__interval.is_bound())
  || (field_active.is_bound())
  || (field_offsets.is_bound());
}
boolean SDP__repeat::is_value() const
{
return field_repeat__interval.is_value()
  && field_active.is_value()
  && field_offsets.is_value();
}
void SDP__repeat::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ repeat_interval := ");
field_repeat__interval.log();
TTCN_Logger::log_event_str(", active := ");
field_active.log();
TTCN_Logger::log_event_str(", offsets := ");
field_offsets.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__repeat::set_implicit_omit()
{
if (repeat__interval().is_bound()) repeat__interval().set_implicit_omit();
if (active().is_bound()) active().set_implicit_omit();
if (offsets().is_bound()) offsets().set_implicit_omit();
}

void SDP__repeat::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_repeat has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) repeat__interval().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) active().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) offsets().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeat_interval")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeat__interval().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "active")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          active().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offsets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offsets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_repeat: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_repeat");
  }
}

void SDP__repeat::encode_text(Text_Buf& text_buf) const
{
field_repeat__interval.encode_text(text_buf);
field_active.encode_text(text_buf);
field_offsets.encode_text(text_buf);
}

void SDP__repeat::decode_text(Text_Buf& text_buf)
{
field_repeat__interval.decode_text(text_buf);
field_active.decode_text(text_buf);
field_offsets.decode_text(text_buf);
}

void SDP__repeat::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__repeat::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__repeat::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_repeat__interval.TEXT_encode(SDP__typed__time_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_active.TEXT_encode(SDP__typed__time_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_offsets.TEXT_encode(SDP__typed__time__list_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__repeat::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_repeat__interval.TEXT_decode(SDP__typed__time_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'repeat__interval' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_active.TEXT_decode(SDP__typed__time_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'active' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_offsets.TEXT_decode(SDP__typed__time__list_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'offsets' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__repeat_template::single_value_struct {
SDP__typed__time_template field_repeat__interval;
SDP__typed__time_template field_active;
SDP__typed__time__list_template field_offsets;
};

void SDP__repeat_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_repeat__interval = ANY_VALUE;
single_value->field_active = ANY_VALUE;
single_value->field_offsets = ANY_VALUE;
}
}
}

void SDP__repeat_template::copy_value(const SDP__repeat& other_value)
{
single_value = new single_value_struct;
if (other_value.repeat__interval().is_bound()) {
  single_value->field_repeat__interval = other_value.repeat__interval();
} else {
  single_value->field_repeat__interval.clean_up();
}
if (other_value.active().is_bound()) {
  single_value->field_active = other_value.active();
} else {
  single_value->field_active.clean_up();
}
if (other_value.offsets().is_bound()) {
  single_value->field_offsets = other_value.offsets();
} else {
  single_value->field_offsets.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__repeat_template::copy_template(const SDP__repeat_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.repeat__interval().get_selection()) {
single_value->field_repeat__interval = other_value.repeat__interval();
} else {
single_value->field_repeat__interval.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.active().get_selection()) {
single_value->field_active = other_value.active();
} else {
single_value->field_active.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.offsets().get_selection()) {
single_value->field_offsets = other_value.offsets();
} else {
single_value->field_offsets.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__repeat_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__repeat_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__repeat_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_repeat.");
break;
}
set_selection(other_value);
}

SDP__repeat_template::SDP__repeat_template()
{
}

SDP__repeat_template::SDP__repeat_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__repeat_template::SDP__repeat_template(const SDP__repeat& other_value)
{
copy_value(other_value);
}

SDP__repeat_template::SDP__repeat_template(const OPTIONAL<SDP__repeat>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__repeat&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_repeat from an unbound optional field.");
}
}

SDP__repeat_template::SDP__repeat_template(SDP__repeat_template* p_precondition, SDP__repeat_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__repeat_template::SDP__repeat_template(Dynamic_Match_Interface<SDP__repeat>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__repeat>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__repeat_template::SDP__repeat_template(const SDP__repeat_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__repeat_template::~SDP__repeat_template()
{
clean_up();
}

SDP__repeat_template& SDP__repeat_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__repeat_template& SDP__repeat_template::operator=(const SDP__repeat& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__repeat_template& SDP__repeat_template::operator=(const OPTIONAL<SDP__repeat>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__repeat&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_repeat.");
}
return *this;
}

SDP__repeat_template& SDP__repeat_template::operator=(const SDP__repeat_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__repeat_template::match(const SDP__repeat& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.repeat__interval().is_bound()) return FALSE;
if(!single_value->field_repeat__interval.match(other_value.repeat__interval(), legacy))return FALSE;
if(!other_value.active().is_bound()) return FALSE;
if(!single_value->field_active.match(other_value.active(), legacy))return FALSE;
if(!other_value.offsets().is_bound()) return FALSE;
if(!single_value->field_offsets.match(other_value.offsets(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_repeat.");
}
return FALSE;
}

boolean SDP__repeat_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_repeat__interval.is_bound()
 || single_value->field_active.is_bound()
 || single_value->field_offsets.is_bound();
}

boolean SDP__repeat_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_repeat__interval.is_value()
 && single_value->field_active.is_value()
 && single_value->field_offsets.is_value();
}

void SDP__repeat_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__repeat SDP__repeat_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_repeat.");
SDP__repeat ret_val;
if (single_value->field_repeat__interval.is_bound()) {
ret_val.repeat__interval() = single_value->field_repeat__interval.valueof();
}
if (single_value->field_active.is_bound()) {
ret_val.active() = single_value->field_active.valueof();
}
if (single_value->field_offsets.is_bound()) {
ret_val.offsets() = single_value->field_offsets.valueof();
}
return ret_val;
}

void SDP__repeat_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_repeat.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__repeat_template[list_length];
}

SDP__repeat_template& SDP__repeat_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_repeat.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_repeat.");
return value_list.list_value[list_index];
}

SDP__typed__time_template& SDP__repeat_template::repeat__interval()
{
set_specific();
return single_value->field_repeat__interval;
}

const SDP__typed__time_template& SDP__repeat_template::repeat__interval() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field repeat_interval of a non-specific template of type @SDP_Types.SDP_repeat.");
return single_value->field_repeat__interval;
}

SDP__typed__time_template& SDP__repeat_template::active()
{
set_specific();
return single_value->field_active;
}

const SDP__typed__time_template& SDP__repeat_template::active() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field active of a non-specific template of type @SDP_Types.SDP_repeat.");
return single_value->field_active;
}

SDP__typed__time__list_template& SDP__repeat_template::offsets()
{
set_specific();
return single_value->field_offsets;
}

const SDP__typed__time__list_template& SDP__repeat_template::offsets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field offsets of a non-specific template of type @SDP_Types.SDP_repeat.");
return single_value->field_offsets;
}

int SDP__repeat_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_repeat containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_repeat.");
  }
  return 0;
}

void SDP__repeat_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ repeat_interval := ");
single_value->field_repeat__interval.log();
TTCN_Logger::log_event_str(", active := ");
single_value->field_active.log();
TTCN_Logger::log_event_str(", offsets := ");
single_value->field_offsets.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__repeat_template::log_match(const SDP__repeat& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_repeat__interval.match(match_value.repeat__interval(), legacy)){
TTCN_Logger::log_logmatch_info(".repeat_interval");
single_value->field_repeat__interval.log_match(match_value.repeat__interval(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_active.match(match_value.active(), legacy)){
TTCN_Logger::log_logmatch_info(".active");
single_value->field_active.log_match(match_value.active(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_offsets.match(match_value.offsets(), legacy)){
TTCN_Logger::log_logmatch_info(".offsets");
single_value->field_offsets.log_match(match_value.offsets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ repeat_interval := ");
single_value->field_repeat__interval.log_match(match_value.repeat__interval(), legacy);
TTCN_Logger::log_event_str(", active := ");
single_value->field_active.log_match(match_value.active(), legacy);
TTCN_Logger::log_event_str(", offsets := ");
single_value->field_offsets.log_match(match_value.offsets(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__repeat_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (repeat__interval().is_bound()) repeat__interval().set_implicit_omit();
if (active().is_bound()) active().set_implicit_omit();
if (offsets().is_bound()) offsets().set_implicit_omit();
}

void SDP__repeat_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_repeat__interval.encode_text(text_buf);
single_value->field_active.encode_text(text_buf);
single_value->field_offsets.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_repeat.");
}
}

void SDP__repeat_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_repeat__interval.decode_text(text_buf);
single_value->field_active.decode_text(text_buf);
single_value->field_offsets.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__repeat_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_repeat.");
}
}

void SDP__repeat_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__repeat_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_repeat has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) repeat__interval().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) active().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) offsets().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeat_interval")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeat__interval().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "active")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          active().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offsets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offsets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_repeat: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__repeat_template* precondition = new SDP__repeat_template;
    precondition->set_param(*param.get_elem(0));
    SDP__repeat_template* implied_template = new SDP__repeat_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__repeat_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_repeat");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__repeat_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_repeat__interval.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_repeat");
single_value->field_active.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_repeat");
single_value->field_offsets.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_repeat");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_repeat");
}

boolean SDP__repeat_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__repeat_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const SDP__time SDP__time__list::UNBOUND_ELEM;
boolean SDP__time__list::compare_function(const Base_Type *left_ptr, int left_index, const Base_Type *right_ptr, int right_index)
{
if (((const SDP__time__list*)left_ptr)->val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_time_list.");
if (((const SDP__time__list*)right_ptr)->val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_time_list.");
if (((const SDP__time__list*)left_ptr)->val_ptr->value_elements[left_index] != NULL){
if (((const SDP__time__list*)right_ptr)->val_ptr->value_elements[right_index] != NULL){
return *((const SDP__time__list*)left_ptr)->val_ptr->value_elements[left_index] == *((const SDP__time__list*)right_ptr)->val_ptr->value_elements[right_index];
} else return FALSE;
} else {
return ((const SDP__time__list*)right_ptr)->val_ptr->value_elements[right_index] == NULL;
}
}

SDP__time__list::SDP__time__list()
{
val_ptr = NULL;
}

SDP__time__list::SDP__time__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

SDP__time__list::SDP__time__list(const SDP__time__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_time_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

SDP__time__list::~SDP__time__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void SDP__time__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

SDP__time__list& SDP__time__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

SDP__time__list& SDP__time__list::operator=(const SDP__time__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @SDP_Types.SDP_time_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean SDP__time__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_time_list.");
return val_ptr->n_elements == 0 ;
}

boolean SDP__time__list::operator==(const SDP__time__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @SDP_Types.SDP_time_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @SDP_Types.SDP_time_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
return compare_set_of(this, val_ptr->n_elements, &other_value, (other_value.val_ptr)->n_elements, compare_function);
}

SDP__time& SDP__time__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_time_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__time**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__time(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new SDP__time;
}
return *val_ptr->value_elements[index_value];
}

SDP__time& SDP__time__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_time_list.");
return (*this)[(int)index_value];
}

const SDP__time& SDP__time__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @SDP_Types.SDP_time_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @SDP_Types.SDP_time_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @SDP_Types.SDP_time_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const SDP__time& SDP__time__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @SDP_Types.SDP_time_list.");
return (*this)[(int)index_value];
}

SDP__time__list SDP__time__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

SDP__time__list SDP__time__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

SDP__time__list SDP__time__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

SDP__time__list SDP__time__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @SDP_Types.SDP_time_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
SDP__time__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new SDP__time(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__time__list SDP__time__list::operator+(const SDP__time__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @SDP_Types.SDP_time_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
SDP__time__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__time(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new SDP__time(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

SDP__time__list SDP__time__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @SDP_Types.SDP_time_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@SDP_Types.SDP_time_list","element");
SDP__time__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__time(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

SDP__time__list SDP__time__list::replace(int index, int len, const SDP__time__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @SDP_Types.SDP_time_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @SDP_Types.SDP_time_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@SDP_Types.SDP_time_list","element");
SDP__time__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new SDP__time(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new SDP__time(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new SDP__time(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

SDP__time__list SDP__time__list::replace(int index, int len, const SDP__time__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void SDP__time__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @SDP_Types.SDP_time_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (SDP__time**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new SDP__time(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (SDP__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @SDP_Types.SDP_time_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (SDP__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean SDP__time__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int SDP__time__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @SDP_Types.SDP_time_list.");
return val_ptr->n_elements;
}

int SDP__time__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @SDP_Types.SDP_time_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void SDP__time__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void SDP__time__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void SDP__time__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "set of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_time_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("set of value", "@SDP_Types.SDP_time_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void SDP__time__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @SDP_Types.SDP_time_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void SDP__time__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @SDP_Types.SDP_time_list.");
val_ptr->value_elements = (SDP__time**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new SDP__time;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void SDP__time__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__time__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__time__list::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
  if(val_ptr==NULL) {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
    if(p_td.text->end_encode){
      p_buf.put_cs(*p_td.text->end_encode);
      encoded_length+=p_td.text->end_encode->lengthof();
    }
    return encoded_length;
  }
  for(int a=0;a<val_ptr->n_elements;a++){
   if(a!=0 && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
   }
   encoded_length+=(*this)[a].TEXT_encode(*p_td.oftype_descr,p_buf);
  }
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__time__list::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean first_call){
  int decoded_length=0;
  size_t pos=p_buf.get_pos();
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int more=val_ptr->n_elements;
  while(TRUE){
    SDP__time *val=new SDP__time;
    pos=p_buf.get_pos();
    int len=val->TEXT_decode(*p_td.oftype_descr,p_buf,limit,TRUE);
    if(len==-1 || (len==0 && !limit.has_token())){
      p_buf.set_pos(pos);
      delete val;
      if(sep_found){
        p_buf.set_pos(p_buf.get_pos()-sep_length);
        decoded_length-=sep_length;
      }
      break;
    }
    sep_found=FALSE;
    val_ptr->value_elements = (SDP__time**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->value_elements[val_ptr->n_elements]=val;
    val_ptr->n_elements++;
    decoded_length+=len;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
        break;
      }
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;
    } else if(p_td.text->end_decode){
      int tl;
      if((tl=p_td.text->end_decode->match_begin(p_buf))!=-1){
        decoded_length+=tl;
        p_buf.increase_pos(tl);
        limit.remove_tokens(ml);
        return decoded_length;
      }
    } else if(limit.has_token(ml)){
      if(limit.match(p_buf,ml)==0){
        sep_found=FALSE;
        break;
      }
    }
  }
   limit.remove_tokens(ml);
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
          if(no_err){
            if(!first_call){
              for(int a=more; a<val_ptr->n_elements; a++) delete val_ptr->value_elements[a];
              val_ptr->n_elements=more;
            }
            return -1;
          }
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
          return decoded_length;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(val_ptr->n_elements==0){
    if(!(p_td.text->end_decode || p_td.text->begin_decode)) {
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "No record/set of member found.");
      return decoded_length;
    }
  }
  if(!first_call && more==val_ptr->n_elements && !(p_td.text->end_decode || p_td.text->begin_decode)) return -1;
  return decoded_length;
}
void SDP__time__list_template::copy_value(const SDP__time__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @SDP_Types.SDP_time_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (SDP__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new SDP__time_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__time_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void SDP__time__list_template::copy_template(const SDP__time__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (SDP__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new SDP__time_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new SDP__time_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__time__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = other_value.value_set.n_items;
value_set.set_items = new SDP__time_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count] = other_value.value_set.set_items[set_count];
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__time__list_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__time__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_time_list.");
break;
}
set_selection(other_value);
}

boolean SDP__time__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__time__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const SDP__time__list*)value_ptr)[value_index], legacy);
else return ((const SDP__time__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

boolean SDP__time__list_template::match_function_set(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const SDP__time__list_template*)template_ptr)->value_set.set_items[template_index].match((*(const SDP__time__list*)value_ptr)[value_index], legacy);
else return ((const SDP__time__list_template*)template_ptr)->value_set.set_items[template_index].is_any_or_omit();
}

void SDP__time__list_template::log_function(const Base_Type *value_ptr, const Restricted_Length_Template *template_ptr, int index_value, int index_template, boolean legacy)
{
if (value_ptr == NULL) {
if (template_ptr != NULL) {
((const SDP__time__list_template*)template_ptr)->single_value.value_elements[index_template]->log();
}
} else if (template_ptr == NULL) {
(*(const SDP__time__list*)value_ptr)[index_value].log();
} else {
((const SDP__time__list_template*)template_ptr)->single_value.value_elements[index_template]->log_match((*(const SDP__time__list*)value_ptr)[index_value], legacy);
}
}

SDP__time__list_template::SDP__time__list_template()
{
}

SDP__time__list_template::SDP__time__list_template(template_sel other_value)
 : Restricted_Length_Template(other_value)
{
check_single_selection(other_value);
}

SDP__time__list_template::SDP__time__list_template(null_type)
 : Restricted_Length_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

SDP__time__list_template::SDP__time__list_template(const SDP__time__list& other_value)
{
copy_value(other_value);
}

SDP__time__list_template::SDP__time__list_template(const OPTIONAL<SDP__time__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_time_list from an unbound optional field.");
}
}

SDP__time__list_template::SDP__time__list_template(SDP__time__list_template* p_precondition, SDP__time__list_template* p_implied_template)
 : Restricted_Length_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__time__list_template::SDP__time__list_template(Dynamic_Match_Interface<SDP__time__list>* p_dyn_match)
 : Restricted_Length_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__time__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__time__list_template::SDP__time__list_template(const SDP__time__list_template& other_value)
 : Restricted_Length_Template()
{
copy_template(other_value);
}

SDP__time__list_template::~SDP__time__list_template()
{
clean_up();
}

void SDP__time__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
delete [] value_set.set_items;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__time__list_template& SDP__time__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__time__list_template& SDP__time__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

SDP__time__list_template& SDP__time__list_template::operator=(const SDP__time__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__time__list_template& SDP__time__list_template::operator=(const OPTIONAL<SDP__time__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__time__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_time_list.");
}
return *this;
}

SDP__time__list_template& SDP__time__list_template::operator=(const SDP__time__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

SDP__time_template& SDP__time__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_time_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_time_list.");
    break;
}
return *single_value.value_elements[index_value];
}

SDP__time_template& SDP__time__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_time_list.");
return (*this)[(int)index_value];
}

const SDP__time_template& SDP__time__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @SDP_Types.SDP_time_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @SDP_Types.SDP_time_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @SDP_Types.SDP_time_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const SDP__time_template& SDP__time__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @SDP_Types.SDP_time_list.");
return (*this)[(int)index_value];
}

void SDP__time__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @SDP_Types.SDP_time_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (SDP__time_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__time_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new SDP__time_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (SDP__time_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int SDP__time__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int SDP__time__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case SUPERSET_MATCH:
case SUBSET_MATCH: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = value_set.n_items;
  if (!is_size) { while (elem_count>0 && !value_set.set_items[elem_count-1].is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (value_set.set_items[i].get_selection())
    {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
  if (template_selection==SUPERSET_MATCH) {
    has_any_or_none = TRUE;
   } else {
    int max_size = min_size;
    min_size = 0;
    if (!has_any_or_none) { // [0,max_size]
      switch (length_restriction_type) {
      case NO_LENGTH_RESTRICTION:
        if (max_size==0) return 0;
        TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list with no exact size.", op_name);
      case SINGLE_LENGTH_RESTRICTION:
        if (length_restriction.single_length<=max_size)
          return length_restriction.single_length;
        TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_time_list. The maximum size (%d) contradicts the length restriction (%d).", op_name, max_size, length_restriction.single_length);
      case RANGE_LENGTH_RESTRICTION:
        if (max_size==length_restriction.range_length.min_length) {
          return max_size;
        } else if (max_size>length_restriction.range_length.min_length){
          TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list with no exact size.", op_name);
        } else
          TTCN_error("Performing %sof() operation on an invalid template of type @SDP_Types.SDP_time_list. Maximum size (%d) contradicts the length restriction (%d..%d).", op_name, max_size, length_restriction.range_length.min_length, length_restriction.range_length.max_length);
      default:
        TTCN_error("Internal error: Template has invalid length restriction type.");
      }
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @SDP_Types.SDP_time_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_time_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @SDP_Types.SDP_time_list");
}

boolean SDP__time__list_template::match(const SDP__time__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_set_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case SUPERSET_MATCH:
case SUBSET_MATCH:
return match_set_of(&other_value, value_length, this, value_set.n_items, match_function_set, legacy);
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @SDP_Types.SDP_time_list.");
}
return FALSE;
}

boolean SDP__time__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

SDP__time__list SDP__time__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_time_list.");
SDP__time__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

SDP__time__list SDP__time__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

SDP__time__list SDP__time__list_template::replace(int index, int len, const SDP__time__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

SDP__time__list SDP__time__list_template::replace(int index, int len, const SDP__time__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void SDP__time__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new SDP__time__list_template[list_length];
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = list_length;
value_set.set_items = new SDP__time_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @SDP_Types.SDP_time_list.");
}
set_selection(template_type);
}

SDP__time__list_template& SDP__time__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @SDP_Types.SDP_time_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @SDP_Types.SDP_time_list.");
return value_list.list_value[list_index];
}

SDP__time_template& SDP__time__list_template::set_item(unsigned int set_index)
{
if (template_selection != SUPERSET_MATCH && template_selection != SUBSET_MATCH) TTCN_error("Internal error: Accessing a set element of a non-set template of type @SDP_Types.SDP_time_list.");
if (set_index >= value_set.n_items) TTCN_error("Internal error: Index overflow in a set template of type @SDP_Types.SDP_time_list.");
return value_set.set_items[set_index];
}

void SDP__time__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log();
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
TTCN_Logger::log_event("%s(", template_selection == SUPERSET_MATCH ? "superset" : "subset");
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++) {
if (set_count > 0) TTCN_Logger::log_event_str(", ");
value_set.set_items[set_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void SDP__time__list_template::log_match(const SDP__time__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (template_selection == SPECIFIC_VALUE)
  log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
else{
if(previous_size != 0){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::set_logmatch_buffer_len(previous_size);
TTCN_Logger::log_event_str(":=");
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else {
TTCN_Logger::log_event_str(" unmatched");
if (template_selection == SPECIFIC_VALUE) log_match_heuristics(&match_value, match_value.size_of(), this, single_value.n_elements, match_function_specific, log_function, legacy);
}
}

void SDP__time__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
text_buf.push_int(value_set.n_items);
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_time_list.");
}
}

void SDP__time__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_restricted(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @SDP_Types.SDP_time_list.");
single_value.value_elements = (SDP__time_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new SDP__time_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__time__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
case SUPERSET_MATCH:
case SUBSET_MATCH:
value_set.n_items = text_buf.pull_int().get_val();
value_set.set_items = new SDP__time_template[value_set.n_items];
for (unsigned int set_count = 0; set_count < value_set.n_items; set_count++)
value_set.set_items[set_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @SDP_Types.SDP_time_list.");
}
}

boolean SDP__time__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__time__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SDP__time__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void SDP__time__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "set of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__time__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List:
    set_size(param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      if (param.get_elem(p_i)->get_type()!=Module_Param::MP_NotUsed) {
        (*this)[p_i].set_param(*param.get_elem(p_i));
      }
    }
    break;
  case Module_Param::MP_Superset_Template:
  case Module_Param::MP_Subset_Template:
    set_type(param.get_type()==Module_Param::MP_Superset_Template ? SUPERSET_MATCH : SUBSET_MATCH, param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      set_item(p_i).set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Implication_Template: {
    SDP__time__list_template* precondition = new SDP__time__list_template;
    precondition->set_param(*param.get_elem(0));
    SDP__time__list_template* implied_template = new SDP__time__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__time__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set of template", "@SDP_Types.SDP_time_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void SDP__time__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_time_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_time_list");
}

boolean SDP__time__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return FALSE;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
SDP__timezone::SDP__timezone()
{
}

SDP__timezone::SDP__timezone(const CHARSTRING& par_adjustment__time,
    const SDP__typed__time& par_offset)
  :   field_adjustment__time(par_adjustment__time),
  field_offset(par_offset)
{
}

SDP__timezone::SDP__timezone(const SDP__timezone& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SDP_Types.SDP_timezone.");
if (other_value.adjustment__time().is_bound()) field_adjustment__time = other_value.adjustment__time();
else field_adjustment__time.clean_up();
if (other_value.offset().is_bound()) field_offset = other_value.offset();
else field_offset.clean_up();
}

void SDP__timezone::clean_up()
{
field_adjustment__time.clean_up();
field_offset.clean_up();
}

const TTCN_Typedescriptor_t* SDP__timezone::get_descriptor() const { return &SDP__timezone_descr_; }
SDP__timezone& SDP__timezone::operator=(const SDP__timezone& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SDP_Types.SDP_timezone.");
  if (other_value.adjustment__time().is_bound()) field_adjustment__time = other_value.adjustment__time();
  else field_adjustment__time.clean_up();
  if (other_value.offset().is_bound()) field_offset = other_value.offset();
  else field_offset.clean_up();
}
return *this;
}

boolean SDP__timezone::operator==(const SDP__timezone& other_value) const
{
return field_adjustment__time==other_value.field_adjustment__time
  && field_offset==other_value.field_offset;
}

boolean SDP__timezone::is_bound() const
{
return (field_adjustment__time.is_bound())
  || (field_offset.is_bound());
}
boolean SDP__timezone::is_value() const
{
return field_adjustment__time.is_value()
  && field_offset.is_value();
}
void SDP__timezone::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ adjustment_time := ");
field_adjustment__time.log();
TTCN_Logger::log_event_str(", offset := ");
field_offset.log();
TTCN_Logger::log_event_str(" }");
}

void SDP__timezone::set_implicit_omit()
{
if (adjustment__time().is_bound()) adjustment__time().set_implicit_omit();
if (offset().is_bound()) offset().set_implicit_omit();
}

void SDP__timezone::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SDP_Types.SDP_timezone has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) adjustment__time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) offset().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "adjustment_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          adjustment__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offset")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offset().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_timezone: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SDP_Types.SDP_timezone");
  }
}

void SDP__timezone::encode_text(Text_Buf& text_buf) const
{
field_adjustment__time.encode_text(text_buf);
field_offset.encode_text(text_buf);
}

void SDP__timezone::decode_text(Text_Buf& text_buf)
{
field_adjustment__time.decode_text(text_buf);
field_offset.decode_text(text_buf);
}

void SDP__timezone::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SDP__timezone::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SDP__timezone::TEXT_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  boolean need_separator=FALSE;
  int encoded_length=0;
  if(p_td.text->begin_encode){
    p_buf.put_cs(*p_td.text->begin_encode);
    encoded_length+=p_td.text->begin_encode->lengthof();
  }
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_adjustment__time.TEXT_encode(CHARSTRING_descr_,p_buf);
 need_separator=TRUE;
 if(need_separator && p_td.text->separator_encode){
    p_buf.put_cs(*p_td.text->separator_encode);
    encoded_length+=p_td.text->separator_encode->lengthof();
 }
 encoded_length+=field_offset.TEXT_encode(SDP__typed__time_descr_,p_buf);
 need_separator=TRUE;
  if(p_td.text->end_encode){
    p_buf.put_cs(*p_td.text->end_encode);
    encoded_length+=p_td.text->end_encode->lengthof();
  }
  return encoded_length;
}
int SDP__timezone::TEXT_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, Limit_Token_List& limit, boolean no_err, boolean){
  int decoded_length=0;
  int decoded_field_length=0;
  boolean sep_found=FALSE;
  int sep_length=0;
  int ml=0;
  if(p_td.text->begin_decode){
    int tl;
    if((tl=p_td.text->begin_decode->match_begin(p_buf))<0){
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error
              (TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->begin_decode), p_td.name);
          return 0;
        }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  if(p_td.text->end_decode){
    limit.add_token(p_td.text->end_decode);
    ml++;
  }
  if(p_td.text->separator_decode){
    limit.add_token(p_td.text->separator_decode);
    ml++;
  }
    while(TRUE){
    decoded_field_length=field_adjustment__time.TEXT_decode(CHARSTRING_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'adjustment__time' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    if(p_td.text->separator_decode){
      int tl;
      if((tl=p_td.text->separator_decode->match_begin(p_buf))<0){
          limit.remove_tokens(ml);
          if(no_err)return -1;
          TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->separator_decode),p_td.name);
          return decoded_length;
      } else {
      decoded_length+=tl;
      p_buf.increase_pos(tl);
      sep_length=tl;
      sep_found=TRUE;}
    } else sep_found=FALSE;
  }
    decoded_field_length=field_offset.TEXT_decode(SDP__typed__time_descr_,p_buf,limit,TRUE);
    if(decoded_field_length<0){
     limit.remove_tokens(ml);
     if(no_err)return -1;
     TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "Error during decoding field 'offset' for '%s': ", p_td.name);
     return decoded_length;
   } else {
  decoded_length+=decoded_field_length;
    sep_found=FALSE;
  }
   break;
  }
  limit.remove_tokens(ml);
  if(sep_found){
      p_buf.set_pos(p_buf.get_pos()-sep_length);
      decoded_length-=sep_length;
  }
  if(p_td.text->end_decode){
    int tl;
    if((tl=p_td.text->end_decode->match_begin(p_buf))<0){
      if(no_err)return -1;
      TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_TOKEN_ERR, "The specified token '%s' not found for '%s': ",(const char*)*(p_td.text->end_decode),p_td.name);
      return decoded_length;
    }
    decoded_length+=tl;
    p_buf.increase_pos(tl);
  }
  return decoded_length;
}
struct SDP__timezone_template::single_value_struct {
CHARSTRING_template field_adjustment__time;
SDP__typed__time_template field_offset;
};

void SDP__timezone_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_adjustment__time = ANY_VALUE;
single_value->field_offset = ANY_VALUE;
}
}
}

void SDP__timezone_template::copy_value(const SDP__timezone& other_value)
{
single_value = new single_value_struct;
if (other_value.adjustment__time().is_bound()) {
  single_value->field_adjustment__time = other_value.adjustment__time();
} else {
  single_value->field_adjustment__time.clean_up();
}
if (other_value.offset().is_bound()) {
  single_value->field_offset = other_value.offset();
} else {
  single_value->field_offset.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SDP__timezone_template::copy_template(const SDP__timezone_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.adjustment__time().get_selection()) {
single_value->field_adjustment__time = other_value.adjustment__time();
} else {
single_value->field_adjustment__time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.offset().get_selection()) {
single_value->field_offset = other_value.offset();
} else {
single_value->field_offset.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SDP__timezone_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SDP__timezone_template(*other_value.implication_.precondition);
implication_.implied_template = new SDP__timezone_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SDP_Types.SDP_timezone.");
break;
}
set_selection(other_value);
}

SDP__timezone_template::SDP__timezone_template()
{
}

SDP__timezone_template::SDP__timezone_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SDP__timezone_template::SDP__timezone_template(const SDP__timezone& other_value)
{
copy_value(other_value);
}

SDP__timezone_template::SDP__timezone_template(const OPTIONAL<SDP__timezone>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__timezone&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SDP_Types.SDP_timezone from an unbound optional field.");
}
}

SDP__timezone_template::SDP__timezone_template(SDP__timezone_template* p_precondition, SDP__timezone_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SDP__timezone_template::SDP__timezone_template(Dynamic_Match_Interface<SDP__timezone>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SDP__timezone>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SDP__timezone_template::SDP__timezone_template(const SDP__timezone_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SDP__timezone_template::~SDP__timezone_template()
{
clean_up();
}

SDP__timezone_template& SDP__timezone_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SDP__timezone_template& SDP__timezone_template::operator=(const SDP__timezone& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SDP__timezone_template& SDP__timezone_template::operator=(const OPTIONAL<SDP__timezone>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SDP__timezone&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SDP_Types.SDP_timezone.");
}
return *this;
}

SDP__timezone_template& SDP__timezone_template::operator=(const SDP__timezone_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SDP__timezone_template::match(const SDP__timezone& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.adjustment__time().is_bound()) return FALSE;
if(!single_value->field_adjustment__time.match(other_value.adjustment__time(), legacy))return FALSE;
if(!other_value.offset().is_bound()) return FALSE;
if(!single_value->field_offset.match(other_value.offset(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SDP_Types.SDP_timezone.");
}
return FALSE;
}

boolean SDP__timezone_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_adjustment__time.is_bound()
 || single_value->field_offset.is_bound();
}

boolean SDP__timezone_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_adjustment__time.is_value()
 && single_value->field_offset.is_value();
}

void SDP__timezone_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SDP__timezone SDP__timezone_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SDP_Types.SDP_timezone.");
SDP__timezone ret_val;
if (single_value->field_adjustment__time.is_bound()) {
ret_val.adjustment__time() = single_value->field_adjustment__time.valueof();
}
if (single_value->field_offset.is_bound()) {
ret_val.offset() = single_value->field_offset.valueof();
}
return ret_val;
}

void SDP__timezone_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SDP_Types.SDP_timezone.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SDP__timezone_template[list_length];
}

SDP__timezone_template& SDP__timezone_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SDP_Types.SDP_timezone.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SDP_Types.SDP_timezone.");
return value_list.list_value[list_index];
}

CHARSTRING_template& SDP__timezone_template::adjustment__time()
{
set_specific();
return single_value->field_adjustment__time;
}

const CHARSTRING_template& SDP__timezone_template::adjustment__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field adjustment_time of a non-specific template of type @SDP_Types.SDP_timezone.");
return single_value->field_adjustment__time;
}

SDP__typed__time_template& SDP__timezone_template::offset()
{
set_specific();
return single_value->field_offset;
}

const SDP__typed__time_template& SDP__timezone_template::offset() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field offset of a non-specific template of type @SDP_Types.SDP_timezone.");
return single_value->field_offset;
}

int SDP__timezone_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SDP_Types.SDP_timezone containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SDP_Types.SDP_timezone.");
  }
  return 0;
}

void SDP__timezone_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ adjustment_time := ");
single_value->field_adjustment__time.log();
TTCN_Logger::log_event_str(", offset := ");
single_value->field_offset.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SDP__timezone_template::log_match(const SDP__timezone& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_adjustment__time.match(match_value.adjustment__time(), legacy)){
TTCN_Logger::log_logmatch_info(".adjustment_time");
single_value->field_adjustment__time.log_match(match_value.adjustment__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_offset.match(match_value.offset(), legacy)){
TTCN_Logger::log_logmatch_info(".offset");
single_value->field_offset.log_match(match_value.offset(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ adjustment_time := ");
single_value->field_adjustment__time.log_match(match_value.adjustment__time(), legacy);
TTCN_Logger::log_event_str(", offset := ");
single_value->field_offset.log_match(match_value.offset(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SDP__timezone_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (adjustment__time().is_bound()) adjustment__time().set_implicit_omit();
if (offset().is_bound()) offset().set_implicit_omit();
}

void SDP__timezone_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_adjustment__time.encode_text(text_buf);
single_value->field_offset.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SDP_Types.SDP_timezone.");
}
}

void SDP__timezone_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_adjustment__time.decode_text(text_buf);
single_value->field_offset.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SDP__timezone_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SDP_Types.SDP_timezone.");
}
}

void SDP__timezone_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SDP__timezone_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SDP_Types.SDP_timezone has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) adjustment__time().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) offset().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "adjustment_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          adjustment__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offset")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offset().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SDP_Types.SDP_timezone: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SDP__timezone_template* precondition = new SDP__timezone_template;
    precondition->set_param(*param.get_elem(0));
    SDP__timezone_template* implied_template = new SDP__timezone_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SDP__timezone_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SDP_Types.SDP_timezone");
  }
  is_ifpresent = param.get_ifpresent();
}

void SDP__timezone_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_adjustment__time.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_timezone");
single_value->field_offset.check_restriction(t_res, t_name ? t_name : "@SDP_Types.SDP_timezone");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SDP_Types.SDP_timezone");
}

boolean SDP__timezone_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SDP__timezone_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
