/* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR BSD-3-Clause) */
/* Do not edit directly, auto-generated from: */
/*	Documentation/netlink/specs/dev-energymodel.yaml */
/* YNL-GEN uapi header */
/* To regenerate run: tools/net/ynl/ynl-regen.sh */

#ifndef _UAPI_LINUX_DEV_ENERGYMODEL_H
#define _UAPI_LINUX_DEV_ENERGYMODEL_H

#define DEV_ENERGYMODEL_FAMILY_NAME	"dev-energymodel"
#define DEV_ENERGYMODEL_FAMILY_VERSION	1

/**
 * enum dev_energymodel_perf_state_flags
 * @DEV_ENERGYMODEL_PERF_STATE_FLAGS_PERF_STATE_INEFFICIENT: The performance
 *   state is inefficient. There is in this perf-domain, another performance
 *   state with a higher frequency but a lower or equal power cost.
 */
enum dev_energymodel_perf_state_flags {
	DEV_ENERGYMODEL_PERF_STATE_FLAGS_PERF_STATE_INEFFICIENT = 1,
};

/**
 * enum dev_energymodel_perf_domain_flags
 * @DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_MICROWATTS: The power values
 *   are in micro-Watts or some other scale.
 * @DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_SKIP_INEFFICIENCIES: Skip
 *   inefficient states when estimating energy consumption.
 * @DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_ARTIFICIAL: The power values
 *   are artificial and might be created by platform missing real power
 *   information.
 */
enum dev_energymodel_perf_domain_flags {
	DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_MICROWATTS = 1,
	DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_SKIP_INEFFICIENCIES = 2,
	DEV_ENERGYMODEL_PERF_DOMAIN_FLAGS_PERF_DOMAIN_ARTIFICIAL = 4,
};

enum {
	DEV_ENERGYMODEL_A_PERF_DOMAIN_PAD = 1,
	DEV_ENERGYMODEL_A_PERF_DOMAIN_PERF_DOMAIN_ID,
	DEV_ENERGYMODEL_A_PERF_DOMAIN_FLAGS,
	DEV_ENERGYMODEL_A_PERF_DOMAIN_CPUS,

	__DEV_ENERGYMODEL_A_PERF_DOMAIN_MAX,
	DEV_ENERGYMODEL_A_PERF_DOMAIN_MAX = (__DEV_ENERGYMODEL_A_PERF_DOMAIN_MAX - 1)
};

enum {
	DEV_ENERGYMODEL_A_PERF_TABLE_PERF_DOMAIN_ID = 1,
	DEV_ENERGYMODEL_A_PERF_TABLE_PERF_STATE,

	__DEV_ENERGYMODEL_A_PERF_TABLE_MAX,
	DEV_ENERGYMODEL_A_PERF_TABLE_MAX = (__DEV_ENERGYMODEL_A_PERF_TABLE_MAX - 1)
};

enum {
	DEV_ENERGYMODEL_A_PERF_STATE_PAD = 1,
	DEV_ENERGYMODEL_A_PERF_STATE_PERFORMANCE,
	DEV_ENERGYMODEL_A_PERF_STATE_FREQUENCY,
	DEV_ENERGYMODEL_A_PERF_STATE_POWER,
	DEV_ENERGYMODEL_A_PERF_STATE_COST,
	DEV_ENERGYMODEL_A_PERF_STATE_FLAGS,

	__DEV_ENERGYMODEL_A_PERF_STATE_MAX,
	DEV_ENERGYMODEL_A_PERF_STATE_MAX = (__DEV_ENERGYMODEL_A_PERF_STATE_MAX - 1)
};

enum {
	DEV_ENERGYMODEL_CMD_GET_PERF_DOMAINS = 1,
	DEV_ENERGYMODEL_CMD_GET_PERF_TABLE,
	DEV_ENERGYMODEL_CMD_PERF_DOMAIN_CREATED,
	DEV_ENERGYMODEL_CMD_PERF_DOMAIN_UPDATED,
	DEV_ENERGYMODEL_CMD_PERF_DOMAIN_DELETED,

	__DEV_ENERGYMODEL_CMD_MAX,
	DEV_ENERGYMODEL_CMD_MAX = (__DEV_ENERGYMODEL_CMD_MAX - 1)
};

#define DEV_ENERGYMODEL_MCGRP_EVENT	"event"

#endif /* _UAPI_LINUX_DEV_ENERGYMODEL_H */
