
/*
 * Copyright (C) 2011-2016 Sylvain Munaut <tnt@246tNt.com>
 * Copyright (C) 2016 sysmocom s.f.m.c. GmbH
 *
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <osmocom/gsm/gsm0503.h>
#include <osmocom/core/conv.h>
#include "conv.h"

const int gsm0503_vectors_len = 45;

const struct conv_test_vector gsm0503_vectors[45] = {
	{
		.name = "gsm0503_xcch",
		.code = &gsm0503_xcch,
		.in_len  = 224,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_f24",
		.code = &gsm0503_tch_f24,
		.in_len  = 72,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_h24",
		.code = &gsm0503_tch_h24,
		.in_len  = 72,
		.out_len = 228,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_f48",
		.code = &gsm0503_tch_f48,
		.in_len  = 148,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_f96",
		.code = &gsm0503_tch_f96,
		.in_len  = 240,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_f144",
		.code = &gsm0503_tch_f144,
		.in_len  = 290,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_rach",
		.code = &gsm0503_rach,
		.in_len  = 14,
		.out_len = 36,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_rach_ext",
		.code = &gsm0503_rach_ext,
		.in_len  = 17,
		.out_len = 36,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_sch",
		.code = &gsm0503_sch,
		.in_len  = 35,
		.out_len = 78,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_cs2",
		.code = &gsm0503_cs2,
		.in_len  = 290,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_cs3",
		.code = &gsm0503_cs3,
		.in_len  = 334,
		.out_len = 456,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_cs2_np",
		.code = &gsm0503_cs2_np,
		.in_len  = 290,
		.out_len = 588,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_cs3_np",
		.code = &gsm0503_cs3_np,
		.in_len  = 334,
		.out_len = 676,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_12_2",
		.code = &gsm0503_tch_afs_12_2,
		.in_len  = 250,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_10_2",
		.code = &gsm0503_tch_afs_10_2,
		.in_len  = 210,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_7_95",
		.code = &gsm0503_tch_afs_7_95,
		.in_len  = 165,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_7_4",
		.code = &gsm0503_tch_afs_7_4,
		.in_len  = 154,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_6_7",
		.code = &gsm0503_tch_afs_6_7,
		.in_len  = 140,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_5_9",
		.code = &gsm0503_tch_afs_5_9,
		.in_len  = 124,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_5_15",
		.code = &gsm0503_tch_afs_5_15,
		.in_len  = 109,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_afs_4_75",
		.code = &gsm0503_tch_afs_4_75,
		.in_len  = 101,
		.out_len = 448,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_fr",
		.code = &gsm0503_tch_fr,
		.in_len  = 185,
		.out_len = 378,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_hr",
		.code = &gsm0503_tch_hr,
		.in_len  = 98,
		.out_len = 211,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_7_95",
		.code = &gsm0503_tch_ahs_7_95,
		.in_len  = 129,
		.out_len = 188,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_7_4",
		.code = &gsm0503_tch_ahs_7_4,
		.in_len  = 126,
		.out_len = 196,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_6_7",
		.code = &gsm0503_tch_ahs_6_7,
		.in_len  = 116,
		.out_len = 200,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_5_9",
		.code = &gsm0503_tch_ahs_5_9,
		.in_len  = 108,
		.out_len = 208,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_5_15",
		.code = &gsm0503_tch_ahs_5_15,
		.in_len  = 97,
		.out_len = 212,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_ahs_4_75",
		.code = &gsm0503_tch_ahs_4_75,
		.in_len  = 89,
		.out_len = 212,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_tch_axs_sid_update",
		.code = &gsm0503_tch_axs_sid_update,
		.in_len  = 49,
		.out_len = 212,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs1_dl_hdr",
		.code = &gsm0503_mcs1_dl_hdr,
		.in_len  = 36,
		.out_len = 108,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs1_ul_hdr",
		.code = &gsm0503_mcs1_ul_hdr,
		.in_len  = 39,
		.out_len = 117,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs1",
		.code = &gsm0503_mcs1,
		.in_len  = 190,
		.out_len = 588,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs2",
		.code = &gsm0503_mcs2,
		.in_len  = 238,
		.out_len = 732,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs3",
		.code = &gsm0503_mcs3,
		.in_len  = 310,
		.out_len = 948,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs4",
		.code = &gsm0503_mcs4,
		.in_len  = 366,
		.out_len = 1116,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs5_dl_hdr",
		.code = &gsm0503_mcs5_dl_hdr,
		.in_len  = 33,
		.out_len = 99,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs5_ul_hdr",
		.code = &gsm0503_mcs5_ul_hdr,
		.in_len  = 45,
		.out_len = 135,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs5",
		.code = &gsm0503_mcs5,
		.in_len  = 462,
		.out_len = 1404,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs6",
		.code = &gsm0503_mcs6,
		.in_len  = 606,
		.out_len = 1836,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs7_dl_hdr",
		.code = &gsm0503_mcs7_dl_hdr,
		.in_len  = 45,
		.out_len = 135,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs7_ul_hdr",
		.code = &gsm0503_mcs7_ul_hdr,
		.in_len  = 54,
		.out_len = 162,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs7",
		.code = &gsm0503_mcs7,
		.in_len  = 462,
		.out_len = 1404,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs8",
		.code = &gsm0503_mcs8,
		.in_len  = 558,
		.out_len = 1692,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
	{
		.name = "gsm0503_mcs9",
		.code = &gsm0503_mcs9,
		.in_len  = 606,
		.out_len = 1836,
		.has_vec = 0,
		.vec_in  = { },
		.vec_out = { },
	},
};
