#pragma once

#include <osmocom/core/socket.h>

/* According to 3GPP TS 29.060. */
struct gtp1u_hdr {
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
	uint8_t pn:1, s:1, e:1, spare:1, pt:1, version:3;
#else
	uint8_t version:3, pt:1, spare:1, e:1, s:1, pn:1;
#endif
	uint8_t type;
	uint16_t length;
	uint32_t tei;
};

struct gtp_flood;
struct udp_port;

struct gtp_flood_cfg {
	unsigned int num_rx_workers;
	unsigned int num_tx_workers;
	unsigned int queue_size;
	unsigned int slew_us;
};
struct gtp_flood *gtp_flood_alloc(void *ctx, const struct gtp_flood_cfg *cfg);

/* information passed on within generated GTP payload. Main purpose is to allow echoing payloads back into a GTP tunnel
 * by osmo-udp-responder, which requires knowledge of the counterpart TEID.
 * (future: add in-band instructions for the responder to shape traffic in certain ways: multiple echos or modified
 * packet size...)
 */
struct gtp_flood_payload_info {
	char mark[4];
	/* ordered exactly as it should be returned in a GTP header (network byte order) */
	uint32_t return_teid;
} __attribute__((packed));

struct gtp_flood_flow_cfg {
	bool rx;

	struct udp_port *gtp_local;

	/* below used only for rx == false */
	struct osmo_sockaddr gtp_remote;
	uint32_t gtp_remote_teid;
	struct osmo_sockaddr payload_src;
	struct osmo_sockaddr payload_dst;
	unsigned int num_packets;

	bool append_payload_info;
	struct gtp_flood_payload_info payload_info;
};

void gtp_flood_add_flow(struct gtp_flood *gtp_flood,
			const struct gtp_flood_flow_cfg *flow_cfg);

void gtp_flood_start(struct gtp_flood *gtp_flood);
bool gtp_flood_is_busy(struct gtp_flood *gtp_flood);
