#pragma once

#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

struct osmo_sockaddr;

/* A value large enough for an IPv6 address (128bit) */
struct range_val {
	uint64_t buf[2];
	size_t size;
};

/* Manage stepping through a defined range of values large enough to handle IPv6 addresses. */
struct range {
	struct range_val first;
	struct range_val last;
	struct range_val next;
	bool wrapped;
};

/* struct range r = {};
 * range_val_set_int(&r.first, 23);
 * range_val_set_int(&r.last, 42);
 * while (1) {
 *     range_next();
 *     unsigned int val = range_val_get_int(&r.next);
 *     printf("%u\n", val);
 * }
 */
void range_next(struct range *r);
void range_val_set_int(struct range_val *rv, uint32_t val);
uint32_t range_val_get_int(const struct range_val *rv);
void range_val_set_addr(struct range_val *rv, const struct osmo_sockaddr *val);
void range_val_get_addr(struct osmo_sockaddr *dst, const struct range_val *rv);
void range_val_inc(struct range_val *rv);
int range_val_cmp(const struct range_val *a, const struct range_val *b);
