/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n;

import com.sun.cldc.i18n.StreamReader;
import com.sun.cldc.i18n.StreamWriter;
import com.sun.javacard.impl.NativeMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Helper {
    private static Helper helperInstance = new Helper();
    private static String defaultEncoding;
    private static String lastReaderEncoding;
    private static StreamReader lastReader;
    private static String lastWriterEncoding;
    private static StreamWriter lastWriter;

    private Helper() {
    }

    public static Reader getStreamReader(InputStream is) {
        try {
            return Helper.getStreamReader(is, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            try {
                defaultEncoding = "ISO8859_1";
                return Helper.getStreamReader(is, defaultEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Missing default encoding " + defaultEncoding);
            }
        }
    }

    public static Reader getStreamReader(InputStream is, String name) throws UnsupportedEncodingException {
        if (is == null || name == null) {
            throw new NullPointerException();
        }
        StreamReader fr = Helper.getStreamReaderPrim(name);
        return fr.open(is, name);
    }

    StreamReader getStreamReaderPrimInternal(String name) throws UnsupportedEncodingException {
        if (name == null) {
            throw new NullPointerException();
        }
        name = Helper.internalNameForEncoding(name);
        try {
            String className = "com.sun.cldc.i18n.j2me." + name + "_Reader";
            Class<?> clazz = Class.forName(className);
            StreamReader sr = (StreamReader)clazz.newInstance();
            NativeMethods.setJCREentry(sr, false);
            return sr;
        }
        catch (ClassNotFoundException x) {
            throw new UnsupportedEncodingException("Encoding " + name + " not found");
        }
        catch (InstantiationException x) {
            throw new RuntimeException("InstantiationException " + x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException("IllegalAccessException " + x.getMessage());
        }
        catch (ClassCastException x) {
            throw new RuntimeException("ClassCastException " + x.getMessage());
        }
    }

    private static StreamReader getStreamReaderPrim(String name) throws UnsupportedEncodingException {
        return helperInstance.getStreamReaderPrimInternal(name);
    }

    public static Writer getStreamWriter(OutputStream os) {
        try {
            return Helper.getStreamWriter(os, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            try {
                defaultEncoding = "ISO8859_1";
                return Helper.getStreamWriter(os, defaultEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Missing default encoding " + defaultEncoding);
            }
        }
    }

    public static Writer getStreamWriter(OutputStream os, String name) throws UnsupportedEncodingException {
        if (os == null || name == null) {
            throw new NullPointerException();
        }
        StreamWriter sw = Helper.getStreamWriterPrim(name);
        return sw.open(os, name);
    }

    StreamWriter getStreamWriterPrimInternal(String name) throws UnsupportedEncodingException {
        if (name == null) {
            throw new NullPointerException();
        }
        name = Helper.internalNameForEncoding(name);
        try {
            String className = "com.sun.cldc.i18n.j2me." + name + "_Writer";
            Class<?> clazz = Class.forName(className);
            StreamWriter sw = (StreamWriter)clazz.newInstance();
            NativeMethods.setJCREentry(sw, false);
            return sw;
        }
        catch (ClassNotFoundException x) {
            throw new UnsupportedEncodingException("Encoding " + name + " not found");
        }
        catch (InstantiationException x) {
            throw new RuntimeException("InstantiationException " + x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException("IllegalAccessException " + x.getMessage());
        }
        catch (ClassCastException x) {
            throw new RuntimeException("ClassCastException " + x.getMessage());
        }
    }

    private static StreamWriter getStreamWriterPrim(String name) throws UnsupportedEncodingException {
        return helperInstance.getStreamWriterPrimInternal(name);
    }

    public static char[] byteToCharArray(byte[] buffer, int offset, int length) {
        try {
            return Helper.byteToCharArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException("Missing default encoding " + defaultEncoding);
        }
    }

    public static byte[] charToByteArray(char[] buffer, int offset, int length) {
        try {
            return Helper.charToByteArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException("Missing default encoding " + defaultEncoding);
        }
    }

    public static synchronized char[] byteToCharArray(byte[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(length));
        }
        if (offset > buffer.length - length) {
            throw new IndexOutOfBoundsException(Integer.toString(offset + length));
        }
        if (lastReaderEncoding == null || !lastReaderEncoding.equals(enc)) {
            lastReader = Helper.getStreamReaderPrim(enc);
            lastReaderEncoding = enc;
        }
        int size = lastReader.sizeOf(buffer, offset, length);
        char[] outbuf = new char[size];
        lastReader.open(new ByteArrayInputStream(buffer, offset, length), enc);
        int count = 0;
        try {
            count = lastReader.read(outbuf, 0, size);
            lastReader.close();
        }
        catch (IOException x) {
            throw new RuntimeException("IOException reading reader " + x.getMessage());
        }
        if (count >= 0 && count < size) {
            char[] newbuf = new char[count];
            System.arraycopy(outbuf, 0, newbuf, 0, count);
            outbuf = newbuf;
        }
        return outbuf;
    }

    public static synchronized byte[] charToByteArray(char[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (lastWriterEncoding == null || !lastWriterEncoding.equals(enc)) {
            lastWriter = Helper.getStreamWriterPrim(enc);
            lastWriterEncoding = enc;
        }
        int size = lastWriter.sizeOf(buffer, offset, length);
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        lastWriter.open(os, enc);
        try {
            lastWriter.write(buffer, offset, length);
            lastWriter.close();
        }
        catch (IOException x) {
            throw new RuntimeException("IOException writing writer " + x.getMessage());
        }
        try {
            os.close();
        }
        catch (Exception x) {
            // empty catch block
        }
        return os.toByteArray();
    }

    private static String internalNameForEncoding(String encodingName) {
        String internalName = Helper.normalizeEncodingName(encodingName);
        if (internalName.equals("US_ASCII")) {
            return "ISO8859_1";
        }
        if (internalName.equals("ISO_8859_1")) {
            return "ISO8859_1";
        }
        if (internalName.equals("UTF_8")) {
            return "UTF8";
        }
        return internalName;
    }

    private static String normalizeEncodingName(String encodingName) {
        StringBuffer normalizedName = new StringBuffer(encodingName);
        for (int i = 0; i < normalizedName.length(); ++i) {
            char currentChar = normalizedName.charAt(i);
            if (currentChar == '-' || currentChar == ':') {
                normalizedName.setCharAt(i, '_');
                continue;
            }
            normalizedName.setCharAt(i, Character.toUpperCase(currentChar));
        }
        return normalizedName.toString();
    }

    static {
        NativeMethods.setJCREentry(helperInstance, false);
        defaultEncoding = System.getProperty("javacard.encoding");
        if (defaultEncoding == null) {
            defaultEncoding = "ISO-8859-1";
        }
    }
}

