/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.appletcontainer;

import com.sun.javacard.appletcontainer.APDUComm;
import com.sun.javacard.appletcontainer.T1TransportLayer;
import com.sun.javacard.impl.NativeMethods;
import javacard.framework.APDUException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class T1APDUImpl
extends APDUComm {
    private static final byte LS = 3;
    private static final byte LO = 4;
    private static final byte PRE_READ_LENGTH = 5;
    private static final byte INCOMIMG_LENGTH = 6;
    private static final byte DATA_PROCESSED_LENGTH = 7;
    private static final byte RAM_SHORT_VARS_LENGTH = 8;
    private static final short CASE_1 = 1;
    private static final short CASE_2S = 2;
    private static final short CASE_3S = 3;
    private static final short CASE_4S = 4;
    private static final short CASE_2E = 6;
    private static final short CASE_3E = 7;
    private static final short CASE_4E = 8;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;
    private static final byte T1_EVENT_POWERRESET = 3;
    private static final short MAX_LE = 256;
    private static final short MAX_EXT_LE = Short.MAX_VALUE;
    private byte type16Flag;
    T1TransportLayer transportLayer;

    public T1APDUImpl(int port, int protocol) {
        this.transportLayer = new T1TransportLayer(port, protocol);
        this.buffer = this.transportLayer.initAPDUBuffer();
        this.ramByteVars = JCSystem.makeTransientByteArray((short)2, (byte)1);
        this.ramShortVars = JCSystem.makeTransientShortArray((short)8, (byte)1);
        this.type16Flag = this.thePackedBoolean.allocate();
    }

    private short getLe() {
        if (this.ramShortVars[0] == 0 && this.getDeterminedLEFlag()) {
            if (this.getExtendedAPDUFlag()) {
                return Short.MAX_VALUE;
            }
            return 256;
        }
        return this.ramShortVars[0];
    }

    private void setLe(short data) {
        this.ramShortVars[0] = data;
    }

    private short getIL() {
        return this.ramShortVars[6];
    }

    private void setIL(short data) {
        this.ramShortVars[6] = data;
    }

    private short getLr() {
        return this.ramShortVars[1];
    }

    private void setLr(short data) {
        this.ramShortVars[1] = data;
    }

    private short getLc() {
        return this.ramShortVars[2];
    }

    private void setLc(short data) {
        this.ramShortVars[2] = data;
    }

    private short getLs() {
        return this.ramShortVars[3];
    }

    private void setLs(short data) {
        this.ramShortVars[3] = (short)(data & Short.MAX_VALUE);
    }

    private short getLo() {
        return this.ramShortVars[4];
    }

    private void setLo(short data) {
        this.ramShortVars[4] = data;
    }

    private short getPreReadLength() {
        return this.ramShortVars[5];
    }

    private void setPreReadLength(short data) {
        this.ramShortVars[5] = data;
    }

    private byte getCurrState() {
        return this.ramByteVars[0];
    }

    private void setCurrState(byte data) {
        this.ramByteVars[0] = data;
    }

    private void resetCurrState() {
        this.ramByteVars[0] = 0;
    }

    private void setLogicalChannel(byte data) {
        this.ramByteVars[1] = data;
    }

    private boolean getType16Flag() {
        return this.thePackedBoolean.get(this.type16Flag);
    }

    private void setType16Flag() {
        this.thePackedBoolean.set(this.type16Flag);
    }

    private void resetType16Flag() {
        this.thePackedBoolean.reset(this.type16Flag);
    }

    private byte getChannelInfo() {
        byte theAPDUChannel;
        if (this.isType16CLA()) {
            theAPDUChannel = (byte)(this.buffer[0] & 0xF);
            theAPDUChannel = (byte)(theAPDUChannel + 4);
        } else {
            theAPDUChannel = (byte)(this.buffer[0] & 0x20) != 0 ? (byte)0 : (byte)(this.buffer[0] & 3);
        }
        return theAPDUChannel;
    }

    @Override
    public byte getLogicalChannel() {
        return this.ramByteVars[1];
    }

    @Override
    public void resetAPDU() {
        this.resetIncomingFlag();
        this.resetOutgoingFlag();
        this.resetOutgoingLenSetFlag();
        this.resetSendInProgressFlag();
        this.resetType16Flag();
        this.resetExtendedAPDUFlag();
        this.resetDeterminedLEFlag();
        this.resetNoChainingFlag();
        this.setPreReadLength((short)0);
        this.ramShortVars[7] = 0;
    }

    private void setAPDUParameters(short Lc, short Le, short Lr, short preReadLength, short incomingLength) {
        this.setLe(Le);
        this.setLc(Lc);
        this.setLr(Lr);
        this.setIL(incomingLength);
        this.resetCurrState();
        this.setPreReadLength(preReadLength);
        if (this.isType16CLA()) {
            this.setType16Flag();
        }
        this.setLogicalChannel(this.getChannelInfo());
    }

    private void preProcessAPDU(short recvBytes) {
        if (recvBytes == 4) {
            this.setAPDUParameters((short)0, (short)0, (short)0, (short)0, (short)0);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes == 5) {
            short Le = (short)(this.buffer[4] & 0xFF);
            this.setAPDUParameters((short)0, Le, (short)0, (short)0, (short)0);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes == 7) {
            byte bLc = this.buffer[4];
            if (bLc == 0) {
                short Le = (short)(this.buffer[5] & 0xFF);
                Le = (short)((short)(Le << 8) | (short)(this.buffer[6] & 0xFF));
                this.setAPDUParameters((short)0, Le, (short)0, (short)0, (short)0);
                this.setDeterminedLEFlag();
                this.setExtendedAPDUFlag();
                return;
            }
            short Lc = (short)(bLc & 0xFF);
            if (bLc != 2) {
                short Le = (short)(this.buffer[6] & 0xFF);
                Lc = (short)(Lc - 1);
                this.setAPDUParameters(Lc, Le, (short)0, (short)1, (short)1);
                this.setDeterminedLEFlag();
                return;
            }
            Lc = (short)(Lc - 2);
            this.setAPDUParameters(Lc, (short)0, (short)0, (short)2, (short)2);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes > 5) {
            byte bLc = this.buffer[4];
            if (bLc == 0) {
                short Le;
                short pRL;
                int Lc = this.buffer[5] & 0xFF;
                if (recvBytes == (short)((Lc = (short)((short)(Lc << 8) | (short)(this.buffer[6] & 0xFF))) + 9)) {
                    pRL = (short)(recvBytes - 9);
                    Le = (short)(this.buffer[(short)(7 + pRL)] & 0xFF);
                    Le = (short)((short)(Le << 8) | (short)(this.buffer[(short)(7 + pRL + 1)] & 0xFF));
                    Lc = -2;
                } else {
                    pRL = (short)(recvBytes - 7);
                    Le = 0;
                    Lc = (short)(Lc - pRL);
                }
                this.setAPDUParameters((short)Lc, Le, (short)0, pRL, (short)(Lc + pRL));
                this.setExtendedAPDUFlag();
                this.resetDeterminedLEFlag();
                return;
            }
            short Lc = (short)(bLc & 0xFF);
            if (Lc > 128) {
                short pRL = (short)(recvBytes - 5);
                Lc = (short)(Lc - pRL);
                this.setAPDUParameters(Lc, (short)0, (short)0, pRL, (short)(Lc + pRL));
                this.resetDeterminedLEFlag();
                return;
            }
            if (Lc < (short)(recvBytes - 5)) {
                short Le = (short)(this.buffer[(short)(recvBytes - 1)] & 0xFF);
                short pRL = (short)(recvBytes - 6);
                Lc = (short)(Lc - pRL);
                this.setAPDUParameters(Lc, Le, (short)0, pRL, (short)(Lc + pRL));
                this.setDeterminedLEFlag();
                return;
            }
            short Le = 0;
            short pRL = (short)(recvBytes - 5);
            Lc = (short)(Lc - pRL);
            this.setAPDUParameters(Lc, Le, (short)0, pRL, (short)(Lc + pRL));
            this.resetDeterminedLEFlag();
        }
    }

    @Override
    public void complete(short status) throws APDUException {
        short result = 0;
        if (status != 0) {
            if (!this.getOutgoingFlag() && !this.transportLayer.t1LastBlockReceived() && (result = this.transportLayer.t1Abort()) < 0) {
                status = (short)28416;
            }
            if (this.getSendInProgressFlag()) {
                short Lo;
                short Ls = this.getLs();
                if ((short)(Ls + (Lo = this.getLo()) + 1) >= 133) {
                    result = this.transportLayer.t1SndBlockRcvAck(Lo, Ls, false);
                    Ls = 0;
                    Lo = 0;
                }
                byte sw1 = (byte)((byte)(status >> 8) & 0xFF);
                byte sw2 = (byte)(status & 0xFF);
                this.buffer[(short)(Ls + Lo)] = sw1;
                this.buffer[(short)(Ls + Lo + 1)] = sw2;
                result = this.transportLayer.t1SndBlockRcvAck(Lo, (short)(Ls + 2), true);
            } else {
                byte sw1 = (byte)((byte)(status >> 8) & 0xFF);
                byte sw2 = (byte)(status & 0xFF);
                this.buffer[0] = sw1;
                this.buffer[1] = sw2;
                result = this.transportLayer.t1SndBlockRcvAck((short)0, (short)2, true);
            }
            if (result != 0 && result != -14) {
                APDUException.throwIt((short)4);
            }
        }
        Util.arrayFillNonAtomic(this.buffer, (short)0, (short)133, (byte)0);
        short bOff = 0;
        short bytesReceived = 0;
        while (result == -14 || bOff < 133 && !this.transportLayer.t1LastBlockReceived()) {
            result = this.transportLayer.t1RcvBlock(bOff, (short)133);
            if (result < 0) {
                APDUException.throwIt((short)4);
            }
            bOff = (short)(bOff + result);
            bytesReceived = (short)(bytesReceived + result);
        }
        this.resetExtendedSupportFlag();
        this.resetAPDU();
        this.preProcessAPDU(bytesReceived);
    }

    @Override
    public void undoIncomingAndReceive() {
        this.setPreReadLength((short)(this.buffer[4] - this.getLc() & Short.MAX_VALUE));
        this.setCurrState((byte)0);
    }

    @Override
    public byte getCLAChannel() {
        return this.getLogicalChannel();
    }

    @Override
    public void waitExtension() throws APDUException {
        short result;
        if (this.getNoChainingFlag()) {
            APDUException.throwIt((short)1);
        }
        if ((result = this.transportLayer.t1Wait()) != 0) {
            APDUException.throwIt((short)4);
        }
    }

    private boolean isExtended() {
        return this.getExtendedSupportFlag();
    }

    @Override
    public boolean isValidCLA() {
        byte cla = this.buffer[0];
        return (byte)(cla & 0xE0) != 32 && cla != -1;
    }

    @Override
    public boolean isCommandChainingCLA() {
        if (!this.isValidCLA()) {
            return false;
        }
        byte theCLAChaining = (byte)(this.buffer[0] & 0x10);
        return theCLAChaining == 16;
    }

    @Override
    public boolean isSecureMessagingCLA() {
        if (!this.isValidCLA()) {
            return false;
        }
        byte secureMsgFlag = this.isType16CLA() ? (byte)(this.buffer[0] & 0x20) : (byte)(this.buffer[0] & 0xC);
        return secureMsgFlag != 0;
    }

    @Override
    public boolean isISOInterindustryCLA() {
        byte theCLAType = (byte)(this.buffer[0] & 0xFFFFFF80);
        return theCLAType == 0;
    }

    private boolean isType16CLA() {
        byte theCLAType = (byte)(this.buffer[0] & 0x40);
        return theCLAType == 64;
    }

    @Override
    public short getInBlockSize() {
        return this.transportLayer.t1GetIFSC();
    }

    @Override
    public short getOutBlockSize() {
        return this.transportLayer.t1GetIFSD();
    }

    @Override
    public byte getProtocol() {
        return 1;
    }

    @Override
    public byte getNAD() {
        return this.transportLayer.t1GetNAD();
    }

    private void receiveBytesAndDiscard() {
        short Le;
        short pre;
        if (!this.getIncomingFlag()) {
            this.setIncomingFlag();
        }
        if ((pre = this.getPreReadLength()) != 0) {
            this.setPreReadLength((short)0);
            this.ramShortVars[7] = (short)(this.ramShortVars[7] + pre);
        }
        if ((Le = this.transportLayer.t1RcvAndDiscardData(this.getIL(), this.ramShortVars[7])) == -2) {
            ISOException.throwIt((short)26368);
        } else if (Le >= 0) {
            this.setLe(Le);
            this.setDeterminedLEFlag();
        }
    }

    @Override
    public short setOutgoing() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (!this.transportLayer.t1LastBlockReceived()) {
            this.receiveBytesAndDiscard();
        }
        this.setOutgoingFlag();
        this.setCurrState((byte)3);
        if (this.getLe() < 0) {
            ISOException.throwIt((short)26368);
        }
        return this.getLe();
    }

    @Override
    public short setOutgoingNoChaining() throws APDUException {
        short result;
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (!this.transportLayer.t1LastBlockReceived() && (result = this.transportLayer.t1Abort()) < 0) {
            APDUException.throwIt((short)4);
        }
        this.setOutgoingFlag();
        this.setNoChainingFlag();
        this.setCurrState((byte)3);
        return this.getLe();
    }

    @Override
    public void setOutgoingLength(short len) throws APDUException {
        if (!this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len > 256 && !this.getExtendedSupportFlag()) {
            APDUException.throwIt((short)3);
        }
        if (len > Short.MAX_VALUE) {
            APDUException.throwIt((short)3);
        }
        if (len < 0) {
            APDUException.throwIt((short)3);
        }
        if (len > (short)(this.transportLayer.t1GetIFSD() - 2) && this.getNoChainingFlag()) {
            APDUException.throwIt((short)3);
        }
        this.setOutgoingLenSetFlag();
        this.setCurrState((byte)4);
        this.setLr(len);
        this.setDeterminedLEFlag();
        if (len > 256) {
            this.setExtendedAPDUFlag();
        }
    }

    @Override
    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (this.getIL() == 0) {
            APDUException.throwIt((short)4);
        }
        if (!this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        short Lc = this.getLc();
        if (bOff < 0) {
            APDUException.throwIt((short)2);
        }
        if ((pre = this.getPreReadLength()) != 0) {
            this.setPreReadLength((short)0);
            if (Lc <= 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            this.ramShortVars[7] = (short)(this.ramShortVars[7] + pre);
            return pre;
        }
        short len = 0;
        if (Lc > 0) {
            short accumLen = 0;
            short bOff2 = bOff;
            while (bOff2 < 133 && Lc > 0) {
                accumLen = this.transportLayer.t1RcvBlock(bOff2, (short)133);
                if (accumLen < 0) {
                    APDUException.throwIt((short)4);
                }
                Lc = (short)(Lc - accumLen);
                bOff2 = (short)(bOff2 + accumLen);
                len = (short)(len + accumLen);
            }
            if (Lc < 0) {
                if (Lc == -1) {
                    if (this.getExtendedAPDUFlag()) {
                        this.setLe((short)((this.buffer[(short)(bOff + len - 1)] & 0xFF) << 8));
                    } else {
                        this.setLe((short)(this.buffer[(short)(bOff + len - 1)] & 0xFF));
                    }
                    Lc = 0;
                    len = (short)(len - 1);
                    this.setDeterminedLEFlag();
                } else {
                    this.setLe((short)((this.buffer[(short)(bOff + len - 2)] & 0xFF) << 8 | (short)(this.buffer[(short)(bOff + len - 1)] & 0xFF)));
                    Lc = 0;
                    len = (short)(len - 2);
                    this.setDeterminedLEFlag();
                }
            }
            this.setLc(Lc);
            if (Lc == 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            this.ramShortVars[7] = (short)(this.ramShortVars[7] + len);
            return len;
        }
        if (!this.transportLayer.t1LastBlockReceived()) {
            len = this.transportLayer.t1RcvBlock(bOff, (short)133);
            if (len < 0) {
                APDUException.throwIt((short)4);
            }
            if (this.getExtendedAPDUFlag()) {
                if (this.getDeterminedLEFlag()) {
                    this.setLe((short)(this.getLe() | this.buffer[(short)(bOff + len - 1)] & 0xFF));
                } else {
                    this.setLe((short)((this.buffer[(short)(bOff + len - 2)] & 0xFF) << 8 | (short)(this.buffer[(short)(bOff + len - 1)] & 0xFF)));
                    this.setDeterminedLEFlag();
                }
            } else if (!this.getDeterminedLEFlag()) {
                this.setLe((short)(this.buffer[(short)(bOff + len - 1)] & 0xFF));
            }
        }
        this.setLc((short)0);
        this.setCurrState((byte)2);
        return 0;
    }

    @Override
    public void sendBytes(short bOff, short len) throws APDUException {
        short result = 0;
        if (bOff < 0 || len < 0 || (short)(bOff + len) > 133) {
            APDUException.throwIt((short)2);
        }
        if (!this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.getLr();
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        short Le = this.getLe();
        short blockSize = this.transportLayer.t1GetIFSD();
        short lenSent = 0;
        short bOff2 = bOff;
        if (this.getNoChainingFlag() && Lr > blockSize) {
            APDUException.throwIt((short)1);
        }
        short initLen = len;
        while (lenSent < initLen) {
            short sendLen = blockSize;
            if (len < blockSize) {
                sendLen = len;
                if (Lr == len && (short)(len + 2) <= blockSize) {
                    this.setLs(len);
                    this.setLo(bOff2);
                    this.setLr((short)0);
                    this.setLe((short)0);
                    this.setCurrState((byte)6);
                    this.setSendInProgressFlag();
                    return;
                }
            }
            if ((result = this.transportLayer.t1SndBlockRcvAck(bOff2, sendLen, false)) != 0) {
                APDUException.throwIt((short)4);
            }
            bOff2 = (short)(bOff2 + sendLen);
            lenSent = (short)(sendLen + lenSent);
            Lr = (short)(Lr - sendLen);
            len = (short)(len - sendLen);
        }
        Le = Lr;
        if (Lr == 0) {
            this.setCurrState((byte)6);
        } else {
            this.setCurrState((byte)5);
        }
        this.setLe(Le);
        this.setLr(Lr);
    }

    @Override
    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        NativeMethods.checkArrayArgs(outData, bOff, len);
        NativeMethods.checkPreviousContextAccess(outData);
        short sendLength = (short)this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, sendLength);
            this.sendBytes((short)0, sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    private void setIncoming() throws APDUException {
        if (this.getPreReadLength() != 0) {
            this.setIncomingFlag();
            return;
        }
        if (this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setIncomingFlag();
        if (!this.getExtendedSupportFlag() && this.getLc() > 256) {
            APDUException.throwIt((short)26368);
        }
        if (this.getLc() < 0) {
            APDUException.throwIt((short)26368);
        }
    }

    @Override
    public short setIncomingAndReceive() throws APDUException {
        this.setIncoming();
        if (this.getExtendedAPDUFlag()) {
            return this.receiveBytes((short)7);
        }
        return this.receiveBytes((short)5);
    }

    @Override
    public byte getCurrentState() {
        return this.getCurrState();
    }

    @Override
    public byte[] getCurrentAPDUBuffer() throws SecurityException {
        return this.getBuffer();
    }

    @Override
    public void markExtendedSupport(boolean extAPDUOK) {
        if (!extAPDUOK) {
            this.resetExtendedSupportFlag();
            if (this.getExtendedAPDUFlag()) {
                ISOException.throwIt((short)26368);
            }
        } else {
            this.setExtendedSupportFlag();
        }
    }

    @Override
    public short getIncomingLength() {
        return this.getIL();
    }

    @Override
    public short getOffsetCdata() {
        if (!this.getExtendedAPDUFlag()) {
            return 5;
        }
        return 7;
    }

    @Override
    public void verifyLe() {
        if (this.getLe() < 0) {
            ISOException.throwIt((short)26368);
        }
    }
}

