/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcrd;

import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Util {
    public static final int ATTRIBUTE_READ_OK = 0;
    public static final int SECTION_END_REACHED = -1;
    private static boolean sectionEndReached = false;
    public static boolean fileEndReached = false;
    private static int lineNumber = 0;
    private static String line;

    public static void startNewFile() {
        fileEndReached = false;
        sectionEndReached = false;
        lineNumber = 0;
        line = null;
    }

    public static void startReadNewSection() {
        sectionEndReached = false;
    }

    public static boolean atSectionEnd() {
        return sectionEndReached;
    }

    public static int readAttribute(BufferedReader br, StringBuffer name, StringBuffer value, StringBuffer lastLine) throws FormatErrorException, IOException {
        String newLastLine = null;
        name.delete(0, name.length());
        value.delete(0, value.length());
        if (sectionEndReached) {
            return -1;
        }
        int returnValue = 0;
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if (line.length() <= 0) {
                sectionEndReached = true;
                returnValue = -1;
                break;
            }
            if (line.startsWith("#")) {
                if (lastLine.length() == 0) continue;
                returnValue = 0;
                break;
            }
            if (line.startsWith(" ")) {
                if (lastLine.length() == 0) {
                    Logger.debug("JCRD-ERROR: Space in the beginning of the line at " + lineNumber);
                }
                lastLine.append(line.substring(1));
                continue;
            }
            if (line.indexOf(":") > 0) {
                if (lastLine.length() == 0) {
                    lastLine.append(line);
                    continue;
                }
                newLastLine = line;
                returnValue = 0;
                break;
            }
            Util.fatalError("4086", Integer.toString(lineNumber));
        }
        if (lastLine.length() > 0 && !lastLine.toString().equals("null") && !lastLine.toString().startsWith("#") && lastLine.toString().indexOf(58) != -1) {
            name.append(Util.getName(lastLine.toString()));
            value.append(Util.getValue(lastLine.toString()));
            lastLine.delete(0, lastLine.length());
            if (newLastLine != null) {
                lastLine.append(newLastLine);
            }
        }
        if (sectionEndReached) {
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                lastLine.append(line);
                break;
            }
        }
        if (line == null) {
            fileEndReached = true;
        }
        return returnValue;
    }

    private static String getName(String line) throws FormatErrorException {
        int index = line.indexOf(58);
        if (index == -1) {
            Util.fatalError("4087", "");
        }
        return line.substring(0, index);
    }

    private static String getValue(String line) throws FormatErrorException {
        int index = line.indexOf(58);
        if (index == -1) {
            Util.fatalError("4087", "");
        }
        return line.substring(index + 1).trim();
    }

    static void fatalError(String desc, String errorLoc) throws FormatErrorException {
        throw new FormatErrorException(desc, errorLoc);
    }

    public static Vector<String> getStringVector(String list) {
        Vector<String> strings = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        while (tokenizer.hasMoreTokens()) {
            strings.addElement(tokenizer.nextToken().trim());
        }
        return strings;
    }
}

