/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.storage;

import com.sun.midp.io.Util;
import java.io.IOException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class File {
    private static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String storageRoot = null;

    public static String getStorageRoot() {
        if (storageRoot == null) {
            storageRoot = File.initStorageRoot();
        }
        return storageRoot;
    }

    public static String unicodeToAsciiFilename(String str) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sbuf.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                sbuf.append('#');
                sbuf.append(c);
                continue;
            }
            int v = c & 0xFFFF;
            sbuf.append('%');
            sbuf.append(NUMS[(v & 0xF000) >> 12]);
            sbuf.append(NUMS[(v & 0xF00) >> 8]);
            sbuf.append(NUMS[(v & 0xF0) >> 4]);
            sbuf.append(NUMS[(v & 0xF) >> 0]);
        }
        return sbuf.toString();
    }

    public static String asciiFilenameToUnicode(String str) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                int v = 0;
                v <<= 4;
                v += File.hexValue(str.charAt(i + 1));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 2));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 3));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 4));
                i += 4;
                sbuf.append((char)(v & 0xFFFF));
                continue;
            }
            if (c == '#') continue;
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return c - 97 + 10;
    }

    public synchronized void rename(String oldName, String newName) throws IOException {
        byte[] oldAsciiFilename = Util.toCString(oldName);
        byte[] newAsciiFilename = Util.toCString(newName);
        File.renameStorage(oldAsciiFilename, newAsciiFilename);
    }

    public synchronized boolean exists(String name) {
        byte[] asciiFilename = Util.toCString(name);
        return File.storageExists(asciiFilename);
    }

    public synchronized Vector<String> filenamesThatStartWith(String root) {
        Vector<String> list = new Vector<String>();
        byte[] szRoot = Util.toCString(root);
        String filename = File.getFirstFileThatStartsWith(szRoot);
        while (filename != null) {
            list.addElement(filename);
            filename = File.getNextFileThatStartsWith(szRoot);
        }
        return list;
    }

    public synchronized void delete(String name) throws IOException {
        byte[] asciiFilename = Util.toCString(name);
        File.deleteStorage(asciiFilename);
    }

    public int getBytesAvailableForFiles() {
        return File.availableStorage();
    }

    private static native String initStorageRoot();

    private static native void renameStorage(byte[] var0, byte[] var1) throws IOException;

    private static native boolean storageExists(byte[] var0);

    private static native void deleteStorage(byte[] var0) throws IOException;

    private static native String getFirstFileThatStartsWith(byte[] var0);

    private static native String getNextFileThatStartsWith(byte[] var0);

    private static native int availableStorage();
}

