/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import java.security.AccessController;
import javacardx.framework.JCRuntimePermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class Thread
implements Runnable {
    private int priority = 5;
    private TransientReference<Thread> vmThreadRef = new TransientReference<Object>(null);
    private Runnable target;
    private char[] name;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int threadInitNumber;

    public static native Thread currentThread();

    private static synchronized int nextThreadNum() {
        return ++threadInitNumber;
    }

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    private void init(Runnable target, String name) {
        if (NativeMethods.getObjectOwnerId(this) != 0) {
            AccessController.checkPermission(new JCRuntimePermission("thread.create"));
        } else {
            NativeMethods.allowMonitorEnter(this);
        }
        this.target = target;
        this.name = name.toCharArray();
        this.priority = JCSystemAccessor.getJCSystemAccessor().getCurrentThreadPriority();
        this.setPriority0(this.priority);
    }

    public Thread() {
        this.init(null, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(String name) {
        this.init(null, "Thread-" + Thread.nextThreadNum());
        this.init(null, name);
    }

    public Thread(Runnable target) {
        this.init(target, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(Runnable target, String name) {
        this.init(target, name);
    }

    public synchronized void start() {
        if (this.vmThreadRef.get() == null) {
            throw new IllegalThreadStateException("Card Reset happened");
        }
        this.start0();
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public void interrupt() {
        if (NativeMethods.getObjectOwnerId(this) != 0) {
            AccessController.checkPermission(new JCRuntimePermission("thread.modify"));
        }
        if (this.vmThreadRef.get() != null) {
            this.interrupt0();
        }
    }

    public final boolean isAlive() {
        if (this.vmThreadRef.get() == null) {
            return false;
        }
        return this.isAlive0();
    }

    public final void setPriority(int newPriority) {
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        if (NativeMethods.getObjectOwnerId(this) != 0) {
            AccessController.checkPermission(new JCRuntimePermission("thread.modify"));
        }
        this.priority = newPriority;
        if (this.vmThreadRef.get() != null) {
            this.setPriority0(this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public static native int activeCount();

    public final synchronized void join() throws InterruptedException {
        while (this.isAlive()) {
            this.wait(1000L);
        }
    }

    public String toString() {
        return "Thread[" + this.getName() + "," + this.getPriority() + "]";
    }

    private native void setPriority0(int var1);

    private native void interrupt0();

    private synchronized native void start0();

    private final native boolean isAlive0();
}

