/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class Locale {
    public static final Locale ENGLISH = Locale.getNewLocaleInternal("en", "", "");
    public static final Locale FRENCH = Locale.getNewLocaleInternal("fr", "", "");
    public static final Locale GERMAN = Locale.getNewLocaleInternal("de", "", "");
    public static final Locale ITALIAN = Locale.getNewLocaleInternal("it", "", "");
    public static final Locale JAPANESE = Locale.getNewLocaleInternal("ja", "", "");
    public static final Locale KOREAN = Locale.getNewLocaleInternal("ko", "", "");
    public static final Locale CHINESE = Locale.getNewLocaleInternal("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.getNewLocaleInternal("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = Locale.getNewLocaleInternal("zh", "TW", "");
    public static final Locale FRANCE = Locale.getNewLocaleInternal("fr", "FR", "");
    public static final Locale GERMANY = Locale.getNewLocaleInternal("de", "DE", "");
    public static final Locale ITALY = Locale.getNewLocaleInternal("it", "IT", "");
    public static final Locale JAPAN = Locale.getNewLocaleInternal("ja", "JP", "");
    public static final Locale KOREA = Locale.getNewLocaleInternal("ko", "KR", "");
    public static final Locale CHINA = Locale.getNewLocaleInternal("zh", "CN", "");
    public static final Locale PRC = Locale.getNewLocaleInternal("zh", "CN", "");
    public static final Locale TAIWAN = Locale.getNewLocaleInternal("zh", "TW", "");
    public static final Locale UK = Locale.getNewLocaleInternal("en", "GB", "");
    public static final Locale US = Locale.getNewLocaleInternal("en", "US", "");
    public static final Locale CANADA = Locale.getNewLocaleInternal("en", "CA", "");
    public static final Locale CANADA_FRENCH = Locale.getNewLocaleInternal("fr", "CA", "");
    private String language = "";
    private String country = "";
    private int hashcode = -1;
    private static Locale defaultLocale = null;

    private static Locale getNewLocaleInternal(String language, String country, String variant) {
        Locale tmpLocale = new Locale(language, country, variant);
        NativeMethods.setJCREentry(tmpLocale, false);
        return tmpLocale;
    }

    private Locale(String language, String country, String variant) {
        this.language = this.convertOldISOCodes(language);
        this.country = this.toUpperCase(country).intern();
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            defaultLocale = JCSystemAccessor.getJCSystemAccessor().createDefaultLocale();
        }
        return defaultLocale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public final String toString() {
        boolean c = this.country.length() != 0;
        StringBuffer result = new StringBuffer(this.language);
        if (c) {
            result.append('_').append(this.country);
        }
        String finalStrRepresentation = result.toString();
        if (NativeMethods.getCurrentContext() == 0) {
            NativeMethods.transferOwnershipToPreviousContext(finalStrRepresentation);
        }
        return finalStrRepresentation;
    }

    public synchronized int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.language.hashCode() ^ this.country.hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale other = (Locale)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.language != other.language) {
            return false;
        }
        return this.country == other.country;
    }

    private String toLowerCase(String str) {
        char[] buf = str.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toLowerCase(buf[i]);
        }
        return new String(buf);
    }

    private String toUpperCase(String str) {
        char[] buf = str.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toUpperCase(buf[i]);
        }
        return new String(buf);
    }

    private String convertOldISOCodes(String language) {
        if ((language = this.toLowerCase(language).intern()) == "he") {
            return "iw";
        }
        if (language == "yi") {
            return "ji";
        }
        if (language == "id") {
            return "in";
        }
        return language;
    }
}

