/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.appletcontainer.APDUComm;
import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import javacard.framework.APDUException;
import javacard.framework.ISOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class APDU {
    public static final byte STATE_INITIAL = 0;
    public static final byte STATE_PARTIAL_INCOMING = 1;
    public static final byte STATE_FULL_INCOMING = 2;
    public static final byte STATE_OUTGOING = 3;
    public static final byte STATE_OUTGOING_LENGTH_KNOWN = 4;
    public static final byte STATE_PARTIAL_OUTGOING = 5;
    public static final byte STATE_FULL_OUTGOING = 6;
    public static final byte STATE_ERROR_NO_T0_GETRESPONSE = -1;
    public static final byte STATE_ERROR_T1_IFD_ABORT = -2;
    public static final byte STATE_ERROR_IO = -3;
    public static final byte STATE_ERROR_NO_T0_REISSUE = -4;
    public static final byte PROTOCOL_MEDIA_MASK = -16;
    public static final byte PROTOCOL_TYPE_MASK = 15;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_MEDIA_DEFAULT = 0;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_A = -128;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_B = -112;
    public static final byte PROTOCOL_MEDIA_USB = -96;
    private APDUComm apduProtocol;

    byte getLogicalChannel() {
        return this.apduProtocol.getLogicalChannel();
    }

    boolean getNoChainingFlag() {
        return this.apduProtocol.getNoChainingFlag();
    }

    private APDU(APDUComm apduProtocol) {
        this.apduProtocol = apduProtocol;
    }

    public byte[] getBuffer() {
        return this.apduProtocol.getBuffer();
    }

    public static short getInBlockSize() {
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getInBlockSize();
        }
        return 0;
    }

    public static short getOutBlockSize() {
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getOutBlockSize();
        }
        return 0;
    }

    public static byte getProtocol() {
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getProtocol();
        }
        return 0;
    }

    public byte getNAD() {
        return this.apduProtocol.getNAD();
    }

    public short setOutgoing() throws APDUException, ISOException {
        APDU.checkErrorState();
        return this.apduProtocol.setOutgoing();
    }

    public short setOutgoingNoChaining() throws APDUException, ISOException {
        APDU.checkErrorState();
        return this.apduProtocol.setOutgoingNoChaining();
    }

    public void setOutgoingLength(short len) throws APDUException {
        APDU.checkErrorState();
        this.apduProtocol.setOutgoingLength(len);
    }

    public short receiveBytes(short bOff) throws APDUException {
        APDU.checkErrorState();
        return this.apduProtocol.receiveBytes(bOff);
    }

    public short setIncomingAndReceive() throws APDUException {
        APDU.checkErrorState();
        return this.apduProtocol.setIncomingAndReceive();
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        APDU.checkErrorState();
        this.apduProtocol.sendBytes(bOff, len);
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        APDU.checkErrorState();
        NativeMethods.checkPreviousContextAccess(outData);
        this.apduProtocol.sendBytesLong(outData, bOff, len);
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        APDU.checkErrorState();
        this.apduProtocol.setOutgoingAndSend(bOff, len);
    }

    public byte getCurrentState() {
        return this.apduProtocol.getCurrentState();
    }

    private static void checkErrorState() throws APDUException {
        Thread ct = Thread.currentThread();
        APDU apdu = null;
        if (!(ct instanceof APDUDispatcher)) {
            return;
        }
        APDUDispatcher dispatcher = (APDUDispatcher)ct;
        apdu = dispatcher.getAPDU();
        if (apdu.getCurrentState() < 0) {
            APDUException.throwIt((short)4);
        }
    }

    private static void checkAPDUObjectAccess() throws SecurityException {
        byte currentAppId = NativeMethods.getCurrentAppId();
        JCSystemAccessor.getJCSystemAccessor().checkAPDUObjectAccess(currentAppId);
    }

    public static APDU getCurrentAPDU() throws SecurityException {
        APDU.checkAPDUObjectAccess();
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getAPDU();
        }
        return null;
    }

    public static byte[] getCurrentAPDUBuffer() throws SecurityException {
        APDU.checkAPDUObjectAccess();
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getAPDUBuffer();
        }
        return null;
    }

    public static byte getCLAChannel() {
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getCLAChannel();
        }
        return 0;
    }

    void resetAPDU() {
        this.apduProtocol.resetAPDU();
    }

    public static void waitExtension() throws APDUException {
        APDU.checkErrorState();
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            dispatcher.waitExtension();
        } else {
            APDUException.throwIt((short)1);
        }
    }

    public boolean isCommandChainingCLA() {
        return this.apduProtocol.isCommandChainingCLA();
    }

    public boolean isSecureMessagingCLA() {
        return this.apduProtocol.isSecureMessagingCLA();
    }

    public boolean isISOInterindustryCLA() {
        return this.apduProtocol.isISOInterindustryCLA();
    }

    public boolean isValidCLA() {
        return this.apduProtocol.isValidCLA();
    }

    public short getIncomingLength() {
        return this.apduProtocol.getIncomingLength();
    }

    public short getOffsetCdata() {
        return this.apduProtocol.getOffsetCdata();
    }
}

