/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework;

import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.spi.cardmgmt.Application;
import com.sun.javacard.spi.security.ProtectionDomain;
import com.sun.javacard.util.APDUUtil;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.javacard.util.URIUtils;
import java.security.AccessControlException;
import java.security.AccessController;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacardx.framework.ContextPermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class JCSystem {
    public static final byte TIME_ACCURATE = 1;
    public static final byte TIME_DELTA_ACCURATE = 2;
    public static final byte TIME_DELTA_MIN_ACCURATE = 3;

    public static AID getAID(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (!APDUUtil.isValidAID(uri)) {
            throw new IllegalArgumentException();
        }
        if (Application.lookup(uri) == null) {
            return null;
        }
        return APDUUtil.getAIDForURI(uri);
    }

    public static String getAppProperty(String name, String uri) {
        name.equals(null);
        if (uri != null) {
            uri.equals(null);
        }
        String appURI = null;
        if (uri != null) {
            appURI = JCSystemAccessor.getJCSystemAccessor().getBaseAppURI(NativeMethods.getCurrentContext(), uri);
        }
        if (appURI == null) {
            appURI = JCSystem.getURI();
        }
        return JCSystemAccessor.getJCSystemAccessor().getAppProperty(appURI, name);
    }

    public static String getClientURI() {
        if (NativeMethods.isSICalledFromSameContext()) {
            return JCSystem.getURI();
        }
        return JCSystem.getPreviousURI();
    }

    public static String getServerURI(Shareable sio) {
        if (sio == null) {
            throw new NullPointerException();
        }
        byte appId = NativeMethods.getObjectOwnerId(sio);
        return JCSystemAccessor.getJCSystemAccessor().getURI(appId);
    }

    public static String getURI() {
        byte appId = NativeMethods.getCurrentAppId();
        return JCSystemAccessor.getJCSystemAccessor().getURI(appId);
    }

    public static String getURI(AID aid) {
        return JCSystemAccessor.getJCSystemAccessor().getURIImpl(aid);
    }

    public static String getPreviousURI() {
        byte clientAppId = NativeMethods.getPreviousAppId();
        return JCSystemAccessor.getJCSystemAccessor().getURI(clientAppId);
    }

    public static boolean isClientInRole(String role, String rsrcURI) {
        role.equals(null);
        rsrcURI.equals(null);
        if (!URIUtils.hasScheme(rsrcURI)) {
            throw new IllegalArgumentException("Absolute resource URI required.");
        }
        rsrcURI = URIUtils.normalize(rsrcURI);
        String appURI = JCSystemAccessor.getJCSystemAccessor().getBaseAppURI(NativeMethods.getCurrentContext(), rsrcURI);
        if (appURI == null) {
            appURI = JCSystem.getURI();
        }
        String srvURI = JCSystem.getURI();
        String clientURI = JCSystem.getClientURI();
        if (clientURI == null) {
            return false;
        }
        if (clientURI.equals(JCSystem.getURI())) {
            return true;
        }
        return JCSystemAccessor.getJCSystemAccessor().isClientInRole(appURI, srvURI, clientURI, role, rsrcURI);
    }

    public static boolean isTransferable(Object object) {
        object.equals(null);
        return NativeMethods.isTransferrable(object);
    }

    public static boolean isUserInRole(String role, String uri) {
        role.equals(null);
        if (uri != null) {
            uri.equals(null);
        }
        String appURI = null;
        if (uri != null) {
            appURI = JCSystemAccessor.getJCSystemAccessor().getBaseAppURI(NativeMethods.getCurrentContext(), uri);
        }
        if (appURI == null) {
            appURI = JCSystem.getURI();
        }
        return JCSystemAccessor.getJCSystemAccessor().isUserInRole(appURI, role);
    }

    public static void transferOwnership(Object object) {
        if (NativeMethods.isSICalledFromSameContext()) {
            return;
        }
        if (object == null) {
            throw new NullPointerException();
        }
        byte clientAppId = NativeMethods.getPreviousAppId();
        if (clientAppId == 0) {
            throw new SecurityException();
        }
        try {
            AccessController.checkPermission(new ContextPermission(JCSystem.getClientURI(), "transfer"));
        }
        catch (AccessControlException e) {
            String pdName = JCSystem.getPDName(JCSystem.getClientURI());
            AccessController.checkPermission(new ContextPermission(pdName, "transfer"));
        }
        NativeMethods.transferOwnershipUsingStack(object);
    }

    private static String getPDName(String uri) {
        ApplicationBundleImpl appBImpl = null;
        Application app = Application.lookup(uri);
        appBImpl = (ApplicationBundleImpl)app.getApplicationGroup();
        if (appBImpl == null) assert (false) : "Error looking up current application.";
        ProtectionDomain pd = appBImpl.getJCContext().getProtectionDomain();
        return pd.getName();
    }

    public static void transferOwnership(Object object, Shareable sio) {
        if (object == null || sio == null) {
            throw new NullPointerException();
        }
        byte appId = NativeMethods.getObjectOwnerId(sio);
        if (appId == 0) {
            throw new SecurityException();
        }
        String appURI = JCSystemAccessor.getJCSystemAccessor().getURI(appId);
        AccessController.checkPermission(new ContextPermission(appURI, "transfer"));
        NativeMethods.transferOwnershipUsingSecondObject(object, sio);
    }

    public static void transferOwnership(Object object, String appURI) {
        if (object == null || appURI == null) {
            throw new NullPointerException();
        }
        if (URIUtils.hasScheme(appURI = URIUtils.normalize(appURI))) {
            throw new IllegalArgumentException("Not an app URI.");
        }
        Boolean checkWithAppURI = false;
        try {
            ProtectionDomain pd = JCSystemAccessor.getJCSystemAccessor().getPDForApp(appURI);
            Logger.debug("Protection Domain for app in JCSystem.transferOwnership is " + pd);
            AccessController.checkPermission(new ContextPermission("pd:" + pd.getName(), "transfer"));
        }
        catch (AccessControlException ace) {
            checkWithAppURI = true;
        }
        if (checkWithAppURI.booleanValue()) {
            AccessController.checkPermission(new ContextPermission(appURI, "transfer"));
        }
        int contextId = JCSystemAccessor.getJCSystemAccessor().getContextIdForAppURI(appURI);
        int appId = JCSystemAccessor.getJCSystemAccessor().getAppIdForAppURI(appURI);
        NativeMethods.transferOwnershiptoContext(object, contextId, appId);
    }

    public static <T> T copyTransferable(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!JCSystem.isTransferable(object)) {
            throw new IllegalArgumentException();
        }
        return NativeMethods.copyTransferable(object);
    }

    public static byte getCurrentTimeAccuracy() {
        return 3;
    }

    public static void synchronizeTime() {
    }

    private JCSystem() {
    }
}

