/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.tlv;

import com.sun.javacard.impl.NativeMethods;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.tlv.ConstructedBERTag;
import javacardx.framework.tlv.PrimitiveBERTag;
import javacardx.framework.tlv.TLVException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class BERTag {
    public static final byte BER_TAG_CLASS_MASK_UNIVERSAL = 0;
    public static final byte BER_TAG_CLASS_MASK_APPLICATION = 1;
    public static final byte BER_TAG_CLASS_MASK_CONTEXT_SPECIFIC = 2;
    public static final byte BER_TAG_CLASS_MASK_PRIVATE = 3;
    public static final boolean BER_TAG_TYPE_CONSTRUCTED = true;
    public static final boolean BER_TAG_TYPE_PRIMITIVE = false;
    private static final short MAX_TAG_SIZE_SUPPORTED = 3;
    private static final byte PRIMITIVE_TAG = 0;
    static final byte CONSTRUCTED_TAG = 32;
    static final byte MALFORMED_TAG_VALUE = -1;
    static final byte ILLEGAL_SIZE_VALUE = -2;
    static final byte MORE_BYTES_CHECK = -128;
    static final byte MORE_THAN_ONE_BYTE_TAG_MASK = 31;
    static final byte TAG_MASK = 127;
    static final byte TAG_CLASS_MASK = 3;
    static final byte TAG_CLASS_SHIFT = 6;
    static final short ONE_BYTE_TAG_MAX = 30;
    static final short TWO_BYTE_TAG_MAX = 127;
    static final short THREE_BYTE_TAG_MAX = 16383;
    static final byte TAG_BYTE_ONE = 1;
    static final byte TAG_BYTE_TWO = 2;
    static final byte TAG_BYTE_THREE = 3;
    private short tagNumber;
    private byte tagClass;
    private byte tagSizeInBytes;
    boolean tagPC;
    private boolean emptyTag = true;

    protected BERTag() {
    }

    public abstract void init(byte[] var1, short var2) throws TLVException;

    public static BERTag getInstance(byte[] bArray, short bOff) throws TLVException {
        BERTag instance = null;
        if (BERTag.verifyFormatInternal(bArray, bOff) == -1) {
            TLVException.throwIt((short)5);
        }
        if ((0x20 & bArray[bOff]) != 0) {
            instance = new ConstructedBERTag();
            instance.init(bArray, bOff);
        } else {
            instance = new PrimitiveBERTag();
            instance.init(bArray, bOff);
        }
        return instance;
    }

    public byte size() throws TLVException {
        if (this.emptyTag) {
            TLVException.throwIt((short)3);
        }
        return this.tagSizeInBytes;
    }

    public short toBytes(byte[] outBuf, short bOffset) throws TLVException {
        if (this.emptyTag) {
            TLVException.throwIt((short)3);
        }
        NativeMethods.checkArrayArgs(outBuf, bOffset, this.tagSizeInBytes);
        outBuf[bOffset] = (byte)(this.tagClass << 6);
        if (this.tagPC) {
            short s = bOffset;
            outBuf[s] = (byte)(outBuf[s] | 0x20);
        }
        switch (this.tagSizeInBytes) {
            case 1: {
                short s = bOffset;
                outBuf[s] = (byte)(outBuf[s] | (byte)this.tagNumber);
                break;
            }
            case 2: {
                short s = bOffset;
                outBuf[s] = (byte)(outBuf[s] | 0x1F);
                outBuf[(short)(bOffset + 1)] = (byte)this.tagNumber;
                break;
            }
            case 3: {
                short s = bOffset;
                outBuf[s] = (byte)(outBuf[s] | 0x1F);
                outBuf[(short)(bOffset + 1)] = (byte)(this.tagNumber >> 7 & 0x7F | 0xFFFFFF80);
                outBuf[(short)(bOffset + 2)] = (byte)(this.tagNumber & 0x7F);
                break;
            }
            default: {
                TLVException.throwIt((short)2);
            }
        }
        return this.tagSizeInBytes;
    }

    public short tagNumber() throws TLVException {
        if (this.emptyTag) {
            TLVException.throwIt((short)3);
        }
        return this.tagNumber;
    }

    public boolean isConstructed() {
        if (this.emptyTag) {
            TLVException.throwIt((short)3);
        }
        return this.tagPC;
    }

    public byte tagClass() {
        if (this.emptyTag) {
            TLVException.throwIt((short)3);
        }
        return this.tagClass;
    }

    public boolean equals(BERTag otherTag) {
        if (otherTag == null) {
            return false;
        }
        return otherTag.tagClass == this.tagClass && otherTag.tagPC == this.tagPC && otherTag.tagNumber == this.tagNumber;
    }

    public static short toBytes(short tagClass, boolean isConstructed, short tagNumber, byte[] outArray, short bOff) {
        short thisTagSizeInBytes = 0;
        if (tagClass < 0 || tagClass > 3 || tagNumber < 0) {
            TLVException.throwIt((short)1);
        }
        if (tagNumber <= 30) {
            NativeMethods.checkArrayArgs(outArray, bOff, (short)1);
            thisTagSizeInBytes = 1;
            outArray[bOff] = (byte)tagNumber;
        } else if (tagNumber <= 127) {
            NativeMethods.checkArrayArgs(outArray, bOff, (short)2);
            thisTagSizeInBytes = 2;
            outArray[bOff] = 31;
            outArray[(short)(bOff + 1)] = (byte)tagNumber;
        } else if (tagNumber <= 16383) {
            NativeMethods.checkArrayArgs(outArray, bOff, (short)3);
            thisTagSizeInBytes = 3;
            outArray[bOff] = 31;
            outArray[(short)(bOff + 1)] = (byte)(tagNumber >> 7 & 0x7F | 0xFFFFFF80);
            outArray[(short)(bOff + 2)] = (byte)(tagNumber & 0x7F);
        } else {
            TLVException.throwIt((short)2);
        }
        short s = bOff;
        outArray[s] = (byte)(outArray[s] | (byte)((byte)tagClass << 6));
        if (isConstructed) {
            short s2 = bOff;
            outArray[s2] = (byte)(outArray[s2] | 0x20);
        }
        return thisTagSizeInBytes;
    }

    public static byte size(byte[] berTagArray, short bOff) throws TLVException {
        short tempNumber = BERTag.verifyFormatInternal(berTagArray, bOff);
        if (tempNumber == -1) {
            TLVException.throwIt((short)5);
        } else if (tempNumber == -2) {
            TLVException.throwIt((short)2);
        }
        return (byte)BERTag.getTagSize(tempNumber);
    }

    public static short tagNumber(byte[] berTagArray, short bOff) throws TLVException {
        short tempNumber = BERTag.verifyFormatInternal(berTagArray, bOff);
        if (tempNumber == -1) {
            TLVException.throwIt((short)5);
        } else if (tempNumber == -2) {
            TLVException.throwIt((short)2);
        }
        return tempNumber;
    }

    public static boolean isConstructed(byte[] berTagArray, short bOff) {
        short tempNumber = BERTag.verifyFormatInternal(berTagArray, bOff);
        if (tempNumber == -1) {
            TLVException.throwIt((short)5);
        }
        return (0x20 & berTagArray[bOff]) != 0;
    }

    public static byte tagClass(byte[] berTagArray, short bOff) {
        short tempNumber = BERTag.verifyFormatInternal(berTagArray, bOff);
        if (tempNumber == -1) {
            TLVException.throwIt((short)5);
        } else if (tempNumber == -2) {
            TLVException.throwIt((short)2);
        }
        return (byte)(berTagArray[bOff] >> 6 & 3);
    }

    public static boolean verifyFormat(byte[] berTagArray, short bOff) {
        return BERTag.verifyFormatInternal(berTagArray, bOff) >= 0;
    }

    static short verifyFormatInternal(byte[] bArray, short bOff) throws TLVException {
        short tNumber;
        NativeMethods.checkArrayArgs(bArray, bOff, (short)1);
        if ((bArray[bOff] & 0x1F) == 31) {
            NativeMethods.checkArrayArgs(bArray, bOff, (short)2);
            if ((bArray[(short)(bOff + 1)] & 0xFFFFFF80) != 0) {
                NativeMethods.checkArrayArgs(bArray, bOff, (short)3);
                if ((bArray[(short)(bOff + 2)] & 0xFFFFFF80) != 0) {
                    return -2;
                }
                tNumber = (short)((bArray[(short)(bOff + 1)] & 0x7F) << 7);
                if ((tNumber = (short)(tNumber | (short)(bArray[(short)(bOff + 2)] & 0x7F))) <= 127) {
                    return -1;
                }
            } else {
                tNumber = (short)(bArray[(short)(bOff + 1)] & 0x7F);
                if (tNumber <= 30) {
                    return -1;
                }
            }
        } else {
            tNumber = (short)(bArray[bOff] & 0x1F);
        }
        return tNumber;
    }

    static short getTagSize(short tagNum) throws TLVException {
        int tagSize = 0;
        if (tagNum <= 30) {
            tagSize = 1;
        } else if (tagNum <= 127) {
            tagSize = 2;
        } else if (tagNum <= 16383) {
            tagSize = 3;
        } else {
            TLVException.throwIt((short)2);
        }
        return (short)tagSize;
    }

    void sharedInit(byte tagClassIn, short tagNumberIn) throws TLVException {
        if (tagClassIn < 0 || tagClassIn > 3) {
            TLVException.throwIt((short)1);
        }
        this.tagSizeInBytes = (byte)BERTag.getTagSize(tagNumberIn);
        this.tagClass = tagClassIn;
        this.tagNumber = tagNumberIn;
        this.emptyTag = false;
    }
}

