/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class View
extends AbstractBuffer {
    Buffer buffer;

    public View(Buffer buffer, int mark, int get, int put, int access) {
        super(2, !buffer.isImmutable());
        this.buffer = buffer.buffer();
        this.setPutIndex(put);
        this.setGetIndex(get);
        this.setMarkIndex(mark);
        this.accessType = access;
    }

    public View(Buffer buffer) {
        super(2, !buffer.isImmutable());
        this.buffer = buffer.buffer();
        this.setPutIndex(buffer.getWriteIndex());
        this.setGetIndex(buffer.getReadIndex());
        this.setMarkIndex(buffer.getMarkIndex());
        this.accessType = buffer.isReadOnly() ? 1 : 2;
    }

    public View() {
        super(2, true);
    }

    public void update(Buffer buffer) {
        this.accessType = 2;
        this.buffer = buffer.buffer();
        this.setGetIndex(0);
        this.setPutIndex(buffer.getWriteIndex());
        this.setGetIndex(buffer.getReadIndex());
        this.setMarkIndex(buffer.getMarkIndex());
        this.accessType = buffer.isReadOnly() ? 1 : 2;
    }

    public void update(int get, int put) {
        int a = this.accessType;
        this.accessType = 2;
        this.setGetIndex(0);
        this.setPutIndex(put);
        this.setGetIndex(get);
        this.setMarkIndex(-1);
        this.accessType = a;
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public Buffer buffer() {
        return this.buffer.buffer();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public void clear() {
        this.setMarkIndex(-1);
        this.setGetIndex(0);
        this.setPutIndex(this.buffer.getReadIndex());
        this.setGetIndex(this.buffer.getReadIndex());
    }

    @Override
    public void compact() {
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0 || super.equals(arg0);
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    public byte peek(int index) {
        return this.buffer.peek(index);
    }

    @Override
    public int peek(int index, byte[] b, int offset, int length) {
        return this.buffer.peek(index, b, offset, length);
    }

    @Override
    public Buffer peek(int index, int length) {
        return this.buffer.peek(index, length);
    }

    @Override
    public int poke(int index, Buffer src) {
        return this.buffer.poke(index, src);
    }

    @Override
    public void poke(int index, byte b) {
        this.buffer.poke(index, b);
    }

    @Override
    public int poke(int index, byte[] b, int offset, int length) {
        return this.buffer.poke(index, b, offset, length);
    }

    @Override
    public String toString() {
        if (this.buffer == null) {
            return "INVALID";
        }
        return super.toString();
    }
}

