/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import com.sun.javacard.impl.CommandLineOptions;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class WebServer
extends HandlerWrapper {
    public static final int MAX_FORM_CONTENT_SIZE = 262144;
    public static final String NAME_HEADER = "Server: Java Card 3.0\r\n";
    private static final WebServer webServer = new WebServer();
    private ThreadPool threadPool;
    private LazyList<WebConnector> connectors;
    private TransientReference<Vector<WebConnector>> dynamicConnectors = new TransientReference<Object>(null);
    private LazyList<UserRealm> realms;
    private SessionIdManager sessionIdManager;
    private WebConnector defaultHttpConnector = new SocketConnector();
    private String hostName;

    public static WebServer getWebServer() {
        return webServer;
    }

    private WebServer() {
        this.defaultHttpConnector.setPort(CommandLineOptions.getHttpPort());
        this.addConnector(this.defaultHttpConnector);
        ContextManager.initContextManager();
        MimeTypes.initMimeTypes();
        SecurityHandler.initSecurityHandler();
        this.threadPool = new BoundedThreadPool();
        NativeMethods.setJCREentry(this.threadPool, false);
        this.sessionIdManager = new HashSessionIdManager();
        NativeMethods.setJCREentry(this.sessionIdManager, false);
    }

    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = ((SocketConnector)this.defaultHttpConnector).getLocalHostAddress();
            }
            catch (Exception ex) {
                this.hostName = this.isStarted() ? "localhost" : null;
            }
        }
        return this.hostName;
    }

    public LazyList<WebConnector> getConnectors() {
        return this.connectors;
    }

    public void addConnector(WebConnector connector) {
        this.setConnectors(LazyList.add(this.getConnectors(), connector));
    }

    public void addDynamicConnector(WebConnector connector) {
        Vector<WebConnector> v = null;
        v = this.dynamicConnectors.get();
        if (v == null) {
            v = new Vector();
            this.dynamicConnectors.set(v);
        }
        v.addElement(connector);
    }

    public void removeConnector(WebConnector connector) {
        this.setConnectors(LazyList.remove(this.getConnectors(), connector));
    }

    public void setConnectors(LazyList<WebConnector> connectors) {
        this.connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void reset() {
        this.threadPool.reset();
        Logger.info("    Resetting Thread Pool ... Done");
        for (WebConnector connector : this.connectors) {
            connector.reset();
            Logger.info("    Restarting Web Connectors ... Done");
        }
    }

    @Override
    protected void doStart() throws Exception {
        Logger.debug("In org.mortbay.jetty.Server.doStart()");
        MultiException mex = new MultiException();
        if (this.sessionIdManager != null) {
            this.sessionIdManager.start();
        }
        try {
            if (this.threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this.threadPool)).start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            e.printStackTrace();
            mex.add(e);
        }
        if (this.connectors != null) {
            for (WebConnector element : this.connectors) {
                try {
                    element.start();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this.connectors != null) {
            for (WebConnector c : this.connectors) {
                try {
                    c.stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (this.sessionIdManager != null) {
            this.sessionIdManager.stop();
        }
        try {
            if (this.threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this.threadPool)).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        this.handle(target, connection.getRequest(), connection.getResponse(), 1);
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public LazyList<UserRealm> getUserRealms() {
        return this.realms;
    }

    public void setUserRealms(LazyList<UserRealm> realms) {
        this.realms = realms;
    }

    public UserRealm getUserRealmForName(String realmName) {
        if (this.realms == null) {
            return null;
        }
        for (int i = 0; i < LazyList.size(this.realms); ++i) {
            if (LazyList.get(this.realms, i) == null || !realmName.equals(LazyList.get(this.realms, i).getName())) continue;
            return LazyList.get(this.realms, i);
        }
        return null;
    }

    public void addUserRealm(UserRealm realm) {
        this.setUserRealms(LazyList.add(this.getUserRealms(), realm));
    }

    public void removeUserRealm(UserRealm realm) {
        this.setUserRealms(LazyList.remove(this.getUserRealms(), realm));
    }

    public SessionIdManager getSessionIdManager() {
        return this.sessionIdManager;
    }

    @Override
    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler(handler);
        } else if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).addHandler(handler);
        } else {
            HandlerCollection collection = new HandlerCollection();
            collection.setHandlers(LazyList.array2List(new Handler[]{this.getHandler(), handler}));
            this.setHandler(collection);
        }
    }

    public void removeHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).removeHandler(handler);
            try {
                handler.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public LazyList<Handler> getHandlers() {
        if (this.getHandler() instanceof HandlerCollection) {
            return ((HandlerCollection)this.getHandler()).getHandlers();
        }
        return null;
    }

    public void setHandlers(LazyList<Handler> handlers) {
        HandlerCollection collection;
        if (this.getHandler() instanceof HandlerCollection) {
            collection = (HandlerCollection)this.getHandler();
        } else {
            collection = new HandlerCollection();
            this.setHandler(collection);
        }
        collection.setHandlers(handlers);
    }

    public void updateContextHandlerCollection() {
        LazyList<Handler> contextCollections = this.getChildHandlersByClass(ContextHandlerCollection.class);
        if (contextCollections != null) {
            for (Handler h : contextCollections) {
                ((ContextHandlerCollection)h).mapContexts();
            }
        }
    }

    public WebConnector getDefaultHttpConnector() {
        return this.defaultHttpConnector;
    }

    public void addHandler(String context, String webappRoot, ClassLoader appClassLoader, Hashtable<String, String> initParams, Hashtable<String, Object> attributes, int fwId, int appId) {
        NativeMethods.setJCREentry(appClassLoader, false);
        NativeMethods.switchContext(fwId, appId);
        try {
            WebAppContext wac = new WebAppContext(webappRoot, context, appClassLoader);
            if (initParams != null) {
                wac.setInitParams(initParams);
            }
            if (attributes != null) {
                Enumeration<String> names = attributes.keys();
                while (names.hasMoreElements()) {
                    String name = names.nextElement();
                    Object value = attributes.get(name);
                    wac.setAttribute(name, value);
                }
            }
            NativeMethods.switchContext(0, 0);
            this.addHandler(wac);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeHandler(String context) {
        if (!context.startsWith("/")) {
            context = "/" + context;
        } else if (context.startsWith("///")) {
            context = context.substring(2);
        }
        Logger.debug("Main.removeHandler() -> " + context);
        Logger.debug("Main.removeHandler() -> " + context);
        LazyList<Handler> handlers = this.getHandlers();
        Logger.debug("Main.removeHandler() -> handlers " + handlers);
        ContextHandler contextHandler = null;
        Handler toBeDeleted = null;
        if (handlers != null) {
            Logger.debug("Main.removeHandler() -> handlers count " + LazyList.size(handlers));
            for (Handler handler : handlers) {
                Logger.debug("Main.removeHandler() -> handler " + handler.getClass());
                if (!(handler instanceof ContextHandler) || !context.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                toBeDeleted = handler;
                break;
            }
            if (toBeDeleted != null) {
                this.removeHandler(toBeDeleted);
            }
        }
    }

    public ServletContext getContext(String uriPath, int currentFirewallConext) {
        ServletContext ctxt = this.getContext(uriPath);
        if (ctxt != null && currentFirewallConext != 0 && NativeMethods.objectContext(ctxt) != currentFirewallConext) {
            return null;
        }
        return ctxt;
    }

    public ServletContext getContext(String uripath) {
        ContextHandler context = null;
        LazyList<Handler> handlers = WebServer.getWebServer().getChildHandlersByClass(ContextHandler.class);
        for (Handler element : handlers) {
            ContextHandler ch;
            String context_path;
            if (element == null || !element.isStarted() || !uripath.equals(context_path = (ch = (ContextHandler)element).getContextPath()) && (!uripath.startsWith(context_path) || uripath.charAt(context_path.length()) != '/') || context != null && context_path.length() <= context.getContextPath().length()) continue;
            context = ch;
        }
        if (context != null) {
            return context.getContainedContext();
        }
        return null;
    }

    static {
        NativeMethods.setJCREentry(webServer, false);
    }
}

