/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    public static final int DISTANT_FUTURE = 628992000;
    int dftMaxIdleSecs = -1;
    protected boolean httpOnly = false;
    protected int maxSessions = 0;
    protected int minSessions = 0;
    int scavengePeriodMs = 30000;
    SessionIdManager sessionIdManager;
    private SessionHandler sessionHandler;
    Thread scavenger = null;
    protected boolean secureCookies = false;
    protected LazyList<EventListener> sessionAttributeListeners;
    protected LazyList<HttpSessionListener> sessionListeners;
    protected TransientReference<Hashtable<String, Session>> sessionsReference = new TransientReference<Object>(null);
    private boolean usingCookies = true;
    protected ClassLoader loader;
    protected ContextHandler.Context context;
    protected String sessionCookie;
    protected String sessionURL;
    protected String sessionURLPrefix;
    protected String sessionDomain;
    protected String sessionPath;
    protected int maxSessionCookieAge = Integer.parseInt("-1");
    protected boolean maxAgeSet = false;

    @Override
    public void setSessionCookie(String cookieName) {
        this.sessionCookie = cookieName;
    }

    @Override
    public String getSessionCookie() {
        return this.sessionCookie;
    }

    @Override
    public void setSessionURL(String url) {
        this.sessionURL = url;
    }

    @Override
    public String getSessionURL() {
        return this.sessionURL;
    }

    @Override
    public String getSessionURLPrefix() {
        return this.sessionURLPrefix;
    }

    @Override
    public void setSessionDomain(String domain) {
        this.sessionDomain = domain;
    }

    @Override
    public String getSessionDomain() {
        return this.sessionDomain;
    }

    @Override
    public void setSessionPath(String path) {
        this.sessionPath = path;
    }

    @Override
    public String getSessionPath() {
        return this.sessionPath;
    }

    @Override
    public void setMaxSessionCookieAge(int maxCookieAge) {
        this.maxSessionCookieAge = maxCookieAge;
        this.maxAgeSet = true;
    }

    @Override
    public int getMaxCookieAge() {
        return this.maxSessionCookieAge;
    }

    @Override
    public void clearEventListeners() {
        this.sessionAttributeListeners = null;
        this.sessionListeners = null;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this.sessionAttributeListeners = LazyList.add(this.sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this.sessionListeners = LazyList.add(this.sessionListeners, (HttpSessionListener)listener);
        }
    }

    @Override
    public SessionIdManager getMetaManager() {
        return this.sessionIdManager;
    }

    @Override
    public void setMetaManager(SessionIdManager metaManager) {
        this.sessionIdManager = metaManager;
    }

    @Override
    public boolean getHttpOnly() {
        return this.httpOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSession(String id) {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            Hashtable<String, Session> sessions = this.sessionsReference.get();
            if (sessions == null) {
                sessions = new Hashtable();
                this.sessionsReference.set(sessions);
            }
            return sessions.get(id);
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.dftMaxIdleSecs;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public int getScavengePeriod() {
        return this.scavengePeriodMs / 1000;
    }

    @Override
    public boolean getSecureCookies() {
        return this.secureCookies;
    }

    @Override
    public Cookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            Cookie cookie = this.getHttpOnly() ? new HttpOnlyCookie(this.sessionCookie, session.getId()) : new Cookie(this.sessionCookie, session.getId());
            cookie.setPath(contextPath == null || contextPath.length() == 0 ? "/" : contextPath);
            cookie.setMaxAge(this.maxSessionCookieAge);
            cookie.setSecure(requestIsSecure && this.getSecureCookies());
            if (this.sessionDomain != null) {
                cookie.setDomain(this.sessionDomain);
            }
            if (this.sessionPath != null) {
                cookie.setPath(this.sessionPath);
            }
            return cookie;
        }
        return null;
    }

    public Hashtable<String, Session> getSessionMap() {
        Hashtable<String, Session> sessions = this.sessionsReference.get();
        if (sessions == null) {
            sessions = new Hashtable();
            this.sessionsReference.set(sessions);
        }
        return sessions;
    }

    public int getSessions() {
        Hashtable<String, Session> sessions = this.sessionsReference.get();
        if (sessions == null) {
            sessions = new Hashtable();
            this.sessionsReference.set(sessions);
        }
        return sessions.size();
    }

    public boolean isUsingCookies() {
        return this.usingCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this.dftMaxIdleSecs);
        SessionIdManager sessionIdManager = this.sessionIdManager;
        synchronized (sessionIdManager) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                Hashtable<String, Session> sessions = this.sessionsReference.get();
                if (sessions == null) {
                    sessions = new Hashtable();
                    this.sessionsReference.set(sessions);
                }
                sessions.put(session.getId(), session);
                this.sessionIdManager.addSession(session);
                if (sessions.size() > this.maxSessions) {
                    this.maxSessions = sessions.size();
                }
            }
        }
        HttpSessionEvent event = new HttpSessionEvent(session);
        for (int i = 0; i < LazyList.size(this.sessionListeners); ++i) {
            LazyList.get(this.sessionListeners, i).sessionCreated(event);
        }
        return session;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this.sessionAttributeListeners = LazyList.remove(this.sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this.sessionListeners = LazyList.remove(this.sessionListeners, (HttpSessionListener)listener);
        }
    }

    public void resetStats() {
        Hashtable<String, Session> sessions = this.sessionsReference.get();
        if (sessions == null) {
            sessions = new Hashtable();
            this.sessionsReference.set(sessions);
        }
        this.minSessions = sessions.size();
        this.maxSessions = sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scavenge() {
        ClassLoader old_loader = ClassLoader.getCurrentClassLoader();
        try {
            if (this.loader != null) {
                ClassLoader.setCurrentClassLoader(this.loader);
            }
            long now = System.currentTimeMillis();
            LazyList<Session> stale = null;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                Hashtable<String, Session> sessions = this.sessionsReference.get();
                if (sessions == null) {
                    sessions = new Hashtable();
                    this.sessionsReference.set(sessions);
                }
                Enumeration<Session> i = sessions.elements();
                while (i.hasMoreElements()) {
                    Session session = i.nextElement();
                    long idleTime = session.maxIdleMs;
                    if (idleTime <= 0L || session.accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                int nbsess;
                Session session = (Session)LazyList.get(stale, i);
                long idleTime = session.maxIdleMs;
                if (idleTime <= 0L || session.accessed + idleTime >= System.currentTimeMillis()) continue;
                try {
                    session.invalidate();
                }
                catch (Throwable th) {
                    this.context.getContextHandler().setUnavailable(true);
                }
                Hashtable<String, Session> sessions = this.sessionsReference.get();
                if (sessions == null) {
                    sessions = new Hashtable();
                    this.sessionsReference.set(sessions);
                }
                if ((nbsess = sessions.size()) >= this.minSessions) continue;
                this.minSessions = nbsess;
            }
        }
        finally {
            ClassLoader.setCurrentClassLoader(old_loader);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this.dftMaxIdleSecs = seconds;
        if (this.dftMaxIdleSecs > 0 && this.scavengePeriodMs > this.dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this.dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this.scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this.scavengePeriodMs = period;
                if (this.scavenger != null) {
                    JCSystemAccessor.getJCSystemAccessor().interruptThread(this.scavenger);
                }
            }
        }
    }

    public void setSecureCookies(boolean secureCookies) {
        this.secureCookies = secureCookies;
    }

    public void setUsingCookies(boolean usingCookies) {
        this.usingCookies = usingCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        String str;
        this.context = ContextManager.getCurrentContext();
        this.loader = ClassLoader.getCurrentClassLoader();
        Hashtable<String, Session> sessions = this.sessionsReference.get();
        if (sessions == null) {
            sessions = new Hashtable();
            this.sessionsReference.set(sessions);
        }
        if (this.sessionIdManager == null) {
            WebServer server;
            WebServer webServer = server = WebServer.getWebServer();
            synchronized (webServer) {
                this.sessionIdManager = server.getSessionIdManager();
            }
        }
        if (!this.sessionIdManager.isStarted()) {
            this.sessionIdManager.start();
        }
        if (this.sessionCookie == null) {
            str = null;
            if (this.context != null) {
                str = this.context.getInitParameter("org.mortbay.jetty.servlet.SessionCookie");
            }
            String string = this.sessionCookie = str == null ? SessionManager.SESSION_COOKIE_SYSTEM_PROPERTY : str;
        }
        if (this.sessionURL == null) {
            str = null;
            if (this.context != null) {
                str = this.context.getInitParameter("org.mortbay.jetty.servlet.SessionURL");
            }
            this.sessionURL = str == null ? SessionManager.SESSION_URL_SYSTEM_PROPERTY : str;
        }
        this.sessionURLPrefix = ";" + this.sessionURL + "=";
        if (!this.maxAgeSet) {
            str = null;
            if (this.context != null) {
                str = this.context.getInitParameter("org.mortbay.jetty.servlet.MaxAge");
            }
            str = str == null ? SessionManager.MAX_AGE_SYSTEM_PROPERTY : str;
            this.maxSessionCookieAge = Integer.parseInt(str.trim());
            this.maxAgeSet = true;
        }
        if (this.sessionDomain == null && this.context != null) {
            this.sessionDomain = this.context.getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
        }
        if (this.sessionPath == null && this.context != null) {
            this.sessionPath = this.context.getInitParameter("org.mortbay.jetty.servlet.SessionPath");
        }
        super.doStart();
        WebServer.getWebServer().getThreadPool().dispatch(new SessionScavenger());
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        Vector<Session> sessions = new Vector<Session>();
        if (this.sessionsReference.get() == null) {
            this.sessionsReference.set(new Hashtable());
        }
        Enumeration<Session> en = this.sessionsReference.get().elements();
        while (en.hasMoreElements()) {
            sessions.addElement(en.nextElement());
        }
        for (Session session : sessions) {
            session.invalidate();
        }
        this.sessionsReference.get().clear();
        this.scavenger = null;
        if (this.scavenger != null) {
            this.scavenger.interrupt();
        }
        this.loader = null;
        this.context = null;
    }

    @Override
    public void access(HttpSession session) {
        ((Session)session).access();
    }

    @Override
    public void complete(HttpSession session) {
    }

    @Override
    public boolean isValid(HttpSession session) {
        return ((Session)session).isValid();
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    class SessionScavenger
    implements Runnable {
        SessionScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String exit;
            AbstractSessionManager.this.scavenger = Thread.currentThread();
            int period = -1;
            try {
                do {
                    if (!AbstractSessionManager.this.isStarting() && !AbstractSessionManager.this.isStarted()) continue;
                    try {
                        if (period != AbstractSessionManager.this.scavengePeriodMs) {
                            period = AbstractSessionManager.this.scavengePeriodMs;
                        }
                        Thread.sleep(period > 1000 ? (long)period : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        Logger.debug(e);
                    }
                    catch (Exception e) {
                        Logger.debug(e);
                    }
                } while (AbstractSessionManager.this.isStarted());
                AbstractSessionManager.this.scavenger = null;
                exit = "Session scavenger exited";
            }
            catch (Throwable throwable) {
                AbstractSessionManager.this.scavenger = null;
                String exit2 = "Session scavenger exited";
                Logger.debug("******************" + exit2 + " ... context is " + NativeMethods.getCurrentContext() + "******" + " appId is " + NativeMethods.getCurrentAppId());
                if (AbstractSessionManager.this.isStarted()) {
                    Logger.debug(exit2);
                } else {
                    Logger.debug(exit2);
                }
                throw throwable;
            }
            Logger.debug("******************" + exit + " ... context is " + NativeMethods.getCurrentContext() + "******" + " appId is " + NativeMethods.getCurrentAppId());
            if (AbstractSessionManager.this.isStarted()) {
                Logger.debug(exit);
            } else {
                Logger.debug(exit);
            }
        }
    }

    public abstract class Session
    implements HttpSession {
        long created;
        long accessed;
        String id;
        boolean invalid;
        long maxIdleMs;
        boolean newSession;
        Hashtable<String, Object> values;
        private boolean _isSessionAuthorized;

        protected Session(HttpServletRequest request) {
            this.accessed = this.created = System.currentTimeMillis();
            this.invalid = false;
            this.maxIdleMs = AbstractSessionManager.this.dftMaxIdleSecs * 1000;
            this.newSession = true;
            this._isSessionAuthorized = false;
            this.id = AbstractSessionManager.this.sessionIdManager.newSessionId(request, this.created);
            if (AbstractSessionManager.this.dftMaxIdleSecs >= 0) {
                this.maxIdleMs = AbstractSessionManager.this.dftMaxIdleSecs * 1000;
            }
        }

        void access() {
            this.newSession = false;
            this.accessed = System.currentTimeMillis();
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name));
            }
        }

        @Override
        public synchronized Object getAttribute(String name) {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }

        @Override
        public synchronized Enumeration<String> getAttributeNames() {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            Vector<String> names = new Vector<String>();
            if (this.values != null) {
                Enumeration<String> en = this.values.keys();
                while (en.hasMoreElements()) {
                    names.addElement(en.nextElement());
                }
            }
            return names.elements();
        }

        @Override
        public long getCreationTime() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.created;
        }

        @Override
        public String getId() throws IllegalStateException {
            return this.id;
        }

        @Override
        public long getLastAccessedTime() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.accessed;
        }

        @Override
        public int getMaxInactiveInterval() {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return (int)(this.maxIdleMs / 1000L);
        }

        @Override
        public ServletContext getServletContext() {
            return AbstractSessionManager.this.context;
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() throws IllegalStateException {
            Object object;
            Logger.debug("Invalidating session now");
            try {
                Logger.debug("start:" + this.invalid);
                object = this;
                synchronized (object) {
                    if (this.invalid) {
                        throw new IllegalStateException();
                    }
                    Logger.debug("unbind listeners");
                    if (AbstractSessionManager.this.sessionListeners != null) {
                        HttpSessionEvent event = new HttpSessionEvent(this);
                        int i = LazyList.size(AbstractSessionManager.this.sessionListeners);
                        while (i-- > 0) {
                            Logger.debug("Session: HTTPSESSIONLISTENER being notified:" + LazyList.get(AbstractSessionManager.this.sessionListeners, i));
                            LazyList.get(AbstractSessionManager.this.sessionListeners, i).sessionDestroyed(event);
                        }
                    }
                    Logger.debug("unbind values");
                    if (this.values != null) {
                        Enumeration<String> iter = this.values.keys();
                        while (iter.hasMoreElements()) {
                            String key = iter.nextElement();
                            Object value = this.values.get(key);
                            this.unbindValue(key, value);
                            if (AbstractSessionManager.this.sessionAttributeListeners == null) continue;
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, key, value);
                            for (int i = 0; i < LazyList.size(AbstractSessionManager.this.sessionAttributeListeners); ++i) {
                                ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this.sessionAttributeListeners, i)).attributeRemoved(event);
                            }
                        }
                        this.values.clear();
                        Logger.debug("_values cleared");
                    }
                }
                object = AbstractSessionManager.this.sessionIdManager;
            }
            catch (Throwable throwable) {
                SessionIdManager sessionIdManager = AbstractSessionManager.this.sessionIdManager;
                synchronized (sessionIdManager) {
                    Logger.debug("Remove session from context and global maps" + this.getId());
                    String id = this.getId();
                    TransientReference<Hashtable<String, Session>> transientReference = AbstractSessionManager.this.sessionsReference;
                    synchronized (transientReference) {
                        this.invalid = true;
                        AbstractSessionManager.this.sessionsReference.get().remove(id);
                        Logger.debug("get removed session" + AbstractSessionManager.this.sessionsReference.get().get(id));
                    }
                    AbstractSessionManager.this.sessionIdManager.invalidateAll(id);
                }
                throw throwable;
            }
            synchronized (object) {
                Logger.debug("Remove session from context and global maps" + this.getId());
                String id = this.getId();
                TransientReference<Hashtable<String, Session>> transientReference = AbstractSessionManager.this.sessionsReference;
                synchronized (transientReference) {
                    this.invalid = true;
                    AbstractSessionManager.this.sessionsReference.get().remove(id);
                    Logger.debug("get removed session" + AbstractSessionManager.this.sessionsReference.get().get(id));
                }
                AbstractSessionManager.this.sessionIdManager.invalidateAll(id);
            }
        }

        @Override
        public boolean isNew() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.newSession;
        }

        boolean isValid() {
            return !this.invalid;
        }

        protected abstract Hashtable<String, Object> newAttributeMap();

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        @Override
        public synchronized void removeAttribute(String name) {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            if (this.values == null) {
                return;
            }
            Object old = this.values.remove(name);
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this.sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, old);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this.sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this.sessionAttributeListeners, i)).attributeRemoved(event);
                    }
                }
            }
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        @Override
        public synchronized void setAttribute(String name, Object value) {
            Object oldValue;
            if (value == null) {
                this.removeAttribute(name);
                return;
            }
            if (this.invalid) {
                throw new IllegalStateException();
            }
            if (this.values == null) {
                this.values = this.newAttributeMap();
            }
            if (!value.equals(oldValue = this.values.put(name, value))) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
                if (AbstractSessionManager.this.sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, oldValue == null ? value : oldValue);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this.sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this.sessionAttributeListeners, i);
                        if (oldValue == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        if (value == null) {
                            l.attributeRemoved(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        @Override
        public void setMaxInactiveInterval(int secs) {
            this.maxIdleMs = (long)secs * 1000L;
            if (this.maxIdleMs > 0L && this.maxIdleMs / 10L < (long)AbstractSessionManager.this.scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(this, name));
            }
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }

        public void setSessionAuthorized(boolean isAuthorized) {
            this._isSessionAuthorized = isAuthorized;
        }

        public boolean isSessionAuthorized() {
            return this._isSessionAuthorized;
        }
    }
}

