/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClient;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.TLP224Exception;
import java.io.IOException;

public class ClientT0Protocol
extends ClientProtocol {
    private Apdu getResponseApdu;
    protected boolean auto61xx;

    public ClientT0Protocol(CadClient cad) {
        this.cad = cad;
        this.getResponseApdu = new Apdu();
        this.auto61xx = true;
    }

    public void exchangeApdu(Apdu apdu) throws IOException, TLP224Exception {
        int[] lengths = new int[2];
        block0 : switch (apdu.getCase()) {
            case 1: {
                int statusCode = this.cad.isoIn(apdu.command, null, 0, apdu.sw1sw2);
                if (statusCode == 0 || statusCode == 231) break;
                throw new TLP224Exception(statusCode);
            }
            case 2: {
                int maxOutput = apdu.Le == 0 ? 256 : apdu.Le;
                apdu.dataOut = new byte[maxOutput];
                lengths[0] = apdu.Le;
                int statusCode = this.cad.isoOut(apdu.command, apdu.dataOut, lengths, apdu.sw1sw2);
                if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                    throw new TLP224Exception(statusCode);
                }
                apdu.Le = lengths[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= maxOutput) {
                    this.getResponseApdu.command[0] = 0;
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    byte[] dataOut = new byte[Le];
                    lengths[0] = Le;
                    statusCode = this.cad.isoOut(this.getResponseApdu.command, dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            case 3: {
                int statusCode = this.cad.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (statusCode == 0 || statusCode == 231 || statusCode == 229) break;
                throw new TLP224Exception(statusCode);
            }
            case 4: {
                int statusCode = this.cad.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                    throw new TLP224Exception(statusCode);
                }
                int maxOutput = 256;
                apdu.dataOut = new byte[maxOutput];
                apdu.Le = 0;
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= maxOutput) {
                    this.getResponseApdu.command[0] = 0;
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    byte[] dataOut = new byte[Le];
                    lengths[0] = Le;
                    statusCode = this.cad.isoOut(this.getResponseApdu.command, dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            default: {
                throw new TLP224Exception(23);
            }
        }
    }

    public boolean getAuto61xx() {
        return this.auto61xx;
    }

    public void setAuto61xx(boolean state) {
        this.auto61xx = state;
    }
}

