/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassFieldsTable;
import com.sun.javacard.components.caputils.ClassFile;
import com.sun.javacard.components.caputils.ClassMethodTable;
import com.sun.javacard.converter.ConverterHarness;
import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AppletInfo;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CapProcessor {
    public static final String pathSep = File.separator;
    public static String pkgName;
    public static PackageInfo pkg;
    public static ExportFile ef;
    Hashtable<String, AppletInfo> applets = new Hashtable();
    String outputPath;

    public CapProcessor() {
        pkg = Cap.getHeader().thisPackage();
        ef = ImportComponent.findExportByAidAndVersion(pkg);
        pkgName = new String(Cap.getPackageDirectory());
    }

    public void processCap(String CAPFileName, String outputPath, Vector<File> exportFiles, String keepProxySourceDirectory) {
        String outFilePath = null;
        this.outputPath = outputPath;
        ClassDescriptor cdesc = Cap.getDescriptor().firstClassDescriptor();
        String clName = null;
        for (int i = Cap.getDescriptor().classCount(); i > 0; --i) {
            ClassFile cf = new ClassFile();
            int clToken = cdesc.token();
            clName = CAPUtil.getRefName(cdesc.thisClass());
            if (Cap.getApplet() != null && Cap.getApplet().isAppletClass(cdesc)) {
                AppletInfo applet = Cap.getApplet().getAppletInfoForClass(cdesc);
                this.applets.put(clName, applet);
            }
            EfClass exportedClass = null;
            if (ef != null) {
                exportedClass = ef.findClassByToken((short)clToken);
            }
            cf.setClassName(clName);
            ClassConstantPool classConstantPool = new ClassConstantPool(cdesc, clName, exportedClass);
            cf.setConstantPool(classConstantPool);
            cf.setAccessFlags(cdesc.flags());
            cf.setThisClass((short)classConstantPool.getThisClassIndex());
            cf.setSuperClass((short)classConstantPool.getSuperClassRefIndex());
            Vector<Integer> interfaces = classConstantPool.getInterfaceRefs();
            int interfaceCount = interfaces.size();
            cf.setInterfaceCount((short)interfaceCount);
            for (int j = 0; j < interfaceCount; ++j) {
                int interfaceRef = interfaces.elementAt(j);
                cf.setInterfaceEntry((short)interfaceRef);
            }
            cf.setMethodTable(new ClassMethodTable(classConstantPool, cdesc, exportedClass));
            cf.setFieldTable(new ClassFieldsTable(classConstantPool, cdesc, exportedClass));
            String classFileName = clName.substring(clName.lastIndexOf("/") + 1) + ".class";
            if (outFilePath == null) {
                outFilePath = outputPath + pathSep + pkgName;
            }
            String outFileName = outFilePath + pathSep + classFileName;
            try {
                File outFileDir = new File(outFilePath);
                if (!outFileDir.exists() && !outFileDir.mkdirs()) {
                    throw new IOException("File could not be created!");
                }
                File outputFile = new File(outFileName);
                FileOutputStream os = new FileOutputStream(outputFile);
                cf.write(os);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            cdesc.next();
        }
        String[] converterArgs = this.getConverterArgs(outputPath, CAPFileName, keepProxySourceDirectory);
        ConverterHarness.startConversion(converterArgs, this.getExportFilesHS(exportFiles));
    }

    private String[] getConverterArgs(String classPath, String CAPFileName, String keepProxySourceDirectory) {
        Vector<String> converterArgs = new Vector<String>();
        converterArgs.add("-classdir");
        converterArgs.add(classPath);
        converterArgs.add("-i");
        converterArgs.add("-out");
        converterArgs.add("NORMALIZED_CAP");
        converterArgs.add("-inputcap");
        converterArgs.add(CAPFileName);
        Enumeration<String> appletClassNames = this.applets.keys();
        while (appletClassNames.hasMoreElements()) {
            String appletClassName = appletClassNames.nextElement();
            String AIDStr = AID.prettyForHex(this.applets.get(appletClassName));
            converterArgs.add("-applet");
            converterArgs.add(AIDStr);
            appletClassName = appletClassName.replace('/', '.');
            converterArgs.add(appletClassName);
        }
        converterArgs.add("-d");
        converterArgs.add(this.outputPath);
        if (keepProxySourceDirectory != null) {
            converterArgs.add("-keepproxysource");
            converterArgs.add(keepProxySourceDirectory);
        }
        converterArgs.add(pkgName);
        converterArgs.add(AID.prettyForHex(pkg));
        converterArgs.add(pkg.majorVersion() + "." + pkg.minorVersion());
        String[] converterArgsArray = new String[converterArgs.size()];
        return converterArgs.toArray(converterArgsArray);
    }

    private Hashtable<String, File> getExportFilesHS(Vector<File> exportFiles) {
        Hashtable<String, File> exportFilesHS = new Hashtable<String, File>();
        for (File file : exportFiles) {
            Cap.getImport();
            ExportFile ef = ImportComponent.findExportByFileName(file.getPath());
            if (ef == null) continue;
            exportFilesHS.put(ef.thisName(), file);
        }
        return exportFilesHS;
    }
}

