/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLNode {
    public static final String JAVACARD_DEFAULT_XMLNS = "http://java.sun.com/xml/ns/javacard";
    public static final String WEB_DEFAULT_XMLNS = "http://java.sun.com/xml/ns/j2ee";
    public static final String SCHEMA_RESOURCE_PATH = "/com/sun/javacard/packager/schemas/";
    private static final Vector<String> EXCLUDE_ATTRIBUTES = new Vector<String>(){
        {
            this.addElement("xsi:schemaLocation");
            this.addElement("xmlns:xsi");
        }
    };
    private final PackageItem packageItem;
    private Node node;
    private String xmlString;
    private Hashtable<String, String> attributes;
    private ArrayList<XMLNode> allChildNodes;
    private Hashtable<String, ArrayList<XMLNode>> namedChildNodes;
    private Hashtable<String, XMLNode> singleChildNodes;
    private String cdata;
    private Document document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLNode(PackageItem packageItem, File file, String xsdName, String defaultXMLNS) throws Exception {
        this.packageItem = packageItem;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            this.document = documentBuilder.parse(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        this.node = this.document.getDocumentElement();
        String xmlNS = this.getAttribute("xmlns");
        if (xmlNS == null || xmlNS.trim().length() <= 0) {
            packageItem.addWarning(ErrorKey.MissingXmlsns, new Object[0]);
        }
        if (xmlNS != null && !defaultXMLNS.equals(xmlNS)) {
            packageItem.addError(ErrorKey.InvalidXmlsns, xmlNS);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new MyLSResourceResolver());
        Schema schema = schemaFactory.newSchema(new StreamSource(this.getClass().getResourceAsStream(SCHEMA_RESOURCE_PATH + xsdName)));
        schema.newValidator().validate(new DOMSource(this.document));
    }

    public XMLNode(PackageItem packageItem, Node node) {
        this.packageItem = packageItem;
        this.node = node;
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public String getTextValue() {
        if (this.node.getFirstChild() == null) {
            return null;
        }
        String result = this.node.getFirstChild().getNodeValue();
        return result == null ? "" : result.trim();
    }

    public XMLNode getChildNode(String name) {
        XMLNode cn;
        if (this.singleChildNodes == null) {
            this.singleChildNodes = new Hashtable();
        }
        if ((cn = this.singleChildNodes.get(name)) == null) {
            NodeList children = this.node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (!children.item(i).getNodeName().equals(name)) continue;
                cn = new XMLNode(this.packageItem, children.item(i));
                this.singleChildNodes.put(name, cn);
                break;
            }
        }
        return cn;
    }

    public ArrayList<XMLNode> getChildNodes(String name) {
        ArrayList<XMLNode> al;
        if (this.namedChildNodes == null) {
            this.namedChildNodes = new Hashtable();
        }
        if ((al = this.namedChildNodes.get(name)) == null) {
            al = new ArrayList();
            NodeList children = this.node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (!children.item(i).getNodeName().equals(name)) continue;
                al.add(new XMLNode(this.packageItem, children.item(i)));
            }
            this.namedChildNodes.put(name, al);
        }
        return al;
    }

    public ArrayList<XMLNode> getChildNodes() {
        if (this.allChildNodes == null) {
            this.allChildNodes = new ArrayList();
            NodeList children = this.node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 8) continue;
                this.allChildNodes.add(new XMLNode(this.packageItem, children.item(i)));
            }
        }
        return this.allChildNodes;
    }

    public Hashtable<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
            NamedNodeMap attrs = this.node.getAttributes();
            if (attrs != null) {
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    this.attributes.put(attrs.item(i).getNodeName(), attrs.item(i).getNodeValue());
                }
            }
        }
        return this.attributes;
    }

    public Integer getIntegerAttribute(String attributeName) {
        this.getAttributes();
        Integer ret = null;
        String val = this.getAttribute(attributeName);
        if (val != null && val.trim().length() > 0) {
            try {
                ret = new Integer(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public Boolean getBooleanAttribute(String attributeName) {
        this.getAttributes();
        Boolean ret = null;
        String val = this.getAttribute(attributeName);
        if (val != null && val.trim().length() > 0) {
            if (val.equalsIgnoreCase("yes")) {
                val = "true";
            } else if (val.equalsIgnoreCase("no")) {
                val = "false";
            }
            try {
                ret = val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public String getAttribute(String attributeName) {
        this.getAttributes();
        return this.attributes.get(attributeName);
    }

    public String getAttributeStrtingWith(String name) {
        this.getAttributes();
        ArrayList<String> keys = new ArrayList<String>(this.attributes.keySet());
        for (String key : keys) {
            if (!key.startsWith(name)) continue;
            return this.attributes.get(key);
        }
        return null;
    }

    public String getCDATA() {
        if (this.cdata == null) {
            Node cdataNode = null;
            NodeList children = this.node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 4) continue;
                cdataNode = n;
            }
            this.cdata = cdataNode == null ? "" : cdataNode.getNodeValue();
        }
        return this.cdata;
    }

    public String toString() {
        if (this.xmlString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.nodeToString(0));
            this.xmlString = sb.toString();
        }
        return this.xmlString;
    }

    private String nodeToString(int indent) {
        ArrayList<XMLNode> childNodes;
        StringBuffer sb = new StringBuffer();
        String nodeName = this.node.getNodeName();
        int colonIndex = nodeName.indexOf(58);
        if (colonIndex != -1) {
            nodeName = nodeName.substring(colonIndex + 1);
        }
        sb.append(StringUtils.indentString(indent)).append("<").append(nodeName);
        Hashtable<String, String> ht = this.getAttributes();
        boolean appendSpace = true;
        ArrayList<String> alNames = new ArrayList<String>(ht.keySet());
        Collections.sort(alNames);
        for (String attrName : alNames) {
            if (EXCLUDE_ATTRIBUTES.contains(attrName)) continue;
            String attrValue = ht.get(attrName);
            sb.append(appendSpace ? " " : "").append(attrName).append("=\"").append(attrValue).append("\"");
            appendSpace = true;
        }
        sb.append(">");
        if (this.getTextValue() != null) {
            sb.append(this.getTextValue().trim());
        }
        if ((childNodes = this.getChildNodes()).size() > 0) {
            sb.append('\n');
        }
        for (XMLNode xmlNode : childNodes) {
            sb.append(xmlNode.nodeToString(indent + 1));
        }
        sb.append(childNodes.size() > 0 ? StringUtils.indentString(indent) : "");
        sb.append("</").append(nodeName).append(">\n");
        return sb.toString();
    }

    class MyLSInput
    implements LSInput {
        private Reader characterStream;
        private InputStream byteStream;
        private String stringData;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String encoding;
        private boolean certifiedText;

        MyLSInput() {
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }
    }

    class MyLSResourceResolver
    implements LSResourceResolver {
        MyLSResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            String resourceName = systemId;
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                resourceName = systemId.substring(index + 1);
            }
            String resourcePath = XMLNode.SCHEMA_RESOURCE_PATH + resourceName;
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            MyLSInput ls = new MyLSInput();
            ls.setByteStream(is);
            ls.setSystemId(this.getClass().getResource(resourcePath).toString());
            return ls;
        }
    }

    public class SchemaLoader
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            String resourceName = systemId;
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                resourceName = systemId.substring(index + 1);
            }
            String resourcePath = XMLNode.SCHEMA_RESOURCE_PATH + resourceName;
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            return new InputSource(is);
        }
    }
}

