/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AbstrInterpError;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Checkcode;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

class MethodComponent
extends Safeptr {
    private TreeSet allMethods;

    MethodComponent(byte[] byArray) {
        super(byArray, "Method");
    }

    int handlerCount() {
        return this.u1(0);
    }

    ExnHandlerInfo exceptionHandler(int n) {
        return new ExnHandlerInfo(this.offset(1 + n * 8));
    }

    Safeptr methInfo() {
        return this.offset(1 + this.handlerCount() * 8);
    }

    MethodInfo methodInfo(int n) {
        return new MethodInfo(this.offset(n));
    }

    Safeptr methodCode(int n) {
        return this.offset(n);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("MethodComponent.100");
        }
        this.allMethods = new TreeSet();
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        int n = Cap.Descriptor.classCount();
        while (n > 0) {
            if ((classDescriptor.flags() & 0x40) == 0) {
                int n2 = 0;
                while (n2 < classDescriptor.methodCount()) {
                    MethodDescriptor methodDescriptor = classDescriptor.methodDescr(n2);
                    MethodInfo methodInfo = this.methodInfo(methodDescriptor.methodOffset());
                    try {
                        this.verifyMethod(classDescriptor, methodDescriptor, methodInfo);
                    }
                    catch (AbstrInterpError abstrInterpError) {
                        throw new AbstrInterpError("MethodComponent.1", methodDescriptor, methodInfo, abstrInterpError.getMessage(), abstrInterpError, classDescriptor);
                    }
                    catch (VerifierError verifierError) {
                        throw new VerifierError("MethodComponent.1", (Object)methodDescriptor, (Object)methodInfo, (Object)verifierError.getMessage());
                    }
                    ++n2;
                }
            }
            --n;
            classDescriptor.next();
        }
        this.verifyHandlers();
        this.verifyOverlap();
        this.allMethods = null;
    }

    private void verifyMethod(ClassDescriptor classDescriptor, MethodDescriptor methodDescriptor, MethodInfo methodInfo) {
        boolean bl;
        int n = methodInfo.flags();
        if ((n & 0xFFFFFFF3) != 0) {
            throw new VerifierError("MethodComponent.9", n);
        }
        boolean bl2 = (methodDescriptor.flags() & 0x40) != 0;
        boolean bl3 = bl = (n & 4) != 0;
        if (bl2 != bl) {
            throw new VerifierError("MethodComponent.2");
        }
        int n2 = (n & 8) == 0 ? 2 : 4;
        int n3 = methodDescriptor.bytecodeCount();
        if ((n & 8) != 0 && methodInfo.paddingExtended() != 0) {
            throw new VerifierError("MethodComponent.14");
        }
        methodInfo.offset(n2 + n3);
        int n4 = methodDescriptor.exnHandlerIndex();
        int n5 = methodDescriptor.exnHandlerCount();
        if (n5 == 0) {
            if (n4 != 0) {
                throw new VerifierError("MethodComponent.3");
            }
        } else if (n4 + n5 > this.handlerCount()) {
            throw new VerifierError("MethodComponent.4");
        }
        int n6 = methodInfo.ofs + n2;
        int n7 = n6 + n3;
        int n8 = 0;
        while (n8 < this.handlerCount()) {
            ExnHandlerInfo exnHandlerInfo = this.exceptionHandler(n8);
            if (exnHandlerInfo.startOffset() < n7 && exnHandlerInfo.endOffset() > n6 && (n8 < n4 || n8 >= n4 + n5)) {
                throw new VerifierError("MethodComponent.5");
            }
            ++n8;
        }
        if ((n & 4) == 0) {
            Checkcode.typecheck(classDescriptor, methodDescriptor, methodInfo);
        }
        if (!this.allMethods.add(new OffsetAndLength(methodInfo.ofs, n2 + n3))) {
            throw new VerifierError("MethodComponent.10", methodInfo.ofs);
        }
    }

    private void verifyHandlers() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.handlerCount()) {
            ExnHandlerInfo exnHandlerInfo = this.exceptionHandler(n2);
            if (exnHandlerInfo.handlerOffset() < n) {
                throw new VerifierError("MethodComponent.11");
            }
            n = exnHandlerInfo.handlerOffset();
            if (exnHandlerInfo.activeLength() == 0) {
                throw new VerifierError("MethodComponent.13", n2);
            }
            boolean bl = true;
            int n3 = n2 + 1;
            while (n3 < this.handlerCount()) {
                if (exnHandlerInfo.intersect(this.exceptionHandler(n3))) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (exnHandlerInfo.stopBit() != bl) {
                throw new VerifierError("MethodComponent.12", n2);
            }
            ++n2;
        }
    }

    private void verifyOverlap() {
        Safeptr safeptr = this.methInfo();
        Iterator iterator = this.allMethods.iterator();
        while (iterator.hasNext()) {
            OffsetAndLength offsetAndLength = (OffsetAndLength)iterator.next();
            if (offsetAndLength.offset < safeptr.ofs) {
                throw new VerifierError("MethodComponent.6", safeptr.ofs);
            }
            if (offsetAndLength.offset > safeptr.ofs) {
                throw new VerifierError("MethodComponent.7", safeptr.ofs);
            }
            safeptr.advance(offsetAndLength.length);
        }
        if (!safeptr.atComponentEnd()) {
            throw new VerifierError("MethodComponent.8");
        }
    }
}

