/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;

public class EfConstant_Package
extends EfConstantInfo {
    public short flags;
    int nameIndex;
    public short minorVersion;
    public short majorVersion;
    short AID_length;
    public byte[] AID;

    EfConstant_Package(ExportFile exportFile) {
        super(exportFile);
    }

    void read() throws IOException {
        this.flags = (short)this.ef.in.readUnsignedByte();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.minorVersion = (short)this.ef.in.readUnsignedByte();
        this.majorVersion = (short)this.ef.in.readUnsignedByte();
        this.AID_length = (short)this.ef.in.readUnsignedByte();
        this.AID = new byte[this.AID_length];
        this.ef.in.read(this.AID);
    }

    void validate() {
        this.ef.checkUtf8Index(this.nameIndex);
        String string = ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
        if (!EfNames.validPackageName(string)) {
            throw new VerifierError("EfConstant_Package.1", string);
        }
        if (this.AID_length < 5 || this.AID_length > 16) {
            throw new VerifierError("EfConstant_Package.2", this.AID_length);
        }
        if ((this.flags & 0xFFFFFFFE) != 0) {
            throw new VerifierError("EfConstant_Package.3", this.flags);
        }
    }

    void compareTo(EfConstant_Package efConstant_Package) {
        this.compareCommon(efConstant_Package);
    }

    void checkEquality(EfConstant_Package efConstant_Package) {
        if (this.flags != efConstant_Package.flags) {
            throw new VerifierError("RevisionError.36");
        }
        this.compareCommon(efConstant_Package);
    }

    void compareCommon(EfConstant_Package efConstant_Package) {
        if (this.AID_length != efConstant_Package.AID_length) {
            throw new VerifierError("RevisionError.1");
        }
        int n = 0;
        while (n < this.AID_length) {
            if (this.AID[n] != efConstant_Package.AID[n]) {
                throw new VerifierError("RevisionError.1");
            }
            ++n;
        }
    }
}

