/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcapiandbcprofiler;

import com.sun.javacard.jcapiandbcprofiler.ClassicCAPProcesssor;
import com.sun.javacard.jcapiandbcprofiler.CryptoAlgorithmInfo;
import com.sun.javacard.jcapiandbcprofiler.CryptoAlgorithmList;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolComponent;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.Contour;
import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.State;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.TypeInit;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.TypeNull;
import com.sun.javacard.offcardverifier.TypeRetaddr;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class CryptoCallAnalyzer {
    static ClassicCAPProcesssor ccp;
    private static final int REGULAR_METHOD = 0;
    private static final int INIT_METHOD = 1;
    private static final int INIT_METHOD_IN_INITIALIZER = 2;
    private static Type actualSelfType;
    private static Type methodResultType;
    private static TypeClass currentClass;
    private static int methodInitStatus;
    static boolean printTrace;
    private static Hashtable<State, State> seenStates;
    private static Stack<State> pendingStates;
    private static Type[][] stackEffect;
    public static Vector<String> cryptoAlgoNames;
    public static boolean allCryptoAlgosFound;
    public static MethodDescriptor md;
    static boolean showVerbose;
    static final String WARNING_MSG_1 = "* Please verify usage of method ";
    static final String WARNING_MSG_2 = " of class ";
    static final String WARNING_MSG_3 = " of method ";
    static final String WARNING_MSG_4 = " at PC ";
    static final String WARNING_MSG_NON_VERBOSE_1 = "* Please verify ";
    static final String WARNING_MSG_NON_VERBOSE_2 = " algorithm use ";

    CryptoCallAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void simulate(Instr[] code, int maxStack, int maxLocal, TypeMethod tymeth, TypeClass self, boolean isInit, TypeClass currClass, MethodDescriptor currentMethod) {
        String value = System.getenv("JC_TRIMMING_TOOL_CRYPTO_VERBOSE");
        if (value != null) {
            showVerbose = value.equalsIgnoreCase("true");
        }
        try {
            cryptoAlgoNames.clear();
            allCryptoAlgosFound = true;
            md = currentMethod;
            seenStates = new Hashtable(51);
            pendingStates = new Stack();
            Type[] initStack = new Type[maxStack];
            Type[] initLocal = new Type[maxLocal];
            int i = 0;
            if (self != null) {
                initLocal[i++] = isInit ? new TypeInit(self.classref, -1) : self;
            }
            for (Type element : tymeth.args) {
                initLocal[i++] = element.normalize();
            }
            CryptoCallAnalyzer.enterState(0, Contour.empty, initLocal, initStack, 0);
            methodResultType = tymeth.res.normalize();
            methodInitStatus = isInit ? 1 : 0;
            currentClass = currClass;
            while (!pendingStates.empty()) {
                State s = pendingStates.pop();
                CryptoCallAnalyzer.transition(code, s);
            }
        }
        finally {
            seenStates = null;
            pendingStates = null;
            methodResultType = null;
            currentClass = null;
        }
    }

    static void transition(Instr[] code, State before) {
        Instr instr = code[before.pc];
        Type[] newStack = (Type[])before.stack.clone();
        Type[] newLocals = before.locals;
        int newSp = 0;
        switch (instr.opcode) {
            case 16: 
            case 17: {
                TypeBase shortType = new TypeBase(4, (Object)instr.arg);
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, (Type)shortType);
                break;
            }
            case 20: {
                TypeBase intType = new TypeBase(5, (Object)instr.arg);
                TypeBase int2Type = new TypeBase(6, (Object)instr.arg2);
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, (Type)intType);
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, (Type)int2Type);
                break;
            }
            case 92: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = before.sp - 1;
                int value = (Integer)shortType.value;
                TypeBase intType = new TypeBase(5, (Object)0);
                TypeBase int2Type = new TypeBase(6, (Object)value);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, (Type)intType);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, (Type)int2Type);
                break;
            }
            case 94: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                newSp = before.sp - 2;
                int value = (Integer)intType.value;
                TypeBase shortType = new TypeBase(4, (Object)value);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, (Type)intType);
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                Type ty = before.locals[instr.arg];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                Type ty = before.locals[instr.arg];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                Type ty = before.locals[instr.arg];
                Type ty2 = before.locals[instr.arg + 1];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 36: {
                Type[] stackEffectAaload = new Type[]{new TypeArray((Type)new TypeClass(Classref.Object)), Type.Short, null, null};
                newSp = CryptoCallAnalyzer.matchStack(stackEffectAaload, newStack, before.sp, instr);
                Type ty = before.stack[before.sp - 2];
                if (ty instanceof TypeArray) {
                    ty = ((TypeArray)ty).eltType;
                } else if (ty instanceof TypeNull) {
                    ty = Type.Null;
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty);
                break;
            }
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.arg, ty);
                newSp = before.sp - 1;
                break;
            }
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short, false, instr);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.arg, (Type)shortType);
                break;
            }
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int, false, instr);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.arg, (Type)intType, (Type)int2Type);
                break;
            }
            case 55: {
                Type[] stackEffectAastore = new Type[]{new TypeArray((Type)new TypeClass(Classref.Object)), Type.Short, new TypeClass(Classref.Object), null, null};
                newSp = CryptoCallAnalyzer.matchStack(stackEffectAastore, newStack, before.sp, instr);
                break;
            }
            case 59: {
                newSp = before.sp - 1;
                break;
            }
            case 60: {
                newSp = before.sp - 2;
                break;
            }
            case 61: {
                newStack[before.sp] = newStack[before.sp - 1];
                newSp = before.sp + 1;
                break;
            }
            case 62: {
                newStack[before.sp] = newStack[before.sp - 2];
                newStack[before.sp + 1] = newStack[before.sp - 1];
                newSp = before.sp + 2;
                break;
            }
            case 63: {
                int m = instr.arg;
                int n = instr.arg2;
                System.arraycopy(before.stack, before.sp - n, newStack, before.sp - n + m, n);
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - n, m);
                newSp = before.sp + m;
                break;
            }
            case 64: {
                int m = instr.arg;
                int n = instr.arg2;
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - m - n, m);
                System.arraycopy(before.stack, before.sp - m - n, newStack, before.sp - n, n);
                newSp = before.sp;
                break;
            }
            case 89: {
                Type ty;
                int value;
                TypeBase shortType = (TypeBase)before.locals[instr.arg];
                if (shortType.value != null) {
                    value = (Integer)((TypeBase)before.locals[instr.arg]).value;
                    ty = before.locals[instr.arg] = new TypeBase(4, (Object)(value += instr.arg2));
                } else {
                    ty = before.locals[instr.arg];
                }
                newSp = before.sp;
                break;
            }
            case 150: {
                Type ty;
                int value;
                TypeBase shortType = (TypeBase)before.locals[instr.arg];
                if (shortType.value != null) {
                    value = instr.arg2 << 8 | instr.arg3;
                    ty = before.locals[instr.arg] = new TypeBase(4, (Object)(value += ((Integer)((TypeBase)before.locals[instr.arg]).value).intValue()));
                } else {
                    ty = before.locals[instr.arg];
                }
                newSp = before.sp;
                break;
            }
            case 90: {
                int intValue = instr.arg2;
                int value1 = (Integer)((TypeBase)before.locals[instr.arg]).value;
                int value2 = (Integer)((TypeBase)before.locals[instr.arg + 1]).value;
                Type ty = before.locals[instr.arg] = new TypeBase(5, (Object)((intValue += value1 << 16 | value2) >> 16 & 0xFFFF));
                TypeBase typeBase = new TypeBase(5, (Object)(intValue & 0xFFFF));
                before.locals[instr.arg + 1] = typeBase;
                Type ty2 = typeBase;
                newSp = before.sp;
                break;
            }
            case 151: {
                int intValue = instr.arg2 << 8 | instr.arg3;
                int value1 = (Integer)((TypeBase)before.locals[instr.arg]).value;
                int value2 = (Integer)((TypeBase)before.locals[instr.arg + 1]).value;
                Type ty = before.locals[instr.arg] = new TypeBase(5, (Object)((intValue += value1 << 16 | value2) >> 16 & 0xFFFF));
                TypeBase typeBase = new TypeBase(5, (Object)(intValue & 0xFFFF));
                before.locals[instr.arg + 1] = typeBase;
                Type ty2 = typeBase;
                newSp = before.sp;
                break;
            }
            case 113: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, (Type)new TypeRetaddr(before.pc + instr.length()));
                break;
            }
            case 114: {
                Type ty = before.locals[instr.arg];
                newSp = before.sp;
                break;
            }
            case 119: {
                Type ty = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 120: {
                Type ty = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 121: {
                Type ty = before.stack[before.sp - 2];
                Type ty2 = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 122: {
                newSp = 0;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg));
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg), false, instr);
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                TypeClass refClass = CryptoCallAnalyzer.findCpoolReferenceClass(instr.arg);
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, (Type)refClass, false, instr);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg));
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                TypeClass refClass = CryptoCallAnalyzer.findCpoolReferenceClass(instr.arg);
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg), true, instr);
                newSp = CryptoCallAnalyzer.popMatch(before.stack, newSp, (Type)refClass, true, instr);
                break;
            }
            case 139: {
                newSp = CryptoCallAnalyzer.matchArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethodtype(instr.arg), CryptoCallAnalyzer.findCpoolReferenceClass(instr.arg), 0);
                break;
            }
            case 140: {
                int initStatus = 0;
                if (ConstantPoolComponent.methodIsInit((int)instr.arg)) {
                    initStatus = 1 + methodInitStatus;
                }
                newSp = CryptoCallAnalyzer.matchArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethodtype(instr.arg), CryptoCallAnalyzer.findCpoolReferenceClass(instr.arg), initStatus);
                if (initStatus == 0) break;
                newStack = CryptoCallAnalyzer.initializeInstance(newStack, newSp);
                newLocals = CryptoCallAnalyzer.initializeInstance(newLocals, newLocals.length);
                break;
            }
            case 141: {
                ConstantPoolEntry cpe = Cap.ConstantPool.entry(instr.arg);
                if (cpe.isExternalStaticRef()) {
                    for (int[] entry : CryptoCallAnalyzer.ccp.cryptoMethodFinderPattern) {
                        if (entry[0] != cpe.externalStaticRefPackageToken() || entry[1] != cpe.externalStaticRefClassToken() || entry[2] != cpe.tokenStaticRef()) continue;
                        if (entry[3] < 0) {
                            boolean successful = CryptoCallAnalyzer.listFlexAlgorithms(before.sp, entry, newStack);
                            if (!successful) {
                                allCryptoAlgosFound = false;
                                continue;
                            }
                            CryptoCallAnalyzer.constructAndAddWarningMessage(entry, before.pc);
                            continue;
                        }
                        int theValue = 0;
                        Type typeOnStack = newStack[before.sp - entry[3]];
                        if (typeOnStack instanceof TypeBase) {
                            TypeBase valueType = (TypeBase)typeOnStack;
                            if (valueType.value != null) {
                                theValue = (Integer)valueType.value;
                                CryptoCallAnalyzer.listCryptoAlgorithmUsed(entry, theValue);
                                CryptoCallAnalyzer.constructAndAddWarningMessage(entry, before.pc);
                                continue;
                            }
                            allCryptoAlgosFound = false;
                            continue;
                        }
                        allCryptoAlgosFound = false;
                    }
                }
                newSp = CryptoCallAnalyzer.matchArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethodtype(instr.arg), null, 0);
                break;
            }
            case 142: {
                MethodTypeAndFlags m = Methodref.findByToken((int)CryptoCallAnalyzer.findCpoolReferenceClassref(instr.arg), (int)instr.arg2, (boolean)false);
                newSp = CryptoCallAnalyzer.matchArgumentsAndPushResult(newStack, before.sp, m.mty, new TypeClass(Classref.Object), 0);
                break;
            }
            case 143: {
                int cref = CryptoCallAnalyzer.findCpoolReferenceClassref(instr.arg);
                int flags = Classref.checkAndGetAccessFlags((int)cref);
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, (Type)new TypeInit(cref, before.pc));
                break;
            }
            case 144: {
                newSp = CryptoCallAnalyzer.popMatch(newStack, before.sp, Type.Short, false, instr);
                Type tyElt = null;
                switch (instr.arg) {
                    case 10: 
                    case 11: {
                        tyElt = Type.Byte;
                        break;
                    }
                    case 12: {
                        tyElt = Type.Short;
                        break;
                    }
                    case 13: {
                        tyElt = Type.Int;
                    }
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, (Type)new TypeArray(tyElt));
                break;
            }
            case 145: {
                newSp = CryptoCallAnalyzer.popMatch(newStack, before.sp, Type.Short, false, instr);
                TypeArray tyElt = new TypeArray((Type)new TypeClass(CryptoCallAnalyzer.findCpoolReferenceClassref(instr.arg)));
                newSp = CryptoCallAnalyzer.push(newStack, newSp, tyElt.normalize());
                break;
            }
            case 146: {
                newSp = before.sp - 1;
                Type ty = before.stack[newSp];
                newSp = CryptoCallAnalyzer.push(newStack, newSp, Type.Short);
                break;
            }
            case 148: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, (Type)new TypeClass(Classref.Object), false, instr);
                TypeArray tyRes = null;
                switch (instr.arg) {
                    case 0: {
                        tyRes = new TypeClass(CryptoCallAnalyzer.findCpoolReferenceClassref(instr.arg2));
                        break;
                    }
                    case 10: 
                    case 11: {
                        tyRes = new TypeArray(Type.Byte);
                        break;
                    }
                    case 12: {
                        tyRes = new TypeArray(Type.Short);
                        break;
                    }
                    case 13: {
                        tyRes = new TypeArray(Type.Int);
                        break;
                    }
                    case 14: {
                        tyRes = new TypeArray((Type)new TypeClass(CryptoCallAnalyzer.findCpoolReferenceClassref(instr.arg2)));
                    }
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, tyRes.normalize());
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg));
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceType(instr.arg), true, instr);
                break;
            }
            default: {
                newSp = CryptoCallAnalyzer.matchStack(stackEffect[instr.opcode], newStack, before.sp, instr);
            }
        }
        if (printTrace) {
            System.out.println(before.pc + before.contour.toString() + ": " + Instr.instrName[instr.opcode]);
            System.out.print("    ");
            State.printLocals((Type[])before.locals);
            State.printStack((Type[])before.stack, (int)before.sp);
            System.out.println();
            System.out.print("--> ");
            State.printLocals((Type[])newLocals);
            System.out.print(' ');
            State.printStack((Type[])newStack, (int)newSp);
            System.out.println();
        }
        switch (instr.opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                CryptoCallAnalyzer.enterState(before.pc + instr.length(), before.contour, newLocals, newStack, newSp);
                CryptoCallAnalyzer.enterState(before.pc + instr.arg, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 112: 
            case 168: {
                CryptoCallAnalyzer.enterState(before.pc + instr.arg, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 115: 
            case 116: {
                InstrTableSwitch ts = (InstrTableSwitch)instr;
                for (int element : ts.offsets) {
                    CryptoCallAnalyzer.enterState(before.pc + element, before.contour, newLocals, newStack, newSp);
                }
                CryptoCallAnalyzer.enterState(before.pc + ts.dfl, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 117: 
            case 118: {
                InstrLookupSwitch ls = (InstrLookupSwitch)instr;
                for (int element : ls.offsets) {
                    CryptoCallAnalyzer.enterState(before.pc + element, before.contour, newLocals, newStack, newSp);
                }
                CryptoCallAnalyzer.enterState(before.pc + ls.dfl, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 147: {
                break;
            }
            default: {
                CryptoCallAnalyzer.enterState(before.pc + instr.length(), before.contour, newLocals, newStack, newSp);
            }
        }
        ExnHandler e = instr.handler;
        while (e != null) {
            Type[] exnStack = new Type[before.stack.length];
            CryptoCallAnalyzer.push(exnStack, 0, (Type)e.catchType);
            CryptoCallAnalyzer.enterState(e.target, before.contour, newLocals, exnStack, 1);
            e = e.next;
        }
    }

    private static int matchStack(Type[] effect, Type[] stack, int sp, Instr instr) {
        int i = 0;
        int nargs = 0;
        while (effect[i] != null) {
            ++nargs;
            ++i;
        }
        sp -= nargs;
        ++i;
        while (effect[i] != null) {
            stack[sp] = effect[i];
            ++sp;
            ++i;
        }
        return sp;
    }

    private static int push(Type[] stack, int sp, Type ty) {
        stack[sp] = ty;
        if (ty == Type.Int) {
            return CryptoCallAnalyzer.push(stack, sp + 1, Type.Int2);
        }
        return sp + 1;
    }

    private static int popMatch(Type[] stack, int sp, Type ty, boolean checkInternalField, Instr instr) {
        if (ty == Type.Int) {
            sp = CryptoCallAnalyzer.popMatch(stack, sp, Type.Int2, checkInternalField, instr);
        }
        return sp - 1;
    }

    private static int matchArgumentsAndPushResult(Type[] stack, int sp, TypeMethod mty, TypeClass selfty, int initStatus) {
        int numArgs = mty.args.length;
        if (selfty != null) {
            ++numArgs;
        }
        int i = 0;
        actualSelfType = null;
        if (selfty != null) {
            Type ty = stack[sp - numArgs];
            boolean matched = false;
            switch (initStatus) {
                case 0: {
                    matched = ty.isSubtype((Type)selfty);
                    break;
                }
                case 1: {
                    matched = ty instanceof TypeInit && ((TypeInit)ty).classref == selfty.classref;
                    actualSelfType = ty;
                    break;
                }
                case 2: {
                    matched = ty instanceof TypeInit && Classref.isSameOrSuper((int)((TypeInit)ty).classref, (int)selfty.classref);
                    actualSelfType = ty;
                }
            }
            i = 1;
        }
        for (int j = 0; j < mty.args.length; ++j) {
            Type actualTy = stack[sp - numArgs + i];
            Type expectedTy = mty.args[j].normalize();
            if (!actualTy.isSubtype(expectedTy)) {
                throw new VerifierError("AbstrInterp.50", j, (Object)expectedTy, (Object)actualTy);
            }
            ++i;
        }
        sp -= numArgs;
        if (mty.res != Type.Void) {
            sp = CryptoCallAnalyzer.push(stack, sp, mty.res.normalize());
        }
        return sp;
    }

    private static Type[] initializeInstance(Type[] ty, int n) {
        Type[] newty = (Type[])ty.clone();
        TypeClass initialized = new TypeClass(((TypeInit)CryptoCallAnalyzer.actualSelfType).classref);
        for (int i = 0; i < n; ++i) {
            if (!actualSelfType.equals(newty[i])) continue;
            newty[i] = initialized;
        }
        return newty;
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty;
        return newLocals;
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty1, Type ty2) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty1;
        newLocals[idx + 1] = ty2;
        return newLocals;
    }

    private static Type findCpoolReferenceType(int idx) {
        int tyIdx = Cap.TypeDescr.constantPoolType(idx);
        Safeptr ty = Cap.TypeDescr.at(tyIdx);
        return Type.parseCap((Safeptr)ty).normalize();
    }

    private static TypeMethod findCpoolReferenceMethodtype(int idx) {
        int tyIdx = Cap.TypeDescr.constantPoolType(idx);
        Safeptr ty = Cap.TypeDescr.at(tyIdx);
        return TypeMethod.parseCap((Safeptr)ty);
    }

    private static TypeClass findCpoolReferenceClass(int idx) {
        ConstantPoolEntry cp = Cap.ConstantPool.entry(idx);
        switch (cp.tag()) {
            case 2: 
            case 3: 
            case 4: {
                return new TypeClass(cp.classRefVirtualRef());
            }
            case 7: {
                if (cp.isExternalStaticRef()) {
                    return new TypeClass(cp.classStaticRef());
                }
                ClassAndMethodDescriptor cmdesc = Methodref.findDescr((int)cp.internalStaticRef());
                return new TypeClass(cmdesc.classDescr.thisClass());
            }
        }
        throw new VerifierError("AbstrInterp.51");
    }

    private static int findCpoolReferenceClassref(int idx) {
        ConstantPoolEntry cp = Cap.ConstantPool.entry(idx);
        return cp.classRef();
    }

    private static void enterState(int pc, Contour contour, Type[] locals, Type[] stack, int sp) {
        Type mergedty;
        Type newty;
        Type oldty;
        int i;
        boolean cloneCreated = false;
        State newstate = new State(pc, contour, locals, stack, sp);
        State oldstate = seenStates.get(newstate);
        if (oldstate == null) {
            seenStates.put(newstate, newstate);
            pendingStates.push(newstate);
            return;
        }
        boolean unchanged = true;
        for (i = 0; i < oldstate.locals.length; ++i) {
            oldty = oldstate.locals[i];
            newty = newstate.locals[i];
            if (oldty == null) continue;
            Type type = mergedty = newty != null ? oldty.lub(newty) : null;
            if (mergedty != null && mergedty instanceof TypeBase) {
                ((TypeBase)mergedty).value = ((TypeBase)oldty).value;
            }
            if (!cloneCreated && (newty == null && mergedty != null || newty == null || !newty.equals(mergedty))) {
                newstate.locals = (Type[])newstate.locals.clone();
                cloneCreated = true;
            }
            newstate.locals[i] = mergedty;
            unchanged = unchanged && oldty.equals(mergedty);
        }
        cloneCreated = false;
        for (i = 0; i < oldstate.sp; ++i) {
            oldty = oldstate.stack[i];
            newty = newstate.stack[i];
            mergedty = oldty.lub(newty);
            if (mergedty == null) {
                throw new VerifierError("AbstrInterp.101", i, (Object)oldty, (Object)newty);
            }
            if (mergedty != null && mergedty instanceof TypeBase) {
                ((TypeBase)mergedty).value = ((TypeBase)oldty).value;
            }
            if (!cloneCreated && !mergedty.equals(newty)) {
                newstate.stack = (Type[])newstate.stack.clone();
                cloneCreated = true;
            }
            newstate.stack[i] = mergedty;
            unchanged = unchanged && oldty.equals(mergedty);
        }
        if (!unchanged) {
            pendingStates.push(newstate);
        }
    }

    static void constructAndAddWarningMessage(int[] info, int pc) {
        ExportFile ef = Cap.Import.exportfileForPackageToken(info[0]);
        EfClass ec = ef.findClassByToken((short)info[1]);
        EfMethod em = ec.getMethodForTokenAndFlag(info[2], true);
        String msg = null;
        if (showVerbose) {
            msg = WARNING_MSG_1 + em.name() + WARNING_MSG_2 + ec.thisName() + WARNING_MSG_3 + md.toString() + WARNING_MSG_4 + pc;
        } else {
            String className = ec.thisName().replace('/', '.');
            msg = WARNING_MSG_NON_VERBOSE_1 + className + WARNING_MSG_NON_VERBOSE_2;
        }
        if (!cryptoAlgoNames.contains(msg)) {
            cryptoAlgoNames.add(msg);
        }
    }

    static void listCryptoAlgorithmUsed(int[] info, int value) {
        ExportFile ef = Cap.Import.exportfileForPackageToken(info[0]);
        EfClass ec = ef.findClassByToken((short)info[1]);
        String name = ec.getConstantFieldNameByValueAndDesc(value, "B");
        if (!cryptoAlgoNames.contains(name)) {
            cryptoAlgoNames.add(name);
        }
    }

    static boolean listFlexAlgorithms(int sp, int[] entry, Type[] newStack) {
        switch (entry[3]) {
            case -1: {
                return CryptoCallAnalyzer.listFlexKeyBuilderAlgorithms(newStack, sp);
            }
            case -2: {
                return CryptoCallAnalyzer.listFlexSignatureAlgorithms(newStack, sp);
            }
            case -3: {
                return CryptoCallAnalyzer.listFlexCipherAlgorithms(newStack, sp);
            }
        }
        return false;
    }

    static int getValueFromStack(Type[] newStack, int sp, int offset) {
        Type typeOnStack = newStack[sp - offset];
        int theValue = -1;
        if (typeOnStack instanceof TypeBase) {
            TypeBase valueType = (TypeBase)typeOnStack;
            if (valueType.value != null) {
                theValue = (Integer)valueType.value;
            } else {
                allCryptoAlgosFound = false;
            }
        } else {
            allCryptoAlgosFound = false;
        }
        return theValue;
    }

    static boolean listFlexKeyBuilderAlgorithms(Type[] newStack, int sp) {
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int memValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        int lengthValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 1);
        if (cipherAlgorithmValue == -1 || memValue == -1 || lengthValue == -1) {
            return false;
        }
        String algoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String memType = CryptoAlgorithmList.getAlgoName(memValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_MEM);
        String length = CryptoAlgorithmList.getAlgoName(lengthValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_KEY_LENGTH);
        if (algoName == null || memType == null || length == null) {
            return false;
        }
        String fullName = algoName + ", " + memType + "," + length;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static boolean listFlexSignatureAlgorithms(Type[] newStack, int sp) {
        int MDAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 4);
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int padAlgValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        if (cipherAlgorithmValue == -1 || MDAlgorithmValue == -1 || padAlgValue == -1) {
            return false;
        }
        String MDAlgoName = CryptoAlgorithmList.getAlgoName(MDAlgorithmValue, "javacard.security.MessageDigest", CryptoAlgorithmInfo.TYPE_NON_FLEX);
        String cipherAlgoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacard.security.Signature", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String padAlgoName = CryptoAlgorithmList.getAlgoName(padAlgValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (padAlgoName == null || cipherAlgoName == null || MDAlgoName == null) {
            return false;
        }
        String fullName = MDAlgoName + ", " + cipherAlgoName + "," + padAlgoName;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static boolean listFlexCipherAlgorithms(Type[] newStack, int sp) {
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int padAlgValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        if (cipherAlgorithmValue == -1 || padAlgValue == -1) {
            return false;
        }
        String cipherAlgoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String paddingAlgoName = CryptoAlgorithmList.getAlgoName(padAlgValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (cipherAlgoName == null || paddingAlgoName == null) {
            return false;
        }
        String fullName = cipherAlgoName + ", " + paddingAlgoName;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static {
        printTrace = false;
        Type[][] se = new Type[][]{{null, null}, {null, Type.Null, null}, {null, new TypeBase(4, (Object)-1), null}, {null, new TypeBase(4, (Object)0), null}, {null, new TypeBase(4, (Object)1), null}, {null, new TypeBase(4, (Object)2), null}, {null, new TypeBase(4, (Object)3), null}, {null, new TypeBase(4, (Object)4), null}, {null, new TypeBase(4, (Object)5), null}, {null, new TypeBase(5, (Object)-1), new TypeBase(6, (Object)-1), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)0), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)1), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)2), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)3), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)4), null}, {null, new TypeBase(5, (Object)0), new TypeBase(6, (Object)5), null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, null, Type.Short, null}, {Type.ShortArray, Type.Short, null, Type.Short, null}, {Type.IntArray, Type.Short, null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, Type.Short, null, null}, {Type.ShortArray, Type.Short, Type.Short, null, null}, {Type.IntArray, Type.Short, Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, null, null, {Type.Short, null, Type.Short, null}, {Type.Short, null, Type.Int, Type.Int2, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Short, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {new TypeClass(Classref.Throwable), null, null}, null, {new TypeClass(Classref.Object), null, Type.Short, null}, null, null, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        stackEffect = se;
        cryptoAlgoNames = new Vector();
        allCryptoAlgosFound = true;
        showVerbose = false;
    }
}

