/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcbytecodeprofiler;

import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcbytecodeprofiler.InputPackageInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCAllCodeNMethodProfiler {
    private Hashtable<String, Vector<String>> allNativeMethods = new Hashtable();
    private Hashtable<String, Vector<String>> allClasses = new Hashtable();
    Vector<JCPackage> pkgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAllReport(InputPackageInfo inputPkgs, File folder) {
        this.pkgs = inputPkgs.getPackages();
        for (JCPackage p : this.pkgs) {
            Enumeration<JCClass> pkgClasses = p.classElements();
            while (pkgClasses.hasMoreElements()) {
                JCClass c = pkgClasses.nextElement();
                Vector<String> nativeMethods = new Vector<String>();
                Vector<String> members = new Vector<String>();
                Enumeration<Field> fields = c.fieldElements();
                while (fields.hasMoreElements()) {
                    Field f = fields.nextElement();
                    String descriptor = null;
                    if (f.getDescriptor().getDescriptorString() == null) {
                        descriptor = this.getFieldDescriptorString(f);
                    }
                    String formatF = f.getFormattedField(descriptor);
                    members.add(formatF);
                }
                Enumeration<JCMethod> classMethods = c.methodElements();
                while (classMethods.hasMoreElements()) {
                    JCMethod m = classMethods.nextElement();
                    members.add(m.getFormattedMethod());
                    if (!Modifier.isNative(m.getAttributes())) continue;
                    nativeMethods.addElement(m.getFormattedMethod());
                }
                if (nativeMethods.size() > 0) {
                    this.allNativeMethods.put(c.getName(), nativeMethods);
                }
                this.allClasses.put(c.getName(), members);
            }
        }
        FileOutputStream fos_allnative = null;
        FileOutputStream fos_allcode = null;
        try {
            String className;
            File f3 = new File(folder, "allnativemethods.list").getAbsoluteFile().getCanonicalFile();
            File f2 = new File(folder, "allcode.info").getAbsoluteFile().getCanonicalFile();
            fos_allnative = new FileOutputStream(f3);
            Enumeration<String> keys = this.allNativeMethods.keys();
            ArrayList<String> sortedKeys = Collections.list(keys);
            Collections.sort(sortedKeys);
            keys = Collections.enumeration(sortedKeys);
            while (keys.hasMoreElements()) {
                className = keys.nextElement();
                fos_allnative.write(className.replace("/", ".").getBytes());
                fos_allnative.write("\n".getBytes());
                Enumeration<String> methods = this.allNativeMethods.get(className).elements();
                while (methods.hasMoreElements()) {
                    String method = methods.nextElement();
                    fos_allnative.write(("      " + method).getBytes());
                    fos_allnative.write("\n".getBytes());
                }
            }
            fos_allcode = new FileOutputStream(f2);
            keys = this.allClasses.keys();
            sortedKeys = Collections.list(keys);
            Collections.sort(sortedKeys);
            keys = Collections.enumeration(sortedKeys);
            while (keys.hasMoreElements()) {
                className = keys.nextElement();
                fos_allcode.write(className.replace("/", ".").getBytes());
                fos_allcode.write("\n".getBytes());
                Enumeration<String> members = this.allClasses.get(className).elements();
                while (members.hasMoreElements()) {
                    String member = members.nextElement();
                    fos_allcode.write(("      " + member).getBytes());
                    fos_allcode.write("\n".getBytes());
                }
            }
        }
        catch (Exception ex) {
            System.exit(10);
        }
        finally {
            if (fos_allnative != null) {
                try {
                    fos_allnative.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fos_allcode != null) {
                try {
                    fos_allcode.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String getFieldDescriptorString(Field f) {
        FieldDescriptor fd = f.getDescriptor();
        String fdStr = fd.getDescriptorString();
        if (fdStr == null) {
            ClassIdentifier cid = fd.getClassIdentifier();
            PackageIdentifier pid = cid.getPackageIdentifier();
            block0: for (JCPackage p : this.pkgs) {
                if (!p.getIdentifier().equals(pid)) continue;
                Enumeration<JCClass> pkgClasses = p.classElements();
                while (pkgClasses.hasMoreElements()) {
                    JCClass c = pkgClasses.nextElement();
                    if (!c.getClassIdentifier().equals(cid)) continue;
                    fdStr = c.getName();
                    fdStr = "L" + fdStr.substring(fdStr.lastIndexOf("/") + 1) + ";";
                    continue block0;
                }
            }
        }
        return fdStr;
    }
}

