/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.installer;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.installer.Component;
import com.sun.javacard.installer.InstallerException;

class ClassComponent
extends Component {
    static final short MODE_PUB = 1;
    static final short MODE_PKG = 2;

    ClassComponent() {
    }

    void process() throws InstallerException {
        Component.load();
    }

    void postProcess() throws InstallerException {
        short m_s1;
        short m_offset = 0;
        int m_classCompAddr = Component.g_componentAddresses[6];
        if (Component.g_capMinor == 2) {
            m_s1 = NativeMethods.readShort((int)m_classCompAddr, (short)m_offset);
            m_offset = (short)(m_offset + m_s1 + 2);
        }
        while (m_offset < Component.g_compSize) {
            int m_superClassAddr;
            short i;
            boolean isSuperExternal = false;
            int m_curClassAddr = m_classCompAddr + m_offset;
            byte m_b1 = NativeMethods.readByte((int)m_curClassAddr, (short)0);
            short m_interfaceCount = (short)(m_b1 & 0xF);
            if (ClassComponent.isInterface(m_b1)) {
                m_offset = (short)(m_offset + 1);
                i = 0;
                while (i < m_interfaceCount) {
                    Component.resolve(m_classCompAddr, m_offset, (byte)6);
                    m_offset = (short)(m_offset + 2);
                    i = (short)(i + 1);
                }
                if (!ClassComponent.isRemote(m_b1)) continue;
                m_offset = ClassComponent.fixupRemoteInfo(m_offset, m_b1, m_classCompAddr);
                continue;
            }
            short m_superClassRef = Component.resolve(m_curClassAddr, (short)1, (byte)6);
            if (Component.isExternal(m_superClassRef)) {
                m_superClassAddr = NativeMethods.getReferenceAddress((short)m_superClassRef);
                isSuperExternal = true;
            } else {
                m_superClassAddr = m_superClassRef + Component.g_componentAddresses[6];
            }
            m_s1 = (short)(ClassComponent.getInstanceSize(m_superClassAddr) + (NativeMethods.readByte((int)m_curClassAddr, (short)4) & 0xFF));
            NativeMethods.writeByte((int)m_curClassAddr, (short)4, (byte)((byte)m_s1));
            m_s1 = (short)(ClassComponent.getInstanceSize(m_superClassAddr) + ClassComponent.getInstanceSize(m_curClassAddr));
            if (m_s1 > 255) {
                InstallerException.throwIt((short)25669);
            }
            NativeMethods.writeByte((int)m_curClassAddr, (short)3, (byte)((byte)m_s1));
            short m_base = (short)(NativeMethods.readByte((int)m_curClassAddr, (short)6) & 0xFF);
            short m_count = (short)(NativeMethods.readByte((int)m_curClassAddr, (short)7) & 0xFF);
            m_offset = (short)(m_offset + 10);
            i = 0;
            while (i < m_count) {
                m_s1 = NativeMethods.readShort((int)m_classCompAddr, (short)m_offset);
                if (m_s1 == -1) {
                    m_s1 = ClassComponent.getVirtualMethodReference(m_superClassAddr, (byte)(i + m_base), isSuperExternal, m_classCompAddr);
                    NativeMethods.writeShort((int)m_classCompAddr, (short)m_offset, (short)m_s1);
                } else {
                    int methodAddress = Component.g_componentAddresses[7] + (m_s1 & 0xFFFF);
                    if ((m_s1 = NativeMethods.addReferenceAddress((int)methodAddress, (byte)PackageMgr.g_newPackageIdentifier)) == 0) {
                        InstallerException.throwIt((short)25636);
                    }
                    NativeMethods.writeShort((int)m_classCompAddr, (short)m_offset, (short)m_s1);
                }
                m_offset = (short)(m_offset + 2);
                i = (short)(i + 1);
            }
            m_base = (short)(NativeMethods.readByte((int)m_curClassAddr, (short)8) & 0xFF);
            if ((short)(m_base + (m_count = (short)(NativeMethods.readByte((int)m_curClassAddr, (short)9) & 0xFF))) > 128) {
                InstallerException.throwIt((short)25666);
            }
            short i2 = 0;
            while (i2 < m_count) {
                int methodAddress;
                m_s1 = NativeMethods.readShort((int)m_classCompAddr, (short)m_offset);
                if ((m_s1 & 0xFFFF) > Short.MAX_VALUE && (m_s1 = NativeMethods.addReferenceAddress((int)(methodAddress = (m_s1 & 0xFFFF) + Component.g_componentAddresses[7]), (byte)PackageMgr.g_newPackageIdentifier)) == 0) {
                    InstallerException.throwIt((short)25636);
                }
                NativeMethods.writeShort((int)m_classCompAddr, (short)m_offset, (short)m_s1);
                m_offset = (short)(m_offset + 2);
                i2 = (short)(i2 + 1);
            }
            short i3 = 0;
            while (i3 < m_interfaceCount) {
                short l_temp = 0;
                Component.resolve(m_classCompAddr, (short)(m_offset + 0), (byte)6);
                l_temp = (short)(NativeMethods.readByte((int)m_classCompAddr, (short)((short)(m_offset + 2))) & 0xFF);
                m_offset = (short)(m_offset + (short)(l_temp + 3));
                i3 = (short)(i3 + 1);
            }
            if (!ClassComponent.isRemote(m_b1)) continue;
            m_offset = ClassComponent.fixupRemoteInfo(m_offset, m_b1, m_classCompAddr);
        }
        Component.setComplete((short)6);
    }

    static short fixupRemoteInfo(short offset, byte classFlag, int classCompAddr) throws InstallerException {
        if (ClassComponent.isInterface(classFlag)) {
            short nameLength = (short)(NativeMethods.readByte((int)classCompAddr, (short)offset) & 0xFF);
            offset = (short)(offset + (short)(nameLength + 1));
            return offset;
        }
        short remoteMethodCount = (short)(NativeMethods.readByte((int)classCompAddr, (short)offset) & 0xFF);
        offset = (short)(offset + 1);
        short i = 0;
        while (i < remoteMethodCount) {
            offset = (short)(offset + 5);
            i = (short)(i + 1);
        }
        short antiCollisionSize = NativeMethods.readByte((int)classCompAddr, (short)offset);
        offset = (short)(offset + (short)(antiCollisionSize + 1));
        short classNameSize = (short)(NativeMethods.readByte((int)classCompAddr, (short)offset) & 0xFF);
        offset = (short)(offset + (classNameSize + 1));
        short remoteInterfaceCount = (short)(NativeMethods.readByte((int)classCompAddr, (short)offset) & 0xFF);
        offset = (short)(offset + 1);
        short i2 = 0;
        while (i2 < remoteInterfaceCount) {
            Component.resolve(classCompAddr, (short)(offset + 0), (byte)6);
            offset = (short)(offset + 2);
            i2 = (short)(i2 + 1);
        }
        return offset;
    }

    static short getInstanceSize(int classAddr) throws InstallerException {
        short m_instanceSize = (short)(NativeMethods.readByte((int)classAddr, (short)3) & 0xFF);
        return m_instanceSize;
    }

    static byte getMethodBase(int classAddr, short mode) {
        return NativeMethods.readByte((int)classAddr, (short)(mode == 1 ? (short)6 : 8));
    }

    static boolean isInterface(byte bitfield) {
        return (bitfield & 0xFFFFFF80) == -128;
    }

    static boolean isRemote(byte bitfield) {
        return (bitfield & 0x20) == 32;
    }

    static byte calcInstanceSize(int classAddr, byte token, int classCompAddress) throws InstallerException {
        short superRef = NativeMethods.readShort((int)classAddr, (short)1);
        int superAddr = Component.isExternal(superRef) ? NativeMethods.getReferenceAddress((short)superRef) : superRef + classCompAddress;
        short m_instanceSize = ClassComponent.getInstanceSize(superAddr);
        if ((m_instanceSize = (short)(m_instanceSize + (short)((short)token & 0xFF))) > 255) {
            InstallerException.throwIt((short)25669);
        }
        return (byte)m_instanceSize;
    }

    static short getVirtualMethodReference(int classAddr, byte methodToken, boolean isSuperExternal, int classCompAddress) throws InstallerException {
        boolean m_goSuper = false;
        if (isSuperExternal) {
            classCompAddress = ClassComponent.getClassCompAddressForClassAddress(classAddr);
        }
        if (Component.isHighbitOn(methodToken)) {
            m_goSuper = ClassComponent.getMethodBase(classAddr, (short)2) > (byte)(methodToken & 0x7F);
        } else {
            boolean bl = m_goSuper = ClassComponent.getMethodBase(classAddr, (short)1) > methodToken;
        }
        if (m_goSuper) {
            int superAddress;
            short superRef = NativeMethods.readShort((int)classAddr, (short)1);
            if (Component.isExternal(superRef)) {
                superAddress = NativeMethods.getReferenceAddress((short)superRef);
                isSuperExternal = true;
            } else {
                superAddress = superRef + classCompAddress;
            }
            return ClassComponent.getVirtualMethodReference(superAddress, methodToken, isSuperExternal, classCompAddress);
        }
        return ClassComponent.getMethodReference(classAddr, methodToken);
    }

    static short getMethodReference(int classAddr, byte methodToken) throws InstallerException {
        int methodType;
        short m_pubMethodCount = (short)(NativeMethods.readByte((int)classAddr, (short)7) & 0xFF);
        short m_offset = 10;
        if (Component.isHighbitOn(methodToken)) {
            m_offset = (short)(m_offset + (short)(m_pubMethodCount * 2));
            methodToken = (byte)(methodToken & 0x7F);
            methodType = 2;
        } else {
            methodType = 1;
        }
        byte m_base = ClassComponent.getMethodBase(classAddr, (short)methodType);
        m_offset = (short)(m_offset + (short)((short)(methodToken - m_base) * 2));
        return NativeMethods.readShort((int)classAddr, (short)m_offset);
    }

    static int getClassCompAddressForClassAddress(int classAddr) {
        byte pkgId = NativeMethods.getPkgIDForAddress((int)classAddr);
        return NativeMethods.getPackageComponentLocation((byte)pkgId, (byte)0);
    }
}

