/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

public class StaticFieldComponent
extends Safeptr {
    private Safeptr endInitArray;
    private TreeSet<OffsetAndLength> allStaticFields;

    StaticFieldComponent(byte[] data) {
        super(data, "StaticField");
    }

    public int imageSize() {
        return this.u2(0);
    }

    public int referenceCount() {
        return this.u2(2);
    }

    public int arrayInitCount() {
        return this.u2(4);
    }

    InitializedArray arrayInit() {
        return new InitializedArray(this.offset(6));
    }

    public int defaultValueCount() {
        return this.endInitArray.u2(0);
    }

    public int nonDefaultValueCount() {
        return this.endInitArray.u2(2);
    }

    public Safeptr nonDefaultValuesStaticfield() {
        return this.endInitArray.offset(4);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("StaticFieldComponent.100");
        }
        this.allStaticFields = new TreeSet();
        InitializedArray ai = this.arrayInit();
        for (int i = this.arrayInitCount(); i > 0; --i) {
            ai.next();
        }
        this.endInitArray = ai;
        if (this.arrayInitCount() > this.referenceCount()) {
            throw new VerifierError("StaticFieldComponent.1");
        }
        if (this.imageSize() != this.referenceCount() * 2 + this.defaultValueCount() + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.2");
        }
        ClassDescriptor cdesc = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            if ((cdesc.flags() & 0x40) == 0) {
                for (int j = 0; j < cdesc.fieldCount(); ++j) {
                    FieldDescriptor fdesc = cdesc.fieldDescr(j);
                    this.verifyField(fdesc);
                }
            }
            cdesc.next();
        }
        this.verifyOverlap();
        this.allStaticFields = null;
        if (this.size() != this.endInitArray.ofs + 4 + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.17");
        }
    }

    private void verifyField(FieldDescriptor f) {
        int sz;
        if ((f.flags() & 8) == 0) {
            return;
        }
        int ofs = f.staticRef();
        Type ty = Type.parseField(f.type());
        if (ofs < this.referenceCount() * 2) {
            sz = 2;
            if ((ofs & 1) != 0) {
                throw new VerifierError("StaticFieldComponent.3");
            }
            if (ofs < this.arrayInitCount()) {
                int szElt;
                Type initTy;
                InitializedArray init = this.arrayInit();
                for (int k = 0; k < ofs; k += 2) {
                    init.next();
                }
                switch (init.type()) {
                    case 2: {
                        initTy = Type.BooleanArray;
                        szElt = 1;
                        break;
                    }
                    case 3: {
                        initTy = Type.ByteArray;
                        szElt = 1;
                        break;
                    }
                    case 4: {
                        initTy = Type.ShortArray;
                        szElt = 2;
                        break;
                    }
                    case 5: {
                        initTy = Type.IntArray;
                        szElt = 4;
                        Cap.Header.useInts();
                        break;
                    }
                    default: {
                        throw new VerifierError("StaticFieldComponent.4", init.type());
                    }
                }
                if (!ty.equals(initTy)) {
                    if ((f.type() & 0x8000) == 0) {
                        TypeClass tc = (TypeClass)ty;
                        if (tc.classref != Classref.Object) {
                            throw new VerifierError("StaticFieldComponent.5", (Object)ty, (Object)initTy);
                        }
                    } else {
                        throw new VerifierError("StaticFieldComponent.5", (Object)ty, (Object)initTy);
                    }
                }
                if (init.count() % szElt != 0) {
                    throw new VerifierError("StaticFieldComponent.13", init.count(), szElt);
                }
                if (init.count() / szElt > Short.MAX_VALUE) {
                    throw new VerifierError("StaticFieldComponent.16", init.count() / szElt);
                }
                if (init.type() == 2) {
                    for (int i = 0; i < init.count(); ++i) {
                        int data = init.values().u1(i);
                        if (data == 0 || data == 1) continue;
                        throw new VerifierError("StaticFieldComponent.14", data);
                    }
                }
            } else if (!(ty instanceof TypeClass) && !(ty instanceof TypeArray)) {
                throw new VerifierError("StaticFieldComponent.6", (Object)ty, ofs);
            }
        } else {
            if (!(ty instanceof TypeBase)) {
                throw new VerifierError("StaticFieldComponent.7", (Object)ty, ofs);
            }
            switch (((TypeBase)ty).kind) {
                case 2: 
                case 3: {
                    sz = 1;
                    break;
                }
                case 4: {
                    sz = 2;
                    break;
                }
                case 5: {
                    sz = 4;
                    break;
                }
                default: {
                    throw new VerifierError("StaticFieldComponent.8", (Object)ty, ofs);
                }
            }
            if (((TypeBase)ty).kind == 2 && ofs >= this.imageSize() - this.nonDefaultValueCount()) {
                int ofsNonDefaultValue = ofs - (this.imageSize() - this.nonDefaultValueCount());
                int data = this.nonDefaultValuesStaticfield().u1(ofsNonDefaultValue);
                if (data != 0 && data != 1) {
                    throw new VerifierError("StaticFieldComponent.15", data);
                }
            }
        }
        this.allStaticFields.add(new OffsetAndLength(ofs, sz));
    }

    public boolean isPrimitiveFieldInitialized(FieldDescriptor f) {
        int offset = f.staticRef();
        return offset >= this.imageSize() - this.nonDefaultValueCount();
    }

    public int getPrimitiveFieldValue(FieldDescriptor f) {
        int offset = f.staticRef();
        Type ty = Type.parseField(f.type());
        int ofsNonDefaultValue = offset - (this.imageSize() - this.nonDefaultValueCount());
        switch (((TypeBase)ty).kind) {
            case 2: 
            case 3: {
                return this.nonDefaultValuesStaticfield().u1(ofsNonDefaultValue);
            }
            case 4: {
                return this.nonDefaultValuesStaticfield().u2(ofsNonDefaultValue);
            }
            case 5: {
                return this.nonDefaultValuesStaticfield().s4(ofsNonDefaultValue);
            }
        }
        return 0;
    }

    public boolean isArrayInitialized(FieldDescriptor f) {
        int offset = f.staticRef();
        return offset < this.arrayInitCount();
    }

    public boolean isStaticFieldInitialized(FieldDescriptor f) {
        int offset = f.staticRef();
        if ((f.type() & 0x8000) == 32768) {
            return offset >= this.imageSize() - this.nonDefaultValueCount();
        }
        return offset < this.arrayInitCount() * 2;
    }

    public InitializedArray getArrayInitValues(int ofs) {
        if (ofs < this.arrayInitCount() * 2) {
            InitializedArray init = this.arrayInit();
            for (int k = 0; k < ofs; k += 2) {
                init.next();
            }
            return init;
        }
        return null;
    }

    private void verifyOverlap() {
        int ofs = 0;
        Iterator<OffsetAndLength> i$ = this.allStaticFields.iterator();
        while (i$.hasNext()) {
            OffsetAndLength offsetAndLength;
            OffsetAndLength ol = offsetAndLength = i$.next();
            if (ol.offset < ofs) {
                throw new VerifierError("StaticFieldComponent.9", ofs);
            }
            if (ol.offset > ofs) {
                throw new VerifierError("StaticFieldComponent.10", ofs);
            }
            ofs += ol.length;
        }
        if (ofs > this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.11");
        }
        if (ofs < this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.12");
        }
    }
}

