/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;

public class LocalVariableConverter_i_g
extends LocalVariableConverter {
    private JcLocalVariable[] jc_locals;
    private int defined_local_size = 0;
    private int undefined_local_max_index = 0;

    public LocalVariableConverter_i_g(MethodConverter method_converter) {
        super(method_converter);
    }

    public JcLocalVariable[] convert() throws Exception {
        this.constructLocalVariables();
        for (int index = 0; index < this.jc_locals.length; ++index) {
            for (JcLocalVariable jc_local = this.jc_locals[index]; jc_local != null; jc_local = jc_local.getNext()) {
                int jc_index = this.computeJcIndex(jc_local);
                jc_local.setJcIndex(jc_index);
            }
        }
        if (this.jc_locals.length == 0) {
            this.defined_local_size = 0;
        } else {
            for (JcLocalVariable last_local = this.jc_locals[this.jc_locals.length - 1]; last_local != null; last_local = last_local.getNext()) {
                int size = DataType.getSize(last_local.getDescriptor());
                if (this.defined_local_size >= last_local.getJcIndex() + size) continue;
                this.defined_local_size = last_local.getJcIndex() + size;
            }
        }
        return this.jc_locals;
    }

    private void constructLocalVariables() throws Exception {
        int i;
        JCodeAttr code_attr = this.method_converter.getJavaMethod().getCodeAttr();
        JLocalVarTableAttr java_local_var_table = code_attr.getLocalVarTableAttr();
        JLocalVariable[] java_locals = java_local_var_table.getLocalVars();
        int max_j_local_index = -1;
        for (i = 0; i < java_locals.length; ++i) {
            if (max_j_local_index >= java_locals[i].getIndex()) continue;
            max_j_local_index = java_locals[i].getIndex();
        }
        this.jc_locals = new JcLocalVariable[max_j_local_index + 1];
        for (i = 0; i < this.jc_locals.length; ++i) {
            this.jc_locals[i] = null;
        }
        for (i = 0; i < java_locals.length; ++i) {
            JcLocalVariable jc_local = new JcLocalVariable(java_locals[i]);
            jc_local.setVarTypeKnown(true);
            int index = java_locals[i].getIndex();
            jc_local.setNext(this.jc_locals[index]);
            this.jc_locals[index] = jc_local;
        }
    }

    private int computeJcIndex(JcLocalVariable jc_local) {
        int j_index = jc_local.getJIndex();
        if (j_index == 0) {
            return 0;
        }
        JcLocalVariable prev_local = this.jc_locals[j_index - 1];
        int cur_index = 2;
        while (prev_local == null) {
            if (j_index - cur_index < 0) {
                return 0;
            }
            prev_local = this.jc_locals[j_index - cur_index];
            ++cur_index;
        }
        int jc_index = 0;
        while (prev_local != null) {
            int prev_jc_index = prev_local.getJcIndex();
            if (prev_local.getDescriptor().equals("I")) {
                if (jc_index < prev_jc_index + 2) {
                    jc_index = prev_jc_index + 2;
                }
            } else if (jc_index < prev_jc_index + 1) {
                jc_index = prev_jc_index + 1;
            }
            prev_local = prev_local.getNext();
        }
        return jc_index;
    }

    public int getUndefinedLocalVariablesSize() {
        if (this.undefined_locals[this.undefined_local_max_index] == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < this.undefined_locals.length; ++i) {
            if (this.undefined_locals[i] == null) continue;
            if (this.undefined_locals[i].getType() == 3 || this.undefined_locals[i].isPromoted()) {
                size += 2;
                continue;
            }
            ++size;
        }
        return size;
    }

    public int getDefinedLocalVariablesSize() {
        return this.defined_local_size;
    }

    public void updateJcLocalVariable(int j_index, String type) {
        if (this.jc_locals.length > j_index && this.jc_locals[j_index] != null) {
            System.out.println("WARNING:: updateJcLocalVariable called on defined local variable");
        }
        if (this.undefined_locals[j_index] == null) {
            this.addToUndefHelper(j_index, type);
            return;
        }
        this.undefined_locals[j_index].setDescriptor(type);
        this.recomputeUndefIndexes(j_index);
    }

    public JcLocalVariable getJcLocalVariable(int j_index) {
        if (this.jc_locals.length > j_index && this.jc_locals[j_index] != null) {
            return this.jc_locals[j_index];
        }
        return this.undefined_locals[j_index];
    }

    private int evaluateStartPC(InstrContainer jinstrC, int origStartPC) {
        while (jinstrC.getPrevInstrContainer() != null) {
            if (jinstrC.getControlFlowLabelFlag() || jinstrC.getJInstr().getOpcode() >= 54 && jinstrC.getJInstr().getOpcode() <= 86) {
                return jinstrC.getJInstr().getPC();
            }
            jinstrC = jinstrC.getPrevInstrContainer();
        }
        return jinstrC.getJInstr().getPC();
    }

    private InstrContainer getJInstr(int pc) {
        for (InstrContainer anyInstr = this.method_converter.getInstrContainers(); anyInstr != null; anyInstr = anyInstr.getNextInstrContainer()) {
            if (anyInstr.getJInstr().getPC() != pc) continue;
            return anyInstr;
        }
        return null;
    }

    public JcLocalVariable getJcLocalVariable(int j_index, JInstruction java_instr) {
        if (j_index >= this.jc_locals.length) {
            return this.addUndefinedLocalVariable(j_index, java_instr);
        }
        int pc = java_instr.getPC();
        for (JcLocalVariable local = this.jc_locals[j_index]; local != null; local = local.getNext()) {
            int j_start_pc = this.getJInstr(local.getJStartPC()).isCatchFinallyBlockLeader() ? local.getJStartPC() : local.getJStartPC() - 2;
            int j_length = local.getJLength() + (local.getJStartPC() - j_start_pc);
            if (j_start_pc > pc || pc > j_start_pc + j_length) continue;
            return local;
        }
        return this.addUndefinedLocalVariable(j_index, java_instr);
    }

    private JcLocalVariable addUndefinedLocalVariable(int j_index, JInstruction java_instr) {
        int opcode = java_instr.getOpcode();
        int type = this.getOpcodeType(opcode);
        if (!this.method_converter.isIntSupported()) {
            if (type == 2) {
                return new JcLocalVariable("undefined", "L", j_index, j_index);
            }
            return new JcLocalVariable("undefined", "S", j_index, j_index);
        }
        if (this.undefined_locals[j_index] != null) {
            if (DataType.getType(this.undefined_locals[j_index].getDescriptor()) == 10 && type != 2) {
                this.undefined_locals[j_index].setMultiType(true);
                if (this.undefined_locals[j_index].isPromoted()) {
                    this.undefined_locals[j_index].setDescriptor("I");
                } else {
                    this.undefined_locals[j_index].setDescriptor("S");
                }
            } else if (DataType.getType(this.undefined_locals[j_index].getDescriptor()) != 10 && type == 2) {
                this.undefined_locals[j_index].setMultiType(true);
                this.undefined_locals[j_index].setDescriptor("L");
            }
            return this.undefined_locals[j_index];
        }
        return this.addToUndef(j_index, java_instr);
    }

    private JcLocalVariable addToUndef(int j_index, JInstruction java_instr) {
        int opcode = java_instr.getOpcode();
        int type = this.getOpcodeType(opcode);
        if (type == 2) {
            return this.addToUndefHelper(j_index, "L");
        }
        return this.addToUndefHelper(j_index, "S");
    }

    private JcLocalVariable addToUndefHelper(int j_index, String type) {
        JcLocalVariable newVar;
        this.undefined_locals[j_index] = newVar = new JcLocalVariable("undefined", type, j_index, 0);
        if (this.undefined_local_max_index < j_index) {
            this.undefined_local_max_index = j_index;
        }
        JcLocalVariable lastUndefVar = this.getLastUndefLocalVar(j_index);
        JcLocalVariable lastDefVar = this.getLastDefLocalVar(j_index);
        JcLocalVariable lastVar = this.getLastVar(lastDefVar, lastUndefVar);
        if (lastVar == null) {
            newVar.setJcIndex(0);
        } else if (lastVar.getType() == 3) {
            newVar.setJcIndex(lastVar.getJcIndex() + 2);
        } else {
            newVar.setJcIndex(lastVar.getJcIndex() + 1);
        }
        if (this.undefined_local_max_index > j_index) {
            throw new RecalculateIndexException(j_index);
        }
        return newVar;
    }

    private JcLocalVariable getLastUndefLocalVar(int j_index) {
        if (j_index == 0) {
            return null;
        }
        --j_index;
        while (j_index > 0 && this.undefined_locals[j_index] == null) {
            --j_index;
        }
        return this.undefined_locals[j_index];
    }

    private JcLocalVariable getLastDefLocalVar(int j_index) {
        if (j_index == 0 || this.jc_locals.length == 0) {
            return null;
        }
        int res_index = 0;
        for (int i = 0; i < this.jc_locals.length; ++i) {
            if (this.jc_locals[i] == null) continue;
            res_index = i;
        }
        return this.jc_locals[res_index];
    }

    private JcLocalVariable getLastVar(JcLocalVariable lastDefVar, JcLocalVariable lastUndefVar) {
        if (lastUndefVar == null && lastDefVar == null) {
            return null;
        }
        if (lastUndefVar == null && lastDefVar != null) {
            return lastDefVar;
        }
        if (lastUndefVar != null && lastDefVar == null) {
            return lastUndefVar;
        }
        if (lastUndefVar != null && lastDefVar != null && lastDefVar.getJcIndex() > lastUndefVar.getJcIndex()) {
            return lastDefVar;
        }
        return lastUndefVar;
    }

    public void recomputeUndefIndexes(int j_index) {
        for (int i = j_index + 1; i <= this.undefined_local_max_index; ++i) {
            if (this.undefined_locals[i] == null) continue;
            JcLocalVariable lastVar = null;
            JcLocalVariable lastUndefVar = this.getLastUndefLocalVar(i);
            JcLocalVariable lastDefVar = this.getLastDefLocalVar(i);
            lastVar = this.getLastVar(lastDefVar, lastUndefVar);
            if (lastVar == null) {
                return;
            }
            if (lastVar.getType() == 3 || lastVar.isPromoted()) {
                this.undefined_locals[i].setJcIndex(lastVar.getJcIndex() + 2);
                continue;
            }
            this.undefined_locals[i].setJcIndex(lastVar.getJcIndex() + 1);
        }
    }

    private int getOpcodeType(int opcode) {
        switch (opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 132: 
            case 196: {
                return 1;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                return 2;
            }
        }
        throw new ClassFormatError();
    }

    private void getParameters() {
        String method_desc = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] param_descs = MethodDescriptor.getParamDescriptors(method_desc);
        int j_index = 0;
        if (!this.method_converter.getJavaMethod().isStatic()) {
            JcLocalVariable var = this.addToUndefHelper(j_index++, "L");
            var.setVarTypeKnown(true);
        }
        for (int i = 0; i < param_descs.length; ++i) {
            if (param_descs[i].equals("V")) continue;
            JcLocalVariable var = this.addToUndefHelper(j_index++, param_descs[i]);
            var.setVarTypeKnown(true);
        }
    }

    private void checkParameters() throws Exception {
        String method_desc = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] param_descs = MethodDescriptor.getParamDescriptors(method_desc);
        if (param_descs.length != 0) {
            Notifier.error("conversion.20", this.method_converter.getClassName().replace('/', '.'));
            throw new ConversionException();
        }
    }
}

