/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterHarness;
import com.sun.javacard.converter.checkers.ReferenceChecker;
import com.sun.javacard.converter.checkers.SubsetChecker;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.efbuilder.ExportFileBuilder;
import com.sun.javacard.converter.jcawriter.JcaWriter;
import com.sun.javacard.converter.optimizers.Optimizer;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;

public class Converter {
    public static final byte CONVERTER_MAJOR_VERSION = 1;
    public static final byte CONVERTER_MINOR_VERSION = 2;
    public static final byte CAP_MAJOR_VERSION = 2;
    public static final byte CAP_MINOR_VERSION = 1;
    public static final byte EXP_MAJOR_VERSION = 2;
    public static final byte EXP_MINOR_VERSION = 1;
    public static final byte JCA_MAJOR_VERSION = 2;
    public static final byte JCA_MINOR_VERSION = 1;
    public static final int SUPPORTED_CLASSFILE_MAJOR_VERSION = 45;
    public static final int MIN_SUPPORTED_CLASSFILE_MINOR_VERSION = 0;
    public static final int MAX_SUPPORTED_CLASSFILE_MINOR_VERSION = 65535;
    private ConversionProfile conversion_profile;
    private JPackage java_package;
    private JcPackage jc_package;
    private ExportFileManager export_file_manager;

    public Converter(ConversionProfile conversion_profile) {
        this.conversion_profile = conversion_profile;
        int i = 0;
        while (i < conversion_profile.applets_profile.length) {
            String name = conversion_profile.applets_profile[i].install_class;
            if (name.indexOf(46) < 0 && name.indexOf(47) < 0) {
                this.conversion_profile.applets_profile[i].install_class = name = (String.valueOf(conversion_profile.package_profile.package_name) + '.' + name).replace('.', '/');
            }
            ++i;
        }
        this.export_file_manager = new ExportFileManager(conversion_profile.export_path);
    }

    private void checkAidConsistency() throws Exception {
        if (this.conversion_profile.package_profile.aid.length < 5) {
            Notifier.error("binary.50");
            throw new ConverterException();
        }
        if (this.conversion_profile.applets_profile.length == 0) {
            return;
        }
        byte[] pAID = this.conversion_profile.package_profile.aid;
        byte[] pRID = new byte[]{pAID[0], pAID[1], pAID[2], pAID[3], pAID[4]};
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < this.conversion_profile.applets_profile.length) {
            Object[] args;
            AppletProfile aProf = this.conversion_profile.applets_profile[i];
            byte[] aAID = this.conversion_profile.applets_profile[i].aid;
            if (aAID.length < 5) {
                Notifier.error("binary.51");
                throw new ConverterException();
            }
            byte[] aRID = new byte[]{aAID[0], aAID[1], aAID[2], aAID[3], aAID[4]};
            if (Arrays.equals(pAID, aAID)) {
                Notifier.error("binary.53");
                throw new ConverterException();
            }
            if (!Arrays.equals(pRID, aRID)) {
                Notifier.error("binary.52");
                throw new ConverterException();
            }
            String aName = this.conversion_profile.applets_profile[i].install_class;
            JcClass jcC = this.jc_package.getClass(aName);
            if (jcC == null) {
                args = new Object[]{aName, this.jc_package.getPackageName().replace('/', '.')};
                Notifier.error("binary.54", args);
                throw new ConverterException();
            }
            if (!jcC.isApplet()) {
                args = new Object[]{aName};
                Notifier.error("binary.55", args);
                throw new ConverterException();
            }
            String s = Strings.toHexString(aAID, ":");
            if (hs.contains(s)) {
                Object[] args2 = new Object[]{s};
                Notifier.error("binary.56", args2);
                throw new ConverterException();
            }
            hs.add(s);
            ++i;
        }
    }

    private void checkBinaryCompatibility(EfExportFile ex_file) throws Exception {
        if (ex_file.getPackageMajorVersion() != this.conversion_profile.package_profile.major_version) {
            Object[] args = new Object[]{Names.getExportFileName(ex_file.getPackageName()), "major", "major"};
            Notifier.error("binary.2", args);
            throw new ConverterException();
        }
        if (ex_file.getPackageMinorVersion() > this.conversion_profile.package_profile.minor_version) {
            Object[] args = new Object[]{Names.getExportFileName(ex_file.getPackageName()), "minor", "minor"};
            Notifier.error("binary.2", args);
            throw new ConverterException();
        }
        if (ex_file.getPackageMinorVersion() == this.conversion_profile.package_profile.minor_version) {
            this.conversion_profile.packageUpgrade = false;
            Notifier.progress("progress.4");
        } else {
            this.conversion_profile.packageUpgrade = true;
            Notifier.progress("progress.5");
        }
    }

    private void checkClassFileVersion() {
        JClassFile[] java_classes = this.java_package.getClasses();
        int i = 0;
        while (i < java_classes.length) {
            Object[] args;
            int major_version = java_classes[i].getMajorVersion();
            int minor_version = java_classes[i].getMinorVersion();
            String version_string = String.valueOf(String.valueOf(major_version)) + "." + String.valueOf(minor_version);
            if (major_version != 45) {
                args = new String[]{java_classes[i].getClassName().replace('/', '.'), version_string};
                Notifier.error("conversion.3", args);
            }
            if (minor_version < 0 || minor_version > 65535) {
                args = new String[]{java_classes[i].getClassName().replace('/', '.'), version_string};
                Notifier.error("conversion.3", args);
            }
            ++i;
        }
    }

    private void checkError() throws Exception {
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
    }

    public void convert() throws Exception {
        if (this.conversion_profile.this_exp_provided) {
            EfExportFile ex_file = this.export_file_manager.load(this.conversion_profile.package_profile.package_name);
            this.checkBinaryCompatibility(ex_file);
        } else if (this.conversion_profile.package_profile.minor_version > 0) {
            Notifier.warning("warning.9");
        }
        this.java_package = new JPackage(this.conversion_profile.package_profile.package_name);
        this.java_package.parse(this.conversion_profile.classes);
        this.java_package.resolve();
        if (this.java_package.getClasses().length == 0) {
            Notifier.error("conversion.0", this.java_package.getPackageName().replace('/', '.'));
        }
        this.checkError();
        this.checkClassFileVersion();
        this.checkError();
        SubsetChecker subset_checker = new SubsetChecker(this.conversion_profile);
        subset_checker.check(this.java_package);
        this.checkError();
        PackageConverter p_converter = new PackageConverter(this.java_package, this.conversion_profile, this.export_file_manager);
        this.jc_package = p_converter.convert();
        this.checkError();
        this.checkAidConsistency();
        this.checkError();
        boolean check_export_only = false;
        if (this.conversion_profile.output == 2) {
            check_export_only = true;
        }
        ReferenceChecker reference_checker = new ReferenceChecker(this.jc_package, this.export_file_manager, check_export_only);
        reference_checker.check();
        this.checkError();
        subset_checker.check(this.jc_package);
        this.checkError();
        Optimizer optimizer = new Optimizer(this.jc_package);
        this.jc_package = optimizer.optimize();
        this.checkError();
        File output_path = this.determineOutputPath();
        if ((this.conversion_profile.output & 2) != 0) {
            ExportFileBuilder ef_generator = new ExportFileBuilder(this.jc_package, this.conversion_profile);
            EfExportFile ef_file = ef_generator.build();
            this.outputExportFile(ef_file, output_path);
        }
        this.checkError();
        if ((this.conversion_profile.output & 4) != 0) {
            this.outputJCAFile(output_path);
            if (this.conversion_profile.debug) {
                this.outputDebugComponent(output_path);
            }
        }
        this.checkError();
    }

    private File determineOutputPath() throws Exception {
        String path = this.conversion_profile.output_dir;
        String package_name = this.conversion_profile.package_profile.package_name;
        char c = File.separatorChar;
        String package_dir = String.valueOf(package_name.replace('/', c)) + c + "javacard";
        File output_dir = new File(path, package_dir);
        if (output_dir.isFile()) {
            Notifier.error("converter.2");
            throw new ConverterException();
        }
        if (!output_dir.exists()) {
            output_dir.mkdirs();
        }
        return output_dir;
    }

    public static void main(String[] args) {
        ConverterHarness.main(args);
    }

    private void outputDebugComponent(File output_path) throws Exception {
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcClass jc_class = jc_classes[i];
            JcMethod[] jc_methods = jc_class.getMethods();
            int j = 0;
            while (j < jc_methods.length) {
                JcMethod jc_method = jc_methods[j];
                JcInstruction code = jc_method.getCode();
                int pc = 0;
                while (code != null) {
                    code.setPC(pc);
                    pc += code.getSizeInBytes();
                    code = code.getNextInstr();
                }
                ++j;
            }
            ++i;
        }
        Globals.debugComp = new DebugComponent(this.jc_package);
        String debug_comp_name = "debug.cap";
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            Globals.debugComp.toBinary(dos);
            dos.flush();
            Globals.outputDebugData = bos.toByteArray();
            dos.close();
            bos.close();
            if (this.conversion_profile.mask) {
                File file = new File(output_path, "debug.msk");
                FileOutputStream fos = new FileOutputStream(file);
                DataOutputStream dosMsk = new DataOutputStream(new BufferedOutputStream(fos));
                Globals.debugComp.toBinary(dosMsk);
                dosMsk.flush();
                dosMsk.close();
                fos.close();
            }
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", debug_comp_name);
            throw new ConverterException();
        }
    }

    private void outputExportFile(EfExportFile ef_file, File output_path) throws Exception {
        String ef_file_name = Names.getExportFileName(ef_file.getPackageName());
        File file = new File(output_path, ef_file_name);
        if (file.isFile() && !file.canWrite()) {
            Notifier.error("converter.3", ef_file_name);
            throw new ConverterException();
        }
        try {
            Notifier.progress("progress.3", file.getCanonicalPath());
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));
            ef_file.toBinary(dos);
            dos.flush();
            dos.close();
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", ef_file_name);
            throw new ConverterException();
        }
    }

    private void outputJCAFile(File output_path) throws Exception {
        JcaWriter jca_writer = new JcaWriter(this.jc_package, this.conversion_profile, this.export_file_manager);
        String jca_file_name = Names.getJcaFileName(this.jc_package.getPackageName());
        File file = new File(output_path, jca_file_name);
        if (file.isFile() && !file.canWrite()) {
            Notifier.error("converter.3", jca_file_name);
            throw new ConverterException();
        }
        try {
            Notifier.progress("progress.3", file.getCanonicalPath());
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            jca_writer.write(pw);
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", jca_file_name);
            throw new ConverterException();
        }
    }
}

