/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.CapWriter;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class CapGen {
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    JCPackage f_package;
    HeaderComponent f_header;
    ImportComponent f_import;
    AppletComponent f_applet;
    ConstantPoolComponent f_constantPool;
    ClassComponent f_class;
    MethodComponent f_method;
    StaticFieldComponent f_staticField;
    ExportComponent f_export;
    ReferenceLocationComponent f_refLocation;
    DescriptorComponent f_descriptor;
    DirectoryComponent f_directory;

    public void gen(JCPackage pack, File outFile) throws IOException {
        this.f_package = pack;
        this.f_method = this.genMethodComponent(this.f_package);
        this.f_staticField = this.genStaticFieldComponent(this.f_package);
        this.f_class = this.genClassComponent(this.f_package);
        this.f_import = this.genImportComponent(this.f_package);
        this.f_applet = this.genAppletComponent(this.f_package);
        this.f_constantPool = this.genConstantPoolComponent(this.f_package);
        this.f_export = this.genExportComponent(this.f_package);
        this.f_refLocation = this.genReferenceLocationComponent(this.f_package);
        this.f_descriptor = this.genDescriptorComponent(this.f_package);
        this.f_header = this.genHeaderComponent(this.f_package);
        this.f_directory = new DirectoryComponent(this.f_package, this.f_header, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor);
        this.f_directory.addDebugComponent(Globals.debugComp);
        if (Globals.errors == 0 && Globals.debug) {
            String lead = "// " + this.f_package.getName() + "/javacard/";
            if ((Globals.debugLevel & 1) != 0) {
                System.out.println(String.valueOf(lead) + "Header.cap" + Msg.eol + this.f_header);
            }
            if ((Globals.debugLevel & 2) != 0) {
                System.out.println(String.valueOf(lead) + "Directory.cap" + Msg.eol + this.f_directory);
            }
            if ((Globals.debugLevel & 4) != 0 && this.f_applet != null) {
                System.out.println(String.valueOf(lead) + "Applet.cap" + Msg.eol + this.f_applet);
            }
            if ((Globals.debugLevel & 8) != 0) {
                System.out.println(String.valueOf(lead) + "Import.cap" + Msg.eol + this.f_import);
            }
            if ((Globals.debugLevel & 0x10) != 0) {
                System.out.println(String.valueOf(lead) + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
            }
            if ((Globals.debugLevel & 0x20) != 0) {
                System.out.println(String.valueOf(lead) + "Class.cap" + Msg.eol + this.f_class);
            }
            if ((Globals.debugLevel & 0x40) != 0) {
                System.out.println(String.valueOf(lead) + "Method.cap" + Msg.eol + this.f_method);
            }
            if ((Globals.debugLevel & 0x80) != 0) {
                System.out.println(String.valueOf(lead) + "StaticField.cap" + Msg.eol + this.f_staticField);
            }
            if ((Globals.debugLevel & 0x100) != 0) {
                System.out.println(String.valueOf(lead) + "RefLocation.cap" + Msg.eol + this.f_refLocation);
            }
            if ((Globals.debugLevel & 0x200) != 0 && this.f_export != null) {
                System.out.println(String.valueOf(lead) + "Export.cap" + Msg.eol + this.f_export);
            }
            if ((Globals.debugLevel & 0x400) != 0) {
                System.out.println(String.valueOf(lead) + "Descriptor.cap" + Msg.eol + this.f_descriptor);
            }
        }
        CapWriter cw = new CapWriter(outFile, this.f_package.getName());
        cw.publish(this.f_header, this.f_directory, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor);
    }

    AppletComponent genAppletComponent(JCPackage p) {
        if (p.appletCount() == 0) {
            return null;
        }
        AppletComponent a = new AppletComponent(p);
        Enumeration f = p.appletElements();
        while (f.hasMoreElements()) {
            a.add((AppletDeclarator)f.nextElement());
        }
        return a;
    }

    ClassComponent genClassComponent(JCPackage p) {
        ClassComponent cl = new ClassComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            cl.add((JCClass)f.nextElement());
        }
        cl.assignAddresses();
        return cl;
    }

    ConstantPoolComponent genConstantPoolComponent(JCPackage p) {
        ConstantPoolComponent cp = new ConstantPoolComponent(p);
        Enumeration f = p.constantPoolElements();
        while (f.hasMoreElements()) {
            cp.add((Info)f.nextElement());
        }
        return cp;
    }

    DescriptorComponent genDescriptorComponent(JCPackage p) {
        DescriptorComponent d = new DescriptorComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            d.add((JCClass)f.nextElement());
        }
        return d;
    }

    ExportComponent genExportComponent(JCPackage p) {
        ExportComponent e = new ExportComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            e.add((JCClass)f.nextElement());
        }
        if (e.dataSize() > 1) {
            return e;
        }
        return null;
    }

    HeaderComponent genHeaderComponent(JCPackage p) {
        int flags = 0;
        if (p.usesIntegers()) {
            flags = 1;
        }
        if (this.f_export != null && this.f_export.size() >= 4) {
            flags |= 2;
        }
        if (p.appletCount() > 0) {
            flags |= 4;
        }
        return new HeaderComponent(p, p.getIdentifier().getAid(), p.getIdentifier().getMajorVersion(), p.getIdentifier().getMinorVersion(), flags);
    }

    ImportComponent genImportComponent(JCPackage p) {
        ImportComponent i = new ImportComponent(p);
        Enumeration f = p.importElements();
        while (f.hasMoreElements()) {
            i.add((PackageIdentifier)f.nextElement());
        }
        return i;
    }

    MethodComponent genMethodComponent(JCPackage p) {
        MethodComponent m = new MethodComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            m.add((JCClass)f.nextElement());
        }
        m.assignAddresses();
        return m;
    }

    ReferenceLocationComponent genReferenceLocationComponent(JCPackage p) {
        ReferenceLocationComponent rl = new ReferenceLocationComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            rl.addException((JCClass)f.nextElement());
        }
        Enumeration f2 = p.classElements();
        while (f2.hasMoreElements()) {
            rl.add((JCClass)f2.nextElement());
        }
        return rl;
    }

    StaticFieldComponent genStaticFieldComponent(JCPackage p) {
        StaticFieldComponent sf = new StaticFieldComponent(p);
        Enumeration f = p.classElements();
        while (f.hasMoreElements()) {
            sf.add((JCClass)f.nextElement());
        }
        sf.assignAddresses();
        return sf;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lead = "// " + this.f_package.getName() + "/javacard/";
        sb.append(String.valueOf(lead) + "Header.cap" + Msg.eol + this.f_header);
        sb.append(String.valueOf(lead) + "Directory.cap" + Msg.eol + this.f_directory);
        if (this.f_applet != null) {
            sb.append(String.valueOf(lead) + "Applet.cap" + Msg.eol + this.f_applet);
        }
        sb.append(String.valueOf(lead) + "Import.cap" + Msg.eol + this.f_import);
        sb.append(String.valueOf(lead) + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
        sb.append(String.valueOf(lead) + "Class.cap" + Msg.eol + this.f_class);
        sb.append(String.valueOf(lead) + "Method.cap" + Msg.eol + this.f_method);
        sb.append(String.valueOf(lead) + "StaticField.cap" + Msg.eol + this.f_staticField);
        sb.append(String.valueOf(lead) + "RefLocation.cap" + Msg.eol + this.f_refLocation);
        if (this.f_export != null) {
            sb.append(String.valueOf(lead) + "Export.cap" + Msg.eol + this.f_export);
        }
        sb.append(String.valueOf(lead) + "Descriptor.cap" + Msg.eol + this.f_descriptor);
        return sb.toString();
    }
}

