/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.events.BreakPointsHandler;
import com.oracle.javacard.jcdebugproxy.events.BreakPointsPool;
import com.oracle.javacard.jcdebugproxy.events.EncodingUtils;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MethodEnterHandler
extends BreakPointsHandler {
    public MethodEnterHandler(BreakPointsPool locations) {
        super(locations);
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVm) throws Exception {
        Integer offsetRef = (Integer)state.args.get("breakpoints-offset");
        int offset = offsetRef == null ? 0 : offsetRef;
        ArrayList<Location> registered = (ArrayList<Location>)state.args.get("breakpoints");
        if (registered == null) {
            registered = new ArrayList<Location>();
            state.args.put("breakpoints", registered);
            this.locations.register(filter);
            this.updateMethodEntryRequest(registered, filter, this.proxy.state().classes().getClasses());
            if (registered.isEmpty()) {
                return ClassicPacketHandler.DeliveryType.NONE;
            }
        }
        offset += this.encodeBreakPointCommands(VMPacketHandler.CommandCode.EVENTS, toVm, registered, offset);
        state.args.put("breakpoints-offset", offset);
        return offset >= registered.size() ? ClassicPacketHandler.DeliveryType.IMMEDIATELY : ClassicPacketHandler.DeliveryType.NOT_COMPLETED;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVm) throws Exception {
        Integer offsetRef = (Integer)state.args.get("breakpoints-offset");
        int offset = offsetRef == null ? 0 : offsetRef;
        ArrayList<Location> toRm = (ArrayList<Location>)state.args.get("breakpoints");
        if (toRm == null) {
            toRm = new ArrayList<Location>();
            List<EventFilter> filters = this.locations.unregisterAll(toRm, new BreakPointsPool.IDFilter(id));
            state.args.put("breakpoints", toRm);
            if (filters.isEmpty()) {
                return ClassicPacketHandler.DeliveryType.NONE;
            }
            state.args.put("event-filters", filters);
            for (EventFilter filter : filters) {
                filter.state = EventFilter.State.DisablingInProcess;
            }
        }
        offset += this.encodeBreakPointCommands(VMPacketHandler.CommandCode.EVENTS, toVm, toRm, offset);
        state.args.put("breakpoints-offset", offset);
        return offset >= toRm.size() ? ClassicPacketHandler.DeliveryType.IMMEDIATELY : ClassicPacketHandler.DeliveryType.NOT_COMPLETED;
    }

    @Override
    public void handleClearConfirmation(HandlerState state, DataInputStream fromVM, int length) throws Exception {
        super.handleClearConfirmation(state, fromVM, length);
    }

    private void updateMethodEntryRequest(Collection<Location> registered, EventFilter filter, Collection<ClassDebugInfo> classes) {
        OnCardEvent event = new OnCardEvent();
        Kind kind = filter.getKind();
        if (kind != Kind.MethodEntry) {
            return;
        }
        Iterator<ClassDebugInfo> i$ = classes.iterator();
        while (i$.hasNext()) {
            ClassDebugInfo info;
            event.clInfo = info = i$.next();
            if (!(info instanceof ClassFileTokens.ClassDebugInfoImpl) || ((ClassFileTokens.ClassDebugInfoImpl)info).isSyntetic || !filter.filter(event)) continue;
            for (MethodDebugInfo meth : info.getAllMethodInfo()) {
                Location location;
                if (meth.getCodeAttributeLength() == 0L || !this.locations.register(location = EncodingUtils.createLocation(info, meth, 0L), filter)) continue;
                registered.add(location);
            }
        }
    }

    public void classesAreLoaded(List<ClassDebugInfo> list) throws Exception {
        HashSet<Location> newLocations = new HashSet<Location>();
        for (EventFilter filter : this.locations.getAllRequests(new BreakPointsPool.KindFilter(Kind.MethodEntry))) {
            this.updateMethodEntryRequest(newLocations, filter, list);
        }
        if (!newLocations.isEmpty()) {
            this.sendBreakPoints(VMPacketHandler.CommandCode.EVENTS, new ArrayList<Location>(newLocations));
        }
    }
}

