/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import com.sun.javacard.debugproxy.comm.Packet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.logging.Logger;

public final class Commands {
    public static final int VIRTUALMACHINE_CMDSET = 1;
    public static final int SENDVERSION_CMD = 1;
    public static final int CLASSESBYSIG_CMD = 2;
    public static final int ALL_CLASSES_CMD = 3;
    public static final int ALL_THREADS_CMD = 4;
    public static final int TOPLEVELTHREADGROUP_CMD = 5;
    public static final int DISPOSE_CMD = 6;
    public static final int IDSIZES_CMD = 7;
    public static final int SUSPEND = 8;
    public static final int RESUME = 9;
    public static final int EXIT_CMD = 10;
    public static final int CREATE_STRING_CMD = 11;
    public static final int CAPABILITIES_CMD = 12;
    public static final int CLASSPATHS_CMD = 13;
    public static final int DISPOSE_OBJECTS_CMD = 14;
    public static final int HOLD_EVENTS_CMD = 15;
    public static final int RELEASE_EVENTS_CMD = 16;
    public static final int CAPABILITIES_NEW_CMD = 17;
    public static final int REDEFINE_CLASSES_CMD = 18;
    public static final int SET_DEFAULT_STRATUM_CMD = 19;
    public static final int REFERENCE_TYPE_CMDSET = 2;
    public static final int SIGNATURE_CMD = 1;
    public static final int CLASSLOADER_CMD = 2;
    public static final int MODIFIERS_CMD = 3;
    public static final int FIELDS_CMD = 4;
    public static final int METHODS_CMD = 5;
    public static final int GET_VALUES_CMD = 6;
    public static final int SOURCEFILE_CMD = 7;
    public static final int NESTED_TYPES_CMD = 8;
    public static final int STATUS_CMD = 9;
    public static final int INTERFACES_CMD = 10;
    public static final int CLASS_OBJECT_CMD = 11;
    public static final int SOURCE_DEBUG_EXTENSION_CMD = 12;
    public static final int CLASS_TYPE_CMDSET = 3;
    public static final int SUPERCLASS_CMD = 1;
    public static final int SET_VALUES_CMD = 2;
    public static final int INVOKE_METHOD_CMD = 3;
    public static final int NEW_INSTANCE_CMD = 4;
    public static final int ARRAY_TYPE_CMDSET = 4;
    public static final int ARRAY_TYPE_NEW_INSTANCE_CMD = 1;
    public static final int METHOD_CMDSET = 6;
    public static final int METHOD_LINETABLE_CMD = 1;
    public static final int METHOD_VARIABLETABLE_CMD = 2;
    public static final int METHOD_BYTECODES_CMD = 3;
    public static final int METHOD_IS_OBSOLETE_CMD = 4;
    public static final int OBJECTREFERENCE_CMDSET = 9;
    public static final int OBJECTREFERENCE_REFERENCETYPE_CMD = 1;
    public static final int OBJECTREFERENCE_GET_VALUES_CMD = 2;
    public static final int OBJECTREFERENCE_SET_VALUES_CMD = 3;
    public static final int OBJECTREFERENCE_MONITOR_INFO_CMD = 5;
    public static final int OBJECTREFERENCE_INVOKE_METHOD_CMD = 6;
    public static final int OBJECTREFERENCE_DISABLE_COLLECTION_CMD = 7;
    public static final int OBJECTREFERENCE_ENABLE_COLLECTION_CMD = 8;
    public static final int OBJECTREFERENCE_IS_COLLECTED_CMD = 9;
    public static final int STRINGREFERENCE_CMDSET = 10;
    public static final int STRINGREFERENCE_VALUE_CMD = 1;
    public static final int THREADREFERENCE_CMDSET = 11;
    public static final int THREAD_NAME_CMD = 1;
    public static final int THREAD_SUSPEND_CMD = 2;
    public static final int THREAD_RESUME_CMD = 3;
    public static final int THREAD_STATUS_CMD = 4;
    public static final int THREAD_THREADGROUP_CMD = 5;
    public static final int THREAD_FRAMES_CMD = 6;
    public static final int THREAD_FRAME_COUNT_CMD = 7;
    public static final int THREAD_OWNED_MONITORS_CMD = 8;
    public static final int THREAD_CURRENT_CONTENDED_MONITOR_CMD = 9;
    public static final int THREAD_STOP_CMD = 10;
    public static final int THREAD_INTERRUPT_CMD = 11;
    public static final int THREAD_SUSPENDCOUNT_CMD = 12;
    public static final int THREADGROUPREFERENCE_CMDSET = 12;
    public static final int THREADGROUP_NAME_CMD = 1;
    public static final int THREADGROUP_PARENT_CMD = 2;
    public static final int THREADGROUP_CHILDREN_CMD = 3;
    public static final int ARRAYREFERENCE_CMDSET = 13;
    public static final int ARRAYREFERENCE_LENGTH_CMD = 1;
    public static final int ARRAYREFERENCE_GET_VALUES_CMD = 2;
    public static final int ARRAYREFERENCE_SET_VALUES_CMD = 3;
    public static final int CLASSLOADERREFERENCE_CMDSET = 14;
    public static final int CLASSLOADERREFERENCE_VISIBLE_CLASSES_CMD = 1;
    public static final int EVENT_REQUEST_CMDSET = 15;
    public static final int SET = 1;
    public static final int CLEAR = 2;
    public static final int CLEAR_ALL_BREAKPOINTS = 3;
    public static final int STACKFRAME_CMDSET = 16;
    public static final int STACKFRAME_GETVALUES_CMD = 1;
    public static final int STACKFRAME_SETVALUES_CMD = 2;
    public static final int STACKFRAME_THISOBJECT_CMD = 3;
    public static final int STACKFRAME_POPFRAME_CMD = 4;
    public static final int CLASSOBJECTREFERENCE_CMDSET = 17;
    public static final int REFLECTEDTYPE_CMD = 1;
    public static final int EVENT_CMDSET = 64;
    public static final int COMPOSITE_CMD = 100;
    public static final int KVM_CMDSET = 128;
    public static final int KVM_HANDSHAKE_CMD = 1;
    public static final int KVM_GET_STEPPINGINFO_CMD = 2;
    public static final int KVM_STEPPING_EVENT_CMD = 3;
    public static final byte JDWP_TYPE_TAG_ARRAY = 3;
    public static final byte JDWP_EVENT_KIND_CLASS_PREPARE = 8;
    public static final int CLASS_PREPARED = 2;
    public static final int CLASS_INITIALIZED = 4;
    public static final byte TYPE_TAG_CLASS = 1;
    public static final byte TYPE_TAG_ARRAY = 3;
    public static final int ONLY_THREADGROUP_ID = -32;
    public static final int ONLY_THREAD_ID = -31;
    public static final String KVM_THREADGROUP_NAME = "JavaCard_System";
    public static final byte JDWP_TAG_ARRAY = 91;
    public static final byte JDWP_TAG_BYTE = 66;
    public static final byte JDWP_TAG_OBJECT = 76;
    public static final byte JDWP_TAG_INT = 73;
    public static final byte JDWP_TAG_SHORT = 83;
    public static final byte JDWP_TAG_VOID = 86;
    public static final byte JDWP_TAG_BOOLEAN = 90;
    public static final byte JDWP_TAG_STRING = 115;
    public static final byte JDWP_TAG_THREAD = 116;
    public static final byte JDWP_TAG_THREAD_GROUP = 103;
    public static final byte JDWP_TAG_CLASS_OBJECT = 99;
    public static final int INVOKE_NONVIRTUAL = 2;
    public static final int INVALID_METHOD_ID = 23;
    public static final int INVALID_THREAD_ID = 10;
    public static final byte SUSPEND_NONE = 0;
    public static final byte SUSPEND_EVENT_THREAD = 1;
    public static final byte SUSPEND_ALL = 2;
    private static final String[][] VM_COMMANDS = new String[][]{{""}, {"Virtual Machine", "Version", "ClassBySignature", "AllClasses", "AllThreads", "TopLevelThreadGroups", "Dispose", "IDSizes", "Suspend", "Resume", "Exit", "CreateString", "Capabilities", "ClassPaths", "DisposeObjects", "HoldEvents", "ReleaseEvents", "CapabilitiesNew", "RedefineClasses", "SetDefaultStratum", "AllClassesWithGeneric"}, {"ReferenceType", "Signature", "ClassLoader", "Modifiers", "Fields", "Methods", "GetValues", "SourceFile", "NestedTypes", "Status", "Interfaces", "ClassObject", "SourceDebugExtension", "SignatureWithGeneric", "FieldsWithGeneric", "MethodsWithGeneric"}, {"ClassType", "Superclass", "SetValues", "InvokeMethod", "NewInstance"}, {"ArrayType", "NewInstance"}, {"InterfaceType"}, {"Method", "LineTable", "VariableTable", "Bytecodes", "IsObsolete", "VariableTableWithGeneric"}, {"UNUSED"}, {"Field"}, {"ObjectReference", "ReferenceType", "GetValues", "SetValues", "UNUSED", "MonitorInfo", "InvokeMethod", "DisableCollection", "EnableCollection", "IsCollected"}, {"StringReference", "Value"}, {"ThreadReference", "Name", "Suspend", "Resume", "Status", "ThreadGroup", "Frames", "FrameCount", "OwnedMonitors", "CurrentCountendedMonitor", "Stop", "Interrupt", "SuspendCount"}, {"ThreadGroupReference", "Name", "Parent", "Children"}, {"ArrayReference", "Length", "GetValues", "SetValues"}, {"ClassLoaderReference", "VisibleClasses"}, {"EventRequest", "Set", "Clear", "ClearAllBreakpoints"}, {"StackFrame", "GetValues", "SetValues", "ThisObject", "PopFrames"}, {"ClassObjectReference", "ReflectedType"}};
    static final String[][] DEBUG_COMMANDS = new String[][]{{"Event", "Composite"}};
    static final String[][] VENDOR_SPECIFIC_COMMANDS = new String[][]{{"CJCRE", "Handshake", "GetSteppingInfo", "SteppingEvent"}};

    public static String[][] getVMCommands() {
        return (String[][])VM_COMMANDS.clone();
    }

    public static void logCommand(String prefixStr, Packet packet) {
        String[][] commands;
        int commandSet = packet.commandSet;
        int command = packet.command;
        int commandSetIndex = commandSet;
        int commandIndex = command;
        if (commandSet < 64) {
            commands = VM_COMMANDS;
        } else if (commandSet < 128) {
            commands = DEBUG_COMMANDS;
            commandSetIndex -= 64;
            commandIndex -= 99;
        } else {
            commands = VENDOR_SPECIFIC_COMMANDS;
            commandIndex = 0;
            commandSetIndex = 0;
        }
        try {
            String ext = "";
            try {
                byte eventKind = packet.getData()[0];
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(packet.getData()));
                Kind event = Kind.find(in.readByte());
                ext = " " + Kind.find(eventKind).name() + "(" + eventKind + ") ";
                byte suspendPolicy = in.readByte();
                int modifiers = in.readInt();
                byte mod = in.readByte();
                EventRequest_Set_Modifier esm = EventRequest_Set_Modifier.findModifier(mod);
                ext = ext + esm.name() + "(" + mod + ")";
                if (commandSet == 15 && command == 1 && (esm == EventRequest_Set_Modifier.ClassMatch || esm == EventRequest_Set_Modifier.ClassExclude)) {
                    String className = EncodingUtils.readString(in);
                    ext = ext + " " + className;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Log.LOGN(3, prefixStr + commands[commandSetIndex][0] + "(" + commandSet + ")/" + commands[commandSetIndex][commandIndex] + "(" + command + ")" + ext);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.getAnonymousLogger().severe("UNKNOWN COMMAND: " + commandSet + "/" + command);
        }
    }

    public static enum EventRequest_Set_Modifier {
        xUnknown(0),
        Count(1),
        Conditional(2),
        ThreadOnly(3),
        ClassOnly(4),
        ClassMatch(5),
        ClassExclude(6),
        LocationOnly(7),
        ExceptionOnly(8),
        FieldOnly(9),
        Step(10),
        InstanceOnly(11);

        private byte code;

        private EventRequest_Set_Modifier(int c) {
            this.code = (byte)c;
        }

        public static EventRequest_Set_Modifier findModifier(int mod) {
            for (EventRequest_Set_Modifier val : EventRequest_Set_Modifier.values()) {
                if (val.ordinal() != mod) continue;
                return val;
            }
            return null;
        }
    }
}

