/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.ThreadConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ChainPacketHandler;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class StackFrameConverters {
    static void registerStackFrameConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(16, 1, new ChainPacketHandler(VMPacketHandler.CommandCode.GET_LOCAL_VARIABLES, 32){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                Log.LOG(3, "StackFrame:GetValues (startChain)");
                ThreadConverters.readThreadId(state);
                ThreadConverters.checkVMThread(state);
                state.args.put("frame-id", state.in.readInt());
                int length = state.in.readInt();
                state.out.writeInt(length);
                return length;
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                toVm.write((Integer)state.args.get("frame-id"));
                toVm.write(chunkSize);
                byte[] tags = new byte[chunkSize];
                for (int i = 0; i < chunkSize; ++i) {
                    int index = EncodingUtils.copyIntAsByte(state.in, toVm);
                    tags[i] = EncodingUtils.copyByte(state.in, toVm);
                    Log.LOG(3, "slot#" + i + " index: " + index + " tag:" + tags[i]);
                }
                state.args.put("tags", tags);
            }

            @Override
            protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
                byte[] tags;
                for (byte tag : tags = (byte[])state.args.get("tags")) {
                    EncodingUtils.copyTypeFromVmToIDE(tag, in, state.out);
                }
            }
        });
        proxy.addConverter(16, 2, new ChainPacketHandler(VMPacketHandler.CommandCode.SET_LOCAL_VARIABLES, 32){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                ThreadConverters.readThreadId(state);
                ThreadConverters.checkVMThread(state);
                state.args.put("frame-id", state.in.readInt());
                return state.in.readInt();
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                toVm.write((Integer)state.args.get("frame-id"));
                toVm.write(chunkSize);
                for (int i = 0; i < chunkSize; ++i) {
                    EncodingUtils.copyIntAsByte(state.in, toVm);
                    EncodingUtils.copyTypeFromIDEtoVm(state.in, toVm);
                }
            }
        });
        proxy.addConverter(16, 3, new ThreadConverters.ThreadPacketHandler(VMPacketHandler.CommandCode.GET_LOCAL_VARIABLES){

            @Override
            protected ClassicPacketHandler.DeliveryType handleVMThread(HandlerState state, DataInputStream fromIde, DataOutputStream toVm) throws IOException {
                Log.LOG(3, "StackFrame:ThisObject (handleVMThread)");
                int frameID = fromIde.readInt();
                Location[] stack = this.proxy.state().getStack();
                boolean isThisDefined = false;
                if (stack.length > frameID) {
                    int accessFlags = stack[frameID].meth.getAccessFlags();
                    boolean bl = isThisDefined = !Modifier.isStatic(accessFlags);
                }
                if (isThisDefined) {
                    toVm.writeByte((byte)frameID);
                    toVm.writeByte(1);
                    toVm.writeByte(0);
                    toVm.writeByte(76);
                    return ClassicPacketHandler.DeliveryType.IMMEDIATELY;
                }
                state.out.writeByte(76);
                state.out.writeInt(0);
                return ClassicPacketHandler.DeliveryType.NONE;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                byte type = in.readByte();
                if (type == 115) {
                    Log.LOG(3, "JDWP String type received from VM: " + type + " == s");
                }
                state.out.writeByte(type);
                state.out.writeInt(in.readInt());
            }
        });
    }
}

