/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.stringproc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javacardx.annotations.StringDef;
import javacardx.annotations.StringPool;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"javacardx.annotations.StringPool", "javacardx.annotations.StringDef"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class StringConstantsProcessor
extends AbstractProcessor {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, StringConstantsProcessor.getCopyrightBanner());
        Types types = this.processingEnv.getTypeUtils();
        boolean bl = false;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(StringPool.class)) {
            Object object;
            Object object22;
            Object object3;
            String string = MessageFormat.format(this.resourceBundle.getString("annotations.processing"), element.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string);
            String string2 = element.getAnnotation(StringPool.class).name();
            if (!string2.equals("") && !this.isJavaIdentifier(string2)) {
                string = MessageFormat.format(this.resourceBundle.getString("name.malformed"), string2);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string, element);
                bl = true;
                continue;
            }
            String string3 = "UTF-8";
            boolean bl2 = element.getAnnotation(StringPool.class).export();
            String string4 = string2.equals("") ? ((TypeElement)element).getQualifiedName() + "$$Strings" : ((PackageElement)element.getEnclosingElement()).getQualifiedName() + "." + string2;
            String string5 = string2.equals("") ? ((TypeElement)element).getSimpleName() + "$$Strings" : string2;
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object4 = element.getAnnotation(StringPool.class).value();
            int n = 0;
            for (int i = 0; i < ((StringDef[])object4).length; ++i) {
                object3 = object4[i].name();
                if (object3.equals("") || !this.isJavaIdentifier((String)object3)) {
                    string = MessageFormat.format(this.resourceBundle.getString("name.malformed"), object3, element);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                    bl = true;
                    continue;
                }
                if (hashSet.contains(object3)) {
                    string = MessageFormat.format(this.resourceBundle.getString("name.duplicate"), object3, element);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                    bl = true;
                    continue;
                }
                hashSet.add((String)object3);
                Object object5 = object4[i].reference();
                if (((String)object5).equals("")) continue;
                if (!this.isQualifiedJavaIdentifier((String)object5)) {
                    string = MessageFormat.format(this.resourceBundle.getString("reference.malformed"), object5);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                    bl = true;
                    continue;
                }
                object22 = object4[i].value();
                if (!((String)object22).equals("")) {
                    string = MessageFormat.format(this.resourceBundle.getString("reference.unexpected"), object5, object22);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                    bl = true;
                    continue;
                }
                object = this.getComponents((String)object5);
                if (object == null) {
                    string = MessageFormat.format(this.resourceBundle.getString("reference.malformed"), object5);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                    bl = true;
                    continue;
                }
                if (hashMap.containsKey(object[0])) continue;
                hashMap.put(object[0], "__x" + n++);
            }
            if (bl) {
                string = MessageFormat.format(this.resourceBundle.getString("annotations.error"), element.getSimpleName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string);
                return false;
            }
            try {
                object4 = this.processingEnv.getFiler().createSourceFile(string4, new Element[0]);
                string = MessageFormat.format(this.resourceBundle.getString("class.creating"), object4.toUri());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string);
                Writer writer = object4.openWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                try {
                    Object object6;
                    String[] stringArray;
                    int n2;
                    printWriter.println("package " + ((PackageElement)element.getEnclosingElement()).getQualifiedName() + ";");
                    printWriter.println();
                    if (!bl2) {
                        printWriter.println("final class " + string5 + " {");
                    } else {
                        printWriter.println("public final class " + string5 + " {");
                    }
                    if (!hashMap.isEmpty()) {
                        for (Object object5 : hashMap.entrySet()) {
                            printWriter.println("    private static " + (String)object5.getKey() + " " + (String)object5.getValue() + ";");
                        }
                    }
                    printWriter.println();
                    if (!bl2) {
                        object3 = element.getAnnotation(StringPool.class).value();
                        for (n2 = 0; n2 < ((StringDef[])object3).length; ++n2) {
                            object22 = object3[n2].reference();
                            object = object3[n2].name();
                            stringArray = object3[n2].value();
                            if (!((String)object22).equals("")) {
                                printWriter.println("    static byte[] " + (String)object + ";");
                                continue;
                            }
                            printWriter.println("    static final byte[] " + (String)object + " = new byte[] " + this.PrintByteArrayInit((String)stringArray, string3) + ";");
                        }
                        printWriter.println();
                        if (!hashMap.isEmpty()) {
                            printWriter.println("    static void importLibConstants() {");
                            if (!hashMap.isEmpty()) {
                                for (Object object22 : hashMap.entrySet()) {
                                    printWriter.println("        " + (String)object22.getValue() + " = new " + (String)object22.getKey() + "();");
                                }
                            }
                            for (n2 = 0; n2 < ((StringDef[])object3).length; ++n2) {
                                object22 = object3[n2].reference();
                                object = object3[n2].name();
                                stringArray = object3[n2].value();
                                if (((String)object22).equals("") || (object6 = this.getComponents((String)object22)) == null) continue;
                                String string6 = (String)hashMap.get(object6[0]);
                                printWriter.println("        " + (String)object + " = " + string6 + "." + object6[1] + ";");
                            }
                            printWriter.println("    }");
                        }
                    } else {
                        object3 = element.getAnnotation(StringPool.class).value();
                        for (int i = 0; i < ((StringDef[])object3).length; ++i) {
                            object22 = object3[i].reference();
                            object = object3[i].name();
                            stringArray = object3[i].value();
                            if (!((String)object22).equals("")) {
                                printWriter.println("    public byte[] " + (String)object + ";");
                                continue;
                            }
                            printWriter.println("    public final byte[] " + (String)object + " = new byte[] " + this.PrintByteArrayInit((String)stringArray, string3) + ";");
                        }
                        printWriter.println();
                        printWriter.println("    public " + string5 + "() {");
                        if (!hashMap.isEmpty()) {
                            for (Object object22 : hashMap.entrySet()) {
                                printWriter.println("        " + (String)object22.getValue() + " = new " + (String)object22.getKey() + "();");
                            }
                        }
                        for (n2 = 0; n2 < ((StringDef[])object3).length; ++n2) {
                            object22 = object3[n2].reference();
                            object = object3[n2].name();
                            if (((String)object22).equals("") || (stringArray = this.getComponents((String)object22)) == null) continue;
                            object6 = (String)hashMap.get(stringArray[0]);
                            printWriter.println("        " + (String)object + " = " + (String)object6 + "." + stringArray[1] + ";");
                        }
                        printWriter.println("    }");
                    }
                    printWriter.println("}");
                    printWriter.flush();
                }
                finally {
                    printWriter.close();
                    writer.close();
                }
            }
            catch (IOException iOException) {
                string = MessageFormat.format(this.resourceBundle.getString("io.error"), iOException.toString());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
            }
        }
        return true;
    }

    private String PrintByteArrayInit(String string, String string2) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (byte by : string.getBytes(string2)) {
            if (by < 0) {
                stringBuilder.append("(byte)");
            }
            stringBuilder.append("0x").append(Integer.toString(by & 0xFF, 16));
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private String[] getComponents(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return new String[]{string.substring(0, n), string.substring(n + 1)};
        }
        return null;
    }

    private boolean isJavaIdentifier(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isQualifiedJavaIdentifier(String string) {
        int n = 0;
        block0: while (n < string.length()) {
            if (!Character.isJavaIdentifierStart(string.charAt(n++))) {
                return false;
            }
            while (n < string.length()) {
                if (string.charAt(n) == '.') {
                    if (n + 1 < string.length()) {
                        ++n;
                        continue block0;
                    }
                    return false;
                }
                if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public static String getCopyrightBanner() {
        return "    Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.\n    \n    ";
    }
}

