/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class ExportFileManager {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    private String[] export_path;
    private Vector<EfExportFile> export_files;
    private Vector<File> exportFiles;
    private ConversionProfile conversionProfile;
    private Hashtable<String, File> exportFilesHS;

    public ExportFileManager(ConversionProfile conversionProfile, Hashtable<String, File> hashtable) {
        this.export_path = conversionProfile.export_path;
        this.export_files = new Vector(20);
        this.exportFiles = new Vector(20);
        this.conversionProfile = conversionProfile;
        this.exportFilesHS = hashtable != null ? hashtable : new Hashtable();
    }

    public Vector<File> getJavaExportFiles() {
        return this.exportFiles;
    }

    private void verifyExportFile(File file) throws Exception {
        try {
            ExportFile exportFile = ExportFile.readFromFile(file);
            exportFile.verify();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Notifier.error("converter.7");
            throw new ConverterException();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Object[] objectArray = new Object[]{string};
            Notifier.error("converter.8", objectArray);
            throw new ConverterException();
        }
    }

    public File loadExpFile(String string) {
        return this.exportFilesHS.get(string);
    }

    public EfExportFile[] getExportFiles() {
        Object[] objectArray = new EfExportFile[this.export_files.size()];
        this.export_files.copyInto(objectArray);
        return objectArray;
    }

    private EfExportFile buildExportFile(File file, String string) throws Exception {
        if (file.isFile()) {
            EfExportFile efExportFile = new EfExportFile();
            try {
                Notifier.progress("progress.1", file.getCanonicalPath());
                if (this.conversionProfile == null || !this.conversionProfile.noVerify) {
                    this.verifyExportFile(file);
                }
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                efExportFile.parse(dataInputStream);
                efExportFile.resolve();
                this.export_files.addElement(efExportFile);
                this.exportFiles.addElement(file);
                dataInputStream.close();
                this.checkBinaryCompatibility(efExportFile);
                return efExportFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object[] objectArray = new String[]{Names.getExportFileName(string), string.replace('/', '.')};
                Notifier.error("linking.1", objectArray);
                throw new ConverterException();
            }
            catch (StreamCorruptedException streamCorruptedException) {
                Notifier.error("converter.6");
                throw new ConverterException();
            }
            catch (IOException iOException) {
                Notifier.error("converter.1", Names.getExportFileName(string));
                throw new ConverterException();
            }
        }
        return null;
    }

    public EfExportFile load(String string) throws Exception {
        EfExportFile efExportFile = null;
        File file = this.exportFilesHS.get(string);
        if (file != null && (efExportFile = this.buildExportFile(file, string)) != null) {
            return efExportFile;
        }
        char c = File.separatorChar;
        String string2 = new String(string.replace('/', c) + c + "javacard" + c + Names.getExportFileName(string));
        for (String string3 : this.export_path) {
            if (string3.endsWith(".jar") || (efExportFile = this.buildExportFile(file = new File(string3, string2), string)) == null) continue;
            return efExportFile;
        }
        Object[] objectArray = new String[]{Names.getExportFileName(string), string.replace('/', '.')};
        Notifier.error("linking.1", objectArray);
        throw new ConverterException();
    }

    public EfExportFile getExportFile(String string) throws Exception {
        Enumeration<EfExportFile> enumeration = this.export_files.elements();
        while (enumeration.hasMoreElements()) {
            EfExportFile efExportFile = enumeration.nextElement();
            if (!efExportFile.getPackageName().equals(string)) continue;
            return efExportFile;
        }
        return this.load(string);
    }

    private boolean areAidsEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public EfExportFile getExportFile(byte[] byArray) {
        for (int i = 0; i < this.export_files.size(); ++i) {
            EfExportFile efExportFile = this.export_files.elementAt(i);
            if (!this.areAidsEqual(byArray, efExportFile.getAID())) continue;
            return efExportFile;
        }
        return null;
    }

    public EfExportFile getExportFileIfAvailable(String string) {
        Enumeration<EfExportFile> enumeration = this.export_files.elements();
        while (enumeration.hasMoreElements()) {
            EfExportFile efExportFile = enumeration.nextElement();
            if (!efExportFile.getPackageName().equals(string)) continue;
            return efExportFile;
        }
        return null;
    }

    public EfClass getClass(String string) throws Exception {
        String string2 = Names.getPackageName(string);
        EfExportFile efExportFile = this.getExportFile(string2);
        if (efExportFile == null) {
            return null;
        }
        return efExportFile.getClass(string);
    }

    public EfClass getClassIfAvailable(String string) {
        String string2 = Names.getPackageName(string);
        EfExportFile efExportFile = this.getExportFileIfAvailable(string2);
        if (efExportFile == null) {
            return null;
        }
        return efExportFile.getClass(string);
    }

    public EfMethod getMethod(String string, String string2, String string3) throws Exception {
        EfClass efClass = this.getClass(string);
        if (efClass == null) {
            return null;
        }
        EfMethod efMethod = efClass.getMethod(string2, string3);
        if (efMethod == null && !string2.equals("<init>")) {
            String string4 = efClass.getSuperClassName(this);
            while (string4 != null) {
                efClass = this.getClass(string4);
                if (efClass == null) {
                    return null;
                }
                efMethod = efClass.getMethod(string2, string3);
                if (efMethod != null) break;
                string4 = efClass.getSuperClassName(this);
            }
        }
        return efMethod;
    }

    public EfField getField(String string, String string2, String string3) throws Exception {
        EfClass efClass = this.getClass(string);
        if (efClass == null) {
            return null;
        }
        return efClass.getField(string2, string3);
    }

    private void checkBinaryCompatibility(EfExportFile efExportFile) throws Exception {
        if (efExportFile.getMajorVersion() != 2) {
            Object[] objectArray = new Object[]{Names.getExportFileName(efExportFile.getPackageName()), messages.getString("major")};
            Notifier.error("binary.1", objectArray);
            throw new ConverterException();
        }
        if (efExportFile.getMinorVersion() < 1 || efExportFile.getMinorVersion() > 2) {
            Object[] objectArray = new Object[]{Names.getExportFileName(efExportFile.getPackageName()), messages.getString("minor")};
            Notifier.error("binary.1", objectArray);
            throw new ConverterException();
        }
    }
}

