// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RLCMAC_CSN1_Types.hh"

namespace RLCMAC__CSN1__Types {

/* Member functions of C++ classes */

RlcMode::RlcMode()
{
enum_value = UNBOUND_VALUE;
}

RlcMode::RlcMode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RLCMAC_CSN1_Types.RlcMode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RlcMode::RlcMode(enum_type other_value)
{
enum_value = other_value;
}

RlcMode::RlcMode(const RlcMode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
enum_value = other_value.enum_value;
}

RlcMode& RlcMode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcMode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RlcMode& RlcMode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RlcMode& RlcMode::operator=(const RlcMode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
enum_value = other_value.enum_value;
return *this;
}

boolean RlcMode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcMode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RlcMode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value == other_value;
}

boolean RlcMode::operator==(const RlcMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value == other_value.enum_value;
}

boolean RlcMode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcMode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RlcMode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value < other_value;
}

boolean RlcMode::operator<(const RlcMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value < other_value.enum_value;
}

boolean RlcMode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcMode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RlcMode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value > other_value;
}

boolean RlcMode::operator>(const RlcMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value > other_value.enum_value;
}

const char *RlcMode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RLC__MODE__ACKNOWLEDGED: return "RLC_MODE_ACKNOWLEDGED";
case RLC__MODE__UNACKNOWLEDGED: return "RLC_MODE_UNACKNOWLEDGED";
default:
return "<unknown>";
}
}

RlcMode::enum_type RlcMode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RLC_MODE_ACKNOWLEDGED")) return RLC__MODE__ACKNOWLEDGED;
if (!strcmp(str_par, "RLC_MODE_UNACKNOWLEDGED")) return RLC__MODE__UNACKNOWLEDGED;
}
return UNKNOWN_VALUE;
}

boolean RlcMode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int RlcMode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RlcMode::enum2int(const RlcMode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RlcMode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcMode.", int_val);
enum_value = (enum_type)int_val;
}

RlcMode::operator RlcMode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return enum_value;
}

void RlcMode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RlcMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RLCMAC_CSN1_Types.RlcMode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcMode.");
  }
}

void RlcMode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
text_buf.push_int(enum_value);
}

void RlcMode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RLCMAC_CSN1_Types.RlcMode.", enum_value);
}

void RlcMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RlcMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RlcMode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RlcMode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RlcMode_template::copy_template(const RlcMode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RlcMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RlcMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RlcMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
}

RlcMode_template::RlcMode_template()
{
}

RlcMode_template::RlcMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RlcMode_template::RlcMode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RlcMode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RLCMAC_CSN1_Types.RlcMode with unknown numeric value %d.", other_value);
single_value = (RlcMode::enum_type)other_value;
}

RlcMode_template::RlcMode_template(RlcMode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RlcMode_template::RlcMode_template(const RlcMode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RlcMode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
single_value = other_value.enum_value;
}

RlcMode_template::RlcMode_template(const OPTIONAL<RlcMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcMode::enum_type)(const RlcMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RLCMAC_CSN1_Types.RlcMode from an unbound optional field.");
}
}

RlcMode_template::RlcMode_template(RlcMode_template* p_precondition, RlcMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RlcMode_template::RlcMode_template(Dynamic_Match_Interface<RlcMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RlcMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RlcMode_template::RlcMode_template(const RlcMode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RlcMode_template::~RlcMode_template()
{
clean_up();
}

boolean RlcMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RlcMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RlcMode::UNBOUND_VALUE;
}

void RlcMode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RlcMode_template& RlcMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RlcMode_template& RlcMode_template::operator=(int other_value)
{
if (!RlcMode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RLCMAC_CSN1_Types.RlcMode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RlcMode::enum_type)other_value;
return *this;
}

RlcMode_template& RlcMode_template::operator=(RlcMode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RlcMode_template& RlcMode_template::operator=(const RlcMode& other_value)
{
if (other_value.enum_value == RlcMode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcMode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RlcMode_template& RlcMode_template::operator=(const OPTIONAL<RlcMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcMode::enum_type)(const RlcMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
return *this;
}

RlcMode_template& RlcMode_template::operator=(const RlcMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RlcMode_template::match(RlcMode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
return FALSE;
}

boolean RlcMode_template::match(const RlcMode& other_value, boolean) const
{
if (other_value.enum_value == RlcMode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RLCMAC_CSN1_Types.RlcMode with an unbound value.");
return match(other_value.enum_value);
}

RlcMode::enum_type RlcMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return single_value;
}

void RlcMode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RlcMode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
}

RlcMode_template& RlcMode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
return value_list.list_value[list_index];
}

void RlcMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RlcMode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RlcMode_template::log_match(const RlcMode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RlcMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
}

void RlcMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RlcMode::enum_type)text_buf.pull_int().get_val();
if (!RlcMode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcMode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RlcMode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcMode.");
}
}

boolean RlcMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RlcMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RlcMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RlcMode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RlcMode::enum_type enum_val = RlcMode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RlcMode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcMode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RlcMode_template* precondition = new RlcMode_template;
    precondition->set_param(*m_p->get_elem(0));
    RlcMode_template* implied_template = new RlcMode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RlcMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RLCMAC_CSN1_Types.RlcMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RlcMode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.RlcMode");
}

LlcPduType::LlcPduType()
{
enum_value = UNBOUND_VALUE;
}

LlcPduType::LlcPduType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RLCMAC_CSN1_Types.LlcPduType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

LlcPduType::LlcPduType(enum_type other_value)
{
enum_value = other_value;
}

LlcPduType::LlcPduType(const LlcPduType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
enum_value = other_value.enum_value;
}

LlcPduType& LlcPduType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

LlcPduType& LlcPduType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

LlcPduType& LlcPduType::operator=(const LlcPduType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
enum_value = other_value.enum_value;
return *this;
}

boolean LlcPduType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.LlcPduType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean LlcPduType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value == other_value;
}

boolean LlcPduType::operator==(const LlcPduType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value == other_value.enum_value;
}

boolean LlcPduType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.LlcPduType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean LlcPduType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value < other_value;
}

boolean LlcPduType::operator<(const LlcPduType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value < other_value.enum_value;
}

boolean LlcPduType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.LlcPduType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean LlcPduType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value > other_value;
}

boolean LlcPduType::operator>(const LlcPduType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value > other_value.enum_value;
}

const char *LlcPduType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case LLC__PDU__IS__SACK__OR__ACK: return "LLC_PDU_IS_SACK_OR_ACK";
case LLC__PDU__IS__NOT__SACK__OR__ACK: return "LLC_PDU_IS_NOT_SACK_OR_ACK";
default:
return "<unknown>";
}
}

LlcPduType::enum_type LlcPduType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "LLC_PDU_IS_SACK_OR_ACK")) return LLC__PDU__IS__SACK__OR__ACK;
if (!strcmp(str_par, "LLC_PDU_IS_NOT_SACK_OR_ACK")) return LLC__PDU__IS__NOT__SACK__OR__ACK;
}
return UNKNOWN_VALUE;
}

boolean LlcPduType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int LlcPduType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int LlcPduType::enum2int(const LlcPduType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void LlcPduType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", int_val);
enum_value = (enum_type)int_val;
}

LlcPduType::operator LlcPduType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return enum_value;
}

void LlcPduType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void LlcPduType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RLCMAC_CSN1_Types.LlcPduType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.LlcPduType.");
  }
}

void LlcPduType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
text_buf.push_int(enum_value);
}

void LlcPduType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RLCMAC_CSN1_Types.LlcPduType.", enum_value);
}

void LlcPduType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LlcPduType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LlcPduType::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int LlcPduType::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void LlcPduType_template::copy_template(const LlcPduType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LlcPduType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LlcPduType_template(*other_value.implication_.precondition);
implication_.implied_template = new LlcPduType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
}

LlcPduType_template::LlcPduType_template()
{
}

LlcPduType_template::LlcPduType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LlcPduType_template::LlcPduType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!LlcPduType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType with unknown numeric value %d.", other_value);
single_value = (LlcPduType::enum_type)other_value;
}

LlcPduType_template::LlcPduType_template(LlcPduType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

LlcPduType_template::LlcPduType_template(const LlcPduType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == LlcPduType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
single_value = other_value.enum_value;
}

LlcPduType_template::LlcPduType_template(const OPTIONAL<LlcPduType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (LlcPduType::enum_type)(const LlcPduType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType from an unbound optional field.");
}
}

LlcPduType_template::LlcPduType_template(LlcPduType_template* p_precondition, LlcPduType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LlcPduType_template::LlcPduType_template(Dynamic_Match_Interface<LlcPduType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LlcPduType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LlcPduType_template::LlcPduType_template(const LlcPduType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

LlcPduType_template::~LlcPduType_template()
{
clean_up();
}

boolean LlcPduType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean LlcPduType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != LlcPduType::UNBOUND_VALUE;
}

void LlcPduType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LlcPduType_template& LlcPduType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LlcPduType_template& LlcPduType_template::operator=(int other_value)
{
if (!LlcPduType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (LlcPduType::enum_type)other_value;
return *this;
}

LlcPduType_template& LlcPduType_template::operator=(LlcPduType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

LlcPduType_template& LlcPduType_template::operator=(const LlcPduType& other_value)
{
if (other_value.enum_value == LlcPduType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.LlcPduType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

LlcPduType_template& LlcPduType_template::operator=(const OPTIONAL<LlcPduType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (LlcPduType::enum_type)(const LlcPduType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
return *this;
}

LlcPduType_template& LlcPduType_template::operator=(const LlcPduType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LlcPduType_template::match(LlcPduType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
return FALSE;
}

boolean LlcPduType_template::match(const LlcPduType& other_value, boolean) const
{
if (other_value.enum_value == LlcPduType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType with an unbound value.");
return match(other_value.enum_value);
}

LlcPduType::enum_type LlcPduType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return single_value;
}

void LlcPduType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LlcPduType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
}

LlcPduType_template& LlcPduType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
return value_list.list_value[list_index];
}

void LlcPduType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(LlcPduType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LlcPduType_template::log_match(const LlcPduType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void LlcPduType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
}

void LlcPduType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (LlcPduType::enum_type)text_buf.pull_int().get_val();
if (!LlcPduType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LlcPduType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RLCMAC_CSN1_Types.LlcPduType.");
}
}

boolean LlcPduType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LlcPduType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void LlcPduType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LlcPduType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    LlcPduType::enum_type enum_val = LlcPduType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!LlcPduType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.LlcPduType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    LlcPduType_template* precondition = new LlcPduType_template;
    precondition->set_param(*m_p->get_elem(0));
    LlcPduType_template* implied_template = new LlcPduType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = LlcPduType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RLCMAC_CSN1_Types.LlcPduType");
  }
  is_ifpresent = param.get_ifpresent();
}

void LlcPduType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.LlcPduType");
}

ChannelReqDescription::ChannelReqDescription()
{
}

ChannelReqDescription::ChannelReqDescription(const INTEGER& par_peak__tput__class,
    const INTEGER& par_priority,
    const RlcMode& par_rlc__mode,
    const LlcPduType& par_llc__pdu__type,
    const INTEGER& par_RlcOctetCount)
  :   field_peak__tput__class(par_peak__tput__class),
  field_priority(par_priority),
  field_rlc__mode(par_rlc__mode),
  field_llc__pdu__type(par_llc__pdu__type),
  field_RlcOctetCount(par_RlcOctetCount)
{
}

ChannelReqDescription::ChannelReqDescription(const ChannelReqDescription& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
if (other_value.peak__tput__class().is_bound()) field_peak__tput__class = other_value.peak__tput__class();
else field_peak__tput__class.clean_up();
if (other_value.priority().is_bound()) field_priority = other_value.priority();
else field_priority.clean_up();
if (other_value.rlc__mode().is_bound()) field_rlc__mode = other_value.rlc__mode();
else field_rlc__mode.clean_up();
if (other_value.llc__pdu__type().is_bound()) field_llc__pdu__type = other_value.llc__pdu__type();
else field_llc__pdu__type.clean_up();
if (other_value.RlcOctetCount().is_bound()) field_RlcOctetCount = other_value.RlcOctetCount();
else field_RlcOctetCount.clean_up();
}

void ChannelReqDescription::clean_up()
{
field_peak__tput__class.clean_up();
field_priority.clean_up();
field_rlc__mode.clean_up();
field_llc__pdu__type.clean_up();
field_RlcOctetCount.clean_up();
}

const TTCN_Typedescriptor_t* ChannelReqDescription::get_descriptor() const { return &ChannelReqDescription_descr_; }
ChannelReqDescription& ChannelReqDescription::operator=(const ChannelReqDescription& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
  if (other_value.peak__tput__class().is_bound()) field_peak__tput__class = other_value.peak__tput__class();
  else field_peak__tput__class.clean_up();
  if (other_value.priority().is_bound()) field_priority = other_value.priority();
  else field_priority.clean_up();
  if (other_value.rlc__mode().is_bound()) field_rlc__mode = other_value.rlc__mode();
  else field_rlc__mode.clean_up();
  if (other_value.llc__pdu__type().is_bound()) field_llc__pdu__type = other_value.llc__pdu__type();
  else field_llc__pdu__type.clean_up();
  if (other_value.RlcOctetCount().is_bound()) field_RlcOctetCount = other_value.RlcOctetCount();
  else field_RlcOctetCount.clean_up();
}
return *this;
}

boolean ChannelReqDescription::operator==(const ChannelReqDescription& other_value) const
{
return field_peak__tput__class==other_value.field_peak__tput__class
  && field_priority==other_value.field_priority
  && field_rlc__mode==other_value.field_rlc__mode
  && field_llc__pdu__type==other_value.field_llc__pdu__type
  && field_RlcOctetCount==other_value.field_RlcOctetCount;
}

boolean ChannelReqDescription::is_bound() const
{
return (field_peak__tput__class.is_bound())
  || (field_priority.is_bound())
  || (field_rlc__mode.is_bound())
  || (field_llc__pdu__type.is_bound())
  || (field_RlcOctetCount.is_bound());
}
boolean ChannelReqDescription::is_value() const
{
return field_peak__tput__class.is_value()
  && field_priority.is_value()
  && field_rlc__mode.is_value()
  && field_llc__pdu__type.is_value()
  && field_RlcOctetCount.is_value();
}
void ChannelReqDescription::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ peak_tput_class := ");
field_peak__tput__class.log();
TTCN_Logger::log_event_str(", priority := ");
field_priority.log();
TTCN_Logger::log_event_str(", rlc_mode := ");
field_rlc__mode.log();
TTCN_Logger::log_event_str(", llc_pdu_type := ");
field_llc__pdu__type.log();
TTCN_Logger::log_event_str(", RlcOctetCount := ");
field_RlcOctetCount.log();
TTCN_Logger::log_event_str(" }");
}

void ChannelReqDescription::set_implicit_omit()
{
if (peak__tput__class().is_bound()) peak__tput__class().set_implicit_omit();
if (priority().is_bound()) priority().set_implicit_omit();
if (rlc__mode().is_bound()) rlc__mode().set_implicit_omit();
if (llc__pdu__type().is_bound()) llc__pdu__type().set_implicit_omit();
if (RlcOctetCount().is_bound()) RlcOctetCount().set_implicit_omit();
}

void ChannelReqDescription::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.ChannelReqDescription has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) peak__tput__class().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rlc__mode().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) llc__pdu__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) RlcOctetCount().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "peak_tput_class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          peak__tput__class().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rlc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rlc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "llc_pdu_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          llc__pdu__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "RlcOctetCount")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          RlcOctetCount().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.ChannelReqDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.ChannelReqDescription");
  }
}

void ChannelReqDescription::encode_text(Text_Buf& text_buf) const
{
field_peak__tput__class.encode_text(text_buf);
field_priority.encode_text(text_buf);
field_rlc__mode.encode_text(text_buf);
field_llc__pdu__type.encode_text(text_buf);
field_RlcOctetCount.encode_text(text_buf);
}

void ChannelReqDescription::decode_text(Text_Buf& text_buf)
{
field_peak__tput__class.decode_text(text_buf);
field_priority.decode_text(text_buf);
field_rlc__mode.decode_text(text_buf);
field_llc__pdu__type.decode_text(text_buf);
field_RlcOctetCount.decode_text(text_buf);
}

void ChannelReqDescription::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ChannelReqDescription::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ChannelReqDescription::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, ChannelReqDescription_peak__tput__class_descr_.raw->forceomit);
  decoded_field_length = field_peak__tput__class.RAW_decode(ChannelReqDescription_peak__tput__class_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ChannelReqDescription_priority_descr_.raw->forceomit);
  decoded_field_length = field_priority.RAW_decode(ChannelReqDescription_priority_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, ChannelReqDescription_rlc__mode_descr_.raw->forceomit);
  decoded_field_length = field_rlc__mode.RAW_decode(ChannelReqDescription_rlc__mode_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, ChannelReqDescription_llc__pdu__type_descr_.raw->forceomit);
  decoded_field_length = field_llc__pdu__type.RAW_decode(ChannelReqDescription_llc__pdu__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, ChannelReqDescription_RlcOctetCount_descr_.raw->forceomit);
  decoded_field_length = field_RlcOctetCount.RAW_decode(ChannelReqDescription_RlcOctetCount_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ChannelReqDescription::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, ChannelReqDescription_peak__tput__class_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ChannelReqDescription_priority_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ChannelReqDescription_rlc__mode_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ChannelReqDescription_llc__pdu__type_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ChannelReqDescription_RlcOctetCount_descr_.raw);
  encoded_length += field_peak__tput__class.RAW_encode(ChannelReqDescription_peak__tput__class_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_priority.RAW_encode(ChannelReqDescription_priority_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rlc__mode.RAW_encode(ChannelReqDescription_rlc__mode_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_llc__pdu__type.RAW_encode(ChannelReqDescription_llc__pdu__type_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_RlcOctetCount.RAW_encode(ChannelReqDescription_RlcOctetCount_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct ChannelReqDescription_template::single_value_struct {
INTEGER_template field_peak__tput__class;
INTEGER_template field_priority;
RlcMode_template field_rlc__mode;
LlcPduType_template field_llc__pdu__type;
INTEGER_template field_RlcOctetCount;
};

void ChannelReqDescription_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_peak__tput__class = ANY_VALUE;
single_value->field_priority = ANY_VALUE;
single_value->field_rlc__mode = ANY_VALUE;
single_value->field_llc__pdu__type = ANY_VALUE;
single_value->field_RlcOctetCount = ANY_VALUE;
}
}
}

void ChannelReqDescription_template::copy_value(const ChannelReqDescription& other_value)
{
single_value = new single_value_struct;
if (other_value.peak__tput__class().is_bound()) {
  single_value->field_peak__tput__class = other_value.peak__tput__class();
} else {
  single_value->field_peak__tput__class.clean_up();
}
if (other_value.priority().is_bound()) {
  single_value->field_priority = other_value.priority();
} else {
  single_value->field_priority.clean_up();
}
if (other_value.rlc__mode().is_bound()) {
  single_value->field_rlc__mode = other_value.rlc__mode();
} else {
  single_value->field_rlc__mode.clean_up();
}
if (other_value.llc__pdu__type().is_bound()) {
  single_value->field_llc__pdu__type = other_value.llc__pdu__type();
} else {
  single_value->field_llc__pdu__type.clean_up();
}
if (other_value.RlcOctetCount().is_bound()) {
  single_value->field_RlcOctetCount = other_value.RlcOctetCount();
} else {
  single_value->field_RlcOctetCount.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ChannelReqDescription_template::copy_template(const ChannelReqDescription_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.peak__tput__class().get_selection()) {
single_value->field_peak__tput__class = other_value.peak__tput__class();
} else {
single_value->field_peak__tput__class.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.priority().get_selection()) {
single_value->field_priority = other_value.priority();
} else {
single_value->field_priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rlc__mode().get_selection()) {
single_value->field_rlc__mode = other_value.rlc__mode();
} else {
single_value->field_rlc__mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.llc__pdu__type().get_selection()) {
single_value->field_llc__pdu__type = other_value.llc__pdu__type();
} else {
single_value->field_llc__pdu__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.RlcOctetCount().get_selection()) {
single_value->field_RlcOctetCount = other_value.RlcOctetCount();
} else {
single_value->field_RlcOctetCount.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ChannelReqDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ChannelReqDescription_template(*other_value.implication_.precondition);
implication_.implied_template = new ChannelReqDescription_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
break;
}
set_selection(other_value);
}

ChannelReqDescription_template::ChannelReqDescription_template()
{
}

ChannelReqDescription_template::ChannelReqDescription_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ChannelReqDescription_template::ChannelReqDescription_template(const ChannelReqDescription& other_value)
{
copy_value(other_value);
}

ChannelReqDescription_template::ChannelReqDescription_template(const OPTIONAL<ChannelReqDescription>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ChannelReqDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.ChannelReqDescription from an unbound optional field.");
}
}

ChannelReqDescription_template::ChannelReqDescription_template(ChannelReqDescription_template* p_precondition, ChannelReqDescription_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ChannelReqDescription_template::ChannelReqDescription_template(Dynamic_Match_Interface<ChannelReqDescription>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ChannelReqDescription>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ChannelReqDescription_template::ChannelReqDescription_template(const ChannelReqDescription_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ChannelReqDescription_template::~ChannelReqDescription_template()
{
clean_up();
}

ChannelReqDescription_template& ChannelReqDescription_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ChannelReqDescription_template& ChannelReqDescription_template::operator=(const ChannelReqDescription& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ChannelReqDescription_template& ChannelReqDescription_template::operator=(const OPTIONAL<ChannelReqDescription>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ChannelReqDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
}
return *this;
}

ChannelReqDescription_template& ChannelReqDescription_template::operator=(const ChannelReqDescription_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ChannelReqDescription_template::match(const ChannelReqDescription& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.peak__tput__class().is_bound()) return FALSE;
if(!single_value->field_peak__tput__class.match(other_value.peak__tput__class(), legacy))return FALSE;
if(!other_value.priority().is_bound()) return FALSE;
if(!single_value->field_priority.match(other_value.priority(), legacy))return FALSE;
if(!other_value.rlc__mode().is_bound()) return FALSE;
if(!single_value->field_rlc__mode.match(other_value.rlc__mode(), legacy))return FALSE;
if(!other_value.llc__pdu__type().is_bound()) return FALSE;
if(!single_value->field_llc__pdu__type.match(other_value.llc__pdu__type(), legacy))return FALSE;
if(!other_value.RlcOctetCount().is_bound()) return FALSE;
if(!single_value->field_RlcOctetCount.match(other_value.RlcOctetCount(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
}
return FALSE;
}

boolean ChannelReqDescription_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_peak__tput__class.is_bound()
 || single_value->field_priority.is_bound()
 || single_value->field_rlc__mode.is_bound()
 || single_value->field_llc__pdu__type.is_bound()
 || single_value->field_RlcOctetCount.is_bound();
}

boolean ChannelReqDescription_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_peak__tput__class.is_value()
 && single_value->field_priority.is_value()
 && single_value->field_rlc__mode.is_value()
 && single_value->field_llc__pdu__type.is_value()
 && single_value->field_RlcOctetCount.is_value();
}

void ChannelReqDescription_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ChannelReqDescription ChannelReqDescription_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
ChannelReqDescription ret_val;
if (single_value->field_peak__tput__class.is_bound()) {
ret_val.peak__tput__class() = single_value->field_peak__tput__class.valueof();
}
if (single_value->field_priority.is_bound()) {
ret_val.priority() = single_value->field_priority.valueof();
}
if (single_value->field_rlc__mode.is_bound()) {
ret_val.rlc__mode() = single_value->field_rlc__mode.valueof();
}
if (single_value->field_llc__pdu__type.is_bound()) {
ret_val.llc__pdu__type() = single_value->field_llc__pdu__type.valueof();
}
if (single_value->field_RlcOctetCount.is_bound()) {
ret_val.RlcOctetCount() = single_value->field_RlcOctetCount.valueof();
}
return ret_val;
}

void ChannelReqDescription_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ChannelReqDescription_template[list_length];
}

ChannelReqDescription_template& ChannelReqDescription_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return value_list.list_value[list_index];
}

INTEGER_template& ChannelReqDescription_template::peak__tput__class()
{
set_specific();
return single_value->field_peak__tput__class;
}

const INTEGER_template& ChannelReqDescription_template::peak__tput__class() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field peak_tput_class of a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return single_value->field_peak__tput__class;
}

INTEGER_template& ChannelReqDescription_template::priority()
{
set_specific();
return single_value->field_priority;
}

const INTEGER_template& ChannelReqDescription_template::priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field priority of a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return single_value->field_priority;
}

RlcMode_template& ChannelReqDescription_template::rlc__mode()
{
set_specific();
return single_value->field_rlc__mode;
}

const RlcMode_template& ChannelReqDescription_template::rlc__mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rlc_mode of a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return single_value->field_rlc__mode;
}

LlcPduType_template& ChannelReqDescription_template::llc__pdu__type()
{
set_specific();
return single_value->field_llc__pdu__type;
}

const LlcPduType_template& ChannelReqDescription_template::llc__pdu__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field llc_pdu_type of a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return single_value->field_llc__pdu__type;
}

INTEGER_template& ChannelReqDescription_template::RlcOctetCount()
{
set_specific();
return single_value->field_RlcOctetCount;
}

const INTEGER_template& ChannelReqDescription_template::RlcOctetCount() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field RlcOctetCount of a non-specific template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
return single_value->field_RlcOctetCount;
}

int ChannelReqDescription_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.ChannelReqDescription containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
  }
  return 0;
}

void ChannelReqDescription_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ peak_tput_class := ");
single_value->field_peak__tput__class.log();
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log();
TTCN_Logger::log_event_str(", rlc_mode := ");
single_value->field_rlc__mode.log();
TTCN_Logger::log_event_str(", llc_pdu_type := ");
single_value->field_llc__pdu__type.log();
TTCN_Logger::log_event_str(", RlcOctetCount := ");
single_value->field_RlcOctetCount.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ChannelReqDescription_template::log_match(const ChannelReqDescription& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_peak__tput__class.match(match_value.peak__tput__class(), legacy)){
TTCN_Logger::log_logmatch_info(".peak_tput_class");
single_value->field_peak__tput__class.log_match(match_value.peak__tput__class(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_priority.match(match_value.priority(), legacy)){
TTCN_Logger::log_logmatch_info(".priority");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rlc__mode.match(match_value.rlc__mode(), legacy)){
TTCN_Logger::log_logmatch_info(".rlc_mode");
single_value->field_rlc__mode.log_match(match_value.rlc__mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_llc__pdu__type.match(match_value.llc__pdu__type(), legacy)){
TTCN_Logger::log_logmatch_info(".llc_pdu_type");
single_value->field_llc__pdu__type.log_match(match_value.llc__pdu__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_RlcOctetCount.match(match_value.RlcOctetCount(), legacy)){
TTCN_Logger::log_logmatch_info(".RlcOctetCount");
single_value->field_RlcOctetCount.log_match(match_value.RlcOctetCount(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ peak_tput_class := ");
single_value->field_peak__tput__class.log_match(match_value.peak__tput__class(), legacy);
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::log_event_str(", rlc_mode := ");
single_value->field_rlc__mode.log_match(match_value.rlc__mode(), legacy);
TTCN_Logger::log_event_str(", llc_pdu_type := ");
single_value->field_llc__pdu__type.log_match(match_value.llc__pdu__type(), legacy);
TTCN_Logger::log_event_str(", RlcOctetCount := ");
single_value->field_RlcOctetCount.log_match(match_value.RlcOctetCount(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ChannelReqDescription_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (peak__tput__class().is_bound()) peak__tput__class().set_implicit_omit();
if (priority().is_bound()) priority().set_implicit_omit();
if (rlc__mode().is_bound()) rlc__mode().set_implicit_omit();
if (llc__pdu__type().is_bound()) llc__pdu__type().set_implicit_omit();
if (RlcOctetCount().is_bound()) RlcOctetCount().set_implicit_omit();
}

void ChannelReqDescription_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_peak__tput__class.encode_text(text_buf);
single_value->field_priority.encode_text(text_buf);
single_value->field_rlc__mode.encode_text(text_buf);
single_value->field_llc__pdu__type.encode_text(text_buf);
single_value->field_RlcOctetCount.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
}
}

void ChannelReqDescription_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_peak__tput__class.decode_text(text_buf);
single_value->field_priority.decode_text(text_buf);
single_value->field_rlc__mode.decode_text(text_buf);
single_value->field_llc__pdu__type.decode_text(text_buf);
single_value->field_RlcOctetCount.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ChannelReqDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.ChannelReqDescription.");
}
}

void ChannelReqDescription_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ChannelReqDescription_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.ChannelReqDescription has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) peak__tput__class().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rlc__mode().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) llc__pdu__type().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) RlcOctetCount().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "peak_tput_class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          peak__tput__class().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rlc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rlc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "llc_pdu_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          llc__pdu__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "RlcOctetCount")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          RlcOctetCount().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.ChannelReqDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ChannelReqDescription_template* precondition = new ChannelReqDescription_template;
    precondition->set_param(*param.get_elem(0));
    ChannelReqDescription_template* implied_template = new ChannelReqDescription_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ChannelReqDescription_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.ChannelReqDescription");
  }
  is_ifpresent = param.get_ifpresent();
}

void ChannelReqDescription_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_peak__tput__class.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
single_value->field_priority.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
single_value->field_rlc__mode.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
single_value->field_llc__pdu__type.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
single_value->field_RlcOctetCount.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.ChannelReqDescription");
}

boolean ChannelReqDescription_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ChannelReqDescription_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EgprsBEPLinkQualityMeasurements::EgprsBEPLinkQualityMeasurements()
{
}

EgprsBEPLinkQualityMeasurements::EgprsBEPLinkQualityMeasurements(const BITSTRING& par_gmsk__presence,
    const OPTIONAL< BITSTRING >& par_gmsk__mean__bep,
    const OPTIONAL< BITSTRING >& par_gmsk__cv__bep,
    const BITSTRING& par_psk8__presence,
    const OPTIONAL< BITSTRING >& par_psk8__mean__bep,
    const OPTIONAL< BITSTRING >& par_psk8__cv__bep)
  :   field_gmsk__presence(par_gmsk__presence),
  field_gmsk__mean__bep(par_gmsk__mean__bep),
  field_gmsk__cv__bep(par_gmsk__cv__bep),
  field_psk8__presence(par_psk8__presence),
  field_psk8__mean__bep(par_psk8__mean__bep),
  field_psk8__cv__bep(par_psk8__cv__bep)
{
}

EgprsBEPLinkQualityMeasurements::EgprsBEPLinkQualityMeasurements(const EgprsBEPLinkQualityMeasurements& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
if (other_value.gmsk__presence().is_bound()) field_gmsk__presence = other_value.gmsk__presence();
else field_gmsk__presence.clean_up();
if (other_value.gmsk__mean__bep().is_bound()) field_gmsk__mean__bep = other_value.gmsk__mean__bep();
else field_gmsk__mean__bep.clean_up();
if (other_value.gmsk__cv__bep().is_bound()) field_gmsk__cv__bep = other_value.gmsk__cv__bep();
else field_gmsk__cv__bep.clean_up();
if (other_value.psk8__presence().is_bound()) field_psk8__presence = other_value.psk8__presence();
else field_psk8__presence.clean_up();
if (other_value.psk8__mean__bep().is_bound()) field_psk8__mean__bep = other_value.psk8__mean__bep();
else field_psk8__mean__bep.clean_up();
if (other_value.psk8__cv__bep().is_bound()) field_psk8__cv__bep = other_value.psk8__cv__bep();
else field_psk8__cv__bep.clean_up();
}

void EgprsBEPLinkQualityMeasurements::clean_up()
{
field_gmsk__presence.clean_up();
field_gmsk__mean__bep.clean_up();
field_gmsk__cv__bep.clean_up();
field_psk8__presence.clean_up();
field_psk8__mean__bep.clean_up();
field_psk8__cv__bep.clean_up();
}

const TTCN_Typedescriptor_t* EgprsBEPLinkQualityMeasurements::get_descriptor() const { return &EgprsBEPLinkQualityMeasurements_descr_; }
EgprsBEPLinkQualityMeasurements& EgprsBEPLinkQualityMeasurements::operator=(const EgprsBEPLinkQualityMeasurements& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
  if (other_value.gmsk__presence().is_bound()) field_gmsk__presence = other_value.gmsk__presence();
  else field_gmsk__presence.clean_up();
  if (other_value.gmsk__mean__bep().is_bound()) field_gmsk__mean__bep = other_value.gmsk__mean__bep();
  else field_gmsk__mean__bep.clean_up();
  if (other_value.gmsk__cv__bep().is_bound()) field_gmsk__cv__bep = other_value.gmsk__cv__bep();
  else field_gmsk__cv__bep.clean_up();
  if (other_value.psk8__presence().is_bound()) field_psk8__presence = other_value.psk8__presence();
  else field_psk8__presence.clean_up();
  if (other_value.psk8__mean__bep().is_bound()) field_psk8__mean__bep = other_value.psk8__mean__bep();
  else field_psk8__mean__bep.clean_up();
  if (other_value.psk8__cv__bep().is_bound()) field_psk8__cv__bep = other_value.psk8__cv__bep();
  else field_psk8__cv__bep.clean_up();
}
return *this;
}

boolean EgprsBEPLinkQualityMeasurements::operator==(const EgprsBEPLinkQualityMeasurements& other_value) const
{
return field_gmsk__presence==other_value.field_gmsk__presence
  && field_gmsk__mean__bep==other_value.field_gmsk__mean__bep
  && field_gmsk__cv__bep==other_value.field_gmsk__cv__bep
  && field_psk8__presence==other_value.field_psk8__presence
  && field_psk8__mean__bep==other_value.field_psk8__mean__bep
  && field_psk8__cv__bep==other_value.field_psk8__cv__bep;
}

boolean EgprsBEPLinkQualityMeasurements::is_bound() const
{
return (field_gmsk__presence.is_bound())
  || (OPTIONAL_OMIT == field_gmsk__mean__bep.get_selection() || field_gmsk__mean__bep.is_bound())
  || (OPTIONAL_OMIT == field_gmsk__cv__bep.get_selection() || field_gmsk__cv__bep.is_bound())
  || (field_psk8__presence.is_bound())
  || (OPTIONAL_OMIT == field_psk8__mean__bep.get_selection() || field_psk8__mean__bep.is_bound())
  || (OPTIONAL_OMIT == field_psk8__cv__bep.get_selection() || field_psk8__cv__bep.is_bound());
}
boolean EgprsBEPLinkQualityMeasurements::is_value() const
{
return field_gmsk__presence.is_value()
  && (OPTIONAL_OMIT == field_gmsk__mean__bep.get_selection() || field_gmsk__mean__bep.is_value())
  && (OPTIONAL_OMIT == field_gmsk__cv__bep.get_selection() || field_gmsk__cv__bep.is_value())
  && field_psk8__presence.is_value()
  && (OPTIONAL_OMIT == field_psk8__mean__bep.get_selection() || field_psk8__mean__bep.is_value())
  && (OPTIONAL_OMIT == field_psk8__cv__bep.get_selection() || field_psk8__cv__bep.is_value());
}
int EgprsBEPLinkQualityMeasurements::size_of() const
{
  int ret_val = 2;
  if (field_gmsk__mean__bep.ispresent()) ret_val++;
  if (field_gmsk__cv__bep.ispresent()) ret_val++;
  if (field_psk8__mean__bep.ispresent()) ret_val++;
  if (field_psk8__cv__bep.ispresent()) ret_val++;
  return ret_val;
}

void EgprsBEPLinkQualityMeasurements::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ gmsk_presence := ");
field_gmsk__presence.log();
TTCN_Logger::log_event_str(", gmsk_mean_bep := ");
field_gmsk__mean__bep.log();
TTCN_Logger::log_event_str(", gmsk_cv_bep := ");
field_gmsk__cv__bep.log();
TTCN_Logger::log_event_str(", psk8_presence := ");
field_psk8__presence.log();
TTCN_Logger::log_event_str(", psk8_mean_bep := ");
field_psk8__mean__bep.log();
TTCN_Logger::log_event_str(", psk8_cv_bep := ");
field_psk8__cv__bep.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsBEPLinkQualityMeasurements::set_implicit_omit()
{
if (gmsk__presence().is_bound()) gmsk__presence().set_implicit_omit();
if (!gmsk__mean__bep().is_bound()) gmsk__mean__bep() = OMIT_VALUE;
else gmsk__mean__bep().set_implicit_omit();
if (!gmsk__cv__bep().is_bound()) gmsk__cv__bep() = OMIT_VALUE;
else gmsk__cv__bep().set_implicit_omit();
if (psk8__presence().is_bound()) psk8__presence().set_implicit_omit();
if (!psk8__mean__bep().is_bound()) psk8__mean__bep() = OMIT_VALUE;
else psk8__mean__bep().set_implicit_omit();
if (!psk8__cv__bep().is_bound()) psk8__cv__bep() = OMIT_VALUE;
else psk8__cv__bep().set_implicit_omit();
}

void EgprsBEPLinkQualityMeasurements::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) gmsk__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gmsk__mean__bep().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) gmsk__cv__bep().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) psk8__presence().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) psk8__mean__bep().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) psk8__cv__bep().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_mean_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__mean__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_cv_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__cv__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_mean_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__mean__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_cv_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__cv__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
  }
}

void EgprsBEPLinkQualityMeasurements::encode_text(Text_Buf& text_buf) const
{
field_gmsk__presence.encode_text(text_buf);
field_gmsk__mean__bep.encode_text(text_buf);
field_gmsk__cv__bep.encode_text(text_buf);
field_psk8__presence.encode_text(text_buf);
field_psk8__mean__bep.encode_text(text_buf);
field_psk8__cv__bep.encode_text(text_buf);
}

void EgprsBEPLinkQualityMeasurements::decode_text(Text_Buf& text_buf)
{
field_gmsk__presence.decode_text(text_buf);
field_gmsk__mean__bep.decode_text(text_buf);
field_gmsk__cv__bep.decode_text(text_buf);
field_psk8__presence.decode_text(text_buf);
field_psk8__mean__bep.decode_text(text_buf);
field_psk8__cv__bep.decode_text(text_buf);
}

void EgprsBEPLinkQualityMeasurements::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsBEPLinkQualityMeasurements::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsBEPLinkQualityMeasurements::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_.raw->forceomit);
  decoded_field_length = field_gmsk__presence.RAW_decode(EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_gmsk__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_gmsk__mean__bep = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsBEPLinkQualityMeasurements_gmsk__mean__bep_descr_.raw->forceomit);
  decoded_field_length = field_gmsk__mean__bep().RAW_decode(EgprsBEPLinkQualityMeasurements_gmsk__mean__bep_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_gmsk__mean__bep = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_gmsk__mean__bep=OMIT_VALUE;
  if (limit > 0 && field_gmsk__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_gmsk__cv__bep = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsBEPLinkQualityMeasurements_gmsk__cv__bep_descr_.raw->forceomit);
  decoded_field_length = field_gmsk__cv__bep().RAW_decode(EgprsBEPLinkQualityMeasurements_gmsk__cv__bep_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_gmsk__cv__bep = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_gmsk__cv__bep=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, EgprsBEPLinkQualityMeasurements_psk8__presence_descr_.raw->forceomit);
  decoded_field_length = field_psk8__presence.RAW_decode(EgprsBEPLinkQualityMeasurements_psk8__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_psk8__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_psk8__mean__bep = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, EgprsBEPLinkQualityMeasurements_psk8__mean__bep_descr_.raw->forceomit);
  decoded_field_length = field_psk8__mean__bep().RAW_decode(EgprsBEPLinkQualityMeasurements_psk8__mean__bep_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_psk8__mean__bep = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_psk8__mean__bep=OMIT_VALUE;
  if (limit > 0 && field_psk8__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_psk8__cv__bep = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, EgprsBEPLinkQualityMeasurements_psk8__cv__bep_descr_.raw->forceomit);
  decoded_field_length = field_psk8__cv__bep().RAW_decode(EgprsBEPLinkQualityMeasurements_psk8__cv__bep_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_psk8__cv__bep = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_psk8__cv__bep=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsBEPLinkQualityMeasurements::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_.raw);
  if (field_gmsk__mean__bep.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsBEPLinkQualityMeasurements_gmsk__mean__bep_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_gmsk__cv__bep.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsBEPLinkQualityMeasurements_gmsk__cv__bep_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EgprsBEPLinkQualityMeasurements_psk8__presence_descr_.raw);
  if (field_psk8__mean__bep.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, EgprsBEPLinkQualityMeasurements_psk8__mean__bep_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_psk8__cv__bep.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, EgprsBEPLinkQualityMeasurements_psk8__cv__bep_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_gmsk__presence.RAW_encode(EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_gmsk__mean__bep.ispresent()) {
  encoded_length += field_gmsk__mean__bep().RAW_encode(EgprsBEPLinkQualityMeasurements_gmsk__mean__bep_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_gmsk__cv__bep.ispresent()) {
  encoded_length += field_gmsk__cv__bep().RAW_encode(EgprsBEPLinkQualityMeasurements_gmsk__cv__bep_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_psk8__presence.RAW_encode(EgprsBEPLinkQualityMeasurements_psk8__presence_descr_, *myleaf.body.node.nodes[3]);
  if (field_psk8__mean__bep.ispresent()) {
  encoded_length += field_psk8__mean__bep().RAW_encode(EgprsBEPLinkQualityMeasurements_psk8__mean__bep_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_psk8__cv__bep.ispresent()) {
  encoded_length += field_psk8__cv__bep().RAW_encode(EgprsBEPLinkQualityMeasurements_psk8__cv__bep_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_gmsk__mean__bep.ispresent() && (field_gmsk__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_gmsk__cv__bep.ispresent() && (field_gmsk__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsBEPLinkQualityMeasurements_gmsk__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_psk8__mean__bep.ispresent() && (field_psk8__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsBEPLinkQualityMeasurements_psk8__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_psk8__cv__bep.ispresent() && (field_psk8__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsBEPLinkQualityMeasurements_psk8__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EgprsBEPLinkQualityMeasurements_template::single_value_struct {
BITSTRING_template field_gmsk__presence;
BITSTRING_template field_gmsk__mean__bep;
BITSTRING_template field_gmsk__cv__bep;
BITSTRING_template field_psk8__presence;
BITSTRING_template field_psk8__mean__bep;
BITSTRING_template field_psk8__cv__bep;
};

void EgprsBEPLinkQualityMeasurements_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_gmsk__presence = ANY_VALUE;
single_value->field_gmsk__mean__bep = ANY_OR_OMIT;
single_value->field_gmsk__cv__bep = ANY_OR_OMIT;
single_value->field_psk8__presence = ANY_VALUE;
single_value->field_psk8__mean__bep = ANY_OR_OMIT;
single_value->field_psk8__cv__bep = ANY_OR_OMIT;
}
}
}

void EgprsBEPLinkQualityMeasurements_template::copy_value(const EgprsBEPLinkQualityMeasurements& other_value)
{
single_value = new single_value_struct;
if (other_value.gmsk__presence().is_bound()) {
  single_value->field_gmsk__presence = other_value.gmsk__presence();
} else {
  single_value->field_gmsk__presence.clean_up();
}
if (other_value.gmsk__mean__bep().is_bound()) {
  if (other_value.gmsk__mean__bep().ispresent()) single_value->field_gmsk__mean__bep = other_value.gmsk__mean__bep()();
  else single_value->field_gmsk__mean__bep = OMIT_VALUE;
} else {
  single_value->field_gmsk__mean__bep.clean_up();
}
if (other_value.gmsk__cv__bep().is_bound()) {
  if (other_value.gmsk__cv__bep().ispresent()) single_value->field_gmsk__cv__bep = other_value.gmsk__cv__bep()();
  else single_value->field_gmsk__cv__bep = OMIT_VALUE;
} else {
  single_value->field_gmsk__cv__bep.clean_up();
}
if (other_value.psk8__presence().is_bound()) {
  single_value->field_psk8__presence = other_value.psk8__presence();
} else {
  single_value->field_psk8__presence.clean_up();
}
if (other_value.psk8__mean__bep().is_bound()) {
  if (other_value.psk8__mean__bep().ispresent()) single_value->field_psk8__mean__bep = other_value.psk8__mean__bep()();
  else single_value->field_psk8__mean__bep = OMIT_VALUE;
} else {
  single_value->field_psk8__mean__bep.clean_up();
}
if (other_value.psk8__cv__bep().is_bound()) {
  if (other_value.psk8__cv__bep().ispresent()) single_value->field_psk8__cv__bep = other_value.psk8__cv__bep()();
  else single_value->field_psk8__cv__bep = OMIT_VALUE;
} else {
  single_value->field_psk8__cv__bep.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsBEPLinkQualityMeasurements_template::copy_template(const EgprsBEPLinkQualityMeasurements_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.gmsk__presence().get_selection()) {
single_value->field_gmsk__presence = other_value.gmsk__presence();
} else {
single_value->field_gmsk__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gmsk__mean__bep().get_selection()) {
single_value->field_gmsk__mean__bep = other_value.gmsk__mean__bep();
} else {
single_value->field_gmsk__mean__bep.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gmsk__cv__bep().get_selection()) {
single_value->field_gmsk__cv__bep = other_value.gmsk__cv__bep();
} else {
single_value->field_gmsk__cv__bep.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psk8__presence().get_selection()) {
single_value->field_psk8__presence = other_value.psk8__presence();
} else {
single_value->field_psk8__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psk8__mean__bep().get_selection()) {
single_value->field_psk8__mean__bep = other_value.psk8__mean__bep();
} else {
single_value->field_psk8__mean__bep.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psk8__cv__bep().get_selection()) {
single_value->field_psk8__cv__bep = other_value.psk8__cv__bep();
} else {
single_value->field_psk8__cv__bep.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsBEPLinkQualityMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsBEPLinkQualityMeasurements_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsBEPLinkQualityMeasurements_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
break;
}
set_selection(other_value);
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template()
{
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(const EgprsBEPLinkQualityMeasurements& other_value)
{
copy_value(other_value);
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(const OPTIONAL<EgprsBEPLinkQualityMeasurements>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsBEPLinkQualityMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements from an unbound optional field.");
}
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(EgprsBEPLinkQualityMeasurements_template* p_precondition, EgprsBEPLinkQualityMeasurements_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(Dynamic_Match_Interface<EgprsBEPLinkQualityMeasurements>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsBEPLinkQualityMeasurements>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsBEPLinkQualityMeasurements_template::EgprsBEPLinkQualityMeasurements_template(const EgprsBEPLinkQualityMeasurements_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsBEPLinkQualityMeasurements_template::~EgprsBEPLinkQualityMeasurements_template()
{
clean_up();
}

EgprsBEPLinkQualityMeasurements_template& EgprsBEPLinkQualityMeasurements_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsBEPLinkQualityMeasurements_template& EgprsBEPLinkQualityMeasurements_template::operator=(const EgprsBEPLinkQualityMeasurements& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsBEPLinkQualityMeasurements_template& EgprsBEPLinkQualityMeasurements_template::operator=(const OPTIONAL<EgprsBEPLinkQualityMeasurements>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsBEPLinkQualityMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
}
return *this;
}

EgprsBEPLinkQualityMeasurements_template& EgprsBEPLinkQualityMeasurements_template::operator=(const EgprsBEPLinkQualityMeasurements_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsBEPLinkQualityMeasurements_template::match(const EgprsBEPLinkQualityMeasurements& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.gmsk__presence().is_bound()) return FALSE;
if(!single_value->field_gmsk__presence.match(other_value.gmsk__presence(), legacy))return FALSE;
if(!other_value.gmsk__mean__bep().is_bound()) return FALSE;
if((other_value.gmsk__mean__bep().ispresent() ? !single_value->field_gmsk__mean__bep.match((const BITSTRING&)other_value.gmsk__mean__bep(), legacy) : !single_value->field_gmsk__mean__bep.match_omit(legacy)))return FALSE;
if(!other_value.gmsk__cv__bep().is_bound()) return FALSE;
if((other_value.gmsk__cv__bep().ispresent() ? !single_value->field_gmsk__cv__bep.match((const BITSTRING&)other_value.gmsk__cv__bep(), legacy) : !single_value->field_gmsk__cv__bep.match_omit(legacy)))return FALSE;
if(!other_value.psk8__presence().is_bound()) return FALSE;
if(!single_value->field_psk8__presence.match(other_value.psk8__presence(), legacy))return FALSE;
if(!other_value.psk8__mean__bep().is_bound()) return FALSE;
if((other_value.psk8__mean__bep().ispresent() ? !single_value->field_psk8__mean__bep.match((const BITSTRING&)other_value.psk8__mean__bep(), legacy) : !single_value->field_psk8__mean__bep.match_omit(legacy)))return FALSE;
if(!other_value.psk8__cv__bep().is_bound()) return FALSE;
if((other_value.psk8__cv__bep().ispresent() ? !single_value->field_psk8__cv__bep.match((const BITSTRING&)other_value.psk8__cv__bep(), legacy) : !single_value->field_psk8__cv__bep.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
}
return FALSE;
}

boolean EgprsBEPLinkQualityMeasurements_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_gmsk__presence.is_bound()
 || (single_value->field_gmsk__mean__bep.is_omit() || single_value->field_gmsk__mean__bep.is_bound())
 || (single_value->field_gmsk__cv__bep.is_omit() || single_value->field_gmsk__cv__bep.is_bound())
 || single_value->field_psk8__presence.is_bound()
 || (single_value->field_psk8__mean__bep.is_omit() || single_value->field_psk8__mean__bep.is_bound())
 || (single_value->field_psk8__cv__bep.is_omit() || single_value->field_psk8__cv__bep.is_bound());
}

boolean EgprsBEPLinkQualityMeasurements_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_gmsk__presence.is_value()
 && (single_value->field_gmsk__mean__bep.is_omit() || single_value->field_gmsk__mean__bep.is_value())
 && (single_value->field_gmsk__cv__bep.is_omit() || single_value->field_gmsk__cv__bep.is_value())
 && single_value->field_psk8__presence.is_value()
 && (single_value->field_psk8__mean__bep.is_omit() || single_value->field_psk8__mean__bep.is_value())
 && (single_value->field_psk8__cv__bep.is_omit() || single_value->field_psk8__cv__bep.is_value());
}

void EgprsBEPLinkQualityMeasurements_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsBEPLinkQualityMeasurements EgprsBEPLinkQualityMeasurements_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
EgprsBEPLinkQualityMeasurements ret_val;
if (single_value->field_gmsk__presence.is_bound()) {
ret_val.gmsk__presence() = single_value->field_gmsk__presence.valueof();
}
if (single_value->field_gmsk__mean__bep.is_omit()) ret_val.gmsk__mean__bep() = OMIT_VALUE;
else if (single_value->field_gmsk__mean__bep.is_bound()) {
ret_val.gmsk__mean__bep() = single_value->field_gmsk__mean__bep.valueof();
}
if (single_value->field_gmsk__cv__bep.is_omit()) ret_val.gmsk__cv__bep() = OMIT_VALUE;
else if (single_value->field_gmsk__cv__bep.is_bound()) {
ret_val.gmsk__cv__bep() = single_value->field_gmsk__cv__bep.valueof();
}
if (single_value->field_psk8__presence.is_bound()) {
ret_val.psk8__presence() = single_value->field_psk8__presence.valueof();
}
if (single_value->field_psk8__mean__bep.is_omit()) ret_val.psk8__mean__bep() = OMIT_VALUE;
else if (single_value->field_psk8__mean__bep.is_bound()) {
ret_val.psk8__mean__bep() = single_value->field_psk8__mean__bep.valueof();
}
if (single_value->field_psk8__cv__bep.is_omit()) ret_val.psk8__cv__bep() = OMIT_VALUE;
else if (single_value->field_psk8__cv__bep.is_bound()) {
ret_val.psk8__cv__bep() = single_value->field_psk8__cv__bep.valueof();
}
return ret_val;
}

void EgprsBEPLinkQualityMeasurements_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsBEPLinkQualityMeasurements_template[list_length];
}

EgprsBEPLinkQualityMeasurements_template& EgprsBEPLinkQualityMeasurements_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return value_list.list_value[list_index];
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__presence()
{
set_specific();
return single_value->field_gmsk__presence;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gmsk_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_gmsk__presence;
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__mean__bep()
{
set_specific();
return single_value->field_gmsk__mean__bep;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__mean__bep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gmsk_mean_bep of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_gmsk__mean__bep;
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__cv__bep()
{
set_specific();
return single_value->field_gmsk__cv__bep;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::gmsk__cv__bep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gmsk_cv_bep of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_gmsk__cv__bep;
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__presence()
{
set_specific();
return single_value->field_psk8__presence;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psk8_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_psk8__presence;
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__mean__bep()
{
set_specific();
return single_value->field_psk8__mean__bep;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__mean__bep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psk8_mean_bep of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_psk8__mean__bep;
}

BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__cv__bep()
{
set_specific();
return single_value->field_psk8__cv__bep;
}

const BITSTRING_template& EgprsBEPLinkQualityMeasurements_template::psk8__cv__bep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psk8_cv_bep of a non-specific template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
return single_value->field_psk8__cv__bep;
}

int EgprsBEPLinkQualityMeasurements_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_gmsk__mean__bep.is_present()) ret_val++;
      if (single_value->field_gmsk__cv__bep.is_present()) ret_val++;
      if (single_value->field_psk8__mean__bep.is_present()) ret_val++;
      if (single_value->field_psk8__cv__bep.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
  }
  return 0;
}

void EgprsBEPLinkQualityMeasurements_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ gmsk_presence := ");
single_value->field_gmsk__presence.log();
TTCN_Logger::log_event_str(", gmsk_mean_bep := ");
single_value->field_gmsk__mean__bep.log();
TTCN_Logger::log_event_str(", gmsk_cv_bep := ");
single_value->field_gmsk__cv__bep.log();
TTCN_Logger::log_event_str(", psk8_presence := ");
single_value->field_psk8__presence.log();
TTCN_Logger::log_event_str(", psk8_mean_bep := ");
single_value->field_psk8__mean__bep.log();
TTCN_Logger::log_event_str(", psk8_cv_bep := ");
single_value->field_psk8__cv__bep.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsBEPLinkQualityMeasurements_template::log_match(const EgprsBEPLinkQualityMeasurements& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_gmsk__presence.match(match_value.gmsk__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".gmsk_presence");
single_value->field_gmsk__presence.log_match(match_value.gmsk__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.gmsk__mean__bep().ispresent()){
if(!single_value->field_gmsk__mean__bep.match(match_value.gmsk__mean__bep(), legacy)){
TTCN_Logger::log_logmatch_info(".gmsk_mean_bep");
single_value->field_gmsk__mean__bep.log_match(match_value.gmsk__mean__bep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gmsk__mean__bep.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gmsk_mean_bep := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gmsk__mean__bep.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gmsk__cv__bep().ispresent()){
if(!single_value->field_gmsk__cv__bep.match(match_value.gmsk__cv__bep(), legacy)){
TTCN_Logger::log_logmatch_info(".gmsk_cv_bep");
single_value->field_gmsk__cv__bep.log_match(match_value.gmsk__cv__bep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gmsk__cv__bep.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gmsk_cv_bep := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gmsk__cv__bep.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_psk8__presence.match(match_value.psk8__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".psk8_presence");
single_value->field_psk8__presence.log_match(match_value.psk8__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.psk8__mean__bep().ispresent()){
if(!single_value->field_psk8__mean__bep.match(match_value.psk8__mean__bep(), legacy)){
TTCN_Logger::log_logmatch_info(".psk8_mean_bep");
single_value->field_psk8__mean__bep.log_match(match_value.psk8__mean__bep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_psk8__mean__bep.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".psk8_mean_bep := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_psk8__mean__bep.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.psk8__cv__bep().ispresent()){
if(!single_value->field_psk8__cv__bep.match(match_value.psk8__cv__bep(), legacy)){
TTCN_Logger::log_logmatch_info(".psk8_cv_bep");
single_value->field_psk8__cv__bep.log_match(match_value.psk8__cv__bep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_psk8__cv__bep.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".psk8_cv_bep := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_psk8__cv__bep.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ gmsk_presence := ");
single_value->field_gmsk__presence.log_match(match_value.gmsk__presence(), legacy);
TTCN_Logger::log_event_str(", gmsk_mean_bep := ");
if (match_value.gmsk__mean__bep().ispresent()) {
single_value->field_gmsk__mean__bep.log_match(match_value.gmsk__mean__bep(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gmsk__mean__bep.log();
if (single_value->field_gmsk__mean__bep.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gmsk_cv_bep := ");
if (match_value.gmsk__cv__bep().ispresent()) {
single_value->field_gmsk__cv__bep.log_match(match_value.gmsk__cv__bep(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gmsk__cv__bep.log();
if (single_value->field_gmsk__cv__bep.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", psk8_presence := ");
single_value->field_psk8__presence.log_match(match_value.psk8__presence(), legacy);
TTCN_Logger::log_event_str(", psk8_mean_bep := ");
if (match_value.psk8__mean__bep().ispresent()) {
single_value->field_psk8__mean__bep.log_match(match_value.psk8__mean__bep(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_psk8__mean__bep.log();
if (single_value->field_psk8__mean__bep.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", psk8_cv_bep := ");
if (match_value.psk8__cv__bep().ispresent()) {
single_value->field_psk8__cv__bep.log_match(match_value.psk8__cv__bep(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_psk8__cv__bep.log();
if (single_value->field_psk8__cv__bep.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsBEPLinkQualityMeasurements_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (gmsk__presence().is_bound()) gmsk__presence().set_implicit_omit();
if (!gmsk__mean__bep().is_bound()) gmsk__mean__bep() = OMIT_VALUE;
else gmsk__mean__bep().set_implicit_omit();
if (!gmsk__cv__bep().is_bound()) gmsk__cv__bep() = OMIT_VALUE;
else gmsk__cv__bep().set_implicit_omit();
if (psk8__presence().is_bound()) psk8__presence().set_implicit_omit();
if (!psk8__mean__bep().is_bound()) psk8__mean__bep() = OMIT_VALUE;
else psk8__mean__bep().set_implicit_omit();
if (!psk8__cv__bep().is_bound()) psk8__cv__bep() = OMIT_VALUE;
else psk8__cv__bep().set_implicit_omit();
}

void EgprsBEPLinkQualityMeasurements_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_gmsk__presence.encode_text(text_buf);
single_value->field_gmsk__mean__bep.encode_text(text_buf);
single_value->field_gmsk__cv__bep.encode_text(text_buf);
single_value->field_psk8__presence.encode_text(text_buf);
single_value->field_psk8__mean__bep.encode_text(text_buf);
single_value->field_psk8__cv__bep.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
}
}

void EgprsBEPLinkQualityMeasurements_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_gmsk__presence.decode_text(text_buf);
single_value->field_gmsk__mean__bep.decode_text(text_buf);
single_value->field_gmsk__cv__bep.decode_text(text_buf);
single_value->field_psk8__presence.decode_text(text_buf);
single_value->field_psk8__mean__bep.decode_text(text_buf);
single_value->field_psk8__cv__bep.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsBEPLinkQualityMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements.");
}
}

void EgprsBEPLinkQualityMeasurements_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsBEPLinkQualityMeasurements_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) gmsk__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gmsk__mean__bep().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) gmsk__cv__bep().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) psk8__presence().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) psk8__mean__bep().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) psk8__cv__bep().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_mean_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__mean__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gmsk_cv_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gmsk__cv__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_mean_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__mean__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psk8_cv_bep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psk8__cv__bep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsBEPLinkQualityMeasurements_template* precondition = new EgprsBEPLinkQualityMeasurements_template;
    precondition->set_param(*param.get_elem(0));
    EgprsBEPLinkQualityMeasurements_template* implied_template = new EgprsBEPLinkQualityMeasurements_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsBEPLinkQualityMeasurements_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsBEPLinkQualityMeasurements_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_gmsk__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
single_value->field_gmsk__mean__bep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
single_value->field_gmsk__cv__bep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
single_value->field_psk8__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
single_value->field_psk8__mean__bep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
single_value->field_psk8__cv__bep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsBEPLinkQualityMeasurements");
}

boolean EgprsBEPLinkQualityMeasurements_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsBEPLinkQualityMeasurements_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BEPMeas::BEPMeas()
{
}

BEPMeas::BEPMeas(const BITSTRING& par_presence,
    const OPTIONAL< BITSTRING >& par_is__8psk,
    const OPTIONAL< INTEGER >& par_bep__meas)
  :   field_presence(par_presence),
  field_is__8psk(par_is__8psk),
  field_bep__meas(par_bep__meas)
{
}

BEPMeas::BEPMeas(const BEPMeas& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.BEPMeas.");
if (other_value.presence().is_bound()) field_presence = other_value.presence();
else field_presence.clean_up();
if (other_value.is__8psk().is_bound()) field_is__8psk = other_value.is__8psk();
else field_is__8psk.clean_up();
if (other_value.bep__meas().is_bound()) field_bep__meas = other_value.bep__meas();
else field_bep__meas.clean_up();
}

void BEPMeas::clean_up()
{
field_presence.clean_up();
field_is__8psk.clean_up();
field_bep__meas.clean_up();
}

const TTCN_Typedescriptor_t* BEPMeas::get_descriptor() const { return &BEPMeas_descr_; }
BEPMeas& BEPMeas::operator=(const BEPMeas& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.BEPMeas.");
  if (other_value.presence().is_bound()) field_presence = other_value.presence();
  else field_presence.clean_up();
  if (other_value.is__8psk().is_bound()) field_is__8psk = other_value.is__8psk();
  else field_is__8psk.clean_up();
  if (other_value.bep__meas().is_bound()) field_bep__meas = other_value.bep__meas();
  else field_bep__meas.clean_up();
}
return *this;
}

boolean BEPMeas::operator==(const BEPMeas& other_value) const
{
return field_presence==other_value.field_presence
  && field_is__8psk==other_value.field_is__8psk
  && field_bep__meas==other_value.field_bep__meas;
}

boolean BEPMeas::is_bound() const
{
return (field_presence.is_bound())
  || (OPTIONAL_OMIT == field_is__8psk.get_selection() || field_is__8psk.is_bound())
  || (OPTIONAL_OMIT == field_bep__meas.get_selection() || field_bep__meas.is_bound());
}
boolean BEPMeas::is_value() const
{
return field_presence.is_value()
  && (OPTIONAL_OMIT == field_is__8psk.get_selection() || field_is__8psk.is_value())
  && (OPTIONAL_OMIT == field_bep__meas.get_selection() || field_bep__meas.is_value());
}
int BEPMeas::size_of() const
{
  int ret_val = 1;
  if (field_is__8psk.ispresent()) ret_val++;
  if (field_bep__meas.ispresent()) ret_val++;
  return ret_val;
}

void BEPMeas::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ presence := ");
field_presence.log();
TTCN_Logger::log_event_str(", is_8psk := ");
field_is__8psk.log();
TTCN_Logger::log_event_str(", bep_meas := ");
field_bep__meas.log();
TTCN_Logger::log_event_str(" }");
}

void BEPMeas::set_implicit_omit()
{
if (presence().is_bound()) presence().set_implicit_omit();
if (!is__8psk().is_bound()) is__8psk() = OMIT_VALUE;
else is__8psk().set_implicit_omit();
if (!bep__meas().is_bound()) bep__meas() = OMIT_VALUE;
else bep__meas().set_implicit_omit();
}

void BEPMeas::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.BEPMeas has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) is__8psk().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bep__meas().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "is_8psk")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          is__8psk().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.BEPMeas: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.BEPMeas");
  }
}

void BEPMeas::encode_text(Text_Buf& text_buf) const
{
field_presence.encode_text(text_buf);
field_is__8psk.encode_text(text_buf);
field_bep__meas.encode_text(text_buf);
}

void BEPMeas::decode_text(Text_Buf& text_buf)
{
field_presence.decode_text(text_buf);
field_is__8psk.decode_text(text_buf);
field_bep__meas.decode_text(text_buf);
}

void BEPMeas::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BEPMeas::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BEPMeas::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, BEPMeas_presence_descr_.raw->forceomit);
  decoded_field_length = field_presence.RAW_decode(BEPMeas_presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_is__8psk = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BEPMeas_is__8psk_descr_.raw->forceomit);
  decoded_field_length = field_is__8psk().RAW_decode(BEPMeas_is__8psk_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_is__8psk = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_is__8psk=OMIT_VALUE;
  if (limit > 0 && field_presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_bep__meas = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BEPMeas_bep__meas_descr_.raw->forceomit);
  decoded_field_length = field_bep__meas().RAW_decode(BEPMeas_bep__meas_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_bep__meas = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bep__meas=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BEPMeas::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, BEPMeas_presence_descr_.raw);
  if (field_is__8psk.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BEPMeas_is__8psk_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_bep__meas.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BEPMeas_bep__meas_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_presence.RAW_encode(BEPMeas_presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_is__8psk.ispresent()) {
  encoded_length += field_is__8psk().RAW_encode(BEPMeas_is__8psk_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_bep__meas.ispresent()) {
  encoded_length += field_bep__meas().RAW_encode(BEPMeas_bep__meas_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_is__8psk.ispresent() && (field_presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(BEPMeas_presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_bep__meas.ispresent() && (field_presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(BEPMeas_presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BEPMeas_template::single_value_struct {
BITSTRING_template field_presence;
BITSTRING_template field_is__8psk;
INTEGER_template field_bep__meas;
};

void BEPMeas_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_presence = ANY_VALUE;
single_value->field_is__8psk = ANY_OR_OMIT;
single_value->field_bep__meas = ANY_OR_OMIT;
}
}
}

void BEPMeas_template::copy_value(const BEPMeas& other_value)
{
single_value = new single_value_struct;
if (other_value.presence().is_bound()) {
  single_value->field_presence = other_value.presence();
} else {
  single_value->field_presence.clean_up();
}
if (other_value.is__8psk().is_bound()) {
  if (other_value.is__8psk().ispresent()) single_value->field_is__8psk = other_value.is__8psk()();
  else single_value->field_is__8psk = OMIT_VALUE;
} else {
  single_value->field_is__8psk.clean_up();
}
if (other_value.bep__meas().is_bound()) {
  if (other_value.bep__meas().ispresent()) single_value->field_bep__meas = other_value.bep__meas()();
  else single_value->field_bep__meas = OMIT_VALUE;
} else {
  single_value->field_bep__meas.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BEPMeas_template::copy_template(const BEPMeas_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.presence().get_selection()) {
single_value->field_presence = other_value.presence();
} else {
single_value->field_presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.is__8psk().get_selection()) {
single_value->field_is__8psk = other_value.is__8psk();
} else {
single_value->field_is__8psk.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bep__meas().get_selection()) {
single_value->field_bep__meas = other_value.bep__meas();
} else {
single_value->field_bep__meas.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BEPMeas_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BEPMeas_template(*other_value.implication_.precondition);
implication_.implied_template = new BEPMeas_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeas.");
break;
}
set_selection(other_value);
}

BEPMeas_template::BEPMeas_template()
{
}

BEPMeas_template::BEPMeas_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BEPMeas_template::BEPMeas_template(const BEPMeas& other_value)
{
copy_value(other_value);
}

BEPMeas_template::BEPMeas_template(const OPTIONAL<BEPMeas>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BEPMeas&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.BEPMeas from an unbound optional field.");
}
}

BEPMeas_template::BEPMeas_template(BEPMeas_template* p_precondition, BEPMeas_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BEPMeas_template::BEPMeas_template(Dynamic_Match_Interface<BEPMeas>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BEPMeas>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BEPMeas_template::BEPMeas_template(const BEPMeas_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BEPMeas_template::~BEPMeas_template()
{
clean_up();
}

BEPMeas_template& BEPMeas_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BEPMeas_template& BEPMeas_template::operator=(const BEPMeas& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BEPMeas_template& BEPMeas_template::operator=(const OPTIONAL<BEPMeas>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BEPMeas&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.BEPMeas.");
}
return *this;
}

BEPMeas_template& BEPMeas_template::operator=(const BEPMeas_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BEPMeas_template::match(const BEPMeas& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.presence().is_bound()) return FALSE;
if(!single_value->field_presence.match(other_value.presence(), legacy))return FALSE;
if(!other_value.is__8psk().is_bound()) return FALSE;
if((other_value.is__8psk().ispresent() ? !single_value->field_is__8psk.match((const BITSTRING&)other_value.is__8psk(), legacy) : !single_value->field_is__8psk.match_omit(legacy)))return FALSE;
if(!other_value.bep__meas().is_bound()) return FALSE;
if((other_value.bep__meas().ispresent() ? !single_value->field_bep__meas.match((const INTEGER&)other_value.bep__meas(), legacy) : !single_value->field_bep__meas.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeas.");
}
return FALSE;
}

boolean BEPMeas_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_presence.is_bound()
 || (single_value->field_is__8psk.is_omit() || single_value->field_is__8psk.is_bound())
 || (single_value->field_bep__meas.is_omit() || single_value->field_bep__meas.is_bound());
}

boolean BEPMeas_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_presence.is_value()
 && (single_value->field_is__8psk.is_omit() || single_value->field_is__8psk.is_value())
 && (single_value->field_bep__meas.is_omit() || single_value->field_bep__meas.is_value());
}

void BEPMeas_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BEPMeas BEPMeas_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.BEPMeas.");
BEPMeas ret_val;
if (single_value->field_presence.is_bound()) {
ret_val.presence() = single_value->field_presence.valueof();
}
if (single_value->field_is__8psk.is_omit()) ret_val.is__8psk() = OMIT_VALUE;
else if (single_value->field_is__8psk.is_bound()) {
ret_val.is__8psk() = single_value->field_is__8psk.valueof();
}
if (single_value->field_bep__meas.is_omit()) ret_val.bep__meas() = OMIT_VALUE;
else if (single_value->field_bep__meas.is_bound()) {
ret_val.bep__meas() = single_value->field_bep__meas.valueof();
}
return ret_val;
}

void BEPMeas_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.BEPMeas.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BEPMeas_template[list_length];
}

BEPMeas_template& BEPMeas_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.BEPMeas.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.BEPMeas.");
return value_list.list_value[list_index];
}

BITSTRING_template& BEPMeas_template::presence()
{
set_specific();
return single_value->field_presence;
}

const BITSTRING_template& BEPMeas_template::presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field presence of a non-specific template of type @RLCMAC_CSN1_Types.BEPMeas.");
return single_value->field_presence;
}

BITSTRING_template& BEPMeas_template::is__8psk()
{
set_specific();
return single_value->field_is__8psk;
}

const BITSTRING_template& BEPMeas_template::is__8psk() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field is_8psk of a non-specific template of type @RLCMAC_CSN1_Types.BEPMeas.");
return single_value->field_is__8psk;
}

INTEGER_template& BEPMeas_template::bep__meas()
{
set_specific();
return single_value->field_bep__meas;
}

const INTEGER_template& BEPMeas_template::bep__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bep_meas of a non-specific template of type @RLCMAC_CSN1_Types.BEPMeas.");
return single_value->field_bep__meas;
}

int BEPMeas_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_is__8psk.is_present()) ret_val++;
      if (single_value->field_bep__meas.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeas containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeas.");
  }
  return 0;
}

void BEPMeas_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ presence := ");
single_value->field_presence.log();
TTCN_Logger::log_event_str(", is_8psk := ");
single_value->field_is__8psk.log();
TTCN_Logger::log_event_str(", bep_meas := ");
single_value->field_bep__meas.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BEPMeas_template::log_match(const BEPMeas& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_presence.match(match_value.presence(), legacy)){
TTCN_Logger::log_logmatch_info(".presence");
single_value->field_presence.log_match(match_value.presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.is__8psk().ispresent()){
if(!single_value->field_is__8psk.match(match_value.is__8psk(), legacy)){
TTCN_Logger::log_logmatch_info(".is_8psk");
single_value->field_is__8psk.log_match(match_value.is__8psk(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_is__8psk.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".is_8psk := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_is__8psk.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bep__meas().ispresent()){
if(!single_value->field_bep__meas.match(match_value.bep__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".bep_meas");
single_value->field_bep__meas.log_match(match_value.bep__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bep__meas.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bep_meas := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bep__meas.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ presence := ");
single_value->field_presence.log_match(match_value.presence(), legacy);
TTCN_Logger::log_event_str(", is_8psk := ");
if (match_value.is__8psk().ispresent()) {
single_value->field_is__8psk.log_match(match_value.is__8psk(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_is__8psk.log();
if (single_value->field_is__8psk.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bep_meas := ");
if (match_value.bep__meas().ispresent()) {
single_value->field_bep__meas.log_match(match_value.bep__meas(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bep__meas.log();
if (single_value->field_bep__meas.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BEPMeas_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (presence().is_bound()) presence().set_implicit_omit();
if (!is__8psk().is_bound()) is__8psk() = OMIT_VALUE;
else is__8psk().set_implicit_omit();
if (!bep__meas().is_bound()) bep__meas() = OMIT_VALUE;
else bep__meas().set_implicit_omit();
}

void BEPMeas_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_presence.encode_text(text_buf);
single_value->field_is__8psk.encode_text(text_buf);
single_value->field_bep__meas.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeas.");
}
}

void BEPMeas_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_presence.decode_text(text_buf);
single_value->field_is__8psk.decode_text(text_buf);
single_value->field_bep__meas.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BEPMeas_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.BEPMeas.");
}
}

void BEPMeas_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BEPMeas_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.BEPMeas has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) is__8psk().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bep__meas().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "is_8psk")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          is__8psk().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.BEPMeas: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BEPMeas_template* precondition = new BEPMeas_template;
    precondition->set_param(*param.get_elem(0));
    BEPMeas_template* implied_template = new BEPMeas_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BEPMeas_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.BEPMeas");
  }
  is_ifpresent = param.get_ifpresent();
}

void BEPMeas_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeas");
single_value->field_is__8psk.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeas");
single_value->field_bep__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeas");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeas");
}

boolean BEPMeas_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BEPMeas_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const BEPMeas BEPMeasLi::UNBOUND_ELEM;
BEPMeasLi::BEPMeasLi()
{
val_ptr = NULL;
}

BEPMeasLi::BEPMeasLi(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BEPMeasLi::BEPMeasLi(const BEPMeasLi& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BEPMeasLi::~BEPMeasLi()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BEPMeasLi::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BEPMeasLi& BEPMeasLi::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BEPMeasLi& BEPMeasLi::operator=(const BEPMeasLi& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BEPMeasLi::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return val_ptr->n_elements == 0 ;
}

boolean BEPMeasLi::operator==(const BEPMeasLi& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BEPMeas& BEPMeasLi::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.BEPMeasLi using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BEPMeas**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BEPMeas(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BEPMeas;
}
return *val_ptr->value_elements[index_value];
}

BEPMeas& BEPMeasLi::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return (*this)[(int)index_value];
}

const BEPMeas& BEPMeasLi::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.BEPMeasLi using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RLCMAC_CSN1_Types.BEPMeasLi: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BEPMeas& BEPMeasLi::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return (*this)[(int)index_value];
}

BEPMeasLi BEPMeasLi::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BEPMeasLi BEPMeasLi::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BEPMeasLi BEPMeasLi::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BEPMeasLi BEPMeasLi::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BEPMeasLi ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BEPMeas(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BEPMeasLi BEPMeasLi::operator+(const BEPMeasLi& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RLCMAC_CSN1_Types.BEPMeasLi concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BEPMeasLi ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BEPMeas(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BEPMeas(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BEPMeasLi BEPMeasLi::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RLCMAC_CSN1_Types.BEPMeasLi","element");
BEPMeasLi ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BEPMeas(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BEPMeasLi BEPMeasLi::replace(int index, int len, const BEPMeasLi& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RLCMAC_CSN1_Types.BEPMeasLi","element");
BEPMeasLi ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BEPMeas(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BEPMeas(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BEPMeas(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BEPMeasLi BEPMeasLi::replace(int index, int len, const BEPMeasLi_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BEPMeasLi::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BEPMeas**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BEPMeas(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BEPMeas**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RLCMAC_CSN1_Types.BEPMeasLi: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BEPMeas**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BEPMeasLi::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BEPMeasLi::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return val_ptr->n_elements;
}

int BEPMeasLi::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BEPMeasLi::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BEPMeasLi::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BEPMeasLi::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.BEPMeasLi");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.BEPMeasLi");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BEPMeasLi::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BEPMeasLi::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RLCMAC_CSN1_Types.BEPMeasLi.");
val_ptr->value_elements = (BEPMeas**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BEPMeas;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BEPMeasLi::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BEPMeasLi::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BEPMeasLi::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BEPMeasLi::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BEPMeasLi_template::copy_value(const BEPMeasLi& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RLCMAC_CSN1_Types.BEPMeasLi with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BEPMeas_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BEPMeas_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BEPMeas_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BEPMeasLi_template::copy_template(const BEPMeasLi_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BEPMeas_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BEPMeas_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BEPMeas_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BEPMeasLi_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BEPMeasLi_template(*other_value.implication_.precondition);
implication_.implied_template = new BEPMeasLi_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
break;
}
set_selection(other_value);
}

boolean BEPMeasLi_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BEPMeasLi_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BEPMeasLi*)value_ptr)[value_index], legacy);
else return ((const BEPMeasLi_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BEPMeasLi_template::BEPMeasLi_template()
{
}

BEPMeasLi_template::BEPMeasLi_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BEPMeasLi_template::BEPMeasLi_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BEPMeasLi_template::BEPMeasLi_template(const BEPMeasLi& other_value)
{
copy_value(other_value);
}

BEPMeasLi_template::BEPMeasLi_template(const OPTIONAL<BEPMeasLi>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BEPMeasLi&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.BEPMeasLi from an unbound optional field.");
}
}

BEPMeasLi_template::BEPMeasLi_template(BEPMeasLi_template* p_precondition, BEPMeasLi_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BEPMeasLi_template::BEPMeasLi_template(Dynamic_Match_Interface<BEPMeasLi>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BEPMeasLi>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BEPMeasLi_template::BEPMeasLi_template(const BEPMeasLi_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BEPMeasLi_template::~BEPMeasLi_template()
{
clean_up();
}

void BEPMeasLi_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BEPMeasLi_template& BEPMeasLi_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BEPMeasLi_template& BEPMeasLi_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BEPMeasLi_template& BEPMeasLi_template::operator=(const BEPMeasLi& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BEPMeasLi_template& BEPMeasLi_template::operator=(const OPTIONAL<BEPMeasLi>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BEPMeasLi&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
}
return *this;
}

BEPMeasLi_template& BEPMeasLi_template::operator=(const BEPMeasLi_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BEPMeas_template& BEPMeasLi_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.BEPMeasLi using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.BEPMeasLi.");
    break;
}
return *single_value.value_elements[index_value];
}

BEPMeas_template& BEPMeasLi_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return (*this)[(int)index_value];
}

const BEPMeas_template& BEPMeasLi_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.BEPMeasLi using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RLCMAC_CSN1_Types.BEPMeasLi: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BEPMeas_template& BEPMeasLi_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return (*this)[(int)index_value];
}

void BEPMeasLi_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BEPMeas_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BEPMeas_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BEPMeas_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BEPMeas_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BEPMeasLi_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BEPMeasLi_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.BEPMeasLi containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeasLi.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RLCMAC_CSN1_Types.BEPMeasLi");
}

boolean BEPMeasLi_template::match(const BEPMeasLi& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
}
return FALSE;
}

boolean BEPMeasLi_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BEPMeasLi BEPMeasLi_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
BEPMeasLi ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BEPMeasLi BEPMeasLi_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BEPMeasLi BEPMeasLi_template::replace(int index, int len, const BEPMeasLi_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BEPMeasLi BEPMeasLi_template::replace(int index, int len, const BEPMeasLi& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BEPMeasLi_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BEPMeasLi_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
}
set_selection(template_type);
}

BEPMeasLi_template& BEPMeasLi_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
return value_list.list_value[list_index];
}

void BEPMeasLi_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BEPMeasLi_template::log_match(const BEPMeasLi& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BEPMeasLi_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
}
}

void BEPMeasLi_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
single_value.value_elements = (BEPMeas_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BEPMeas_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BEPMeasLi_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RLCMAC_CSN1_Types.BEPMeasLi.");
}
}

boolean BEPMeasLi_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BEPMeasLi_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BEPMeasLi_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BEPMeasLi_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BEPMeasLi_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BEPMeasLi_template* precondition = new BEPMeasLi_template;
    precondition->set_param(*param.get_elem(0));
    BEPMeasLi_template* implied_template = new BEPMeasLi_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BEPMeasLi_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RLCMAC_CSN1_Types.BEPMeasLi");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BEPMeasLi_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeasLi");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.BEPMeasLi");
}

boolean BEPMeasLi_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
EgprsTimeslotLinkQualityMeasurements::EgprsTimeslotLinkQualityMeasurements()
{
}

EgprsTimeslotLinkQualityMeasurements::EgprsTimeslotLinkQualityMeasurements(const BITSTRING& par_bep__measurements__presence,
    const OPTIONAL< BEPMeasLi >& par_bep__meas,
    const BITSTRING& par_i__measurements__presence,
    const OPTIONAL< ILevels >& par_i__meas)
  :   field_bep__measurements__presence(par_bep__measurements__presence),
  field_bep__meas(par_bep__meas),
  field_i__measurements__presence(par_i__measurements__presence),
  field_i__meas(par_i__meas)
{
}

EgprsTimeslotLinkQualityMeasurements::EgprsTimeslotLinkQualityMeasurements(const EgprsTimeslotLinkQualityMeasurements& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
if (other_value.bep__measurements__presence().is_bound()) field_bep__measurements__presence = other_value.bep__measurements__presence();
else field_bep__measurements__presence.clean_up();
if (other_value.bep__meas().is_bound()) field_bep__meas = other_value.bep__meas();
else field_bep__meas.clean_up();
if (other_value.i__measurements__presence().is_bound()) field_i__measurements__presence = other_value.i__measurements__presence();
else field_i__measurements__presence.clean_up();
if (other_value.i__meas().is_bound()) field_i__meas = other_value.i__meas();
else field_i__meas.clean_up();
}

void EgprsTimeslotLinkQualityMeasurements::clean_up()
{
field_bep__measurements__presence.clean_up();
field_bep__meas.clean_up();
field_i__measurements__presence.clean_up();
field_i__meas.clean_up();
}

const TTCN_Typedescriptor_t* EgprsTimeslotLinkQualityMeasurements::get_descriptor() const { return &EgprsTimeslotLinkQualityMeasurements_descr_; }
EgprsTimeslotLinkQualityMeasurements& EgprsTimeslotLinkQualityMeasurements::operator=(const EgprsTimeslotLinkQualityMeasurements& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
  if (other_value.bep__measurements__presence().is_bound()) field_bep__measurements__presence = other_value.bep__measurements__presence();
  else field_bep__measurements__presence.clean_up();
  if (other_value.bep__meas().is_bound()) field_bep__meas = other_value.bep__meas();
  else field_bep__meas.clean_up();
  if (other_value.i__measurements__presence().is_bound()) field_i__measurements__presence = other_value.i__measurements__presence();
  else field_i__measurements__presence.clean_up();
  if (other_value.i__meas().is_bound()) field_i__meas = other_value.i__meas();
  else field_i__meas.clean_up();
}
return *this;
}

boolean EgprsTimeslotLinkQualityMeasurements::operator==(const EgprsTimeslotLinkQualityMeasurements& other_value) const
{
return field_bep__measurements__presence==other_value.field_bep__measurements__presence
  && field_bep__meas==other_value.field_bep__meas
  && field_i__measurements__presence==other_value.field_i__measurements__presence
  && field_i__meas==other_value.field_i__meas;
}

boolean EgprsTimeslotLinkQualityMeasurements::is_bound() const
{
return (field_bep__measurements__presence.is_bound())
  || (OPTIONAL_OMIT == field_bep__meas.get_selection() || field_bep__meas.is_bound())
  || (field_i__measurements__presence.is_bound())
  || (OPTIONAL_OMIT == field_i__meas.get_selection() || field_i__meas.is_bound());
}
boolean EgprsTimeslotLinkQualityMeasurements::is_value() const
{
return field_bep__measurements__presence.is_value()
  && (OPTIONAL_OMIT == field_bep__meas.get_selection() || field_bep__meas.is_value())
  && field_i__measurements__presence.is_value()
  && (OPTIONAL_OMIT == field_i__meas.get_selection() || field_i__meas.is_value());
}
int EgprsTimeslotLinkQualityMeasurements::size_of() const
{
  int ret_val = 2;
  if (field_bep__meas.ispresent()) ret_val++;
  if (field_i__meas.ispresent()) ret_val++;
  return ret_val;
}

void EgprsTimeslotLinkQualityMeasurements::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ bep_measurements_presence := ");
field_bep__measurements__presence.log();
TTCN_Logger::log_event_str(", bep_meas := ");
field_bep__meas.log();
TTCN_Logger::log_event_str(", i_measurements_presence := ");
field_i__measurements__presence.log();
TTCN_Logger::log_event_str(", i_meas := ");
field_i__meas.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsTimeslotLinkQualityMeasurements::set_implicit_omit()
{
if (bep__measurements__presence().is_bound()) bep__measurements__presence().set_implicit_omit();
if (!bep__meas().is_bound()) bep__meas() = OMIT_VALUE;
else bep__meas().set_implicit_omit();
if (i__measurements__presence().is_bound()) i__measurements__presence().set_implicit_omit();
if (!i__meas().is_bound()) i__meas() = OMIT_VALUE;
else i__meas().set_implicit_omit();
}

void EgprsTimeslotLinkQualityMeasurements::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) bep__measurements__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bep__meas().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) i__measurements__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) i__meas().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_measurements_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__measurements__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_measurements_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__measurements__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
  }
}

void EgprsTimeslotLinkQualityMeasurements::encode_text(Text_Buf& text_buf) const
{
field_bep__measurements__presence.encode_text(text_buf);
field_bep__meas.encode_text(text_buf);
field_i__measurements__presence.encode_text(text_buf);
field_i__meas.encode_text(text_buf);
}

void EgprsTimeslotLinkQualityMeasurements::decode_text(Text_Buf& text_buf)
{
field_bep__measurements__presence.decode_text(text_buf);
field_bep__meas.decode_text(text_buf);
field_i__measurements__presence.decode_text(text_buf);
field_i__meas.decode_text(text_buf);
}

void EgprsTimeslotLinkQualityMeasurements::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsTimeslotLinkQualityMeasurements::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsTimeslotLinkQualityMeasurements::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsTimeslotLinkQualityMeasurements_bep__measurements__presence_descr_.raw->forceomit);
  decoded_field_length = field_bep__measurements__presence.RAW_decode(EgprsTimeslotLinkQualityMeasurements_bep__measurements__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_bep__measurements__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_bep__meas = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsTimeslotLinkQualityMeasurements_bep__meas_descr_.raw->forceomit);
  decoded_field_length = field_bep__meas().RAW_decode(EgprsTimeslotLinkQualityMeasurements_bep__meas_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_bep__meas = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bep__meas=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsTimeslotLinkQualityMeasurements_i__measurements__presence_descr_.raw->forceomit);
  decoded_field_length = field_i__measurements__presence.RAW_decode(EgprsTimeslotLinkQualityMeasurements_i__measurements__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_i__measurements__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_i__meas = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, EgprsTimeslotLinkQualityMeasurements_i__meas_descr_.raw->forceomit);
  decoded_field_length = field_i__meas().RAW_decode(EgprsTimeslotLinkQualityMeasurements_i__meas_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_i__meas = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_i__meas=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsTimeslotLinkQualityMeasurements::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsTimeslotLinkQualityMeasurements_bep__measurements__presence_descr_.raw);
  if (field_bep__meas.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsTimeslotLinkQualityMeasurements_bep__meas_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsTimeslotLinkQualityMeasurements_i__measurements__presence_descr_.raw);
  if (field_i__meas.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EgprsTimeslotLinkQualityMeasurements_i__meas_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_bep__measurements__presence.RAW_encode(EgprsTimeslotLinkQualityMeasurements_bep__measurements__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_bep__meas.ispresent()) {
  encoded_length += field_bep__meas().RAW_encode(EgprsTimeslotLinkQualityMeasurements_bep__meas_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_i__measurements__presence.RAW_encode(EgprsTimeslotLinkQualityMeasurements_i__measurements__presence_descr_, *myleaf.body.node.nodes[2]);
  if (field_i__meas.ispresent()) {
  encoded_length += field_i__meas().RAW_encode(EgprsTimeslotLinkQualityMeasurements_i__meas_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_bep__meas.ispresent() && (field_bep__measurements__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsTimeslotLinkQualityMeasurements_bep__measurements__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_i__meas.ispresent() && (field_i__measurements__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsTimeslotLinkQualityMeasurements_i__measurements__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EgprsTimeslotLinkQualityMeasurements_template::single_value_struct {
BITSTRING_template field_bep__measurements__presence;
BEPMeasLi_template field_bep__meas;
BITSTRING_template field_i__measurements__presence;
ILevels_template field_i__meas;
};

void EgprsTimeslotLinkQualityMeasurements_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_bep__measurements__presence = ANY_VALUE;
single_value->field_bep__meas = ANY_OR_OMIT;
single_value->field_i__measurements__presence = ANY_VALUE;
single_value->field_i__meas = ANY_OR_OMIT;
}
}
}

void EgprsTimeslotLinkQualityMeasurements_template::copy_value(const EgprsTimeslotLinkQualityMeasurements& other_value)
{
single_value = new single_value_struct;
if (other_value.bep__measurements__presence().is_bound()) {
  single_value->field_bep__measurements__presence = other_value.bep__measurements__presence();
} else {
  single_value->field_bep__measurements__presence.clean_up();
}
if (other_value.bep__meas().is_bound()) {
  if (other_value.bep__meas().ispresent()) single_value->field_bep__meas = other_value.bep__meas()();
  else single_value->field_bep__meas = OMIT_VALUE;
} else {
  single_value->field_bep__meas.clean_up();
}
if (other_value.i__measurements__presence().is_bound()) {
  single_value->field_i__measurements__presence = other_value.i__measurements__presence();
} else {
  single_value->field_i__measurements__presence.clean_up();
}
if (other_value.i__meas().is_bound()) {
  if (other_value.i__meas().ispresent()) single_value->field_i__meas = other_value.i__meas()();
  else single_value->field_i__meas = OMIT_VALUE;
} else {
  single_value->field_i__meas.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsTimeslotLinkQualityMeasurements_template::copy_template(const EgprsTimeslotLinkQualityMeasurements_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.bep__measurements__presence().get_selection()) {
single_value->field_bep__measurements__presence = other_value.bep__measurements__presence();
} else {
single_value->field_bep__measurements__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bep__meas().get_selection()) {
single_value->field_bep__meas = other_value.bep__meas();
} else {
single_value->field_bep__meas.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.i__measurements__presence().get_selection()) {
single_value->field_i__measurements__presence = other_value.i__measurements__presence();
} else {
single_value->field_i__measurements__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.i__meas().get_selection()) {
single_value->field_i__meas = other_value.i__meas();
} else {
single_value->field_i__meas.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsTimeslotLinkQualityMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsTimeslotLinkQualityMeasurements_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsTimeslotLinkQualityMeasurements_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
break;
}
set_selection(other_value);
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template()
{
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(const EgprsTimeslotLinkQualityMeasurements& other_value)
{
copy_value(other_value);
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(const OPTIONAL<EgprsTimeslotLinkQualityMeasurements>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsTimeslotLinkQualityMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements from an unbound optional field.");
}
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(EgprsTimeslotLinkQualityMeasurements_template* p_precondition, EgprsTimeslotLinkQualityMeasurements_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(Dynamic_Match_Interface<EgprsTimeslotLinkQualityMeasurements>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsTimeslotLinkQualityMeasurements>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsTimeslotLinkQualityMeasurements_template::EgprsTimeslotLinkQualityMeasurements_template(const EgprsTimeslotLinkQualityMeasurements_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsTimeslotLinkQualityMeasurements_template::~EgprsTimeslotLinkQualityMeasurements_template()
{
clean_up();
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsTimeslotLinkQualityMeasurements_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsTimeslotLinkQualityMeasurements_template::operator=(const EgprsTimeslotLinkQualityMeasurements& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsTimeslotLinkQualityMeasurements_template::operator=(const OPTIONAL<EgprsTimeslotLinkQualityMeasurements>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsTimeslotLinkQualityMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
}
return *this;
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsTimeslotLinkQualityMeasurements_template::operator=(const EgprsTimeslotLinkQualityMeasurements_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsTimeslotLinkQualityMeasurements_template::match(const EgprsTimeslotLinkQualityMeasurements& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.bep__measurements__presence().is_bound()) return FALSE;
if(!single_value->field_bep__measurements__presence.match(other_value.bep__measurements__presence(), legacy))return FALSE;
if(!other_value.bep__meas().is_bound()) return FALSE;
if((other_value.bep__meas().ispresent() ? !single_value->field_bep__meas.match((const BEPMeasLi&)other_value.bep__meas(), legacy) : !single_value->field_bep__meas.match_omit(legacy)))return FALSE;
if(!other_value.i__measurements__presence().is_bound()) return FALSE;
if(!single_value->field_i__measurements__presence.match(other_value.i__measurements__presence(), legacy))return FALSE;
if(!other_value.i__meas().is_bound()) return FALSE;
if((other_value.i__meas().ispresent() ? !single_value->field_i__meas.match((const ILevels&)other_value.i__meas(), legacy) : !single_value->field_i__meas.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
}
return FALSE;
}

boolean EgprsTimeslotLinkQualityMeasurements_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_bep__measurements__presence.is_bound()
 || (single_value->field_bep__meas.is_omit() || single_value->field_bep__meas.is_bound())
 || single_value->field_i__measurements__presence.is_bound()
 || (single_value->field_i__meas.is_omit() || single_value->field_i__meas.is_bound());
}

boolean EgprsTimeslotLinkQualityMeasurements_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_bep__measurements__presence.is_value()
 && (single_value->field_bep__meas.is_omit() || single_value->field_bep__meas.is_value())
 && single_value->field_i__measurements__presence.is_value()
 && (single_value->field_i__meas.is_omit() || single_value->field_i__meas.is_value());
}

void EgprsTimeslotLinkQualityMeasurements_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsTimeslotLinkQualityMeasurements EgprsTimeslotLinkQualityMeasurements_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
EgprsTimeslotLinkQualityMeasurements ret_val;
if (single_value->field_bep__measurements__presence.is_bound()) {
ret_val.bep__measurements__presence() = single_value->field_bep__measurements__presence.valueof();
}
if (single_value->field_bep__meas.is_omit()) ret_val.bep__meas() = OMIT_VALUE;
else if (single_value->field_bep__meas.is_bound()) {
ret_val.bep__meas() = single_value->field_bep__meas.valueof();
}
if (single_value->field_i__measurements__presence.is_bound()) {
ret_val.i__measurements__presence() = single_value->field_i__measurements__presence.valueof();
}
if (single_value->field_i__meas.is_omit()) ret_val.i__meas() = OMIT_VALUE;
else if (single_value->field_i__meas.is_bound()) {
ret_val.i__meas() = single_value->field_i__meas.valueof();
}
return ret_val;
}

void EgprsTimeslotLinkQualityMeasurements_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsTimeslotLinkQualityMeasurements_template[list_length];
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsTimeslotLinkQualityMeasurements_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
return value_list.list_value[list_index];
}

BITSTRING_template& EgprsTimeslotLinkQualityMeasurements_template::bep__measurements__presence()
{
set_specific();
return single_value->field_bep__measurements__presence;
}

const BITSTRING_template& EgprsTimeslotLinkQualityMeasurements_template::bep__measurements__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bep_measurements_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
return single_value->field_bep__measurements__presence;
}

BEPMeasLi_template& EgprsTimeslotLinkQualityMeasurements_template::bep__meas()
{
set_specific();
return single_value->field_bep__meas;
}

const BEPMeasLi_template& EgprsTimeslotLinkQualityMeasurements_template::bep__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bep_meas of a non-specific template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
return single_value->field_bep__meas;
}

BITSTRING_template& EgprsTimeslotLinkQualityMeasurements_template::i__measurements__presence()
{
set_specific();
return single_value->field_i__measurements__presence;
}

const BITSTRING_template& EgprsTimeslotLinkQualityMeasurements_template::i__measurements__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field i_measurements_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
return single_value->field_i__measurements__presence;
}

ILevels_template& EgprsTimeslotLinkQualityMeasurements_template::i__meas()
{
set_specific();
return single_value->field_i__meas;
}

const ILevels_template& EgprsTimeslotLinkQualityMeasurements_template::i__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field i_meas of a non-specific template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
return single_value->field_i__meas;
}

int EgprsTimeslotLinkQualityMeasurements_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_bep__meas.is_present()) ret_val++;
      if (single_value->field_i__meas.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
  }
  return 0;
}

void EgprsTimeslotLinkQualityMeasurements_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ bep_measurements_presence := ");
single_value->field_bep__measurements__presence.log();
TTCN_Logger::log_event_str(", bep_meas := ");
single_value->field_bep__meas.log();
TTCN_Logger::log_event_str(", i_measurements_presence := ");
single_value->field_i__measurements__presence.log();
TTCN_Logger::log_event_str(", i_meas := ");
single_value->field_i__meas.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsTimeslotLinkQualityMeasurements_template::log_match(const EgprsTimeslotLinkQualityMeasurements& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_bep__measurements__presence.match(match_value.bep__measurements__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".bep_measurements_presence");
single_value->field_bep__measurements__presence.log_match(match_value.bep__measurements__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.bep__meas().ispresent()){
if(!single_value->field_bep__meas.match(match_value.bep__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".bep_meas");
single_value->field_bep__meas.log_match(match_value.bep__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bep__meas.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bep_meas := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bep__meas.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_i__measurements__presence.match(match_value.i__measurements__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".i_measurements_presence");
single_value->field_i__measurements__presence.log_match(match_value.i__measurements__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.i__meas().ispresent()){
if(!single_value->field_i__meas.match(match_value.i__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".i_meas");
single_value->field_i__meas.log_match(match_value.i__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_i__meas.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".i_meas := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_i__meas.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ bep_measurements_presence := ");
single_value->field_bep__measurements__presence.log_match(match_value.bep__measurements__presence(), legacy);
TTCN_Logger::log_event_str(", bep_meas := ");
if (match_value.bep__meas().ispresent()) {
single_value->field_bep__meas.log_match(match_value.bep__meas(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bep__meas.log();
if (single_value->field_bep__meas.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", i_measurements_presence := ");
single_value->field_i__measurements__presence.log_match(match_value.i__measurements__presence(), legacy);
TTCN_Logger::log_event_str(", i_meas := ");
if (match_value.i__meas().ispresent()) {
single_value->field_i__meas.log_match(match_value.i__meas(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_i__meas.log();
if (single_value->field_i__meas.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsTimeslotLinkQualityMeasurements_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (bep__measurements__presence().is_bound()) bep__measurements__presence().set_implicit_omit();
if (!bep__meas().is_bound()) bep__meas() = OMIT_VALUE;
else bep__meas().set_implicit_omit();
if (i__measurements__presence().is_bound()) i__measurements__presence().set_implicit_omit();
if (!i__meas().is_bound()) i__meas() = OMIT_VALUE;
else i__meas().set_implicit_omit();
}

void EgprsTimeslotLinkQualityMeasurements_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_bep__measurements__presence.encode_text(text_buf);
single_value->field_bep__meas.encode_text(text_buf);
single_value->field_i__measurements__presence.encode_text(text_buf);
single_value->field_i__meas.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
}
}

void EgprsTimeslotLinkQualityMeasurements_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_bep__measurements__presence.decode_text(text_buf);
single_value->field_bep__meas.decode_text(text_buf);
single_value->field_i__measurements__presence.decode_text(text_buf);
single_value->field_i__meas.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsTimeslotLinkQualityMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements.");
}
}

void EgprsTimeslotLinkQualityMeasurements_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsTimeslotLinkQualityMeasurements_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) bep__measurements__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bep__meas().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) i__measurements__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) i__meas().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_measurements_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__measurements__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_measurements_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__measurements__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsTimeslotLinkQualityMeasurements_template* precondition = new EgprsTimeslotLinkQualityMeasurements_template;
    precondition->set_param(*param.get_elem(0));
    EgprsTimeslotLinkQualityMeasurements_template* implied_template = new EgprsTimeslotLinkQualityMeasurements_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsTimeslotLinkQualityMeasurements_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsTimeslotLinkQualityMeasurements_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_bep__measurements__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
single_value->field_bep__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
single_value->field_i__measurements__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
single_value->field_i__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsTimeslotLinkQualityMeasurements");
}

boolean EgprsTimeslotLinkQualityMeasurements_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsTimeslotLinkQualityMeasurements_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EgprsChannelQualityReport::EgprsChannelQualityReport()
{
}

EgprsChannelQualityReport::EgprsChannelQualityReport(const EgprsBEPLinkQualityMeasurements& par_bep__link__qual__meas,
    const INTEGER& par_c__value,
    const EgprsTimeslotLinkQualityMeasurements& par_ts__link__qual__meas)
  :   field_bep__link__qual__meas(par_bep__link__qual__meas),
  field_c__value(par_c__value),
  field_ts__link__qual__meas(par_ts__link__qual__meas)
{
}

EgprsChannelQualityReport::EgprsChannelQualityReport(const EgprsChannelQualityReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
if (other_value.bep__link__qual__meas().is_bound()) field_bep__link__qual__meas = other_value.bep__link__qual__meas();
else field_bep__link__qual__meas.clean_up();
if (other_value.c__value().is_bound()) field_c__value = other_value.c__value();
else field_c__value.clean_up();
if (other_value.ts__link__qual__meas().is_bound()) field_ts__link__qual__meas = other_value.ts__link__qual__meas();
else field_ts__link__qual__meas.clean_up();
}

void EgprsChannelQualityReport::clean_up()
{
field_bep__link__qual__meas.clean_up();
field_c__value.clean_up();
field_ts__link__qual__meas.clean_up();
}

const TTCN_Typedescriptor_t* EgprsChannelQualityReport::get_descriptor() const { return &EgprsChannelQualityReport_descr_; }
EgprsChannelQualityReport& EgprsChannelQualityReport::operator=(const EgprsChannelQualityReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
  if (other_value.bep__link__qual__meas().is_bound()) field_bep__link__qual__meas = other_value.bep__link__qual__meas();
  else field_bep__link__qual__meas.clean_up();
  if (other_value.c__value().is_bound()) field_c__value = other_value.c__value();
  else field_c__value.clean_up();
  if (other_value.ts__link__qual__meas().is_bound()) field_ts__link__qual__meas = other_value.ts__link__qual__meas();
  else field_ts__link__qual__meas.clean_up();
}
return *this;
}

boolean EgprsChannelQualityReport::operator==(const EgprsChannelQualityReport& other_value) const
{
return field_bep__link__qual__meas==other_value.field_bep__link__qual__meas
  && field_c__value==other_value.field_c__value
  && field_ts__link__qual__meas==other_value.field_ts__link__qual__meas;
}

boolean EgprsChannelQualityReport::is_bound() const
{
return (field_bep__link__qual__meas.is_bound())
  || (field_c__value.is_bound())
  || (field_ts__link__qual__meas.is_bound());
}
boolean EgprsChannelQualityReport::is_value() const
{
return field_bep__link__qual__meas.is_value()
  && field_c__value.is_value()
  && field_ts__link__qual__meas.is_value();
}
void EgprsChannelQualityReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ bep_link_qual_meas := ");
field_bep__link__qual__meas.log();
TTCN_Logger::log_event_str(", c_value := ");
field_c__value.log();
TTCN_Logger::log_event_str(", ts_link_qual_meas := ");
field_ts__link__qual__meas.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsChannelQualityReport::set_implicit_omit()
{
if (bep__link__qual__meas().is_bound()) bep__link__qual__meas().set_implicit_omit();
if (c__value().is_bound()) c__value().set_implicit_omit();
if (ts__link__qual__meas().is_bound()) ts__link__qual__meas().set_implicit_omit();
}

void EgprsChannelQualityReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) bep__link__qual__meas().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) c__value().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ts__link__qual__meas().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_link_qual_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__link__qual__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "c_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          c__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ts_link_qual_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ts__link__qual__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsChannelQualityReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
  }
}

void EgprsChannelQualityReport::encode_text(Text_Buf& text_buf) const
{
field_bep__link__qual__meas.encode_text(text_buf);
field_c__value.encode_text(text_buf);
field_ts__link__qual__meas.encode_text(text_buf);
}

void EgprsChannelQualityReport::decode_text(Text_Buf& text_buf)
{
field_bep__link__qual__meas.decode_text(text_buf);
field_c__value.decode_text(text_buf);
field_ts__link__qual__meas.decode_text(text_buf);
}

void EgprsChannelQualityReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsChannelQualityReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsChannelQualityReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsChannelQualityReport_bep__link__qual__meas_descr_.raw->forceomit);
  decoded_field_length = field_bep__link__qual__meas.RAW_decode(EgprsChannelQualityReport_bep__link__qual__meas_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsChannelQualityReport_c__value_descr_.raw->forceomit);
  decoded_field_length = field_c__value.RAW_decode(EgprsChannelQualityReport_c__value_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsChannelQualityReport_ts__link__qual__meas_descr_.raw->forceomit);
  decoded_field_length = field_ts__link__qual__meas.RAW_decode(EgprsChannelQualityReport_ts__link__qual__meas_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsChannelQualityReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsChannelQualityReport_bep__link__qual__meas_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsChannelQualityReport_c__value_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsChannelQualityReport_ts__link__qual__meas_descr_.raw);
  encoded_length += field_bep__link__qual__meas.RAW_encode(EgprsChannelQualityReport_bep__link__qual__meas_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_c__value.RAW_encode(EgprsChannelQualityReport_c__value_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_ts__link__qual__meas.RAW_encode(EgprsChannelQualityReport_ts__link__qual__meas_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct EgprsChannelQualityReport_template::single_value_struct {
EgprsBEPLinkQualityMeasurements_template field_bep__link__qual__meas;
INTEGER_template field_c__value;
EgprsTimeslotLinkQualityMeasurements_template field_ts__link__qual__meas;
};

void EgprsChannelQualityReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_bep__link__qual__meas = ANY_VALUE;
single_value->field_c__value = ANY_VALUE;
single_value->field_ts__link__qual__meas = ANY_VALUE;
}
}
}

void EgprsChannelQualityReport_template::copy_value(const EgprsChannelQualityReport& other_value)
{
single_value = new single_value_struct;
if (other_value.bep__link__qual__meas().is_bound()) {
  single_value->field_bep__link__qual__meas = other_value.bep__link__qual__meas();
} else {
  single_value->field_bep__link__qual__meas.clean_up();
}
if (other_value.c__value().is_bound()) {
  single_value->field_c__value = other_value.c__value();
} else {
  single_value->field_c__value.clean_up();
}
if (other_value.ts__link__qual__meas().is_bound()) {
  single_value->field_ts__link__qual__meas = other_value.ts__link__qual__meas();
} else {
  single_value->field_ts__link__qual__meas.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsChannelQualityReport_template::copy_template(const EgprsChannelQualityReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.bep__link__qual__meas().get_selection()) {
single_value->field_bep__link__qual__meas = other_value.bep__link__qual__meas();
} else {
single_value->field_bep__link__qual__meas.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.c__value().get_selection()) {
single_value->field_c__value = other_value.c__value();
} else {
single_value->field_c__value.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ts__link__qual__meas().get_selection()) {
single_value->field_ts__link__qual__meas = other_value.ts__link__qual__meas();
} else {
single_value->field_ts__link__qual__meas.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsChannelQualityReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsChannelQualityReport_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsChannelQualityReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
break;
}
set_selection(other_value);
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template()
{
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(const EgprsChannelQualityReport& other_value)
{
copy_value(other_value);
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(const OPTIONAL<EgprsChannelQualityReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsChannelQualityReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport from an unbound optional field.");
}
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(EgprsChannelQualityReport_template* p_precondition, EgprsChannelQualityReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(Dynamic_Match_Interface<EgprsChannelQualityReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsChannelQualityReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsChannelQualityReport_template::EgprsChannelQualityReport_template(const EgprsChannelQualityReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsChannelQualityReport_template::~EgprsChannelQualityReport_template()
{
clean_up();
}

EgprsChannelQualityReport_template& EgprsChannelQualityReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsChannelQualityReport_template& EgprsChannelQualityReport_template::operator=(const EgprsChannelQualityReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsChannelQualityReport_template& EgprsChannelQualityReport_template::operator=(const OPTIONAL<EgprsChannelQualityReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsChannelQualityReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
}
return *this;
}

EgprsChannelQualityReport_template& EgprsChannelQualityReport_template::operator=(const EgprsChannelQualityReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsChannelQualityReport_template::match(const EgprsChannelQualityReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.bep__link__qual__meas().is_bound()) return FALSE;
if(!single_value->field_bep__link__qual__meas.match(other_value.bep__link__qual__meas(), legacy))return FALSE;
if(!other_value.c__value().is_bound()) return FALSE;
if(!single_value->field_c__value.match(other_value.c__value(), legacy))return FALSE;
if(!other_value.ts__link__qual__meas().is_bound()) return FALSE;
if(!single_value->field_ts__link__qual__meas.match(other_value.ts__link__qual__meas(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
}
return FALSE;
}

boolean EgprsChannelQualityReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_bep__link__qual__meas.is_bound()
 || single_value->field_c__value.is_bound()
 || single_value->field_ts__link__qual__meas.is_bound();
}

boolean EgprsChannelQualityReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_bep__link__qual__meas.is_value()
 && single_value->field_c__value.is_value()
 && single_value->field_ts__link__qual__meas.is_value();
}

void EgprsChannelQualityReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsChannelQualityReport EgprsChannelQualityReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
EgprsChannelQualityReport ret_val;
if (single_value->field_bep__link__qual__meas.is_bound()) {
ret_val.bep__link__qual__meas() = single_value->field_bep__link__qual__meas.valueof();
}
if (single_value->field_c__value.is_bound()) {
ret_val.c__value() = single_value->field_c__value.valueof();
}
if (single_value->field_ts__link__qual__meas.is_bound()) {
ret_val.ts__link__qual__meas() = single_value->field_ts__link__qual__meas.valueof();
}
return ret_val;
}

void EgprsChannelQualityReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsChannelQualityReport_template[list_length];
}

EgprsChannelQualityReport_template& EgprsChannelQualityReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
return value_list.list_value[list_index];
}

EgprsBEPLinkQualityMeasurements_template& EgprsChannelQualityReport_template::bep__link__qual__meas()
{
set_specific();
return single_value->field_bep__link__qual__meas;
}

const EgprsBEPLinkQualityMeasurements_template& EgprsChannelQualityReport_template::bep__link__qual__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bep_link_qual_meas of a non-specific template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
return single_value->field_bep__link__qual__meas;
}

INTEGER_template& EgprsChannelQualityReport_template::c__value()
{
set_specific();
return single_value->field_c__value;
}

const INTEGER_template& EgprsChannelQualityReport_template::c__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field c_value of a non-specific template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
return single_value->field_c__value;
}

EgprsTimeslotLinkQualityMeasurements_template& EgprsChannelQualityReport_template::ts__link__qual__meas()
{
set_specific();
return single_value->field_ts__link__qual__meas;
}

const EgprsTimeslotLinkQualityMeasurements_template& EgprsChannelQualityReport_template::ts__link__qual__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ts_link_qual_meas of a non-specific template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
return single_value->field_ts__link__qual__meas;
}

int EgprsChannelQualityReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
  }
  return 0;
}

void EgprsChannelQualityReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ bep_link_qual_meas := ");
single_value->field_bep__link__qual__meas.log();
TTCN_Logger::log_event_str(", c_value := ");
single_value->field_c__value.log();
TTCN_Logger::log_event_str(", ts_link_qual_meas := ");
single_value->field_ts__link__qual__meas.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsChannelQualityReport_template::log_match(const EgprsChannelQualityReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_bep__link__qual__meas.match(match_value.bep__link__qual__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".bep_link_qual_meas");
single_value->field_bep__link__qual__meas.log_match(match_value.bep__link__qual__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_c__value.match(match_value.c__value(), legacy)){
TTCN_Logger::log_logmatch_info(".c_value");
single_value->field_c__value.log_match(match_value.c__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ts__link__qual__meas.match(match_value.ts__link__qual__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".ts_link_qual_meas");
single_value->field_ts__link__qual__meas.log_match(match_value.ts__link__qual__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ bep_link_qual_meas := ");
single_value->field_bep__link__qual__meas.log_match(match_value.bep__link__qual__meas(), legacy);
TTCN_Logger::log_event_str(", c_value := ");
single_value->field_c__value.log_match(match_value.c__value(), legacy);
TTCN_Logger::log_event_str(", ts_link_qual_meas := ");
single_value->field_ts__link__qual__meas.log_match(match_value.ts__link__qual__meas(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsChannelQualityReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (bep__link__qual__meas().is_bound()) bep__link__qual__meas().set_implicit_omit();
if (c__value().is_bound()) c__value().set_implicit_omit();
if (ts__link__qual__meas().is_bound()) ts__link__qual__meas().set_implicit_omit();
}

void EgprsChannelQualityReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_bep__link__qual__meas.encode_text(text_buf);
single_value->field_c__value.encode_text(text_buf);
single_value->field_ts__link__qual__meas.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
}
}

void EgprsChannelQualityReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_bep__link__qual__meas.decode_text(text_buf);
single_value->field_c__value.decode_text(text_buf);
single_value->field_ts__link__qual__meas.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsChannelQualityReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport.");
}
}

void EgprsChannelQualityReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsChannelQualityReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsChannelQualityReport has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) bep__link__qual__meas().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) c__value().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ts__link__qual__meas().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bep_link_qual_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bep__link__qual__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "c_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          c__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ts_link_qual_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ts__link__qual__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsChannelQualityReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsChannelQualityReport_template* precondition = new EgprsChannelQualityReport_template;
    precondition->set_param(*param.get_elem(0));
    EgprsChannelQualityReport_template* implied_template = new EgprsChannelQualityReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsChannelQualityReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsChannelQualityReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_bep__link__qual__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
single_value->field_c__value.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
single_value->field_ts__link__qual__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsChannelQualityReport");
}

boolean EgprsChannelQualityReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsChannelQualityReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EgprsAckNackDescription::EgprsAckNackDescription()
{
}

EgprsAckNackDescription::EgprsAckNackDescription(const BITSTRING& par_final__ack,
    const BITSTRING& par_begin__window,
    const BITSTRING& par_end__window,
    const INTEGER& par_starting__seq__nr,
    const BITSTRING& par_compressed,
    const OPTIONAL< BITSTRING >& par_urbb)
  :   field_final__ack(par_final__ack),
  field_begin__window(par_begin__window),
  field_end__window(par_end__window),
  field_starting__seq__nr(par_starting__seq__nr),
  field_compressed(par_compressed),
  field_urbb(par_urbb)
{
}

EgprsAckNackDescription::EgprsAckNackDescription(const EgprsAckNackDescription& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
if (other_value.final__ack().is_bound()) field_final__ack = other_value.final__ack();
else field_final__ack.clean_up();
if (other_value.begin__window().is_bound()) field_begin__window = other_value.begin__window();
else field_begin__window.clean_up();
if (other_value.end__window().is_bound()) field_end__window = other_value.end__window();
else field_end__window.clean_up();
if (other_value.starting__seq__nr().is_bound()) field_starting__seq__nr = other_value.starting__seq__nr();
else field_starting__seq__nr.clean_up();
if (other_value.compressed().is_bound()) field_compressed = other_value.compressed();
else field_compressed.clean_up();
if (other_value.urbb().is_bound()) field_urbb = other_value.urbb();
else field_urbb.clean_up();
}

void EgprsAckNackDescription::clean_up()
{
field_final__ack.clean_up();
field_begin__window.clean_up();
field_end__window.clean_up();
field_starting__seq__nr.clean_up();
field_compressed.clean_up();
field_urbb.clean_up();
}

const TTCN_Typedescriptor_t* EgprsAckNackDescription::get_descriptor() const { return &EgprsAckNackDescription_descr_; }
EgprsAckNackDescription& EgprsAckNackDescription::operator=(const EgprsAckNackDescription& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
  if (other_value.final__ack().is_bound()) field_final__ack = other_value.final__ack();
  else field_final__ack.clean_up();
  if (other_value.begin__window().is_bound()) field_begin__window = other_value.begin__window();
  else field_begin__window.clean_up();
  if (other_value.end__window().is_bound()) field_end__window = other_value.end__window();
  else field_end__window.clean_up();
  if (other_value.starting__seq__nr().is_bound()) field_starting__seq__nr = other_value.starting__seq__nr();
  else field_starting__seq__nr.clean_up();
  if (other_value.compressed().is_bound()) field_compressed = other_value.compressed();
  else field_compressed.clean_up();
  if (other_value.urbb().is_bound()) field_urbb = other_value.urbb();
  else field_urbb.clean_up();
}
return *this;
}

boolean EgprsAckNackDescription::operator==(const EgprsAckNackDescription& other_value) const
{
return field_final__ack==other_value.field_final__ack
  && field_begin__window==other_value.field_begin__window
  && field_end__window==other_value.field_end__window
  && field_starting__seq__nr==other_value.field_starting__seq__nr
  && field_compressed==other_value.field_compressed
  && field_urbb==other_value.field_urbb;
}

boolean EgprsAckNackDescription::is_bound() const
{
return (field_final__ack.is_bound())
  || (field_begin__window.is_bound())
  || (field_end__window.is_bound())
  || (field_starting__seq__nr.is_bound())
  || (field_compressed.is_bound())
  || (OPTIONAL_OMIT == field_urbb.get_selection() || field_urbb.is_bound());
}
boolean EgprsAckNackDescription::is_value() const
{
return field_final__ack.is_value()
  && field_begin__window.is_value()
  && field_end__window.is_value()
  && field_starting__seq__nr.is_value()
  && field_compressed.is_value()
  && (OPTIONAL_OMIT == field_urbb.get_selection() || field_urbb.is_value());
}
int EgprsAckNackDescription::size_of() const
{
  int ret_val = 5;
  if (field_urbb.ispresent()) ret_val++;
  return ret_val;
}

void EgprsAckNackDescription::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ final_ack := ");
field_final__ack.log();
TTCN_Logger::log_event_str(", begin_window := ");
field_begin__window.log();
TTCN_Logger::log_event_str(", end_window := ");
field_end__window.log();
TTCN_Logger::log_event_str(", starting_seq_nr := ");
field_starting__seq__nr.log();
TTCN_Logger::log_event_str(", compressed := ");
field_compressed.log();
TTCN_Logger::log_event_str(", urbb := ");
field_urbb.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsAckNackDescription::set_implicit_omit()
{
if (final__ack().is_bound()) final__ack().set_implicit_omit();
if (begin__window().is_bound()) begin__window().set_implicit_omit();
if (end__window().is_bound()) end__window().set_implicit_omit();
if (starting__seq__nr().is_bound()) starting__seq__nr().set_implicit_omit();
if (compressed().is_bound()) compressed().set_implicit_omit();
if (!urbb().is_bound()) urbb() = OMIT_VALUE;
else urbb().set_implicit_omit();
}

void EgprsAckNackDescription::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsAckNackDescription has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) final__ack().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) begin__window().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) end__window().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) starting__seq__nr().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) compressed().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) urbb().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "final_ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          final__ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "begin_window")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          begin__window().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "end_window")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          end__window().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "starting_seq_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          starting__seq__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "compressed")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          compressed().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "urbb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          urbb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsAckNackDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
  }
}

void EgprsAckNackDescription::encode_text(Text_Buf& text_buf) const
{
field_final__ack.encode_text(text_buf);
field_begin__window.encode_text(text_buf);
field_end__window.encode_text(text_buf);
field_starting__seq__nr.encode_text(text_buf);
field_compressed.encode_text(text_buf);
field_urbb.encode_text(text_buf);
}

void EgprsAckNackDescription::decode_text(Text_Buf& text_buf)
{
field_final__ack.decode_text(text_buf);
field_begin__window.decode_text(text_buf);
field_end__window.decode_text(text_buf);
field_starting__seq__nr.decode_text(text_buf);
field_compressed.decode_text(text_buf);
field_urbb.decode_text(text_buf);
}

void EgprsAckNackDescription::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsAckNackDescription::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsAckNackDescription::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsAckNackDescription_final__ack_descr_.raw->forceomit);
  decoded_field_length = field_final__ack.RAW_decode(EgprsAckNackDescription_final__ack_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsAckNackDescription_begin__window_descr_.raw->forceomit);
  decoded_field_length = field_begin__window.RAW_decode(EgprsAckNackDescription_begin__window_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsAckNackDescription_end__window_descr_.raw->forceomit);
  decoded_field_length = field_end__window.RAW_decode(EgprsAckNackDescription_end__window_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, EgprsAckNackDescription_starting__seq__nr_descr_.raw->forceomit);
  decoded_field_length = field_starting__seq__nr.RAW_decode(EgprsAckNackDescription_starting__seq__nr_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, EgprsAckNackDescription_compressed_descr_.raw->forceomit);
  decoded_field_length = field_compressed.RAW_decode(EgprsAckNackDescription_compressed_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_compressed ==  bs_1){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_urbb = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, EgprsAckNackDescription_urbb_descr_.raw->forceomit);
  decoded_field_length = field_urbb().RAW_decode(EgprsAckNackDescription_urbb_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_urbb = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_urbb=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsAckNackDescription::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsAckNackDescription_final__ack_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsAckNackDescription_begin__window_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsAckNackDescription_end__window_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EgprsAckNackDescription_starting__seq__nr_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, EgprsAckNackDescription_compressed_descr_.raw);
  if (field_urbb.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, EgprsAckNackDescription_urbb_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_final__ack.RAW_encode(EgprsAckNackDescription_final__ack_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_begin__window.RAW_encode(EgprsAckNackDescription_begin__window_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_end__window.RAW_encode(EgprsAckNackDescription_end__window_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_starting__seq__nr.RAW_encode(EgprsAckNackDescription_starting__seq__nr_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_compressed.RAW_encode(EgprsAckNackDescription_compressed_descr_, *myleaf.body.node.nodes[4]);
  if (field_urbb.ispresent()) {
  encoded_length += field_urbb().RAW_encode(EgprsAckNackDescription_urbb_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_urbb.ispresent() && (field_compressed !=  bs_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={4};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(EgprsAckNackDescription_compressed_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EgprsAckNackDescription_template::single_value_struct {
BITSTRING_template field_final__ack;
BITSTRING_template field_begin__window;
BITSTRING_template field_end__window;
INTEGER_template field_starting__seq__nr;
BITSTRING_template field_compressed;
BITSTRING_template field_urbb;
};

void EgprsAckNackDescription_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_final__ack = ANY_VALUE;
single_value->field_begin__window = ANY_VALUE;
single_value->field_end__window = ANY_VALUE;
single_value->field_starting__seq__nr = ANY_VALUE;
single_value->field_compressed = ANY_VALUE;
single_value->field_urbb = ANY_OR_OMIT;
}
}
}

void EgprsAckNackDescription_template::copy_value(const EgprsAckNackDescription& other_value)
{
single_value = new single_value_struct;
if (other_value.final__ack().is_bound()) {
  single_value->field_final__ack = other_value.final__ack();
} else {
  single_value->field_final__ack.clean_up();
}
if (other_value.begin__window().is_bound()) {
  single_value->field_begin__window = other_value.begin__window();
} else {
  single_value->field_begin__window.clean_up();
}
if (other_value.end__window().is_bound()) {
  single_value->field_end__window = other_value.end__window();
} else {
  single_value->field_end__window.clean_up();
}
if (other_value.starting__seq__nr().is_bound()) {
  single_value->field_starting__seq__nr = other_value.starting__seq__nr();
} else {
  single_value->field_starting__seq__nr.clean_up();
}
if (other_value.compressed().is_bound()) {
  single_value->field_compressed = other_value.compressed();
} else {
  single_value->field_compressed.clean_up();
}
if (other_value.urbb().is_bound()) {
  if (other_value.urbb().ispresent()) single_value->field_urbb = other_value.urbb()();
  else single_value->field_urbb = OMIT_VALUE;
} else {
  single_value->field_urbb.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsAckNackDescription_template::copy_template(const EgprsAckNackDescription_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.final__ack().get_selection()) {
single_value->field_final__ack = other_value.final__ack();
} else {
single_value->field_final__ack.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.begin__window().get_selection()) {
single_value->field_begin__window = other_value.begin__window();
} else {
single_value->field_begin__window.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.end__window().get_selection()) {
single_value->field_end__window = other_value.end__window();
} else {
single_value->field_end__window.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.starting__seq__nr().get_selection()) {
single_value->field_starting__seq__nr = other_value.starting__seq__nr();
} else {
single_value->field_starting__seq__nr.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.compressed().get_selection()) {
single_value->field_compressed = other_value.compressed();
} else {
single_value->field_compressed.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.urbb().get_selection()) {
single_value->field_urbb = other_value.urbb();
} else {
single_value->field_urbb.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsAckNackDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsAckNackDescription_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsAckNackDescription_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
break;
}
set_selection(other_value);
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template()
{
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(const EgprsAckNackDescription& other_value)
{
copy_value(other_value);
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(const OPTIONAL<EgprsAckNackDescription>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsAckNackDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription from an unbound optional field.");
}
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(EgprsAckNackDescription_template* p_precondition, EgprsAckNackDescription_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(Dynamic_Match_Interface<EgprsAckNackDescription>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsAckNackDescription>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsAckNackDescription_template::EgprsAckNackDescription_template(const EgprsAckNackDescription_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsAckNackDescription_template::~EgprsAckNackDescription_template()
{
clean_up();
}

EgprsAckNackDescription_template& EgprsAckNackDescription_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsAckNackDescription_template& EgprsAckNackDescription_template::operator=(const EgprsAckNackDescription& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsAckNackDescription_template& EgprsAckNackDescription_template::operator=(const OPTIONAL<EgprsAckNackDescription>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsAckNackDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
}
return *this;
}

EgprsAckNackDescription_template& EgprsAckNackDescription_template::operator=(const EgprsAckNackDescription_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsAckNackDescription_template::match(const EgprsAckNackDescription& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.final__ack().is_bound()) return FALSE;
if(!single_value->field_final__ack.match(other_value.final__ack(), legacy))return FALSE;
if(!other_value.begin__window().is_bound()) return FALSE;
if(!single_value->field_begin__window.match(other_value.begin__window(), legacy))return FALSE;
if(!other_value.end__window().is_bound()) return FALSE;
if(!single_value->field_end__window.match(other_value.end__window(), legacy))return FALSE;
if(!other_value.starting__seq__nr().is_bound()) return FALSE;
if(!single_value->field_starting__seq__nr.match(other_value.starting__seq__nr(), legacy))return FALSE;
if(!other_value.compressed().is_bound()) return FALSE;
if(!single_value->field_compressed.match(other_value.compressed(), legacy))return FALSE;
if(!other_value.urbb().is_bound()) return FALSE;
if((other_value.urbb().ispresent() ? !single_value->field_urbb.match((const BITSTRING&)other_value.urbb(), legacy) : !single_value->field_urbb.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
}
return FALSE;
}

boolean EgprsAckNackDescription_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_final__ack.is_bound()
 || single_value->field_begin__window.is_bound()
 || single_value->field_end__window.is_bound()
 || single_value->field_starting__seq__nr.is_bound()
 || single_value->field_compressed.is_bound()
 || (single_value->field_urbb.is_omit() || single_value->field_urbb.is_bound());
}

boolean EgprsAckNackDescription_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_final__ack.is_value()
 && single_value->field_begin__window.is_value()
 && single_value->field_end__window.is_value()
 && single_value->field_starting__seq__nr.is_value()
 && single_value->field_compressed.is_value()
 && (single_value->field_urbb.is_omit() || single_value->field_urbb.is_value());
}

void EgprsAckNackDescription_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsAckNackDescription EgprsAckNackDescription_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
EgprsAckNackDescription ret_val;
if (single_value->field_final__ack.is_bound()) {
ret_val.final__ack() = single_value->field_final__ack.valueof();
}
if (single_value->field_begin__window.is_bound()) {
ret_val.begin__window() = single_value->field_begin__window.valueof();
}
if (single_value->field_end__window.is_bound()) {
ret_val.end__window() = single_value->field_end__window.valueof();
}
if (single_value->field_starting__seq__nr.is_bound()) {
ret_val.starting__seq__nr() = single_value->field_starting__seq__nr.valueof();
}
if (single_value->field_compressed.is_bound()) {
ret_val.compressed() = single_value->field_compressed.valueof();
}
if (single_value->field_urbb.is_omit()) ret_val.urbb() = OMIT_VALUE;
else if (single_value->field_urbb.is_bound()) {
ret_val.urbb() = single_value->field_urbb.valueof();
}
return ret_val;
}

void EgprsAckNackDescription_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsAckNackDescription_template[list_length];
}

EgprsAckNackDescription_template& EgprsAckNackDescription_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return value_list.list_value[list_index];
}

BITSTRING_template& EgprsAckNackDescription_template::final__ack()
{
set_specific();
return single_value->field_final__ack;
}

const BITSTRING_template& EgprsAckNackDescription_template::final__ack() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field final_ack of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_final__ack;
}

BITSTRING_template& EgprsAckNackDescription_template::begin__window()
{
set_specific();
return single_value->field_begin__window;
}

const BITSTRING_template& EgprsAckNackDescription_template::begin__window() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field begin_window of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_begin__window;
}

BITSTRING_template& EgprsAckNackDescription_template::end__window()
{
set_specific();
return single_value->field_end__window;
}

const BITSTRING_template& EgprsAckNackDescription_template::end__window() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field end_window of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_end__window;
}

INTEGER_template& EgprsAckNackDescription_template::starting__seq__nr()
{
set_specific();
return single_value->field_starting__seq__nr;
}

const INTEGER_template& EgprsAckNackDescription_template::starting__seq__nr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field starting_seq_nr of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_starting__seq__nr;
}

BITSTRING_template& EgprsAckNackDescription_template::compressed()
{
set_specific();
return single_value->field_compressed;
}

const BITSTRING_template& EgprsAckNackDescription_template::compressed() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field compressed of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_compressed;
}

BITSTRING_template& EgprsAckNackDescription_template::urbb()
{
set_specific();
return single_value->field_urbb;
}

const BITSTRING_template& EgprsAckNackDescription_template::urbb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field urbb of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
return single_value->field_urbb;
}

int EgprsAckNackDescription_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_urbb.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
  }
  return 0;
}

void EgprsAckNackDescription_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ final_ack := ");
single_value->field_final__ack.log();
TTCN_Logger::log_event_str(", begin_window := ");
single_value->field_begin__window.log();
TTCN_Logger::log_event_str(", end_window := ");
single_value->field_end__window.log();
TTCN_Logger::log_event_str(", starting_seq_nr := ");
single_value->field_starting__seq__nr.log();
TTCN_Logger::log_event_str(", compressed := ");
single_value->field_compressed.log();
TTCN_Logger::log_event_str(", urbb := ");
single_value->field_urbb.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsAckNackDescription_template::log_match(const EgprsAckNackDescription& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_final__ack.match(match_value.final__ack(), legacy)){
TTCN_Logger::log_logmatch_info(".final_ack");
single_value->field_final__ack.log_match(match_value.final__ack(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_begin__window.match(match_value.begin__window(), legacy)){
TTCN_Logger::log_logmatch_info(".begin_window");
single_value->field_begin__window.log_match(match_value.begin__window(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_end__window.match(match_value.end__window(), legacy)){
TTCN_Logger::log_logmatch_info(".end_window");
single_value->field_end__window.log_match(match_value.end__window(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_starting__seq__nr.match(match_value.starting__seq__nr(), legacy)){
TTCN_Logger::log_logmatch_info(".starting_seq_nr");
single_value->field_starting__seq__nr.log_match(match_value.starting__seq__nr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_compressed.match(match_value.compressed(), legacy)){
TTCN_Logger::log_logmatch_info(".compressed");
single_value->field_compressed.log_match(match_value.compressed(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.urbb().ispresent()){
if(!single_value->field_urbb.match(match_value.urbb(), legacy)){
TTCN_Logger::log_logmatch_info(".urbb");
single_value->field_urbb.log_match(match_value.urbb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_urbb.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".urbb := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_urbb.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ final_ack := ");
single_value->field_final__ack.log_match(match_value.final__ack(), legacy);
TTCN_Logger::log_event_str(", begin_window := ");
single_value->field_begin__window.log_match(match_value.begin__window(), legacy);
TTCN_Logger::log_event_str(", end_window := ");
single_value->field_end__window.log_match(match_value.end__window(), legacy);
TTCN_Logger::log_event_str(", starting_seq_nr := ");
single_value->field_starting__seq__nr.log_match(match_value.starting__seq__nr(), legacy);
TTCN_Logger::log_event_str(", compressed := ");
single_value->field_compressed.log_match(match_value.compressed(), legacy);
TTCN_Logger::log_event_str(", urbb := ");
if (match_value.urbb().ispresent()) {
single_value->field_urbb.log_match(match_value.urbb(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_urbb.log();
if (single_value->field_urbb.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsAckNackDescription_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (final__ack().is_bound()) final__ack().set_implicit_omit();
if (begin__window().is_bound()) begin__window().set_implicit_omit();
if (end__window().is_bound()) end__window().set_implicit_omit();
if (starting__seq__nr().is_bound()) starting__seq__nr().set_implicit_omit();
if (compressed().is_bound()) compressed().set_implicit_omit();
if (!urbb().is_bound()) urbb() = OMIT_VALUE;
else urbb().set_implicit_omit();
}

void EgprsAckNackDescription_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_final__ack.encode_text(text_buf);
single_value->field_begin__window.encode_text(text_buf);
single_value->field_end__window.encode_text(text_buf);
single_value->field_starting__seq__nr.encode_text(text_buf);
single_value->field_compressed.encode_text(text_buf);
single_value->field_urbb.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
}
}

void EgprsAckNackDescription_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_final__ack.decode_text(text_buf);
single_value->field_begin__window.decode_text(text_buf);
single_value->field_end__window.decode_text(text_buf);
single_value->field_starting__seq__nr.decode_text(text_buf);
single_value->field_compressed.decode_text(text_buf);
single_value->field_urbb.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsAckNackDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription.");
}
}

void EgprsAckNackDescription_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsAckNackDescription_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsAckNackDescription has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) final__ack().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) begin__window().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) end__window().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) starting__seq__nr().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) compressed().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) urbb().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "final_ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          final__ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "begin_window")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          begin__window().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "end_window")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          end__window().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "starting_seq_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          starting__seq__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "compressed")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          compressed().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "urbb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          urbb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsAckNackDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsAckNackDescription_template* precondition = new EgprsAckNackDescription_template;
    precondition->set_param(*param.get_elem(0));
    EgprsAckNackDescription_template* implied_template = new EgprsAckNackDescription_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsAckNackDescription_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsAckNackDescription_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_final__ack.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
single_value->field_begin__window.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
single_value->field_end__window.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
single_value->field_starting__seq__nr.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
single_value->field_compressed.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
single_value->field_urbb.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescription");
}

boolean EgprsAckNackDescription_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsAckNackDescription_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EgprsAckNackDescriptionIE::EgprsAckNackDescriptionIE()
{
}

EgprsAckNackDescriptionIE::EgprsAckNackDescriptionIE(const BITSTRING& par_len__present,
    const OPTIONAL< INTEGER >& par_len,
    const EgprsAckNackDescription& par_acknack__desc)
  :   field_len__present(par_len__present),
  field_len(par_len),
  field_acknack__desc(par_acknack__desc)
{
}

EgprsAckNackDescriptionIE::EgprsAckNackDescriptionIE(const EgprsAckNackDescriptionIE& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
if (other_value.len__present().is_bound()) field_len__present = other_value.len__present();
else field_len__present.clean_up();
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.acknack__desc().is_bound()) field_acknack__desc = other_value.acknack__desc();
else field_acknack__desc.clean_up();
}

void EgprsAckNackDescriptionIE::clean_up()
{
field_len__present.clean_up();
field_len.clean_up();
field_acknack__desc.clean_up();
}

const TTCN_Typedescriptor_t* EgprsAckNackDescriptionIE::get_descriptor() const { return &EgprsAckNackDescriptionIE_descr_; }
EgprsAckNackDescriptionIE& EgprsAckNackDescriptionIE::operator=(const EgprsAckNackDescriptionIE& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
  if (other_value.len__present().is_bound()) field_len__present = other_value.len__present();
  else field_len__present.clean_up();
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.acknack__desc().is_bound()) field_acknack__desc = other_value.acknack__desc();
  else field_acknack__desc.clean_up();
}
return *this;
}

boolean EgprsAckNackDescriptionIE::operator==(const EgprsAckNackDescriptionIE& other_value) const
{
return field_len__present==other_value.field_len__present
  && field_len==other_value.field_len
  && field_acknack__desc==other_value.field_acknack__desc;
}

boolean EgprsAckNackDescriptionIE::is_bound() const
{
return (field_len__present.is_bound())
  || (OPTIONAL_OMIT == field_len.get_selection() || field_len.is_bound())
  || (field_acknack__desc.is_bound());
}
boolean EgprsAckNackDescriptionIE::is_value() const
{
return field_len__present.is_value()
  && (OPTIONAL_OMIT == field_len.get_selection() || field_len.is_value())
  && field_acknack__desc.is_value();
}
int EgprsAckNackDescriptionIE::size_of() const
{
  int ret_val = 2;
  if (field_len.ispresent()) ret_val++;
  return ret_val;
}

void EgprsAckNackDescriptionIE::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len_present := ");
field_len__present.log();
TTCN_Logger::log_event_str(", len := ");
field_len.log();
TTCN_Logger::log_event_str(", acknack_desc := ");
field_acknack__desc.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsAckNackDescriptionIE::set_implicit_omit()
{
if (len__present().is_bound()) len__present().set_implicit_omit();
if (!len().is_bound()) len() = OMIT_VALUE;
else len().set_implicit_omit();
if (acknack__desc().is_bound()) acknack__desc().set_implicit_omit();
}

void EgprsAckNackDescriptionIE::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len__present().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) acknack__desc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len_present")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len__present().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acknack_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acknack__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
  }
}

void EgprsAckNackDescriptionIE::encode_text(Text_Buf& text_buf) const
{
field_len__present.encode_text(text_buf);
field_len.encode_text(text_buf);
field_acknack__desc.encode_text(text_buf);
}

void EgprsAckNackDescriptionIE::decode_text(Text_Buf& text_buf)
{
field_len__present.decode_text(text_buf);
field_len.decode_text(text_buf);
field_acknack__desc.decode_text(text_buf);
}

void EgprsAckNackDescriptionIE::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsAckNackDescriptionIE::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsAckNackDescriptionIE::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsAckNackDescriptionIE_len__present_descr_.raw->forceomit);
  decoded_field_length = field_len__present.RAW_decode(EgprsAckNackDescriptionIE_len__present_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_len__present ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_len = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsAckNackDescriptionIE_len_descr_.raw->forceomit);
  decoded_field_length = field_len().RAW_decode(EgprsAckNackDescriptionIE_len_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_len = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_len().convert_to_Integer(EgprsAckNackDescriptionIE_len_descr_);
  field_len() = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 1;
  }
  }
  }
  else field_len=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsAckNackDescriptionIE_acknack__desc_descr_.raw->forceomit);
  decoded_field_length = field_acknack__desc.RAW_decode(EgprsAckNackDescriptionIE_acknack__desc_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsAckNackDescriptionIE::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsAckNackDescriptionIE_len__present_descr_.raw);
  if (field_len.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsAckNackDescriptionIE_len_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsAckNackDescriptionIE_acknack__desc_descr_.raw);
  encoded_length += field_len__present.RAW_encode(EgprsAckNackDescriptionIE_len__present_descr_, *myleaf.body.node.nodes[0]);
  if (field_len.ispresent()) {
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &EgprsAckNackDescriptionIE_len_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  }
  encoded_length += field_acknack__desc.RAW_encode(EgprsAckNackDescriptionIE_acknack__desc_descr_, *myleaf.body.node.nodes[2]);
  if (field_len.ispresent() && (field_len__present !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsAckNackDescriptionIE_len__present_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EgprsAckNackDescriptionIE_template::single_value_struct {
BITSTRING_template field_len__present;
INTEGER_template field_len;
EgprsAckNackDescription_template field_acknack__desc;
};

void EgprsAckNackDescriptionIE_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len__present = ANY_VALUE;
single_value->field_len = ANY_OR_OMIT;
single_value->field_acknack__desc = ANY_VALUE;
}
}
}

void EgprsAckNackDescriptionIE_template::copy_value(const EgprsAckNackDescriptionIE& other_value)
{
single_value = new single_value_struct;
if (other_value.len__present().is_bound()) {
  single_value->field_len__present = other_value.len__present();
} else {
  single_value->field_len__present.clean_up();
}
if (other_value.len().is_bound()) {
  if (other_value.len().ispresent()) single_value->field_len = other_value.len()();
  else single_value->field_len = OMIT_VALUE;
} else {
  single_value->field_len.clean_up();
}
if (other_value.acknack__desc().is_bound()) {
  single_value->field_acknack__desc = other_value.acknack__desc();
} else {
  single_value->field_acknack__desc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsAckNackDescriptionIE_template::copy_template(const EgprsAckNackDescriptionIE_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len__present().get_selection()) {
single_value->field_len__present = other_value.len__present();
} else {
single_value->field_len__present.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.acknack__desc().get_selection()) {
single_value->field_acknack__desc = other_value.acknack__desc();
} else {
single_value->field_acknack__desc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsAckNackDescriptionIE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsAckNackDescriptionIE_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsAckNackDescriptionIE_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
break;
}
set_selection(other_value);
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template()
{
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(const EgprsAckNackDescriptionIE& other_value)
{
copy_value(other_value);
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(const OPTIONAL<EgprsAckNackDescriptionIE>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsAckNackDescriptionIE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE from an unbound optional field.");
}
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(EgprsAckNackDescriptionIE_template* p_precondition, EgprsAckNackDescriptionIE_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(Dynamic_Match_Interface<EgprsAckNackDescriptionIE>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsAckNackDescriptionIE>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsAckNackDescriptionIE_template::EgprsAckNackDescriptionIE_template(const EgprsAckNackDescriptionIE_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsAckNackDescriptionIE_template::~EgprsAckNackDescriptionIE_template()
{
clean_up();
}

EgprsAckNackDescriptionIE_template& EgprsAckNackDescriptionIE_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsAckNackDescriptionIE_template& EgprsAckNackDescriptionIE_template::operator=(const EgprsAckNackDescriptionIE& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsAckNackDescriptionIE_template& EgprsAckNackDescriptionIE_template::operator=(const OPTIONAL<EgprsAckNackDescriptionIE>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsAckNackDescriptionIE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
}
return *this;
}

EgprsAckNackDescriptionIE_template& EgprsAckNackDescriptionIE_template::operator=(const EgprsAckNackDescriptionIE_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsAckNackDescriptionIE_template::match(const EgprsAckNackDescriptionIE& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len__present().is_bound()) return FALSE;
if(!single_value->field_len__present.match(other_value.len__present(), legacy))return FALSE;
if(!other_value.len().is_bound()) return FALSE;
if((other_value.len().ispresent() ? !single_value->field_len.match((const INTEGER&)other_value.len(), legacy) : !single_value->field_len.match_omit(legacy)))return FALSE;
if(!other_value.acknack__desc().is_bound()) return FALSE;
if(!single_value->field_acknack__desc.match(other_value.acknack__desc(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
}
return FALSE;
}

boolean EgprsAckNackDescriptionIE_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len__present.is_bound()
 || (single_value->field_len.is_omit() || single_value->field_len.is_bound())
 || single_value->field_acknack__desc.is_bound();
}

boolean EgprsAckNackDescriptionIE_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len__present.is_value()
 && (single_value->field_len.is_omit() || single_value->field_len.is_value())
 && single_value->field_acknack__desc.is_value();
}

void EgprsAckNackDescriptionIE_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsAckNackDescriptionIE EgprsAckNackDescriptionIE_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
EgprsAckNackDescriptionIE ret_val;
if (single_value->field_len__present.is_bound()) {
ret_val.len__present() = single_value->field_len__present.valueof();
}
if (single_value->field_len.is_omit()) ret_val.len() = OMIT_VALUE;
else if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_acknack__desc.is_bound()) {
ret_val.acknack__desc() = single_value->field_acknack__desc.valueof();
}
return ret_val;
}

void EgprsAckNackDescriptionIE_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsAckNackDescriptionIE_template[list_length];
}

EgprsAckNackDescriptionIE_template& EgprsAckNackDescriptionIE_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
return value_list.list_value[list_index];
}

BITSTRING_template& EgprsAckNackDescriptionIE_template::len__present()
{
set_specific();
return single_value->field_len__present;
}

const BITSTRING_template& EgprsAckNackDescriptionIE_template::len__present() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len_present of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
return single_value->field_len__present;
}

INTEGER_template& EgprsAckNackDescriptionIE_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& EgprsAckNackDescriptionIE_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
return single_value->field_len;
}

EgprsAckNackDescription_template& EgprsAckNackDescriptionIE_template::acknack__desc()
{
set_specific();
return single_value->field_acknack__desc;
}

const EgprsAckNackDescription_template& EgprsAckNackDescriptionIE_template::acknack__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field acknack_desc of a non-specific template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
return single_value->field_acknack__desc;
}

int EgprsAckNackDescriptionIE_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_len.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
  }
  return 0;
}

void EgprsAckNackDescriptionIE_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len_present := ");
single_value->field_len__present.log();
TTCN_Logger::log_event_str(", len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", acknack_desc := ");
single_value->field_acknack__desc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsAckNackDescriptionIE_template::log_match(const EgprsAckNackDescriptionIE& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len__present.match(match_value.len__present(), legacy)){
TTCN_Logger::log_logmatch_info(".len_present");
single_value->field_len__present.log_match(match_value.len__present(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.len().ispresent()){
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_len.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".len := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_len.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_acknack__desc.match(match_value.acknack__desc(), legacy)){
TTCN_Logger::log_logmatch_info(".acknack_desc");
single_value->field_acknack__desc.log_match(match_value.acknack__desc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len_present := ");
single_value->field_len__present.log_match(match_value.len__present(), legacy);
TTCN_Logger::log_event_str(", len := ");
if (match_value.len().ispresent()) {
single_value->field_len.log_match(match_value.len(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_len.log();
if (single_value->field_len.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", acknack_desc := ");
single_value->field_acknack__desc.log_match(match_value.acknack__desc(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsAckNackDescriptionIE_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len__present().is_bound()) len__present().set_implicit_omit();
if (!len().is_bound()) len() = OMIT_VALUE;
else len().set_implicit_omit();
if (acknack__desc().is_bound()) acknack__desc().set_implicit_omit();
}

void EgprsAckNackDescriptionIE_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len__present.encode_text(text_buf);
single_value->field_len.encode_text(text_buf);
single_value->field_acknack__desc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
}
}

void EgprsAckNackDescriptionIE_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len__present.decode_text(text_buf);
single_value->field_len.decode_text(text_buf);
single_value->field_acknack__desc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsAckNackDescriptionIE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE.");
}
}

void EgprsAckNackDescriptionIE_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsAckNackDescriptionIE_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len__present().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) acknack__desc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len_present")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len__present().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acknack_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acknack__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsAckNackDescriptionIE_template* precondition = new EgprsAckNackDescriptionIE_template;
    precondition->set_param(*param.get_elem(0));
    EgprsAckNackDescriptionIE_template* implied_template = new EgprsAckNackDescriptionIE_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsAckNackDescriptionIE_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsAckNackDescriptionIE_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len__present.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
single_value->field_acknack__desc.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsAckNackDescriptionIE");
}

boolean EgprsAckNackDescriptionIE_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsAckNackDescriptionIE_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EgprsPacketDlAckNack::EgprsPacketDlAckNack()
{
}

EgprsPacketDlAckNack::EgprsPacketDlAckNack(const INTEGER& par_dl__tfi,
    const BITSTRING& par_ms__oom,
    const BITSTRING& par_egprs__ch__qual__rep__presence,
    const OPTIONAL< EgprsChannelQualityReport >& par_egprs__ch__qual__rep,
    const BITSTRING& par_chreq__desc__presence,
    const OPTIONAL< ChannelReqDescription >& par_chreq__desc,
    const BITSTRING& par_pfi__presence,
    const OPTIONAL< BITSTRING >& par_pfi,
    const BITSTRING& par_epdan__presence,
    const EgprsAckNackDescriptionIE& par_ack__nack__desc__ie)
  :   field_dl__tfi(par_dl__tfi),
  field_ms__oom(par_ms__oom),
  field_egprs__ch__qual__rep__presence(par_egprs__ch__qual__rep__presence),
  field_egprs__ch__qual__rep(par_egprs__ch__qual__rep),
  field_chreq__desc__presence(par_chreq__desc__presence),
  field_chreq__desc(par_chreq__desc),
  field_pfi__presence(par_pfi__presence),
  field_pfi(par_pfi),
  field_epdan__presence(par_epdan__presence),
  field_ack__nack__desc__ie(par_ack__nack__desc__ie)
{
}

EgprsPacketDlAckNack::EgprsPacketDlAckNack(const EgprsPacketDlAckNack& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
if (other_value.dl__tfi().is_bound()) field_dl__tfi = other_value.dl__tfi();
else field_dl__tfi.clean_up();
if (other_value.ms__oom().is_bound()) field_ms__oom = other_value.ms__oom();
else field_ms__oom.clean_up();
if (other_value.egprs__ch__qual__rep__presence().is_bound()) field_egprs__ch__qual__rep__presence = other_value.egprs__ch__qual__rep__presence();
else field_egprs__ch__qual__rep__presence.clean_up();
if (other_value.egprs__ch__qual__rep().is_bound()) field_egprs__ch__qual__rep = other_value.egprs__ch__qual__rep();
else field_egprs__ch__qual__rep.clean_up();
if (other_value.chreq__desc__presence().is_bound()) field_chreq__desc__presence = other_value.chreq__desc__presence();
else field_chreq__desc__presence.clean_up();
if (other_value.chreq__desc().is_bound()) field_chreq__desc = other_value.chreq__desc();
else field_chreq__desc.clean_up();
if (other_value.pfi__presence().is_bound()) field_pfi__presence = other_value.pfi__presence();
else field_pfi__presence.clean_up();
if (other_value.pfi().is_bound()) field_pfi = other_value.pfi();
else field_pfi.clean_up();
if (other_value.epdan__presence().is_bound()) field_epdan__presence = other_value.epdan__presence();
else field_epdan__presence.clean_up();
if (other_value.ack__nack__desc__ie().is_bound()) field_ack__nack__desc__ie = other_value.ack__nack__desc__ie();
else field_ack__nack__desc__ie.clean_up();
}

void EgprsPacketDlAckNack::clean_up()
{
field_dl__tfi.clean_up();
field_ms__oom.clean_up();
field_egprs__ch__qual__rep__presence.clean_up();
field_egprs__ch__qual__rep.clean_up();
field_chreq__desc__presence.clean_up();
field_chreq__desc.clean_up();
field_pfi__presence.clean_up();
field_pfi.clean_up();
field_epdan__presence.clean_up();
field_ack__nack__desc__ie.clean_up();
}

const TTCN_Typedescriptor_t* EgprsPacketDlAckNack::get_descriptor() const { return &EgprsPacketDlAckNack_descr_; }
EgprsPacketDlAckNack& EgprsPacketDlAckNack::operator=(const EgprsPacketDlAckNack& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
  if (other_value.dl__tfi().is_bound()) field_dl__tfi = other_value.dl__tfi();
  else field_dl__tfi.clean_up();
  if (other_value.ms__oom().is_bound()) field_ms__oom = other_value.ms__oom();
  else field_ms__oom.clean_up();
  if (other_value.egprs__ch__qual__rep__presence().is_bound()) field_egprs__ch__qual__rep__presence = other_value.egprs__ch__qual__rep__presence();
  else field_egprs__ch__qual__rep__presence.clean_up();
  if (other_value.egprs__ch__qual__rep().is_bound()) field_egprs__ch__qual__rep = other_value.egprs__ch__qual__rep();
  else field_egprs__ch__qual__rep.clean_up();
  if (other_value.chreq__desc__presence().is_bound()) field_chreq__desc__presence = other_value.chreq__desc__presence();
  else field_chreq__desc__presence.clean_up();
  if (other_value.chreq__desc().is_bound()) field_chreq__desc = other_value.chreq__desc();
  else field_chreq__desc.clean_up();
  if (other_value.pfi__presence().is_bound()) field_pfi__presence = other_value.pfi__presence();
  else field_pfi__presence.clean_up();
  if (other_value.pfi().is_bound()) field_pfi = other_value.pfi();
  else field_pfi.clean_up();
  if (other_value.epdan__presence().is_bound()) field_epdan__presence = other_value.epdan__presence();
  else field_epdan__presence.clean_up();
  if (other_value.ack__nack__desc__ie().is_bound()) field_ack__nack__desc__ie = other_value.ack__nack__desc__ie();
  else field_ack__nack__desc__ie.clean_up();
}
return *this;
}

boolean EgprsPacketDlAckNack::operator==(const EgprsPacketDlAckNack& other_value) const
{
return field_dl__tfi==other_value.field_dl__tfi
  && field_ms__oom==other_value.field_ms__oom
  && field_egprs__ch__qual__rep__presence==other_value.field_egprs__ch__qual__rep__presence
  && field_egprs__ch__qual__rep==other_value.field_egprs__ch__qual__rep
  && field_chreq__desc__presence==other_value.field_chreq__desc__presence
  && field_chreq__desc==other_value.field_chreq__desc
  && field_pfi__presence==other_value.field_pfi__presence
  && field_pfi==other_value.field_pfi
  && field_epdan__presence==other_value.field_epdan__presence
  && field_ack__nack__desc__ie==other_value.field_ack__nack__desc__ie;
}

boolean EgprsPacketDlAckNack::is_bound() const
{
return (field_dl__tfi.is_bound())
  || (field_ms__oom.is_bound())
  || (field_egprs__ch__qual__rep__presence.is_bound())
  || (OPTIONAL_OMIT == field_egprs__ch__qual__rep.get_selection() || field_egprs__ch__qual__rep.is_bound())
  || (field_chreq__desc__presence.is_bound())
  || (OPTIONAL_OMIT == field_chreq__desc.get_selection() || field_chreq__desc.is_bound())
  || (field_pfi__presence.is_bound())
  || (OPTIONAL_OMIT == field_pfi.get_selection() || field_pfi.is_bound())
  || (field_epdan__presence.is_bound())
  || (field_ack__nack__desc__ie.is_bound());
}
boolean EgprsPacketDlAckNack::is_value() const
{
return field_dl__tfi.is_value()
  && field_ms__oom.is_value()
  && field_egprs__ch__qual__rep__presence.is_value()
  && (OPTIONAL_OMIT == field_egprs__ch__qual__rep.get_selection() || field_egprs__ch__qual__rep.is_value())
  && field_chreq__desc__presence.is_value()
  && (OPTIONAL_OMIT == field_chreq__desc.get_selection() || field_chreq__desc.is_value())
  && field_pfi__presence.is_value()
  && (OPTIONAL_OMIT == field_pfi.get_selection() || field_pfi.is_value())
  && field_epdan__presence.is_value()
  && field_ack__nack__desc__ie.is_value();
}
int EgprsPacketDlAckNack::size_of() const
{
  int ret_val = 7;
  if (field_egprs__ch__qual__rep.ispresent()) ret_val++;
  if (field_chreq__desc.ispresent()) ret_val++;
  if (field_pfi.ispresent()) ret_val++;
  return ret_val;
}

void EgprsPacketDlAckNack::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ dl_tfi := ");
field_dl__tfi.log();
TTCN_Logger::log_event_str(", ms_oom := ");
field_ms__oom.log();
TTCN_Logger::log_event_str(", egprs_ch_qual_rep_presence := ");
field_egprs__ch__qual__rep__presence.log();
TTCN_Logger::log_event_str(", egprs_ch_qual_rep := ");
field_egprs__ch__qual__rep.log();
TTCN_Logger::log_event_str(", chreq_desc_presence := ");
field_chreq__desc__presence.log();
TTCN_Logger::log_event_str(", chreq_desc := ");
field_chreq__desc.log();
TTCN_Logger::log_event_str(", pfi_presence := ");
field_pfi__presence.log();
TTCN_Logger::log_event_str(", pfi := ");
field_pfi.log();
TTCN_Logger::log_event_str(", epdan_presence := ");
field_epdan__presence.log();
TTCN_Logger::log_event_str(", ack_nack_desc_ie := ");
field_ack__nack__desc__ie.log();
TTCN_Logger::log_event_str(" }");
}

void EgprsPacketDlAckNack::set_implicit_omit()
{
if (dl__tfi().is_bound()) dl__tfi().set_implicit_omit();
if (ms__oom().is_bound()) ms__oom().set_implicit_omit();
if (egprs__ch__qual__rep__presence().is_bound()) egprs__ch__qual__rep__presence().set_implicit_omit();
if (!egprs__ch__qual__rep().is_bound()) egprs__ch__qual__rep() = OMIT_VALUE;
else egprs__ch__qual__rep().set_implicit_omit();
if (chreq__desc__presence().is_bound()) chreq__desc__presence().set_implicit_omit();
if (!chreq__desc().is_bound()) chreq__desc() = OMIT_VALUE;
else chreq__desc().set_implicit_omit();
if (pfi__presence().is_bound()) pfi__presence().set_implicit_omit();
if (!pfi().is_bound()) pfi() = OMIT_VALUE;
else pfi().set_implicit_omit();
if (epdan__presence().is_bound()) epdan__presence().set_implicit_omit();
if (ack__nack__desc__ie().is_bound()) ack__nack__desc__ie().set_implicit_omit();
}

void EgprsPacketDlAckNack::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dl__tfi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ms__oom().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) egprs__ch__qual__rep__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) egprs__ch__qual__rep().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) chreq__desc__presence().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) chreq__desc().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) pfi__presence().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) pfi().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) epdan__presence().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) ack__nack__desc__ie().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_tfi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__tfi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_oom")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__oom().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "egprs_ch_qual_rep_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          egprs__ch__qual__rep__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "egprs_ch_qual_rep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          egprs__ch__qual__rep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chreq_desc_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chreq__desc__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chreq_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chreq__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pfi_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pfi__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pfi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pfi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "epdan_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          epdan__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ack_nack_desc_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ack__nack__desc__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
  }
}

void EgprsPacketDlAckNack::encode_text(Text_Buf& text_buf) const
{
field_dl__tfi.encode_text(text_buf);
field_ms__oom.encode_text(text_buf);
field_egprs__ch__qual__rep__presence.encode_text(text_buf);
field_egprs__ch__qual__rep.encode_text(text_buf);
field_chreq__desc__presence.encode_text(text_buf);
field_chreq__desc.encode_text(text_buf);
field_pfi__presence.encode_text(text_buf);
field_pfi.encode_text(text_buf);
field_epdan__presence.encode_text(text_buf);
field_ack__nack__desc__ie.encode_text(text_buf);
}

void EgprsPacketDlAckNack::decode_text(Text_Buf& text_buf)
{
field_dl__tfi.decode_text(text_buf);
field_ms__oom.decode_text(text_buf);
field_egprs__ch__qual__rep__presence.decode_text(text_buf);
field_egprs__ch__qual__rep.decode_text(text_buf);
field_chreq__desc__presence.decode_text(text_buf);
field_chreq__desc.decode_text(text_buf);
field_pfi__presence.decode_text(text_buf);
field_pfi.decode_text(text_buf);
field_epdan__presence.decode_text(text_buf);
field_ack__nack__desc__ie.decode_text(text_buf);
}

void EgprsPacketDlAckNack::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EgprsPacketDlAckNack::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EgprsPacketDlAckNack::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EgprsPacketDlAckNack_dl__tfi_descr_.raw->forceomit);
  decoded_field_length = field_dl__tfi.RAW_decode(EgprsPacketDlAckNack_dl__tfi_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EgprsPacketDlAckNack_ms__oom_descr_.raw->forceomit);
  decoded_field_length = field_ms__oom.RAW_decode(EgprsPacketDlAckNack_ms__oom_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, EgprsPacketDlAckNack_egprs__ch__qual__rep__presence_descr_.raw->forceomit);
  decoded_field_length = field_egprs__ch__qual__rep__presence.RAW_decode(EgprsPacketDlAckNack_egprs__ch__qual__rep__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_egprs__ch__qual__rep__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_egprs__ch__qual__rep = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, EgprsPacketDlAckNack_egprs__ch__qual__rep_descr_.raw->forceomit);
  decoded_field_length = field_egprs__ch__qual__rep().RAW_decode(EgprsPacketDlAckNack_egprs__ch__qual__rep_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_egprs__ch__qual__rep = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_egprs__ch__qual__rep=OMIT_VALUE;
  RAW_Force_Omit field_4_force_omit(4, force_omit, EgprsPacketDlAckNack_chreq__desc__presence_descr_.raw->forceomit);
  decoded_field_length = field_chreq__desc__presence.RAW_decode(EgprsPacketDlAckNack_chreq__desc__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_chreq__desc__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_chreq__desc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, EgprsPacketDlAckNack_chreq__desc_descr_.raw->forceomit);
  decoded_field_length = field_chreq__desc().RAW_decode(EgprsPacketDlAckNack_chreq__desc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_chreq__desc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_chreq__desc=OMIT_VALUE;
  RAW_Force_Omit field_6_force_omit(6, force_omit, EgprsPacketDlAckNack_pfi__presence_descr_.raw->forceomit);
  decoded_field_length = field_pfi__presence.RAW_decode(EgprsPacketDlAckNack_pfi__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_pfi__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_pfi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, EgprsPacketDlAckNack_pfi_descr_.raw->forceomit);
  decoded_field_length = field_pfi().RAW_decode(EgprsPacketDlAckNack_pfi_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_pfi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_pfi=OMIT_VALUE;
  RAW_Force_Omit field_8_force_omit(8, force_omit, EgprsPacketDlAckNack_epdan__presence_descr_.raw->forceomit);
  decoded_field_length = field_epdan__presence.RAW_decode(EgprsPacketDlAckNack_epdan__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_9_force_omit(9, force_omit, EgprsPacketDlAckNack_ack__nack__desc__ie_descr_.raw->forceomit);
  decoded_field_length = field_ack__nack__desc__ie.RAW_decode(EgprsPacketDlAckNack_ack__nack__desc__ie_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EgprsPacketDlAckNack::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 10;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(10);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EgprsPacketDlAckNack_dl__tfi_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EgprsPacketDlAckNack_ms__oom_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EgprsPacketDlAckNack_egprs__ch__qual__rep__presence_descr_.raw);
  if (field_egprs__ch__qual__rep.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EgprsPacketDlAckNack_egprs__ch__qual__rep_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, EgprsPacketDlAckNack_chreq__desc__presence_descr_.raw);
  if (field_chreq__desc.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, EgprsPacketDlAckNack_chreq__desc_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, EgprsPacketDlAckNack_pfi__presence_descr_.raw);
  if (field_pfi.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, EgprsPacketDlAckNack_pfi_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, EgprsPacketDlAckNack_epdan__presence_descr_.raw);
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, EgprsPacketDlAckNack_ack__nack__desc__ie_descr_.raw);
  encoded_length += field_dl__tfi.RAW_encode(EgprsPacketDlAckNack_dl__tfi_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ms__oom.RAW_encode(EgprsPacketDlAckNack_ms__oom_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_egprs__ch__qual__rep__presence.RAW_encode(EgprsPacketDlAckNack_egprs__ch__qual__rep__presence_descr_, *myleaf.body.node.nodes[2]);
  if (field_egprs__ch__qual__rep.ispresent()) {
  encoded_length += field_egprs__ch__qual__rep().RAW_encode(EgprsPacketDlAckNack_egprs__ch__qual__rep_descr_, *myleaf.body.node.nodes[3]);
  }
  encoded_length += field_chreq__desc__presence.RAW_encode(EgprsPacketDlAckNack_chreq__desc__presence_descr_, *myleaf.body.node.nodes[4]);
  if (field_chreq__desc.ispresent()) {
  encoded_length += field_chreq__desc().RAW_encode(EgprsPacketDlAckNack_chreq__desc_descr_, *myleaf.body.node.nodes[5]);
  }
  encoded_length += field_pfi__presence.RAW_encode(EgprsPacketDlAckNack_pfi__presence_descr_, *myleaf.body.node.nodes[6]);
  if (field_pfi.ispresent()) {
  encoded_length += field_pfi().RAW_encode(EgprsPacketDlAckNack_pfi_descr_, *myleaf.body.node.nodes[7]);
  }
  encoded_length += field_epdan__presence.RAW_encode(EgprsPacketDlAckNack_epdan__presence_descr_, *myleaf.body.node.nodes[8]);
  encoded_length += field_ack__nack__desc__ie.RAW_encode(EgprsPacketDlAckNack_ack__nack__desc__ie_descr_, *myleaf.body.node.nodes[9]);
  if (field_egprs__ch__qual__rep.ispresent() && (field_egprs__ch__qual__rep__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsPacketDlAckNack_egprs__ch__qual__rep__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_chreq__desc.ispresent() && (field_chreq__desc__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={4};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsPacketDlAckNack_chreq__desc__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_pfi.ispresent() && (field_pfi__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={6};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EgprsPacketDlAckNack_pfi__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EgprsPacketDlAckNack_template::single_value_struct {
INTEGER_template field_dl__tfi;
BITSTRING_template field_ms__oom;
BITSTRING_template field_egprs__ch__qual__rep__presence;
EgprsChannelQualityReport_template field_egprs__ch__qual__rep;
BITSTRING_template field_chreq__desc__presence;
ChannelReqDescription_template field_chreq__desc;
BITSTRING_template field_pfi__presence;
BITSTRING_template field_pfi;
BITSTRING_template field_epdan__presence;
EgprsAckNackDescriptionIE_template field_ack__nack__desc__ie;
};

void EgprsPacketDlAckNack_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_dl__tfi = ANY_VALUE;
single_value->field_ms__oom = ANY_VALUE;
single_value->field_egprs__ch__qual__rep__presence = ANY_VALUE;
single_value->field_egprs__ch__qual__rep = ANY_OR_OMIT;
single_value->field_chreq__desc__presence = ANY_VALUE;
single_value->field_chreq__desc = ANY_OR_OMIT;
single_value->field_pfi__presence = ANY_VALUE;
single_value->field_pfi = ANY_OR_OMIT;
single_value->field_epdan__presence = ANY_VALUE;
single_value->field_ack__nack__desc__ie = ANY_VALUE;
}
}
}

void EgprsPacketDlAckNack_template::copy_value(const EgprsPacketDlAckNack& other_value)
{
single_value = new single_value_struct;
if (other_value.dl__tfi().is_bound()) {
  single_value->field_dl__tfi = other_value.dl__tfi();
} else {
  single_value->field_dl__tfi.clean_up();
}
if (other_value.ms__oom().is_bound()) {
  single_value->field_ms__oom = other_value.ms__oom();
} else {
  single_value->field_ms__oom.clean_up();
}
if (other_value.egprs__ch__qual__rep__presence().is_bound()) {
  single_value->field_egprs__ch__qual__rep__presence = other_value.egprs__ch__qual__rep__presence();
} else {
  single_value->field_egprs__ch__qual__rep__presence.clean_up();
}
if (other_value.egprs__ch__qual__rep().is_bound()) {
  if (other_value.egprs__ch__qual__rep().ispresent()) single_value->field_egprs__ch__qual__rep = other_value.egprs__ch__qual__rep()();
  else single_value->field_egprs__ch__qual__rep = OMIT_VALUE;
} else {
  single_value->field_egprs__ch__qual__rep.clean_up();
}
if (other_value.chreq__desc__presence().is_bound()) {
  single_value->field_chreq__desc__presence = other_value.chreq__desc__presence();
} else {
  single_value->field_chreq__desc__presence.clean_up();
}
if (other_value.chreq__desc().is_bound()) {
  if (other_value.chreq__desc().ispresent()) single_value->field_chreq__desc = other_value.chreq__desc()();
  else single_value->field_chreq__desc = OMIT_VALUE;
} else {
  single_value->field_chreq__desc.clean_up();
}
if (other_value.pfi__presence().is_bound()) {
  single_value->field_pfi__presence = other_value.pfi__presence();
} else {
  single_value->field_pfi__presence.clean_up();
}
if (other_value.pfi().is_bound()) {
  if (other_value.pfi().ispresent()) single_value->field_pfi = other_value.pfi()();
  else single_value->field_pfi = OMIT_VALUE;
} else {
  single_value->field_pfi.clean_up();
}
if (other_value.epdan__presence().is_bound()) {
  single_value->field_epdan__presence = other_value.epdan__presence();
} else {
  single_value->field_epdan__presence.clean_up();
}
if (other_value.ack__nack__desc__ie().is_bound()) {
  single_value->field_ack__nack__desc__ie = other_value.ack__nack__desc__ie();
} else {
  single_value->field_ack__nack__desc__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EgprsPacketDlAckNack_template::copy_template(const EgprsPacketDlAckNack_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.dl__tfi().get_selection()) {
single_value->field_dl__tfi = other_value.dl__tfi();
} else {
single_value->field_dl__tfi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__oom().get_selection()) {
single_value->field_ms__oom = other_value.ms__oom();
} else {
single_value->field_ms__oom.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.egprs__ch__qual__rep__presence().get_selection()) {
single_value->field_egprs__ch__qual__rep__presence = other_value.egprs__ch__qual__rep__presence();
} else {
single_value->field_egprs__ch__qual__rep__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.egprs__ch__qual__rep().get_selection()) {
single_value->field_egprs__ch__qual__rep = other_value.egprs__ch__qual__rep();
} else {
single_value->field_egprs__ch__qual__rep.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chreq__desc__presence().get_selection()) {
single_value->field_chreq__desc__presence = other_value.chreq__desc__presence();
} else {
single_value->field_chreq__desc__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chreq__desc().get_selection()) {
single_value->field_chreq__desc = other_value.chreq__desc();
} else {
single_value->field_chreq__desc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pfi__presence().get_selection()) {
single_value->field_pfi__presence = other_value.pfi__presence();
} else {
single_value->field_pfi__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pfi().get_selection()) {
single_value->field_pfi = other_value.pfi();
} else {
single_value->field_pfi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.epdan__presence().get_selection()) {
single_value->field_epdan__presence = other_value.epdan__presence();
} else {
single_value->field_epdan__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ack__nack__desc__ie().get_selection()) {
single_value->field_ack__nack__desc__ie = other_value.ack__nack__desc__ie();
} else {
single_value->field_ack__nack__desc__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EgprsPacketDlAckNack_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EgprsPacketDlAckNack_template(*other_value.implication_.precondition);
implication_.implied_template = new EgprsPacketDlAckNack_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
break;
}
set_selection(other_value);
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template()
{
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(const EgprsPacketDlAckNack& other_value)
{
copy_value(other_value);
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(const OPTIONAL<EgprsPacketDlAckNack>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsPacketDlAckNack&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack from an unbound optional field.");
}
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(EgprsPacketDlAckNack_template* p_precondition, EgprsPacketDlAckNack_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(Dynamic_Match_Interface<EgprsPacketDlAckNack>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EgprsPacketDlAckNack>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EgprsPacketDlAckNack_template::EgprsPacketDlAckNack_template(const EgprsPacketDlAckNack_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EgprsPacketDlAckNack_template::~EgprsPacketDlAckNack_template()
{
clean_up();
}

EgprsPacketDlAckNack_template& EgprsPacketDlAckNack_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EgprsPacketDlAckNack_template& EgprsPacketDlAckNack_template::operator=(const EgprsPacketDlAckNack& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EgprsPacketDlAckNack_template& EgprsPacketDlAckNack_template::operator=(const OPTIONAL<EgprsPacketDlAckNack>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EgprsPacketDlAckNack&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
}
return *this;
}

EgprsPacketDlAckNack_template& EgprsPacketDlAckNack_template::operator=(const EgprsPacketDlAckNack_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EgprsPacketDlAckNack_template::match(const EgprsPacketDlAckNack& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.dl__tfi().is_bound()) return FALSE;
if(!single_value->field_dl__tfi.match(other_value.dl__tfi(), legacy))return FALSE;
if(!other_value.ms__oom().is_bound()) return FALSE;
if(!single_value->field_ms__oom.match(other_value.ms__oom(), legacy))return FALSE;
if(!other_value.egprs__ch__qual__rep__presence().is_bound()) return FALSE;
if(!single_value->field_egprs__ch__qual__rep__presence.match(other_value.egprs__ch__qual__rep__presence(), legacy))return FALSE;
if(!other_value.egprs__ch__qual__rep().is_bound()) return FALSE;
if((other_value.egprs__ch__qual__rep().ispresent() ? !single_value->field_egprs__ch__qual__rep.match((const EgprsChannelQualityReport&)other_value.egprs__ch__qual__rep(), legacy) : !single_value->field_egprs__ch__qual__rep.match_omit(legacy)))return FALSE;
if(!other_value.chreq__desc__presence().is_bound()) return FALSE;
if(!single_value->field_chreq__desc__presence.match(other_value.chreq__desc__presence(), legacy))return FALSE;
if(!other_value.chreq__desc().is_bound()) return FALSE;
if((other_value.chreq__desc().ispresent() ? !single_value->field_chreq__desc.match((const ChannelReqDescription&)other_value.chreq__desc(), legacy) : !single_value->field_chreq__desc.match_omit(legacy)))return FALSE;
if(!other_value.pfi__presence().is_bound()) return FALSE;
if(!single_value->field_pfi__presence.match(other_value.pfi__presence(), legacy))return FALSE;
if(!other_value.pfi().is_bound()) return FALSE;
if((other_value.pfi().ispresent() ? !single_value->field_pfi.match((const BITSTRING&)other_value.pfi(), legacy) : !single_value->field_pfi.match_omit(legacy)))return FALSE;
if(!other_value.epdan__presence().is_bound()) return FALSE;
if(!single_value->field_epdan__presence.match(other_value.epdan__presence(), legacy))return FALSE;
if(!other_value.ack__nack__desc__ie().is_bound()) return FALSE;
if(!single_value->field_ack__nack__desc__ie.match(other_value.ack__nack__desc__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
}
return FALSE;
}

boolean EgprsPacketDlAckNack_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_dl__tfi.is_bound()
 || single_value->field_ms__oom.is_bound()
 || single_value->field_egprs__ch__qual__rep__presence.is_bound()
 || (single_value->field_egprs__ch__qual__rep.is_omit() || single_value->field_egprs__ch__qual__rep.is_bound())
 || single_value->field_chreq__desc__presence.is_bound()
 || (single_value->field_chreq__desc.is_omit() || single_value->field_chreq__desc.is_bound())
 || single_value->field_pfi__presence.is_bound()
 || (single_value->field_pfi.is_omit() || single_value->field_pfi.is_bound())
 || single_value->field_epdan__presence.is_bound()
 || single_value->field_ack__nack__desc__ie.is_bound();
}

boolean EgprsPacketDlAckNack_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_dl__tfi.is_value()
 && single_value->field_ms__oom.is_value()
 && single_value->field_egprs__ch__qual__rep__presence.is_value()
 && (single_value->field_egprs__ch__qual__rep.is_omit() || single_value->field_egprs__ch__qual__rep.is_value())
 && single_value->field_chreq__desc__presence.is_value()
 && (single_value->field_chreq__desc.is_omit() || single_value->field_chreq__desc.is_value())
 && single_value->field_pfi__presence.is_value()
 && (single_value->field_pfi.is_omit() || single_value->field_pfi.is_value())
 && single_value->field_epdan__presence.is_value()
 && single_value->field_ack__nack__desc__ie.is_value();
}

void EgprsPacketDlAckNack_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EgprsPacketDlAckNack EgprsPacketDlAckNack_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
EgprsPacketDlAckNack ret_val;
if (single_value->field_dl__tfi.is_bound()) {
ret_val.dl__tfi() = single_value->field_dl__tfi.valueof();
}
if (single_value->field_ms__oom.is_bound()) {
ret_val.ms__oom() = single_value->field_ms__oom.valueof();
}
if (single_value->field_egprs__ch__qual__rep__presence.is_bound()) {
ret_val.egprs__ch__qual__rep__presence() = single_value->field_egprs__ch__qual__rep__presence.valueof();
}
if (single_value->field_egprs__ch__qual__rep.is_omit()) ret_val.egprs__ch__qual__rep() = OMIT_VALUE;
else if (single_value->field_egprs__ch__qual__rep.is_bound()) {
ret_val.egprs__ch__qual__rep() = single_value->field_egprs__ch__qual__rep.valueof();
}
if (single_value->field_chreq__desc__presence.is_bound()) {
ret_val.chreq__desc__presence() = single_value->field_chreq__desc__presence.valueof();
}
if (single_value->field_chreq__desc.is_omit()) ret_val.chreq__desc() = OMIT_VALUE;
else if (single_value->field_chreq__desc.is_bound()) {
ret_val.chreq__desc() = single_value->field_chreq__desc.valueof();
}
if (single_value->field_pfi__presence.is_bound()) {
ret_val.pfi__presence() = single_value->field_pfi__presence.valueof();
}
if (single_value->field_pfi.is_omit()) ret_val.pfi() = OMIT_VALUE;
else if (single_value->field_pfi.is_bound()) {
ret_val.pfi() = single_value->field_pfi.valueof();
}
if (single_value->field_epdan__presence.is_bound()) {
ret_val.epdan__presence() = single_value->field_epdan__presence.valueof();
}
if (single_value->field_ack__nack__desc__ie.is_bound()) {
ret_val.ack__nack__desc__ie() = single_value->field_ack__nack__desc__ie.valueof();
}
return ret_val;
}

void EgprsPacketDlAckNack_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EgprsPacketDlAckNack_template[list_length];
}

EgprsPacketDlAckNack_template& EgprsPacketDlAckNack_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return value_list.list_value[list_index];
}

INTEGER_template& EgprsPacketDlAckNack_template::dl__tfi()
{
set_specific();
return single_value->field_dl__tfi;
}

const INTEGER_template& EgprsPacketDlAckNack_template::dl__tfi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_tfi of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_dl__tfi;
}

BITSTRING_template& EgprsPacketDlAckNack_template::ms__oom()
{
set_specific();
return single_value->field_ms__oom;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::ms__oom() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_oom of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_ms__oom;
}

BITSTRING_template& EgprsPacketDlAckNack_template::egprs__ch__qual__rep__presence()
{
set_specific();
return single_value->field_egprs__ch__qual__rep__presence;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::egprs__ch__qual__rep__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field egprs_ch_qual_rep_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_egprs__ch__qual__rep__presence;
}

EgprsChannelQualityReport_template& EgprsPacketDlAckNack_template::egprs__ch__qual__rep()
{
set_specific();
return single_value->field_egprs__ch__qual__rep;
}

const EgprsChannelQualityReport_template& EgprsPacketDlAckNack_template::egprs__ch__qual__rep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field egprs_ch_qual_rep of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_egprs__ch__qual__rep;
}

BITSTRING_template& EgprsPacketDlAckNack_template::chreq__desc__presence()
{
set_specific();
return single_value->field_chreq__desc__presence;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::chreq__desc__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chreq_desc_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_chreq__desc__presence;
}

ChannelReqDescription_template& EgprsPacketDlAckNack_template::chreq__desc()
{
set_specific();
return single_value->field_chreq__desc;
}

const ChannelReqDescription_template& EgprsPacketDlAckNack_template::chreq__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chreq_desc of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_chreq__desc;
}

BITSTRING_template& EgprsPacketDlAckNack_template::pfi__presence()
{
set_specific();
return single_value->field_pfi__presence;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::pfi__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pfi_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_pfi__presence;
}

BITSTRING_template& EgprsPacketDlAckNack_template::pfi()
{
set_specific();
return single_value->field_pfi;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::pfi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pfi of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_pfi;
}

BITSTRING_template& EgprsPacketDlAckNack_template::epdan__presence()
{
set_specific();
return single_value->field_epdan__presence;
}

const BITSTRING_template& EgprsPacketDlAckNack_template::epdan__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field epdan_presence of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_epdan__presence;
}

EgprsAckNackDescriptionIE_template& EgprsPacketDlAckNack_template::ack__nack__desc__ie()
{
set_specific();
return single_value->field_ack__nack__desc__ie;
}

const EgprsAckNackDescriptionIE_template& EgprsPacketDlAckNack_template::ack__nack__desc__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ack_nack_desc_ie of a non-specific template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
return single_value->field_ack__nack__desc__ie;
}

int EgprsPacketDlAckNack_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 7;
      if (single_value->field_egprs__ch__qual__rep.is_present()) ret_val++;
      if (single_value->field_chreq__desc.is_present()) ret_val++;
      if (single_value->field_pfi.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
  }
  return 0;
}

void EgprsPacketDlAckNack_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ dl_tfi := ");
single_value->field_dl__tfi.log();
TTCN_Logger::log_event_str(", ms_oom := ");
single_value->field_ms__oom.log();
TTCN_Logger::log_event_str(", egprs_ch_qual_rep_presence := ");
single_value->field_egprs__ch__qual__rep__presence.log();
TTCN_Logger::log_event_str(", egprs_ch_qual_rep := ");
single_value->field_egprs__ch__qual__rep.log();
TTCN_Logger::log_event_str(", chreq_desc_presence := ");
single_value->field_chreq__desc__presence.log();
TTCN_Logger::log_event_str(", chreq_desc := ");
single_value->field_chreq__desc.log();
TTCN_Logger::log_event_str(", pfi_presence := ");
single_value->field_pfi__presence.log();
TTCN_Logger::log_event_str(", pfi := ");
single_value->field_pfi.log();
TTCN_Logger::log_event_str(", epdan_presence := ");
single_value->field_epdan__presence.log();
TTCN_Logger::log_event_str(", ack_nack_desc_ie := ");
single_value->field_ack__nack__desc__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EgprsPacketDlAckNack_template::log_match(const EgprsPacketDlAckNack& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_dl__tfi.match(match_value.dl__tfi(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_tfi");
single_value->field_dl__tfi.log_match(match_value.dl__tfi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ms__oom.match(match_value.ms__oom(), legacy)){
TTCN_Logger::log_logmatch_info(".ms_oom");
single_value->field_ms__oom.log_match(match_value.ms__oom(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_egprs__ch__qual__rep__presence.match(match_value.egprs__ch__qual__rep__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".egprs_ch_qual_rep_presence");
single_value->field_egprs__ch__qual__rep__presence.log_match(match_value.egprs__ch__qual__rep__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.egprs__ch__qual__rep().ispresent()){
if(!single_value->field_egprs__ch__qual__rep.match(match_value.egprs__ch__qual__rep(), legacy)){
TTCN_Logger::log_logmatch_info(".egprs_ch_qual_rep");
single_value->field_egprs__ch__qual__rep.log_match(match_value.egprs__ch__qual__rep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_egprs__ch__qual__rep.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".egprs_ch_qual_rep := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_egprs__ch__qual__rep.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_chreq__desc__presence.match(match_value.chreq__desc__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".chreq_desc_presence");
single_value->field_chreq__desc__presence.log_match(match_value.chreq__desc__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.chreq__desc().ispresent()){
if(!single_value->field_chreq__desc.match(match_value.chreq__desc(), legacy)){
TTCN_Logger::log_logmatch_info(".chreq_desc");
single_value->field_chreq__desc.log_match(match_value.chreq__desc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_chreq__desc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".chreq_desc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_chreq__desc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_pfi__presence.match(match_value.pfi__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".pfi_presence");
single_value->field_pfi__presence.log_match(match_value.pfi__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pfi().ispresent()){
if(!single_value->field_pfi.match(match_value.pfi(), legacy)){
TTCN_Logger::log_logmatch_info(".pfi");
single_value->field_pfi.log_match(match_value.pfi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pfi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pfi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pfi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_epdan__presence.match(match_value.epdan__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".epdan_presence");
single_value->field_epdan__presence.log_match(match_value.epdan__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ack__nack__desc__ie.match(match_value.ack__nack__desc__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".ack_nack_desc_ie");
single_value->field_ack__nack__desc__ie.log_match(match_value.ack__nack__desc__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ dl_tfi := ");
single_value->field_dl__tfi.log_match(match_value.dl__tfi(), legacy);
TTCN_Logger::log_event_str(", ms_oom := ");
single_value->field_ms__oom.log_match(match_value.ms__oom(), legacy);
TTCN_Logger::log_event_str(", egprs_ch_qual_rep_presence := ");
single_value->field_egprs__ch__qual__rep__presence.log_match(match_value.egprs__ch__qual__rep__presence(), legacy);
TTCN_Logger::log_event_str(", egprs_ch_qual_rep := ");
if (match_value.egprs__ch__qual__rep().ispresent()) {
single_value->field_egprs__ch__qual__rep.log_match(match_value.egprs__ch__qual__rep(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_egprs__ch__qual__rep.log();
if (single_value->field_egprs__ch__qual__rep.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", chreq_desc_presence := ");
single_value->field_chreq__desc__presence.log_match(match_value.chreq__desc__presence(), legacy);
TTCN_Logger::log_event_str(", chreq_desc := ");
if (match_value.chreq__desc().ispresent()) {
single_value->field_chreq__desc.log_match(match_value.chreq__desc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_chreq__desc.log();
if (single_value->field_chreq__desc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pfi_presence := ");
single_value->field_pfi__presence.log_match(match_value.pfi__presence(), legacy);
TTCN_Logger::log_event_str(", pfi := ");
if (match_value.pfi().ispresent()) {
single_value->field_pfi.log_match(match_value.pfi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pfi.log();
if (single_value->field_pfi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", epdan_presence := ");
single_value->field_epdan__presence.log_match(match_value.epdan__presence(), legacy);
TTCN_Logger::log_event_str(", ack_nack_desc_ie := ");
single_value->field_ack__nack__desc__ie.log_match(match_value.ack__nack__desc__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EgprsPacketDlAckNack_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (dl__tfi().is_bound()) dl__tfi().set_implicit_omit();
if (ms__oom().is_bound()) ms__oom().set_implicit_omit();
if (egprs__ch__qual__rep__presence().is_bound()) egprs__ch__qual__rep__presence().set_implicit_omit();
if (!egprs__ch__qual__rep().is_bound()) egprs__ch__qual__rep() = OMIT_VALUE;
else egprs__ch__qual__rep().set_implicit_omit();
if (chreq__desc__presence().is_bound()) chreq__desc__presence().set_implicit_omit();
if (!chreq__desc().is_bound()) chreq__desc() = OMIT_VALUE;
else chreq__desc().set_implicit_omit();
if (pfi__presence().is_bound()) pfi__presence().set_implicit_omit();
if (!pfi().is_bound()) pfi() = OMIT_VALUE;
else pfi().set_implicit_omit();
if (epdan__presence().is_bound()) epdan__presence().set_implicit_omit();
if (ack__nack__desc__ie().is_bound()) ack__nack__desc__ie().set_implicit_omit();
}

void EgprsPacketDlAckNack_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_dl__tfi.encode_text(text_buf);
single_value->field_ms__oom.encode_text(text_buf);
single_value->field_egprs__ch__qual__rep__presence.encode_text(text_buf);
single_value->field_egprs__ch__qual__rep.encode_text(text_buf);
single_value->field_chreq__desc__presence.encode_text(text_buf);
single_value->field_chreq__desc.encode_text(text_buf);
single_value->field_pfi__presence.encode_text(text_buf);
single_value->field_pfi.encode_text(text_buf);
single_value->field_epdan__presence.encode_text(text_buf);
single_value->field_ack__nack__desc__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
}
}

void EgprsPacketDlAckNack_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_dl__tfi.decode_text(text_buf);
single_value->field_ms__oom.decode_text(text_buf);
single_value->field_egprs__ch__qual__rep__presence.decode_text(text_buf);
single_value->field_egprs__ch__qual__rep.decode_text(text_buf);
single_value->field_chreq__desc__presence.decode_text(text_buf);
single_value->field_chreq__desc.decode_text(text_buf);
single_value->field_pfi__presence.decode_text(text_buf);
single_value->field_pfi.decode_text(text_buf);
single_value->field_epdan__presence.decode_text(text_buf);
single_value->field_ack__nack__desc__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EgprsPacketDlAckNack_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack.");
}
}

void EgprsPacketDlAckNack_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EgprsPacketDlAckNack_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (10<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack has 10 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dl__tfi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ms__oom().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) egprs__ch__qual__rep__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) egprs__ch__qual__rep().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) chreq__desc__presence().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) chreq__desc().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) pfi__presence().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) pfi().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) epdan__presence().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) ack__nack__desc__ie().set_param(*param.get_elem(9));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_tfi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__tfi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_oom")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__oom().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "egprs_ch_qual_rep_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          egprs__ch__qual__rep__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "egprs_ch_qual_rep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          egprs__ch__qual__rep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chreq_desc_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chreq__desc__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chreq_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chreq__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pfi_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pfi__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pfi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pfi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "epdan_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          epdan__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ack_nack_desc_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ack__nack__desc__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EgprsPacketDlAckNack: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EgprsPacketDlAckNack_template* precondition = new EgprsPacketDlAckNack_template;
    precondition->set_param(*param.get_elem(0));
    EgprsPacketDlAckNack_template* implied_template = new EgprsPacketDlAckNack_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EgprsPacketDlAckNack_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
  }
  is_ifpresent = param.get_ifpresent();
}

void EgprsPacketDlAckNack_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_dl__tfi.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_ms__oom.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_egprs__ch__qual__rep__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_egprs__ch__qual__rep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_chreq__desc__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_chreq__desc.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_pfi__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_pfi.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_epdan__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
single_value->field_ack__nack__desc__ie.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EgprsPacketDlAckNack");
}

boolean EgprsPacketDlAckNack_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EgprsPacketDlAckNack_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CtrlAck::CtrlAck()
{
enum_value = UNBOUND_VALUE;
}

CtrlAck::CtrlAck(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RLCMAC_CSN1_Types.CtrlAck with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

CtrlAck::CtrlAck(enum_type other_value)
{
enum_value = other_value;
}

CtrlAck::CtrlAck(const CtrlAck& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
enum_value = other_value.enum_value;
}

CtrlAck& CtrlAck::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

CtrlAck& CtrlAck::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

CtrlAck& CtrlAck::operator=(const CtrlAck& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
enum_value = other_value.enum_value;
return *this;
}

boolean CtrlAck::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.CtrlAck comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean CtrlAck::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value == other_value;
}

boolean CtrlAck::operator==(const CtrlAck& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value == other_value.enum_value;
}

boolean CtrlAck::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.CtrlAck comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean CtrlAck::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value < other_value;
}

boolean CtrlAck::operator<(const CtrlAck& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value < other_value.enum_value;
}

boolean CtrlAck::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.CtrlAck comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean CtrlAck::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value > other_value;
}

boolean CtrlAck::operator>(const CtrlAck& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value > other_value.enum_value;
}

const char *CtrlAck::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case MS__RCVD__TWO__RLC__SAME__RTI__DIFF__RBSN__NEW__TFI: return "MS_RCVD_TWO_RLC_SAME_RTI_DIFF_RBSN_NEW_TFI";
case MS__RCVD__RBSN1__NO__RBSN0: return "MS_RCVD_RBSN1_NO_RBSN0";
case MS__RCVD__RBSN0__NO__RBSN1: return "MS_RCVD_RBSN0_NO_RBSN1";
case MS__RCVD__TWO__RLC__SAME__RTI__DIFF__RBSN: return "MS_RCVD_TWO_RLC_SAME_RTI_DIFF_RBSN";
default:
return "<unknown>";
}
}

CtrlAck::enum_type CtrlAck::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "MS_RCVD_TWO_RLC_SAME_RTI_DIFF_RBSN_NEW_TFI")) return MS__RCVD__TWO__RLC__SAME__RTI__DIFF__RBSN__NEW__TFI;
if (!strcmp(str_par, "MS_RCVD_RBSN1_NO_RBSN0")) return MS__RCVD__RBSN1__NO__RBSN0;
if (!strcmp(str_par, "MS_RCVD_RBSN0_NO_RBSN1")) return MS__RCVD__RBSN0__NO__RBSN1;
if (!strcmp(str_par, "MS_RCVD_TWO_RLC_SAME_RTI_DIFF_RBSN")) return MS__RCVD__TWO__RLC__SAME__RTI__DIFF__RBSN;
}
return UNKNOWN_VALUE;
}

boolean CtrlAck::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int CtrlAck::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int CtrlAck::enum2int(const CtrlAck& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void CtrlAck::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", int_val);
enum_value = (enum_type)int_val;
}

CtrlAck::operator CtrlAck::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return enum_value;
}

void CtrlAck::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void CtrlAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RLCMAC_CSN1_Types.CtrlAck");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.CtrlAck.");
  }
}

void CtrlAck::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
text_buf.push_int(enum_value);
}

void CtrlAck::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RLCMAC_CSN1_Types.CtrlAck.", enum_value);
}

void CtrlAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CtrlAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CtrlAck::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int CtrlAck::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void CtrlAck_template::copy_template(const CtrlAck_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CtrlAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CtrlAck_template(*other_value.implication_.precondition);
implication_.implied_template = new CtrlAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
}

CtrlAck_template::CtrlAck_template()
{
}

CtrlAck_template::CtrlAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CtrlAck_template::CtrlAck_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!CtrlAck::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck with unknown numeric value %d.", other_value);
single_value = (CtrlAck::enum_type)other_value;
}

CtrlAck_template::CtrlAck_template(CtrlAck::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

CtrlAck_template::CtrlAck_template(const CtrlAck& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == CtrlAck::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
single_value = other_value.enum_value;
}

CtrlAck_template::CtrlAck_template(const OPTIONAL<CtrlAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (CtrlAck::enum_type)(const CtrlAck&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck from an unbound optional field.");
}
}

CtrlAck_template::CtrlAck_template(CtrlAck_template* p_precondition, CtrlAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CtrlAck_template::CtrlAck_template(Dynamic_Match_Interface<CtrlAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CtrlAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CtrlAck_template::CtrlAck_template(const CtrlAck_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

CtrlAck_template::~CtrlAck_template()
{
clean_up();
}

boolean CtrlAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean CtrlAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != CtrlAck::UNBOUND_VALUE;
}

void CtrlAck_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CtrlAck_template& CtrlAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CtrlAck_template& CtrlAck_template::operator=(int other_value)
{
if (!CtrlAck::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (CtrlAck::enum_type)other_value;
return *this;
}

CtrlAck_template& CtrlAck_template::operator=(CtrlAck::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

CtrlAck_template& CtrlAck_template::operator=(const CtrlAck& other_value)
{
if (other_value.enum_value == CtrlAck::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.CtrlAck to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

CtrlAck_template& CtrlAck_template::operator=(const OPTIONAL<CtrlAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (CtrlAck::enum_type)(const CtrlAck&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
return *this;
}

CtrlAck_template& CtrlAck_template::operator=(const CtrlAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CtrlAck_template::match(CtrlAck::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
return FALSE;
}

boolean CtrlAck_template::match(const CtrlAck& other_value, boolean) const
{
if (other_value.enum_value == CtrlAck::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck with an unbound value.");
return match(other_value.enum_value);
}

CtrlAck::enum_type CtrlAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return single_value;
}

void CtrlAck_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CtrlAck_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
}

CtrlAck_template& CtrlAck_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
return value_list.list_value[list_index];
}

void CtrlAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(CtrlAck::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CtrlAck_template::log_match(const CtrlAck& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void CtrlAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
}

void CtrlAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (CtrlAck::enum_type)text_buf.pull_int().get_val();
if (!CtrlAck::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CtrlAck_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RLCMAC_CSN1_Types.CtrlAck.");
}
}

boolean CtrlAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CtrlAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void CtrlAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CtrlAck_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    CtrlAck::enum_type enum_val = CtrlAck::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!CtrlAck::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.CtrlAck.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    CtrlAck_template* precondition = new CtrlAck_template;
    precondition->set_param(*m_p->get_elem(0));
    CtrlAck_template* implied_template = new CtrlAck_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = CtrlAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RLCMAC_CSN1_Types.CtrlAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void CtrlAck_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.CtrlAck");
}

PacketCtrlAck::PacketCtrlAck()
{
}

PacketCtrlAck::PacketCtrlAck(const OCTETSTRING& par_tlli,
    const CtrlAck& par_ctrl__ack)
  :   field_tlli(par_tlli),
  field_ctrl__ack(par_ctrl__ack)
{
}

PacketCtrlAck::PacketCtrlAck(const PacketCtrlAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
else field_tlli.clean_up();
if (other_value.ctrl__ack().is_bound()) field_ctrl__ack = other_value.ctrl__ack();
else field_ctrl__ack.clean_up();
}

void PacketCtrlAck::clean_up()
{
field_tlli.clean_up();
field_ctrl__ack.clean_up();
}

const TTCN_Typedescriptor_t* PacketCtrlAck::get_descriptor() const { return &PacketCtrlAck_descr_; }
PacketCtrlAck& PacketCtrlAck::operator=(const PacketCtrlAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
  if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
  else field_tlli.clean_up();
  if (other_value.ctrl__ack().is_bound()) field_ctrl__ack = other_value.ctrl__ack();
  else field_ctrl__ack.clean_up();
}
return *this;
}

boolean PacketCtrlAck::operator==(const PacketCtrlAck& other_value) const
{
return field_tlli==other_value.field_tlli
  && field_ctrl__ack==other_value.field_ctrl__ack;
}

boolean PacketCtrlAck::is_bound() const
{
return (field_tlli.is_bound())
  || (field_ctrl__ack.is_bound());
}
boolean PacketCtrlAck::is_value() const
{
return field_tlli.is_value()
  && field_ctrl__ack.is_value();
}
void PacketCtrlAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli.log();
TTCN_Logger::log_event_str(", ctrl_ack := ");
field_ctrl__ack.log();
TTCN_Logger::log_event_str(" }");
}

void PacketCtrlAck::set_implicit_omit()
{
if (tlli().is_bound()) tlli().set_implicit_omit();
if (ctrl__ack().is_bound()) ctrl__ack().set_implicit_omit();
}

void PacketCtrlAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketCtrlAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ctrl__ack().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ctrl_ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ctrl__ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketCtrlAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketCtrlAck");
  }
}

void PacketCtrlAck::encode_text(Text_Buf& text_buf) const
{
field_tlli.encode_text(text_buf);
field_ctrl__ack.encode_text(text_buf);
}

void PacketCtrlAck::decode_text(Text_Buf& text_buf)
{
field_tlli.decode_text(text_buf);
field_ctrl__ack.decode_text(text_buf);
}

void PacketCtrlAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketCtrlAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketCtrlAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketCtrlAck_tlli_descr_.raw->forceomit);
  decoded_field_length = field_tlli.RAW_decode(PacketCtrlAck_tlli_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketCtrlAck_ctrl__ack_descr_.raw->forceomit);
  decoded_field_length = field_ctrl__ack.RAW_decode(PacketCtrlAck_ctrl__ack_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketCtrlAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketCtrlAck_tlli_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketCtrlAck_ctrl__ack_descr_.raw);
  encoded_length += field_tlli.RAW_encode(PacketCtrlAck_tlli_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ctrl__ack.RAW_encode(PacketCtrlAck_ctrl__ack_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PacketCtrlAck_template::single_value_struct {
OCTETSTRING_template field_tlli;
CtrlAck_template field_ctrl__ack;
};

void PacketCtrlAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tlli = ANY_VALUE;
single_value->field_ctrl__ack = ANY_VALUE;
}
}
}

void PacketCtrlAck_template::copy_value(const PacketCtrlAck& other_value)
{
single_value = new single_value_struct;
if (other_value.tlli().is_bound()) {
  single_value->field_tlli = other_value.tlli();
} else {
  single_value->field_tlli.clean_up();
}
if (other_value.ctrl__ack().is_bound()) {
  single_value->field_ctrl__ack = other_value.ctrl__ack();
} else {
  single_value->field_ctrl__ack.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketCtrlAck_template::copy_template(const PacketCtrlAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tlli().get_selection()) {
single_value->field_tlli = other_value.tlli();
} else {
single_value->field_tlli.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ctrl__ack().get_selection()) {
single_value->field_ctrl__ack = other_value.ctrl__ack();
} else {
single_value->field_ctrl__ack.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketCtrlAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketCtrlAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketCtrlAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
break;
}
set_selection(other_value);
}

PacketCtrlAck_template::PacketCtrlAck_template()
{
}

PacketCtrlAck_template::PacketCtrlAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketCtrlAck_template::PacketCtrlAck_template(const PacketCtrlAck& other_value)
{
copy_value(other_value);
}

PacketCtrlAck_template::PacketCtrlAck_template(const OPTIONAL<PacketCtrlAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketCtrlAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketCtrlAck from an unbound optional field.");
}
}

PacketCtrlAck_template::PacketCtrlAck_template(PacketCtrlAck_template* p_precondition, PacketCtrlAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketCtrlAck_template::PacketCtrlAck_template(Dynamic_Match_Interface<PacketCtrlAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketCtrlAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketCtrlAck_template::PacketCtrlAck_template(const PacketCtrlAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketCtrlAck_template::~PacketCtrlAck_template()
{
clean_up();
}

PacketCtrlAck_template& PacketCtrlAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketCtrlAck_template& PacketCtrlAck_template::operator=(const PacketCtrlAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketCtrlAck_template& PacketCtrlAck_template::operator=(const OPTIONAL<PacketCtrlAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketCtrlAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
}
return *this;
}

PacketCtrlAck_template& PacketCtrlAck_template::operator=(const PacketCtrlAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketCtrlAck_template::match(const PacketCtrlAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tlli().is_bound()) return FALSE;
if(!single_value->field_tlli.match(other_value.tlli(), legacy))return FALSE;
if(!other_value.ctrl__ack().is_bound()) return FALSE;
if(!single_value->field_ctrl__ack.match(other_value.ctrl__ack(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
}
return FALSE;
}

boolean PacketCtrlAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tlli.is_bound()
 || single_value->field_ctrl__ack.is_bound();
}

boolean PacketCtrlAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tlli.is_value()
 && single_value->field_ctrl__ack.is_value();
}

void PacketCtrlAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketCtrlAck PacketCtrlAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
PacketCtrlAck ret_val;
if (single_value->field_tlli.is_bound()) {
ret_val.tlli() = single_value->field_tlli.valueof();
}
if (single_value->field_ctrl__ack.is_bound()) {
ret_val.ctrl__ack() = single_value->field_ctrl__ack.valueof();
}
return ret_val;
}

void PacketCtrlAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketCtrlAck_template[list_length];
}

PacketCtrlAck_template& PacketCtrlAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PacketCtrlAck_template::tlli()
{
set_specific();
return single_value->field_tlli;
}

const OCTETSTRING_template& PacketCtrlAck_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tlli of a non-specific template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
return single_value->field_tlli;
}

CtrlAck_template& PacketCtrlAck_template::ctrl__ack()
{
set_specific();
return single_value->field_ctrl__ack;
}

const CtrlAck_template& PacketCtrlAck_template::ctrl__ack() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ctrl_ack of a non-specific template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
return single_value->field_ctrl__ack;
}

int PacketCtrlAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketCtrlAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
  }
  return 0;
}

void PacketCtrlAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log();
TTCN_Logger::log_event_str(", ctrl_ack := ");
single_value->field_ctrl__ack.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketCtrlAck_template::log_match(const PacketCtrlAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tlli.match(match_value.tlli(), legacy)){
TTCN_Logger::log_logmatch_info(".tlli");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ctrl__ack.match(match_value.ctrl__ack(), legacy)){
TTCN_Logger::log_logmatch_info(".ctrl_ack");
single_value->field_ctrl__ack.log_match(match_value.ctrl__ack(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(", ctrl_ack := ");
single_value->field_ctrl__ack.log_match(match_value.ctrl__ack(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketCtrlAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tlli().is_bound()) tlli().set_implicit_omit();
if (ctrl__ack().is_bound()) ctrl__ack().set_implicit_omit();
}

void PacketCtrlAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tlli.encode_text(text_buf);
single_value->field_ctrl__ack.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
}
}

void PacketCtrlAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tlli.decode_text(text_buf);
single_value->field_ctrl__ack.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketCtrlAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PacketCtrlAck.");
}
}

void PacketCtrlAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketCtrlAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PacketCtrlAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ctrl__ack().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ctrl_ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ctrl__ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketCtrlAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketCtrlAck_template* precondition = new PacketCtrlAck_template;
    precondition->set_param(*param.get_elem(0));
    PacketCtrlAck_template* implied_template = new PacketCtrlAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketCtrlAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PacketCtrlAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketCtrlAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tlli.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketCtrlAck");
single_value->field_ctrl__ack.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketCtrlAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketCtrlAck");
}

boolean PacketCtrlAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketCtrlAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketUlDummy::PacketUlDummy()
{
}

PacketUlDummy::PacketUlDummy(const OCTETSTRING& par_tlli)
  :   field_tlli(par_tlli)
{
}

PacketUlDummy::PacketUlDummy(const PacketUlDummy& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketUlDummy.");
if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
else field_tlli.clean_up();
}

void PacketUlDummy::clean_up()
{
field_tlli.clean_up();
}

const TTCN_Typedescriptor_t* PacketUlDummy::get_descriptor() const { return &PacketUlDummy_descr_; }
PacketUlDummy& PacketUlDummy::operator=(const PacketUlDummy& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketUlDummy.");
  if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
  else field_tlli.clean_up();
}
return *this;
}

boolean PacketUlDummy::operator==(const PacketUlDummy& other_value) const
{
return field_tlli==other_value.field_tlli;
}

boolean PacketUlDummy::is_bound() const
{
return (field_tlli.is_bound());
}
boolean PacketUlDummy::is_value() const
{
return field_tlli.is_value();
}
void PacketUlDummy::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli.log();
TTCN_Logger::log_event_str(" }");
}

void PacketUlDummy::set_implicit_omit()
{
if (tlli().is_bound()) tlli().set_implicit_omit();
}

void PacketUlDummy::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketUlDummy has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketUlDummy: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketUlDummy");
  }
}

void PacketUlDummy::encode_text(Text_Buf& text_buf) const
{
field_tlli.encode_text(text_buf);
}

void PacketUlDummy::decode_text(Text_Buf& text_buf)
{
field_tlli.decode_text(text_buf);
}

void PacketUlDummy::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketUlDummy::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketUlDummy::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketUlDummy_tlli_descr_.raw->forceomit);
  decoded_field_length = field_tlli.RAW_decode(PacketUlDummy_tlli_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketUlDummy::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketUlDummy_tlli_descr_.raw);
  encoded_length += field_tlli.RAW_encode(PacketUlDummy_tlli_descr_, *myleaf.body.node.nodes[0]);
  return myleaf.length = encoded_length;
}

struct PacketUlDummy_template::single_value_struct {
OCTETSTRING_template field_tlli;
};

void PacketUlDummy_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tlli = ANY_VALUE;
}
}
}

void PacketUlDummy_template::copy_value(const PacketUlDummy& other_value)
{
single_value = new single_value_struct;
if (other_value.tlli().is_bound()) {
  single_value->field_tlli = other_value.tlli();
} else {
  single_value->field_tlli.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketUlDummy_template::copy_template(const PacketUlDummy_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tlli().get_selection()) {
single_value->field_tlli = other_value.tlli();
} else {
single_value->field_tlli.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketUlDummy_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketUlDummy_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketUlDummy_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
break;
}
set_selection(other_value);
}

PacketUlDummy_template::PacketUlDummy_template()
{
}

PacketUlDummy_template::PacketUlDummy_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketUlDummy_template::PacketUlDummy_template(const PacketUlDummy& other_value)
{
copy_value(other_value);
}

PacketUlDummy_template::PacketUlDummy_template(const OPTIONAL<PacketUlDummy>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketUlDummy&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketUlDummy from an unbound optional field.");
}
}

PacketUlDummy_template::PacketUlDummy_template(PacketUlDummy_template* p_precondition, PacketUlDummy_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketUlDummy_template::PacketUlDummy_template(Dynamic_Match_Interface<PacketUlDummy>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketUlDummy>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketUlDummy_template::PacketUlDummy_template(const PacketUlDummy_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketUlDummy_template::~PacketUlDummy_template()
{
clean_up();
}

PacketUlDummy_template& PacketUlDummy_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketUlDummy_template& PacketUlDummy_template::operator=(const PacketUlDummy& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketUlDummy_template& PacketUlDummy_template::operator=(const OPTIONAL<PacketUlDummy>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketUlDummy&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
}
return *this;
}

PacketUlDummy_template& PacketUlDummy_template::operator=(const PacketUlDummy_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketUlDummy_template::match(const PacketUlDummy& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tlli().is_bound()) return FALSE;
if(!single_value->field_tlli.match(other_value.tlli(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
}
return FALSE;
}

boolean PacketUlDummy_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tlli.is_bound();
}

boolean PacketUlDummy_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tlli.is_value();
}

void PacketUlDummy_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketUlDummy PacketUlDummy_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
PacketUlDummy ret_val;
if (single_value->field_tlli.is_bound()) {
ret_val.tlli() = single_value->field_tlli.valueof();
}
return ret_val;
}

void PacketUlDummy_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketUlDummy_template[list_length];
}

PacketUlDummy_template& PacketUlDummy_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PacketUlDummy_template::tlli()
{
set_specific();
return single_value->field_tlli;
}

const OCTETSTRING_template& PacketUlDummy_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tlli of a non-specific template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
return single_value->field_tlli;
}

int PacketUlDummy_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketUlDummy containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
  }
  return 0;
}

void PacketUlDummy_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketUlDummy_template::log_match(const PacketUlDummy& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tlli.match(match_value.tlli(), legacy)){
TTCN_Logger::log_logmatch_info(".tlli");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketUlDummy_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tlli().is_bound()) tlli().set_implicit_omit();
}

void PacketUlDummy_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tlli.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
}
}

void PacketUlDummy_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tlli.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketUlDummy_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PacketUlDummy.");
}
}

void PacketUlDummy_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketUlDummy_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PacketUlDummy has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketUlDummy: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketUlDummy_template* precondition = new PacketUlDummy_template;
    precondition->set_param(*param.get_elem(0));
    PacketUlDummy_template* implied_template = new PacketUlDummy_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketUlDummy_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PacketUlDummy");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketUlDummy_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tlli.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketUlDummy");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketUlDummy");
}

boolean PacketUlDummy_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketUlDummy_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NCMeasurement::NCMeasurement()
{
}

NCMeasurement::NCMeasurement(const INTEGER& par_frequency__n,
    const BITSTRING& par_bsic__n__presence,
    const OPTIONAL< BITSTRING >& par_bsic__n,
    const INTEGER& par_rxlev__n)
  :   field_frequency__n(par_frequency__n),
  field_bsic__n__presence(par_bsic__n__presence),
  field_bsic__n(par_bsic__n),
  field_rxlev__n(par_rxlev__n)
{
}

NCMeasurement::NCMeasurement(const NCMeasurement& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurement.");
if (other_value.frequency__n().is_bound()) field_frequency__n = other_value.frequency__n();
else field_frequency__n.clean_up();
if (other_value.bsic__n__presence().is_bound()) field_bsic__n__presence = other_value.bsic__n__presence();
else field_bsic__n__presence.clean_up();
if (other_value.bsic__n().is_bound()) field_bsic__n = other_value.bsic__n();
else field_bsic__n.clean_up();
if (other_value.rxlev__n().is_bound()) field_rxlev__n = other_value.rxlev__n();
else field_rxlev__n.clean_up();
}

void NCMeasurement::clean_up()
{
field_frequency__n.clean_up();
field_bsic__n__presence.clean_up();
field_bsic__n.clean_up();
field_rxlev__n.clean_up();
}

const TTCN_Typedescriptor_t* NCMeasurement::get_descriptor() const { return &NCMeasurement_descr_; }
NCMeasurement& NCMeasurement::operator=(const NCMeasurement& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.NCMeasurement.");
  if (other_value.frequency__n().is_bound()) field_frequency__n = other_value.frequency__n();
  else field_frequency__n.clean_up();
  if (other_value.bsic__n__presence().is_bound()) field_bsic__n__presence = other_value.bsic__n__presence();
  else field_bsic__n__presence.clean_up();
  if (other_value.bsic__n().is_bound()) field_bsic__n = other_value.bsic__n();
  else field_bsic__n.clean_up();
  if (other_value.rxlev__n().is_bound()) field_rxlev__n = other_value.rxlev__n();
  else field_rxlev__n.clean_up();
}
return *this;
}

boolean NCMeasurement::operator==(const NCMeasurement& other_value) const
{
return field_frequency__n==other_value.field_frequency__n
  && field_bsic__n__presence==other_value.field_bsic__n__presence
  && field_bsic__n==other_value.field_bsic__n
  && field_rxlev__n==other_value.field_rxlev__n;
}

boolean NCMeasurement::is_bound() const
{
return (field_frequency__n.is_bound())
  || (field_bsic__n__presence.is_bound())
  || (OPTIONAL_OMIT == field_bsic__n.get_selection() || field_bsic__n.is_bound())
  || (field_rxlev__n.is_bound());
}
boolean NCMeasurement::is_value() const
{
return field_frequency__n.is_value()
  && field_bsic__n__presence.is_value()
  && (OPTIONAL_OMIT == field_bsic__n.get_selection() || field_bsic__n.is_value())
  && field_rxlev__n.is_value();
}
int NCMeasurement::size_of() const
{
  int ret_val = 3;
  if (field_bsic__n.ispresent()) ret_val++;
  return ret_val;
}

void NCMeasurement::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ frequency_n := ");
field_frequency__n.log();
TTCN_Logger::log_event_str(", bsic_n_presence := ");
field_bsic__n__presence.log();
TTCN_Logger::log_event_str(", bsic_n := ");
field_bsic__n.log();
TTCN_Logger::log_event_str(", rxlev_n := ");
field_rxlev__n.log();
TTCN_Logger::log_event_str(" }");
}

void NCMeasurement::set_implicit_omit()
{
if (frequency__n().is_bound()) frequency__n().set_implicit_omit();
if (bsic__n__presence().is_bound()) bsic__n__presence().set_implicit_omit();
if (!bsic__n().is_bound()) bsic__n() = OMIT_VALUE;
else bsic__n().set_implicit_omit();
if (rxlev__n().is_bound()) rxlev__n().set_implicit_omit();
}

void NCMeasurement::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.NCMeasurement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) frequency__n().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bsic__n__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bsic__n().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxlev__n().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "frequency_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          frequency__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_n_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__n__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.NCMeasurement");
  }
}

void NCMeasurement::encode_text(Text_Buf& text_buf) const
{
field_frequency__n.encode_text(text_buf);
field_bsic__n__presence.encode_text(text_buf);
field_bsic__n.encode_text(text_buf);
field_rxlev__n.encode_text(text_buf);
}

void NCMeasurement::decode_text(Text_Buf& text_buf)
{
field_frequency__n.decode_text(text_buf);
field_bsic__n__presence.decode_text(text_buf);
field_bsic__n.decode_text(text_buf);
field_rxlev__n.decode_text(text_buf);
}

void NCMeasurement::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurement::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurement::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, NCMeasurement_frequency__n_descr_.raw->forceomit);
  decoded_field_length = field_frequency__n.RAW_decode(NCMeasurement_frequency__n_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NCMeasurement_bsic__n__presence_descr_.raw->forceomit);
  decoded_field_length = field_bsic__n__presence.RAW_decode(NCMeasurement_bsic__n__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_bsic__n__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_bsic__n = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, NCMeasurement_bsic__n_descr_.raw->forceomit);
  decoded_field_length = field_bsic__n().RAW_decode(NCMeasurement_bsic__n_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_bsic__n = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bsic__n=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, NCMeasurement_rxlev__n_descr_.raw->forceomit);
  decoded_field_length = field_rxlev__n.RAW_decode(NCMeasurement_rxlev__n_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NCMeasurement::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, NCMeasurement_frequency__n_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NCMeasurement_bsic__n__presence_descr_.raw);
  if (field_bsic__n.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NCMeasurement_bsic__n_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, NCMeasurement_rxlev__n_descr_.raw);
  encoded_length += field_frequency__n.RAW_encode(NCMeasurement_frequency__n_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_bsic__n__presence.RAW_encode(NCMeasurement_bsic__n__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_bsic__n.ispresent()) {
  encoded_length += field_bsic__n().RAW_encode(NCMeasurement_bsic__n_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_rxlev__n.RAW_encode(NCMeasurement_rxlev__n_descr_, *myleaf.body.node.nodes[3]);
  if (field_bsic__n.ispresent() && (field_bsic__n__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(NCMeasurement_bsic__n__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct NCMeasurement_template::single_value_struct {
INTEGER_template field_frequency__n;
BITSTRING_template field_bsic__n__presence;
BITSTRING_template field_bsic__n;
INTEGER_template field_rxlev__n;
};

void NCMeasurement_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_frequency__n = ANY_VALUE;
single_value->field_bsic__n__presence = ANY_VALUE;
single_value->field_bsic__n = ANY_OR_OMIT;
single_value->field_rxlev__n = ANY_VALUE;
}
}
}

void NCMeasurement_template::copy_value(const NCMeasurement& other_value)
{
single_value = new single_value_struct;
if (other_value.frequency__n().is_bound()) {
  single_value->field_frequency__n = other_value.frequency__n();
} else {
  single_value->field_frequency__n.clean_up();
}
if (other_value.bsic__n__presence().is_bound()) {
  single_value->field_bsic__n__presence = other_value.bsic__n__presence();
} else {
  single_value->field_bsic__n__presence.clean_up();
}
if (other_value.bsic__n().is_bound()) {
  if (other_value.bsic__n().ispresent()) single_value->field_bsic__n = other_value.bsic__n()();
  else single_value->field_bsic__n = OMIT_VALUE;
} else {
  single_value->field_bsic__n.clean_up();
}
if (other_value.rxlev__n().is_bound()) {
  single_value->field_rxlev__n = other_value.rxlev__n();
} else {
  single_value->field_rxlev__n.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurement_template::copy_template(const NCMeasurement_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.frequency__n().get_selection()) {
single_value->field_frequency__n = other_value.frequency__n();
} else {
single_value->field_frequency__n.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bsic__n__presence().get_selection()) {
single_value->field_bsic__n__presence = other_value.bsic__n__presence();
} else {
single_value->field_bsic__n__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bsic__n().get_selection()) {
single_value->field_bsic__n = other_value.bsic__n();
} else {
single_value->field_bsic__n.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxlev__n().get_selection()) {
single_value->field_rxlev__n = other_value.rxlev__n();
} else {
single_value->field_rxlev__n.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurement_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurement_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurement.");
break;
}
set_selection(other_value);
}

NCMeasurement_template::NCMeasurement_template()
{
}

NCMeasurement_template::NCMeasurement_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurement_template::NCMeasurement_template(const NCMeasurement& other_value)
{
copy_value(other_value);
}

NCMeasurement_template::NCMeasurement_template(const OPTIONAL<NCMeasurement>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurement from an unbound optional field.");
}
}

NCMeasurement_template::NCMeasurement_template(NCMeasurement_template* p_precondition, NCMeasurement_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurement_template::NCMeasurement_template(Dynamic_Match_Interface<NCMeasurement>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurement>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurement_template::NCMeasurement_template(const NCMeasurement_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NCMeasurement_template::~NCMeasurement_template()
{
clean_up();
}

NCMeasurement_template& NCMeasurement_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurement_template& NCMeasurement_template::operator=(const NCMeasurement& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurement_template& NCMeasurement_template::operator=(const OPTIONAL<NCMeasurement>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurement.");
}
return *this;
}

NCMeasurement_template& NCMeasurement_template::operator=(const NCMeasurement_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NCMeasurement_template::match(const NCMeasurement& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.frequency__n().is_bound()) return FALSE;
if(!single_value->field_frequency__n.match(other_value.frequency__n(), legacy))return FALSE;
if(!other_value.bsic__n__presence().is_bound()) return FALSE;
if(!single_value->field_bsic__n__presence.match(other_value.bsic__n__presence(), legacy))return FALSE;
if(!other_value.bsic__n().is_bound()) return FALSE;
if((other_value.bsic__n().ispresent() ? !single_value->field_bsic__n.match((const BITSTRING&)other_value.bsic__n(), legacy) : !single_value->field_bsic__n.match_omit(legacy)))return FALSE;
if(!other_value.rxlev__n().is_bound()) return FALSE;
if(!single_value->field_rxlev__n.match(other_value.rxlev__n(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurement.");
}
return FALSE;
}

boolean NCMeasurement_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_frequency__n.is_bound()
 || single_value->field_bsic__n__presence.is_bound()
 || (single_value->field_bsic__n.is_omit() || single_value->field_bsic__n.is_bound())
 || single_value->field_rxlev__n.is_bound();
}

boolean NCMeasurement_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_frequency__n.is_value()
 && single_value->field_bsic__n__presence.is_value()
 && (single_value->field_bsic__n.is_omit() || single_value->field_bsic__n.is_value())
 && single_value->field_rxlev__n.is_value();
}

void NCMeasurement_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurement NCMeasurement_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurement.");
NCMeasurement ret_val;
if (single_value->field_frequency__n.is_bound()) {
ret_val.frequency__n() = single_value->field_frequency__n.valueof();
}
if (single_value->field_bsic__n__presence.is_bound()) {
ret_val.bsic__n__presence() = single_value->field_bsic__n__presence.valueof();
}
if (single_value->field_bsic__n.is_omit()) ret_val.bsic__n() = OMIT_VALUE;
else if (single_value->field_bsic__n.is_bound()) {
ret_val.bsic__n() = single_value->field_bsic__n.valueof();
}
if (single_value->field_rxlev__n.is_bound()) {
ret_val.rxlev__n() = single_value->field_rxlev__n.valueof();
}
return ret_val;
}

void NCMeasurement_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.NCMeasurement.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NCMeasurement_template[list_length];
}

NCMeasurement_template& NCMeasurement_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurement.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurement.");
return value_list.list_value[list_index];
}

INTEGER_template& NCMeasurement_template::frequency__n()
{
set_specific();
return single_value->field_frequency__n;
}

const INTEGER_template& NCMeasurement_template::frequency__n() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field frequency_n of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurement.");
return single_value->field_frequency__n;
}

BITSTRING_template& NCMeasurement_template::bsic__n__presence()
{
set_specific();
return single_value->field_bsic__n__presence;
}

const BITSTRING_template& NCMeasurement_template::bsic__n__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bsic_n_presence of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurement.");
return single_value->field_bsic__n__presence;
}

BITSTRING_template& NCMeasurement_template::bsic__n()
{
set_specific();
return single_value->field_bsic__n;
}

const BITSTRING_template& NCMeasurement_template::bsic__n() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bsic_n of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurement.");
return single_value->field_bsic__n;
}

INTEGER_template& NCMeasurement_template::rxlev__n()
{
set_specific();
return single_value->field_rxlev__n;
}

const INTEGER_template& NCMeasurement_template::rxlev__n() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxlev_n of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurement.");
return single_value->field_rxlev__n;
}

int NCMeasurement_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_bsic__n.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurement containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurement.");
  }
  return 0;
}

void NCMeasurement_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ frequency_n := ");
single_value->field_frequency__n.log();
TTCN_Logger::log_event_str(", bsic_n_presence := ");
single_value->field_bsic__n__presence.log();
TTCN_Logger::log_event_str(", bsic_n := ");
single_value->field_bsic__n.log();
TTCN_Logger::log_event_str(", rxlev_n := ");
single_value->field_rxlev__n.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NCMeasurement_template::log_match(const NCMeasurement& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_frequency__n.match(match_value.frequency__n(), legacy)){
TTCN_Logger::log_logmatch_info(".frequency_n");
single_value->field_frequency__n.log_match(match_value.frequency__n(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bsic__n__presence.match(match_value.bsic__n__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".bsic_n_presence");
single_value->field_bsic__n__presence.log_match(match_value.bsic__n__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.bsic__n().ispresent()){
if(!single_value->field_bsic__n.match(match_value.bsic__n(), legacy)){
TTCN_Logger::log_logmatch_info(".bsic_n");
single_value->field_bsic__n.log_match(match_value.bsic__n(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bsic__n.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bsic_n := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bsic__n.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_rxlev__n.match(match_value.rxlev__n(), legacy)){
TTCN_Logger::log_logmatch_info(".rxlev_n");
single_value->field_rxlev__n.log_match(match_value.rxlev__n(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ frequency_n := ");
single_value->field_frequency__n.log_match(match_value.frequency__n(), legacy);
TTCN_Logger::log_event_str(", bsic_n_presence := ");
single_value->field_bsic__n__presence.log_match(match_value.bsic__n__presence(), legacy);
TTCN_Logger::log_event_str(", bsic_n := ");
if (match_value.bsic__n().ispresent()) {
single_value->field_bsic__n.log_match(match_value.bsic__n(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bsic__n.log();
if (single_value->field_bsic__n.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rxlev_n := ");
single_value->field_rxlev__n.log_match(match_value.rxlev__n(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurement_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (frequency__n().is_bound()) frequency__n().set_implicit_omit();
if (bsic__n__presence().is_bound()) bsic__n__presence().set_implicit_omit();
if (!bsic__n().is_bound()) bsic__n() = OMIT_VALUE;
else bsic__n().set_implicit_omit();
if (rxlev__n().is_bound()) rxlev__n().set_implicit_omit();
}

void NCMeasurement_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_frequency__n.encode_text(text_buf);
single_value->field_bsic__n__presence.encode_text(text_buf);
single_value->field_bsic__n.encode_text(text_buf);
single_value->field_rxlev__n.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurement.");
}
}

void NCMeasurement_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_frequency__n.decode_text(text_buf);
single_value->field_bsic__n__presence.decode_text(text_buf);
single_value->field_bsic__n.decode_text(text_buf);
single_value->field_rxlev__n.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.NCMeasurement.");
}
}

void NCMeasurement_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurement_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.NCMeasurement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) frequency__n().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bsic__n__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bsic__n().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxlev__n().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "frequency_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          frequency__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_n_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__n__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_n")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__n().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurement_template* precondition = new NCMeasurement_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurement_template* implied_template = new NCMeasurement_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurement_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.NCMeasurement");
  }
  is_ifpresent = param.get_ifpresent();
}

void NCMeasurement_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_frequency__n.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurement");
single_value->field_bsic__n__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurement");
single_value->field_bsic__n.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurement");
single_value->field_rxlev__n.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurement");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurement");
}

boolean NCMeasurement_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurement_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const NCMeasurement NCMeasurementList::UNBOUND_ELEM;
NCMeasurementList::NCMeasurementList()
{
val_ptr = NULL;
}

NCMeasurementList::NCMeasurementList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

NCMeasurementList::NCMeasurementList(const NCMeasurementList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

NCMeasurementList::~NCMeasurementList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void NCMeasurementList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

NCMeasurementList& NCMeasurementList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

NCMeasurementList& NCMeasurementList::operator=(const NCMeasurementList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean NCMeasurementList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return val_ptr->n_elements == 0 ;
}

boolean NCMeasurementList::operator==(const NCMeasurementList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

NCMeasurement& NCMeasurementList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.NCMeasurementList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (NCMeasurement**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new NCMeasurement(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new NCMeasurement;
}
return *val_ptr->value_elements[index_value];
}

NCMeasurement& NCMeasurementList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return (*this)[(int)index_value];
}

const NCMeasurement& NCMeasurementList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.NCMeasurementList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RLCMAC_CSN1_Types.NCMeasurementList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const NCMeasurement& NCMeasurementList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return (*this)[(int)index_value];
}

NCMeasurementList NCMeasurementList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

NCMeasurementList NCMeasurementList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

NCMeasurementList NCMeasurementList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

NCMeasurementList NCMeasurementList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
NCMeasurementList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new NCMeasurement(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

NCMeasurementList NCMeasurementList::operator+(const NCMeasurementList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RLCMAC_CSN1_Types.NCMeasurementList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
NCMeasurementList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurement(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new NCMeasurement(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

NCMeasurementList NCMeasurementList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RLCMAC_CSN1_Types.NCMeasurementList","element");
NCMeasurementList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurement(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

NCMeasurementList NCMeasurementList::replace(int index, int len, const NCMeasurementList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RLCMAC_CSN1_Types.NCMeasurementList","element");
NCMeasurementList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurement(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new NCMeasurement(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new NCMeasurement(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

NCMeasurementList NCMeasurementList::replace(int index, int len, const NCMeasurementList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void NCMeasurementList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (NCMeasurement**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new NCMeasurement(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (NCMeasurement**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RLCMAC_CSN1_Types.NCMeasurementList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (NCMeasurement**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean NCMeasurementList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int NCMeasurementList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return val_ptr->n_elements;
}

int NCMeasurementList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void NCMeasurementList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void NCMeasurementList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void NCMeasurementList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.NCMeasurementList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.NCMeasurementList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void NCMeasurementList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void NCMeasurementList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RLCMAC_CSN1_Types.NCMeasurementList.");
val_ptr->value_elements = (NCMeasurement**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new NCMeasurement;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void NCMeasurementList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurementList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurementList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int NCMeasurementList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void NCMeasurementList_template::copy_value(const NCMeasurementList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RLCMAC_CSN1_Types.NCMeasurementList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (NCMeasurement_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new NCMeasurement_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new NCMeasurement_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurementList_template::copy_template(const NCMeasurementList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (NCMeasurement_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new NCMeasurement_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new NCMeasurement_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurementList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurementList_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurementList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
break;
}
set_selection(other_value);
}

boolean NCMeasurementList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const NCMeasurementList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const NCMeasurementList*)value_ptr)[value_index], legacy);
else return ((const NCMeasurementList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

NCMeasurementList_template::NCMeasurementList_template()
{
}

NCMeasurementList_template::NCMeasurementList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurementList_template::NCMeasurementList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

NCMeasurementList_template::NCMeasurementList_template(const NCMeasurementList& other_value)
{
copy_value(other_value);
}

NCMeasurementList_template::NCMeasurementList_template(const OPTIONAL<NCMeasurementList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurementList from an unbound optional field.");
}
}

NCMeasurementList_template::NCMeasurementList_template(NCMeasurementList_template* p_precondition, NCMeasurementList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurementList_template::NCMeasurementList_template(Dynamic_Match_Interface<NCMeasurementList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurementList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurementList_template::NCMeasurementList_template(const NCMeasurementList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

NCMeasurementList_template::~NCMeasurementList_template()
{
clean_up();
}

void NCMeasurementList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurementList_template& NCMeasurementList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurementList_template& NCMeasurementList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

NCMeasurementList_template& NCMeasurementList_template::operator=(const NCMeasurementList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurementList_template& NCMeasurementList_template::operator=(const OPTIONAL<NCMeasurementList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
}
return *this;
}

NCMeasurementList_template& NCMeasurementList_template::operator=(const NCMeasurementList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

NCMeasurement_template& NCMeasurementList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.NCMeasurementList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.NCMeasurementList.");
    break;
}
return *single_value.value_elements[index_value];
}

NCMeasurement_template& NCMeasurementList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return (*this)[(int)index_value];
}

const NCMeasurement_template& NCMeasurementList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.NCMeasurementList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RLCMAC_CSN1_Types.NCMeasurementList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const NCMeasurement_template& NCMeasurementList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return (*this)[(int)index_value];
}

void NCMeasurementList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (NCMeasurement_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new NCMeasurement_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new NCMeasurement_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (NCMeasurement_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int NCMeasurementList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int NCMeasurementList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RLCMAC_CSN1_Types.NCMeasurementList");
}

boolean NCMeasurementList_template::match(const NCMeasurementList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
}
return FALSE;
}

boolean NCMeasurementList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

NCMeasurementList NCMeasurementList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
NCMeasurementList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

NCMeasurementList NCMeasurementList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

NCMeasurementList NCMeasurementList_template::replace(int index, int len, const NCMeasurementList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

NCMeasurementList NCMeasurementList_template::replace(int index, int len, const NCMeasurementList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void NCMeasurementList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new NCMeasurementList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
}
set_selection(template_type);
}

NCMeasurementList_template& NCMeasurementList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
return value_list.list_value[list_index];
}

void NCMeasurementList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void NCMeasurementList_template::log_match(const NCMeasurementList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurementList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
}
}

void NCMeasurementList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
single_value.value_elements = (NCMeasurement_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new NCMeasurement_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurementList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RLCMAC_CSN1_Types.NCMeasurementList.");
}
}

boolean NCMeasurementList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurementList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void NCMeasurementList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void NCMeasurementList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurementList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurementList_template* precondition = new NCMeasurementList_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurementList_template* implied_template = new NCMeasurementList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurementList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RLCMAC_CSN1_Types.NCMeasurementList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void NCMeasurementList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementList");
}

boolean NCMeasurementList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
NCMeasurementReport::NCMeasurementReport()
{
}

NCMeasurementReport::NCMeasurementReport(const BITSTRING& par_nc__mode,
    const INTEGER& par_rxlev__serving__cell,
    const BITSTRING& par_zero,
    const INTEGER& par_num__nc__measurements,
    const NCMeasurementList& par_nm__measurements)
  :   field_nc__mode(par_nc__mode),
  field_rxlev__serving__cell(par_rxlev__serving__cell),
  field_zero(par_zero),
  field_num__nc__measurements(par_num__nc__measurements),
  field_nm__measurements(par_nm__measurements)
{
}

NCMeasurementReport::NCMeasurementReport(const NCMeasurementReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
if (other_value.nc__mode().is_bound()) field_nc__mode = other_value.nc__mode();
else field_nc__mode.clean_up();
if (other_value.rxlev__serving__cell().is_bound()) field_rxlev__serving__cell = other_value.rxlev__serving__cell();
else field_rxlev__serving__cell.clean_up();
if (other_value.zero().is_bound()) field_zero = other_value.zero();
else field_zero.clean_up();
if (other_value.num__nc__measurements().is_bound()) field_num__nc__measurements = other_value.num__nc__measurements();
else field_num__nc__measurements.clean_up();
if (other_value.nm__measurements().is_bound()) field_nm__measurements = other_value.nm__measurements();
else field_nm__measurements.clean_up();
}

void NCMeasurementReport::clean_up()
{
field_nc__mode.clean_up();
field_rxlev__serving__cell.clean_up();
field_zero.clean_up();
field_num__nc__measurements.clean_up();
field_nm__measurements.clean_up();
}

const TTCN_Typedescriptor_t* NCMeasurementReport::get_descriptor() const { return &NCMeasurementReport_descr_; }
NCMeasurementReport& NCMeasurementReport::operator=(const NCMeasurementReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
  if (other_value.nc__mode().is_bound()) field_nc__mode = other_value.nc__mode();
  else field_nc__mode.clean_up();
  if (other_value.rxlev__serving__cell().is_bound()) field_rxlev__serving__cell = other_value.rxlev__serving__cell();
  else field_rxlev__serving__cell.clean_up();
  if (other_value.zero().is_bound()) field_zero = other_value.zero();
  else field_zero.clean_up();
  if (other_value.num__nc__measurements().is_bound()) field_num__nc__measurements = other_value.num__nc__measurements();
  else field_num__nc__measurements.clean_up();
  if (other_value.nm__measurements().is_bound()) field_nm__measurements = other_value.nm__measurements();
  else field_nm__measurements.clean_up();
}
return *this;
}

boolean NCMeasurementReport::operator==(const NCMeasurementReport& other_value) const
{
return field_nc__mode==other_value.field_nc__mode
  && field_rxlev__serving__cell==other_value.field_rxlev__serving__cell
  && field_zero==other_value.field_zero
  && field_num__nc__measurements==other_value.field_num__nc__measurements
  && field_nm__measurements==other_value.field_nm__measurements;
}

boolean NCMeasurementReport::is_bound() const
{
return (field_nc__mode.is_bound())
  || (field_rxlev__serving__cell.is_bound())
  || (field_zero.is_bound())
  || (field_num__nc__measurements.is_bound())
  || (field_nm__measurements.is_bound());
}
boolean NCMeasurementReport::is_value() const
{
return field_nc__mode.is_value()
  && field_rxlev__serving__cell.is_value()
  && field_zero.is_value()
  && field_num__nc__measurements.is_value()
  && field_nm__measurements.is_value();
}
void NCMeasurementReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ nc_mode := ");
field_nc__mode.log();
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
field_rxlev__serving__cell.log();
TTCN_Logger::log_event_str(", zero := ");
field_zero.log();
TTCN_Logger::log_event_str(", num_nc_measurements := ");
field_num__nc__measurements.log();
TTCN_Logger::log_event_str(", nm_measurements := ");
field_nm__measurements.log();
TTCN_Logger::log_event_str(" }");
}

void NCMeasurementReport::set_implicit_omit()
{
if (nc__mode().is_bound()) nc__mode().set_implicit_omit();
if (rxlev__serving__cell().is_bound()) rxlev__serving__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__nc__measurements().is_bound()) num__nc__measurements().set_implicit_omit();
if (nm__measurements().is_bound()) nm__measurements().set_implicit_omit();
}

void NCMeasurementReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.NCMeasurementReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) nc__mode().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rxlev__serving__cell().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) num__nc__measurements().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nm__measurements().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_serving_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__serving__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_nc_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__nc__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nm_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nm__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.NCMeasurementReport");
  }
}

void NCMeasurementReport::encode_text(Text_Buf& text_buf) const
{
field_nc__mode.encode_text(text_buf);
field_rxlev__serving__cell.encode_text(text_buf);
field_zero.encode_text(text_buf);
field_num__nc__measurements.encode_text(text_buf);
field_nm__measurements.encode_text(text_buf);
}

void NCMeasurementReport::decode_text(Text_Buf& text_buf)
{
field_nc__mode.decode_text(text_buf);
field_rxlev__serving__cell.decode_text(text_buf);
field_zero.decode_text(text_buf);
field_num__nc__measurements.decode_text(text_buf);
field_nm__measurements.decode_text(text_buf);
}

void NCMeasurementReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurementReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurementReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field3 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, NCMeasurementReport_nc__mode_descr_.raw->forceomit);
  decoded_field_length = field_nc__mode.RAW_decode(NCMeasurementReport_nc__mode_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NCMeasurementReport_rxlev__serving__cell_descr_.raw->forceomit);
  decoded_field_length = field_rxlev__serving__cell.RAW_decode(NCMeasurementReport_rxlev__serving__cell_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, NCMeasurementReport_zero_descr_.raw->forceomit);
  decoded_field_length = field_zero.RAW_decode(NCMeasurementReport_zero_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, NCMeasurementReport_num__nc__measurements_descr_.raw->forceomit);
  decoded_field_length = field_num__nc__measurements.RAW_decode(NCMeasurementReport_num__nc__measurements_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp3 = field_num__nc__measurements.convert_to_Integer(NCMeasurementReport_num__nc__measurements_descr_);
  field_num__nc__measurements = tmp3;
  value_of_length_field3 += tmp3.get_long_long_val() * 1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, NCMeasurementReport_nm__measurements_descr_.raw->forceomit);
  decoded_field_length = field_nm__measurements.RAW_decode(NCMeasurementReport_nm__measurements_descr_, p_buf, limit, local_top_order, no_err, value_of_length_field3, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NCMeasurementReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, NCMeasurementReport_nc__mode_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NCMeasurementReport_rxlev__serving__cell_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NCMeasurementReport_zero_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, NCMeasurementReport_num__nc__measurements_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, NCMeasurementReport_nm__measurements_descr_.raw);
  encoded_length += field_nc__mode.RAW_encode(NCMeasurementReport_nc__mode_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_rxlev__serving__cell.RAW_encode(NCMeasurementReport_rxlev__serving__cell_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_zero.RAW_encode(NCMeasurementReport_zero_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 3;
  myleaf.body.node.nodes[3]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[3]->coding_descr = &NCMeasurementReport_num__nc__measurements_descr_;
  myleaf.body.node.nodes[3]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[3]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[3]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[3]->length = 3;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_nm__measurements.RAW_encode(NCMeasurementReport_nm__measurements_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct NCMeasurementReport_template::single_value_struct {
BITSTRING_template field_nc__mode;
INTEGER_template field_rxlev__serving__cell;
BITSTRING_template field_zero;
INTEGER_template field_num__nc__measurements;
NCMeasurementList_template field_nm__measurements;
};

void NCMeasurementReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_nc__mode = ANY_VALUE;
single_value->field_rxlev__serving__cell = ANY_VALUE;
single_value->field_zero = ANY_VALUE;
single_value->field_num__nc__measurements = ANY_VALUE;
single_value->field_nm__measurements = ANY_VALUE;
}
}
}

void NCMeasurementReport_template::copy_value(const NCMeasurementReport& other_value)
{
single_value = new single_value_struct;
if (other_value.nc__mode().is_bound()) {
  single_value->field_nc__mode = other_value.nc__mode();
} else {
  single_value->field_nc__mode.clean_up();
}
if (other_value.rxlev__serving__cell().is_bound()) {
  single_value->field_rxlev__serving__cell = other_value.rxlev__serving__cell();
} else {
  single_value->field_rxlev__serving__cell.clean_up();
}
if (other_value.zero().is_bound()) {
  single_value->field_zero = other_value.zero();
} else {
  single_value->field_zero.clean_up();
}
if (other_value.num__nc__measurements().is_bound()) {
  single_value->field_num__nc__measurements = other_value.num__nc__measurements();
} else {
  single_value->field_num__nc__measurements.clean_up();
}
if (other_value.nm__measurements().is_bound()) {
  single_value->field_nm__measurements = other_value.nm__measurements();
} else {
  single_value->field_nm__measurements.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurementReport_template::copy_template(const NCMeasurementReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.nc__mode().get_selection()) {
single_value->field_nc__mode = other_value.nc__mode();
} else {
single_value->field_nc__mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxlev__serving__cell().get_selection()) {
single_value->field_rxlev__serving__cell = other_value.rxlev__serving__cell();
} else {
single_value->field_rxlev__serving__cell.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.zero().get_selection()) {
single_value->field_zero = other_value.zero();
} else {
single_value->field_zero.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.num__nc__measurements().get_selection()) {
single_value->field_num__nc__measurements = other_value.num__nc__measurements();
} else {
single_value->field_num__nc__measurements.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nm__measurements().get_selection()) {
single_value->field_nm__measurements = other_value.nm__measurements();
} else {
single_value->field_nm__measurements.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurementReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurementReport_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurementReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
break;
}
set_selection(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template()
{
}

NCMeasurementReport_template::NCMeasurementReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template(const NCMeasurementReport& other_value)
{
copy_value(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template(const OPTIONAL<NCMeasurementReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurementReport from an unbound optional field.");
}
}

NCMeasurementReport_template::NCMeasurementReport_template(NCMeasurementReport_template* p_precondition, NCMeasurementReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurementReport_template::NCMeasurementReport_template(Dynamic_Match_Interface<NCMeasurementReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurementReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurementReport_template::NCMeasurementReport_template(const NCMeasurementReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NCMeasurementReport_template::~NCMeasurementReport_template()
{
clean_up();
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const NCMeasurementReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const OPTIONAL<NCMeasurementReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const NCMeasurementReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NCMeasurementReport_template::match(const NCMeasurementReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.nc__mode().is_bound()) return FALSE;
if(!single_value->field_nc__mode.match(other_value.nc__mode(), legacy))return FALSE;
if(!other_value.rxlev__serving__cell().is_bound()) return FALSE;
if(!single_value->field_rxlev__serving__cell.match(other_value.rxlev__serving__cell(), legacy))return FALSE;
if(!other_value.zero().is_bound()) return FALSE;
if(!single_value->field_zero.match(other_value.zero(), legacy))return FALSE;
if(!other_value.num__nc__measurements().is_bound()) return FALSE;
if(!single_value->field_num__nc__measurements.match(other_value.num__nc__measurements(), legacy))return FALSE;
if(!other_value.nm__measurements().is_bound()) return FALSE;
if(!single_value->field_nm__measurements.match(other_value.nm__measurements(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
return FALSE;
}

boolean NCMeasurementReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_nc__mode.is_bound()
 || single_value->field_rxlev__serving__cell.is_bound()
 || single_value->field_zero.is_bound()
 || single_value->field_num__nc__measurements.is_bound()
 || single_value->field_nm__measurements.is_bound();
}

boolean NCMeasurementReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_nc__mode.is_value()
 && single_value->field_rxlev__serving__cell.is_value()
 && single_value->field_zero.is_value()
 && single_value->field_num__nc__measurements.is_value()
 && single_value->field_nm__measurements.is_value();
}

void NCMeasurementReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurementReport NCMeasurementReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
NCMeasurementReport ret_val;
if (single_value->field_nc__mode.is_bound()) {
ret_val.nc__mode() = single_value->field_nc__mode.valueof();
}
if (single_value->field_rxlev__serving__cell.is_bound()) {
ret_val.rxlev__serving__cell() = single_value->field_rxlev__serving__cell.valueof();
}
if (single_value->field_zero.is_bound()) {
ret_val.zero() = single_value->field_zero.valueof();
}
if (single_value->field_num__nc__measurements.is_bound()) {
ret_val.num__nc__measurements() = single_value->field_num__nc__measurements.valueof();
}
if (single_value->field_nm__measurements.is_bound()) {
ret_val.nm__measurements() = single_value->field_nm__measurements.valueof();
}
return ret_val;
}

void NCMeasurementReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NCMeasurementReport_template[list_length];
}

NCMeasurementReport_template& NCMeasurementReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return value_list.list_value[list_index];
}

BITSTRING_template& NCMeasurementReport_template::nc__mode()
{
set_specific();
return single_value->field_nc__mode;
}

const BITSTRING_template& NCMeasurementReport_template::nc__mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nc_mode of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_nc__mode;
}

INTEGER_template& NCMeasurementReport_template::rxlev__serving__cell()
{
set_specific();
return single_value->field_rxlev__serving__cell;
}

const INTEGER_template& NCMeasurementReport_template::rxlev__serving__cell() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxlev_serving_cell of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_rxlev__serving__cell;
}

BITSTRING_template& NCMeasurementReport_template::zero()
{
set_specific();
return single_value->field_zero;
}

const BITSTRING_template& NCMeasurementReport_template::zero() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field zero of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_zero;
}

INTEGER_template& NCMeasurementReport_template::num__nc__measurements()
{
set_specific();
return single_value->field_num__nc__measurements;
}

const INTEGER_template& NCMeasurementReport_template::num__nc__measurements() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field num_nc_measurements of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_num__nc__measurements;
}

NCMeasurementList_template& NCMeasurementReport_template::nm__measurements()
{
set_specific();
return single_value->field_nm__measurements;
}

const NCMeasurementList_template& NCMeasurementReport_template::nm__measurements() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nm_measurements of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_nm__measurements;
}

int NCMeasurementReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
  }
  return 0;
}

void NCMeasurementReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ nc_mode := ");
single_value->field_nc__mode.log();
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
single_value->field_rxlev__serving__cell.log();
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log();
TTCN_Logger::log_event_str(", num_nc_measurements := ");
single_value->field_num__nc__measurements.log();
TTCN_Logger::log_event_str(", nm_measurements := ");
single_value->field_nm__measurements.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NCMeasurementReport_template::log_match(const NCMeasurementReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_nc__mode.match(match_value.nc__mode(), legacy)){
TTCN_Logger::log_logmatch_info(".nc_mode");
single_value->field_nc__mode.log_match(match_value.nc__mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxlev__serving__cell.match(match_value.rxlev__serving__cell(), legacy)){
TTCN_Logger::log_logmatch_info(".rxlev_serving_cell");
single_value->field_rxlev__serving__cell.log_match(match_value.rxlev__serving__cell(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_zero.match(match_value.zero(), legacy)){
TTCN_Logger::log_logmatch_info(".zero");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_num__nc__measurements.match(match_value.num__nc__measurements(), legacy)){
TTCN_Logger::log_logmatch_info(".num_nc_measurements");
single_value->field_num__nc__measurements.log_match(match_value.num__nc__measurements(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nm__measurements.match(match_value.nm__measurements(), legacy)){
TTCN_Logger::log_logmatch_info(".nm_measurements");
single_value->field_nm__measurements.log_match(match_value.nm__measurements(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ nc_mode := ");
single_value->field_nc__mode.log_match(match_value.nc__mode(), legacy);
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
single_value->field_rxlev__serving__cell.log_match(match_value.rxlev__serving__cell(), legacy);
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::log_event_str(", num_nc_measurements := ");
single_value->field_num__nc__measurements.log_match(match_value.num__nc__measurements(), legacy);
TTCN_Logger::log_event_str(", nm_measurements := ");
single_value->field_nm__measurements.log_match(match_value.nm__measurements(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurementReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (nc__mode().is_bound()) nc__mode().set_implicit_omit();
if (rxlev__serving__cell().is_bound()) rxlev__serving__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__nc__measurements().is_bound()) num__nc__measurements().set_implicit_omit();
if (nm__measurements().is_bound()) nm__measurements().set_implicit_omit();
}

void NCMeasurementReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_nc__mode.encode_text(text_buf);
single_value->field_rxlev__serving__cell.encode_text(text_buf);
single_value->field_zero.encode_text(text_buf);
single_value->field_num__nc__measurements.encode_text(text_buf);
single_value->field_nm__measurements.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
}

void NCMeasurementReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_nc__mode.decode_text(text_buf);
single_value->field_rxlev__serving__cell.decode_text(text_buf);
single_value->field_zero.decode_text(text_buf);
single_value->field_num__nc__measurements.decode_text(text_buf);
single_value->field_nm__measurements.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurementReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
}

void NCMeasurementReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurementReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.NCMeasurementReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) nc__mode().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rxlev__serving__cell().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) num__nc__measurements().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nm__measurements().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_serving_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__serving__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_nc_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__nc__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nm_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nm__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurementReport_template* precondition = new NCMeasurementReport_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurementReport_template* implied_template = new NCMeasurementReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurementReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.NCMeasurementReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void NCMeasurementReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_nc__mode.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_rxlev__serving__cell.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_zero.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_num__nc__measurements.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_nm__measurements.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
}

boolean NCMeasurementReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurementReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketMeasReport::PacketMeasReport()
{
}

PacketMeasReport::PacketMeasReport(const OCTETSTRING& par_tlli,
    const BITSTRING& par_psi5__change__mark__presence,
    const OPTIONAL< BITSTRING >& par_psi5__change__mark,
    const BITSTRING& par_additions__99,
    const OPTIONAL< NCMeasurementReport >& par_nc__meas__report)
  :   field_tlli(par_tlli),
  field_psi5__change__mark__presence(par_psi5__change__mark__presence),
  field_psi5__change__mark(par_psi5__change__mark),
  field_additions__99(par_additions__99),
  field_nc__meas__report(par_nc__meas__report)
{
}

PacketMeasReport::PacketMeasReport(const PacketMeasReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketMeasReport.");
if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
else field_tlli.clean_up();
if (other_value.psi5__change__mark__presence().is_bound()) field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
else field_psi5__change__mark__presence.clean_up();
if (other_value.psi5__change__mark().is_bound()) field_psi5__change__mark = other_value.psi5__change__mark();
else field_psi5__change__mark.clean_up();
if (other_value.additions__99().is_bound()) field_additions__99 = other_value.additions__99();
else field_additions__99.clean_up();
if (other_value.nc__meas__report().is_bound()) field_nc__meas__report = other_value.nc__meas__report();
else field_nc__meas__report.clean_up();
}

void PacketMeasReport::clean_up()
{
field_tlli.clean_up();
field_psi5__change__mark__presence.clean_up();
field_psi5__change__mark.clean_up();
field_additions__99.clean_up();
field_nc__meas__report.clean_up();
}

const TTCN_Typedescriptor_t* PacketMeasReport::get_descriptor() const { return &PacketMeasReport_descr_; }
PacketMeasReport& PacketMeasReport::operator=(const PacketMeasReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketMeasReport.");
  if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
  else field_tlli.clean_up();
  if (other_value.psi5__change__mark__presence().is_bound()) field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
  else field_psi5__change__mark__presence.clean_up();
  if (other_value.psi5__change__mark().is_bound()) field_psi5__change__mark = other_value.psi5__change__mark();
  else field_psi5__change__mark.clean_up();
  if (other_value.additions__99().is_bound()) field_additions__99 = other_value.additions__99();
  else field_additions__99.clean_up();
  if (other_value.nc__meas__report().is_bound()) field_nc__meas__report = other_value.nc__meas__report();
  else field_nc__meas__report.clean_up();
}
return *this;
}

boolean PacketMeasReport::operator==(const PacketMeasReport& other_value) const
{
return field_tlli==other_value.field_tlli
  && field_psi5__change__mark__presence==other_value.field_psi5__change__mark__presence
  && field_psi5__change__mark==other_value.field_psi5__change__mark
  && field_additions__99==other_value.field_additions__99
  && field_nc__meas__report==other_value.field_nc__meas__report;
}

boolean PacketMeasReport::is_bound() const
{
return (field_tlli.is_bound())
  || (field_psi5__change__mark__presence.is_bound())
  || (OPTIONAL_OMIT == field_psi5__change__mark.get_selection() || field_psi5__change__mark.is_bound())
  || (field_additions__99.is_bound())
  || (OPTIONAL_OMIT == field_nc__meas__report.get_selection() || field_nc__meas__report.is_bound());
}
boolean PacketMeasReport::is_value() const
{
return field_tlli.is_value()
  && field_psi5__change__mark__presence.is_value()
  && (OPTIONAL_OMIT == field_psi5__change__mark.get_selection() || field_psi5__change__mark.is_value())
  && field_additions__99.is_value()
  && (OPTIONAL_OMIT == field_nc__meas__report.get_selection() || field_nc__meas__report.is_value());
}
int PacketMeasReport::size_of() const
{
  int ret_val = 3;
  if (field_psi5__change__mark.ispresent()) ret_val++;
  if (field_nc__meas__report.ispresent()) ret_val++;
  return ret_val;
}

void PacketMeasReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli.log();
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
field_psi5__change__mark__presence.log();
TTCN_Logger::log_event_str(", psi5_change_mark := ");
field_psi5__change__mark.log();
TTCN_Logger::log_event_str(", additions_99 := ");
field_additions__99.log();
TTCN_Logger::log_event_str(", nc_meas_report := ");
field_nc__meas__report.log();
TTCN_Logger::log_event_str(" }");
}

void PacketMeasReport::set_implicit_omit()
{
if (tlli().is_bound()) tlli().set_implicit_omit();
if (psi5__change__mark__presence().is_bound()) psi5__change__mark__presence().set_implicit_omit();
if (!psi5__change__mark().is_bound()) psi5__change__mark() = OMIT_VALUE;
else psi5__change__mark().set_implicit_omit();
if (additions__99().is_bound()) additions__99().set_implicit_omit();
if (!nc__meas__report().is_bound()) nc__meas__report() = OMIT_VALUE;
else nc__meas__report().set_implicit_omit();
}

void PacketMeasReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketMeasReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) additions__99().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nc__meas__report().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additions_99")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additions__99().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_meas_report")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__meas__report().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketMeasReport");
  }
}

void PacketMeasReport::encode_text(Text_Buf& text_buf) const
{
field_tlli.encode_text(text_buf);
field_psi5__change__mark__presence.encode_text(text_buf);
field_psi5__change__mark.encode_text(text_buf);
field_additions__99.encode_text(text_buf);
field_nc__meas__report.encode_text(text_buf);
}

void PacketMeasReport::decode_text(Text_Buf& text_buf)
{
field_tlli.decode_text(text_buf);
field_psi5__change__mark__presence.decode_text(text_buf);
field_psi5__change__mark.decode_text(text_buf);
field_additions__99.decode_text(text_buf);
field_nc__meas__report.decode_text(text_buf);
}

void PacketMeasReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketMeasReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketMeasReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketMeasReport_tlli_descr_.raw->forceomit);
  decoded_field_length = field_tlli.RAW_decode(PacketMeasReport_tlli_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketMeasReport_psi5__change__mark__presence_descr_.raw->forceomit);
  decoded_field_length = field_psi5__change__mark__presence.RAW_decode(PacketMeasReport_psi5__change__mark__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_psi5__change__mark__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_psi5__change__mark = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketMeasReport_psi5__change__mark_descr_.raw->forceomit);
  decoded_field_length = field_psi5__change__mark().RAW_decode(PacketMeasReport_psi5__change__mark_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_psi5__change__mark = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_psi5__change__mark=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PacketMeasReport_additions__99_descr_.raw->forceomit);
  decoded_field_length = field_additions__99.RAW_decode(PacketMeasReport_additions__99_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_additions__99 ==  bs_1){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_nc__meas__report = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PacketMeasReport_nc__meas__report_descr_.raw->forceomit);
  decoded_field_length = field_nc__meas__report().RAW_decode(PacketMeasReport_nc__meas__report_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_nc__meas__report = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nc__meas__report=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketMeasReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketMeasReport_tlli_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketMeasReport_psi5__change__mark__presence_descr_.raw);
  if (field_psi5__change__mark.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketMeasReport_psi5__change__mark_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PacketMeasReport_additions__99_descr_.raw);
  if (field_nc__meas__report.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PacketMeasReport_nc__meas__report_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_tlli.RAW_encode(PacketMeasReport_tlli_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_psi5__change__mark__presence.RAW_encode(PacketMeasReport_psi5__change__mark__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_psi5__change__mark.ispresent()) {
  encoded_length += field_psi5__change__mark().RAW_encode(PacketMeasReport_psi5__change__mark_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_additions__99.RAW_encode(PacketMeasReport_additions__99_descr_, *myleaf.body.node.nodes[3]);
  if (field_nc__meas__report.ispresent()) {
  encoded_length += field_nc__meas__report().RAW_encode(PacketMeasReport_nc__meas__report_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_psi5__change__mark.ispresent() && (field_psi5__change__mark__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketMeasReport_psi5__change__mark__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_nc__meas__report.ispresent() && (field_additions__99 !=  bs_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(PacketMeasReport_additions__99_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PacketMeasReport_template::single_value_struct {
OCTETSTRING_template field_tlli;
BITSTRING_template field_psi5__change__mark__presence;
BITSTRING_template field_psi5__change__mark;
BITSTRING_template field_additions__99;
NCMeasurementReport_template field_nc__meas__report;
};

void PacketMeasReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tlli = ANY_VALUE;
single_value->field_psi5__change__mark__presence = ANY_VALUE;
single_value->field_psi5__change__mark = ANY_OR_OMIT;
single_value->field_additions__99 = ANY_VALUE;
single_value->field_nc__meas__report = ANY_OR_OMIT;
}
}
}

void PacketMeasReport_template::copy_value(const PacketMeasReport& other_value)
{
single_value = new single_value_struct;
if (other_value.tlli().is_bound()) {
  single_value->field_tlli = other_value.tlli();
} else {
  single_value->field_tlli.clean_up();
}
if (other_value.psi5__change__mark__presence().is_bound()) {
  single_value->field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
} else {
  single_value->field_psi5__change__mark__presence.clean_up();
}
if (other_value.psi5__change__mark().is_bound()) {
  if (other_value.psi5__change__mark().ispresent()) single_value->field_psi5__change__mark = other_value.psi5__change__mark()();
  else single_value->field_psi5__change__mark = OMIT_VALUE;
} else {
  single_value->field_psi5__change__mark.clean_up();
}
if (other_value.additions__99().is_bound()) {
  single_value->field_additions__99 = other_value.additions__99();
} else {
  single_value->field_additions__99.clean_up();
}
if (other_value.nc__meas__report().is_bound()) {
  if (other_value.nc__meas__report().ispresent()) single_value->field_nc__meas__report = other_value.nc__meas__report()();
  else single_value->field_nc__meas__report = OMIT_VALUE;
} else {
  single_value->field_nc__meas__report.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketMeasReport_template::copy_template(const PacketMeasReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tlli().get_selection()) {
single_value->field_tlli = other_value.tlli();
} else {
single_value->field_tlli.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psi5__change__mark__presence().get_selection()) {
single_value->field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
} else {
single_value->field_psi5__change__mark__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psi5__change__mark().get_selection()) {
single_value->field_psi5__change__mark = other_value.psi5__change__mark();
} else {
single_value->field_psi5__change__mark.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.additions__99().get_selection()) {
single_value->field_additions__99 = other_value.additions__99();
} else {
single_value->field_additions__99.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nc__meas__report().get_selection()) {
single_value->field_nc__meas__report = other_value.nc__meas__report();
} else {
single_value->field_nc__meas__report.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketMeasReport_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketMeasReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
break;
}
set_selection(other_value);
}

PacketMeasReport_template::PacketMeasReport_template()
{
}

PacketMeasReport_template::PacketMeasReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketMeasReport_template::PacketMeasReport_template(const PacketMeasReport& other_value)
{
copy_value(other_value);
}

PacketMeasReport_template::PacketMeasReport_template(const OPTIONAL<PacketMeasReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketMeasReport from an unbound optional field.");
}
}

PacketMeasReport_template::PacketMeasReport_template(PacketMeasReport_template* p_precondition, PacketMeasReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketMeasReport_template::PacketMeasReport_template(Dynamic_Match_Interface<PacketMeasReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketMeasReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketMeasReport_template::PacketMeasReport_template(const PacketMeasReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketMeasReport_template::~PacketMeasReport_template()
{
clean_up();
}

PacketMeasReport_template& PacketMeasReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const PacketMeasReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const OPTIONAL<PacketMeasReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const PacketMeasReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketMeasReport_template::match(const PacketMeasReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tlli().is_bound()) return FALSE;
if(!single_value->field_tlli.match(other_value.tlli(), legacy))return FALSE;
if(!other_value.psi5__change__mark__presence().is_bound()) return FALSE;
if(!single_value->field_psi5__change__mark__presence.match(other_value.psi5__change__mark__presence(), legacy))return FALSE;
if(!other_value.psi5__change__mark().is_bound()) return FALSE;
if((other_value.psi5__change__mark().ispresent() ? !single_value->field_psi5__change__mark.match((const BITSTRING&)other_value.psi5__change__mark(), legacy) : !single_value->field_psi5__change__mark.match_omit(legacy)))return FALSE;
if(!other_value.additions__99().is_bound()) return FALSE;
if(!single_value->field_additions__99.match(other_value.additions__99(), legacy))return FALSE;
if(!other_value.nc__meas__report().is_bound()) return FALSE;
if((other_value.nc__meas__report().ispresent() ? !single_value->field_nc__meas__report.match((const NCMeasurementReport&)other_value.nc__meas__report(), legacy) : !single_value->field_nc__meas__report.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
return FALSE;
}

boolean PacketMeasReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tlli.is_bound()
 || single_value->field_psi5__change__mark__presence.is_bound()
 || (single_value->field_psi5__change__mark.is_omit() || single_value->field_psi5__change__mark.is_bound())
 || single_value->field_additions__99.is_bound()
 || (single_value->field_nc__meas__report.is_omit() || single_value->field_nc__meas__report.is_bound());
}

boolean PacketMeasReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tlli.is_value()
 && single_value->field_psi5__change__mark__presence.is_value()
 && (single_value->field_psi5__change__mark.is_omit() || single_value->field_psi5__change__mark.is_value())
 && single_value->field_additions__99.is_value()
 && (single_value->field_nc__meas__report.is_omit() || single_value->field_nc__meas__report.is_value());
}

void PacketMeasReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketMeasReport PacketMeasReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
PacketMeasReport ret_val;
if (single_value->field_tlli.is_bound()) {
ret_val.tlli() = single_value->field_tlli.valueof();
}
if (single_value->field_psi5__change__mark__presence.is_bound()) {
ret_val.psi5__change__mark__presence() = single_value->field_psi5__change__mark__presence.valueof();
}
if (single_value->field_psi5__change__mark.is_omit()) ret_val.psi5__change__mark() = OMIT_VALUE;
else if (single_value->field_psi5__change__mark.is_bound()) {
ret_val.psi5__change__mark() = single_value->field_psi5__change__mark.valueof();
}
if (single_value->field_additions__99.is_bound()) {
ret_val.additions__99() = single_value->field_additions__99.valueof();
}
if (single_value->field_nc__meas__report.is_omit()) ret_val.nc__meas__report() = OMIT_VALUE;
else if (single_value->field_nc__meas__report.is_bound()) {
ret_val.nc__meas__report() = single_value->field_nc__meas__report.valueof();
}
return ret_val;
}

void PacketMeasReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketMeasReport_template[list_length];
}

PacketMeasReport_template& PacketMeasReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PacketMeasReport_template::tlli()
{
set_specific();
return single_value->field_tlli;
}

const OCTETSTRING_template& PacketMeasReport_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tlli of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_tlli;
}

BITSTRING_template& PacketMeasReport_template::psi5__change__mark__presence()
{
set_specific();
return single_value->field_psi5__change__mark__presence;
}

const BITSTRING_template& PacketMeasReport_template::psi5__change__mark__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psi5_change_mark_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_psi5__change__mark__presence;
}

BITSTRING_template& PacketMeasReport_template::psi5__change__mark()
{
set_specific();
return single_value->field_psi5__change__mark;
}

const BITSTRING_template& PacketMeasReport_template::psi5__change__mark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psi5_change_mark of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_psi5__change__mark;
}

BITSTRING_template& PacketMeasReport_template::additions__99()
{
set_specific();
return single_value->field_additions__99;
}

const BITSTRING_template& PacketMeasReport_template::additions__99() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field additions_99 of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_additions__99;
}

NCMeasurementReport_template& PacketMeasReport_template::nc__meas__report()
{
set_specific();
return single_value->field_nc__meas__report;
}

const NCMeasurementReport_template& PacketMeasReport_template::nc__meas__report() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nc_meas_report of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_nc__meas__report;
}

int PacketMeasReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_psi5__change__mark.is_present()) ret_val++;
      if (single_value->field_nc__meas__report.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
  }
  return 0;
}

void PacketMeasReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log();
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
single_value->field_psi5__change__mark__presence.log();
TTCN_Logger::log_event_str(", psi5_change_mark := ");
single_value->field_psi5__change__mark.log();
TTCN_Logger::log_event_str(", additions_99 := ");
single_value->field_additions__99.log();
TTCN_Logger::log_event_str(", nc_meas_report := ");
single_value->field_nc__meas__report.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketMeasReport_template::log_match(const PacketMeasReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tlli.match(match_value.tlli(), legacy)){
TTCN_Logger::log_logmatch_info(".tlli");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_psi5__change__mark__presence.match(match_value.psi5__change__mark__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".psi5_change_mark_presence");
single_value->field_psi5__change__mark__presence.log_match(match_value.psi5__change__mark__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.psi5__change__mark().ispresent()){
if(!single_value->field_psi5__change__mark.match(match_value.psi5__change__mark(), legacy)){
TTCN_Logger::log_logmatch_info(".psi5_change_mark");
single_value->field_psi5__change__mark.log_match(match_value.psi5__change__mark(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_psi5__change__mark.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".psi5_change_mark := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_psi5__change__mark.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_additions__99.match(match_value.additions__99(), legacy)){
TTCN_Logger::log_logmatch_info(".additions_99");
single_value->field_additions__99.log_match(match_value.additions__99(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.nc__meas__report().ispresent()){
if(!single_value->field_nc__meas__report.match(match_value.nc__meas__report(), legacy)){
TTCN_Logger::log_logmatch_info(".nc_meas_report");
single_value->field_nc__meas__report.log_match(match_value.nc__meas__report(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nc__meas__report.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nc_meas_report := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nc__meas__report.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
single_value->field_psi5__change__mark__presence.log_match(match_value.psi5__change__mark__presence(), legacy);
TTCN_Logger::log_event_str(", psi5_change_mark := ");
if (match_value.psi5__change__mark().ispresent()) {
single_value->field_psi5__change__mark.log_match(match_value.psi5__change__mark(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_psi5__change__mark.log();
if (single_value->field_psi5__change__mark.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", additions_99 := ");
single_value->field_additions__99.log_match(match_value.additions__99(), legacy);
TTCN_Logger::log_event_str(", nc_meas_report := ");
if (match_value.nc__meas__report().ispresent()) {
single_value->field_nc__meas__report.log_match(match_value.nc__meas__report(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nc__meas__report.log();
if (single_value->field_nc__meas__report.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketMeasReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tlli().is_bound()) tlli().set_implicit_omit();
if (psi5__change__mark__presence().is_bound()) psi5__change__mark__presence().set_implicit_omit();
if (!psi5__change__mark().is_bound()) psi5__change__mark() = OMIT_VALUE;
else psi5__change__mark().set_implicit_omit();
if (additions__99().is_bound()) additions__99().set_implicit_omit();
if (!nc__meas__report().is_bound()) nc__meas__report() = OMIT_VALUE;
else nc__meas__report().set_implicit_omit();
}

void PacketMeasReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tlli.encode_text(text_buf);
single_value->field_psi5__change__mark__presence.encode_text(text_buf);
single_value->field_psi5__change__mark.encode_text(text_buf);
single_value->field_additions__99.encode_text(text_buf);
single_value->field_nc__meas__report.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
}

void PacketMeasReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tlli.decode_text(text_buf);
single_value->field_psi5__change__mark__presence.decode_text(text_buf);
single_value->field_psi5__change__mark.decode_text(text_buf);
single_value->field_additions__99.decode_text(text_buf);
single_value->field_nc__meas__report.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
}

void PacketMeasReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketMeasReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PacketMeasReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) additions__99().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nc__meas__report().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additions_99")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additions__99().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_meas_report")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__meas__report().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketMeasReport_template* precondition = new PacketMeasReport_template;
    precondition->set_param(*param.get_elem(0));
    PacketMeasReport_template* implied_template = new PacketMeasReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketMeasReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PacketMeasReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketMeasReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tlli.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_psi5__change__mark__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_psi5__change__mark.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_additions__99.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_nc__meas__report.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
}

boolean PacketMeasReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketMeasReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2::copy_value(const MSRadioAccCap2& other_value)
{
switch (other_value.union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV(*other_value.field_msRadioAccessCapabilityV);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
union_selection = other_value.union_selection;
}

MSRadioAccCap2::MSRadioAccCap2()
{
union_selection = UNBOUND_VALUE;
}

MSRadioAccCap2::MSRadioAccCap2(const MSRadioAccCap2& other_value)
: Base_Type(){
copy_value(other_value);
}

MSRadioAccCap2::~MSRadioAccCap2()
{
clean_up();
}

MSRadioAccCap2& MSRadioAccCap2::operator=(const MSRadioAccCap2& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean MSRadioAccCap2::operator==(const MSRadioAccCap2& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
return *field_msRadioAccessCapabilityV == *other_value.field_msRadioAccessCapabilityV;
default:
return FALSE;
}
}

MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV& MSRadioAccCap2::msRadioAccessCapabilityV()
{
if (union_selection != ALT_msRadioAccessCapabilityV) {
clean_up();
field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV;
union_selection = ALT_msRadioAccessCapabilityV;
}
return *field_msRadioAccessCapabilityV;
}

const MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV& MSRadioAccCap2::msRadioAccessCapabilityV() const
{
if (union_selection != ALT_msRadioAccessCapabilityV) TTCN_error("Using non-selected field msRadioAccessCapabilityV in a value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return *field_msRadioAccessCapabilityV;
}

boolean MSRadioAccCap2::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return union_selection == checked_selection;
}

boolean MSRadioAccCap2::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean MSRadioAccCap2::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_msRadioAccessCapabilityV: return field_msRadioAccessCapabilityV->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void MSRadioAccCap2::clean_up()
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
  delete field_msRadioAccessCapabilityV;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void MSRadioAccCap2::log() const
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
field_msRadioAccessCapabilityV->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void MSRadioAccCap2::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "msRadioAccessCapabilityV")) {
    msRadioAccessCapabilityV().set_param(*mp_last);
    if (!msRadioAccessCapabilityV().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.MSRadioAccCap2.", last_name);
}

void MSRadioAccCap2::set_implicit_omit()
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV->set_implicit_omit(); break;
default: break;
}
}

void MSRadioAccCap2::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_msRadioAccessCapabilityV:
msRadioAccessCapabilityV().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MSRadioAccCap2::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MSRadioAccCap2::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw->forceomit);
      decoded_length = msRadioAccessCapabilityV().RAW_decode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw->forceomit);
      decoded_length = msRadioAccessCapabilityV().RAW_decode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int MSRadioAccCap2::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  memset(myleaf.body.node.nodes, 0, 1 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_msRadioAccessCapabilityV:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw);
    encoded_length = field_msRadioAccessCapabilityV->RAW_encode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &MSRadioAccCap2_msRadioAccessCapabilityV_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void MSRadioAccCap2_template::copy_value(const MSRadioAccCap2& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(other_value.msRadioAccessCapabilityV());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
set_selection(SPECIFIC_VALUE);
}

void MSRadioAccCap2_template::copy_template(const MSRadioAccCap2_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(*other_value.single_value.field_msRadioAccessCapabilityV);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MSRadioAccCap2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MSRadioAccCap2_template(*other_value.implication_.precondition);
implication_.implied_template = new MSRadioAccCap2_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
set_selection(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template()
{
}

MSRadioAccCap2_template::MSRadioAccCap2_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const MSRadioAccCap2& other_value)
{
copy_value(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const OPTIONAL<MSRadioAccCap2>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSRadioAccCap2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2 from an unbound optional field.");
}
}

MSRadioAccCap2_template::MSRadioAccCap2_template(MSRadioAccCap2_template* p_precondition, MSRadioAccCap2_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MSRadioAccCap2_template::MSRadioAccCap2_template(Dynamic_Match_Interface<MSRadioAccCap2>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MSRadioAccCap2>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const MSRadioAccCap2_template& other_value)
: Base_Template(){
copy_template(other_value);
}

MSRadioAccCap2_template::~MSRadioAccCap2_template()
{
clean_up();
}

void MSRadioAccCap2_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
delete single_value.field_msRadioAccessCapabilityV;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const MSRadioAccCap2& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const OPTIONAL<MSRadioAccCap2>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSRadioAccCap2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const MSRadioAccCap2_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MSRadioAccCap2_template::match(const MSRadioAccCap2& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
MSRadioAccCap2::union_selection_type value_selection = other_value.get_selection();
if (value_selection == MSRadioAccCap2::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
return single_value.field_msRadioAccessCapabilityV->match(other_value.msRadioAccessCapabilityV(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return FALSE;
}

boolean MSRadioAccCap2_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
return single_value.field_msRadioAccessCapabilityV->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

MSRadioAccCap2 MSRadioAccCap2_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
MSRadioAccCap2 ret_val;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
ret_val.msRadioAccessCapabilityV() = single_value.field_msRadioAccessCapabilityV->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return ret_val;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return value_list.list_value[list_index];
}
void MSRadioAccCap2_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MSRadioAccCap2_template[list_length];
}

MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template& MSRadioAccCap2_template::msRadioAccessCapabilityV()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != MSRadioAccCap2::ALT_msRadioAccessCapabilityV) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(ANY_VALUE);
else single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template;
single_value.union_selection = MSRadioAccCap2::ALT_msRadioAccessCapabilityV;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_msRadioAccessCapabilityV;
}

const MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template& MSRadioAccCap2_template::msRadioAccessCapabilityV() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field msRadioAccessCapabilityV in a non-specific template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (single_value.union_selection != MSRadioAccCap2::ALT_msRadioAccessCapabilityV) TTCN_error("Accessing non-selected field msRadioAccessCapabilityV in a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return *single_value.field_msRadioAccessCapabilityV;
}

boolean MSRadioAccCap2_template::ischosen(MSRadioAccCap2::union_selection_type checked_selection) const
{
if (checked_selection == MSRadioAccCap2::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == MSRadioAccCap2::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2 containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
single_value.field_msRadioAccessCapabilityV->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MSRadioAccCap2_template::log_match(const MSRadioAccCap2& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".msRadioAccessCapabilityV");
single_value.field_msRadioAccessCapabilityV->log_match(match_value.msRadioAccessCapabilityV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
single_value.field_msRadioAccessCapabilityV->log_match(match_value.msRadioAccessCapabilityV(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MSRadioAccCap2_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->set_implicit_omit(); break;
default: break;
}
}

void MSRadioAccCap2_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = MSRadioAccCap2::UNBOUND_VALUE;
MSRadioAccCap2::union_selection_type new_selection = (MSRadioAccCap2::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template;
single_value.field_msRadioAccessCapabilityV->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MSRadioAccCap2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

boolean MSRadioAccCap2_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MSRadioAccCap2_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RLCMAC_CSN1_Types.MSRadioAccCap2'");
    }
    if (strcmp("msRadioAccessCapabilityV", param_field) == 0) {
      msRadioAccessCapabilityV().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RLCMAC_CSN1_Types.MSRadioAccCap2'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MSRadioAccCap2_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RLCMAC_CSN1_Types.MSRadioAccCap2");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "msRadioAccessCapabilityV")) {
      msRadioAccessCapabilityV().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.MSRadioAccCap2.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    MSRadioAccCap2_template* precondition = new MSRadioAccCap2_template;
    precondition->set_param(*m_p->get_elem(0));
    MSRadioAccCap2_template* implied_template = new MSRadioAccCap2_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = MSRadioAccCap2_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RLCMAC_CSN1_Types.MSRadioAccCap2");
  }
  is_ifpresent = param.get_ifpresent();
}

void MSRadioAccCap2_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.MSRadioAccCap2");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.MSRadioAccCap2");
}

RlcAccessType::RlcAccessType()
{
enum_value = UNBOUND_VALUE;
}

RlcAccessType::RlcAccessType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RlcAccessType::RlcAccessType(enum_type other_value)
{
enum_value = other_value;
}

RlcAccessType::RlcAccessType(const RlcAccessType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
enum_value = other_value.enum_value;
}

RlcAccessType& RlcAccessType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RlcAccessType& RlcAccessType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RlcAccessType& RlcAccessType::operator=(const RlcAccessType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
enum_value = other_value.enum_value;
return *this;
}

boolean RlcAccessType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RlcAccessType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value == other_value;
}

boolean RlcAccessType::operator==(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value == other_value.enum_value;
}

boolean RlcAccessType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RlcAccessType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value < other_value;
}

boolean RlcAccessType::operator<(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value < other_value.enum_value;
}

boolean RlcAccessType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RlcAccessType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value > other_value;
}

boolean RlcAccessType::operator>(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value > other_value.enum_value;
}

const char *RlcAccessType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RLC__ACC__TYPE__TWO__PHASE: return "RLC_ACC_TYPE_TWO_PHASE";
case RLC__ACC__TYPE__PAG__RESPONSE: return "RLC_ACC_TYPE_PAG_RESPONSE";
case RLC__ACC__TYPE__CELL__UPDATE: return "RLC_ACC_TYPE_CELL_UPDATE";
case RLC__ACC__TYPE__MM: return "RLC_ACC_TYPE_MM";
default:
return "<unknown>";
}
}

RlcAccessType::enum_type RlcAccessType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RLC_ACC_TYPE_TWO_PHASE")) return RLC__ACC__TYPE__TWO__PHASE;
if (!strcmp(str_par, "RLC_ACC_TYPE_PAG_RESPONSE")) return RLC__ACC__TYPE__PAG__RESPONSE;
if (!strcmp(str_par, "RLC_ACC_TYPE_CELL_UPDATE")) return RLC__ACC__TYPE__CELL__UPDATE;
if (!strcmp(str_par, "RLC_ACC_TYPE_MM")) return RLC__ACC__TYPE__MM;
}
return UNKNOWN_VALUE;
}

boolean RlcAccessType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RlcAccessType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RlcAccessType::enum2int(const RlcAccessType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RlcAccessType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", int_val);
enum_value = (enum_type)int_val;
}

RlcAccessType::operator RlcAccessType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value;
}

void RlcAccessType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RlcAccessType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RLCMAC_CSN1_Types.RlcAccessType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcAccessType.");
  }
}

void RlcAccessType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
text_buf.push_int(enum_value);
}

void RlcAccessType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_value);
}

void RlcAccessType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RlcAccessType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RlcAccessType::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RlcAccessType::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RlcAccessType_template::copy_template(const RlcAccessType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RlcAccessType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RlcAccessType_template(*other_value.implication_.precondition);
implication_.implied_template = new RlcAccessType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

RlcAccessType_template::RlcAccessType_template()
{
}

RlcAccessType_template::RlcAccessType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RlcAccessType_template::RlcAccessType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RlcAccessType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with unknown numeric value %d.", other_value);
single_value = (RlcAccessType::enum_type)other_value;
}

RlcAccessType_template::RlcAccessType_template(RlcAccessType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RlcAccessType_template::RlcAccessType_template(const RlcAccessType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
single_value = other_value.enum_value;
}

RlcAccessType_template::RlcAccessType_template(const OPTIONAL<RlcAccessType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)(const RlcAccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType from an unbound optional field.");
}
}

RlcAccessType_template::RlcAccessType_template(RlcAccessType_template* p_precondition, RlcAccessType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RlcAccessType_template::RlcAccessType_template(Dynamic_Match_Interface<RlcAccessType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RlcAccessType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RlcAccessType_template::RlcAccessType_template(const RlcAccessType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RlcAccessType_template::~RlcAccessType_template()
{
clean_up();
}

boolean RlcAccessType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RlcAccessType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RlcAccessType::UNBOUND_VALUE;
}

void RlcAccessType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RlcAccessType_template& RlcAccessType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(int other_value)
{
if (!RlcAccessType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)other_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(RlcAccessType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const RlcAccessType& other_value)
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const OPTIONAL<RlcAccessType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)(const RlcAccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const RlcAccessType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RlcAccessType_template::match(RlcAccessType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
return FALSE;
}

boolean RlcAccessType_template::match(const RlcAccessType& other_value, boolean) const
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with an unbound value.");
return match(other_value.enum_value);
}

RlcAccessType::enum_type RlcAccessType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return single_value;
}

void RlcAccessType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RlcAccessType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

RlcAccessType_template& RlcAccessType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return value_list.list_value[list_index];
}

void RlcAccessType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RlcAccessType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RlcAccessType_template::log_match(const RlcAccessType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RlcAccessType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

void RlcAccessType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RlcAccessType::enum_type)text_buf.pull_int().get_val();
if (!RlcAccessType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RlcAccessType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

boolean RlcAccessType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RlcAccessType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RlcAccessType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RlcAccessType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RlcAccessType::enum_type enum_val = RlcAccessType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RlcAccessType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcAccessType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RlcAccessType_template* precondition = new RlcAccessType_template;
    precondition->set_param(*m_p->get_elem(0));
    RlcAccessType_template* implied_template = new RlcAccessType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RlcAccessType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RLCMAC_CSN1_Types.RlcAccessType");
  }
  is_ifpresent = param.get_ifpresent();
}

void RlcAccessType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.RlcAccessType");
}

void PacketResourceReqID::copy_value(const PacketResourceReqID& other_value)
{
switch (other_value.union_selection) {
case ALT_gtfi:
field_gtfi = new GlobalTfi(*other_value.field_gtfi);
break;
case ALT_tlli:
field_tlli = new OCTETSTRING(*other_value.field_tlli);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
union_selection = other_value.union_selection;
}

PacketResourceReqID::PacketResourceReqID()
{
union_selection = UNBOUND_VALUE;
}

PacketResourceReqID::PacketResourceReqID(const PacketResourceReqID& other_value)
: Base_Type(){
copy_value(other_value);
}

PacketResourceReqID::~PacketResourceReqID()
{
clean_up();
}

PacketResourceReqID& PacketResourceReqID::operator=(const PacketResourceReqID& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PacketResourceReqID::operator==(const PacketResourceReqID& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_gtfi:
return *field_gtfi == *other_value.field_gtfi;
case ALT_tlli:
return *field_tlli == *other_value.field_tlli;
default:
return FALSE;
}
}

GlobalTfi& PacketResourceReqID::gtfi()
{
if (union_selection != ALT_gtfi) {
clean_up();
field_gtfi = new GlobalTfi;
union_selection = ALT_gtfi;
}
return *field_gtfi;
}

const GlobalTfi& PacketResourceReqID::gtfi() const
{
if (union_selection != ALT_gtfi) TTCN_error("Using non-selected field gtfi in a value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *field_gtfi;
}

OCTETSTRING& PacketResourceReqID::tlli()
{
if (union_selection != ALT_tlli) {
clean_up();
field_tlli = new OCTETSTRING;
union_selection = ALT_tlli;
}
return *field_tlli;
}

const OCTETSTRING& PacketResourceReqID::tlli() const
{
if (union_selection != ALT_tlli) TTCN_error("Using non-selected field tlli in a value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *field_tlli;
}

boolean PacketResourceReqID::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return union_selection == checked_selection;
}

boolean PacketResourceReqID::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PacketResourceReqID::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_gtfi: return field_gtfi->is_value();
case ALT_tlli: return field_tlli->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PacketResourceReqID::clean_up()
{
switch (union_selection) {
case ALT_gtfi:
  delete field_gtfi;
  break;
case ALT_tlli:
  delete field_tlli;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PacketResourceReqID::log() const
{
switch (union_selection) {
case ALT_gtfi:
TTCN_Logger::log_event_str("{ gtfi := ");
field_gtfi->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tlli:
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PacketResourceReqID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "gtfi")) {
    gtfi().set_param(*mp_last);
    if (!gtfi().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tlli")) {
    tlli().set_param(*mp_last);
    if (!tlli().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.PacketResourceReqID.", last_name);
}

void PacketResourceReqID::set_implicit_omit()
{
switch (union_selection) {
case ALT_gtfi:
field_gtfi->set_implicit_omit(); break;
case ALT_tlli:
field_tlli->set_implicit_omit(); break;
default: break;
}
}

void PacketResourceReqID::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_gtfi:
field_gtfi->encode_text(text_buf);
break;
case ALT_tlli:
field_tlli->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_gtfi:
gtfi().decode_text(text_buf);
break;
case ALT_tlli:
tlli().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketResourceReqID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketResourceReqID::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PacketResourceReqID_gtfi_descr_.raw->forceomit);
      decoded_length = gtfi().RAW_decode(PacketResourceReqID_gtfi_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PacketResourceReqID_tlli_descr_.raw->forceomit);
      decoded_length = tlli().RAW_decode(PacketResourceReqID_tlli_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, PacketResourceReqID_gtfi_descr_.raw->forceomit);
      decoded_length = gtfi().RAW_decode(PacketResourceReqID_gtfi_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, PacketResourceReqID_tlli_descr_.raw->forceomit);
      decoded_length = tlli().RAW_decode(PacketResourceReqID_tlli_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int PacketResourceReqID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_gtfi:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PacketResourceReqID_gtfi_descr_.raw);
    encoded_length = field_gtfi->RAW_encode(PacketResourceReqID_gtfi_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PacketResourceReqID_gtfi_descr_;
    break;
  case ALT_tlli:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PacketResourceReqID_tlli_descr_.raw);
    encoded_length = field_tlli->RAW_encode(PacketResourceReqID_tlli_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PacketResourceReqID_tlli_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PacketResourceReqID_template::copy_value(const PacketResourceReqID& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template(other_value.gtfi());
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template(other_value.tlli());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
set_selection(SPECIFIC_VALUE);
}

void PacketResourceReqID_template::copy_template(const PacketResourceReqID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template(*other_value.single_value.field_gtfi);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template(*other_value.single_value.field_tlli);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketResourceReqID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketResourceReqID_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketResourceReqID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
set_selection(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template()
{
}

PacketResourceReqID_template::PacketResourceReqID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template(const PacketResourceReqID& other_value)
{
copy_value(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template(const OPTIONAL<PacketResourceReqID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReqID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID from an unbound optional field.");
}
}

PacketResourceReqID_template::PacketResourceReqID_template(PacketResourceReqID_template* p_precondition, PacketResourceReqID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketResourceReqID_template::PacketResourceReqID_template(Dynamic_Match_Interface<PacketResourceReqID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketResourceReqID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketResourceReqID_template::PacketResourceReqID_template(const PacketResourceReqID_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PacketResourceReqID_template::~PacketResourceReqID_template()
{
clean_up();
}

void PacketResourceReqID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
delete single_value.field_gtfi;
break;
case PacketResourceReqID::ALT_tlli:
delete single_value.field_tlli;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const PacketResourceReqID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const OPTIONAL<PacketResourceReqID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReqID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const PacketResourceReqID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketResourceReqID_template::match(const PacketResourceReqID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PacketResourceReqID::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PacketResourceReqID::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PacketResourceReqID::ALT_gtfi:
return single_value.field_gtfi->match(other_value.gtfi(), legacy);
case PacketResourceReqID::ALT_tlli:
return single_value.field_tlli->match(other_value.tlli(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return FALSE;
}

boolean PacketResourceReqID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
return single_value.field_gtfi->is_value();
case PacketResourceReqID::ALT_tlli:
return single_value.field_tlli->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

PacketResourceReqID PacketResourceReqID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
PacketResourceReqID ret_val;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
ret_val.gtfi() = single_value.field_gtfi->valueof();
break;
case PacketResourceReqID::ALT_tlli:
ret_val.tlli() = single_value.field_tlli->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return ret_val;
}

PacketResourceReqID_template& PacketResourceReqID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return value_list.list_value[list_index];
}
void PacketResourceReqID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketResourceReqID_template[list_length];
}

GlobalTfi_template& PacketResourceReqID_template::gtfi()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PacketResourceReqID::ALT_gtfi) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_gtfi = new GlobalTfi_template(ANY_VALUE);
else single_value.field_gtfi = new GlobalTfi_template;
single_value.union_selection = PacketResourceReqID::ALT_gtfi;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_gtfi;
}

const GlobalTfi_template& PacketResourceReqID_template::gtfi() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field gtfi in a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (single_value.union_selection != PacketResourceReqID::ALT_gtfi) TTCN_error("Accessing non-selected field gtfi in a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *single_value.field_gtfi;
}

OCTETSTRING_template& PacketResourceReqID_template::tlli()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PacketResourceReqID::ALT_tlli) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tlli = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_tlli = new OCTETSTRING_template;
single_value.union_selection = PacketResourceReqID::ALT_tlli;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tlli;
}

const OCTETSTRING_template& PacketResourceReqID_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tlli in a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (single_value.union_selection != PacketResourceReqID::ALT_tlli) TTCN_error("Accessing non-selected field tlli in a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *single_value.field_tlli;
}

boolean PacketResourceReqID_template::ischosen(PacketResourceReqID::union_selection_type checked_selection) const
{
if (checked_selection == PacketResourceReqID::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PacketResourceReqID::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PacketResourceReqID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
TTCN_Logger::log_event_str("{ gtfi := ");
single_value.field_gtfi->log();
TTCN_Logger::log_event_str(" }");
break;
case PacketResourceReqID::ALT_tlli:
TTCN_Logger::log_event_str("{ tlli := ");
single_value.field_tlli->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketResourceReqID_template::log_match(const PacketResourceReqID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".gtfi");
single_value.field_gtfi->log_match(match_value.gtfi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ gtfi := ");
single_value.field_gtfi->log_match(match_value.gtfi(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PacketResourceReqID::ALT_tlli:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tlli");
single_value.field_tlli->log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tlli := ");
single_value.field_tlli->log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketResourceReqID_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->set_implicit_omit(); break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->set_implicit_omit(); break;
default: break;
}
}

void PacketResourceReqID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->encode_text(text_buf);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PacketResourceReqID::UNBOUND_VALUE;
PacketResourceReqID::union_selection_type new_selection = (PacketResourceReqID::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template;
single_value.field_gtfi->decode_text(text_buf);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template;
single_value.field_tlli->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketResourceReqID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

boolean PacketResourceReqID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketResourceReqID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PacketResourceReqID_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RLCMAC_CSN1_Types.PacketResourceReqID'");
    }
    if (strcmp("gtfi", param_field) == 0) {
      gtfi().set_param(param);
      return;
    } else if (strcmp("tlli", param_field) == 0) {
      tlli().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RLCMAC_CSN1_Types.PacketResourceReqID'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketResourceReqID_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RLCMAC_CSN1_Types.PacketResourceReqID");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "gtfi")) {
      gtfi().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tlli")) {
      tlli().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.PacketResourceReqID.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketResourceReqID_template* precondition = new PacketResourceReqID_template;
    precondition->set_param(*m_p->get_elem(0));
    PacketResourceReqID_template* implied_template = new PacketResourceReqID_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PacketResourceReqID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RLCMAC_CSN1_Types.PacketResourceReqID");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketResourceReqID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
return;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
}

PacketResourceReq::PacketResourceReq()
{
}

PacketResourceReq::PacketResourceReq(const BITSTRING& par_acc__type__presence,
    const OPTIONAL< RlcAccessType >& par_acc__type,
    const BITSTRING& par_id__type,
    const PacketResourceReqID& par_id,
    const BITSTRING& par_ms__rac2__presence,
    const OPTIONAL< MSRadioAccCap2 >& par_ms__rac2,
    const ChannelReqDescription& par_ch__req__desc,
    const BITSTRING& par_change__mark__presence,
    const OPTIONAL< BITSTRING >& par_change__mark,
    const BITSTRING& par_C__val,
    const BITSTRING& par_sign__var__presence,
    const OPTIONAL< BITSTRING >& par_sign__var,
    const ILevels& par_I__levels)
  :   field_acc__type__presence(par_acc__type__presence),
  field_acc__type(par_acc__type),
  field_id__type(par_id__type),
  field_id(par_id),
  field_ms__rac2__presence(par_ms__rac2__presence),
  field_ms__rac2(par_ms__rac2),
  field_ch__req__desc(par_ch__req__desc),
  field_change__mark__presence(par_change__mark__presence),
  field_change__mark(par_change__mark),
  field_C__val(par_C__val),
  field_sign__var__presence(par_sign__var__presence),
  field_sign__var(par_sign__var),
  field_I__levels(par_I__levels)
{
}

PacketResourceReq::PacketResourceReq(const PacketResourceReq& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReq.");
if (other_value.acc__type__presence().is_bound()) field_acc__type__presence = other_value.acc__type__presence();
else field_acc__type__presence.clean_up();
if (other_value.acc__type().is_bound()) field_acc__type = other_value.acc__type();
else field_acc__type.clean_up();
if (other_value.id__type().is_bound()) field_id__type = other_value.id__type();
else field_id__type.clean_up();
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.ms__rac2__presence().is_bound()) field_ms__rac2__presence = other_value.ms__rac2__presence();
else field_ms__rac2__presence.clean_up();
if (other_value.ms__rac2().is_bound()) field_ms__rac2 = other_value.ms__rac2();
else field_ms__rac2.clean_up();
if (other_value.ch__req__desc().is_bound()) field_ch__req__desc = other_value.ch__req__desc();
else field_ch__req__desc.clean_up();
if (other_value.change__mark__presence().is_bound()) field_change__mark__presence = other_value.change__mark__presence();
else field_change__mark__presence.clean_up();
if (other_value.change__mark().is_bound()) field_change__mark = other_value.change__mark();
else field_change__mark.clean_up();
if (other_value.C__val().is_bound()) field_C__val = other_value.C__val();
else field_C__val.clean_up();
if (other_value.sign__var__presence().is_bound()) field_sign__var__presence = other_value.sign__var__presence();
else field_sign__var__presence.clean_up();
if (other_value.sign__var().is_bound()) field_sign__var = other_value.sign__var();
else field_sign__var.clean_up();
if (other_value.I__levels().is_bound()) field_I__levels = other_value.I__levels();
else field_I__levels.clean_up();
}

void PacketResourceReq::clean_up()
{
field_acc__type__presence.clean_up();
field_acc__type.clean_up();
field_id__type.clean_up();
field_id.clean_up();
field_ms__rac2__presence.clean_up();
field_ms__rac2.clean_up();
field_ch__req__desc.clean_up();
field_change__mark__presence.clean_up();
field_change__mark.clean_up();
field_C__val.clean_up();
field_sign__var__presence.clean_up();
field_sign__var.clean_up();
field_I__levels.clean_up();
}

const TTCN_Typedescriptor_t* PacketResourceReq::get_descriptor() const { return &PacketResourceReq_descr_; }
PacketResourceReq& PacketResourceReq::operator=(const PacketResourceReq& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReq.");
  if (other_value.acc__type__presence().is_bound()) field_acc__type__presence = other_value.acc__type__presence();
  else field_acc__type__presence.clean_up();
  if (other_value.acc__type().is_bound()) field_acc__type = other_value.acc__type();
  else field_acc__type.clean_up();
  if (other_value.id__type().is_bound()) field_id__type = other_value.id__type();
  else field_id__type.clean_up();
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.ms__rac2__presence().is_bound()) field_ms__rac2__presence = other_value.ms__rac2__presence();
  else field_ms__rac2__presence.clean_up();
  if (other_value.ms__rac2().is_bound()) field_ms__rac2 = other_value.ms__rac2();
  else field_ms__rac2.clean_up();
  if (other_value.ch__req__desc().is_bound()) field_ch__req__desc = other_value.ch__req__desc();
  else field_ch__req__desc.clean_up();
  if (other_value.change__mark__presence().is_bound()) field_change__mark__presence = other_value.change__mark__presence();
  else field_change__mark__presence.clean_up();
  if (other_value.change__mark().is_bound()) field_change__mark = other_value.change__mark();
  else field_change__mark.clean_up();
  if (other_value.C__val().is_bound()) field_C__val = other_value.C__val();
  else field_C__val.clean_up();
  if (other_value.sign__var__presence().is_bound()) field_sign__var__presence = other_value.sign__var__presence();
  else field_sign__var__presence.clean_up();
  if (other_value.sign__var().is_bound()) field_sign__var = other_value.sign__var();
  else field_sign__var.clean_up();
  if (other_value.I__levels().is_bound()) field_I__levels = other_value.I__levels();
  else field_I__levels.clean_up();
}
return *this;
}

boolean PacketResourceReq::operator==(const PacketResourceReq& other_value) const
{
return field_acc__type__presence==other_value.field_acc__type__presence
  && field_acc__type==other_value.field_acc__type
  && field_id__type==other_value.field_id__type
  && field_id==other_value.field_id
  && field_ms__rac2__presence==other_value.field_ms__rac2__presence
  && field_ms__rac2==other_value.field_ms__rac2
  && field_ch__req__desc==other_value.field_ch__req__desc
  && field_change__mark__presence==other_value.field_change__mark__presence
  && field_change__mark==other_value.field_change__mark
  && field_C__val==other_value.field_C__val
  && field_sign__var__presence==other_value.field_sign__var__presence
  && field_sign__var==other_value.field_sign__var
  && field_I__levels==other_value.field_I__levels;
}

boolean PacketResourceReq::is_bound() const
{
return (field_acc__type__presence.is_bound())
  || (OPTIONAL_OMIT == field_acc__type.get_selection() || field_acc__type.is_bound())
  || (field_id__type.is_bound())
  || (field_id.is_bound())
  || (field_ms__rac2__presence.is_bound())
  || (OPTIONAL_OMIT == field_ms__rac2.get_selection() || field_ms__rac2.is_bound())
  || (field_ch__req__desc.is_bound())
  || (field_change__mark__presence.is_bound())
  || (OPTIONAL_OMIT == field_change__mark.get_selection() || field_change__mark.is_bound())
  || (field_C__val.is_bound())
  || (field_sign__var__presence.is_bound())
  || (OPTIONAL_OMIT == field_sign__var.get_selection() || field_sign__var.is_bound())
  || (field_I__levels.is_bound());
}
boolean PacketResourceReq::is_value() const
{
return field_acc__type__presence.is_value()
  && (OPTIONAL_OMIT == field_acc__type.get_selection() || field_acc__type.is_value())
  && field_id__type.is_value()
  && field_id.is_value()
  && field_ms__rac2__presence.is_value()
  && (OPTIONAL_OMIT == field_ms__rac2.get_selection() || field_ms__rac2.is_value())
  && field_ch__req__desc.is_value()
  && field_change__mark__presence.is_value()
  && (OPTIONAL_OMIT == field_change__mark.get_selection() || field_change__mark.is_value())
  && field_C__val.is_value()
  && field_sign__var__presence.is_value()
  && (OPTIONAL_OMIT == field_sign__var.get_selection() || field_sign__var.is_value())
  && field_I__levels.is_value();
}
int PacketResourceReq::size_of() const
{
  int ret_val = 9;
  if (field_acc__type.ispresent()) ret_val++;
  if (field_ms__rac2.ispresent()) ret_val++;
  if (field_change__mark.ispresent()) ret_val++;
  if (field_sign__var.ispresent()) ret_val++;
  return ret_val;
}

void PacketResourceReq::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ acc_type_presence := ");
field_acc__type__presence.log();
TTCN_Logger::log_event_str(", acc_type := ");
field_acc__type.log();
TTCN_Logger::log_event_str(", id_type := ");
field_id__type.log();
TTCN_Logger::log_event_str(", id := ");
field_id.log();
TTCN_Logger::log_event_str(", ms_rac2_presence := ");
field_ms__rac2__presence.log();
TTCN_Logger::log_event_str(", ms_rac2 := ");
field_ms__rac2.log();
TTCN_Logger::log_event_str(", ch_req_desc := ");
field_ch__req__desc.log();
TTCN_Logger::log_event_str(", change_mark_presence := ");
field_change__mark__presence.log();
TTCN_Logger::log_event_str(", change_mark := ");
field_change__mark.log();
TTCN_Logger::log_event_str(", C_val := ");
field_C__val.log();
TTCN_Logger::log_event_str(", sign_var_presence := ");
field_sign__var__presence.log();
TTCN_Logger::log_event_str(", sign_var := ");
field_sign__var.log();
TTCN_Logger::log_event_str(", I_levels := ");
field_I__levels.log();
TTCN_Logger::log_event_str(" }");
}

void PacketResourceReq::set_implicit_omit()
{
if (acc__type__presence().is_bound()) acc__type__presence().set_implicit_omit();
if (!acc__type().is_bound()) acc__type() = OMIT_VALUE;
else acc__type().set_implicit_omit();
if (id__type().is_bound()) id__type().set_implicit_omit();
if (id().is_bound()) id().set_implicit_omit();
if (ms__rac2__presence().is_bound()) ms__rac2__presence().set_implicit_omit();
if (!ms__rac2().is_bound()) ms__rac2() = OMIT_VALUE;
else ms__rac2().set_implicit_omit();
if (ch__req__desc().is_bound()) ch__req__desc().set_implicit_omit();
if (change__mark__presence().is_bound()) change__mark__presence().set_implicit_omit();
if (!change__mark().is_bound()) change__mark() = OMIT_VALUE;
else change__mark().set_implicit_omit();
if (C__val().is_bound()) C__val().set_implicit_omit();
if (sign__var__presence().is_bound()) sign__var__presence().set_implicit_omit();
if (!sign__var().is_bound()) sign__var() = OMIT_VALUE;
else sign__var().set_implicit_omit();
if (I__levels().is_bound()) I__levels().set_implicit_omit();
}

void PacketResourceReq::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (13<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketResourceReq has 13 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) acc__type__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) acc__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) id__type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ms__rac2__presence().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) ms__rac2().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ch__req__desc().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) change__mark__presence().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) change__mark().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) C__val().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sign__var__presence().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) sign__var().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) I__levels().set_param(*param.get_elem(12));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ch_req_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ch__req__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "C_val")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          C__val().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "I_levels")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          I__levels().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketResourceReq: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketResourceReq");
  }
}

void PacketResourceReq::encode_text(Text_Buf& text_buf) const
{
field_acc__type__presence.encode_text(text_buf);
field_acc__type.encode_text(text_buf);
field_id__type.encode_text(text_buf);
field_id.encode_text(text_buf);
field_ms__rac2__presence.encode_text(text_buf);
field_ms__rac2.encode_text(text_buf);
field_ch__req__desc.encode_text(text_buf);
field_change__mark__presence.encode_text(text_buf);
field_change__mark.encode_text(text_buf);
field_C__val.encode_text(text_buf);
field_sign__var__presence.encode_text(text_buf);
field_sign__var.encode_text(text_buf);
field_I__levels.encode_text(text_buf);
}

void PacketResourceReq::decode_text(Text_Buf& text_buf)
{
field_acc__type__presence.decode_text(text_buf);
field_acc__type.decode_text(text_buf);
field_id__type.decode_text(text_buf);
field_id.decode_text(text_buf);
field_ms__rac2__presence.decode_text(text_buf);
field_ms__rac2.decode_text(text_buf);
field_ch__req__desc.decode_text(text_buf);
field_change__mark__presence.decode_text(text_buf);
field_change__mark.decode_text(text_buf);
field_C__val.decode_text(text_buf);
field_sign__var__presence.decode_text(text_buf);
field_sign__var.decode_text(text_buf);
field_I__levels.decode_text(text_buf);
}

void PacketResourceReq::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketResourceReq::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketResourceReq::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketResourceReq_acc__type__presence_descr_.raw->forceomit);
  decoded_field_length = field_acc__type__presence.RAW_decode(PacketResourceReq_acc__type__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_acc__type__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_acc__type = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketResourceReq_acc__type_descr_.raw->forceomit);
  decoded_field_length = field_acc__type().RAW_decode(PacketResourceReq_acc__type_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_acc__type = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_acc__type=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketResourceReq_id__type_descr_.raw->forceomit);
  decoded_field_length = field_id__type.RAW_decode(PacketResourceReq_id__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_id__type ==  bs_1) selected_field = 0;
  else if (field_id__type ==  bs_0) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PacketResourceReq_id_descr_.raw->forceomit);
  decoded_field_length = field_id.RAW_decode(PacketResourceReq_id_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, PacketResourceReq_ms__rac2__presence_descr_.raw->forceomit);
  decoded_field_length = field_ms__rac2__presence.RAW_decode(PacketResourceReq_ms__rac2__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_ms__rac2__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_ms__rac2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, PacketResourceReq_ms__rac2_descr_.raw->forceomit);
  decoded_field_length = field_ms__rac2().RAW_decode(PacketResourceReq_ms__rac2_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_ms__rac2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ms__rac2=OMIT_VALUE;
  RAW_Force_Omit field_6_force_omit(6, force_omit, PacketResourceReq_ch__req__desc_descr_.raw->forceomit);
  decoded_field_length = field_ch__req__desc.RAW_decode(PacketResourceReq_ch__req__desc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_7_force_omit(7, force_omit, PacketResourceReq_change__mark__presence_descr_.raw->forceomit);
  decoded_field_length = field_change__mark__presence.RAW_decode(PacketResourceReq_change__mark__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_change__mark__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_change__mark = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, PacketResourceReq_change__mark_descr_.raw->forceomit);
  decoded_field_length = field_change__mark().RAW_decode(PacketResourceReq_change__mark_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_change__mark = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_change__mark=OMIT_VALUE;
  RAW_Force_Omit field_9_force_omit(9, force_omit, PacketResourceReq_C__val_descr_.raw->forceomit);
  decoded_field_length = field_C__val.RAW_decode(PacketResourceReq_C__val_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_10_force_omit(10, force_omit, PacketResourceReq_sign__var__presence_descr_.raw->forceomit);
  decoded_field_length = field_sign__var__presence.RAW_decode(PacketResourceReq_sign__var__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_sign__var__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_sign__var = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, PacketResourceReq_sign__var_descr_.raw->forceomit);
  decoded_field_length = field_sign__var().RAW_decode(PacketResourceReq_sign__var_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_sign__var = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sign__var=OMIT_VALUE;
  RAW_Force_Omit field_12_force_omit(12, force_omit, PacketResourceReq_I__levels_descr_.raw->forceomit);
  decoded_field_length = field_I__levels.RAW_decode(PacketResourceReq_I__levels_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketResourceReq::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 13;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(13);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketResourceReq_acc__type__presence_descr_.raw);
  if (field_acc__type.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketResourceReq_acc__type_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketResourceReq_id__type_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PacketResourceReq_id_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PacketResourceReq_ms__rac2__presence_descr_.raw);
  if (field_ms__rac2.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PacketResourceReq_ms__rac2_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, PacketResourceReq_ch__req__desc_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, PacketResourceReq_change__mark__presence_descr_.raw);
  if (field_change__mark.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, PacketResourceReq_change__mark_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, PacketResourceReq_C__val_descr_.raw);
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, PacketResourceReq_sign__var__presence_descr_.raw);
  if (field_sign__var.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, PacketResourceReq_sign__var_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, PacketResourceReq_I__levels_descr_.raw);
  encoded_length += field_acc__type__presence.RAW_encode(PacketResourceReq_acc__type__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_acc__type.ispresent()) {
  encoded_length += field_acc__type().RAW_encode(PacketResourceReq_acc__type_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_id__type.RAW_encode(PacketResourceReq_id__type_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_id.RAW_encode(PacketResourceReq_id_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_ms__rac2__presence.RAW_encode(PacketResourceReq_ms__rac2__presence_descr_, *myleaf.body.node.nodes[4]);
  if (field_ms__rac2.ispresent()) {
  encoded_length += field_ms__rac2().RAW_encode(PacketResourceReq_ms__rac2_descr_, *myleaf.body.node.nodes[5]);
  }
  encoded_length += field_ch__req__desc.RAW_encode(PacketResourceReq_ch__req__desc_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_change__mark__presence.RAW_encode(PacketResourceReq_change__mark__presence_descr_, *myleaf.body.node.nodes[7]);
  if (field_change__mark.ispresent()) {
  encoded_length += field_change__mark().RAW_encode(PacketResourceReq_change__mark_descr_, *myleaf.body.node.nodes[8]);
  }
  encoded_length += field_C__val.RAW_encode(PacketResourceReq_C__val_descr_, *myleaf.body.node.nodes[9]);
  encoded_length += field_sign__var__presence.RAW_encode(PacketResourceReq_sign__var__presence_descr_, *myleaf.body.node.nodes[10]);
  if (field_sign__var.ispresent()) {
  encoded_length += field_sign__var().RAW_encode(PacketResourceReq_sign__var_descr_, *myleaf.body.node.nodes[11]);
  }
  encoded_length += field_I__levels.RAW_encode(PacketResourceReq_I__levels_descr_, *myleaf.body.node.nodes[12]);
  if (field_acc__type.ispresent() && (field_acc__type__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_acc__type__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  switch (field_id.get_selection()) {
  case PacketResourceReqID::ALT_gtfi:
  if (field_id__type !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(PacketResourceReq_id__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PacketResourceReqID::ALT_tlli:
  if (field_id__type !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(PacketResourceReq_id__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_ms__rac2.ispresent() && (field_ms__rac2__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={4};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_ms__rac2__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_change__mark.ispresent() && (field_change__mark__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={7};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_change__mark__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_sign__var.ispresent() && (field_sign__var__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={10};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_sign__var__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PacketResourceReq_template::single_value_struct {
BITSTRING_template field_acc__type__presence;
RlcAccessType_template field_acc__type;
BITSTRING_template field_id__type;
PacketResourceReqID_template field_id;
BITSTRING_template field_ms__rac2__presence;
MSRadioAccCap2_template field_ms__rac2;
ChannelReqDescription_template field_ch__req__desc;
BITSTRING_template field_change__mark__presence;
BITSTRING_template field_change__mark;
BITSTRING_template field_C__val;
BITSTRING_template field_sign__var__presence;
BITSTRING_template field_sign__var;
ILevels_template field_I__levels;
};

void PacketResourceReq_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_acc__type__presence = ANY_VALUE;
single_value->field_acc__type = ANY_OR_OMIT;
single_value->field_id__type = ANY_VALUE;
single_value->field_id = ANY_VALUE;
single_value->field_ms__rac2__presence = ANY_VALUE;
single_value->field_ms__rac2 = ANY_OR_OMIT;
single_value->field_ch__req__desc = ANY_VALUE;
single_value->field_change__mark__presence = ANY_VALUE;
single_value->field_change__mark = ANY_OR_OMIT;
single_value->field_C__val = ANY_VALUE;
single_value->field_sign__var__presence = ANY_VALUE;
single_value->field_sign__var = ANY_OR_OMIT;
single_value->field_I__levels = ANY_VALUE;
}
}
}

void PacketResourceReq_template::copy_value(const PacketResourceReq& other_value)
{
single_value = new single_value_struct;
if (other_value.acc__type__presence().is_bound()) {
  single_value->field_acc__type__presence = other_value.acc__type__presence();
} else {
  single_value->field_acc__type__presence.clean_up();
}
if (other_value.acc__type().is_bound()) {
  if (other_value.acc__type().ispresent()) single_value->field_acc__type = other_value.acc__type()();
  else single_value->field_acc__type = OMIT_VALUE;
} else {
  single_value->field_acc__type.clean_up();
}
if (other_value.id__type().is_bound()) {
  single_value->field_id__type = other_value.id__type();
} else {
  single_value->field_id__type.clean_up();
}
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.ms__rac2__presence().is_bound()) {
  single_value->field_ms__rac2__presence = other_value.ms__rac2__presence();
} else {
  single_value->field_ms__rac2__presence.clean_up();
}
if (other_value.ms__rac2().is_bound()) {
  if (other_value.ms__rac2().ispresent()) single_value->field_ms__rac2 = other_value.ms__rac2()();
  else single_value->field_ms__rac2 = OMIT_VALUE;
} else {
  single_value->field_ms__rac2.clean_up();
}
if (other_value.ch__req__desc().is_bound()) {
  single_value->field_ch__req__desc = other_value.ch__req__desc();
} else {
  single_value->field_ch__req__desc.clean_up();
}
if (other_value.change__mark__presence().is_bound()) {
  single_value->field_change__mark__presence = other_value.change__mark__presence();
} else {
  single_value->field_change__mark__presence.clean_up();
}
if (other_value.change__mark().is_bound()) {
  if (other_value.change__mark().ispresent()) single_value->field_change__mark = other_value.change__mark()();
  else single_value->field_change__mark = OMIT_VALUE;
} else {
  single_value->field_change__mark.clean_up();
}
if (other_value.C__val().is_bound()) {
  single_value->field_C__val = other_value.C__val();
} else {
  single_value->field_C__val.clean_up();
}
if (other_value.sign__var__presence().is_bound()) {
  single_value->field_sign__var__presence = other_value.sign__var__presence();
} else {
  single_value->field_sign__var__presence.clean_up();
}
if (other_value.sign__var().is_bound()) {
  if (other_value.sign__var().ispresent()) single_value->field_sign__var = other_value.sign__var()();
  else single_value->field_sign__var = OMIT_VALUE;
} else {
  single_value->field_sign__var.clean_up();
}
if (other_value.I__levels().is_bound()) {
  single_value->field_I__levels = other_value.I__levels();
} else {
  single_value->field_I__levels.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketResourceReq_template::copy_template(const PacketResourceReq_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.acc__type__presence().get_selection()) {
single_value->field_acc__type__presence = other_value.acc__type__presence();
} else {
single_value->field_acc__type__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.acc__type().get_selection()) {
single_value->field_acc__type = other_value.acc__type();
} else {
single_value->field_acc__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.id__type().get_selection()) {
single_value->field_id__type = other_value.id__type();
} else {
single_value->field_id__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__rac2__presence().get_selection()) {
single_value->field_ms__rac2__presence = other_value.ms__rac2__presence();
} else {
single_value->field_ms__rac2__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__rac2().get_selection()) {
single_value->field_ms__rac2 = other_value.ms__rac2();
} else {
single_value->field_ms__rac2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ch__req__desc().get_selection()) {
single_value->field_ch__req__desc = other_value.ch__req__desc();
} else {
single_value->field_ch__req__desc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.change__mark__presence().get_selection()) {
single_value->field_change__mark__presence = other_value.change__mark__presence();
} else {
single_value->field_change__mark__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.change__mark().get_selection()) {
single_value->field_change__mark = other_value.change__mark();
} else {
single_value->field_change__mark.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.C__val().get_selection()) {
single_value->field_C__val = other_value.C__val();
} else {
single_value->field_C__val.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sign__var__presence().get_selection()) {
single_value->field_sign__var__presence = other_value.sign__var__presence();
} else {
single_value->field_sign__var__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sign__var().get_selection()) {
single_value->field_sign__var = other_value.sign__var();
} else {
single_value->field_sign__var.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.I__levels().get_selection()) {
single_value->field_I__levels = other_value.I__levels();
} else {
single_value->field_I__levels.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketResourceReq_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketResourceReq_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketResourceReq_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
break;
}
set_selection(other_value);
}

PacketResourceReq_template::PacketResourceReq_template()
{
}

PacketResourceReq_template::PacketResourceReq_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketResourceReq_template::PacketResourceReq_template(const PacketResourceReq& other_value)
{
copy_value(other_value);
}

PacketResourceReq_template::PacketResourceReq_template(const OPTIONAL<PacketResourceReq>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReq&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketResourceReq from an unbound optional field.");
}
}

PacketResourceReq_template::PacketResourceReq_template(PacketResourceReq_template* p_precondition, PacketResourceReq_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketResourceReq_template::PacketResourceReq_template(Dynamic_Match_Interface<PacketResourceReq>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketResourceReq>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketResourceReq_template::PacketResourceReq_template(const PacketResourceReq_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketResourceReq_template::~PacketResourceReq_template()
{
clean_up();
}

PacketResourceReq_template& PacketResourceReq_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const PacketResourceReq& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const OPTIONAL<PacketResourceReq>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReq&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const PacketResourceReq_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketResourceReq_template::match(const PacketResourceReq& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.acc__type__presence().is_bound()) return FALSE;
if(!single_value->field_acc__type__presence.match(other_value.acc__type__presence(), legacy))return FALSE;
if(!other_value.acc__type().is_bound()) return FALSE;
if((other_value.acc__type().ispresent() ? !single_value->field_acc__type.match((const RlcAccessType&)other_value.acc__type(), legacy) : !single_value->field_acc__type.match_omit(legacy)))return FALSE;
if(!other_value.id__type().is_bound()) return FALSE;
if(!single_value->field_id__type.match(other_value.id__type(), legacy))return FALSE;
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.ms__rac2__presence().is_bound()) return FALSE;
if(!single_value->field_ms__rac2__presence.match(other_value.ms__rac2__presence(), legacy))return FALSE;
if(!other_value.ms__rac2().is_bound()) return FALSE;
if((other_value.ms__rac2().ispresent() ? !single_value->field_ms__rac2.match((const MSRadioAccCap2&)other_value.ms__rac2(), legacy) : !single_value->field_ms__rac2.match_omit(legacy)))return FALSE;
if(!other_value.ch__req__desc().is_bound()) return FALSE;
if(!single_value->field_ch__req__desc.match(other_value.ch__req__desc(), legacy))return FALSE;
if(!other_value.change__mark__presence().is_bound()) return FALSE;
if(!single_value->field_change__mark__presence.match(other_value.change__mark__presence(), legacy))return FALSE;
if(!other_value.change__mark().is_bound()) return FALSE;
if((other_value.change__mark().ispresent() ? !single_value->field_change__mark.match((const BITSTRING&)other_value.change__mark(), legacy) : !single_value->field_change__mark.match_omit(legacy)))return FALSE;
if(!other_value.C__val().is_bound()) return FALSE;
if(!single_value->field_C__val.match(other_value.C__val(), legacy))return FALSE;
if(!other_value.sign__var__presence().is_bound()) return FALSE;
if(!single_value->field_sign__var__presence.match(other_value.sign__var__presence(), legacy))return FALSE;
if(!other_value.sign__var().is_bound()) return FALSE;
if((other_value.sign__var().ispresent() ? !single_value->field_sign__var.match((const BITSTRING&)other_value.sign__var(), legacy) : !single_value->field_sign__var.match_omit(legacy)))return FALSE;
if(!other_value.I__levels().is_bound()) return FALSE;
if(!single_value->field_I__levels.match(other_value.I__levels(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
return FALSE;
}

boolean PacketResourceReq_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_acc__type__presence.is_bound()
 || (single_value->field_acc__type.is_omit() || single_value->field_acc__type.is_bound())
 || single_value->field_id__type.is_bound()
 || single_value->field_id.is_bound()
 || single_value->field_ms__rac2__presence.is_bound()
 || (single_value->field_ms__rac2.is_omit() || single_value->field_ms__rac2.is_bound())
 || single_value->field_ch__req__desc.is_bound()
 || single_value->field_change__mark__presence.is_bound()
 || (single_value->field_change__mark.is_omit() || single_value->field_change__mark.is_bound())
 || single_value->field_C__val.is_bound()
 || single_value->field_sign__var__presence.is_bound()
 || (single_value->field_sign__var.is_omit() || single_value->field_sign__var.is_bound())
 || single_value->field_I__levels.is_bound();
}

boolean PacketResourceReq_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_acc__type__presence.is_value()
 && (single_value->field_acc__type.is_omit() || single_value->field_acc__type.is_value())
 && single_value->field_id__type.is_value()
 && single_value->field_id.is_value()
 && single_value->field_ms__rac2__presence.is_value()
 && (single_value->field_ms__rac2.is_omit() || single_value->field_ms__rac2.is_value())
 && single_value->field_ch__req__desc.is_value()
 && single_value->field_change__mark__presence.is_value()
 && (single_value->field_change__mark.is_omit() || single_value->field_change__mark.is_value())
 && single_value->field_C__val.is_value()
 && single_value->field_sign__var__presence.is_value()
 && (single_value->field_sign__var.is_omit() || single_value->field_sign__var.is_value())
 && single_value->field_I__levels.is_value();
}

void PacketResourceReq_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketResourceReq PacketResourceReq_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
PacketResourceReq ret_val;
if (single_value->field_acc__type__presence.is_bound()) {
ret_val.acc__type__presence() = single_value->field_acc__type__presence.valueof();
}
if (single_value->field_acc__type.is_omit()) ret_val.acc__type() = OMIT_VALUE;
else if (single_value->field_acc__type.is_bound()) {
ret_val.acc__type() = single_value->field_acc__type.valueof();
}
if (single_value->field_id__type.is_bound()) {
ret_val.id__type() = single_value->field_id__type.valueof();
}
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_ms__rac2__presence.is_bound()) {
ret_val.ms__rac2__presence() = single_value->field_ms__rac2__presence.valueof();
}
if (single_value->field_ms__rac2.is_omit()) ret_val.ms__rac2() = OMIT_VALUE;
else if (single_value->field_ms__rac2.is_bound()) {
ret_val.ms__rac2() = single_value->field_ms__rac2.valueof();
}
if (single_value->field_ch__req__desc.is_bound()) {
ret_val.ch__req__desc() = single_value->field_ch__req__desc.valueof();
}
if (single_value->field_change__mark__presence.is_bound()) {
ret_val.change__mark__presence() = single_value->field_change__mark__presence.valueof();
}
if (single_value->field_change__mark.is_omit()) ret_val.change__mark() = OMIT_VALUE;
else if (single_value->field_change__mark.is_bound()) {
ret_val.change__mark() = single_value->field_change__mark.valueof();
}
if (single_value->field_C__val.is_bound()) {
ret_val.C__val() = single_value->field_C__val.valueof();
}
if (single_value->field_sign__var__presence.is_bound()) {
ret_val.sign__var__presence() = single_value->field_sign__var__presence.valueof();
}
if (single_value->field_sign__var.is_omit()) ret_val.sign__var() = OMIT_VALUE;
else if (single_value->field_sign__var.is_bound()) {
ret_val.sign__var() = single_value->field_sign__var.valueof();
}
if (single_value->field_I__levels.is_bound()) {
ret_val.I__levels() = single_value->field_I__levels.valueof();
}
return ret_val;
}

void PacketResourceReq_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketResourceReq_template[list_length];
}

PacketResourceReq_template& PacketResourceReq_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return value_list.list_value[list_index];
}

BITSTRING_template& PacketResourceReq_template::acc__type__presence()
{
set_specific();
return single_value->field_acc__type__presence;
}

const BITSTRING_template& PacketResourceReq_template::acc__type__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field acc_type_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_acc__type__presence;
}

RlcAccessType_template& PacketResourceReq_template::acc__type()
{
set_specific();
return single_value->field_acc__type;
}

const RlcAccessType_template& PacketResourceReq_template::acc__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field acc_type of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_acc__type;
}

BITSTRING_template& PacketResourceReq_template::id__type()
{
set_specific();
return single_value->field_id__type;
}

const BITSTRING_template& PacketResourceReq_template::id__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id_type of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_id__type;
}

PacketResourceReqID_template& PacketResourceReq_template::id()
{
set_specific();
return single_value->field_id;
}

const PacketResourceReqID_template& PacketResourceReq_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_id;
}

BITSTRING_template& PacketResourceReq_template::ms__rac2__presence()
{
set_specific();
return single_value->field_ms__rac2__presence;
}

const BITSTRING_template& PacketResourceReq_template::ms__rac2__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_rac2_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ms__rac2__presence;
}

MSRadioAccCap2_template& PacketResourceReq_template::ms__rac2()
{
set_specific();
return single_value->field_ms__rac2;
}

const MSRadioAccCap2_template& PacketResourceReq_template::ms__rac2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_rac2 of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ms__rac2;
}

ChannelReqDescription_template& PacketResourceReq_template::ch__req__desc()
{
set_specific();
return single_value->field_ch__req__desc;
}

const ChannelReqDescription_template& PacketResourceReq_template::ch__req__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ch_req_desc of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ch__req__desc;
}

BITSTRING_template& PacketResourceReq_template::change__mark__presence()
{
set_specific();
return single_value->field_change__mark__presence;
}

const BITSTRING_template& PacketResourceReq_template::change__mark__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field change_mark_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_change__mark__presence;
}

BITSTRING_template& PacketResourceReq_template::change__mark()
{
set_specific();
return single_value->field_change__mark;
}

const BITSTRING_template& PacketResourceReq_template::change__mark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field change_mark of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_change__mark;
}

BITSTRING_template& PacketResourceReq_template::C__val()
{
set_specific();
return single_value->field_C__val;
}

const BITSTRING_template& PacketResourceReq_template::C__val() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field C_val of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_C__val;
}

BITSTRING_template& PacketResourceReq_template::sign__var__presence()
{
set_specific();
return single_value->field_sign__var__presence;
}

const BITSTRING_template& PacketResourceReq_template::sign__var__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sign_var_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_sign__var__presence;
}

BITSTRING_template& PacketResourceReq_template::sign__var()
{
set_specific();
return single_value->field_sign__var;
}

const BITSTRING_template& PacketResourceReq_template::sign__var() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sign_var of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_sign__var;
}

ILevels_template& PacketResourceReq_template::I__levels()
{
set_specific();
return single_value->field_I__levels;
}

const ILevels_template& PacketResourceReq_template::I__levels() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field I_levels of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return sin