// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "PCUIF_Types.hh"

namespace PCUIF__Types {

/* Member functions of C++ classes */

PCUIF__agch::PCUIF__agch()
{
}

PCUIF__agch::PCUIF__agch(const OCTETSTRING& par_msg__id,
    const OCTETSTRING& par_data,
    const BOOLEAN& par_confirm)
  :   field_msg__id(par_msg__id),
  field_data(par_data),
  field_confirm(par_confirm)
{
}

PCUIF__agch::PCUIF__agch(const PCUIF__agch& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PCUIF_Types.PCUIF_agch.");
if (other_value.msg__id().is_bound()) field_msg__id = other_value.msg__id();
else field_msg__id.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
if (other_value.confirm().is_bound()) field_confirm = other_value.confirm();
else field_confirm.clean_up();
}

void PCUIF__agch::clean_up()
{
field_msg__id.clean_up();
field_data.clean_up();
field_confirm.clean_up();
}

const TTCN_Typedescriptor_t* PCUIF__agch::get_descriptor() const { return &PCUIF__agch_descr_; }
PCUIF__agch& PCUIF__agch::operator=(const PCUIF__agch& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PCUIF_Types.PCUIF_agch.");
  if (other_value.msg__id().is_bound()) field_msg__id = other_value.msg__id();
  else field_msg__id.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
  if (other_value.confirm().is_bound()) field_confirm = other_value.confirm();
  else field_confirm.clean_up();
}
return *this;
}

boolean PCUIF__agch::operator==(const PCUIF__agch& other_value) const
{
return field_msg__id==other_value.field_msg__id
  && field_data==other_value.field_data
  && field_confirm==other_value.field_confirm;
}

boolean PCUIF__agch::is_bound() const
{
return (field_msg__id.is_bound())
  || (field_data.is_bound())
  || (field_confirm.is_bound());
}
boolean PCUIF__agch::is_value() const
{
return field_msg__id.is_value()
  && field_data.is_value()
  && field_confirm.is_value();
}
void PCUIF__agch::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ msg_id := ");
field_msg__id.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(", confirm := ");
field_confirm.log();
TTCN_Logger::log_event_str(" }");
}

void PCUIF__agch::set_implicit_omit()
{
if (msg__id().is_bound()) msg__id().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
if (confirm().is_bound()) confirm().set_implicit_omit();
}

void PCUIF__agch::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PCUIF_Types.PCUIF_agch has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msg__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) confirm().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "confirm")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          confirm().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PCUIF_Types.PCUIF_agch: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PCUIF_Types.PCUIF_agch");
  }
}

void PCUIF__agch::encode_text(Text_Buf& text_buf) const
{
field_msg__id.encode_text(text_buf);
field_data.encode_text(text_buf);
field_confirm.encode_text(text_buf);
}

void PCUIF__agch::decode_text(Text_Buf& text_buf)
{
field_msg__id.decode_text(text_buf);
field_data.decode_text(text_buf);
field_confirm.decode_text(text_buf);
}

void PCUIF__agch::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCUIF__agch::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCUIF__agch::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PCUIF__agch_msg__id_descr_.raw->forceomit);
  decoded_field_length = field_msg__id.RAW_decode(PCUIF__agch_msg__id_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PCUIF__agch_data_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(PCUIF__agch_data_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, PCUIF__agch_confirm_descr_.raw->forceomit);
  decoded_field_length = field_confirm.RAW_decode(PCUIF__agch_confirm_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PCUIF__agch::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PCUIF__agch_msg__id_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PCUIF__agch_data_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PCUIF__agch_confirm_descr_.raw);
  encoded_length += field_msg__id.RAW_encode(PCUIF__agch_msg__id_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_data.RAW_encode(PCUIF__agch_data_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_confirm.RAW_encode(PCUIF__agch_confirm_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PCUIF__agch_template::single_value_struct {
OCTETSTRING_template field_msg__id;
OCTETSTRING_template field_data;
BOOLEAN_template field_confirm;
};

void PCUIF__agch_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_msg__id = ANY_VALUE;
single_value->field_data = ANY_VALUE;
single_value->field_confirm = ANY_VALUE;
}
}
}

void PCUIF__agch_template::copy_value(const PCUIF__agch& other_value)
{
single_value = new single_value_struct;
if (other_value.msg__id().is_bound()) {
  single_value->field_msg__id = other_value.msg__id();
} else {
  single_value->field_msg__id.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
if (other_value.confirm().is_bound()) {
  single_value->field_confirm = other_value.confirm();
} else {
  single_value->field_confirm.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PCUIF__agch_template::copy_template(const PCUIF__agch_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.msg__id().get_selection()) {
single_value->field_msg__id = other_value.msg__id();
} else {
single_value->field_msg__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.confirm().get_selection()) {
single_value->field_confirm = other_value.confirm();
} else {
single_value->field_confirm.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCUIF__agch_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCUIF__agch_template(*other_value.implication_.precondition);
implication_.implied_template = new PCUIF__agch_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_agch.");
break;
}
set_selection(other_value);
}

PCUIF__agch_template::PCUIF__agch_template()
{
}

PCUIF__agch_template::PCUIF__agch_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCUIF__agch_template::PCUIF__agch_template(const PCUIF__agch& other_value)
{
copy_value(other_value);
}

PCUIF__agch_template::PCUIF__agch_template(const OPTIONAL<PCUIF__agch>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__agch&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PCUIF_Types.PCUIF_agch from an unbound optional field.");
}
}

PCUIF__agch_template::PCUIF__agch_template(PCUIF__agch_template* p_precondition, PCUIF__agch_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCUIF__agch_template::PCUIF__agch_template(Dynamic_Match_Interface<PCUIF__agch>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCUIF__agch>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCUIF__agch_template::PCUIF__agch_template(const PCUIF__agch_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PCUIF__agch_template::~PCUIF__agch_template()
{
clean_up();
}

PCUIF__agch_template& PCUIF__agch_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCUIF__agch_template& PCUIF__agch_template::operator=(const PCUIF__agch& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PCUIF__agch_template& PCUIF__agch_template::operator=(const OPTIONAL<PCUIF__agch>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__agch&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PCUIF_Types.PCUIF_agch.");
}
return *this;
}

PCUIF__agch_template& PCUIF__agch_template::operator=(const PCUIF__agch_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCUIF__agch_template::match(const PCUIF__agch& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.msg__id().is_bound()) return FALSE;
if(!single_value->field_msg__id.match(other_value.msg__id(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
if(!other_value.confirm().is_bound()) return FALSE;
if(!single_value->field_confirm.match(other_value.confirm(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_agch.");
}
return FALSE;
}

boolean PCUIF__agch_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_msg__id.is_bound()
 || single_value->field_data.is_bound()
 || single_value->field_confirm.is_bound();
}

boolean PCUIF__agch_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_msg__id.is_value()
 && single_value->field_data.is_value()
 && single_value->field_confirm.is_value();
}

void PCUIF__agch_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCUIF__agch PCUIF__agch_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PCUIF_Types.PCUIF_agch.");
PCUIF__agch ret_val;
if (single_value->field_msg__id.is_bound()) {
ret_val.msg__id() = single_value->field_msg__id.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
if (single_value->field_confirm.is_bound()) {
ret_val.confirm() = single_value->field_confirm.valueof();
}
return ret_val;
}

void PCUIF__agch_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PCUIF_Types.PCUIF_agch.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCUIF__agch_template[list_length];
}

PCUIF__agch_template& PCUIF__agch_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PCUIF_Types.PCUIF_agch.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PCUIF_Types.PCUIF_agch.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PCUIF__agch_template::msg__id()
{
set_specific();
return single_value->field_msg__id;
}

const OCTETSTRING_template& PCUIF__agch_template::msg__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg_id of a non-specific template of type @PCUIF_Types.PCUIF_agch.");
return single_value->field_msg__id;
}

OCTETSTRING_template& PCUIF__agch_template::data()
{
set_specific();
return single_value->field_data;
}

const OCTETSTRING_template& PCUIF__agch_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @PCUIF_Types.PCUIF_agch.");
return single_value->field_data;
}

BOOLEAN_template& PCUIF__agch_template::confirm()
{
set_specific();
return single_value->field_confirm;
}

const BOOLEAN_template& PCUIF__agch_template::confirm() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field confirm of a non-specific template of type @PCUIF_Types.PCUIF_agch.");
return single_value->field_confirm;
}

int PCUIF__agch_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_agch containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_agch.");
  }
  return 0;
}

void PCUIF__agch_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ msg_id := ");
single_value->field_msg__id.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(", confirm := ");
single_value->field_confirm.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCUIF__agch_template::log_match(const PCUIF__agch& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_msg__id.match(match_value.msg__id(), legacy)){
TTCN_Logger::log_logmatch_info(".msg_id");
single_value->field_msg__id.log_match(match_value.msg__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_confirm.match(match_value.confirm(), legacy)){
TTCN_Logger::log_logmatch_info(".confirm");
single_value->field_confirm.log_match(match_value.confirm(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ msg_id := ");
single_value->field_msg__id.log_match(match_value.msg__id(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(", confirm := ");
single_value->field_confirm.log_match(match_value.confirm(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PCUIF__agch_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (msg__id().is_bound()) msg__id().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
if (confirm().is_bound()) confirm().set_implicit_omit();
}

void PCUIF__agch_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_msg__id.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
single_value->field_confirm.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_agch.");
}
}

void PCUIF__agch_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_msg__id.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
single_value->field_confirm.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCUIF__agch_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PCUIF_Types.PCUIF_agch.");
}
}

void PCUIF__agch_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCUIF__agch_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PCUIF_Types.PCUIF_agch has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msg__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) confirm().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "confirm")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          confirm().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PCUIF_Types.PCUIF_agch: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PCUIF__agch_template* precondition = new PCUIF__agch_template;
    precondition->set_param(*param.get_elem(0));
    PCUIF__agch_template* implied_template = new PCUIF__agch_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PCUIF__agch_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PCUIF_Types.PCUIF_agch");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCUIF__agch_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_msg__id.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_agch");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_agch");
single_value->field_confirm.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_agch");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PCUIF_Types.PCUIF_agch");
}

boolean PCUIF__agch_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCUIF__agch_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCUIF__MsgUnion::copy_value(const PCUIF__MsgUnion& other_value)
{
switch (other_value.union_selection) {
case ALT_data__req:
field_data__req = new PCUIF__data(*other_value.field_data__req);
break;
case ALT_data__cnf2:
field_data__cnf2 = new PCUIF__data__cnf(*other_value.field_data__cnf2);
break;
case ALT_data__ind:
field_data__ind = new PCUIF__data(*other_value.field_data__ind);
break;
case ALT_susp__req:
field_susp__req = new PCUIF__susp__req(*other_value.field_susp__req);
break;
case ALT_rts__req:
field_rts__req = new PCUIF__rts__req(*other_value.field_rts__req);
break;
case ALT_rach__ind:
field_rach__ind = new PCUIF__rach__ind(*other_value.field_rach__ind);
break;
case ALT_txt__ind:
field_txt__ind = new PCUIF__txt__ind(*other_value.field_txt__ind);
break;
case ALT_info__ind:
field_info__ind = new PCUIF__info__ind(*other_value.field_info__ind);
break;
case ALT_e1__ccu__ind:
field_e1__ccu__ind = new PCUIF__e1__ccu__ind(*other_value.field_e1__ccu__ind);
break;
case ALT_act__req:
field_act__req = new PCUIF__act__req(*other_value.field_act__req);
break;
case ALT_time__ind:
field_time__ind = new PCUIF__time__ind(*other_value.field_time__ind);
break;
case ALT_interf__ind:
field_interf__ind = new PCUIF__interf__ind(*other_value.field_interf__ind);
break;
case ALT_pag__req:
field_pag__req = new PCUIF__pag__req(*other_value.field_pag__req);
break;
case ALT_app__info__req:
field_app__info__req = new PCUIF__app__info__req(*other_value.field_app__info__req);
break;
case ALT_container:
field_container = new PCUIF__container(*other_value.field_container);
break;
default:
TTCN_error("Assignment of an unbound union value of type @PCUIF_Types.PCUIF_MsgUnion.");
}
union_selection = other_value.union_selection;
}

PCUIF__MsgUnion::PCUIF__MsgUnion()
{
union_selection = UNBOUND_VALUE;
}

PCUIF__MsgUnion::PCUIF__MsgUnion(const PCUIF__MsgUnion& other_value)
: Base_Type(){
copy_value(other_value);
}

PCUIF__MsgUnion::~PCUIF__MsgUnion()
{
clean_up();
}

PCUIF__MsgUnion& PCUIF__MsgUnion::operator=(const PCUIF__MsgUnion& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PCUIF__MsgUnion::operator==(const PCUIF__MsgUnion& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_data__req:
return *field_data__req == *other_value.field_data__req;
case ALT_data__cnf2:
return *field_data__cnf2 == *other_value.field_data__cnf2;
case ALT_data__ind:
return *field_data__ind == *other_value.field_data__ind;
case ALT_susp__req:
return *field_susp__req == *other_value.field_susp__req;
case ALT_rts__req:
return *field_rts__req == *other_value.field_rts__req;
case ALT_rach__ind:
return *field_rach__ind == *other_value.field_rach__ind;
case ALT_txt__ind:
return *field_txt__ind == *other_value.field_txt__ind;
case ALT_info__ind:
return *field_info__ind == *other_value.field_info__ind;
case ALT_e1__ccu__ind:
return *field_e1__ccu__ind == *other_value.field_e1__ccu__ind;
case ALT_act__req:
return *field_act__req == *other_value.field_act__req;
case ALT_time__ind:
return *field_time__ind == *other_value.field_time__ind;
case ALT_interf__ind:
return *field_interf__ind == *other_value.field_interf__ind;
case ALT_pag__req:
return *field_pag__req == *other_value.field_pag__req;
case ALT_app__info__req:
return *field_app__info__req == *other_value.field_app__info__req;
case ALT_container:
return *field_container == *other_value.field_container;
default:
return FALSE;
}
}

PCUIF__data& PCUIF__MsgUnion::data__req()
{
if (union_selection != ALT_data__req) {
clean_up();
field_data__req = new PCUIF__data;
union_selection = ALT_data__req;
}
return *field_data__req;
}

const PCUIF__data& PCUIF__MsgUnion::data__req() const
{
if (union_selection != ALT_data__req) TTCN_error("Using non-selected field data_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_data__req;
}

PCUIF__data__cnf& PCUIF__MsgUnion::data__cnf2()
{
if (union_selection != ALT_data__cnf2) {
clean_up();
field_data__cnf2 = new PCUIF__data__cnf;
union_selection = ALT_data__cnf2;
}
return *field_data__cnf2;
}

const PCUIF__data__cnf& PCUIF__MsgUnion::data__cnf2() const
{
if (union_selection != ALT_data__cnf2) TTCN_error("Using non-selected field data_cnf2 in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_data__cnf2;
}

PCUIF__data& PCUIF__MsgUnion::data__ind()
{
if (union_selection != ALT_data__ind) {
clean_up();
field_data__ind = new PCUIF__data;
union_selection = ALT_data__ind;
}
return *field_data__ind;
}

const PCUIF__data& PCUIF__MsgUnion::data__ind() const
{
if (union_selection != ALT_data__ind) TTCN_error("Using non-selected field data_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_data__ind;
}

PCUIF__susp__req& PCUIF__MsgUnion::susp__req()
{
if (union_selection != ALT_susp__req) {
clean_up();
field_susp__req = new PCUIF__susp__req;
union_selection = ALT_susp__req;
}
return *field_susp__req;
}

const PCUIF__susp__req& PCUIF__MsgUnion::susp__req() const
{
if (union_selection != ALT_susp__req) TTCN_error("Using non-selected field susp_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_susp__req;
}

PCUIF__rts__req& PCUIF__MsgUnion::rts__req()
{
if (union_selection != ALT_rts__req) {
clean_up();
field_rts__req = new PCUIF__rts__req;
union_selection = ALT_rts__req;
}
return *field_rts__req;
}

const PCUIF__rts__req& PCUIF__MsgUnion::rts__req() const
{
if (union_selection != ALT_rts__req) TTCN_error("Using non-selected field rts_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_rts__req;
}

PCUIF__rach__ind& PCUIF__MsgUnion::rach__ind()
{
if (union_selection != ALT_rach__ind) {
clean_up();
field_rach__ind = new PCUIF__rach__ind;
union_selection = ALT_rach__ind;
}
return *field_rach__ind;
}

const PCUIF__rach__ind& PCUIF__MsgUnion::rach__ind() const
{
if (union_selection != ALT_rach__ind) TTCN_error("Using non-selected field rach_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_rach__ind;
}

PCUIF__txt__ind& PCUIF__MsgUnion::txt__ind()
{
if (union_selection != ALT_txt__ind) {
clean_up();
field_txt__ind = new PCUIF__txt__ind;
union_selection = ALT_txt__ind;
}
return *field_txt__ind;
}

const PCUIF__txt__ind& PCUIF__MsgUnion::txt__ind() const
{
if (union_selection != ALT_txt__ind) TTCN_error("Using non-selected field txt_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_txt__ind;
}

PCUIF__info__ind& PCUIF__MsgUnion::info__ind()
{
if (union_selection != ALT_info__ind) {
clean_up();
field_info__ind = new PCUIF__info__ind;
union_selection = ALT_info__ind;
}
return *field_info__ind;
}

const PCUIF__info__ind& PCUIF__MsgUnion::info__ind() const
{
if (union_selection != ALT_info__ind) TTCN_error("Using non-selected field info_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_info__ind;
}

PCUIF__e1__ccu__ind& PCUIF__MsgUnion::e1__ccu__ind()
{
if (union_selection != ALT_e1__ccu__ind) {
clean_up();
field_e1__ccu__ind = new PCUIF__e1__ccu__ind;
union_selection = ALT_e1__ccu__ind;
}
return *field_e1__ccu__ind;
}

const PCUIF__e1__ccu__ind& PCUIF__MsgUnion::e1__ccu__ind() const
{
if (union_selection != ALT_e1__ccu__ind) TTCN_error("Using non-selected field e1_ccu_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_e1__ccu__ind;
}

PCUIF__act__req& PCUIF__MsgUnion::act__req()
{
if (union_selection != ALT_act__req) {
clean_up();
field_act__req = new PCUIF__act__req;
union_selection = ALT_act__req;
}
return *field_act__req;
}

const PCUIF__act__req& PCUIF__MsgUnion::act__req() const
{
if (union_selection != ALT_act__req) TTCN_error("Using non-selected field act_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_act__req;
}

PCUIF__time__ind& PCUIF__MsgUnion::time__ind()
{
if (union_selection != ALT_time__ind) {
clean_up();
field_time__ind = new PCUIF__time__ind;
union_selection = ALT_time__ind;
}
return *field_time__ind;
}

const PCUIF__time__ind& PCUIF__MsgUnion::time__ind() const
{
if (union_selection != ALT_time__ind) TTCN_error("Using non-selected field time_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_time__ind;
}

PCUIF__interf__ind& PCUIF__MsgUnion::interf__ind()
{
if (union_selection != ALT_interf__ind) {
clean_up();
field_interf__ind = new PCUIF__interf__ind;
union_selection = ALT_interf__ind;
}
return *field_interf__ind;
}

const PCUIF__interf__ind& PCUIF__MsgUnion::interf__ind() const
{
if (union_selection != ALT_interf__ind) TTCN_error("Using non-selected field interf_ind in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_interf__ind;
}

PCUIF__pag__req& PCUIF__MsgUnion::pag__req()
{
if (union_selection != ALT_pag__req) {
clean_up();
field_pag__req = new PCUIF__pag__req;
union_selection = ALT_pag__req;
}
return *field_pag__req;
}

const PCUIF__pag__req& PCUIF__MsgUnion::pag__req() const
{
if (union_selection != ALT_pag__req) TTCN_error("Using non-selected field pag_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_pag__req;
}

PCUIF__app__info__req& PCUIF__MsgUnion::app__info__req()
{
if (union_selection != ALT_app__info__req) {
clean_up();
field_app__info__req = new PCUIF__app__info__req;
union_selection = ALT_app__info__req;
}
return *field_app__info__req;
}

const PCUIF__app__info__req& PCUIF__MsgUnion::app__info__req() const
{
if (union_selection != ALT_app__info__req) TTCN_error("Using non-selected field app_info_req in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_app__info__req;
}

PCUIF__container& PCUIF__MsgUnion::container()
{
if (union_selection != ALT_container) {
clean_up();
field_container = new PCUIF__container;
union_selection = ALT_container;
}
return *field_container;
}

const PCUIF__container& PCUIF__MsgUnion::container() const
{
if (union_selection != ALT_container) TTCN_error("Using non-selected field container in a value of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *field_container;
}

boolean PCUIF__MsgUnion::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @PCUIF_Types.PCUIF_MsgUnion.");
return union_selection == checked_selection;
}

boolean PCUIF__MsgUnion::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PCUIF__MsgUnion::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_data__req: return field_data__req->is_value();
case ALT_data__cnf2: return field_data__cnf2->is_value();
case ALT_data__ind: return field_data__ind->is_value();
case ALT_susp__req: return field_susp__req->is_value();
case ALT_rts__req: return field_rts__req->is_value();
case ALT_rach__ind: return field_rach__ind->is_value();
case ALT_txt__ind: return field_txt__ind->is_value();
case ALT_info__ind: return field_info__ind->is_value();
case ALT_e1__ccu__ind: return field_e1__ccu__ind->is_value();
case ALT_act__req: return field_act__req->is_value();
case ALT_time__ind: return field_time__ind->is_value();
case ALT_interf__ind: return field_interf__ind->is_value();
case ALT_pag__req: return field_pag__req->is_value();
case ALT_app__info__req: return field_app__info__req->is_value();
case ALT_container: return field_container->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PCUIF__MsgUnion::clean_up()
{
switch (union_selection) {
case ALT_data__req:
  delete field_data__req;
  break;
case ALT_data__cnf2:
  delete field_data__cnf2;
  break;
case ALT_data__ind:
  delete field_data__ind;
  break;
case ALT_susp__req:
  delete field_susp__req;
  break;
case ALT_rts__req:
  delete field_rts__req;
  break;
case ALT_rach__ind:
  delete field_rach__ind;
  break;
case ALT_txt__ind:
  delete field_txt__ind;
  break;
case ALT_info__ind:
  delete field_info__ind;
  break;
case ALT_e1__ccu__ind:
  delete field_e1__ccu__ind;
  break;
case ALT_act__req:
  delete field_act__req;
  break;
case ALT_time__ind:
  delete field_time__ind;
  break;
case ALT_interf__ind:
  delete field_interf__ind;
  break;
case ALT_pag__req:
  delete field_pag__req;
  break;
case ALT_app__info__req:
  delete field_app__info__req;
  break;
case ALT_container:
  delete field_container;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PCUIF__MsgUnion::log() const
{
switch (union_selection) {
case ALT_data__req:
TTCN_Logger::log_event_str("{ data_req := ");
field_data__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_data__cnf2:
TTCN_Logger::log_event_str("{ data_cnf2 := ");
field_data__cnf2->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_data__ind:
TTCN_Logger::log_event_str("{ data_ind := ");
field_data__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_susp__req:
TTCN_Logger::log_event_str("{ susp_req := ");
field_susp__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rts__req:
TTCN_Logger::log_event_str("{ rts_req := ");
field_rts__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rach__ind:
TTCN_Logger::log_event_str("{ rach_ind := ");
field_rach__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_txt__ind:
TTCN_Logger::log_event_str("{ txt_ind := ");
field_txt__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_info__ind:
TTCN_Logger::log_event_str("{ info_ind := ");
field_info__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_e1__ccu__ind:
TTCN_Logger::log_event_str("{ e1_ccu_ind := ");
field_e1__ccu__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_act__req:
TTCN_Logger::log_event_str("{ act_req := ");
field_act__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_time__ind:
TTCN_Logger::log_event_str("{ time_ind := ");
field_time__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_interf__ind:
TTCN_Logger::log_event_str("{ interf_ind := ");
field_interf__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_pag__req:
TTCN_Logger::log_event_str("{ pag_req := ");
field_pag__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_app__info__req:
TTCN_Logger::log_event_str("{ app_info_req := ");
field_app__info__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_container:
TTCN_Logger::log_event_str("{ container := ");
field_container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PCUIF__MsgUnion::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "data_req")) {
    data__req().set_param(*mp_last);
    if (!data__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "data_cnf2")) {
    data__cnf2().set_param(*mp_last);
    if (!data__cnf2().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "data_ind")) {
    data__ind().set_param(*mp_last);
    if (!data__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "susp_req")) {
    susp__req().set_param(*mp_last);
    if (!susp__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rts_req")) {
    rts__req().set_param(*mp_last);
    if (!rts__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rach_ind")) {
    rach__ind().set_param(*mp_last);
    if (!rach__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "txt_ind")) {
    txt__ind().set_param(*mp_last);
    if (!txt__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "info_ind")) {
    info__ind().set_param(*mp_last);
    if (!info__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "e1_ccu_ind")) {
    e1__ccu__ind().set_param(*mp_last);
    if (!e1__ccu__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "act_req")) {
    act__req().set_param(*mp_last);
    if (!act__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "time_ind")) {
    time__ind().set_param(*mp_last);
    if (!time__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "interf_ind")) {
    interf__ind().set_param(*mp_last);
    if (!interf__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "pag_req")) {
    pag__req().set_param(*mp_last);
    if (!pag__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "app_info_req")) {
    app__info__req().set_param(*mp_last);
    if (!app__info__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "container")) {
    container().set_param(*mp_last);
    if (!container().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @PCUIF_Types.PCUIF_MsgUnion.", last_name);
}

void PCUIF__MsgUnion::set_implicit_omit()
{
switch (union_selection) {
case ALT_data__req:
field_data__req->set_implicit_omit(); break;
case ALT_data__cnf2:
field_data__cnf2->set_implicit_omit(); break;
case ALT_data__ind:
field_data__ind->set_implicit_omit(); break;
case ALT_susp__req:
field_susp__req->set_implicit_omit(); break;
case ALT_rts__req:
field_rts__req->set_implicit_omit(); break;
case ALT_rach__ind:
field_rach__ind->set_implicit_omit(); break;
case ALT_txt__ind:
field_txt__ind->set_implicit_omit(); break;
case ALT_info__ind:
field_info__ind->set_implicit_omit(); break;
case ALT_e1__ccu__ind:
field_e1__ccu__ind->set_implicit_omit(); break;
case ALT_act__req:
field_act__req->set_implicit_omit(); break;
case ALT_time__ind:
field_time__ind->set_implicit_omit(); break;
case ALT_interf__ind:
field_interf__ind->set_implicit_omit(); break;
case ALT_pag__req:
field_pag__req->set_implicit_omit(); break;
case ALT_app__info__req:
field_app__info__req->set_implicit_omit(); break;
case ALT_container:
field_container->set_implicit_omit(); break;
default: break;
}
}

void PCUIF__MsgUnion::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_data__req:
field_data__req->encode_text(text_buf);
break;
case ALT_data__cnf2:
field_data__cnf2->encode_text(text_buf);
break;
case ALT_data__ind:
field_data__ind->encode_text(text_buf);
break;
case ALT_susp__req:
field_susp__req->encode_text(text_buf);
break;
case ALT_rts__req:
field_rts__req->encode_text(text_buf);
break;
case ALT_rach__ind:
field_rach__ind->encode_text(text_buf);
break;
case ALT_txt__ind:
field_txt__ind->encode_text(text_buf);
break;
case ALT_info__ind:
field_info__ind->encode_text(text_buf);
break;
case ALT_e1__ccu__ind:
field_e1__ccu__ind->encode_text(text_buf);
break;
case ALT_act__req:
field_act__req->encode_text(text_buf);
break;
case ALT_time__ind:
field_time__ind->encode_text(text_buf);
break;
case ALT_interf__ind:
field_interf__ind->encode_text(text_buf);
break;
case ALT_pag__req:
field_pag__req->encode_text(text_buf);
break;
case ALT_app__info__req:
field_app__info__req->encode_text(text_buf);
break;
case ALT_container:
field_container->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
}

void PCUIF__MsgUnion::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_data__req:
data__req().decode_text(text_buf);
break;
case ALT_data__cnf2:
data__cnf2().decode_text(text_buf);
break;
case ALT_data__ind:
data__ind().decode_text(text_buf);
break;
case ALT_susp__req:
susp__req().decode_text(text_buf);
break;
case ALT_rts__req:
rts__req().decode_text(text_buf);
break;
case ALT_rach__ind:
rach__ind().decode_text(text_buf);
break;
case ALT_txt__ind:
txt__ind().decode_text(text_buf);
break;
case ALT_info__ind:
info__ind().decode_text(text_buf);
break;
case ALT_e1__ccu__ind:
e1__ccu__ind().decode_text(text_buf);
break;
case ALT_act__req:
act__req().decode_text(text_buf);
break;
case ALT_time__ind:
time__ind().decode_text(text_buf);
break;
case ALT_interf__ind:
interf__ind().decode_text(text_buf);
break;
case ALT_pag__req:
pag__req().decode_text(text_buf);
break;
case ALT_app__info__req:
app__info__req().decode_text(text_buf);
break;
case ALT_container:
container().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @PCUIF_Types.PCUIF_MsgUnion.");
}
}

void PCUIF__MsgUnion::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCUIF__MsgUnion::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCUIF__MsgUnion::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PCUIF__MsgUnion_data__req_descr_.raw->forceomit);
      decoded_length = data__req().RAW_decode(PCUIF__MsgUnion_data__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PCUIF__MsgUnion_data__cnf2_descr_.raw->forceomit);
      decoded_length = data__cnf2().RAW_decode(PCUIF__MsgUnion_data__cnf2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PCUIF__MsgUnion_data__ind_descr_.raw->forceomit);
      decoded_length = data__ind().RAW_decode(PCUIF__MsgUnion_data__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, PCUIF__MsgUnion_susp__req_descr_.raw->forceomit);
      decoded_length = susp__req().RAW_decode(PCUIF__MsgUnion_susp__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, PCUIF__MsgUnion_rts__req_descr_.raw->forceomit);
      decoded_length = rts__req().RAW_decode(PCUIF__MsgUnion_rts__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, PCUIF__MsgUnion_rach__ind_descr_.raw->forceomit);
      decoded_length = rach__ind().RAW_decode(PCUIF__MsgUnion_rach__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, PCUIF__MsgUnion_txt__ind_descr_.raw->forceomit);
      decoded_length = txt__ind().RAW_decode(PCUIF__MsgUnion_txt__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, PCUIF__MsgUnion_info__ind_descr_.raw->forceomit);
      decoded_length = info__ind().RAW_decode(PCUIF__MsgUnion_info__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, PCUIF__MsgUnion_e1__ccu__ind_descr_.raw->forceomit);
      decoded_length = e1__ccu__ind().RAW_decode(PCUIF__MsgUnion_e1__ccu__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, PCUIF__MsgUnion_act__req_descr_.raw->forceomit);
      decoded_length = act__req().RAW_decode(PCUIF__MsgUnion_act__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, PCUIF__MsgUnion_time__ind_descr_.raw->forceomit);
      decoded_length = time__ind().RAW_decode(PCUIF__MsgUnion_time__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, PCUIF__MsgUnion_interf__ind_descr_.raw->forceomit);
      decoded_length = interf__ind().RAW_decode(PCUIF__MsgUnion_interf__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, PCUIF__MsgUnion_pag__req_descr_.raw->forceomit);
      decoded_length = pag__req().RAW_decode(PCUIF__MsgUnion_pag__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, PCUIF__MsgUnion_app__info__req_descr_.raw->forceomit);
      decoded_length = app__info__req().RAW_decode(PCUIF__MsgUnion_app__info__req_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, PCUIF__MsgUnion_container_descr_.raw->forceomit);
      decoded_length = container().RAW_decode(PCUIF__MsgUnion_container_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, PCUIF__MsgUnion_data__req_descr_.raw->forceomit);
      decoded_length = data__req().RAW_decode(PCUIF__MsgUnion_data__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, PCUIF__MsgUnion_data__cnf2_descr_.raw->forceomit);
      decoded_length = data__cnf2().RAW_decode(PCUIF__MsgUnion_data__cnf2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, PCUIF__MsgUnion_data__ind_descr_.raw->forceomit);
      decoded_length = data__ind().RAW_decode(PCUIF__MsgUnion_data__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, PCUIF__MsgUnion_susp__req_descr_.raw->forceomit);
      decoded_length = susp__req().RAW_decode(PCUIF__MsgUnion_susp__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, PCUIF__MsgUnion_rts__req_descr_.raw->forceomit);
      decoded_length = rts__req().RAW_decode(PCUIF__MsgUnion_rts__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, PCUIF__MsgUnion_rach__ind_descr_.raw->forceomit);
      decoded_length = rach__ind().RAW_decode(PCUIF__MsgUnion_rach__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, PCUIF__MsgUnion_txt__ind_descr_.raw->forceomit);
      decoded_length = txt__ind().RAW_decode(PCUIF__MsgUnion_txt__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, PCUIF__MsgUnion_info__ind_descr_.raw->forceomit);
      decoded_length = info__ind().RAW_decode(PCUIF__MsgUnion_info__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, PCUIF__MsgUnion_e1__ccu__ind_descr_.raw->forceomit);
      decoded_length = e1__ccu__ind().RAW_decode(PCUIF__MsgUnion_e1__ccu__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, PCUIF__MsgUnion_act__req_descr_.raw->forceomit);
      decoded_length = act__req().RAW_decode(PCUIF__MsgUnion_act__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_10_force_omit(10, force_omit, PCUIF__MsgUnion_time__ind_descr_.raw->forceomit);
      decoded_length = time__ind().RAW_decode(PCUIF__MsgUnion_time__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_10_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_11_force_omit(11, force_omit, PCUIF__MsgUnion_interf__ind_descr_.raw->forceomit);
      decoded_length = interf__ind().RAW_decode(PCUIF__MsgUnion_interf__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_11_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_12_force_omit(12, force_omit, PCUIF__MsgUnion_pag__req_descr_.raw->forceomit);
      decoded_length = pag__req().RAW_decode(PCUIF__MsgUnion_pag__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_12_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_13_force_omit(13, force_omit, PCUIF__MsgUnion_app__info__req_descr_.raw->forceomit);
      decoded_length = app__info__req().RAW_decode(PCUIF__MsgUnion_app__info__req_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_13_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_14_force_omit(14, force_omit, PCUIF__MsgUnion_container_descr_.raw->forceomit);
      decoded_length = container().RAW_decode(PCUIF__MsgUnion_container_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_14_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int PCUIF__MsgUnion::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 15;  myleaf.body.node.nodes = init_nodes_of_enc_tree(15);
  memset(myleaf.body.node.nodes, 0, 15 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_data__req:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PCUIF__MsgUnion_data__req_descr_.raw);
    encoded_length = field_data__req->RAW_encode(PCUIF__MsgUnion_data__req_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PCUIF__MsgUnion_data__req_descr_;
    break;
  case ALT_data__cnf2:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PCUIF__MsgUnion_data__cnf2_descr_.raw);
    encoded_length = field_data__cnf2->RAW_encode(PCUIF__MsgUnion_data__cnf2_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PCUIF__MsgUnion_data__cnf2_descr_;
    break;
  case ALT_data__ind:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PCUIF__MsgUnion_data__ind_descr_.raw);
    encoded_length = field_data__ind->RAW_encode(PCUIF__MsgUnion_data__ind_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PCUIF__MsgUnion_data__ind_descr_;
    break;
  case ALT_susp__req:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, PCUIF__MsgUnion_susp__req_descr_.raw);
    encoded_length = field_susp__req->RAW_encode(PCUIF__MsgUnion_susp__req_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &PCUIF__MsgUnion_susp__req_descr_;
    break;
  case ALT_rts__req:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, PCUIF__MsgUnion_rts__req_descr_.raw);
    encoded_length = field_rts__req->RAW_encode(PCUIF__MsgUnion_rts__req_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &PCUIF__MsgUnion_rts__req_descr_;
    break;
  case ALT_rach__ind:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, PCUIF__MsgUnion_rach__ind_descr_.raw);
    encoded_length = field_rach__ind->RAW_encode(PCUIF__MsgUnion_rach__ind_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &PCUIF__MsgUnion_rach__ind_descr_;
    break;
  case ALT_txt__ind:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, PCUIF__MsgUnion_txt__ind_descr_.raw);
    encoded_length = field_txt__ind->RAW_encode(PCUIF__MsgUnion_txt__ind_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &PCUIF__MsgUnion_txt__ind_descr_;
    break;
  case ALT_info__ind:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, PCUIF__MsgUnion_info__ind_descr_.raw);
    encoded_length = field_info__ind->RAW_encode(PCUIF__MsgUnion_info__ind_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &PCUIF__MsgUnion_info__ind_descr_;
    break;
  case ALT_e1__ccu__ind:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, PCUIF__MsgUnion_e1__ccu__ind_descr_.raw);
    encoded_length = field_e1__ccu__ind->RAW_encode(PCUIF__MsgUnion_e1__ccu__ind_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &PCUIF__MsgUnion_e1__ccu__ind_descr_;
    break;
  case ALT_act__req:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, PCUIF__MsgUnion_act__req_descr_.raw);
    encoded_length = field_act__req->RAW_encode(PCUIF__MsgUnion_act__req_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &PCUIF__MsgUnion_act__req_descr_;
    break;
  case ALT_time__ind:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, PCUIF__MsgUnion_time__ind_descr_.raw);
    encoded_length = field_time__ind->RAW_encode(PCUIF__MsgUnion_time__ind_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &PCUIF__MsgUnion_time__ind_descr_;
    break;
  case ALT_interf__ind:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, PCUIF__MsgUnion_interf__ind_descr_.raw);
    encoded_length = field_interf__ind->RAW_encode(PCUIF__MsgUnion_interf__ind_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &PCUIF__MsgUnion_interf__ind_descr_;
    break;
  case ALT_pag__req:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, PCUIF__MsgUnion_pag__req_descr_.raw);
    encoded_length = field_pag__req->RAW_encode(PCUIF__MsgUnion_pag__req_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &PCUIF__MsgUnion_pag__req_descr_;
    break;
  case ALT_app__info__req:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, PCUIF__MsgUnion_app__info__req_descr_.raw);
    encoded_length = field_app__info__req->RAW_encode(PCUIF__MsgUnion_app__info__req_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &PCUIF__MsgUnion_app__info__req_descr_;
    break;
  case ALT_container:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, PCUIF__MsgUnion_container_descr_.raw);
    encoded_length = field_container->RAW_encode(PCUIF__MsgUnion_container_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &PCUIF__MsgUnion_container_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PCUIF__MsgUnion_template::copy_value(const PCUIF__MsgUnion& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req = new PCUIF__data_template(other_value.data__req());
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2 = new PCUIF__data__cnf_template(other_value.data__cnf2());
break;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind = new PCUIF__data_template(other_value.data__ind());
break;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req = new PCUIF__susp__req_template(other_value.susp__req());
break;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req = new PCUIF__rts__req_template(other_value.rts__req());
break;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind = new PCUIF__rach__ind_template(other_value.rach__ind());
break;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind = new PCUIF__txt__ind_template(other_value.txt__ind());
break;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind = new PCUIF__info__ind_template(other_value.info__ind());
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind = new PCUIF__e1__ccu__ind_template(other_value.e1__ccu__ind());
break;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req = new PCUIF__act__req_template(other_value.act__req());
break;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind = new PCUIF__time__ind_template(other_value.time__ind());
break;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind = new PCUIF__interf__ind_template(other_value.interf__ind());
break;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req = new PCUIF__pag__req_template(other_value.pag__req());
break;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req = new PCUIF__app__info__req_template(other_value.app__info__req());
break;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container = new PCUIF__container_template(other_value.container());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @PCUIF_Types.PCUIF_MsgUnion.");
}
set_selection(SPECIFIC_VALUE);
}

void PCUIF__MsgUnion_template::copy_template(const PCUIF__MsgUnion_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req = new PCUIF__data_template(*other_value.single_value.field_data__req);
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2 = new PCUIF__data__cnf_template(*other_value.single_value.field_data__cnf2);
break;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind = new PCUIF__data_template(*other_value.single_value.field_data__ind);
break;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req = new PCUIF__susp__req_template(*other_value.single_value.field_susp__req);
break;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req = new PCUIF__rts__req_template(*other_value.single_value.field_rts__req);
break;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind = new PCUIF__rach__ind_template(*other_value.single_value.field_rach__ind);
break;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind = new PCUIF__txt__ind_template(*other_value.single_value.field_txt__ind);
break;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind = new PCUIF__info__ind_template(*other_value.single_value.field_info__ind);
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind = new PCUIF__e1__ccu__ind_template(*other_value.single_value.field_e1__ccu__ind);
break;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req = new PCUIF__act__req_template(*other_value.single_value.field_act__req);
break;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind = new PCUIF__time__ind_template(*other_value.single_value.field_time__ind);
break;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind = new PCUIF__interf__ind_template(*other_value.single_value.field_interf__ind);
break;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req = new PCUIF__pag__req_template(*other_value.single_value.field_pag__req);
break;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req = new PCUIF__app__info__req_template(*other_value.single_value.field_app__info__req);
break;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container = new PCUIF__container_template(*other_value.single_value.field_container);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @PCUIF_Types.PCUIF_MsgUnion.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCUIF__MsgUnion_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCUIF__MsgUnion_template(*other_value.implication_.precondition);
implication_.implied_template = new PCUIF__MsgUnion_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
set_selection(other_value);
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template()
{
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(const PCUIF__MsgUnion& other_value)
{
copy_value(other_value);
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(const OPTIONAL<PCUIF__MsgUnion>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__MsgUnion&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @PCUIF_Types.PCUIF_MsgUnion from an unbound optional field.");
}
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(PCUIF__MsgUnion_template* p_precondition, PCUIF__MsgUnion_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(Dynamic_Match_Interface<PCUIF__MsgUnion>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCUIF__MsgUnion>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCUIF__MsgUnion_template::PCUIF__MsgUnion_template(const PCUIF__MsgUnion_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PCUIF__MsgUnion_template::~PCUIF__MsgUnion_template()
{
clean_up();
}

void PCUIF__MsgUnion_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
delete single_value.field_data__req;
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
delete single_value.field_data__cnf2;
break;
case PCUIF__MsgUnion::ALT_data__ind:
delete single_value.field_data__ind;
break;
case PCUIF__MsgUnion::ALT_susp__req:
delete single_value.field_susp__req;
break;
case PCUIF__MsgUnion::ALT_rts__req:
delete single_value.field_rts__req;
break;
case PCUIF__MsgUnion::ALT_rach__ind:
delete single_value.field_rach__ind;
break;
case PCUIF__MsgUnion::ALT_txt__ind:
delete single_value.field_txt__ind;
break;
case PCUIF__MsgUnion::ALT_info__ind:
delete single_value.field_info__ind;
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
delete single_value.field_e1__ccu__ind;
break;
case PCUIF__MsgUnion::ALT_act__req:
delete single_value.field_act__req;
break;
case PCUIF__MsgUnion::ALT_time__ind:
delete single_value.field_time__ind;
break;
case PCUIF__MsgUnion::ALT_interf__ind:
delete single_value.field_interf__ind;
break;
case PCUIF__MsgUnion::ALT_pag__req:
delete single_value.field_pag__req;
break;
case PCUIF__MsgUnion::ALT_app__info__req:
delete single_value.field_app__info__req;
break;
case PCUIF__MsgUnion::ALT_container:
delete single_value.field_container;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCUIF__MsgUnion_template& PCUIF__MsgUnion_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCUIF__MsgUnion_template& PCUIF__MsgUnion_template::operator=(const PCUIF__MsgUnion& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PCUIF__MsgUnion_template& PCUIF__MsgUnion_template::operator=(const OPTIONAL<PCUIF__MsgUnion>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__MsgUnion&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
return *this;
}

PCUIF__MsgUnion_template& PCUIF__MsgUnion_template::operator=(const PCUIF__MsgUnion_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCUIF__MsgUnion_template::match(const PCUIF__MsgUnion& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PCUIF__MsgUnion::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PCUIF__MsgUnion::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PCUIF__MsgUnion::ALT_data__req:
return single_value.field_data__req->match(other_value.data__req(), legacy);
case PCUIF__MsgUnion::ALT_data__cnf2:
return single_value.field_data__cnf2->match(other_value.data__cnf2(), legacy);
case PCUIF__MsgUnion::ALT_data__ind:
return single_value.field_data__ind->match(other_value.data__ind(), legacy);
case PCUIF__MsgUnion::ALT_susp__req:
return single_value.field_susp__req->match(other_value.susp__req(), legacy);
case PCUIF__MsgUnion::ALT_rts__req:
return single_value.field_rts__req->match(other_value.rts__req(), legacy);
case PCUIF__MsgUnion::ALT_rach__ind:
return single_value.field_rach__ind->match(other_value.rach__ind(), legacy);
case PCUIF__MsgUnion::ALT_txt__ind:
return single_value.field_txt__ind->match(other_value.txt__ind(), legacy);
case PCUIF__MsgUnion::ALT_info__ind:
return single_value.field_info__ind->match(other_value.info__ind(), legacy);
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
return single_value.field_e1__ccu__ind->match(other_value.e1__ccu__ind(), legacy);
case PCUIF__MsgUnion::ALT_act__req:
return single_value.field_act__req->match(other_value.act__req(), legacy);
case PCUIF__MsgUnion::ALT_time__ind:
return single_value.field_time__ind->match(other_value.time__ind(), legacy);
case PCUIF__MsgUnion::ALT_interf__ind:
return single_value.field_interf__ind->match(other_value.interf__ind(), legacy);
case PCUIF__MsgUnion::ALT_pag__req:
return single_value.field_pag__req->match(other_value.pag__req(), legacy);
case PCUIF__MsgUnion::ALT_app__info__req:
return single_value.field_app__info__req->match(other_value.app__info__req(), legacy);
case PCUIF__MsgUnion::ALT_container:
return single_value.field_container->match(other_value.container(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
return FALSE;
}

boolean PCUIF__MsgUnion_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
return single_value.field_data__req->is_value();
case PCUIF__MsgUnion::ALT_data__cnf2:
return single_value.field_data__cnf2->is_value();
case PCUIF__MsgUnion::ALT_data__ind:
return single_value.field_data__ind->is_value();
case PCUIF__MsgUnion::ALT_susp__req:
return single_value.field_susp__req->is_value();
case PCUIF__MsgUnion::ALT_rts__req:
return single_value.field_rts__req->is_value();
case PCUIF__MsgUnion::ALT_rach__ind:
return single_value.field_rach__ind->is_value();
case PCUIF__MsgUnion::ALT_txt__ind:
return single_value.field_txt__ind->is_value();
case PCUIF__MsgUnion::ALT_info__ind:
return single_value.field_info__ind->is_value();
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
return single_value.field_e1__ccu__ind->is_value();
case PCUIF__MsgUnion::ALT_act__req:
return single_value.field_act__req->is_value();
case PCUIF__MsgUnion::ALT_time__ind:
return single_value.field_time__ind->is_value();
case PCUIF__MsgUnion::ALT_interf__ind:
return single_value.field_interf__ind->is_value();
case PCUIF__MsgUnion::ALT_pag__req:
return single_value.field_pag__req->is_value();
case PCUIF__MsgUnion::ALT_app__info__req:
return single_value.field_app__info__req->is_value();
case PCUIF__MsgUnion::ALT_container:
return single_value.field_container->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
}

PCUIF__MsgUnion PCUIF__MsgUnion_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
PCUIF__MsgUnion ret_val;
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
ret_val.data__req() = single_value.field_data__req->valueof();
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
ret_val.data__cnf2() = single_value.field_data__cnf2->valueof();
break;
case PCUIF__MsgUnion::ALT_data__ind:
ret_val.data__ind() = single_value.field_data__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_susp__req:
ret_val.susp__req() = single_value.field_susp__req->valueof();
break;
case PCUIF__MsgUnion::ALT_rts__req:
ret_val.rts__req() = single_value.field_rts__req->valueof();
break;
case PCUIF__MsgUnion::ALT_rach__ind:
ret_val.rach__ind() = single_value.field_rach__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_txt__ind:
ret_val.txt__ind() = single_value.field_txt__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_info__ind:
ret_val.info__ind() = single_value.field_info__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
ret_val.e1__ccu__ind() = single_value.field_e1__ccu__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_act__req:
ret_val.act__req() = single_value.field_act__req->valueof();
break;
case PCUIF__MsgUnion::ALT_time__ind:
ret_val.time__ind() = single_value.field_time__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_interf__ind:
ret_val.interf__ind() = single_value.field_interf__ind->valueof();
break;
case PCUIF__MsgUnion::ALT_pag__req:
ret_val.pag__req() = single_value.field_pag__req->valueof();
break;
case PCUIF__MsgUnion::ALT_app__info__req:
ret_val.app__info__req() = single_value.field_app__info__req->valueof();
break;
case PCUIF__MsgUnion::ALT_container:
ret_val.container() = single_value.field_container->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
return ret_val;
}

PCUIF__MsgUnion_template& PCUIF__MsgUnion_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return value_list.list_value[list_index];
}
void PCUIF__MsgUnion_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCUIF__MsgUnion_template[list_length];
}

PCUIF__data_template& PCUIF__MsgUnion_template::data__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_data__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_data__req = new PCUIF__data_template(ANY_VALUE);
else single_value.field_data__req = new PCUIF__data_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_data__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_data__req;
}

const PCUIF__data_template& PCUIF__MsgUnion_template::data__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field data_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_data__req) TTCN_error("Accessing non-selected field data_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_data__req;
}

PCUIF__data__cnf_template& PCUIF__MsgUnion_template::data__cnf2()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_data__cnf2) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_data__cnf2 = new PCUIF__data__cnf_template(ANY_VALUE);
else single_value.field_data__cnf2 = new PCUIF__data__cnf_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_data__cnf2;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_data__cnf2;
}

const PCUIF__data__cnf_template& PCUIF__MsgUnion_template::data__cnf2() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field data_cnf2 in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_data__cnf2) TTCN_error("Accessing non-selected field data_cnf2 in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_data__cnf2;
}

PCUIF__data_template& PCUIF__MsgUnion_template::data__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_data__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_data__ind = new PCUIF__data_template(ANY_VALUE);
else single_value.field_data__ind = new PCUIF__data_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_data__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_data__ind;
}

const PCUIF__data_template& PCUIF__MsgUnion_template::data__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field data_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_data__ind) TTCN_error("Accessing non-selected field data_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_data__ind;
}

PCUIF__susp__req_template& PCUIF__MsgUnion_template::susp__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_susp__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_susp__req = new PCUIF__susp__req_template(ANY_VALUE);
else single_value.field_susp__req = new PCUIF__susp__req_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_susp__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_susp__req;
}

const PCUIF__susp__req_template& PCUIF__MsgUnion_template::susp__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field susp_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_susp__req) TTCN_error("Accessing non-selected field susp_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_susp__req;
}

PCUIF__rts__req_template& PCUIF__MsgUnion_template::rts__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_rts__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rts__req = new PCUIF__rts__req_template(ANY_VALUE);
else single_value.field_rts__req = new PCUIF__rts__req_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_rts__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rts__req;
}

const PCUIF__rts__req_template& PCUIF__MsgUnion_template::rts__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rts_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_rts__req) TTCN_error("Accessing non-selected field rts_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_rts__req;
}

PCUIF__rach__ind_template& PCUIF__MsgUnion_template::rach__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_rach__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rach__ind = new PCUIF__rach__ind_template(ANY_VALUE);
else single_value.field_rach__ind = new PCUIF__rach__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_rach__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rach__ind;
}

const PCUIF__rach__ind_template& PCUIF__MsgUnion_template::rach__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rach_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_rach__ind) TTCN_error("Accessing non-selected field rach_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_rach__ind;
}

PCUIF__txt__ind_template& PCUIF__MsgUnion_template::txt__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_txt__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_txt__ind = new PCUIF__txt__ind_template(ANY_VALUE);
else single_value.field_txt__ind = new PCUIF__txt__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_txt__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_txt__ind;
}

const PCUIF__txt__ind_template& PCUIF__MsgUnion_template::txt__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field txt_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_txt__ind) TTCN_error("Accessing non-selected field txt_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_txt__ind;
}

PCUIF__info__ind_template& PCUIF__MsgUnion_template::info__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_info__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_info__ind = new PCUIF__info__ind_template(ANY_VALUE);
else single_value.field_info__ind = new PCUIF__info__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_info__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_info__ind;
}

const PCUIF__info__ind_template& PCUIF__MsgUnion_template::info__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field info_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_info__ind) TTCN_error("Accessing non-selected field info_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_info__ind;
}

PCUIF__e1__ccu__ind_template& PCUIF__MsgUnion_template::e1__ccu__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_e1__ccu__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_e1__ccu__ind = new PCUIF__e1__ccu__ind_template(ANY_VALUE);
else single_value.field_e1__ccu__ind = new PCUIF__e1__ccu__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_e1__ccu__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_e1__ccu__ind;
}

const PCUIF__e1__ccu__ind_template& PCUIF__MsgUnion_template::e1__ccu__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field e1_ccu_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_e1__ccu__ind) TTCN_error("Accessing non-selected field e1_ccu_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_e1__ccu__ind;
}

PCUIF__act__req_template& PCUIF__MsgUnion_template::act__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_act__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_act__req = new PCUIF__act__req_template(ANY_VALUE);
else single_value.field_act__req = new PCUIF__act__req_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_act__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_act__req;
}

const PCUIF__act__req_template& PCUIF__MsgUnion_template::act__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field act_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_act__req) TTCN_error("Accessing non-selected field act_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_act__req;
}

PCUIF__time__ind_template& PCUIF__MsgUnion_template::time__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_time__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_time__ind = new PCUIF__time__ind_template(ANY_VALUE);
else single_value.field_time__ind = new PCUIF__time__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_time__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_time__ind;
}

const PCUIF__time__ind_template& PCUIF__MsgUnion_template::time__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field time_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_time__ind) TTCN_error("Accessing non-selected field time_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_time__ind;
}

PCUIF__interf__ind_template& PCUIF__MsgUnion_template::interf__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_interf__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_interf__ind = new PCUIF__interf__ind_template(ANY_VALUE);
else single_value.field_interf__ind = new PCUIF__interf__ind_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_interf__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_interf__ind;
}

const PCUIF__interf__ind_template& PCUIF__MsgUnion_template::interf__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field interf_ind in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_interf__ind) TTCN_error("Accessing non-selected field interf_ind in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_interf__ind;
}

PCUIF__pag__req_template& PCUIF__MsgUnion_template::pag__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_pag__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pag__req = new PCUIF__pag__req_template(ANY_VALUE);
else single_value.field_pag__req = new PCUIF__pag__req_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_pag__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pag__req;
}

const PCUIF__pag__req_template& PCUIF__MsgUnion_template::pag__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pag_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_pag__req) TTCN_error("Accessing non-selected field pag_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_pag__req;
}

PCUIF__app__info__req_template& PCUIF__MsgUnion_template::app__info__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_app__info__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_app__info__req = new PCUIF__app__info__req_template(ANY_VALUE);
else single_value.field_app__info__req = new PCUIF__app__info__req_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_app__info__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_app__info__req;
}

const PCUIF__app__info__req_template& PCUIF__MsgUnion_template::app__info__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field app_info_req in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_app__info__req) TTCN_error("Accessing non-selected field app_info_req in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_app__info__req;
}

PCUIF__container_template& PCUIF__MsgUnion_template::container()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PCUIF__MsgUnion::ALT_container) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_container = new PCUIF__container_template(ANY_VALUE);
else single_value.field_container = new PCUIF__container_template;
single_value.union_selection = PCUIF__MsgUnion::ALT_container;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_container;
}

const PCUIF__container_template& PCUIF__MsgUnion_template::container() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field container in a non-specific template of union type @PCUIF_Types.PCUIF_MsgUnion.");
if (single_value.union_selection != PCUIF__MsgUnion::ALT_container) TTCN_error("Accessing non-selected field container in a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return *single_value.field_container;
}

boolean PCUIF__MsgUnion_template::ischosen(PCUIF__MsgUnion::union_selection_type checked_selection) const
{
if (checked_selection == PCUIF__MsgUnion::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @PCUIF_Types.PCUIF_MsgUnion.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PCUIF__MsgUnion::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @PCUIF_Types.PCUIF_MsgUnion containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PCUIF__MsgUnion_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
TTCN_Logger::log_event_str("{ data_req := ");
single_value.field_data__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
TTCN_Logger::log_event_str("{ data_cnf2 := ");
single_value.field_data__cnf2->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_data__ind:
TTCN_Logger::log_event_str("{ data_ind := ");
single_value.field_data__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_susp__req:
TTCN_Logger::log_event_str("{ susp_req := ");
single_value.field_susp__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_rts__req:
TTCN_Logger::log_event_str("{ rts_req := ");
single_value.field_rts__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_rach__ind:
TTCN_Logger::log_event_str("{ rach_ind := ");
single_value.field_rach__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_txt__ind:
TTCN_Logger::log_event_str("{ txt_ind := ");
single_value.field_txt__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_info__ind:
TTCN_Logger::log_event_str("{ info_ind := ");
single_value.field_info__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
TTCN_Logger::log_event_str("{ e1_ccu_ind := ");
single_value.field_e1__ccu__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_act__req:
TTCN_Logger::log_event_str("{ act_req := ");
single_value.field_act__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_time__ind:
TTCN_Logger::log_event_str("{ time_ind := ");
single_value.field_time__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_interf__ind:
TTCN_Logger::log_event_str("{ interf_ind := ");
single_value.field_interf__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_pag__req:
TTCN_Logger::log_event_str("{ pag_req := ");
single_value.field_pag__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_app__info__req:
TTCN_Logger::log_event_str("{ app_info_req := ");
single_value.field_app__info__req->log();
TTCN_Logger::log_event_str(" }");
break;
case PCUIF__MsgUnion::ALT_container:
TTCN_Logger::log_event_str("{ container := ");
single_value.field_container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCUIF__MsgUnion_template::log_match(const PCUIF__MsgUnion& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".data_req");
single_value.field_data__req->log_match(match_value.data__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ data_req := ");
single_value.field_data__req->log_match(match_value.data__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".data_cnf2");
single_value.field_data__cnf2->log_match(match_value.data__cnf2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ data_cnf2 := ");
single_value.field_data__cnf2->log_match(match_value.data__cnf2(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_data__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".data_ind");
single_value.field_data__ind->log_match(match_value.data__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ data_ind := ");
single_value.field_data__ind->log_match(match_value.data__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_susp__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".susp_req");
single_value.field_susp__req->log_match(match_value.susp__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ susp_req := ");
single_value.field_susp__req->log_match(match_value.susp__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_rts__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rts_req");
single_value.field_rts__req->log_match(match_value.rts__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rts_req := ");
single_value.field_rts__req->log_match(match_value.rts__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_rach__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rach_ind");
single_value.field_rach__ind->log_match(match_value.rach__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rach_ind := ");
single_value.field_rach__ind->log_match(match_value.rach__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_txt__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".txt_ind");
single_value.field_txt__ind->log_match(match_value.txt__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ txt_ind := ");
single_value.field_txt__ind->log_match(match_value.txt__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_info__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".info_ind");
single_value.field_info__ind->log_match(match_value.info__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ info_ind := ");
single_value.field_info__ind->log_match(match_value.info__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".e1_ccu_ind");
single_value.field_e1__ccu__ind->log_match(match_value.e1__ccu__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ e1_ccu_ind := ");
single_value.field_e1__ccu__ind->log_match(match_value.e1__ccu__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_act__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".act_req");
single_value.field_act__req->log_match(match_value.act__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ act_req := ");
single_value.field_act__req->log_match(match_value.act__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_time__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".time_ind");
single_value.field_time__ind->log_match(match_value.time__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ time_ind := ");
single_value.field_time__ind->log_match(match_value.time__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_interf__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".interf_ind");
single_value.field_interf__ind->log_match(match_value.interf__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ interf_ind := ");
single_value.field_interf__ind->log_match(match_value.interf__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_pag__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pag_req");
single_value.field_pag__req->log_match(match_value.pag__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pag_req := ");
single_value.field_pag__req->log_match(match_value.pag__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_app__info__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".app_info_req");
single_value.field_app__info__req->log_match(match_value.app__info__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ app_info_req := ");
single_value.field_app__info__req->log_match(match_value.app__info__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PCUIF__MsgUnion::ALT_container:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".container");
single_value.field_container->log_match(match_value.container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ container := ");
single_value.field_container->log_match(match_value.container(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PCUIF__MsgUnion_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req->set_implicit_omit(); break;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container->set_implicit_omit(); break;
default: break;
}
}

void PCUIF__MsgUnion_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req->encode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @PCUIF_Types.PCUIF_MsgUnion.");
}
}

void PCUIF__MsgUnion_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PCUIF__MsgUnion::UNBOUND_VALUE;
PCUIF__MsgUnion::union_selection_type new_selection = (PCUIF__MsgUnion::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req = new PCUIF__data_template;
single_value.field_data__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2 = new PCUIF__data__cnf_template;
single_value.field_data__cnf2->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind = new PCUIF__data_template;
single_value.field_data__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req = new PCUIF__susp__req_template;
single_value.field_susp__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req = new PCUIF__rts__req_template;
single_value.field_rts__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind = new PCUIF__rach__ind_template;
single_value.field_rach__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind = new PCUIF__txt__ind_template;
single_value.field_txt__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind = new PCUIF__info__ind_template;
single_value.field_info__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind = new PCUIF__e1__ccu__ind_template;
single_value.field_e1__ccu__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req = new PCUIF__act__req_template;
single_value.field_act__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind = new PCUIF__time__ind_template;
single_value.field_time__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind = new PCUIF__interf__ind_template;
single_value.field_interf__ind->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req = new PCUIF__pag__req_template;
single_value.field_pag__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req = new PCUIF__app__info__req_template;
single_value.field_app__info__req->decode_text(text_buf);
break;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container = new PCUIF__container_template;
single_value.field_container->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @PCUIF_Types.PCUIF_MsgUnion.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCUIF__MsgUnion_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @PCUIF_Types.PCUIF_MsgUnion.");
}
}

boolean PCUIF__MsgUnion_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCUIF__MsgUnion_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCUIF__MsgUnion_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@PCUIF_Types.PCUIF_MsgUnion'");
    }
    if (strcmp("data_req", param_field) == 0) {
      data__req().set_param(param);
      return;
    } else if (strcmp("data_cnf2", param_field) == 0) {
      data__cnf2().set_param(param);
      return;
    } else if (strcmp("data_ind", param_field) == 0) {
      data__ind().set_param(param);
      return;
    } else if (strcmp("susp_req", param_field) == 0) {
      susp__req().set_param(param);
      return;
    } else if (strcmp("rts_req", param_field) == 0) {
      rts__req().set_param(param);
      return;
    } else if (strcmp("rach_ind", param_field) == 0) {
      rach__ind().set_param(param);
      return;
    } else if (strcmp("txt_ind", param_field) == 0) {
      txt__ind().set_param(param);
      return;
    } else if (strcmp("info_ind", param_field) == 0) {
      info__ind().set_param(param);
      return;
    } else if (strcmp("e1_ccu_ind", param_field) == 0) {
      e1__ccu__ind().set_param(param);
      return;
    } else if (strcmp("act_req", param_field) == 0) {
      act__req().set_param(param);
      return;
    } else if (strcmp("time_ind", param_field) == 0) {
      time__ind().set_param(param);
      return;
    } else if (strcmp("interf_ind", param_field) == 0) {
      interf__ind().set_param(param);
      return;
    } else if (strcmp("pag_req", param_field) == 0) {
      pag__req().set_param(param);
      return;
    } else if (strcmp("app_info_req", param_field) == 0) {
      app__info__req().set_param(param);
      return;
    } else if (strcmp("container", param_field) == 0) {
      container().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@PCUIF_Types.PCUIF_MsgUnion'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCUIF__MsgUnion_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@PCUIF_Types.PCUIF_MsgUnion");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "data_req")) {
      data__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "data_cnf2")) {
      data__cnf2().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "data_ind")) {
      data__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "susp_req")) {
      susp__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rts_req")) {
      rts__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rach_ind")) {
      rach__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "txt_ind")) {
      txt__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "info_ind")) {
      info__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "e1_ccu_ind")) {
      e1__ccu__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "act_req")) {
      act__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "time_ind")) {
      time__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "interf_ind")) {
      interf__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "pag_req")) {
      pag__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "app_info_req")) {
      app__info__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "container")) {
      container().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @PCUIF_Types.PCUIF_MsgUnion.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PCUIF__MsgUnion_template* precondition = new PCUIF__MsgUnion_template;
    precondition->set_param(*m_p->get_elem(0));
    PCUIF__MsgUnion_template* implied_template = new PCUIF__MsgUnion_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCUIF__MsgUnion_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@PCUIF_Types.PCUIF_MsgUnion");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCUIF__MsgUnion_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PCUIF__MsgUnion::ALT_data__req:
single_value.field_data__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_data__cnf2:
single_value.field_data__cnf2->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_data__ind:
single_value.field_data__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_susp__req:
single_value.field_susp__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_rts__req:
single_value.field_rts__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_rach__ind:
single_value.field_rach__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_txt__ind:
single_value.field_txt__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_info__ind:
single_value.field_info__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_e1__ccu__ind:
single_value.field_e1__ccu__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_act__req:
single_value.field_act__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_time__ind:
single_value.field_time__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_interf__ind:
single_value.field_interf__ind->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_pag__req:
single_value.field_pag__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_app__info__req:
single_value.field_app__info__req->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
case PCUIF__MsgUnion::ALT_container:
single_value.field_container->check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @PCUIF_Types.PCUIF_MsgUnion.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PCUIF_Types.PCUIF_MsgUnion");
}

PCUIF__Message::PCUIF__Message()
{
}

PCUIF__Message::PCUIF__Message(const PCUIF__MsgType& par_msg__type,
    const INTEGER& par_bts__nr,
    const OCTETSTRING& par_spare,
    const PCUIF__MsgUnion& par_u)
  :   field_msg__type(par_msg__type),
  field_bts__nr(par_bts__nr),
  field_spare(par_spare),
  field_u(par_u)
{
}

PCUIF__Message::PCUIF__Message(const PCUIF__Message& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PCUIF_Types.PCUIF_Message.");
if (other_value.msg__type().is_bound()) field_msg__type = other_value.msg__type();
else field_msg__type.clean_up();
if (other_value.bts__nr().is_bound()) field_bts__nr = other_value.bts__nr();
else field_bts__nr.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.u().is_bound()) field_u = other_value.u();
else field_u.clean_up();
}

void PCUIF__Message::clean_up()
{
field_msg__type.clean_up();
field_bts__nr.clean_up();
field_spare.clean_up();
field_u.clean_up();
}

const TTCN_Typedescriptor_t* PCUIF__Message::get_descriptor() const { return &PCUIF__Message_descr_; }
PCUIF__Message& PCUIF__Message::operator=(const PCUIF__Message& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PCUIF_Types.PCUIF_Message.");
  if (other_value.msg__type().is_bound()) field_msg__type = other_value.msg__type();
  else field_msg__type.clean_up();
  if (other_value.bts__nr().is_bound()) field_bts__nr = other_value.bts__nr();
  else field_bts__nr.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.u().is_bound()) field_u = other_value.u();
  else field_u.clean_up();
}
return *this;
}

boolean PCUIF__Message::operator==(const PCUIF__Message& other_value) const
{
return field_msg__type==other_value.field_msg__type
  && field_bts__nr==other_value.field_bts__nr
  && field_spare==other_value.field_spare
  && field_u==other_value.field_u;
}

boolean PCUIF__Message::is_bound() const
{
return (field_msg__type.is_bound())
  || (field_bts__nr.is_bound())
  || (field_spare.is_bound())
  || (field_u.is_bound());
}
boolean PCUIF__Message::is_value() const
{
return field_msg__type.is_value()
  && field_bts__nr.is_value()
  && field_spare.is_value()
  && field_u.is_value();
}
void PCUIF__Message::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ msg_type := ");
field_msg__type.log();
TTCN_Logger::log_event_str(", bts_nr := ");
field_bts__nr.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", u := ");
field_u.log();
TTCN_Logger::log_event_str(" }");
}

void PCUIF__Message::set_implicit_omit()
{
if (msg__type().is_bound()) msg__type().set_implicit_omit();
if (bts__nr().is_bound()) bts__nr().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (u().is_bound()) u().set_implicit_omit();
}

void PCUIF__Message::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @PCUIF_Types.PCUIF_Message has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msg__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bts__nr().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) u().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bts_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bts__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "u")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          u().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PCUIF_Types.PCUIF_Message: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PCUIF_Types.PCUIF_Message");
  }
}

void PCUIF__Message::encode_text(Text_Buf& text_buf) const
{
field_msg__type.encode_text(text_buf);
field_bts__nr.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_u.encode_text(text_buf);
}

void PCUIF__Message::decode_text(Text_Buf& text_buf)
{
field_msg__type.decode_text(text_buf);
field_bts__nr.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_u.decode_text(text_buf);
}

void PCUIF__Message::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCUIF__Message::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCUIF__Message::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PCUIF__Message_msg__type_descr_.raw->forceomit);
  decoded_field_length = field_msg__type.RAW_decode(PCUIF__Message_msg__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PCUIF__Message_bts__nr_descr_.raw->forceomit);
  decoded_field_length = field_bts__nr.RAW_decode(PCUIF__Message_bts__nr_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, PCUIF__Message_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(PCUIF__Message_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__DATA__REQ) selected_field = 0;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__DATA__CNF__2) selected_field = 1;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__DATA__IND) selected_field = 2;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__SUSP__REQ) selected_field = 3;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__RTS__REQ) selected_field = 4;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__RACH__IND) selected_field = 5;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__TXT__IND) selected_field = 6;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__INFO__IND) selected_field = 7;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__E1__CCU__IND) selected_field = 8;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__ACT__REQ) selected_field = 9;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__TIME__IND) selected_field = 10;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__INTERF__IND) selected_field = 11;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__PAG__REQ) selected_field = 12;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__APP__INFO__REQ) selected_field = 13;
  else if (field_msg__type == PCUIF__MsgType::PCU__IF__MSG__CONTAINER) selected_field = 14;
  else selected_field = -1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PCUIF__Message_u_descr_.raw->forceomit);
  decoded_field_length = field_u.RAW_decode(PCUIF__Message_u_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PCUIF__Message::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PCUIF__Message_msg__type_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PCUIF__Message_bts__nr_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PCUIF__Message_spare_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PCUIF__Message_u_descr_.raw);
  encoded_length += field_msg__type.RAW_encode(PCUIF__Message_msg__type_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_bts__nr.RAW_encode(PCUIF__Message_bts__nr_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(PCUIF__Message_spare_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_u.RAW_encode(PCUIF__Message_u_descr_, *myleaf.body.node.nodes[3]);
  switch (field_u.get_selection()) {
  case PCUIF__MsgUnion::ALT_data__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__DATA__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__DATA__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_data__cnf2:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__DATA__CNF__2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__DATA__CNF__2);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_data__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__DATA__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__DATA__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_susp__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__SUSP__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__SUSP__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_rts__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__RTS__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__RTS__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_rach__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__RACH__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__RACH__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_txt__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__TXT__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__TXT__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_info__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__INFO__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__INFO__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_e1__ccu__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__E1__CCU__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__E1__CCU__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_act__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__ACT__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__ACT__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_time__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__TIME__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__TIME__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_interf__ind:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__INTERF__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__INTERF__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_pag__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__PAG__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__PAG__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_app__info__req:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__APP__INFO__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__APP__INFO__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PCUIF__MsgUnion::ALT_container:
  if (field_msg__type != PCUIF__MsgType::PCU__IF__MSG__CONTAINER) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  PCUIF__MsgType new_val(PCUIF__MsgType::PCU__IF__MSG__CONTAINER);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(PCUIF__Message_msg__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct PCUIF__Message_template::single_value_struct {
PCUIF__MsgType_template field_msg__type;
INTEGER_template field_bts__nr;
OCTETSTRING_template field_spare;
PCUIF__MsgUnion_template field_u;
};

void PCUIF__Message_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_msg__type = ANY_VALUE;
single_value->field_bts__nr = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_u = ANY_VALUE;
}
}
}

void PCUIF__Message_template::copy_value(const PCUIF__Message& other_value)
{
single_value = new single_value_struct;
if (other_value.msg__type().is_bound()) {
  single_value->field_msg__type = other_value.msg__type();
} else {
  single_value->field_msg__type.clean_up();
}
if (other_value.bts__nr().is_bound()) {
  single_value->field_bts__nr = other_value.bts__nr();
} else {
  single_value->field_bts__nr.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.u().is_bound()) {
  single_value->field_u = other_value.u();
} else {
  single_value->field_u.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PCUIF__Message_template::copy_template(const PCUIF__Message_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.msg__type().get_selection()) {
single_value->field_msg__type = other_value.msg__type();
} else {
single_value->field_msg__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bts__nr().get_selection()) {
single_value->field_bts__nr = other_value.bts__nr();
} else {
single_value->field_bts__nr.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.u().get_selection()) {
single_value->field_u = other_value.u();
} else {
single_value->field_u.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCUIF__Message_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCUIF__Message_template(*other_value.implication_.precondition);
implication_.implied_template = new PCUIF__Message_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_Message.");
break;
}
set_selection(other_value);
}

PCUIF__Message_template::PCUIF__Message_template()
{
}

PCUIF__Message_template::PCUIF__Message_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCUIF__Message_template::PCUIF__Message_template(const PCUIF__Message& other_value)
{
copy_value(other_value);
}

PCUIF__Message_template::PCUIF__Message_template(const OPTIONAL<PCUIF__Message>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__Message&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PCUIF_Types.PCUIF_Message from an unbound optional field.");
}
}

PCUIF__Message_template::PCUIF__Message_template(PCUIF__Message_template* p_precondition, PCUIF__Message_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCUIF__Message_template::PCUIF__Message_template(Dynamic_Match_Interface<PCUIF__Message>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCUIF__Message>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCUIF__Message_template::PCUIF__Message_template(const PCUIF__Message_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PCUIF__Message_template::~PCUIF__Message_template()
{
clean_up();
}

PCUIF__Message_template& PCUIF__Message_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCUIF__Message_template& PCUIF__Message_template::operator=(const PCUIF__Message& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PCUIF__Message_template& PCUIF__Message_template::operator=(const OPTIONAL<PCUIF__Message>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PCUIF__Message&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PCUIF_Types.PCUIF_Message.");
}
return *this;
}

PCUIF__Message_template& PCUIF__Message_template::operator=(const PCUIF__Message_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCUIF__Message_template::match(const PCUIF__Message& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.msg__type().is_bound()) return FALSE;
if(!single_value->field_msg__type.match(other_value.msg__type(), legacy))return FALSE;
if(!other_value.bts__nr().is_bound()) return FALSE;
if(!single_value->field_bts__nr.match(other_value.bts__nr(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.u().is_bound()) return FALSE;
if(!single_value->field_u.match(other_value.u(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_Message.");
}
return FALSE;
}

boolean PCUIF__Message_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_msg__type.is_bound()
 || single_value->field_bts__nr.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_u.is_bound();
}

boolean PCUIF__Message_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_msg__type.is_value()
 && single_value->field_bts__nr.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_u.is_value();
}

void PCUIF__Message_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCUIF__Message PCUIF__Message_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PCUIF_Types.PCUIF_Message.");
PCUIF__Message ret_val;
if (single_value->field_msg__type.is_bound()) {
ret_val.msg__type() = single_value->field_msg__type.valueof();
}
if (single_value->field_bts__nr.is_bound()) {
ret_val.bts__nr() = single_value->field_bts__nr.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_u.is_bound()) {
ret_val.u() = single_value->field_u.valueof();
}
return ret_val;
}

void PCUIF__Message_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PCUIF_Types.PCUIF_Message.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCUIF__Message_template[list_length];
}

PCUIF__Message_template& PCUIF__Message_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PCUIF_Types.PCUIF_Message.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PCUIF_Types.PCUIF_Message.");
return value_list.list_value[list_index];
}

PCUIF__MsgType_template& PCUIF__Message_template::msg__type()
{
set_specific();
return single_value->field_msg__type;
}

const PCUIF__MsgType_template& PCUIF__Message_template::msg__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg_type of a non-specific template of type @PCUIF_Types.PCUIF_Message.");
return single_value->field_msg__type;
}

INTEGER_template& PCUIF__Message_template::bts__nr()
{
set_specific();
return single_value->field_bts__nr;
}

const INTEGER_template& PCUIF__Message_template::bts__nr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bts_nr of a non-specific template of type @PCUIF_Types.PCUIF_Message.");
return single_value->field_bts__nr;
}

OCTETSTRING_template& PCUIF__Message_template::spare()
{
set_specific();
return single_value->field_spare;
}

const OCTETSTRING_template& PCUIF__Message_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @PCUIF_Types.PCUIF_Message.");
return single_value->field_spare;
}

PCUIF__MsgUnion_template& PCUIF__Message_template::u()
{
set_specific();
return single_value->field_u;
}

const PCUIF__MsgUnion_template& PCUIF__Message_template::u() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field u of a non-specific template of type @PCUIF_Types.PCUIF_Message.");
return single_value->field_u;
}

int PCUIF__Message_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PCUIF_Types.PCUIF_Message containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_Message.");
  }
  return 0;
}

void PCUIF__Message_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ msg_type := ");
single_value->field_msg__type.log();
TTCN_Logger::log_event_str(", bts_nr := ");
single_value->field_bts__nr.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", u := ");
single_value->field_u.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCUIF__Message_template::log_match(const PCUIF__Message& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_msg__type.match(match_value.msg__type(), legacy)){
TTCN_Logger::log_logmatch_info(".msg_type");
single_value->field_msg__type.log_match(match_value.msg__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bts__nr.match(match_value.bts__nr(), legacy)){
TTCN_Logger::log_logmatch_info(".bts_nr");
single_value->field_bts__nr.log_match(match_value.bts__nr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_u.match(match_value.u(), legacy)){
TTCN_Logger::log_logmatch_info(".u");
single_value->field_u.log_match(match_value.u(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ msg_type := ");
single_value->field_msg__type.log_match(match_value.msg__type(), legacy);
TTCN_Logger::log_event_str(", bts_nr := ");
single_value->field_bts__nr.log_match(match_value.bts__nr(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", u := ");
single_value->field_u.log_match(match_value.u(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PCUIF__Message_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (msg__type().is_bound()) msg__type().set_implicit_omit();
if (bts__nr().is_bound()) bts__nr().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (u().is_bound()) u().set_implicit_omit();
}

void PCUIF__Message_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_msg__type.encode_text(text_buf);
single_value->field_bts__nr.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_u.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PCUIF_Types.PCUIF_Message.");
}
}

void PCUIF__Message_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_msg__type.decode_text(text_buf);
single_value->field_bts__nr.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_u.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCUIF__Message_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PCUIF_Types.PCUIF_Message.");
}
}

void PCUIF__Message_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCUIF__Message_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @PCUIF_Types.PCUIF_Message has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) msg__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bts__nr().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) u().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bts_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bts__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "u")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          u().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PCUIF_Types.PCUIF_Message: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PCUIF__Message_template* precondition = new PCUIF__Message_template;
    precondition->set_param(*param.get_elem(0));
    PCUIF__Message_template* implied_template = new PCUIF__Message_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PCUIF__Message_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PCUIF_Types.PCUIF_Message");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCUIF__Message_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_msg__type.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_Message");
single_value->field_bts__nr.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_Message");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_Message");
single_value->field_u.check_restriction(t_res, t_name ? t_name : "@PCUIF_Types.PCUIF_Message");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PCUIF_Types.PCUIF_Message");
}

boolean PCUIF__Message_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCUIF__Message_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


/* Bodies of functions, altsteps and testcases */

void PCUIF__Version_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Version_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Version_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Version_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgType_encoder(const PCUIF__MsgType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgType_decoder(OCTETSTRING& input_stream, PCUIF__MsgType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_bts__active_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_bts__active_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_bts__active_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_bts__active_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_direct__phy_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_direct__phy_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_direct__phy_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_direct__phy_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_spare_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_spare_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_cs1_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_cs1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_cs1_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_cs1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_cs2_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_cs2_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_cs2_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_cs2_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_cs3_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_cs3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_cs3_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_cs3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_cs4_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_cs4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_cs4_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_cs4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs1_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs1_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs2_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs2_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs2_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs2_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs3_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs3_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs3_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs3_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs4_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs4_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs5_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs5_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs5_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs5_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs6_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs6_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs6_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs6_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs7_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs7_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs7_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs7_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs8_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs8_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs8_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs8_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_mcs9_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_mcs9_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_mcs9_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_mcs9_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_spare2_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_spare2_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_spare2_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_spare2_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Flags_encoder(const PCUIF__Flags& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Flags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Flags_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Flags_decoder(OCTETSTRING& input_stream, PCUIF__Flags& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Flags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Flags_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__bts__model_encoder(const PCUIF__bts__model& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_bts_model' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__bts__model_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__bts__model_decoder(OCTETSTRING& input_stream, PCUIF__bts__model& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_bts_model' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__bts__model_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__TextType_encoder(const PCUIF__TextType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_TextType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__TextType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__TextType_decoder(OCTETSTRING& input_stream, PCUIF__TextType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_TextType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__TextType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Text_encoder(const CHARSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Text_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Text_decoder(OCTETSTRING& input_stream, CHARSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Text_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__txt__ind_txt__type_encoder(const PCUIF__TextType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_TextType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__txt__ind_txt__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__txt__ind_txt__type_decoder(OCTETSTRING& input_stream, PCUIF__TextType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_TextType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__txt__ind_txt__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__txt__ind_text_encoder(const CHARSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__txt__ind_text_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__txt__ind_text_decoder(OCTETSTRING& input_stream, CHARSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__txt__ind_text_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__txt__ind_encoder(const PCUIF__txt__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_txt_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__txt__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__txt__ind_decoder(OCTETSTRING& input_stream, PCUIF__txt__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_txt_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__txt__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_fn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_fn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_fn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_fn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_ts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_ts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_block__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_block__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_block__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_block__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_rssi_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_rssi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_rssi_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_rssi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_ber10k_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_ber10k_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_ber10k_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_ber10k_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_ta__offs__qbits_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_ta__offs__qbits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_ta__offs__qbits_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_ta__offs__qbits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_lqual__cb_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_lqual__cb_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_lqual__cb_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_lqual__cb_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data_encoder(const PCUIF__data& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data_decoder(OCTETSTRING& input_stream, PCUIF__data& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data__cnf_sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data__cnf_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data__cnf_sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data__cnf_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data__cnf_msg__id_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data__cnf_msg__id_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data__cnf_msg__id_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data__cnf_msg__id_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__data__cnf_encoder(const PCUIF__data__cnf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__data__cnf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__data__cnf_decoder(OCTETSTRING& input_stream, PCUIF__data__cnf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__data__cnf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_fn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_fn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_fn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_fn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_ts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_ts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_block__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_block__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_block__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_block__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rts__req_encoder(const PCUIF__rts__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rts_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rts__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rts__req_decoder(OCTETSTRING& input_stream, PCUIF__rts__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rts_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rts__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__BurstType_encoder(const PCUIF__BurstType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_BurstType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__BurstType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__BurstType_decoder(OCTETSTRING& input_stream, PCUIF__BurstType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_BurstType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__BurstType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_ra_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_ra_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_ra_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_ra_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_qta_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_qta_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_qta_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_qta_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_fn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_fn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_is__11bit_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_is__11bit_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_is__11bit_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_is__11bit_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_burst__type_encoder(const PCUIF__BurstType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_BurstType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_burst__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_burst__type_decoder(OCTETSTRING& input_stream, PCUIF__BurstType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_BurstType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_burst__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_ts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_ts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__rach__ind_encoder(const PCUIF__rach__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rach_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__rach__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__rach__ind_decoder(OCTETSTRING& input_stream, PCUIF__rach__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rach_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__rach__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_tsc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_tsc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_tsc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_tsc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_hopping_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_hopping_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_hopping_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_hopping_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_hsn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_hsn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_hsn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_hsn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_maio_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_maio_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_maio_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_maio_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_ma__bit__len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_ma__bit__len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_ma__bit__len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_ma__bit__len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_ma_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_ma_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_ma_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_ma_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTs_encoder(const PCUIF__InfoTrxTs& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTs_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTs_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxTs& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTs_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const PCUIF__InfoTrxTsList& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @PCUIF_Types.PCUIF_InfoTrxTsList.");
return other_value.val_ptr->n_elements == 0;
}

void PCUIF__InfoTrxTsList_0_encoder(const PCUIF__InfoTrxTs& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTsList_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTsList_0_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxTs& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTsList_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxTsList_encoder(const PCUIF__InfoTrxTsList& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTsList' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxTsList_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxTsList_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxTsList& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTsList' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxTsList_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_pdch__mask_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_pdch__mask_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_pdch__mask_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_pdch__mask_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_hLayer1_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_hLayer1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_hLayer1_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_hLayer1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_ts_encoder(const PCUIF__InfoTrxTsList& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTsList' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_ts_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_ts_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxTsList& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxTsList' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_ts_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrx_encoder(const PCUIF__InfoTrx& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrx' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrx_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrx_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrx& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrx' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrx_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const PCUIF__InfoTrxs& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @PCUIF_Types.PCUIF_InfoTrxs.");
return other_value.val_ptr->n_elements == 0;
}

void PCUIF__InfoTrxs_0_encoder(const PCUIF__InfoTrx& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrx' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxs_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxs_0_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrx& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrx' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxs_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__InfoTrxs_encoder(const PCUIF__InfoTrxs& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__InfoTrxs_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__InfoTrxs_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxs& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__InfoTrxs_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_version_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_version_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_version_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_version_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_flags_encoder(const PCUIF__Flags& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Flags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_flags_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_flags_decoder(OCTETSTRING& input_stream, PCUIF__Flags& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Flags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_flags_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_trx_encoder(const PCUIF__InfoTrxs& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_trx_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_trx_decoder(OCTETSTRING& input_stream, PCUIF__InfoTrxs& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_InfoTrxs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_trx_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_bsic_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_bsic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_bsic_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_bsic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_mcc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_mcc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_mcc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_mcc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_mnc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_mnc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_mnc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_mnc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_mnc__3__digits_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_mnc__3__digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_mnc__3__digits_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_mnc__3__digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_lac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_lac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_lac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_lac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_rac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_rac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_rac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_rac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_nsei_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_nsei_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_nsei_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_nsei_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_nse__timer_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_nse__timer_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_nse__timer_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_nse__timer_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_nse__timer_encoder(const PCUIF__info__ind_nse__timer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.nse_timer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_nse__timer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_nse__timer_decoder(OCTETSTRING& input_stream, PCUIF__info__ind_nse__timer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.nse_timer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_nse__timer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_cell__timer_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_cell__timer_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_cell__timer_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_cell__timer_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_cell__timer_encoder(const PCUIF__info__ind_cell__timer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.cell_timer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_cell__timer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_cell__timer_decoder(OCTETSTRING& input_stream, PCUIF__info__ind_cell__timer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.cell_timer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_cell__timer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_cell__id_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_cell__id_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_cell__id_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_cell__id_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_repeat__time_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_repeat__time_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_repeat__time_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_repeat__time_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_repeat__count_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_repeat__count_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_repeat__count_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_repeat__count_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_bvci_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_bvci_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_bvci_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_bvci_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_t3142_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_t3142_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_t3142_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_t3142_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_t3169_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_t3169_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_t3169_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_t3169_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_t3191_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_t3191_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_t3191_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_t3191_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_t3193__10ms_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_t3193__10ms_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_t3193__10ms_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_t3193__10ms_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_t3195_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_t3195_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_t3195_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_t3195_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_n3101_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_n3101_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_n3101_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_n3101_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_n3103_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_n3103_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_n3103_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_n3103_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_n3105_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_n3105_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_n3105_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_n3105_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_cv__countdown_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_cv__countdown_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_cv__countdown_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_cv__countdown_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_dl__tbf__ext_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_dl__tbf__ext_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_dl__tbf__ext_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_dl__tbf__ext_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_ul__tbf__ext_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_ul__tbf__ext_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_ul__tbf__ext_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_ul__tbf__ext_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_initial__cs_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_initial__cs_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_initial__cs_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_initial__cs_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_initial__mcs_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_initial__mcs_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_initial__mcs_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_initial__mcs_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_nsvci_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_nsvci_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_nsvci_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_nsvci_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_nsvci_encoder(const PCUIF__info__ind_nsvci& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.nsvci' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_nsvci_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_nsvci_decoder(OCTETSTRING& input_stream, PCUIF__info__ind_nsvci& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.nsvci' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_nsvci_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_local__port_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_local__port_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_local__port_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_local__port_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_local__port_encoder(const PCUIF__info__ind_local__port& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.local_port' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_local__port_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_local__port_decoder(OCTETSTRING& input_stream, PCUIF__info__ind_local__port& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.local_port' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_local__port_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_remote__port_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_remote__port_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_remote__port_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_remote__port_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_remote__port_encoder(const PCUIF__info__ind_remote__port& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.remote_port' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_remote__port_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_remote__port_decoder(OCTETSTRING& input_stream, PCUIF__info__ind_remote__port& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind.remote_port' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_remote__port_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const PCUIF__RemoteAddr_addr__type& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @PCUIF_Types.PCUIF_RemoteAddr.addr_type.");
return other_value.val_ptr->n_elements == 0;
}

void PCUIF__AddrType_encoder(const PCUIF__AddrType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_AddrType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__AddrType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__AddrType_decoder(OCTETSTRING& input_stream, PCUIF__AddrType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_AddrType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__AddrType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__RemoteAddr_addr__type_0_encoder(const PCUIF__AddrType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_AddrType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__RemoteAddr_addr__type_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__RemoteAddr_addr__type_0_decoder(OCTETSTRING& input_stream, PCUIF__AddrType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_AddrType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__RemoteAddr_addr__type_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__RemoteAddr_addr__type_encoder(const PCUIF__RemoteAddr_addr__type& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr.addr_type' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__RemoteAddr_addr__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__RemoteAddr_addr__type_decoder(OCTETSTRING& input_stream, PCUIF__RemoteAddr_addr__type& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr.addr_type' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__RemoteAddr_addr__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__RemoteAddr_addr_0_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__RemoteAddr_addr_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__RemoteAddr_addr_0_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__RemoteAddr_addr_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__RemoteAddr_addr_encoder(const PCUIF__RemoteAddr_addr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr.addr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__RemoteAddr_addr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__RemoteAddr_addr_decoder(OCTETSTRING& input_stream, PCUIF__RemoteAddr_addr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr.addr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__RemoteAddr_addr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__RemoteAddr_encoder(const PCUIF__RemoteAddr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__RemoteAddr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__RemoteAddr_decoder(OCTETSTRING& input_stream, PCUIF__RemoteAddr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__RemoteAddr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_remote__addr_encoder(const PCUIF__RemoteAddr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_remote__addr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_remote__addr_decoder(OCTETSTRING& input_stream, PCUIF__RemoteAddr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_RemoteAddr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_remote__addr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_bts__model_encoder(const PCUIF__bts__model& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_bts_model' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_bts__model_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_bts__model_decoder(OCTETSTRING& input_stream, PCUIF__bts__model& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_bts_model' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_bts__model_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__info__ind_encoder(const PCUIF__info__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__info__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__info__ind_decoder(OCTETSTRING& input_stream, PCUIF__info__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__info__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_ts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_ts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_e1__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_e1__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_e1__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_e1__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_e1__ts_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_e1__ts_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_e1__ts_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_e1__ts_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_e1__ts__ss_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_e1__ts__ss_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_e1__ts__ss_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_e1__ts__ss_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__e1__ccu__ind_encoder(const PCUIF__e1__ccu__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_e1_ccu_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__e1__ccu__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__e1__ccu__ind_decoder(OCTETSTRING& input_stream, PCUIF__e1__ccu__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_e1_ccu_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__e1__ccu__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__act__req_is__activate_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__act__req_is__activate_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__act__req_is__activate_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__act__req_is__activate_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__act__req_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__act__req_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__act__req_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__act__req_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__act__req_ts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__act__req_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__act__req_ts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__act__req_ts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__act__req_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__act__req_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__act__req_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__act__req_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__act__req_encoder(const PCUIF__act__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_act_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__act__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__act__req_decoder(OCTETSTRING& input_stream, PCUIF__act__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_act_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__act__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__time__ind_fn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__time__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__time__ind_fn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__time__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__time__ind_encoder(const PCUIF__time__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_time_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__time__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__time__ind_decoder(OCTETSTRING& input_stream, PCUIF__time__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_time_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__time__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf_0_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf_0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf_0_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf_0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf_encoder(const PCUIF__interf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf_decoder(OCTETSTRING& input_stream, PCUIF__interf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf__ind_trx__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf__ind_trx__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf__ind_trx__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf__ind_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf__ind_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf__ind_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf__ind_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf__ind_fn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf__ind_fn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf__ind_fn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf__ind_interf_encoder(const PCUIF__interf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf__ind_interf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf__ind_interf_decoder(OCTETSTRING& input_stream, PCUIF__interf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf__ind_interf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__interf__ind_encoder(const PCUIF__interf__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__interf__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__interf__ind_decoder(OCTETSTRING& input_stream, PCUIF__interf__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__interf__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pag__req_sapi_encoder(const PCUIF__Sapi& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pag__req_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pag__req_sapi_decoder(OCTETSTRING& input_stream, PCUIF__Sapi& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Sapi' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pag__req_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pag__req_chan__needed_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pag__req_chan__needed_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pag__req_chan__needed_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pag__req_chan__needed_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pag__req_identity__lv_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pag__req_identity__lv_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pag__req_identity__lv_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pag__req_identity__lv_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pag__req_encoder(const PCUIF__pag__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pag_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pag__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pag__req_decoder(OCTETSTRING& input_stream, PCUIF__pag__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pag_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pag__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__app__info__req_application__type_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__app__info__req_application__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__app__info__req_application__type_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__app__info__req_application__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__app__info__req_len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__app__info__req_len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__app__info__req_len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__app__info__req_len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__app__info__req_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__app__info__req_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__app__info__req_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__app__info__req_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__app__info__req_encoder(const PCUIF__app__info__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_app_info_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__app__info__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__app__info__req_decoder(OCTETSTRING& input_stream, PCUIF__app__info__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_app_info_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__app__info__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__susp__req_tlli_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__susp__req_tlli_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__susp__req_tlli_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__susp__req_tlli_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__susp__req_ra__id_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__susp__req_ra__id_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__susp__req_ra__id_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__susp__req_ra__id_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__susp__req_cause_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__susp__req_cause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__susp__req_cause_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__susp__req_cause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__susp__req_encoder(const PCUIF__susp__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_susp_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__susp__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__susp__req_decoder(OCTETSTRING& input_stream, PCUIF__susp__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_susp_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__susp__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__req_local__lac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__req_local__lac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__req_local__lac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__req_local__lac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__req_local__ci_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__req_local__ci_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__req_local__ci_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__req_local__ci_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__req_tgt__arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__req_tgt__arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__req_tgt__arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__req_tgt__arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__req_tgt__bsic_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__req_tgt__bsic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__req_tgt__bsic_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__req_tgt__bsic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__req_encoder(const PCUIF__neigh__addr__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__req_decoder(OCTETSTRING& input_stream, PCUIF__neigh__addr__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_orig__req_encoder(const PCUIF__neigh__addr__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_orig__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_orig__req_decoder(OCTETSTRING& input_stream, PCUIF__neigh__addr__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_orig__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_error__code_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_error__code_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_error__code_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_error__code_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_mcc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_mcc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_mcc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_mcc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_mnc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_mnc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_mnc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_mnc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_mnc__3__digits_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_mnc__3__digits_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_mnc__3__digits_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_mnc__3__digits_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_lac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_lac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_lac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_lac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_rac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_rac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_rac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_rac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_cell__identity_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_cell__identity_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_cell__identity_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_cell__identity_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__neigh__addr__cnf_encoder(const PCUIF__neigh__addr__cnf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__neigh__addr__cnf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__neigh__addr__cnf_decoder(OCTETSTRING& input_stream, PCUIF__neigh__addr__cnf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__neigh__addr__cnf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__ContainerMsgUnion_neigh__addr__req_encoder(const PCUIF__neigh__addr__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__ContainerMsgUnion_neigh__addr__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__ContainerMsgUnion_neigh__addr__req_decoder(OCTETSTRING& input_stream, PCUIF__neigh__addr__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__ContainerMsgUnion_neigh__addr__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__ContainerMsgUnion_neigh__addr__cnf_encoder(const PCUIF__neigh__addr__cnf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__ContainerMsgUnion_neigh__addr__cnf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__ContainerMsgUnion_neigh__addr__cnf_decoder(OCTETSTRING& input_stream, PCUIF__neigh__addr__cnf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_neigh_addr_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__ContainerMsgUnion_neigh__addr__cnf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__ContainerMsgUnion_other_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__ContainerMsgUnion_other_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__ContainerMsgUnion_other_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__ContainerMsgUnion_other_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__ContainerMsgUnion_encoder(const PCUIF__ContainerMsgUnion& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_ContainerMsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__ContainerMsgUnion_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__ContainerMsgUnion_decoder(OCTETSTRING& input_stream, PCUIF__ContainerMsgUnion& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_ContainerMsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__ContainerMsgUnion_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__container_msg__type_encoder(const PCUIF__MsgType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__container_msg__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__container_msg__type_decoder(OCTETSTRING& input_stream, PCUIF__MsgType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__container_msg__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__container_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__container_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__container_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__container_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__container_len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__container_len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__container_len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__container_len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__container_u_encoder(const PCUIF__ContainerMsgUnion& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_ContainerMsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__container_u_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__container_u_decoder(OCTETSTRING& input_stream, PCUIF__ContainerMsgUnion& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_ContainerMsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__container_u_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__container_encoder(const PCUIF__container& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_container' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__container_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__container_decoder(OCTETSTRING& input_stream, PCUIF__container& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_container' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__container_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pch_msg__id_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pch_msg__id_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pch_msg__id_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pch_msg__id_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pch_imsi_encoder(const CHARSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pch_imsi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pch_imsi_decoder(OCTETSTRING& input_stream, CHARSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pch_imsi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pch_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pch_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pch_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pch_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pch_confirm_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pch_confirm_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pch_confirm_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pch_confirm_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__pch_encoder(const PCUIF__pch& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pch' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__pch_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__pch_decoder(OCTETSTRING& input_stream, PCUIF__pch& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pch' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__pch_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__PCUIF__pch(const PCUIF__pch& pdu)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_pch(): Encoding @PCUIF_Types.PCUIF_pch: ");
pdu.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
pdu.encode(PCUIF__pch_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_pch(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

PCUIF__pch dec__PCUIF__pch(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_pch(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
PCUIF__pch ret_val;
ret_val.decode(PCUIF__pch_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_pch(): Decoded @PCUIF_Types.PCUIF_pch: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_PCUIF_pch(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

void PCUIF__agch_msg__id_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__agch_msg__id_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__agch_msg__id_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__agch_msg__id_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__agch_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__agch_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__agch_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__agch_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__agch_confirm_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__agch_confirm_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__agch_confirm_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__agch_confirm_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__agch_encoder(const PCUIF__agch& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_agch' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__agch_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__agch_decoder(OCTETSTRING& input_stream, PCUIF__agch& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_agch' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__agch_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__PCUIF__agch(const PCUIF__agch& pdu)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_agch(): Encoding @PCUIF_Types.PCUIF_agch: ");
pdu.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
pdu.encode(PCUIF__agch_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_agch(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

PCUIF__agch dec__PCUIF__agch(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_agch(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
PCUIF__agch ret_val;
ret_val.decode(PCUIF__agch_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_agch(): Decoded @PCUIF_Types.PCUIF_agch: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_PCUIF_agch(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

void PCUIF__MsgUnion_data__req_encoder(const PCUIF__data& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_data__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_data__req_decoder(OCTETSTRING& input_stream, PCUIF__data& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_data__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_data__cnf2_encoder(const PCUIF__data__cnf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_data__cnf2_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_data__cnf2_decoder(OCTETSTRING& input_stream, PCUIF__data__cnf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data_cnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_data__cnf2_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_data__ind_encoder(const PCUIF__data& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_data__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_data__ind_decoder(OCTETSTRING& input_stream, PCUIF__data& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_data' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_data__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_susp__req_encoder(const PCUIF__susp__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_susp_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_susp__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_susp__req_decoder(OCTETSTRING& input_stream, PCUIF__susp__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_susp_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_susp__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_rts__req_encoder(const PCUIF__rts__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rts_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_rts__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_rts__req_decoder(OCTETSTRING& input_stream, PCUIF__rts__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rts_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_rts__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_rach__ind_encoder(const PCUIF__rach__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rach_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_rach__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_rach__ind_decoder(OCTETSTRING& input_stream, PCUIF__rach__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_rach_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_rach__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_txt__ind_encoder(const PCUIF__txt__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_txt_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_txt__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_txt__ind_decoder(OCTETSTRING& input_stream, PCUIF__txt__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_txt_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_txt__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_info__ind_encoder(const PCUIF__info__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_info__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_info__ind_decoder(OCTETSTRING& input_stream, PCUIF__info__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_info_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_info__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_e1__ccu__ind_encoder(const PCUIF__e1__ccu__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_e1_ccu_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_e1__ccu__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_e1__ccu__ind_decoder(OCTETSTRING& input_stream, PCUIF__e1__ccu__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_e1_ccu_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_e1__ccu__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_act__req_encoder(const PCUIF__act__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_act_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_act__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_act__req_decoder(OCTETSTRING& input_stream, PCUIF__act__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_act_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_act__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_time__ind_encoder(const PCUIF__time__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_time_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_time__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_time__ind_decoder(OCTETSTRING& input_stream, PCUIF__time__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_time_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_time__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_interf__ind_encoder(const PCUIF__interf__ind& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_interf__ind_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_interf__ind_decoder(OCTETSTRING& input_stream, PCUIF__interf__ind& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_interf_ind' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_interf__ind_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_pag__req_encoder(const PCUIF__pag__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pag_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_pag__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_pag__req_decoder(OCTETSTRING& input_stream, PCUIF__pag__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_pag_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_pag__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_app__info__req_encoder(const PCUIF__app__info__req& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_app_info_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_app__info__req_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_app__info__req_decoder(OCTETSTRING& input_stream, PCUIF__app__info__req& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_app_info_req' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_app__info__req_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_container_encoder(const PCUIF__container& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_container' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_container_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_container_decoder(OCTETSTRING& input_stream, PCUIF__container& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_container' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_container_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__MsgUnion_encoder(const PCUIF__MsgUnion& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__MsgUnion_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__MsgUnion_decoder(OCTETSTRING& input_stream, PCUIF__MsgUnion& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__MsgUnion_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Message_msg__type_encoder(const PCUIF__MsgType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Message_msg__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Message_msg__type_decoder(OCTETSTRING& input_stream, PCUIF__MsgType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Message_msg__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Message_bts__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Message_bts__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Message_bts__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Message_bts__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Message_spare_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Message_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Message_spare_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Message_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Message_u_encoder(const PCUIF__MsgUnion& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Message_u_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Message_u_decoder(OCTETSTRING& input_stream, PCUIF__MsgUnion& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_MsgUnion' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Message_u_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PCUIF__Message_encoder(const PCUIF__Message& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Message' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PCUIF__Message_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PCUIF__Message_decoder(OCTETSTRING& input_stream, PCUIF__Message& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@PCUIF_Types.PCUIF_Message' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PCUIF__Message_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__PCUIF__Message(const PCUIF__Message& pdu)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_Message(): Encoding @PCUIF_Types.PCUIF_Message: ");
pdu.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
pdu.encode(PCUIF__Message_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_PCUIF_Message(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

PCUIF__Message dec__PCUIF__Message(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_Message(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
PCUIF__Message ret_val;
ret_val.decode(PCUIF__Message_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_PCUIF_Message(): Decoded @PCUIF_Types.PCUIF_Message: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_PCUIF_Message(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__MSG(const PCUIF__MsgType_template& msg__type, const INTEGER_template& bts__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 411, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_MSG");
PCUIF__Message_template ret_val;
ret_val.msg__type() = msg__type;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
ret_val.u() = ANY_VALUE;
return ret_val;
}

PCUIF__Message_template ts__PCUIF__RTS__REQ(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const PCUIF__Sapi_template& sapi, const INTEGER_template& fn, const INTEGER_template& arfcn, const INTEGER_template& block__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 419, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_RTS_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__RTS__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__rts__req_template& tmp_0 = ret_val.u().rts__req();
tmp_0.sapi() = sapi;
tmp_0.spare() = os_1;
tmp_0.fn() = fn;
tmp_0.arfcn() = arfcn;
tmp_0.trx__nr() = trx__nr;
tmp_0.ts__nr() = ts__nr;
tmp_0.block__nr() = block__nr;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__RTS__REQ(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const PCUIF__Sapi_template& sapi, const INTEGER_template& fn, const INTEGER_template& block__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 442, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_RTS_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__RTS__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__rts__req_template& tmp_1 = ret_val.u().rts__req();
tmp_1.sapi() = sapi;
tmp_1.spare() = ANY_VALUE;
tmp_1.fn() = fn;
tmp_1.arfcn() = ANY_VALUE;
tmp_1.trx__nr() = trx__nr;
tmp_1.ts__nr() = ts__nr;
tmp_1.block__nr() = block__nr;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__TXT__IND(const INTEGER& bts__nr, const PCUIF__TextType& tt, const CHARSTRING& text)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 465, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_TXT_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__TXT__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__txt__ind_template& tmp_2 = ret_val.u().txt__ind();
tmp_2.txt__type() = tt;
tmp_2.text() = text;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__TXT__IND(const INTEGER_template& bts__nr, const PCUIF__TextType_template& tt, const CHARSTRING_template& text)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 476, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_TXT_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__TXT__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__txt__ind_template& tmp_3 = ret_val.u().txt__ind();
tmp_3.txt__type() = tt;
tmp_3.text() = text;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__ACT__REQ(const INTEGER& bts__nr, const INTEGER& trx__nr, const INTEGER& ts__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 491, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_ACT_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__ACT__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__act__req_template& tmp_4 = ret_val.u().act__req();
tmp_4.is__activate() = 1;
tmp_4.trx__nr() = trx__nr;
tmp_4.ts__nr() = ts__nr;
tmp_4.spare() = os_2;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__ACT__REQ(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 504, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_ACT_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__ACT__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__act__req_template& tmp_5 = ret_val.u().act__req();
tmp_5.is__activate() = 1;
tmp_5.trx__nr() = trx__nr;
tmp_5.ts__nr() = ts__nr;
tmp_5.spare() = os_2;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__DEACT__REQ(const INTEGER& bts__nr, const INTEGER& trx__nr, const INTEGER& ts__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 519, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_DEACT_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__ACT__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__act__req_template& tmp_6 = ret_val.u().act__req();
tmp_6.is__activate() = 0;
tmp_6.trx__nr() = trx__nr;
tmp_6.ts__nr() = ts__nr;
tmp_6.spare() = os_2;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__DEACT__REQ(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 532, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_DEACT_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__ACT__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__act__req_template& tmp_7 = ret_val.u().act__req();
tmp_7.is__activate() = 0;
tmp_7.trx__nr() = trx__nr;
tmp_7.ts__nr() = ts__nr;
tmp_7.spare() = os_2;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__DATA__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& block__nr, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& data, const INTEGER_template& fn, const INTEGER_template& arfcn, const INTEGER_template& rssi, const INTEGER_template& ber10k, const INTEGER_template& ta__offs__qbits, const INTEGER_template& lqual__cb)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 547, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_DATA_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__data_template& tmp_8 = ret_val.u().data__ind();
tmp_8.sapi() = sapi;
tmp_8.len() = data.valueof().lengthof();
tmp_8.data() = data;
tmp_8.fn() = fn;
tmp_8.arfcn() = arfcn;
tmp_8.trx__nr() = trx__nr;
tmp_8.ts__nr() = ts__nr;
tmp_8.block__nr() = block__nr;
tmp_8.rssi() = rssi;
tmp_8.ber10k() = ber10k;
tmp_8.ta__offs__qbits() = ta__offs__qbits;
tmp_8.lqual__cb() = lqual__cb;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__DATA__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& block__nr, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 579, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_DATA_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__data_template& tmp_9 = ret_val.u().data__ind();
tmp_9.sapi() = sapi;
tmp_9.len() = ANY_VALUE;
tmp_9.data() = data;
tmp_9.fn() = ANY_VALUE;
tmp_9.arfcn() = ANY_VALUE;
tmp_9.trx__nr() = trx__nr;
tmp_9.ts__nr() = ts__nr;
tmp_9.block__nr() = block__nr;
tmp_9.rssi() = ANY_VALUE;
tmp_9.ber10k() = ANY_VALUE;
tmp_9.ta__offs__qbits() = ANY_VALUE;
tmp_9.lqual__cb() = ANY_VALUE;
}
return ret_val;
}

PCUIF__data_template tr__PCUIF__DATA(const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& block__nr, const INTEGER_template& fn, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 606, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_DATA");
PCUIF__data_template ret_val;
ret_val.sapi() = sapi;
ret_val.len() = ANY_VALUE;
ret_val.data() = data;
ret_val.fn() = fn;
ret_val.arfcn() = ANY_VALUE;
ret_val.trx__nr() = trx__nr;
ret_val.ts__nr() = ts__nr;
ret_val.block__nr() = block__nr;
ret_val.rssi() = 0;
ret_val.ber10k() = 0;
ret_val.ta__offs__qbits() = 0;
ret_val.lqual__cb() = 0;
return ret_val;
}

PCUIF__Message_template ts__PCUIF__DATA__REQ(const INTEGER& bts__nr, const INTEGER& trx__nr, const INTEGER& ts__nr, const INTEGER& block__nr, const INTEGER& fn, const PCUIF__Sapi& sapi, const OCTETSTRING& data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 628, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_DATA_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__data_template& tmp_10 = ret_val.u().data__req();
tmp_10.sapi() = sapi;
tmp_10.len() = data.lengthof();
tmp_10.data() = data;
tmp_10.fn() = fn;
tmp_10.arfcn() = 0;
tmp_10.trx__nr() = trx__nr;
tmp_10.ts__nr() = ts__nr;
tmp_10.block__nr() = block__nr;
tmp_10.rssi() = 0;
tmp_10.ber10k() = 0;
tmp_10.ta__offs__qbits() = 0;
tmp_10.lqual__cb() = 0;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__DATA__REQ(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& block__nr, const INTEGER_template& fn, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 653, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_DATA_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().data__req() = tr__PCUIF__DATA(trx__nr, ts__nr, block__nr, fn, sapi, data);
return ret_val;
}

PCUIF__Message_template ts__PCUIF__DATA__CNF__2(const INTEGER_template& bts__nr, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& msg__id)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 668, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_DATA_CNF_2");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__CNF__2;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__data__cnf_template& tmp_11 = ret_val.u().data__cnf2();
tmp_11.sapi() = sapi;
tmp_11.msg__id() = msg__id;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__DATA__CNF__2(const INTEGER_template& bts__nr, const PCUIF__Sapi_template& sapi, const OCTETSTRING_template& msg__id)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 681, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_DATA_CNF_2");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__DATA__CNF__2;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__data__cnf_template& tmp_12 = ret_val.u().data__cnf2();
tmp_12.sapi() = sapi;
tmp_12.msg__id() = msg__id;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__RACH__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& ra, const INTEGER_template& is__11bit, const PCUIF__BurstType_template& burst__type, const INTEGER_template& fn, const INTEGER_template& arfcn, const INTEGER_template& qta, const PCUIF__Sapi_template& sapi)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 695, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_RACH_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__RACH__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__rach__ind_template& tmp_13 = ret_val.u().rach__ind();
tmp_13.sapi() = sapi;
tmp_13.ra() = ra;
tmp_13.qta() = qta;
tmp_13.fn() = fn;
tmp_13.arfcn() = arfcn;
tmp_13.is__11bit() = is__11bit;
tmp_13.burst__type() = burst__type;
tmp_13.trx__nr() = trx__nr;
tmp_13.ts__nr() = ts__nr;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__RACH__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& ts__nr, const INTEGER_template& ra, const INTEGER_template& is__11bit, const PCUIF__BurstType_template& burst__type, const INTEGER_template& fn, const PCUIF__Sapi_template& sapi)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 723, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_RACH_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__RACH__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__rach__ind_template& tmp_14 = ret_val.u().rach__ind();
tmp_14.sapi() = sapi;
tmp_14.ra() = ra;
tmp_14.qta() = ANY_VALUE;
tmp_14.fn() = fn;
tmp_14.arfcn() = ANY_VALUE;
tmp_14.is__11bit() = is__11bit;
tmp_14.burst__type() = burst__type;
tmp_14.trx__nr() = trx__nr;
tmp_14.ts__nr() = ts__nr;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__PAG__REQ(const INTEGER_template& bts__nr, const OCTETSTRING_template& id__lv, const INTEGER_template& chan__needed, const PCUIF__Sapi_template& sapi)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 749, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_PAG_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__PAG__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__pag__req_template& tmp_15 = ret_val.u().pag__req();
tmp_15.sapi() = sapi;
tmp_15.chan__needed() = chan__needed;
tmp_15.identity__lv() = id__lv;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__PAG__REQ(const INTEGER_template& bts__nr, const OCTETSTRING_template& id__lv, const INTEGER_template& chan__needed, const PCUIF__Sapi_template& )
{
TTCN_Location current_location("PCUIF_Types.ttcn", 764, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_PAG_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__PAG__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__pag__req_template& tmp_16 = ret_val.u().pag__req();
tmp_16.sapi() = ANY_VALUE;
tmp_16.chan__needed() = chan__needed;
tmp_16.identity__lv() = id__lv;
}
return ret_val;
}

BOOLEAN f__pcuif__ind__flags__egprs__enabled(const PCUIF__Flags& flags)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 820, TTCN_Location::LOCATION_FUNCTION, "f_pcuif_ind_flags_egprs_enabled");
current_location.update_lineno(821);
/* PCUIF_Types.ttcn, line 821 */
return ((((((((const_cast< const PCUIF__Flags&>(flags).mcs1() || const_cast< const PCUIF__Flags&>(flags).mcs2()) || const_cast< const PCUIF__Flags&>(flags).mcs3()) || const_cast< const PCUIF__Flags&>(flags).mcs4()) || const_cast< const PCUIF__Flags&>(flags).mcs5()) || const_cast< const PCUIF__Flags&>(flags).mcs6()) || const_cast< const PCUIF__Flags&>(flags).mcs7()) || const_cast< const PCUIF__Flags&>(flags).mcs8()) || const_cast< const PCUIF__Flags&>(flags).mcs9());
}

PCUIF__InfoTrxTs_template ts__PCUIF__InfoTrxTsH0(const INTEGER_template& tsc)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 826, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_InfoTrxTsH0");
PCUIF__InfoTrxTs_template ret_val;
ret_val.tsc() = tsc;
ret_val.hopping() = 0;
ret_val.hsn() = 0;
ret_val.maio() = 0;
ret_val.ma__bit__len() = 0;
ret_val.ma() = Osmocom__Types::f__pad__bit(bs_2, 64, bs_3);
return ret_val;
}

PCUIF__InfoTrxTs_template tr__PCUIF__InfoTrxTsH0(const INTEGER_template& tsc)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 833, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_InfoTrxTsH0");
PCUIF__InfoTrxTs_template ret_val;
ret_val.tsc() = tsc;
ret_val.hopping() = 0;
ret_val.hsn() = ANY_VALUE;
ret_val.maio() = ANY_VALUE;
ret_val.ma__bit__len() = ANY_VALUE;
ret_val.ma() = ANY_VALUE;
return ret_val;
}

PCUIF__InfoTrxTs_template ts__PCUIF__InfoTrxTsH1(const INTEGER_template& tsc, const INTEGER_template& hsn, const INTEGER_template& maio, const BITSTRING_template& ma)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 841, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_InfoTrxTsH1");
PCUIF__InfoTrxTs_template ret_val;
ret_val.tsc() = tsc;
ret_val.hopping() = 1;
ret_val.hsn() = hsn;
ret_val.maio() = maio;
ret_val.ma__bit__len() = ma.valueof().lengthof();
ret_val.ma() = Osmocom__Types::f__pad__bit(ma.valueof(), 64, bs_3);
return ret_val;
}

PCUIF__InfoTrxTs_template tr__PCUIF__InfoTrxTsH1(const INTEGER_template& tsc, const INTEGER_template& hsn, const INTEGER_template& maio, const BITSTRING_template& ma, const INTEGER_template& ma__bit__len)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 852, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_InfoTrxTsH1");
PCUIF__InfoTrxTs_template ret_val;
ret_val.tsc() = tsc;
ret_val.hopping() = 1;
ret_val.hsn() = hsn;
ret_val.maio() = maio;
ret_val.ma__bit__len() = ma__bit__len;
ret_val.ma() = ma;
return ret_val;
}

PCUIF__InfoTrx_template ts__PCUIF__InfoTrx(const INTEGER_template& arfcn, const BITSTRING_template& pdch__mask, const INTEGER_template& tsc)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 865, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_InfoTrx");
PCUIF__InfoTrx_template ret_val;
ret_val.arfcn() = arfcn;
ret_val.pdch__mask() = pdch__mask;
ret_val.spare() = os_2;
ret_val.hLayer1() = 0;
{
PCUIF__InfoTrxTsList_template& tmp_17 = ret_val.ts();
tmp_17.set_size(8);
tmp_17[0] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[1] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[2] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[3] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[4] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[5] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[6] = ts__PCUIF__InfoTrxTsH0(tsc);
tmp_17[7] = ts__PCUIF__InfoTrxTsH0(tsc);
}
return ret_val;
}

PCUIF__InfoTrxs_template ts__PCUIF__InfoTrxs__def(const INTEGER& base__arfcn)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 881, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_InfoTrxs_def");
PCUIF__InfoTrxs_template ret_val;
ret_val.set_size(8);
ret_val[0] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 0)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[1] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 1)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[2] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 2)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[3] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 3)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[4] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 4)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[5] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 5)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[6] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 6)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
ret_val[7] = ts__PCUIF__InfoTrx(INTEGER_template((base__arfcn + 7)), ts__PCUIF__InfoTrx_pdch__mask_defval, ts__PCUIF__InfoTrx_tsc_defval);
return ret_val;
}

PCUIF__Message_template ts__PCUIF__INFO__IND(const INTEGER_template& bts__nr, const PCUIF__info__ind_template& info__ind)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 893, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_INFO_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__INFO__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().info__ind() = info__ind;
return ret_val;
}

PCUIF__Message_template tr__PCUIF__INFO__IND(const INTEGER_template& bts__nr, const PCUIF__Flags_template& flags, const INTEGER_template& version)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 902, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_INFO_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__INFO__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__info__ind_template& tmp_18 = ret_val.u().info__ind();
tmp_18.version() = version;
tmp_18.flags() = flags;
tmp_18.trx() = ANY_VALUE;
tmp_18.bsic() = ANY_VALUE;
tmp_18.mcc() = ANY_VALUE;
tmp_18.mnc() = ANY_VALUE;
tmp_18.mnc__3__digits() = ANY_VALUE;
tmp_18.lac() = ANY_VALUE;
tmp_18.rac() = ANY_VALUE;
tmp_18.nsei() = ANY_VALUE;
tmp_18.nse__timer() = ANY_VALUE;
tmp_18.cell__timer() = ANY_VALUE;
tmp_18.cell__id() = ANY_VALUE;
tmp_18.repeat__time() = ANY_VALUE;
tmp_18.repeat__count() = ANY_VALUE;
tmp_18.bvci() = ANY_VALUE;
tmp_18.t3142() = ANY_VALUE;
tmp_18.t3169() = ANY_VALUE;
tmp_18.t3191() = ANY_VALUE;
tmp_18.t3193__10ms() = ANY_VALUE;
tmp_18.t3195() = ANY_VALUE;
tmp_18.n3101() = ANY_VALUE;
tmp_18.n3103() = ANY_VALUE;
tmp_18.n3105() = ANY_VALUE;
tmp_18.cv__countdown() = ANY_VALUE;
tmp_18.dl__tbf__ext() = ANY_VALUE;
tmp_18.ul__tbf__ext() = ANY_VALUE;
tmp_18.initial__cs() = ANY_VALUE;
tmp_18.initial__mcs() = ANY_VALUE;
tmp_18.nsvci() = ANY_VALUE;
tmp_18.local__port() = ANY_VALUE;
tmp_18.remote__port() = ANY_VALUE;
tmp_18.remote__addr() = ANY_VALUE;
tmp_18.bts__model() = ANY_OR_OMIT;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__TIME__IND(const INTEGER_template& bts__nr, const INTEGER_template& fn)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 949, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_TIME_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__TIME__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().time__ind().fn() = fn;
return ret_val;
}

PCUIF__Message_template tr__PCUIF__TIME__IND(const INTEGER_template& bts__nr, const INTEGER_template& fn)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 960, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_TIME_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__TIME__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
ret_val.u().time__ind().fn() = fn;
return ret_val;
}

PCUIF__Message_template ts__PCUIF__INTERF__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& fn, const PCUIF__interf_template& interf)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 972, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_INTERF_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__INTERF__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__interf__ind_template& tmp_19 = ret_val.u().interf__ind();
tmp_19.trx__nr() = trx__nr;
tmp_19.spare() = os_1;
tmp_19.fn() = fn;
tmp_19.interf() = interf;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__INTERF__IND(const INTEGER_template& bts__nr, const INTEGER_template& trx__nr, const INTEGER_template& fn, const PCUIF__interf_template& interf)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 989, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_INTERF_IND");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__INTERF__IND;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = ANY_VALUE;
{
PCUIF__interf__ind_template& tmp_20 = ret_val.u().interf__ind();
tmp_20.trx__nr() = trx__nr;
tmp_20.spare() = ANY_VALUE;
tmp_20.fn() = fn;
tmp_20.interf() = interf;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__SUSP__REQ(const INTEGER_template& bts__nr, const OCTETSTRING_template& tlli, const OCTETSTRING_template& ra__id, const INTEGER_template& cause)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1007, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_SUSP_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__SUSP__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__susp__req_template& tmp_21 = ret_val.u().susp__req();
tmp_21.tlli() = tlli;
tmp_21.ra__id() = ra__id;
tmp_21.cause() = cause;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__SUSP__REQ(const INTEGER_template& bts__nr, const OCTETSTRING_template& tlli, const OCTETSTRING_template& ra__id, const INTEGER_template& cause)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1022, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_SUSP_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__SUSP__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__susp__req_template& tmp_22 = ret_val.u().susp__req();
tmp_22.tlli() = tlli;
tmp_22.ra__id() = ra__id;
tmp_22.cause() = cause;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__APP__INFO__REQ(const INTEGER_template& bts__nr, const INTEGER_template& app__type, const OCTETSTRING_template& app__data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1038, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_APP_INFO_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__APP__INFO__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__app__info__req_template& tmp_23 = ret_val.u().app__info__req();
tmp_23.application__type() = app__type;
tmp_23.len() = 0;
tmp_23.data() = app__data;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__APP__INFO__REQ(const INTEGER_template& bts__nr, const INTEGER_template& app__type, const OCTETSTRING_template& app__data)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1052, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_APP_INFO_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__APP__INFO__REQ;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
{
PCUIF__app__info__req_template& tmp_24 = ret_val.u().app__info__req();
tmp_24.application__type() = app__type;
tmp_24.len() = ANY_VALUE;
tmp_24.data() = app__data;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__CONTAINER(const INTEGER_template& bts__nr, const PCUIF__container_template& container)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1068, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_CONTAINER");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__CONTAINER;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().container() = container;
return ret_val;
}

PCUIF__Message_template tr__PCUIF__CONTAINER(const INTEGER_template& bts__nr, const PCUIF__container_template& container)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1077, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_CONTAINER");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__CONTAINER;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().container() = container;
return ret_val;
}

PCUIF__container_template ts__PCUIF__CONT__OTHER(const PCUIF__MsgType& msg__type, const OCTETSTRING_template& payload)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1087, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_CONT_OTHER");
PCUIF__container_template ret_val;
ret_val.msg__type() = msg__type;
ret_val.spare() = os_2;
ret_val.len() = payload.lengthof();
ret_val.u().other() = payload;
return ret_val;
}

PCUIF__container_template tr__PCUIF__CONT__OTHER(const PCUIF__MsgType_template& msg__type, const OCTETSTRING_template& payload)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1095, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_CONT_OTHER");
PCUIF__container_template ret_val;
ret_val.msg__type() = msg__type;
ret_val.spare() = os_2;
ret_val.len() = ANY_VALUE;
ret_val.u().other() = payload;
return ret_val;
}

PCUIF__container_template tr__PCUIF__CONT__NEIGH__ADDR__REQ(const INTEGER_template& local__lac, const INTEGER_template& local__ci, const INTEGER_template& tgt__arfcn, const INTEGER_template& tgt__bsic)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1105, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_CONT_NEIGH_ADDR_REQ");
PCUIF__container_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__NEIGH__ADDR__REQ;
ret_val.spare() = os_2;
ret_val.len() = ANY_VALUE;
{
PCUIF__neigh__addr__req_template& tmp_25 = ret_val.u().neigh__addr__req();
tmp_25.local__lac() = local__lac;
tmp_25.local__ci() = local__ci;
tmp_25.tgt__arfcn() = tgt__arfcn;
tmp_25.tgt__bsic() = tgt__bsic;
}
return ret_val;
}

PCUIF__Message_template tr__PCUIF__NEIGH__ADDR__REQ(const INTEGER_template& bts__nr, const INTEGER_template& local__lac, const INTEGER_template& local__ci, const INTEGER_template& tgt__arfcn, const INTEGER_template& tgt__bsic)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1121, TTCN_Location::LOCATION_TEMPLATE, "tr_PCUIF_NEIGH_ADDR_REQ");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__CONTAINER;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().container() = tr__PCUIF__CONT__NEIGH__ADDR__REQ(local__lac, local__ci, tgt__arfcn, tgt__bsic);
return ret_val;
}

PCUIF__container_template ts__PCUIF__CONT__NEIGH__ADDR__CNF(const PCUIF__neigh__addr__req_template& orig__req, const INTEGER_template& error__code, const INTEGER_template& mcc, const INTEGER_template& mnc, const INTEGER_template& mnc__3__digits, const INTEGER_template& lac, const INTEGER_template& rac, const INTEGER_template& cell__identity)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1134, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_CONT_NEIGH_ADDR_CNF");
PCUIF__container_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__NEIGH__ADDR__CNF;
ret_val.spare() = os_2;
ret_val.len() = 0;
{
PCUIF__neigh__addr__cnf_template& tmp_26 = ret_val.u().neigh__addr__cnf();
tmp_26.orig__req() = orig__req;
tmp_26.error__code() = error__code;
tmp_26.mcc() = mcc;
tmp_26.mnc() = mnc;
tmp_26.mnc__3__digits() = mnc__3__digits;
tmp_26.lac() = lac;
tmp_26.rac() = rac;
tmp_26.cell__identity() = cell__identity;
}
return ret_val;
}

PCUIF__Message_template ts__PCUIF__NEIGH__ADDR__CNF(const INTEGER_template& bts__nr, const PCUIF__neigh__addr__req_template& orig__req, const INTEGER_template& error__code, const INTEGER_template& mcc, const INTEGER_template& mnc, const INTEGER_template& mnc__3__digits, const INTEGER_template& lac, const INTEGER_template& rac, const INTEGER_template& cell__identity)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1158, TTCN_Location::LOCATION_TEMPLATE, "ts_PCUIF_NEIGH_ADDR_CNF");
PCUIF__Message_template ret_val;
ret_val.msg__type() = PCUIF__MsgType::PCU__IF__MSG__CONTAINER;
ret_val.bts__nr() = bts__nr;
ret_val.spare() = os_0;
ret_val.u().container() = ts__PCUIF__CONT__NEIGH__ADDR__CNF(orig__req, error__code, mcc, mnc, mnc__3__digits, lac, rac, cell__identity);
return ret_val;
}

void f__PCUIF__PDCHMask__set(PCUIF__info__ind& info, const BITSTRING& pdch__mask, const INTEGER_template& trx__nr)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1176, TTCN_Location::LOCATION_FUNCTION, "f_PCUIF_PDCHMask_set");
{
current_location.update_lineno(1179);
/* PCUIF_Types.ttcn, line 1179 */
INTEGER nr(0);
current_location.update_lineno(1179);
/* PCUIF_Types.ttcn, line 1179 */
for ( ; ; ) {
current_location.update_lineno(1179);
/* PCUIF_Types.ttcn, line 1179 */
if (!(nr < const_cast< const PCUIF__info__ind&>(info).trx().lengthof())) break;
current_location.update_lineno(1180);
/* PCUIF_Types.ttcn, line 1180 */
if (trx__nr.match(nr)) {
current_location.update_lineno(1181);
/* PCUIF_Types.ttcn, line 1181 */
info.trx()[nr].pdch__mask() = pdch__mask;
}
current_location.update_lineno(1179);
/* PCUIF_Types.ttcn, line 1179 */
{
INTEGER tmp_28;
++nr;
}
}
}
}

PCUIF__AddrType f__PCUIF__AF2addr__type(const Osmocom__Types::AddressFamily& address__family)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1186, TTCN_Location::LOCATION_FUNCTION, "f_PCUIF_AF2addr_type");
current_location.update_lineno(1188);
/* PCUIF_Types.ttcn, line 1188 */
if ((address__family == Osmocom__Types::AddressFamily::AF__INET)) {
current_location.update_lineno(1189);
/* PCUIF_Types.ttcn, line 1189 */
return PCUIF__AddrType::PCUIF__ADDR__TYPE__IPV4;
}
else {
current_location.update_lineno(1190);
/* PCUIF_Types.ttcn, line 1190 */
if ((address__family == Osmocom__Types::AddressFamily::AF__INET6)) {
current_location.update_lineno(1191);
/* PCUIF_Types.ttcn, line 1191 */
return PCUIF__AddrType::PCUIF__ADDR__TYPE__IPV6;
}
else {
current_location.update_lineno(1193);
/* PCUIF_Types.ttcn, line 1193 */
return PCUIF__AddrType::PCUIF__ADDR__TYPE__UNSPEC;
}
}
}

PCUIF__RemoteAddr f__PCUIF__RemoteAddr(const PCUIF__AddrType& addr__type, const CHARSTRING& addr__str)
{
TTCN_Location current_location("PCUIF_Types.ttcn", 1198, TTCN_Location::LOCATION_FUNCTION, "f_PCUIF_RemoteAddr");
current_location.update_lineno(1201);
/* PCUIF_Types.ttcn, line 1201 */
PCUIF__RemoteAddr remote__addr;
current_location.update_lineno(1203);
/* PCUIF_Types.ttcn, line 1203 */
remote__addr.addr__type()[0] = addr__type;
current_location.update_lineno(1204);
/* PCUIF_Types.ttcn, line 1204 */
if ((addr__type == PCUIF__AddrType::PCUIF__ADDR__TYPE__IPV4)) {
current_location.update_lineno(1205);
/* PCUIF_Types.ttcn, line 1205 */
remote__addr.addr()[0] = Native__Functions::f__inet__addr(addr__str);
}
else {
current_location.update_lineno(1207);
/* PCUIF_Types.ttcn, line 1207 */
remote__addr.addr()[0] = Native__Functions::f__inet6__addr(addr__str);
}
current_location.update_lineno(1210);
/* PCUIF_Types.ttcn, line 1210 */
remote__addr.addr__type()[1] = PCUIF__AddrType::PCUIF__ADDR__TYPE__UNSPEC;
current_location.update_lineno(1211);
/* PCUIF_Types.ttcn, line 1211 */
remote__addr.addr()[1] = Osmocom__Types::f__pad__oct(os_3, 16, os_2);
current_location.update_lineno(1213);
/* PCUIF_Types.ttcn, line 1213 */
return remote__addr;
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("PCUIF_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "PCUIF_Types");
Osmocom__Types::module_object.pre_init_module();
Native__Functions::module_object.pre_init_module();
current_location.update_lineno(20);
/* PCUIF_Types.ttcn, line 20 */
modulepar_mp__pcuif__version = 12;
module_object.add_modulepar("mp_pcuif_version");
current_location.update_lineno(23);
/* PCUIF_Types.ttcn, line 23 */
const_PCU__SOCK__DEFAULT = cs_0;
module_object.add_function("enc_PCUIF_pch", (genericfunc_t)&enc__PCUIF__pch, NULL);
module_object.add_function("dec_PCUIF_pch", (genericfunc_t)&dec__PCUIF__pch, NULL);
module_object.add_function("enc_PCUIF_agch", (genericfunc_t)&enc__PCUIF__agch, NULL);
module_object.add_function("dec_PCUIF_agch", (genericfunc_t)&dec__PCUIF__agch, NULL);
module_object.add_function("enc_PCUIF_Message", (genericfunc_t)&enc__PCUIF__Message, NULL);
module_object.add_function("dec_PCUIF_Message", (genericfunc_t)&dec__PCUIF__Message, NULL);
current_location.update_lineno(780);
/* PCUIF_Types.ttcn, line 780 */
const_c__PCUIF__Flags__default.bts__active() = TRUE;
const_c__PCUIF__Flags__default.direct__phy() = FALSE;
const_c__PCUIF__Flags__default.spare() = bs_0;
const_c__PCUIF__Flags__default.cs1() = TRUE;
const_c__PCUIF__Flags__default.cs2() = TRUE;
const_c__PCUIF__Flags__default.cs3() = TRUE;
const_c__PCUIF__Flags__default.cs4() = TRUE;
const_c__PCUIF__Flags__default.mcs1() = TRUE;
const_c__PCUIF__Flags__default.mcs2() = TRUE;
const_c__PCUIF__Flags__default.mcs3() = TRUE;
const_c__PCUIF__Flags__default.mcs4() = TRUE;
const_c__PCUIF__Flags__default.mcs5() = TRUE;
const_c__PCUIF__Flags__default.mcs6() = TRUE;
const_c__PCUIF__Flags__default.mcs7() = TRUE;
const_c__PCUIF__Flags__default.mcs8() = TRUE;
const_c__PCUIF__Flags__default.mcs9() = TRUE;
const_c__PCUIF__Flags__default.spare2() = bs_1;
current_location.update_lineno(800);
/* PCUIF_Types.ttcn, line 800 */
const_c__PCUIF__Flags__noMCS.bts__active() = TRUE;
const_c__PCUIF__Flags__noMCS.direct__phy() = FALSE;
const_c__PCUIF__Flags__noMCS.spare() = bs_0;
const_c__PCUIF__Flags__noMCS.cs1() = TRUE;
const_c__PCUIF__Flags__noMCS.cs2() = TRUE;
const_c__PCUIF__Flags__noMCS.cs3() = TRUE;
const_c__PCUIF__Flags__noMCS.cs4() = TRUE;
const_c__PCUIF__Flags__noMCS.mcs1() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs2() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs3() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs4() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs5() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs6() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs7() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs8() = FALSE;
const_c__PCUIF__Flags__noMCS.mcs9() = FALSE;
const_c__PCUIF__Flags__noMCS.spare2() = bs_1;
module_object.add_function("f_pcuif_ind_flags_egprs_enabled", (genericfunc_t)&f__pcuif__ind__flags__egprs__enabled, NULL);
module_object.add_function("f_PCUIF_PDCHMask_set", (genericfunc_t)&f__PCUIF__PDCHMask__set, NULL);
module_object.add_function("f_PCUIF_AF2addr_type", (genericfunc_t)&f__PCUIF__AF2addr__type, NULL);
module_object.add_function("f_PCUIF_RemoteAddr", (genericfunc_t)&f__PCUIF__RemoteAddr, NULL);
}

void post_init_module()
{
TTCN_Location current_location("PCUIF_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "PCUIF_Types");
Osmocom__Types::module_object.post_init_module();
Native__Functions::module_object.post_init_module();
current_location.update_lineno(411);
/* PCUIF_Types.ttcn, line 411 */
template_tr__PCUIF__MSG_msg__type_defval = ANY_VALUE;
current_location.update_lineno(412);
/* PCUIF_Types.ttcn, line 412 */
template_tr__PCUIF__MSG_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(442);
/* PCUIF_Types.ttcn, line 442 */
template_tr__PCUIF__RTS__REQ_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(443);
/* PCUIF_Types.ttcn, line 443 */
template_tr__PCUIF__RTS__REQ_trx__nr_defval = ANY_VALUE;
current_location.update_lineno(444);
/* PCUIF_Types.ttcn, line 444 */
template_tr__PCUIF__RTS__REQ_ts__nr_defval = ANY_VALUE;
current_location.update_lineno(445);
/* PCUIF_Types.ttcn, line 445 */
template_tr__PCUIF__RTS__REQ_sapi_defval = ANY_VALUE;
current_location.update_lineno(446);
/* PCUIF_Types.ttcn, line 446 */
template_tr__PCUIF__RTS__REQ_fn_defval = ANY_VALUE;
current_location.update_lineno(447);
/* PCUIF_Types.ttcn, line 447 */
template_tr__PCUIF__RTS__REQ_block__nr_defval = ANY_VALUE;
current_location.update_lineno(477);
/* PCUIF_Types.ttcn, line 477 */
template_tr__PCUIF__TXT__IND_text_defval = ANY_VALUE;
current_location.update_lineno(555);
/* PCUIF_Types.ttcn, line 555 */
template_ts__PCUIF__DATA__IND_rssi_defval = -80;
current_location.update_lineno(556);
/* PCUIF_Types.ttcn, line 556 */
template_ts__PCUIF__DATA__IND_ber10k_defval = 0;
current_location.update_lineno(557);
/* PCUIF_Types.ttcn, line 557 */
template_ts__PCUIF__DATA__IND_ta__offs__qbits_defval = 0;
current_location.update_lineno(558);
/* PCUIF_Types.ttcn, line 558 */
template_ts__PCUIF__DATA__IND_lqual__cb_defval = 10;
current_location.update_lineno(579);
/* PCUIF_Types.ttcn, line 579 */
template_tr__PCUIF__DATA__IND_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(580);
/* PCUIF_Types.ttcn, line 580 */
template_tr__PCUIF__DATA__IND_trx__nr_defval = ANY_VALUE;
current_location.update_lineno(581);
/* PCUIF_Types.ttcn, line 581 */
template_tr__PCUIF__DATA__IND_ts__nr_defval = ANY_VALUE;
current_location.update_lineno(582);
/* PCUIF_Types.ttcn, line 582 */
template_tr__PCUIF__DATA__IND_block__nr_defval = ANY_VALUE;
current_location.update_lineno(583);
/* PCUIF_Types.ttcn, line 583 */
template_tr__PCUIF__DATA__IND_sapi_defval = ANY_VALUE;
current_location.update_lineno(584);
/* PCUIF_Types.ttcn, line 584 */
template_tr__PCUIF__DATA__IND_data_defval = ANY_VALUE;
current_location.update_lineno(608);
/* PCUIF_Types.ttcn, line 608 */
template_tr__PCUIF__DATA_block__nr_defval = ANY_VALUE;
current_location.update_lineno(609);
/* PCUIF_Types.ttcn, line 609 */
template_tr__PCUIF__DATA_fn_defval = ANY_VALUE;
current_location.update_lineno(610);
/* PCUIF_Types.ttcn, line 610 */
template_tr__PCUIF__DATA_sapi_defval = ANY_VALUE;
current_location.update_lineno(611);
/* PCUIF_Types.ttcn, line 611 */
template_tr__PCUIF__DATA_data_defval = ANY_VALUE;
current_location.update_lineno(656);
/* PCUIF_Types.ttcn, line 656 */
template_tr__PCUIF__DATA__REQ_block__nr_defval = ANY_VALUE;
current_location.update_lineno(657);
/* PCUIF_Types.ttcn, line 657 */
template_tr__PCUIF__DATA__REQ_fn_defval = ANY_VALUE;
current_location.update_lineno(658);
/* PCUIF_Types.ttcn, line 658 */
template_tr__PCUIF__DATA__REQ_sapi_defval = ANY_VALUE;
current_location.update_lineno(659);
/* PCUIF_Types.ttcn, line 659 */
template_tr__PCUIF__DATA__REQ_data_defval = ANY_VALUE;
current_location.update_lineno(682);
/* PCUIF_Types.ttcn, line 682 */
template_tr__PCUIF__DATA__CNF__2_sapi_defval = ANY_VALUE;
current_location.update_lineno(683);
/* PCUIF_Types.ttcn, line 683 */
template_tr__PCUIF__DATA__CNF__2_msg__id_defval = ANY_VALUE;
current_location.update_lineno(703);
/* PCUIF_Types.ttcn, line 703 */
template_ts__PCUIF__RACH__IND_qta_defval = 0;
current_location.update_lineno(704);
/* PCUIF_Types.ttcn, line 704 */
template_ts__PCUIF__RACH__IND_sapi_defval = PCUIF__Sapi::PCU__IF__SAPI__RACH;
current_location.update_lineno(723);
/* PCUIF_Types.ttcn, line 723 */
template_tr__PCUIF__RACH__IND_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(724);
/* PCUIF_Types.ttcn, line 724 */
template_tr__PCUIF__RACH__IND_trx__nr_defval = ANY_VALUE;
current_location.update_lineno(725);
/* PCUIF_Types.ttcn, line 725 */
template_tr__PCUIF__RACH__IND_ts__nr_defval = ANY_VALUE;
current_location.update_lineno(726);
/* PCUIF_Types.ttcn, line 726 */
template_tr__PCUIF__RACH__IND_ra_defval = ANY_VALUE;
current_location.update_lineno(727);
/* PCUIF_Types.ttcn, line 727 */
template_tr__PCUIF__RACH__IND_is__11bit_defval = ANY_VALUE;
current_location.update_lineno(728);
/* PCUIF_Types.ttcn, line 728 */
template_tr__PCUIF__RACH__IND_burst__type_defval = ANY_VALUE;
current_location.update_lineno(729);
/* PCUIF_Types.ttcn, line 729 */
template_tr__PCUIF__RACH__IND_fn_defval = ANY_VALUE;
current_location.update_lineno(730);
/* PCUIF_Types.ttcn, line 730 */
template_tr__PCUIF__RACH__IND_sapi_defval = PCUIF__Sapi::PCU__IF__SAPI__RACH;
current_location.update_lineno(764);
/* PCUIF_Types.ttcn, line 764 */
template_tr__PCUIF__PAG__REQ_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(765);
/* PCUIF_Types.ttcn, line 765 */
template_tr__PCUIF__PAG__REQ_id__lv_defval = ANY_VALUE;
current_location.update_lineno(766);
/* PCUIF_Types.ttcn, line 766 */
template_tr__PCUIF__PAG__REQ_chan__needed_defval = ANY_VALUE;
current_location.update_lineno(767);
/* PCUIF_Types.ttcn, line 767 */
template_tr__PCUIF__PAG__REQ_sapi_defval = ANY_VALUE;
current_location.update_lineno(826);
/* PCUIF_Types.ttcn, line 826 */
template_ts__PCUIF__InfoTrxTsH0_tsc_defval = 7;
current_location.update_lineno(833);
/* PCUIF_Types.ttcn, line 833 */
template_tr__PCUIF__InfoTrxTsH0_tsc_defval = ANY_VALUE;
current_location.update_lineno(841);
/* PCUIF_Types.ttcn, line 841 */
template_ts__PCUIF__InfoTrxTsH1_tsc_defval = 7;
current_location.update_lineno(842);
/* PCUIF_Types.ttcn, line 842 */
template_ts__PCUIF__InfoTrxTsH1_hsn_defval = 0;
current_location.update_lineno(843);
/* PCUIF_Types.ttcn, line 843 */
template_ts__PCUIF__InfoTrxTsH1_maio_defval = 0;
current_location.update_lineno(844);
/* PCUIF_Types.ttcn, line 844 */
template_ts__PCUIF__InfoTrxTsH1_ma_defval = bs_2;
current_location.update_lineno(852);
/* PCUIF_Types.ttcn, line 852 */
template_tr__PCUIF__InfoTrxTsH1_tsc_defval = ANY_VALUE;
current_location.update_lineno(853);
/* PCUIF_Types.ttcn, line 853 */
template_tr__PCUIF__InfoTrxTsH1_hsn_defval = ANY_VALUE;
current_location.update_lineno(854);
/* PCUIF_Types.ttcn, line 854 */
template_tr__PCUIF__InfoTrxTsH1_maio_defval = ANY_VALUE;
current_location.update_lineno(855);
/* PCUIF_Types.ttcn, line 855 */
template_tr__PCUIF__InfoTrxTsH1_ma_defval = ANY_VALUE;
current_location.update_lineno(856);
/* PCUIF_Types.ttcn, line 856 */
template_tr__PCUIF__InfoTrxTsH1_ma__bit__len_defval = ANY_VALUE;
current_location.update_lineno(866);
/* PCUIF_Types.ttcn, line 866 */
template_ts__PCUIF__InfoTrx_arfcn_defval = 871;
current_location.update_lineno(867);
/* PCUIF_Types.ttcn, line 867 */
template_ts__PCUIF__InfoTrx_pdch__mask_defval = bs_4;
current_location.update_lineno(868);
/* PCUIF_Types.ttcn, line 868 */
template_ts__PCUIF__InfoTrx_tsc_defval = 7;
current_location.update_lineno(902);
/* PCUIF_Types.ttcn, line 902 */
template_tr__PCUIF__INFO__IND_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(903);
/* PCUIF_Types.ttcn, line 903 */
template_tr__PCUIF__INFO__IND_flags_defval = ANY_VALUE;
current_location.update_lineno(904);
/* PCUIF_Types.ttcn, line 904 */
template_tr__PCUIF__INFO__IND_version_defval = mp__pcuif__version;
current_location.update_lineno(990);
/* PCUIF_Types.ttcn, line 990 */
template_tr__PCUIF__INTERF__IND_bts__nr_defval = ANY_VALUE;
current_location.update_lineno(991);
/* PCUIF_Types.ttcn, line 991 */
template_tr__PCUIF__INTERF__IND_trx__nr_defval = ANY_VALUE;
current_location.update_lineno(992);
/* PCUIF_Types.ttcn, line 992 */
template_tr__PCUIF__INTERF__IND_fn_defval = ANY_VALUE;
current_location.update_lineno(993);
/* PCUIF_Types.ttcn, line 993 */
template_tr__PCUIF__INTERF__IND_interf_defval = ANY_VALUE;
current_location.update_lineno(1105);
/* PCUIF_Types.ttcn, line 1105 */
template_tr__PCUIF__CONT__NEIGH__ADDR__REQ_local__lac_defval = ANY_VALUE;
current_location.update_lineno(1106);
/* PCUIF_Types.ttcn, line 1106 */
template_tr__PCUIF__CONT__NEIGH__ADDR__REQ_local__ci_defval = ANY_VALUE;
current_location.update_lineno(1107);
/* PCUIF_Types.ttcn, line 1107 */
template_tr__PCUIF__CONT__NEIGH__ADDR__REQ_tgt__arfcn_defval = ANY_VALUE;
current_location.update_lineno(1108);
/* PCUIF_Types.ttcn, line 1108 */
template_tr__PCUIF__CONT__NEIGH__ADDR__REQ_tgt__bsic_defval = ANY_VALUE;
current_location.update_lineno(1122);
/* PCUIF_Types.ttcn, line 1122 */
template_tr__PCUIF__NEIGH__ADDR__REQ_local__lac_defval = ANY_VALUE;
current_location.update_lineno(1123);
/* PCUIF_Types.ttcn, line 1123 */
template_tr__PCUIF__NEIGH__ADDR__REQ_local__ci_defval = ANY_VALUE;
current_location.update_lineno(1124);
/* PCUIF_Types.ttcn, line 1124 */
template_tr__PCUIF__NEIGH__ADDR__REQ_tgt__arfcn_defval = ANY_VALUE;
current_location.update_lineno(1125);
/* PCUIF_Types.ttcn, line 1125 */
template_tr__PCUIF__NEIGH__ADDR__REQ_tgt__bsic_defval = ANY_VALUE;
current_location.update_lineno(1135);
/* PCUIF_Types.ttcn, line 1135 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_error__code_defval = 0;
current_location.update_lineno(1136);
/* PCUIF_Types.ttcn, line 1136 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_mcc_defval = 0;
current_location.update_lineno(1137);
/* PCUIF_Types.ttcn, line 1137 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_mnc_defval = 0;
current_location.update_lineno(1138);
/* PCUIF_Types.ttcn, line 1138 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_mnc__3__digits_defval = 0;
current_location.update_lineno(1139);
/* PCUIF_Types.ttcn, line 1139 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_lac_defval = 0;
current_location.update_lineno(1140);
/* PCUIF_Types.ttcn, line 1140 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_rac_defval = 0;
current_location.update_lineno(1141);
/* PCUIF_Types.ttcn, line 1141 */
template_ts__PCUIF__CONT__NEIGH__ADDR__CNF_cell__identity_defval = 0;
current_location.update_lineno(1160);
/* PCUIF_Types.ttcn, line 1160 */
template_ts__PCUIF__NEIGH__ADDR__CNF_error__code_defval = 0;
current_location.update_lineno(1161);
/* PCUIF_Types.ttcn, line 1161 */
template_ts__PCUIF__NEIGH__ADDR__CNF_mcc_defval = 0;
current_location.update_lineno(1162);
/* PCUIF_Types.ttcn, line 1162 */
template_ts__PCUIF__NEIGH__ADDR__CNF_mnc_defval = 0;
current_location.update_lineno(1163);
/* PCUIF_Types.ttcn, line 1163 */
template_ts__PCUIF__NEIGH__ADDR__CNF_mnc__3__digits_defval = 0;
current_location.update_lineno(1164);
/* PCUIF_Types.ttcn, line 1164 */
template_ts__PCUIF__NEIGH__ADDR__CNF_lac_defval = 0;
current_location.update_lineno(1165);
/* PCUIF_Types.ttcn, line 1165 */
template_ts__PCUIF__NEIGH__ADDR__CNF_rac_defval = 0;
current_location.update_lineno(1166);
/* PCUIF_Types.ttcn, line 1166 */
template_ts__PCUIF__NEIGH__ADDR__CNF_cell__identity_defval = 0;
current_location.update_lineno(1177);
/* PCUIF_Types.ttcn, line 1177 */
template_f__PCUIF__PDCHMask__set_trx__nr_defval = ANY_VALUE;
}

boolean set_module_param(Module_Param& param)
{
const char* const par_name = param.get_id()->get_current_name();
if (!strcmp(par_name, "mp_pcuif_version")) {
modulepar_mp__pcuif__version.set_param(param);
return TRUE;
} else return FALSE;
}

void log_module_param()
{
TTCN_Logger::log_event_str("mp_pcuif_version := ");
mp__pcuif__version.log();
}


} /* end of namespace */
