/* 3GPP TS 29.244: Packet Forwarding Control Protocol */
/*
 * (C) 2021-2022 by sysmocom - s.f.m.c. GmbH <info@sysmocom.de>
 * All Rights Reserved.
 *
 * Author: Neels Janosch Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * SPDX-License-Identifier: GPL-2.0+
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#define OSMO_PFCP_PORT 8805

/* Section 7.3 / Table 7.3-1 */
enum osmo_pfcp_message_type {
	OSMO_PFCP_MSGT_NONE = 0,

	/* Node related messages */
	OSMO_PFCP_MSGT_HEARTBEAT_REQ = 1,
	OSMO_PFCP_MSGT_HEARTBEAT_RESP = 2,
	OSMO_PFCP_MSGT_PFD_MGMT_REQ = 3,
	OSMO_PFCP_MSGT_PFD_MGMT_RESP = 4,
	OSMO_PFCP_MSGT_ASSOC_SETUP_REQ = 5,
	OSMO_PFCP_MSGT_ASSOC_SETUP_RESP = 6,
	OSMO_PFCP_MSGT_ASSOC_UPDATE_REQ = 7,
	OSMO_PFCP_MSGT_ASSOC_UPDATE_RESP = 8,
	OSMO_PFCP_MSGT_ASSOC_RELEASE_REQ = 9,
	OSMO_PFCP_MSGT_ASSOC_RELEASE_RESP = 10,
	OSMO_PFCP_MSGT_VERSION_NOT_SUPP_RESP = 11,
	OSMO_PFCP_MSGT_NODE_REPORT_REQ = 12,
	OSMO_PFCP_MSGT_NODE_REPORT_RESP = 13,
	OSMO_PFCP_MSGT_SESSION_SET_DEL_REQ = 14,
	OSMO_PFCP_MSGT_SESSION_SET_DEL_RESP = 15,

	/* Session related messages */
	OSMO_PFCP_MSGT_SESSION_EST_REQ = 50,
	OSMO_PFCP_MSGT_SESSION_EST_RESP = 51,
	OSMO_PFCP_MSGT_SESSION_MOD_REQ = 52,
	OSMO_PFCP_MSGT_SESSION_MOD_RESP = 53,
	OSMO_PFCP_MSGT_SESSION_DEL_REQ = 54,
	OSMO_PFCP_MSGT_SESSION_DEL_RESP = 55,
	OSMO_PFCP_MSGT_SESSION_REP_REQ = 56,
	OSMO_PFCP_MSGT_SESSION_REP_RESP = 57,
};

/* Section 8.1.2 / Table 8.1.2-1 */
enum osmo_pfcp_iei {
	OSMO_PFCP_INVALID_IEI = 0,
	OSMO_PFCP_IEI_CREATE_PDR = 1,
	OSMO_PFCP_IEI_PDI = 2,
	OSMO_PFCP_IEI_CREATE_FAR = 3,
	OSMO_PFCP_IEI_FORW_PARAMS = 4,
	OSMO_PFCP_IEI_DUPL_PARAMS = 5,
	OSMO_PFCP_IEI_CREATE_URR = 6,
	OSMO_PFCP_IEI_CREATE_QER = 7,
	OSMO_PFCP_IEI_CREATED_PDR = 8,
	OSMO_PFCP_IEI_UPD_PDR = 9,
	OSMO_PFCP_IEI_UPD_FAR = 10,
	OSMO_PFCP_IEI_UPD_FORW_PARAMS = 11,
	OSMO_PFCP_IEI_UPD_BAR_SESS_REP_RESP = 12,
	OSMO_PFCP_IEI_UPD_URR = 13,
	OSMO_PFCP_IEI_UPD_QER = 14,
	OSMO_PFCP_IEI_REMOVE_PDR = 15,
	OSMO_PFCP_IEI_REMOVE_FAR = 16,
	OSMO_PFCP_IEI_REMOVE_URR = 17,
	OSMO_PFCP_IEI_REMOVE_QER = 18,
	OSMO_PFCP_IEI_CAUSE = 19,
	OSMO_PFCP_IEI_SOURCE_IFACE = 20,
	OSMO_PFCP_IEI_F_TEID = 21,
	OSMO_PFCP_IEI_NETWORK_INST = 22,
	OSMO_PFCP_IEI_SDF_FILTER = 23,
	OSMO_PFCP_IEI_APPLICATION_ID = 24,
	OSMO_PFCP_IEI_GATE_STATUS = 25,
	OSMO_PFCP_IEI_MBR = 26,
	OSMO_PFCP_IEI_GBR = 27,
	OSMO_PFCP_IEI_QER_CORRELATION_ID = 28,
	OSMO_PFCP_IEI_PRECEDENCE = 29,
	OSMO_PFCP_IEI_TRANSPORT_LEVEL_MARKING = 30,
	OSMO_PFCP_IEI_VOLUME_THRESH = 31,
	OSMO_PFCP_IEI_TIME_THRESH = 32,
	OSMO_PFCP_IEI_MONITORING_TIME = 33,
	OSMO_PFCP_IEI_SUBSEQUENT_VOLUME_THRESH = 34,
	OSMO_PFCP_IEI_SUBSEQUENT_TIME_THRESH = 35,
	OSMO_PFCP_IEI_INACT_DETECTION_TIME = 36,
	OSMO_PFCP_IEI_REPORTING_TRIGGERS = 37,
	OSMO_PFCP_IEI_REDIRECT_INFO = 38,
	OSMO_PFCP_IEI_REP_TYPE = 39,
	OSMO_PFCP_IEI_OFFENDING_IE = 40,
	OSMO_PFCP_IEI_FORW_POLICY = 41,
	OSMO_PFCP_IEI_DESTINATION_IFACE = 42,
	OSMO_PFCP_IEI_UP_FUNCTION_FEATURES = 43,
	OSMO_PFCP_IEI_APPLY_ACTION = 44,
	OSMO_PFCP_IEI_DL_DATA_SERVICE_INFO = 45,
	OSMO_PFCP_IEI_DL_DATA_NOTIFICATION_DELAY = 46,
	OSMO_PFCP_IEI_DL_BUFF_DURATION = 47,
	OSMO_PFCP_IEI_DL_BUFF_SUGGESTED_PACKET_COUNT = 48,
	OSMO_PFCP_IEI_PFCPSMREQ_FLAGS = 49,
	OSMO_PFCP_IEI_PFCPSRRSP_FLAGS = 50,
	OSMO_PFCP_IEI_LOAD_CTRL_INFO = 51,
	OSMO_PFCP_IEI_SEQUENCE_NUMBER = 52,
	OSMO_PFCP_IEI_METRIC = 53,
	OSMO_PFCP_IEI_OVERLOAD_CTRL_INFO = 54,
	OSMO_PFCP_IEI_TIMER = 55,
	OSMO_PFCP_IEI_PDR_ID = 56,
	OSMO_PFCP_IEI_F_SEID = 57,
	OSMO_PFCP_IEI_APPLICATION_IDS_PFDS = 58,
	OSMO_PFCP_IEI_PFD_CONTEXT = 59,
	OSMO_PFCP_IEI_NODE_ID = 60,
	OSMO_PFCP_IEI_PFD_CONTENTS = 61,
	OSMO_PFCP_IEI_MEAS_METHOD = 62,
	OSMO_PFCP_IEI_USAGE_REP_TRIGGER = 63,
	OSMO_PFCP_IEI_MEAS_PERIOD = 64,
	OSMO_PFCP_IEI_FQ_CSID = 65,
	OSMO_PFCP_IEI_VOLUME_MEAS = 66,
	OSMO_PFCP_IEI_DURATION_MEAS = 67,
	OSMO_PFCP_IEI_APPLICATION_DETECTION_INFO = 68,
	OSMO_PFCP_IEI_TIME_OF_FIRST_PACKET = 69,
	OSMO_PFCP_IEI_TIME_OF_LAST_PACKET = 70,
	OSMO_PFCP_IEI_QUOTA_HOLDING_TIME = 71,
	OSMO_PFCP_IEI_DROPPED_DL_TRAFFIC_THRESH = 72,
	OSMO_PFCP_IEI_VOLUME_QUOTA = 73,
	OSMO_PFCP_IEI_TIME_QUOTA = 74,
	OSMO_PFCP_IEI_START_TIME = 75,
	OSMO_PFCP_IEI_END_TIME = 76,
	OSMO_PFCP_IEI_QUERY_URR = 77,
	OSMO_PFCP_IEI_USAGE_REP_SESS_MOD_RESP = 78,
	OSMO_PFCP_IEI_USAGE_REP_SESS_DEL_RESP = 79,
	OSMO_PFCP_IEI_USAGE_REP_SESS_REP_REQ = 80,
	OSMO_PFCP_IEI_URR_ID = 81,
	OSMO_PFCP_IEI_LINKED_URR_ID = 82,
	OSMO_PFCP_IEI_DL_DATA_REP = 83,
	OSMO_PFCP_IEI_OUTER_HEADER_CREATION = 84,
	OSMO_PFCP_IEI_CREATE_BAR = 85,
	OSMO_PFCP_IEI_UPD_BAR_SESS_MOD_REQ = 86,
	OSMO_PFCP_IEI_REMOVE_BAR = 87,
	OSMO_PFCP_IEI_BAR_ID = 88,
	OSMO_PFCP_IEI_CP_FUNCTION_FEATURES = 89,
	OSMO_PFCP_IEI_USAGE_INFO = 90,
	OSMO_PFCP_IEI_APPLICATION_INST_ID = 91,
	OSMO_PFCP_IEI_FLOW_INFO = 92,
	OSMO_PFCP_IEI_UE_IP_ADDRESS = 93,
	OSMO_PFCP_IEI_PACKET_RATE = 94,
	OSMO_PFCP_IEI_OUTER_HEADER_REMOVAL = 95,
	OSMO_PFCP_IEI_RECOVERY_TIME_STAMP = 96,
	OSMO_PFCP_IEI_DL_FLOW_LEVEL_MARKING = 97,
	OSMO_PFCP_IEI_HEADER_ENRICHMENT = 98,
	OSMO_PFCP_IEI_ERROR_IND_REP = 99,
	OSMO_PFCP_IEI_MEAS_INFO = 100,
	OSMO_PFCP_IEI_NODE_REP_TYPE = 101,
	OSMO_PFCP_IEI_USER_PLANE_PATH_FAILURE_REP = 102,
	OSMO_PFCP_IEI_REMOTE_GTP_U_PEER = 103,
	OSMO_PFCP_IEI_UR_SEQN = 104,
	OSMO_PFCP_IEI_UPD_DUPL_PARAMS = 105,
	OSMO_PFCP_IEI_ACTIVATE_PREDEFINED_RULES = 106,
	OSMO_PFCP_IEI_DEACTIVATE_PREDEFINED_RULES = 107,
	OSMO_PFCP_IEI_FAR_ID = 108,
	OSMO_PFCP_IEI_QER_ID = 109,
	OSMO_PFCP_IEI_OCI_FLAGS = 110,
	OSMO_PFCP_IEI_PFCP_ASSOC_RELEASE_REQ = 111,
	OSMO_PFCP_IEI_GRACEFUL_RELEASE_PERIOD = 112,
	OSMO_PFCP_IEI_PDN_TYPE = 113,
	OSMO_PFCP_IEI_FAILED_RULE_ID = 114,
	OSMO_PFCP_IEI_TIME_QUOTA_MECHANISM = 115,
	OSMO_PFCP_IEI_RESERVED = 116,
	OSMO_PFCP_IEI_USER_PLANE_INACT_TIMER = 117,
	OSMO_PFCP_IEI_AGGREGATED_URRS = 118,
	OSMO_PFCP_IEI_MULTIPLIER = 119,
	OSMO_PFCP_IEI_AGGREGATED_URR_ID = 120,
	OSMO_PFCP_IEI_SUBSEQUENT_VOLUME_QUOTA = 121,
	OSMO_PFCP_IEI_SUBSEQUENT_TIME_QUOTA = 122,
	OSMO_PFCP_IEI_RQI = 123,
	OSMO_PFCP_IEI_QFI = 124,
	OSMO_PFCP_IEI_QUERY_URR_REFERENCE = 125,
	OSMO_PFCP_IEI_ADDITIONAL_USAGE_REPS_INFO = 126,
	OSMO_PFCP_IEI_CREATE_TRAFFIC_ENDPOINT = 127,
	OSMO_PFCP_IEI_CREATED_TRAFFIC_ENDPOINT = 128,
	OSMO_PFCP_IEI_UPD_TRAFFIC_ENDPOINT = 129,
	OSMO_PFCP_IEI_REMOVE_TRAFFIC_ENDPOINT = 130,
	OSMO_PFCP_IEI_TRAFFIC_ENDPOINT_ID = 131,
	OSMO_PFCP_IEI_ETHERNET_PACKET_FILTER = 132,
	OSMO_PFCP_IEI_MAC_ADDRESS = 133,
	OSMO_PFCP_IEI_C_TAG = 134,
	OSMO_PFCP_IEI_S_TAG = 135,
	OSMO_PFCP_IEI_ETHERTYPE = 136,
	OSMO_PFCP_IEI_PROXYING = 137,
	OSMO_PFCP_IEI_ETHERNET_FILTER_ID = 138,
	OSMO_PFCP_IEI_ETHERNET_FILTER_PROPERTIES = 139,
	OSMO_PFCP_IEI_SUGGESTED_BUFF_PACKETS_COUNT = 140,
	OSMO_PFCP_IEI_USER_ID = 141,
	OSMO_PFCP_IEI_ETHERNET_PDU_SESS_INFO = 142,
	OSMO_PFCP_IEI_ETHERNET_TRAFFIC_INFO = 143,
	OSMO_PFCP_IEI_MAC_ADDRS_DETECTED = 144,
	OSMO_PFCP_IEI_MAC_ADDRS_REMOVED = 145,
	OSMO_PFCP_IEI_ETHERNET_INACT_TIMER = 146,
	OSMO_PFCP_IEI_ADDITIONAL_MONITORING_TIME = 147,
	OSMO_PFCP_IEI_EVENT_QUOTA = 148,
	OSMO_PFCP_IEI_EVENT_THRESH = 149,
	OSMO_PFCP_IEI_SUBSEQUENT_EVENT_QUOTA = 150,
	OSMO_PFCP_IEI_SUBSEQUENT_EVENT_THRESH = 151,
	OSMO_PFCP_IEI_TRACE_INFO = 152,
	OSMO_PFCP_IEI_FRAMED_ROUTE = 153,
	OSMO_PFCP_IEI_FRAMED_ROUTING = 154,
	OSMO_PFCP_IEI_FRAMED_IPV6_ROUTE = 155,
	OSMO_PFCP_IEI_TIME_STAMP = 156,
	OSMO_PFCP_IEI_AVERAGING_WINDOW = 157,
	OSMO_PFCP_IEI_PAGING_POLICY_INDICATOR = 158,
	OSMO_PFCP_IEI_APN_DNN = 159,
	OSMO_PFCP_IEI_3GPP_IFACE_TYPE = 160,
	OSMO_PFCP_IEI_PFCPSRREQ_FLAGS = 161,
	OSMO_PFCP_IEI_PFCPAUREQ_FLAGS = 162,
	OSMO_PFCP_IEI_ACTIVATION_TIME = 163,
	OSMO_PFCP_IEI_DEACTIVATION_TIME = 164,
	OSMO_PFCP_IEI_CREATE_MAR = 165,
	OSMO_PFCP_IEI_3GPP_ACCESS_FORW_ACTION_INFO = 166,
	OSMO_PFCP_IEI_NON_3GPP_ACCESS_FORW_ACTION_INFO = 167,
	OSMO_PFCP_IEI_REMOVE_MAR = 168,
	OSMO_PFCP_IEI_UPD_MAR = 169,
	OSMO_PFCP_IEI_MAR_ID = 170,
	OSMO_PFCP_IEI_STEERING_FUNCTIONALITY = 171,
	OSMO_PFCP_IEI_STEERING_MODE = 172,
	OSMO_PFCP_IEI_WEIGHT = 173,
	OSMO_PFCP_IEI_PRIORITY = 174,
	OSMO_PFCP_IEI_UPD_3GPP_ACCESS_FORW_ACTION_INFO = 175,
	OSMO_PFCP_IEI_UPD_NON_3GPP_ACCESS_FORW_ACTION_INFO = 176,
	OSMO_PFCP_IEI_UE_IP_ADDRESS_POOL_IDENTITY = 177,
	OSMO_PFCP_IEI_ALTERNATIVE_SMF_IP_ADDRESS = 178,
	OSMO_PFCP_IEI_PACKET_REPLICATION_AND_DETECTION_CARRY_ON_INFO = 179,
	OSMO_PFCP_IEI_SMF_SET_ID = 180,
	OSMO_PFCP_IEI_QUOTA_VALIDITY_TIME = 181,
	OSMO_PFCP_IEI_NUMBER_OF_REPS = 182,
	OSMO_PFCP_IEI_PFCP_SESS_RETENTION_INFO_IN_ASSOC_SETUP_REQ = 183,
	OSMO_PFCP_IEI_PFCPASRSP_FLAGS = 184,
	OSMO_PFCP_IEI_CP_ENTITY_IP_ADDRESS = 185,
	OSMO_PFCP_IEI_PFCPSEREQ_FLAGS = 186,
	OSMO_PFCP_IEI_USER_PLANE_PATH_RECOVERY_REP = 187,
	OSMO_PFCP_IEI_IP_MULTICAST_ADDR_INFO_IN_SESS_EST_REQ = 188,
	OSMO_PFCP_IEI_JOIN_IP_MULTICAST_INFO_IE_IN_USAGE_REP = 189,
	OSMO_PFCP_IEI_LEAVE_IP_MULTICAST_INFO_IE_IN_USAGE_REP = 190,
	OSMO_PFCP_IEI_IP_MULTICAST_ADDRESS = 191,
	OSMO_PFCP_IEI_SOURCE_IP_ADDRESS = 192,
	OSMO_PFCP_IEI_PACKET_RATE_STATUS = 193,
	OSMO_PFCP_IEI_CREATE_BRIDGE_INFO_FOR_TSC = 194,
	OSMO_PFCP_IEI_CREATED_BRIDGE_INFO_FOR_TSC = 195,
	OSMO_PFCP_IEI_DS_TT_PORT_NUMBER = 196,
	OSMO_PFCP_IEI_NW_TT_PORT_NUMBER = 197,
	OSMO_PFCP_IEI_TSN_BRIDGE_ID = 198,
	OSMO_PFCP_IEI_TSC_MGMT_INFO_IE_IN_SESS_MOD_REQ = 199,
	OSMO_PFCP_IEI_TSC_MGMT_INFO_IE_IN_SESS_MOD_RESP = 200,
	OSMO_PFCP_IEI_TSC_MGMT_INFO_IE_IN_SESS_REP_REQ = 201,
	OSMO_PFCP_IEI_PORT_MGMT_INFO_CONTAINER = 202,
	OSMO_PFCP_IEI_CLOCK_DRIFT_CTRL_INFO = 203,
	OSMO_PFCP_IEI_REQUESTED_CLOCK_DRIFT_INFO = 204,
	OSMO_PFCP_IEI_CLOCK_DRIFT_REP = 205,
	OSMO_PFCP_IEI_TSN_TIME_DOMAIN_NUMBER = 206,
	OSMO_PFCP_IEI_TIME_OFFSET_THRESH = 207,
	OSMO_PFCP_IEI_CUMULATIVE_RATERATIO_THRESH = 208,
	OSMO_PFCP_IEI_TIME_OFFSET_MEAS = 209,
	OSMO_PFCP_IEI_CUMULATIVE_RATERATIO_MEAS = 210,
	OSMO_PFCP_IEI_REMOVE_SRR = 211,
	OSMO_PFCP_IEI_CREATE_SRR = 212,
	OSMO_PFCP_IEI_UPD_SRR = 213,
	OSMO_PFCP_IEI_SESS_REP = 214,
	OSMO_PFCP_IEI_SRR_ID = 215,
	OSMO_PFCP_IEI_ACCESS_AVAIL_CTRL_INFO = 216,
	OSMO_PFCP_IEI_REQUESTED_ACCESS_AVAIL_INFO = 217,
	OSMO_PFCP_IEI_ACCESS_AVAIL_REP = 218,
	OSMO_PFCP_IEI_ACCESS_AVAIL_INFO = 219,
	OSMO_PFCP_IEI_PROVIDE_ATSSS_CTRL_INFO = 220,
	OSMO_PFCP_IEI_ATSSS_CTRL_PARAMS = 221,
	OSMO_PFCP_IEI_MPTCP_CTRL_INFO = 222,
	OSMO_PFCP_IEI_ATSSS_LL_CTRL_INFO = 223,
	OSMO_PFCP_IEI_PMF_CTRL_INFO = 224,
	OSMO_PFCP_IEI_MPTCP_PARAMS = 225,
	OSMO_PFCP_IEI_ATSSS_LL_PARAMS = 226,
	OSMO_PFCP_IEI_PMF_PARAMS = 227,
	OSMO_PFCP_IEI_MPTCP_ADDRESS_INFO = 228,
	OSMO_PFCP_IEI_UE_LINK_SPECIFIC_IP_ADDRESS = 229,
	OSMO_PFCP_IEI_PMF_ADDRESS_INFO = 230,
	OSMO_PFCP_IEI_ATSSS_LL_INFO = 231,
	OSMO_PFCP_IEI_DATA_NETWORK_ACCESS_IDENTIFIER = 232,
	OSMO_PFCP_IEI_UE_IP_ADDRESS_POOL_INFO = 233,
	OSMO_PFCP_IEI_AVERAGE_PACKET_DELAY = 234,
	OSMO_PFCP_IEI_MIN_PACKET_DELAY = 235,
	OSMO_PFCP_IEI_MAX_PACKET_DELAY = 236,
	OSMO_PFCP_IEI_QOS_REP_TRIGGER = 237,
	OSMO_PFCP_IEI_GTP_U_PATH_QOS_CTRL_INFO = 238,
	OSMO_PFCP_IEI_GTP_U_PATH_QOS_REP_NODE_REP_REQ = 239,
	OSMO_PFCP_IEI_QOS_INFO_IN_GTP_U_PATH_QOS_REP = 240,
	OSMO_PFCP_IEI_GTP_U_PATH_IFACE_TYPE = 241,
	OSMO_PFCP_IEI_QOS_MONITORING_PER_QOS_FLOW_CTRL_INFO = 242,
	OSMO_PFCP_IEI_REQUESTED_QOS_MONITORING = 243,
	OSMO_PFCP_IEI_REPORTING_FREQUENCY = 244,
	OSMO_PFCP_IEI_PACKET_DELAY_THRESHOLDS = 245,
	OSMO_PFCP_IEI_MIN_WAIT_TIME = 246,
	OSMO_PFCP_IEI_QOS_MONITORING_REP = 247,
	OSMO_PFCP_IEI_QOS_MONITORING_MEAS = 248,
	OSMO_PFCP_IEI_MT_EDT_CTRL_INFO = 249,
	OSMO_PFCP_IEI_DL_DATA_PACKETS_SIZE = 250,
	OSMO_PFCP_IEI_QER_CTRL_INDICATIONS = 251,
	OSMO_PFCP_IEI_PACKET_RATE_STATUS_REP = 252,
	OSMO_PFCP_IEI_NF_INST_ID = 253,
	OSMO_PFCP_IEI_ETHERNET_CONTEXT_INFO = 254,
	OSMO_PFCP_IEI_REDUNDANT_TRANSMISSION_PARAMS = 255,
	OSMO_PFCP_IEI_UPDATED_PDR = 256,
	OSMO_PFCP_IEI_S_NSSAI = 257,
	OSMO_PFCP_IEI_IP_VERSION = 258,
	OSMO_PFCP_IEI_PFCPASREQ_FLAGS = 259,
	OSMO_PFCP_IEI_DATA_STATUS = 260,
	OSMO_PFCP_IEI_PROVIDE_RDS_CONF_INFO = 261,
	OSMO_PFCP_IEI_RDS_CONF_INFO = 262,
	OSMO_PFCP_IEI_QUERY_PACKET_RATE_STATUS_IE_IN_SESS_MOD_REQ = 263,
	OSMO_PFCP_IEI_PACKET_RATE_STATUS_REP_IE_IN_SESS_MOD_RESP = 264,
	OSMO_PFCP_IEI_MPTCP_APPLICABLE_IND = 265,
	OSMO_PFCP_IEI_BRIDGE_MGMT_INFO_CONTAINER = 266,
	OSMO_PFCP_IEI_UE_IP_ADDRESS_USAGE_INFO = 267,
	OSMO_PFCP_IEI_NUMBER_OF_UE_IP_ADDRS = 268,
	OSMO_PFCP_IEI_VALIDITY_TIMER = 269,
	OSMO_PFCP_IEI_REDUNDANT_TRANSMISSION_FORW_PARAMS = 270,
	OSMO_PFCP_IEI_TRANSPORT_DELAY_REPORTING = 271,
};

/* Section 8.2.1 / Table 8.2.1-1 */
enum osmo_pfcp_cause {
	OSMO_PFCP_CAUSE_RESERVED = 0,
	OSMO_PFCP_CAUSE_REQUEST_ACCEPTED = 1,
	OSMO_PFCP_CAUSE_MORE_USAGE_REPORT_TO_SEND = 2,
	OSMO_PFCP_CAUSE_REQUEST_REJECTED = 64,
	OSMO_PFCP_CAUSE_SESSION_CTX_NOT_FOUND = 65,
	OSMO_PFCP_CAUSE_MANDATORY_IE_MISSING = 66,
	OSMO_PFCP_CAUSE_CONDITIONAL_IE_MISSING = 67,
	OSMO_PFCP_CAUSE_INVALID_LENGTH = 68,
	OSMO_PFCP_CAUSE_MANDATORY_IE_INCORRECT = 69,
	OSMO_PFCP_CAUSE_INVALID_FORW_POLICY = 70,
	OSMO_PFCP_CAUSE_INVALID_F_TEID_ALLOC_OPTION = 71,
	OSMO_PFCP_CAUSE_NO_ESTABLISHED_PFCP_ASSOC = 72,
	OSMO_PFCP_CAUSE_RULE_CREATION_MOD_FAILURE = 73,
	OSMO_PFCP_CAUSE_PFCP_ENTITY_IN_CONGESTION = 74,
	OSMO_PFCP_CAUSE_NO_RESOURCES_AVAILABLE = 75,
	OSMO_PFCP_CAUSE_SERVICE_NOT_SUPPORTED = 76,
	OSMO_PFCP_CAUSE_SYSTEM_FAILURE = 77,
	OSMO_PFCP_CAUSE_REDIRECTION_REQUESTED = 78,
	OSMO_PFCP_CAUSE_ALL_DYNAMIC_ADDRESSES_ARE_OCCUPIED = 79,
};

/* Section 8.2.38 */
enum osmo_pfcp_node_id_type {
	OSMO_PFCP_NODE_ID_T_IPV4 = 0,
	OSMO_PFCP_NODE_ID_T_IPV6 = 1,
	OSMO_PFCP_NODE_ID_T_FQDN = 2,
};

enum osmo_pfcp_3gpp_iface_type {
	OSMO_PFCP_3GPP_IFACE_TYPE_S1_U = 0,
	OSMO_PFCP_3GPP_IFACE_TYPE_S5_S8_U = 1,
	OSMO_PFCP_3GPP_IFACE_TYPE_S4_U = 2,
	OSMO_PFCP_3GPP_IFACE_TYPE_S11_U = 3,
	OSMO_PFCP_3GPP_IFACE_TYPE_S12_U = 4,
	OSMO_PFCP_3GPP_IFACE_TYPE_GN_GP_U = 5,
	OSMO_PFCP_3GPP_IFACE_TYPE_S2A_U = 6,
	OSMO_PFCP_3GPP_IFACE_TYPE_S2B_U = 7,
	OSMO_PFCP_3GPP_IFACE_TYPE_ENODEB_GTP_U_INTERFACE_FOR_DL_DATA_FORWARDING = 8,
	OSMO_PFCP_3GPP_IFACE_TYPE_ENODEB_GTP_U_INTERFACE_FOR_UL_DATA_FORWARDING = 9,
	OSMO_PFCP_3GPP_IFACE_TYPE_SGW_UPF_GTP_U_INTERFACE_FOR_DL_DATA_FORWARDING = 10,
	OSMO_PFCP_3GPP_IFACE_TYPE_N3_3GPP_ACCESS = 11,
	OSMO_PFCP_3GPP_IFACE_TYPE_N3_TRUSTED_NON_3GPP_ACCESS = 12,
	OSMO_PFCP_3GPP_IFACE_TYPE_N3_UNTRUSTED_NON_3GPP_ACCESS = 13,
	OSMO_PFCP_3GPP_IFACE_TYPE_N3_FOR_DATA_FORWARDING = 14,
	OSMO_PFCP_3GPP_IFACE_TYPE_N9 = 15,
	OSMO_PFCP_3GPP_IFACE_TYPE_SGI = 16,
	OSMO_PFCP_3GPP_IFACE_TYPE_N6 = 17,
	OSMO_PFCP_3GPP_IFACE_TYPE_N19 = 18,
	OSMO_PFCP_3GPP_IFACE_TYPE_S8_U = 19,
	OSMO_PFCP_3GPP_IFACE_TYPE_GP_U = 20,
};

enum osmo_pfcp_source_iface {
	OSMO_PFCP_SOURCE_IFACE_ACCESS = 0,
	OSMO_PFCP_SOURCE_IFACE_CORE = 1,
	OSMO_PFCP_SOURCE_IFACE_SGI_LAN_N6_LAN = 2,
	OSMO_PFCP_SOURCE_IFACE_CP_FUNCTION = 3,
	OSMO_PFCP_SOURCE_IFACE_5G_VN_INTERNAL = 4,
};

enum osmo_pfcp_dest_iface {
	OSMO_PFCP_DEST_IFACE_ACCESS = 0,
	OSMO_PFCP_DEST_IFACE_CORE = 1,
	OSMO_PFCP_DEST_IFACE_SGI_LAN_N6_LAN = 2,
	OSMO_PFCP_DEST_IFACE_CP_FUNCTION = 3,
	OSMO_PFCP_DEST_IFACE_LI_FUNCTION = 4,
	OSMO_PFCP_DEST_IFACE_5G_VN_INTERNAL = 5,
};

/* The enum values correspond to the bit index in the supported features bitmask in the PFCP UP Function Features IE.
 * 0 means first octet and first bit, "Octet 5 Bit 1" as in spec;
 * 7 means first octet last bit, "Octet 5 Bit 8";
 * 8 means second octet first bit, "Octet 6 Bit 1";
 * and so on.
 * Intended for use with osmo_pfcp_bits_get(), osmo_pfcp_bits_set(), osmo_pfcp_bits_to_str_c().
 */
enum osmo_pfcp_up_feature {
	OSMO_PFCP_UP_FEAT_BUCP = 0,
	OSMO_PFCP_UP_FEAT_DDND,
	OSMO_PFCP_UP_FEAT_DLBD,
	OSMO_PFCP_UP_FEAT_TRST,
	OSMO_PFCP_UP_FEAT_FTUP,
	OSMO_PFCP_UP_FEAT_PFDM,
	OSMO_PFCP_UP_FEAT_HEEU,
	OSMO_PFCP_UP_FEAT_TREU,
	OSMO_PFCP_UP_FEAT_EMPU,
	OSMO_PFCP_UP_FEAT_PDIU,
	OSMO_PFCP_UP_FEAT_UDBC,
	OSMO_PFCP_UP_FEAT_QUOAC,
	OSMO_PFCP_UP_FEAT_TRACE,
	OSMO_PFCP_UP_FEAT_FRRT,
	OSMO_PFCP_UP_FEAT_PFDE,
	OSMO_PFCP_UP_FEAT_EPFAR,
	OSMO_PFCP_UP_FEAT_DPDRA,
	OSMO_PFCP_UP_FEAT_ADPDP,
	OSMO_PFCP_UP_FEAT_UEIP,
	OSMO_PFCP_UP_FEAT_SSET,
	OSMO_PFCP_UP_FEAT_MNOP,
	OSMO_PFCP_UP_FEAT_MTE,
	OSMO_PFCP_UP_FEAT_BUNDL,
	OSMO_PFCP_UP_FEAT_GCOM,
	OSMO_PFCP_UP_FEAT_MPAS,
	OSMO_PFCP_UP_FEAT_RTTL,
	OSMO_PFCP_UP_FEAT_VTIME,
	OSMO_PFCP_UP_FEAT_NORP,
	OSMO_PFCP_UP_FEAT_IP6PL,
	OSMO_PFCP_UP_FEAT_TSCU,
	OSMO_PFCP_UP_FEAT_MPTCP,
	OSMO_PFCP_UP_FEAT_ATSSSLL,
	OSMO_PFCP_UP_FEAT_QFQM,
	OSMO_PFCP_UP_FEAT_GPQM,
	OSMO_PFCP_UP_FEAT_MTEDT,
	OSMO_PFCP_UP_FEAT_CIOT,
	OSMO_PFCP_UP_FEAT_ETHAR,
	OSMO_PFCP_UP_FEAT_DDDS,
	OSMO_PFCP_UP_FEAT_RDS,
	OSMO_PFCP_UP_FEAT_RTTWP,
};

/* The enum values correspond to the bit index in the supported features bitmask in the PFCP CP Function Features IE.
 * 0 means first octet and first bit, "Octet 5 Bit 1" as in spec;
 * 7 means first octet last bit, "Octet 5 Bit 8";
 * 8 means second octet first bit, "Octet 6 Bit 1";
 * and so on.
 * Intended for use with osmo_pfcp_bits_get(), osmo_pfcp_bits_set(), osmo_pfcp_bits_to_str_c().
 */
enum osmo_pfcp_cp_feature {
	OSMO_PFCP_CP_FEAT_LOAD = 0,
	OSMO_PFCP_CP_FEAT_OVRL,
	OSMO_PFCP_CP_FEAT_EPFAR,
	OSMO_PFCP_CP_FEAT_SSET,
	OSMO_PFCP_CP_FEAT_BUNDL,
	OSMO_PFCP_CP_FEAT_MPAS,
	OSMO_PFCP_CP_FEAT_ARDR,
	OSMO_PFCP_CP_FEAT_UIAUR,
};

/* The enum values correspond to the bit index in the PFCP Apply Action IE.
 * 0 means first octet and first bit, "Octet 5 Bit 1" as in spec;
 * 7 means first octet last bit, "Octet 5 Bit 8";
 * 8 means second octet first bit, "Octet 6 Bit 1";
 * and so on.
 * Intended for use with osmo_pfcp_bits_get(), osmo_pfcp_bits_set(), osmo_pfcp_bits_to_str_c().
 */
enum osmo_pfcp_apply_action {
	OSMO_PFCP_APPLY_ACTION_DROP = 0,
	OSMO_PFCP_APPLY_ACTION_FORW,
	OSMO_PFCP_APPLY_ACTION_BUFF,
	OSMO_PFCP_APPLY_ACTION_NOCP,
	OSMO_PFCP_APPLY_ACTION_DUPL,
	OSMO_PFCP_APPLY_ACTION_IPMA,
	OSMO_PFCP_APPLY_ACTION_IPMD,
	OSMO_PFCP_APPLY_ACTION_DFRT,
	OSMO_PFCP_APPLY_ACTION_EDRT,
	OSMO_PFCP_APPLY_ACTION_BDPN,
	OSMO_PFCP_APPLY_ACTION_DDPN,
};

/* The enum values correspond to the bit index in the description bitmask in the PFCP Outer Header Creation IE.
 * 0 means first octet and first bit, "Octet 5 Bit 1" as in spec;
 * 7 means first octet last bit, "Octet 5 Bit 8";
 * 8 means second octet first bit, "Octet 6 Bit 1";
 * and so on.
 * Intended for use with osmo_pfcp_bits_get(), osmo_pfcp_bits_set(), osmo_pfcp_bits_to_str_c().
 */
enum osmo_pfcp_outer_header_creation {
	OSMO_PFCP_OUTER_HEADER_CREATION_GTP_U_UDP_IPV4 = 0,
	OSMO_PFCP_OUTER_HEADER_CREATION_GTP_U_UDP_IPV6,
	OSMO_PFCP_OUTER_HEADER_CREATION_UDP_IPV4,
	OSMO_PFCP_OUTER_HEADER_CREATION_UDP_IPV6,
	OSMO_PFCP_OUTER_HEADER_CREATION_IPV4,
	OSMO_PFCP_OUTER_HEADER_CREATION_IPV6,
	OSMO_PFCP_OUTER_HEADER_CREATION_C_TAG,
	OSMO_PFCP_OUTER_HEADER_CREATION_S_TAG,
	OSMO_PFCP_OUTER_HEADER_CREATION_N19_INDICATION,
	OSMO_PFCP_OUTER_HEADER_CREATION_N6_INDICATION,
};

/* 3GPP TS 29.244 8.2.64 */
enum osmo_pfcp_outer_header_removal_desc {
	OSMO_PFCP_OUTER_HEADER_REMOVAL_GTP_U_UDP_IPV4 = 0,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_GTP_U_UDP_IPV6 = 1,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_UDP_IPV4 = 2,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_UDP_IPV6 = 3,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_IPV4 = 4,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_IPV6 = 5,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_GTP_U_UDP_IP = 6,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_VLAN_S_TAG = 7,
	OSMO_PFCP_OUTER_HEADER_REMOVAL_S_TAG_AND_C_TAG = 8,
};
