/* DO NOT EDIT THIS FILE. It is generated from files in osmo-hlr.git/sql/ */
#pragma once
static const char * const stmt_bootstrap_sql[] = {
"CREATE TABLE subscriber (\n"
"-- OsmoHLR's DB scheme is modelled roughly after TS 23.008 version 13.3.0\n"
"	id		INTEGER PRIMARY KEY,\n"
"	-- Chapter 2.1.1.1\n"
"	imsi		VARCHAR(15) UNIQUE NOT NULL,\n"
"	-- Chapter 2.1.2\n"
"	msisdn		VARCHAR(15) UNIQUE,\n"
"	-- Chapter 2.2.3: Most recent / current IMEISV\n"
"	imeisv		VARCHAR,\n"
"	-- Chapter 2.1.9: Most recent / current IMEI\n"
"	imei		VARCHAR(14),\n"
"	-- Chapter 2.4.5\n"
"	vlr_number	VARCHAR(15),\n"
"	-- Chapter 2.4.6\n"
"	msc_number	VARCHAR(15),\n"
"	-- Chapter 2.4.8.1\n"
"	sgsn_number	VARCHAR(15),\n"
"	-- Chapter 2.13.10\n"
"	sgsn_address	VARCHAR,\n"
"	-- Chapter 2.4.8.2\n"
"	ggsn_number	VARCHAR(15),\n"
"	-- Chapter 2.4.9.2\n"
"	gmlc_number	VARCHAR(15),\n"
"	-- Chapter 2.4.23\n"
"	smsc_number	VARCHAR(15),\n"
"	-- Chapter 2.4.24\n"
"	periodic_lu_tmr	INTEGER,\n"
"	-- Chapter 2.13.115\n"
"	periodic_rau_tau_tmr INTEGER,\n"
"	-- Chapter 2.1.1.2: network access mode\n"
"	nam_cs		BOOLEAN NOT NULL DEFAULT 1,\n"
"	nam_ps		BOOLEAN NOT NULL DEFAULT 1,\n"
"	-- Chapter 2.1.8\n"
"	lmsi		INTEGER,\n"

"	-- The below purged flags might not even be stored non-volatile,\n"
"	-- refer to TS 23.012 Chapter 3.6.1.4\n"
"	-- Chapter 2.7.5\n"
"	ms_purged_cs	BOOLEAN NOT NULL DEFAULT 0,\n"
"	-- Chapter 2.7.6\n"
"	ms_purged_ps	BOOLEAN NOT NULL DEFAULT 0,\n"

"	-- Timestamp of last location update seen from subscriber\n"
"	-- The value is a string which encodes a UTC timestamp in granularity of seconds.\n"
"	last_lu_seen TIMESTAMP default NULL,\n"
"	last_lu_seen_ps TIMESTAMP default NULL,\n"

"	-- When a LU was received via a proxy, that proxy's hlr_number is stored here,\n"
"	-- while vlr_number reflects the MSC on the far side of that proxy.\n"
"	vlr_via_proxy	VARCHAR,\n"
"	sgsn_via_proxy	VARCHAR\n"
")\n",

"CREATE TABLE subscriber_apn (\n"
"	subscriber_id	INTEGER,		-- subscriber.id\n"
"	apn		VARCHAR(256) NOT NULL\n"
")\n",

"CREATE TABLE subscriber_multi_msisdn (\n"
"-- Chapter 2.1.3\n"
"	subscriber_id	INTEGER,		-- subscriber.id\n"
"	msisdn		VARCHAR(15) NOT NULL\n"
")\n",

"CREATE TABLE auc_2g (\n"
"	subscriber_id	INTEGER PRIMARY KEY,	-- subscriber.id\n"
"	algo_id_2g	INTEGER NOT NULL,	-- enum osmo_auth_algo value\n"
"	ki		VARCHAR(32) NOT NULL	-- hex string: subscriber's secret key (128bit)\n"
")\n",

"CREATE TABLE auc_3g (\n"
"	subscriber_id	INTEGER PRIMARY KEY,	-- subscriber.id\n"
"	algo_id_3g	INTEGER NOT NULL,	-- enum osmo_auth_algo value\n"
"	k		VARCHAR(64) NOT NULL,	-- hex string: subscriber's secret key (128/256bit)\n"
"	op		VARCHAR(64),		-- hex string: operator's secret key (128/256bit)\n"
"	opc		VARCHAR(64),		-- hex string: derived from OP and K (128/256bit)\n"
"	sqn		INTEGER NOT NULL DEFAULT 0,	-- sequence number of key usage\n"
"	-- nr of index bits at lower SQN end\n"
"	ind_bitlen	INTEGER NOT NULL DEFAULT 5\n"
")\n",

"CREATE TABLE ind (\n"
"	-- 3G auth IND pool to be used for this VLR\n"
"	ind     INTEGER PRIMARY KEY,\n"
"	-- VLR identification, usually the GSUP source_name\n"
"	vlr     TEXT NOT NULL,\n"
"	UNIQUE (vlr)\n"
")\n",

"CREATE UNIQUE INDEX idx_subscr_imsi ON subscriber (imsi)\n",

"-- Set HLR database schema version number\n"
"-- Note: This constant is currently duplicated in src/db.c and must be kept in sync!\n"
"PRAGMA user_version = 7\n",
};
