#pragma once

#include <cstring>

#include "rijndael.hh"

class opc {
  const uint8_t OP[16]{0x63, 0xbf, 0xa5, 0x0e, 0xe6, 0x52, 0x33, 0x65, 0xff, 0x14, 0xc1, 0xf4, 0x5f, 0x88, 0x73, 0x7d}; //<! Operator Variant Algorithm Configuration Field

  rijndael& _rijndael;
  uint8_t _op[16];
  bool _computed;

public:
  opc(rijndael& p_rijndael): _rijndael(p_rijndael), _op(), _computed{false} { std::memcpy(_op, OP, 16); std::memset(_op, 0x00, 16); };
  opc(rijndael& p_rijndael, uint8_t p_op[16]): _rijndael(p_rijndael), _computed{true} { std::memcpy(_op, p_op, 16); };
  virtual ~opc() {};

  void compute_opc(uint8_t p_opc[16]);
};
