/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.impl.NativeMethods;
import java.math.BigInteger;
import java.util.Vector;
import javacard.framework.Util;
import javacardx.framework.math.BCDUtil;
import javacardx.framework.math.BigNumber;

public class MathUtil {
    public static short convertToHex(byte[] bcdArray, short bOff, short bLen, byte[] hexArray, short outOff) {
        if (!MathUtil.isBCDFormat(bcdArray, (short)bOff, bLen)) {
            throw new ArithmeticException();
        }
        BigInteger result = new BigInteger(String.valueOf(0));
        for (int i = bOff; i < bOff + bLen; ++i) {
            result = result.multiply(new BigInteger(String.valueOf(100)));
            result = result.add(new BigInteger(String.valueOf(10 * (bcdArray[i] >> 4 & 0xF) + (bcdArray[i] & 0xF))));
        }
        byte[] finalResult = result.toByteArray();
        int numLength = MathUtil.getNumBytesRequired(finalResult, (short)finalResult.length);
        if (numLength > BCDUtil.getMaxBytesSupported()) {
            throw new ArithmeticException();
        }
        MathUtil.rightJustifiedArrayCopy(finalResult, hexArray, (short)(finalResult.length - numLength), outOff, (short)numLength, (short)numLength);
        return (short)numLength;
    }

    public static short convertToBCD(byte[] hexArraySrc, short bOff, short bLen, byte[] bcdArray, short outOff) {
        if (bLen == 0 || bLen > BCDUtil.getMaxBytesSupported()) {
            throw new ArithmeticException();
        }
        Vector<Byte> remainders = new Vector<Byte>();
        byte[] hexArray = new byte[bLen];
        Util.arrayCopy(hexArraySrc, bOff, hexArray, (short)0, bLen);
        BigInteger hexNumber = new BigInteger(1, hexArray);
        if (hexNumber.equals(BigInteger.ZERO)) {
            bcdArray[outOff] = 0;
            return 1;
        }
        BigInteger divisor = new BigInteger(String.valueOf(100));
        while (hexNumber.compareTo(BigInteger.ZERO) != 0) {
            BigInteger[] qr = hexNumber.divideAndRemainder(divisor);
            byte dd = qr[1].byteValue();
            byte bcd = (byte)(dd / 10 << 4 | dd % 10);
            remainders.insertElementAt(new Byte(bcd), 0);
            hexNumber = qr[0];
        }
        for (int i = 0; i < remainders.size(); ++i) {
            bcdArray[outOff + i] = (Byte)remainders.elementAt(i);
        }
        return (short)remainders.size();
    }

    public static boolean isBCDFormat(byte[] bcdArray, short bOff, short bLen) {
        if (bLen == 0) {
            throw new ArithmeticException();
        }
        for (short i = 0; i < bLen; i = (short)(i + 1)) {
            byte firstNibble = (byte)(bcdArray[bOff + i] >> 4 & 0xF);
            byte secondNibble = (byte)(bcdArray[bOff + i] & 0xF);
            if (firstNibble <= 9 && secondNibble <= 9) continue;
            return false;
        }
        return true;
    }

    private static void rightJustifiedArrayCopy(byte[] src, byte[] dest, short srcOff, short destOff, short srcLen, short destLength) {
        int i;
        int numZeros = destLength - srcLen;
        for (i = 0; i < numZeros; ++i) {
            dest[destOff + i] = 0;
        }
        i = 0;
        int j = numZeros;
        while (i < srcLen) {
            dest[destOff + j] = src[i + srcOff];
            ++i;
            ++j;
        }
    }

    public static void setMaxBigNumberValue(byte[] input, short bOff, short bLen, byte arrayFormat, byte[] dest, byte[] currentNumber) {
        BigInteger currentValue;
        if (bLen == 0) {
            throw new ArithmeticException();
        }
        if (arrayFormat != 1 && arrayFormat != 2) {
            throw new ArithmeticException();
        }
        BigInteger newMax = MathUtil.getBIOperand(input, bOff, bLen, arrayFormat);
        if (newMax.compareTo(currentValue = new BigInteger(1, currentNumber)) < 1) {
            throw new ArithmeticException();
        }
        byte[] result = newMax.toByteArray();
        int numLength = MathUtil.getNumBytesRequired(result, (short)result.length);
        if (numLength > dest.length) {
            throw new ArithmeticException();
        }
        MathUtil.rightJustifiedArrayCopy(result, dest, (short)(result.length - numLength), (short)0, (short)numLength, (short)dest.length);
    }

    public static void initBigNumber(byte[] bArray, short bOff, short bLen, byte arrayFormat, byte[] dest, byte[] maxValue) {
        if (bLen == 0) {
            throw new ArithmeticException();
        }
        NativeMethods.checkArrayArgs(bArray, bOff, bLen);
        BigInteger input = MathUtil.getBIOperand(bArray, bOff, bLen, arrayFormat);
        BigInteger max = MathUtil.getBIOperand(maxValue, (short)0, (short)maxValue.length, (byte)2);
        if (input.compareTo(max) > 0) {
            throw new ArithmeticException();
        }
        byte[] initializer = input.toByteArray();
        int numLength = MathUtil.getNumBytesRequired(initializer, (short)initializer.length);
        MathUtil.rightJustifiedArrayCopy(initializer, dest, (byte)(initializer.length - numLength), (short)0, (byte)numLength, (byte)dest.length);
    }

    static int getNumBytesRequired(byte[] array, short length) {
        for (short index = 0; index < length; index = (short)(index + 1)) {
            if (array[index] == 0) continue;
            return length - index;
        }
        return 1;
    }

    private static BigInteger getBIOperand(byte[] bArray, short bOff, short bLen, byte arrayFormat) {
        if (bLen == 0) {
            throw new ArithmeticException();
        }
        if (arrayFormat != 1 && arrayFormat != 2) {
            throw new ArithmeticException();
        }
        byte[] opArray = null;
        if (arrayFormat == 1) {
            byte[] tempArray = new byte[BigNumber.getMaxBytesSupported()];
            opArray = new byte[BigNumber.getMaxBytesSupported()];
            short numLength = MathUtil.convertToHex(bArray, bOff, bLen, tempArray, (short)0);
            MathUtil.rightJustifiedArrayCopy(tempArray, opArray, (short)0, (short)0, numLength, (short)opArray.length);
        } else {
            opArray = new byte[bLen];
            MathUtil.rightJustifiedArrayCopy(bArray, opArray, bOff, (short)0, bLen, (short)opArray.length);
        }
        return new BigInteger(1, opArray);
    }

    public static void addBigNumbers(byte[] bArray, short bOff, short bLen, byte arrayFormat, byte[] addTo, byte[] maxSize) {
        BigInteger op1 = MathUtil.getBIOperand(addTo, (short)0, (short)addTo.length, (byte)2);
        BigInteger op2 = MathUtil.getBIOperand(bArray, bOff, bLen, arrayFormat);
        BigInteger max = MathUtil.getBIOperand(maxSize, (short)0, (short)maxSize.length, (byte)2);
        byte[] result = (op1 = op1.add(op2)).toByteArray();
        int numLength = MathUtil.getNumBytesRequired(result, (short)result.length);
        if (numLength > addTo.length || max.compareTo(op1) < 0) {
            throw new ArithmeticException();
        }
        MathUtil.rightJustifiedArrayCopy(result, addTo, (short)(result.length - numLength), (short)0, (short)numLength, (short)addTo.length);
    }

    public static void multiplyBigNumbers(byte[] bArray, short bOff, short bLen, byte arrayFormat, byte[] op1Array, byte[] maxSize) {
        BigInteger op1 = MathUtil.getBIOperand(op1Array, (short)0, (short)op1Array.length, (byte)2);
        BigInteger op2 = MathUtil.getBIOperand(bArray, bOff, bLen, arrayFormat);
        BigInteger max = MathUtil.getBIOperand(maxSize, (short)0, (short)maxSize.length, (byte)2);
        byte[] result = (op1 = op1.multiply(op2)).toByteArray();
        int numLength = MathUtil.getNumBytesRequired(result, (short)result.length);
        if (numLength > op1Array.length || max.compareTo(op1) < 0) {
            throw new ArithmeticException();
        }
        MathUtil.rightJustifiedArrayCopy(result, op1Array, (short)(result.length - numLength), (short)0, (short)numLength, (short)op1Array.length);
    }

    public static void subtractBigNumbers(byte[] bArray, short bOff, short bLen, byte arrayFormat, byte[] subFrom, byte[] maxSize) {
        BigInteger op1 = MathUtil.getBIOperand(subFrom, (short)0, (short)subFrom.length, (byte)2);
        BigInteger op2 = MathUtil.getBIOperand(bArray, bOff, bLen, arrayFormat);
        if ((op1 = op1.subtract(op2)).compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException();
        }
        byte[] result = op1.toByteArray();
        int numLength = MathUtil.getNumBytesRequired(result, (short)result.length);
        MathUtil.rightJustifiedArrayCopy(result, subFrom, (short)(result.length - numLength), (short)0, (short)numLength, (short)subFrom.length);
    }

    public static byte compareBigNumbers(byte[] bArray, short bOff, short bLen, byte format, byte[] thisNum) {
        NativeMethods.checkArrayArgs(bArray, bOff, bLen);
        BigInteger thisNumber = MathUtil.getBIOperand(thisNum, (short)0, (short)thisNum.length, (byte)2);
        BigInteger num2 = MathUtil.getBIOperand(bArray, bOff, bLen, format);
        return (byte)thisNumber.compareTo(num2);
    }

    public static void toBytes(byte[] outBuf, short bOff, short numBytes, byte arrayFormat, byte[] buff) {
        if (numBytes == 0) {
            throw new ArithmeticException();
        }
        if (arrayFormat != 1 && arrayFormat != 2) {
            throw new ArithmeticException();
        }
        int numSize = 0;
        int numOffset = 0;
        byte[] result = null;
        if (arrayFormat == 1) {
            result = new byte[BigNumber.getMaxBytesSupported()];
            numSize = MathUtil.convertToBCD(buff, (short)0, (short)buff.length, result, (short)0);
        } else {
            result = buff;
            numSize = MathUtil.getNumBytesRequired(result, (short)result.length);
            numOffset = result.length - numSize;
        }
        if (numBytes < numSize) {
            throw new ArithmeticException();
        }
        MathUtil.rightJustifiedArrayCopy(result, outBuf, (short)numOffset, bOff, (short)numSize, numBytes);
    }

    public static byte getByteLength(byte[] bn, byte arrayFormat) {
        boolean numSize = false;
        if (arrayFormat != 1 && arrayFormat != 2) {
            throw new ArithmeticException();
        }
        if (arrayFormat == 1) {
            byte[] result = new byte[BigNumber.getMaxBytesSupported() * 2];
            return (byte)MathUtil.convertToBCD(bn, (short)0, (short)bn.length, result, (short)0);
        }
        for (int i = 0; i < bn.length; ++i) {
            if (bn[i] == 0) continue;
            return (byte)(bn.length - i);
        }
        return 1;
    }
}

