/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Cad {
    protected InputStream in;
    protected OutputStream out;
    private boolean debug = false;

    public Cad(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        int dbgLevel = Integer.getInteger("apduIODebug", 0);
        if ((dbgLevel & 1) == 1) {
            this.debug = true;
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    public synchronized void receiveTLP224Message(TLP224Message msg) throws IOException, TLP224Exception {
        int tries = 0;
        while (true) {
            int hiNibble;
            if (tries++ > 5) {
                throw new TLP224Exception(1);
            }
            boolean messageTooLong = false;
            boolean xmitError = false;
            byte[] msgData = msg.getData();
            int got = 0;
            while ((hiNibble = this.in.read()) != 3) {
                int lowNibble;
                if (hiNibble == -1) {
                    throw new EOFException();
                }
                if ((hiNibble -= 48) > 9) {
                    hiNibble -= 7;
                }
                if (hiNibble < 0 || hiNibble > 15) {
                    xmitError = true;
                }
                if ((lowNibble = this.in.read()) == 3) {
                    xmitError = true;
                    break;
                }
                if (lowNibble == -1) {
                    throw new EOFException();
                }
                if ((lowNibble -= 48) > 9) {
                    lowNibble -= 7;
                }
                if (lowNibble < 0 || lowNibble > 15) {
                    xmitError = true;
                }
                if (messageTooLong || xmitError) continue;
                try {
                    msgData[got++] = (byte)(hiNibble << 4 | lowNibble);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    messageTooLong = true;
                }
            }
            if (xmitError) {
                if (this.debug) {
                    System.out.println("<-- message received with transmission error");
                    System.out.flush();
                }
                this.transmissionError();
                continue;
            }
            if (messageTooLong) {
                if (this.debug) {
                    System.out.println("<-- received message too long");
                    System.out.flush();
                }
                this.statusResponse(18);
                continue;
            }
            msg.setLength(got);
            if (this.debug) {
                System.out.println("<-- " + msg);
                System.out.flush();
            }
            if (msgData[got - 1] != (byte)msg.computeLRC(got - 1)) {
                this.transmissionError();
                continue;
            }
            if (msgData[1] != (byte)(got - 3)) {
                this.transmissionError();
                continue;
            }
            if (msgData[0] == 96 || msgData[0] == -32) break;
            this.statusResponse(9);
        }
    }

    public void sendTLP224Message(TLP224Message msg) throws IOException {
        if (this.debug) {
            System.out.println("--> " + msg);
            System.out.flush();
        }
        byte[] msgData = msg.getData();
        int i = 0;
        while (i < msg.getLength()) {
            int nibble = msgData[i] >> 4 & 0xF;
            nibble = nibble < 10 ? (nibble += 48) : (nibble += 55);
            this.out.write(nibble);
            nibble = msgData[i] & 0xF;
            nibble = nibble < 10 ? (nibble += 48) : (nibble += 55);
            this.out.write(nibble);
            ++i;
        }
        this.out.write(3);
        this.out.flush();
    }

    void statusResponse(int code) throws IOException {
        TLP224Message msg = new TLP224Message(new byte[4]);
        byte[] msgData = msg.getData();
        msgData[0] = 96;
        msgData[1] = 1;
        msgData[2] = (byte)code;
        msgData[3] = (byte)msg.computeLRC(3);
        msg.setLength(4);
        this.sendTLP224Message(msg);
    }

    private void transmissionError() throws IOException {
        TLP224Message msg = new TLP224Message(new byte[3]);
        byte[] msgData = msg.getData();
        msgData[0] = -32;
        msgData[1] = 0;
        msgData[2] = (byte)msg.computeLRC(2);
        msg.setLength(3);
        this.sendTLP224Message(msg);
    }
}

