/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.ShareableInterfaceClassLoader;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class ExtensionLibraryClassLoader
extends ClassLoader {
    private static final int ID = 3;
    private static final int LEVEL = 2;
    private static final int BUNDLE_ID = 3;
    private static final ExtensionLibraryClassLoader extensionLibraryClassLoader = ExtensionLibraryClassLoader.getNewExtensionLibraryClassLoader();

    private static ExtensionLibraryClassLoader getNewExtensionLibraryClassLoader() {
        ExtensionLibraryClassLoader elcl = new ExtensionLibraryClassLoader();
        NativeMethods.setJCREentry(elcl, false);
        return elcl;
    }

    public static ExtensionLibraryClassLoader getExtensionLibraryClassLoader() {
        return extensionLibraryClassLoader;
    }

    private ExtensionLibraryClassLoader() {
        this.id = 3;
        this.parent = ShareableInterfaceClassLoader.getShareableInterfaceClassLoader();
        this.classPath = "";
        this.preloaded = false;
        this.initClassLoader0(this.id, this.parent.id, this.classPath, 2, 3);
        this.setAppType(1);
    }

    public void loadEL(Vector<String> elClasses, String elClasspath) throws ClassNotFoundException {
        StringBuffer existingCP = new StringBuffer(this.getClassPath());
        this.setClassPath(elClasspath);
        for (String className : elClasses) {
            Logger.debug("ExtensionLibraryClassLoader: Loading " + className);
            try {
                this.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                this.setClassPath(existingCP.toString());
                throw ex;
            }
        }
        existingCP.append(';').append(this.getBundleID()).append(',').append(elClasspath);
        this.setClassPath(existingCP.toString());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        int bundleId = 0;
        Logger.debug("    getResourceAsStream()", name);
        Logger.debug("    ", name);
        if (this.parent != null) {
            is = this.parent.getResourceAsStream(name);
        }
        if (is == null && this.classPath != null) {
            StringTokenizer st = new StringTokenizer(this.classPath, " ;");
            String cpElement = null;
            String cp = null;
            FileConnection fc = null;
            while (st.hasMoreTokens()) {
                cp = st.nextToken();
                int commaIndex = cp.indexOf(44);
                cpElement = cp.substring(commaIndex + 1);
                Logger.debug("   cpElement and name in getResourceAsStream of extensionLibraryClassLoader ", cpElement, name);
                fc = new FileConnection(cpElement, name);
                try {
                    if (!fc.exists()) continue;
                    Logger.debug("This resource " + name + " exists");
                    is = fc.openInputStream();
                    bundleId = Integer.valueOf(cp.substring(0, commaIndex));
                    if (NativeMethods.getCurrentContext() == 0 && NativeMethods.getPreviousContext() != 0) {
                        NativeMethods.transferOwnershipToPreviousContext(is);
                    }
                    NativeMethods.storeStream(is, bundleId);
                    break;
                }
                catch (IOException e) {
                }
            }
        }
        return is;
    }
}

