/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ClassicLibraryClassLoader;
import com.sun.javacard.ExtensionLibraryClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.CMStatus;
import com.sun.javacard.cm.impl.DeploymentUnitLoaderImpl;
import com.sun.javacard.cm.impl.IDManager;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.spi.cardmgmt.Library;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.StringTokenizer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.spi.cardmgmt.CardManagementPermission;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class LibraryImpl
implements Library {
    private byte type;
    private ClassLoader classLoader;
    private FileConnection libDir;
    private int bundleId;

    public LibraryImpl(byte type, ClassLoader classLoader, FileConnection fc, int bundleId) {
        this.type = type;
        this.classLoader = classLoader;
        this.libDir = fc;
        this.bundleId = bundleId;
        NativeMethods.setJCREentry(this, false);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public boolean unload(boolean forced) throws SecurityException, AccessControlException {
        AccessController.checkPermission(new CardManagementPermission("deploymentUnit.unload"));
        NativeMethods.setUnloadFlag(this.bundleId);
        int[] dependencies = NativeMethods.getDependenciesOnBundle(this.bundleId);
        if (dependencies != null) {
            CMStatus.getInstance().setLastError(4046);
            CMStatus.getInstance().setLastErrorMsg("");
            NativeMethods.setUnloadFlag(0);
            return false;
        }
        if (NativeMethods.getStreamCount(this.bundleId) > 0) {
            CMStatus.getInstance().setLastError(4046);
            CMStatus.getInstance().setLastErrorMsg("Resources");
            NativeMethods.setUnloadFlag(0);
            return false;
        }
        NativeMethods.removeBundleDependencies(this.bundleId);
        try {
            this.libDir.delete();
        }
        catch (IOException e) {
            Logger.debug("FileConnection.delete threw IOException");
            e.printStackTrace();
        }
        if (this.type == 1) {
            ExtensionLibraryClassLoader el = ExtensionLibraryClassLoader.getExtensionLibraryClassLoader();
            String elClassPath = el.getClassPath();
            StringTokenizer st = new StringTokenizer(elClassPath, " ;");
            String cp = null;
            StringBuffer modifiedCP = new StringBuffer();
            while (st.hasMoreTokens()) {
                int commaIndex;
                cp = st.nextToken();
                int bId = Integer.valueOf(cp.substring(0, commaIndex = cp.indexOf(44)));
                if (this.bundleId == bId) continue;
                modifiedCP.append(';').append(cp);
            }
            if (modifiedCP.length() > 0) {
                el.setClassPath(modifiedCP.toString());
            } else {
                el.setClassPath(null);
            }
            el.freeClasses(this.bundleId);
        } else {
            ClassicLibraryClassLoader.getClassicLibraryClassLoader().freeClasses(this.bundleId);
        }
        IDManager.removeBundleId(this.bundleId);
        DeploymentUnitLoaderImpl.removeDeploymentUnit(this);
        NativeMethods.setUnloadFlag(0);
        return true;
    }
}

