/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcrd;

import com.sun.javacard.cm.impl.jcrd.Util;
import com.sun.javacard.util.URIUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ClientRole {
    private String roleName;
    private Vector<String> mappedClientURIs;
    private Vector<String> mappedProtectionDomains;
    private Vector<String> mappedAuthCredentials;
    private String credentialAuthType = null;
    private String credentialAuthDuration = null;
    boolean urisSet = false;
    boolean pdsSet = false;
    boolean acsSet = false;
    boolean catSet = false;
    boolean cadSet = false;

    public ClientRole(String name) {
        this.roleName = name;
    }

    public String getClientRoleName() {
        return this.roleName;
    }

    public boolean setClientURIs(String URIList) {
        if (this.urisSet) {
            return false;
        }
        this.mappedClientURIs = new Vector();
        StringTokenizer tokenizer = new StringTokenizer(URIList, ",");
        while (tokenizer.hasMoreTokens()) {
            this.mappedClientURIs.addElement(URIUtils.normalize(tokenizer.nextToken().trim()));
        }
        this.urisSet = true;
        return true;
    }

    public boolean setProtectionDomains(String PDList) {
        if (this.pdsSet) {
            return false;
        }
        Vector<String> temp = Util.getStringVector(PDList);
        if (temp != null) {
            this.mappedProtectionDomains = new Vector(temp.size());
            for (int i = 0; i < temp.size(); ++i) {
                String name = temp.elementAt(i);
                this.mappedProtectionDomains.addElement(name.substring("pd:".length()));
            }
        }
        this.pdsSet = true;
        return true;
    }

    public boolean setAuthCredentials(String AuthCredList) {
        if (this.acsSet) {
            return false;
        }
        this.mappedAuthCredentials = Util.getStringVector(AuthCredList);
        this.acsSet = true;
        return true;
    }

    public boolean setCredentialAuthType(String authType) {
        if (this.catSet) {
            return false;
        }
        this.credentialAuthType = authType;
        this.catSet = true;
        return true;
    }

    public boolean setCredentialAuthDuration(String authDuration) {
        if (this.cadSet) {
            return false;
        }
        this.credentialAuthDuration = authDuration;
        this.cadSet = true;
        return true;
    }

    public Vector<String> getClientURIs() {
        return this.mappedClientURIs;
    }

    public Vector<String> getProtectionDomains() {
        return this.mappedProtectionDomains;
    }

    public Vector<String> getAuthCredentials() {
        return this.mappedAuthCredentials;
    }

    public String getCredentialAuthType() {
        return this.credentialAuthType;
    }

    public String getCredentialAuthDuration() {
        return this.credentialAuthDuration;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.mappedClientURIs != null) {
            sb.append("\t\t\tClient URIs\n");
            for (String curi : this.mappedClientURIs) {
                sb.append("\t\t\t    " + curi + "\n");
            }
        }
        if (this.mappedProtectionDomains != null) {
            sb.append("\t\t\tClient Protection Domains\n");
            for (String cpd : this.mappedProtectionDomains) {
                sb.append("\t\t\t    " + cpd + "\n");
            }
        }
        if (this.mappedAuthCredentials != null) {
            sb.append("\t\t\tClient Authentication Credentials\n");
            for (String cpd : this.mappedAuthCredentials) {
                sb.append("\t\t\t    " + cpd + "\n");
            }
        }
        sb.append("\t\t\tClient Credential Authentication Type\n");
        sb.append("\t\t\t    " + this.credentialAuthType + "\n");
        sb.append("\t\t\tClient Credential Authentication Duration\n");
        sb.append("\t\t\t    " + this.credentialAuthDuration + "\n");
        return sb.toString();
    }
}

